/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.event.FieldEvents;
import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.NullValueController;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import java.util.EventObject;

public class FCheckBox
extends Checkbox
implements FAbstractComponent,
Field<Boolean>,
FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier,
HasSizeable {
    private NullValueController<Boolean> nullValueController;

    public FCheckBox() {
    }

    public FCheckBox(String caption) {
        super(caption);
        this.setCaption(caption);
    }

    public FCheckBox(String caption, boolean initialState) {
        super(caption, initialState);
        this.setCaption(caption);
    }

    public FCheckBox(String caption, Property<?> dataSource) {
        super(caption);
        this.setPropertyDataSource(dataSource);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null || this.getValue().equals(Boolean.FALSE);
    }

    @Override
    public void setValue(Boolean value) {
        super.setValue((Object)this.getNullValueController().processSetValue(value));
    }

    @Override
    public Boolean getValue() {
        return this.getNullValueController().processGetValue((Boolean)super.getValue());
    }

    private NullValueController<Boolean> getNullValueController() {
        if (this.nullValueController == null) {
            this.nullValueController = new NullValueController<Boolean>((HasValue<?, Boolean>)this, Boolean.FALSE);
        }
        return this.nullValueController;
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }
}

