/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.featurepack.server.FAbstractClientConnector;
import com.vaadin.featurepack.server.SizeWithUnit;
import com.vaadin.featurepack.ui.AbstractComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Unit;
import java.io.Serializable;

public interface FSizeable
extends Serializable {
    default public float getFWidth() {
        if (this instanceof AbstractComponent) {
            return ((AbstractComponent)this).getWidth();
        }
        SizeWithUnit cachedWidth = (SizeWithUnit)ComponentUtil.getData((Component)((Component)this), (String)"component-cachedWidth");
        return cachedWidth == null ? -1.0f : cachedWidth.getSize();
    }

    default public float getFHeight() {
        if (this instanceof AbstractComponent) {
            return ((AbstractComponent)this).getHeight();
        }
        SizeWithUnit cachedHeight = (SizeWithUnit)ComponentUtil.getData((Component)((Component)this), (String)"component-cachedHeight");
        return cachedHeight == null ? -1.0f : cachedHeight.getSize();
    }

    default public Unit getWidthUnits() {
        SizeWithUnit cachedWidth = (SizeWithUnit)ComponentUtil.getData((Component)((Component)this), (String)"component-cachedWidth");
        return cachedWidth == null ? Unit.PIXELS : cachedWidth.getUnit();
    }

    default public Unit getHeightUnits() {
        SizeWithUnit cachedHeight = (SizeWithUnit)ComponentUtil.getData((Component)((Component)this), (String)"component-cachedHeight");
        return cachedHeight == null ? Unit.PIXELS : cachedHeight.getUnit();
    }

    default public void setHeight(String height) {
        SizeWithUnit parsedHeight = SizeWithUnit.parseStringSize(height);
        if (parsedHeight != null) {
            this.setHeight(parsedHeight.getSize(), parsedHeight.getUnit());
        } else {
            this.setHeight(-1.0f, Unit.PIXELS);
        }
    }

    default public void setWidth(float width, Unit unit) {
        if (this instanceof AbstractComponent) {
            ((AbstractComponent)this).setWidth(width, unit);
        } else {
            if (unit == null) {
                throw new IllegalArgumentException("Unit can not be null");
            }
            ComponentUtil.setData((Component)((Component)this), (String)"component-cachedWidth", (Object)new SizeWithUnit(width, unit));
            ((HasSize)this).getElement().getStyle().setWidth(HasSize.getCssSize((float)width, (Unit)unit));
            ((HasSize)this).getElement().removeAttribute("data-width-full");
            if (this instanceof FAbstractClientConnector) {
                ((FAbstractClientConnector)((Object)this)).markAsDirty();
            }
        }
    }

    default public void setHeight(float height, Unit unit) {
        if (this instanceof AbstractComponent) {
            ((AbstractComponent)this).setHeight(height, unit);
        } else {
            if (unit == null) {
                throw new IllegalArgumentException("Unit can not be null");
            }
            ComponentUtil.setData((Component)((Component)this), (String)"component-cachedHeight", (Object)new SizeWithUnit(height, unit));
            ((HasSize)this).getElement().getStyle().setHeight(HasSize.getCssSize((float)height, (Unit)unit));
            ((HasSize)this).getElement().removeAttribute("data-height-full");
            if (this instanceof FAbstractClientConnector) {
                ((FAbstractClientConnector)((Object)this)).markAsDirty();
            }
        }
    }

    default public void setWidth(String width) {
        SizeWithUnit parsedWidth = SizeWithUnit.parseStringSize(width);
        if (parsedWidth != null) {
            this.setWidth(parsedWidth.getSize(), parsedWidth.getUnit());
        } else {
            this.setWidth(-1.0f, Unit.PIXELS);
        }
    }

    default public void setSizeFull() {
        this.setWidth(100.0f, Unit.PERCENTAGE);
        this.setHeight(100.0f, Unit.PERCENTAGE);
    }

    default public void setWidthFull() {
        this.setWidth(100.0f, Unit.PERCENTAGE);
    }

    default public void setHeightFull() {
        this.setHeight(100.0f, Unit.PERCENTAGE);
    }

    default public void setSizeUndefined() {
        this.setWidthUndefined();
        this.setHeightUndefined();
    }

    default public void setWidthUndefined() {
        this.setWidth(-1.0f, Unit.PIXELS);
    }

    default public void setHeightUndefined() {
        this.setHeight(-1.0f, Unit.PIXELS);
    }
}

