/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.featurepack.server.SizeWithUnit;
import com.vaadin.featurepack.ui.AbstractComponent;
import com.vaadin.featurepack.ui.AbstractOrderedLayout;
import com.vaadin.featurepack.ui.GridLayout;
import com.vaadin.featurepack.ui.VerticalLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Unit;
import java.io.Serializable;
import java.util.Iterator;

public class ComponentSizeValidator
implements Serializable {
    private static boolean hasNonRelativeHeightComponent(AbstractOrderedLayout ol) {
        Iterator it = ol.getChildren().iterator();
        while (it.hasNext()) {
            if (ComponentSizeValidator.hasRelativeHeight((Component)it.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean parentCanDefineHeight(Component component) {
        if (!component.getParent().isPresent()) {
            return true;
        }
        Component parent = (Component)component.getParent().get();
        if (ComponentSizeValidator.isUndefinedHeight(parent)) {
            if (parent instanceof AbstractOrderedLayout) {
                if (parent instanceof VerticalLayout) {
                    return false;
                }
                return ComponentSizeValidator.hasNonRelativeHeightComponent((AbstractOrderedLayout)parent);
            }
            if (parent instanceof GridLayout) {
                GridLayout gl = (GridLayout)parent;
                GridLayout.Area componentArea = gl.getComponentArea(component);
                for (int row = componentArea.getRow1(); row <= componentArea.getRow2(); ++row) {
                    for (int column = 0; column < gl.getColumns(); ++column) {
                        Component c = gl.getComponent(column, row);
                        if (c == null || ComponentSizeValidator.hasRelativeHeight(c)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        if (ComponentSizeValidator.hasRelativeHeight(parent)) {
            if (parent.getParent().isPresent()) {
                return ComponentSizeValidator.parentCanDefineHeight(parent);
            }
            return true;
        }
        return true;
    }

    private static boolean hasRelativeHeight(Component component) {
        if (component instanceof AbstractComponent) {
            return ((AbstractComponent)component).getHeight() > 0.0f && ((AbstractComponent)component).getHeightUnits() == Unit.PERCENTAGE;
        }
        try {
            SizeWithUnit sizeWithUnit = SizeWithUnit.parseStringSize(component.getElement().getStyle().get("height"));
            return sizeWithUnit != null && sizeWithUnit.getUnit() == Unit.PERCENTAGE && sizeWithUnit.getSize() > 0.0f;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private static boolean hasNonRelativeWidthComponent(AbstractOrderedLayout ol) {
        Iterator<Component> it = ol.iterator();
        while (it.hasNext()) {
            if (ComponentSizeValidator.hasRelativeWidth(it.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRelativeWidth(Component component) {
        if (component instanceof AbstractComponent) {
            return ((AbstractComponent)component).getWidth() > 0.0f && ((AbstractComponent)component).getWidthUnits() == Unit.PERCENTAGE;
        }
        try {
            SizeWithUnit sizeWithUnit = SizeWithUnit.parseStringSize(component.getElement().getStyle().get("width"));
            return sizeWithUnit != null && sizeWithUnit.getUnit() == Unit.PERCENTAGE && sizeWithUnit.getSize() > 0.0f;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static boolean parentCanDefineWidth(Component component) {
        if (!component.getParent().isPresent()) {
            return true;
        }
        Component parent = (Component)component.getParent().get();
        if (ComponentSizeValidator.isUndefinedWidth(parent)) {
            if (parent instanceof AbstractOrderedLayout) {
                AbstractOrderedLayout abstractOrderedLayout = (AbstractOrderedLayout)parent;
                return abstractOrderedLayout instanceof VerticalLayout && ComponentSizeValidator.hasNonRelativeWidthComponent(abstractOrderedLayout);
            }
            if (parent instanceof GridLayout) {
                GridLayout gl = (GridLayout)parent;
                GridLayout.Area componentArea = gl.getComponentArea(component);
                for (int col = componentArea.getColumn1(); col <= componentArea.getColumn2(); ++col) {
                    for (int row = 0; row < gl.getRows(); ++row) {
                        Component c = gl.getComponent(col, row);
                        if (c == null || ComponentSizeValidator.hasRelativeWidth(c)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        if (ComponentSizeValidator.hasRelativeWidth(parent)) {
            if (!parent.getParent().isPresent()) {
                return true;
            }
            return ComponentSizeValidator.parentCanDefineWidth(parent);
        }
        return true;
    }

    private static boolean isUndefinedHeight(Component component) {
        if (component instanceof AbstractComponent) {
            return ((AbstractComponent)component).getHeight() < 0.0f;
        }
        try {
            SizeWithUnit sizeWithUnit = SizeWithUnit.parseStringSize(component.getElement().getStyle().get("height"));
            return sizeWithUnit == null;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private static boolean isUndefinedWidth(Component component) {
        if (component instanceof AbstractComponent) {
            return ((AbstractComponent)component).getWidth() < 0.0f;
        }
        try {
            SizeWithUnit sizeWithUnit = SizeWithUnit.parseStringSize(component.getElement().getStyle().get("width"));
            return sizeWithUnit == null;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    private ComponentSizeValidator() {
    }
}

