/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.AbstractContainer;
import com.vaadin.featurepack.desktop.Window;
import com.vaadin.featurepack.desktop.layouts.CustomLayoutResizeListener;
import com.vaadin.featurepack.desktop.layouts.LayoutManager;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.page.BrowserWindowResizeListener;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.UUID;

public class CustomLayout
implements Serializable {
    private LayoutManager layoutManager;
    private Window window;
    private Component container;

    public CustomLayout(LayoutManager layoutManager, Window window) {
        this.layoutManager = layoutManager;
        this.window = window;
    }

    public CustomLayout(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public void setConstraints(Component component, Object constraints) {
        this.layoutManager.addLayoutComponent(component, constraints);
    }

    public Object getConstraints(Component component) {
        return null;
    }

    public void pack() {
        this.layoutManager.layoutContainer((Component)((AbstractContainer)this.container));
    }

    private Window retrieveParentWindow(Component container) {
        if (container == null) {
            return null;
        }
        if (container instanceof Window || container != null && "com.vaadin.featurepack.Window".equals(container.getClass().getName())) {
            return (Window)container;
        }
        return this.retrieveParentWindow(container.getParent().orElse(null));
    }

    private int findSizeHeader() {
        try {
            Class dialogHeaderFooter = Dialog.DialogHeader.class.getSuperclass();
            Field rootField = dialogHeaderFooter.getDeclaredField("root");
            rootField.setAccessible(true);
            Element element = (Element)rootField.get(this.window.getHeader());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private void navigate() {
        UI.getCurrent().getChildren().forEach(o -> this.navigate((Component)o));
    }

    private void navigate(Component c) {
        c.getChildren().forEach(o -> this.navigate((Component)o));
    }

    public void setContainer(final Component container) {
        this.container = container;
        UI.getCurrent().access(new Command(){

            public void execute() {
                Window parentWindow;
                Window window = parentWindow = CustomLayout.this.window == null ? CustomLayout.this.retrieveParentWindow(container) : CustomLayout.this.window;
                if (parentWindow == null) {
                    final Page page = UI.getCurrent().getPage();
                    UI.getCurrent().access(new Command(){

                        public void execute() {
                            String BROWSER_RESIZE_LISTENER = "BROWSER_RESIZE_LISTENER-" + String.valueOf(UI.getCurrent().getCurrentView());
                            CustomLayoutResizeListener clrl = (CustomLayoutResizeListener)UI.getCurrent().getSession().getAttribute(BROWSER_RESIZE_LISTENER);
                            if (clrl == null) {
                                clrl = new CustomLayoutResizeListener();
                                page.addBrowserWindowResizeListener((BrowserWindowResizeListener)clrl);
                                UI.getCurrent().getSession().setAttribute(BROWSER_RESIZE_LISTENER, (Object)clrl);
                            } else {
                                System.out.println("BrowserResize Listener already added! " + String.valueOf(clrl));
                            }
                            if (container instanceof AbstractContainer) {
                                clrl.register((AbstractContainer)container, CustomLayout.this.layoutManager);
                                System.out.println("Registered " + String.valueOf(container) + " [" + String.valueOf(container.getId()) + "]");
                            } else {
                                System.out.println("Expected an AbstractContainer but found " + String.valueOf(container));
                            }
                        }
                    });
                } else {
                    UI.getCurrent().access(new Command(){

                        public void execute() {
                            if (parentWindow.getId().isEmpty()) {
                                parentWindow.setId(UUID.randomUUID().toString());
                            }
                            String BROWSER_RESIZE_LISTENER = "BROWSER_RESIZE_LISTENER-" + String.valueOf(parentWindow.getId());
                            CustomLayoutResizeListener clrl = (CustomLayoutResizeListener)UI.getCurrent().getSession().getAttribute(BROWSER_RESIZE_LISTENER);
                            if (clrl == null) {
                                clrl = new CustomLayoutResizeListener();
                                parentWindow.addResizeListener(clrl);
                                UI.getCurrent().getSession().setAttribute(BROWSER_RESIZE_LISTENER, (Object)clrl);
                                System.out.println("Registered " + BROWSER_RESIZE_LISTENER + " (" + String.valueOf(clrl) + ")");
                            } else {
                                System.out.println("BrowserResize Listener already added! " + String.valueOf(clrl));
                            }
                            if (container instanceof AbstractContainer) {
                                clrl.register((AbstractContainer)container, CustomLayout.this.layoutManager);
                                System.out.println("Registered " + String.valueOf(container) + " [" + String.valueOf(container.getId()) + "] inside " + BROWSER_RESIZE_LISTENER);
                            } else {
                                System.out.println("Expected an AbstractContainer but found " + String.valueOf(container));
                            }
                        }
                    });
                }
            }
        });
    }
}

