/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.featurepack.desktop.layouts.BaseCardLayout;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import java.util.List;
import java.util.Objects;

public class CardLayout
extends AbstractLayout {
    private int horizontalGap = 0;
    private int verticalGap = 0;
    private BaseCardLayout baseCardLayout = new BaseCardLayout();

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int hgap, int vgap) {
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    protected void onContainerAttach(AttachEvent event) {
        event.getUI().getPage().addStyleSheet("vfp-card-layout.css");
    }

    public void setContainer(Component container) {
        Component current = this.getContainer();
        if (current != null) {
            current.getElement().removeAttribute("vfp-card-layout");
            current.getStyle().remove("--vfp-horizontal-gap");
            current.getStyle().remove("--vfp-vertical-gap");
            current.getChildren().forEach(child -> child.getElement().removeAttribute("vfp-card-layout-name"));
        }
        super.setContainer(container);
        if (container != null) {
            container.getElement().setAttribute("vfp-card-layout", "");
            this.updateHgap();
            this.updateVgap();
        }
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        this.setConstraints(component, "");
        if (!this.baseCardLayout.getCards().isEmpty()) {
            component.setVisible(false);
        }
        this.baseCardLayout.getCards().add(component);
    }

    public void removeComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        component.getElement().removeAttribute("vfp-card-layout-name");
        for (int i = 0; i < this.baseCardLayout.getCards().size(); ++i) {
            if (this.baseCardLayout.getCards().get(i) != component) continue;
            if (component.isVisible()) {
                this.baseCardLayout.next();
            }
            this.baseCardLayout.getCards().remove(i);
            if (this.baseCardLayout.getCurrentCard() <= i) break;
            this.baseCardLayout.setCurrentCard(this.baseCardLayout.getCurrentCard() - 1);
            break;
        }
    }

    public void setConstraints(Component component, Object constraints) {
        Objects.requireNonNull(component, "Component must not be null");
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("Constraints must be a String or null");
        }
        String name = (String)constraints;
        if (name == null) {
            name = "";
        }
        component.getElement().setAttribute("vfp-card-layout-name", name);
    }

    public Object getConstraints(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        String name = component.getElement().getAttribute("vfp-card-layout-name");
        if (name == null) {
            name = "";
        }
        return name;
    }

    public int getHgap() {
        return this.horizontalGap;
    }

    public void setHgap(int hgap) {
        this.horizontalGap = hgap;
        this.updateHgap();
    }

    private void updateHgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-horizontal-gap", this.horizontalGap + "px");
        }
    }

    public int getVgap() {
        return this.verticalGap;
    }

    public void setVgap(int vgap) {
        this.verticalGap = vgap;
        this.updateVgap();
    }

    private void updateVgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-vertical-gap", this.verticalGap + "px");
        }
    }

    public void first() {
        this.baseCardLayout.first();
    }

    public void last() {
        this.baseCardLayout.last();
    }

    public void previous() {
        this.baseCardLayout.previous();
    }

    public void next() {
        this.baseCardLayout.next();
    }

    public void show(String name) {
        this.baseCardLayout.show(name);
    }

    public List<Component> getCards() {
        return this.baseCardLayout.getCards();
    }

    public int getCurrentCard() {
        return this.baseCardLayout.getCurrentCard();
    }

    public void setCurrentCard(int currentCard) {
        this.baseCardLayout.setCurrentCard(currentCard);
    }
}

