/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util.filter;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;

public class Between
implements Container.Filter {
    private final Object propertyId;
    private final Comparable startValue;
    private final Comparable endValue;

    public Between(Object propertyId, Comparable startValue, Comparable endValue) {
        this.propertyId = propertyId;
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public Object getPropertyId() {
        return this.propertyId;
    }

    public Comparable<?> getStartValue() {
        return this.startValue;
    }

    public Comparable<?> getEndValue() {
        return this.endValue;
    }

    @Override
    public boolean passesFilter(Object itemId, Item item) throws UnsupportedOperationException {
        Object value = item.getItemProperty(this.getPropertyId()).getValue();
        if (value instanceof Comparable) {
            Comparable cval = (Comparable)value;
            return cval.compareTo(this.getStartValue()) >= 0 && cval.compareTo(this.getEndValue()) <= 0;
        }
        return false;
    }

    @Override
    public boolean appliesToProperty(Object propertyId) {
        return this.getPropertyId() != null && this.getPropertyId().equals(propertyId);
    }

    public int hashCode() {
        return this.getPropertyId().hashCode() + this.getStartValue().hashCode() + this.getEndValue().hashCode();
    }

    public boolean equals(Object obj) {
        boolean startValueEqual;
        boolean propertyIdEqual;
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Between o = (Between)obj;
        boolean bl = null != this.getPropertyId() ? this.getPropertyId().equals(o.getPropertyId()) : (propertyIdEqual = null == o.getPropertyId());
        boolean bl2 = null != this.getStartValue() ? this.getStartValue().equals(o.getStartValue()) : (startValueEqual = null == o.getStartValue());
        boolean endValueEqual = null != this.getEndValue() ? this.getEndValue().equals(o.getEndValue()) : null == o.getEndValue();
        return propertyIdEqual && startValueEqual && endValueEqual;
    }
}

