/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util.converter;

import com.vaadin.featurepack.data.converter.Converter;
import com.vaadin.featurepack.data.util.converter.ConversionException;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.DefaultConverterFactory;
import java.io.Serializable;
import java.util.Locale;

public class ConverterUtil
implements Serializable {
    public static <PRESENTATIONTYPE, MODELTYPE> com.vaadin.featurepack.data.converter.Converter<PRESENTATIONTYPE, MODELTYPE> getConverter(final Class<PRESENTATIONTYPE> presentationType, final Class<MODELTYPE> modelType) {
        DefaultConverterFactory factory = DefaultConverterFactory.INSTANCE;
        final Converter converter = factory.newInstance(presentationType, modelType).orElse(null);
        if (converter == null) {
            return null;
        }
        return new com.vaadin.featurepack.data.converter.Converter<PRESENTATIONTYPE, MODELTYPE>(){

            @Override
            public MODELTYPE convertToModel(PRESENTATIONTYPE value, Class<? extends MODELTYPE> targetType, Locale locale) throws Converter.ConversionException {
                Result result = converter.convertToModel(value, new ValueContext(null, locale));
                if (result.isError()) {
                    throw new Converter.ConversionException(result.getMessage().orElse(""));
                }
                return result.getOrThrow(Converter.ConversionException::new);
            }

            @Override
            public PRESENTATIONTYPE convertToPresentation(MODELTYPE value, Class<? extends PRESENTATIONTYPE> targetType, Locale locale) throws Converter.ConversionException {
                return converter.convertToPresentation(value, new ValueContext(null, locale));
            }

            @Override
            public Class<MODELTYPE> getModelType() {
                return modelType;
            }

            @Override
            public Class<PRESENTATIONTYPE> getPresentationType() {
                return presentationType;
            }
        };
    }

    public static <PRESENTATIONTYPE, MODELTYPE> PRESENTATIONTYPE convertFromModel(Component field, MODELTYPE modelValue, Class<? extends PRESENTATIONTYPE> presentationType, Converter<PRESENTATIONTYPE, MODELTYPE> converter) throws ConversionException {
        if (converter != null) {
            Object presentation = converter.convertToPresentation(modelValue, new ValueContext(null, field));
            if (presentation != null && !presentationType.isInstance(presentation)) {
                throw new ConversionException("Converter returned an object of type " + presentation.getClass().getName() + " when expecting " + presentationType.getName());
            }
            return (PRESENTATIONTYPE)presentation;
        }
        if (modelValue == null) {
            return null;
        }
        if (presentationType.isAssignableFrom(modelValue.getClass())) {
            return (PRESENTATIONTYPE)modelValue;
        }
        throw new ConversionException("Unable to convert value of type " + modelValue.getClass().getName() + " to presentation type " + String.valueOf(presentationType) + ". No converter is set and the types are not compatible.");
    }

    public static <MODELTYPE, PRESENTATIONTYPE> MODELTYPE convertToModel(Component field, PRESENTATIONTYPE presentationValue, Class<MODELTYPE> modelType, Converter<PRESENTATIONTYPE, MODELTYPE> converter) throws ConversionException {
        if (converter != null) {
            Object model = converter.convertToModel(presentationValue, new ValueContext(null, field)).getOrThrow(IllegalStateException::new);
            if (model != null && !modelType.isInstance(model)) {
                throw new ConversionException("Converter returned an object of type " + model.getClass().getName() + " when expecting " + modelType.getName());
            }
            return (MODELTYPE)model;
        }
        if (presentationValue == null) {
            return null;
        }
        if (modelType == null) {
            return (MODELTYPE)presentationValue;
        }
        if (modelType.isAssignableFrom(presentationValue.getClass())) {
            return modelType.cast(presentationValue);
        }
        throw new ConversionException("Unable to convert value of type " + presentationValue.getClass().getName() + " to model type " + String.valueOf(modelType) + ". No converter is set and the types are not compatible.");
    }

    public static boolean canConverterHandle(Converter<?, ?> converter, Class<?> presentationType, Class<?> modelType) {
        if (converter == null) {
            return false;
        }
        if (modelType != converter.getClass().getTypeParameters()[1].getClass()) {
            return false;
        }
        return presentationType == converter.getClass().getTypeParameters()[0].getClass();
    }

    public static boolean canConverterPossiblyHandle(Converter<?, ?> converter, Class<?> presentationType, Class<?> modelType) {
        Class<Object> converterPresentationType;
        Class<Object> converterModelType;
        if (converter == null) {
            return false;
        }
        if (converter instanceof com.vaadin.featurepack.data.converter.Converter) {
            com.vaadin.featurepack.data.converter.Converter v7Converter = (com.vaadin.featurepack.data.converter.Converter)converter;
            converterModelType = v7Converter.getModelType();
        } else {
            converterModelType = converter.getClass().getTypeParameters()[1].getClass();
        }
        if (!modelType.isAssignableFrom(converterModelType) && !converterModelType.isAssignableFrom(modelType)) {
            return false;
        }
        if (converter instanceof com.vaadin.featurepack.data.converter.Converter) {
            com.vaadin.featurepack.data.converter.Converter v7Converter = (com.vaadin.featurepack.data.converter.Converter)converter;
            converterPresentationType = v7Converter.getPresentationType();
        } else {
            converterPresentationType = converter.getClass().getTypeParameters()[0].getClass();
        }
        return presentationType.isAssignableFrom(converterPresentationType) || converterPresentationType.isAssignableFrom(presentationType);
    }
}

