/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util;

import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.util.AbstractProperty;

public class TransactionalPropertyWrapper<T>
extends AbstractProperty<T>
implements Property.ValueChangeNotifier,
Property.Transactional<T> {
    private Property<T> wrappedProperty;
    private boolean inTransaction = false;
    private boolean valueChangePending;
    private T valueBeforeTransaction;
    private final Property.ValueChangeListener listener = new Property.ValueChangeListener(){

        @Override
        public void valueChange(Property.ValueChangeEvent event) {
            TransactionalPropertyWrapper.this.fireValueChange();
        }
    };

    public TransactionalPropertyWrapper(Property<T> wrappedProperty) {
        this.wrappedProperty = wrappedProperty;
        if (wrappedProperty instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)((Object)wrappedProperty)).addValueChangeListener(this.listener);
        }
    }

    public void detachFromProperty() {
        if (this.wrappedProperty instanceof Property.ValueChangeNotifier) {
            ((Property.ValueChangeNotifier)((Object)this.wrappedProperty)).removeValueChangeListener(this.listener);
        }
    }

    @Override
    public Class getType() {
        return this.wrappedProperty.getType();
    }

    @Override
    public T getValue() {
        return this.wrappedProperty.getValue();
    }

    @Override
    public void setValue(T newValue) throws Property.ReadOnlyException {
        this.wrappedProperty.setValue(newValue);
    }

    @Override
    public void startTransaction() {
        this.inTransaction = true;
        this.valueBeforeTransaction = this.getValue();
    }

    @Override
    public void commit() {
        this.endTransaction();
    }

    @Override
    public void rollback() {
        try {
            this.wrappedProperty.setValue(this.valueBeforeTransaction);
        }
        finally {
            this.valueChangePending = false;
            this.endTransaction();
        }
    }

    protected void endTransaction() {
        this.inTransaction = false;
        this.valueBeforeTransaction = null;
        if (this.valueChangePending) {
            this.fireValueChange();
        }
    }

    @Override
    protected void fireValueChange() {
        if (this.inTransaction) {
            this.valueChangePending = true;
        } else {
            super.fireValueChange();
        }
    }

    public Property<T> getWrappedProperty() {
        return this.wrappedProperty;
    }

    @Override
    public boolean isPropertyReadOnly() {
        return this.wrappedProperty.isPropertyReadOnly();
    }

    @Override
    public void setPropertyReadOnly(boolean newStatus) {
        boolean oldStatus = this.isPropertyReadOnly();
        this.wrappedProperty.setPropertyReadOnly(newStatus);
        if (oldStatus != this.isPropertyReadOnly()) {
            this.fireReadOnlyStatusChange();
        }
    }
}

