/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util;

import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.util.MethodProperty;
import com.vaadin.featurepack.data.util.VaadinPropertyDescriptor;
import com.vaadin.featurepack.util.SerializerHelper;
import com.vaadin.flow.internal.ReflectTools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodPropertyDescriptor<BT>
implements VaadinPropertyDescriptor<BT> {
    private final String name;
    private Class<?> propertyType;
    private transient Method readMethod;
    private transient Method writeMethod;

    public MethodPropertyDescriptor(String name, Class<?> propertyType, Method readMethod, Method writeMethod) {
        this.name = name;
        this.propertyType = ReflectTools.convertPrimitiveType(propertyType);
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper.writeClass(out, this.propertyType);
        if (this.writeMethod != null) {
            out.writeObject(this.writeMethod.getName());
            SerializerHelper.writeClass(out, this.writeMethod.getDeclaringClass());
            SerializerHelper.writeClassArray(out, this.writeMethod.getParameterTypes());
        } else {
            out.writeObject(null);
            out.writeObject(null);
            out.writeObject(null);
        }
        if (this.readMethod != null) {
            out.writeObject(this.readMethod.getName());
            SerializerHelper.writeClass(out, this.readMethod.getDeclaringClass());
            SerializerHelper.writeClassArray(out, this.readMethod.getParameterTypes());
        } else {
            out.writeObject(null);
            out.writeObject(null);
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Class<?> class1 = SerializerHelper.readClass(in);
            this.propertyType = ReflectTools.convertPrimitiveType(class1);
            String name = (String)in.readObject();
            Class<?> writeMethodClass = SerializerHelper.readClass(in);
            Class<?>[] paramTypes = SerializerHelper.readClassArray(in);
            this.writeMethod = name != null ? writeMethodClass.getMethod(name, paramTypes) : null;
            name = (String)in.readObject();
            Class<?> readMethodClass = SerializerHelper.readClass(in);
            paramTypes = SerializerHelper.readClassArray(in);
            this.readMethod = name != null ? readMethodClass.getMethod(name, paramTypes) : null;
        }
        catch (SecurityException e) {
            MethodPropertyDescriptor.getLogger().log(Level.SEVERE, "Internal deserialization error", e);
        }
        catch (NoSuchMethodException e) {
            MethodPropertyDescriptor.getLogger().log(Level.SEVERE, "Internal deserialization error", e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public Property<?> createProperty(Object bean) {
        return new MethodProperty(this.propertyType, bean, this.readMethod, this.writeMethod);
    }

    private static final Logger getLogger() {
        return Logger.getLogger(MethodPropertyDescriptor.class.getName());
    }
}

