/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.threads;

import com.vaadin.featurepack.desktop.threads.LoomUtils;
import com.vaadin.featurepack.desktop.threads.SuspendingExecutor;
import com.vaadin.featurepack.desktop.threads.ThreadUtils;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class VaadinSuspendingExecutor
implements AutoCloseable {
    private final SuspendingExecutor suspendingExecutor;
    private final UI ui;

    public VaadinSuspendingExecutor(UI ui) {
        this.suspendingExecutor = new SuspendingExecutor(new UIExecutor(ui));
        this.ui = ui;
    }

    public void run(Runnable runnable) {
        Objects.requireNonNull(runnable);
        this.suspendingExecutor.run(() -> {
            try {
                VaadinSession.setCurrent((VaadinSession)this.ui.getSession());
                UI.setCurrent((UI)this.ui);
                VaadinSuspendingExecutor.assertUIVirtualThread();
                runnable.run();
            }
            catch (Throwable t) {
                this.ui.getSession().getErrorHandler().error(new ErrorEvent(t));
            }
            finally {
                UI.setCurrent(null);
                VaadinSession.setCurrent(null);
            }
        });
    }

    @Override
    public void close() {
        this.suspendingExecutor.close();
    }

    public static void assertUIVirtualThread() {
        LoomUtils.assertVirtualThread();
        if (UI.getCurrent() == null) {
            throw new IllegalStateException("UI.getCurrent() is null, this needs to be run in the Vaadin UI thread");
        }
    }

    private static class UIExecutor
    implements Executor {
        private final UI ui;

        public UIExecutor(UI ui) {
            this.ui = Objects.requireNonNull(ui);
        }

        @Override
        public void execute(Runnable command) {
            ThreadUtils.logInfo("I am going to access UI");
            this.ui.access((Command & Serializable)() -> {
                if (Thread.currentThread().isVirtual()) {
                    throw new IllegalStateException("http requests seems to be running in virtual threads. This is currently unsupported.");
                }
                ThreadUtils.logInfo("I am going to run a command");
                command.run();
                ThreadUtils.logInfo("Command executed");
            });
            ThreadUtils.logInfo("UI accessed.");
        }
    }
}

