/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.threads;

import com.vaadin.featurepack.desktop.threads.LoomUtils;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class SuspendingExecutor
implements AutoCloseable {
    private final ExecutorService virtualThreadExecutor;

    public SuspendingExecutor(Executor executor) {
        this.virtualThreadExecutor = Executors.newThreadPerTaskExecutor(LoomUtils.newVirtualBuilder(executor).factory());
    }

    public void run(Runnable runnable) {
        Objects.requireNonNull(runnable);
        this.virtualThreadExecutor.submit(runnable);
    }

    @Override
    public void close() {
        this.virtualThreadExecutor.shutdownNow();
    }
}

