/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.threads;

import com.vaadin.featurepack.desktop.threads.BlockingDialogOptions;
import com.vaadin.featurepack.desktop.threads.ThreadUtils;
import com.vaadin.featurepack.desktop.threads.VaadinSuspendingExecutor;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;

public class BlockingDialog
extends Dialog {
    private TextField input = null;
    CompletableFuture<String> responseInput = new CompletableFuture();

    public BlockingDialog(BlockingDialogOptions options) {
        this.initDialog(options);
    }

    public BlockingDialog(String title, BlockingDialogOptions options) {
        this.setHeaderTitle(title);
        this.initDialog(options);
    }

    private void initDialog(BlockingDialogOptions options) {
        if (options == BlockingDialogOptions.OK_CANCEL_INPUT) {
            VerticalLayout l = new VerticalLayout();
            this.input = new TextField();
            l.add(new Component[]{this.input, this.okCancelButtons()});
            l.setPadding(false);
            l.setSpacing(false);
            l.setAlignItems(FlexComponent.Alignment.STRETCH);
            l.getStyle().set("width", "18rem").set("max-width", "100%");
            this.add(new Component[]{l});
        }
    }

    private HorizontalLayout okCancelButtons() {
        HorizontalLayout l = new HorizontalLayout();
        Button okButton = new Button("Ok", (ComponentEventListener & Serializable)e -> {
            this.responseInput.complete(this.input.getValue());
            this.close();
        });
        Button cancelButton = new Button("Cancel", (ComponentEventListener & Serializable)e -> this.close());
        okButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        l.add(new Component[]{okButton, cancelButton});
        return l;
    }

    public static String askQuestion(HasComponents c, String question) {
        BlockingDialog b = new BlockingDialog(question, BlockingDialogOptions.OK_CANCEL_INPUT);
        c.add(new Component[]{b});
        return b.askInputResult();
    }

    public static boolean confirmDialog(String message) {
        VaadinSuspendingExecutor.assertUIVirtualThread();
        ThreadUtils.logInfo("Preparing a compleatable future, configure the dialog and open it");
        CompletableFuture responseFuture = new CompletableFuture();
        ConfirmDialog dialog = new ConfirmDialog();
        dialog.setText(message);
        dialog.addConfirmListener((ComponentEventListener & Serializable)e -> {
            ThreadUtils.logInfo("Sending result to the compleatable future (true)");
            responseFuture.complete(true);
        });
        dialog.setCancelable(true);
        dialog.addCancelListener((ComponentEventListener & Serializable)e -> {
            ThreadUtils.logInfo("Sending result to the compleatable future (false)");
            responseFuture.complete(false);
        });
        dialog.open();
        try {
            ThreadUtils.logInfo("Obtaining the result from the future...");
            boolean response = (Boolean)responseFuture.get();
            ThreadUtils.logInfo("Result obtained (" + response + ")");
            boolean bl = response;
            return bl;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        finally {
            ThreadUtils.logInfo("Closing the dialog");
            dialog.close();
        }
    }

    public String askInputResult() {
        VaadinSuspendingExecutor.assertUIVirtualThread();
        ThreadUtils.logInfo("Preparing a compleatable future, configure the dialog and open it");
        this.open();
        try {
            ThreadUtils.logInfo("Obtaining the result from the future...");
            String response = this.responseInput.get();
            ThreadUtils.logInfo("Result obtained (" + response + ")");
            String string = response;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ThreadUtils.logInfo("Closing the dialog");
        }
    }
}

