/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.threads;

import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.concurrent.Executor;

public class LoomUtils {
    public static void assertVirtualThread() {
        if (!Thread.currentThread().isVirtual()) {
            throw new IllegalStateException("This can only be called from a virtual thread");
        }
    }

    public static Thread.Builder.OfVirtual newVirtualBuilder(Executor executor) {
        Objects.requireNonNull(executor);
        try {
            Class<?> vtbclass = Class.forName("java.lang.ThreadBuilders$VirtualThreadBuilder");
            Constructor<?> c = vtbclass.getDeclaredConstructor(Executor.class);
            c.setAccessible(true);
            Thread.Builder.OfVirtual vtb = (Thread.Builder.OfVirtual)c.newInstance(executor);
            return vtb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

