/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.flow.component.Component;
import java.io.Serializable;

public class BaseFlowLayout
implements Serializable {
    protected int horizontalGap = 0;
    protected int verticalGap = 0;
    private int alignment = 0;
    public static final int CENTER = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;

    public BaseFlowLayout() {
        this(0, 5, 5);
    }

    public BaseFlowLayout(int align) {
        this(align, 5, 5);
    }

    public BaseFlowLayout(int align, int hgap, int vgap) {
        this.setHorizontalGap(hgap);
        this.setVerticalGap(vgap);
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected void setAlignment(int align, Component container) {
        this.alignment = align;
        this.updateAlignment(container);
    }

    protected void updateAlignment(Component container) {
        String justify = switch (this.alignment) {
            case 1 -> "flex-start";
            case 2 -> "flex-end";
            default -> "center";
        };
        if (container != null) {
            container.getStyle().set("--vfp-justify-content", justify);
        }
    }

    protected void setHorizontalGap(int horizontalGap) {
        this.horizontalGap = horizontalGap;
    }

    protected void setVerticalGap(int verticalGap) {
        this.verticalGap = verticalGap;
    }

    protected int getHorizontalGap() {
        return this.horizontalGap;
    }

    protected int getVerticalGap() {
        return this.verticalGap;
    }
}

