/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.geometry;

import com.vaadin.featurepack.desktop.geometry.Dimension;
import com.vaadin.featurepack.desktop.geometry.Point;
import java.io.Serializable;
import java.util.Objects;

public class Rectangle
implements Serializable {
    private int x;
    private int y;
    private int width;
    private int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Point p, Dimension d) {
        this(p.getX(), p.getY(), d.getWidth(), d.getHeight());
    }

    public Rectangle(Rectangle r) {
        this(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)obj;
            return this.getX() == rectangle.getX() && this.getY() == rectangle.getY() && this.getWidth() == rectangle.getWidth() && this.getHeight() == rectangle.getHeight();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }
}

