/*
 * Copyright (c) 1997, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.vaadin.featurepack.desktop.geometry;

import java.io.Serializable;
import java.util.Objects;

/**
 * A class that represents a dimension in 2D space.
 *
 * @author Vaadin Ltd
 */
public class Dimension implements Serializable {
    public int width;
    public int height;

    /**
     * Creates a new dimension with width and height set to 0.
     */
    public Dimension() {
        this(0, 0);
    }

    /**
     * Creates a new dimension with the given width and height.
     */
    public Dimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    /**
     * Creates a new dimension with the given width and height.
     */
    public Dimension(double width, double height) {
        this.width = (int) width;
        this.height = (int) height;
    }

    /**
     * Creates a new dimension clone
     */
    public Dimension(Dimension dim) {
        this(dim.width, dim.height);
    }

    /**
     * Returns the width of this dimension.
     *
     * @return the width
     */
    public int getWidth() {
        return width;
    }

    /**
     * Returns the height of this dimension.
     *
     * @return the height
     */
    public int getHeight() {
        return height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Dimension dimension) {
            return (getWidth() == dimension.getWidth())
                    && (getHeight() == dimension.getHeight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height);
    }

    @Override
    public String toString() {
        return "Dimension [width=" + width + ", height=" + height + "]";
    }

}
