/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.flow.component.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BaseCardLayout
implements Serializable {
    protected int currentCard = 0;
    protected List<Component> cards = new ArrayList<Component>();

    public void first() {
        for (int i = 0; i < this.cards.size(); ++i) {
            Component card = this.cards.get(i);
            if (!card.isVisible()) continue;
            card.setVisible(false);
            break;
        }
        if (this.cards.size() > 0) {
            this.currentCard = 0;
            this.cards.get(this.currentCard).setVisible(true);
        }
    }

    public void last() {
        for (int i = 0; i < this.cards.size(); ++i) {
            Component card = this.cards.get(i);
            if (!card.isVisible()) continue;
            card.setVisible(false);
            break;
        }
        if (this.cards.size() > 0) {
            this.currentCard = this.cards.size() - 1;
            this.cards.get(this.currentCard).setVisible(true);
        }
    }

    public void previous() {
        int count = this.cards.size();
        for (int i = 0; i < count; ++i) {
            Component card = this.cards.get(i);
            if (!card.isVisible()) continue;
            card.setVisible(false);
            this.currentCard = i > 0 ? i - 1 : count - 1;
            this.cards.get(this.currentCard).setVisible(true);
            return;
        }
    }

    public void next() {
        int count = this.cards.size();
        for (int i = 0; i < count; ++i) {
            Component card = this.cards.get(i);
            if (!card.isVisible()) continue;
            card.setVisible(false);
            this.currentCard = (i + 1) % count;
            this.cards.get(this.currentCard).setVisible(true);
            return;
        }
    }

    public void show(String name) {
        Component card;
        int i;
        Component next = null;
        for (i = 0; i < this.cards.size(); ++i) {
            card = this.cards.get(i);
            if (!card.getElement().getAttribute("vfp-card-layout-name").equals(name)) continue;
            next = card;
            break;
        }
        if (next != null && !next.isVisible()) {
            for (i = 0; i < this.cards.size(); ++i) {
                card = this.cards.get(i);
                if (!card.isVisible()) continue;
                card.setVisible(false);
                break;
            }
            next.setVisible(true);
        }
    }

    public List<Component> getCards() {
        return this.cards;
    }

    public int getCurrentCard() {
        return this.currentCard;
    }

    public void setCurrentCard(int currentCard) {
        this.currentCard = currentCard;
    }
}

