/*
 * Copyright (c) 1997, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.vaadin.featurepack.desktop.graphics;

import java.io.Serializable;

/**
 * Color class to hold RGB values
 */
public class Color implements Serializable {
    private int rValue;// red of RGB
    private int gValue;// green of RGB
    private int bValue;// blue of RGB
    private int aValue;// alpha value

    public static final Color white = new Color(255, 255, 255);

    public static final Color red = new Color(255, 0, 0);

    public static final Color green = new Color(0, 255, 0);

    public static final Color blue = new Color(0, 0, 255);

    public static final Color black = new Color(0, 0, 0);

    public Color(int red, int green, int blue, int alpha) {
        super();
        this.rValue = red;
        this.gValue = green;
        this.bValue = blue;
        this.aValue = alpha;
    }

    public Color(int red, int green, int blue) {
        super();
        this.rValue = red;
        this.gValue = green;
        this.bValue = blue;
    }

    public int getRed() {
        return rValue;
    }

    public void setRed(int red) {
        this.rValue = red;
    }

    public int getGreen() {
        return gValue;
    }

    public void setGreen(int green) {
        this.gValue = green;
    }

    public int getBlue() {
        return bValue;
    }

    public void setBlue(int blue) {
        this.bValue = blue;
    }

    public int getAlpha() {
        return aValue;
    }

    public void setAlpha(int alpha) {
        this.aValue = alpha;
    }

    public static Color decode(String num) throws NumberFormatException {
        Integer intval = Integer.decode(num);
        int i = intval.intValue();
        return new Color((i >> 16) & 0xFF, (i >> 8) & 0xFF, i & 0xFF);
    }

    public String toHexString() {
        return String.format("#%02X%02X%02X", rValue, gValue, bValue);
    }
}
