/*
 * Copyright (c) 1997, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.shared.HasTooltip;

/**
 * Label implementation with additional functionality over standart Vaadin Span.
 * A label can contain an Icon along with it's text.
 */
public abstract class AbstractFLabel extends Span implements HasTooltip {

    Image iconImage;

    public AbstractFLabel(String s) {
        super(s);
    }

    public AbstractFLabel() {
    }

    /**
     * Sets the icon for this label.
     *
     * @param icon
     */
    public void setIcon(Image icon) {
        if (iconImage != null) {
            try {
                remove(iconImage);
            } catch (Exception e) {
                System.out.println("iconImage is not child: " + iconImage);
            }
        }

        if (icon == null)
            return;

        this.iconImage = new Image(icon.getSrc(), icon.getAlt().orElse(null));
        addComponentAsFirst(iconImage);
    }

    /**
     * Returns current icon of this label
     *
     * @return Current icon.
     */
    public Image getIcon() {
        return iconImage;
    }

}
