/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public abstract class AbstractLayout
implements Serializable {
    private Component container;
    private final List<Registration> registrations = new ArrayList<Registration>();

    public void setContainer(Component container) {
        this.registrations.forEach(registration -> registration.remove());
        this.registrations.clear();
        this.container = container;
        if (container != null) {
            this.registrations.add(container.addAttachListener(this::onContainerAttach));
            this.registrations.add(container.addDetachListener(this::onContainerDetach));
        }
    }

    protected void onContainerAttach(AttachEvent event) {
    }

    protected void onContainerDetach(DetachEvent event) {
    }

    public void addComponent(Component component) {
    }

    public void removeComponent(Component component) {
    }

    public Component getContainer() {
        return this.container;
    }

    public Stream<Component> getComponents() {
        return this.container.getChildren();
    }

    public abstract void setConstraints(Component var1, Object var2);

    public abstract Object getConstraints(Component var1);
}

