/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts.form;

import com.vaadin.featurepack.desktop.layouts.form.ConstantSize;
import com.vaadin.featurepack.desktop.layouts.form.FormSpec;
import com.vaadin.featurepack.desktop.layouts.form.FormSpecParser;
import com.vaadin.featurepack.desktop.layouts.form.Size;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class ColumnSpec
extends FormSpec {
    public static final FormSpec.DefaultAlignment LEFT = FormSpec.LEFT_ALIGN;
    public static final FormSpec.DefaultAlignment CENTER = FormSpec.CENTER_ALIGN;
    public static final FormSpec.DefaultAlignment RIGHT = FormSpec.RIGHT_ALIGN;
    public static final FormSpec.DefaultAlignment FILL;
    public static final FormSpec.DefaultAlignment DEFAULT;
    private static final Map<String, ColumnSpec> CACHE;

    public ColumnSpec(FormSpec.DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        super(defaultAlignment, size, resizeWeight);
    }

    public ColumnSpec(Size size) {
        super(DEFAULT, size, 0.0);
    }

    private ColumnSpec(String encodedDescription) {
        super(DEFAULT, encodedDescription);
    }

    public static ColumnSpec createGap(ConstantSize gapWidth) {
        return new ColumnSpec(DEFAULT, gapWidth, 0.0);
    }

    public static ColumnSpec decode(String encodedColumnSpec) {
        Objects.requireNonNull(encodedColumnSpec, "Column specification cannot be null");
        String trimmed = encodedColumnSpec.trim();
        return ColumnSpec.decodeExpanded(trimmed.toLowerCase(Locale.ENGLISH));
    }

    static ColumnSpec decodeExpanded(String expandedTrimmedLowerCaseSpec) {
        ColumnSpec spec = CACHE.get(expandedTrimmedLowerCaseSpec);
        if (spec == null) {
            spec = new ColumnSpec(expandedTrimmedLowerCaseSpec);
            CACHE.put(expandedTrimmedLowerCaseSpec, spec);
        }
        return spec;
    }

    public static ColumnSpec[] decodeSpecs(String encodedColumnSpecs) {
        Objects.requireNonNull(encodedColumnSpecs, "Column specification cannot be null");
        return FormSpecParser.parseColumnSpecs(encodedColumnSpecs);
    }

    @Override
    protected boolean isHorizontal() {
        return true;
    }

    static {
        DEFAULT = FILL = FormSpec.FILL_ALIGN;
        CACHE = new HashMap<String, ColumnSpec>();
    }
}

