/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts.form;

import com.vaadin.featurepack.desktop.layouts.form.ConstantSize;
import com.vaadin.featurepack.desktop.layouts.form.FormSpec;
import com.vaadin.featurepack.desktop.layouts.form.FormSpecParser;
import com.vaadin.featurepack.desktop.layouts.form.Size;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class RowSpec
extends FormSpec {
    public static final FormSpec.DefaultAlignment TOP = FormSpec.TOP_ALIGN;
    public static final FormSpec.DefaultAlignment CENTER = FormSpec.CENTER_ALIGN;
    public static final FormSpec.DefaultAlignment BOTTOM = FormSpec.BOTTOM_ALIGN;
    public static final FormSpec.DefaultAlignment FILL = FormSpec.FILL_ALIGN;
    public static final FormSpec.DefaultAlignment DEFAULT = CENTER;
    private static final Map<String, RowSpec> CACHE = new HashMap<String, RowSpec>();

    public RowSpec(FormSpec.DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        super(defaultAlignment, size, resizeWeight);
    }

    public RowSpec(Size size) {
        super(DEFAULT, size, 0.0);
    }

    private RowSpec(String encodedDescription) {
        super(DEFAULT, encodedDescription);
    }

    public static RowSpec createGap(ConstantSize gapHeight) {
        return new RowSpec(DEFAULT, gapHeight, 0.0);
    }

    public static RowSpec decode(String encodedRowSpec) {
        Objects.requireNonNull(encodedRowSpec, "Row specification cannot be null");
        String trimmed = encodedRowSpec.trim();
        return RowSpec.decodeExpanded(trimmed.toLowerCase(Locale.ENGLISH));
    }

    static RowSpec decodeExpanded(String expandedTrimmedLowerCaseSpec) {
        RowSpec spec = CACHE.get(expandedTrimmedLowerCaseSpec);
        if (spec == null) {
            spec = new RowSpec(expandedTrimmedLowerCaseSpec);
            CACHE.put(expandedTrimmedLowerCaseSpec, spec);
        }
        return spec;
    }

    public static RowSpec[] decodeSpecs(String encodedRowSpecs) {
        Objects.requireNonNull(encodedRowSpecs, "Row specification cannot be null");
        return FormSpecParser.parseRowSpecs(encodedRowSpecs);
    }

    @Override
    protected boolean isHorizontal() {
        return false;
    }
}

