/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts.form;

import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.featurepack.desktop.layouts.form.CellConstraints;
import com.vaadin.featurepack.desktop.layouts.form.ColumnSpec;
import com.vaadin.featurepack.desktop.layouts.form.ComponentSize;
import com.vaadin.featurepack.desktop.layouts.form.ConstantSize;
import com.vaadin.featurepack.desktop.layouts.form.FormSpec;
import com.vaadin.featurepack.desktop.layouts.form.RowSpec;
import com.vaadin.featurepack.desktop.layouts.form.Size;
import com.vaadin.featurepack.desktop.layouts.form.Unit;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FormLayout
extends AbstractLayout {
    private final List<ColumnSpec> columnSpecs;
    private final List<RowSpec> rowSpecs;
    private final Map<Component, CellConstraints> constraintMap = new HashMap<Component, CellConstraints>();

    public FormLayout() {
        this(new ColumnSpec[0], new RowSpec[0]);
    }

    public FormLayout(String encodedColumnSpecs, String encodedRowSpecs) {
        this(ColumnSpec.decodeSpecs(encodedColumnSpecs), RowSpec.decodeSpecs(encodedRowSpecs));
    }

    public FormLayout(ColumnSpec[] colSpecs, RowSpec[] rowSpecs) {
        Objects.requireNonNull(colSpecs, "Column specs must not be null");
        Objects.requireNonNull(rowSpecs, "Row specs must not be null");
        this.columnSpecs = new ArrayList<ColumnSpec>(Arrays.asList(colSpecs));
        this.rowSpecs = new ArrayList<RowSpec>(Arrays.asList(rowSpecs));
    }

    protected void onContainerAttach(AttachEvent event) {
        event.getUI().getPage().addStyleSheet("vfp-form-layout.css");
    }

    public void setContainer(Component container) {
        Component current = this.getContainer();
        if (current != null) {
            current.getElement().removeAttribute("vfp-form-layout");
            current.getStyle().set("--vfp-grid-columns", null);
            current.getStyle().set("--vfp-grid-rows", null);
            this.constraintMap.forEach((component, constraints) -> this.clearComponent((Component)component));
            this.constraintMap.clear();
        }
        super.setContainer(container);
        if (container != null) {
            container.getElement().setAttribute("vfp-form-layout", "");
            this.getContainer().getStyle().set("--vfp-grid-columns", this.parseColumns());
            this.getContainer().getStyle().set("--vfp-grid-rows", this.parseRows());
        }
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
    }

    public void removeComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        this.constraintMap.remove(component);
        this.clearComponent(component);
    }

    private void clearComponent(Component component) {
        component.getStyle().remove("--vfp-grid-row-start");
        component.getStyle().remove("--vfp-grid-row-end");
        component.getStyle().remove("--vfp-grid-column-start");
        component.getStyle().remove("--vfp-grid-column-end");
        component.getStyle().remove("--vfp-justify-self");
        component.getStyle().remove("--vfp-align-self");
    }

    public void setConstraints(Component component, Object constraints) {
        Objects.requireNonNull(component, "Component must not be null");
        Objects.requireNonNull(constraints, "Constraints must not be null");
        if (!(constraints instanceof CellConstraints)) {
            throw new IllegalArgumentException("Constraints must be a CellConstraints");
        }
        CellConstraints cc = ((CellConstraints)constraints).clone();
        this.ensureValidGridBounds(cc, this.getColumnCount(), this.getRowCount());
        this.applyConstraints(component, cc);
    }

    private void ensureValidGridBounds(CellConstraints constraints, int colCount, int rowCount) {
        if (constraints.gridX <= 0) {
            throw new IndexOutOfBoundsException("The column index " + constraints.gridX + " must be positive.");
        }
        if (constraints.gridX > colCount) {
            throw new IndexOutOfBoundsException("The column index " + constraints.gridX + " must be less than or equal to " + colCount + ".");
        }
        if (constraints.gridX + constraints.gridWidth - 1 > colCount) {
            throw new IndexOutOfBoundsException("The grid width " + constraints.gridWidth + " must be less than or equal to " + (colCount - constraints.gridX + 1) + ".");
        }
        if (constraints.gridY <= 0) {
            throw new IndexOutOfBoundsException("The row index " + constraints.gridY + " must be positive.");
        }
        if (constraints.gridY > rowCount) {
            throw new IndexOutOfBoundsException("The row index " + constraints.gridY + " must be less than or equal to " + rowCount + ".");
        }
        if (constraints.gridY + constraints.gridHeight - 1 > rowCount) {
            throw new IndexOutOfBoundsException("The grid height " + constraints.gridHeight + " must be less than or equal to " + (rowCount - constraints.gridY + 1) + ".");
        }
    }

    private void applyConstraints(Component component, CellConstraints constraints) {
        this.constraintMap.put(component, constraints);
        this.setCellCoordinates(component, constraints);
        this.setCellAlignment(component, constraints);
    }

    public Object getConstraints(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        CellConstraints constraints = this.constraintMap.get(component);
        if (constraints == null) {
            throw new IllegalArgumentException("There is no constraints for the given component.");
        }
        return constraints.clone();
    }

    public int getColumnCount() {
        return this.columnSpecs.size();
    }

    public ColumnSpec getColumnSpec(int columnIndex) {
        return this.columnSpecs.get(columnIndex - 1);
    }

    public void appendColumn(ColumnSpec columnSpec) {
        Objects.requireNonNull(columnSpec, "Column spec must not be null");
        this.columnSpecs.add(columnSpec);
        this.getContainer().getStyle().set("--vfp-grid-columns", this.parseColumns());
    }

    public void insertColumn(int columnIndex, ColumnSpec columnSpec) {
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + columnIndex + "must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.columnSpecs.add(columnIndex - 1, columnSpec);
        this.getContainer().getStyle().set("--vfp-grid-columns", this.parseColumns());
        this.shiftComponentsHorizontally(columnIndex, false);
    }

    public void removeColumn(int columnIndex) {
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("The column index " + columnIndex + " must be in the range [1, " + this.getColumnCount() + "].");
        }
        this.columnSpecs.remove(columnIndex - 1);
        this.getContainer().getStyle().set("--vfp-grid-columns", this.parseColumns());
        this.shiftComponentsHorizontally(columnIndex, true);
    }

    public int getRowCount() {
        return this.rowSpecs.size();
    }

    public RowSpec getRowSpec(int rowIndex) {
        return this.rowSpecs.get(rowIndex - 1);
    }

    public void appendRow(RowSpec rowSpec) {
        Objects.requireNonNull(rowSpec, "Row spec must not be null");
        this.rowSpecs.add(rowSpec);
        this.getContainer().getStyle().set("--vfp-grid-rows", this.parseRows());
    }

    public void insertRow(int rowIndex, RowSpec rowSpec) {
        if (rowIndex < 1 || rowIndex > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + rowIndex + " must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.add(rowIndex - 1, rowSpec);
        this.getContainer().getStyle().set("--vfp-grid-rows", this.parseRows());
        this.shiftComponentsVertically(rowIndex, false);
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < 1 || rowIndex > this.getRowCount()) {
            throw new IndexOutOfBoundsException("The row index " + rowIndex + "must be in the range [1, " + this.getRowCount() + "].");
        }
        this.rowSpecs.remove(rowIndex - 1);
        this.getContainer().getStyle().set("--vfp-grid-rows", this.parseRows());
        this.shiftComponentsVertically(rowIndex, true);
    }

    private void shiftComponentsHorizontally(int columnIndex, boolean remove) {
        int offset = remove ? -1 : 1;
        this.constraintMap.forEach((component, constraints) -> {
            int x1 = constraints.gridX;
            int w = constraints.gridWidth;
            int x2 = x1 + w - 1;
            if (x1 == columnIndex && remove) {
                throw new IllegalStateException("The removed column " + columnIndex + " must not contain components.");
            }
            if (x1 >= columnIndex) {
                constraints.gridX += offset;
                this.setCellCoordinates((Component)component, (CellConstraints)constraints);
            } else if (x2 >= columnIndex) {
                constraints.gridWidth += offset;
                this.setCellCoordinates((Component)component, (CellConstraints)constraints);
            }
        });
    }

    private void shiftComponentsVertically(int rowIndex, boolean remove) {
        int offset = remove ? -1 : 1;
        this.constraintMap.forEach((component, constraints) -> {
            int y1 = constraints.gridY;
            int h = constraints.gridHeight;
            int y2 = y1 + h - 1;
            if (y1 == rowIndex && remove) {
                throw new IllegalStateException("The removed row " + rowIndex + " must not contain components.");
            }
            if (y1 >= rowIndex) {
                constraints.gridY += offset;
                this.setCellCoordinates((Component)component, (CellConstraints)constraints);
            } else if (y2 >= rowIndex) {
                constraints.gridHeight += offset;
                this.setCellCoordinates((Component)component, (CellConstraints)constraints);
            }
        });
    }

    private void setCellCoordinates(Component component, CellConstraints cell) {
        component.getStyle().set("--vfp-grid-row-start", Integer.toString(cell.gridY));
        component.getStyle().set("--vfp-grid-row-end", Integer.toString(cell.gridY + cell.gridHeight));
        component.getStyle().set("--vfp-grid-column-start", Integer.toString(cell.gridX));
        component.getStyle().set("--vfp-grid-column-end", Integer.toString(cell.gridX + cell.gridWidth));
    }

    private void setCellAlignment(Component component, CellConstraints cell) {
        ColumnSpec colSpec = cell.gridWidth == 1 ? this.getColumnSpec(cell.gridX) : null;
        CellConstraints.Alignment hAlign = this.getEffectiveAlignment(cell.hAlign, colSpec, CellConstraints.FILL);
        component.getStyle().set("--vfp-justify-self", this.parseAlignX(hAlign.toString()));
        RowSpec rowSpec = cell.gridHeight == 1 ? this.getRowSpec(cell.gridY) : null;
        CellConstraints.Alignment vAlign = this.getEffectiveAlignment(cell.vAlign, rowSpec, CellConstraints.CENTER);
        component.getStyle().set("--vfp-align-self", this.parseAlignY(vAlign.toString()));
    }

    private CellConstraints.Alignment getEffectiveAlignment(CellConstraints.Alignment cellAlignment, FormSpec formSpec, CellConstraints.Alignment fallbackAlignment) {
        if (formSpec == null) {
            return cellAlignment == CellConstraints.DEFAULT ? fallbackAlignment : cellAlignment;
        }
        if (cellAlignment != CellConstraints.DEFAULT) {
            return cellAlignment;
        }
        switch (formSpec.getDefaultAlignment().toString()) {
            case "left": {
                return CellConstraints.LEFT;
            }
            case "right": {
                return CellConstraints.RIGHT;
            }
            case "center": {
                return CellConstraints.CENTER;
            }
            case "top": {
                return CellConstraints.TOP;
            }
            case "bottom": {
                return CellConstraints.BOTTOM;
            }
        }
        return CellConstraints.FILL;
    }

    private String parseAlignX(String align) {
        switch (align) {
            case "left": {
                return "start";
            }
            case "right": {
                return "end";
            }
            case "fill": {
                return null;
            }
        }
        return align;
    }

    private String parseAlignY(String align) {
        switch (align) {
            case "top": {
                return "start";
            }
            case "bottom": {
                return "end";
            }
            case "fill": {
                return "stretch";
            }
            case "center": {
                return null;
            }
        }
        return align;
    }

    private String parseColumns() {
        return this.columnSpecs.stream().map(spec -> {
            if (spec.getResizeWeight() > 0.0) {
                return this.parseResizeWeight(spec.getResizeWeight());
            }
            Size size = spec.getSize();
            if (size instanceof ConstantSize) {
                ConstantSize s = (ConstantSize)size;
                if (s.getUnit() == Unit.DIALOG_UNITS) {
                    return this.parseHorizontalDlu(s.getValue());
                }
                return s.encode();
            }
            if (size instanceof ComponentSize) {
                ComponentSize s = (ComponentSize)size;
                if (s == ComponentSize.MINIMUM) {
                    return "min-content";
                }
                if (s == ComponentSize.DEFAULT) {
                    return "minmax(min-content, auto)";
                }
            }
            return "auto";
        }).collect(Collectors.joining(" "));
    }

    private String parseRows() {
        return this.rowSpecs.stream().map(spec -> {
            if (spec.getResizeWeight() > 0.0) {
                return this.parseResizeWeight(spec.getResizeWeight());
            }
            Size size = spec.getSize();
            if (size instanceof ConstantSize) {
                ConstantSize s = (ConstantSize)size;
                if (s.getUnit() == Unit.DIALOG_UNITS) {
                    return this.parseVerticalDlu(s.getValue());
                }
                return s.encode();
            }
            if (size instanceof ComponentSize) {
                ComponentSize s = (ComponentSize)size;
                if (s == ComponentSize.MINIMUM) {
                    return "min-content";
                }
                if (s == ComponentSize.DEFAULT) {
                    return "minmax(min-content, auto)";
                }
            }
            return "auto";
        }).collect(Collectors.joining(" "));
    }

    private String parseResizeWeight(double weight) {
        return String.format("%dfr", (int)Math.round(weight * 100.0));
    }

    private String parseHorizontalDlu(double size) {
        return String.format("calc(%d / 4 * 1ch)", (int)Math.round(size));
    }

    private String parseVerticalDlu(double size) {
        return String.format("calc(%d / 8 * 1em)", (int)Math.round(size));
    }
}

