/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts.form;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;

public class CellConstraints
implements Cloneable,
Serializable {
    public static final Alignment DEFAULT = new Alignment("default", 2);
    public static final Alignment FILL = new Alignment("fill", 2);
    public static final Alignment LEFT = new Alignment("left", 0);
    public static final Alignment RIGHT = new Alignment("right", 0);
    public static final Alignment CENTER = new Alignment("center", 2);
    public static final Alignment TOP = new Alignment("top", 1);
    public static final Alignment BOTTOM = new Alignment("bottom", 1);
    private static final Alignment[] VALUES = new Alignment[]{DEFAULT, FILL, LEFT, RIGHT, CENTER, TOP, BOTTOM};
    public int gridX;
    public int gridY;
    public int gridWidth;
    public int gridHeight;
    public Alignment hAlign;
    public Alignment vAlign;

    public CellConstraints() {
        this(1, 1);
    }

    public CellConstraints(int gridX, int gridY) {
        this(gridX, gridY, 1, 1);
    }

    public CellConstraints(int gridX, int gridY, Alignment hAlign, Alignment vAlign) {
        this(gridX, gridY, 1, 1, hAlign, vAlign);
    }

    public CellConstraints(int gridX, int gridY, int gridWidth, int gridHeight) {
        this(gridX, gridY, gridWidth, gridHeight, DEFAULT, DEFAULT);
    }

    public CellConstraints(int gridX, int gridY, int gridWidth, int gridHeight, Alignment hAlign, Alignment vAlign) {
        Objects.requireNonNull(hAlign, "Horizontal alignment must not be null");
        Objects.requireNonNull(vAlign, "Vertical alignment must not be null");
        this.gridX = gridX;
        this.gridY = gridY;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
        if (gridX <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        if (gridY <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (gridWidth <= 0) {
            throw new IndexOutOfBoundsException("The grid width must be a positive number.");
        }
        if (gridHeight <= 0) {
            throw new IndexOutOfBoundsException("The grid height must be a positive number.");
        }
        CellConstraints.ensureValidOrientations(hAlign, vAlign);
    }

    public CellConstraints(String encodedConstraints) {
        this();
        this.initFromConstraints(encodedConstraints);
    }

    public CellConstraints xy(int col, int row) {
        return this.xywh(col, row, 1, 1);
    }

    public CellConstraints xy(int col, int row, String encodedAlignments) {
        return this.xywh(col, row, 1, 1, encodedAlignments);
    }

    public CellConstraints xy(int col, int row, Alignment colAlign, Alignment rowAlign) {
        return this.xywh(col, row, 1, 1, colAlign, rowAlign);
    }

    public CellConstraints xyw(int col, int row, int colSpan) {
        return this.xywh(col, row, colSpan, 1, DEFAULT, DEFAULT);
    }

    public CellConstraints xyw(int col, int row, int colSpan, String encodedAlignments) {
        return this.xywh(col, row, colSpan, 1, encodedAlignments);
    }

    public CellConstraints xyw(int col, int row, int colSpan, Alignment colAlign, Alignment rowAlign) {
        return this.xywh(col, row, colSpan, 1, colAlign, rowAlign);
    }

    public CellConstraints xywh(int col, int row, int colSpan, int rowSpan) {
        return this.xywh(col, row, colSpan, rowSpan, DEFAULT, DEFAULT);
    }

    public CellConstraints xywh(int col, int row, int colSpan, int rowSpan, String encodedAlignments) {
        CellConstraints result = this.xywh(col, row, colSpan, rowSpan);
        result.setAlignments(encodedAlignments, true);
        return result;
    }

    public CellConstraints xywh(int col, int row, int colSpan, int rowSpan, Alignment colAlign, Alignment rowAlign) {
        this.gridX = col;
        this.gridY = row;
        this.gridWidth = colSpan;
        this.gridHeight = rowSpan;
        this.hAlign = colAlign;
        this.vAlign = rowAlign;
        CellConstraints.ensureValidOrientations(this.hAlign, this.vAlign);
        return this;
    }

    private void initFromConstraints(String encodedConstraints) {
        StringTokenizer tokenizer = new StringTokenizer(encodedConstraints, " ,");
        int argCount = tokenizer.countTokens();
        if (argCount != 2 && argCount != 4 && argCount != 6) {
            throw new IllegalArgumentException("You must provide 2, 4 or 6 arguments.");
        }
        Integer nextInt = CellConstraints.decodeInt(tokenizer.nextToken());
        if (nextInt == null) {
            throw new IllegalArgumentException("First cell constraint element must be a number.");
        }
        this.gridX = nextInt;
        if (this.gridX <= 0) {
            throw new IllegalArgumentException("The grid X must be a positive number.");
        }
        nextInt = CellConstraints.decodeInt(tokenizer.nextToken());
        if (nextInt == null) {
            throw new IllegalArgumentException("Second cell constraint element must be a number.");
        }
        this.gridY = nextInt;
        if (this.gridY <= 0) {
            throw new IllegalArgumentException("The grid Y must be a positive number.");
        }
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        String token = tokenizer.nextToken();
        nextInt = CellConstraints.decodeInt(token);
        if (nextInt != null) {
            this.gridWidth = nextInt;
            if (this.gridWidth <= 0) {
                throw new IndexOutOfBoundsException("The grid width must be a positive number.");
            }
            nextInt = CellConstraints.decodeInt(tokenizer.nextToken());
            if (nextInt == null) {
                throw new IllegalArgumentException("Fourth cell constraint element must be like third.");
            }
            this.gridHeight = nextInt;
            if (this.gridHeight <= 0) {
                throw new IndexOutOfBoundsException("The grid height must be a positive number.");
            }
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            token = tokenizer.nextToken();
        }
        this.hAlign = CellConstraints.decodeAlignment(token);
        this.vAlign = CellConstraints.decodeAlignment(tokenizer.nextToken());
        CellConstraints.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    private void setAlignments(String encodedAlignments, boolean horizontalThenVertical) {
        StringTokenizer tokenizer = new StringTokenizer(encodedAlignments, " ,");
        Alignment first = CellConstraints.decodeAlignment(tokenizer.nextToken());
        Alignment second = CellConstraints.decodeAlignment(tokenizer.nextToken());
        this.hAlign = horizontalThenVertical ? first : second;
        this.vAlign = horizontalThenVertical ? second : first;
        CellConstraints.ensureValidOrientations(this.hAlign, this.vAlign);
    }

    private static Integer decodeInt(String token) {
        try {
            return Integer.decode(token);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Alignment decodeAlignment(String encodedAlignment) {
        return Alignment.valueOf(encodedAlignment);
    }

    private static void ensureValidOrientations(Alignment horizontalAlignment, Alignment verticalAlignment) {
        if (!horizontalAlignment.isHorizontal()) {
            throw new IllegalArgumentException("The horizontal alignment must be one of: left, center, right, fill, default.");
        }
        if (!verticalAlignment.isVertical()) {
            throw new IllegalArgumentException("The vertical alignment must be one of: top, center, bottom, fill, default.");
        }
    }

    public CellConstraints clone() {
        try {
            CellConstraints c = (CellConstraints)super.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static final class Alignment
    implements Serializable {
        private static final int HORIZONTAL = 0;
        private static final int VERTICAL = 1;
        private static final int BOTH = 2;
        private final transient String name;
        private final transient int orientation;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Alignment(String name, int orientation) {
            this.name = name;
            this.orientation = orientation;
        }

        static Alignment valueOf(String nameOrAbbreviation) {
            String str;
            switch (str = nameOrAbbreviation.toLowerCase(Locale.ENGLISH)) {
                case "d": 
                case "default": {
                    return DEFAULT;
                }
                case "f": 
                case "fill": {
                    return FILL;
                }
                case "c": 
                case "center": {
                    return CENTER;
                }
                case "l": 
                case "left": {
                    return LEFT;
                }
                case "r": 
                case "right": {
                    return RIGHT;
                }
                case "t": 
                case "top": {
                    return TOP;
                }
                case "b": 
                case "bottom": {
                    return BOTTOM;
                }
            }
            throw new IllegalArgumentException("Invalid alignment " + nameOrAbbreviation + ". Must be one of: left, center, right, top, bottom, fill, default, l, c, r, t, b, f, d.");
        }

        public String toString() {
            return this.name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        private boolean isHorizontal() {
            return this.orientation != 1;
        }

        private boolean isVertical() {
            return this.orientation != 0;
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

