/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts.form;

public enum Unit {
    PIXEL("px"),
    POINT("pt"),
    DIALOG_UNITS("dlu"),
    MILLIMETER("mm"),
    CENTIMETER("cm"),
    INCH("in");

    private final String abbreviation;

    private Unit(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    static Unit decode(String name) {
        switch (name) {
            case "px": {
                return PIXEL;
            }
            case "dlu": {
                return DIALOG_UNITS;
            }
            case "pt": {
                return POINT;
            }
            case "in": {
                return INCH;
            }
            case "mm": {
                return MILLIMETER;
            }
            case "cm": {
                return CENTIMETER;
            }
        }
        throw new IllegalArgumentException("Invalid unit name '" + name + "'. Must be one of: px, dlu, pt, mm, cm, in");
    }

    public String encode() {
        return this.abbreviation;
    }

    public String abbreviation() {
        return this.abbreviation;
    }
}

