/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts.form;

import com.vaadin.featurepack.desktop.layouts.form.ComponentSize;
import com.vaadin.featurepack.desktop.layouts.form.ConstantSize;
import com.vaadin.featurepack.desktop.layouts.form.Size;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class FormSpec
implements Serializable {
    static final DefaultAlignment LEFT_ALIGN = new DefaultAlignment("left");
    static final DefaultAlignment RIGHT_ALIGN = new DefaultAlignment("right");
    static final DefaultAlignment TOP_ALIGN = new DefaultAlignment("top");
    static final DefaultAlignment BOTTOM_ALIGN = new DefaultAlignment("bottom");
    static final DefaultAlignment CENTER_ALIGN = new DefaultAlignment("center");
    static final DefaultAlignment FILL_ALIGN = new DefaultAlignment("fill");
    private static final DefaultAlignment[] VALUES = new DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;
    private static final Pattern TOKEN_SEPARATOR_PATTERN = Pattern.compile(":");
    private DefaultAlignment defaultAlignment;
    private Size size;
    private double resizeWeight;

    protected FormSpec(DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        Objects.requireNonNull(size, "Size must not be null");
        if (resizeWeight < 0.0) {
            throw new IllegalArgumentException("Resize weight must be non-negative");
        }
        this.defaultAlignment = defaultAlignment;
        this.size = size;
        this.resizeWeight = resizeWeight;
    }

    protected FormSpec(DefaultAlignment defaultAlignment, String encodedDescription) {
        this(defaultAlignment, ComponentSize.DEFAULT, 0.0);
        this.parseAndInitValues(encodedDescription.toLowerCase(Locale.ENGLISH));
    }

    public final DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final Size getSize() {
        return this.size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    abstract boolean isHorizontal();

    void setDefaultAlignment(DefaultAlignment defaultAlignment) {
        this.defaultAlignment = defaultAlignment;
    }

    void setSize(Size size) {
        this.size = size;
    }

    void setResizeWeight(double resizeWeight) {
        this.resizeWeight = resizeWeight;
    }

    private void parseAndInitValues(String encodedDescription) {
        String next;
        DefaultAlignment alignment;
        Objects.requireNonNull(this.size, "Encoded description must not be null");
        String[] token = TOKEN_SEPARATOR_PATTERN.split(encodedDescription);
        if (token.length == 0) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        int nextIndex = 0;
        if ((alignment = DefaultAlignment.valueOf(next = token[nextIndex++], this.isHorizontal())) != null) {
            this.setDefaultAlignment(alignment);
            if (token.length < 2) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            next = token[nextIndex++];
        }
        this.setSize(FormSpec.parseSize(next));
        if (nextIndex < token.length) {
            this.setResizeWeight(FormSpec.parseResizeWeight(token[nextIndex]));
        }
    }

    private static Size parseSize(String token) {
        return FormSpec.parseAtomicSize(token);
    }

    private static Size parseAtomicSize(String token) {
        String trimmedToken = token.trim();
        ComponentSize componentSize = ComponentSize.decode(trimmedToken);
        if (componentSize != null) {
            return componentSize;
        }
        return ConstantSize.decode(trimmedToken);
    }

    private static double parseResizeWeight(String token) {
        if (token.equals("g") || token.equals("grow")) {
            return 1.0;
        }
        if (token.equals("n") || token.equals("nogrow") || token.equals("none")) {
            return 0.0;
        }
        if ((token.startsWith("grow(") || token.startsWith("g(")) && token.endsWith(")")) {
            int leftParen = token.indexOf(40);
            int rightParen = token.indexOf(41);
            String substring = token.substring(leftParen + 1, rightParen);
            return Double.parseDouble(substring);
        }
        throw new IllegalArgumentException("The resize argument '" + token + "' is invalid.  Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    private static boolean isConstant(Size aSize) {
        return aSize instanceof ConstantSize;
    }

    public static final class DefaultAlignment
    implements Serializable {
        private final transient String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private DefaultAlignment(String name) {
            this.name = name;
        }

        private static DefaultAlignment valueOf(String str, boolean isHorizontal) {
            if (str.equals("f") || str.equals("fill")) {
                return FILL_ALIGN;
            }
            if (str.equals("c") || str.equals("center")) {
                return CENTER_ALIGN;
            }
            if (isHorizontal) {
                if (str.equals("r") || str.equals("right")) {
                    return RIGHT_ALIGN;
                }
                if (str.equals("l") || str.equals("left")) {
                    return LEFT_ALIGN;
                }
                return null;
            }
            if (str.equals("t") || str.equals("top")) {
                return TOP_ALIGN;
            }
            if (str.equals("b") || str.equals("bottom")) {
                return BOTTOM_ALIGN;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

