/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts.form;

import com.vaadin.featurepack.desktop.layouts.form.Size;
import com.vaadin.featurepack.desktop.layouts.form.Unit;

public final class ConstantSize
implements Size {
    private final double value;
    private final Unit unit;

    public ConstantSize(int value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public ConstantSize(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    static ConstantSize decode(String encodedValueAndUnit) {
        String[] split = ConstantSize.splitValueAndUnit(encodedValueAndUnit);
        String encodedValue = split[0];
        String encodedUnit = split[1];
        Unit unit = Unit.decode(encodedUnit);
        double value = Double.parseDouble(encodedValue);
        return new ConstantSize(value, unit);
    }

    static ConstantSize dlu(int value) {
        return new ConstantSize(value, Unit.DIALOG_UNITS);
    }

    public double getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantSize)) {
            return false;
        }
        ConstantSize size = (ConstantSize)o;
        return this.value == size.value && this.unit == size.unit;
    }

    public int hashCode() {
        return new Double(this.value).hashCode() + 37 * this.unit.hashCode();
    }

    public String toString() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.abbreviation() : Double.toString(this.value) + this.unit.abbreviation();
    }

    @Override
    public String encode() {
        return this.value == (double)this.intValue() ? Integer.toString(this.intValue()) + this.unit.encode() : Double.toString(this.value) + this.unit.encode();
    }

    private int intValue() {
        return (int)Math.round(this.value);
    }

    private static String[] splitValueAndUnit(String encodedValueAndUnit) {
        int len;
        int firstLetterIndex;
        String[] result = new String[2];
        for (firstLetterIndex = len = encodedValueAndUnit.length(); firstLetterIndex > 0 && Character.isLetter(encodedValueAndUnit.charAt(firstLetterIndex - 1)); --firstLetterIndex) {
        }
        result[0] = encodedValueAndUnit.substring(0, firstLetterIndex);
        result[1] = encodedValueAndUnit.substring(firstLetterIndex);
        return result;
    }
}

