/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.base.devserver.stats.JsonHelpers;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.base.devserver.stats.StatisticsSender;
import com.vaadin.base.devserver.stats.StatisticsStorage;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.Version;
import com.vaadin.pro.licensechecker.MachineId;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;

public class DevModeUsageStatistics {
    private static DevModeUsageStatistics instance = null;
    private final StatisticsStorage storage;
    private final File projectFolder;

    private DevModeUsageStatistics(File projectFolder, StatisticsStorage storage) {
        this.projectFolder = projectFolder;
        this.storage = storage;
    }

    static DevModeUsageStatistics get() {
        return instance;
    }

    public static DevModeUsageStatistics init(File projectFolder, StatisticsStorage storage, StatisticsSender sender) {
        DevModeUsageStatistics.getLogger().debug("Telemetry enabled");
        Path statisticDirPath = storage.getUsageStatisticsFile().getParentFile().toPath();
        Path firstSeenPath = statisticDirPath.resolve("telemetry-notice-seen.txt");
        if (!Files.exists(firstSeenPath, new LinkOption[0])) {
            DevModeUsageStatistics.getLogger().info("Telemetry");
            DevModeUsageStatistics.getLogger().info("---------");
            DevModeUsageStatistics.getLogger().info("Vaadin collects usage data in order to help us improve your experience. You can opt-out of telemetry by setting the {} environment variable value to 'false'.", (Object)"VAADIN_USAGE_STATS_ENABLED");
            DevModeUsageStatistics.getLogger().info("Read more about Vaadin telemetry at https://vaadin.com/docs/latest/flow/configuration/development-mode#usage-statistics");
            try {
                Files.createDirectories(statisticDirPath, new FileAttribute[0]);
                Files.writeString(firstSeenPath, (CharSequence)Instant.now().toString(), new OpenOption[0]);
            }
            catch (IOException ioe) {
                DevModeUsageStatistics.getLogger().warn("Failed to create telemetry notice first seen file", (Throwable)ioe);
            }
        }
        storage.access((Command & Serializable)() -> {
            instance = new DevModeUsageStatistics(projectFolder, storage);
            String projectId = ProjectHelpers.generateProjectId(projectFolder);
            storage.setProjectId(projectId);
            instance.trackGlobalData();
            sender.triggerSendIfNeeded(storage.read());
        });
        return instance;
    }

    private void trackGlobalData() {
        this.storage.update((globalData, projectData) -> {
            globalData.setValue("os", ServerInfo.fetchOperatingSystem());
            globalData.setValue("jvm", ServerInfo.fetchJavaVersion());
            globalData.setValue("proKey", ProjectHelpers.getProKey());
            globalData.setValue("userKey", ProjectHelpers.getUserKey());
            try {
                globalData.setValue("machineId", MachineId.get());
            }
            catch (Throwable ex) {
                globalData.setValue("machineId", "ERROR");
                DevModeUsageStatistics.getLogger().debug("Cannot get Machine ID", ex);
            }
            projectData.setValue("flowVersion", Version.getFullVersion());
            projectData.setValue("vaadinVersion", ServerInfo.fetchVaadinVersion());
            projectData.setValue("hillaVersion", ServerInfo.fetchHillaVersion());
            projectData.setValue("sourceId", ProjectHelpers.getProjectSource(this.projectFolder));
            projectData.increment("devModeStarts");
        });
    }

    public static void handleBrowserData(JsonNode data) {
        DevModeUsageStatistics.getLogger().debug("Received client usage statistics from the browser");
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        DevModeUsageStatistics.get().storage.update((global, project) -> {
            try {
                String json = data.get("browserData").toString();
                JsonNode clientData = JsonHelpers.getJsonMapper().readTree(json);
                if (clientData != null && clientData.isObject()) {
                    clientData.properties().forEach(e -> project.setValue((String)e.getKey(), (JsonNode)e.getValue()));
                }
            }
            catch (Exception e2) {
                DevModeUsageStatistics.getLogger().debug("Failed to update client telemetry data", (Throwable)e2);
            }
        });
    }

    static boolean isStatisticsEnabled() {
        return instance != null;
    }

    public static void collectEvent(String name) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            DevModeUsageStatistics.get().storage.update((global, project) -> project.increment(name));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to log '" + name + "'", (Throwable)e);
        }
    }

    public static void collectEvent(String name, double value) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            DevModeUsageStatistics.get().storage.update((global, project) -> project.aggregate(name, value));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to collect event '" + name + "'", (Throwable)e);
        }
    }

    public void set(String name, String value) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            this.storage.update((global, project) -> project.setValue(name, value));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to set  '" + name + "'", (Throwable)e);
        }
    }

    public void setGlobal(String name, String value) {
        if (!DevModeUsageStatistics.isStatisticsEnabled()) {
            return;
        }
        try {
            this.storage.update((global, project) -> global.setValue(name, value));
        }
        catch (Exception e) {
            DevModeUsageStatistics.getLogger().debug("Failed to set global '" + name + "'", (Throwable)e);
        }
    }

    static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeUsageStatistics.class);
    }
}

