/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.hotswap;

import com.vaadin.base.devserver.hotswap.HotswapClassEvent;
import com.vaadin.base.devserver.hotswap.HotswapClassSessionEvent;
import com.vaadin.base.devserver.hotswap.HotswapCompleteEvent;
import com.vaadin.base.devserver.hotswap.HotswapEvent;
import com.vaadin.base.devserver.hotswap.HotswapResourceEvent;
import com.vaadin.base.devserver.hotswap.UIUpdateStrategy;
import com.vaadin.base.devserver.hotswap.VaadinHotswapper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.SessionDestroyEvent;
import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.SessionInitEvent;
import com.vaadin.flow.server.SessionInitListener;
import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import jakarta.annotation.Priority;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hotswapper
implements ServiceDestroyListener,
SessionInitListener,
SessionDestroyListener,
UIInitListener {
    public static final String FORCE_RELOAD_PROPERTY = "vaadin.hotswap.forcePageReload";
    private static final Logger LOGGER = LoggerFactory.getLogger(Hotswapper.class);
    private final Set<VaadinSession> sessions = ConcurrentHashMap.newKeySet();
    private final VaadinService vaadinService;
    private final BrowserLiveReload liveReload;
    private final Collection<VaadinHotswapper> hotSwappers;
    private volatile boolean serviceDestroyed = false;

    Hotswapper(VaadinService vaadinService) {
        this.vaadinService = Objects.requireNonNull(vaadinService, "VaadinService instance is mandatory");
        this.liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService((VaadinService)vaadinService).orElse(null);
        this.hotSwappers = Hotswapper.initializeHotSwappers(vaadinService);
    }

    private static Collection<VaadinHotswapper> initializeHotSwappers(VaadinService vaadinService) {
        Lookup lookup = (Lookup)vaadinService.getContext().getAttribute(Lookup.class);
        if (lookup == null) {
            throw new IllegalStateException("Lookup not found in VaadinContext");
        }
        ArrayList<VaadinHotswapper> hotSwappers = new ArrayList<VaadinHotswapper>(lookup.lookupAll(VaadinHotswapper.class));
        hotSwappers.sort(Comparator.comparingInt(plugin -> {
            Priority priority = plugin.getClass().getAnnotation(Priority.class);
            if (priority == null) {
                return 0;
            }
            return priority.value();
        }));
        for (VaadinHotswapper hotSwapper : hotSwappers) {
            try {
                hotSwapper.onInit(vaadinService);
            }
            catch (Exception ex) {
                LOGGER.error("Initialization failed for {} {}", new Object[]{VaadinHotswapper.class.getSimpleName(), hotSwapper.getClass().getName(), ex});
            }
        }
        return hotSwappers;
    }

    public void onHotswap(String[] classes, Boolean redefined) {
        if (this.serviceDestroyed) {
            LOGGER.debug("Hotswap classes change event ignored because VaadinService has been destroyed.");
            return;
        }
        if (classes == null || classes.length == 0) {
            LOGGER.debug("Hotswap event ignored because Hotswapper has been called without class changes to apply.");
            return;
        }
        this.onHotswapInternal(Arrays.stream(classes).map(Hotswapper::resolveClass).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new)), redefined);
    }

    public void onHotswap(URI[] createdResources, URI[] modifiedResources, URI[] deletedResources) {
        if (this.serviceDestroyed) {
            LOGGER.debug("Hotswap resources change event ignored because VaadinService has been destroyed.");
            return;
        }
        if (!(createdResources != null && createdResources.length != 0 || modifiedResources != null && modifiedResources.length != 0 || deletedResources != null && deletedResources.length != 0)) {
            LOGGER.debug("Hotswap event ignored because Hotswapper has been called without resource changes to apply.");
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created resources: {}, modified resources: {}, deletedResources: {}.", new Object[]{createdResources, modifiedResources, deletedResources});
        }
        HashSet<URI> allResources = new HashSet<URI>();
        if (createdResources != null) {
            Collections.addAll(allResources, createdResources);
        }
        if (modifiedResources != null) {
            Collections.addAll(allResources, modifiedResources);
        }
        if (deletedResources != null) {
            Collections.addAll(allResources, deletedResources);
        }
        HotswapResourceEvent event = new HotswapResourceEvent(this.vaadinService, allResources);
        for (VaadinHotswapper hotSwapper : this.hotSwappers) {
            try {
                hotSwapper.onResourcesChange(event);
            }
            catch (Exception ex) {
                LOGGER.debug("Resource hotswap failed executing {}", (Object)hotSwapper, (Object)ex);
            }
        }
        this.applyLiveReloadCommands(event);
        EnumMap<UIRefreshStrategy, List<UI>> refreshActions = new EnumMap<UIRefreshStrategy, List<UI>>(UIRefreshStrategy.class);
        this.forEachActiveUI(ui -> {
            boolean pushEnabled = ui.getPushConfiguration().getPushMode().isEnabled();
            UIRefreshStrategy refreshStrategy = event.getUIUpdateStrategy((UI)ui).map(upd -> this.mapUpdateStrategy((UIUpdateStrategy)((Object)((Object)upd)), pushEnabled)).orElse(UIRefreshStrategy.SKIP);
            refreshActions.computeIfAbsent(refreshStrategy, k -> new ArrayList()).add(ui);
        });
        refreshActions.remove((Object)UIRefreshStrategy.SKIP);
        boolean forceReload = event.anyUIRequiresPageReload();
        this.triggerClientUpdate(refreshActions, forceReload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHotswapInternal(HashSet<Class<?>> classes, Boolean redefined) {
        boolean bl;
        if (classes == null || classes.isEmpty()) {
            LOGGER.debug("Hotswap event ignored because Hotswapper has been called without changes to apply.");
            return;
        }
        HotswapClassEvent event = new HotswapClassEvent(this.vaadinService, classes, redefined);
        for (VaadinHotswapper vaadinHotswapper : this.hotSwappers) {
            try {
                vaadinHotswapper.onClassesChange(event);
            }
            catch (Exception ex) {
                LOGGER.debug("Global hotswap failed executing {}", (Object)vaadinHotswapper, (Object)ex);
            }
        }
        Set<VaadinSession> vaadinSessions = Set.copyOf(this.sessions);
        for (VaadinSession vaadinSession : vaadinSessions) {
            try {
                vaadinSession.getLockInstance().lock();
                HotswapClassSessionEvent sessionEvent = new HotswapClassSessionEvent(this.vaadinService, vaadinSession, classes, redefined);
                for (VaadinHotswapper hotSwapper : this.hotSwappers) {
                    try {
                        hotSwapper.onClassesChange(sessionEvent);
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Hotswap failed executing {} for Vaadin session {}", new Object[]{hotSwapper, vaadinSession.getSession().getId(), ex});
                    }
                }
                event.merge(sessionEvent);
            }
            finally {
                vaadinSession.getLockInstance().unlock();
            }
        }
        this.applyLiveReloadCommands(event);
        boolean bl3 = event.anyUIRequiresPageReload();
        bl3 = bl3 || Hotswapper.getForceReloadHolder(this.vaadinService).shouldReloadPage() && redefined != false;
        boolean uiTreeNeedsRefresh = false;
        EnumMap<UIRefreshStrategy, List<UI>> refreshActions = null;
        if (!bl3) {
            refreshActions = this.computeRefreshStrategies(event);
            if (refreshActions.containsKey((Object)UIRefreshStrategy.RELOAD)) {
                bl = true;
            }
            boolean bl4 = uiTreeNeedsRefresh = !refreshActions.isEmpty();
        }
        if (bl || uiTreeNeedsRefresh) {
            this.triggerClientUpdate(refreshActions, bl);
        }
        HotswapCompleteEvent completeEvent = new HotswapCompleteEvent(this.vaadinService, classes, redefined);
        for (VaadinHotswapper hotSwapper : this.hotSwappers) {
            try {
                hotSwapper.onHotswapComplete(completeEvent);
            }
            catch (Exception ex) {
                LOGGER.debug("Hotswap complete event handling failed for {}", (Object)hotSwapper, (Object)ex);
            }
        }
    }

    private void applyLiveReloadCommands(HotswapEvent event) {
        if (this.liveReload != null) {
            try {
                event.applyClientCommands(this.liveReload);
            }
            catch (Exception ex) {
                LOGGER.debug("Failed to apply client commands", (Throwable)ex);
            }
        } else {
            LOGGER.debug("A change to one or more class or resource requires a browser page refresh, but BrowserLiveReload is not available. Please reload the browser page manually to make changes effective.");
        }
    }

    private EnumMap<UIRefreshStrategy, List<UI>> computeRefreshStrategies(HotswapClassEvent event) {
        EnumMap<UIRefreshStrategy, List<UI>> uisToRefresh = new EnumMap<UIRefreshStrategy, List<UI>>(UIRefreshStrategy.class);
        this.forEachActiveUI(ui -> uisToRefresh.computeIfAbsent(this.computeRefreshStrategy((UI)ui, event), k -> new ArrayList()).add(ui));
        uisToRefresh.remove((Object)UIRefreshStrategy.SKIP);
        return uisToRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachActiveUI(Consumer<UI> consumer) {
        for (VaadinSession session : Set.copyOf(this.sessions)) {
            session.getLockInstance().lock();
            try {
                session.getUIs().stream().filter(ui -> !ui.isClosing()).forEach(consumer);
            }
            finally {
                session.getLockInstance().unlock();
            }
        }
    }

    private UIRefreshStrategy mapUpdateStrategy(UIUpdateStrategy strategy, boolean pushEnabled) {
        if (strategy == UIUpdateStrategy.RELOAD) {
            return UIRefreshStrategy.RELOAD;
        }
        if (pushEnabled) {
            return UIRefreshStrategy.PUSH_REFRESH_CHAIN;
        }
        return UIRefreshStrategy.REFRESH;
    }

    private UIRefreshStrategy computeRefreshStrategy(UI ui, HotswapClassEvent event) {
        UIRefreshStrategy refreshStrategy;
        boolean pushEnabled;
        block6: {
            block8: {
                String currentPath;
                RouteRegistry registry;
                RouteTarget routeTarget;
                Set<Class<?>> changedClasses;
                block7: {
                    pushEnabled = ui.getPushConfiguration().getPushMode().isEnabled();
                    refreshStrategy = event.getUIUpdateStrategy(ui).map(requestedStrategy -> this.mapUpdateStrategy((UIUpdateStrategy)((Object)requestedStrategy), pushEnabled)).orElse(null);
                    if (refreshStrategy != null) {
                        return refreshStrategy;
                    }
                    changedClasses = event.getChangedClasses();
                    boolean redefined = event.isRedefined();
                    ArrayList<HasElement> targetsChain = new ArrayList<HasElement>(ui.getActiveRouterTargetsChain());
                    if (targetsChain.isEmpty()) {
                        return UIRefreshStrategy.SKIP;
                    }
                    HasElement route = (HasElement)targetsChain.get(0);
                    List targetChainChangedItems = changedClasses.stream().flatMap(clazz -> targetsChain.stream().filter(chainItem -> clazz.isAssignableFrom(chainItem.getClass()))).distinct().toList();
                    refreshStrategy = redefined ? (ui.hasModalComponent() ? UIRefreshStrategy.PUSH_REFRESH_CHAIN : (!targetChainChangedItems.isEmpty() ? (targetChainChangedItems.stream().allMatch(chainItem -> chainItem == route) ? UIRefreshStrategy.PUSH_REFRESH_ROUTE : UIRefreshStrategy.PUSH_REFRESH_CHAIN) : Hotswapper.computeRefreshStrategyForUITree(ui, changedClasses, targetsChain, route))) : UIRefreshStrategy.SKIP;
                    if (refreshStrategy != UIRefreshStrategy.SKIP || (routeTarget = (registry = ui.getInternals().getRouter().getRegistry()).getNavigationRouteTarget(currentPath = ui.getActiveViewLocation().getPath()).getRouteTarget()) == null) break block6;
                    if (!redefined) break block7;
                    if (routeTarget.getParentLayouts().stream().anyMatch(changedClasses::contains)) break block8;
                }
                if (!RouteUtil.isAutolayoutEnabled((Class)routeTarget.getTarget(), (String)currentPath) || !registry.hasLayout(currentPath)) break block6;
                if (!RouteUtil.collectRouteParentLayouts((Class)registry.getLayout(currentPath)).stream().anyMatch(changedClasses::contains)) break block6;
            }
            refreshStrategy = UIRefreshStrategy.PUSH_REFRESH_CHAIN;
        }
        if (refreshStrategy != UIRefreshStrategy.SKIP && !pushEnabled) {
            refreshStrategy = UIRefreshStrategy.REFRESH;
        }
        return refreshStrategy;
    }

    private static UIRefreshStrategy computeRefreshStrategyForUITree(UI ui, Set<Class<?>> changedClasses, List<HasElement> targetsChain, HasElement route) {
        UIRefreshStrategy refreshStrategy = UIRefreshStrategy.SKIP;
        LinkedList stack = new LinkedList();
        ui.getChildren().forEach(stack::add);
        while (!stack.isEmpty()) {
            Component child = (Component)stack.removeFirst();
            if (changedClasses.stream().anyMatch(clazz -> clazz.isAssignableFrom(child.getClass()))) {
                Component parent = child.getParent().orElse(null);
                while (parent != null) {
                    if (!targetsChain.contains(parent)) {
                        parent = parent.getParent().orElse(null);
                        continue;
                    }
                    if (parent == route) {
                        refreshStrategy = UIRefreshStrategy.PUSH_REFRESH_ROUTE;
                        parent = null;
                        continue;
                    }
                    refreshStrategy = UIRefreshStrategy.PUSH_REFRESH_CHAIN;
                    parent = null;
                    stack.clear();
                }
                continue;
            }
            child.getChildren().forEach(stack::add);
        }
        return refreshStrategy;
    }

    private void triggerClientUpdate(EnumMap<UIRefreshStrategy, List<UI>> uisToRefresh, boolean forceReload) {
        boolean refreshRequested;
        boolean bl = refreshRequested = !forceReload && uisToRefresh.containsKey((Object)UIRefreshStrategy.REFRESH);
        if (forceReload || refreshRequested) {
            if (this.liveReload == null) {
                LOGGER.debug("A change to one or more classes requires a browser page reload, but BrowserLiveReload is not available. Please reload the browser page manually to make changes effective.");
            } else if (forceReload) {
                LOGGER.debug("Triggering browser live reload because of classes changes");
                this.liveReload.reload();
            } else {
                LOGGER.debug("Triggering browser live refresh because of classes changes");
                this.liveReload.refresh(true);
            }
        } else {
            LOGGER.debug("Triggering re-navigation to current route for UIs affected by classes changes.");
            for (UIRefreshStrategy action : uisToRefresh.keySet()) {
                String triggerEventJS = String.format("window.dispatchEvent(new CustomEvent(\"vaadin-refresh-ui\", { detail: { fullRefresh: %s }}));", action == UIRefreshStrategy.PUSH_REFRESH_CHAIN);
                uisToRefresh.get((Object)action).forEach(ui -> ui.access((Command & Serializable)() -> ui.getPage().executeJs(triggerEventJS, new Object[0])));
            }
        }
    }

    private static Class<?> resolveClass(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.debug("Cannot resolve class {}", (Object)className, (Object)e);
            return null;
        }
    }

    public void sessionInit(SessionInitEvent event) throws ServiceException {
        this.sessions.add(event.getSession());
    }

    public void sessionDestroy(SessionDestroyEvent event) {
        this.sessions.remove(event.getSession());
    }

    public void serviceDestroy(ServiceDestroyEvent event) {
        this.serviceDestroyed = true;
        this.sessions.clear();
    }

    public void uiInit(UIInitEvent event) {
        UI ui = event.getUI();
        this.sessions.add(ui.getSession());
        ui.getPage().executeJs("const $wnd = window;\nwindow.addEventListener('vaadin-refresh-ui', (ev) => {\n    const senderFn = $wnd.Vaadin?.Flow?.clients[$0]?.sendEventMessage;\n    if (senderFn) {\n        senderFn(1, \"ui-refresh\", ev.detail);\n    }\n});\n", new Object[]{ui.getInternals().getAppId()});
    }

    public static Optional<Hotswapper> register(VaadinService vaadinService) {
        if (!vaadinService.getDeploymentConfiguration().isProductionMode()) {
            Hotswapper hotswapper = new Hotswapper(vaadinService);
            vaadinService.addUIInitListener((UIInitListener)hotswapper);
            vaadinService.addSessionInitListener((SessionInitListener)hotswapper);
            vaadinService.addSessionDestroyListener((SessionDestroyListener)hotswapper);
            vaadinService.addServiceDestroyListener((ServiceDestroyListener)hotswapper);
            return Optional.of(hotswapper);
        }
        return Optional.empty();
    }

    public static void forcePageReload(VaadinService vaadinService, boolean forceReload) {
        Objects.requireNonNull(vaadinService, "VaadinService cannot be null");
        Hotswapper.getForceReloadHolder(vaadinService).activate(forceReload);
    }

    public static boolean isForcedPageReload(VaadinService vaadinService) {
        return Hotswapper.getForceReloadHolder(vaadinService).isActive();
    }

    private static ForcePageReloadHolder getForceReloadHolder(VaadinService vaadinService) {
        return (ForcePageReloadHolder)vaadinService.getContext().getAttribute(ForcePageReloadHolder.class, ForcePageReloadHolder::new);
    }

    private static enum UIRefreshStrategy {
        RELOAD,
        REFRESH,
        PUSH_REFRESH_ROUTE,
        PUSH_REFRESH_CHAIN,
        SKIP;

    }

    private static class ForcePageReloadHolder
    implements Serializable {
        private final AtomicBoolean forceReload = new AtomicBoolean(false);

        private ForcePageReloadHolder() {
        }

        void activate(boolean active) {
            this.forceReload.set(active);
        }

        boolean isActive() {
            return this.forceReload.get();
        }

        boolean shouldReloadPage() {
            return this.forceReload.get() || Boolean.getBoolean(Hotswapper.FORCE_RELOAD_PROPERTY);
        }
    }
}

