/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.FileWatcher;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.CssBundler;
import com.vaadin.flow.internal.ThemeUtils;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;

public class ThemeLiveUpdater
implements Closeable {
    private FileWatcher watcher;

    public ThemeLiveUpdater(File themeFolder, VaadinContext context) {
        String themeName = themeFolder.getName();
        File stylesCss = new File(themeFolder, "styles.css");
        JsonNode themeJson = ThemeUtils.getThemeJson((String)themeName, (AbstractConfiguration)ApplicationConfiguration.get((VaadinContext)context)).orElse(null);
        Optional liveReload = BrowserLiveReloadAccessor.getLiveReloadFromContext((VaadinContext)context);
        if (liveReload.isPresent()) {
            try {
                this.watcher = new FileWatcher((SerializableConsumer<File>)(SerializableConsumer & Serializable)file -> {
                    if (file.getName().endsWith(".css")) {
                        try {
                            ((BrowserLiveReload)liveReload.get()).update(ThemeUtils.getThemeFilePath((String)themeName, (String)"styles.css"), CssBundler.inlineImportsForThemes((File)stylesCss.getParentFile(), (File)stylesCss, (JsonNode)themeJson));
                        }
                        catch (IOException e) {
                            this.getLogger().error("Unable to perform hot update of " + String.valueOf(file), (Throwable)e);
                            ((BrowserLiveReload)liveReload.get()).reload();
                        }
                    } else {
                        ((BrowserLiveReload)liveReload.get()).reload();
                    }
                }, themeFolder);
                this.watcher.start();
                this.getLogger().debug("Watching {} for theme changes", (Object)themeFolder);
            }
            catch (IOException e) {
                this.getLogger().error("Unable to watch {} for theme changes", (Object)themeFolder, (Object)e);
            }
        } else {
            this.getLogger().error("Browser live reload is not available. Unable to watch {} for theme changes", (Object)themeFolder);
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void close() throws IOException {
        this.watcher.stop();
        this.watcher = null;
    }
}

