/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.FileWatcher;
import com.vaadin.base.devserver.PublicStyleSheetBundler;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.ActiveStyleSheetTracker;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicResourcesLiveUpdater
implements Closeable {
    private static final Pattern THEME_URLS_PATTERN = Pattern.compile("^(.*/)?(lumo|aura)/.+\\.css$");
    private final List<FileWatcher> watchers = new ArrayList<FileWatcher>();
    private final List<File> roots = new ArrayList<File>();
    private final VaadinContext context;
    private final PublicStyleSheetBundler bundler;

    public PublicResourcesLiveUpdater(List<String> roots, VaadinContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        this.context = context;
        Optional liveReload = BrowserLiveReloadAccessor.getLiveReloadFromContext((VaadinContext)context);
        for (String string : roots) {
            File rootLocation = new File(string);
            if (!rootLocation.exists() || !rootLocation.isDirectory()) continue;
            this.roots.add(rootLocation);
        }
        this.bundler = PublicStyleSheetBundler.forResourceLocations(this.roots);
        if (liveReload.isEmpty()) {
            this.getLogger().error("Browser live reload is not available. Unable to watch public resources for changes");
            return;
        }
        try {
            for (File file : this.roots) {
                FileWatcher watcher = this.getFileWatcher(file, (BrowserLiveReload)liveReload.get());
                this.watchers.add(watcher);
                this.getLogger().debug("Watching {} for public CSS changes", (Object)file);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to watch public resources for changes under {}", this.roots, (Object)e);
        }
    }

    private FileWatcher getFileWatcher(File root, BrowserLiveReload liveReload) throws IOException {
        FileWatcher watcher = new FileWatcher((SerializableConsumer<File>)(SerializableConsumer & Serializable)file -> {
            if (file.isDirectory()) {
                return;
            }
            if (this.isTempFile((File)file)) {
                return;
            }
            if (!file.getName().endsWith(".css")) {
                return;
            }
            try {
                Set activeUrls = ActiveStyleSheetTracker.get((VaadinContext)this.context).getActiveUrls();
                if (activeUrls.isEmpty()) {
                    return;
                }
                for (String url : activeUrls) {
                    if (this.isVaadinThemeUrl(url) || this.isExternalUrl(url)) continue;
                    String normalized = PublicStyleSheetBundler.normalizeUrl(url);
                    String contextPath = this.getContextPath();
                    String content = this.bundler.bundle(url, contextPath).orElse(null);
                    String path = "context://" + normalized;
                    liveReload.update(path, content);
                    this.getLogger().debug("Pushed bundled stylesheet update for {}", (Object)path);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Unable to perform hot update for CSS change under root {}, fall back to page reload", (Object)root, (Object)e);
                try {
                    liveReload.reload();
                }
                catch (Exception ignore) {
                    this.getLogger().error("Failed to reload resource changes", (Throwable)e);
                }
            }
        }, root);
        watcher.start();
        return watcher;
    }

    private boolean isExternalUrl(String url) {
        if (url.startsWith("context://") || url.startsWith("base://")) {
            return false;
        }
        try {
            return URI.create(url).isAbsolute();
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    private boolean isVaadinThemeUrl(String url) {
        url = FrontendUtils.getUnixPath((Path)new File(url).toPath());
        return THEME_URLS_PATTERN.matcher(url).matches();
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void close() throws IOException {
        for (FileWatcher watcher : this.watchers) {
            try {
                watcher.stop();
            }
            catch (Exception e) {
                this.getLogger().error("Failed to stop watcher {}", (Object)watcher, (Object)e);
            }
        }
        this.watchers.clear();
        this.roots.clear();
    }

    private boolean isTempFile(File file) {
        String name = file.getName();
        return name.startsWith("~") || name.endsWith("~");
    }

    private String getContextPath() {
        String contextPath = "";
        if (this.context instanceof VaadinServletContext) {
            contextPath = ((VaadinServletContext)this.context).getContext().getContextPath();
        }
        return contextPath;
    }
}

