/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.hotswap.impl;

import com.vaadin.base.devserver.hotswap.HotswapClassEvent;
import com.vaadin.base.devserver.hotswap.HotswapClassSessionEvent;
import com.vaadin.base.devserver.hotswap.HotswapCompleteEvent;
import com.vaadin.base.devserver.hotswap.HotswapResourceEvent;
import com.vaadin.base.devserver.hotswap.UIUpdateStrategy;
import com.vaadin.base.devserver.hotswap.VaadinHotswapper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.internal.ActiveStyleSheetTracker;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.CssBundler;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.shared.ui.Dependency;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleSheetHotswapper
implements VaadinHotswapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(StyleSheetHotswapper.class);
    private static final String STYLESHEET_REGISTRY_KEY = Registry.class.getName();
    private final ConcurrentHashMap<String, Set<String>> appShellStylesheets = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> componentStylesheets = new ConcurrentHashMap();

    @Override
    public void onInit(VaadinService vaadinService) {
        AppShellRegistry appShellRegistry = AppShellRegistry.getInstance((VaadinContext)vaadinService.getContext());
        Class appShellClass = appShellRegistry.getShell();
        if (appShellClass != null) {
            this.appShellStylesheets.put(appShellClass.getName(), StyleSheetHotswapper.getStyleSheetUrls(appShellClass));
            this.trackAppShellUrls(vaadinService);
        }
        vaadinService.addUIInitListener((UIInitListener & Serializable)uiInitEvent -> {
            UI ui = uiInitEvent.getUI();
            VaadinSession session = ui.getSession();
            ActiveStyleSheetTracker tracker = ActiveStyleSheetTracker.get((VaadinService)session.getService());
            ui.addAfterNavigationListener((AfterNavigationListener & Serializable)navigationEvent -> {
                UI newUi = navigationEvent.getLocationChangeEvent().getUI();
                LinkedHashSet<String> allUrls = new LinkedHashSet<String>();
                StyleSheetHotswapper.lookupUrlsForComponents((Component)newUi, allUrls, newUi.getSession().getService());
                allUrls.forEach(arg_0 -> ((ActiveStyleSheetTracker)tracker).trackAddForComponent(arg_0));
            });
        });
    }

    @Override
    public void onHotswapComplete(HotswapCompleteEvent event) {
        event.getClasses().stream().filter(AppShellConfigurator.class::isAssignableFrom).forEach(clazz -> this.appShellStylesheets.put(clazz.getName(), StyleSheetHotswapper.getStyleSheetUrls(clazz)));
        this.trackAppShellUrls(event.getService());
    }

    @Override
    public void onClassesChange(HotswapClassEvent event) {
        Set<Class<?>> classes = StyleSheetHotswapper.filterClasses(event);
        if (classes.isEmpty()) {
            return;
        }
        for (Class<?> clazz : classes) {
            if (!Component.class.isAssignableFrom(clazz)) continue;
            List<String> styleSheets = ComponentUtil.getDependencies((VaadinService)event.getVaadinService(), clazz).getStyleSheets().stream().map(StyleSheet::value).toList();
            if (!styleSheets.isEmpty()) {
                this.componentStylesheets.put(clazz.getName(), new LinkedHashSet<String>(styleSheets));
                continue;
            }
            this.componentStylesheets.remove(clazz.getName());
        }
    }

    @Override
    public void onClassesChange(HotswapClassSessionEvent event) {
        Set<Class<?>> classes = StyleSheetHotswapper.filterClasses(event);
        if (classes.isEmpty()) {
            return;
        }
        VaadinSession session = event.getVaadinSession();
        Registry registry = this.getRegistry(session);
        if (!event.isRedefined()) {
            this.getRegistry(session).updateState(classes);
            return;
        }
        for (Class<?> clazz : classes) {
            try {
                this.handleClassChange(event, clazz, registry);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to handle stylesheet changes for class {}", (Object)clazz.getName(), (Object)e);
            }
        }
    }

    private static Set<Class<?>> filterClasses(HotswapClassEvent event) {
        return event.getChangedClasses().stream().filter(clazz -> Component.class.isAssignableFrom((Class<?>)clazz) || AppShellConfigurator.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toSet());
    }

    private void handleClassChange(HotswapClassSessionEvent event, Class<?> clazz, Registry registry) {
        boolean isAppShellConfigurator = AppShellConfigurator.class.isAssignableFrom(clazz);
        boolean isComponent = Component.class.isAssignableFrom(clazz);
        Set<String> currentStylesheets = StyleSheetHotswapper.getStyleSheetUrls(clazz);
        Set<String> previousStylesheets = registry.previousState(clazz);
        if (previousStylesheets == null) {
            previousStylesheets = new LinkedHashSet<String>();
            ConcurrentHashMap<String, Set<String>> initialState = isAppShellConfigurator ? this.appShellStylesheets : this.componentStylesheets;
            Set initialStyles = (Set)initialState.get(clazz.getName());
            if (initialStyles != null) {
                previousStylesheets.addAll(initialStyles);
            }
        }
        LinkedHashSet<String> addedStylesheets = new LinkedHashSet<String>(currentStylesheets);
        addedStylesheets.removeAll(previousStylesheets);
        LinkedHashSet<String> removedStylesheets = new LinkedHashSet<String>(previousStylesheets);
        removedStylesheets.removeAll(currentStylesheets);
        if (addedStylesheets.isEmpty() && removedStylesheets.isEmpty()) {
            return;
        }
        if (isAppShellConfigurator) {
            this.handleAppShellConfiguratorChange(event, clazz, addedStylesheets, removedStylesheets, registry);
        } else if (isComponent) {
            this.handleComponentChange(event, clazz, addedStylesheets, removedStylesheets, registry);
        }
        registry.updateState(clazz, currentStylesheets);
    }

    private void handleAppShellConfiguratorChange(HotswapClassSessionEvent event, Class<?> clazz, Set<String> addedStylesheets, Set<String> removedStylesheets, Registry registry) {
        AppShellRegistry appShellRegistry = AppShellRegistry.getInstance((VaadinContext)event.getVaadinService().getContext());
        Class appShellClass = appShellRegistry.getShell();
        if (appShellClass == null || !appShellClass.getName().equals(clazz.getName())) {
            return;
        }
        LOGGER.debug("Processing AppShellConfigurator stylesheet changes for {}: added={}, removed={}", new Object[]{clazz.getName(), addedStylesheets, removedStylesheets});
        this.updateUIs(event, clazz, addedStylesheets, removedStylesheets, registry);
        Set<String> currentUrls = StyleSheetHotswapper.getStyleSheetUrls(clazz);
        this.appShellStylesheets.put(clazz.getName(), currentUrls);
        this.trackAppShellUrls(event.getVaadinService());
    }

    private void handleComponentChange(HotswapClassSessionEvent event, Class<?> clazz, Set<String> addedStylesheets, Set<String> removedStylesheets, Registry registry) {
        LOGGER.debug("Processing Component stylesheet changes for {}: added={}, removed={}", new Object[]{clazz.getName(), addedStylesheets, removedStylesheets});
        this.updateUIs(event, clazz, addedStylesheets, removedStylesheets, registry);
    }

    private void updateUIs(HotswapClassSessionEvent event, Class<?> clazz, Set<String> addedStylesheets, Set<String> removedStylesheets, Registry registry) {
        boolean isAppShell = AppShellConfigurator.class.isAssignableFrom(clazz);
        VaadinSession session = event.getVaadinSession();
        for (UI ui : session.getUIs()) {
            String normalized;
            Dependency dependency;
            if (ui.isClosing() || !isAppShell && !this.isComponentInUse(ui, clazz)) continue;
            for (String url : removedStylesheets) {
                if (registry.previousState(clazz) == null) {
                    dependency = ui.getInternals().getDependencyList().getDependencyByUrl(url, Dependency.Type.STYLESHEET);
                    if (dependency != null) {
                        ui.getInternals().removeStyleSheet(dependency.getId());
                        ActiveStyleSheetTracker.get((VaadinService)event.getVaadinService()).trackRemoveForComponent(url);
                        normalized = StyleSheetHotswapper.normalizeStylesheetUrl(url);
                        if (normalized != null) {
                            event.updateClientResource("context://" + normalized, "");
                        }
                        event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                    }
                } else {
                    registry.removeRegistration(clazz, url).ifPresent(dependencyId -> {
                        ui.getInternals().removeStyleSheet(dependencyId);
                        ActiveStyleSheetTracker.get((VaadinService)event.getVaadinService()).trackRemoveForComponent(url);
                        String normalized = StyleSheetHotswapper.normalizeStylesheetUrl(url);
                        if (normalized != null) {
                            event.updateClientResource("context://" + normalized, "");
                        }
                        event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                    });
                }
                if (isAppShell) {
                    ui.getInternals().removeStyleSheet("appShell-" + url);
                    event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                }
                LOGGER.debug("Removed stylesheet {} from Component {}", (Object)url, (Object)clazz.getName());
            }
            for (String url : addedStylesheets) {
                try {
                    ui.getPage().addStyleSheet(url);
                    dependency = ui.getInternals().getDependencyList().getDependencyByUrl(url, Dependency.Type.STYLESHEET);
                    registry.addRegistration(clazz, dependency);
                    ActiveStyleSheetTracker.get((VaadinService)event.getVaadinService()).trackAddForComponent(url);
                    normalized = StyleSheetHotswapper.normalizeStylesheetUrl(url);
                    if (normalized != null) {
                        this.tryBundlePublicStylesheet(event, normalized).ifPresent(content -> event.updateClientResource("context://" + normalized, (String)content));
                    }
                    event.triggerUpdate(ui, UIUpdateStrategy.REFRESH);
                    LOGGER.debug("Added stylesheet {} to Component {}", (Object)url, (Object)clazz.getName());
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to add stylesheet {} to Component {}", new Object[]{url, clazz.getName(), e});
                }
            }
        }
    }

    @Override
    public void onResourcesChange(HotswapResourceEvent event) {
    }

    private void trackAppShellUrls(VaadinService vaadinService) {
        ActiveStyleSheetTracker.get((VaadinService)vaadinService).trackForAppShell((Collection)this.appShellStylesheets.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    private boolean isComponentInUse(UI ui, Class<?> componentClass) {
        return ui.getChildren().anyMatch(component -> componentClass.isInstance(component) || this.hasChildOfType((Component)component, componentClass));
    }

    private boolean hasChildOfType(Component component, Class<?> targetClass) {
        if (targetClass.isInstance(component)) {
            return true;
        }
        return component.getChildren().anyMatch(child -> this.hasChildOfType((Component)child, targetClass));
    }

    private static Set<String> getStyleSheetUrls(Class<?> clazz) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        if (Component.class.isAssignableFrom(clazz)) {
            Class<?> componentClass = clazz;
            List annotations = AnnotationReader.getStyleSheetAnnotations(componentClass);
            for (StyleSheet annotation : annotations) {
                String url = annotation.value();
                if (url == null || url.isEmpty()) continue;
                urls.add(url);
            }
        } else {
            StyleSheet[] annotations;
            for (StyleSheet annotation : annotations = (StyleSheet[])clazz.getAnnotationsByType(StyleSheet.class)) {
                String url = annotation.value();
                if (url == null || url.isEmpty()) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private Registry getRegistry(VaadinSession session) {
        Registry registry = (Registry)session.getAttribute(STYLESHEET_REGISTRY_KEY);
        if (registry == null) {
            registry = new Registry();
            session.setAttribute(STYLESHEET_REGISTRY_KEY, (Object)registry);
        }
        return registry;
    }

    private static String normalizeStylesheetUrl(String url) {
        if (url == null || url.isBlank()) {
            return null;
        }
        if ((url = url.trim()).startsWith("context://")) {
            url = url.substring("context://".length());
        }
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if ((url = FrontendUtils.getUnixPath((Path)new File(url).toPath())).startsWith("./")) {
            url = url.substring(2);
        }
        return url;
    }

    private Optional<String> tryBundlePublicStylesheet(HotswapClassSessionEvent event, String normalizedPath) {
        try {
            File projectFolder;
            VaadinService service = event.getVaadinService();
            ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)service.getContext());
            File file = projectFolder = config != null ? config.getProjectFolder() : null;
            if (projectFolder == null) {
                return Optional.empty();
            }
            File resourceFolder = config.getJavaResourceFolder();
            List<File> stylesheets = Stream.concat(Stream.of("META-INF/resources", "resources", "static", "public").map(location -> new File(resourceFolder, (String)location)), Stream.of(new File(projectFolder, "src/main/webapp"))).filter(root -> root.exists() && root.isDirectory()).map(root -> new File((File)root, normalizedPath)).filter(File::exists).filter(File::isFile).toList();
            Iterator iterator = stylesheets.iterator();
            if (iterator.hasNext()) {
                File stylesheet = (File)iterator.next();
                try {
                    String root2 = StyleSheetHotswapper.getResourceRootFromAbsolutePath(normalizedPath, stylesheet);
                    String contextPath = StyleSheetHotswapper.getContextPath(service);
                    String bundled = CssBundler.inlineImportsForPublicResources((File)new File(root2), (File)stylesheet, (String)contextPath);
                    return Optional.ofNullable(bundled);
                }
                catch (IOException ioe) {
                    LOGGER.debug("Failed to inline CSS imports for {}", (Object)stylesheet, (Object)ioe);
                    return Optional.empty();
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error while trying to bundle public stylesheet {}", (Object)normalizedPath, (Object)e);
        }
        return Optional.empty();
    }

    private static String getResourceRootFromAbsolutePath(String normalizedPath, File stylesheet) {
        return stylesheet.getAbsolutePath().substring(0, stylesheet.getAbsolutePath().indexOf(normalizedPath));
    }

    private static String getContextPath(VaadinService service) {
        String contextPath = "";
        if (service.getContext() instanceof VaadinServletContext) {
            contextPath = ((VaadinServletContext)service.getContext()).getContext().getContextPath();
        }
        return contextPath;
    }

    private static void lookupUrlsForComponents(Component root, Set<String> allUrls, VaadinService vaadinService) {
        root.getChildren().forEach(child -> {
            if (child.getClass().isAnnotationPresent(StyleSheet.class)) {
                ComponentUtil.getDependencies((VaadinService)vaadinService, child.getClass()).getStyleSheets().stream().map(StyleSheet::value).forEach(allUrls::add);
            }
            StyleSheetHotswapper.lookupUrlsForComponents(child, allUrls, vaadinService);
        });
    }

    private static class Registry
    implements Serializable {
        private transient Map<String, RegistryEntry> entries = new ConcurrentHashMap<String, RegistryEntry>();

        private Registry() {
        }

        Set<String> previousState(Class<?> clazz) {
            RegistryEntry entry = this.entries.get(clazz.getName());
            if (entry != null) {
                return new LinkedHashSet<String>(entry.previousState);
            }
            return null;
        }

        void updateState(Class<?> clazz, Set<String> stylesheets) {
            this.entries.computeIfAbsent(clazz.getName(), k -> new RegistryEntry()).updateState(stylesheets);
        }

        void updateState(Set<Class<?>> classes) {
            for (Class<?> clazz : classes) {
                Set<String> stylesheets = StyleSheetHotswapper.getStyleSheetUrls(clazz);
                if (stylesheets.isEmpty()) continue;
                this.updateState(clazz, stylesheets);
            }
        }

        Optional<String> removeRegistration(Class<?> clazz, String url) {
            return Optional.ofNullable(this.entries.get(clazz.getName())).flatMap(entry -> entry.removeRegistration(url));
        }

        void addRegistration(Class<?> clazz, Dependency dependency) {
            this.entries.computeIfAbsent(clazz.getName(), k -> new RegistryEntry()).addRegistration(dependency);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.entries = new ConcurrentHashMap<String, RegistryEntry>();
        }
    }

    private static class RegistryEntry {
        private final Map<String, String> registrations = new LinkedHashMap<String, String>();
        private final Set<String> previousState = new LinkedHashSet<String>();

        private RegistryEntry() {
        }

        void updateState(Set<String> stylesheets) {
            this.previousState.clear();
            this.previousState.addAll(stylesheets);
        }

        Optional<String> removeRegistration(String url) {
            return Optional.ofNullable(this.registrations.remove(url));
        }

        void addRegistration(Dependency dependency) {
            if (dependency != null) {
                this.registrations.put(dependency.getUrl(), dependency.getId());
            }
        }
    }
}

