/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.AbstractDevServerRunner;
import com.vaadin.base.devserver.BrowserLauncher;
import com.vaadin.base.devserver.DevBundleBuildingHandler;
import com.vaadin.base.devserver.ExternalDependencyWatcher;
import com.vaadin.base.devserver.NamedDaemonThreadFactory;
import com.vaadin.base.devserver.PublicResourcesLiveUpdater;
import com.vaadin.base.devserver.ThemeLiveUpdater;
import com.vaadin.base.devserver.startup.DevModeInitializer;
import com.vaadin.base.devserver.startup.DevModeStartupListener;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.ThemeUtils;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeHandlerManagerImpl
implements DevModeHandlerManager {
    private DevModeHandler devModeHandler;
    private BrowserLauncher browserLauncher;
    private final Set<Command> shutdownCommands = new HashSet<Command>();
    private ExecutorService executorService;
    private String applicationUrl;
    private boolean fullyStarted = false;

    public Class<?>[] getHandlesTypes() {
        return DevModeStartupListener.class.getAnnotation(HandlesTypes.class).value();
    }

    public void setDevModeHandler(DevModeHandler devModeHandler) {
        if (this.devModeHandler != null) {
            throw new IllegalStateException("Unable to initialize dev mode handler. A handler is already present: " + String.valueOf(this.devModeHandler));
        }
        this.devModeHandler = devModeHandler;
    }

    public DevModeHandler getDevModeHandler() {
        return this.devModeHandler;
    }

    public void initDevModeHandler(Set<Class<?>> classes, VaadinContext context) throws VaadinInitializerException {
        this.shutdownExecutorService();
        this.executorService = Executors.newFixedThreadPool(4, new NamedDaemonThreadFactory("vaadin-dev-server"));
        this.setDevModeHandler(DevModeInitializer.initDevModeHandler(classes, context, this.executorService));
        CompletableFuture.runAsync(() -> {
            DevModeHandler devModeHandler = this.getDevModeHandler();
            if (devModeHandler instanceof AbstractDevServerRunner) {
                ((AbstractDevServerRunner)devModeHandler).waitForDevServer();
            } else if (devModeHandler instanceof DevBundleBuildingHandler) {
                DevBundleBuildingHandler devBundleBuilder = (DevBundleBuildingHandler)devModeHandler;
                devBundleBuilder.waitForDevBundle();
            }
            ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)context);
            this.startWatchingThemeFolder(context, config);
            this.startWatchingPublicResourcesFolders(context, config);
            this.watchExternalDependencies(context, config);
            this.setFullyStarted(true);
        }, this.executorService);
        this.setDevModeStarted(context);
        this.browserLauncher = new BrowserLauncher(context);
    }

    private void shutdownExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private void watchExternalDependencies(VaadinContext context, ApplicationConfiguration config) {
        File frontendFolder = FrontendUtils.getProjectFrontendDir((AbstractConfiguration)config);
        File jarFrontendResourcesFolder = FrontendUtils.getJarResourcesFolder((File)frontendFolder);
        this.registerWatcherShutdownCommand(new ExternalDependencyWatcher(context, jarFrontendResourcesFolder));
    }

    private void startWatchingThemeFolder(VaadinContext context, ApplicationConfiguration config) {
        if (config.getMode() != Mode.DEVELOPMENT_BUNDLE) {
            return;
        }
        try {
            Optional maybeThemeName = ThemeUtils.getThemeName((VaadinContext)context);
            if (maybeThemeName.isEmpty()) {
                DevModeHandlerManagerImpl.getLogger().debug("Found no custom theme in the project. Skipping watching the theme files");
                return;
            }
            List activeThemes = ThemeUtils.getActiveThemes((VaadinContext)context);
            for (String themeName : activeThemes) {
                File themeFolder = ThemeUtils.getThemeFolder((File)FrontendUtils.getProjectFrontendDir((AbstractConfiguration)config), (String)themeName);
                this.registerWatcherShutdownCommand(new ThemeLiveUpdater(themeFolder, context));
            }
        }
        catch (Exception e) {
            DevModeHandlerManagerImpl.getLogger().error("Failed to start live-reload for theme files", (Throwable)e);
        }
    }

    void startWatchingPublicResourcesFolders(VaadinContext context, ApplicationConfiguration config) {
        try {
            File projectFolder = config.getProjectFolder();
            File resourceFolder = config.getJavaResourceFolder();
            List<String> locations = Stream.concat(Stream.of("META-INF/resources", "resources", "static", "public").map(location -> new File(resourceFolder, (String)location)), Stream.of(new File(projectFolder, "src/main/webapp"))).filter(root -> root.exists() && root.isDirectory()).filter(File::exists).map(staticResourceFolder -> FrontendUtils.getUnixPath((Path)staticResourceFolder.toPath())).toList();
            this.registerWatcherShutdownCommand(new PublicResourcesLiveUpdater(locations, context));
        }
        catch (Exception e) {
            DevModeHandlerManagerImpl.getLogger().error("Failed to start live-reload for public CSS resources", (Throwable)e);
        }
    }

    public void stopDevModeHandler() {
        if (this.devModeHandler != null) {
            this.devModeHandler.stop();
            this.devModeHandler = null;
        }
        this.shutdownExecutorService();
        for (Command shutdownCommand : this.shutdownCommands) {
            try {
                shutdownCommand.execute();
            }
            catch (Exception e) {
                DevModeHandlerManagerImpl.getLogger().error("Failed to execute shut down command {}", (Object)shutdownCommand.getClass().getName(), (Object)e);
            }
        }
        this.shutdownCommands.clear();
    }

    public void launchBrowserInDevelopmentMode(String url) {
        this.browserLauncher.launchBrowserInDevelopmentMode(url);
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
        this.reportApplicationUrl();
    }

    private void setFullyStarted(boolean fullyStarted) {
        this.fullyStarted = fullyStarted;
        this.reportApplicationUrl();
    }

    private void reportApplicationUrl() {
        if (this.fullyStarted && this.applicationUrl != null) {
            DevModeHandlerManagerImpl.getLogger().info("Application running at {}", (Object)this.applicationUrl);
        }
    }

    private void setDevModeStarted(VaadinContext context) {
        context.setAttribute(DevModeHandlerAlreadyStartedAttribute.class, (Object)new DevModeHandlerAlreadyStartedAttribute());
    }

    private void registerWatcherShutdownCommand(Closeable watcher) {
        this.registerShutdownCommand((Command & Serializable)() -> {
            try {
                watcher.close();
            }
            catch (Exception e) {
                DevModeHandlerManagerImpl.getLogger().error("Failed to stop watcher {}", (Object)watcher.getClass().getName(), (Object)e);
            }
        });
    }

    public void registerShutdownCommand(Command command) {
        this.shutdownCommands.add(command);
    }

    public static boolean isDevModeAlreadyStarted(VaadinContext context) {
        assert (context != null);
        return context.getAttribute(DevModeHandlerAlreadyStartedAttribute.class) != null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeHandlerManagerImpl.class);
    }

    private static final class DevModeHandlerAlreadyStartedAttribute
    implements Serializable {
        private DevModeHandlerAlreadyStartedAttribute() {
        }
    }
}

