/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedDaemonThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public NamedDaemonThreadFactory(String namePrefix) {
        this.namePrefix = Objects.requireNonNull(namePrefix, "namePrefix must not be null");
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String threadName = this.namePrefix + "-" + this.threadNumber.getAndIncrement();
        Thread thread = new Thread(runnable, threadName);
        thread.setDaemon(true);
        thread.setPriority(5);
        return thread;
    }
}

