/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.FileWatcher;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.server.VaadinContext;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PublicResourcesCssLiveUpdater
implements Closeable {
    private final File resourcesFolder;
    private final VaadinContext context;
    private FileWatcher watcher;

    PublicResourcesCssLiveUpdater(File resourcesFolder, VaadinContext context) throws IOException {
        this.resourcesFolder = resourcesFolder;
        this.context = context;
        this.initWatcher();
    }

    private void initWatcher() throws IOException {
        if (this.resourcesFolder == null || !this.resourcesFolder.isDirectory()) {
            this.getLogger().debug("Public resources folder {} not found, skipping watcher", (Object)this.resourcesFolder);
            return;
        }
        Optional liveReloadOpt = BrowserLiveReloadAccessor.getLiveReloadFromContext((VaadinContext)this.context);
        if (liveReloadOpt.isEmpty()) {
            this.getLogger().debug("Browser live reload not available, skipping public resources watcher");
            return;
        }
        BrowserLiveReload liveReload = (BrowserLiveReload)liveReloadOpt.get();
        this.watcher = new FileWatcher((SerializableConsumer<File>)(SerializableConsumer & Serializable)changed -> {
            try {
                if (changed.isFile() && changed.getName().endsWith(".css")) {
                    String rel = this.resourcesFolder.toPath().relativize(changed.toPath()).toString().replace(File.separatorChar, '/');
                    String browserPath = "/" + rel;
                    String contents = Files.readString(changed.toPath(), StandardCharsets.UTF_8);
                    liveReload.update(browserPath, contents);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Unable to perform hot update of public resource CSS " + String.valueOf(changed), (Throwable)e);
                try {
                    liveReload.reload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, this.resourcesFolder);
        this.watcher.start();
        this.getLogger().debug("Watching {} for public CSS changes", (Object)this.resourcesFolder);
    }

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            this.watcher.stop();
            this.watcher = null;
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

