/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.JsonHelpers;
import com.vaadin.base.devserver.stats.StatisticsContainer;
import com.vaadin.base.devserver.stats.StatisticsStorage;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class StatisticsSender {
    private static final String FAILED_TO_READ = "Failed to read ";
    private StatisticsStorage storage;

    public StatisticsSender(StatisticsStorage storage) {
        this.storage = storage;
    }

    public String getReportingUrl() {
        return "https://tools.vaadin.com/usage-stats/v2/submit";
    }

    String getLastServerMessage(ObjectNode json) {
        return json.has("serverMessage") ? json.get("serverMessage").asText() : null;
    }

    boolean isIntervalElapsed(ObjectNode json) {
        long interval;
        long now = System.currentTimeMillis();
        long lastSend = this.getLastSendTime(json);
        return lastSend + (interval = this.getInterval(json)) * 1000L < now;
    }

    long getInterval(ObjectNode json) {
        try {
            long interval = json.get("reportInterval").asLong();
            return StatisticsSender.normalizeInterval(interval);
        }
        catch (Exception e) {
            StatisticsSender.getLogger().debug("Failed to read reportInterval", (Throwable)e);
            return 86400L;
        }
    }

    private static long normalizeInterval(long intervalSec) {
        if (intervalSec < 43200L) {
            return 43200L;
        }
        return Math.min(intervalSec, 2592000L);
    }

    long getLastSendTime(ObjectNode json) {
        try {
            return json.get("lastSent").asLong();
        }
        catch (Exception e) {
            StatisticsSender.getLogger().debug("Failed to read lastSent", (Throwable)e);
            return -1L;
        }
    }

    String getLastSendStatus(ObjectNode json) {
        try {
            return json.get("lastSendStatus").asText();
        }
        catch (Exception e) {
            StatisticsSender.getLogger().debug("Failed to read lastSendStatus", (Throwable)e);
            return null;
        }
    }

    public void triggerSendIfNeeded(ObjectNode json) {
        if (this.isIntervalElapsed(json)) {
            CompletableFuture.runAsync(() -> {
                String message = this.sendStatistics(json);
                if (message != null && !message.trim().isEmpty()) {
                    DevModeUsageStatistics.getLogger().info(message);
                }
            });
        }
    }

    String sendStatistics(ObjectNode json) {
        String stringData;
        AtomicReference<Object> message = new AtomicReference<Object>(null);
        try {
            stringData = JsonHelpers.getJsonMapper().writeValueAsString((Object)json);
        }
        catch (JacksonException e) {
            StatisticsSender.getLogger().debug("Error converting statistics to a string", (Throwable)e);
            return null;
        }
        ObjectNode response = StatisticsSender.postData(this.getReportingUrl(), stringData);
        if (response.isObject() && response.has("lastSendStatus")) {
            this.storage.update((arg_0, arg_1) -> StatisticsSender.lambda$sendStatistics$1((JsonNode)response, message, arg_0, arg_1));
            if (response.get("lastSendStatus").asText().startsWith("200:")) {
                this.storage.clearAllProjectData();
            }
        }
        return message.get();
    }

    private static ObjectNode postData(String postUrl, String data) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(postUrl)).POST(HttpRequest.BodyPublishers.ofString(data)).header("Content-Type", "application/json").build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            JsonNode jsonResponse = null;
            if (statusCode == 200) {
                jsonResponse = JsonHelpers.getJsonMapper().readTree(response.body());
            }
            ObjectNode result = jsonResponse != null && jsonResponse.isObject() ? (ObjectNode)jsonResponse : JsonHelpers.getJsonMapper().createObjectNode();
            result.put("lastSendStatus", statusCode + ": ");
            return result;
        }
        catch (IOException ex) {
            StatisticsSender.getLogger().debug("Failed to send statistics.", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            StatisticsSender.getLogger().debug("Failed to send statistics.", (Throwable)ex);
        }
        ObjectNode result = JsonHelpers.getJsonMapper().createObjectNode();
        result.put("lastSendStatus", "Invalid server response.");
        return result;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(StatisticsSender.class);
    }

    private static /* synthetic */ void lambda$sendStatistics$1(JsonNode response, AtomicReference message, StatisticsContainer global, StatisticsContainer project) {
        global.setValue("lastSent", System.currentTimeMillis());
        global.setValue("lastSendStatus", response.get("lastSendStatus").asText());
        if (response.has("reportInterval") && response.get("reportInterval").isNumber()) {
            global.setValue("reportInterval", StatisticsSender.normalizeInterval(response.get("reportInterval").asLong()));
        } else {
            global.setValue("reportInterval", 86400L);
        }
        if (response.has("serverMessage") && response.get("serverMessage").isTextual()) {
            String msg = response.get("serverMessage").asText();
            global.setValue("serverMessage", msg);
            message.set(msg);
        }
    }
}

