/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.JsonHelpers;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ObjectNode;

class UserKey {
    private static final String FIELD_KEY = "key";
    private final String key;

    UserKey(String key) {
        this.key = key;
    }

    UserKey(File keyFile) {
        String keyFromFile = null;
        try {
            JsonNode value = JsonHelpers.getJsonMapper().readTree(keyFile);
            keyFromFile = value.get(FIELD_KEY).asText();
        }
        catch (Exception e) {
            UserKey.getLogger().debug("Unable to read UserKey", (Throwable)e);
        }
        this.key = keyFromFile;
    }

    public String getKey() {
        return this.key;
    }

    void toFile(File fileLocation) throws IOException {
        ObjectMapper jsonMapper = JsonHelpers.getJsonMapper();
        ObjectNode value = jsonMapper.createObjectNode();
        value.put(FIELD_KEY, this.key);
        fileLocation.getParentFile().mkdirs();
        jsonMapper.writeValue(fileLocation, (Object)value);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DevModeUsageStatistics.class.getName());
    }
}

