/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

class JsonHelpers {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    private JsonHelpers() {
    }

    static ObjectNode getOrCreate(String id, JsonNode arrayNode, String idField, boolean createNew) {
        if (arrayNode == null || !arrayNode.isArray()) {
            return null;
        }
        for (JsonNode p : arrayNode) {
            if (p == null || !p.has(idField) || !id.equals(p.get(idField).asText())) continue;
            return (ObjectNode)p;
        }
        if (createNew) {
            JsonNode p;
            ArrayNode newNode = (ArrayNode)arrayNode;
            p = newNode.addObject();
            p.put("id", id);
            return p;
        }
        return null;
    }

    static void incrementJsonValue(ObjectNode node, String fieldName) {
        if (node.has(fieldName)) {
            JsonNode f = node.get(fieldName);
            node.put(fieldName, f.asInt() + 1);
        } else {
            node.put(fieldName, 1);
        }
    }

    static ObjectMapper getJsonMapper() {
        return jsonMapper;
    }
}

