/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.server.frontend.CssBundler;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublicStyleSheetBundler {
    private final List<File> sourceRoots;

    private PublicStyleSheetBundler(List<File> sourceRoots) {
        this.sourceRoots = sourceRoots;
    }

    public static PublicStyleSheetBundler forResourceLocations(List<File> roots) {
        Objects.requireNonNull(roots, "roots cannot be null");
        return new PublicStyleSheetBundler(roots);
    }

    public Optional<String> bundle(String url, String contextPath) {
        if (url == null || url.isBlank()) {
            return Optional.empty();
        }
        String normalized = PublicStyleSheetBundler.normalizeUrl(url);
        for (File root : this.sourceRoots) {
            File entry = new File(root, normalized);
            if (!entry.exists() || !entry.isFile()) continue;
            try {
                String bundled = CssBundler.inlineImportsForPublicResources((File)root, (File)entry, (String)contextPath);
                return Optional.ofNullable(bundled);
            }
            catch (IOException e) {
                PublicStyleSheetBundler.getLogger().debug("Failed to inline CSS imports for {} in root {}", new Object[]{entry, root, e});
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static String normalizeUrl(String url) {
        if ((url = url.trim()).startsWith("context://")) {
            url = url.substring("context://".length());
        }
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if ((url = FrontendUtils.getUnixPath((Path)new File(url).toPath())).startsWith("./")) {
            url = url.substring(2);
        }
        return url;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(PublicStyleSheetBundler.class);
    }
}

