/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.vaadin.base.devserver.MavenUtils;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.ProKey;
import com.vaadin.base.devserver.stats.UserKey;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectHelpers {
    private ProjectHelpers() {
    }

    static String generateProjectId(File projectFolder) {
        Document pom = MavenUtils.parsePomFileFromFolder(projectFolder);
        if (pom != null) {
            String groupId = MavenUtils.getGroupId(pom);
            String artifactId = MavenUtils.getArtifactId(pom);
            return "pom" + ProjectHelpers.createHash(groupId + artifactId);
        }
        File gradleFile = new File(projectFolder, "settings.gradle");
        if (gradleFile.exists()) {
            String string;
            block11: {
                Stream<String> stream = Files.lines(gradleFile.toPath());
                try {
                    String projectName = stream.filter(line -> line.contains("rootProject.name")).findFirst().orElse("default-project-id");
                    if (projectName.contains("=")) {
                        projectName = projectName.substring(projectName.indexOf("=") + 1).replace('\'', ' ').trim();
                    }
                    string = "gradle" + ProjectHelpers.createHash(projectName);
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ProjectHelpers.getLogger().debug("Failed to parse gradle project id from " + gradleFile.getPath(), (Throwable)e);
                    }
                }
                stream.close();
            }
            return string;
        }
        return ProjectHelpers.createHash("default-project-id");
    }

    static String createHash(String string) {
        if (string != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(string.getBytes(StandardCharsets.UTF_8));
                byte[] digest = md.digest();
                return ProjectHelpers.toHexString(digest);
            }
            catch (Exception e) {
                ProjectHelpers.getLogger().debug("Missing hash algorithm", (Throwable)e);
            }
        }
        return "[NA]";
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    static String getProjectSource(File projectFolder) {
        try {
            String projectSource = ProjectHelpers.getMavenProjectSource(projectFolder);
            if (projectSource != null) {
                return projectSource;
            }
            projectSource = ProjectHelpers.getGradleProjectSource(projectFolder);
            if (projectSource != null) {
                return projectSource;
            }
        }
        catch (Exception e) {
            ProjectHelpers.getLogger().debug("Failed to parse project id from " + projectFolder.toPath().toAbsolutePath(), (Throwable)e);
        }
        return "[NA]";
    }

    private static String getMavenProjectSource(File projectFolder) throws ParserConfigurationException, SAXException, IOException {
        Document pom = MavenUtils.parsePomFileFromFolder(projectFolder);
        if (pom == null) {
            return null;
        }
        NodeList nodeList = pom.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String comment;
            String projectSource;
            if (nodeList.item(i).getNodeType() != 8 || (projectSource = ProjectHelpers.findProjectSource(comment = nodeList.item(i).getTextContent())) == null) continue;
            return projectSource;
        }
        return null;
    }

    private static String findProjectSource(String comment) {
        if (comment == null) {
            return null;
        }
        if (comment.contains("Vaadin project from")) {
            return comment.substring(comment.indexOf("Vaadin project from") + "Vaadin project from".length()).trim();
        }
        if (comment.contains("Project from")) {
            return comment.substring(comment.indexOf("Project from") + "Project from".length()).trim();
        }
        return null;
    }

    private static String getGradleProjectSource(File projectFolder) throws IOException {
        File gradleFile = new File(projectFolder, "settings.gradle");
        if (gradleFile.exists()) {
            try (Stream<String> stream = Files.lines(gradleFile.toPath());){
                String comment = stream.filter(line -> line.contains("Vaadin project from") || line.contains("Project from")).findFirst().orElse(null);
                String projectSource = ProjectHelpers.findProjectSource(comment);
                if (projectSource != null) {
                    String string = projectSource;
                    return string;
                }
            }
        }
        return null;
    }

    public static File resolveVaadinHomeDirectory() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".vaadin");
    }

    static File resolveStatisticsStore() {
        File vaadinHome;
        try {
            vaadinHome = ProjectHelpers.resolveVaadinHomeDirectory();
        }
        catch (Exception e) {
            ProjectHelpers.getLogger().debug("Failed to find .vaadin directory ", (Throwable)e);
            vaadinHome = null;
        }
        if (vaadinHome == null) {
            try {
                vaadinHome = File.createTempFile(".vaadin", UUID.randomUUID().toString());
                FileUtils.forceMkdir((File)vaadinHome);
            }
            catch (IOException e) {
                ProjectHelpers.getLogger().debug("Failed to create temp directory ", (Throwable)e);
                return null;
            }
        }
        return new File(vaadinHome, "usage-statistics.json");
    }

    static File resolveUserKeyLocation() {
        File vaadinHome = ProjectHelpers.resolveVaadinHomeDirectory();
        return new File(vaadinHome, "userKey");
    }

    static String getProKey() {
        ProKey proKey = ProKey.get();
        return proKey != null ? proKey.getKey() : null;
    }

    public static String getUserKey() {
        File userKeyFile = ProjectHelpers.resolveUserKeyLocation();
        UserKey localKey = new UserKey(userKeyFile);
        if (localKey.getKey() != null) {
            return localKey.getKey();
        }
        localKey = new UserKey("user-" + UUID.randomUUID());
        try {
            localKey.toFile(userKeyFile);
            return localKey.getKey();
        }
        catch (IOException e) {
            ProjectHelpers.getLogger().debug("Failed to write generated userKey", (Throwable)e);
            return null;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DevModeUsageStatistics.class.getName());
    }
}

