/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.open.Open;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLauncher {
    private static final String LAUNCH_TRACKER = "LaunchUtil.hasLaunched";
    private static final String LAUNCHED_VALUE = "yes";
    private VaadinContext context;

    public BrowserLauncher(VaadinContext context) {
        this.context = context;
    }

    public void launchBrowserInDevelopmentMode(String url) {
        if (this.isLaunched()) {
            return;
        }
        if (!this.isProductionMode()) {
            String outputOnFailure = "Application started at " + url;
            if (!Open.open((String)url)) {
                this.getLogger().info(outputOnFailure);
            }
            this.setLaunched();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private boolean isProductionMode() {
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)this.context);
        return applicationConfiguration.isProductionMode();
    }

    private boolean isLaunched() {
        File launchFile = this.getLaunchFile();
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)this.context);
        int lastModifiedDelay = Integer.parseInt(applicationConfiguration.getStringProperty("launch-browser-delay", "30"));
        if (launchFile.exists() && TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - launchFile.lastModified()) < (long)lastModifiedDelay) {
            this.writeLaunchFile(launchFile);
            return true;
        }
        return LAUNCHED_VALUE.equals(System.getProperty(LAUNCH_TRACKER));
    }

    private void writeLaunchFile(File launchFile) {
        try {
            Files.writeString(launchFile.toPath(), (CharSequence)Long.toString(System.currentTimeMillis()), new OpenOption[0]);
        }
        catch (IOException e) {
            this.getLogger().debug("Failed to write browser launched file.", (Throwable)e);
        }
    }

    private File getLaunchFile() {
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)this.context);
        File buildFolder = new File(applicationConfiguration.getProjectFolder(), applicationConfiguration.getBuildFolder());
        return new File(buildFolder, "tab.launch");
    }

    private void setLaunched() {
        this.writeLaunchFile(this.getLaunchFile());
        System.setProperty(LAUNCH_TRACKER, LAUNCHED_VALUE);
    }
}

