/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.startup;

import com.vaadin.base.devserver.ViteHandler;
import com.vaadin.base.devserver.WebpackHandler;
import com.vaadin.base.devserver.startup.DevModeStartupListener;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.StatisticsSender;
import com.vaadin.base.devserver.stats.StatisticsStorage;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.frontend.EndpointGeneratorTaskFactory;
import com.vaadin.flow.server.frontend.FallbackChunk;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import com.vaadin.pro.licensechecker.LicenseChecker;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.annotation.HandlesTypes;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeInitializer
implements Serializable {
    private static final Pattern JAR_FILE_REGEX = Pattern.compile(".*file:(.+\\.jar).*");
    private static final Pattern ZIP_PROTOCOL_JAR_FILE_REGEX = Pattern.compile("(.+\\.jar).*");
    private static final Pattern VFS_FILE_REGEX = Pattern.compile("(vfs:/.+\\.jar).*");
    private static final Pattern VFS_DIRECTORY_REGEX = Pattern.compile("vfs:/.+");
    private static final Pattern DIR_REGEX_FRONTEND_DEFAULT = Pattern.compile("^(?:file:0)?(.+)META-INF/frontend/?$");
    private static final Pattern DIR_REGEX_RESOURCES_JAR_DEFAULT = Pattern.compile("^(?:file:0)?(.+)META-INF/resources/themes//?$");
    private static final Pattern DIR_REGEX_COMPATIBILITY_FRONTEND_DEFAULT = Pattern.compile("^(?:file:)?(.+)META-INF/resources/frontend/?$");

    public static DevModeHandler initDevModeHandler(Set<Class<?>> classes, VaadinContext context) throws VaadinInitializerException {
        ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)context);
        if (config.isProductionMode()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because PRODUCTION MODE is set.");
            return null;
        }
        if (!config.enableDevServer()) {
            DevModeInitializer.log().debug("Skipping DEV MODE because dev server shouldn't be enabled.");
            return null;
        }
        FeatureFlags featureFlags = FeatureFlags.get((VaadinContext)context);
        LicenseChecker.setStrictOffline((!featureFlags.isEnabled(FeatureFlags.OLD_LICENSE_CHECKER) ? 1 : 0) != 0);
        featureFlags.setPropertiesLocation(config.getJavaResourceFolder());
        String baseDirString = config.getStringProperty("project.basedir", null);
        File baseDir = baseDirString != null ? new File(baseDirString) : DevModeInitializer.getBaseDirectoryFallback();
        if (config.isUsageStatisticsEnabled()) {
            StatisticsStorage storage = new StatisticsStorage();
            DevModeUsageStatistics.init(baseDir, storage, new StatisticsSender(storage));
        }
        String generatedDir = System.getProperty("vaadin.frontend.generated.folder", Paths.get(config.getBuildFolder(), "frontend/").toString());
        String frontendFolder = config.getStringProperty("vaadin.frontend.frontend.folder", System.getProperty("vaadin.frontend.frontend.folder", "./frontend/"));
        Lookup lookupFromContext = (Lookup)context.getAttribute(Lookup.class);
        Lookup lookupForClassFinder = Lookup.of((Object)((Object)new DevModeClassFinder(classes)), (Class[])new Class[]{ClassFinder.class});
        Lookup lookup = Lookup.compose((Lookup)lookupForClassFinder, (Lookup)lookupFromContext);
        Options options = new Options(lookup, baseDir, new File(generatedDir), new File(frontendFolder), config.getBuildFolder());
        DevModeInitializer.log().info("Starting dev-mode updaters in {} folder.", (Object)options.getNpmFolder());
        if (!options.getGeneratedFolder().exists()) {
            try {
                FileUtils.forceMkdir((File)options.getGeneratedFolder());
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create directory '%s'", options.getGeneratedFolder()), e);
            }
        }
        File generatedPackages = new File(options.getGeneratedFolder(), "package.json");
        File target = new File(baseDir, config.getBuildFolder());
        options.withWebpack(Paths.get(target.getPath(), "classes", "META-INF/VAADIN/webapp/").toFile(), Paths.get(target.getPath(), "classes", "META-INF/VAADIN/").toFile());
        options.useV14Bootstrap(config.useV14Bootstrap());
        if (!config.useV14Bootstrap() && DevModeInitializer.isEndpointServiceAvailable(lookup)) {
            String connectJavaSourceFolder = config.getStringProperty("connect.javaSourceFolder", Paths.get(baseDir.getAbsolutePath(), "src/main/java").toString());
            String connectApplicationProperties = config.getStringProperty("connect.applicationProperties", Paths.get(baseDir.getAbsolutePath(), "src/main/resources/application.properties").toString());
            String connectOpenApiJsonFile = config.getStringProperty("connect.openApiFile", Paths.get(baseDir.getAbsolutePath(), config.getBuildFolder(), "generated-resources/openapi.json").toString());
            options.withEndpointSourceFolder(new File(connectJavaSourceFolder)).withApplicationProperties(new File(connectApplicationProperties)).withEndpointGeneratedOpenAPIFile(new File(connectOpenApiJsonFile));
        }
        if (!new File(options.getNpmFolder(), "package.json").exists() || !generatedPackages.exists()) {
            options.createMissingPackageJson(true);
        }
        Set<File> frontendLocations = DevModeInitializer.getFrontendLocationsFromClassloader(DevModeStartupListener.class.getClassLoader());
        boolean useByteCodeScanner = config.getBooleanProperty("devmode.optimizeBundle", Boolean.parseBoolean(System.getProperty("devmode.optimizeBundle", Boolean.FALSE.toString())));
        boolean enablePnpm = config.isPnpmEnabled();
        boolean useGlobalPnpm = config.isGlobalPnpm();
        boolean useHomeNodeExec = config.getBooleanProperty("require.home.node", false);
        String[] additionalPostinstallPackages = config.getStringProperty("npm.postinstallPackages", "").split(",");
        String frontendGeneratedFolderName = config.getStringProperty("project.frontend.generated", Paths.get(baseDir.getAbsolutePath(), "./frontend/generated/").toString());
        File frontendGeneratedFolder = new File(frontendGeneratedFolderName);
        File jarFrontendResourcesFolder = new File(frontendGeneratedFolder, "jar-resources");
        JsonObject tokenFileData = Json.createObject();
        options.enablePackagesUpdate(true).useByteCodeScanner(useByteCodeScanner).withFrontendGeneratedFolder(frontendGeneratedFolder).withJarFrontendResourcesFolder(jarFrontendResourcesFolder).copyResources(frontendLocations).copyLocalResources(new File(baseDir, "src/main/resources/META-INF/resources/frontend")).enableImportsUpdate(true).runNpmInstall(true).populateTokenFileData(tokenFileData).withEmbeddableWebComponents(true).enablePnpm(enablePnpm).useGlobalPnpm(useGlobalPnpm).withHomeNodeExecRequired(useHomeNodeExec).withProductionMode(config.isProductionMode()).withPostinstallPackages(Arrays.asList(additionalPostinstallPackages));
        NodeTasks tasks = new NodeTasks(options);
        Runnable runnable = () -> {
            DevModeInitializer.runNodeTasks(context, tokenFileData, tasks);
            if (!featureFlags.isEnabled(FeatureFlags.WEBPACK) && VaadinServlet.getFrontendMapping() == null) {
                DevModeInitializer.log().debug("Waiting for a VaadinServlet to be deployed");
                while (VaadinServlet.getFrontendMapping() == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        CompletableFuture<Void> nodeTasksFuture = CompletableFuture.runAsync(runnable);
        Lookup devServerLookup = Lookup.compose((Lookup)lookup, (Lookup)Lookup.of((Object)config, (Class[])new Class[]{ApplicationConfiguration.class}));
        int port = Integer.parseInt(config.getStringProperty("devServerPort", "0"));
        if (featureFlags.isEnabled(FeatureFlags.WEBPACK)) {
            return new WebpackHandler(devServerLookup, port, options.getNpmFolder(), nodeTasksFuture);
        }
        return new ViteHandler(devServerLookup, port, options.getNpmFolder(), nodeTasksFuture);
    }

    private static boolean isEndpointServiceAvailable(Lookup lookup) {
        if (lookup == null) {
            return false;
        }
        return lookup.lookup(EndpointGeneratorTaskFactory.class) != null;
    }

    private static Logger log() {
        return LoggerFactory.getLogger(DevModeStartupListener.class);
    }

    private static File getBaseDirectoryFallback() {
        File projectFolder = FileIOUtils.getProjectFolderFromClasspath();
        if (projectFolder != null) {
            return projectFolder;
        }
        String baseDirCandidate = System.getProperty("user.dir", ".");
        Path path = Paths.get(baseDirCandidate, new String[0]);
        if (path.toFile().isDirectory() && (path.resolve("pom.xml").toFile().exists() || path.resolve("build.gradle").toFile().exists())) {
            return path.toFile();
        }
        throw new IllegalStateException(String.format("Failed to determine project directory for dev mode. Directory '%s' does not look like a Maven or Gradle project. Ensure that you have run the prepare-frontend Maven goal, which generates 'flow-build-info.json', prior to deploying your application", path.toString()));
    }

    static Set<File> getFrontendLocationsFromClassloader(ClassLoader classLoader) throws VaadinInitializerException {
        HashSet<File> frontendFiles = new HashSet<File>();
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromClassloader(classLoader, "META-INF/frontend"));
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromClassloader(classLoader, "META-INF/resources/frontend"));
        frontendFiles.addAll(DevModeInitializer.getFrontendLocationsFromClassloader(classLoader, "META-INF/resources/themes/"));
        return frontendFiles;
    }

    private static void runNodeTasks(VaadinContext vaadinContext, JsonObject tokenFileData, NodeTasks tasks) {
        try {
            tasks.execute();
            FallbackChunk chunk = FrontendUtils.readFallbackChunk((JsonObject)tokenFileData);
            if (chunk != null) {
                vaadinContext.setAttribute((Object)chunk);
            }
        }
        catch (ExecutionFailedException exception) {
            DevModeInitializer.log().debug("Could not initialize dev mode handler. One of the node tasks failed", (Throwable)exception);
            throw new CompletionException(exception);
        }
    }

    private static Set<File> getFrontendLocationsFromClassloader(ClassLoader classLoader, String resourcesFolder) throws VaadinInitializerException {
        HashSet<File> frontendFiles = new HashSet<File>();
        try {
            Enumeration<URL> en = classLoader.getResources(resourcesFolder);
            if (en == null) {
                return frontendFiles;
            }
            HashSet<String> vfsJars = new HashSet<String>();
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                String urlString = url.toString();
                String path = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8.name());
                Matcher jarMatcher = JAR_FILE_REGEX.matcher(path);
                Matcher zipProtocolJarMatcher = ZIP_PROTOCOL_JAR_FILE_REGEX.matcher(path);
                Matcher dirMatcher = DIR_REGEX_FRONTEND_DEFAULT.matcher(path);
                Matcher dirResourcesMatcher = DIR_REGEX_RESOURCES_JAR_DEFAULT.matcher(path);
                Matcher dirCompatibilityMatcher = DIR_REGEX_COMPATIBILITY_FRONTEND_DEFAULT.matcher(path);
                Matcher jarVfsMatcher = VFS_FILE_REGEX.matcher(urlString);
                Matcher dirVfsMatcher = VFS_DIRECTORY_REGEX.matcher(urlString);
                if (jarVfsMatcher.find()) {
                    String vfsJar = jarVfsMatcher.group(1);
                    if (!vfsJars.add(vfsJar)) continue;
                    frontendFiles.add(DevModeInitializer.getPhysicalFileOfJBossVfsJar(new URL(vfsJar)));
                    continue;
                }
                if (dirVfsMatcher.find()) {
                    URL vfsDirUrl = new URL(urlString.substring(0, urlString.lastIndexOf(resourcesFolder)));
                    frontendFiles.add(DevModeInitializer.getPhysicalFileOfJBossVfsDirectory(vfsDirUrl));
                    continue;
                }
                if (jarMatcher.find()) {
                    frontendFiles.add(new File(jarMatcher.group(1)));
                    continue;
                }
                if ("zip".equalsIgnoreCase(url.getProtocol()) && zipProtocolJarMatcher.find()) {
                    frontendFiles.add(new File(zipProtocolJarMatcher.group(1)));
                    continue;
                }
                if (dirMatcher.find()) {
                    frontendFiles.add(new File(dirMatcher.group(1)));
                    continue;
                }
                if (dirResourcesMatcher.find()) {
                    frontendFiles.add(new File(dirResourcesMatcher.group(1)));
                    continue;
                }
                if (dirCompatibilityMatcher.find()) {
                    frontendFiles.add(new File(dirCompatibilityMatcher.group(1)));
                    continue;
                }
                DevModeInitializer.log().warn("Resource {} not visited because does not meet supported formats.", (Object)url.getPath());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return frontendFiles;
    }

    private static File getPhysicalFileOfJBossVfsDirectory(URL url) throws IOException, VaadinInitializerException {
        try {
            Object virtualFile = url.openConnection().getContent();
            Class<?> virtualFileClass = virtualFile.getClass();
            Method getChildrenRecursivelyMethod = virtualFileClass.getMethod("getChildrenRecursively", new Class[0]);
            Method getPhysicalFileMethod = virtualFileClass.getMethod("getPhysicalFile", new Class[0]);
            List virtualFiles = (List)getChildrenRecursivelyMethod.invoke(virtualFile, new Object[0]);
            File rootDirectory = (File)getPhysicalFileMethod.invoke(virtualFile, new Object[0]);
            for (Object child : virtualFiles) {
                getPhysicalFileMethod.invoke(child, new Object[0]);
            }
            return rootDirectory;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new VaadinInitializerException("Failed to invoke JBoss VFS API.", (Throwable)exc);
        }
    }

    private static File getPhysicalFileOfJBossVfsJar(URL url) throws IOException, VaadinInitializerException {
        try {
            Object jarVirtualFile = url.openConnection().getContent();
            String vfsJarPath = url.toString();
            String fileNamePrefix = vfsJarPath.substring(vfsJarPath.lastIndexOf(47) + 1, vfsJarPath.lastIndexOf(".jar"));
            Path tempJar = Files.createTempFile(fileNamePrefix, ".jar", new FileAttribute[0]);
            DevModeInitializer.generateJarFromJBossVfsFolder(jarVirtualFile, tempJar);
            File tempJarFile = tempJar.toFile();
            tempJarFile.deleteOnExit();
            return tempJarFile;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            throw new VaadinInitializerException("Failed to invoke JBoss VFS API.", (Throwable)exc);
        }
    }

    private static void generateJarFromJBossVfsFolder(Object jarVirtualFile, Path tempJar) throws IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> virtualFileClass = jarVirtualFile.getClass();
        Method getChildrenRecursivelyMethod = virtualFileClass.getMethod("getChildrenRecursively", new Class[0]);
        Method openStreamMethod = virtualFileClass.getMethod("openStream", new Class[0]);
        Method isFileMethod = virtualFileClass.getMethod("isFile", new Class[0]);
        Method getPathNameRelativeToMethod = virtualFileClass.getMethod("getPathNameRelativeTo", virtualFileClass);
        List jarVirtualChildren = (List)getChildrenRecursivelyMethod.invoke(jarVirtualFile, new Object[0]);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempJar, new OpenOption[0]));){
            for (Object child : jarVirtualChildren) {
                if (!((Boolean)isFileMethod.invoke(child, new Object[0])).booleanValue()) continue;
                String relativePath = (String)getPathNameRelativeToMethod.invoke(child, jarVirtualFile);
                InputStream inputStream = (InputStream)openStreamMethod.invoke(child, new Object[0]);
                ZipEntry zipEntry = new ZipEntry(relativePath);
                zipOutputStream.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
        }
    }

    static class DevModeClassFinder
    extends ClassFinder.DefaultClassFinder {
        private static final Set<String> APPLICABLE_CLASS_NAMES = Collections.unmodifiableSet(DevModeClassFinder.calculateApplicableClassNames());

        public DevModeClassFinder(Set<Class<?>> classes) {
            super(classes);
        }

        public Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
            this.ensureImplementation(annotation);
            return super.getAnnotatedClasses(annotation);
        }

        public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
            this.ensureImplementation(type);
            return super.getSubTypesOf(type);
        }

        private void ensureImplementation(Class<?> clazz) {
            if (!APPLICABLE_CLASS_NAMES.contains(clazz.getName())) {
                throw new IllegalArgumentException("Unexpected class name " + clazz + ". Implementation error: the class finder instance is not aware of this class. Fix @HandlesTypes annotation value for " + DevModeStartupListener.class.getName());
            }
        }

        private static Set<String> calculateApplicableClassNames() {
            HandlesTypes handlesTypes = DevModeStartupListener.class.getAnnotation(HandlesTypes.class);
            return Stream.of(handlesTypes.value()).map(Class::getName).collect(Collectors.toSet());
        }
    }
}

