import { x as xe, L as Le, m as Rc, l as le, d as k, n as uu, a as f, C as Ca } from "./indexhtml-CMy5IyL1.js";
import { a } from "./state-DX1Hshs6-BwbB-yRy.js";
import { r } from "./icons-DSuqz_Pk-DhRDe3w0.js";
import { o as o$1 } from "./copilot-tree-w_0cNQLz-LZEdElzD.js";
import { c } from "./base-panel-BzptayPc-CHErjyhk.js";
import "./commonjsHelpers-CUmg6egw.js";
var $ = Object.defineProperty, S = Object.getOwnPropertyDescriptor, o = (t, a2, p, r2) => {
  for (var l = r2 > 1 ? void 0 : r2 ? S(a2, p) : a2, v = t.length - 1, b; v >= 0; v--)
    (b = t[v]) && (l = (r2 ? b(a2, p, l) : b(l)) || l);
  return r2 && l && $(a2, p, l), l;
};
let d = class extends c {
  constructor() {
    super(...arguments), this.selectedTab = 0, this.activationShortcutEnabled = Le.isActivationShortcut(), this.aiUsage = Le.isAIUsageAllowed(), this.aiProvider = Le.getAIProvider(), this.themeItems = [
      { label: "System", value: "system" },
      { label: "Light", value: "light" },
      { label: "Dark", value: "dark" }
    ], this.aiUsageItems = [
      { label: "Ask each time", value: "ask" },
      { label: "Allow", value: "yes" },
      { label: "Deny", value: "no" }
    ], this.aiProviderItems = [
      { label: "Any region", value: "ANY" },
      { label: "EU only", value: "EU_ONLY" }
    ], this.toggleActivationShortcut = () => {
      this.activationShortcutEnabled = !this.activationShortcutEnabled, Le.setActivationShortcut(this.activationShortcutEnabled);
    };
  }
  renderKbd(t) {
    const a2 = t.replace(/<kbd([^>]*)class="([^"]*)"/, '<kbd$1class="$2 font-sans ms-auto"').replace(/<kbd(?![^>]*class=)/, '<kbd class="font-sans ms-auto"');
    return Rc(a2);
  }
  render() {
    return le`
      <vaadin-tabs>
        <vaadin-tab ?selected=${this.selectedTab === 0} @click=${() => this.selectedTab = 0}>General</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 1} @click=${() => this.selectedTab = 1}>Shortcuts</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 2} @click=${() => this.selectedTab = 2}>AI</vaadin-tab>
        <vaadin-tab ?selected=${this.selectedTab === 3} @click=${() => this.selectedTab = 3}>Features</vaadin-tab>
      </vaadin-tabs>
      ${this.selectedTab === 0 ? this.renderGeneralTab() : null}
      ${this.selectedTab === 1 ? this.renderShortcutsTab() : null} ${this.selectedTab === 2 ? this.renderAiTab() : null}
      ${this.selectedTab === 3 ? this.renderFeaturesTab() : null}
    `;
  }
  renderGeneralTab() {
    const t = Le.getSelectedTheme();
    return le`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <label class="py-1.5" id="theme">Theme</label>
        <vaadin-select
          accessible-name-ref="theme"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.themeItems}"
          .value="${t}"
          @change="${(a2) => {
      Le.setSelectedTheme(
        a2.target.value
      );
    }}"></vaadin-select>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="reduce-motion-label">Reduce motion</label>
          <span id="reduce-motion-desc" class="text-secondary text-xs">Disables animations</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="reduce-motion-label"
          aria-describedby="reduce-motion-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
      <div class="flex gap-2 justify-between py-3.5">
        <div class="flex flex-col">
          <label id="error-reports-label">Send error reports</label>
          <span id="error-reports-desc" class="text-secondary text-xs">Helps us improve the user experience</span>
        </div>
        <button
          aria-checked="true"
          aria-labelledby="error-reports-label"
          aria-describedby="error-reports-desc"
          class="my-px"
          role="switch"
          type="button">
          <span></span>
        </button>
      </div>
    </div>`;
  }
  renderShortcutsTab() {
    const t = o$1.hasFlowComponents();
    return le`<div class="flex flex-col gap-4 pb-2 pt-4 px-4">
      <div class="flex justify-between">
        <div class="flex flex-col">
          <label id="enable-shortcuts-label">Enable keyboard shortcut</label>
          <span id="enable-shortcuts-desc" class="text-secondary text-xs"
            >Open Copilot with ${this.renderKbd(uu.toggleCopilot)}</span
          >
        </div>
        <button
          aria-checked="${this.activationShortcutEnabled}"
          aria-labelledby="enable-shortcuts-label"
          aria-describedby="enable-shortcuts-desc"
          class="my-px"
          role="switch"
          type="button"
          @click=${() => this.toggleActivationShortcut()}>
          <span></span>
        </button>
      </div>
      <vaadin-text-field accessible-name="Search" placeholder="Search...">
        <vaadin-icon class="text-secondary" slot="prefix" .svg="${r.search}"></vaadin-icon>
      </vaadin-text-field>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Global</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.vaadin}"></vaadin-icon>
            <span>Copilot</span>
            ${this.renderKbd(uu.toggleCopilot)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.undo}"></vaadin-icon>
            <span>Undo</span>
            ${this.renderKbd(uu.undo)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.redo}"></vaadin-icon>
            <span>Redo</span>
            ${this.renderKbd(uu.redo)}
          </li>
        </ul>
      </div>
      <div class="flex flex-col gap-1">
        <h3 class="font-semibold my-0 text-sm">Component Selection</h3>
        <ul class="border-dashed divide-y flex flex-col list-none m-0 p-0">
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.sparkles}"></vaadin-icon>
            <span>Open AI prompt</span>
            ${this.renderKbd(uu.openAiPopover)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.code}"></vaadin-icon>
            <span>Go to source</span>
            ${this.renderKbd(uu.goToSource)}
          </li>
          ${t ? le`<li class="flex gap-2 py-2">
                <vaadin-icon .svg="${r.code}"></vaadin-icon>
                <span>Go to attach source</span>
                ${this.renderKbd(uu.goToAttachSource)}
              </li>` : k}
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.contentCopy}"></vaadin-icon>
            <span>Copy</span>
            ${this.renderKbd(uu.copy)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.contentPaste}"></vaadin-icon>
            <span>Paste</span>
            ${this.renderKbd(uu.paste)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.fileCopy}"></vaadin-icon>
            <span>Duplicate</span>
            ${this.renderKbd(uu.duplicate)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.turnLeft}"></vaadin-icon>
            <span>Select parent</span>
            ${this.renderKbd(uu.selectParent)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.north}"></vaadin-icon>
            <span>Select previous sibling</span>
            ${this.renderKbd(uu.selectPreviousSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.south}"></vaadin-icon>
            <span>Select first child / next sibling</span>
            ${this.renderKbd(uu.selectNextSibling)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.delete}"></vaadin-icon>
            <span>Delete</span>
            ${this.renderKbd(uu.delete)}
          </li>
          <li class="flex gap-2 py-2">
            <vaadin-icon .svg="${r.dashboardCustomize}"></vaadin-icon>
            <span>Add component</span>
            <kbd class="font-sans ms-auto">A – Z</kbd>
          </li>
        </ul>
      </div>
    </div>`;
  }
  renderAiTab() {
    const t = f.userInfo?.vaadiner;
    return le`<div class="border-dashed flex flex-col divide-y px-4 py-0.5">
      <div class="flex gap-2 items-start justify-between py-2">
        <div class="flex flex-col py-1.5">
          <label id="ai-usage">AI usage</label>
          <span class="text-secondary text-xs">All AI features are clearly labelled </span>
        </div>
        <vaadin-select
          accessible-name-ref="ai-usage"
          class="flex-shrink-0"
          theme="auto-width no-border"
          .items="${this.aiUsageItems}"
          .value="${this.aiUsage}"
          @value-changed="${(a2) => {
      this.aiUsage = a2.detail.value, Le.setAIUsageAllowed(a2.detail.value);
    }}"></vaadin-select>
      </div>
      ${t ? le`<div class="flex gap-2 items-start justify-between py-2">
            <label class="py-1.5" id="ai-provider">AI provider</label>
            <vaadin-select
              accessible-name-ref="ai-provider"
              class="flex-shrink-0"
              theme="auto-width no-border"
              .items="${this.aiProviderItems}"
              .value="${this.aiProvider}"
              @value-changed="${(a2) => {
      this.aiProvider = a2.detail.value, Le.setAIProvider(a2.detail.value);
    }}"></vaadin-select>
          </div>` : k}
    </div>`;
  }
  renderFeaturesTab() {
    return le`<copilot-features-panel></copilot-features-panel>`;
  }
};
o([
  a()
], d.prototype, "selectedTab", 2);
o([
  a()
], d.prototype, "activationShortcutEnabled", 2);
o([
  a()
], d.prototype, "aiUsage", 2);
o([
  a()
], d.prototype, "aiProvider", 2);
d = o([
  Ca("copilot-settings-panel")
], d);
const T = {
  header: "Settings",
  tag: xe.SETTINGS
}, A = {
  init(t) {
    t.addPanel(T);
  }
};
window.Vaadin.copilot.plugins.push(A);
export {
  d as CopilotSettingsPanel,
  T as panelConfig
};
