import { aA as addGlobalStyles, aB as css$h, aC as ThemableMixin, aD as DirMixin, aE as PolylitMixin, aF as LumoInjectionMixin, aG as LitElement, aH as html, aI as defineCustomElement, aJ as overlayStyles$1, aK as PositionMixin, aL as OverlayMixin, aM as Debouncer, aN as timeOut, aO as isKeyboardActive, aP as announce, aQ as detailsSummary, aR as ActiveMixin, aS as CollapsibleMixin, aT as DelegateFocusMixin, aU as DelegateStateMixin, aV as SummaryController, aW as TooltipController, aX as KeyboardDirectionMixin, aY as isElementFocused, aZ as SlotObserver, a_ as ElementMixin, a$ as isIOS, b0 as I18nMixin, b1 as FocusTrapController, b2 as animationFrame, b3 as ButtonMixin, b4 as buttonStyles, b5 as isEmptyTextNode, b6 as FocusMixin, b7 as ifDefined, b8 as ListMixin, b9 as itemStyles, ba as ItemMixin, bb as ResizeMixin, bc as SlotController, bd as render$1, be as isElementHidden, bf as issueWarning, bg as generateUniqueId, bh as unsafeCSS, bi as get$5, bj as field, bk as group, bl as FieldMixin, bm as DisabledMixin, bn as Directive, bo as isSingleExpression, bp as PartType, bq as directive, br as noChange, bs as ComboBoxPlaceholder, bt as dialogOverlayBase, bu as DialogSizeMixin, bv as setAriaIDReference, bw as ThemePropertyMixin, bx as gestures, by as removeListener, bz as addListener, bA as dialogOverlayStyles, bB as DialogBaseMixin, bC as ColumnBaseMixin, bD as updateColumnOrders, bE as ColumnObserver, bF as Button, bG as set, bH as GridColumn, bI as gridStyles, bJ as Grid, bK as SlotStylesMixin, bL as FocusRestorationController, bM as MediaQueryController, bN as nothing, bO as isFocusable, bP as KeyboardMixin, bQ as getFlattenedElements, bR as setTouchAction, bS as isElementFocusable, bT as InputConstraintsMixin, bU as VirtualKeyboardController, bV as InputControlMixin, bW as inputFieldShared, bX as InputController, bY as LabelledInputController, bZ as ComboBoxItemMixin, b_ as ComboBoxOverlayMixin, b$ as ComboBoxScrollerMixin, c0 as comboBoxScrollerStyles, c1 as PatternMixin, c2 as ComboBoxBaseMixin, c3 as addValueToAttribute, c4 as removeValueFromAttribute, c5 as iterateRowCells, c6 as updatePart, c7 as Checkbox, c8 as Select, c9 as TextField, ca as getDeepActiveElement, cb as InputMixin, cc as SlotChildObserveController, cd as getFocusableElements, ce as __vitePreload, cf as isTemplateResult, cg as Popover, ch as reactExports, ci as clientExports, cj as jsxDEV, ck as Outlet, cl as Tooltip$2, cm as screenReaderOnly, cn as InputFieldMixin, co as setCommittedValue, cp as isTouch, cq as Virtualizer, cr as OverflowController, cs as isChrome, ct as isSafari$1, cu as Iconset } from "./indexhtml-ChvF_Mci.js";
import { renderMarkdownToElement } from "./markdown-helpers-BqEtI5ss.js";
import "./commonjsHelpers-CUmg6egw.js";
/**
 * @license
 * Copyright (c) 2017 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
addGlobalStyles(
  "vaadin-base-user-colors",
  css$h`
    @layer vaadin.base {
      html {
        --_color-count: 10;
        --_hue-step: round(360 / var(--_color-count), 1);
        --vaadin-user-color-0: var(--vaadin-user-color, oklch(0.52 0.2 240));
        --vaadin-user-color-1: oklch(
          from var(--vaadin-user-color-0) calc(0.62 + clamp(-0.15, (0.6201 - l) * 10000, 0.15)) c
            calc(h - var(--_hue-step) * 2 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-2: oklch(
          from var(--vaadin-user-color-0) l c calc(h - var(--_hue-step) * -2 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-3: oklch(
          from var(--vaadin-user-color-0) calc(0.62 + clamp(-0.15, (0.6201 - l) * 10000, 0.15)) c
            calc(h - var(--_hue-step) * 0 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-4: oklch(
          from var(--vaadin-user-color-0) l c calc(h - var(--_hue-step) * 2 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-5: oklch(
          from var(--vaadin-user-color-0) calc(0.62 + clamp(-0.15, (0.6201 - l) * 10000, 0.15)) c
            calc(h - var(--_hue-step) * -2 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-6: oklch(
          from var(--vaadin-user-color-0) l c calc(h - var(--_hue-step) * -4 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-7: oklch(
          from var(--vaadin-user-color-0) calc(0.62 + clamp(-0.15, (0.6201 - l) * 10000, 0.15)) c
            calc(h - var(--_hue-step) * 4 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-8: oklch(
          from var(--vaadin-user-color-0) l c calc(h - var(--_hue-step) * 4 * var(--_vaadin-safari-17-deg, 1))
        );
        --vaadin-user-color-9: oklch(
          from var(--vaadin-user-color-0) calc(0.62 + clamp(-0.15, (0.6201 - l) * 10000, 0.15)) c
            calc(h - var(--_hue-step) * 6 * var(--_vaadin-safari-17-deg, 1))
        );
      }
    }
  `
);
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const fieldOutlineStyles = css$h`
  :host {
    display: block;
    position: absolute;
    inset: 0;
    pointer-events: none;
    opacity: 0;
    --_active-user-color: transparent;
    outline: 3px solid var(--_active-user-color);
    outline-offset: -1px;
    /* TODO doesn't inherit correctly from vaadin-input-container for some reason, so we use the internal _radius property */
    border-radius: var(--_radius, inherit);
  }

  :host([has-active-user]) {
    opacity: 1;
  }

  :host([context$='item']) {
    inset: 2px;
  }
`;
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class FieldOutline extends ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-field-outline";
  }
  static get styles() {
    return fieldOutlineStyles;
  }
  static get properties() {
    return {
      /**
       * A user who last interacted with the field.
       */
      user: {
        type: Object,
        value: null,
        observer: "_userChanged",
        sync: true
      }
    };
  }
  /** @protected */
  render() {
    return html``;
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("part", "outline");
    this._field = this.getRootNode().host;
  }
  /** @private */
  _userChanged(user) {
    this.toggleAttribute("has-active-user", Boolean(user));
    const value = user ? `var(--vaadin-user-color-${user.colorIndex})` : "transparent";
    const prop = "--_active-user-color";
    this.style.setProperty(prop, value);
    if (this._field) {
      this._field.style.setProperty(prop, value);
    }
  }
}
defineCustomElement(FieldOutline);
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const userTagStyles = css$h`
  :host {
    display: inline-block;
    box-sizing: border-box;
    opacity: 0;
    padding: var(--vaadin-user-tag-padding, 0.3em);
    background-color: var(--vaadin-user-tag-color);
    color: oklch(from var(--vaadin-user-tag-color) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    font-size: var(--vaadin-user-tag-font-size, 0.75em);
    font-weight: var(--vaadin-user-tag-font-weight, 500);
    line-height: var(--vaadin-user-tag-line-height, 1);
    border: var(--vaadin-user-tag-border-width, 0) solid
      var(--vaadin-user-tag-border-color, var(--vaadin-border-color-secondary));
    border-radius: var(--vaadin-user-tag-border-radius, var(--vaadin-radius-m));
    cursor: default;
  }

  :host(.show) {
    opacity: 1;
  }

  [part='name'] {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
  }
`;
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class UserTag extends ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-user-tag";
  }
  static get styles() {
    return userTagStyles;
  }
  /** @protected */
  render() {
    return html`<div part="name">${this.name}</div>`;
  }
  static get properties() {
    return {
      /**
       * Name of the user.
       */
      name: {
        type: String
      },
      /**
       * Id of the user.
       */
      uid: {
        type: String
      },
      /**
       * Color index of the user.
       */
      colorIndex: {
        type: Number,
        observer: "_colorIndexChanged"
      }
    };
  }
  /** @protected */
  ready() {
    super.ready();
    this.addEventListener("mousedown", this._onClick.bind(this), true);
  }
  /** @private */
  _colorIndexChanged(index) {
    if (index != null) {
      this.style.setProperty("--vaadin-user-tag-color", `var(--vaadin-user-color-${index})`);
    }
  }
  /**
   * @param {Event} e
   * @private
   */
  _onClick(e) {
    e.preventDefault();
    this.dispatchEvent(
      new CustomEvent("user-tag-click", {
        bubbles: true,
        composed: true,
        detail: {
          name: this.name
        }
      })
    );
  }
}
defineCustomElement(UserTag);
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const userTagsOverlay = css$h`
  [part='overlay'] {
    all: initial;
    display: block;
    font: inherit;
    color: inherit;
  }

  [part='content'] {
    display: flex;
    flex-wrap: wrap;
    gap: var(--vaadin-user-tag-overlay-gap, 0.2em);
    padding: 0.5em 0;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;
const userTagsOverlayStyles = [overlayStyles$1, userTagsOverlay];
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class UserTagsOverlay extends PositionMixin(
  OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))))
) {
  static get is() {
    return "vaadin-user-tags-overlay";
  }
  static get styles() {
    return userTagsOverlayStyles;
  }
  /** @protected */
  render() {
    return html`
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `;
  }
}
defineCustomElement(UserTagsOverlay);
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const listenOnce$1 = (elem, type) => {
  return new Promise((resolve) => {
    const listener = () => {
      elem.removeEventListener(type, listener);
      resolve();
    };
    elem.addEventListener(type, listener);
  });
};
class UserTags extends PolylitMixin(LitElement) {
  static get is() {
    return "vaadin-user-tags";
  }
  static get styles() {
    return css$h`
      :host {
        position: absolute;
      }
    `;
  }
  /** @protected */
  render() {
    return html`
      <vaadin-user-tags-overlay
        id="overlay"
        exportparts="overlay:user-tags-overlay, content:user-tags-content"
        modeless
        .opened="${this.opened}"
        no-vertical-overlap
        @vaadin-overlay-open="${this._onOverlayOpen}"
      >
        <slot></slot>
      </vaadin-user-tags-overlay>
    `;
  }
  static get properties() {
    return {
      /**
       * True when the field has focus. In this case, the overlay
       * with a list of the user tags needs to be always visible.
       */
      hasFocus: {
        type: Boolean,
        value: false,
        observer: "_hasFocusChanged"
      },
      /**
       * True when the overlay is opened.
       */
      opened: {
        type: Boolean,
        value: false,
        sync: true
      },
      /**
       * True when the overlay is flashing: quickly shown and then hidden
       * once a different user starts to interact with the field.
       */
      flashing: {
        type: Boolean,
        value: false
      },
      /**
       * A target element that the overlay is positioned to.
       */
      target: {
        type: Object,
        observer: "__targetChanged"
      },
      /**
       * A list of users who focused the field.
       */
      users: {
        type: Array,
        value: () => []
      },
      duration: {
        type: Number,
        value: 200
      },
      delay: {
        type: Number,
        value: 2e3
      },
      /** @private */
      __flashQueue: {
        type: Array,
        value: () => []
      },
      /** @private */
      __isTargetVisible: {
        type: Boolean,
        value: false
      }
    };
  }
  constructor() {
    super();
    this.__targetVisibilityObserver = new IntersectionObserver(
      ([entry]) => {
        this.__onTargetVisibilityChange(entry.isIntersecting);
      },
      { threshold: 1 }
    );
  }
  /** @protected */
  get wrapper() {
    return this;
  }
  /** @protected */
  connectedCallback() {
    super.connectedCallback();
    if (this.target) {
      this.__targetVisibilityObserver.observe(this.target);
    }
  }
  /** @protected */
  disconnectedCallback() {
    super.disconnectedCallback();
    this.opened = false;
    if (this.target) {
      this.__targetVisibilityObserver.unobserve(this.target);
    }
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("exportparts", "user-tags-overlay, user-tags-content");
  }
  /** @private */
  __onTargetVisibilityChange(isVisible) {
    this.__isTargetVisible = isVisible;
    if (isVisible && this.__flashQueue.length > 0 && !this.flashing) {
      this.flashTags(this.__flashQueue.shift());
      return;
    }
    if (isVisible && this.hasFocus) {
      this.opened = true;
      return;
    }
    if (!isVisible && this.opened) {
      this.opened = false;
    }
  }
  /** @private */
  __targetChanged(newTarget, oldTarget) {
    this.$.overlay.positionTarget = newTarget;
    if (oldTarget) {
      this.__targetVisibilityObserver.unobserve(oldTarget);
    }
    if (newTarget) {
      this.__targetVisibilityObserver.observe(newTarget);
    }
  }
  /** @private */
  _hasFocusChanged(hasFocus) {
    if (hasFocus && this.flashing) {
      this.stopFlash();
    }
  }
  createUserTag(user) {
    const tag = document.createElement("vaadin-user-tag");
    tag.setAttribute("part", "user-tag");
    tag.name = user.name;
    tag.uid = user.id;
    tag.colorIndex = user.colorIndex;
    return tag;
  }
  getTagForUser(user) {
    return Array.from(this.children).find((tag) => tag.uid === user.id);
  }
  getChangedTags(addedUsers, removedUsers) {
    const removed = removedUsers.map((user) => this.getTagForUser(user));
    const added = addedUsers.map((user) => this.getTagForUser(user) || this.createUserTag(user));
    return { added, removed };
  }
  applyTagsStart({ added, removed }) {
    removed.forEach((tag) => {
      if (tag) {
        tag.classList.add("removing");
        tag.classList.remove("show");
      }
    });
    added.forEach((tag) => this.insertBefore(tag, this.firstChild));
  }
  applyTagsEnd({ added, removed }) {
    removed.forEach((tag) => {
      if (tag && tag.parentNode === this) {
        this.removeChild(tag);
      }
    });
    added.forEach((tag) => tag && tag.classList.add("show"));
  }
  setUsers(users) {
    this.requestContentUpdate();
    let addedUsers = [];
    let removedUsers = [];
    const hasNewUsers = Array.isArray(users);
    const hasOldUsers = Array.isArray(this.users);
    if (hasOldUsers) {
      const newUserIds = (users || []).map((user) => user.id);
      removedUsers = this.users.filter((item) => !newUserIds.includes(item.id));
    }
    if (hasNewUsers) {
      const oldUserIds = (this.users || []).map((user) => user.id);
      addedUsers = users.filter((item) => !oldUserIds.includes(item.id)).reverse();
    }
    if (addedUsers.length === 0 && removedUsers.length === 0) {
      return;
    }
    const changedTags = this.getChangedTags(addedUsers, removedUsers);
    if (this.__flashQueue.length > 0) {
      removedUsers.forEach((user, i2) => {
        if (changedTags.removed[i2] === null) {
          return;
        }
        this.__flashQueue.forEach((tags) => {
          if (tags.some((tag) => tag.uid === user.id)) {
            this.__flashQueue = this.__flashQueue.filter((_2, index) => index !== i2);
          }
        });
      });
    }
    if (this.opened && this.hasFocus) {
      this.updateTags(users, changedTags);
    } else if (addedUsers.length > 0 && document.visibilityState !== "hidden") {
      const addedTags = changedTags.added;
      const removedTags = changedTags.removed;
      this.updateTagsSync(users, {
        added: [],
        removed: removedTags
      });
      if (this.flashing || !this.__isTargetVisible) {
        this.__flashQueue = [...this.__flashQueue, addedTags];
      } else {
        this.flashTags(addedTags);
      }
    } else {
      this.updateTagsSync(users, changedTags);
    }
  }
  /** @private */
  _onOverlayOpen() {
    Array.from(this.children).forEach((tag) => {
      if (!tag.classList.contains("removing")) {
        tag.classList.add("show");
      }
    });
  }
  flashTags(added) {
    this.flashing = true;
    const hidden = Array.from(this.children);
    hidden.forEach((tag) => {
      tag.style.display = "none";
    });
    added.forEach((tag) => {
      this.insertBefore(tag, this.firstChild);
    });
    this.flashPromise = new Promise((resolve) => {
      listenOnce$1(this.$.overlay, "vaadin-overlay-open").then(() => {
        this._debounceFlashStart = Debouncer.debounce(
          this._debounceFlashStart,
          timeOut.after(this.duration + this.delay),
          () => {
            if (!this.hasFocus) {
              added.forEach((tag) => tag.classList.remove("show"));
            }
            this._debounceFlashEnd = Debouncer.debounce(this._debounceFlashEnd, timeOut.after(this.duration), () => {
              const finishFlash = () => {
                hidden.forEach((tag) => {
                  tag.style.display = "block";
                });
                this.flashing = false;
                resolve();
              };
              if (this.hasFocus) {
                finishFlash();
              } else {
                listenOnce$1(this.$.overlay, "animationend").then(() => {
                  finishFlash();
                });
                this.opened = false;
              }
            });
          }
        );
      });
    }).then(() => {
      if (this.__flashQueue.length > 0) {
        const tags = this.__flashQueue[0];
        this.__flashQueue = [...this.__flashQueue].slice(1);
        this.flashTags(tags);
      }
    });
    this.opened = true;
  }
  stopFlash() {
    if (this._debounceFlashStart) {
      this._debounceFlashStart.flush();
    }
    if (this._debounceFlashEnd) {
      this._debounceFlashEnd.flush();
    }
    this.$.overlay._flushAnimation("closing");
  }
  updateTags(users, changed) {
    this.applyTagsStart(changed);
    this._debounceRender = Debouncer.debounce(this._debounceRender, timeOut.after(this.duration), () => {
      this.users = users;
      this.applyTagsEnd(changed);
      if (users.length === 0 && this.opened) {
        this.opened = false;
      }
    });
  }
  updateTagsSync(users, changed) {
    this.applyTagsStart(changed);
    this.users = users;
    this.applyTagsEnd(changed);
  }
  show() {
    this.hasFocus = true;
    if (this.__isTargetVisible) {
      this.opened = true;
    }
  }
  hide() {
    this.hasFocus = false;
    this.opened = false;
  }
  requestContentUpdate() {
    if (this._debounceRender && this._debounceRender.isActive()) {
      this._debounceRender.flush();
    }
  }
}
defineCustomElement(UserTags);
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const getOutlineTarget = (element, tagName) => {
  switch (tagName) {
    /* c8 ignore next */
    case "vaadin-big-decimal-field":
    case "vaadin-combo-box":
    case "vaadin-date-picker":
    case "vaadin-email-field":
    case "vaadin-integer-field":
    case "vaadin-number-field":
    case "vaadin-password-field":
    case "vaadin-select":
    case "vaadin-text-area":
    case "vaadin-text-field":
    case "vaadin-time-picker":
      return element.shadowRoot.querySelector('[part="input-field"]');
    /* c8 ignore next */
    case "vaadin-checkbox":
      return element.shadowRoot.querySelector('[part="checkbox"]');
    /* c8 ignore next */
    case "vaadin-radio-button":
      return element.shadowRoot.querySelector('[part="radio"]');
    /* c8 ignore next */
    default:
      return element;
  }
};
const fields = /* @__PURE__ */ new WeakMap();
const initOutline = (field2) => {
  if (!fields.has(field2)) {
    const tagName = field2.tagName.toLowerCase();
    const target = getOutlineTarget(field2, tagName);
    target.style.position = "relative";
    if (tagName.endsWith("text-area")) {
      target.style.overflow = "visible";
    }
    const style = document.createElement("style");
    style.textContent = `
      :host(:is([active], [focused])) [part="outline"] {
        display: none;
      }
    `;
    field2.shadowRoot.appendChild(style);
    const outline = document.createElement("vaadin-field-outline");
    (target === field2 ? field2.shadowRoot : target).appendChild(outline);
    outline.setAttribute("context", tagName);
    fields.set(field2, { root: field2, target, outline });
  }
  return fields.get(field2);
};
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class ComponentObserver {
  constructor(component) {
    this.component = component;
    this.initTags(component);
  }
  getFields() {
    return [this.component];
  }
  getFieldIndex(field2) {
    return this.getFields().indexOf(field2);
  }
  getFocusTarget(_event) {
    return this.component;
  }
  initTags(component) {
    const tags = document.createElement("vaadin-user-tags");
    component.shadowRoot.appendChild(tags);
    tags.target = component;
    this._tags = tags;
    component.addEventListener("mouseenter", (event) => {
      if (event.relatedTarget === this._tags.$.overlay) {
        return;
      }
      this._mouse = true;
      this._mouseDebouncer = Debouncer.debounce(this._mouseDebouncer, timeOut.after(200), () => {
        if (this._mouse) {
          this._tags.show();
        }
      });
    });
    component.addEventListener("mouseleave", (event) => {
      if (event.relatedTarget === this._tags.$.overlay) {
        return;
      }
      this._mouse = false;
      if (!this._hasFocus) {
        this._tags.hide();
      }
    });
    component.addEventListener("vaadin-highlight-show", (_event) => {
      this._hasFocus = true;
      if (this._debouncer && this._debouncer.isActive()) {
        this._debouncer.cancel();
      } else {
        this._tags.show();
      }
    });
    component.addEventListener("vaadin-highlight-hide", (_event) => {
      this._hasFocus = false;
      if (!this._mouse) {
        this._debouncer = Debouncer.debounce(this._debouncer, timeOut.after(1), () => {
          this._tags.hide();
        });
      }
    });
    this._tags.$.overlay.addEventListener("mouseleave", (event) => {
      if (event.relatedTarget === component) {
        return;
      }
      this._mouse = false;
      if (!component.hasAttribute("focused")) {
        this._tags.hide();
      }
    });
  }
  setOutlines(users) {
    const fields2 = this.getFields();
    fields2.forEach((field2, idx2) => {
      const { outline } = initOutline(field2);
      const index = fields2.length === 1 ? 0 : users.map((user) => user.fieldIndex).indexOf(idx2);
      outline.user = users[index];
    });
  }
  showOutline(field2) {
    this.fire("show", field2);
  }
  hideOutline(field2) {
    this.fire("hide", field2);
  }
  fire(action, field2) {
    this.component.dispatchEvent(
      new CustomEvent(`vaadin-highlight-${action}`, {
        bubbles: true,
        composed: true,
        detail: { fieldIndex: this.getFieldIndex(field2) }
      })
    );
  }
  redraw(users) {
    this._tags.setUsers(users);
    this.setOutlines(users);
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class FieldObserver extends ComponentObserver {
  constructor(field2) {
    super(field2);
    this.addListeners(field2);
  }
  addListeners(field2) {
    field2.addEventListener("focusin", (event) => this.onFocusIn(event));
    field2.addEventListener("focusout", (event) => this.onFocusOut(event));
  }
  onFocusIn(event) {
    const target = this.getFocusTarget(event);
    this.showOutline(target);
  }
  onFocusOut(event) {
    const target = this.getFocusTarget(event);
    this.hideOutline(target);
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class CheckboxGroupObserver extends FieldObserver {
  getFields() {
    return this.component.__checkboxes;
  }
  getFocusTarget(event) {
    const fields2 = this.getFields();
    return Array.from(event.composedPath()).find((node) => fields2.includes(node));
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class DatePickerObserver extends ComponentObserver {
  constructor(datePicker) {
    super(datePicker);
    this.datePicker = datePicker;
    this.blurWhileOpened = false;
    this.addListeners(datePicker);
  }
  addListeners(datePicker) {
    this.overlay = datePicker.$.overlay;
    datePicker.addEventListener("opened-changed", (event) => this.onOpenedChanged(event));
    this.overlay.addEventListener("focusout", (event) => this.onOverlayFocusOut(event));
    datePicker.addEventListener("focusin", (event) => this.onFocusIn(event));
    datePicker.addEventListener("focusout", (event) => this.onFocusOut(event));
  }
  isEventInOverlay(node) {
    return this.datePicker._overlayContent && this.datePicker._overlayContent.contains(node);
  }
  isFullscreen() {
    const datePicker = this.datePicker;
    return datePicker._noInput && !isKeyboardActive();
  }
  onFocusIn(event) {
    if (this.isEventInOverlay(event.target)) {
      return;
    }
    if (this.isEventInOverlay(event.relatedTarget)) {
      return;
    }
    if (this.blurWhileOpened) {
      this.blurWhileOpened = false;
      return;
    }
    this.showOutline(this.datePicker);
  }
  onFocusOut(event) {
    if (this.isEventInOverlay(event.target) && this.component.contains(event.relatedTarget)) {
      return;
    }
    if (this.isEventInOverlay(event.relatedTarget)) {
      return;
    }
    if (!this.datePicker.opened) {
      this.hideOutline(this.datePicker);
    } else {
      this.blurWhileOpened = true;
    }
  }
  onOverlayFocusOut(event) {
    if (!this.datePicker.contains(event.relatedTarget)) {
      this.blurWhileOpened = true;
    }
  }
  onOpenedChanged(event) {
    if (event.detail.value === true && this.isFullscreen()) {
      this.showOutline(this.datePicker);
    }
    if (event.detail.value === false && this.blurWhileOpened) {
      this.blurWhileOpened = false;
      this.hideOutline(this.datePicker);
    }
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class DateObserver extends DatePickerObserver {
  constructor(datePicker, host) {
    super(datePicker);
    this.component = host;
  }
  getFieldIndex() {
    return 0;
  }
}
class TimeObserver extends FieldObserver {
  constructor(timePicker, host) {
    super(timePicker);
    this.component = host;
    this.timePicker = timePicker;
  }
  getFocusTarget(_event) {
    return this.timePicker;
  }
  getFieldIndex() {
    return 1;
  }
}
class DateTimePickerObserver extends ComponentObserver {
  constructor(picker) {
    super(picker);
    const [datePicker, timePicker] = this.getFields();
    this.dateObserver = new DateObserver(datePicker, picker);
    this.timeObserver = new TimeObserver(timePicker, picker);
  }
  getFields() {
    return [this.component.querySelector("[slot=date-picker]"), this.component.querySelector("[slot=time-picker]")];
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class ListBoxObserver extends FieldObserver {
  getFields() {
    return this.component.items || [];
  }
  getFocusTarget(event) {
    const fields2 = this.getFields();
    return Array.from(event.composedPath()).find((node) => fields2.includes(node));
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class RadioGroupObserver extends FieldObserver {
  getFields() {
    return this.component.__radioButtons;
  }
  getFocusTarget(event) {
    const fields2 = this.getFields();
    return Array.from(event.composedPath()).find((node) => fields2.includes(node));
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class SelectObserver extends FieldObserver {
  constructor(select) {
    super(select);
    this.overlay = select._overlayElement;
  }
  onFocusIn(event) {
    if (this.overlay._contentRoot.contains(event.target)) {
      return;
    }
    if (this.overlay._contentRoot.contains(event.relatedTarget)) {
      return;
    }
    super.onFocusIn(event);
  }
  onFocusOut(event) {
    if (this.overlay._contentRoot.contains(event.relatedTarget)) {
      return;
    }
    if (this.overlay._contentRoot.contains(event.target) && this.component.contains(event.relatedTarget)) {
      return;
    }
    super.onFocusOut(event);
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const initFieldObserver = (field2) => {
  let result;
  switch (field2.tagName.toLowerCase()) {
    /* c8 ignore next */
    case "vaadin-date-picker":
      result = new DatePickerObserver(field2);
      break;
    /* c8 ignore next */
    case "vaadin-date-time-picker":
      result = new DateTimePickerObserver(field2);
      break;
    /* c8 ignore next */
    case "vaadin-select":
      result = new SelectObserver(field2);
      break;
    /* c8 ignore next 2 */
    case "vaadin-checkbox-group":
      result = new CheckboxGroupObserver(field2);
      break;
    case "vaadin-radio-group":
      result = new RadioGroupObserver(field2);
      break;
    case "vaadin-list-box":
      result = new ListBoxObserver(field2);
      break;
    default:
      result = new FieldObserver(field2);
  }
  return result;
};
class FieldHighlighterController {
  constructor(host) {
    this.host = host;
    this.user = null;
    this.users = [];
  }
  get user() {
    return this._user;
  }
  set user(user) {
    this._user = user;
    if (user) {
      const msg = `${user.name} started editing`;
      const { label } = this.host;
      announce(label ? `${msg} ${label}` : msg);
    }
  }
  hostConnected() {
    this.redraw();
  }
  addUser(user) {
    if (user) {
      this.users.push(user);
      this.redraw();
      this.user = user;
    }
  }
  setUsers(users) {
    if (Array.isArray(users)) {
      this.users = users;
      this.redraw();
      this.user = users[users.length - 1] || null;
    }
  }
  removeUser(user) {
    if (user && user.id !== void 0) {
      let index;
      for (let i2 = 0; i2 < this.users.length; i2++) {
        if (this.users[i2].id === user.id) {
          index = i2;
          break;
        }
      }
      if (index !== void 0) {
        this.users.splice(index, 1);
        this.redraw();
        if (this.users.length > 0) {
          this.user = this.users[this.users.length - 1];
        } else {
          this.user = null;
        }
      }
    }
  }
  redraw() {
    this.observer.redraw([...this.users].reverse());
  }
}
class FieldHighlighter extends HTMLElement {
  static get is() {
    return "vaadin-field-highlighter";
  }
  static init(field2) {
    if (!field2._highlighterController) {
      const instance = new FieldHighlighterController(field2);
      field2.setAttribute("has-highlighter", "");
      instance.observer = initFieldObserver(field2);
      field2.addController(instance);
      field2._highlighterController = instance;
    }
    return field2._highlighterController;
  }
  static addUser(field2, user) {
    this.init(field2).addUser(user);
  }
  static removeUser(field2, user) {
    this.init(field2).removeUser(user);
  }
  static setUsers(field2, users) {
    this.init(field2).setUsers(users);
  }
}
defineCustomElement(FieldHighlighter);
/**
 * @license
 * Copyright (c) 2019 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const accordionHeading = [
  detailsSummary("vaadin-accordion-heading"),
  css$h`
    button {
      align-items: center;
      appearance: none;
      background: transparent;
      border: 0;
      color: inherit;
      cursor: inherit;
      display: flex;
      font: inherit;
      gap: inherit;
      outline: none;
      padding: 0;
      touch-action: manipulation;
    }
  `
];
/**
 * @license
 * Copyright (c) 2019 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-accordion-heading";
  }
  static get shadowRootOptions() {
    return { ...LitElement.shadowRootOptions, delegatesFocus: true };
  }
  static get styles() {
    return accordionHeading;
  }
  static get properties() {
    return {
      /**
       * When true, the element is opened.
       */
      opened: {
        type: Boolean,
        reflectToAttribute: true,
        sync: true,
        value: false
      }
    };
  }
  /** @protected */
  render() {
    return html`
      <button id="button" part="content" ?disabled="${this.disabled}" aria-expanded="${this.opened ? "true" : "false"}">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    if (!this.hasAttribute("role")) {
      this.setAttribute("role", "heading");
    }
  }
}
defineCustomElement(AccordionHeading);
/**
 * @license
 * Copyright (c) 2019 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const accordionPanel = css$h`
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    box-sizing: border-box;
  }

  :host(:not([opened])) [part='content'] {
    display: none !important;
  }

  :host([focus-ring]) {
    --_focus-ring: 1;
  }
`;
/**
 * @license
 * Copyright (c) 2019 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const AccordionPanelMixin = (superClass) => class AccordionPanelMixinClass extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(superClass))) {
  static get properties() {
    return {
      /**
       * A text that is displayed in the heading, if no
       * element is assigned to the `summary` slot.
       */
      summary: {
        type: String,
        observer: "_summaryChanged"
      }
    };
  }
  static get observers() {
    return ["__updateAriaAttributes(focusElement, _contentElements)"];
  }
  static get delegateProps() {
    return ["disabled", "opened", "_theme"];
  }
  constructor() {
    super();
    this._summaryController = new SummaryController(this, "vaadin-accordion-heading");
    this._summaryController.addEventListener("slot-content-changed", (event) => {
      const { node } = event.target;
      this._setFocusElement(node);
      this.stateTarget = node;
      this._tooltipController.setTarget(node);
    });
    this._tooltipController = new TooltipController(this);
    this._tooltipController.setPosition("bottom-start");
  }
  /**
   * @protected
   * @override
   */
  __forwardTabIndex(tabindex) {
    super.__forwardTabIndex(tabindex);
    if (tabindex !== void 0 && this.focusElement) {
      this.focusElement.$.button.tabIndex = tabindex;
      this.focusElement.tabIndex = -1;
    }
  }
  /** @protected */
  ready() {
    super.ready();
    this.addController(this._summaryController);
    this.addController(this._tooltipController);
  }
  /**
   * Override method from `DelegateStateMixin` to set delegate `theme`
   * using attribute instead of property (needed for the Lit version).
   * @protected
   * @override
   */
  _delegateProperty(name, value) {
    if (!this.stateTarget) {
      return;
    }
    if (name === "_theme") {
      this._delegateAttribute("theme", value);
      return;
    }
    super._delegateProperty(name, value);
  }
  /**
   * Override method inherited from `DisabledMixin`
   * to not set `aria-disabled` on the host element.
   *
   * @protected
   * @override
   */
  _setAriaDisabled() {
  }
  /** @private */
  _summaryChanged(summary) {
    this._summaryController.setSummary(summary);
  }
  /** @private */
  __updateAriaAttributes(focusElement, contentElements) {
    if (focusElement && contentElements) {
      const node = contentElements[0];
      if (node) {
        node.setAttribute("role", "region");
        node.setAttribute("aria-labelledby", focusElement.id);
      }
      if (node && node.id) {
        focusElement.setAttribute("aria-controls", node.id);
      } else {
        focusElement.removeAttribute("aria-controls");
      }
    }
  }
};
/**
 * @license
 * Copyright (c) 2019 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AccordionPanel extends AccordionPanelMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-accordion-panel";
  }
  static get styles() {
    return accordionPanel;
  }
  /** @protected */
  render() {
    return html`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `;
  }
}
defineCustomElement(AccordionPanel);
/**
 * @license
 * Copyright (c) 2019 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const AccordionMixin = (superClass) => class AccordionMixinClass extends KeyboardDirectionMixin(superClass) {
  static get properties() {
    return {
      /**
       * The index of currently opened panel. First panel is opened by
       * default. Only one panel can be opened at the same time.
       * Setting null or undefined closes all the accordion panels.
       * @type {number}
       */
      opened: {
        type: Number,
        value: 0,
        notify: true,
        reflectToAttribute: true
      },
      /**
       * The list of `<vaadin-accordion-panel>` child elements.
       * It is populated from the elements passed to the light DOM,
       * and updated dynamically when adding or removing panels.
       * @type {!Array<!AccordionPanel>}
       */
      items: {
        type: Array,
        readOnly: true,
        notify: true
      }
    };
  }
  static get observers() {
    return ["_updateItems(items, opened)"];
  }
  constructor() {
    super();
    this._boundUpdateOpened = this._updateOpened.bind(this);
  }
  /**
   * Override getter from `KeyboardDirectionMixin`
   * to check if the heading element has focus.
   *
   * @return {Element | null}
   * @protected
   * @override
   */
  get focused() {
    return (this._getItems() || []).find((item) => isElementFocused(item.focusElement));
  }
  /**
   * @param {FocusOptions=} options
   * @protected
   * @override
   */
  focus(options2) {
    if (this._observer) {
      this._observer.flush();
    }
    super.focus(options2);
  }
  /** @protected */
  ready() {
    super.ready();
    const slot = this.shadowRoot.querySelector("slot");
    this._observer = new SlotObserver(slot, (info) => {
      this._setItems(this._filterItems(Array.from(this.children)));
      this._filterItems(info.addedNodes).forEach((el) => {
        el.addEventListener("opened-changed", this._boundUpdateOpened);
      });
    });
  }
  /**
   * Override method inherited from `KeyboardDirectionMixin`
   * to use the stored list of accordion panels as items.
   *
   * @return {Element[]}
   * @protected
   * @override
   */
  _getItems() {
    return this.items;
  }
  /**
   * @param {!Array<!Element>} array
   * @return {!Array<!AccordionPanel>}
   * @protected
   */
  _filterItems(array) {
    return array.filter((el) => el instanceof customElements.get("vaadin-accordion-panel"));
  }
  /** @private */
  _updateItems(items, opened) {
    if (items) {
      this.__itemsSync = true;
      const itemToOpen = items[opened];
      items.forEach((item) => {
        item.opened = item === itemToOpen;
      });
      this.__itemsSync = false;
    }
  }
  /**
   * Override an event listener from `KeyboardMixin`
   * to only handle details toggle buttons events.
   *
   * @param {!KeyboardEvent} event
   * @protected
   * @override
   */
  _onKeyDown(event) {
    if (!this.items.some((item) => item.focusElement === event.target)) {
      return;
    }
    super._onKeyDown(event);
  }
  /** @private */
  _updateOpened(e) {
    if (this.__itemsSync) {
      return;
    }
    const target = this._filterItems(e.composedPath())[0];
    const idx2 = this.items.indexOf(target);
    if (e.detail.value) {
      if (target.disabled || idx2 === -1) {
        return;
      }
      this.opened = idx2;
    } else if (!this.items.some((item) => item.opened)) {
      this.opened = null;
    }
  }
};
/**
 * @license
 * Copyright (c) 2019 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class Accordion extends AccordionMixin(ThemableMixin(ElementMixin(PolylitMixin(LitElement)))) {
  static get is() {
    return "vaadin-accordion";
  }
  static get styles() {
    return css$h`
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }
    `;
  }
  /** @protected */
  render() {
    return html`<slot></slot>`;
  }
}
defineCustomElement(Accordion);
/**
 * @license
 * Copyright (c) 2018 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
function _detectIosNavbar() {
  if (isIOS) {
    const innerHeight = window.innerHeight;
    const innerWidth = window.innerWidth;
    const landscape = innerWidth > innerHeight;
    const clientHeight = document.documentElement.clientHeight;
    if (landscape && clientHeight > innerHeight) {
      document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom", `${clientHeight - innerHeight}px`);
    } else {
      document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom", "");
    }
  }
}
_detectIosNavbar();
window.addEventListener("resize", _detectIosNavbar);
/**
 * @license
 * Copyright (c) 2018 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const appLayoutStyles = css$h`
  :host {
    display: block;
    box-sizing: border-box;
    height: 100%;
    --vaadin-app-layout-transition-duration: 0s;
    transition: padding var(--vaadin-app-layout-transition-duration);
    --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, auto);
    --vaadin-app-layout-touch-optimized: false;
    --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
    --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
    padding-top: max(var(--vaadin-app-layout-navbar-offset-top), var(--safe-area-inset-top));
    padding-bottom: max(var(--vaadin-app-layout-navbar-offset-bottom), var(--safe-area-inset-bottom));
  }

  :host(:dir(ltr)) [content] {
    padding-left: max(var(--vaadin-app-layout-drawer-offset-left), var(--safe-area-inset-left));
    padding-right: var(--safe-area-inset-right);
  }

  :host(:dir(rtl)) [content] {
    padding-left: var(--safe-area-inset-left);
    padding-right: max(var(--vaadin-app-layout-drawer-offset-left), var(--safe-area-inset-right));
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  @media (prefers-reduced-motion: no-preference) {
    :host(:not([no-anim])) {
      --vaadin-app-layout-transition-duration: 200ms;
    }
  }

  :host([drawer-opened]) {
    --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
  }

  :host([overlay]) {
    --vaadin-app-layout-drawer-offset-left: 0px;
  }

  :host(:not([no-scroll])) [content] {
    overflow: auto;
  }

  [content] {
    height: 100%;
    transition: inherit;
  }

  @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
    :host {
      --vaadin-app-layout-touch-optimized: true;
    }
  }

  [part~='navbar'] {
    position: fixed;
    display: flex;
    align-items: center;
    top: 0;
    inset-inline: 0;
    transition: inset-inline-start var(--vaadin-app-layout-transition-duration);
    padding-top: max(var(--vaadin-app-layout-navbar-padding-top, var(--vaadin-padding-s)), var(--safe-area-inset-top));
    padding-bottom: var(--vaadin-app-layout-navbar-padding-bottom, var(--vaadin-padding-s));
    padding-inline-start: max(
      var(--vaadin-app-layout-navbar-padding-inline-start, var(--vaadin-padding-s)),
      var(--safe-area-inset-left)
    );
    /* stylelint-disable-next-line declaration-block-no-redundant-longhand-properties */
    padding-inline-end: max(
      var(--vaadin-app-layout-navbar-padding-inline-end, var(--vaadin-padding-s)),
      var(--safe-area-inset-right)
    );
    z-index: 1;
    gap: var(--vaadin-app-layout-navbar-gap, var(--vaadin-gap-s));
    background: var(--vaadin-app-layout-navbar-background, var(--vaadin-background-container));
  }

  :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part~='navbar'] {
    inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
  }

  :host([primary-section='drawer']) [part='drawer'] {
    top: 0;
  }

  [part~='navbar-bottom'] {
    top: auto;
    bottom: 0;
    padding-top: var(--vaadin-app-layout-navbar-padding-top, var(--vaadin-padding-s));
    padding-bottom: max(
      var(--vaadin-app-layout-navbar-padding-bottom, var(--vaadin-padding-s)),
      var(--safe-area-inset-bottom)
    );
  }

  [part='drawer'] {
    overflow: auto;
    overscroll-behavior: contain;
    position: fixed;
    top: var(--vaadin-app-layout-navbar-offset-top, 0);
    bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
    inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
    transition:
      transform var(--vaadin-app-layout-transition-duration),
      visibility var(--vaadin-app-layout-transition-duration);
    transform: translateX(-100%);
    max-width: 90%;
    width: var(--_vaadin-app-layout-drawer-width);
    box-sizing: border-box;
    padding-block: var(--safe-area-inset-top) var(--safe-area-inset-bottom);
    outline: none;
    /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
    visibility: hidden;
    display: flex;
    flex-direction: column;
    background: var(--vaadin-app-layout-drawer-background, transparent);
  }

  [part='drawer']:dir(ltr) {
    padding-left: var(--safe-area-inset-left);
  }

  [part='drawer']:dir(rtl) {
    padding-right: var(--safe-area-inset-right);
  }

  :host([has-navbar]:not([overlay])) [part='drawer'],
  :host([has-navbar]) [content] {
    --safe-area-inset-top: 0px;
  }

  :host([has-drawer]:not([overlay])[drawer-opened]) [content] {
    &:dir(ltr) {
      --safe-area-inset-left: 0px;
    }

    &:dir(rtl) {
      --safe-area-inset-right: 0px;
    }
  }

  :host([drawer-opened]) [part='drawer'] {
    /* The drawer should be accessible by the tabbing navigation when it is opened. */
    visibility: visible;
    transform: translateX(0%);
    touch-action: manipulation;
  }

  [part='backdrop'] {
    background: var(--vaadin-overlay-backdrop-background, rgba(0, 0, 0, 0.2));
    forced-color-adjust: none;
  }

  :host(:not([drawer-opened])) [part='backdrop'] {
    opacity: 0 !important;
  }

  :host([overlay]) [part='backdrop'] {
    position: fixed;
    inset: 0;
    pointer-events: none;
    transition: opacity var(--vaadin-app-layout-transition-duration);
    -webkit-tap-highlight-color: transparent;
  }

  :host([overlay]) [part='drawer'] {
    top: 0;
    bottom: 0;
    box-shadow: var(--vaadin-overlay-shadow, 0 8px 24px -4px rgba(0, 0, 0, 0.3));
    background: var(--vaadin-app-layout-drawer-background, var(--vaadin-background-color));
  }

  :host([overlay]) [part='drawer'],
  :host([overlay]) [part='backdrop'] {
    z-index: 2;
  }

  :host([drawer-opened][overlay]) [part='backdrop'] {
    pointer-events: auto;
    touch-action: manipulation;
  }

  :host([dir='rtl']) [part='drawer'] {
    transform: translateX(100%);
  }

  :host([dir='rtl'][drawer-opened]) [part='drawer'] {
    transform: translateX(0%);
  }

  @media (max-width: 800px), (max-height: 600px) {
    :host {
      --vaadin-app-layout-drawer-overlay: true;
      --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 320px);
    }
  }

  /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
  [part='drawer'] ::slotted(vaadin-scroller) {
    flex: 1;
    overscroll-behavior: contain;
  }

  @media (forced-colors: active) {
    :host([overlay]) [part='drawer'] {
      border: 3px solid;
    }
  }
`;
/**
 * @license
 * Copyright (c) 2017 Anton Korzunov
 * SPDX-License-Identifier: MIT
 */
let counterMap = /* @__PURE__ */ new WeakMap();
let uncontrolledNodes = /* @__PURE__ */ new WeakMap();
let markerMap = {};
let lockCount = 0;
const isElement = (node) => node && node.nodeType === Node.ELEMENT_NODE;
const logError = (...args) => {
  console.error(`Error: ${args.join(" ")}. Skip setting aria-hidden.`);
};
const correctTargets = (parent, targets) => {
  if (!isElement(parent)) {
    logError(parent, "is not a valid element");
    return [];
  }
  return targets.map((target) => {
    if (!isElement(target)) {
      logError(target, "is not a valid element");
      return null;
    }
    let node = target;
    while (node && node !== parent) {
      if (parent.contains(node)) {
        return target;
      }
      node = node.getRootNode().host;
    }
    logError(target, "is not contained inside", parent);
    return null;
  }).filter((x) => Boolean(x));
};
const applyAttributeToOthers = (originalTarget, parentNode, markerName, controlAttribute) => {
  const targets = correctTargets(parentNode, Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  if (!markerMap[markerName]) {
    markerMap[markerName] = /* @__PURE__ */ new WeakMap();
  }
  const markerCounter = markerMap[markerName];
  const hiddenNodes = [];
  const elementsToKeep = /* @__PURE__ */ new Set();
  const elementsToStop = new Set(targets);
  const keep = (el) => {
    if (!el || elementsToKeep.has(el)) {
      return;
    }
    elementsToKeep.add(el);
    const slot = el.assignedSlot;
    if (slot) {
      keep(slot);
    }
    keep(el.parentNode || el.host);
  };
  targets.forEach(keep);
  const deep = (parent) => {
    if (!parent || elementsToStop.has(parent)) {
      return;
    }
    const root = parent.shadowRoot;
    const children = root ? [...parent.children, ...root.children] : [...parent.children];
    children.forEach((node) => {
      if (["template", "script", "style"].includes(node.localName)) {
        return;
      }
      if (elementsToKeep.has(node)) {
        deep(node);
      } else {
        const attr2 = node.getAttribute(controlAttribute);
        const alreadyHidden = attr2 !== null && attr2 !== "false";
        const counterValue = (counterMap.get(node) || 0) + 1;
        const markerValue = (markerCounter.get(node) || 0) + 1;
        counterMap.set(node, counterValue);
        markerCounter.set(node, markerValue);
        hiddenNodes.push(node);
        if (counterValue === 1 && alreadyHidden) {
          uncontrolledNodes.set(node, true);
        }
        if (markerValue === 1) {
          node.setAttribute(markerName, "true");
        }
        if (!alreadyHidden) {
          node.setAttribute(controlAttribute, "true");
        }
      }
    });
  };
  deep(parentNode);
  elementsToKeep.clear();
  lockCount += 1;
  return () => {
    hiddenNodes.forEach((node) => {
      const counterValue = counterMap.get(node) - 1;
      const markerValue = markerCounter.get(node) - 1;
      counterMap.set(node, counterValue);
      markerCounter.set(node, markerValue);
      if (!counterValue) {
        if (uncontrolledNodes.has(node)) {
          uncontrolledNodes.delete(node);
        } else {
          node.removeAttribute(controlAttribute);
        }
      }
      if (!markerValue) {
        node.removeAttribute(markerName);
      }
    });
    lockCount -= 1;
    if (!lockCount) {
      counterMap = /* @__PURE__ */ new WeakMap();
      counterMap = /* @__PURE__ */ new WeakMap();
      uncontrolledNodes = /* @__PURE__ */ new WeakMap();
      markerMap = {};
    }
  };
};
const hideOthers = (originalTarget, parentNode = document.body, markerName = "data-aria-hidden") => {
  const targets = Array.from(Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  if (parentNode) {
    targets.push(...Array.from(parentNode.querySelectorAll("[aria-live]")));
  }
  return applyAttributeToOthers(targets, parentNode, markerName, "aria-hidden");
};
/**
 * @license
 * Copyright (c) 2021 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AriaModalController {
  /**
   * @param {HTMLElement} host
   */
  constructor(host, callback) {
    this.host = host;
    this.callback = typeof callback === "function" ? callback : () => host;
  }
  /**
   * Make the controller host modal by hiding other elements from screen readers
   * using `aria-hidden` attribute (can be replaced with `inert` in the future).
   *
   * The method name is chosen to align with the one provided by native `<dialog>`:
   * https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement/showModal
   */
  showModal() {
    const targets = this.callback();
    this.__showOthers = hideOthers(targets);
  }
  /**
   * Remove `aria-hidden` from other elements unless there are any other
   * controller hosts on the page activated by using `showModal()` call.
   */
  close() {
    if (this.__showOthers) {
      this.__showOthers();
      this.__showOthers = null;
    }
  }
}
/**
 * @license
 * Copyright (c) 2018 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const DEFAULT_I18N$a = {
  drawer: "Drawer"
};
const AppLayoutMixin = (superclass) => class AppLayoutMixinClass extends I18nMixin(DEFAULT_I18N$a, superclass) {
  static get properties() {
    return {
      /**
       * Defines whether navbar or drawer will come first visually.
       * - By default (`primary-section="navbar"`), the navbar takes the full available width and moves the drawer down.
       * - If `primary-section="drawer"` is set, then the drawer will move the navbar, taking the full available height.
       * @attr {navbar|drawer} primary-section
       * @type {!PrimarySection}
       */
      primarySection: {
        type: String,
        value: "navbar",
        notify: true,
        reflectToAttribute: true,
        observer: "__primarySectionChanged",
        sync: true
      },
      /**
       * Controls whether the drawer is opened (visible) or not.
       * Its default value depends on the viewport:
       * - `true`, for desktop size views
       * - `false`, for mobile size views
       * @attr {boolean} drawer-opened
       * @type {boolean}
       */
      drawerOpened: {
        type: Boolean,
        notify: true,
        value: true,
        reflectToAttribute: true,
        observer: "__drawerOpenedChanged",
        sync: true
      },
      /**
       * Drawer is an overlay on top of the content
       * Controlled via CSS using `--vaadin-app-layout-drawer-overlay: true|false`;
       * @type {boolean}
       */
      overlay: {
        type: Boolean,
        notify: true,
        readOnly: true,
        value: false,
        reflectToAttribute: true,
        observer: "__overlayChanged",
        sync: true
      },
      /**
       * A global event that causes the drawer to close (be hidden) when it is in overlay mode.
       * - The default is `vaadin-router-location-changed` dispatched by Vaadin Router
       *
       * @attr {string} close-drawer-on
       * @type {string}
       */
      closeDrawerOn: {
        type: String,
        value: "vaadin-router-location-changed",
        observer: "_closeDrawerOnChanged"
      }
    };
  }
  static get observers() {
    return ["__i18nChanged(__effectiveI18n)"];
  }
  /**
   * Helper static method that dispatches a `close-overlay-drawer` event
   */
  static dispatchCloseOverlayDrawerEvent() {
    window.dispatchEvent(new CustomEvent("close-overlay-drawer"));
  }
  /**
   * The object used to localize this component. To change the default
   * localization, replace this with an object that provides all properties, or
   * just the individual properties you want to change.
   *
   * The object has the following structure and default values:
   * ```js
   * {
   *   drawer: 'Drawer'
   * }
   * ```
   * @return {!AppLayoutI18n}
   */
  get i18n() {
    return super.i18n;
  }
  set i18n(value) {
    super.i18n = value;
  }
  constructor() {
    super();
    this.__boundResizeListener = this._resize.bind(this);
    this.__drawerToggleClickListener = this._drawerToggleClick.bind(this);
    this.__onDrawerKeyDown = this.__onDrawerKeyDown.bind(this);
    this.__closeOverlayDrawerListener = this.__closeOverlayDrawer.bind(this);
    this.__trapFocusInDrawer = this.__trapFocusInDrawer.bind(this);
    this.__releaseFocusFromDrawer = this.__releaseFocusFromDrawer.bind(this);
    this.__ariaModalController = new AriaModalController(this, () => [
      ...this.querySelectorAll('vaadin-drawer-toggle, [slot="drawer"]')
    ]);
    this.__focusTrapController = new FocusTrapController(this);
  }
  /** @protected */
  connectedCallback() {
    super.connectedCallback();
    this._blockAnimationUntilAfterNextRender();
    window.addEventListener("resize", this.__boundResizeListener);
    this.addEventListener("drawer-toggle-click", this.__drawerToggleClickListener);
    requestAnimationFrame(() => {
      this._updateOffsetSize();
    });
    this._updateTouchOptimizedMode();
    this._updateDrawerSize();
    this._updateOverlayMode();
    this._navbarSizeObserver = new ResizeObserver(() => {
      requestAnimationFrame(() => {
        if (this.__isDrawerAnimating) {
          this.__updateOffsetSizePending = true;
        } else {
          this._updateOffsetSize();
        }
      });
    });
    this._navbarSizeObserver.observe(this.$.navbarTop);
    this._navbarSizeObserver.observe(this.$.navbarBottom);
    this._navbarSizeObserver.observe(this.$.drawer);
    window.addEventListener("close-overlay-drawer", this.__closeOverlayDrawerListener);
    window.addEventListener("keydown", this.__onDrawerKeyDown);
  }
  /** @protected */
  ready() {
    super.ready();
    this.addController(this.__focusTrapController);
    this.__setAriaExpanded();
    this.$.drawer.addEventListener("transitionstart", () => {
      this.__isDrawerAnimating = true;
    });
    this.$.drawer.addEventListener("transitionend", () => {
      if (this.__updateOffsetSizePending) {
        this.__updateOffsetSizePending = false;
        this._updateOffsetSize();
      }
      requestAnimationFrame(() => {
        this.__isDrawerAnimating = false;
      });
    });
  }
  /** @protected */
  disconnectedCallback() {
    super.disconnectedCallback();
    window.removeEventListener("resize", this.__boundResizeListener);
    this.removeEventListener("drawer-toggle-click", this.__drawerToggleClickListener);
    window.removeEventListener("close-overlay-drawer", this.__drawerToggleClickListener);
    window.removeEventListener("keydown", this.__onDrawerKeyDown);
  }
  /** @private */
  __onNavbarSlotChange() {
    this._updateTouchOptimizedMode();
    this.toggleAttribute("has-navbar", !!this.querySelector('[slot="navbar"]'));
  }
  /** @private */
  __onDrawerSlotChange() {
    this._updateDrawerSize();
    this.toggleAttribute("has-drawer", !!this.querySelector('[slot="drawer"]'));
  }
  /**
   * A callback for the `primarySection` property observer.
   *
   * Ensures the property is set to its default value `navbar`
   * whenever the new value is not one of the valid values: `navbar`, `drawer`.
   *
   * @param {string} value
   * @private
   */
  __primarySectionChanged(value) {
    const isValid2 = ["navbar", "drawer"].includes(value);
    if (!isValid2) {
      this.primarySection = "navbar";
    }
  }
  /**
   * A callback for the `drawerOpened` property observer.
   *
   * When the drawer opens, the method ensures the drawer has a proper height and sets focus on it.
   * As long as the drawer is open, the focus is trapped within the drawer.
   *
   * When the drawer closes, the method releases focus from the drawer, setting focus on the drawer toggle.
   *
   * @param {boolean} drawerOpened
   * @param {boolean} oldDrawerOpened
   * @private
   */
  __drawerOpenedChanged(drawerOpened, oldDrawerOpened) {
    if (this.overlay) {
      if (drawerOpened) {
        this.__trapFocusInDrawer();
      } else if (oldDrawerOpened) {
        this.__releaseFocusFromDrawer();
      }
    }
    this.__setAriaExpanded();
  }
  /**
   * A callback for the `overlay` property observer.
   *
   * When layout resizes while in the overlay mode, drawer opened state
   * is not changed, but focus trap needs to be removed.
   *
   * @param {boolean} overlay
   * @param {boolean} oldOverlay
   * @private
   */
  __overlayChanged(_overlay, oldOverlay) {
    if (oldOverlay) {
      this.__restoreFocus();
    }
  }
  /**
   * A callback for the `i18n` property observer.
   *
   * The method ensures the drawer has ARIA attributes updated
   * once the `i18n` property changes.
   *
   * @private
   */
  __i18nChanged() {
    this.__updateDrawerAriaAttributes();
  }
  /** @private */
  _drawerToggleClick(e) {
    e.stopPropagation();
    this.drawerOpened = !this.drawerOpened;
  }
  /** @private */
  __closeOverlayDrawer() {
    if (this.overlay) {
      this.drawerOpened = false;
    }
  }
  /** @private */
  __setAriaExpanded() {
    const toggle = this.querySelector("vaadin-drawer-toggle");
    if (toggle) {
      toggle.setAttribute("aria-expanded", this.drawerOpened);
    }
  }
  /** @protected */
  _updateDrawerSize() {
    const childCount = this.querySelectorAll("[slot=drawer]").length;
    const drawer = this.$.drawer;
    if (childCount === 0) {
      drawer.setAttribute("hidden", "");
      this.style.setProperty("--_vaadin-app-layout-drawer-width", 0);
    } else {
      drawer.removeAttribute("hidden");
      this.style.removeProperty("--_vaadin-app-layout-drawer-width");
    }
    this._updateOffsetSize();
  }
  /** @private */
  _resize() {
    this._blockAnimationUntilAfterNextRender();
    this._updateTouchOptimizedMode();
    this._updateOverlayMode();
  }
  /** @protected */
  _updateOffsetSize() {
    const navbar = this.$.navbarTop;
    const navbarRect = navbar.getBoundingClientRect();
    const navbarBottom = this.$.navbarBottom;
    const navbarBottomRect = navbarBottom.getBoundingClientRect();
    const drawer = this.$.drawer;
    const drawerRect = drawer.getBoundingClientRect();
    this.style.setProperty("--_vaadin-app-layout-navbar-offset-size", `${navbarRect.height}px`);
    this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom", `${navbarBottomRect.height}px`);
    this.style.setProperty("--_vaadin-app-layout-drawer-offset-size", `${drawerRect.width}px`);
  }
  /** @protected */
  _updateOverlayMode() {
    const overlay = this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay") === "true";
    if (!this.overlay && overlay) {
      this._drawerStateSaved = this.drawerOpened;
      this.drawerOpened = false;
    }
    this._setOverlay(overlay);
    if (!this.overlay && this._drawerStateSaved) {
      this.drawerOpened = this._drawerStateSaved;
      this._drawerStateSaved = null;
    }
    this.__updateDrawerAriaAttributes();
  }
  /**
   * Updates ARIA attributes on the drawer depending on the drawer mode.
   *
   * - In the overlay mode, the method marks the drawer with ARIA attributes as a dialog
   * labelled with the `i18n.drawer` property.
   * - In the normal mode, the method removes the ARIA attributes that has been set for the overlay mode.
   *
   * @private
   */
  __updateDrawerAriaAttributes() {
    const drawer = this.$.drawer;
    if (this.overlay) {
      drawer.setAttribute("role", "dialog");
      drawer.setAttribute("aria-modal", "true");
      drawer.setAttribute("aria-label", this.__effectiveI18n.drawer);
    } else {
      drawer.removeAttribute("role");
      drawer.removeAttribute("aria-modal");
      drawer.removeAttribute("aria-label");
    }
  }
  /**
   * Returns a promise that resolves when the drawer opening/closing CSS transition ends.
   *
   * @return {Promise}
   * @private
   */
  __drawerTransitionComplete() {
    return Promise.all(this.$.drawer.getAnimations().map((animation) => animation.finished));
  }
  /** @private */
  async __trapFocusInDrawer() {
    await this.__drawerTransitionComplete();
    if (!this.drawerOpened) {
      return;
    }
    this.$.drawer.setAttribute("tabindex", "0");
    this.__ariaModalController.showModal();
    this.__focusTrapController.trapFocus(this.$.drawer);
  }
  /** @private */
  async __releaseFocusFromDrawer() {
    await this.__drawerTransitionComplete();
    if (this.drawerOpened) {
      return;
    }
    this.__restoreFocus();
    const toggle = this.querySelector("vaadin-drawer-toggle");
    if (toggle) {
      toggle.focus({ focusVisible: isKeyboardActive() });
    }
  }
  /** @private */
  __restoreFocus() {
    this.__ariaModalController.close();
    this.__focusTrapController.releaseFocus();
    this.$.drawer.removeAttribute("tabindex");
  }
  /**
   * Closes the drawer on Escape press if it has been opened in the overlay mode.
   *
   * @param {KeyboardEvent} event
   * @private
   */
  __onDrawerKeyDown(event) {
    if (event.key === "Escape" && this.overlay) {
      this.drawerOpened = false;
    }
  }
  /** @private */
  _closeDrawerOnChanged(closeDrawerOn, oldCloseDrawerOn) {
    if (oldCloseDrawerOn) {
      window.removeEventListener(oldCloseDrawerOn, this.__closeOverlayDrawerListener);
    }
    if (closeDrawerOn) {
      window.addEventListener(closeDrawerOn, this.__closeOverlayDrawerListener);
    }
  }
  /** @private */
  _onBackdropClick() {
    this._close();
  }
  /** @private */
  _onBackdropTouchend(event) {
    event.preventDefault();
    this._close();
  }
  /** @protected */
  _close() {
    this.drawerOpened = false;
  }
  /** @private */
  _getCustomPropertyValue(customProperty) {
    const customPropertyValue = getComputedStyle(this).getPropertyValue(customProperty);
    return (customPropertyValue || "").trim().toLowerCase();
  }
  /** @protected */
  _updateTouchOptimizedMode() {
    const touchOptimized = this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized") === "true";
    const navbarItems = this.querySelectorAll('[slot*="navbar"]');
    if (navbarItems.length > 0) {
      Array.from(navbarItems).forEach((navbar) => {
        if (navbar.getAttribute("slot").indexOf("touch-optimized") > -1) {
          navbar.__touchOptimized = true;
        }
        if (touchOptimized && navbar.__touchOptimized) {
          navbar.setAttribute("slot", "navbar-bottom");
        } else {
          navbar.setAttribute("slot", "navbar");
        }
      });
    }
    if (this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length === 0) {
      this.$.navbarTop.setAttribute("hidden", "");
    } else {
      this.$.navbarTop.removeAttribute("hidden");
    }
    if (this.$.navbarBottom.querySelector("[name=navbar-bottom]").assignedNodes().length === 0) {
      this.$.navbarBottom.setAttribute("hidden", "");
    } else {
      this.$.navbarBottom.removeAttribute("hidden");
    }
    this._updateOffsetSize();
  }
  /** @protected */
  _blockAnimationUntilAfterNextRender() {
    this.setAttribute("no-anim", "");
    this.__debounceAnimation = Debouncer.debounce(this.__debounceAnimation, animationFrame, () => {
      setTimeout(() => {
        this.removeAttribute("no-anim");
      });
    });
  }
  /**
   * App Layout listens to `close-overlay-drawer` on the window level.
   * A custom event can be dispatched and the App Layout will close the drawer in overlay.
   *
   * That can be used, for instance, when a navigation occurs when user clicks in a menu item inside the drawer.
   *
   * See `dispatchCloseOverlayDrawerEvent()` helper method.
   *
   * @event close-overlay-drawer
   */
};
/**
 * @license
 * Copyright (c) 2018 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AppLayout extends AppLayoutMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-app-layout";
  }
  static get styles() {
    return appLayoutStyles;
  }
  /** @protected */
  render() {
    return html`
      <div part="navbar navbar-top" id="navbarTop">
        <slot name="navbar" @slotchange="${this.__onNavbarSlotChange}"></slot>
      </div>
      <div part="backdrop" @click="${this._onBackdropClick}" @touchend="${this._onBackdropTouchend}"></div>
      <div part="drawer" id="drawer">
        <slot name="drawer" id="drawerSlot" @slotchange="${this.__onDrawerSlotChange}"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar navbar-bottom" id="navbarBottom" hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden>
        <slot id="touchSlot" name="navbar touch-optimized" @slotchange="${this.__onNavbarSlotChange}"></slot>
      </div>
    `;
  }
}
defineCustomElement(AppLayout);
/**
 * @license
 * Copyright (c) 2018 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const drawerToggle = css$h`
  [part='icon'] {
    background: currentColor;
    display: block;
    height: var(--vaadin-icon-size, 1lh);
    mask: var(--_vaadin-icon-menu) 50% / var(--vaadin-icon-visual-size, 100%) no-repeat;
    width: var(--vaadin-icon-size, 1lh);
  }

  [hidden] {
    display: none !important;
  }

  @media (forced-colors: active) {
    [part='icon'] {
      background: CanvasText;
    }
  }
`;
/**
 * @license
 * Copyright (c) 2018 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class DrawerToggle extends ButtonMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-drawer-toggle";
  }
  static get styles() {
    return [buttonStyles, drawerToggle];
  }
  static get properties() {
    return {
      ariaLabel: {
        type: String,
        value: "Toggle navigation panel",
        reflectToAttribute: true,
        sync: true
      },
      /** @private */
      _showFallbackIcon: {
        type: Boolean,
        value: false
      }
    };
  }
  constructor() {
    super();
    this.addEventListener("click", () => {
      this.dispatchEvent(new CustomEvent("drawer-toggle-click", { bubbles: true, composed: true }));
    });
  }
  /** @protected */
  render() {
    return html`
      <slot id="slot" @slotchange="${this._toggleFallbackIcon}">
        <div part="icon"></div>
      </slot>
      <div part="icon" ?hidden="${!this._showFallbackIcon}"></div>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this._toggleFallbackIcon();
  }
  /** @private */
  _toggleFallbackIcon() {
    const nodes = this.$.slot.assignedNodes();
    this._showFallbackIcon = nodes.length > 0 && nodes.every((node) => isEmptyTextNode(node));
  }
}
defineCustomElement(DrawerToggle);
/**
 * @license
 * Copyright (c) 2017 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const avatarStyles = css$h`
  :host {
    display: inline-block;
    flex: none;
    border-radius: 50%;
    cursor: default;
    color: var(--vaadin-avatar-text-color, var(--vaadin-text-color-secondary));
    overflow: hidden;
    --_size: var(--vaadin-avatar-size, calc(1lh + var(--vaadin-padding-xs) * 2));
    height: var(--_size);
    width: var(--_size);
    border: var(--vaadin-focus-ring-width) solid transparent;
    margin: calc(var(--vaadin-focus-ring-width) * -1);
    background: var(--vaadin-avatar-background, var(--vaadin-background-container-strong));
    background-clip: content-box;
    vertical-align: middle;
    -webkit-user-select: none;
    user-select: none;
    -webkit-tap-highlight-color: transparent;
    position: relative;
    font-weight: var(--vaadin-avatar-font-weight, 400);
    font-size: var(--vaadin-avatar-font-size, inherit);
  }

  /* Overlay border on top of image and icon as well */
  :host::before {
    position: absolute;
    content: '';
    inset: calc(var(--vaadin-focus-ring-width) * -1);
    border-radius: inherit;
    outline: var(--vaadin-avatar-border-width, 1px) solid var(--vaadin-avatar-border-color, transparent);
    outline-offset: calc((var(--vaadin-focus-ring-width) + var(--vaadin-avatar-border-width, 1px)) * -1);
  }

  :host([role='button']) {
    cursor: var(--vaadin-clickable-cursor);
  }

  img {
    height: 100%;
    width: 100%;
    object-fit: cover;
  }

  [part='icon'] {
    height: 100%;
    mask: var(--_vaadin-icon-user) no-repeat center / 74%;
    background: currentColor;
  }

  [part='abbr'] {
    font-size: 2.75em;
    fill: currentColor;
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([has-color-index]) {
    background-color: var(--vaadin-avatar-user-color);
    color: oklch(
      from var(--vaadin-avatar-user-color) clamp(0, (0.62 - l) * 1000, 1) 0 0 / clamp(0.8, (0.62 - l) * 1000, 1)
    );
    --vaadin-avatar-border-width: 2px;
    --vaadin-avatar-border-color: var(--vaadin-avatar-user-color);
  }

  :host([focus-ring]) {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
    outline-offset: calc((var(--vaadin-focus-ring-width)) * -1);
  }

  @media (forced-colors: active) {
    :host {
      border-color: Canvas !important;
    }

    [part='icon'] {
      background: CanvasText !important;
    }
  }
`;
/**
 * @license
 * Copyright (c) 2017 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const DEFAULT_I18N$9 = {
  anonymous: "anonymous"
};
const AvatarMixin = (superClass) => class AvatarMixinClass extends I18nMixin(DEFAULT_I18N$9, FocusMixin(superClass)) {
  static get properties() {
    return {
      /**
       * The path to the image
       */
      img: {
        type: String,
        reflectToAttribute: true,
        observer: "__imgChanged"
      },
      /**
       * A shortened form of name that is displayed
       * in the avatar when `img` is not provided.
       */
      abbr: {
        type: String,
        reflectToAttribute: true
      },
      /**
       * Full name of the user
       * used for the tooltip of the avatar.
       */
      name: {
        type: String,
        reflectToAttribute: true
      },
      /**
       * Color index used for avatar background.
       * @attr {number} color-index
       */
      colorIndex: {
        type: Number,
        observer: "__colorIndexChanged"
      },
      /**
       * When true, the avatar has tooltip shown on hover and focus.
       * The tooltip text is based on the `name` and `abbr` properties.
       * When neither is provided, `i18n.anonymous` is used instead.
       * @attr {boolean} with-tooltip
       */
      withTooltip: {
        type: Boolean,
        value: false,
        observer: "__withTooltipChanged"
      },
      /** @protected */
      __imgVisible: Boolean,
      /** @protected */
      __iconVisible: Boolean,
      /** @protected */
      __abbrVisible: Boolean,
      /** @private */
      __tooltipNode: Object
    };
  }
  static get observers() {
    return [
      "__imgOrAbbrOrNameChanged(img, abbr, name)",
      "__i18nChanged(__effectiveI18n)",
      "__tooltipChanged(__tooltipNode, name, abbr)"
    ];
  }
  /**
   * The object used to localize this component. To change the default
   * localization, replace this with an object that provides all properties, or
   * just the individual properties you want to change.
   *
   * The object has the following JSON structure and default values:
   * ```js
   * {
   *   // Translation of the anonymous user avatar tooltip.
   *   anonymous: 'anonymous'
   * }
   * ```
   * @return {!AvatarI18n}
   */
  get i18n() {
    return super.i18n;
  }
  set i18n(value) {
    super.i18n = value;
  }
  /** @protected */
  ready() {
    super.ready();
    this.__updateVisibility();
    if (!this.hasAttribute("role")) {
      this.setAttribute("role", "img");
    }
    if (!this.name && !this.abbr) {
      this.__setTooltip();
    }
  }
  /** @private */
  __colorIndexChanged(index) {
    if (index != null) {
      this.setAttribute("has-color-index", "");
      this.style.setProperty("--vaadin-avatar-user-color", `var(--vaadin-user-color-${index})`);
    } else {
      this.removeAttribute("has-color-index");
      this.style.removeProperty("--vaadin-avatar-user-color");
    }
  }
  /** @private */
  __imgChanged() {
    this.__imgFailedToLoad = false;
  }
  /** @private */
  __imgOrAbbrOrNameChanged(_img, abbr, name) {
    this.__updateVisibility();
    if (abbr && abbr !== this.__generatedAbbr) {
      return;
    }
    if (name) {
      this.abbr = this.__generatedAbbr = name.split(" ").map((word) => word.charAt(0)).join("");
    } else {
      this.abbr = void 0;
    }
  }
  /** @private */
  __tooltipChanged(tooltipNode, name, abbr) {
    if (tooltipNode) {
      if (abbr && abbr !== this.__generatedAbbr) {
        this.__setTooltip(name ? `${name} (${abbr})` : abbr);
      } else {
        this.__setTooltip(name);
      }
    }
    if (abbr) {
      this.setAttribute("aria-label", !tooltipNode && name ? `${name} (${abbr})` : abbr);
    } else {
      this.removeAttribute("aria-label");
    }
  }
  /** @private */
  __withTooltipChanged(withTooltip, oldWithTooltip) {
    this.toggleAttribute("has-tooltip", withTooltip);
    if (withTooltip) {
      const tooltipNode = document.createElement("vaadin-tooltip");
      tooltipNode.setAttribute("slot", "tooltip");
      this.appendChild(tooltipNode);
      this.__tooltipNode = tooltipNode;
    } else if (oldWithTooltip) {
      this.__tooltipNode.target = null;
      this.__tooltipNode.remove();
      this.__tooltipNode = null;
    }
  }
  /** @private */
  __i18nChanged(effectiveI18n) {
    if (effectiveI18n && effectiveI18n.anonymous) {
      if (this.__oldAnonymous && this.__tooltipNode && this.__tooltipNode.text === this.__oldAnonymous) {
        this.__setTooltip();
      }
      this.__oldAnonymous = effectiveI18n.anonymous;
    }
  }
  /** @private */
  __updateVisibility() {
    this.__imgVisible = !!this.img && !this.__imgFailedToLoad;
    this.__abbrVisible = !this.__imgVisible && !!this.abbr;
    this.__iconVisible = !this.__imgVisible && !this.abbr;
  }
  /** @private */
  __setTooltip(tooltip) {
    const tooltipNode = this.__tooltipNode;
    if (tooltipNode) {
      tooltipNode.text = tooltip || this.__effectiveI18n.anonymous;
    }
  }
  /** @protected */
  __onImageLoadError() {
    if (this.img) {
      console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`);
      this.__imgFailedToLoad = true;
      this.__updateVisibility();
    }
  }
};
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class Avatar extends AvatarMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar";
  }
  static get styles() {
    return avatarStyles;
  }
  static get lumoInjector() {
    return { ...super.lumoInjector, includeBaseStyles: true };
  }
  /** @protected */
  render() {
    return html`
      <img
        ?hidden="${!this.__imgVisible}"
        src="${ifDefined(this.img)}"
        aria-hidden="true"
        @error="${this.__onImageLoadError}"
        draggable="false"
      />
      <div part="icon" ?hidden="${!this.__iconVisible}" aria-hidden="true"></div>
      <svg
        part="abbr"
        ?hidden="${!this.__abbrVisible}"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">${this.abbr}</text>
      </svg>

      <slot name="tooltip"></slot>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this._tooltipController = new TooltipController(this);
    this.addController(this._tooltipController);
  }
}
defineCustomElement(Avatar);
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const avatarGroupMenuStyles = css$h`
  :host {
    display: block;
    padding: var(--vaadin-item-overlay-padding, 4px);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='items'] {
    display: contents;
  }
`;
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar-group-menu";
  }
  static get styles() {
    return avatarGroupMenuStyles;
  }
  static get properties() {
    return {
      // We don't need to define this property since super default is vertical,
      // but we don't want it to be modified, or be shown in the API docs.
      /** @private */
      orientation: {
        readOnly: true
      }
    };
  }
  /**
   * @return {!HTMLElement}
   * @protected
   * @override
   */
  get _scrollerElement() {
    return this.shadowRoot.querySelector('[part="items"]');
  }
  /** @protected */
  render() {
    return html`
      <div part="items">
        <slot></slot>
      </div>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("role", "menu");
  }
}
defineCustomElement(AvatarGroupMenu);
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const menuItemStyles = css$h`
  [part='content'] {
    display: flex;
    align-items: center;
    gap: inherit;
  }
`;
const avatarGroupMenuItemStyles = [itemStyles, menuItemStyles];
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar-group-menu-item";
  }
  static get styles() {
    return avatarGroupMenuItemStyles;
  }
  /** @protected */
  render() {
    return html`
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("role", "menuitem");
  }
}
defineCustomElement(AvatarGroupMenuItem);
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroupOverlay extends PositionMixin(
  OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))))
) {
  static get is() {
    return "vaadin-avatar-group-overlay";
  }
  static get styles() {
    return overlayStyles$1;
  }
  /** @protected */
  render() {
    return html`
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `;
  }
}
defineCustomElement(AvatarGroupOverlay);
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const avatarGroupStyles = css$h`
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    /* 1: last on top */
    /* -1: first on top */
    --_dir: 1;
  }

  :host([theme~='reverse']) {
    --_dir: -1;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    display: flex;
    position: relative;
    width: 100%;
    flex-wrap: nowrap;
  }

  ::slotted(vaadin-avatar) {
    --_overlap: max(0px, var(--vaadin-avatar-group-overlap, 8px));
    --_gap: max(0px, var(--vaadin-avatar-group-gap, 2px));
    --_outline-width: var(--vaadin-focus-ring-width);
    --_d: var(--_dir);
    mask-image: url('data:image/svg+xml;utf8,<svg viewBox="0 0 300 300" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z" fill="black"/></svg>');
    mask-size: calc((100% - var(--_outline-width) * 2) * 3);
    mask-position: calc(50% + (100% - var(--_outline-width) * 2 - var(--_overlap)) * var(--_d));
  }

  :host(:dir(rtl)) ::slotted(vaadin-avatar) {
    --_d: calc(var(--_dir) * -1);
  }

  ::slotted(vaadin-avatar:not(:first-of-type)) {
    margin-inline-start: calc((var(--_outline-width) + var(--_overlap) - var(--_gap)) * -1);
  }

  :host(:not([theme~='reverse'])) ::slotted(vaadin-avatar:last-child),
  :host(:not([theme~='reverse']):not([has-overflow])) ::slotted(vaadin-avatar:nth-last-child(2)),
  :host([theme~='reverse']) ::slotted(vaadin-avatar:first-of-type) {
    mask-image: none;
  }
`;
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const MINIMUM_DISPLAYED_AVATARS = 2;
const DEFAULT_I18N$8 = {
  anonymous: "anonymous",
  activeUsers: {
    one: "Currently one active user",
    many: "Currently {count} active users"
  },
  joined: "{user} joined",
  left: "{user} left"
};
const AvatarGroupMixin = (superClass) => class AvatarGroupMixinClass extends I18nMixin(DEFAULT_I18N$8, ResizeMixin(superClass)) {
  static get properties() {
    return {
      /**
       * An array containing the items which will be stamped as avatars.
       *
       * The items objects allow to configure [`name`](#/elements/vaadin-avatar#property-name),
       * [`abbr`](#/elements/vaadin-avatar#property-abbr), [`img`](#/elements/vaadin-avatar#property-img)
       * and [`colorIndex`](#/elements/vaadin-avatar#property-colorIndex) properties on the
       * stamped avatars, and set `className` to provide CSS class names.
       *
       * #### Example
       *
       * ```js
       * group.items = [
       *   {
       *     name: 'User name',
       *     img: 'url-to-image.png',
       *     className: 'even'
       *   },
       *   {
       *     abbr: 'JD',
       *     colorIndex: 1,
       *     className: 'odd'
       *   },
       * ];
       * ```
       *
       * @type {!Array<!AvatarGroupItem> | undefined}
       */
      items: {
        type: Array,
        sync: true
      },
      /**
       * The maximum number of avatars to display. By default, all the avatars are displayed.
       * When _maxItemsVisible_ is set, the overflowing avatars are grouped into one avatar with
       * a dropdown. Setting 0 or 1 has no effect so there are always at least two avatars visible.
       * @attr {number} max-items-visible
       */
      maxItemsVisible: {
        type: Number,
        sync: true
      },
      /** @private */
      __itemsInView: {
        type: Number,
        value: null,
        sync: true
      },
      /** @private */
      _overflowItems: {
        type: Array
      },
      /** @private */
      _overflowLimit: {
        type: Number
      },
      /** @private */
      _opened: {
        type: Boolean,
        sync: true
      }
    };
  }
  /**
   * The object used to localize this component. To change the default
   * localization, replace this with an object that provides all properties, or
   * just the individual properties you want to change.
   *
   * The object has the following JSON structure and default values:
   * ```js
   * {
   *   // Translation of the anonymous user avatar tooltip.
   *   anonymous: 'anonymous',
   *   // Translation of the avatar group accessible label.
   *   // {count} is replaced with the actual count of users.
   *   activeUsers: {
   *     one: 'Currently one active user',
   *     many: 'Currently {count} active users'
   *   },
   *   // Screen reader announcement when user joins group.
   *   // {user} is replaced with the name or abbreviation.
   *   // When neither is set, "anonymous" is used instead.
   *   joined: '{user} joined',
   *   // Screen reader announcement when user leaves group.
   *   // {user} is replaced with the name or abbreviation.
   *   // When neither is set, "anonymous" is used instead.
   *   left: '{user} left'
   * }
   * ```
   * @return {!AvatarGroupI18n}
   */
  get i18n() {
    return super.i18n;
  }
  set i18n(value) {
    super.i18n = value;
  }
  /** @protected */
  get _avatars() {
    return [...this.children].filter((node) => node.localName === "vaadin-avatar");
  }
  /** @protected */
  ready() {
    super.ready();
    this._menuController = new SlotController(this, "overlay", "vaadin-avatar-group-menu", {
      initializer: (menu) => {
        menu.addEventListener("keydown", this._onListKeyDown.bind(this));
        this._menuElement = menu;
      }
    });
    this._overflowController = new SlotController(this, "overflow", "vaadin-avatar", {
      initializer: (overflow) => {
        overflow.setAttribute("role", "button");
        overflow.setAttribute("tabindex", "0");
        overflow.setAttribute("aria-haspopup", "menu");
        overflow.setAttribute("aria-expanded", "false");
        overflow.addEventListener("click", (e) => this._onOverflowClick(e));
        overflow.addEventListener("keydown", (e) => this._onOverflowKeyDown(e));
        const tooltip = document.createElement("vaadin-tooltip");
        tooltip.setAttribute("slot", "tooltip");
        overflow.appendChild(tooltip);
        this._overflow = overflow;
        this._overflowTooltip = tooltip;
      }
    });
    this.addController(this._menuController);
    this.addController(this._overflowController);
    this._overlayElement = this.$.overlay;
  }
  /** @protected */
  disconnectedCallback() {
    super.disconnectedCallback();
    this._opened = false;
  }
  /** @protected */
  willUpdate(props) {
    super.willUpdate(props);
    if (props.has("items") || props.has("__itemsInView") || props.has("maxItemsVisible")) {
      const count = Array.isArray(this.items) ? this.items.length : 0;
      const limit = this.__getLimit(count, this.__itemsInView, this.maxItemsVisible);
      this._overflowLimit = limit;
      this._overflowItems = limit ? this.items.slice(limit) : [];
    }
  }
  /** @protected */
  updated(props) {
    super.updated(props);
    if (props.has("items")) {
      this.__itemsChanged(this.items, props.get("items"));
    }
    if (props.has("items") || props.has("_overflowLimit") || props.has("__effectiveI18n") || props.has("_theme")) {
      const limit = this._overflowLimit;
      this.__renderAvatars(limit ? this.items.slice(0, limit) : this.items || []);
    }
    if (props.has("items") || props.has("_overflowLimit")) {
      this.__updateOverflowTooltip(this.items, this._overflowLimit);
      this.__updateOverflowAvatar(this.items, this._overflowLimit, this.__itemsInView);
    }
    if (props.has("__effectiveI18n") || props.has("items")) {
      this.__i18nItemsChanged(this.__effectiveI18n, this.items);
    }
    if (props.has("_opened")) {
      this.__openedChanged(this._opened, props.get("_opened"));
    }
    if (props.has("_theme")) {
      if (this._theme) {
        this._overflow.setAttribute("theme", this._theme);
      } else {
        this._overflow.removeAttribute("theme");
      }
    }
    if (props.has("_overflowItems") || props.has("__effectiveI18n") || props.has("_theme")) {
      this.__renderMenu();
    }
  }
  /** @private */
  __getMessage(user, action) {
    return action.replace("{user}", user.name || user.abbr || this.__effectiveI18n.anonymous);
  }
  /**
   * Renders items when they are provided by the `items` property and clears the content otherwise.
   * @private
   */
  __renderMenu() {
    render$1(
      html`
          ${(this._overflowItems || []).map(
        (item) => html`
              <vaadin-avatar-group-menu-item>
                <vaadin-avatar
                  .name="${item.name}"
                  .abbr="${item.abbr}"
                  .img="${item.img}"
                  .colorIndex="${item.colorIndex}"
                  .i18n="${this.__effectiveI18n}"
                  class="${ifDefined(item.className)}"
                  theme="${ifDefined(this._theme)}"
                  aria-hidden="true"
                ></vaadin-avatar>
                ${item.name || ""}
              </vaadin-avatar-group-menu-item>
            `
      )}
        `,
      this._menuElement,
      { host: this }
    );
  }
  /** @private */
  _onOverflowClick(e) {
    e.stopPropagation();
    if (this._opened) {
      this.$.overlay.close();
    } else if (!e.defaultPrevented) {
      this._opened = true;
    }
  }
  /** @private */
  _onOverflowKeyDown(e) {
    if (!this._opened) {
      if (/^(Enter|SpaceBar|\s)$/u.test(e.key)) {
        e.preventDefault();
        this._opened = true;
      }
    }
  }
  /** @private */
  _onListKeyDown(event) {
    if (event.key === "Escape" || event.key === "Tab") {
      this._opened = false;
    }
  }
  /**
   * @protected
   * @override
   */
  _onResize() {
    this.__setItemsInView();
  }
  /** @private */
  _onVaadinOverlayClose(e) {
    if (e.detail.sourceEvent && e.detail.sourceEvent.composedPath().includes(this)) {
      e.preventDefault();
    }
  }
  /** @private */
  _onVaadinOverlayOpen() {
    if (this._menuElement) {
      this._menuElement.focus();
    }
  }
  /** @private */
  __renderAvatars(items) {
    render$1(
      html`
          ${items.map(
        (item) => html`
              <vaadin-avatar
                .name="${item.name}"
                .abbr="${item.abbr}"
                .img="${item.img}"
                .colorIndex="${item.colorIndex}"
                .i18n="${this.__effectiveI18n}"
                theme="${ifDefined(this._theme)}"
                class="${ifDefined(item.className)}"
                tabindex="0"
                with-tooltip
              ></vaadin-avatar>
            `
      )}
        `,
      this,
      { renderBefore: this._overflow }
    );
  }
  /** @private */
  __updateOverflowAvatar(items, limit, itemsInView) {
    const overflow = this._overflow;
    if (overflow) {
      const count = Array.isArray(items) ? items.length : 0;
      const maxReached = this.maxItemsVisible != null && count > this.__getMax(this.maxItemsVisible);
      overflow.abbr = `+${count - limit}`;
      const hasOverflow = maxReached || itemsInView && itemsInView < count;
      overflow.toggleAttribute("hidden", !hasOverflow);
      this.toggleAttribute("has-overflow", hasOverflow);
    }
  }
  /** @private */
  __updateOverflowTooltip(items, limit) {
    if (!Array.isArray(items)) {
      return;
    }
    if (limit == null) {
      return;
    }
    const result = [];
    for (let i2 = limit; i2 < items.length; i2++) {
      const item = items[i2];
      if (item) {
        result.push(item.name || item.abbr || "anonymous");
      }
    }
    this._overflowTooltip.text = result.join("\n");
  }
  /** @private */
  __getLimit(items, itemsInView, maxItemsVisible) {
    let limit = null;
    const adjustedMax = this.__getMax(maxItemsVisible);
    if (maxItemsVisible != null && adjustedMax < items) {
      limit = adjustedMax - 1;
    } else if (itemsInView && itemsInView < items) {
      limit = itemsInView;
    }
    return Math.min(limit, this.__calculateAvatarsFitWidth());
  }
  /** @private */
  __getMax(maxItemsVisible) {
    return Math.max(maxItemsVisible, MINIMUM_DISPLAYED_AVATARS);
  }
  /** @private */
  __itemsChanged(items, oldItems) {
    this.__setItemsInView();
    let added = [];
    let removed = [];
    const hasNewItems = Array.isArray(items);
    const hasOldItems = Array.isArray(oldItems);
    if (hasOldItems) {
      removed = oldItems.filter((item) => hasNewItems && !items.includes(item));
    }
    if (hasNewItems) {
      added = items.filter((item) => hasOldItems && !oldItems.includes(item));
    }
    this.__announceItemsChange(added, removed);
  }
  /** @private */
  __announceItemsChange(added, removed) {
    let addedMsg = [];
    let removedMsg = [];
    if (added) {
      addedMsg = added.map((user) => this.__getMessage(user, this.__effectiveI18n.joined || "{user} joined"));
    }
    if (removed) {
      removedMsg = removed.map((user) => this.__getMessage(user, this.__effectiveI18n.left || "{user} left"));
    }
    const messages = removedMsg.concat(addedMsg);
    if (messages.length > 0) {
      announce(messages.join(", "));
    }
  }
  /** @private */
  __i18nItemsChanged(effectiveI18n, items) {
    if (effectiveI18n && effectiveI18n.activeUsers) {
      const count = Array.isArray(items) ? items.length : 0;
      const field2 = count === 1 ? "one" : "many";
      if (effectiveI18n.activeUsers[field2]) {
        this.setAttribute("aria-label", effectiveI18n.activeUsers[field2].replace("{count}", count || 0));
      }
    }
  }
  /** @private */
  __openedChanged(opened, oldOpened) {
    if (opened) {
      this._openedWithFocusRing = this._overflow.hasAttribute("focus-ring");
    } else if (oldOpened) {
      this._overflow.focus({ focusVisible: this._openedWithFocusRing });
    }
    this._overflow.setAttribute("aria-expanded", opened === true);
  }
  /** @private */
  __setItemsInView() {
    const avatars = this._avatars;
    const items = this.items;
    if (!items || !avatars || avatars.length < 3) {
      return;
    }
    let result = this.__calculateAvatarsFitWidth();
    if (result === items.length - 1) {
      result = items.length;
    }
    if (result >= items.length && this._opened) {
      this.$.overlay.close();
      this.$.overlay._flushAnimation("closing");
    }
    this.__itemsInView = result;
  }
  /** @private */
  __calculateAvatarsFitWidth() {
    if (!this.shadowRoot || this._avatars.length < MINIMUM_DISPLAYED_AVATARS) {
      return MINIMUM_DISPLAYED_AVATARS;
    }
    const avatars = this._avatars;
    const avatarWidth = avatars[0].clientWidth;
    const { marginLeft, marginRight } = getComputedStyle(avatars[1]);
    const offset2 = this.__isRTL ? parseInt(marginRight, 0) - parseInt(marginLeft, 0) : parseInt(marginLeft, 0) - parseInt(marginRight, 0);
    return Math.floor((this.$.container.offsetWidth - avatarWidth) / (avatarWidth + offset2));
  }
};
/**
 * @license
 * Copyright (c) 2020 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroup extends AvatarGroupMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar-group";
  }
  static get styles() {
    return avatarGroupStyles;
  }
  static get lumoInjector() {
    return { ...super.lumoInjector, includeBaseStyles: true };
  }
  /** @protected */
  render() {
    return html`
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        .owner="${this}"
        .opened="${this._opened}"
        .positionTarget="${this._overflow}"
        no-vertical-overlap
        exportparts="overlay, content"
        @vaadin-overlay-close="${this._onVaadinOverlayClose}"
        @vaadin-overlay-open="${this._onVaadinOverlayOpen}"
        @opened-changed="${this._onOpenedChanged}"
      >
        <slot name="overlay"></slot>
      </vaadin-avatar-group-overlay>
    `;
  }
  /** @private */
  _onOpenedChanged(event) {
    this._opened = event.detail.value;
  }
}
defineCustomElement(AvatarGroup);
/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
const CLASSES = {
  SMALL: "small",
  MEDIUM: "medium",
  LARGE: "large"
};
const BoardRowMixin = (superClass) => class BoardRowMixinClass extends ResizeMixin(superClass) {
  constructor() {
    super();
    this._oldWidth = 0;
    this._oldBreakpoints = { smallSize: 600, mediumSize: 960 };
    this._oldFlexBasis = [];
  }
  /** @protected */
  ready() {
    super.ready();
    this.$.insertionPoint.addEventListener("slotchange", () => this.redraw());
  }
  /** @protected */
  connectedCallback() {
    super.connectedCallback();
    this._onResize();
  }
  /**
   * Adds styles for board row based on width.
   * @private
   */
  _addStyleNames(width, breakpoints) {
    if (width < breakpoints.smallSize) {
      this.classList.add(CLASSES.SMALL);
      this.classList.remove(CLASSES.MEDIUM);
      this.classList.remove(CLASSES.LARGE);
    } else if (width < breakpoints.mediumSize) {
      this.classList.remove(CLASSES.SMALL);
      this.classList.add(CLASSES.MEDIUM);
      this.classList.remove(CLASSES.LARGE);
    } else {
      this.classList.remove(CLASSES.SMALL);
      this.classList.remove(CLASSES.MEDIUM);
      this.classList.add(CLASSES.LARGE);
    }
  }
  /**
   * Calculates flex basis based on colSpan, width and breakpoints.
   * @param {number} colSpan colspan value of the row
   * @param {number} width width of the row in px
   * @param {number} colsInRow number of columns in the row
   * @param {object} breakpoints object with smallSize and mediumSize number properties, which tells
   * where the row should switch rendering size in pixels.
   * @private
   */
  _calculateFlexBasis(colSpan, width, colsInRow, breakpoints) {
    if (width < breakpoints.smallSize) {
      colsInRow = 1;
    } else if (width < breakpoints.mediumSize && colsInRow === 4) {
      colsInRow = 2;
    }
    let flexBasis = colSpan / colsInRow * 100;
    flexBasis = flexBasis > 100 ? 100 : flexBasis;
    return `${flexBasis}%`;
  }
  /** @private */
  _reportError() {
    const errorMessage = "The column configuration is not valid; column count should add up to 3 or 4.";
    console.warn(errorMessage, `check: \r
${this.outerHTML}`);
  }
  /**
   * Parses board-cols from DOM.
   * If there is not enough space in the row drop board cols.
   * @param {!Array<!Node>} nodes array of nodes
   * @return {!Array<number>} array of boardCols
   * @private
   */
  _parseBoardCols(nodes) {
    const boardCols = nodes.map((node) => {
      if (node.getAttribute("board-cols")) {
        return parseInt(node.getAttribute("board-cols"));
      }
      return 1;
    });
    let spaceLeft = 4;
    let returnBoardCols = [];
    nodes.forEach((_node, i2) => {
      spaceLeft -= boardCols[i2];
    });
    if (spaceLeft < 0) {
      this._reportError();
      boardCols.forEach((_node, i2) => {
        returnBoardCols[i2] = 1;
      });
    } else {
      returnBoardCols = boardCols.slice(0);
    }
    return returnBoardCols;
  }
  /**
   * If there is not enough space in the row.
   * Extra items are dropped from DOM.
   * @param {!Array<number>} boardCols array of board-cols for every node
   * @param {!Array<!Node>} nodes array of nodes
   * @return {!Array<!Node>} filtered array of nodes
   * @private
   */
  _removeExtraNodesFromDOM(boardCols, nodes) {
    let isErrorReported = false;
    let spaceLeft = 4;
    const returnNodes = [];
    nodes.forEach((node, i2) => {
      spaceLeft -= boardCols[i2];
      if (spaceLeft < 0) {
        if (!isErrorReported) {
          isErrorReported = true;
          this._reportError();
        }
        this.removeChild(node);
      } else {
        returnNodes[i2] = node;
      }
    });
    return returnNodes;
  }
  /**
   * Redraws the row, if necessary.
   *
   * In most cases, a board row will redraw itself if your reconfigure it.
   * If you dynamically change breakpoints
   * --vaadin-board-width-small or --vaadin-board-width-medium,
   * then you need to call this method.
   */
  redraw() {
    this._recalculateFlexBasis(true);
  }
  /**
   * @protected
   * @override
   */
  _onResize() {
    this._recalculateFlexBasis(false);
  }
  /** @private */
  _recalculateFlexBasis(forceResize) {
    const width = this.getBoundingClientRect().width;
    const breakpoints = this._measureBreakpointsInPx();
    if (forceResize || this._shouldRecalculate(width, breakpoints)) {
      const nodes = this.$.insertionPoint.assignedNodes({ flatten: true });
      const filteredNodes = nodes.filter((node) => node.nodeType === Node.ELEMENT_NODE);
      this._addStyleNames(width, breakpoints);
      const boardCols = this._parseBoardCols(filteredNodes);
      const colsInRow = boardCols.reduce((a, b) => a + b, 0);
      this._removeExtraNodesFromDOM(boardCols, filteredNodes).forEach((e, i2) => {
        const newFlexBasis = this._calculateFlexBasis(boardCols[i2], width, colsInRow, breakpoints);
        if (forceResize || !this._oldFlexBasis[i2] || this._oldFlexBasis[i2] !== newFlexBasis) {
          this._oldFlexBasis[i2] = newFlexBasis;
          e.style.flexBasis = newFlexBasis;
        }
      });
      this._oldWidth = width;
      this._oldBreakpoints = breakpoints;
    }
  }
  /** @private */
  _shouldRecalculate(width, breakpoints) {
    if (isElementHidden(this)) {
      return false;
    }
    return width !== this._oldWidth || breakpoints.smallSize !== this._oldBreakpoints.smallSize || breakpoints.mediumSize !== this._oldBreakpoints.mediumSize;
  }
  /**
   * Measure the breakpoints in pixels.
   *
   * The breakpoints for `small` and `medium` can be given in any unit: `px`, `em`, `in` etc.
   * We need to know them in `px` so that they are comparable with the actual size.
   *
   * @return {object} object with smallSize and mediumSize number properties, which tells
   * where the row should switch rendering size in pixels.
   * @private
   */
  _measureBreakpointsInPx() {
    const breakpoints = {};
    const tmpStyleProp = "background-position";
    const smallSize = getComputedStyle(this).getPropertyValue("--small-size");
    const mediumSize = getComputedStyle(this).getPropertyValue("--medium-size");
    this.style.setProperty(tmpStyleProp, smallSize);
    breakpoints.smallSize = parseFloat(getComputedStyle(this).getPropertyValue(tmpStyleProp));
    this.style.setProperty(tmpStyleProp, mediumSize);
    breakpoints.mediumSize = parseFloat(getComputedStyle(this).getPropertyValue(tmpStyleProp));
    this.style.removeProperty(tmpStyleProp);
    return breakpoints;
  }
};
/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
class BoardRow extends BoardRowMixin(ElementMixin(PolylitMixin(LitElement))) {
  static get is() {
    return "vaadin-board-row";
  }
  static get styles() {
    return css$h`
      :host {
        display: flex;
        flex-flow: row wrap;
        align-items: stretch;
        --small-size: var(--vaadin-board-width-small, 600px);
        --medium-size: var(--vaadin-board-width-medium, 960px);
      }

      :host([hidden]) {
        display: none !important;
      }

      :host ::slotted(*) {
        box-sizing: border-box;
        flex-grow: 1;
        overflow: hidden;
      }
    `;
  }
  /** @protected */
  render() {
    return html`<slot id="insertionPoint"></slot>`;
  }
}
defineCustomElement(BoardRow);
/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
class Board extends ElementMixin(PolylitMixin(LitElement)) {
  static get is() {
    return "vaadin-board";
  }
  static get cvdlName() {
    return "vaadin-board";
  }
  static get styles() {
    return css$h`
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }
    `;
  }
  /** @protected */
  firstUpdated() {
    super.firstUpdated();
    issueWarning(
      "`<vaadin-board>` is deprecated and will be removed in Vaadin 26. Consider using `<vaadin-dashboard>` or `<vaadin-dashboard-layout>` as an alternative."
    );
  }
  /** @protected */
  render() {
    return html`<slot></slot>`;
  }
  /**
   * Redraws the board and all rows inside it, if necessary.
   *
   * In most cases, board will redraw itself if your reconfigure it. If you dynamically change
   * breakpoints `--vaadin-board-width-small` or `--vaadin-board-width-medium`,
   * then you need to call this method.
   */
  redraw() {
    [...this.querySelectorAll("*")].filter((node) => node instanceof BoardRow).forEach((row) => row.redraw());
  }
}
defineCustomElement(Board);
/**
 * @license
 * Copyright (c) 2024 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const cardStyles = css$h`
  :host {
    --_content: 0;
    --_footer: 0;
    --_gap: var(--vaadin-card-gap, var(--vaadin-gap-m));
    --_header: max(var(--_header-prefix), var(--_title), var(--_subtitle), var(--_header-suffix));
    --_header-prefix: 0;
    --_header-suffix: 0;
    --_media: 0;
    --_padding: var(--vaadin-card-padding, var(--vaadin-padding-m));
    --_subtitle: 0;
    --_title: 0;
    background: var(--vaadin-card-background, var(--vaadin-background-container));
    border-radius: var(--vaadin-card-border-radius, var(--vaadin-radius-m));
    box-shadow: var(--vaadin-card-shadow, none);
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    gap: var(--_gap);
    padding: var(--_padding);
    position: relative;
  }

  /* Could be an inset outline on the host as well, but let's reserve that for a potential focus outline */
  :host::before {
    border: var(--vaadin-card-border-width, 0) solid
      var(--vaadin-card-border-color, var(--vaadin-border-color-secondary));
    border-radius: inherit;
    content: '';
    inset: 0;
    pointer-events: none;
    position: absolute;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host(:not([theme~='horizontal'])) {
    justify-content: space-between;
  }

  :host([_m]) {
    --_media: 1;
  }

  :host([_t]) {
    --_title: 1;
  }

  :host([_st]) {
    --_subtitle: 1;
  }

  :host([_h]) {
    --_header: 1;
    --_title: 0;
    --_subtitle: 0;
  }

  :host([_hp]) {
    --_header-prefix: 1;
  }

  :host([_hs]) {
    --_header-suffix: 1;
  }

  :host([_c]) {
    --_content: 1;
  }

  :host([_f]) {
    --_footer: 1;
  }

  [part='media'],
  [part='header'],
  [part='content'],
  [part='footer'] {
    display: none;
  }

  :host([_m]) [part='media'] {
    display: block;
  }

  :host(:is([_h], [_t], [_st], [_hp], [_hs])) [part='header'] {
    align-items: center;
    display: grid;
    gap: var(--_gap);
    row-gap: 0;
  }

  :host([_hs]) [part='header'] {
    grid-template-columns: 1fr auto;
  }

  :host([_hp]) [part='header'] {
    grid-template-columns: repeat(var(--_header-prefix), auto) 1fr;
  }

  :host([_c]) [part='content'] {
    display: block;
  }

  :host([_f]) [part='footer'] {
    display: flex;
    flex-wrap: wrap;
    gap: var(--_gap);
  }

  slot {
    border-radius: inherit;
  }

  ::slotted([slot='header-prefix']) {
    grid-column: 1;
    grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
  }

  ::slotted([slot='header']),
  ::slotted([slot='title']) {
    grid-column: calc(1 + var(--_header-prefix));
    grid-row: 1;
  }

  ::slotted([slot='title']) {
    color: var(--vaadin-card-title-color, var(--vaadin-text-color)) !important;
    font-size: var(--vaadin-card-title-font-size, inherit) !important;
    font-weight: var(--vaadin-card-title-font-weight, 500) !important;
    line-height: var(--vaadin-card-title-line-height, inherit) !important;
    margin: 0 !important;
  }

  ::slotted([slot='subtitle']) {
    color: var(--vaadin-card-subtitle-color, var(--vaadin-text-color-secondary)) !important;
    font-size: var(--vaadin-card-subtitle-font-size, inherit) !important;
    font-weight: var(--vaadin-card-subtitle-font-weight, 400) !important;
    line-height: var(--vaadin-card-subtitle-line-height, inherit) !important;
    margin: 0 !important;
    grid-column: calc(1 + var(--_header-prefix));
    grid-row: calc(1 + var(--_title));
  }

  ::slotted([slot='header-suffix']) {
    grid-column: calc(2 + var(--_header-prefix));
    grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
  }

  /* Horizontal */
  :host([theme~='horizontal']) {
    align-items: start;
    display: grid;
    grid-template-columns: repeat(var(--_media), minmax(auto, max-content)) 1fr;
  }

  :host([theme~='horizontal'][_f]) {
    grid-template-rows: 1fr auto;
  }

  :host([theme~='horizontal'][_c]) {
    grid-template-rows: repeat(var(--_header), auto) 1fr;
  }

  [part='media'] {
    align-self: stretch;
    border-radius: inherit;
    grid-column: 1;
    grid-row: 1 / span calc(var(--_header) + var(--_content) + var(--_footer));
  }

  [part='header'] {
    margin-bottom: auto;
    grid-column: calc(1 + var(--_media));
    grid-row: 1;
  }

  [part='content'] {
    grid-column: calc(1 + var(--_media));
    grid-row: calc(1 + var(--_header));
    flex: auto;
    min-height: 0;
  }

  [part='footer'] {
    border-radius: inherit;
    grid-column: calc(1 + var(--_media));
    grid-row: calc(1 + var(--_header) + var(--_content));
  }

  :host([theme~='horizontal']) [part='footer'] {
    align-self: end;
  }

  :host(:not([theme~='horizontal'])) ::slotted([slot='media']:is(img, video, svg)) {
    max-width: 100%;
  }

  ::slotted([slot='media']) {
    vertical-align: middle;
  }

  :host(:is([theme~='cover-media'], [theme~='stretch-media']))
    ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    aspect-ratio: var(--vaadin-card-media-aspect-ratio, 16/9);
    height: auto;
    object-fit: cover;
    /* Fixes an issue where an icon overflows the card boundaries on Firefox: https://github.com/vaadin/web-components/issues/8641 */
    overflow: hidden;
    width: 100%;
  }

  :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media'])) {
    grid-template-columns: repeat(var(--_media), minmax(auto, 0.5fr)) 1fr;
  }

  :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media']))
    ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    aspect-ratio: auto;
    height: 100%;
  }

  :host([theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: inherit;
    border-end-end-radius: 0;
    border-end-start-radius: 0;
    margin-inline: calc(var(--_padding) * -1);
    margin-top: calc(var(--_padding) * -1);
    max-width: none;
    width: calc(100% + var(--_padding) * 2);
  }

  :host([theme~='horizontal'][theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: inherit;
    border-end-end-radius: 0;
    border-start-end-radius: 0;
    height: calc(100% + var(--_padding) * 2);
    margin-inline-end: 0;
    width: calc(100% + var(--_padding));
  }

  /* Scroller in content */
  [part='content'] ::slotted(vaadin-scroller) {
    margin-inline: calc(var(--_padding) * -1);
    padding-inline: var(--_padding);
  }

  [part='content'] ::slotted(vaadin-scroller)::before,
  [part='content'] ::slotted(vaadin-scroller)::after {
    margin-inline: calc(var(--_padding) * -1);
  }

  /* Outlined */
  :host([theme~='outlined']) {
    --vaadin-card-border-width: 1px;
  }

  /* Elevated */
  :host([theme~='elevated']) {
    --vaadin-card-background: var(--vaadin-background-color);
    box-shadow: var(--vaadin-card-shadow, 0 1px 4px -1px rgba(0, 0, 0, 0.3));
  }
`;
/**
 * @license
 * Copyright (c) 2024 - 2026 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class Card extends ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-card";
  }
  static get styles() {
    return cardStyles;
  }
  static get lumoInjector() {
    return { ...super.lumoInjector, includeBaseStyles: true };
  }
  static get properties() {
    return {
      /**
       * The title of the card. When set, any custom slotted title is removed and this string-based title is used instead. If this title is used, an `aria-labelledby` attribute that points to the generated title element is set.
       *
       * @attr {string} card-title
       */
      cardTitle: {
        type: String,
        observer: "__cardTitleChanged"
      },
      /**
       * Sets the heading level (`aria-level`) for the string-based title. If not set, the level defaults to 2. Setting values outside the range [1, 6] can cause accessibility issues.
       *
       * @attr {number} title-heading-level
       */
      titleHeadingLevel: {
        type: Number,
        reflectToAttribute: true,
        observer: "__titleHeadingLevelChanged"
      }
    };
  }
  /** @protected */
  ready() {
    super.ready();
    if (!this.hasAttribute("role")) {
      this.setAttribute("role", "region");
    }
  }
  /** @protected */
  render() {
    return html`
      <div part="media">
        <slot name="media"></slot>
      </div>
      <div part="header">
        <slot name="header-prefix"></slot>
        <slot name="header">
          <slot name="title"></slot>
          <slot name="subtitle"></slot>
        </slot>
        <slot name="header-suffix"></slot>
      </div>
      <div part="content">
        <slot></slot>
      </div>
      <div part="footer">
        <slot name="footer"></slot>
      </div>
    `;
  }
  /** @protected */
  firstUpdated() {
    super.firstUpdated();
    this._onSlotChange();
  }
  /** @private */
  _onSlotChange() {
    this.toggleAttribute("_m", this.querySelector(':scope > [slot="media"]'));
    this.toggleAttribute("_h", this.querySelector(':scope > [slot="header"]'));
    this.toggleAttribute(
      "_t",
      this.querySelector(':scope > [slot="title"]') && !this.querySelector(':scope > [slot="header"]')
    );
    this.toggleAttribute(
      "_st",
      this.querySelector(':scope > [slot="subtitle"]') && !this.querySelector(':scope > [slot="header"]')
    );
    this.toggleAttribute("_hp", this.querySelector(':scope > [slot="header-prefix"]'));
    this.toggleAttribute("_hs", this.querySelector(':scope > [slot="header-suffix"]'));
    this.toggleAttribute("_c", this.querySelector(":scope > :not([slot])"));
    this.toggleAttribute("_f", this.querySelector(':scope > [slot="footer"]'));
    if (this.__getCustomTitleElement()) {
      this.__clearStringTitle();
    }
  }
  /** @private */
  __clearStringTitle() {
    const stringTitleElement = this.__getStringTitleElement();
    if (stringTitleElement) {
      this.removeChild(stringTitleElement);
    }
    const ariaLabelledby = this.getAttribute("aria-labelledby");
    if (ariaLabelledby && ariaLabelledby.startsWith("card-title-")) {
      this.removeAttribute("aria-labelledby");
    }
    if (this.cardTitle) {
      this.cardTitle = "";
    }
  }
  /** @private */
  __getCustomTitleElement() {
    return Array.from(this.querySelectorAll('[slot="title"]')).find((el) => {
      return !el.hasAttribute("card-string-title");
    });
  }
  /** @private */
  __cardTitleChanged(title) {
    if (!title) {
      this.__clearStringTitle();
      return;
    }
    const customTitleElement = this.__getCustomTitleElement();
    if (customTitleElement) {
      this.removeChild(customTitleElement);
    }
    let stringTitleElement = this.__getStringTitleElement();
    if (!stringTitleElement) {
      stringTitleElement = this.__createStringTitleElement();
      this.appendChild(stringTitleElement);
      this.setAttribute("aria-labelledby", stringTitleElement.id);
    }
    stringTitleElement.textContent = title;
  }
  /** @private */
  __createStringTitleElement() {
    const stringTitleElement = document.createElement("div");
    stringTitleElement.setAttribute("slot", "title");
    stringTitleElement.setAttribute("role", "heading");
    this.__setTitleHeadingLevel(stringTitleElement, this.titleHeadingLevel);
    stringTitleElement.setAttribute("card-string-title", "");
    stringTitleElement.id = `card-title-${generateUniqueId()}`;
    return stringTitleElement;
  }
  /** @private */
  __titleHeadingLevelChanged(titleHeadingLevel) {
    const stringTitleElement = this.__getStringTitleElement();
    if (stringTitleElement) {
      this.__setTitleHeadingLevel(stringTitleElement, titleHeadingLevel);
    }
  }
  /** @private */
  __setTitleHeadingLevel(stringTitleElement, titleHeadingLevel) {
    stringTitleElement.setAttribute("aria-level", titleHeadingLevel || 2);
  }
  /** @private */
  __getStringTitleElement() {
    return this.querySelector('[slot="title"][card-string-title]');
  }
  /**
   * @protected
   * @override
   */
  createRenderRoot() {
    const root = super.createRenderRoot();
    root.addEventListener("slotchange", () => this._onSlotChange());
    return root;
  }
}
defineCustomElement(Card);
/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
function inflateFunctions(config) {
  if (Array.isArray(config)) {
    config.forEach(inflateFunctions);
    return;
  }
  if (
    // Check if param is a primitive/null/undefined value
    !(config instanceof Object) || // Check if param is a plain object (not a HC object)
    config.constructor !== Object
  ) {
    return;
  }
  Object.entries(config).forEach(([attr, targetProperty]) => {
    if (attr.startsWith("_fn_") && (typeof targetProperty === "string" || targetProperty instanceof String)) {
      try {
        config[attr.substr(4)] = eval(`(${targetProperty})`);
      } catch (_) {
        config[attr.substr(4)] = eval(`(function(){${targetProperty}})`);
      }
      delete config[attr];
    } else if (targetProperty instanceof Object) {
      inflateFunctions(targetProperty);
    }
  });
}
function deepMerge(target, source) {
  const isObject2 = (item) => item && typeof item === "object" && !Array.isArray(item);
  if (isObject2(source) && isObject2(target)) {
    Object.keys(source).forEach((key2) => {
      if (isObject2(source[key2])) {
        if (!target[key2]) {
          Object.assign(target, { [key2]: {} });
        }
        deepMerge(target[key2], source[key2]);
      } else {
        Object.assign(target, { [key2]: source[key2] });
      }
    });
  }
  return target;
}
function prepareExport(chart) {
  if (!chart.tempBodyStyle) {
    let effectiveCss = "";
    if (chart.shadowRoot.adoptedStyleSheets) {
      chart.shadowRoot.adoptedStyleSheets.forEach((sheet) => {
        effectiveCss += `${[...sheet.cssRules].map((rule) => rule.cssText).join("\n")}
`;
      });
    }
    effectiveCss = effectiveCss.replace(/:host\(.+?\)/gu, (match2) => {
      const selector = match2.substr(6, match2.length - 7);
      return chart.matches(selector) ? "" : match2;
    });
    effectiveCss = `${effectiveCss}body {    -moz-transform: scale(0.9, 0.9);    zoom: 0.9;    zoom: 90%;}`;
    chart.tempBodyStyle = document.createElement("style");
    chart.tempBodyStyle.textContent = effectiveCss;
    document.body.appendChild(chart.tempBodyStyle);
    if (chart.__styledMode) {
      document.body.toggleAttribute("styled-mode", true);
    }
  }
}
function cleanupExport(chart) {
  if (chart.tempBodyStyle) {
    document.body.removeChild(chart.tempBodyStyle);
    delete chart.tempBodyStyle;
    if (chart.__styledMode) {
      document.body.removeAttribute("styled-mode");
    }
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
const ChartSeriesMixin = (superClass) => class extends superClass {
  static get properties() {
    return {
      /**
       * An array of data used by the series.
       * Format depends on the chart type and can be:
       *   - An array of numerical values `[y0, y1, y2, y3,...]`
       *   - An array of arrays with 2 values (`x`, `y`) `[ [x0, y0], [x1, y1], [x2, y2], ... ]`
       *   - An array of objects, each one describing one point `[ {x: x0, y: y0, name: 'Point0', color: '#FF0000'}, {...}, ...]`
       *
       *  See more in [API Site](https://api.highcharts.com/highcharts/series)
       *
       * @type {ChartSeriesValues}
       */
      values: {
        type: Array,
        value: () => [],
        sync: true
      },
      /**
       * Value-axis minimum-value.
       * Sets the value to a series bound by 'unit' property.
       * Otherwise sets the value to the first series.
       * Undefined by default (determined from data).
       * @attr {number} value-min
       */
      valueMin: {
        type: Number,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Value-axis maximum-value.
       * See the 'valueMin'
       * @attr {number} value-max
       */
      valueMax: {
        type: Number,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * A string with the type of the series.
       * Defaults to `'line'` in case no type is set for the chart.
       * Note that `'bar'`, `'gauge'` and `'solidgauge'` should be set as default series type on `<vaadin-chart>`.
       */
      type: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * The name of the series as shown in the legend, tooltip etc.
       * @type {string}
       */
      title: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Shows/hides data-point markers for line-like series.
       * Acceptable input are:
       *  - `shown`: markers are always visible
       *  - `hidden`: markers are always hidden
       *  - `auto`: markers are visible for widespread data and hidden, when data is dense *(default)*
       * @type {ChartSeriesMarkers | undefined}
       */
      markers: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Used to connect the series to an axis; if multiple series have the same `unit`, they will share axis.
       * Displayed as a title for the axis.
       * If no unit is defined, then series will be connected to the first axis.
       */
      unit: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Used to group series in a different stacks.
       * "stacking" property should be specified either for each series or in plotOptions.
       * It is recommended to place series in a single stack, when they belong to the same yAxis.
       * @type {number | string}
       */
      stack: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * The height of the neck, the lower part of the funnel.
       * A number defines pixel width, a percentage string defines a percentage of the plot area height. Defaults to 30%.
       * Note that this property only applies for "funnel" charts.
       * @attr {number | string} neck-position
       * @type {number | string}
       */
      neckPosition: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * The width of the neck, the lower part of the funnel.
       * A number defines pixel width, a percentage string defines a percentage of the plot area width. Defaults to 30%.
       * Note that this property only applies for "funnel" charts.
       * @attr {number | string} neck-width
       * @type {number | string}
       */
      neckWidth: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Object with the configured options defined and used to create a series.
       * @type {!ChartSeriesOptions}
       * @readonly
       */
      options: {
        type: Object,
        sync: true
      },
      /**
       * Represents additional JSON configuration.
       * @type {SeriesOptionsType | undefined}
       */
      additionalOptions: {
        type: Object,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * @type {!Series | undefined}
       * @protected
       */
      _series: {
        type: Object,
        sync: true
      }
    };
  }
  static get observers() {
    return [
      "__additionalOptionsObserver(additionalOptions, _series)",
      "__markersObserver(markers, _series)",
      "__neckPositionObserver(neckPosition, _series)",
      "__neckWidthObserver(neckWidth, _series)",
      "__stackObserver(stack, _series)",
      "__titleObserver(title, _series)",
      "__typeObserver(type, _series)",
      "__unitObserver(unit, valueMin, valueMax, _series)",
      "__valueMinObserver(valueMin, _series)",
      "__valueMaxObserver(valueMax, _series)",
      "__valuesObserver(values, _series)"
    ];
  }
  get options() {
    const options2 = deepMerge({}, this.additionalOptions);
    if (this.type) {
      options2.type = this.type;
    }
    if (this.title) {
      options2.name = this.title;
    }
    if (this.values) {
      options2.data = this.values;
    }
    if (this.markers) {
      if (!this.__isMarkersValid()) {
        this.markers = "auto";
      }
      options2.marker = this.__markersConfiguration;
    }
    if (this.unit) {
      options2.yAxis = this.unit;
    }
    if (this.stack) {
      options2.stack = this.stack;
    }
    if (isFinite(this.valueMin)) {
      options2.yAxisValueMin = this.valueMin;
    }
    if (isFinite(this.valueMax)) {
      options2.yAxisValueMax = this.valueMax;
    }
    if (this.neckWidth) {
      options2.neckWidth = this.neckWidth;
    }
    if (this.neckPosition) {
      options2.neckHeight = this.neckPosition;
    }
    return options2;
  }
  /** @private */
  get __markersConfiguration() {
    const config2 = {};
    switch (this.markers) {
      case "shown":
        config2.enabled = true;
        break;
      case "hidden":
        config2.enabled = false;
        break;
      case "auto":
      default:
        config2.enabled = null;
        break;
    }
    return config2;
  }
  /**
   * Method to attach a series object of type `Highcharts.Series`.
   * @param {!Series} series Object of type `Highcharts.Series`
   */
  setSeries(series) {
    this._series = series;
  }
  /** @private */
  __valuesObserver(values2, series) {
    if (series) {
      series.setData(values2);
    }
  }
  /** @private */
  __additionalOptionsObserver(additionalOptions, series) {
    if (series && additionalOptions) {
      series.update(additionalOptions);
    }
  }
  /** @private */
  __updateAxis(series, value, key2) {
    if (!isFinite(value)) {
      this.__showWarn(`value-${key2}`, "Numbers or null");
      return;
    }
    if (series && series.yAxis) {
      series.yAxis.update({ [key2]: value });
    }
  }
  /** @private */
  __valueMinObserver(valueMin, series) {
    if (valueMin === void 0 || series == null) {
      return;
    }
    this.__updateAxis(series, valueMin, "min");
  }
  /** @private */
  __valueMaxObserver(valueMax, series) {
    if (valueMax === void 0 || series == null) {
      return;
    }
    this.__updateAxis(series, valueMax, "max");
  }
  /** @private */
  __typeObserver(type, series) {
    if (type && series) {
      series.update({ type });
    }
  }
  /** @private */
  __titleObserver(title, series) {
    if (title === void 0 || series == null) {
      return;
    }
    series.update({ name: title });
  }
  /** @private */
  __stackObserver(stack, series) {
    if (stack === void 0 || series == null) {
      return;
    }
    series.update({ stack });
  }
  /** @private */
  __neckPositionObserver(neckPosition, series) {
    if (neckPosition === void 0 || series == null) {
      return;
    }
    series.update({ neckHeight: neckPosition });
  }
  /** @private */
  __neckWidthObserver(neckWidth, series) {
    if (neckWidth === void 0 || series == null) {
      return;
    }
    series.update({ neckWidth });
  }
  /** @private */
  __unitObserver(unit, valueMin, valueMax, series) {
    if (series && unit !== this.__oldUnit) {
      const Chart3 = customElements.get("vaadin-chart");
      this.__oldUnit = unit;
      const parent = this.parentNode instanceof Chart3 && this.parentNode;
      if (parent && parent instanceof Chart3) {
        if (unit && !parent.__getAxis(unit)) {
          const title = { title: { text: unit } };
          parent.__addAxis({ id: unit, axisGenerated: true, ...title });
        }
        series.update({ yAxis: unit || 0 });
        if (valueMin !== void 0) {
          this.__updateAxis(series, valueMin, "min");
        }
        if (valueMax !== void 0) {
          this.__updateAxis(series, valueMax, "max");
        }
        parent.__removeAxisIfEmpty();
      }
    }
  }
  /** @private */
  __isMarkersValid() {
    if (["shown", "hidden", "auto"].indexOf(this.markers) === -1) {
      this.__showWarn("markers", '"shown", "hidden" or "auto"');
      return false;
    }
    return true;
  }
  /** @private */
  __markersObserver(markers, series) {
    if (markers === void 0 || series == null) {
      return;
    }
    if (!this.__isMarkersValid()) {
      this.markers = "auto";
      return;
    }
    series.update({
      marker: this.__markersConfiguration
    });
  }
  /** @private */
  __showWarn(propertyName, acceptedValues) {
    console.warn(`<vaadin-chart-series> Acceptable values for "${propertyName}" are ${acceptedValues}`);
  }
};
/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
class ChartSeries extends ChartSeriesMixin(PolylitMixin(LitElement)) {
  static get is() {
    return "vaadin-chart-series";
  }
}
defineCustomElement(ChartSeries);
/**
 * @license
 * Copyright (c) 2000 - 2026 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
const tooltipStyles = (scope) => css$h`
  ${unsafeCSS(scope)} .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
    filter: drop-shadow(var(--vaadin-charts-tooltip-shadow, 0 4px 8px rgba(0, 0, 0, 0.2))) !important;
  }

  ${unsafeCSS(scope)} .highcharts-tooltip text,
  ${unsafeCSS(scope)} .highcharts-tooltip foreignObject span {
    fill: var(--highcharts-neutral-color-80, var(--vaadin-charts-data-label, var(--vaadin-text-color)));
  }

  ${unsafeCSS(scope)} .highcharts-tooltip .highcharts-tracker {
    fill: none;
    stroke: none;
  }

  ${unsafeCSS(scope)} .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--highcharts-neutral-color-60, var(--vaadin-text-color-secondary));
  }

  ${unsafeCSS(scope)} .highcharts-tooltip-box {
    stroke-width: 0;
    fill: var(--highcharts-background-color, var(--vaadin-charts-tooltip-background, var(--vaadin-background-color)));
  }

  ${unsafeCSS(scope)} .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--highcharts-background-color, var(--vaadin-charts-tooltip-background, var(--vaadin-background-color)));
  }

  ${unsafeCSS(scope)} div.highcharts-tooltip {
    filter: none;
    font-size: 0.8em;
  }
`;
addGlobalStyles(
  "vaadin-charts-tooltip",
  css$h`
    .highcharts-tooltip-container .highcharts-root {
      overflow: visible;
      font-size: var(--vaadin-charts-font-size, 0.75rem);
      line-height: normal;
    }
  `,
  tooltipStyles(".highcharts-tooltip-container")
);
const chartStyles = css$h`
  :host {
    display: block;
    width: 100%;
    height: 100%;
    overflow: hidden;
  }

  :host,
  :root {
    font-size: var(--vaadin-charts-font-size, 0.75rem);
    line-height: normal;

    /* Needs to be a color, not a background image */
    --_bg: var(--vaadin-charts-background, var(--vaadin-background-color));

    --_color-0: var(--highcharts-color-0, var(--vaadin-charts-color-0, var(--vaadin-user-color-0)));
    --_color-1: var(--highcharts-color-1, var(--vaadin-charts-color-1, var(--vaadin-user-color-1)));
    --_color-2: var(--highcharts-color-2, var(--vaadin-charts-color-2, var(--vaadin-user-color-2)));
    --_color-3: var(--highcharts-color-3, var(--vaadin-charts-color-3, var(--vaadin-user-color-3)));
    --_color-4: var(--highcharts-color-4, var(--vaadin-charts-color-4, var(--vaadin-user-color-4)));
    --_color-5: var(--highcharts-color-5, var(--vaadin-charts-color-5, var(--vaadin-user-color-5)));
    --_color-6: var(--highcharts-color-6, var(--vaadin-charts-color-6, var(--vaadin-user-color-6)));
    --_color-7: var(--highcharts-color-7, var(--vaadin-charts-color-7, var(--vaadin-user-color-7)));
    --_color-8: var(--highcharts-color-8, var(--vaadin-charts-color-8, var(--vaadin-user-color-8)));
    --_color-9: var(--highcharts-color-9, var(--vaadin-charts-color-9, var(--vaadin-user-color-9)));

    --_color-0-label: oklch(from var(--_color-0) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-1-label: oklch(from var(--_color-1) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-2-label: oklch(from var(--_color-2) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-3-label: oklch(from var(--_color-3) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-4-label: oklch(from var(--_color-4) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-5-label: oklch(from var(--_color-5) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-6-label: oklch(from var(--_color-6) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-7-label: oklch(from var(--_color-7) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-8-label: oklch(from var(--_color-8) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-9-label: oklch(from var(--_color-9) clamp(0, (0.62 - l) * 1000, 1) 0 0);

    --_color-positive: light-dark(#19b156, #1ccc62);
    --_color-negative: light-dark(#dc0611, #f7353f);

    --_label: var(--vaadin-charts-label, var(--vaadin-text-color));
    --_secondary-label: var(--vaadin-charts-secondary-label, var(--vaadin-text-color-secondary));
    --_disabled-label: var(--vaadin-charts-disabled-label, var(--vaadin-text-color-disabled));
    --_point-border: var(--vaadin-charts-point-border, var(--_bg));
    --_axis-line: var(--vaadin-charts-axis-line, var(--vaadin-border-color-secondary));
    --_axis-title: var(--vaadin-charts-axis-title, var(--_secondary-label));
    --_axis-label: var(--vaadin-charts-axis-label, var(--_secondary-label));
    --_grid-line: var(--vaadin-charts-grid-line, var(--vaadin-border-color-secondary));
    --_minor-grid-line: var(
      --vaadin-charts-minor-grid-line,
      color-mix(in srgb, var(--vaadin-border-color-secondary) 60%, transparent)
    );
    --_data-label: var(--vaadin-charts-data-label, var(--_label));
  }

  /* Safari 17 doesn't support relative colors from light-dark() */
  @supports not (color: oklch(from light-dark(red, red) l c h)) {
    :host {
      /* Safari 17 wants degrees instead of raw numbers */
      --_hue-scale: 180deg;
    }
  }

  :host([hidden]) {
    display: none !important;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    line-height: normal;
    z-index: 0; /* highcharts/highcharts#1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
    user-select: none;
    touch-action: manipulation;
    outline: none;
  }

  :where([styled-mode]) .highcharts-no-touch-action {
    touch-action: none;
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: bold;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--highcharts-background-color, var(--_bg));
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label text {
    fill: var(--highcharts-neutral-color-80, var(--_data-label));
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
    rx: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    ry: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--highcharts-neutral-color-80, var(--vaadin-charts-title-label, var(--_label)));
    font-size: 1.6em;
    font-weight: bold;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--highcharts-neutral-color-60, var(--_secondary-label));
    font-size: 1em;
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--highcharts-neutral-color-80, var(--_axis-line));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--highcharts-neutral-color-60, var(--_axis-title));
    font-size: 1em;
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--highcharts-neutral-color-80, var(--_axis-label));
    cursor: default;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--highcharts-neutral-color-10, var(--_grid-line));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--highcharts-neutral-color-80, var(--_grid-line));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--highcharts-neutral-color-5, var(--_minor-grid-line));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--highcharts-neutral-color-20, var(--_grid-line));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--highcharts-highlight-color-20, var(--_color-0));
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--highcharts-neutral-color-40, var(--_disabled-label));
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: var(--highcharts-neutral-color-100, black);
    font-size: 0.8em;
  }

  /* Tooltip */
  ${unsafeCSS(tooltipStyles(":where([styled-mode])"))};

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--highcharts-highlight-color-80, var(--_color-0));
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: var(--vaadin-chart-graph-stroke-width, 2);
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-empty-series {
    stroke-width: 1px;
    fill: none;
    stroke: var(--highcharts-neutral-color-20, var(--_color-0));
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: calc(var(--vaadin-chart-graph-stroke-width, 2) + 1);
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms; /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms; /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms; /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms; /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode])
    .highcharts-legend-point-active
    .highcharts-point:not(.highcharts-point-hover, .highcharts-point-select),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */

  /* Default colors */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--_color-0);
    stroke: var(--_color-0);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--_color-1);
    stroke: var(--_color-1);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--_color-2);
    stroke: var(--_color-2);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--_color-3);
    stroke: var(--_color-3);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--_color-4);
    stroke: var(--_color-4);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--_color-5);
    stroke: var(--_color-5);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--_color-6);
    stroke: var(--_color-6);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--_color-7);
    color: var(--_color-7-label);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--_color-8);
    stroke: var(--_color-8);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--_color-9);
    stroke: var(--_color-9);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-0 {
    color: var(--_color-0-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-1 {
    color: var(--_color-1-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-2 {
    color: var(--_color-2-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-3 {
    color: var(--_color-3-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-4 {
    color: var(--_color-4-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-5 {
    color: var(--_color-5-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-6 {
    color: var(--_color-6-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-7 {
    color: var(--_color-7-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-8 {
    color: var(--_color-8-label);
  }

  :where([styled-mode])
    :where(.highcharts-treemap-series, .highcharts-organization-series, .highcharts-gantt-series)
    .highcharts-data-label-color-9 {
    color: var(--_color-9-label);
  }

  :where([styled-mode]) [class*='highcharts-data-label-color-'] {
    fill: currentColor;
  }

  /* Various series-specific */
  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.75;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--highcharts-background-color, var(--_bg));
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover, .highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) .highcharts-data-label span,
  :where([styled-mode]) text.highcharts-data-label {
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--highcharts-neutral-color-80, var(--_data-label));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series-label text {
    fill: inherit;
    font-weight: bold;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--highcharts-neutral-color-20, var(--_grid-line));
    stroke: var(--highcharts-neutral-color-100, var(--vaadin-charts-contrast, var(--_label)));
  }

  :where([styled-mode]) .highcharts-column-series path.highcharts-point,
  :where([styled-mode]) .highcharts-bar-series path.highcharts-point {
    /* path to prevent stroke on 3D columns and bars */
    stroke: var(--highcharts-background-color, var(--_point-border));
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point,
  :where([styled-mode]) .highcharts-bar-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover,
  :where([styled-mode]) .highcharts-bar-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--highcharts-background-color, var(--_point-border));
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--highcharts-background-color, var(--_point-border));
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--highcharts-background-color, var(--_point-border));
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 1px;
    stroke: var(--highcharts-background-color, var(--_point-border));
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke: var(--highcharts-neutral-color-40, var(--_point-border));
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--highcharts-neutral-color-100, var(--vaadin-charts-contrast, var(--_label)));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text,
  :where([styled-mode]) .highcharts-legend-item span {
    fill: var(--highcharts-neutral-color-80, var(--_data-label));
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--highcharts-neutral-color-100, var(--vaadin-charts-title-label, var(--_label)));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--highcharts-neutral-color-60, var(--_disabled-label)) !important;
    stroke: var(--highcharts-neutral-color-60, var(--_disabled-label)) !important;
    transition: fill 250ms;
    text-decoration: line-through;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--highcharts-highlight-color-100, var(--vaadin-charts-button-label, var(--_label)));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--highcharts-neutral-color-20, var(--_disabled-label));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--highcharts-neutral-color-80, var(--_data-label));
    font-size: 0.95em;
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--highcharts-background-color, var(--_bg));
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: bold;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--highcharts-neutral-color-100, var(--vaadin-charts-contrast, var(--_label)));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(
      --highcharts-neutral-color-40,
      color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent)
    );
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    font-size: 1em;
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--highcharts-background-color, var(--_bg));
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--highcharts-neutral-color-100, var(--vaadin-charts-contrast, var(--_label)));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--highcharts-neutral-color-20, var(--_grid-line));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--highcharts-neutral-color-100, var(--vaadin-charts-contrast, var(--_label)));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-organization-series .highcharts-null-point {
    fill: transparent;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(
      --highcharts-neutral-color-80,
      color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent)
    );
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--highcharts-neutral-color-20, var(--_point-border));
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--highcharts-neutral-color-20, var(--_point-border));
  }

  :where([styled-mode]) .highcharts-timeline-series .highcharts-graph {
    stroke: var(--highcharts-neutral-color-20, var(--_point-border));
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--highcharts-highlight-color-60, var(--_color-0)); /* navigator.maskFill option */
    fill-opacity: 0.25;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--highcharts-neutral-color-40, var(--_grid-line));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--highcharts-neutral-color-40, var(--_grid-line));
    fill: var(--highcharts-neutral-color-5, var(--_bg));
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--highcharts-highlight-color-80, var(--_color-1));
    stroke: var(--highcharts-highlight-color-80, var(--_color-1));
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--highcharts-neutral-color-10, var(--_grid-line));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--highcharts-neutral-color-100, var(--_secondary-label));
    font-size: 0.95em;
    opacity: 0.6;
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(
      --highcharts-neutral-color-20,
      color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 20%, transparent)
    );
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--highcharts-neutral-color-10, var(--_bg));
    stroke: var(--highcharts-neutral-color-20);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--highcharts-neutral-color-60, var(--_data-label));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: none;
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 5%, transparent);
    stroke: var(--highcharts-neutral-color-20);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--highcharts-neutral-color-3, var(--vaadin-charts-button-background, var(--vaadin-background-container)));
    stroke: var(--highcharts-neutral-color-20);
    cursor: default;
    stroke-width: 1px;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--highcharts-neutral-color-80, var(--vaadin-charts-button-label, var(--_label)));
    font-size: 1em;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(
      --highcharts-neutral-color-10,
      var(--vaadin-charts-button-hover-background, var(--vaadin-background-container))
    );
    stroke: var(--highcharts-neutral-color-20);
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--highcharts-neutral-color-80, var(--vaadin-charts-button-label, var(--_label)));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    font-weight: bold;
    fill: var(--highcharts-highlight-color-10, var(--vaadin-charts-button-active-background, var(--_label)));
    stroke: var(--highcharts-neutral-color-20);
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--highcharts-neutral-color-80, var(--vaadin-charts-button-active-label, var(--_bg)));
    font-weight: bold;
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(
      --highcharts-neutral-color-80,
      var(--vaadin-charts-button-disabled-label, var(--vaadin-text-color-disabled))
    );
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--highcharts-neutral-color-60, var(--_secondary-label));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-range-input-background, var(--vaadin-background-container));
    rx: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    ry: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-range-input-background-hover, var(--vaadin-background-container));
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--highcharts-neutral-color-80, var(--_data-label));
    font-size: 1em;
  }

  :where([styled-mode]) .highcharts-range-input {
    stroke-width: 1px;
    stroke: var(--highcharts-neutral-color-20);
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    padding: 0;
    text-align: center;
    top: -9999em;
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--highcharts-background-color, var(--_bg));
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--highcharts-neutral-color-100, var(--vaadin-charts-candlestick-line, var(--vaadin-border-color)));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--highcharts-background-color, var(--_color-positive));
  }

  :where([styled-mode]) .highcharts-renko-series .highcharts-point-down,
  :where([styled-mode]) .highcharts-hollowcandlestick-series .highcharts-point-down {
    fill: var(--highcharts-negative-color, var(--_color-negative));
    stroke: var(--highcharts-negative-color, var(--_color-negative));
  }

  :where([styled-mode]) .highcharts-renko-series .highcharts-point-up,
  :where([styled-mode]) .highcharts-hollowcandlestick-series .highcharts-point-down-bearish-up {
    fill: var(--highcharts-positive-color, var(--_color-positive));
    stroke: var(--highcharts-positive-color, var(--_color-positive));
  }

  :where([styled-mode]) .highcharts-hollowcandlestick-series .highcharts-point-up {
    fill: transparent;
    stroke: var(--highcharts-positive-color, var(--_color-positive));
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--highcharts-neutral-color-40, var(--_grid-line));
    fill: var(--highcharts-background-color, var(--_bg));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(
      --highcharts-neutral-color-100,
      color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent)
    );
    fill: var(--highcharts-highlight-color-20, var(--_bg));
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--highcharts-neutral-color-100, var(--_data-label));
    font-size: 0.9em;
    font-weight: bold;
  }

  /* Highcharts Maps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: var(--highcharts-neutral-color-20);
    stroke-width: inherit;
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: bold;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-map-navigation.highcharts-button {
    fill: var(--highcharts-background-color);
    stroke: var(--highcharts-neutral-color-10);
  }

  :where([styled-mode]) .highcharts-map-navigation.highcharts-button:hover {
    fill: var(--highcharts-neutral-color-10);
  }

  :where([styled-mode]) .highcharts-map-navigation.highcharts-button .highcharts-button-symbol {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapview-inset-border {
    stroke: var(--highcharts-neutral-color-20);
    stroke-width: 1px;
    fill: none;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--highcharts-neutral-color-40);
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--highcharts-neutral-color-3, var(--vaadin-charts-button-background, var(--vaadin-background-container)));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    /* Fill is needed to capture hover */
    fill: var(--highcharts-background-color, var(--_bg));
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: var(--highcharts-neutral-color-10, #e6e6e6);
    stroke: var(--highcharts-neutral-color-10, #e6e6e6);
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--highcharts-neutral-color-60, var(--_secondary-label));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: none;
    background: var(--highcharts-background-color, var(--_bg));
    border-radius: 3px;
    padding: 0.5em;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    background: none;
    border-radius: 3px;
    color: var(--highcharts-neutral-color-80, var(--vaadin-charts-button-label, var(--_label)));
    cursor: pointer;
    font-size: 1em;
    list-style-type: none;
    padding: 0.5em;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: var(--highcharts-neutral-color-5, var(--_bg));
  }

  /* Breadcrumbs */
  :where([styled-mode]) .highcharts-breadcrumbs-button {
    fill: none;
    stroke-width: 0;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-breadcrumbs-separator {
    fill: var(--highcharts-neutral-color-60, var(--_secondary-label));
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--highcharts-highlight-color-100, var(--vaadin-charts-button-label, var(--_label)));
    font-weight: bold;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: bold;
    font-size: 1em;
    fill: var(--highcharts-neutral-color-60, var(--_secondary-label));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: var(--highcharts-neutral-color-100, black);
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(
      --highcharts-neutral-color-80,
      color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent)
    );
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(
      --highcharts-neutral-color-80,
      color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent)
    );
  }

  /* Advanced annotations module */
  :where([styled-mode]) .highcharts-fibonacci-background-0,
  :where([styled-mode]) .highcharts-pitchfork-inner-background,
  :where([styled-mode]) .highcharts-measure-background {
    fill: var(--highcharts-annotation-color-0);
  }

  :where([styled-mode]) .highcharts-fibonacci-background-1 {
    fill: var(--highcharts-annotation-color-1);
  }

  :where([styled-mode]) .highcharts-fibonacci-background-2 {
    fill: var(--highcharts-annotation-color-2);
  }

  :where([styled-mode]) .highcharts-fibonacci-background-3,
  :where([styled-mode]) .highcharts-pitchfork-outer-background {
    fill: var(--highcharts-annotation-color-3);
  }

  :where([styled-mode]) .highcharts-fibonacci-background-4 {
    fill: var(--highcharts-annotation-color-4);
  }

  :where([styled-mode]) .highcharts-fibonacci-background-5 {
    fill: var(--highcharts-annotation-color-5);
  }

  :where([styled-mode]) .highcharts-fibonacci-line {
    stroke: var(--highcharts-neutral-color-40);
  }

  :where([styled-mode]) .highcharts-crooked-lines,
  :where([styled-mode]) .highcharts-tunnel-lines,
  :where([styled-mode]) .highcharts-infinity-lines,
  :where([styled-mode]) .highcharts-timecycles-lines,
  :where([styled-mode]) .highcharts-fibonacci-timezones-lines,
  :where([styled-mode]) .highcharts-pitchfork-lines,
  :where([styled-mode]) .highcharts-vertical-line,
  :where([styled-mode]) .highcharts-measure-crosshair-x,
  :where([styled-mode]) .highcharts-measure-crosshair-y {
    stroke: var(--highcharts-neutral-color-100);
    stroke-opacity: 0.75;
    fill: none;
  }

  :where([styled-mode]) .highcharts-measure-crosshair-x,
  :where([styled-mode]) .highcharts-measure-crosshair-y {
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-tunnel-background {
    fill: var(--highcharts-color-0);
  }

  :where([styled-mode]) .highcharts-annotation-shapes {
    cursor: move;
  }

  :where([styled-mode]) .highcharts-basic-shape {
    fill: var(--highcharts-neutral-color-100);
    stroke: var(--highcharts-neutral-color-100);
    opacity: 0.74;
  }

  /* Annotations module */

  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--highcharts-neutral-color-100, var(--vaadin-charts-contrast, var(--_label)));
    fill: var(--highcharts-neutral-color-100, var(--vaadin-charts-contrast, var(--_label)));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--highcharts-neutral-color-10, var(--_label));
    font-size: 1em;
  }

  /* A11y module */
  :where([styled-mode]) .highcharts-a11y-proxy-element {
    border-width: 0;
    background-color: transparent;
    cursor: pointer;
    outline: none;
    opacity: 0.001;
    z-index: 999;
    overflow: hidden;
    padding: 0;
    margin: 0;
    display: block;
    position: absolute;
  }

  :where([styled-mode]) .highcharts-a11y-proxy-group li {
    list-style: none;
  }

  :where([styled-mode]) .highcharts-visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    overflow: hidden;
    white-space: nowrap;
    clip: rect(1px, 1px, 1px, 1px);
    margin-top: -3px;
    opacity: 0.01;
  }

  :where([styled-mode]) .highcharts-a11y-invisible {
    visibility: hidden;
  }

  :where([styled-mode]) .highcharts-a11y-proxy-container,
  :where([styled-mode]) .highcharts-a11y-proxy-container-before,
  :where([styled-mode]) .highcharts-a11y-proxy-container-after {
    position: absolute;
    white-space: nowrap;
  }

  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-point {
    outline: none;
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke: var(--highcharts-neutral-color-20, var(--_grid-line));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke: var(--highcharts-neutral-color-20, var(--_grid-line));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gantt-series .highcharts-partfill-overlay {
    fill: hsla(0, 0%, 0%, 0.3);
    stroke: hsla(0, 0%, 0%, 0.3);
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }
`;
var Globals;
(function(Globals2) {
  Globals2.SVG_NS = "http://www.w3.org/2000/svg", Globals2.product = "Highcharts", Globals2.version = "12.2.0", Globals2.win = typeof window !== "undefined" ? window : {}, // eslint-disable-line node/no-unsupported-features/es-builtins
  Globals2.doc = Globals2.win.document, Globals2.svg = !!Globals2.doc?.createElementNS?.(Globals2.SVG_NS, "svg")?.createSVGRect, Globals2.pageLang = Globals2.doc?.documentElement?.closest("[lang]")?.lang, Globals2.userAgent = Globals2.win.navigator?.userAgent || "", Globals2.isChrome = Globals2.win.chrome, Globals2.isFirefox = Globals2.userAgent.indexOf("Firefox") !== -1, Globals2.isMS = /(edge|msie|trident)/i.test(Globals2.userAgent) && !Globals2.win.opera, Globals2.isSafari = !Globals2.isChrome && Globals2.userAgent.indexOf("Safari") !== -1, Globals2.isTouchDevice = /(Mobile|Android|Windows Phone)/.test(Globals2.userAgent), Globals2.isWebKit = Globals2.userAgent.indexOf("AppleWebKit") !== -1, Globals2.deg2rad = Math.PI * 2 / 360, Globals2.marginNames = [
    "plotTop",
    "marginRight",
    "marginBottom",
    "plotLeft"
  ], Globals2.noop = function() {
  }, Globals2.supportsPassiveEvents = (function() {
    let supportsPassive = false;
    if (!Globals2.isMS) {
      const opts = Object.defineProperty({}, "passive", {
        get: function() {
          supportsPassive = true;
        }
      });
      if (Globals2.win.addEventListener && Globals2.win.removeEventListener) {
        Globals2.win.addEventListener("testPassive", Globals2.noop, opts);
        Globals2.win.removeEventListener("testPassive", Globals2.noop, opts);
      }
    }
    return supportsPassive;
  })();
  Globals2.charts = [];
  Globals2.composed = [];
  Globals2.dateFormats = {};
  Globals2.seriesTypes = {};
  Globals2.symbolSizes = {};
  Globals2.chartCount = 0;
})(Globals || (Globals = {}));
const Highcharts = Globals;
const { charts: charts$4, doc: doc$s, win: win$h } = Highcharts;
function error$b(code, stop2, chart, params2) {
  const severity = stop2 ? "Highcharts error" : "Highcharts warning";
  if (code === 32) {
    code = `${severity}: Deprecated member`;
  }
  const isCode = isNumber$1d(code);
  let message2 = isCode ? `${severity} #${code}: www.highcharts.com/errors/${code}/` : code.toString();
  const defaultHandler = function() {
    if (stop2) {
      throw new Error(message2);
    }
    if (win$h.console && error$b.messages.indexOf(message2) === -1) {
      console.warn(message2);
    }
  };
  if (typeof params2 !== "undefined") {
    let additionalMessages = "";
    if (isCode) {
      message2 += "?";
    }
    objectEach$z(params2, function(value, key2) {
      additionalMessages += `
 - ${key2}: ${value}`;
      if (isCode) {
        message2 += encodeURI(key2) + "=" + encodeURI(value);
      }
    });
    message2 += additionalMessages;
  }
  fireEvent$N(Highcharts, "displayError", { chart, code, message: message2, params: params2 }, defaultHandler);
  error$b.messages.push(message2);
}
(function(error2) {
  error2.messages = [];
})(error$b || (error$b = {}));
function merge$1K(extendOrSource, ...sources) {
  let i2, args = [extendOrSource, ...sources], ret = {};
  const doCopy = function(copy, original) {
    if (typeof copy !== "object") {
      copy = {};
    }
    objectEach$z(original, function(value, key2) {
      if (key2 === "__proto__" || key2 === "constructor") {
        return;
      }
      if (isObject$p(value, true) && !isClass(value) && !isDOMElement(value)) {
        copy[key2] = doCopy(copy[key2] || {}, value);
      } else {
        copy[key2] = original[key2];
      }
    });
    return copy;
  };
  if (extendOrSource === true) {
    ret = args[1];
    args = Array.prototype.slice.call(args, 2);
  }
  const len = args.length;
  for (i2 = 0; i2 < len; i2++) {
    ret = doCopy(ret, args[i2]);
  }
  return ret;
}
function clamp$o(value, min2, max2) {
  return value > min2 ? value < max2 ? value : max2 : min2;
}
function crisp$g(value, lineWidth = 0, inverted) {
  const mod = lineWidth % 2 / 2, inverter = inverted ? -1 : 1;
  return (Math.round(value * inverter - mod) + mod) * inverter;
}
function diffObjects$5(newer, older, keepOlder, collectionsWithUpdate) {
  const ret = {};
  function diff(newer2, older2, ret2, depth) {
    const keeper = keepOlder ? older2 : newer2;
    objectEach$z(newer2, function(newerVal, key2) {
      if (!depth && collectionsWithUpdate && collectionsWithUpdate.indexOf(key2) > -1 && older2[key2]) {
        newerVal = splat$n(newerVal);
        ret2[key2] = [];
        for (let i2 = 0; i2 < Math.max(newerVal.length, older2[key2].length); i2++) {
          if (older2[key2][i2]) {
            if (newerVal[i2] === void 0) {
              ret2[key2][i2] = older2[key2][i2];
            } else {
              ret2[key2][i2] = {};
              diff(newerVal[i2], older2[key2][i2], ret2[key2][i2], depth + 1);
            }
          }
        }
      } else if (isObject$p(newerVal, true) && !newerVal.nodeType) {
        ret2[key2] = isArray$s(newerVal) ? [] : {};
        diff(newerVal, older2[key2] || {}, ret2[key2], depth + 1);
        if (Object.keys(ret2[key2]).length === 0 && // Except colorAxis which is a special case where the empty
        // object means it is enabled. Which is unfortunate and we
        // should try to find a better way.
        !(key2 === "colorAxis" && depth === 0)) {
          delete ret2[key2];
        }
      } else if (newer2[key2] !== older2[key2] || // If the newer key is explicitly undefined, keep it (#10525)
      key2 in newer2 && !(key2 in older2)) {
        if (key2 !== "__proto__" && key2 !== "constructor") {
          ret2[key2] = keeper[key2];
        }
      }
    });
  }
  diff(newer, older, ret, 0);
  return ret;
}
function pInt$8(s, mag) {
  return parseInt(s, mag || 10);
}
function isString$l(s) {
  return typeof s === "string";
}
function isArray$s(obj) {
  const str = Object.prototype.toString.call(obj);
  return str === "[object Array]" || str === "[object Array Iterator]";
}
function isObject$p(obj, strict) {
  return !!obj && typeof obj === "object" && (!strict || !isArray$s(obj));
}
function isDOMElement(obj) {
  return isObject$p(obj) && typeof obj.nodeType === "number";
}
function isClass(obj) {
  const c = obj?.constructor;
  return !!(isObject$p(obj, true) && !isDOMElement(obj) && (c?.name && c.name !== "Object"));
}
function isNumber$1d(n2) {
  return typeof n2 === "number" && !isNaN(n2) && n2 < Infinity && n2 > -Infinity;
}
function erase$c(arr, item) {
  let i2 = arr.length;
  while (i2--) {
    if (arr[i2] === item) {
      arr.splice(i2, 1);
      break;
    }
  }
}
function insertItem$2(item, collection) {
  const indexOption = item.options.index, length = collection.length;
  let i2;
  for (
    // Internal item (navigator) should always be pushed to the end
    i2 = item.options.isInternal ? length : 0;
    i2 < length + 1;
    i2++
  ) {
    if (
      // No index option, reached the end of the collection,
      // equivalent to pushing
      !collection[i2] || // Handle index option, the element to insert has lower index
      isNumber$1d(indexOption) && indexOption < pick$1S(collection[i2].options.index, collection[i2]._i) || // Insert the new item before other internal items
      // (navigator)
      collection[i2].options.isInternal
    ) {
      collection.splice(i2, 0, item);
      break;
    }
  }
  return i2;
}
function pushUnique$B(array, item) {
  return array.indexOf(item) < 0 && !!array.push(item);
}
function defined$1h(obj) {
  return typeof obj !== "undefined" && obj !== null;
}
function attr$f(elem, keyOrAttribs, value) {
  const isGetter = isString$l(keyOrAttribs) && !defined$1h(value);
  let ret;
  const attrSingle = (value2, key2) => {
    if (defined$1h(value2)) {
      elem.setAttribute(key2, value2);
    } else if (isGetter) {
      ret = elem.getAttribute(key2);
      if (!ret && key2 === "class") {
        ret = elem.getAttribute(key2 + "Name");
      }
    } else {
      elem.removeAttribute(key2);
    }
  };
  if (isString$l(keyOrAttribs)) {
    attrSingle(value, keyOrAttribs);
  } else {
    objectEach$z(keyOrAttribs, attrSingle);
  }
  return ret;
}
function splat$n(obj) {
  return isArray$s(obj) ? obj : [obj];
}
function syncTimeout$c(fn, delay, context) {
  if (delay > 0) {
    return setTimeout(fn, delay, context);
  }
  fn.call(0, context);
  return -1;
}
function internalClearTimeout(id) {
  if (defined$1h(id)) {
    clearTimeout(id);
  }
}
function extend$1u(a, b) {
  let n2;
  if (!a) {
    a = {};
  }
  for (n2 in b) {
    a[n2] = b[n2];
  }
  return a;
}
function pick$1S() {
  const args = arguments;
  const length = args.length;
  for (let i2 = 0; i2 < length; i2++) {
    const arg = args[i2];
    if (typeof arg !== "undefined" && arg !== null) {
      return arg;
    }
  }
}
function css$g(el, styles) {
  extend$1u(el.style, styles);
}
function createElement$e(tag, attribs, styles, parent, nopad) {
  const el = doc$s.createElement(tag);
  if (attribs) {
    extend$1u(el, attribs);
  }
  if (nopad) {
    css$g(el, { padding: "0", border: "none", margin: "0" });
  }
  if (styles) {
    css$g(el, styles);
  }
  if (parent) {
    parent.appendChild(el);
  }
  return el;
}
function extendClass$1(parent, members) {
  const obj = (function() {
  });
  obj.prototype = new parent();
  extend$1u(obj.prototype, members);
  return obj;
}
function pad$1(number, length, padder) {
  return new Array((length || 2) + 1 - String(number).replace("-", "").length).join(padder || "0") + number;
}
function relativeLength$i(value, base2, offset2) {
  return /%$/.test(value) ? base2 * parseFloat(value) / 100 + (offset2 || 0) : parseFloat(value);
}
function replaceNested$3(text, ...replacements) {
  let previous, replacement;
  do {
    previous = text;
    for (replacement of replacements) {
      text = text.replace(replacement[0], replacement[1]);
    }
  } while (text !== previous);
  return text;
}
function wrap$g(obj, method, func) {
  const proceed = obj[method];
  obj[method] = function() {
    const outerArgs = arguments, scope = this;
    return func.apply(this, [
      function() {
        return proceed.apply(scope, arguments.length ? arguments : outerArgs);
      }
    ].concat([].slice.call(arguments)));
  };
}
function getMagnitude$1(num) {
  return Math.pow(10, Math.floor(Math.log(num) / Math.LN10));
}
function normalizeTickInterval$3(interval, multiples, magnitude, allowDecimals, hasTickAmount) {
  let i2, retInterval = interval;
  magnitude = pick$1S(magnitude, getMagnitude$1(interval));
  const normalized = interval / magnitude;
  if (!multiples) {
    multiples = hasTickAmount ? (
      // Finer grained ticks when the tick amount is hard set, including
      // when alignTicks is true on multiple axes (#4580).
      [1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8, 10]
    ) : (
      // Else, let ticks fall on rounder numbers
      [1, 2, 2.5, 5, 10]
    );
    if (allowDecimals === false) {
      if (magnitude === 1) {
        multiples = multiples.filter(function(num) {
          return num % 1 === 0;
        });
      } else if (magnitude <= 0.1) {
        multiples = [1 / magnitude];
      }
    }
  }
  for (i2 = 0; i2 < multiples.length; i2++) {
    retInterval = multiples[i2];
    if (hasTickAmount && retInterval * magnitude >= interval || !hasTickAmount && normalized <= (multiples[i2] + (multiples[i2 + 1] || multiples[i2])) / 2) {
      break;
    }
  }
  retInterval = correctFloat$g(retInterval * magnitude, -Math.round(Math.log(1e-3) / Math.LN10));
  return retInterval;
}
function stableSort$8(arr, sortFunction) {
  const length = arr.length;
  let sortValue, i2;
  for (i2 = 0; i2 < length; i2++) {
    arr[i2].safeI = i2;
  }
  arr.sort(function(a, b) {
    sortValue = sortFunction(a, b);
    return sortValue === 0 ? a.safeI - b.safeI : sortValue;
  });
  for (i2 = 0; i2 < length; i2++) {
    delete arr[i2].safeI;
  }
}
function arrayMin$9(data) {
  let i2 = data.length, min2 = data[0];
  while (i2--) {
    if (data[i2] < min2) {
      min2 = data[i2];
    }
  }
  return min2;
}
function arrayMax$b(data) {
  let i2 = data.length, max2 = data[0];
  while (i2--) {
    if (data[i2] > max2) {
      max2 = data[i2];
    }
  }
  return max2;
}
function destroyObjectProperties$b(obj, except, destructablesOnly) {
  objectEach$z(obj, function(val, n2) {
    if (val !== except && val?.destroy) {
      val.destroy();
    }
    if (val?.destroy || !destructablesOnly) {
      delete obj[n2];
    }
  });
}
function discardElement$6(element) {
  element?.parentElement?.removeChild(element);
}
function correctFloat$g(num, prec) {
  return num > 1e14 ? num : parseFloat(num.toPrecision(prec || 14));
}
const timeUnits$5 = {
  millisecond: 1,
  second: 1e3,
  minute: 6e4,
  hour: 36e5,
  day: 24 * 36e5,
  week: 7 * 24 * 36e5,
  month: 28 * 24 * 36e5,
  year: 364 * 24 * 36e5
};
Math.easeInOutSine = function(pos) {
  return -0.5 * (Math.cos(Math.PI * pos) - 1);
};
const getAlignFactor$b = (align = "") => ({
  center: 0.5,
  right: 1,
  middle: 0.5,
  bottom: 1
})[align] || 0;
function getClosestDistance$2(arrays, onError) {
  const allowNegative = !onError;
  let closest, loopLength, distance, i2;
  arrays.forEach((xData) => {
    if (xData.length > 1) {
      loopLength = xData.length - 1;
      for (i2 = loopLength; i2 > 0; i2--) {
        distance = xData[i2] - xData[i2 - 1];
        if (distance < 0 && !allowNegative) {
          onError?.();
          onError = void 0;
        } else if (distance && (typeof closest === "undefined" || distance < closest)) {
          closest = distance;
        }
      }
    }
  });
  return closest;
}
function getNestedProperty$4(path, parent) {
  const pathElements = path.split(".");
  while (pathElements.length && defined$1h(parent)) {
    const pathElement = pathElements.shift();
    if (typeof pathElement === "undefined" || pathElement === "__proto__") {
      return;
    }
    if (pathElement === "this") {
      let thisProp;
      if (isObject$p(parent)) {
        thisProp = parent["@this"];
      }
      return thisProp ?? parent;
    }
    const child = parent[pathElement.replace(/[\\'"]/g, "")];
    if (!defined$1h(child) || typeof child === "function" || typeof child.nodeType === "number" || child === win$h) {
      return;
    }
    parent = child;
  }
  return parent;
}
function getStyle$2(el, prop, toInt) {
  let style;
  if (prop === "width") {
    let offsetWidth = Math.min(el.offsetWidth, el.scrollWidth);
    const boundingClientRectWidth = el.getBoundingClientRect?.().width;
    if (boundingClientRectWidth < offsetWidth && boundingClientRectWidth >= offsetWidth - 1) {
      offsetWidth = Math.floor(boundingClientRectWidth);
    }
    return Math.max(
      0,
      // #8377
      offsetWidth - (getStyle$2(el, "padding-left", true) || 0) - (getStyle$2(el, "padding-right", true) || 0)
    );
  }
  if (prop === "height") {
    return Math.max(
      0,
      // #8377
      Math.min(el.offsetHeight, el.scrollHeight) - (getStyle$2(el, "padding-top", true) || 0) - (getStyle$2(el, "padding-bottom", true) || 0)
    );
  }
  const css2 = win$h.getComputedStyle(el, void 0);
  if (css2) {
    style = css2.getPropertyValue(prop);
    if (pick$1S(toInt, prop !== "opacity")) {
      style = pInt$8(style);
    }
  }
  return style;
}
const find$j = Array.prototype.find ? function(arr, callback) {
  return arr.find(callback);
} : (
  // Legacy implementation. PhantomJS, IE <= 11 etc. #7223.
  (function(arr, callback) {
    let i2;
    const length = arr.length;
    for (i2 = 0; i2 < length; i2++) {
      if (callback(arr[i2], i2)) {
        return arr[i2];
      }
    }
  })
);
function offset$1(el) {
  const docElem = doc$s.documentElement, box = el.parentElement || el.parentNode ? el.getBoundingClientRect() : { top: 0, left: 0, width: 0, height: 0 };
  return {
    top: box.top + (win$h.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
    left: box.left + (win$h.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0),
    width: box.width,
    height: box.height
  };
}
function objectEach$z(obj, fn, ctx) {
  for (const key2 in obj) {
    if (Object.hasOwnProperty.call(obj, key2)) {
      fn.call(ctx || obj[key2], obj[key2], key2, obj);
    }
  }
}
function addEvent$1w(el, type, fn, options2 = {}) {
  const owner = typeof el === "function" && el.prototype || el;
  if (!Object.hasOwnProperty.call(owner, "hcEvents")) {
    owner.hcEvents = {};
  }
  const events = owner.hcEvents;
  if (Highcharts.Point && // Without H a dependency loop occurs
  el instanceof Highcharts.Point && el.series && el.series.chart) {
    el.series.chart.runTrackerClick = true;
  }
  const addEventListener = el.addEventListener;
  if (addEventListener) {
    addEventListener.call(el, type, fn, Highcharts.supportsPassiveEvents ? {
      passive: options2.passive === void 0 ? type.indexOf("touch") !== -1 : options2.passive,
      capture: false
    } : false);
  }
  if (!events[type]) {
    events[type] = [];
  }
  const eventObject = {
    fn,
    order: typeof options2.order === "number" ? options2.order : Infinity
  };
  events[type].push(eventObject);
  events[type].sort((a, b) => a.order - b.order);
  return function() {
    removeEvent$d(el, type, fn);
  };
}
function removeEvent$d(el, type, fn) {
  function removeOneEvent(type2, fn2) {
    const removeEventListener = el.removeEventListener;
    if (removeEventListener) {
      removeEventListener.call(el, type2, fn2, false);
    }
  }
  function removeAllEvents(eventCollection) {
    let types, len;
    if (!el.nodeName) {
      return;
    }
    if (type) {
      types = {};
      types[type] = true;
    } else {
      types = eventCollection;
    }
    objectEach$z(types, function(_val, n2) {
      if (eventCollection[n2]) {
        len = eventCollection[n2].length;
        while (len--) {
          removeOneEvent(n2, eventCollection[n2][len].fn);
        }
      }
    });
  }
  const owner = typeof el === "function" && el.prototype || el;
  if (Object.hasOwnProperty.call(owner, "hcEvents")) {
    const events = owner.hcEvents;
    if (type) {
      const typeEvents = events[type] || [];
      if (fn) {
        events[type] = typeEvents.filter(function(obj) {
          return fn !== obj.fn;
        });
        removeOneEvent(type, fn);
      } else {
        removeAllEvents(events);
        events[type] = [];
      }
    } else {
      removeAllEvents(events);
      delete owner.hcEvents;
    }
  }
}
function fireEvent$N(el, type, eventArguments, defaultFunction) {
  eventArguments = eventArguments || {};
  if (doc$s?.createEvent && (el.dispatchEvent || el.fireEvent && // Enable firing events on Highcharts instance.
  el !== Highcharts)) {
    const e = doc$s.createEvent("Events");
    e.initEvent(type, true, true);
    eventArguments = extend$1u(e, eventArguments);
    if (el.dispatchEvent) {
      el.dispatchEvent(eventArguments);
    } else {
      el.fireEvent(type, eventArguments);
    }
  } else if (el.hcEvents) {
    if (!eventArguments.target) {
      extend$1u(eventArguments, {
        // Attach a simple preventDefault function to skip
        // default handler if called. The built-in
        // defaultPrevented property is not overwritable (#5112)
        preventDefault: function() {
          eventArguments.defaultPrevented = true;
        },
        // Setting target to native events fails with clicking
        // the zoom-out button in Chrome.
        target: el,
        // If the type is not set, we're running a custom event
        // (#2297). If it is set, we're running a browser event.
        type
      });
    }
    const events = [];
    let object = el;
    let multilevel = false;
    while (object.hcEvents) {
      if (Object.hasOwnProperty.call(object, "hcEvents") && object.hcEvents[type]) {
        if (events.length) {
          multilevel = true;
        }
        events.unshift.apply(events, object.hcEvents[type]);
      }
      object = Object.getPrototypeOf(object);
    }
    if (multilevel) {
      events.sort((a, b) => a.order - b.order);
    }
    events.forEach((obj) => {
      if (obj.fn.call(el, eventArguments) === false) {
        eventArguments.preventDefault();
      }
    });
  }
  if (defaultFunction && !eventArguments.defaultPrevented) {
    defaultFunction.call(el, eventArguments);
  }
}
let serialMode;
const uniqueKey$a = (function() {
  const hash2 = Math.random().toString(36).substring(2, 9) + "-";
  let id = 0;
  return function() {
    return "highcharts-" + (serialMode ? "" : hash2) + id++;
  };
})();
function useSerialIds(mode2) {
  return serialMode = pick$1S(mode2, serialMode);
}
function isFunction$6(obj) {
  return typeof obj === "function";
}
function ucfirst$2(s) {
  return isString$l(s) ? s.substring(0, 1).toUpperCase() + s.substring(1) : String(s);
}
if (win$h.jQuery) {
  win$h.jQuery.fn.highcharts = function() {
    const args = [].slice.call(arguments);
    if (this[0]) {
      if (args[0]) {
        new Highcharts[
          // eslint-disable-line computed-property-spacing, no-new
          // Constructor defaults to Chart
          isString$l(args[0]) ? args.shift() : "Chart"
        ](this[0], args[0], args[1]);
        return this;
      }
      return charts$4[attr$f(this[0], "data-highcharts-chart")];
    }
  };
}
const Utilities = {
  addEvent: addEvent$1w,
  arrayMax: arrayMax$b,
  arrayMin: arrayMin$9,
  attr: attr$f,
  clamp: clamp$o,
  clearTimeout: internalClearTimeout,
  correctFloat: correctFloat$g,
  createElement: createElement$e,
  crisp: crisp$g,
  css: css$g,
  defined: defined$1h,
  destroyObjectProperties: destroyObjectProperties$b,
  diffObjects: diffObjects$5,
  discardElement: discardElement$6,
  erase: erase$c,
  error: error$b,
  extend: extend$1u,
  extendClass: extendClass$1,
  find: find$j,
  fireEvent: fireEvent$N,
  getAlignFactor: getAlignFactor$b,
  getClosestDistance: getClosestDistance$2,
  getMagnitude: getMagnitude$1,
  getNestedProperty: getNestedProperty$4,
  getStyle: getStyle$2,
  insertItem: insertItem$2,
  isArray: isArray$s,
  isClass,
  isDOMElement,
  isFunction: isFunction$6,
  isNumber: isNumber$1d,
  isObject: isObject$p,
  isString: isString$l,
  merge: merge$1K,
  normalizeTickInterval: normalizeTickInterval$3,
  objectEach: objectEach$z,
  offset: offset$1,
  pad: pad$1,
  pick: pick$1S,
  pInt: pInt$8,
  pushUnique: pushUnique$B,
  relativeLength: relativeLength$i,
  removeEvent: removeEvent$d,
  replaceNested: replaceNested$3,
  splat: splat$n,
  stableSort: stableSort$8,
  syncTimeout: syncTimeout$c,
  timeUnits: timeUnits$5,
  ucfirst: ucfirst$2,
  uniqueKey: uniqueKey$a,
  useSerialIds,
  wrap: wrap$g
};
const ChartDefaults = {
  /**
   * Default `mapData` for all series, in terms of a GeoJSON or TopoJSON
   * object. If set to a string, it functions as an index into the
   * `Highcharts.maps` array.
   *
   * For picking out individual shapes and geometries to use for each series
   * of the map, see [series.mapData](#series.map.mapData).
   *
   * @sample    maps/demo/geojson
   *            Loading GeoJSON data
   * @sample    maps/chart/topojson
   *            Loading TopoJSON data
   *
   * @type      {string|Array<*>|Highcharts.GeoJSON|Highcharts.TopoJSON}
   * @since     5.0.0
   * @product   highmaps
   * @apioption chart.map
   */
  /**
   * Set lat/lon transformation definitions for the chart. If not defined,
   * these are extracted from the map data.
   *
   * @type      {*}
   * @since     5.0.0
   * @product   highmaps
   * @apioption chart.mapTransforms
   */
  /**
   * When using multiple axes, the ticks of two or more opposite axes
   * will automatically be aligned by adding ticks to the axis or axes
   * with the least ticks, as if `tickAmount` were specified.
   *
   * This can be prevented by setting `alignTicks` to false. If the grid
   * lines look messy, it's a good idea to hide them for the secondary
   * axis by setting `gridLineWidth` to 0.
   *
   * If `startOnTick` or `endOnTick` in the axis options are set to false,
   * then the `alignTicks ` will be disabled for the axis.
   *
   * Disabled for logarithmic axes.
   *
   * @sample {highcharts} highcharts/chart/alignticks-true/
   *         True by default
   * @sample {highcharts} highcharts/chart/alignticks-false/
   *         False
   * @sample {highstock} stock/chart/alignticks-true/
   *         True by default
   * @sample {highstock} stock/chart/alignticks-false/
   *         False
   *
   * @type      {boolean}
   * @default   true
   * @product   highcharts highstock gantt
   * @apioption chart.alignTicks
   */
  /**
   * When using multiple axes, align the thresholds. When this is true, other
   * ticks will also be aligned.
   *
   * Note that for line series and some other series types, the `threshold`
   * option is set to `null` by default. This will in turn cause their y-axis
   * to not have a threshold. In order to avoid that, set the series
   * `threshold` to 0 or another number.
   *
   * If `startOnTick` or `endOnTick` in the axis options are set to false, or
   * if the axis is logarithmic, the threshold will not be aligned.
   *
   * @sample {highcharts} highcharts/chart/alignthresholds/ Set to true
   *
   * @since 10.0.0
   * @product   highcharts highstock gantt
   * @apioption chart.alignThresholds
   */
  alignThresholds: false,
  /**
   * Set the overall animation for all chart updating. Animation can be
   * disabled throughout the chart by setting it to false here. It can
   * be overridden for each individual API method as a function parameter.
   * The only animation not affected by this option is the initial series
   * animation, see [plotOptions.series.animation](
   * #plotOptions.series.animation).
   *
   * The animation can either be set as a boolean or a configuration
   * object. If `true`, it will use the 'swing' jQuery easing and a
   * duration of 500 ms. If used as a configuration object, the following
   * properties are supported:
   *
   * - `defer`: The animation delay time in milliseconds.
   *
   * - `duration`: The duration of the animation in milliseconds.
   *
   * - `easing`: A string reference to an easing function set on the
   *   `Math` object. See
   *   [the easing demo](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-animation-easing/).
   *
   * When zooming on a series with less than 100 points, the chart redraw
   * will be done with animation, but in case of more data points, it is
   * necessary to set this option to ensure animation on zoom.
   *
   * @sample {highcharts} highcharts/chart/animation-none/
   *         Updating with no animation
   * @sample {highcharts} highcharts/chart/animation-duration/
   *         With a longer duration
   * @sample {highcharts} highcharts/chart/animation-easing/
   *         With a jQuery UI easing
   * @sample {highmaps} maps/chart/animation-none/
   *         Updating with no animation
   * @sample {highmaps} maps/chart/animation-duration/
   *         With a longer duration
   *
   * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
   * @default   true
   * @apioption chart.animation
   */
  /**
   * A CSS class name to apply to the charts container `div`, allowing
   * unique CSS styling for each chart.
   *
   * @type      {string}
   * @apioption chart.className
   */
  /**
   * Event listeners for the chart.
   *
   * @apioption chart.events
   */
  /**
   * Fires when a series is added to the chart after load time, using the
   * `addSeries` method. One parameter, `event`, is passed to the
   * function, containing common event information. Through
   * `event.options` you can access the series options that were passed to
   * the `addSeries` method. Returning false prevents the series from
   * being added.
   *
   * @sample {highcharts} highcharts/chart/events-addseries/
   *         Alert on add series
   * @sample {highstock} stock/chart/events-addseries/
   *         Alert on add series
   *
   * @type      {Highcharts.ChartAddSeriesCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Chart
   * @apioption chart.events.addSeries
   */
  /**
   * Fires when clicking on the plot background. One parameter, `event`,
   * is passed to the function, containing common event information.
   *
   * Information on the clicked spot can be found through `event.xAxis`
   * and `event.yAxis`, which are arrays containing the axes of each
   * dimension and each axis' value at the clicked spot. The primary axes
   * are `event.xAxis[0]` and `event.yAxis[0]`. Remember the unit of a
   * datetime axis is milliseconds since 1970-01-01 00:00:00.
   *
   * ```js
   * click: function(e) {
   *     console.log(
   *         Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', e.xAxis[0].value),
   *         e.yAxis[0].value
   *     )
   * }
   * ```
   *
   * @sample {highcharts} highcharts/chart/events-click/
   *         Alert coordinates on click
   * @sample {highcharts} highcharts/chart/events-container/
   *         Alternatively, attach event to container
   * @sample {highstock} stock/chart/events-click/
   *         Alert coordinates on click
   * @sample {highstock} highcharts/chart/events-container/
   *         Alternatively, attach event to container
   * @sample {highmaps} maps/chart/events-click/
   *         Record coordinates on click
   * @sample {highmaps} highcharts/chart/events-container/
   *         Alternatively, attach event to container
   *
   * @type      {Highcharts.ChartClickCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Chart
   * @apioption chart.events.click
   */
  /**
   * Fires when the chart is finished loading. Since v4.2.2, it also waits
   * for images to be loaded, for example from point markers. One
   * parameter, `event`, is passed to the function, containing common
   * event information.
   *
   * There is also a second parameter to the chart constructor where a
   * callback function can be passed to be executed on chart.load.
   *
   * @sample {highcharts} highcharts/chart/events-load/
   *         Alert on chart load
   * @sample {highcharts} highcharts/chart/events-render/
   *         Load vs Redraw vs Render
   * @sample {highstock} stock/chart/events-load/
   *         Alert on chart load
   * @sample {highmaps} maps/chart/events-load/
   *         Add series on chart load
   *
   * @type      {Highcharts.ChartLoadCallbackFunction}
   * @context   Highcharts.Chart
   * @apioption chart.events.load
   */
  /**
   * Fires when the chart is redrawn, either after a call to
   * `chart.redraw()` or after an axis, series or point is modified with
   * the `redraw` option set to `true`. One parameter, `event`, is passed
   * to the function, containing common event information.
   *
   * @sample {highcharts} highcharts/chart/events-redraw/
   *         Alert on chart redraw
   * @sample {highcharts} highcharts/chart/events-render/
   *         Load vs Redraw vs Render
   * @sample {highstock} stock/chart/events-redraw/
   *         Alert on chart redraw when adding a series or moving the
   *         zoomed range
   * @sample {highmaps} maps/chart/events-redraw/
   *         Set subtitle on chart redraw
   *
   * @type      {Highcharts.ChartRedrawCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Chart
   * @apioption chart.events.redraw
   */
  /**
   * Fires after initial load of the chart (directly after the `load`
   * event), and after each redraw (directly after the `redraw` event).
   *
   * @sample {highcharts} highcharts/chart/events-render/
   *         Load vs Redraw vs Render
   *
   * @type      {Highcharts.ChartRenderCallbackFunction}
   * @since     5.0.7
   * @context   Highcharts.Chart
   * @apioption chart.events.render
   */
  /**
   * Fires when an area of the chart has been selected. Selection is
   * enabled by setting the chart's zoomType. One parameter, `event`, is
   * passed to the function, containing common event information. The
   * default action for the selection event is to zoom the chart to the
   * selected area. It can be prevented by calling
   * `event.preventDefault()` or return false.
   *
   * Information on the selected area can be found through `event.xAxis`
   * and `event.yAxis`, which are arrays containing the axes of each
   * dimension and each axis' min and max values. The primary axes are
   * `event.xAxis[0]` and `event.yAxis[0]`. Remember the unit of a
   * datetime axis is milliseconds since 1970-01-01 00:00:00.
   *
   * ```js
   * selection: function(event) {
   *     // log the min and max of the primary, datetime x-axis
   *     console.log(
   *         Highcharts.dateFormat(
   *             '%Y-%m-%d %H:%M:%S',
   *             event.xAxis[0].min
   *         ),
   *         Highcharts.dateFormat(
   *             '%Y-%m-%d %H:%M:%S',
   *             event.xAxis[0].max
   *         )
   *     );
   *     // log the min and max of the y axis
   *     console.log(event.yAxis[0].min, event.yAxis[0].max);
   * }
   * ```
   *
   * @sample {highcharts} highcharts/chart/events-selection/
   *         Report on selection and reset
   * @sample {highcharts} highcharts/chart/events-selection-points/
   *         Select a range of points through a drag selection
   * @sample {highstock} stock/chart/events-selection/
   *         Report on selection and reset
   * @sample {highstock} highcharts/chart/events-selection-points/
   *         Select a range of points through a drag selection
   *         (Highcharts)
   *
   * @type      {Highcharts.ChartSelectionCallbackFunction}
   * @apioption chart.events.selection
   */
  /**
   * The margin between the outer edge of the chart and the plot area.
   * The numbers in the array designate top, right, bottom and left
   * respectively. Use the options `marginTop`, `marginRight`,
   * `marginBottom` and `marginLeft` for shorthand setting of one option.
   *
   * By default there is no margin. The actual space is dynamically
   * calculated from the offset of axis labels, axis title, title,
   * subtitle and legend in addition to the `spacingTop`, `spacingRight`,
   * `spacingBottom` and `spacingLeft` options.
   *
   * @sample {highcharts} highcharts/chart/margins-zero/
   *         Zero margins
   * @sample {highstock} stock/chart/margin-zero/
   *         Zero margins
   *
   * @type      {number|Array<number>}
   * @apioption chart.margin
   */
  /**
   * The margin between the bottom outer edge of the chart and the plot
   * area. Use this to set a fixed pixel value for the margin as opposed
   * to the default dynamic margin. See also `spacingBottom`.
   *
   * @sample {highcharts} highcharts/chart/marginbottom/
   *         100px bottom margin
   * @sample {highstock} stock/chart/marginbottom/
   *         100px bottom margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginBottom
   */
  /**
   * The margin between the left outer edge of the chart and the plot
   * area. Use this to set a fixed pixel value for the margin as opposed
   * to the default dynamic margin. See also `spacingLeft`.
   *
   * @sample {highcharts} highcharts/chart/marginleft/
   *         150px left margin
   * @sample {highstock} stock/chart/marginleft/
   *         150px left margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginLeft
   */
  /**
   * The margin between the right outer edge of the chart and the plot
   * area. Use this to set a fixed pixel value for the margin as opposed
   * to the default dynamic margin. See also `spacingRight`.
   *
   * @sample {highcharts} highcharts/chart/marginright/
   *         100px right margin
   * @sample {highstock} stock/chart/marginright/
   *         100px right margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginRight
   */
  /**
   * The margin between the top outer edge of the chart and the plot area.
   * Use this to set a fixed pixel value for the margin as opposed to
   * the default dynamic margin. See also `spacingTop`.
   *
   * @sample {highcharts} highcharts/chart/margintop/ 100px top margin
   * @sample {highstock} stock/chart/margintop/
   *         100px top margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginTop
   */
  /**
   * Callback function to override the default function that formats all
   * the numbers in the chart. Returns a string with the formatted number.
   *
   * @sample highcharts/members/highcharts-numberformat
   *      Arabic digits in Highcharts
   * @type {Highcharts.NumberFormatterCallbackFunction}
   * @since 8.0.0
   * @apioption chart.numberFormatter
   */
  /**
   * When a chart with an x and a y-axis is rendered, we first pre-render the
   * labels of both in order to measure them. Then, if either of the axis
   * labels take up so much space that it significantly affects the length of
   * the other axis, we repeat the process.
   *
   * By default we stop at two axis layout runs, but it may be that the second
   * run also alter the space required by either axis, for example if it
   * causes the labels to rotate. In this situation, a subsequent redraw of
   * the chart may cause the tick and label placement to change for apparently
   * no reason.
   *
   * Use the `axisLayoutRuns` option to set the maximum allowed number of
   * repetitions. But keep in mind that the default value of 2 is set because
   * every run costs performance time.
   *
   * **Note:** Changing that option to higher than the default might decrease
   * performance significantly, especially with bigger sets of data.
   *
   * @type      {number}
   * @default   2
   * @since     11.3.0
   * @apioption chart.axisLayoutRuns
   */
  /**
   * Allows setting a key to switch between zooming and panning. Can be
   * one of `alt`, `ctrl`, `meta` (the command key on Mac and Windows
   * key on Windows) or `shift`. The keys are mapped directly to the key
   * properties of the click event argument (`event.altKey`,
   * `event.ctrlKey`, `event.metaKey` and `event.shiftKey`).
   *
   * @type       {string}
   * @since      4.0.3
   * @product    highcharts gantt
   * @validvalue ["alt", "ctrl", "meta", "shift"]
   * @apioption  chart.panKey
   */
  /**
   * Allow panning in a chart. Best used with [panKey](#chart.panKey)
   * to combine zooming and panning.
   *
   * On touch devices, when the [tooltip.followTouchMove](
   * #tooltip.followTouchMove) option is `true` (default), panning
   * requires two fingers. To allow panning with one finger, set
   * `followTouchMove` to `false`.
   *
   * @sample  {highcharts} highcharts/chart/pankey/ Zooming and panning
   * @sample  {highstock} stock/chart/panning/ Zooming and xy panning
   */
  panning: {
    /**
     * Enable or disable chart panning.
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock|highmaps} true
     */
    enabled: false,
    /**
     * Decides in what dimensions the user can pan the chart. Can be
     * one of `x`, `y`, or `xy`.
     *
     * During panning, all axes will behave as if
     * [`startOnTick`](#yAxis.startOnTick) and
     * [`endOnTick`](#yAxis.endOnTick) were set to `false`. After the
     * panning action is finished, the axes will adjust to their actual
     * settings.
     *
     * @sample {highcharts} highcharts/chart/panning-type
     *         Zooming and xy panning
     *
     * @declare    Highcharts.OptionsChartPanningTypeValue
     * @type       {string}
     * @validvalue ["x", "y", "xy"]
     * @product    highcharts highstock gantt
     */
    type: "x"
  },
  /**
   * Equivalent to [zoomType](#chart.zoomType), but for multitouch
   * gestures only. By default, the `pinchType` is the same as the
   * `zoomType` setting. However, pinching can be enabled separately in
   * some cases, for example in stock charts where a mouse drag pans the
   * chart, while pinching is enabled. When [tooltip.followTouchMove](
   * #tooltip.followTouchMove) is true, pinchType only applies to
   * two-finger touches.
   *
   * @type       {string}
   * @default    {highcharts} undefined
   * @default    {highstock} undefined
   * @since      3.0
   * @product    highcharts highstock gantt
   * @deprecated
   * @validvalue ["x", "y", "xy"]
   * @apioption  chart.pinchType
   */
  /**
   * Whether to apply styled mode. When in styled mode, no presentational
   * attributes or CSS are applied to the chart SVG. Instead, CSS rules
   * are required to style the chart. The default style sheet is
   * available from `https://code.highcharts.com/css/highcharts.css`.
   *
   * [Read more in the docs](https://www.highcharts.com/docs/chart-design-and-style/style-by-css)
   * on what classes and variables are available.
   *
   * @sample highcharts/css/colors
   *         Color theming with CSS
   * @sample highcharts/css/prefers-color-scheme
   *         Dynamic theme based on system settings
   * @type       {boolean}
   * @default    false
   * @since      7.0
   * @apioption  chart.styledMode
   */
  styledMode: false,
  /**
   * The corner radius of the outer chart border.
   *
   * @sample {highcharts} highcharts/chart/borderradius/
   *         20px radius
   * @sample {highstock} stock/chart/border/
   *         10px radius
   * @sample {highmaps} maps/chart/border/
   *         Border options
   *
   */
  borderRadius: 0,
  /**
   * In styled mode, this sets how many colors the class names
   * should rotate between. With ten colors, series (or points) are
   * given class names like `highcharts-color-0`, `highcharts-color-1`
   * [...] `highcharts-color-9`. The equivalent in non-styled mode
   * is to set colors using the [colors](#colors) setting.
   *
   * @since      5.0.0
   */
  colorCount: 10,
  /**
   * By default, (because of memory and performance reasons) the chart does
   * not copy the data but keeps it as a reference. In some cases, this might
   * result in mutating the original data source. In order to prevent that,
   * set that property to false. Please note that changing that might decrease
   * performance, especially with bigger sets of data.
   *
   * @type       {boolean}
   * @since 10.1.0
   */
  allowMutatingData: true,
  /**
   * If true, the axes will scale to the remaining visible series once
   * one series is hidden. If false, hiding and showing a series will
   * not affect the axes or the other series. For stacks, once one series
   * within the stack is hidden, the rest of the stack will close in
   * around it even if the axis is not affected.
   *
   * @sample {highcharts} highcharts/chart/ignorehiddenseries-true/
   *         True by default
   * @sample {highcharts} highcharts/chart/ignorehiddenseries-false/
   *         False
   * @sample {highcharts} highcharts/chart/ignorehiddenseries-true-stacked/
   *         True with stack
   * @sample {highstock} stock/chart/ignorehiddenseries-true/
   *         True by default
   * @sample {highstock} stock/chart/ignorehiddenseries-false/
   *         False
   *
   * @since   1.2.0
   * @product highcharts highstock gantt
   */
  ignoreHiddenSeries: true,
  /**
   * Whether to invert the axes so that the x axis is vertical and y axis
   * is horizontal. When `true`, the x axis is [reversed](#xAxis.reversed)
   * by default.
   *
   * @productdesc {highcharts}
   * If a bar series is present in the chart, it will be inverted
   * automatically. Inverting the chart doesn't have an effect if there
   * are no cartesian series in the chart.
   *
   * @sample {highcharts} highcharts/chart/inverted/
   *         Inverted line
   * @sample {highstock} stock/navigator/inverted/
   *         Inverted stock chart
   *
   * @type      {boolean}
   * @default   false
   * @product   highcharts highstock gantt
   * @apioption chart.inverted
   */
  /**
   * The distance between the outer edge of the chart and the content,
   * like title or legend, or axis title and labels if present. The
   * numbers in the array designate top, right, bottom and left
   * respectively. Use the options spacingTop, spacingRight, spacingBottom
   * and spacingLeft options for shorthand setting of one option.
   *
   * @type    {Array<number>}
   * @see     [chart.margin](#chart.margin)
   * @default [10, 10, 15, 10]
   * @since   3.0.6
   */
  spacing: [10, 10, 15, 10],
  /**
   * The button that appears after a selection zoom, allowing the user
   * to reset zoom. This option is deprecated in favor of
   * [zooming](#chart.zooming).
   *
   * @since      2.2
   * @deprecated 10.2.1
   */
  resetZoomButton: {
    /**
     * What frame the button placement should be related to. Can be
     * either `plotBox` or `spacingBox`.
     *
     * @sample {highcharts} highcharts/chart/resetzoombutton-relativeto/
     *         Relative to the chart
     * @sample {highstock} highcharts/chart/resetzoombutton-relativeto/
     *         Relative to the chart
     *
     * @type      {Highcharts.ButtonRelativeToValue}
     * @apioption chart.resetZoomButton.relativeTo
     */
    /**
     * A collection of attributes for the button. The object takes SVG
     * attributes like `fill`, `stroke`, `stroke-width` or `r`, the
     * border radius. The theme also supports `style`, a collection of
     * CSS properties for the text. Equivalent attributes for the hover
     * state are given in `theme.states.hover`.
     *
     * @sample {highcharts} highcharts/chart/resetzoombutton-theme/
     *         Theming the button
     * @sample {highstock} highcharts/chart/resetzoombutton-theme/
     *         Theming the button
     *
     * @type {Highcharts.SVGAttributes}
     */
    theme: {
      /**
       * The z-index of the button.
       *
       * @type {number}
       * @apioption chart.resetZoomButton.theme.zIndex
       */
    },
    /**
     * The position of the button.
     *
     * @sample {highcharts} highcharts/chart/resetzoombutton-position/
     *         Above the plot area
     * @sample {highstock} highcharts/chart/resetzoombutton-position/
     *         Above the plot area
     * @sample {highmaps} highcharts/chart/resetzoombutton-position/
     *         Above the plot area
     *
     * @type {Highcharts.AlignObject}
     */
    position: {
      /**
       * The horizontal alignment of the button.
       *
       * @type {number}
       * @apioption chart.resetZoomButton.position.align
       */
      /**
       * The horizontal offset of the button.
       *
       * @type {number}
       * @apioption chart.resetZoomButton.position.x
       */
      /**
       * The vertical alignment of the button.
       *
       * @type      {Highcharts.VerticalAlignValue}
       * @apioption chart.resetZoomButton.position.verticalAlign
       */
      /**
       * The vertical offset of the button.
       *
       * @type {number}
       * @apioption chart.resetZoomButton.position.y
       */
    }
  },
  /**
   * The pixel width of the plot area border.
   *
   * @sample {highcharts} highcharts/chart/plotborderwidth/
   *         1px border
   * @sample {highstock} stock/chart/plotborder/
   *         2px border
   * @sample {highmaps} maps/chart/plotborder/
   *         Plot border options
   *
   * @type      {number}
   * @default   0
   * @apioption chart.plotBorderWidth
   */
  /**
   * Whether to apply a drop shadow to the plot area. Requires that
   * plotBackgroundColor be set. The shadow can be an object configuration
   * containing `color`, `offsetX`, `offsetY`, `opacity` and `width`.
   *
   * @sample {highcharts} highcharts/chart/plotshadow/
   *         Plot shadow
   * @sample {highstock} stock/chart/plotshadow/
   *         Plot shadow
   * @sample {highmaps} maps/chart/plotborder/
   *         Plot border options
   *
   * @type      {boolean|Highcharts.ShadowOptionsObject}
   * @default   false
   * @apioption chart.plotShadow
   */
  /**
   * When true, cartesian charts like line, spline, area and column are
   * transformed into the polar coordinate system. This produces _polar
   * charts_, also known as _radar charts_.
   *
   * @sample {highcharts} highcharts/demo/polar/
   *         Polar chart
   * @sample {highcharts} highcharts/demo/polar-wind-rose/
   *         Wind rose, stacked polar column chart
   * @sample {highcharts} highcharts/demo/polar-spider/
   *         Spider web chart
   * @sample {highcharts} highcharts/parallel-coordinates/polar/
   *         Star plot, multivariate data in a polar chart
   *
   * @type      {boolean}
   * @default   false
   * @since     2.3.0
   * @product   highcharts
   * @requires  highcharts-more
   * @apioption chart.polar
   */
  /**
   * Whether to reflow the chart to fit the width of the container div
   * on resizing the window.
   *
   * @sample {highcharts} highcharts/chart/reflow-true/
   *         True by default
   * @sample {highcharts} highcharts/chart/reflow-false/
   *         False
   * @sample {highstock} stock/chart/reflow-true/
   *         True by default
   * @sample {highstock} stock/chart/reflow-false/
   *         False
   * @sample {highmaps} maps/chart/reflow-true/
   *         True by default
   * @sample {highmaps} maps/chart/reflow-false/
   *         False
   *
   * @since     2.1
   */
  reflow: true,
  /**
   * The HTML element where the chart will be rendered. If it is a string,
   * the element by that id is used. The HTML element can also be passed
   * by direct reference, or as the first argument of the chart
   * constructor, in which case the option is not needed.
   *
   * @sample {highcharts} highcharts/chart/reflow-true/
   *         String
   * @sample {highcharts} highcharts/chart/renderto-object/
   *         Object reference
   * @sample {highstock} stock/chart/renderto-string/
   *         String
   * @sample {highstock} stock/chart/renderto-object/
   *         Object reference
   *
   * @type      {string|Highcharts.HTMLDOMElement}
   * @apioption chart.renderTo
   */
  /**
   * The background color of the marker square when selecting (zooming
   * in on) an area of the chart.
   *
   * @see In styled mode, the selection marker fill is set with the
   *      `.highcharts-selection-marker` class.
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @default   rgba(51,92,173,0.25)
   * @since     2.1.7
   * @apioption chart.selectionMarkerFill
   */
  /**
   * Whether to apply a drop shadow to the global series group. This causes
   * all the series to have the same shadow. Contrary to the `series.shadow`
   * option, this prevents items from casting shadows on each other, like for
   * others series in a stack. The shadow can be an object configuration
   * containing `color`, `offsetX`, `offsetY`, `opacity` and `width`.
   *
   * @sample highcharts/chart/seriesgroupshadow/ Shadow
   *
   * @type      {boolean|Highcharts.ShadowOptionsObject}
   * @default   false
   * @apioption chart.shadow
   */
  /**
   * Whether to apply a drop shadow to the outer chart area. Requires
   * that backgroundColor be set. The shadow can be an object
   * configuration containing `color`, `offsetX`, `offsetY`, `opacity` and
   * `width`.
   *
   * @sample {highcharts} highcharts/chart/shadow/
   *         Shadow
   * @sample {highstock} stock/chart/shadow/
   *         Shadow
   * @sample {highmaps} maps/chart/border/
   *         Chart border and shadow
   *
   * @type      {boolean|Highcharts.ShadowOptionsObject}
   * @default   false
   * @apioption chart.shadow
   */
  /**
   * Whether to show the axes initially. This only applies to empty charts
   * where series are added dynamically, as axes are automatically added
   * to cartesian series.
   *
   * @sample {highcharts} highcharts/chart/showaxes-false/
   *         False by default
   * @sample {highcharts} highcharts/chart/showaxes-true/
   *         True
   *
   * @type      {boolean}
   * @since     1.2.5
   * @product   highcharts gantt
   * @apioption chart.showAxes
   */
  /**
   * The space between the bottom edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingbottom/
   *         Spacing bottom set to 100
   * @sample {highstock} stock/chart/spacingbottom/
   *         Spacing bottom set to 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   15
   * @since     2.1
   * @apioption chart.spacingBottom
   */
  /**
   * The space between the left edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingleft/
   *         Spacing left set to 100
   * @sample {highstock} stock/chart/spacingleft/
   *         Spacing left set to 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   10
   * @since     2.1
   * @apioption chart.spacingLeft
   */
  /**
   * The space between the right edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingright-100/
   *         Spacing set to 100
   * @sample {highcharts} highcharts/chart/spacingright-legend/
   *         Legend in right position with default spacing
   * @sample {highstock} stock/chart/spacingright/
   *         Spacing set to 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   10
   * @since     2.1
   * @apioption chart.spacingRight
   */
  /**
   * The space between the top edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingtop-100/
   *         A top spacing of 100
   * @sample {highcharts} highcharts/chart/spacingtop-10/
   *         Floating chart title makes the plot area align to the default
   *         spacingTop of 10.
   * @sample {highstock} stock/chart/spacingtop/
   *         A top spacing of 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   10
   * @since     2.1
   * @apioption chart.spacingTop
   */
  /**
   * Additional CSS styles to apply inline to the container `div` and the root
   * SVG.
   *
   * According to the CSS syntax documentation, it is recommended to quote
   * font family names that contain white space, digits, or punctuation
   * characters other than hyphens. In such cases, wrap the fontFamily
   * name as follows: `fontFamily: '"Font name"'`.
   *
   * Since v11, the root font size is 1rem by default, and all child element
   * are given a relative `em` font size by default. This allows implementers
   * to control all the chart's font sizes by only setting the root level.
   *
   * @see    In styled mode, general chart styles can be set with the
   *         `.highcharts-root` class.
   * @sample {highcharts} highcharts/chart/style-serif-font/
   *         Using a serif type font
   * @sample {highcharts} highcharts/chart/style-special-font/
   *         Using a font with special character in name
   * @sample {highcharts} highcharts/members/relative-font-size/
   *         Relative font sizes
   * @sample {highcharts} highcharts/css/em/
   *         Styled mode with relative font sizes
   * @sample {highstock} stock/chart/style/
   *         Using a serif type font
   * @sample {highmaps} maps/chart/style-serif-font/
   *         Using a serif type font
   *
   * @type      {Highcharts.CSSObject}
   * @default   {"fontFamily": "-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol', sans-serif", "fontSize":"1rem"}
   * @apioption chart.style
   */
  /**
   * The default series type for the chart. Can be any of the chart types
   * listed under [plotOptions](#plotOptions) and [series](#series) or can
   * be a series provided by an additional module.
   *
   * In TypeScript this option has no effect in sense of typing and
   * instead the `type` option must always be set in the series.
   *
   * @sample {highcharts} highcharts/chart/type-bar/
   *         Bar
   * @sample {highstock} stock/chart/type/
   *         Areaspline
   * @sample {highmaps} maps/chart/type-mapline/
   *         Mapline
   *
   * @type       {string}
   * @default    {highcharts} line
   * @default    {highstock} line
   * @default    {highmaps} map
   * @since      2.1.0
   * @apioption  chart.type
   */
  type: "line",
  /**
   * Decides in what dimensions the user can zoom by dragging the mouse.
   * Can be one of `x`, `y` or `xy`.
   *
   * @see [panKey](#chart.panKey)
   *
   * @sample {highcharts} highcharts/chart/zoomtype-none/
   *         None by default
   * @sample {highcharts} highcharts/chart/zoomtype-x/
   *         X
   * @sample {highcharts} highcharts/chart/zoomtype-y/
   *         Y
   * @sample {highcharts} highcharts/chart/zoomtype-xy/
   *         Xy
   * @sample {highcharts} highcharts/chart/zoomtype-polar/
   *         Zoom on polar chart
   * @sample {highstock} stock/demo/basic-line/
   *         None by default
   * @sample {highstock} stock/chart/zoomtype-x/
   *         X
   * @sample {highstock} stock/chart/zoomtype-y/
   *         Y
   * @sample {highstock} stock/chart/zoomtype-xy/
   *         Xy
   * @sample {highmaps} maps/chart/zoomtype-xy/
   *         Map with selection zoom
   *
   * @type       {string}
   * @validvalue ["x", "y", "xy"]
   * @deprecated
   * @apioption  chart.zoomType
   */
  /**
   * Enables zooming by a single touch, in combination with
   * [chart.zoomType](#chart.zoomType). When enabled, two-finger pinch
   * will still work as set up by [chart.pinchType](#chart.pinchType).
   * However, `zoomBySingleTouch` will interfere with touch-dragging the
   * chart to read the tooltip. And especially when vertical zooming is
   * enabled, it will make it hard to scroll vertically on the page.
   * @since      9.0.0
   * @sample     highcharts/chart/zoombysingletouch
   *             Zoom by single touch enabled, with buttons to toggle
   * @product    highcharts highstock gantt
   * @deprecated
   */
  /**
   * Chart zooming options.
   * @since 10.2.1
   */
  zooming: {
    /**
     * Equivalent to [type](#chart.zooming.type), but for multitouch
     * gestures only. By default, the `pinchType` is the same as the
     * `type` setting. However, pinching can be enabled separately in
     * some cases, for example in stock charts where a mouse drag pans the
     * chart, while pinching is enabled. When [tooltip.followTouchMove](
     * #tooltip.followTouchMove) is true, pinchType only applies to
     * two-finger touches.
     *
     * @type       {string}
     * @default    {highcharts} undefined
     * @default    {highstock} x
     * @product    highcharts highstock gantt
     * @validvalue ["x", "y", "xy"]
     * @apioption  chart.zooming.pinchType
     */
    /**
     * Decides in what dimensions the user can zoom by dragging the mouse.
     * Can be one of `x`, `y` or `xy`.
     *
     * @declare    Highcharts.OptionsChartZoomingTypeValue
     * @type       {string}
     * @default    {highcharts} undefined
     * @product    highcharts highstock gantt
     * @validvalue ["x", "y", "xy"]
     * @apioption  chart.zooming.type
     */
    /**
     * Set a key to hold when dragging to zoom the chart. This is useful to
     * avoid zooming while moving points. Should be set different than
     * [chart.panKey](#chart.panKey).
     *
     * @type       {string}
     * @default    {highcharts} undefined
     * @validvalue ["alt", "ctrl", "meta", "shift"]
     * @requires   modules/draggable-points
     * @apioption  chart.zooming.key
     */
    /**
     * Enables zooming by a single touch, in combination with
     * [chart.zooming.type](#chart.zooming.type). When enabled, two-finger
     * pinch will still work as set up by [chart.zooming.pinchType]
     * (#chart.zooming.pinchType). However, `singleTouch` will interfere
     * with touch-dragging the chart to read the tooltip. And especially
     * when vertical zooming is enabled, it will make it hard to scroll
     * vertically on the page.
     *
     * @sample  highcharts/chart/zoombysingletouch
     *          Zoom by single touch enabled, with buttons to toggle
     *
     * @product highcharts highstock gantt
     */
    singleTouch: false,
    /**
     * The button that appears after a selection zoom, allowing the user
     * to reset zoom.
     */
    resetButton: {
      /**
       * What frame the button placement should be related to. Can be
       * either `plotBox` or `spacingBox`.
       *
       * @sample {highcharts} highcharts/chart/resetzoombutton-relativeto/
       *         Relative to the chart
       * @sample {highstock} highcharts/chart/resetzoombutton-relativeto/
       *         Relative to the chart
       *
       * @type      {Highcharts.ButtonRelativeToValue}
       * @default   plot
       * @apioption chart.zooming.resetButton.relativeTo
       */
      /**
       * A collection of attributes for the button. The object takes SVG
       * attributes like `fill`, `stroke`, `stroke-width` or `r`, the
       * border radius. The theme also supports `style`, a collection of
       * CSS properties for the text. Equivalent attributes for the hover
       * state are given in `theme.states.hover`.
       *
       * @sample {highcharts} highcharts/chart/resetzoombutton-theme/
       *         Theming the button
       * @sample {highstock} highcharts/chart/resetzoombutton-theme/
       *         Theming the button
       *
       * @type  {Highcharts.SVGAttributes}
       * @since 10.2.1
       */
      theme: {
        /** @internal */
        zIndex: 6
      },
      /**
       * The position of the button.
       *
       * Note: Adjusting position values might cause overlap with chart
       * elements. Ensure coordinates do not obstruct other components or
       * data visibility.
       *
       * @sample {highcharts} highcharts/chart/resetzoombutton-position/
       *         Above the plot area
       * @sample {highstock} highcharts/chart/resetzoombutton-position/
       *         Above the plot area
       * @sample {highmaps} highcharts/chart/resetzoombutton-position/
       *         Above the plot area
       *
       * @type  {Highcharts.AlignObject}
       * @since 10.2.1
       */
      position: {
        /**
         * The horizontal alignment of the button.
         */
        align: "right",
        /**
         * The horizontal offset of the button.
         */
        x: -10,
        /**
         * The vertical alignment of the button.
         *
         * @type       {Highcharts.VerticalAlignValue}
         * @default    top
         * @apioption  chart.zooming.resetButton.position.verticalAlign
         */
        /**
         * The vertical offset of the button.
         */
        y: 10
      }
    }
  },
  /**
   * An explicit width for the chart. By default (when `null`) the width
   * is calculated from the offset width of the containing element.
   *
   * @sample {highcharts} highcharts/chart/width/
   *         800px wide
   * @sample {highstock} stock/chart/width/
   *         800px wide
   * @sample {highmaps} maps/chart/size/
   *         Chart with explicit size
   *
   * @type {null|number|string}
   */
  width: null,
  /**
   * An explicit height for the chart. If a _number_, the height is
   * given in pixels. If given a _percentage string_ (for example
   * `'56%'`), the height is given as the percentage of the actual chart
   * width. This allows for preserving the aspect ratio across responsive
   * sizes.
   *
   * By default (when `null`) the height is calculated from the offset
   * height of the containing element, or 400 pixels if the containing
   * element's height is 0.
   *
   * @sample {highcharts} highcharts/chart/height/
   *         Forced 200px height
   * @sample {highstock} stock/chart/height/
   *         300px height
   * @sample {highmaps} maps/chart/size/
   *         Chart with explicit size
   * @sample highcharts/chart/height-percent/
   *         Highcharts with percentage height
   * @sample highcharts/chart/height-inherited/
   *         Chart with inherited height
   *
   * @type {null|number|string}
   */
  height: null,
  /**
   * The color of the outer chart border.
   *
   * @see In styled mode, the stroke is set with the
   *      `.highcharts-background` class.
   *
   * @sample {highcharts} highcharts/chart/bordercolor/
   *         Brown border
   * @sample {highstock} stock/chart/border/
   *         Brown border
   * @sample {highmaps} maps/chart/border/
   *         Border options
   *
   * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   */
  borderColor: "#334eff",
  /**
   * The pixel width of the outer chart border.
   *
   * @see In styled mode, the stroke is set with the
   *      `.highcharts-background` class.
   *
   * @sample {highcharts} highcharts/chart/borderwidth/
   *         5px border
   * @sample {highstock} stock/chart/border/
   *         2px border
   * @sample {highmaps} maps/chart/border/
   *         Border options
   *
   * @type      {number}
   * @default   0
   * @apioption chart.borderWidth
   */
  /**
   * The background color or gradient for the outer chart area.
   *
   * @see In styled mode, the background is set with the
   *      `.highcharts-background` class.
   *
   * @sample {highcharts} highcharts/chart/backgroundcolor-color/
   *         Color
   * @sample {highcharts} highcharts/chart/backgroundcolor-gradient/
   *         Gradient
   * @sample {highstock} stock/chart/backgroundcolor-color/
   *         Color
   * @sample {highstock} stock/chart/backgroundcolor-gradient/
   *         Gradient
   * @sample {highmaps} maps/chart/backgroundcolor-color/
   *         Color
   * @sample {highmaps} maps/chart/backgroundcolor-gradient/
   *         Gradient
   *
   * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   */
  backgroundColor: "#ffffff",
  /**
   * The background color or gradient for the plot area.
   *
   * @see In styled mode, the plot background is set with the
   *      `.highcharts-plot-background` class.
   *
   * @sample {highcharts} highcharts/chart/plotbackgroundcolor-color/
   *         Color
   * @sample {highcharts} highcharts/chart/plotbackgroundcolor-gradient/
   *         Gradient
   * @sample {highstock} stock/chart/plotbackgroundcolor-color/
   *         Color
   * @sample {highstock} stock/chart/plotbackgroundcolor-gradient/
   *         Gradient
   * @sample {highmaps} maps/chart/plotbackgroundcolor-color/
   *         Color
   * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
   *         Gradient
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @apioption chart.plotBackgroundColor
   */
  /**
   * The URL for an image to use as the plot background. To set an image
   * as the background for the entire chart, set a CSS background image
   * to the container element. Note that for the image to be applied to
   * exported charts, its URL needs to be accessible by the export server.
   *
   * @see In styled mode, a plot background image can be set with the
   *      `.highcharts-plot-background` class and a [custom pattern](
   *      https://www.highcharts.com/docs/chart-design-and-style/gradients-shadows-and-patterns).
   *
   * @sample {highcharts} highcharts/chart/plotbackgroundimage/
   *         Skies
   * @sample {highstock} stock/chart/plotbackgroundimage/
   *         Skies
   *
   * @type      {string}
   * @apioption chart.plotBackgroundImage
   */
  /**
   * The color of the inner chart or plot area border.
   *
   * @see In styled mode, a plot border stroke can be set with the
   *      `.highcharts-plot-border` class.
   *
   * @sample {highcharts} highcharts/chart/plotbordercolor/
   *         Blue border
   * @sample {highstock} stock/chart/plotborder/
   *         Blue border
   * @sample {highmaps} maps/chart/plotborder/
   *         Plot border options
   *
   * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   */
  plotBorderColor: "#cccccc"
  /* Palette.neutralColor20 */
};
const SeriesPalettes = {
  /**
   * Colors for data series and points
   */
  colors: [
    "#2caffe",
    "#544fc5",
    "#00e272",
    "#fe6a35",
    "#6b8abc",
    "#d568fb",
    "#2ee0ca",
    "#fa4b42",
    "#feb56a",
    "#91e8e1"
  ]
};
const { pageLang: pageLang$1, win: win$g } = Highcharts;
const { defined: defined$1g, error: error$a, extend: extend$1t, isNumber: isNumber$1c, isObject: isObject$o, isString: isString$k, merge: merge$1J, objectEach: objectEach$y, pad, splat: splat$m, timeUnits: timeUnits$4, ucfirst: ucfirst$1 } = Utilities;
const hasOldSafariBug = Highcharts.isSafari && win$g.Intl && !win$g.Intl.DateTimeFormat.prototype.formatRange;
const isDateTimeFormatOptions = (obj) => obj.main === void 0;
class TimeBase {
  /* *
   *
   *  Constructors
   *
   * */
  constructor(options2, lang2) {
    this.options = {
      timezone: "UTC"
    };
    this.variableTimezone = false;
    this.Date = win$g.Date;
    this.update(options2);
    this.lang = lang2;
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Update the Time object with current options. It is called internally on
   * initializing Highcharts, after running `Highcharts.setOptions` and on
   * `Chart.update`.
   *
   * @private
   * @function Highcharts.Time#update
   *
   * @param {Highcharts.TimeOptions} [options]
   *
   */
  update(options2 = {}) {
    this.dTLCache = {};
    this.options = options2 = merge$1J(true, this.options, options2);
    const { timezoneOffset, useUTC } = options2;
    this.Date = options2.Date || win$g.Date || Date;
    let timezone = options2.timezone;
    if (defined$1g(useUTC)) {
      timezone = useUTC ? "UTC" : void 0;
    }
    if (timezoneOffset && timezoneOffset % 60 === 0) {
      timezone = "Etc/GMT" + (timezoneOffset > 0 ? "+" : "") + timezoneOffset / 60;
    }
    this.variableTimezone = timezone !== "UTC" && timezone?.indexOf("Etc/GMT") !== 0;
    this.timezone = timezone;
    ["months", "shortMonths", "weekdays", "shortWeekdays"].forEach((name) => {
      const isMonth = /months/i.test(name), isShort = /short/.test(name), options3 = {
        timeZone: "UTC"
      };
      options3[isMonth ? "month" : "weekday"] = isShort ? "short" : "long";
      this[name] = (isMonth ? [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11] : [3, 4, 5, 6, 7, 8, 9]).map((position) => this.dateFormat(options3, (isMonth ? 31 : 1) * 24 * 36e5 * position));
    });
  }
  /**
   * Get a date in terms of numbers (year, month, day etc) for further
   * processing. Takes the current `timezone` setting into account. Inverse of
   * `makeTime` and the native `Date` constructor and `Date.UTC`.
   *
   * The date is returned in array format with the following indices:
   *
   * 0: year,
   * 1: month (zero based),
   * 2: day,
   * 3: hours,
   * 4: minutes,
   * 5: seconds,
   * 6: milliseconds,
   * 7: weekday (Sunday as 0)
   *
   * @function Highcharts.Time#toParts
   *
   * @param {number|Date} [timestamp]
   *                 The timestamp in milliseconds since January 1st 1970.
   *                 A Date object is also accepted.
   *
   * @return {Array<number>} The date parts in array format.
   */
  toParts(timestamp) {
    const [weekday, dayOfMonth, month, year, hours, minutes, seconds] = this.dateTimeFormat({
      weekday: "narrow",
      day: "numeric",
      month: "numeric",
      year: "numeric",
      hour: "numeric",
      minute: "numeric",
      second: "numeric"
    }, timestamp, "es").split(/(?:, | |\/|:)/g);
    return [
      year,
      +month - 1,
      dayOfMonth,
      hours,
      minutes,
      seconds,
      // Milliseconds
      Math.floor(Number(timestamp) || 0) % 1e3,
      // Spanish weekday index
      "DLMXJVS".indexOf(weekday)
    ].map(Number);
  }
  /**
   * Shorthand to get a cached `Intl.DateTimeFormat` instance.
   */
  dateTimeFormat(options2, timestamp, locale = this.options.locale || pageLang$1) {
    const cacheKey = JSON.stringify(options2) + locale;
    if (isString$k(options2)) {
      options2 = this.str2dtf(options2);
    }
    let dTL = this.dTLCache[cacheKey];
    if (!dTL) {
      options2.timeZone ?? (options2.timeZone = this.timezone);
      try {
        dTL = new Intl.DateTimeFormat(locale, options2);
      } catch (e) {
        if (/Invalid time zone/i.test(e.message)) {
          error$a(34);
          options2.timeZone = "UTC";
          dTL = new Intl.DateTimeFormat(locale, options2);
        } else {
          error$a(e.message, false);
        }
      }
    }
    this.dTLCache[cacheKey] = dTL;
    return dTL?.format(timestamp) || "";
  }
  /**
   * Take a locale-aware string format and return a full DateTimeFormat in
   * object form.
   */
  str2dtf(s, dtf = {}) {
    const mapping = {
      L: { fractionalSecondDigits: 3 },
      S: { second: "2-digit" },
      M: { minute: "numeric" },
      H: { hour: "2-digit" },
      k: { hour: "numeric" },
      E: { weekday: "narrow" },
      a: { weekday: "short" },
      A: { weekday: "long" },
      d: { day: "2-digit" },
      e: { day: "numeric" },
      b: { month: "short" },
      B: { month: "long" },
      m: { month: "2-digit" },
      o: { month: "numeric" },
      y: { year: "2-digit" },
      Y: { year: "numeric" }
    };
    Object.keys(mapping).forEach((key2) => {
      if (s.indexOf(key2) !== -1) {
        extend$1t(dtf, mapping[key2]);
      }
    });
    return dtf;
  }
  /**
   * Make a time and returns milliseconds. Similar to `Date.UTC`, but takes
   * the current `timezone` setting into account.
   *
   * @function Highcharts.Time#makeTime
   *
   * @param {number} year
   *        The year
   *
   * @param {number} month
   *        The month. Zero-based, so January is 0.
   *
   * @param {number} [date=1]
   *        The day of the month
   *
   * @param {number} [hours=0]
   *        The hour of the day, 0-23.
   *
   * @param {number} [minutes=0]
   *        The minutes
   *
   * @param {number} [seconds=0]
   *        The seconds
   *
   * @return {number}
   *         The time in milliseconds since January 1st 1970.
   */
  makeTime(year, month, date = 1, hours = 0, minutes, seconds, milliseconds) {
    let d = this.Date.UTC(year, month, date, hours, minutes || 0, seconds || 0, milliseconds || 0);
    if (this.timezone !== "UTC") {
      const offset2 = this.getTimezoneOffset(d);
      d += offset2;
      if (
        // Optimize for speed by limiting the number of calls to
        // `getTimezoneOffset`. According to
        // https://en.wikipedia.org/wiki/Daylight_saving_time_by_country,
        // DST change may only occur in these months.
        [2, 3, 8, 9, 10, 11].indexOf(month) !== -1 && // DST transitions occur only in the night-time
        (hours < 5 || hours > 20)
      ) {
        const newOffset = this.getTimezoneOffset(d);
        if (offset2 !== newOffset) {
          d += newOffset - offset2;
        } else if (offset2 - 36e5 === this.getTimezoneOffset(d - 36e5) && !hasOldSafariBug) {
          d -= 36e5;
        }
      }
    }
    return d;
  }
  /**
   * Parse a datetime string. Unless the string contains time zone
   * information, apply the current `timezone` from options. If the argument
   * is a number, return it.
   *
   * @function Highcharts.Time#parse
   * @param    {string|number|undefined} s The datetime string to parse
   * @return   {number|undefined}          Parsed JavaScript timestamp
   */
  parse(s) {
    if (!isString$k(s)) {
      return s ?? void 0;
    }
    s = s.replace(/\//g, "-").replace(/(GMT|UTC)/, "");
    const hasTimezone = s.indexOf("Z") > -1 || /([+-][0-9]{2}):?[0-9]{2}$/.test(s), isYYYYMMDD = /^[0-9]{4}-[0-9]{2}(-[0-9]{2}|)$/.test(s);
    if (!hasTimezone && !isYYYYMMDD) {
      s += "Z";
    }
    const ts = Date.parse(s);
    if (isNumber$1c(ts)) {
      return ts + (!hasTimezone || isYYYYMMDD ? this.getTimezoneOffset(ts) : 0);
    }
  }
  /**
   * Get the time zone offset based on the current timezone information as
   * set in the global options.
   *
   * @function Highcharts.Time#getTimezoneOffset
   *
   * @param {number} timestamp
   *        The JavaScript timestamp to inspect.
   *
   * @return {number}
   *         The timezone offset in minutes compared to UTC.
   */
  getTimezoneOffset(timestamp) {
    if (this.timezone !== "UTC") {
      const [date, gmt, hours, colon, minutes = 0] = this.dateTimeFormat({ timeZoneName: "shortOffset" }, timestamp, "en").split(/(GMT|:)/).map(Number), offset2 = -(hours + minutes / 60) * 60 * 6e4;
      if (isNumber$1c(offset2)) {
        return offset2;
      }
    }
    return 0;
  }
  /**
   * Formats a JavaScript date timestamp (milliseconds since January 1 1970)
   * into a human readable date string.
   *
   * The `format` parameter accepts two types of values:
   * - An object containing settings that are passed directly on to
   *   [Intl.DateTimeFormat.prototype.format](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/DateTimeFormat/format).
   * - A format string containing either individual or locale-aware format
   *   keys. **Individual keys**, for example `%Y-%m-%d`, are listed below.
   *   **Locale-aware keys** are grouped by square brackets, for example
   *   `%[Ymd]`. The order of keys within the square bracket doesn't affect
   *   the output, which is determined by the locale. See example below.
   *   Internally, the locale-aware format keys are just a shorthand for the
   *   full object formats, but are particularly practical in
   *   [templating](https://www.highcharts.com/docs/chart-concepts/templating)
   *   where full object definitions are not an option.
   *
   * The available string format keys are listed below. Additional formats can
   * be given in the {@link Highcharts.dateFormats} hook.
   *
   * Supported format keys:
   * | Key  | Description                     | Notes on locale-aware format |
   * -------|----------------------------------------------|-------|
   * | `%A` | Long weekday, like 'Monday'                  |       |
   * | `%a` | Short weekday, like 'Mon'                    |       |
   * | `%E` | Narrow weekday, single character             |       |
   * | `%d` | Two digit day of the month, 01 to 31         |       |
   * | `%e` | Day of the month, 1 through 31               |       |
   * | `%w` | Day of the week, 0 through 6                 | N/A   |
   * | `%v` | The prefix "week from", read from `lang.weekFrom` | N/A |
   * | `%b` | Short month, like 'Jan'                      |       |
   * | `%B` | Long month, like 'January'                   |       |
   * | `%m` | Two digit month number, 01 through 12        |       |
   * | `%o` | Month number, 1 through 12                   |       |
   * | `%y` | Two digits year, like 24 for 2024            |       |
   * | `%Y` | Four digits year, like 2024                  |       |
   * | `%H` | Two digits hours in 24h format, 00 through 23 | Depending on the locale, 12h format may be instered. |
   * | `%k` | Hours in 24h format, 0 through 23            | Depending on the locale, 12h format may be instered. |
   * | `%I` | Two digits hours in 12h format, 00 through 11 | N/A. The locale determines the hour format. |
   * | `%l` | Hours in 12h format, 1 through 12            | N/A. The locale determines the hour format. |
   * | `%M` | Two digits minutes, 00 through 59            |       |
   * | `%p` | Upper case AM or PM                          | N/A. The locale determines whether to add AM and PM. |
   * | `%P` | Lower case AM or PM                          | N/A. The locale determines whether to add AM and PM. |
   * | `%S` | Two digits seconds, 00 through 59            |       |
   * | `%L` | Milliseconds (naming from Ruby)              |       |
   *
   * @example
   * // Object format, US English
   * const time1 = new Highcharts.Time({ locale: 'en-US' });
   * console.log(
   *     time1.dateFormat({
   *         day: 'numeric',
   *         month: 'short',
   *         year: 'numeric',
   *         hour: 'numeric',
   *         minute: 'numeric'
   *     }, Date.UTC(2024, 11, 31))
   * ); // => Dec 31, 2024, 12:00 AM
   *
   * // Object format, British English
   * const time2 = new Highcharts.Time({ locale: 'en-GB' });
   * console.log(
   *     time2.dateFormat({
   *         day: 'numeric',
   *         month: 'short',
   *         year: 'numeric',
   *         hour: 'numeric',
   *         minute: 'numeric'
   *     }, Date.UTC(2024, 11, 31))
   * ); // => 31 Dec 2024, 00:00
   *
   * // Individual key string replacement
   * const time3 = new Highcharts.Time();
   * console.log(
   *     time3.dateFormat('%Y-%m-%d %H:%M:%S', Date.UTC(2024, 11, 31))
   * ); // => 2024-12-31 00:00:00
   *
   * // Locale-aware keys, US English
   * const time4 = new Highcharts.Time({ locale: 'en-US' });
   * console.log(
   *     time4.dateFormat('%[YebHM]', Date.UTC(2024, 11, 31))
   * ); // => Dec 31, 2024, 12:00 AM
   *
   * // Locale-aware keys, British English
   * const time5 = new Highcharts.Time({ locale: 'en-GB' });
   * console.log(
   *     time5.dateFormat('%[YebHM]', Date.UTC(2024, 11, 31))
   * ); // => 31 Dec 2024, 00:00
   *
   * // Mixed locale-aware and individual keys
   * console.log(
   *     time5.dateFormat('%[Yeb], %H:%M', Date.UTC(2024, 11, 31))
   * ); // => 31 Dec 2024, 00:00
   *
   * @function Highcharts.Time#dateFormat
   *
   * @param {string|Highcharts.DateTimeFormatOptions} format
   *        The desired string format where various time representations are
   *        prefixed with %, or an object representing the locale-aware format
   *        options.
   *
   * @param {number} [timestamp]
   *        The JavaScript timestamp.
   *
   * @param {boolean} [upperCaseFirst=false]
   *        Upper case first letter in the return.
   *
   * @return {string}
   *         The formatted date.
   */
  dateFormat(format2, timestamp, upperCaseFirst) {
    const lang2 = this.lang;
    if (!defined$1g(timestamp) || isNaN(timestamp)) {
      return lang2?.invalidDate || "";
    }
    format2 = format2 ?? "%Y-%m-%d %H:%M:%S";
    if (isString$k(format2)) {
      const localeAwareRegex = /%\[([a-zA-Z]+)\]/g;
      let match2;
      while (match2 = localeAwareRegex.exec(format2)) {
        format2 = format2.replace(match2[0], this.dateTimeFormat(match2[1], timestamp, lang2?.locale));
      }
    }
    if (isString$k(format2) && format2.indexOf("%") !== -1) {
      const time = this, [fullYear, month, dayOfMonth, hours, minutes, seconds, milliseconds, weekday] = this.toParts(timestamp), langWeekdays = lang2?.weekdays || this.weekdays, shortWeekdays = lang2?.shortWeekdays || this.shortWeekdays, months = lang2?.months || this.months, shortMonths = lang2?.shortMonths || this.shortMonths, replacements = extend$1t({
        // Day
        // Short weekday, like 'Mon'
        a: shortWeekdays ? shortWeekdays[weekday] : langWeekdays[weekday].substr(0, 3),
        // Long weekday, like 'Monday'
        A: langWeekdays[weekday],
        // Two digit day of the month, 01 to 31
        d: pad(dayOfMonth),
        // Day of the month, 1 through 31
        e: pad(dayOfMonth, 2, " "),
        // Day of the week, 0 through 6
        w: weekday,
        // Week (none implemented)
        // 'W': weekNumber(),
        v: lang2?.weekFrom ?? "",
        // Month
        // Short month, like 'Jan'
        b: shortMonths[month],
        // Long month, like 'January'
        B: months[month],
        // Two digit month number, 01 through 12
        m: pad(month + 1),
        // Month number, 1 through 12 (#8150)
        o: month + 1,
        // Year
        // Two digits year, like 09 for 2009
        y: fullYear.toString().substr(2, 2),
        // Four digits year, like 2009
        Y: fullYear,
        // Time
        // Two digits hours in 24h format, 00 through 23
        H: pad(hours),
        // Hours in 24h format, 0 through 23
        k: hours,
        // Two digits hours in 12h format, 00 through 11
        I: pad(hours % 12 || 12),
        // Hours in 12h format, 1 through 12
        l: hours % 12 || 12,
        // Two digits minutes, 00 through 59
        M: pad(minutes),
        // Upper case AM or PM
        p: hours < 12 ? "AM" : "PM",
        // Lower case AM or PM
        P: hours < 12 ? "am" : "pm",
        // Two digits seconds, 00 through 59
        S: pad(seconds),
        // Milliseconds (naming from Ruby)
        L: pad(milliseconds, 3)
      }, Highcharts.dateFormats);
      objectEach$y(replacements, function(val, key2) {
        if (isString$k(format2)) {
          while (format2.indexOf("%" + key2) !== -1) {
            format2 = format2.replace("%" + key2, typeof val === "function" ? val.call(time, timestamp) : val);
          }
        }
      });
    } else if (isObject$o(format2)) {
      const tzHours = (this.getTimezoneOffset(timestamp) || 0) / (6e4 * 60), timeZone = this.timezone || "Etc/GMT" + (tzHours >= 0 ? "+" : "") + tzHours, { prefix = "", suffix = "" } = format2;
      format2 = prefix + this.dateTimeFormat(extend$1t({ timeZone }, format2), timestamp) + suffix;
    }
    return upperCaseFirst ? ucfirst$1(format2) : format2;
  }
  /**
   * Resolve legacy formats of dateTimeLabelFormats (strings and arrays) into
   * an object.
   * @private
   * @param {string|Array<T>|Highcharts.Dictionary<T>} f
   * General format description
   * @return {Highcharts.Dictionary<T>}
   * The object definition
   */
  resolveDTLFormat(f) {
    if (!isObject$o(f, true)) {
      f = splat$m(f);
      return {
        main: f[0],
        from: f[1],
        to: f[2]
      };
    }
    if (isObject$o(f, true) && isDateTimeFormatOptions(f)) {
      return { main: f };
    }
    return f;
  }
  /**
   * Get the optimal date format for a point, based on a range.
   *
   * @private
   * @function Highcharts.Time#getDateFormat
   *
   * @param {number} range
   *        The time range
   *
   * @param {number} timestamp
   *        The timestamp of the date
   *
   * @param {number} startOfWeek
   *        An integer representing the first day of the week, where 0 is
   *        Sunday.
   *
   * @param {Highcharts.Dictionary<string>} dateTimeLabelFormats
   *        A map of time units to formats.
   *
   * @return {string}
   *         The optimal date format for a point.
   */
  getDateFormat(range2, timestamp, startOfWeek2, dateTimeLabelFormats) {
    const dateStr = this.dateFormat("%m-%d %H:%M:%S.%L", timestamp), blank = "01-01 00:00:00.000", strpos = {
      millisecond: 15,
      second: 12,
      minute: 9,
      hour: 6,
      day: 3
    };
    let n2 = "millisecond", lastN = n2;
    for (n2 in timeUnits$4) {
      if (range2 && range2 === timeUnits$4.week && +this.dateFormat("%w", timestamp) === startOfWeek2 && dateStr.substr(6) === blank.substr(6)) {
        n2 = "week";
        break;
      }
      if (range2 && timeUnits$4[n2] > range2) {
        n2 = lastN;
        break;
      }
      if (strpos[n2] && dateStr.substr(strpos[n2]) !== blank.substr(strpos[n2])) {
        break;
      }
      if (n2 !== "week") {
        lastN = n2;
      }
    }
    return this.resolveDTLFormat(dateTimeLabelFormats[n2]).main;
  }
}
const { defined: defined$1f, extend: extend$1s, timeUnits: timeUnits$3 } = Utilities;
class Time extends TimeBase {
  /**
   * Return an array with time positions distributed on round time values
   * right and right after min and max. Used in datetime axes as well as for
   * grouping data on a datetime axis.
   *
   * @function Highcharts.Time#getTimeTicks
   *
   * @param {Highcharts.TimeNormalizedObject} normalizedInterval
   *        The interval in axis values (ms) and the count
   *
   * @param {number} [min]
   *        The minimum in axis values
   *
   * @param {number} [max]
   *        The maximum in axis values
   *
   * @param {number} [startOfWeek=1]
   *
   * @return {Highcharts.AxisTickPositionsArray}
   * Time positions
   */
  getTimeTicks(normalizedInterval, min2, max2, startOfWeek2) {
    const time = this, tickPositions = [], higherRanks = {}, { count = 1, unitRange } = normalizedInterval;
    let [year, month, dayOfMonth, hours, minutes, seconds] = time.toParts(min2), milliseconds = (min2 || 0) % 1e3, variableDayLength;
    startOfWeek2 ?? (startOfWeek2 = 1);
    if (defined$1f(min2)) {
      milliseconds = unitRange >= timeUnits$3.second ? 0 : (
        // #3935
        count * Math.floor(milliseconds / count)
      );
      if (unitRange >= timeUnits$3.second) {
        seconds = unitRange >= timeUnits$3.minute ? 0 : (
          // #3935
          count * Math.floor(seconds / count)
        );
      }
      if (unitRange >= timeUnits$3.minute) {
        minutes = unitRange >= timeUnits$3.hour ? 0 : count * Math.floor(minutes / count);
      }
      if (unitRange >= timeUnits$3.hour) {
        hours = unitRange >= timeUnits$3.day ? 0 : count * Math.floor(hours / count);
      }
      if (unitRange >= timeUnits$3.day) {
        dayOfMonth = unitRange >= timeUnits$3.month ? 1 : Math.max(1, count * Math.floor(dayOfMonth / count));
      }
      if (unitRange >= timeUnits$3.month) {
        month = unitRange >= timeUnits$3.year ? 0 : count * Math.floor(month / count);
      }
      if (unitRange >= timeUnits$3.year) {
        year -= year % count;
      }
      if (unitRange === timeUnits$3.week) {
        if (count) {
          min2 = time.makeTime(year, month, dayOfMonth, hours, minutes, seconds, milliseconds);
        }
        const weekday = this.dateTimeFormat({
          timeZone: this.timezone,
          weekday: "narrow"
        }, min2, "es"), weekdayNo = "DLMXJVS".indexOf(weekday);
        dayOfMonth += -weekdayNo + startOfWeek2 + // We don't want to skip days that are before
        // startOfWeek (#7051)
        (weekdayNo < startOfWeek2 ? -7 : 0);
      }
      min2 = time.makeTime(year, month, dayOfMonth, hours, minutes, seconds, milliseconds);
      if (time.variableTimezone && defined$1f(max2)) {
        variableDayLength = // Long range, assume we're crossing over.
        max2 - min2 > 4 * timeUnits$3.month || // Short range, check if min and max are in different time
        // zones.
        time.getTimezoneOffset(min2) !== time.getTimezoneOffset(max2);
      }
      let t = min2, i2 = 1;
      while (t < max2) {
        tickPositions.push(t);
        if (unitRange === timeUnits$3.year) {
          t = time.makeTime(year + i2 * count, 0);
        } else if (unitRange === timeUnits$3.month) {
          t = time.makeTime(year, month + i2 * count);
        } else if (variableDayLength && (unitRange === timeUnits$3.day || unitRange === timeUnits$3.week)) {
          t = time.makeTime(year, month, dayOfMonth + i2 * count * (unitRange === timeUnits$3.day ? 1 : 7));
        } else if (variableDayLength && unitRange === timeUnits$3.hour && count > 1) {
          t = time.makeTime(year, month, dayOfMonth, hours + i2 * count);
        } else {
          t += unitRange * count;
        }
        i2++;
      }
      tickPositions.push(t);
      if (unitRange <= timeUnits$3.hour && tickPositions.length < 1e4) {
        tickPositions.forEach((t2) => {
          if (
            // Speed optimization, no need to run dateFormat unless
            // we're on a full or half hour
            t2 % 18e5 === 0 && // Check for local or global midnight
            time.dateFormat("%H%M%S%L", t2) === "000000000"
          ) {
            higherRanks[t2] = "day";
          }
        });
      }
    }
    tickPositions.info = extend$1s(normalizedInterval, {
      higherRanks,
      totalRange: unitRange * count
    });
    return tickPositions;
  }
}
const { isTouchDevice: isTouchDevice$6 } = Highcharts;
const { fireEvent: fireEvent$M, merge: merge$1I } = Utilities;
const defaultOptions$n = {
  /**
   * An array containing the default colors for the chart's series. When
   * all colors are used, new colors are pulled from the start again.
   *
   * Default colors can also be set on a series or series.type basis,
   * see [column.colors](#plotOptions.column.colors),
   * [pie.colors](#plotOptions.pie.colors).
   *
   * In styled mode, the colors option doesn't exist. Instead, colors
   * are defined in CSS and applied either through series or point class
   * names, or through the [chart.colorCount](#chart.colorCount) option.
   *
   * @sample {highcharts} highcharts/chart/colors/
   *         Assign a global color theme
   * @sample highcharts/members/theme-v10/
   *         Latest release styled like version 10
   *
   * @type    {Array<(Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject)>}
   * @default [
   *     "#2caffe",
   *     "#544fc5",
   *     "#00e272",
   *     "#fe6a35",
   *     "#6b8abc",
   *     "#d568fb",
   *     "#2ee0ca",
   *     "#fa4b42",
   *     "#feb56a",
   *     "#91e8e1"
   * ]
   */
  colors: SeriesPalettes.colors,
  /**
   * Styled mode only. Configuration object for adding SVG definitions for
   * reusable elements. See [gradients, shadows and
   * patterns](https://www.highcharts.com/docs/chart-design-and-style/gradients-shadows-and-patterns)
   * for more information and code examples.
   *
   * @type      {*}
   * @since     5.0.0
   * @apioption defs
   */
  /**
   * @ignore-option
   */
  symbols: ["circle", "diamond", "square", "triangle", "triangle-down"],
  /**
   * An object containing language-related strings and settings. A typical
   * setup uses `Highcharts.setOptions` to make the options apply to all
   * charts in the same page.
   *
   * ```js
   * Highcharts.setOptions({
   *     lang: {
   *         locale: 'fr'
   *     }
   * });
   * ```
   *
   * @optionparent lang
   */
  lang: {
    weekFrom: "week from",
    /**
     * The default chart title.
     *
     * @since 12.2.0
     */
    chartTitle: "Chart title",
    /**
     * The browser locale to use for date and number formatting. The actual
     * locale used for each chart is determined in three steps:
     * 1. If this `lang.locale` option is specified, it is used.
     * 2. Else, look for the closest ancestor HTML element with a `lang`
     *    attribute, typically the `<html>` element.
     * 3. If no 'lang' attribute is found, use the default browser locale.
     *
     * Use `en-GB`, British English, for approximate consistency with
     * Highcharts v < 12.
     *
     * @sample highcharts/lang/locale/
     *         Set the locale using the `lang.locale` option
     * @sample highcharts/lang/locale-attribute/
     *         Pick up the locale from the HTML `lang` attribute
     * @sample highcharts/members/highcharts-numberformat
     *         Arabic locale with digits and dates         *
     *
     * @since 12.0.0
     * @type {string|Array<string>}
     */
    locale: void 0,
    /**
     * The loading text that appears when the chart is set into the loading
     * state following a call to `chart.showLoading`.
     */
    loading: "Loading...",
    /**
     * An array containing the months names. Corresponds to the `%B` format
     * in `Highcharts.dateFormat()`. Defaults to 'undefined',
     * meaning the default month names are used according to the
     * `lang.locale` setting.
     *
     * @type    {Array<string>}
     */
    months: void 0,
    /**
     * [Format string](https://www.highcharts.com/docs/chart-concepts/templating) for the default series name.
     *
     * @since 12.2.0
     */
    seriesName: "Series {add index 1}",
    /**
     * An array containing the months names in abbreviated form. Corresponds
     * to the `%b` format in `Highcharts.dateFormat()`. Defaults to
     * 'undefined', meaning the default short month names are used according
     * to the `lang.locale` setting.
     *
     * @type    {Array<string>}
     */
    shortMonths: void 0,
    /**
     * An array containing the weekday names. Defaults to 'undefined',
     * meaning the default weekday names are used according to the
     * `lang.locale` setting.
     *
     * @type    {Array<string>}
     */
    weekdays: void 0,
    /**
     * Short week days, starting Sunday. Defaults to 'undefined', meaning
     * the default short weekday names are used according to the
     * `lang.locale` setting.
     *
     * @sample highcharts/lang/shortweekdays/
     *         Finnish two-letter abbreviations
     *
     * @type      {Array<string>}
     * @since     4.2.4
     * @apioption lang.shortWeekdays
     */
    /**
     * What to show in a date field for invalid dates. Defaults to an empty
     * string.
     *
     * @type      {string}
     * @since     4.1.8
     * @product   highcharts highstock
     * @apioption lang.invalidDate
     */
    /**
     * The title appearing on hovering the zoom in button. The text itself
     * defaults to "+" and can be changed in the button options.
     *
     * @type      {string}
     * @default   Zoom in
     * @product   highmaps
     * @apioption lang.zoomIn
     */
    /**
     * The title appearing on hovering the zoom out button. The text itself
     * defaults to "-" and can be changed in the button options.
     *
     * @type      {string}
     * @default   Zoom out
     * @product   highmaps
     * @apioption lang.zoomOut
     */
    /**
     * The default decimal point used in the `Highcharts.numberFormat`
     * method unless otherwise specified in the function arguments. Defaults
     * to the locale decimal point as determined by `lang.locale`.
     *
     * @type      {string}
     * @default   undefined
     * @since     1.2.2
     * @apioption lang.decimalPoint
     */
    /**
     * [Metric prefixes](https://en.wikipedia.org/wiki/Metric_prefix) used
     * to shorten high numbers in axis labels. Replacing any of the
     * positions with `null` causes the full number to be written. Setting
     * `numericSymbols` to `undefined` disables shortening altogether.
     *
     * @sample {highcharts} highcharts/lang/numericsymbols/
     *         Replacing the symbols with text
     * @sample {highstock} highcharts/lang/numericsymbols/
     *         Replacing the symbols with text
     *
     * @type    {Array<string>}
     * @default ["k", "M", "G", "T", "P", "E"]
     * @since   2.3.0
     */
    numericSymbols: ["k", "M", "G", "T", "P", "E"],
    /**
     * The default name for a pie slice (point).
     * @since 12.2.0
     */
    pieSliceName: "Slice",
    /**
     * The magnitude of [numericSymbols](#lang.numericSymbol) replacements.
     * Use 10000 for Japanese, Korean and various Chinese locales, which
     * use symbols for 10^4, 10^8 and 10^12.
     *
     * @sample highcharts/lang/numericsymbolmagnitude/
     *         10000 magnitude for Japanese
     *
     * @type      {number}
     * @default   1000
     * @since     5.0.3
     * @apioption lang.numericSymbolMagnitude
     */
    /**
     * The default thousands separator used in the `Highcharts.numberFormat`
     * method unless otherwise specified in the function arguments. Defaults
     * to the locale thousands separator as determined by `lang.locale`.
     *
     * @type      {string}
     * @default   undefined
     * @since     1.2.2
     * @apioption lang.thousandsSep
     */
    /**
     * The text for the label appearing when a chart is zoomed.
     *
     * @since 1.2.4
     */
    resetZoom: "Reset zoom",
    /**
     * The tooltip title for the label appearing when a chart is zoomed.
     *
     * @since 1.2.4
     */
    /**
     * The default title of the Y axis
     *
     * @since 12.2.0
     */
    yAxisTitle: "Values",
    resetZoomTitle: "Reset zoom level 1:1"
  },
  /**
   * Global options that don't apply to each chart. These options must be set
   * using the `Highcharts.setOptions` method.
   *
   * ```js
   * Highcharts.setOptions({
   *     global: {
   *         buttonTheme: {
   *             fill: '#d0d0d0'
   *         }
   *     }
   * });
   * ```
   */
  global: {
    /**
     * General theme for buttons. This applies to the zoom button, exporting
     * context menu, map navigation, range selector buttons and custom
     * buttons generated using the `SVGRenderer.button` function. However,
     * each of these may be overridden with more specific options.
     *
     * @sample highcharts/global/buttontheme
     *         General button theme
     * @since 11.4.2
     */
    buttonTheme: {
      /**
       * The fill color for buttons
       */
      fill: "#f7f7f7",
      /**
       * The padding of buttons
       */
      padding: 8,
      /**
       * The border radius for buttons
       */
      r: 2,
      /**
       * The stroke color for buttons
       */
      stroke: "#cccccc",
      /**
       * The stroke width for buttons
       */
      "stroke-width": 1,
      /**
       * CSS styling for the buttons' text
       */
      style: {
        color: "#333333",
        cursor: "pointer",
        fontSize: "0.8em",
        fontWeight: "normal"
      },
      /**
       * State overrides for the buttons
       */
      states: {
        /**
         * Hover state overrides for the buttons are applied in addition
         * to the normal state options
         */
        hover: {
          fill: "#e6e6e6"
          /* Palette.neutralColor10 */
        },
        /**
         * Select state overrides for the buttons are applied in
         * addition to the normal state options
         */
        select: {
          fill: "#e6e9ff",
          style: {
            color: "#000000",
            fontWeight: "bold"
          }
        },
        /**
         * Disabled state overrides for the buttons are applied in
         * addition to the normal state options
         */
        disabled: {
          /**
           * Disabled state CSS style overrides for the buttons' text
           */
          style: {
            color: "#cccccc"
            /* Palette.neutralColor20 */
          }
        }
      }
    }
  },
  /**
   * Time options that can apply globally or to individual charts. These
   * settings affect how `datetime` axes are laid out, how tooltips are
   * formatted, how series
   * [pointIntervalUnit](#plotOptions.series.pointIntervalUnit) works and how
   * the Highcharts Stock range selector handles time.
   *
   * The common use case is that all charts in the same Highcharts object
   * share the same time settings, in which case the global settings are set
   * using `setOptions`.
   *
   * ```js
   * // Apply time settings globally
   * Highcharts.setOptions({
   *     time: {
   *         timezone: 'Europe/London'
   *     }
   * });
   * // Apply time settings by instance
   * const chart = Highcharts.chart('container', {
   *     time: {
   *         timezone: 'America/New_York'
   *     },
   *     series: [{
   *         data: [1, 4, 3, 5]
   *     }]
   * });
   *
   * // Use the Time object
   * console.log(
   *        'Current time in New York',
   *        chart.time.dateFormat('%Y-%m-%d %H:%M:%S', Date.now())
   * );
   * ```
   *
   * Since v6.0.5, the time options were moved from the `global` object to the
   * `time` object, and time options can be set on each individual chart.
   *
   * @sample {highcharts|highstock}
   *         highcharts/time/timezone/
   *         Set the timezone globally
   * @sample {highcharts}
   *         highcharts/time/individual/
   *         Set the timezone per chart instance
   * @sample {highstock}
   *         stock/time/individual/
   *         Set the timezone per chart instance
   *
   * @since     6.0.5
   * @optionparent time
   */
  time: {
    /**
     * A custom `Date` class for advanced date handling. For example,
     * [JDate](https://github.com/tahajahangir/jdate) can be hooked in to
     * handle Jalali dates.
     *
     * @type      {*}
     * @since     4.0.4
     * @product   highcharts highstock gantt
     */
    Date: void 0,
    /**
     * A named time zone. Supported time zone names rely on the browser
     * implementations, as described in the [mdn
     * docs](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/DateTimeFormat/DateTimeFormat#timezone).
     * If the given time zone is not recognized by the browser, Highcharts
     * provides a warning and falls back to returning a 0 offset,
     * corresponding to the UTC time zone.
     *
     * The time zone affects axis scaling, tickmark placement and
     * time display in `Highcharts.dateFormat`.
     *
     * Setting `timezone` to `undefined` falls back to the default browser
     * timezone setting.
     *
     * Until v11.2.0, this option depended on moment.js.
     *
     * @sample {highcharts|highstock} highcharts/time/timezone/ Europe/Oslo
     *
     * @type      {string}
     * @since     5.0.7
     * @product   highcharts highstock gantt
     */
    timezone: "UTC",
    /**
     * The timezone offset in minutes. Positive values are west, negative
     * values are east of UTC, as in the ECMAScript
     * [getTimezoneOffset](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTimezoneOffset)
     * method. Use this to display UTC based data in a predefined time zone.
     *
     * This option is deprecated as of v11.4.1 and will be removed in a
     * future release. Use the [time.timezone](#time.timezone) option
     * instead.
     *
     * @see [time.getTimezoneOffset](#time.getTimezoneOffset)
     *
     * @sample {highcharts|highstock} highcharts/time/timezoneoffset/
     *         Timezone offset
     *
     * @since     3.0.8
     * @deprecated 11.4.2
     * @product   highcharts highstock gantt
     */
    timezoneOffset: 0,
    /**
     * Whether to use UTC time for axis scaling, tickmark placement and
     * time display in `Highcharts.dateFormat`. Advantages of using UTC
     * is that the time displays equally regardless of the user agent's
     * time zone settings. Local time can be used when the data is loaded
     * in real time or when correct Daylight Saving Time transitions are
     * required.
     *
     * Setting `useUTC` to true is equivalent to setting `time.timezone` to
     * `"UTC"`. Setting `useUTC` to false is equivalent to setting
     * `time.timezone` to `undefined`.
     *
     * @see [time.timezone](#timezone)
     *
     * @sample {highcharts} highcharts/time/useutc-true/
     *         True by default
     * @sample {highcharts} highcharts/time/useutc-false/
     *         False
     *
     * @deprecated
     */
    useUTC: void 0
  },
  chart: ChartDefaults,
  /**
   * The chart's main title.
   *
   * @sample {highmaps} maps/title/title/
   *         Title options demonstrated
   * @sample {highcharts} highcharts/title/align-auto/
   *         Default title alignment
   */
  title: {
    /**
     * When the title is floating, the plot area will not move to make space
     * for it.
     *
     * @sample {highcharts} highcharts/chart/zoomtype-none/
     *         False by default
     * @sample {highcharts} highcharts/title/floating/
     *         True - title on top of the plot area
     * @sample {highstock} stock/chart/title-floating/
     *         True - title on top of the plot area
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @apioption title.floating
     */
    /**
     * Whether to
     * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the text.
     *
     * @type      {boolean}
     * @default   false
     * @apioption title.useHTML
     */
    /**
     * The vertical alignment of the title. Can be one of `"top"`,
     * `"middle"` and `"bottom"`. When a value is given, the title behaves
     * as if [floating](#title.floating) were `true`.
     *
     * @sample {highcharts} highcharts/title/verticalalign/
     *         Chart title in bottom right corner
     * @sample {highstock} stock/chart/title-verticalalign/
     *         Chart title in bottom right corner
     *
     * @type      {Highcharts.VerticalAlignValue}
     * @since     2.1
     * @apioption title.verticalAlign
     */
    /**
     * The x position of the title relative to the alignment within
     * `chart.spacingLeft` and `chart.spacingRight`.
     *
     * @sample {highcharts} highcharts/title/align/
     *         Aligned to the plot area (x = 70px = margin left - spacing
     *         left)
     * @sample {highstock} stock/chart/title-align/
     *         Aligned to the plot area (x = 50px = margin left - spacing
     *         left)
     *
     * @type      {number}
     * @default   0
     * @since     2.0
     * @apioption title.x
     */
    /**
     * The y position of the title relative to the alignment within
     * [chart.spacingTop](#chart.spacingTop) and [chart.spacingBottom](
     * #chart.spacingBottom). By default it depends on the font size.
     *
     * @sample {highcharts} highcharts/title/y/
     *         Title inside the plot area
     * @sample {highstock} stock/chart/title-verticalalign/
     *         Chart title in bottom right corner
     *
     * @type      {number}
     * @since     2.0
     * @apioption title.y
     */
    /**
     * CSS styles for the title. Use this for font styling, but use `align`,
     * `x` and `y` for text alignment.
     *
     * Note that the default [title.minScale](#title.minScale) option also
     * affects the rendered font size. In order to keep the font size fixed
     * regardless of title length, set `minScale` to 1.
     *
     * In styled mode, the title style is given in the `.highcharts-title`
     * class.
     *
     * @sample {highcharts} highcharts/title/style/
     *         Custom color and weight
     * @sample {highstock} stock/chart/title-style/
     *         Custom color and weight
     * @sample highcharts/css/titles/
     *         Styled mode
     *
     * @type      {Highcharts.CSSObject}
     * @default   {highcharts|highmaps} { "color": "#333333", "fontSize": "18px" }
     * @default   {highstock} { "color": "#333333", "fontSize": "16px" }
     */
    style: {
      color: "#333333",
      fontWeight: "bold"
    },
    /**
     * The title of the chart. To disable the title, set the `text` to
     * `undefined`.
     *
     * @sample {highcharts} highcharts/title/text/
     *         Custom title
     * @sample {highstock} stock/chart/title-text/
     *         Custom title
     *
     * @default {highcharts|highmaps} Chart title
     * @default {highstock} undefined
     */
    text: "Chart title",
    /**
     * The horizontal alignment of the title. Can be one of "left", "center"
     * and "right".
     *
     * Since v12 it defaults to `undefined`, meaning the alignment is
     * computed for best fit. If the text fits in one line, it aligned to
     * the center, but if it is wrapped into multiple lines, it is aligned
     * to the left.
     *
     * @sample {highcharts} highcharts/title/align-auto/
     *         Default alignment, dynamic
     * @sample {highcharts} highcharts/title/align/
     *         Aligned to the plot area (x = 70px = margin left - spacing
     *         left)
     * @sample {highstock} stock/chart/title-align/
     *         Aligned to the plot area (x = 50px = margin left - spacing
     *         left)
     *
     * @type      {Highcharts.AlignValue}
     * @default   undefined
     * @since     2.0
     * @apioption title.align
     */
    /**
     * The margin between the title and the plot area, or if a subtitle
     * is present, the margin between the subtitle and the plot area.
     *
     * @sample {highcharts} highcharts/title/margin-50/
     *         A chart title margin of 50
     * @sample {highcharts} highcharts/title/margin-subtitle/
     *         The same margin applied with a subtitle
     * @sample {highstock} stock/chart/title-margin/
     *         A chart title margin of 50
     *
     * @since 2.1
     */
    margin: 15,
    /**
     * When the title is too wide to fit in the chart, the default behavior
     * is to scale it down to fit, or apply word wrap if it is scaled down
     * to `minScale` and still doesn't fit.
     *
     * The default value reflects the scale, when using default font sizes,
     * when the title font size matches that of the subtitle. The title
     * still stands out as it is bold by default.
     *
     * Set `minScale` to 1 to avoid downscaling.
     *
     * @sample {highcharts} highcharts/title/align-auto/
     *         Downscaling demonstrated
     *
     * @since 12.0.0
     */
    minScale: 0.67
  },
  /**
   * The chart's subtitle. This can be used both to display a subtitle below
   * the main title, and to display random text anywhere in the chart. The
   * subtitle can be updated after chart initialization through the
   * `Chart.setTitle` method.
   *
   * @sample {highcharts} highcharts/title/align-auto/
   *         Default title alignment
   * @sample {highmaps} maps/title/subtitle/
   *         Subtitle options demonstrated
   */
  subtitle: {
    /**
     * The horizontal alignment of the subtitle. Can be one of "left",
     * "center" and "right". Since v12, it defaults to `undefined`, meaning
     * the actual alignment is inherited from the alignment of the main
     * title.
     *
     * @sample {highcharts} highcharts/title/align-auto/
     *         Default title and subtitle alignment, dynamic
     * @sample {highcharts} highcharts/subtitle/align/
     *         Footnote at right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at bottom right of plot area
     *
     * @type  {Highcharts.AlignValue}
     * @default undefined
     * @since 2.0
     * @apioption subtitle.align
     */
    /**
     * When the subtitle is floating, the plot area will not move to make
     * space for it.
     *
     * @sample {highcharts} highcharts/subtitle/floating/
     *         Floating title and subtitle
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote floating at bottom right of plot area
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @apioption subtitle.floating
     */
    /**
     * CSS styles for the title.
     *
     * In styled mode, the subtitle style is given in the
     * `.highcharts-subtitle` class.
     *
     * @sample {highcharts} highcharts/subtitle/style/
     *         Custom color and weight
     * @sample {highcharts} highcharts/css/titles/
     *         Styled mode
     * @sample {highstock} stock/chart/subtitle-style
     *         Custom color and weight
     * @sample {highstock} highcharts/css/titles/
     *         Styled mode
     * @sample {highmaps} highcharts/css/titles/
     *         Styled mode
     *
     * @type      {Highcharts.CSSObject}
     * @default   {"color": "#666666"}
     * @apioption subtitle.style
     */
    /**
     * Whether to
     * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the text.
     *
     * @type      {boolean}
     * @default   false
     * @apioption subtitle.useHTML
     */
    /**
     * The vertical alignment of the title. Can be one of `"top"`,
     * `"middle"` and `"bottom"`. When middle, the subtitle behaves as
     * floating.
     *
     * @sample {highcharts} highcharts/subtitle/verticalalign/
     *         Footnote at the bottom right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at the bottom right of plot area
     *
     * @type      {Highcharts.VerticalAlignValue}
     * @since     2.1
     * @apioption subtitle.verticalAlign
     */
    /**
     * The x position of the subtitle relative to the alignment within
     * `chart.spacingLeft` and `chart.spacingRight`.
     *
     * @sample {highcharts} highcharts/subtitle/align/
     *         Footnote at right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at the bottom right of plot area
     *
     * @type      {number}
     * @default   0
     * @since     2.0
     * @apioption subtitle.x
     */
    /**
     * The y position of the subtitle relative to the alignment within
     * `chart.spacingTop` and `chart.spacingBottom`. By default the subtitle
     * is laid out below the title unless the title is floating.
     *
     * @sample {highcharts} highcharts/subtitle/verticalalign/
     *         Footnote at the bottom right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at the bottom right of plot area
     *
     * @type      {number}
     * @since     2.0
     * @apioption subtitle.y
     */
    /**
     * CSS styles for the title.
     *
     * In styled mode, the subtitle style is given in the
     * `.highcharts-subtitle` class.
     *
     * @sample {highcharts} highcharts/subtitle/style/
     *         Custom color and weight
     * @sample {highcharts} highcharts/css/titles/
     *         Styled mode
     * @sample {highstock} stock/chart/subtitle-style
     *         Custom color and weight
     * @sample {highstock} highcharts/css/titles/
     *         Styled mode
     * @sample {highmaps} highcharts/css/titles/
     *         Styled mode
     *
     * @type      {Highcharts.CSSObject}
     * @default   {"color": "#666666"}
     */
    style: {
      color: "#666666",
      /**
       * @type {number|string}
       */
      fontSize: "0.8em"
    },
    /**
     * The subtitle of the chart.
     *
     * @sample {highcharts|highstock} highcharts/subtitle/text/
     *         Custom subtitle
     * @sample {highcharts|highstock} highcharts/subtitle/text-formatted/
     *         Formatted and linked text.
     */
    text: ""
  },
  /**
   * The chart's caption, which will render below the chart and will be part
   * of exported charts. The caption can be updated after chart initialization
   * through the `Chart.update` or `Chart.caption.update` methods.
   *
   * @sample highcharts/caption/text/
   *         A chart with a caption
   * @since  7.2.0
   */
  caption: {
    /**
     * When the caption is floating, the plot area will not move to make
     * space for it.
     *
     * @type      {boolean}
     * @default   false
     * @apioption caption.floating
     */
    /**
     * The margin between the caption and the plot area.
     */
    margin: 15,
    /**
     * Whether to
     * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the text.
     *
     * @type      {boolean}
     * @default   false
     * @apioption caption.useHTML
     */
    /**
     * The x position of the caption relative to the alignment within
     * `chart.spacingLeft` and `chart.spacingRight`.
     *
     * @type      {number}
     * @default   0
     * @apioption caption.x
     */
    /**
     * The y position of the caption relative to the alignment within
     * `chart.spacingTop` and `chart.spacingBottom`.
     *
     * @type      {number}
     * @apioption caption.y
     */
    /**
     * CSS styles for the caption.
     *
     * In styled mode, the caption style is given in the
     * `.highcharts-caption` class.
     *
     * @sample {highcharts} highcharts/css/titles/
     *         Styled mode
     *
     * @type      {Highcharts.CSSObject}
     * @default   {"color": "#666666"}
     */
    style: {
      color: "#666666",
      /**
       * @type {number|string}
       */
      fontSize: "0.8em"
    },
    /**
     * The caption text of the chart.
     *
     * @sample {highcharts} highcharts/caption/text/
     *         Custom caption
     */
    text: "",
    /**
     * The horizontal alignment of the caption. Can be one of "left",
     *  "center" and "right".
     *
     * @type  {Highcharts.AlignValue}
     */
    align: "left",
    /**
     * The vertical alignment of the caption. Can be one of `"top"`,
     * `"middle"` and `"bottom"`. When middle, the caption behaves as
     * floating.
     *
     * @type      {Highcharts.VerticalAlignValue}
     */
    verticalAlign: "bottom"
  },
  /**
   * The plotOptions is a wrapper object for config objects for each series
   * type. The config objects for each series can also be overridden for
   * each series item as given in the series array.
   *
   * Configuration options for the series are given in three levels. Options
   * for all series in a chart are given in the [plotOptions.series](
   * #plotOptions.series) object. Then options for all series of a specific
   * type are given in the plotOptions of that type, for example
   * `plotOptions.line`. Next, options for one single series are given in
   * [the series array](#series).
   */
  plotOptions: {},
  /**
   * The legend is a box containing a symbol and name for each series
   * item or point item in the chart. Each series (or points in case
   * of pie charts) is represented by a symbol and its name in the legend.
   *
   * It is possible to override the symbol creator function and create
   * [custom legend symbols](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/studies/legend-custom-symbol/).
   *
   * @productdesc {highmaps}
   * A Highmaps legend by default contains one legend item per series, but if
   * a `colorAxis` is defined, the axis will be displayed in the legend.
   * Either as a gradient, or as multiple legend items for `dataClasses`.
   */
  legend: {
    /**
     * The background color of the legend.
     *
     * @see In styled mode, the legend background fill can be applied with
     *      the `.highcharts-legend-box` class.
     *
     * @sample {highcharts} highcharts/legend/backgroundcolor/
     *         Yellowish background
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     * @apioption legend.backgroundColor
     */
    /**
     * The width of the drawn border around the legend.
     *
     * @see In styled mode, the legend border stroke width can be applied
     *      with the `.highcharts-legend-box` class.
     *
     * @sample {highcharts} highcharts/legend/borderwidth/
     *         2px border width
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type      {number}
     * @default   0
     * @apioption legend.borderWidth
     */
    /**
     * Enable or disable the legend. There is also a series-specific option,
     * [showInLegend](#plotOptions.series.showInLegend), that can hide the
     * series from the legend. In some series types this is `false` by
     * default, so it must set to `true` in order to show the legend for the
     * series.
     *
     * @sample {highcharts} highcharts/legend/enabled-false/ Legend disabled
     * @sample {highstock} stock/legend/align/ Various legend options
     * @sample {highmaps} maps/legend/enabled-false/ Legend disabled
     *
     * @default {highstock} false
     * @default {highmaps} true
     * @default {gantt} false
     */
    enabled: true,
    /**
     * The horizontal alignment of the legend box within the chart area.
     * Valid values are `left`, `center` and `right`.
     *
     * In the case that the legend is aligned in a corner position, the
     * `layout` option will determine whether to place it above/below
     * or on the side of the plot area.
     *
     * @sample {highcharts} highcharts/legend/align/
     *         Legend at the right of the chart
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/alignment/
     *         Legend alignment
     *
     * @type  {Highcharts.AlignValue}
     * @since 2.0
     */
    align: "center",
    /**
     * If the [layout](legend.layout) is `horizontal` and the legend items
     * span over two lines or more, whether to align the items into vertical
     * columns. Setting this to `false` makes room for more items, but will
     * look more messy.
     *
     * @since 6.1.0
     */
    alignColumns: true,
    /**
     * A CSS class name to apply to the legend group.
     */
    className: "highcharts-no-tooltip",
    /**
     * General event handlers for the legend. These event hooks can
     * also be attached to the legend at run time using the
     * `Highcharts.addEvent` function.
     *
     * @declare Highcharts.LegendEventsOptionsObject
     *
     * @private
     */
    events: {},
    /**
     * Fires when the legend item belonging to the series is clicked. One
     * parameter, `event`, is passed to the function. The default action
     * is to toggle the visibility of the series, point or data class. This
     * can be prevented by returning `false` or calling
     * `event.preventDefault()`.
     *
     * @sample {highcharts} highcharts/legend/itemclick/
     *         Confirm hiding and showing
     * @sample {highcharts} highcharts/legend/pie-legend-itemclick/
     *         Confirm toggle visibility of pie slices
     *
     * @type      {Highcharts.LegendItemClickCallbackFunction}
     * @context   Highcharts.Legend
     * @apioption legend.events.itemClick
     */
    /**
     * When the legend is floating, the plot area ignores it and is allowed
     * to be placed below it.
     *
     * @sample {highcharts} highcharts/legend/floating-false/
     *         False by default
     * @sample {highcharts} highcharts/legend/floating-true/
     *         True
     * @sample {highmaps} maps/legend/alignment/
     *         Floating legend
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @apioption legend.floating
     */
    /**
     * The layout of the legend items. Can be one of `horizontal` or
     * `vertical` or `proximate`. When `proximate`, the legend items will be
     * placed as close as possible to the graphs they're representing,
     * except in inverted charts or when the legend position doesn't allow
     * it.
     *
     * @sample {highcharts} highcharts/legend/layout-horizontal/
     *         Horizontal by default
     * @sample {highcharts} highcharts/legend/layout-vertical/
     *         Vertical
     * @sample highcharts/legend/layout-proximate
     *         Labels proximate to the data
     * @sample {highstock} stock/legend/layout-horizontal/
     *         Horizontal by default
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Vertical with data classes
     * @sample {highmaps} maps/legend/layout-vertical/
     *         Vertical with color axis gradient
     *
     * @validvalue ["horizontal", "vertical", "proximate"]
     */
    layout: "horizontal",
    /**
     * In a legend with horizontal layout, the itemDistance defines the
     * pixel distance between each item.
     *
     * @sample {highcharts} highcharts/legend/layout-horizontal/
     *         50px item distance
     * @sample {highstock} highcharts/legend/layout-horizontal/
     *         50px item distance
     *
     * @type      {number}
     * @default   {highcharts} 20
     * @default   {highstock} 20
     * @default   {highmaps} 8
     * @since     3.0.3
     * @apioption legend.itemDistance
     */
    /**
     * The pixel bottom margin for each legend item.
     *
     * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     *
     * @since     2.2.0
     */
    itemMarginBottom: 2,
    /**
     * The pixel top margin for each legend item.
     *
     * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     *
     * @since     2.2.0
     */
    itemMarginTop: 2,
    /**
     * The width for each legend item. By default the items are laid out
     * successively. In a [horizontal layout](legend.layout), if the items
     * are laid out across two rows or more, they will be vertically aligned
     * depending on the [legend.alignColumns](legend.alignColumns) option.
     *
     * @sample {highcharts} highcharts/legend/itemwidth-default/
     *         Undefined by default
     * @sample {highcharts} highcharts/legend/itemwidth-80/
     *         80 for aligned legend items
     *
     * @type      {number}
     * @since     2.0
     * @apioption legend.itemWidth
     */
    /**
     * A [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
     * for each legend label. Available variables relates to properties on
     * the series, or the point in case of pies.
     *
     * @type      {string}
     * @default   {name}
     * @since     1.3
     * @apioption legend.labelFormat
     */
    /* eslint-disable valid-jsdoc */
    /**
     * Callback function to format each of the series' labels. The `this`
     * keyword refers to the series object, or the point object in case of
     * pie charts. By default the series or point name is printed.
     *
     * @productdesc {highmaps}
     * In Highmaps the context can also be a data class in case of a
     * `colorAxis`.
     *
     * @sample {highcharts} highcharts/legend/labelformatter/
     *         Add text
     * @sample {highmaps} maps/legend/labelformatter/
     *         Data classes with label formatter
     *
     * @type {Highcharts.FormatterCallbackFunction<Point|Series>}
     */
    labelFormatter: function() {
      return this.name;
    },
    /**
     * Line height for the legend items. Deprecated as of 2.1\. Instead,
     * the line height for each item can be set using
     * `itemStyle.lineHeight`, and the padding between items using
     * `itemMarginTop` and `itemMarginBottom`.
     *
     * @sample {highcharts} highcharts/legend/lineheight/
     *         Setting padding
     *
     * @deprecated
     *
     * @type      {number}
     * @default   16
     * @since     2.0
     * @product   highcharts gantt
     * @apioption legend.lineHeight
     */
    /**
     * If the plot area sized is calculated automatically and the legend is
     * not floating, the legend margin is the space between the legend and
     * the axis labels or plot area.
     *
     * @sample {highcharts} highcharts/legend/margin-default/
     *         12 pixels by default
     * @sample {highcharts} highcharts/legend/margin-30/
     *         30 pixels
     *
     * @type      {number}
     * @default   12
     * @since     2.1
     * @apioption legend.margin
     */
    /**
     * Maximum pixel height for the legend. When the maximum height is
     * extended, navigation will show.
     *
     * @type      {number}
     * @since     2.3.0
     * @apioption legend.maxHeight
     */
    /**
     * The color of the drawn border around the legend.
     *
     * @see In styled mode, the legend border stroke can be applied with the
     *      `.highcharts-legend-box` class.
     *
     * @sample {highcharts} highcharts/legend/bordercolor/
     *         Brown border
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     */
    borderColor: "#999999",
    /**
     * The border corner radius of the legend.
     *
     * @sample {highcharts} highcharts/legend/borderradius-default/
     *         Square by default
     * @sample {highcharts} highcharts/legend/borderradius-round/
     *         5px rounded
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     */
    borderRadius: 0,
    /**
     * Options for the paging or navigation appearing when the legend is
     * overflown. Navigation works well on screen, but not in static
     * exported images. One way of working around that is to
     * [increase the chart height in
     * export](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/legend/navigation-enabled-false/).
     *
     * @sample highcharts/legend/scrollable-vertical/
     *         Legend with vertical scrollable extension
     * @sample highcharts/legend/scrollable-horizontal/
     *         Legend with horizontal scrollable extension
     *
     */
    navigation: {
      /**
       * How to animate the pages when navigating up or down. A value of
       * `true` applies the default navigation given in the
       * `chart.animation` option. Additional options can be given as an
       * object containing values for easing and duration.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
       * @default   true
       * @since     2.2.4
       * @apioption legend.navigation.animation
       */
      /**
       * The pixel size of the up and down arrows in the legend paging
       * navigation.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type      {number}
       * @default   12
       * @since     2.2.4
       * @apioption legend.navigation.arrowSize
       */
      /**
       * Whether to enable the legend navigation. In most cases, disabling
       * the navigation results in an unwanted overflow.
       *
       * See also the
       * [adapt chart to legend](https://github.com/highcharts/adapt-chart-to-legend)
       * plugin for a solution to extend the chart height to make room for
       * the legend, optionally in exported charts only.
       *
       * @type      {boolean}
       * @default   true
       * @since     4.2.4
       * @apioption legend.navigation.enabled
       */
      /**
       * Text styles for the legend page navigation.
       *
       * @see In styled mode, the navigation items are styled with the
       *      `.highcharts-legend-navigation` class.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type      {Highcharts.CSSObject}
       * @since     2.2.4
       * @apioption legend.navigation.style
       */
      style: {
        /**
         * @type {number|string}
         */
        fontSize: "0.8em"
      },
      /**
       * The color for the active up or down arrow in the legend page
       * navigation.
       *
       * @see In styled mode, the active arrow be styled with the
       *      `.highcharts-legend-nav-active` class.
       *
       * @sample  {highcharts} highcharts/legend/navigation/
       *          Legend page navigation demonstrated
       * @sample  {highstock} highcharts/legend/navigation/
       *          Legend page navigation demonstrated
       *
       * @type  {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @since 2.2.4
       */
      activeColor: "#0022ff",
      /**
       * The color of the inactive up or down arrow in the legend page
       * navigation. .
       *
       * @see In styled mode, the inactive arrow be styled with the
       *      `.highcharts-legend-nav-inactive` class.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type  {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @since 2.2.4
       */
      inactiveColor: "#cccccc"
      /* Palette.neutralColor20 */
    },
    /**
     * The inner padding of the legend box.
     *
     * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     *
     * @type      {number}
     * @default   8
     * @since     2.2.0
     * @apioption legend.padding
     */
    /**
     * Whether to reverse the order of the legend items compared to the
     * order of the series or points as defined in the configuration object.
     *
     * @see [yAxis.reversedStacks](#yAxis.reversedStacks),
     *      [series.legendIndex](#series.legendIndex)
     *
     * @sample {highcharts} highcharts/legend/reversed/
     *         Stacked bar with reversed legend
     *
     * @type      {boolean}
     * @default   false
     * @since     1.2.5
     * @apioption legend.reversed
     */
    /**
     * Whether to show the symbol on the right side of the text rather than
     * the left side. This is common in Arabic and Hebrew.
     *
     * @sample {highcharts} highcharts/legend/rtl/
     *         Symbol to the right
     *
     * @type      {boolean}
     * @default   false
     * @since     2.2
     * @apioption legend.rtl
     */
    /**
     * CSS styles for the legend area. In the 1.x versions the position
     * of the legend area was determined by CSS. In 2.x, the position is
     * determined by properties like `align`, `verticalAlign`, `x` and `y`,
     * but the styles are still parsed for backwards compatibility.
     *
     * @deprecated
     *
     * @type      {Highcharts.CSSObject}
     * @product   highcharts highstock
     * @apioption legend.style
     */
    /**
     * CSS styles for each legend item. Only a subset of CSS is supported,
     * notably those options related to text. The default `textOverflow`
     * property makes long texts truncate. Set it to `undefined` to wrap
     * text instead. A `width` property can be added to control the text
     * width.
     *
     * @see In styled mode, the legend items can be styled with the
     *      `.highcharts-legend-item` class.
     *
     * @sample {highcharts} highcharts/legend/itemstyle/
     *         Bold black text
     * @sample {highmaps} maps/legend/itemstyle/
     *         Item text styles
     *
     * @type    {Highcharts.CSSObject}
     * @default {"color": "#333333", "cursor": "pointer", "fontSize": "0.8em", "fontWeight": "bold", "textOverflow": "ellipsis"}
     */
    itemStyle: {
      /**
       * @ignore
       */
      color: "#333333",
      /**
       * @ignore
       */
      cursor: "pointer",
      /**
       * @ignore
       */
      fontSize: "0.8em",
      /**
       * @ignore
       */
      textDecoration: "none",
      /**
       * @ignore
       */
      textOverflow: "ellipsis"
    },
    /**
     * CSS styles for each legend item in hover mode. Only a subset of
     * CSS is supported, notably those options related to text. Properties
     * are inherited from `style` unless overridden here.
     *
     * @see In styled mode, the hovered legend items can be styled with
     *      the `.highcharts-legend-item:hover` pseudo-class.
     *
     * @sample {highcharts} highcharts/legend/itemhoverstyle/
     *         Red on hover
     * @sample {highmaps} maps/legend/itemstyle/
     *         Item text styles
     *
     * @type    {Highcharts.CSSObject}
     * @default {"color": "#000000"}
     */
    itemHoverStyle: {
      /**
       * @ignore
       */
      color: "#000000"
      /* Palette.neutralColor100 */
    },
    /**
     * CSS styles for each legend item when the corresponding series or
     * point is hidden. Only a subset of CSS is supported, notably those
     * options related to text. Properties are inherited from `style`
     * unless overridden here.
     *
     * @see In styled mode, the hidden legend items can be styled with
     *      the `.highcharts-legend-item-hidden` class.
     *
     * @sample {highcharts} highcharts/legend/itemhiddenstyle/
     *         Darker gray color
     *
     * @type    {Highcharts.CSSObject}
     * @default {"color": "#cccccc"}
     */
    itemHiddenStyle: {
      /**
       * @ignore
       */
      color: "#666666",
      /**
       * @ignore
       */
      textDecoration: "line-through"
    },
    /**
     * Whether to apply a drop shadow to the legend. A `backgroundColor`
     * also needs to be applied for this to take effect. The shadow can be
     * an object configuration containing `color`, `offsetX`, `offsetY`,
     * `opacity` and `width`.
     *
     * @sample {highcharts} highcharts/legend/shadow/
     *         White background and drop shadow
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type {boolean|Highcharts.CSSObject}
     */
    shadow: false,
    /**
     * Default styling for the checkbox next to a legend item when
     * `showCheckbox` is true.
     *
     * @type {Highcharts.CSSObject}
     * @default {"width": "13px", "height": "13px", "position":"absolute"}
     */
    itemCheckboxStyle: {
      /**
       * @ignore
       */
      position: "absolute",
      /**
       * @ignore
       */
      width: "13px",
      // For IE precision
      /**
       * @ignore
       */
      height: "13px"
    },
    /// itemWidth: undefined,
    /**
     * When this is true, the legend symbol width will be the same as
     * the symbol height, which in turn defaults to the font size of the
     * legend items.
     *
     * @since 5.0.0
     */
    squareSymbol: true,
    /**
     * The pixel height of the symbol for series types that use a rectangle
     * in the legend. Defaults to the font size of legend items.
     *
     * Note: This option is a default source of color axis height, if the
     * [colorAxis.height](https://api.highcharts.com/highcharts/colorAxis.height)
     * option is not set.
     *
     * @productdesc {highmaps}
     * In Highmaps, when the symbol is the gradient of a vertical color
     * axis, the height defaults to 200.
     *
     * @sample {highmaps} maps/legend/layout-vertical-sized/
     *         Sized vertical gradient
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         No distance between data classes
     *
     * @type      {number}
     * @since     3.0.8
     * @apioption legend.symbolHeight
     */
    /**
     * The border radius of the symbol for series types that use a rectangle
     * in the legend. Defaults to half the `symbolHeight`, effectively
     * creating a circle.
     *
     * For color axis scales, it defaults to 3.
     *
     * @sample {highcharts} highcharts/legend/symbolradius/
     *         Round symbols
     * @sample {highstock} highcharts/legend/symbolradius/
     *         Round symbols
     * @sample {highmaps} highcharts/legend/symbolradius/
     *         Round symbols
     *
     * @type      {number}
     * @since     3.0.8
     * @apioption legend.symbolRadius
     */
    /**
     * The pixel width of the legend item symbol. When the `squareSymbol`
     * option is set, this defaults to the `symbolHeight`, otherwise 16.
     *
     * Note: This option is a default source of color axis width, if the
     * [colorAxis.width](https://api.highcharts.com/highcharts/colorAxis.width)
     * option is not set.
     *
     * @productdesc {highmaps}
     * In Highmaps, when the symbol is the gradient of a horizontal color
     * axis, the width defaults to 200.
     *
     * @sample {highcharts} highcharts/legend/symbolwidth/
     *         Greater symbol width and padding
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/layout-vertical-sized/
     *         Sized vertical gradient
     *
     * @type      {number}
     * @apioption legend.symbolWidth
     */
    /**
     * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the legend item texts.
     *
     * Prior to 4.1.7, when using HTML, [legend.navigation](
     * #legend.navigation) was disabled.
     *
     * @sample highcharts/legend/scrollable-vertical/
     *         Legend with vertical scrollable extension
     * @sample highcharts/legend/scrollable-horizontal/
     *         Legend with horizontal scrollable extension
     *
     * @type      {boolean}
     * @default   false
     * @apioption legend.useHTML
     */
    /**
     * For a color axis with data classes, how many decimals to render in
     * the legend. The default preserves the decimals of the range numbers.
     *
     * @type      {number}
     * @default   -1
     * @product   highcharts highmaps
     * @apioption legend.valueDecimals
     */
    /**
     * For a color axis with data classes, a suffix for the range numbers in
     * the legend.
     *
     * @type      {string}
     * @default   ''
     * @product   highcharts highmaps
     * @apioption legend.valueSuffix
     */
    /**
     * The width of the legend box. If a number is set, it translates to
     * pixels. Since v7.0.2 it allows setting a percent string of the full
     * chart width, for example `40%`.
     *
     * Defaults to the full chart width for legends below or above the
     * chart, half the chart width for legends to the left and right.
     *
     * @sample {highcharts} highcharts/legend/width/
     *         Aligned to the plot area
     * @sample {highcharts} highcharts/legend/width-percent/
     *         A percent of the chart width
     *
     * @type      {number|string}
     * @since     2.0
     * @apioption legend.width
     */
    /**
     * The pixel padding between the legend item symbol and the legend
     * item text.
     *
     * @sample {highcharts} highcharts/legend/symbolpadding/
     *         Greater symbol width and padding
     */
    symbolPadding: 5,
    /**
     * The vertical alignment of the legend box. Can be one of `top`,
     * `middle` or `bottom`. Vertical position can be further determined
     * by the `y` option.
     *
     * In the case that the legend is aligned in a corner position, the
     * `layout` option will determine whether to place it above/below
     * or on the side of the plot area.
     *
     * When the [layout](#legend.layout) option is `proximate`, the
     * `verticalAlign` option doesn't apply.
     *
     * @sample {highcharts} highcharts/legend/verticalalign/
     *         Legend 100px from the top of the chart
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/alignment/
     *         Legend alignment
     *
     * @type  {Highcharts.VerticalAlignValue}
     * @since 2.0
     */
    verticalAlign: "bottom",
    // Width: undefined,
    /**
     * The x offset of the legend relative to its horizontal alignment
     * `align` within chart.spacingLeft and chart.spacingRight. Negative
     * x moves it to the left, positive x moves it to the right.
     *
     * @sample {highcharts} highcharts/legend/width/
     *         Aligned to the plot area
     *
     * @since 2.0
     */
    x: 0,
    /**
     * The vertical offset of the legend relative to it's vertical alignment
     * `verticalAlign` within chart.spacingTop and chart.spacingBottom.
     *  Negative y moves it up, positive y moves it down.
     *
     * @sample {highcharts} highcharts/legend/verticalalign/
     *         Legend 100px from the top of the chart
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/alignment/
     *         Legend alignment
     *
     * @since 2.0
     */
    y: 0,
    /**
     * A title to be added on top of the legend.
     *
     * @sample {highcharts} highcharts/legend/title/
     *         Legend title
     * @sample {highmaps} maps/legend/alignment/
     *         Legend with title
     *
     * @since 3.0
     */
    title: {
      /**
       * A text or HTML string for the title.
       *
       * @type      {string}
       * @since     3.0
       * @apioption legend.title.text
       */
      /**
       * Generic CSS styles for the legend title.
       *
       * @see In styled mode, the legend title is styled with the
       *      `.highcharts-legend-title` class.
       *
       * @type    {Highcharts.CSSObject}
       * @default {"fontSize": "0.8em", "fontWeight": "bold"}
       * @since   3.0
       */
      style: {
        /**
         * @ignore
         */
        fontSize: "0.8em",
        /**
         * @ignore
         */
        fontWeight: "bold"
      }
    }
  },
  /**
   * The loading options control the appearance of the loading screen
   * that covers the plot area on chart operations. This screen only
   * appears after an explicit call to `chart.showLoading()`. It is a
   * utility for developers to communicate to the end user that something
   * is going on, for example while retrieving new data via an XHR connection.
   * The "Loading..." text itself is not part of this configuration
   * object, but part of the `lang` object.
   */
  loading: {
    /**
     * The duration in milliseconds of the fade out effect.
     *
     * @sample highcharts/loading/hideduration/
     *         Fade in and out over a second
     *
     * @type      {number}
     * @default   100
     * @since     1.2.0
     * @apioption loading.hideDuration
     */
    /**
     * The duration in milliseconds of the fade in effect.
     *
     * @sample highcharts/loading/hideduration/
     *         Fade in and out over a second
     *
     * @type      {number}
     * @default   100
     * @since     1.2.0
     * @apioption loading.showDuration
     */
    /**
     * CSS styles for the loading label `span`.
     *
     * @see In styled mode, the loading label is styled with the
     *      `.highcharts-loading-inner` class.
     *
     * @sample {highcharts|highmaps} highcharts/loading/labelstyle/
     *         Vertically centered
     * @sample {highstock} stock/loading/general/
     *         Label styles
     *
     * @type    {Highcharts.CSSObject}
     * @default {"fontWeight": "bold", "position": "relative", "top": "45%"}
     * @since   1.2.0
     */
    labelStyle: {
      /**
       * @ignore
       */
      fontWeight: "bold",
      /**
       * @ignore
       */
      position: "relative",
      /**
       * @ignore
       */
      top: "45%"
    },
    /**
     * CSS styles for the loading screen that covers the plot area.
     *
     * In styled mode, the loading label is styled with the
     * `.highcharts-loading` class.
     *
     * @sample  {highcharts|highmaps} highcharts/loading/style/
     *          Gray plot area, white text
     * @sample  {highstock} stock/loading/general/
     *          Gray plot area, white text
     *
     * @type    {Highcharts.CSSObject}
     * @default {"position": "absolute", "backgroundColor": "#ffffff", "opacity": 0.5, "textAlign": "center"}
     * @since   1.2.0
     */
    style: {
      /**
       * @ignore
       */
      position: "absolute",
      /**
       * @ignore
       */
      backgroundColor: "#ffffff",
      /**
       * @ignore
       */
      opacity: 0.5,
      /**
       * @ignore
       */
      textAlign: "center"
    }
  },
  /**
   * Options for the tooltip that appears when the user hovers over a
   * series or point.
   *
   * @declare Highcharts.TooltipOptions
   */
  tooltip: {
    /**
     * The color of the tooltip border. When `undefined`, the border takes
     * the color of the corresponding series or point.
     *
     * Note that the [borderWidth](#tooltip.borderWidth) is usually 0 by
     * default, so the border color may not be visible until a border width
     * is set.
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/ Follow
     *         series by default
     * @sample {highcharts} highcharts/tooltip/bordercolor-black/ Black
     *         border
     * @sample {highstock} stock/tooltip/general/ Styled tooltip
     * @sample {highmaps} maps/tooltip/background-border/ Background and
     *         border demo
     *
     * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     * @apioption tooltip.borderColor
     */
    /**
     * A CSS class name to apply to the tooltip's container div,
     * allowing unique CSS styling for each chart.
     *
     * @type      {string}
     * @apioption tooltip.className
     */
    /**
     * Since 4.1, the crosshair definitions are moved to the Axis object
     * in order for a better separation from the tooltip. See
     * [xAxis.crosshair](#xAxis.crosshair).
     *
     * @sample {highcharts} highcharts/tooltip/crosshairs-x/
     *         Enable a crosshair for the x value
     *
     * @deprecated
     *
     * @type      {*}
     * @default   true
     * @apioption tooltip.crosshairs
     */
    /**
     * Distance from point to tooltip in pixels.
     *
     * @type      {number}
     * @default   16
     * @apioption tooltip.distance
     */
    /**
     * Whether the tooltip should be fixed to one position in the chart, or
     * located next to the point or mouse. When the tooltip is fixed, the
     * position can be further specified with the
     * [tooltip.position](#tooltip.position) options set.
     *
     * @sample    highcharts/tooltip/fixed/
     *            Fixed tooltip and position options
     * @sample    {highstock} stock/tooltip/fixed/
     *            Stock chart with fixed tooltip
     * @sample    {highmaps} maps/tooltip/fixed/
     *            Map with fixed tooltip
     *
     * @type      {boolean}
     * @default   false
     * @since 12.2.0
     * @apioption tooltip.fixed
     */
    /**
     * Whether the tooltip should follow the mouse as it moves across
     * columns, pie slices and other point types with an extent.
     * By default it behaves this way for pie, polygon, map, sankey
     * and wordcloud series by override in the `plotOptions`
     * for those series types.
     *
     * Does not apply if [split](#tooltip.split) is `true`.
     *
     * For touch moves to behave the same way, [followTouchMove](
     * #tooltip.followTouchMove) must be `true` also.
     *
     * @sample highcharts/tooltip/followpointer/
     *         Tooltip follow pointer comparison
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock} false
     * @default   {highmaps} true
     * @since     3.0
     * @apioption tooltip.followPointer
     */
    /**
     * Whether the tooltip should update as the finger moves on a touch
     * device. If this is `true` and [chart.panning](#chart.panning) is
     * set,`followTouchMove` will take over one-finger touches, so the user
     * needs to use two fingers for zooming and panning.
     *
     * Note the difference to [followPointer](#tooltip.followPointer) that
     * only defines the _position_ of the tooltip. If `followPointer` is
     * false in for example a column series, the tooltip will show above or
     * below the column, but as `followTouchMove` is true, the tooltip will
     * jump from column to column as the user swipes across the plot area.
     *
     * @type      {boolean}
     * @default   {highcharts} true
     * @default   {highstock} true
     * @default   {highmaps} false
     * @since     3.0.1
     * @apioption tooltip.followTouchMove
     */
    /**
     * A [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
     * for the whole shared tooltip. When format strings are a requirement,
     * it is usually more convenient to use `headerFormat`, `pointFormat`
     * and `footerFormat`, but the `format` option allows combining them
     * into one setting.
     *
     * The context of the format string is the same as that of the
     * `tooltip.formatter` callback.
     *
     * @sample {highcharts} highcharts/tooltip/format-shared/
     *         Format for shared tooltip
     *
     * @type      {string}
     * @default   undefined
     * @since     11.1.0
     * @apioption tooltip.format
     */
    /**
     * Callback function to format the text of the tooltip from scratch. In
     * case of single or [shared](#tooltip.shared) tooltips, a string should
     * be returned. In case of [split](#tooltip.split) tooltips, it should
     * return an array where the first item is the header, and subsequent
     * items are mapped to the points. Return `false` to disable tooltip for
     * a specific point on series.
     *
     * A subset of HTML is supported. Unless `useHTML` is true, the HTML of
     * the tooltip is parsed and converted to SVG, therefore this isn't a
     * complete HTML renderer. The following HTML tags are supported: `b`,
     * `br`, `em`, `i`, `span`, `strong`. Spans can be styled with a `style`
     * attribute, but only text-related CSS, that is shared with SVG, is
     * handled.
     *
     * The context of the formatter (since v12) is the
     * [Point](https://api.highcharts.com/class-reference/Highcharts.Point)
     * instance. If the tooltip is shared or split, an array `this.points`
     * contains all points of the hovered x-value.
     *
     * Common properties from the Point to use in the formatter include:
     *
     * - **Point.percentage**:
     *   Stacked series and pies only. The point's percentage of the total.
     *
     * - **Point.points**:
     *   In a shared or split tooltip, this is an array containing all the
     *   hovered points.
     *
     * - **this.series**:
     *   The series object. The series name is available through
     *   `this.series.name`.
     *
     * - **this.total**:
     *   The total value at this point's x value in a stacked series, or the
     *   sum of all slices in a pie series.
     *
     * - **this.x**:
     *   The x value.
     *
     * - **this.y**:
     *   The y value.
     *
     * @sample {highcharts} highcharts/tooltip/formatter-simple/
     *         Simple string formatting
     * @sample {highcharts} highcharts/tooltip/formatter-shared/
     *         Formatting with shared tooltip
     * @sample {highcharts|highstock} highcharts/tooltip/formatter-split/
     *         Formatting with split tooltip
     * @sample highcharts/tooltip/formatter-conditional-default/
     *         Extending default formatter
     * @sample {highstock} stock/tooltip/formatter/
     *         Formatting with shared tooltip
     * @sample {highmaps} maps/tooltip/formatter/
     *         String formatting
     *
     * @type      {Highcharts.TooltipFormatterCallbackFunction}
     * @apioption tooltip.formatter
     */
    /**
     * Callback function to format the text of the tooltip for
     * visible null points.
     * Works analogously to [formatter](#tooltip.formatter).
     *
     * @sample highcharts/plotoptions/series-nullformat
     *         Format data label and tooltip for null point.
     *
     * @type      {Highcharts.TooltipFormatterCallbackFunction}
     * @apioption tooltip.nullFormatter
     */
    /**
     * Whether to allow the tooltip to render outside the chart's SVG
     * element box. By default (`false`), the tooltip is rendered within the
     * chart's SVG element, which results in the tooltip being aligned
     * inside the chart area. For small charts, this may result in clipping
     * or overlapping. When `true`, a separate SVG element is created and
     * overlaid on the page, allowing the tooltip to be aligned inside the
     * page itself. Beware that with this option active, CSS classes on the
     * chart's target container, with classnames matching the pattern
     * 'highcharts-*', will be set on the tooltip as well. This is done to
     * support theming for tooltips with this option.
     *
     * Defaults to `true` if `chart.scrollablePlotArea` is activated,
     * otherwise `false`.
     *
     * @sample highcharts/tooltip/outside
     *         Small charts with tooltips outside
     *
     * @type      {boolean|undefined}
     * @default   undefined
     * @since     6.1.1
     * @apioption tooltip.outside
     */
    /**
     * A callback function for formatting the HTML output for a single point
     * in the tooltip. Like the `pointFormat` string, but with more
     * flexibility.
     *
     * @type      {Highcharts.FormatterCallbackFunction<Highcharts.Point>}
     * @since     4.1.0
     * @context   Highcharts.Point
     * @apioption tooltip.pointFormatter
     */
    /**
     * A callback function to place the tooltip in a custom position. The
     * callback receives three parameters: `labelWidth`, `labelHeight` and
     * `point`, where point contains values for `plotX` and `plotY` telling
     * where the reference point is in the plot area. Add `chart.plotLeft`
     * and `chart.plotTop` to get the full coordinates.
     *
     * To find the actual hovered `Point` instance, use
     * `this.chart.hoverPoint`. For shared or split tooltips, all the hover
     * points are available in `this.chart.hoverPoints`.
     *
     * Since v7, when [tooltip.split](#tooltip.split) option is enabled,
     * positioner is called for each of the boxes separately, including
     * xAxis header. xAxis header is not a point, instead `point` argument
     * contains info: `{ plotX: Number, plotY: Number, isHeader: Boolean }`
     *
     * Since v12.2, the [tooltip.fixed](#tooltip.fixed) option combined with
     * [tooltip.position](#tooltip.position) covers most of the use cases
     * for custom tooltip positioning.
     *
     * The return should be an object containing x and y values, for example
     * `{ x: 100, y: 100 }`.
     *
     * @sample {highcharts} highcharts/tooltip/positioner/
     *         A fixed tooltip position
     * @sample {highstock} stock/tooltip/positioner/
     *         A fixed tooltip position on top of the chart
     * @sample {highmaps} maps/tooltip/positioner/
     *         A fixed tooltip position
     * @sample {highstock} stock/tooltip/split-positioner/
     *         Split tooltip with fixed positions
     * @sample {highstock} stock/tooltip/positioner-scrollable-plotarea/
     *         Scrollable plot area combined with tooltip positioner
     *
     * @see [position](#tooltip.position)
     *
     * @type      {Highcharts.TooltipPositionerCallbackFunction}
     * @since     2.2.4
     * @apioption tooltip.positioner
     */
    /**
     * Shows tooltip for all points with the same X value. Splits the
     * tooltip into one label per series, with the header close to the axis.
     * This is recommended over [shared](#tooltip.shared)
     * tooltips for charts with multiple line series, generally making them
     * easier to read. This option takes precedence over `tooltip.shared`.
     *
     * Not supported for [polar](#chart.polar) and [inverted](#chart.inverted) charts.
     *
     * @productdesc {highstock} In Highcharts Stock, tooltips are split
     * by default since v6.0.0. Stock charts typically contain
     * multi-dimension points and multiple panes, making split tooltips
     * the preferred layout over
     * the previous `shared` tooltip.
     *
     * @sample highcharts/tooltip/split/
     *         Split tooltip
     * @sample {highcharts|highstock} highcharts/tooltip/formatter-split/
     *         Split tooltip and custom formatter callback
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock} true
     * @since     5.0.0
     * @product   highcharts highstock
     * @apioption tooltip.split
     */
    /**
     * Prevents the tooltip from switching or closing, when touched or
     * pointed.
     *
     * @sample highcharts/tooltip/stickoncontact/
     *         Tooltip sticks on pointer contact
     *
     * @type      {boolean}
     * @since     8.0.1
     * @apioption tooltip.stickOnContact
     */
    /**
     * Use HTML to render the contents of the tooltip instead of SVG. Using
     * HTML allows advanced formatting like tables and images in the
     * tooltip. It is also recommended for rtl languages as it works around
     * rtl bugs in early Firefox.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/footerformat/
     *         A table for value alignment
     * @sample {highcharts|highstock} highcharts/tooltip/fullhtml/
     *         Full HTML tooltip
     * @sample {highmaps} maps/tooltip/usehtml/
     *         Pure HTML tooltip
     *
     * @type      {boolean}
     * @default   false
     * @since     2.2
     * @apioption tooltip.useHTML
     */
    /**
     * How many decimals to show in each series' y value. This is
     * overridable in each series' tooltip options object. The default is to
     * preserve all decimals.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     * @sample {highmaps} maps/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     *
     * @type      {number|undefined}
     * @since     2.2
     * @apioption tooltip.valueDecimals
     */
    /**
     * A string to prepend to each series' y value. Overridable in each
     * series' tooltip options object.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     * @sample {highmaps} maps/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     *
     * @type      {string}
     * @since     2.2
     * @apioption tooltip.valuePrefix
     */
    /**
     * A string to append to each series' y value. Overridable in each
     * series' tooltip options object.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     * @sample {highmaps} maps/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     *
     * @type      {string}
     * @since     2.2
     * @apioption tooltip.valueSuffix
     */
    /**
     * The format for the date in the tooltip header if the X axis is a
     * datetime axis. The default is a best guess based on the smallest
     * distance between points in the chart.
     *
     * @sample {highcharts} highcharts/tooltip/xdateformat/
     *         A different format
     *
     * @type      {string|Highcharts.DateTimeFormatOptions}
     * @product   highcharts highstock gantt
     * @apioption tooltip.xDateFormat
     */
    /**
     * How many decimals to show for the `point.change`
     * or the `point.cumulativeSum` value when the `series.compare`
     * or the `series.cumulative` option is set.
     * This is overridable in each series' tooltip options object.
     *
     * @type      {number}
     * @default   2
     * @since     1.0.1
     * @product   highstock
     * @apioption tooltip.changeDecimals
     */
    /**
     * Enable or disable the tooltip.
     *
     * @sample {highcharts} highcharts/tooltip/enabled/
     *         Disabled
     * @sample {highcharts} highcharts/plotoptions/series-point-events-mouseover/
     *         Disable tooltip and show values on chart instead
     */
    enabled: true,
    /**
     * Enable or disable animation of the tooltip.
     *
     * @type       {boolean|Partial<Highcharts.AnimationOptionsObject>}
     * @since      2.3.0
     */
    animation: {
      duration: 300,
      // EaseOutCirc
      easing: (x) => Math.sqrt(1 - Math.pow(x - 1, 2))
    },
    /**
     * The radius of the rounded border corners.
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         Default border radius
     * @sample {highcharts} highcharts/tooltip/borderradius-0/
     *         Square borders
     * @sample {highmaps} maps/tooltip/background-border/
     *         Background and border demo
     */
    borderRadius: 3,
    /**
     * For series on datetime axes, the date format in the tooltip's
     * header will by default be guessed based on the closest data points.
     * This member gives the default string representations used for
     * each unit. For an overview of the string or object configuration, see
     * [dateFormat](/class-reference/Highcharts.Time#dateFormat).
     *
     * @see [xAxis.dateTimeLabelFormats](#xAxis.dateTimeLabelFormats)
     *
     * @type    {Highcharts.Dictionary<string|Highcharts.DateTimeFormatOptions>}
     * @product highcharts highstock gantt
     */
    dateTimeLabelFormats: {
      /** @internal */
      millisecond: "%[AebHMSL]",
      /** @internal */
      second: "%[AebHMS]",
      /** @internal */
      minute: "%[AebHM]",
      /** @internal */
      hour: "%[AebHM]",
      /** @internal */
      day: "%[AebY]",
      /** @internal */
      week: "%v %[AebY]",
      /** @internal */
      month: "%[BY]",
      /** @internal */
      year: "%Y"
    },
    /**
     * A string to append to the tooltip format.
     *
     * @sample {highcharts} highcharts/tooltip/footerformat/
     *         A table for value alignment
     * @sample {highmaps} maps/tooltip/format/
     *         Format demo
     *
     * @since 2.2
     */
    footerFormat: "",
    /**
     * The name of a symbol to use for the border around the tooltip
     * header. Applies only when [tooltip.split](#tooltip.split) is
     * enabled.
     *
     * Custom callbacks for symbol path generation can also be added to
     * `Highcharts.SVGRenderer.prototype.symbols` the same way as for
     * [series.marker.symbol](plotOptions.line.marker.symbol).
     *
     * @see [tooltip.shape](#tooltip.shape)
     *
     * @sample {highstock} stock/tooltip/split-positioner/
     *         Different shapes for header and split boxes
     *
     * @type       {Highcharts.TooltipShapeValue}
     * @validvalue ["callout", "rect"]
     * @since      7.0
     */
    headerShape: "callout",
    /**
     * The number of milliseconds to wait until the tooltip is hidden when
     * mouse out from a point or chart.
     *
     * @since 3.0
     */
    hideDelay: 500,
    /**
     * Padding inside the tooltip, in pixels.
     *
     * @since 5.0.0
     */
    padding: 8,
    /**
     * Positioning options for fixed tooltip, taking effect only when
     * [tooltip.fixed](#tooltip.fixed) is `true`.
     *
     * @sample {highcharts} highcharts/tooltip/fixed/
     *         Fixed tooltip and position options
     * @sample {highstock} stock/tooltip/fixed/
     *         Stock chart with fixed tooltip
     * @sample {highmaps} maps/tooltip/fixed/
     *         Map with fixed tooltip
     *
     * @since 12.2.0
     */
    position: {
      /**
       * The horizontal alignment of the fixed tooltip.
       *
       * @sample highcharts/tooltip/fixed/
       *         Fixed tooltip
       * @sample {highstock} stock/tooltip/fixed/
       *         Stock chart with fixed tooltip
       *
       * @type {Highcharts.AlignValue}
       * @default left
       * @apioption tooltip.position.align
       */
      /**
       * The vertical alignment of the fixed tooltip.
       *
       * @sample highcharts/tooltip/fixed/
       *         Fixed tooltip
       * @sample {highstock} stock/tooltip/fixed/
       *         Stock chart with fixed tooltip
       *
       * @type {Highcharts.VerticalAlignValue}
       * @default top
       * @apioption tooltip.position.verticalAlign
       */
      /**
       * What the fixed tooltip alignment should be relative to.
       *
       * The default, `pane`, means that it is aligned within the plot
       * area for that given series. If the tooltip is split (as default
       * in Stock charts), each partial tooltip is aligned within the
       * series' pane.
       *
       * @sample highcharts/tooltip/fixed/
       *         Fixed tooltip
       * @sample {highstock} stock/tooltip/fixed/
       *         Stock chart with fixed tooltip
       *
       * @type {string}
       * @default pane
       * @validvalue ["pane", "chart", "plotBox", "spacingBox"]
       * @apioption tooltip.position.relativeTo
       */
      /**
       * X pixel offset from the given position. Can be used to shy away
       * from axis lines, grid lines etc to avoid the tooltip overlapping
       * other elements.
       *
       * @sample highcharts/tooltip/fixed/
       *         Fixed tooltip
       * @sample {highstock} stock/tooltip/fixed/
       *         Stock chart with fixed tooltip
       */
      x: 0,
      /**
       * Y pixel offset from the given position. Can be used to shy away
       * from axis lines, grid lines etc to avoid the tooltip overlapping
       * other elements.
       *
       * @sample highcharts/tooltip/fixed/
       *         Fixed tooltip
       * @sample {highstock} stock/tooltip/fixed/
       *         Stock chart with fixed tooltip
       */
      y: 3
    },
    /**
     * The name of a symbol to use for the border around the tooltip. Can
     * be one of: `"callout"`, `"circle"` or `"rect"`. When
     * [tooltip.split](#tooltip.split)
     * option is enabled, shape is applied to all boxes except header, which
     * is controlled by
     * [tooltip.headerShape](#tooltip.headerShape).
     *
     * Custom callbacks for symbol path generation can also be added to
     * `Highcharts.SVGRenderer.prototype.symbols` the same way as for
     * [series.marker.symbol](plotOptions.line.marker.symbol).
     *
     * Defaults to `callout` for floating tooltip, `rect` for
     * [fixed](#tooltip.fixed) tooltip.
     *
     * @type  {Highcharts.TooltipShapeValue}
     * @since 4.0
     * @default undefined
     * @apioption tooltip.shape
     */
    /**
     * Shows information in the tooltip for all points with the same X
     * value. When the tooltip is shared, the entire plot area will capture
     * mouse movement or touch events. Tooltip texts for series types with
     * ordered data (not pie, scatter, flags etc) will be shown in a single
     * bubble. This is recommended for single series charts and for
     * tablet/mobile optimized charts.
     *
     * See also [tooltip.split](#tooltip.split), that is better suited for
     * charts with many series, especially line-type series. The
     * `tooltip.split` option takes precedence over `tooltip.shared`.
     *
     * @sample {highcharts} highcharts/tooltip/shared-false/
     *         False by default
     * @sample {highcharts} highcharts/tooltip/shared-true/
     *         True
     * @sample {highcharts} highcharts/tooltip/shared-x-crosshair/
     *         True with x axis crosshair
     * @sample {highcharts} highcharts/tooltip/shared-true-mixed-types/
     *         True with mixed series types
     *
     * @since   2.1
     * @product highcharts highstock
     */
    shared: false,
    /**
     * Proximity snap for graphs or single points. It defaults to 10 for
     * mouse-powered devices and 25 for touch devices.
     *
     * Note that in most cases the whole plot area captures the mouse
     * movement, and in these cases `tooltip.snap` doesn't make sense. This
     * applies when [stickyTracking](#plotOptions.series.stickyTracking)
     * is `true` (default) and when the tooltip is [shared](#tooltip.shared)
     * or [split](#tooltip.split).
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         10 px by default
     * @sample {highcharts} highcharts/tooltip/snap-50/
     *         50 px on graph
     *
     * @type    {number}
     * @default 10/25
     * @since   1.2.0
     * @product highcharts highstock
     */
    snap: isTouchDevice$6 ? 25 : 10,
    /**
     * The HTML of the tooltip header line. The context is the
     * [Point class](https://api.highcharts.com/class-reference/Highcharts.Point).
     * Variables are enclosed in curly brackets. Examples of common
     * variables to include are `x`, `y`, `series.name` and `series.color`
     * and other properties on the same form. The `point.key` variable
     * contains the category name, x value or datetime string depending on
     * the type of axis. For datetime axes, the `point.key` date format can
     * be set using `tooltip.xDateFormat`.
     *
     * @sample {highcharts} highcharts/tooltip/footerformat/
     *         An HTML table in the tooltip
     * @sample {highstock} highcharts/tooltip/footerformat/
     *         An HTML table in the tooltip
     * @sample {highmaps} maps/tooltip/format/
     *         Format demo
     *
     * @type      {string}
     * @apioption tooltip.headerFormat
     */
    headerFormat: '<span style="font-size: 0.8em">{ucfirst point.key}</span><br/>',
    /**
     * The HTML of the null point's line in the tooltip. Works analogously
     * to [pointFormat](#tooltip.pointFormat).
     *
     * @sample {highcharts} highcharts/series/null-interaction
     *         Line chart with null interaction
     * @sample {highcharts} highcharts/plotoptions/series-nullformat
     *         Heatmap with null interaction
     *
     * @type      {string}
     * @apioption tooltip.nullFormat
     */
    /**
     * The HTML of the point's line in the tooltip. The context is the
     * [Point class](https://api.highcharts.com/class-reference/Highcharts.Point).
     * Variables are enclosed in curly brackets. Examples of common
     * variables to include are `x`, `y`, `series.name` and `series.color`
     * and other properties on the same form. Furthermore, `y` can be
     * extended by the `tooltip.valuePrefix` and `tooltip.valueSuffix`
     * variables. This can also be overridden for each series, which makes
     * it a good hook for displaying units.
     *
     * In styled mode, the dot is colored by a class name rather than the
     * point color.
     *
     * @sample {highcharts} highcharts/tooltip/pointformat/
     *         A different point format with value suffix
     * @sample {highcharts|highstock} highcharts/tooltip/pointformat-extra-information/
     *         Show extra information about points in the tooltip
     * @sample {highmaps} maps/tooltip/format/
     *         Format demo
     *
     * @type       {string}
     * @since      2.2
     * @apioption  tooltip.pointFormat
     */
    pointFormat: '<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',
    /**
     * The background color or gradient for the tooltip.
     *
     * In styled mode, the stroke width is set in the
     * `.highcharts-tooltip-box` class.
     *
     * @sample {highcharts} highcharts/tooltip/backgroundcolor-solid/
     *         Yellowish background
     * @sample {highcharts} highcharts/tooltip/backgroundcolor-gradient/
     *         Gradient
     * @sample {highcharts} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highstock} stock/tooltip/general/
     *         Custom tooltip
     * @sample {highstock} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highmaps} maps/tooltip/background-border/
     *         Background and border demo
     * @sample {highmaps} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     *
     * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     */
    backgroundColor: "#ffffff",
    /**
     * The pixel width of the tooltip border. Defaults to 0 for single
     * tooltips and fixed tooltips, otherwise 1 for split tooltips.
     *
     * In styled mode, the stroke width is set in the
     * `.highcharts-tooltip-box` class.
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         2 pixels
     * @sample {highcharts} highcharts/tooltip/borderwidth/
     *         No border (shadow only)
     * @sample {highcharts} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highstock} stock/tooltip/general/
     *         Custom tooltip
     * @sample {highstock} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highmaps} maps/tooltip/background-border/
     *         Background and border demo
     * @sample {highmaps} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     *
     * @type {number}
     */
    borderWidth: void 0,
    /**
     * Whether to apply a drop shadow to the tooltip. Defaults to true,
     * unless the tooltip is [fixed](#tooltip.fixed).
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         True by default
     * @sample {highcharts} highcharts/tooltip/shadow/
     *         False
     * @sample {highmaps} maps/tooltip/positioner/
     *         Fixed tooltip position, border and shadow disabled
     *
     * @type {boolean|Highcharts.ShadowOptionsObject}
     * @default undefined
     * @apioption tooltip.shadow
     */
    /**
     * Prevents the tooltip from switching or closing when touched or
     * pointed.
     *
     * @sample highcharts/tooltip/stickoncontact/
     *         Tooltip sticks on pointer contact
     *
     * @since 8.0.1
     */
    stickOnContact: false,
    /**
     * CSS styles for the tooltip. The tooltip can also be styled through
     * the CSS class `.highcharts-tooltip`.
     *
     * Note that the default `pointerEvents` style makes the tooltip ignore
     * mouse events, so in order to use clickable tooltips, this value must
     * be set to `auto`.
     *
     * @sample {highcharts} highcharts/tooltip/style/
     *         Greater padding, bold text
     *
     * @type {Highcharts.CSSObject}
     */
    style: {
      /** @internal */
      color: "#333333",
      /** @internal */
      cursor: "default",
      /**
       * @type {number|string}
       */
      fontSize: "0.8em"
    },
    /**
     * Use HTML to render the contents of the tooltip instead of SVG. Using
     * HTML allows advanced formatting like tables and images in the
     * tooltip. It is also recommended for rtl languages as it works around
     * rtl bugs in early Firefox.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/footerformat/
     *         A table for value alignment
     * @sample {highcharts|highstock} highcharts/tooltip/fullhtml/
     *         Full HTML tooltip
     * @sample {highmaps} maps/tooltip/usehtml/
     *         Pure HTML tooltip
     *
     * @since 2.2
     */
    useHTML: false
  },
  /**
   * Highchart by default puts a credits label in the lower right corner
   * of the chart. This can be changed using these options.
   */
  credits: {
    /**
     * Credits for map source to be concatenated with conventional credit
     * text. By default this is a format string that collects copyright
     * information from the map if available.
     *
     * @see [mapTextFull](#credits.mapTextFull)
     * @see [text](#credits.text)
     *
     * @type      {string}
     * @default   \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>
     * @since     4.2.2
     * @product   highmaps
     * @apioption credits.mapText
     */
    /**
     * Detailed credits for map source to be displayed on hover of credits
     * text. By default this is a format string that collects copyright
     * information from the map if available.
     *
     * @see [mapText](#credits.mapText)
     * @see [text](#credits.text)
     *
     * @type      {string}
     * @default   {geojson.copyright}
     * @since     4.2.2
     * @product   highmaps
     * @apioption credits.mapTextFull
     */
    /**
     * Whether to show the credits text.
     *
     * @sample {highcharts} highcharts/credits/enabled-false/
     *         Credits disabled
     * @sample {highstock} stock/credits/enabled/
     *         Credits disabled
     * @sample {highmaps} maps/credits/enabled-false/
     *         Credits disabled
     */
    enabled: true,
    /**
     * The URL for the credits label.
     *
     * @sample {highcharts} highcharts/credits/href/
     *         Custom URL and text
     * @sample {highmaps} maps/credits/customized/
     *         Custom URL and text
     */
    href: "https://www.highcharts.com?credits",
    /**
     * Position configuration for the credits label.
     *
     * @sample {highcharts} highcharts/credits/position-left/
     *         Left aligned
     * @sample {highcharts} highcharts/credits/position-left/
     *         Left aligned
     * @sample {highmaps} maps/credits/customized/
     *         Left aligned
     * @sample {highmaps} maps/credits/customized/
     *         Left aligned
     *
     * @type    {Highcharts.AlignObject}
     * @since   2.1
     */
    position: {
      /** @internal */
      align: "right",
      /** @internal */
      x: -10,
      /** @internal */
      verticalAlign: "bottom",
      /** @internal */
      y: -5
    },
    /**
     * CSS styles for the credits label.
     *
     * @see In styled mode, credits styles can be set with the
     *      `.highcharts-credits` class.
     *
     * @type {Highcharts.CSSObject}
     */
    style: {
      /** @internal */
      cursor: "pointer",
      /** @internal */
      color: "#999999",
      /**
       * @type {number|string}
       */
      fontSize: "0.6em"
    },
    /**
     * The text for the credits label.
     *
     * @productdesc {highmaps}
     * If a map is loaded as GeoJSON, the text defaults to
     * `Highcharts @ {map-credits}`. Otherwise, it defaults to
     * `Highcharts.com`.
     *
     * @sample {highcharts} highcharts/credits/href/
     *         Custom URL and text
     * @sample {highmaps} maps/credits/customized/
     *         Custom URL and text
     */
    text: "Highcharts.com"
  }
};
const defaultTime$1 = new Time(defaultOptions$n.time, defaultOptions$n.lang);
function getOptions$3() {
  return defaultOptions$n;
}
function setOptions$4(options2) {
  fireEvent$M(Highcharts, "setOptions", { options: options2 });
  merge$1I(true, defaultOptions$n, options2);
  if (options2.time) {
    defaultTime$1.update(defaultOptions$n.time);
  }
  if (options2.lang && "locale" in options2.lang) {
    defaultTime$1.update({
      locale: options2.lang.locale
    });
  }
  if (options2.lang?.chartTitle) {
    defaultOptions$n.title = {
      ...defaultOptions$n.title,
      text: options2.lang.chartTitle
    };
  }
  return defaultOptions$n;
}
const DefaultOptions = {
  defaultOptions: defaultOptions$n,
  defaultTime: defaultTime$1,
  getOptions: getOptions$3,
  setOptions: setOptions$4
};
const { win: win$f } = Highcharts;
const { isNumber: isNumber$1b, isString: isString$j, merge: merge$1H, pInt: pInt$7, defined: defined$1e } = Utilities;
const colorMix = (color1, color2, weight) => `color-mix(in srgb,${color1},${color2} ${weight * 100}%)`;
const isStringColor = (color2) => isString$j(color2) && !!color2 && color2 !== "none";
class Color {
  /* *
   *
   *  Static Functions
   *
   * */
  /**
   * Creates a color instance out of a color string or object.
   *
   * @function Highcharts.Color.parse
   *
   * @param {Highcharts.ColorType} [input]
   * The input color in either rgba or hex format.
   *
   * @return {Highcharts.Color}
   * Color instance.
   */
  static parse(input) {
    return input ? new Color(input) : Color.None;
  }
  /* *
   *
   *  Constructor
   *
   * */
  constructor(input) {
    this.rgba = [NaN, NaN, NaN, NaN];
    this.input = input;
    const GlobalColor = Highcharts.Color;
    if (GlobalColor && GlobalColor !== Color) {
      return new GlobalColor(input);
    }
    let result, rgba, i2, parser;
    if (typeof input === "object" && typeof input.stops !== "undefined") {
      this.stops = input.stops.map((stop2) => new Color(stop2[1]));
    } else if (typeof input === "string") {
      this.input = input = Color.names[input.toLowerCase()] || input;
      i2 = Color.parsers.length;
      while (i2-- && !rgba) {
        parser = Color.parsers[i2];
        result = parser.regex.exec(input);
        if (result) {
          rgba = parser.parse(result);
        }
      }
    }
    if (rgba) {
      this.rgba = rgba;
    }
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Return the color or gradient stops in the specified format
   *
   * @function Highcharts.Color#get
   *
   * @param {string} [format]
   * Possible values are 'a', 'rgb', 'rgba' (default).
   *
   * @return {Highcharts.ColorType}
   * This color as a string or gradient stops.
   */
  get(format2) {
    const input = this.input, rgba = this.rgba;
    if (this.output) {
      return this.output;
    }
    if (typeof input === "object" && typeof this.stops !== "undefined") {
      const ret = merge$1H(input);
      ret.stops = [].slice.call(ret.stops);
      this.stops.forEach((stop2, i2) => {
        ret.stops[i2] = [
          ret.stops[i2][0],
          stop2.get(format2)
        ];
      });
      return ret;
    }
    if (rgba && isNumber$1b(rgba[0])) {
      if (format2 === "rgb" || !format2 && rgba[3] === 1) {
        return "rgb(" + rgba[0] + "," + rgba[1] + "," + rgba[2] + ")";
      }
      if (format2 === "a") {
        return `${rgba[3]}`;
      }
      return "rgba(" + rgba.join(",") + ")";
    }
    return input;
  }
  /**
   * Brighten the color instance.
   *
   * @function Highcharts.Color#brighten
   *
   * @param {number} alpha
   * The alpha value.
   *
   * @return {Highcharts.Color}
   * This color with modifications.
   */
  brighten(alpha) {
    const rgba = this.rgba;
    if (this.stops) {
      this.stops.forEach(function(stop2) {
        stop2.brighten(alpha);
      });
    } else if (isNumber$1b(alpha) && alpha !== 0) {
      if (isNumber$1b(rgba[0])) {
        for (let i2 = 0; i2 < 3; i2++) {
          rgba[i2] += pInt$7(alpha * 255);
          if (rgba[i2] < 0) {
            rgba[i2] = 0;
          }
          if (rgba[i2] > 255) {
            rgba[i2] = 255;
          }
        }
      } else if (Color.useColorMix && isStringColor(this.input)) {
        this.output = colorMix(this.input, alpha > 0 ? "white" : "black", Math.abs(alpha));
      }
    }
    return this;
  }
  /**
   * Set the color's opacity to a given alpha value.
   *
   * @function Highcharts.Color#setOpacity
   *
   * @param {number} alpha
   *        Opacity between 0 and 1.
   *
   * @return {Highcharts.Color}
   *         Color with modifications.
   */
  setOpacity(alpha) {
    this.rgba[3] = alpha;
    return this;
  }
  /**
   * Return an intermediate color between two colors.
   *
   * @function Highcharts.Color#tweenTo
   *
   * @param {Highcharts.Color} to
   * The color object to tween to.
   *
   * @param {number} pos
   * The intermediate position, where 0 is the from color (current color
   * item), and 1 is the `to` color.
   *
   * @return {Highcharts.ColorType}
   * The intermediate color in rgba notation, or unsupported type.
   */
  tweenTo(to, pos) {
    const fromRgba = this.rgba, toRgba = to.rgba;
    if (!isNumber$1b(fromRgba[0]) || !isNumber$1b(toRgba[0])) {
      if (Color.useColorMix && isStringColor(this.input) && isStringColor(to.input) && pos < 0.99) {
        return colorMix(this.input, to.input, pos);
      }
      return to.input || "none";
    }
    const hasAlpha = toRgba[3] !== 1 || fromRgba[3] !== 1, channel = (to2, i2) => to2 + (fromRgba[i2] - to2) * (1 - pos), rgba = toRgba.slice(0, 3).map(channel).map(Math.round);
    if (hasAlpha) {
      rgba.push(channel(toRgba[3], 3));
    }
    return (hasAlpha ? "rgba(" : "rgb(") + rgba.join(",") + ")";
  }
}
Color.names = {
  white: "#ffffff",
  black: "#000000"
};
Color.parsers = [{
  // RGBA color
  // eslint-disable-next-line max-len
  regex: /rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d?(?:\.\d+)?)\s*\)/,
  parse: function(result) {
    return [
      pInt$7(result[1]),
      pInt$7(result[2]),
      pInt$7(result[3]),
      parseFloat(result[4], 10)
    ];
  }
}, {
  // RGB color
  regex: /rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)/,
  parse: function(result) {
    return [pInt$7(result[1]), pInt$7(result[2]), pInt$7(result[3]), 1];
  }
}, {
  // RGBA 3 & 4 digit hex color, e.g. #F0F, #F0FA
  regex: /^#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?$/i,
  parse: function(result) {
    return [
      pInt$7(result[1] + result[1], 16),
      pInt$7(result[2] + result[2], 16),
      pInt$7(result[3] + result[3], 16),
      !defined$1e(result[4]) ? 1 : pInt$7(result[4] + result[4], 16) / 255
    ];
  }
}, {
  // RGBA 6 & 8 digit hex color, e.g. #FFCC00, #FFCC00FF
  regex: /^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?$/i,
  parse: function(result) {
    return [
      pInt$7(result[1], 16),
      pInt$7(result[2], 16),
      pInt$7(result[3], 16),
      !defined$1e(result[4]) ? 1 : pInt$7(result[4], 16) / 255
    ];
  }
}];
Color.useColorMix = win$f.CSS?.supports("color", "color-mix(in srgb,red,blue 9%)");
Color.None = new Color("");
const { parse: color$c } = Color;
const { win: win$e } = Highcharts;
const { isNumber: isNumber$1a, objectEach: objectEach$x } = Utilities;
class Fx {
  /* *
   *
   *  Constructors
   *
   * */
  constructor(elem, options2, prop) {
    this.pos = NaN;
    this.options = options2;
    this.elem = elem;
    this.prop = prop;
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Set the current step of a path definition on SVGElement.
   *
   * @function Highcharts.Fx#dSetter
   *
   */
  dSetter() {
    const paths = this.paths, start2 = paths?.[0], end = paths?.[1], now = this.now || 0;
    let path = [];
    if (now === 1 || !start2 || !end) {
      path = this.toD || [];
    } else if (start2.length === end.length && now < 1) {
      for (let i2 = 0; i2 < end.length; i2++) {
        const startSeg = start2[i2];
        const endSeg = end[i2];
        const tweenSeg = [];
        for (let j = 0; j < endSeg.length; j++) {
          const startItem = startSeg[j];
          const endItem = endSeg[j];
          if (isNumber$1a(startItem) && isNumber$1a(endItem) && // Arc boolean flags
          !(endSeg[0] === "A" && (j === 4 || j === 5))) {
            tweenSeg[j] = startItem + now * (endItem - startItem);
          } else {
            tweenSeg[j] = endItem;
          }
        }
        path.push(tweenSeg);
      }
    } else {
      path = end;
    }
    this.elem.attr("d", path, void 0, true);
  }
  /**
   * Update the element with the current animation step.
   *
   * @function Highcharts.Fx#update
   *
   */
  update() {
    const elem = this.elem, prop = this.prop, now = this.now, step = this.options.step;
    if (this[prop + "Setter"]) {
      this[prop + "Setter"]();
    } else if (elem.attr) {
      if (elem.element) {
        elem.attr(prop, now, null, true);
      }
    } else {
      elem.style[prop] = now + this.unit;
    }
    if (step) {
      step.call(elem, now, this);
    }
  }
  /**
   * Run an animation.
   *
   * @function Highcharts.Fx#run
   *
   * @param {number} from
   *        The current value, value to start from.
   *
   * @param {number} to
   *        The end value, value to land on.
   *
   * @param {string} unit
   *        The property unit, for example `px`.
   *
   */
  run(from, to, unit) {
    const self2 = this, options2 = self2.options, timer = function(gotoEnd) {
      return timer.stopped ? false : self2.step(gotoEnd);
    }, requestAnimationFrame2 = win$e.requestAnimationFrame || function(step2) {
      setTimeout(step2, 13);
    }, step = function() {
      for (let i2 = 0; i2 < Fx.timers.length; i2++) {
        if (!Fx.timers[i2]()) {
          Fx.timers.splice(i2--, 1);
        }
      }
      if (Fx.timers.length) {
        requestAnimationFrame2(step);
      }
    };
    if (from === to && !this.elem["forceAnimate:" + this.prop]) {
      delete options2.curAnim[this.prop];
      if (options2.complete && Object.keys(options2.curAnim).length === 0) {
        options2.complete.call(this.elem);
      }
    } else {
      this.startTime = +/* @__PURE__ */ new Date();
      this.start = from;
      this.end = to;
      this.unit = unit;
      this.now = this.start;
      this.pos = 0;
      timer.elem = this.elem;
      timer.prop = this.prop;
      if (timer() && Fx.timers.push(timer) === 1) {
        requestAnimationFrame2(step);
      }
    }
  }
  /**
   * Run a single step in the animation.
   *
   * @function Highcharts.Fx#step
   *
   * @param {boolean} [gotoEnd]
   *        Whether to go to the endpoint of the animation after abort.
   *
   * @return {boolean}
   *         Returns `true` if animation continues.
   */
  step(gotoEnd) {
    const t = +/* @__PURE__ */ new Date(), options2 = this.options, elem = this.elem, complete = options2.complete, duration = options2.duration, curAnim = options2.curAnim;
    let ret, done;
    if (!!elem.attr && !elem.element) {
      ret = false;
    } else if (gotoEnd || t >= duration + this.startTime) {
      this.now = this.end;
      this.pos = 1;
      this.update();
      curAnim[this.prop] = true;
      done = true;
      objectEach$x(curAnim, function(val) {
        if (val !== true) {
          done = false;
        }
      });
      if (done && complete) {
        complete.call(elem);
      }
      ret = false;
    } else {
      this.pos = options2.easing((t - this.startTime) / duration);
      this.now = this.start + (this.end - this.start) * this.pos;
      this.update();
      ret = true;
    }
    return ret;
  }
  /**
   * Prepare start and end values so that the path can be animated one to one.
   *
   * @function Highcharts.Fx#initPath
   *
   * @param {Highcharts.SVGElement} elem
   *        The SVGElement item.
   *
   * @param {Highcharts.SVGPathArray|undefined} fromD
   *        Starting path definition.
   *
   * @param {Highcharts.SVGPathArray} toD
   *        Ending path definition.
   *
   * @return {Array<Highcharts.SVGPathArray,Highcharts.SVGPathArray>}
   *         An array containing start and end paths in array form so that
   *         they can be animated in parallel.
   */
  initPath(elem, fromD, toD) {
    const startX = elem.startX, endX = elem.endX, end = toD.slice(), isArea = elem.isArea, positionFactor = isArea ? 2 : 1, disableAnimation = fromD && toD.length > fromD.length && toD.hasStackedCliffs;
    let shift, fullLength, i2, reverse, start2 = fromD?.slice();
    if (!start2 || disableAnimation) {
      return [end, end];
    }
    function prepend(arr, other) {
      while (arr.length < fullLength) {
        const moveSegment = arr[0], otherSegment = other[fullLength - arr.length];
        if (otherSegment && moveSegment[0] === "M") {
          if (otherSegment[0] === "C") {
            arr[0] = [
              "C",
              moveSegment[1],
              moveSegment[2],
              moveSegment[1],
              moveSegment[2],
              moveSegment[1],
              moveSegment[2]
            ];
          } else {
            arr[0] = ["L", moveSegment[1], moveSegment[2]];
          }
        }
        arr.unshift(moveSegment);
        if (isArea) {
          const z = arr.pop();
          arr.push(arr[arr.length - 1], z);
        }
      }
    }
    function append(arr) {
      while (arr.length < fullLength) {
        const segmentToAdd = arr[Math.floor(arr.length / positionFactor) - 1].slice();
        if (segmentToAdd[0] === "C") {
          segmentToAdd[1] = segmentToAdd[5];
          segmentToAdd[2] = segmentToAdd[6];
        }
        if (!isArea) {
          arr.push(segmentToAdd);
        } else {
          const lowerSegmentToAdd = arr[Math.floor(arr.length / positionFactor)].slice();
          arr.splice(arr.length / 2, 0, segmentToAdd, lowerSegmentToAdd);
        }
      }
    }
    if (startX && endX && endX.length) {
      for (i2 = 0; i2 < startX.length; i2++) {
        if (startX[i2] === endX[0]) {
          shift = i2;
          break;
        } else if (startX[0] === endX[endX.length - startX.length + i2]) {
          shift = i2;
          reverse = true;
          break;
        } else if (startX[startX.length - 1] === endX[endX.length - startX.length + i2]) {
          shift = startX.length - i2;
          break;
        }
      }
      if (typeof shift === "undefined") {
        start2 = [];
      }
    }
    if (start2.length && isNumber$1a(shift)) {
      fullLength = end.length + shift * positionFactor;
      if (!reverse) {
        prepend(end, start2);
        append(start2);
      } else {
        prepend(start2, end);
        append(end);
      }
    }
    return [start2, end];
  }
  /**
   * Handle animation of the color attributes directly.
   *
   * @function Highcharts.Fx#fillSetter
   *
   */
  fillSetter() {
    Fx.prototype.strokeSetter.apply(this, arguments);
  }
  /**
   * Handle animation of the color attributes directly.
   *
   * @function Highcharts.Fx#strokeSetter
   *
   */
  strokeSetter() {
    this.elem.attr(this.prop, color$c(this.start).tweenTo(color$c(this.end), this.pos), void 0, true);
  }
}
Fx.timers = [];
const { defined: defined$1d, getStyle: getStyle$1, isArray: isArray$r, isNumber: isNumber$19, isObject: isObject$n, merge: merge$1G, objectEach: objectEach$w, pick: pick$1R } = Utilities;
function setAnimation$5(animation, chart) {
  chart.renderer.globalAnimation = pick$1R(animation, chart.options.chart.animation, true);
}
function animObject$g(animation) {
  return isObject$n(animation) ? merge$1G({ duration: 500, defer: 0 }, animation) : { duration: animation ? 500 : 0, defer: 0 };
}
function getDeferredAnimation$3(chart, animation, series) {
  const labelAnimation = animObject$g(animation), s = series ? [series] : chart.series;
  let defer = 0, duration = 0;
  s.forEach((series2) => {
    const seriesAnim = animObject$g(series2.options.animation);
    defer = isObject$n(animation) && defined$1d(animation.defer) ? labelAnimation.defer : Math.max(defer, seriesAnim.duration + seriesAnim.defer);
    duration = Math.min(labelAnimation.duration, seriesAnim.duration);
  });
  if (chart.renderer.forExport) {
    defer = 0;
  }
  const anim = {
    defer: Math.max(0, defer - duration),
    duration: Math.min(defer, duration)
  };
  return anim;
}
function animate$2(el, params2, opt) {
  let start2, unit = "", end, fx, args;
  if (!isObject$n(opt)) {
    args = arguments;
    opt = {
      duration: args[2],
      easing: args[3],
      complete: args[4]
    };
  }
  if (!isNumber$19(opt.duration)) {
    opt.duration = 400;
  }
  opt.easing = typeof opt.easing === "function" ? opt.easing : Math[opt.easing] || Math.easeInOutSine;
  opt.curAnim = merge$1G(params2);
  objectEach$w(params2, function(val, prop) {
    stop$2(el, prop);
    fx = new Fx(el, opt, prop);
    end = void 0;
    if (prop === "d" && isArray$r(params2.d)) {
      fx.paths = fx.initPath(el, el.pathArray, params2.d);
      fx.toD = params2.d;
      start2 = 0;
      end = 1;
    } else if (el.attr) {
      start2 = el.attr(prop);
    } else {
      start2 = parseFloat(getStyle$1(el, prop)) || 0;
      if (prop !== "opacity") {
        unit = "px";
      }
    }
    if (!end) {
      end = val;
    }
    if (typeof end === "string" && end.match("px")) {
      end = end.replace(/px/g, "");
    }
    fx.run(start2, end, unit);
  });
}
function stop$2(el, prop) {
  let i2 = Fx.timers.length;
  while (i2--) {
    if (Fx.timers[i2].elem === el && (!prop || prop === Fx.timers[i2].prop)) {
      Fx.timers[i2].stopped = true;
    }
  }
}
const animationExports = {
  animate: animate$2,
  animObject: animObject$g,
  getDeferredAnimation: getDeferredAnimation$3,
  setAnimation: setAnimation$5,
  stop: stop$2
};
const { SVG_NS: SVG_NS$4, win: win$d } = Highcharts;
const { attr: attr$e, createElement: createElement$d, css: css$f, error: error$9, isFunction: isFunction$5, isString: isString$i, objectEach: objectEach$v, splat: splat$l } = Utilities;
const { trustedTypes } = win$d;
const trustedTypesPolicy = trustedTypes && isFunction$5(trustedTypes.createPolicy) && trustedTypes.createPolicy("highcharts", {
  createHTML: (s) => s
});
const emptyHTML = trustedTypesPolicy ? trustedTypesPolicy.createHTML("") : "";
class AST {
  /* *
   *
   *  Static Functions
   *
   * */
  /**
   * Filter an object of SVG or HTML attributes against the allow list.
   *
   * @static
   *
   * @function Highcharts.AST#filterUserAttributes
   *
   * @param {Highcharts.SVGAttributes} attributes The attributes to filter
   *
   * @return {Highcharts.SVGAttributes}
   * The filtered attributes
   */
  static filterUserAttributes(attributes) {
    objectEach$v(attributes, (val, key2) => {
      let valid = true;
      if (AST.allowedAttributes.indexOf(key2) === -1) {
        valid = false;
      }
      if (["background", "dynsrc", "href", "lowsrc", "src"].indexOf(key2) !== -1) {
        valid = isString$i(val) && AST.allowedReferences.some((ref) => val.indexOf(ref) === 0);
      }
      if (!valid) {
        error$9(33, false, void 0, {
          "Invalid attribute in config": `${key2}`
        });
        delete attributes[key2];
      }
      if (isString$i(val) && attributes[key2]) {
        attributes[key2] = val.replace(/</g, "&lt;");
      }
    });
    return attributes;
  }
  static parseStyle(style) {
    return style.split(";").reduce((styles, line2) => {
      const pair = line2.split(":").map((s) => s.trim()), key2 = pair.shift();
      if (key2 && pair.length) {
        styles[key2.replace(/-([a-z])/g, (g) => g[1].toUpperCase())] = pair.join(":");
      }
      return styles;
    }, {});
  }
  /**
   * Utility function to set html content for an element by passing in a
   * markup string. The markup is safely parsed by the AST class to avoid
   * XSS vulnerabilities. This function should be used instead of setting
   * `innerHTML` in all cases where the content is not fully trusted.
   *
   * @static
   * @function Highcharts.AST#setElementHTML
   *
   * @param {SVGDOMElement|HTMLDOMElement} el
   * Node to set content of.
   *
   * @param {string} html
   * Markup string
   */
  static setElementHTML(el, html2) {
    el.innerHTML = AST.emptyHTML;
    if (html2) {
      const ast = new AST(html2);
      ast.addToDOM(el);
    }
  }
  /* *
   *
   *  Constructor
   *
   * */
  // Construct an AST from HTML markup, or wrap an array of existing AST nodes
  constructor(source) {
    this.nodes = typeof source === "string" ? this.parseMarkup(source) : source;
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Add the tree defined as a hierarchical JS structure to the DOM
   *
   * @function Highcharts.AST#addToDOM
   *
   * @param {Highcharts.HTMLDOMElement|Highcharts.SVGDOMElement} parent
   * The node where it should be added
   *
   * @return {Highcharts.HTMLDOMElement|Highcharts.SVGDOMElement}
   * The inserted node.
   */
  addToDOM(parent) {
    function recurse(subtree, subParent) {
      let ret;
      splat$l(subtree).forEach(function(item) {
        const tagName = item.tagName;
        const textNode = item.textContent ? Highcharts.doc.createTextNode(item.textContent) : void 0;
        const bypassHTMLFiltering = AST.bypassHTMLFiltering;
        let node;
        if (tagName) {
          if (tagName === "#text") {
            node = textNode;
          } else if (AST.allowedTags.indexOf(tagName) !== -1 || bypassHTMLFiltering) {
            const NS = tagName === "svg" ? SVG_NS$4 : subParent.namespaceURI || SVG_NS$4;
            const element = Highcharts.doc.createElementNS(NS, tagName);
            const attributes = item.attributes || {};
            objectEach$v(item, function(val, key2) {
              if (key2 !== "tagName" && key2 !== "attributes" && key2 !== "children" && key2 !== "style" && key2 !== "textContent") {
                attributes[key2] = val;
              }
            });
            attr$e(element, bypassHTMLFiltering ? attributes : AST.filterUserAttributes(attributes));
            if (item.style) {
              css$f(element, item.style);
            }
            if (textNode) {
              element.appendChild(textNode);
            }
            recurse(item.children || [], element);
            node = element;
          } else {
            error$9(33, false, void 0, {
              "Invalid tagName in config": tagName
            });
          }
        }
        if (node) {
          subParent.appendChild(node);
        }
        ret = node;
      });
      return ret;
    }
    return recurse(this.nodes, parent);
  }
  /**
   * Parse HTML/SVG markup into AST Node objects. Used internally from the
   * constructor.
   *
   * @private
   *
   * @function Highcharts.AST#getNodesFromMarkup
   *
   * @param {string} markup The markup string.
   *
   * @return {Array<Highcharts.ASTNode>} The parsed nodes.
   */
  parseMarkup(markup) {
    const nodes = [];
    markup = markup.trim().replace(/ style=(["'])/g, " data-style=$1");
    let doc2;
    try {
      doc2 = new DOMParser().parseFromString(trustedTypesPolicy ? trustedTypesPolicy.createHTML(markup) : markup, "text/html");
    } catch (e) {
    }
    if (!doc2) {
      const body = createElement$d("div");
      body.innerHTML = markup;
      doc2 = { body };
    }
    const appendChildNodes = (node, addTo) => {
      const tagName = node.nodeName.toLowerCase();
      const astNode = {
        tagName
      };
      if (tagName === "#text") {
        astNode.textContent = node.textContent || "";
      }
      const parsedAttributes = node.attributes;
      if (parsedAttributes) {
        const attributes = {};
        [].forEach.call(parsedAttributes, (attrib) => {
          if (attrib.name === "data-style") {
            astNode.style = AST.parseStyle(attrib.value);
          } else {
            attributes[attrib.name] = attrib.value;
          }
        });
        astNode.attributes = attributes;
      }
      if (node.childNodes.length) {
        const children = [];
        [].forEach.call(node.childNodes, (childNode) => {
          appendChildNodes(childNode, children);
        });
        if (children.length) {
          astNode.children = children;
        }
      }
      addTo.push(astNode);
    };
    [].forEach.call(doc2.body.childNodes, (childNode) => appendChildNodes(childNode, nodes));
    return nodes;
  }
}
AST.allowedAttributes = [
  "alt",
  "aria-controls",
  "aria-describedby",
  "aria-expanded",
  "aria-haspopup",
  "aria-hidden",
  "aria-label",
  "aria-labelledby",
  "aria-live",
  "aria-pressed",
  "aria-readonly",
  "aria-roledescription",
  "aria-selected",
  "class",
  "clip-path",
  "color",
  "colspan",
  "cx",
  "cy",
  "d",
  "dx",
  "dy",
  "disabled",
  "fill",
  "filterUnits",
  "flood-color",
  "flood-opacity",
  "height",
  "href",
  "id",
  "in",
  "in2",
  "markerHeight",
  "markerWidth",
  "offset",
  "opacity",
  "operator",
  "orient",
  "padding",
  "paddingLeft",
  "paddingRight",
  "patternUnits",
  "r",
  "radius",
  "refX",
  "refY",
  "role",
  "scope",
  "slope",
  "src",
  "startOffset",
  "stdDeviation",
  "stroke",
  "stroke-linecap",
  "stroke-width",
  "style",
  "tableValues",
  "result",
  "rowspan",
  "summary",
  "target",
  "tabindex",
  "text-align",
  "text-anchor",
  "textAnchor",
  "textLength",
  "title",
  "type",
  "valign",
  "width",
  "x",
  "x1",
  "x2",
  "xlink:href",
  "y",
  "y1",
  "y2",
  "zIndex"
];
AST.allowedReferences = [
  "https://",
  "http://",
  "mailto:",
  "/",
  "../",
  "./",
  "#"
];
AST.allowedTags = [
  "a",
  "abbr",
  "b",
  "br",
  "button",
  "caption",
  "circle",
  "clipPath",
  "code",
  "dd",
  "defs",
  "div",
  "dl",
  "dt",
  "em",
  "feComponentTransfer",
  "feComposite",
  "feDropShadow",
  "feFlood",
  "feFuncA",
  "feFuncB",
  "feFuncG",
  "feFuncR",
  "feGaussianBlur",
  "feMorphology",
  "feOffset",
  "feMerge",
  "feMergeNode",
  "filter",
  "h1",
  "h2",
  "h3",
  "h4",
  "h5",
  "h6",
  "hr",
  "i",
  "img",
  "li",
  "linearGradient",
  "marker",
  "ol",
  "p",
  "path",
  "pattern",
  "pre",
  "rect",
  "small",
  "span",
  "stop",
  "strong",
  "style",
  "sub",
  "sup",
  "svg",
  "table",
  "text",
  "textPath",
  "thead",
  "title",
  "tbody",
  "tspan",
  "td",
  "th",
  "tr",
  "u",
  "ul",
  "#text"
];
AST.emptyHTML = emptyHTML;
AST.bypassHTMLFiltering = false;
const { defaultOptions: defaultOptions$m, defaultTime } = DefaultOptions;
const { pageLang } = Highcharts;
const { extend: extend$1r, getNestedProperty: getNestedProperty$3, isArray: isArray$q, isNumber: isNumber$18, isObject: isObject$m, isString: isString$h, pick: pick$1Q, ucfirst } = Utilities;
const helpers = {
  // Built-in helpers
  add: (a, b) => a + b,
  divide: (a, b) => b !== 0 ? a / b : "",
  // eslint-disable-next-line eqeqeq
  eq: (a, b) => a == b,
  each: function(arr) {
    const match2 = arguments[arguments.length - 1];
    return isArray$q(arr) ? arr.map((item, i2) => format$h(match2.body, extend$1r(isObject$m(item) ? item : { "@this": item }, {
      "@index": i2,
      "@first": i2 === 0,
      "@last": i2 === arr.length - 1
    }))).join("") : false;
  },
  ge: (a, b) => a >= b,
  gt: (a, b) => a > b,
  "if": (condition) => !!condition,
  le: (a, b) => a <= b,
  lt: (a, b) => a < b,
  multiply: (a, b) => a * b,
  // eslint-disable-next-line eqeqeq
  ne: (a, b) => a != b,
  subtract: (a, b) => a - b,
  ucfirst,
  unless: (condition) => !condition
};
const numberFormatCache = {};
const isQuotedString = (str) => /^["'].+["']$/.test(str);
function dateFormat(format2, timestamp, upperCaseFirst) {
  return defaultTime.dateFormat(format2, timestamp, upperCaseFirst);
}
function format$h(str = "", ctx, owner) {
  const regex = /\{([a-zA-Z\u00C0-\u017F\d:\.,;\-\/<>\[\]%_@+"'’= #\(\)]+)\}/g, subRegex = /\(([a-zA-Z\u00C0-\u017F\d:\.,;\-\/<>\[\]%_@+"'= ]+)\)/g, matches = [], floatRegex = /f$/, decRegex = /\.(\d)/, lang2 = owner?.options?.lang || defaultOptions$m.lang, time = owner?.time || defaultTime, numberFormatter = owner?.numberFormatter || numberFormat$2;
  const resolveProperty = (key2 = "") => {
    let n2;
    if (key2 === "true") {
      return true;
    }
    if (key2 === "false") {
      return false;
    }
    if ((n2 = Number(key2)).toString() === key2) {
      return n2;
    }
    if (isQuotedString(key2)) {
      return key2.slice(1, -1);
    }
    return getNestedProperty$3(key2, ctx);
  };
  let match2, currentMatch, depth = 0, hasSub;
  while ((match2 = regex.exec(str)) !== null) {
    const mainMatch = match2, subMatch = subRegex.exec(match2[1]);
    if (subMatch) {
      match2 = subMatch;
      hasSub = true;
    }
    if (!currentMatch?.isBlock) {
      currentMatch = {
        ctx,
        expression: match2[1],
        find: match2[0],
        isBlock: match2[1].charAt(0) === "#",
        start: match2.index,
        startInner: match2.index + match2[0].length,
        length: match2[0].length
      };
    }
    const fn = (currentMatch.isBlock ? mainMatch : match2)[1].split(" ")[0].replace("#", "");
    if (helpers[fn]) {
      if (currentMatch.isBlock && fn === currentMatch.fn) {
        depth++;
      }
      if (!currentMatch.fn) {
        currentMatch.fn = fn;
      }
    }
    const startingElseSection = match2[1] === "else";
    if (currentMatch.isBlock && currentMatch.fn && (match2[1] === `/${currentMatch.fn}` || startingElseSection)) {
      if (!depth) {
        const start2 = currentMatch.startInner, body = str.substr(start2, match2.index - start2);
        if (currentMatch.body === void 0) {
          currentMatch.body = body;
          currentMatch.startInner = match2.index + match2[0].length;
        } else {
          currentMatch.elseBody = body;
        }
        currentMatch.find += body + match2[0];
        if (!startingElseSection) {
          matches.push(currentMatch);
          currentMatch = void 0;
        }
      } else if (!startingElseSection) {
        depth--;
      }
    } else if (!currentMatch.isBlock) {
      matches.push(currentMatch);
    }
    if (subMatch && !currentMatch?.isBlock) {
      break;
    }
  }
  matches.forEach((match3) => {
    const { body, elseBody, expression, fn } = match3;
    let replacement, i2;
    if (fn) {
      const args = [match3], parts = [], len = expression.length;
      let start2 = 0, startChar;
      for (i2 = 0; i2 <= len; i2++) {
        const char = expression.charAt(i2);
        if (!startChar && (char === '"' || char === "'")) {
          startChar = char;
        } else if (startChar === char) {
          startChar = "";
        }
        if (!startChar && (char === " " || i2 === len)) {
          parts.push(expression.substr(start2, i2 - start2));
          start2 = i2 + 1;
        }
      }
      i2 = helpers[fn].length;
      while (i2--) {
        args.unshift(resolveProperty(parts[i2 + 1]));
      }
      replacement = helpers[fn].apply(ctx, args);
      if (match3.isBlock && typeof replacement === "boolean") {
        replacement = format$h(replacement ? body : elseBody, ctx, owner);
      }
    } else {
      const valueAndFormat = isQuotedString(expression) ? [expression] : expression.split(":");
      replacement = resolveProperty(valueAndFormat.shift() || "");
      if (valueAndFormat.length && typeof replacement === "number") {
        const segment = valueAndFormat.join(":");
        if (floatRegex.test(segment)) {
          const decimals = parseInt((segment.match(decRegex) || ["", "-1"])[1], 10);
          if (replacement !== null) {
            replacement = numberFormatter(replacement, decimals, lang2.decimalPoint, segment.indexOf(",") > -1 ? lang2.thousandsSep : "");
          }
        } else {
          replacement = time.dateFormat(segment, replacement);
        }
      }
      subRegex.lastIndex = 0;
      if (subRegex.test(match3.find) && isString$h(replacement)) {
        replacement = `"${replacement}"`;
      }
    }
    str = str.replace(match3.find, pick$1Q(replacement, ""));
  });
  return hasSub ? format$h(str, ctx, owner) : str;
}
function numberFormat$2(number, decimals, decimalPoint, thousandsSep) {
  number = +number || 0;
  decimals = +decimals;
  let ret, fractionDigits, [mantissa, exp] = number.toString().split("e").map(Number);
  const lang2 = this?.options?.lang || defaultOptions$m.lang, origDec = (number.toString().split(".")[1] || "").split("e")[0].length, firstDecimals = decimals, options2 = {};
  decimalPoint ?? (decimalPoint = lang2.decimalPoint);
  thousandsSep ?? (thousandsSep = lang2.thousandsSep);
  if (decimals === -1) {
    decimals = Math.min(origDec, 20);
  } else if (!isNumber$18(decimals)) {
    decimals = 2;
  } else if (decimals && exp < 0) {
    fractionDigits = decimals + exp;
    if (fractionDigits >= 0) {
      mantissa = +mantissa.toExponential(fractionDigits).split("e")[0];
      decimals = fractionDigits;
    } else {
      mantissa = Math.floor(mantissa);
      if (decimals < 20) {
        number = +(mantissa * Math.pow(10, exp)).toFixed(decimals);
      } else {
        number = 0;
      }
      exp = 0;
    }
  }
  if (exp) {
    decimals ?? (decimals = 2);
    number = mantissa;
  }
  if (isNumber$18(decimals) && decimals >= 0) {
    options2.minimumFractionDigits = decimals;
    options2.maximumFractionDigits = decimals;
  }
  if (thousandsSep === "") {
    options2.useGrouping = false;
  }
  const hasSeparators = thousandsSep || decimalPoint, locale = hasSeparators ? "en" : this?.locale || lang2.locale || pageLang, cacheKey = JSON.stringify(options2) + locale, nf = numberFormatCache[cacheKey] ?? (numberFormatCache[cacheKey] = new Intl.NumberFormat(locale, options2));
  ret = nf.format(number);
  if (hasSeparators) {
    ret = ret.replace(/([,\.])/g, "_$1").replace(/_\,/g, thousandsSep ?? ",").replace("_.", decimalPoint ?? ".");
  }
  if (
    // Remove signed zero (#20564)
    !decimals && +ret === 0 || // Small numbers, no decimals (#14023)
    exp < 0 && !firstDecimals
  ) {
    ret = "0";
  }
  if (exp && +ret !== 0) {
    ret += "e" + (exp < 0 ? "" : "+") + exp;
  }
  return ret;
}
const Templating = {
  dateFormat,
  format: format$h,
  helpers,
  numberFormat: numberFormat$2
};
var RendererRegistry;
(function(RendererRegistry2) {
  RendererRegistry2.rendererTypes = {};
  let defaultRenderer;
  function getRendererType2(rendererType = defaultRenderer) {
    return RendererRegistry2.rendererTypes[rendererType] || RendererRegistry2.rendererTypes[defaultRenderer];
  }
  RendererRegistry2.getRendererType = getRendererType2;
  function registerRendererType(rendererType, rendererClass, setAsDefault) {
    RendererRegistry2.rendererTypes[rendererType] = rendererClass;
    if (!defaultRenderer || setAsDefault) {
      defaultRenderer = rendererType;
      Highcharts.Renderer = rendererClass;
    }
  }
  RendererRegistry2.registerRendererType = registerRendererType;
})(RendererRegistry || (RendererRegistry = {}));
const RendererRegistry$1 = RendererRegistry;
const { clamp: clamp$n, pick: pick$1P, pushUnique: pushUnique$A, stableSort: stableSort$7 } = Utilities;
var RendererUtilities;
(function(RendererUtilities2) {
  function distribute2(boxes, len, maxDistance) {
    const origBoxes = boxes, reducedLen = origBoxes.reducedLen || len, sortByRank = (a, b) => (b.rank || 0) - (a.rank || 0), sortByTarget = (a, b) => a.target - b.target, restBoxes = [], boxesLength = boxes.length, forDeletion = [], push = restBoxes.push;
    let i2, cursor, step, overlapping = true, box, target, total = 0, equalRank;
    i2 = boxesLength;
    while (i2--) {
      total += boxes[i2].size;
    }
    if (total > reducedLen) {
      stableSort$7(boxes, sortByRank);
      equalRank = boxes[0].rank === boxes[boxes.length - 1].rank;
      step = equalRank ? boxesLength / 2 : -1;
      cursor = equalRank ? step : boxesLength - 1;
      while (step && total > reducedLen) {
        i2 = Math.floor(cursor);
        box = boxes[i2];
        if (pushUnique$A(forDeletion, i2)) {
          total -= box.size;
        }
        cursor += step;
        if (equalRank && cursor >= boxes.length) {
          step /= 2;
          cursor = step;
        }
      }
      forDeletion.sort((a, b) => b - a).forEach((i3) => push.apply(restBoxes, boxes.splice(i3, 1)));
    }
    stableSort$7(boxes, sortByTarget);
    boxes = boxes.map((box2) => ({
      size: box2.size,
      targets: [box2.target],
      align: pick$1P(box2.align, 0.5)
    }));
    while (overlapping) {
      i2 = boxes.length;
      while (i2--) {
        box = boxes[i2];
        target = (Math.min.apply(0, box.targets) + Math.max.apply(0, box.targets)) / 2;
        box.pos = clamp$n(target - box.size * box.align, 0, len - box.size);
      }
      i2 = boxes.length;
      overlapping = false;
      while (i2--) {
        if (i2 > 0 && boxes[i2 - 1].pos + boxes[i2 - 1].size > boxes[i2].pos) {
          boxes[i2 - 1].size += boxes[i2].size;
          boxes[i2 - 1].targets = boxes[i2 - 1].targets.concat(boxes[i2].targets);
          boxes[i2 - 1].align = 0.5;
          if (boxes[i2 - 1].pos + boxes[i2 - 1].size > len) {
            boxes[i2 - 1].pos = len - boxes[i2 - 1].size;
          }
          boxes.splice(i2, 1);
          overlapping = true;
        }
      }
    }
    push.apply(origBoxes, restBoxes);
    i2 = 0;
    boxes.some((box2) => {
      let posInCompositeBox = 0;
      return (box2.targets || []).some(() => {
        origBoxes[i2].pos = box2.pos + posInCompositeBox;
        if (typeof maxDistance !== "undefined" && Math.abs(origBoxes[i2].pos - origBoxes[i2].target) > maxDistance) {
          origBoxes.slice(0, i2 + 1).forEach((box3) => delete box3.pos);
          origBoxes.reducedLen = (origBoxes.reducedLen || len) - len * 0.1;
          if (origBoxes.reducedLen > len * 0.1) {
            distribute2(origBoxes, len, maxDistance);
          }
          return true;
        }
        posInCompositeBox += origBoxes[i2].size;
        i2++;
        return false;
      });
    });
    stableSort$7(origBoxes, sortByTarget);
    return origBoxes;
  }
  RendererUtilities2.distribute = distribute2;
})(RendererUtilities || (RendererUtilities = {}));
const R$1 = RendererUtilities;
const { animate: animate$1, animObject: animObject$f, stop: stop$1 } = animationExports;
const { deg2rad: deg2rad$a, doc: doc$r, svg: svg$2, SVG_NS: SVG_NS$3, win: win$c, isFirefox: isFirefox$3 } = Highcharts;
const { addEvent: addEvent$1v, attr: attr$d, createElement: createElement$c, crisp: crisp$f, css: css$e, defined: defined$1c, erase: erase$b, extend: extend$1q, fireEvent: fireEvent$L, getAlignFactor: getAlignFactor$a, isArray: isArray$p, isFunction: isFunction$4, isNumber: isNumber$17, isObject: isObject$l, isString: isString$g, merge: merge$1F, objectEach: objectEach$u, pick: pick$1O, pInt: pInt$6, pushUnique: pushUnique$z, replaceNested: replaceNested$2, syncTimeout: syncTimeout$b, uniqueKey: uniqueKey$9 } = Utilities;
let SVGElement$1 = class SVGElement2 {
  // @todo public zIndex?: number;
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Get the current value of an attribute or pseudo attribute,
   * used mainly for animation. Called internally from
   * the {@link Highcharts.SVGRenderer#attr} function.
   *
   * @private
   * @function Highcharts.SVGElement#_defaultGetter
   *
   * @param {string} key
   *        Property key.
   *
   * @return {number|string}
   *         Property value.
   */
  _defaultGetter(key2) {
    let ret = pick$1O(
      this[key2 + "Value"],
      // Align getter
      this[key2],
      this.element ? this.element.getAttribute(key2) : null,
      0
    );
    if (/^-?[\d\.]+$/.test(ret)) {
      ret = parseFloat(ret);
    }
    return ret;
  }
  /**
   * @private
   * @function Highcharts.SVGElement#_defaultSetter
   *
   * @param {string} value
   *
   * @param {string} key
   *
   * @param {Highcharts.SVGDOMElement} element
   *
   */
  _defaultSetter(value, key2, element) {
    element.setAttribute(key2, value);
  }
  /**
   * Add the element to the DOM. All elements must be added this way.
   *
   * @sample highcharts/members/renderer-g
   *         Elements added to a group
   *
   * @function Highcharts.SVGElement#add
   *
   * @param {Highcharts.SVGElement} [parent]
   *        The parent item to add it to. If undefined, the element is added
   *        to the {@link Highcharts.SVGRenderer.box}.
   *
   * @return {Highcharts.SVGElement}
   *         Returns the SVGElement for chaining.
   */
  add(parent) {
    const renderer = this.renderer, element = this.element;
    let inserted;
    if (parent) {
      this.parentGroup = parent;
    }
    if (typeof this.textStr !== "undefined" && this.element.nodeName === "text") {
      renderer.buildText(this);
    }
    this.added = true;
    if (!parent || parent.handleZ || this.zIndex) {
      inserted = this.zIndexSetter();
    }
    if (!inserted) {
      (parent ? parent.element : renderer.box).appendChild(element);
    }
    if (this.onAdd) {
      this.onAdd();
    }
    return this;
  }
  /**
   * Add a class name to an element.
   *
   * @function Highcharts.SVGElement#addClass
   *
   * @param {string} className
   * The new class name to add.
   *
   * @param {boolean} [replace=false]
   * When true, the existing class name(s) will be overwritten with the new
   * one. When false, the new one is added.
   *
   * @return {Highcharts.SVGElement}
   * Return the SVG element for chainability.
   */
  addClass(className, replace) {
    const currentClassName = replace ? "" : this.attr("class") || "";
    className = (className || "").split(/ /g).reduce(function(newClassName, name) {
      if (currentClassName.indexOf(name) === -1) {
        newClassName.push(name);
      }
      return newClassName;
    }, currentClassName ? [currentClassName] : []).join(" ");
    if (className !== currentClassName) {
      this.attr("class", className);
    }
    return this;
  }
  /**
   * This method is executed in the end of `attr()`, after setting all
   * attributes in the hash. In can be used to efficiently consolidate
   * multiple attributes in one SVG property -- e.g., translate, rotate and
   * scale are merged in one "transform" attribute in the SVG node.
   *
   * @private
   * @function Highcharts.SVGElement#afterSetters
   */
  afterSetters() {
    if (this.doTransform) {
      this.updateTransform();
      this.doTransform = false;
    }
  }
  /**
   * Align the element relative to the chart or another box.
   *
   * @function Highcharts.SVGElement#align
   *
   * @param {Highcharts.AlignObject} [alignOptions]
   *        The alignment options. The function can be called without this
   *        parameter in order to re-align an element after the box has been
   *        updated.
   *
   * @param {boolean} [alignByTranslate]
   *        Align element by translation.
   *
   * @param {string|Highcharts.BBoxObject} [alignTo]
   *        The box to align to, needs a width and height. When the box is a
   *        string, it refers to an object in the Renderer. For example, when
   *        box is `spacingBox`, it refers to `Renderer.spacingBox` which
   *        holds `width`, `height`, `x` and `y` properties.
   *
   * @param {boolean} [redraw]
   *        Decide if SVGElement should be redrawn with new alignment or
   *        just change its attributes.
   *
   * @return {Highcharts.SVGElement} Returns the SVGElement for chaining.
   */
  align(alignOptions, alignByTranslate, alignTo, redraw = true) {
    const renderer = this.renderer, alignedObjects = renderer.alignedObjects, initialAlignment = Boolean(alignOptions);
    if (alignOptions) {
      this.alignOptions = alignOptions;
      this.alignByTranslate = alignByTranslate;
      this.alignTo = alignTo;
    } else {
      alignOptions = this.alignOptions || {};
      alignByTranslate = this.alignByTranslate;
      alignTo = this.alignTo;
    }
    const alignToKey = !alignTo || isString$g(alignTo) ? alignTo || "renderer" : void 0;
    if (alignToKey) {
      if (initialAlignment) {
        pushUnique$z(alignedObjects, this);
      }
      alignTo = void 0;
    }
    const alignToBox = pick$1O(alignTo, renderer[alignToKey], renderer), x = (alignToBox.x || 0) + (alignOptions.x || 0) + ((alignToBox.width || 0) - (alignOptions.width || 0)) * getAlignFactor$a(alignOptions.align), y = (alignToBox.y || 0) + (alignOptions.y || 0) + ((alignToBox.height || 0) - (alignOptions.height || 0)) * getAlignFactor$a(alignOptions.verticalAlign), attribs = {
      "text-align": alignOptions?.align
    };
    attribs[alignByTranslate ? "translateX" : "x"] = Math.round(x);
    attribs[alignByTranslate ? "translateY" : "y"] = Math.round(y);
    if (redraw) {
      this[this.placed ? "animate" : "attr"](attribs);
      this.placed = true;
    }
    this.alignAttr = attribs;
    return this;
  }
  /**
   * @private
   * @function Highcharts.SVGElement#alignSetter
   * @param {"left"|"center"|"right"} value
   */
  alignSetter(value) {
    const convert = {
      left: "start",
      center: "middle",
      right: "end"
    };
    if (convert[value]) {
      this.alignValue = value;
      this.element.setAttribute("text-anchor", convert[value]);
    }
  }
  /**
   * Animate to given attributes or CSS properties.
   *
   * @sample highcharts/members/element-on/
   *         Setting some attributes by animation
   *
   * @function Highcharts.SVGElement#animate
   *
   * @param {Highcharts.SVGAttributes} params
   *        SVG attributes or CSS to animate.
   *
   * @param {boolean|Partial<Highcharts.AnimationOptionsObject>} [options]
   *        Animation options.
   *
   * @param {Function} [complete]
   *        Function to perform at the end of animation.
   *
   * @return {Highcharts.SVGElement}
   *         Returns the SVGElement for chaining.
   */
  animate(params2, options2, complete) {
    const animOptions = animObject$f(pick$1O(options2, this.renderer.globalAnimation, true)), deferTime = animOptions.defer;
    if (doc$r.hidden) {
      animOptions.duration = 0;
    }
    if (animOptions.duration !== 0) {
      if (complete) {
        animOptions.complete = complete;
      }
      syncTimeout$b(() => {
        if (this.element) {
          animate$1(this, params2, animOptions);
        }
      }, deferTime);
    } else {
      this.attr(params2, void 0, complete || animOptions.complete);
      objectEach$u(params2, function(val, prop) {
        if (animOptions.step) {
          animOptions.step.call(this, val, { prop, pos: 1, elem: this });
        }
      }, this);
    }
    return this;
  }
  /**
   * Apply a text outline through a custom CSS property, by copying the text
   * element and apply stroke to the copy. Used internally. Contrast checks at
   * [example](https://jsfiddle.net/highcharts/43soe9m1/2/).
   *
   * @example
   * // Specific color
   * text.css({
   *    textOutline: '1px black'
   * });
   * // Automatic contrast
   * text.css({
   *    color: '#000000', // black text
   *    textOutline: '1px contrast' // => white outline
   * });
   *
   * @private
   * @function Highcharts.SVGElement#applyTextOutline
   *
   * @param {string} textOutline
   *        A custom CSS `text-outline` setting, defined by `width color`.
   */
  applyTextOutline(textOutline) {
    const elem = this.element, hasContrast = textOutline.indexOf("contrast") !== -1;
    if (hasContrast) {
      textOutline = textOutline.replace(/contrast/g, this.renderer.getContrast(elem.style.fill));
    }
    const spacePos = textOutline.indexOf(" "), color2 = textOutline.substring(spacePos + 1);
    let strokeWidth = textOutline.substring(0, spacePos);
    if (strokeWidth && strokeWidth !== "none" && Highcharts.svg) {
      this.fakeTS = true;
      strokeWidth = strokeWidth.replace(/(^[\d\.]+)(.*?)$/g, function(match2, digit, unit) {
        return 2 * Number(digit) + unit;
      });
      this.removeTextOutline();
      const outline = doc$r.createElementNS(SVG_NS$3, "tspan");
      attr$d(outline, {
        "class": "highcharts-text-outline",
        fill: color2,
        stroke: color2,
        "stroke-width": strokeWidth,
        "stroke-linejoin": "round"
      });
      const parentElem = elem.querySelector("textPath") || elem;
      [].forEach.call(parentElem.childNodes, (childNode) => {
        const clone2 = childNode.cloneNode(true);
        if (clone2.removeAttribute) {
          ["fill", "stroke", "stroke-width", "stroke"].forEach((prop) => clone2.removeAttribute(prop));
        }
        outline.appendChild(clone2);
      });
      let totalHeight = 0;
      [].forEach.call(parentElem.querySelectorAll("text tspan"), (element) => {
        totalHeight += Number(element.getAttribute("dy"));
      });
      const br = doc$r.createElementNS(SVG_NS$3, "tspan");
      br.textContent = "​";
      attr$d(br, {
        x: Number(elem.getAttribute("x")),
        dy: -totalHeight
      });
      outline.appendChild(br);
      parentElem.insertBefore(outline, parentElem.firstChild);
    }
  }
  /**
   * @function Highcharts.SVGElement#attr
   * @param {string} key
   * @return {number|string}
   */
  /**
  * Apply native and custom attributes to the SVG elements.
  *
  * In order to set the rotation center for rotation, set x and y to 0 and
  * use `translateX` and `translateY` attributes to position the element
  * instead.
  *
  * Attributes frequently used in Highcharts are `fill`, `stroke`,
  * `stroke-width`.
  *
  * @sample highcharts/members/renderer-rect/
  *         Setting some attributes
  *
  * @example
  * // Set multiple attributes
  * element.attr({
  *     stroke: 'red',
  *     fill: 'blue',
  *     x: 10,
  *     y: 10
  * });
  *
  * // Set a single attribute
  * element.attr('stroke', 'red');
  *
  * // Get an attribute
  * element.attr('stroke'); // => 'red'
  *
  * @function Highcharts.SVGElement#attr
  *
  * @param {string|Highcharts.SVGAttributes} [hash]
  *        The native and custom SVG attributes.
  *
  * @param {number|string|Highcharts.SVGPathArray} [val]
  *        If the type of the first argument is `string`, the second can be a
  *        value, which will serve as a single attribute setter. If the first
  *        argument is a string and the second is undefined, the function
  *        serves as a getter and the current value of the property is
  *        returned.
  *
  * @param {Function} [complete]
  *        A callback function to execute after setting the attributes. This
  *        makes the function compliant and interchangeable with the
  *        {@link SVGElement#animate} function.
  *
  * @param {boolean} [continueAnimation=true]
  *        Used internally when `.attr` is called as part of an animation
  *        step. Otherwise, calling `.attr` for an attribute will stop
  *        animation for that attribute.
  *
  * @return {Highcharts.SVGElement}
  *         If used as a setter, it returns the current
  *         {@link Highcharts.SVGElement} so the calls can be chained. If
  *         used as a getter, the current value of the attribute is returned.
  */
  attr(hash2, val, complete, continueAnimation) {
    const { element } = this, symbolCustomAttribs = SVGElement2.symbolCustomAttribs;
    let key2, hasSetSymbolSize, ret = this, skipAttr, setter;
    if (typeof hash2 === "string" && typeof val !== "undefined") {
      key2 = hash2;
      hash2 = {};
      hash2[key2] = val;
    }
    if (typeof hash2 === "string") {
      ret = (this[hash2 + "Getter"] || this._defaultGetter).call(this, hash2, element);
    } else {
      objectEach$u(hash2, function eachAttribute(val2, key3) {
        skipAttr = false;
        if (!continueAnimation) {
          stop$1(this, key3);
        }
        if (this.symbolName && symbolCustomAttribs.indexOf(key3) !== -1) {
          if (!hasSetSymbolSize) {
            this.symbolAttr(hash2);
            hasSetSymbolSize = true;
          }
          skipAttr = true;
        }
        if (this.rotation && (key3 === "x" || key3 === "y")) {
          this.doTransform = true;
        }
        if (!skipAttr) {
          setter = this[key3 + "Setter"] || this._defaultSetter;
          setter.call(this, val2, key3, element);
        }
      }, this);
      this.afterSetters();
    }
    if (complete) {
      complete.call(this);
    }
    return ret;
  }
  /**
   * Apply a clipping shape to this element.
   *
   * @function Highcharts.SVGElement#clip
   *
   * @param {SVGElement} [clipElem]
   *        The clipping shape. If skipped, the current clip is removed.
   *
   * @return {Highcharts.SVGElement}
   *         Returns the SVG element to allow chaining.
   */
  clip(clipElem) {
    if (clipElem && !clipElem.clipPath) {
      const id = uniqueKey$9() + "-", clipPath = this.renderer.createElement("clipPath").attr({ id }).add(this.renderer.defs);
      extend$1q(clipElem, { clipPath, id, count: 0 });
      clipElem.add(clipPath);
    }
    return this.attr("clip-path", clipElem ? `url(${this.renderer.url}#${clipElem.id})` : "none");
  }
  /**
   * Calculate the coordinates needed for drawing a rectangle crisply and
   * return the calculated attributes.
   *
   * @function Highcharts.SVGElement#crisp
   *
   * @param {Highcharts.RectangleObject} rect
   * Rectangle to crisp.
   *
   * @param {number} [strokeWidth]
   * The stroke width to consider when computing crisp positioning. It can
   * also be set directly on the rect parameter.
   *
   * @return {Highcharts.RectangleObject}
   * The modified rectangle arguments.
   */
  crisp(rect2, strokeWidth) {
    strokeWidth = Math.round(strokeWidth || rect2.strokeWidth || 0);
    const x1 = rect2.x || this.x || 0, y1 = rect2.y || this.y || 0, x2 = (rect2.width || this.width || 0) + x1, y2 = (rect2.height || this.height || 0) + y1, x = crisp$f(x1, strokeWidth), y = crisp$f(y1, strokeWidth), x2Crisp = crisp$f(x2, strokeWidth), y2Crisp = crisp$f(y2, strokeWidth);
    extend$1q(rect2, {
      x,
      y,
      width: x2Crisp - x,
      height: y2Crisp - y
    });
    if (defined$1c(rect2.strokeWidth)) {
      rect2.strokeWidth = strokeWidth;
    }
    return rect2;
  }
  /**
   * Build and apply an SVG gradient out of a common JavaScript configuration
   * object. This function is called from the attribute setters. An event
   * hook is added for supporting other complex color types.
   *
   * @private
   * @function Highcharts.SVGElement#complexColor
   *
   * @param {Highcharts.GradientColorObject|Highcharts.PatternObject} colorOptions
   * The gradient or pattern options structure.
   *
   * @param {string} prop
   * The property to apply, can either be `fill` or `stroke`.
   *
   * @param {Highcharts.SVGDOMElement} elem
   * SVG element to apply the gradient on.
   */
  complexColor(colorOptions, prop, elem) {
    const renderer = this.renderer;
    let colorObject, gradName, gradAttr, radAttr, gradients, stops, stopColor, stopOpacity, radialReference, id, key2 = [], value;
    fireEvent$L(this.renderer, "complexColor", {
      args: arguments
    }, function() {
      if (colorOptions.radialGradient) {
        gradName = "radialGradient";
      } else if (colorOptions.linearGradient) {
        gradName = "linearGradient";
      }
      if (gradName) {
        gradAttr = colorOptions[gradName];
        gradients = renderer.gradients;
        stops = colorOptions.stops;
        radialReference = elem.radialReference;
        if (isArray$p(gradAttr)) {
          colorOptions[gradName] = gradAttr = {
            x1: gradAttr[0],
            y1: gradAttr[1],
            x2: gradAttr[2],
            y2: gradAttr[3],
            gradientUnits: "userSpaceOnUse"
          };
        }
        if (gradName === "radialGradient" && radialReference && !defined$1c(gradAttr.gradientUnits)) {
          radAttr = gradAttr;
          gradAttr = merge$1F(gradAttr, renderer.getRadialAttr(radialReference, radAttr), { gradientUnits: "userSpaceOnUse" });
        }
        objectEach$u(gradAttr, function(value2, n2) {
          if (n2 !== "id") {
            key2.push(n2, value2);
          }
        });
        objectEach$u(stops, function(val) {
          key2.push(val);
        });
        key2 = key2.join(",");
        if (gradients[key2]) {
          id = gradients[key2].attr("id");
        } else {
          gradAttr.id = id = uniqueKey$9();
          const gradientObject = gradients[key2] = renderer.createElement(gradName).attr(gradAttr).add(renderer.defs);
          gradientObject.radAttr = radAttr;
          gradientObject.stops = [];
          stops.forEach(function(stop2) {
            if (stop2[1].indexOf("rgba") === 0) {
              colorObject = Color.parse(stop2[1]);
              stopColor = colorObject.get("rgb");
              stopOpacity = colorObject.get("a");
            } else {
              stopColor = stop2[1];
              stopOpacity = 1;
            }
            const stopObject = renderer.createElement("stop").attr({
              offset: stop2[0],
              "stop-color": stopColor,
              "stop-opacity": stopOpacity
            }).add(gradientObject);
            gradientObject.stops.push(stopObject);
          });
        }
        value = "url(" + renderer.url + "#" + id + ")";
        elem.setAttribute(prop, value);
        elem.gradient = key2;
        colorOptions.toString = function() {
          return value;
        };
      }
    });
  }
  /**
   * Set styles for the element. In addition to CSS styles supported by
   * native SVG and HTML elements, there are also some custom made for
   * Highcharts, like `width`, `ellipsis` and `textOverflow` for SVG text
   * elements.
   *
   * @sample highcharts/members/renderer-text-on-chart/
   *         Styled text
   *
   * @function Highcharts.SVGElement#css
   *
   * @param {Highcharts.CSSObject} styles
   *        The new CSS styles.
   *
   * @return {Highcharts.SVGElement}
   *         Return the SVG element for chaining.
   */
  css(styles) {
    const oldStyles = this.styles, newStyles = {}, elem = this.element;
    let textWidth, hasNew = !oldStyles;
    if (oldStyles) {
      objectEach$u(styles, function(value, n2) {
        if (oldStyles && oldStyles[n2] !== value) {
          newStyles[n2] = value;
          hasNew = true;
        }
      });
    }
    if (hasNew) {
      if (oldStyles) {
        styles = extend$1q(oldStyles, newStyles);
      }
      if (styles.width === null || styles.width === "auto") {
        delete this.textWidth;
      } else if (elem.nodeName.toLowerCase() === "text" && styles.width) {
        textWidth = this.textWidth = pInt$6(styles.width);
      }
      extend$1q(this.styles, styles);
      if (textWidth && (!svg$2 && this.renderer.forExport)) {
        delete styles.width;
      }
      const fontSize = isFirefox$3 && styles.fontSize || null;
      if (fontSize && (isNumber$17(fontSize) || /^\d+$/.test(fontSize))) {
        styles.fontSize += "px";
      }
      const stylesToApply = merge$1F(styles);
      if (elem.namespaceURI === this.SVG_NS) {
        ["textOutline", "textOverflow", "whiteSpace", "width"].forEach((key2) => stylesToApply && delete stylesToApply[key2]);
        if (stylesToApply.color) {
          stylesToApply.fill = stylesToApply.color;
          delete stylesToApply.color;
        }
      }
      css$e(elem, stylesToApply);
    }
    if (this.added) {
      if (this.element.nodeName === "text") {
        this.renderer.buildText(this);
      }
      if (styles.textOutline) {
        this.applyTextOutline(styles.textOutline);
      }
    }
    return this;
  }
  /**
   * @private
   * @function Highcharts.SVGElement#dashstyleSetter
   * @param {string} value
   */
  dashstyleSetter(value) {
    let i2, strokeWidth = this["stroke-width"];
    if (strokeWidth === "inherit") {
      strokeWidth = 1;
    }
    if (value) {
      value = value.toLowerCase();
      const v = value.replace("shortdashdotdot", "3,1,1,1,1,1,").replace("shortdashdot", "3,1,1,1").replace("shortdot", "1,1,").replace("shortdash", "3,1,").replace("longdash", "8,3,").replace(/dot/g, "1,3,").replace("dash", "4,3,").replace(/,$/, "").split(",");
      i2 = v.length;
      while (i2--) {
        v[i2] = "" + pInt$6(v[i2]) * pick$1O(strokeWidth, NaN);
      }
      value = v.join(",").replace(/NaN/g, "none");
      this.element.setAttribute("stroke-dasharray", value);
    }
  }
  /**
   * Destroy the element and element wrapper and clear up the DOM and event
   * hooks.
   *
   * @function Highcharts.SVGElement#destroy
   */
  destroy() {
    const wrapper = this, element = wrapper.element || {}, renderer = wrapper.renderer, ownerSVGElement = element.ownerSVGElement;
    let parentToClean = element.nodeName === "SPAN" && wrapper.parentGroup || void 0, grandParent, i2;
    element.onclick = element.onmouseout = element.onmouseover = element.onmousemove = element.point = null;
    stop$1(wrapper);
    if (wrapper.clipPath && ownerSVGElement) {
      const clipPath = wrapper.clipPath;
      [].forEach.call(ownerSVGElement.querySelectorAll("[clip-path],[CLIP-PATH]"), function(el) {
        if (el.getAttribute("clip-path").indexOf(clipPath.element.id) > -1) {
          el.removeAttribute("clip-path");
        }
      });
      wrapper.clipPath = clipPath.destroy();
    }
    if (wrapper.stops) {
      for (i2 = 0; i2 < wrapper.stops.length; i2++) {
        wrapper.stops[i2].destroy();
      }
      wrapper.stops.length = 0;
      wrapper.stops = void 0;
    }
    wrapper.safeRemoveChild(element);
    while (parentToClean?.div && parentToClean.div.childNodes.length === 0) {
      grandParent = parentToClean.parentGroup;
      wrapper.safeRemoveChild(parentToClean.div);
      delete parentToClean.div;
      parentToClean = grandParent;
    }
    if (wrapper.alignOptions) {
      erase$b(renderer.alignedObjects, wrapper);
    }
    objectEach$u(wrapper, (val, key2) => {
      if (
        // Destroy child elements of a group
        wrapper[key2]?.parentGroup === wrapper || // Destroy own elements
        ["connector", "foreignObject"].indexOf(key2) !== -1
      ) {
        wrapper[key2]?.destroy?.();
      }
      delete wrapper[key2];
    });
    return;
  }
  /**
   * @private
   * @function Highcharts.SVGElement#dSettter
   * @param {number|string|Highcharts.SVGPathArray} value
   * @param {string} key
   * @param {Highcharts.SVGDOMElement} element
   */
  dSetter(value, key2, element) {
    if (isArray$p(value)) {
      if (typeof value[0] === "string") {
        value = this.renderer.pathToSegments(value);
      }
      this.pathArray = value;
      value = value.reduce((acc, seg, i2) => {
        if (!seg?.join) {
          return (seg || "").toString();
        }
        return (i2 ? acc + " " : "") + seg.join(" ");
      }, "");
    }
    if (/(NaN| {2}|^$)/.test(value)) {
      value = "M 0 0";
    }
    if (this[key2] !== value) {
      element.setAttribute(key2, value);
      this[key2] = value;
    }
  }
  /**
   * @private
   * @function Highcharts.SVGElement#fillSetter
   * @param {Highcharts.ColorType} value
   * @param {string} key
   * @param {Highcharts.SVGDOMElement} element
   */
  fillSetter(value, key2, element) {
    if (typeof value === "string") {
      element.setAttribute(key2, value);
    } else if (value) {
      this.complexColor(value, key2, element);
    }
  }
  /**
   * @private
   * @function Highcharts.SVGElement#hrefSetter
   * @param {Highcharts.ColorType} value
   * @param {string} key
   * @param {Highcharts.SVGDOMElement} element
   */
  hrefSetter(value, key2, element) {
    element.setAttributeNS("http://www.w3.org/1999/xlink", key2, value);
  }
  /**
   * Get the bounding box (width, height, x and y) for the element. Generally
   * used to get rendered text size. Since this is called a lot in charts,
   * the results are cached based on text properties, in order to save DOM
   * traffic. The returned bounding box includes the rotation, so for example
   * a single text line of rotation 90 will report a greater height, and a
   * width corresponding to the line-height.
   *
   * @sample highcharts/members/renderer-on-chart/
   *         Draw a rectangle based on a text's bounding box
   *
   * @function Highcharts.SVGElement#getBBox
   *
   * @param {boolean} [reload]
   *        Skip the cache and get the updated DOM bounding box.
   *
   * @param {number} [rot]
   *        Override the element's rotation. This is internally used on axis
   *        labels with a value of 0 to find out what the bounding box would
   *        be have been if it were not rotated.
   *
   * @return {Highcharts.BBoxObject}
   *         The bounding box with `x`, `y`, `width` and `height` properties.
   */
  getBBox(reload, rot) {
    const wrapper = this, { alignValue, element, renderer, styles, textStr } = wrapper, { cache: cache2, cacheKeys } = renderer, isSVG = element.namespaceURI === wrapper.SVG_NS, rotation = pick$1O(rot, wrapper.rotation, 0), fontSize = renderer.styledMode ? element && SVGElement2.prototype.getStyle.call(element, "font-size") : styles.fontSize;
    let bBox, height, toggleTextShadowShim, cacheKey;
    if (defined$1c(textStr)) {
      cacheKey = textStr.toString();
      if (cacheKey.indexOf("<") === -1) {
        cacheKey = cacheKey.replace(/\d/g, "0");
      }
      cacheKey += [
        "",
        renderer.rootFontSize,
        fontSize,
        rotation,
        wrapper.textWidth,
        // #7874, also useHTML
        alignValue,
        styles.lineClamp,
        styles.textOverflow,
        // #5968
        styles.fontWeight
        // #12163
      ].join(",");
    }
    if (cacheKey && !reload) {
      bBox = cache2[cacheKey];
    }
    if (!bBox || bBox.polygon) {
      if (isSVG || renderer.forExport) {
        try {
          toggleTextShadowShim = this.fakeTS && function(display) {
            const outline = element.querySelector(".highcharts-text-outline");
            if (outline) {
              css$e(outline, { display });
            }
          };
          if (isFunction$4(toggleTextShadowShim)) {
            toggleTextShadowShim("none");
          }
          bBox = element.getBBox ? (
            // SVG: use extend because IE9 is not allowed to change
            // width and height in case of rotation (below)
            extend$1q({}, element.getBBox())
          ) : {
            // HTML elements with `exporting.allowHTML` and
            // legacy IE in export mode
            width: element.offsetWidth,
            height: element.offsetHeight,
            x: 0,
            y: 0
          };
          if (isFunction$4(toggleTextShadowShim)) {
            toggleTextShadowShim("");
          }
        } catch (e2) {
        }
        if (!bBox || bBox.width < 0) {
          bBox = { x: 0, y: 0, width: 0, height: 0 };
        }
      } else {
        bBox = wrapper.htmlGetBBox();
      }
      height = bBox.height;
      if (isSVG) {
        bBox.height = height = {
          "11px,17": 14,
          "13px,20": 16
        }[`${fontSize || ""},${Math.round(height)}`] || height;
      }
      if (rotation) {
        bBox = this.getRotatedBox(bBox, rotation);
      }
      const e = { bBox };
      fireEvent$L(this, "afterGetBBox", e);
      bBox = e.bBox;
    }
    if (cacheKey && (textStr === "" || bBox.height > 0)) {
      while (cacheKeys.length > 250) {
        delete cache2[cacheKeys.shift()];
      }
      if (!cache2[cacheKey]) {
        cacheKeys.push(cacheKey);
      }
      cache2[cacheKey] = bBox;
    }
    return bBox;
  }
  /**
   * Get the rotated box.
   * @private
   */
  getRotatedBox(box, rotation) {
    const { x: boxX, y: boxY, width, height } = box, { alignValue, translateY, rotationOriginX = 0, rotationOriginY = 0 } = this, alignFactor = getAlignFactor$a(alignValue), baseline = Number(this.element.getAttribute("y") || 0) - (translateY ? 0 : boxY), rad = rotation * deg2rad$a, rad90 = (rotation - 90) * deg2rad$a, cosRad = Math.cos(rad), sinRad = Math.sin(rad), wCosRad = width * cosRad, wSinRad = width * sinRad, cosRad90 = Math.cos(rad90), sinRad90 = Math.sin(rad90), [[xOriginCosRad, xOriginSinRad], [yOriginCosRad, yOriginSinRad]] = [
      rotationOriginX,
      rotationOriginY
    ].map((rotOrigin) => [
      rotOrigin - rotOrigin * cosRad,
      rotOrigin * sinRad
    ]), pX = boxX + alignFactor * (width - wCosRad) + xOriginCosRad + yOriginSinRad, pY = boxY + baseline - alignFactor * wSinRad - xOriginSinRad + yOriginCosRad, aX = pX + baseline * cosRad90, bX = aX + wCosRad, cX = bX - height * cosRad90, dX = cX - wCosRad, aY = pY + baseline * sinRad90, bY = aY + wSinRad, cY = bY - height * sinRad90, dY = cY - wSinRad;
    const x = Math.min(aX, bX, cX, dX), y = Math.min(aY, bY, cY, dY), boxWidth = Math.max(aX, bX, cX, dX) - x, boxHeight = Math.max(aY, bY, cY, dY) - y;
    return {
      x,
      y,
      width: boxWidth,
      height: boxHeight,
      polygon: [
        [aX, aY],
        [bX, bY],
        [cX, cY],
        [dX, dY]
      ]
    };
  }
  /**
   * Get the computed style. Only in styled mode.
   *
   * @example
   * chart.series[0].points[0].graphic.getStyle('stroke-width'); // => '1px'
   *
   * @function Highcharts.SVGElement#getStyle
   *
   * @param {string} prop
   *        The property name to check for.
   *
   * @return {string}
   *         The current computed value.
   */
  getStyle(prop) {
    return win$c.getComputedStyle(this.element || this, "").getPropertyValue(prop);
  }
  /**
   * Check if an element has the given class name.
   *
   * @function Highcharts.SVGElement#hasClass
   *
   * @param {string} className
   * The class name to check for.
   *
   * @return {boolean}
   * Whether the class name is found.
   */
  hasClass(className) {
    return ("" + this.attr("class")).split(" ").indexOf(className) !== -1;
  }
  /**
   * Hide the element, similar to setting the `visibility` attribute to
   * `hidden`.
   *
   * @function Highcharts.SVGElement#hide
   *
   * @return {Highcharts.SVGElement}
   *         Returns the SVGElement for chaining.
   */
  hide() {
    return this.attr({ visibility: "hidden" });
  }
  /**
   * @private
   */
  htmlGetBBox() {
    return { height: 0, width: 0, x: 0, y: 0 };
  }
  /**
   * Initialize the SVG element. This function only exists to make the
   * initialization process overridable. It should not be called directly.
   *
   * @function Highcharts.SVGElement#init
   *
   * @param {Highcharts.SVGRenderer} renderer
   * The SVGRenderer instance to initialize to.
   *
   * @param {string} nodeName
   * The SVG node name.
   */
  constructor(renderer, nodeName) {
    this.onEvents = {};
    this.opacity = 1;
    this.SVG_NS = SVG_NS$3;
    this.element = nodeName === "span" || nodeName === "body" ? createElement$c(nodeName) : doc$r.createElementNS(this.SVG_NS, nodeName);
    this.renderer = renderer;
    this.styles = {};
    fireEvent$L(this, "afterInit");
  }
  /**
   * Add an event listener. This is a simple setter that replaces the
   * previous event of the same type added by this function, as opposed to
   * the {@link Highcharts#addEvent} function.
   *
   * @sample highcharts/members/element-on/
   *         A clickable rectangle
   *
   * @function Highcharts.SVGElement#on
   *
   * @param {string} eventType
   * The event type.
   *
   * @param {Function} handler
   * The handler callback.
   *
   * @return {Highcharts.SVGElement}
   * The SVGElement for chaining.
   */
  on(eventType, handler) {
    const { onEvents } = this;
    if (onEvents[eventType]) {
      onEvents[eventType]();
    }
    onEvents[eventType] = addEvent$1v(this.element, eventType, handler);
    return this;
  }
  /**
   * @private
   * @function Highcharts.SVGElement#opacitySetter
   * @param {string} value
   * @param {string} key
   * @param {Highcharts.SVGDOMElement} element
   */
  opacitySetter(value, key2, element) {
    const opacity = Number(Number(value).toFixed(3));
    this.opacity = opacity;
    element.setAttribute(key2, opacity);
  }
  /**
   * Re-align an aligned text or label after setting the text.
   *
   * @private
   * @function Highcharts.SVGElement#reAlign
   *
   */
  reAlign() {
    if (this.alignOptions?.width && this.alignOptions.align !== "left") {
      this.alignOptions.width = this.getBBox().width;
      this.placed = false;
      this.align();
    }
  }
  /**
   * Remove a class name from the element.
   *
   * @function Highcharts.SVGElement#removeClass
   *
   * @param {string|RegExp} className
   *        The class name to remove.
   *
   * @return {Highcharts.SVGElement} Returns the SVG element for chainability.
   */
  removeClass(className) {
    return this.attr("class", ("" + this.attr("class")).replace(isString$g(className) ? new RegExp(`(^| )${className}( |$)`) : (
      // #12064, #13590
      className
    ), " ").replace(/ +/g, " ").trim());
  }
  /**
   *
   * @private
   */
  removeTextOutline() {
    const outline = this.element.querySelector("tspan.highcharts-text-outline");
    if (outline) {
      this.safeRemoveChild(outline);
    }
  }
  /**
   * Removes an element from the DOM.
   *
   * @private
   * @function Highcharts.SVGElement#safeRemoveChild
   *
   * @param {Highcharts.SVGDOMElement|Highcharts.HTMLDOMElement} element
   * The DOM node to remove.
   */
  safeRemoveChild(element) {
    const parentNode = element.parentNode;
    if (parentNode) {
      parentNode.removeChild(element);
    }
  }
  /**
   * Set the coordinates needed to draw a consistent radial gradient across
   * a shape regardless of positioning inside the chart. Used on pie slices
   * to make all the slices have the same radial reference point.
   *
   * @function Highcharts.SVGElement#setRadialReference
   *
   * @param {Array<number>} coordinates
   * The center reference. The format is `[centerX, centerY, diameter]` in
   * pixels.
   *
   * @return {Highcharts.SVGElement}
   * Returns the SVGElement for chaining.
   */
  setRadialReference(coordinates2) {
    const existingGradient = this.element.gradient && this.renderer.gradients[this.element.gradient] || void 0;
    this.element.radialReference = coordinates2;
    if (existingGradient?.radAttr) {
      existingGradient.animate(this.renderer.getRadialAttr(coordinates2, existingGradient.radAttr));
    }
    return this;
  }
  /**
   * Add a shadow to the element. In styled mode, this method is not used,
   * instead use `defs` and filters.
   *
   * @example
   * renderer.rect(10, 100, 100, 100)
   *     .attr({ fill: 'red' })
   *     .shadow(true);
   *
   * @function Highcharts.SVGElement#shadow
   *
   * @param {boolean|Highcharts.ShadowOptionsObject} [shadowOptions] The
   *        shadow options. If `true`, the default options are applied. If
   *        `false`, the current shadow will be removed.
   *
   * @return {Highcharts.SVGElement} Returns the SVGElement for chaining.
   */
  shadow(shadowOptions) {
    const { renderer } = this, options2 = merge$1F(this.parentGroup?.rotation === 90 ? {
      offsetX: -1,
      offsetY: -1
    } : {}, isObject$l(shadowOptions) ? shadowOptions : {}), id = renderer.shadowDefinition(options2);
    return this.attr({
      filter: shadowOptions ? `url(${renderer.url}#${id})` : "none"
    });
  }
  /**
   * Show the element after it has been hidden.
   *
   * @function Highcharts.SVGElement#show
   *
   * @param {boolean} [inherit=true]
   *        Set the visibility attribute to `inherit` rather than `visible`.
   *        The difference is that an element with `visibility="visible"`
   *        will be visible even if the parent is hidden.
   *
   * @return {Highcharts.SVGElement}
   *         Returns the SVGElement for chaining.
   */
  show(inherit = true) {
    return this.attr({ visibility: inherit ? "inherit" : "visible" });
  }
  /**
   * Set the stroke-width and record it on the SVGElement
   *
   * @private
   * @function Highcharts.SVGElement#strokeSetter
   * @param {number|string|ColorType} value
   * @param {string} key
   * @param {Highcharts.SVGDOMElement} element
   */
  "stroke-widthSetter"(value, key2, element) {
    this[key2] = value;
    element.setAttribute(key2, value);
  }
  /**
   * Get the computed stroke width in pixel values. This is used extensively
   * when drawing shapes to ensure the shapes are rendered crisp and
   * positioned correctly relative to each other. Using
   * `shape-rendering: crispEdges` leaves us less control over positioning,
   * for example when we want to stack columns next to each other, or position
   * things pixel-perfectly within the plot box.
   *
   * The common pattern when placing a shape is:
   * - Create the SVGElement and add it to the DOM. In styled mode, it will
   *   now receive a stroke width from the style sheet. In classic mode we
   *   will add the `stroke-width` attribute.
   * - Read the computed `elem.strokeWidth()`.
   * - Place it based on the stroke width.
   *
   * @function Highcharts.SVGElement#strokeWidth
   *
   * @return {number}
   * The stroke width in pixels. Even if the given stroke width (in CSS or by
   * attributes) is based on `em` or other units, the pixel size is returned.
   */
  strokeWidth() {
    if (!this.renderer.styledMode) {
      return this["stroke-width"] || 0;
    }
    const val = this.getStyle("stroke-width");
    let ret = 0, tempElement;
    if (/px$/.test(val)) {
      ret = pInt$6(val);
    } else if (val !== "") {
      tempElement = doc$r.createElementNS(SVG_NS$3, "rect");
      attr$d(tempElement, {
        width: val,
        "stroke-width": 0
      });
      this.element.parentNode.appendChild(tempElement);
      ret = tempElement.getBBox().width;
      tempElement.parentNode.removeChild(tempElement);
    }
    return ret;
  }
  /**
   * If one of the symbol size affecting parameters are changed,
   * check all the others only once for each call to an element's
   * .attr() method
   *
   * @private
   * @function Highcharts.SVGElement#symbolAttr
   *
   * @param {Highcharts.SVGAttributes} hash
   * The attributes to set.
   */
  symbolAttr(hash2) {
    const wrapper = this;
    SVGElement2.symbolCustomAttribs.forEach(function(key2) {
      wrapper[key2] = pick$1O(hash2[key2], wrapper[key2]);
    });
    wrapper.attr({
      d: wrapper.renderer.symbols[wrapper.symbolName](wrapper.x, wrapper.y, wrapper.width, wrapper.height, wrapper)
    });
  }
  /**
   * @private
   * @function Highcharts.SVGElement#textSetter
   * @param {string} value
   */
  textSetter(value) {
    if (value !== this.textStr) {
      delete this.textPxLength;
      this.textStr = value;
      if (this.added) {
        this.renderer.buildText(this);
      }
      this.reAlign();
    }
  }
  /**
   * @private
   * @function Highcharts.SVGElement#titleSetter
   * @param {string} value
   */
  titleSetter(value) {
    const el = this.element;
    const titleNode = el.getElementsByTagName("title")[0] || doc$r.createElementNS(this.SVG_NS, "title");
    if (el.insertBefore) {
      el.insertBefore(titleNode, el.firstChild);
    } else {
      el.appendChild(titleNode);
    }
    titleNode.textContent = replaceNested$2(
      // Scan #[73]
      pick$1O(value, ""),
      // #3276, #3895
      [/<[^>]*>/g, ""]
    ).replace(/&lt;/g, "<").replace(/&gt;/g, ">");
  }
  /**
   * Bring the element to the front. Alternatively, a new zIndex can be set.
   *
   * @sample highcharts/members/element-tofront/
   *         Click an element to bring it to front
   *
   * @function Highcharts.SVGElement#toFront
   *
   * @return {Highcharts.SVGElement}
   * Returns the SVGElement for chaining.
   */
  toFront() {
    const element = this.element;
    element.parentNode.appendChild(element);
    return this;
  }
  /**
   * Move an object and its children by x and y values.
   *
   * @function Highcharts.SVGElement#translate
   *
   * @param {number} x
   * The x value.
   *
   * @param {number} y
   * The y value.
   *
   * @return {Highcharts.SVGElement}
   * Translated element.
   */
  translate(x, y) {
    return this.attr({
      translateX: x,
      translateY: y
    });
  }
  /**
   * Update the transform attribute based on internal properties. Deals with
   * the custom `translateX`, `translateY`, `rotation`, `scaleX` and `scaleY`
   * attributes and updates the SVG `transform` attribute.
   *
   * @private
   * @function Highcharts.SVGElement#updateTransform
   */
  updateTransform(attrib = "transform") {
    const { element, foreignObject, matrix, padding, rotation = 0, rotationOriginX, rotationOriginY, scaleX, scaleY, text, translateX = 0, translateY = 0 } = this;
    const transform2 = ["translate(" + translateX + "," + translateY + ")"];
    if (defined$1c(matrix)) {
      transform2.push("matrix(" + matrix.join(",") + ")");
    }
    if (rotation) {
      transform2.push("rotate(" + rotation + " " + (rotationOriginX ?? element.getAttribute("x") ?? this.x ?? 0) + " " + (rotationOriginY ?? element.getAttribute("y") ?? this.y ?? 0) + ")");
      if (text?.element.tagName === "SPAN" && !text?.foreignObject) {
        text.attr({
          rotation,
          rotationOriginX: (rotationOriginX || 0) - padding,
          rotationOriginY: (rotationOriginY || 0) - padding
        });
      }
    }
    if (defined$1c(scaleX) || defined$1c(scaleY)) {
      transform2.push("scale(" + pick$1O(scaleX, 1) + " " + pick$1O(scaleY, 1) + ")");
    }
    if (transform2.length && !(text || this).textPath) {
      (foreignObject?.element || element).setAttribute(attrib, transform2.join(" "));
    }
  }
  /**
   * @private
   * @function Highcharts.SVGElement#visibilitySetter
   *
   * @param {string} value
   *
   * @param {string} key
   *
   * @param {Highcharts.SVGDOMElement} element
   *
   */
  visibilitySetter(value, key2, element) {
    if (value === "inherit") {
      element.removeAttribute(key2);
    } else if (this[key2] !== value) {
      element.setAttribute(key2, value);
    }
    this[key2] = value;
  }
  /**
   * @private
   * @function Highcharts.SVGElement#xGetter
   */
  xGetter(key2) {
    if (this.element.nodeName === "circle") {
      if (key2 === "x") {
        key2 = "cx";
      } else if (key2 === "y") {
        key2 = "cy";
      }
    }
    return this._defaultGetter(key2);
  }
  /**
   * @private
   * @function Highcharts.SVGElement#zIndexSetter
   */
  zIndexSetter(value, key2) {
    const renderer = this.renderer, parentGroup = this.parentGroup, parentWrapper = parentGroup || renderer, parentNode = parentWrapper.element || renderer.box, element = this.element, svgParent = parentNode === renderer.box;
    let childNodes, otherElement, otherZIndex, inserted = false, undefinedOtherZIndex, run = this.added, i2;
    if (defined$1c(value)) {
      element.setAttribute("data-z-index", value);
      value = +value;
      if (this[key2] === value) {
        run = false;
      }
    } else if (defined$1c(this[key2])) {
      element.removeAttribute("data-z-index");
    }
    this[key2] = value;
    if (run) {
      value = this.zIndex;
      if (value && parentGroup) {
        parentGroup.handleZ = true;
      }
      childNodes = parentNode.childNodes;
      for (i2 = childNodes.length - 1; i2 >= 0 && !inserted; i2--) {
        otherElement = childNodes[i2];
        otherZIndex = otherElement.getAttribute("data-z-index");
        undefinedOtherZIndex = !defined$1c(otherZIndex);
        if (otherElement !== element) {
          if (
            // Negative zIndex versus no zIndex:
            // On all levels except the highest. If the parent is
            // <svg>, then we don't want to put items before <desc>
            // or <defs>
            value < 0 && undefinedOtherZIndex && !svgParent && !i2
          ) {
            parentNode.insertBefore(element, childNodes[i2]);
            inserted = true;
          } else if (
            // Insert after the first element with a lower zIndex
            pInt$6(otherZIndex) <= value || // If negative zIndex, add this before first undefined
            // zIndex element
            undefinedOtherZIndex && (!defined$1c(value) || value >= 0)
          ) {
            parentNode.insertBefore(element, childNodes[i2 + 1]);
            inserted = true;
          }
        }
      }
      if (!inserted) {
        parentNode.insertBefore(element, childNodes[svgParent ? 3 : 0]);
        inserted = true;
      }
    }
    return inserted;
  }
};
SVGElement$1.symbolCustomAttribs = [
  "anchorX",
  "anchorY",
  "clockwise",
  "end",
  "height",
  "innerR",
  "r",
  "start",
  "width",
  "x",
  "y"
];
SVGElement$1.prototype.strokeSetter = SVGElement$1.prototype.fillSetter;
SVGElement$1.prototype.yGetter = SVGElement$1.prototype.xGetter;
SVGElement$1.prototype.matrixSetter = SVGElement$1.prototype.rotationOriginXSetter = SVGElement$1.prototype.rotationOriginYSetter = SVGElement$1.prototype.rotationSetter = SVGElement$1.prototype.scaleXSetter = SVGElement$1.prototype.scaleYSetter = SVGElement$1.prototype.translateXSetter = SVGElement$1.prototype.translateYSetter = SVGElement$1.prototype.verticalAlignSetter = function(value, key2) {
  this[key2] = value;
  this.doTransform = true;
};
const { defined: defined$1b, extend: extend$1p, getAlignFactor: getAlignFactor$9, isNumber: isNumber$16, merge: merge$1E, pick: pick$1N, removeEvent: removeEvent$c } = Utilities;
class SVGLabel extends SVGElement$1 {
  /* *
   *
   *  Constructor
   *
   * */
  constructor(renderer, str, x, y, shape, anchorX, anchorY, useHTML, baseline, className) {
    super(renderer, "g");
    this.paddingLeftSetter = this.paddingSetter;
    this.paddingRightSetter = this.paddingSetter;
    this.doUpdate = false;
    this.textStr = str;
    this.x = x;
    this.y = y;
    this.anchorX = anchorX;
    this.anchorY = anchorY;
    this.baseline = baseline;
    this.className = className;
    this.addClass(className === "button" ? "highcharts-no-tooltip" : "highcharts-label");
    if (className) {
      this.addClass("highcharts-" + className);
    }
    this.text = renderer.text(void 0, 0, 0, useHTML).attr({ zIndex: 1 });
    let hasBGImage;
    if (typeof shape === "string") {
      hasBGImage = /^url\((.*?)\)$/.test(shape);
      if (hasBGImage || this.renderer.symbols[shape]) {
        this.symbolKey = shape;
      }
    }
    this.bBox = SVGLabel.emptyBBox;
    this.padding = 3;
    this.baselineOffset = 0;
    this.needsBox = renderer.styledMode || hasBGImage;
    this.deferredAttr = {};
    this.alignFactor = 0;
  }
  /* *
   *
   *  Functions
   *
   * */
  alignSetter(value) {
    const alignFactor = getAlignFactor$9(value);
    this.textAlign = value;
    if (alignFactor !== this.alignFactor) {
      this.alignFactor = alignFactor;
      if (this.bBox && isNumber$16(this.xSetting)) {
        this.attr({ x: this.xSetting });
      }
    }
  }
  anchorXSetter(value, key2) {
    this.anchorX = value;
    this.boxAttr(key2, Math.round(value) - this.getCrispAdjust() - this.xSetting);
  }
  anchorYSetter(value, key2) {
    this.anchorY = value;
    this.boxAttr(key2, value - this.ySetting);
  }
  /*
   * Set a box attribute, or defer it if the box is not yet created
   */
  boxAttr(key2, value) {
    if (this.box) {
      this.box.attr(key2, value);
    } else {
      this.deferredAttr[key2] = value;
    }
  }
  /*
   * Pick up some properties and apply them to the text instead of the
   * wrapper.
   */
  css(styles) {
    if (styles) {
      const textStyles = {};
      styles = merge$1E(styles);
      SVGLabel.textProps.forEach((prop) => {
        if (typeof styles[prop] !== "undefined") {
          textStyles[prop] = styles[prop];
          delete styles[prop];
        }
      });
      this.text.css(textStyles);
      if ("fontSize" in textStyles || "fontWeight" in textStyles) {
        this.updateTextPadding();
      } else if ("width" in textStyles || "textOverflow" in textStyles) {
        this.updateBoxSize();
      }
    }
    return SVGElement$1.prototype.css.call(this, styles);
  }
  /*
   * Destroy and release memory.
   */
  destroy() {
    removeEvent$c(this.element, "mouseenter");
    removeEvent$c(this.element, "mouseleave");
    if (this.text) {
      this.text.destroy();
    }
    if (this.box) {
      this.box = this.box.destroy();
    }
    SVGElement$1.prototype.destroy.call(this);
    return void 0;
  }
  fillSetter(value, key2) {
    if (value) {
      this.needsBox = true;
    }
    this.fill = value;
    this.boxAttr(key2, value);
  }
  /*
   * Return the bounding box of the box, not the group.
   */
  getBBox(reload, rot) {
    if (this.textStr && this.bBox.width === 0 && this.bBox.height === 0) {
      this.updateBoxSize();
    }
    const { padding, height = 0, translateX = 0, translateY = 0, width = 0 } = this, paddingLeft = pick$1N(this.paddingLeft, padding), rotation = rot ?? (this.rotation || 0);
    let bBox = {
      width,
      height,
      x: translateX + this.bBox.x - paddingLeft,
      y: translateY + this.bBox.y - padding + this.baselineOffset
    };
    if (rotation) {
      bBox = this.getRotatedBox(bBox, rotation);
    }
    return bBox;
  }
  getCrispAdjust() {
    return (this.renderer.styledMode && this.box ? this.box.strokeWidth() : this["stroke-width"] ? parseInt(this["stroke-width"], 10) : 0) % 2 / 2;
  }
  heightSetter(value) {
    this.heightSetting = value;
    this.doUpdate = true;
  }
  /**
   * This method is executed in the end of `attr()`, after setting all
   * attributes in the hash. In can be used to efficiently consolidate
   * multiple attributes in one SVG property -- e.g., translate, rotate and
   * scale are merged in one "transform" attribute in the SVG node.
   * Also updating height or width should trigger update of the box size.
   *
   * @private
   * @function Highcharts.SVGLabel#afterSetters
   */
  afterSetters() {
    super.afterSetters();
    if (this.doUpdate) {
      this.updateBoxSize();
      this.doUpdate = false;
    }
  }
  /*
   * After the text element is added, get the desired size of the border
   * box and add it before the text in the DOM.
   */
  onAdd() {
    this.text.add(this);
    this.attr({
      // Alignment is available now  (#3295, 0 not rendered if given
      // as a value)
      text: pick$1N(this.textStr, ""),
      x: this.x || 0,
      y: this.y || 0
    });
    if (this.box && defined$1b(this.anchorX)) {
      this.attr({
        anchorX: this.anchorX,
        anchorY: this.anchorY
      });
    }
  }
  paddingSetter(value, key2) {
    if (!isNumber$16(value)) {
      this[key2] = void 0;
    } else if (value !== this[key2]) {
      this[key2] = value;
      this.updateTextPadding();
    }
  }
  rSetter(value, key2) {
    this.boxAttr(key2, value);
  }
  strokeSetter(value, key2) {
    this.stroke = value;
    this.boxAttr(key2, value);
  }
  "stroke-widthSetter"(value, key2) {
    if (value) {
      this.needsBox = true;
    }
    this["stroke-width"] = value;
    this.boxAttr(key2, value);
  }
  "text-alignSetter"(value) {
    this.textAlign = this["text-align"] = value;
    this.updateTextPadding();
  }
  textSetter(text) {
    if (typeof text !== "undefined") {
      this.text.attr({ text });
    }
    this.updateTextPadding();
    this.reAlign();
  }
  /*
   * This function runs after the label is added to the DOM (when the bounding
   * box is available), and after the text of the label is updated to detect
   * the new bounding box and reflect it in the border box.
   */
  updateBoxSize() {
    const text = this.text, attribs = {}, padding = this.padding, bBox = this.bBox = (!isNumber$16(this.widthSetting) || !isNumber$16(this.heightSetting) || this.textAlign) && defined$1b(text.textStr) ? text.getBBox(void 0, 0) : SVGLabel.emptyBBox;
    let crispAdjust;
    this.width = this.getPaddedWidth();
    this.height = (this.heightSetting || bBox.height || 0) + 2 * padding;
    const metrics = this.renderer.fontMetrics(text);
    this.baselineOffset = padding + Math.min(
      // When applicable, use the font size of the first line (#15707)
      (this.text.firstLineMetrics || metrics).b,
      // When the height is 0, there is no bBox, so go with the font
      // metrics. Highmaps CSS demos.
      bBox.height || Infinity
    );
    if (this.heightSetting) {
      this.baselineOffset += (this.heightSetting - metrics.h) / 2;
    }
    if (this.needsBox && !text.textPath) {
      if (!this.box) {
        const box = this.box = this.symbolKey ? this.renderer.symbol(this.symbolKey) : this.renderer.rect();
        box.addClass(
          // Don't use label className for buttons
          (this.className === "button" ? "" : "highcharts-label-box") + (this.className ? " highcharts-" + this.className + "-box" : "")
        );
        box.add(this);
      }
      crispAdjust = this.getCrispAdjust();
      attribs.x = crispAdjust;
      attribs.y = (this.baseline ? -this.baselineOffset : 0) + crispAdjust;
      attribs.width = Math.round(this.width);
      attribs.height = Math.round(this.height);
      this.box.attr(extend$1p(attribs, this.deferredAttr));
      this.deferredAttr = {};
    }
  }
  /*
   * This function runs after setting text or padding, but only if padding
   * is changed.
   */
  updateTextPadding() {
    const text = this.text, textAlign = text.styles.textAlign || this.textAlign;
    if (!text.textPath) {
      this.updateBoxSize();
      const textY = this.baseline ? 0 : this.baselineOffset, textX = (this.paddingLeft ?? this.padding) + // Compensate for alignment
      getAlignFactor$9(textAlign) * (this.widthSetting ?? this.bBox.width);
      if (textX !== text.x || textY !== text.y) {
        text.attr({
          align: textAlign,
          x: textX
        });
        if (typeof textY !== "undefined") {
          text.attr("y", textY);
        }
      }
      text.x = textX;
      text.y = textY;
    }
  }
  widthSetter(value) {
    this.widthSetting = isNumber$16(value) ? value : void 0;
    this.doUpdate = true;
  }
  getPaddedWidth() {
    const padding = this.padding;
    const paddingLeft = pick$1N(this.paddingLeft, padding);
    const paddingRight = pick$1N(this.paddingRight, padding);
    return (this.widthSetting || this.bBox.width || 0) + paddingLeft + paddingRight;
  }
  xSetter(value) {
    this.x = value;
    if (this.alignFactor) {
      value -= this.alignFactor * this.getPaddedWidth();
      this["forceAnimate:x"] = true;
    }
    this.xSetting = Math.round(value);
    this.attr("translateX", this.xSetting);
  }
  ySetter(value) {
    this.ySetting = this.y = Math.round(value);
    this.attr("translateY", this.ySetting);
  }
}
SVGLabel.emptyBBox = {
  width: 0,
  height: 0,
  x: 0,
  y: 0
};
SVGLabel.textProps = [
  "color",
  "direction",
  "fontFamily",
  "fontSize",
  "fontStyle",
  "fontWeight",
  "lineClamp",
  "lineHeight",
  "textAlign",
  "textDecoration",
  "textOutline",
  "textOverflow",
  "whiteSpace",
  "width"
];
const { defined: defined$1a, isNumber: isNumber$15, pick: pick$1M } = Utilities;
function arc$1(cx, cy, w, h, options2) {
  const arc2 = [];
  if (options2) {
    let start2 = options2.start || 0, end = options2.end || 0;
    const rx = pick$1M(options2.r, w), ry = pick$1M(options2.r, h || w), proximity = 2e-4 / (options2.borderRadius ? 1 : Math.max(rx, 1)), fullCircle = Math.abs(end - start2 - 2 * Math.PI) < proximity;
    if (fullCircle) {
      start2 = Math.PI / 2;
      end = Math.PI * 2.5 - proximity;
    }
    const innerRadius = options2.innerR, open2 = pick$1M(options2.open, fullCircle), cosStart = Math.cos(start2), sinStart = Math.sin(start2), cosEnd = Math.cos(end), sinEnd = Math.sin(end), longArc = pick$1M(options2.longArc, end - start2 - Math.PI < proximity ? 0 : 1);
    let arcSegment = [
      "A",
      // ArcTo
      rx,
      // X radius
      ry,
      // Y radius
      0,
      // Slanting
      longArc,
      // Long or short arc
      pick$1M(options2.clockwise, 1),
      // Clockwise
      cx + rx * cosEnd,
      cy + ry * sinEnd
    ];
    arcSegment.params = { start: start2, end, cx, cy };
    arc2.push([
      "M",
      cx + rx * cosStart,
      cy + ry * sinStart
    ], arcSegment);
    if (defined$1a(innerRadius)) {
      arcSegment = [
        "A",
        // ArcTo
        innerRadius,
        // X radius
        innerRadius,
        // Y radius
        0,
        // Slanting
        longArc,
        // Long or short arc
        // Clockwise - opposite to the outer arc clockwise
        defined$1a(options2.clockwise) ? 1 - options2.clockwise : 0,
        cx + innerRadius * cosStart,
        cy + innerRadius * sinStart
      ];
      arcSegment.params = {
        start: end,
        end: start2,
        cx,
        cy
      };
      arc2.push(open2 ? [
        "M",
        cx + innerRadius * cosEnd,
        cy + innerRadius * sinEnd
      ] : [
        "L",
        cx + innerRadius * cosEnd,
        cy + innerRadius * sinEnd
      ], arcSegment);
    }
    if (!open2) {
      arc2.push(["Z"]);
    }
  }
  return arc2;
}
function callout(x, y, w, h, options2) {
  const arrowLength = 6, halfDistance = 6, r = Math.min(options2?.r || 0, w, h), safeDistance = r + halfDistance, anchorX = options2?.anchorX, anchorY = options2?.anchorY || 0;
  const path = roundedRect$1(x, y, w, h, { r });
  if (!isNumber$15(anchorX)) {
    return path;
  }
  if (anchorX < w && anchorX > 0 && anchorY < h && anchorY > 0) {
    return path;
  }
  if (x + anchorX > w - safeDistance) {
    if (anchorY > y + safeDistance && anchorY < y + h - safeDistance) {
      path.splice(3, 1, ["L", x + w, anchorY - halfDistance], ["L", x + w + arrowLength, anchorY], ["L", x + w, anchorY + halfDistance], ["L", x + w, y + h - r]);
    } else {
      if (anchorX < w) {
        const isTopCorner = anchorY < y + safeDistance, cornerY = isTopCorner ? y : y + h, sliceStart = isTopCorner ? 2 : 5;
        path.splice(sliceStart, 0, ["L", anchorX, anchorY], ["L", x + w - r, cornerY]);
      } else {
        path.splice(3, 1, ["L", x + w, h / 2], ["L", anchorX, anchorY], ["L", x + w, h / 2], ["L", x + w, y + h - r]);
      }
    }
  } else if (x + anchorX < safeDistance) {
    if (anchorY > y + safeDistance && anchorY < y + h - safeDistance) {
      path.splice(7, 1, ["L", x, anchorY + halfDistance], ["L", x - arrowLength, anchorY], ["L", x, anchorY - halfDistance], ["L", x, y + r]);
    } else {
      if (anchorX > 0) {
        const isTopCorner = anchorY < y + safeDistance, cornerY = isTopCorner ? y : y + h, sliceStart = isTopCorner ? 1 : 6;
        path.splice(sliceStart, 0, ["L", anchorX, anchorY], ["L", x + r, cornerY]);
      } else {
        path.splice(7, 1, ["L", x, h / 2], ["L", anchorX, anchorY], ["L", x, h / 2], ["L", x, y + r]);
      }
    }
  } else if (
    // Replace bottom
    anchorY > h && anchorX < w - safeDistance
  ) {
    path.splice(5, 1, ["L", anchorX + halfDistance, y + h], ["L", anchorX, y + h + arrowLength], ["L", anchorX - halfDistance, y + h], ["L", x + r, y + h]);
  } else if (
    // Replace top
    anchorY < 0 && anchorX > safeDistance
  ) {
    path.splice(1, 1, ["L", anchorX - halfDistance, y], ["L", anchorX, y - arrowLength], ["L", anchorX + halfDistance, y], ["L", w - r, y]);
  }
  return path;
}
function circle(x, y, w, h) {
  return arc$1(x + w / 2, y + h / 2, w / 2, h / 2, {
    start: Math.PI * 0.5,
    end: Math.PI * 2.5,
    open: false
  });
}
function diamond(x, y, w, h) {
  return [
    ["M", x + w / 2, y],
    ["L", x + w, y + h / 2],
    ["L", x + w / 2, y + h],
    ["L", x, y + h / 2],
    ["Z"]
  ];
}
function rect(x, y, w, h, options2) {
  if (options2?.r) {
    return roundedRect$1(x, y, w, h, options2);
  }
  return [
    ["M", x, y],
    ["L", x + w, y],
    ["L", x + w, y + h],
    ["L", x, y + h],
    ["Z"]
  ];
}
function roundedRect$1(x, y, w, h, options2) {
  const r = options2?.r || 0;
  return [
    ["M", x + r, y],
    ["L", x + w - r, y],
    // Top side
    ["A", r, r, 0, 0, 1, x + w, y + r],
    // Top-right corner
    ["L", x + w, y + h - r],
    // Right side
    ["A", r, r, 0, 0, 1, x + w - r, y + h],
    // Bottom-right corner
    ["L", x + r, y + h],
    // Bottom side
    ["A", r, r, 0, 0, 1, x, y + h - r],
    // Bottom-left corner
    ["L", x, y + r],
    // Left side
    ["A", r, r, 0, 0, 1, x + r, y],
    ["Z"]
    // Top-left corner
  ];
}
function triangle(x, y, w, h) {
  return [
    ["M", x + w / 2, y],
    ["L", x + w, y + h],
    ["L", x, y + h],
    ["Z"]
  ];
}
function triangleDown(x, y, w, h) {
  return [
    ["M", x, y],
    ["L", x + w, y],
    ["L", x + w / 2, y + h],
    ["Z"]
  ];
}
const Symbols = {
  arc: arc$1,
  callout,
  circle,
  diamond,
  rect,
  roundedRect: roundedRect$1,
  square: rect,
  triangle,
  "triangle-down": triangleDown
};
const { doc: doc$q, SVG_NS: SVG_NS$2, win: win$b } = Highcharts;
const { attr: attr$c, extend: extend$1o, fireEvent: fireEvent$K, isString: isString$f, objectEach: objectEach$t, pick: pick$1L } = Utilities;
const stringWithEllipsis = (text, currentIndex) => text.substring(0, currentIndex) + "…";
class TextBuilder {
  constructor(svgElement) {
    const textStyles = svgElement.styles;
    this.renderer = svgElement.renderer;
    this.svgElement = svgElement;
    this.width = svgElement.textWidth;
    this.textLineHeight = textStyles?.lineHeight;
    this.textOutline = textStyles?.textOutline;
    this.ellipsis = Boolean(textStyles?.textOverflow === "ellipsis");
    this.lineClamp = textStyles?.lineClamp;
    this.noWrap = Boolean(textStyles?.whiteSpace === "nowrap");
  }
  /**
   * Build an SVG representation of the pseudo HTML given in the object's
   * svgElement.
   *
   * @private
   *
   * @return {void}.
   */
  buildSVG() {
    const wrapper = this.svgElement, textNode = wrapper.element, renderer = wrapper.renderer, textStr = pick$1L(wrapper.textStr, "").toString(), hasMarkup = textStr.indexOf("<") !== -1, childNodes = textNode.childNodes, tempParent = !wrapper.added && renderer.box, regexMatchBreaks = /<br.*?>/g, textCache = [
      textStr,
      this.ellipsis,
      this.noWrap,
      this.textLineHeight,
      this.textOutline,
      wrapper.getStyle("font-size"),
      wrapper.styles.lineClamp,
      this.width
    ].join(",");
    if (textCache === wrapper.textCache) {
      return;
    }
    wrapper.textCache = textCache;
    delete wrapper.actualWidth;
    for (let i2 = childNodes.length; i2--; ) {
      textNode.removeChild(childNodes[i2]);
    }
    if (!hasMarkup && !this.ellipsis && !this.width && !wrapper.textPath && (textStr.indexOf(" ") === -1 || this.noWrap && !regexMatchBreaks.test(textStr))) {
      textNode.appendChild(doc$q.createTextNode(this.unescapeEntities(textStr)));
    } else if (textStr !== "") {
      if (tempParent) {
        tempParent.appendChild(textNode);
      }
      const ast = new AST(textStr);
      this.modifyTree(ast.nodes);
      ast.addToDOM(textNode);
      this.modifyDOM();
      if (this.ellipsis && (textNode.textContent || "").indexOf("…") !== -1) {
        wrapper.attr(
          "title",
          this.unescapeEntities(wrapper.textStr || "", ["&lt;", "&gt;"])
          // #7179
        );
      }
      if (tempParent) {
        tempParent.removeChild(textNode);
      }
    }
    if (isString$f(this.textOutline) && wrapper.applyTextOutline) {
      wrapper.applyTextOutline(this.textOutline);
    }
  }
  /**
   * Modify the DOM of the generated SVG structure. This function only does
   * operations that cannot be done until the elements are attached to the
   * DOM, like doing layout based on rendered metrics of the added elements.
   *
   * @private
   *
   */
  modifyDOM() {
    const wrapper = this.svgElement;
    const x = attr$c(wrapper.element, "x");
    wrapper.firstLineMetrics = void 0;
    let firstChild;
    while (firstChild = wrapper.element.firstChild) {
      if (/^[\s\u200B]*$/.test(firstChild.textContent || " ")) {
        wrapper.element.removeChild(firstChild);
      } else {
        break;
      }
    }
    [].forEach.call(wrapper.element.querySelectorAll("tspan.highcharts-br"), (br, i2) => {
      if (br.nextSibling && br.previousSibling) {
        if (i2 === 0 && br.previousSibling.nodeType === 1) {
          wrapper.firstLineMetrics = wrapper.renderer.fontMetrics(br.previousSibling);
        }
        attr$c(br, {
          // Since the break is inserted in front of the next
          // line, we need to use the next sibling for the line
          // height
          dy: this.getLineHeight(br.nextSibling),
          x
        });
      }
    });
    const width = this.width || 0;
    if (!width) {
      return;
    }
    const modifyTextNode = (textNode, parentElement) => {
      const text = textNode.textContent || "";
      const words = text.replace(/([^\^])-/g, "$1- ").split(" ");
      const hasWhiteSpace = !this.noWrap && (words.length > 1 || wrapper.element.childNodes.length > 1);
      const dy = this.getLineHeight(parentElement), ellipsisWidth = Math.max(
        0,
        // Subtract the font face to make room for
        // the ellipsis itself
        width - 0.8 * dy
      );
      let lineNo = 0;
      let startAt = wrapper.actualWidth;
      if (hasWhiteSpace) {
        const lines = [];
        const precedingSiblings = [];
        while (parentElement.firstChild && parentElement.firstChild !== textNode) {
          precedingSiblings.push(parentElement.firstChild);
          parentElement.removeChild(parentElement.firstChild);
        }
        while (words.length) {
          if (words.length && !this.noWrap && lineNo > 0) {
            lines.push(textNode.textContent || "");
            textNode.textContent = words.join(" ").replace(/- /g, "-");
          }
          this.truncate(
            textNode,
            void 0,
            words,
            lineNo === 0 ? startAt || 0 : 0,
            width,
            ellipsisWidth,
            // Build the text to test for
            (t, currentIndex) => words.slice(0, currentIndex).join(" ").replace(/- /g, "-")
          );
          startAt = wrapper.actualWidth;
          lineNo++;
          if (this.lineClamp && lineNo >= this.lineClamp) {
            if (words.length) {
              this.truncate(
                textNode,
                textNode.textContent || "",
                void 0,
                0,
                // Target width
                width,
                ellipsisWidth,
                stringWithEllipsis
              );
              textNode.textContent = textNode.textContent?.replace("…", "") + "…";
            }
            break;
          }
        }
        precedingSiblings.forEach((childNode) => {
          parentElement.insertBefore(childNode, textNode);
        });
        lines.forEach((line2) => {
          parentElement.insertBefore(doc$q.createTextNode(line2), textNode);
          const br = doc$q.createElementNS(SVG_NS$2, "tspan");
          br.textContent = "​";
          attr$c(br, { dy, x });
          parentElement.insertBefore(br, textNode);
        });
      } else if (this.ellipsis) {
        if (text) {
          this.truncate(
            textNode,
            text,
            void 0,
            0,
            // Target width
            width,
            ellipsisWidth,
            stringWithEllipsis
          );
        }
      }
    };
    const modifyChildren = ((node) => {
      const childNodes = [].slice.call(node.childNodes);
      childNodes.forEach((childNode) => {
        if (childNode.nodeType === win$b.Node.TEXT_NODE) {
          modifyTextNode(childNode, node);
        } else {
          if (childNode.className.baseVal.indexOf("highcharts-br") !== -1) {
            wrapper.actualWidth = 0;
          }
          modifyChildren(childNode);
        }
      });
    });
    modifyChildren(wrapper.element);
  }
  /**
   * Get the rendered line height of a <text>, <tspan> or pure text node.
   * @private
   * @param {DOMElementType|Text} node The node to check for
   * @return {number} The rendered line height
   */
  getLineHeight(node) {
    const element = node.nodeType === win$b.Node.TEXT_NODE ? node.parentElement : node;
    return this.textLineHeight ? parseInt(this.textLineHeight.toString(), 10) : this.renderer.fontMetrics(element || this.svgElement.element).h;
  }
  /**
   * Transform a pseudo HTML AST node tree into an SVG structure. We do as
   * much heavy lifting as we can here, before doing the final processing in
   * the modifyDOM function. The original data is mutated.
   *
   * @private
   *
   * @param {ASTNode[]} nodes The AST nodes
   *
   */
  modifyTree(nodes) {
    const modifyChild = (node, i2) => {
      const { attributes = {}, children, style = {}, tagName } = node, styledMode = this.renderer.styledMode;
      if (tagName === "b" || tagName === "strong") {
        if (styledMode) {
          attributes["class"] = "highcharts-strong";
        } else {
          style.fontWeight = "bold";
        }
      } else if (tagName === "i" || tagName === "em") {
        if (styledMode) {
          attributes["class"] = "highcharts-emphasized";
        } else {
          style.fontStyle = "italic";
        }
      }
      if (style?.color) {
        style.fill = style.color;
      }
      if (tagName === "br") {
        attributes["class"] = "highcharts-br";
        node.textContent = "​";
        const nextNode = nodes[i2 + 1];
        if (nextNode?.textContent) {
          nextNode.textContent = nextNode.textContent.replace(/^ +/gm, "");
        }
      } else if (tagName === "a" && children && children.some((child) => child.tagName === "#text")) {
        node.children = [{ children, tagName: "tspan" }];
      }
      if (tagName !== "#text" && tagName !== "a") {
        node.tagName = "tspan";
      }
      extend$1o(node, { attributes, style });
      if (children) {
        children.filter((c) => c.tagName !== "#text").forEach(modifyChild);
      }
    };
    nodes.forEach(modifyChild);
    fireEvent$K(this.svgElement, "afterModifyTree", { nodes });
  }
  /*
   * Truncate the text node contents to a given length. Used when the css
   * width is set. If the `textOverflow` is `ellipsis`, the text is truncated
   * character by character to the given length. If not, the text is
   * word-wrapped line by line.
   */
  truncate(textNode, text, words, startAt, width, ellipsisWidth, getString) {
    const svgElement = this.svgElement;
    const { rotation } = svgElement;
    const lengths = [];
    let minIndex = words && !startAt ? 1 : 0;
    let maxIndex = (text || words || "").length;
    let currentIndex = maxIndex;
    let str;
    let actualWidth;
    if (!words) {
      width = ellipsisWidth;
    }
    const getSubStringLength = function(charEnd, concatenatedEnd) {
      const end = concatenatedEnd || charEnd;
      const parentNode = textNode.parentNode;
      if (parentNode && typeof lengths[end] === "undefined") {
        if (parentNode.getSubStringLength) {
          try {
            lengths[end] = startAt + parentNode.getSubStringLength(0, words ? end + 1 : end);
          } catch (e) {
          }
        }
      }
      return lengths[end];
    };
    svgElement.rotation = 0;
    actualWidth = getSubStringLength(textNode.textContent.length);
    if (startAt + actualWidth > width) {
      while (minIndex <= maxIndex) {
        currentIndex = Math.ceil((minIndex + maxIndex) / 2);
        if (words) {
          str = getString(words, currentIndex);
        }
        actualWidth = getSubStringLength(currentIndex, str && str.length - 1);
        if (minIndex === maxIndex) {
          minIndex = maxIndex + 1;
        } else if (actualWidth > width) {
          maxIndex = currentIndex - 1;
        } else {
          minIndex = currentIndex;
        }
      }
      if (maxIndex === 0) {
        textNode.textContent = "";
      } else if (!(text && maxIndex === text.length - 1)) {
        textNode.textContent = str || getString(text || words, currentIndex);
      }
      if (this.ellipsis && actualWidth > width) {
        this.truncate(textNode, textNode.textContent || "", void 0, 0, width, ellipsisWidth, stringWithEllipsis);
      }
    }
    if (words) {
      words.splice(0, currentIndex);
    }
    svgElement.actualWidth = actualWidth;
    svgElement.rotation = rotation;
  }
  /*
   * Un-escape HTML entities based on the public `renderer.escapes` list
   *
   * @private
   *
   * @param {string} inputStr The string to unescape
   * @param {Array<string>} [except] Exceptions
   *
   * @return {string} The processed string
   */
  unescapeEntities(inputStr, except) {
    objectEach$t(this.renderer.escapes, function(value, key2) {
      if (!except || except.indexOf(value) === -1) {
        inputStr = inputStr.toString().replace(new RegExp(value, "g"), key2);
      }
    });
    return inputStr;
  }
}
const { defaultOptions: defaultOptions$l } = DefaultOptions;
const { charts: charts$3, deg2rad: deg2rad$9, doc: doc$p, isFirefox: isFirefox$2, isMS: isMS$1, isWebKit, noop: noop$j, SVG_NS: SVG_NS$1, symbolSizes, win: win$a } = Highcharts;
const { addEvent: addEvent$1u, attr: attr$b, createElement: createElement$b, crisp: crisp$e, css: css$d, defined: defined$19, destroyObjectProperties: destroyObjectProperties$a, extend: extend$1n, isArray: isArray$o, isNumber: isNumber$14, isObject: isObject$k, isString: isString$e, merge: merge$1D, pick: pick$1K, pInt: pInt$5, replaceNested: replaceNested$1, uniqueKey: uniqueKey$8 } = Utilities;
let hasInternalReferenceBug;
class SVGRenderer {
  /**
   * The root `svg` node of the renderer.
   *
   * @name Highcharts.SVGRenderer#box
   * @type {Highcharts.SVGDOMElement}
   */
  /**
   * The wrapper for the root `svg` node of the renderer.
   *
   * @name Highcharts.SVGRenderer#boxWrapper
   * @type {Highcharts.SVGElement}
   */
  /**
   * A pointer to the `defs` node of the root SVG.
   *
   * @name Highcharts.SVGRenderer#defs
   * @type {Highcharts.SVGElement}
   */
  /**
   * Whether the rendered content is intended for export.
   *
   * @name Highcharts.SVGRenderer#forExport
   * @type {boolean | undefined}
   */
  /**
   * Page url used for internal references.
   *
   * @private
   * @name Highcharts.SVGRenderer#url
   * @type {string}
   */
  /**
   * Initialize the SVGRenderer. Overridable initializer function that takes
   * the same parameters as the constructor.
   *
   * @function Highcharts.SVGRenderer#init
   *
   * @param {Highcharts.HTMLDOMElement} container
   * Where to put the SVG in the web page.
   *
   * @param {number} width
   * The width of the SVG.
   *
   * @param {number} height
   * The height of the SVG.
   *
   * @param {Highcharts.CSSObject} [style]
   * The box style, if not in styleMode
   *
   * @param {boolean} [forExport=false]
   * Whether the rendered content is intended for export.
   *
   * @param {boolean} [allowHTML=true]
   * Whether the renderer is allowed to include HTML text, which will be
   * projected on top of the SVG.
   *
   * @param {boolean} [styledMode=false]
   * Whether the renderer belongs to a chart that is in styled mode. If it
   * does, it will avoid setting presentational attributes in some cases, but
   * not when set explicitly through `.attr` and `.css` etc.
   */
  constructor(container, width, height, style, forExport, allowHTML, styledMode) {
    this.x = 0;
    this.y = 0;
    const renderer = this, boxWrapper = renderer.createElement("svg").attr({
      version: "1.1",
      "class": "highcharts-root"
    }), element = boxWrapper.element;
    if (!styledMode) {
      boxWrapper.css(this.getStyle(style || {}));
    }
    container.appendChild(element);
    attr$b(container, "dir", "ltr");
    if (container.innerHTML.indexOf("xmlns") === -1) {
      attr$b(element, "xmlns", this.SVG_NS);
    }
    this.box = element;
    this.boxWrapper = boxWrapper;
    this.alignedObjects = [];
    this.url = this.getReferenceURL();
    const desc = this.createElement("desc").add();
    desc.element.appendChild(doc$p.createTextNode("Created with Highcharts 12.2.0"));
    this.defs = this.createElement("defs").add();
    this.allowHTML = allowHTML;
    this.forExport = forExport;
    this.styledMode = styledMode;
    this.gradients = {};
    this.cache = {};
    this.cacheKeys = [];
    this.imgCount = 0;
    this.rootFontSize = boxWrapper.getStyle("font-size");
    renderer.setSize(width, height, false);
    let subPixelFix, rect2;
    if (isFirefox$2 && container.getBoundingClientRect) {
      subPixelFix = function() {
        css$d(container, { left: 0, top: 0 });
        rect2 = container.getBoundingClientRect();
        css$d(container, {
          left: Math.ceil(rect2.left) - rect2.left + "px",
          top: Math.ceil(rect2.top) - rect2.top + "px"
        });
      };
      subPixelFix();
      renderer.unSubPixelFix = addEvent$1u(win$a, "resize", subPixelFix);
    }
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * General method for adding a definition to the SVG `defs` tag. Can be used
   * for gradients, fills, filters etc. Styled mode only. A hook for adding
   * general definitions to the SVG's defs tag. Definitions can be referenced
   * from the CSS by its `id`. Read more in
   * [gradients, shadows and patterns](https://www.highcharts.com/docs/chart-design-and-style/gradients-shadows-and-patterns).
   * Styled mode only.
   *
   * @function Highcharts.SVGRenderer#definition
   *
   * @param {Highcharts.ASTNode} def
   * A serialized form of an SVG definition, including children.
   *
   * @return {Highcharts.SVGElement}
   * The inserted node.
   */
  definition(def) {
    const ast = new AST([def]);
    return ast.addToDOM(this.defs.element);
  }
  /**
   * Get the prefix needed for internal URL references to work in certain
   * cases. Some older browser versions had a bug where internal url
   * references in SVG attributes, on the form `url(#some-id)`, would fail if
   * a base tag was present in the page. There were also issues with
   * `history.pushState` related to this prefix.
   *
   * Related issues: #24, #672, #1070, #5244.
   *
   * The affected browsers are:
   * - Chrome <= 53 (May 2018)
   * - Firefox <= 51 (January 2017)
   * - Safari/Mac <= 12.1 (2018 or 2019)
   * - Safari/iOS <= 13
   *
   * @todo Remove this hack when time has passed. All the affected browsers
   * are evergreens, so it is increasingly unlikely that users are affected by
   * the bug.
   *
   * @return {string}
   * The prefix to use. An empty string for modern browsers.
   */
  getReferenceURL() {
    if ((isFirefox$2 || isWebKit) && doc$p.getElementsByTagName("base").length) {
      if (!defined$19(hasInternalReferenceBug)) {
        const id = uniqueKey$8();
        const ast = new AST([{
          tagName: "svg",
          attributes: {
            width: 8,
            height: 8
          },
          children: [{
            tagName: "defs",
            children: [{
              tagName: "clipPath",
              attributes: {
                id
              },
              children: [{
                tagName: "rect",
                attributes: {
                  width: 4,
                  height: 4
                }
              }]
            }]
          }, {
            tagName: "rect",
            attributes: {
              id: "hitme",
              width: 8,
              height: 8,
              "clip-path": `url(#${id})`,
              fill: "rgba(0,0,0,0.001)"
            }
          }]
        }]);
        const svg2 = ast.addToDOM(doc$p.body);
        css$d(svg2, {
          position: "fixed",
          top: 0,
          left: 0,
          zIndex: 9e5
        });
        const hitElement = doc$p.elementFromPoint(6, 6);
        hasInternalReferenceBug = hitElement?.id === "hitme";
        doc$p.body.removeChild(svg2);
      }
      if (hasInternalReferenceBug) {
        return replaceNested$1(
          win$a.location.href.split("#")[0],
          // Remove hash
          [/<[^>]*>/g, ""],
          // Wing cut HTML
          [/([\('\)])/g, "\\$1"],
          // Escape parantheses and quotes
          [/ /g, "%20"]
          // Replace spaces (needed for Safari only)
        );
      }
    }
    return "";
  }
  /**
   * Get the global style setting for the renderer.
   *
   * @private
   * @function Highcharts.SVGRenderer#getStyle
   *
   * @param {Highcharts.CSSObject} style
   * Style settings.
   *
   * @return {Highcharts.CSSObject}
   * The style settings mixed with defaults.
   */
  getStyle(style) {
    this.style = extend$1n({
      fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", sans-serif',
      fontSize: "1rem"
    }, style);
    return this.style;
  }
  /**
   * Apply the global style on the renderer, mixed with the default styles.
   *
   * @function Highcharts.SVGRenderer#setStyle
   *
   * @param {Highcharts.CSSObject} style
   * CSS to apply.
   */
  setStyle(style) {
    this.boxWrapper.css(this.getStyle(style));
  }
  /**
   * Detect whether the renderer is hidden. This happens when one of the
   * parent elements has `display: none`. Used internally to detect when we
   * need to render preliminarily in another div to get the text bounding
   * boxes right.
   *
   * @function Highcharts.SVGRenderer#isHidden
   *
   * @return {boolean}
   * True if it is hidden.
   */
  isHidden() {
    return !this.boxWrapper.getBBox().width;
  }
  /**
   * Destroys the renderer and its allocated members.
   *
   * @function Highcharts.SVGRenderer#destroy
   *
   * @return {null}
   * Pass through value.
   */
  destroy() {
    const renderer = this, rendererDefs = renderer.defs;
    renderer.box = null;
    renderer.boxWrapper = renderer.boxWrapper.destroy();
    destroyObjectProperties$a(renderer.gradients || {});
    renderer.gradients = null;
    renderer.defs = rendererDefs.destroy();
    if (renderer.unSubPixelFix) {
      renderer.unSubPixelFix();
    }
    renderer.alignedObjects = null;
    return null;
  }
  /**
   * Create a wrapper for an SVG element. Serves as a factory for
   * {@link SVGElement}, but this function is itself mostly called from
   * primitive factories like {@link SVGRenderer#path}, {@link
   * SVGRenderer#rect} or {@link SVGRenderer#text}.
   *
   * @function Highcharts.SVGRenderer#createElement
   *
   * @param {string} nodeName
   * The node name, for example `rect`, `g` etc.
   *
   * @return {Highcharts.SVGElement}
   * The generated SVGElement.
   */
  createElement(nodeName) {
    return new this.Element(this, nodeName);
  }
  /**
   * Get converted radial gradient attributes according to the radial
   * reference. Used internally from the {@link SVGElement#colorGradient}
   * function.
   *
   * @private
   * @function Highcharts.SVGRenderer#getRadialAttr
   */
  getRadialAttr(radialReference, gradAttr) {
    return {
      cx: radialReference[0] - radialReference[2] / 2 + (gradAttr.cx || 0) * radialReference[2],
      cy: radialReference[1] - radialReference[2] / 2 + (gradAttr.cy || 0) * radialReference[2],
      r: (gradAttr.r || 0) * radialReference[2]
    };
  }
  /**
   * Create a drop shadow definition and return its id
   *
   * @private
   * @function Highcharts.SVGRenderer#shadowDefinition
   *
   * @param {boolean|Highcharts.ShadowOptionsObject} [shadowOptions] The
   *        shadow options. If `true`, the default options are applied
   */
  shadowDefinition(shadowOptions) {
    const id = [
      `highcharts-drop-shadow-${this.chartIndex}`,
      ...Object.keys(shadowOptions).map((key2) => `${key2}-${shadowOptions[key2]}`)
    ].join("-").toLowerCase().replace(/[^a-z\d\-]/g, ""), options2 = merge$1D({
      color: "#000000",
      offsetX: 1,
      offsetY: 1,
      opacity: 0.15,
      width: 5
    }, shadowOptions);
    if (!this.defs.element.querySelector(`#${id}`)) {
      this.definition({
        tagName: "filter",
        attributes: {
          id,
          filterUnits: options2.filterUnits
        },
        children: this.getShadowFilterContent(options2)
      });
    }
    return id;
  }
  /**
   * Get shadow filter content.
   * NOTE! Overridden in es5 module for IE11 compatibility.
   *
   * @private
   * @function Highcharts.SVGRenderer#getShadowFilterContent
   *
   * @param {ShadowOptionsObject} options
   * The shadow options.
   * @return {Array<AST.Node>}
   * The shadow filter content.
   */
  getShadowFilterContent(options2) {
    return [{
      tagName: "feDropShadow",
      attributes: {
        dx: options2.offsetX,
        dy: options2.offsetY,
        "flood-color": options2.color,
        // Tuned and modified to keep a preserve compatibility
        // with the old settings
        "flood-opacity": Math.min(options2.opacity * 5, 1),
        stdDeviation: options2.width / 2
      }
    }];
  }
  /**
   * Parse a simple HTML string into SVG tspans. Called internally when text
   * is set on an SVGElement. The function supports a subset of HTML tags, CSS
   * text features like `width`, `text-overflow`, `white-space`, and also
   * attributes like `href` and `style`.
   *
   * @private
   * @function Highcharts.SVGRenderer#buildText
   *
   * @param {Highcharts.SVGElement} wrapper
   * The parent SVGElement.
   */
  buildText(wrapper) {
    new TextBuilder(wrapper).buildSVG();
  }
  /**
   * Returns white for dark colors and black for bright colors, based on W3C's
   * definition of [Relative luminance](
   * https://www.w3.org/WAI/GL/wiki/Relative_luminance).
   *
   * @function Highcharts.SVGRenderer#getContrast
   *
   * @param {Highcharts.ColorString} color
   * The color to get the contrast for.
   *
   * @return {Highcharts.ColorString}
   * The contrast color, either `#000000` or `#FFFFFF`.
   */
  getContrast(color2) {
    const rgba256 = Color.parse(color2).rgba, channelFunc = " clamp(0,calc(9e9*(0.5 - (0.2126*r + 0.7152*g + 0.0722*b))),1)";
    if (isNumber$14(rgba256[0]) || !Color.useColorMix) {
      const rgba = rgba256.map((b8) => {
        const c = b8 / 255;
        return c <= 0.04 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
      }), l = 0.2126 * rgba[0] + 0.7152 * rgba[1] + 0.0722 * rgba[2];
      return 1.05 / (l + 0.05) > (l + 0.05) / 0.05 ? "#FFFFFF" : "#000000";
    }
    return "color(from " + color2 + " srgb" + channelFunc + channelFunc + channelFunc + ")";
  }
  /**
   * Create a button with preset states. Styles for the button can either be
   * set as arguments, or a general theme for all buttons can be set by the
   * `global.buttonTheme` option.
   *
   * @function Highcharts.SVGRenderer#button
   *
   * @param {string} text
   * The text or HTML to draw.
   *
   * @param {number} x
   * The x position of the button's left side.
   *
   * @param {number} y
   * The y position of the button's top side.
   *
   * @param {Highcharts.EventCallbackFunction<Highcharts.SVGElement>} callback
   * The function to execute on button click or touch.
   *
   * @param {Highcharts.SVGAttributes} [theme]
   * SVG attributes for the normal state.
   *
   * @param {Highcharts.SVGAttributes} [hoverState]
   * SVG attributes for the hover state.
   *
   * @param {Highcharts.SVGAttributes} [selectState]
   * SVG attributes for the pressed state.
   *
   * @param {Highcharts.SVGAttributes} [disabledState]
   * SVG attributes for the disabled state.
   *
   * @param {Highcharts.SymbolKeyValue} [shape=rect]
   * The shape type.
   *
   * @param {boolean} [useHTML=false]
   * Whether to use HTML to render the label.
   *
   * @return {Highcharts.SVGElement}
   * The button element.
   */
  button(text, x, y, callback, theme2 = {}, hoverState, selectState, disabledState, shape, useHTML) {
    const label = this.label(text, x, y, shape, void 0, void 0, useHTML, void 0, "button"), styledMode = this.styledMode, args = arguments;
    let curState = 0;
    theme2 = merge$1D(defaultOptions$l.global.buttonTheme, theme2);
    if (styledMode) {
      delete theme2.fill;
      delete theme2.stroke;
      delete theme2["stroke-width"];
    }
    const states2 = theme2.states || {}, normalStyle = theme2.style || {};
    delete theme2.states;
    delete theme2.style;
    const stateAttribs = [
      AST.filterUserAttributes(theme2)
    ], stateStyles = [normalStyle];
    if (!styledMode) {
      ["hover", "select", "disabled"].forEach((stateName, i2) => {
        stateAttribs.push(merge$1D(stateAttribs[0], AST.filterUserAttributes(args[i2 + 5] || states2[stateName] || {})));
        stateStyles.push(stateAttribs[i2 + 1].style);
        delete stateAttribs[i2 + 1].style;
      });
    }
    addEvent$1u(label.element, isMS$1 ? "mouseover" : "mouseenter", function() {
      if (curState !== 3) {
        label.setState(1);
      }
    });
    addEvent$1u(label.element, isMS$1 ? "mouseout" : "mouseleave", function() {
      if (curState !== 3) {
        label.setState(curState);
      }
    });
    label.setState = (state = 0) => {
      if (state !== 1) {
        label.state = curState = state;
      }
      label.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-" + ["normal", "hover", "pressed", "disabled"][state]);
      if (!styledMode) {
        label.attr(stateAttribs[state]);
        const css2 = stateStyles[state];
        if (isObject$k(css2)) {
          label.css(css2);
        }
      }
    };
    label.attr(stateAttribs[0]);
    if (!styledMode) {
      label.css(extend$1n({ cursor: "default" }, normalStyle));
      if (useHTML) {
        label.text.css({ pointerEvents: "none" });
      }
    }
    return label.on("touchstart", (e) => e.stopPropagation()).on("click", function(e) {
      if (curState !== 3) {
        callback?.call(label, e);
      }
    });
  }
  /**
   * Make a straight line crisper by not spilling out to neighbour pixels.
   *
   * @function Highcharts.SVGRenderer#crispLine
   *
   * @param {Highcharts.SVGPathArray} points
   *        The original points on the format `[['M', 0, 0], ['L', 100, 0]]`.
   *
   * @param {number} width
   *        The width of the line.
   *
   * @return {Highcharts.SVGPathArray}
   *         The original points array, but modified to render crisply.
   */
  crispLine(points, width) {
    const [start2, end] = points;
    if (defined$19(start2[1]) && start2[1] === end[1]) {
      start2[1] = end[1] = crisp$e(start2[1], width);
    }
    if (defined$19(start2[2]) && start2[2] === end[2]) {
      start2[2] = end[2] = crisp$e(start2[2], width);
    }
    return points;
  }
  /**
   * Draw a path, wraps the SVG `path` element.
   *
   * @sample highcharts/members/renderer-path-on-chart/
   *         Draw a path in a chart
   * @sample highcharts/members/renderer-path/
   *         Draw a path independent from a chart
   *
   * @example
   * let path = renderer.path(['M', 10, 10, 'L', 30, 30, 'z'])
   *     .attr({ stroke: '#ff00ff' })
   *     .add();
   *
   * @function Highcharts.SVGRenderer#path
   *
   * @param {Highcharts.SVGPathArray} [path]
   * An SVG path definition in array form.
   *
   * @return {Highcharts.SVGElement}
   * The generated wrapper element.
   *
   */
  /**
  * Draw a path, wraps the SVG `path` element.
  *
  * @function Highcharts.SVGRenderer#path
  *
  * @param {Highcharts.SVGAttributes} [attribs]
  * The initial attributes.
  *
  * @return {Highcharts.SVGElement}
  * The generated wrapper element.
  */
  path(path) {
    const attribs = this.styledMode ? {} : {
      fill: "none"
    };
    if (isArray$o(path)) {
      attribs.d = path;
    } else if (isObject$k(path)) {
      extend$1n(attribs, path);
    }
    return this.createElement("path").attr(attribs);
  }
  /**
   * Draw a circle, wraps the SVG `circle` element.
   *
   * @sample highcharts/members/renderer-circle/
   *         Drawing a circle
   *
   * @function Highcharts.SVGRenderer#circle
   *
   * @param {number} [x]
   * The center x position.
   *
   * @param {number} [y]
   * The center y position.
   *
   * @param {number} [r]
   * The radius.
   *
   * @return {Highcharts.SVGElement}
   * The generated wrapper element.
   */
  /**
  * Draw a circle, wraps the SVG `circle` element.
  *
  * @function Highcharts.SVGRenderer#circle
  *
  * @param {Highcharts.SVGAttributes} [attribs]
  * The initial attributes.
  *
  * @return {Highcharts.SVGElement}
  * The generated wrapper element.
  */
  circle(x, y, r) {
    const attribs = isObject$k(x) ? x : typeof x === "undefined" ? {} : { x, y, r }, wrapper = this.createElement("circle");
    wrapper.xSetter = wrapper.ySetter = function(value, key2, element) {
      element.setAttribute("c" + key2, value);
    };
    return wrapper.attr(attribs);
  }
  /**
   * Draw and return an arc.
   *
   * @sample highcharts/members/renderer-arc/
   *         Drawing an arc
   *
   * @function Highcharts.SVGRenderer#arc
   *
   * @param {number} [x=0]
   * Center X position.
   *
   * @param {number} [y=0]
   * Center Y position.
   *
   * @param {number} [r=0]
   * The outer radius' of the arc.
   *
   * @param {number} [innerR=0]
   * Inner radius like used in donut charts.
   *
   * @param {number} [start=0]
   * The starting angle of the arc in radians, where 0 is to the right and
   * `-Math.PI/2` is up.
   *
   * @param {number} [end=0]
   * The ending angle of the arc in radians, where 0 is to the right and
   * `-Math.PI/2` is up.
   *
   * @return {Highcharts.SVGElement}
   * The generated wrapper element.
   */
  /**
  * Draw and return an arc. Overloaded function that takes arguments object.
  *
  * @function Highcharts.SVGRenderer#arc
  *
  * @param {Highcharts.SVGAttributes} attribs
  * Initial SVG attributes.
  *
  * @return {Highcharts.SVGElement}
  * The generated wrapper element.
  */
  arc(x, y, r, innerR, start2, end) {
    let options2;
    if (isObject$k(x)) {
      options2 = x;
      y = options2.y;
      r = options2.r;
      innerR = options2.innerR;
      start2 = options2.start;
      end = options2.end;
      x = options2.x;
    } else {
      options2 = { innerR, start: start2, end };
    }
    const arc2 = this.symbol("arc", x, y, r, r, options2);
    arc2.r = r;
    return arc2;
  }
  /**
   * Draw and return a rectangle.
   *
   * @function Highcharts.SVGRenderer#rect
   *
   * @param {number} [x]
   * Left position.
   *
   * @param {number} [y]
   * Top position.
   *
   * @param {number} [width]
   * Width of the rectangle.
   *
   * @param {number} [height]
   * Height of the rectangle.
   *
   * @param {number} [r]
   * Border corner radius.
   *
   * @param {number} [strokeWidth]
   * A stroke width can be supplied to allow crisp drawing.
   *
   * @return {Highcharts.SVGElement}
   * The generated wrapper element.
   */
  /**
  * Draw and return a rectangle.
  *
  * @sample highcharts/members/renderer-rect-on-chart/
  *         Draw a rectangle in a chart
  * @sample highcharts/members/renderer-rect/
  *         Draw a rectangle independent from a chart
  *
  * @function Highcharts.SVGRenderer#rect
  *
  * @param {Highcharts.SVGAttributes} [attributes]
  * General SVG attributes for the rectangle.
  *
  * @return {Highcharts.SVGElement}
  * The generated wrapper element.
  */
  rect(x, y, width, height, r, strokeWidth) {
    const attribs = isObject$k(x) ? x : typeof x === "undefined" ? {} : {
      x,
      y,
      r,
      width: Math.max(width || 0, 0),
      height: Math.max(height || 0, 0)
    }, wrapper = this.createElement("rect");
    if (!this.styledMode) {
      if (typeof strokeWidth !== "undefined") {
        attribs["stroke-width"] = strokeWidth;
        extend$1n(attribs, wrapper.crisp(attribs));
      }
      attribs.fill = "none";
    }
    wrapper.rSetter = function(value, _key, element) {
      wrapper.r = value;
      attr$b(element, {
        rx: value,
        ry: value
      });
    };
    wrapper.rGetter = function() {
      return wrapper.r || 0;
    };
    return wrapper.attr(attribs);
  }
  /**
   * Draw and return a rectangle with advanced corner rounding options.
   *
   * @function Highcharts.SVGRenderer#roundedRect
   *
   * @param {Highcharts.SVGAttributes} attribs
   *      Attributes
   * @return {Highcharts.SVGElement}
   * The generated wrapper element.
   */
  roundedRect(attribs) {
    return this.symbol("roundedRect").attr(attribs);
  }
  /**
   * Resize the {@link SVGRenderer#box} and re-align all aligned child
   * elements.
   *
   * @sample highcharts/members/renderer-g/
   *         Show and hide grouped objects
   *
   * @function Highcharts.SVGRenderer#setSize
   *
   * @param {number} width
   * The new pixel width.
   *
   * @param {number} height
   * The new pixel height.
   *
   * @param {boolean|Partial<Highcharts.AnimationOptionsObject>} [animate=true]
   * Whether and how to animate.
   */
  setSize(width, height, animate2) {
    const renderer = this;
    renderer.width = width;
    renderer.height = height;
    renderer.boxWrapper.animate({
      width,
      height
    }, {
      step: function() {
        this.attr({
          viewBox: "0 0 " + this.attr("width") + " " + this.attr("height")
        });
      },
      duration: pick$1K(animate2, true) ? void 0 : 0
    });
    renderer.alignElements();
  }
  /**
   * Create and return an svg group element. Child
   * {@link Highcharts.SVGElement} objects are added to the group by using the
   * group as the first parameter in {@link Highcharts.SVGElement#add|add()}.
   *
   * @function Highcharts.SVGRenderer#g
   *
   * @param {string} [name]
   *        The group will be given a class name of `highcharts-{name}`. This
   *        can be used for styling and scripting.
   *
   * @return {Highcharts.SVGElement}
   *         The generated wrapper element.
   */
  g(name) {
    const elem = this.createElement("g");
    return name ? elem.attr({ "class": "highcharts-" + name }) : elem;
  }
  /**
   * Display an image.
   *
   * @sample highcharts/members/renderer-image-on-chart/
   *         Add an image in a chart
   * @sample highcharts/members/renderer-image/
   *         Add an image independent of a chart
   *
   * @function Highcharts.SVGRenderer#image
   *
   * @param {string} href
   *        The image source.
   *
   * @param {number} [x]
   *        The X position.
   *
   * @param {number} [y]
   *        The Y position.
   *
   * @param {number} [width]
   *        The image width. If omitted, it defaults to the image file width.
   *
   * @param {number} [height]
   *        The image height. If omitted it defaults to the image file
   *        height.
   *
   * @param {Function} [onload]
   *        Event handler for image load.
   *
   * @return {Highcharts.SVGElement}
   *         The generated wrapper element.
   */
  image(href, x, y, width, height, onload) {
    const attribs = { preserveAspectRatio: "none" };
    if (isNumber$14(x)) {
      attribs.x = x;
    }
    if (isNumber$14(y)) {
      attribs.y = y;
    }
    if (isNumber$14(width)) {
      attribs.width = width;
    }
    if (isNumber$14(height)) {
      attribs.height = height;
    }
    const elemWrapper = this.createElement("image").attr(attribs), onDummyLoad = function(e) {
      elemWrapper.attr({ href });
      onload.call(elemWrapper, e);
    };
    if (onload) {
      elemWrapper.attr({
        /* eslint-disable-next-line max-len */
        href: "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="
      });
      const dummy = new win$a.Image();
      addEvent$1u(dummy, "load", onDummyLoad);
      dummy.src = href;
      if (dummy.complete) {
        onDummyLoad({});
      }
    } else {
      elemWrapper.attr({ href });
    }
    return elemWrapper;
  }
  /**
   * Draw a symbol out of pre-defined shape paths from
   * {@link SVGRenderer#symbols}.
   * It is used in Highcharts for point makers, which cake a `symbol` option,
   * and label and button backgrounds like in the tooltip and stock flags.
   *
   * @function Highcharts.SVGRenderer#symbol
   *
   * @param {string} symbol
   * The symbol name.
   *
   * @param {number} [x]
   * The X coordinate for the top left position.
   *
   * @param {number} [y]
   * The Y coordinate for the top left position.
   *
   * @param {number} [width]
   * The pixel width.
   *
   * @param {number} [height]
   * The pixel height.
   *
   * @param {Highcharts.SymbolOptionsObject} [options]
   * Additional options, depending on the actual symbol drawn.
   *
   * @return {Highcharts.SVGElement}
   * SVG symbol.
   */
  symbol(symbol, x, y, width, height, options2) {
    const ren = this, imageRegex = /^url\((.*?)\)$/, isImage = imageRegex.test(symbol), sym = !isImage && (this.symbols[symbol] ? symbol : "circle"), symbolFn = sym && this.symbols[sym];
    let obj, path, imageSrc, centerImage;
    if (symbolFn) {
      if (typeof x === "number") {
        path = symbolFn.call(this.symbols, x || 0, y || 0, width || 0, height || 0, options2);
      }
      obj = this.path(path);
      if (!ren.styledMode) {
        obj.attr("fill", "none");
      }
      extend$1n(obj, {
        symbolName: sym || void 0,
        x,
        y,
        width,
        height
      });
      if (options2) {
        extend$1n(obj, options2);
      }
    } else if (isImage) {
      imageSrc = symbol.match(imageRegex)[1];
      const img = obj = this.image(imageSrc);
      img.imgwidth = pick$1K(options2?.width, symbolSizes[imageSrc]?.width);
      img.imgheight = pick$1K(options2?.height, symbolSizes[imageSrc]?.height);
      centerImage = (obj2) => obj2.attr({
        width: obj2.width,
        height: obj2.height
      });
      ["width", "height"].forEach((key2) => {
        img[`${key2}Setter`] = function(value, key3) {
          this[key3] = value;
          const { alignByTranslate, element, width: width2, height: height2, imgwidth, imgheight } = this, imgSize = key3 === "width" ? imgwidth : imgheight;
          let scale2 = 1;
          if (options2 && options2.backgroundSize === "within" && width2 && height2 && imgwidth && imgheight) {
            scale2 = Math.min(width2 / imgwidth, height2 / imgheight);
            attr$b(element, {
              width: Math.round(imgwidth * scale2),
              height: Math.round(imgheight * scale2)
            });
          } else if (element && imgSize) {
            element.setAttribute(key3, imgSize);
          }
          if (!alignByTranslate && imgwidth && imgheight) {
            this.translate(((width2 || 0) - imgwidth * scale2) / 2, ((height2 || 0) - imgheight * scale2) / 2);
          }
        };
      });
      if (defined$19(x)) {
        img.attr({
          x,
          y
        });
      }
      img.isImg = true;
      img.symbolUrl = symbol;
      if (defined$19(img.imgwidth) && defined$19(img.imgheight)) {
        centerImage(img);
      } else {
        img.attr({ width: 0, height: 0 });
        createElement$b("img", {
          onload: function() {
            const chart = charts$3[ren.chartIndex];
            if (this.width === 0) {
              css$d(this, {
                position: "absolute",
                top: "-999em"
              });
              doc$p.body.appendChild(this);
            }
            symbolSizes[imageSrc] = {
              width: this.width,
              height: this.height
            };
            img.imgwidth = this.width;
            img.imgheight = this.height;
            if (img.element) {
              centerImage(img);
            }
            if (this.parentNode) {
              this.parentNode.removeChild(this);
            }
            ren.imgCount--;
            if (!ren.imgCount && chart && !chart.hasLoaded) {
              chart.onload();
            }
          },
          src: imageSrc
        });
        this.imgCount++;
      }
    }
    return obj;
  }
  /**
   * Define a clipping rectangle. The clipping rectangle is later applied
   * to {@link SVGElement} objects through the {@link SVGElement#clip}
   * function.
   *
   * This function is deprecated as of v11.2. Instead, use a regular shape
   * (`rect`, `path` etc), and the `SVGElement.clipTo` function.
   *
   * @example
   * let circle = renderer.circle(100, 100, 100)
   *     .attr({ fill: 'red' })
   *     .add();
   * let clipRect = renderer.clipRect(100, 100, 100, 100);
   *
   * // Leave only the lower right quarter visible
   * circle.clip(clipRect);
   *
   * @deprecated
   *
   * @function Highcharts.SVGRenderer#clipRect
   *
   * @param {number} [x]
   *
   * @param {number} [y]
   *
   * @param {number} [width]
   *
   * @param {number} [height]
   *
   * @return {Highcharts.ClipRectElement}
   *         A clipping rectangle.
   */
  clipRect(x, y, width, height) {
    return this.rect(x, y, width, height, 0);
  }
  /**
   * Draw text. The text can contain a subset of HTML, like spans and anchors
   * and some basic text styling of these. For more advanced features like
   * border and background, use {@link Highcharts.SVGRenderer#label} instead.
   * To update the text after render, run `text.attr({ text: 'New text' })`.
   *
   * @sample highcharts/members/renderer-text-on-chart/
   *         Annotate the chart freely
   * @sample highcharts/members/renderer-on-chart/
   *         Annotate with a border and in response to the data
   * @sample highcharts/members/renderer-text/
   *         Formatted text
   *
   * @function Highcharts.SVGRenderer#text
   *
   * @param {string} [str]
   * The text of (subset) HTML to draw.
   *
   * @param {number} [x]
   * The x position of the text's lower left corner.
   *
   * @param {number} [y]
   * The y position of the text's lower left corner.
   *
   * @param {boolean} [useHTML=false]
   * Use HTML to render the text.
   *
   * @return {Highcharts.SVGElement}
   * The text object.
   */
  text(str, x, y, useHTML) {
    const renderer = this, attribs = {};
    if (useHTML && (renderer.allowHTML || !renderer.forExport)) {
      return renderer.html(str, x, y);
    }
    attribs.x = Math.round(x || 0);
    if (y) {
      attribs.y = Math.round(y);
    }
    if (defined$19(str)) {
      attribs.text = str;
    }
    const wrapper = renderer.createElement("text").attr(attribs);
    if (!useHTML || renderer.forExport && !renderer.allowHTML) {
      wrapper.xSetter = function(value, key2, element) {
        const tspans = element.getElementsByTagName("tspan"), parentVal = element.getAttribute(key2);
        for (let i2 = 0, tspan; i2 < tspans.length; i2++) {
          tspan = tspans[i2];
          if (tspan.getAttribute(key2) === parentVal) {
            tspan.setAttribute(key2, value);
          }
        }
        element.setAttribute(key2, value);
      };
    }
    return wrapper;
  }
  /**
   * Utility to return the baseline offset and total line height from the font
   * size.
   *
   * @function Highcharts.SVGRenderer#fontMetrics
   *
   * @param {Highcharts.SVGElement|Highcharts.SVGDOMElement|number} [element]
   *        The element to inspect for a current font size. If a number is
   *        given, it's used as a fall back for direct font size in pixels.
   *
   * @return {Highcharts.FontMetricsObject}
   *         The font metrics.
   */
  fontMetrics(element) {
    const f = pInt$5(SVGElement$1.prototype.getStyle.call(element, "font-size") || 0);
    const h = f < 24 ? f + 3 : Math.round(f * 1.2), b = Math.round(h * 0.8);
    return {
      // Line height
      h,
      // Baseline
      b,
      // Font size
      f
    };
  }
  /**
   * Correct X and Y positioning of a label for rotation (#1764).
   *
   * @private
   * @function Highcharts.SVGRenderer#rotCorr
   */
  rotCorr(baseline, rotation, alterY) {
    let y = baseline;
    if (rotation && alterY) {
      y = Math.max(y * Math.cos(rotation * deg2rad$9), 4);
    }
    return {
      x: -baseline / 3 * Math.sin(rotation * deg2rad$9),
      y
    };
  }
  /**
   * Compatibility function to convert the legacy one-dimensional path array
   * into an array of segments.
   *
   * It is used in maps to parse the `path` option, and in SVGRenderer.dSetter
   * to support legacy paths from demos.
   *
   * @private
   * @function Highcharts.SVGRenderer#pathToSegments
   */
  pathToSegments(path) {
    const ret = [];
    const segment = [];
    const commandLength = {
      A: 8,
      C: 7,
      H: 2,
      L: 3,
      M: 3,
      Q: 5,
      S: 5,
      T: 3,
      V: 2
    };
    for (let i2 = 0; i2 < path.length; i2++) {
      if (isString$e(segment[0]) && isNumber$14(path[i2]) && segment.length === commandLength[segment[0].toUpperCase()]) {
        path.splice(i2, 0, segment[0].replace("M", "L").replace("m", "l"));
      }
      if (typeof path[i2] === "string") {
        if (segment.length) {
          ret.push(segment.slice(0));
        }
        segment.length = 0;
      }
      segment.push(path[i2]);
    }
    ret.push(segment.slice(0));
    return ret;
  }
  /**
   * Draw a label, which is an extended text element with support for border
   * and background. Highcharts creates a `g` element with a text and a `path`
   * or `rect` inside, to make it behave somewhat like a HTML div. Border and
   * background are set through `stroke`, `stroke-width` and `fill` attributes
   * using the {@link Highcharts.SVGElement#attr|attr} method. To update the
   * text after render, run `label.attr({ text: 'New text' })`.
   *
   * @sample highcharts/members/renderer-label-on-chart/
   *         A label on the chart
   *
   * @function Highcharts.SVGRenderer#label
   *
   * @param {string} str
   *        The initial text string or (subset) HTML to render.
   *
   * @param {number} x
   *        The x position of the label's left side.
   *
   * @param {number} [y]
   *        The y position of the label's top side or baseline, depending on
   *        the `baseline` parameter.
   *
   * @param {string} [shape='rect']
   *        The shape of the label's border/background, if any. Defaults to
   *        `rect`. Other possible values are `callout` or other shapes
   *        defined in {@link Highcharts.SVGRenderer#symbols}.
   *
   * @param {number} [anchorX]
   *        In case the `shape` has a pointer, like a flag, this is the
   *        coordinates it should be pinned to.
   *
   * @param {number} [anchorY]
   *        In case the `shape` has a pointer, like a flag, this is the
   *        coordinates it should be pinned to.
   *
   * @param {boolean} [useHTML=false]
   *        Whether to use HTML to render the label.
   *
   * @param {boolean} [baseline=false]
   *        Whether to position the label relative to the text baseline,
   *        like {@link Highcharts.SVGRenderer#text|renderer.text}, or to the
   *        upper border of the rectangle.
   *
   * @param {string} [className]
   *        Class name for the group.
   *
   * @return {Highcharts.SVGElement}
   *         The generated label.
   */
  label(str, x, y, shape, anchorX, anchorY, useHTML, baseline, className) {
    return new SVGLabel(this, str, x, y, shape, anchorX, anchorY, useHTML, baseline, className);
  }
  /**
   * Re-align all aligned elements.
   *
   * @private
   * @function Highcharts.SVGRenderer#alignElements
   */
  alignElements() {
    this.alignedObjects.forEach((el) => el.align());
  }
}
extend$1n(SVGRenderer.prototype, {
  /**
   * A pointer to the renderer's associated Element class.
   *
   * @name Highcharts.SVGRenderer#Element
   * @type {Highcharts.SVGElement}
   */
  Element: SVGElement$1,
  SVG_NS: SVG_NS$1,
  /**
   * A collection of characters mapped to HTML entities. When `useHTML` on an
   * element is true, these entities will be rendered correctly by HTML. In
   * the SVG pseudo-HTML, they need to be unescaped back to simple characters,
   * so for example `&lt;` will render as `<`.
   *
   * @example
   * // Add support for unescaping quotes
   * Highcharts.SVGRenderer.prototype.escapes['"'] = '&quot;';
   *
   * @name Highcharts.SVGRenderer#escapes
   * @type {Highcharts.Dictionary<string>}
   */
  escapes: {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    "'": "&#39;",
    // eslint-disable-line quotes
    '"': "&quot;"
  },
  /**
   * An extendable collection of functions for defining symbol paths.
   *
   * @name Highcharts.SVGRenderer#symbols
   * @type {Highcharts.SymbolDictionary}
   */
  symbols: Symbols,
  /**
   * Dummy function for plugins, called every time the renderer is updated.
   * Prior to Highcharts 5, this was used for the canvg renderer.
   *
   * @deprecated
   * @function Highcharts.SVGRenderer#draw
   */
  draw: noop$j
});
RendererRegistry$1.registerRendererType("svg", SVGRenderer, true);
const { composed: composed$y, isFirefox: isFirefox$1 } = Highcharts;
const { attr: attr$a, css: css$c, createElement: createElement$a, defined: defined$18, extend: extend$1m, getAlignFactor: getAlignFactor$8, isNumber: isNumber$13, pInt: pInt$4, pushUnique: pushUnique$y } = Utilities;
function commonSetter(value, key2, elem) {
  const style = this.div?.style || elem.style;
  SVGElement$1.prototype[`${key2}Setter`].call(this, value, key2, elem);
  if (style) {
    style[key2] = value;
  }
}
const decorateSVGGroup = (g, container) => {
  if (!g.div) {
    const className = attr$a(g.element, "class"), cssProto = g.css;
    const div = createElement$a(
      "div",
      className ? { className } : void 0,
      {
        // Add HTML specific styles
        position: "absolute",
        left: `${g.translateX || 0}px`,
        top: `${g.translateY || 0}px`,
        // Add pre-existing styles
        ...g.styles,
        // Add g attributes that correspond to CSS
        display: g.display,
        opacity: g.opacity,
        // #5075
        visibility: g.visibility
      },
      // The top group is appended to container
      g.parentGroup?.div || container
    );
    g.classSetter = (value, key2, element) => {
      element.setAttribute("class", value);
      div.className = value;
    };
    g.translateXSetter = g.translateYSetter = (value, key2) => {
      g[key2] = value;
      div.style[key2 === "translateX" ? "left" : "top"] = `${value}px`;
      g.doTransform = true;
    };
    g.opacitySetter = g.visibilitySetter = commonSetter;
    g.css = (styles) => {
      cssProto.call(g, styles);
      if (styles.cursor) {
        div.style.cursor = styles.cursor;
      }
      if (styles.pointerEvents) {
        div.style.pointerEvents = styles.pointerEvents;
      }
      return g;
    };
    g.on = function() {
      SVGElement$1.prototype.on.apply({
        element: div,
        onEvents: g.onEvents
      }, arguments);
      return g;
    };
    g.div = div;
  }
  return g.div;
};
let HTMLElement$1 = class HTMLElement2 extends SVGElement$1 {
  /**
   * Compose
   * @private
   */
  static compose(SVGRendererClass) {
    if (pushUnique$y(composed$y, this.compose)) {
      SVGRendererClass.prototype.html = function(str, x, y) {
        return new HTMLElement2(this, "span").attr({
          text: str,
          x: Math.round(x),
          y: Math.round(y)
        });
      };
    }
  }
  /* *
   *
   *  Functions
   *
   * */
  constructor(renderer, nodeName) {
    super(renderer, nodeName);
    if (HTMLElement2.useForeignObject) {
      this.foreignObject = renderer.createElement("foreignObject").attr({
        zIndex: 2
      });
    } else {
      this.css({
        position: "absolute",
        ...renderer.styledMode ? {} : {
          fontFamily: renderer.style.fontFamily,
          fontSize: renderer.style.fontSize
        }
      });
    }
    this.element.style.whiteSpace = "nowrap";
  }
  /**
   * Get the correction in X and Y positioning as the element is rotated.
   * @private
   */
  getSpanCorrection(width, baseline, alignCorrection) {
    this.xCorr = -width * alignCorrection;
    this.yCorr = -baseline;
  }
  /**
   * Apply CSS to HTML elements. This is used in text within SVG rendering.
   * @private
   */
  css(styles) {
    const { element } = this, isSettingWidth = element.tagName === "SPAN" && styles && "width" in styles, textWidth = isSettingWidth && styles.width;
    let doTransform;
    if (isSettingWidth) {
      delete styles.width;
      this.textWidth = pInt$4(textWidth) || void 0;
      doTransform = true;
    }
    if (styles?.textOverflow === "ellipsis") {
      styles.overflow = "hidden";
      styles.whiteSpace = "nowrap";
    }
    if (styles?.lineClamp) {
      styles.display = "-webkit-box";
      styles.WebkitLineClamp = styles.lineClamp;
      styles.WebkitBoxOrient = "vertical";
      styles.overflow = "hidden";
    }
    if (isNumber$13(Number(styles?.fontSize))) {
      styles.fontSize += "px";
    }
    extend$1m(this.styles, styles);
    css$c(element, styles);
    if (doTransform) {
      this.updateTransform();
    }
    return this;
  }
  /**
   * The useHTML method for calculating the bounding box based on offsets.
   * Called internally from the `SVGElement.getBBox` function and subsequently
   * rotated.
   *
   * @private
   */
  htmlGetBBox() {
    const { element } = this;
    return {
      x: element.offsetLeft,
      y: element.offsetTop,
      width: element.offsetWidth,
      height: element.offsetHeight
    };
  }
  /**
   * Batch update styles and attributes related to transform
   *
   * @private
   */
  updateTransform() {
    if (!this.added) {
      this.alignOnAdd = true;
      return;
    }
    const { element, foreignObject, oldTextWidth, renderer, rotation, rotationOriginX, rotationOriginY, scaleX, scaleY, styles: { display = "inline-block", whiteSpace }, textAlign = "left", textWidth, translateX = 0, translateY = 0, x = 0, y = 0 } = this;
    const getTextPxLength = () => {
      if (this.textPxLength) {
        return this.textPxLength;
      }
      css$c(element, {
        width: "",
        whiteSpace: whiteSpace || "nowrap"
      });
      return element.offsetWidth;
    };
    if (!foreignObject) {
      css$c(element, {
        marginLeft: `${translateX}px`,
        marginTop: `${translateY}px`
      });
    }
    if (element.tagName === "SPAN") {
      const currentTextTransform = [
        rotation,
        textAlign,
        element.innerHTML,
        textWidth,
        this.textAlign
      ].join(","), parentPadding = this.parentGroup?.padding * -1 || 0;
      let baseline;
      if (textWidth !== oldTextWidth) {
        const textPxLength = getTextPxLength(), textWidthNum = textWidth || 0, willOverWrap = element.style.textOverflow === "" && element.style.webkitLineClamp;
        if ((textWidthNum > oldTextWidth || textPxLength > textWidthNum || willOverWrap) && // Only set the width if the text is able to word-wrap,
        // or text-overflow is ellipsis (#9537)
        (/[\-\s\u00AD]/.test(element.textContent || element.innerText) || element.style.textOverflow === "ellipsis")) {
          const usePxWidth = rotation || scaleX || textPxLength > textWidthNum || // Set width to prevent over-wrapping (#22609)
          willOverWrap;
          css$c(element, {
            width: usePxWidth && isNumber$13(textWidth) ? textWidth + "px" : "auto",
            // #16261
            display,
            whiteSpace: whiteSpace || "normal"
            // #3331
          });
          this.oldTextWidth = textWidth;
        }
      }
      if (foreignObject) {
        css$c(element, {
          // Inline block must be set before we can read the offset
          // width
          display: "inline-block",
          verticalAlign: "top"
        });
        foreignObject.attr({
          width: renderer.width,
          height: renderer.height
        });
      }
      if (currentTextTransform !== this.cTT) {
        baseline = renderer.fontMetrics(element).b;
        if (defined$18(rotation) && !foreignObject && (rotation !== (this.oldRotation || 0) || textAlign !== this.oldAlign)) {
          css$c(element, {
            transform: `rotate(${rotation}deg)`,
            transformOrigin: `${parentPadding}% ${parentPadding}px`
          });
        }
        this.getSpanCorrection(
          // Avoid elem.offsetWidth if we can, it affects rendering
          // time heavily (#7656)
          !defined$18(rotation) && !this.textWidth && this.textPxLength || // #7920
          element.offsetWidth,
          baseline,
          getAlignFactor$8(textAlign)
        );
      }
      const { xCorr = 0, yCorr = 0 } = this, rotOriginX = (rotationOriginX ?? x) - xCorr - x - parentPadding, rotOriginY = (rotationOriginY ?? y) - yCorr - y - parentPadding, styles = {
        left: `${x + xCorr}px`,
        top: `${y + yCorr}px`,
        textAlign,
        transformOrigin: `${rotOriginX}px ${rotOriginY}px`
      };
      if (scaleX || scaleY) {
        styles.transform = `scale(${scaleX ?? 1},${scaleY ?? 1})`;
      }
      if (foreignObject) {
        super.updateTransform();
        if (isNumber$13(x) && isNumber$13(y)) {
          foreignObject.attr({
            x: x + xCorr,
            y: y + yCorr,
            width: element.offsetWidth + 3,
            height: element.offsetHeight,
            "transform-origin": element.getAttribute("transform-origin") || "0 0"
          });
          css$c(element, { display, textAlign });
        } else if (isFirefox$1) {
          foreignObject.attr({
            width: 0,
            height: 0
          });
        }
      } else {
        css$c(element, styles);
      }
      this.cTT = currentTextTransform;
      this.oldRotation = rotation;
      this.oldAlign = textAlign;
    }
  }
  /**
   * Add the element to a group wrapper. For HTML elements, a parallel div
   * will be created for each ancenstor SVG `g` element.
   *
   * @private
   */
  add(parentGroup) {
    const { foreignObject, renderer } = this, container = renderer.box.parentNode, parents = [];
    if (foreignObject) {
      foreignObject.add(parentGroup);
      super.add(
        // Create a body inside the foreignObject
        renderer.createElement("body").attr({ xmlns: "http://www.w3.org/1999/xhtml" }).css({
          background: "transparent",
          // 3px is to avoid clipping on the right
          margin: "0 3px 0 0"
          // For export
        }).add(foreignObject)
      );
    } else {
      let div;
      this.parentGroup = parentGroup;
      if (parentGroup) {
        div = parentGroup.div;
        if (!div) {
          let svgGroup = parentGroup;
          while (svgGroup) {
            parents.push(svgGroup);
            svgGroup = svgGroup.parentGroup;
          }
          for (const parentGroup2 of parents.reverse()) {
            div = decorateSVGGroup(parentGroup2, container);
          }
        }
      }
      (div || container).appendChild(this.element);
    }
    this.added = true;
    if (this.alignOnAdd) {
      this.updateTransform();
    }
    return this;
  }
  /**
   * Text setter
   * @private
   */
  textSetter(value) {
    if (value !== this.textStr) {
      delete this.bBox;
      delete this.oldTextWidth;
      AST.setElementHTML(this.element, value ?? "");
      this.textStr = value;
      this.doTransform = true;
    }
  }
  /**
   * Align setter
   *
   * @private
   */
  alignSetter(value) {
    this.alignValue = this.textAlign = value;
    this.doTransform = true;
  }
  /**
   * Various setters which rely on update transform
   * @private
   */
  xSetter(value, key2) {
    this[key2] = value;
    this.doTransform = true;
  }
};
const proto = HTMLElement$1.prototype;
proto.visibilitySetter = proto.opacitySetter = commonSetter;
proto.ySetter = proto.rotationSetter = proto.rotationOriginXSetter = proto.rotationOriginYSetter = proto.xSetter;
var AxisDefaults;
(function(AxisDefaults2) {
  AxisDefaults2.xAxis = {
    /**
     * When using multiple axis, the ticks of two or more opposite axes
     * will automatically be aligned by adding ticks to the axis or axes
     * with the least ticks, as if `tickAmount` were specified.
     *
     * This can be prevented by setting `alignTicks` to false. If the grid
     * lines look messy, it's a good idea to hide them for the secondary
     * axis by setting `gridLineWidth` to 0.
     *
     * If `startOnTick` or `endOnTick` in an Axis options are set to false,
     * then the `alignTicks ` will be disabled for the Axis.
     *
     * Disabled for logarithmic axes.
     *
     * @product   highcharts highstock gantt
     */
    alignTicks: true,
    /**
     * Whether to allow decimals in this axis' ticks. When counting
     * integers, like persons or hits on a web page, decimals should
     * be avoided in the labels. By default, decimals are allowed on small
     * scale axes.
     *
     * @see [minTickInterval](#xAxis.minTickInterval)
     *
     * @sample {highcharts|highstock} highcharts/yaxis/allowdecimals-true/
     *         True by default
     * @sample {highcharts|highstock} highcharts/yaxis/allowdecimals-false/
     *         False
     *
     * @type      {boolean|undefined}
     * @default   undefined
     * @since     2.0
     */
    allowDecimals: void 0,
    /**
     * When using an alternate grid color, a band is painted across the
     * plot area between every other grid line.
     *
     * @sample {highcharts} highcharts/yaxis/alternategridcolor/
     *         Alternate grid color on the Y axis
     * @sample {highstock} stock/xaxis/alternategridcolor/
     *         Alternate grid color on the Y axis
     *
     * @type      {Highcharts.ColorType}
     * @apioption xAxis.alternateGridColor
     */
    /**
     * An array defining breaks in the axis, the sections defined will be
     * left out and all the points shifted closer to each other.
     *
     * @productdesc {highcharts}
     * Requires that the broken-axis.js module is loaded.
     *
     * @sample {highcharts} highcharts/axisbreak/break-simple/
     *         Simple break
     * @sample {highcharts|highstock} highcharts/axisbreak/break-visualized/
     *         Advanced with callback
     * @sample {highstock} stock/demo/intraday-breaks/
     *         Break on nights and weekends
     *
     * @type      {Array<*>}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks
     */
    /**
     * A number indicating how much space should be left between the start
     * and the end of the break. The break size is given in axis units,
     * so for instance on a `datetime` axis, a break size of 3600000 would
     * indicate the equivalent of an hour.
     *
     * @type      {number}
     * @default   0
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.breakSize
     */
    /**
     * The axis value where the break starts. On datetime axes, this may be
     * a date string.
     *
     * @type      {number|string}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.from
     */
    /**
     * Defines an interval after which the break appears again. By default
     * the breaks do not repeat.
     *
     * @type      {number}
     * @default   0
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.repeat
     */
    /**
     * The axis value where the break ends. On datetime axes, this may be
     * a date string.
     *
     * @type      {number|string}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.to
     */
    /**
     * If categories are present for the xAxis, names are used instead of
     * numbers for that axis.
     *
     * Since Highcharts 3.0, categories can also
     * be extracted by giving each point a [name](#series.data) and setting
     * axis [type](#xAxis.type) to `category`. However, if you have multiple
     * series, best practice remains defining the `categories` array.
     *
     * Example: `categories: ['Apples', 'Bananas', 'Oranges']`
     *
     * @sample {highcharts} highcharts/demo/line-labels/
     *         With
     * @sample {highcharts} highcharts/xaxis/categories/
     *         Without
     *
     * @type      {Array<string>}
     * @product   highcharts gantt
     * @apioption xAxis.categories
     */
    /**
     * The highest allowed value for automatically computed axis extremes.
     *
     * @see [floor](#xAxis.floor)
     *
     * @sample {highcharts|highstock} highcharts/yaxis/floor-ceiling/
     *         Floor and ceiling
     *
     * @type       {number}
     * @since      4.0
     * @product    highcharts highstock gantt
     * @apioption  xAxis.ceiling
     */
    /**
     * A class name that opens for styling the axis by CSS, especially in
     * Highcharts styled mode. The class name is applied to group elements
     * for the grid, axis elements and labels.
     *
     * @sample {highcharts|highstock|highmaps} highcharts/css/axis/
     *         Multiple axes with separate styling
     *
     * @type      {string}
     * @since     5.0.0
     * @apioption xAxis.className
     */
    /**
     * Configure a crosshair that follows either the mouse pointer or the
     * hovered point.
     *
     * In styled mode, the crosshairs are styled in the
     * `.highcharts-crosshair`, `.highcharts-crosshair-thin` or
     * `.highcharts-xaxis-category` classes.
     *
     * @productdesc {highstock}
     * In Highcharts stock, by default, the crosshair is enabled on the
     * X axis and disabled on the Y axis.
     *
     * @sample {highcharts} highcharts/xaxis/crosshair-both/
     *         Crosshair on both axes
     * @sample {highstock} stock/xaxis/crosshairs-xy/
     *         Crosshair on both axes, with y axis label
     * @sample {highmaps} highcharts/xaxis/crosshair-both/
     *         Crosshair on both axes
     *
     * @declare   Highcharts.AxisCrosshairOptions
     * @type      {boolean|*}
     * @default   false
     * @since     4.1
     * @apioption xAxis.crosshair
     */
    /**
     * The value on a perpendicular axis where this axis should cross. This
     * is typically used on mathematical plots where the axes cross at 0.
     * When `crossing` is set, space will not be reserved at the sides of
     * the chart for axis labels and title, so those may be clipped. In this
     * case it is better to place the axes without the `crossing` option.
     *
     * @type      {number}
     * @sample    highcharts/xaxis/crossing
     *            Function plot with axes crossing at 0
     * @since 11.0.1
     * @apioption xAxis.crossing
     */
    /**
     * A class name for the crosshair, especially as a hook for styling.
     *
     * @type      {string}
     * @since     5.0.0
     * @apioption xAxis.crosshair.className
     */
    /**
     * The color of the crosshair. Defaults to `#cccccc` for numeric and
     * datetime axes, and `rgba(204,214,235,0.25)` for category axes, where
     * the crosshair by default highlights the whole category.
     *
     * @sample {highcharts|highstock|highmaps} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     *
     * @type      {Highcharts.ColorType}
     * @default   #cccccc
     * @since     4.1
     * @apioption xAxis.crosshair.color
     */
    /**
     * The dash style for the crosshair. See
     * [plotOptions.series.dashStyle](#plotOptions.series.dashStyle)
     * for possible values.
     *
     * @sample {highcharts|highmaps} highcharts/xaxis/crosshair-dotted/
     *         Dotted crosshair
     * @sample {highstock} stock/xaxis/crosshair-dashed/
     *         Dashed X axis crosshair
     *
     * @type      {Highcharts.DashStyleValue}
     * @default   Solid
     * @since     4.1
     * @apioption xAxis.crosshair.dashStyle
     */
    /**
     * A label on the axis next to the crosshair.
     *
     * In styled mode, the label is styled with the
     * `.highcharts-crosshair-label` class.
     *
     * @sample {highstock} stock/xaxis/crosshair-label/
     *         Crosshair labels
     * @sample {highstock} highcharts/css/crosshair-label/
     *         Style mode
     *
     * @declare   Highcharts.AxisCrosshairLabelOptions
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label
     */
    /**
     * Alignment of the label compared to the axis. Defaults to `"left"` for
     * right-side axes, `"right"` for left-side axes and `"center"` for
     * horizontal axes.
     *
     * @type      {Highcharts.AlignValue}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.align
     */
    /**
     * The background color for the label. Defaults to the related series
     * color, or `#666666` if that is not available.
     *
     * @type      {Highcharts.ColorType}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.backgroundColor
     */
    /**
     * The border color for the crosshair label
     *
     * @type      {Highcharts.ColorType}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.borderColor
     */
    /**
     * The border corner radius of the crosshair label.
     *
     * @type      {number}
     * @default   3
     * @since     2.1.10
     * @product   highstock
     * @apioption xAxis.crosshair.label.borderRadius
     */
    /**
     * The border width for the crosshair label.
     *
     * @type      {number}
     * @default   0
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.borderWidth
     */
    /**
     * Flag to enable crosshair's label.
     *
     * @sample {highstock} stock/xaxis/crosshairs-xy/
     *         Enabled label for yAxis' crosshair
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.enabled
     */
    /**
     * A format string for the crosshair label. Defaults to `{value}` for
     * numeric axes and `{value:%b %d, %Y}` for datetime axes.
     *
     * @type      {string}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.format
     */
    /**
     * Formatter function for the label text.
     *
     * @type      {Highcharts.XAxisCrosshairLabelFormatterCallbackFunction}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.formatter
     */
    /**
     * Padding inside the crosshair label.
     *
     * @type      {number}
     * @default   8
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.padding
     */
    /**
     * The shape to use for the label box.
     *
     * @type      {string}
     * @default   callout
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.shape
     */
    /**
     * Text styles for the crosshair label.
     *
     * @type      {Highcharts.CSSObject}
     * @default   {"color": "white", "fontWeight": "normal", "fontSize": "11px", "textAlign": "center"}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.style
     */
    /**
     * Whether the crosshair should snap to the point or follow the pointer
     * independent of points.
     *
     * @sample {highcharts|highstock} highcharts/xaxis/crosshair-snap-false/
     *         True by default
     * @sample {highmaps} maps/demo/latlon-advanced/
     *         Snap is false
     *
     * @type      {boolean}
     * @default   true
     * @since     4.1
     * @apioption xAxis.crosshair.snap
     */
    /**
     * The pixel width of the crosshair. Defaults to 1 for numeric or
     * datetime axes, and for one category width for category axes.
     *
     * @sample {highcharts} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     * @sample {highstock} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     * @sample {highmaps} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     *
     * @type      {number}
     * @default   1
     * @since     4.1
     * @apioption xAxis.crosshair.width
     */
    /**
     * The Z index of the crosshair. Higher Z indices allow drawing the
     * crosshair on top of the series or behind the grid lines.
     *
     * @type      {number}
     * @default   2
     * @since     4.1
     * @apioption xAxis.crosshair.zIndex
     */
    /**
     * Whether to pan axis. If `chart.panning` is enabled, the option
     * allows to disable panning on an individual axis.
     */
    panningEnabled: true,
    /**
     * The Z index for the axis group.
     *
     * @see [axis.gridZIndex](#xAxis.gridZIndex)
     * @see [axis.labels.zIndex](#xAxis.labels.zIndex)
     */
    zIndex: 2,
    /**
     * Whether to zoom axis. If `chart.zoomType` is set, the option allows
     * to disable zooming on an individual axis.
     *
     * @sample {highcharts} highcharts/xaxis/zoomenabled/
     *         Zoom enabled is false
     */
    zoomEnabled: true,
    /**
     * For a datetime axis, the scale will automatically adjust to the
     * appropriate unit. This member gives the default string
     * representations used for each unit. For intermediate values,
     * different units may be used, for example the `day` unit can be used
     * on midnight and `hour` unit be used for intermediate values on the
     * same axis.
     *
     * For an overview of the string or object configuration, see
     * [dateFormat](/class-reference/Highcharts.Time#dateFormat).
     *
     * Defaults to:
     * ```js
     * {
     *     millisecond: '%[HMSL]',
     *     second: '%[HMS]',
     *     minute: '%[HM]',
     *     hour: '%[HM]',
     *     day: '%[eb]',
     *     week: '%[eb]',
     *     month: '%[bY]',
     *     year: '%Y'
     * }
     * ```
     *
     * @sample {highcharts} highcharts/xaxis/datetimelabelformats-object/
     *         Object day format on X axis
     * @sample {highcharts} highcharts/xaxis/datetimelabelformats/
     *         String day format on X axis
     * @sample {highstock} stock/xaxis/datetimelabelformats/
     *         More information in x axis labels
     *
     * @declare Highcharts.AxisDateTimeLabelFormatsOptions
     * @product highcharts highstock gantt
     */
    dateTimeLabelFormats: {
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      millisecond: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.millisecond.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.millisecond.main
         */
        main: "%[HMSL]",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      second: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.second.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.second.main
         */
        main: "%[HMS]",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      minute: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.minute.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.minute.main
         */
        main: "%[HM]",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      hour: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.hour.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.hour.main
         */
        main: "%[HM]",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      day: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.day.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.day.main
         */
        main: "%[eb]"
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      week: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.week.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.week.main
         */
        main: "%[eb]"
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      month: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.month.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.month.main
         */
        main: "%[bY]"
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      year: {
        /**
         * @type {Array<string|Highcharts.DateTimeFormatOptions>}
         * @default undefined
         * @apioption xAxis.dateTimeLabelFormats.year.list
         */
        /**
         * @type {string|Highcharts.DateTimeFormatOptions}
         * @apioption xAxis.dateTimeLabelFormats.year.main
         */
        main: "%Y"
      }
    },
    /**
     * Whether to force the axis to end on a tick. Use this option with
     * the `maxPadding` option to control the axis end.
     *
     * @productdesc {highstock}
     * In Highcharts Stock, `endOnTick` is always `false` when the navigator
     * is enabled, to prevent jumpy scrolling. With disabled navigator
     * enabling `endOnTick` may lead to extending the xAxis to show the last
     * tick, therefore range selector buttons may not have an active state
     * if the axis gets extended.
     *
     * @sample {highcharts} highcharts/yaxis/endontick/
     *         True by default
     * @sample {highcharts} highcharts/yaxis/endontick-false/
     *         False
     * @sample {highstock} stock/demo/basic-line/
     *         True by default
     * @sample {highstock} stock/xaxis/endontick/
     *         False
     *
     * @since 1.2.0
     */
    endOnTick: false,
    /**
     * Event handlers for the axis.
     *
     * @type      {*}
     * @apioption xAxis.events
     */
    /**
     * An event fired after the breaks have rendered.
     *
     * @see [breaks](#xAxis.breaks)
     *
     * @sample {highcharts} highcharts/axisbreak/break-event/
     *         AfterBreak Event
     *
     * @type      {Highcharts.AxisEventCallbackFunction}
     * @since     4.1.0
     * @product   highcharts gantt
     * @apioption xAxis.events.afterBreaks
     */
    /**
     * As opposed to the `setExtremes` event, this event fires after the
     * final min and max values are computed and corrected for `minRange`.
     *
     * Fires when the minimum and maximum is set for the axis, either by
     * calling the `.setExtremes()` method or by selecting an area in the
     * chart. One parameter, `event`, is passed to the function, containing
     * common event information.
     *
     * The new user set minimum and maximum values can be found by
     * `event.min` and `event.max`. These reflect the axis minimum and
     * maximum in axis values. The actual data extremes are found in
     * `event.dataMin` and `event.dataMax`.
     *
     * @type      {Highcharts.AxisSetExtremesEventCallbackFunction}
     * @since     2.3
     * @context   Highcharts.Axis
     * @apioption xAxis.events.afterSetExtremes
     */
    /**
     * An event fired when a break from this axis occurs on a point.
     *
     * @see [breaks](#xAxis.breaks)
     *
     * @sample {highcharts} highcharts/axisbreak/break-visualized/
     *         Visualization of a Break
     *
     * @type      {Highcharts.AxisPointBreakEventCallbackFunction}
     * @since     4.1.0
     * @product   highcharts gantt
     * @context   Highcharts.Axis
     * @apioption xAxis.events.pointBreak
     */
    /**
     * An event fired when a point falls inside a break from this axis.
     *
     * @type      {Highcharts.AxisPointBreakEventCallbackFunction}
     * @product   highcharts highstock gantt
     * @context   Highcharts.Axis
     * @apioption xAxis.events.pointInBreak
     */
    /**
     * An event fired when a point is outside a break after zoom.
     *
     * @type      {Highcharts.AxisPointBreakEventCallbackFunction}
     * @product   highcharts highstock gantt
     * @context   Highcharts.Axis
     * @apioption xAxis.events.pointBreakOut
     */
    /**
     * Fires when the minimum and maximum is set for the axis, either by
     * calling the `.setExtremes()` method or by selecting an area in the
     * chart. One parameter, `event`, is passed to the function,
     * containing common event information.
     *
     * The new user set minimum and maximum values can be found by
     * `event.min` and `event.max`. These reflect the axis minimum and
     * maximum in data values. When an axis is zoomed all the way out from
     * the "Reset zoom" button, `event.min` and `event.max` are null, and
     * the new extremes are set based on `this.dataMin` and `this.dataMax`.
     *
     * @sample {highstock} stock/xaxis/events-setextremes/
     *         Log new extremes on x axis
     *
     * @type      {Highcharts.AxisSetExtremesEventCallbackFunction}
     * @since     1.2.0
     * @context   Highcharts.Axis
     * @apioption xAxis.events.setExtremes
     */
    /**
     * The lowest allowed value for automatically computed axis extremes.
     *
     * @see [ceiling](#yAxis.ceiling)
     *
     * @sample {highcharts} highcharts/yaxis/floor-ceiling/
     *         Floor and ceiling
     * @sample {highstock} stock/demo/lazy-loading/
     *         Prevent negative stock price on Y axis
     *
     * @type      {number}
     * @since     4.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.floor
     */
    /**
     * The dash or dot style of the grid lines. For possible values, see
     * [this demonstration](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-dashstyle-all/).
     *
     * @sample {highcharts} highcharts/yaxis/gridlinedashstyle/
     *         Long dashes
     * @sample {highstock} stock/xaxis/gridlinedashstyle/
     *         Long dashes
     *
     * @type      {Highcharts.DashStyleValue}
     * @since     1.2
     */
    gridLineDashStyle: "Solid",
    /**
     * The Z index of the grid lines.
     *
     * @sample {highcharts|highstock} highcharts/xaxis/gridzindex/
     *         A Z index of 4 renders the grid above the graph
     *
     * @product   highcharts highstock gantt
     *
     * @see [axis.zIndex](#xAxis.zIndex)
     * @see [axis.labels.zIndex](#xAxis.labels.zIndex)
     */
    gridZIndex: 1,
    /**
     * An id for the axis. This can be used after render time to get
     * a pointer to the axis object through `chart.get()`.
     *
     * @sample {highcharts} highcharts/xaxis/id/
     *         Get the object
     * @sample {highstock} stock/xaxis/id/
     *         Get the object
     *
     * @type      {string}
     * @since     1.2.0
     * @apioption xAxis.id
     */
    /**
     * The axis labels show the number or category for each tick.
     *
     * Since v8.0.0: Labels are animated in categorized x-axis with
     * updating data if `tickInterval` and `step` is set to 1.
     *
     * @productdesc {highmaps}
     * X and Y axis labels are by default disabled in Highmaps, but the
     * functionality is inherited from Highcharts and used on `colorAxis`,
     * and can be enabled on X and Y axes too.
     */
    labels: {
      /**
       * What part of the string the given position is anchored to.
       * If `left`, the left side of the string is at the axis position.
       * Can be one of `"left"`, `"center"` or `"right"`. Defaults to
       * an intelligent guess based on which side of the chart the axis
       * is on and the rotation of the label.
       *
       * @see [reserveSpace](#xAxis.labels.reserveSpace)
       *
       * @sample {highcharts} highcharts/xaxis/labels-align-left/
       *         Left
       * @sample {highcharts} highcharts/xaxis/labels-align-right/
       *         Right
       * @sample {highcharts} highcharts/xaxis/labels-reservespace-true/
       *         Left-aligned labels on a vertical category axis
       *
       * @type      {Highcharts.AlignValue}
       * @apioption xAxis.labels.align
       */
      /**
       * Whether to allow the axis labels to overlap. When false,
       * overlapping labels are hidden.
       *
       * @sample {highcharts} highcharts/xaxis/labels-allowoverlap-true/
       *         X axis labels overlap enabled
       *
       * @type      {boolean}
       * @default   false
       * @apioption xAxis.labels.allowOverlap
       */
      /**
       * For horizontal axes, the allowed degrees of label rotation
       * to prevent overlapping labels. If there is enough space,
       * labels are not rotated. As the chart gets narrower, it
       * will start rotating the labels -45 degrees, then remove
       * every second label and try again with rotations 0 and -45 etc.
       * Set it to `undefined` to disable rotation, which will
       * cause the labels to word-wrap if possible. Defaults to `[-45]``
       * on bottom and top axes, `undefined` on left and right axes.
       *
       * @sample {highcharts|highstock} highcharts/xaxis/labels-autorotation-default/
       *         Default auto rotation of 0 or -45
       * @sample {highcharts|highstock} highcharts/xaxis/labels-autorotation-0-90/
       *         Custom graded auto rotation
       *
       * @type      {Array<number>}
       * @default   undefined
       * @since     4.1.0
       * @product   highcharts highstock gantt
       * @apioption xAxis.labels.autoRotation
       */
      /**
       * When each category width is more than this many pixels, we don't
       * apply auto rotation. Instead, we lay out the axis label with word
       * wrap. A lower limit makes sense when the label contains multiple
       * short words that don't extend the available horizontal space for
       * each label.
       *
       * @sample {highcharts} highcharts/xaxis/labels-autorotationlimit/
       *         Lower limit
       *
       * @since     4.1.5
       * @product   highcharts gantt
       */
      autoRotationLimit: 80,
      /**
       * The label's pixel distance from the perimeter of the plot area.
       * On cartesian charts, this is overridden if the `labels.y` setting
       * is set.
       *
       * @sample {highcharts} highcharts/yaxis/labels-distance/
       *         Polar chart, labels centered under the arc
       *
       * @type      {number}
       * @product   highcharts gantt
       */
      distance: 15,
      /**
       * Enable or disable the axis labels.
       *
       * @sample {highcharts} highcharts/xaxis/labels-enabled/
       *         X axis labels disabled
       * @sample {highstock} stock/xaxis/labels-enabled/
       *         X axis labels disabled
       *
       */
      enabled: true,
      /**
       * A format string for the axis label. The context is available as
       * format string variables. For example, you can use `{text}` to
       * insert the default formatted text. The recommended way of adding
       * units for the label is using `text`, for example `{text} km`.
       *
       * To add custom numeric or datetime formatting, use `{value}` with
       * formatting, for example `{value:.1f}` or `{value:%Y-%m-%d}`.
       *
       * See
       * [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
       * for more examples of formatting.
       *
       * The default value is not specified due to the dynamic
       * nature of the default implementation.
       *
       * @sample {highcharts|highstock} highcharts/yaxis/labels-format/
       *         Add units to Y axis label
       * @sample {highcharts} highcharts/xaxis/labels-format-linked/
       *         Linked category names
       * @sample {highcharts} highcharts/xaxis/labels-format-custom/
       *         Custom number format
       *
       * @type      {string}
       * @since     3.0
       * @apioption xAxis.labels.format
       */
      /**
       * Callback JavaScript function to format the label. The value
       * is given by `this.value`. Additional properties for `this` are
       * `axis`, `chart`, `isFirst`, `isLast` and `text` which holds the
       * value of the default formatter.
       *
       * Defaults to a built in function returning a formatted string
       * depending on whether the axis is `category`, `datetime`,
       * `numeric` or other.
       *
       * @sample {highcharts} highcharts/xaxis/labels-formatter-linked/
       *         Linked category names
       * @sample {highcharts} highcharts/xaxis/labels-formatter-extended/
       *         Modified numeric labels
       * @sample {highstock} stock/xaxis/labels-formatter/
       *         Added units on Y axis
       *
       * @type      {Highcharts.AxisLabelsFormatterCallbackFunction}
       * @apioption xAxis.labels.formatter
       */
      /**
       * The number of pixels to indent the labels per level in a treegrid
       * axis.
       *
       * @sample gantt/treegrid-axis/demo
       *         Indentation 10px by default.
       * @sample gantt/treegrid-axis/indentation-0px
       *         Indentation set to 0px.
       *
       * @product gantt
       */
      indentation: 10,
      /**
       * Horizontal axis only. When `staggerLines` is not set,
       * `maxStaggerLines` defines how many lines the axis is allowed to
       * add to automatically avoid overlapping X labels. Set to `1` to
       * disable overlap detection.
       *
       * @deprecated
       * @type      {number}
       * @default   5
       * @since     1.3.3
       * @apioption xAxis.labels.maxStaggerLines
       */
      /**
       * How to handle overflowing labels on horizontal axis. If set to
       * `"allow"`, it will not be aligned at all. By default it
       * `"justify"` labels inside the chart area. If there is room to
       * move it, it will be aligned to the edge, else it will be removed.
       *
       * @since      2.2.5
       * @validvalue ["allow", "justify"]
       */
      overflow: "justify",
      /**
       * The pixel padding for axis labels, to ensure white space between
       * them. Defaults to 4 for horizontal axes, 1 for vertical.
       *
       * @type      {number}
       * @default   undefined
       * @product   highcharts gantt
       * @apioption xAxis.labels.padding
       */
      /**
       * Whether to reserve space for the labels. By default, space is
       * reserved for the labels in these cases:
       *
       * * On all horizontal axes.
       * * On vertical axes if `label.align` is `right` on a left-side
       * axis or `left` on a right-side axis.
       * * On vertical axes if `label.align` is `center`.
       *
       * This can be turned off when for example the labels are rendered
       * inside the plot area instead of outside.
       *
       * @see [labels.align](#xAxis.labels.align)
       *
       * @sample {highcharts} highcharts/xaxis/labels-reservespace/
       *         No reserved space, labels inside plot
       * @sample {highcharts} highcharts/xaxis/labels-reservespace-true/
       *         Left-aligned labels on a vertical category axis
       *
       * @type      {boolean}
       * @since     4.1.10
       * @product   highcharts highstock gantt
       * @apioption xAxis.labels.reserveSpace
       */
      reserveSpace: void 0,
      /**
       * Rotation of the labels in degrees. When `undefined`, the
       * `autoRotation` option takes precedence.
       *
       * @sample {highcharts} highcharts/xaxis/labels-rotation/
       *         X axis labels rotated 90°
       *
       * @type      {number}
       * @default   0
       * @apioption xAxis.labels.rotation
       */
      rotation: void 0,
      /**
       * Horizontal axes only. The number of lines to spread the labels
       * over to make room or tighter labels. 0 disables staggering.
       *
       * @sample {highcharts} highcharts/xaxis/labels-staggerlines/
       *         Show labels over two lines
       * @sample {highstock} stock/xaxis/labels-staggerlines/
       *         Show labels over two lines
       *
       * @since     2.1
       */
      staggerLines: 0,
      /**
       * To show only every _n_'th label on the axis, set the step to _n_.
       * Setting the step to 2 shows every other label.
       *
       * By default, when 0, the step is calculated automatically to avoid
       * overlap. To prevent this, set it to 1\. This usually only
       * happens on a category axis, and is often a sign that you have
       * chosen the wrong axis type.
       *
       * Read more at
       * [Axis docs](https://www.highcharts.com/docs/chart-concepts/axes)
       * => What axis should I use?
       *
       * @sample {highcharts} highcharts/xaxis/labels-step/
       *         Showing only every other axis label on a categorized
       *         x-axis
       * @sample {highcharts} highcharts/xaxis/labels-step-auto/
       *         Auto steps on a category axis
       *
       * @since     2.1
       */
      step: 0,
      /**
       * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
       * to render the labels.
       */
      useHTML: false,
      /**
       * The x position offset of all labels relative to the tick
       * positions on the axis. Overrides the `labels.distance` option.
       *
       * @type      {number}
       * @apioption xAxis.labels.x
       */
      /**
       * The y position offset of all labels relative to the tick
       * positions on the axis. Overrides the `labels.distance` option.
       *
       * @sample {highcharts} highcharts/xaxis/labels-x/
       *         X axis labels placed on grid lines
       *
       * @type      {number}
       * @apioption xAxis.labels.y
       */
      /**
       * The Z index for the axis labels.
       *
       * @see [axis.zIndex](#xAxis.zIndex)
       * @see [axis.gridZIndex](#xAxis.gridZIndex)
       */
      zIndex: 7,
      /**
       * CSS styles for the label. Use `lineClamp` to control wrapping of
       * category labels. Use `textOverflow: 'none'` to prevent ellipsis
       * (dots).
       *
       * In styled mode, the labels are styled with the
       * `.highcharts-axis-labels` class.
       *
       * @sample {highcharts} highcharts/xaxis/labels-style/
       *         Red X axis labels
       *
       * @type      {Highcharts.CSSObject}
       */
      style: {
        /** @internal */
        color: "#333333",
        /** @internal */
        cursor: "default",
        /**
         * @type {number|string}
         */
        fontSize: "0.8em",
        /** @internal */
        textOverflow: "ellipsis"
      }
    },
    /**
     * The left position as the horizontal axis. If it's a number, it is
     * interpreted as pixel position relative to the chart.
     *
     * Since Highcharts v5.0.13: If it's a percentage string, it is
     * interpreted as percentages of the plot width, offset from plot area
     * left.
     *
     * @sample {highcharts} highcharts/xaxis/axis-position-properties
     *         Different axis position properties
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.left
     */
    /**
     * The top position as the vertical axis. If it's a number, it is
     * interpreted as pixel position relative to the chart.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted
     * as percentages of the plot height, offset from plot area top.
     *
     * @sample {highcharts} highcharts/xaxis/axis-position-properties
     *         Different axis position properties
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.top
     */
    /**
     * Index of another axis that this axis is linked to. When an axis is
     * linked to a master axis, it will take the same extremes as
     * the master, but as assigned by min or max or by setExtremes.
     * It can be used to show additional info, or to ease reading the
     * chart by duplicating the scales.
     *
     * @sample {highcharts} highcharts/xaxis/linkedto/
     *         Different string formats of the same date
     * @sample {highcharts} highcharts/yaxis/linkedto/
     *         Y values on both sides
     *
     * @type      {number}
     * @since     2.0.2
     * @product   highcharts highstock gantt
     * @apioption xAxis.linkedTo
     */
    /**
     * The maximum value of the axis. If `undefined`, the max value is
     * automatically calculated.
     *
     * If a datetime string is passed, it is parsed into epoch time
     * according to the time zone given in [time.timezone](#time.timezone).
     *
     * If the [endOnTick](#yAxis.endOnTick) option is true, the `max` value
     * might be rounded up.
     *
     * If a [tickAmount](#yAxis.tickAmount) is set, the axis may be extended
     * beyond the set max in order to reach the given number of ticks. The
     * same may happen in a chart with multiple axes, determined by [chart.
     * alignTicks](#chart), where a `tickAmount` is applied internally.
     *
     * @sample {highcharts} highcharts/yaxis/max-200/
     *         Y axis max of 200
     * @sample {highcharts} highcharts/yaxis/max-logarithmic/
     *         Y axis max on logarithmic axis
     * @sample {highstock} stock/xaxis/min-max/
     *         Fixed min and max on X axis
     *
     * @type      {number|string|null}
     * @apioption xAxis.max
     */
    /**
     * Padding of the max value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the highest data value to appear on the edge
     * of the plot area. When the axis' `max` option is set or a max extreme
     * is set using `axis.setExtremes()`, the maxPadding will be ignored.
     *
     * @productdesc {highstock}
     * For an [ordinal](#xAxis.ordinal) axis, `minPadding` and `maxPadding`
     * are ignored. Use [overscroll](#xAxis.overscroll) instead.
     *
     * @sample {highcharts} highcharts/yaxis/maxpadding/
     *         Max padding of 0.25 on y axis
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
     *         Add some padding
     *
     * @default   {highcharts} 0.01
     * @default   {highstock|highmaps} 0
     * @since     1.2.0
     */
    maxPadding: 0.01,
    /**
     * Deprecated. Use `minRange` instead.
     *
     * @deprecated
     * @type      {number}
     * @product   highcharts highstock
     * @apioption xAxis.maxZoom
     */
    /**
     * The minimum value of the axis. If `undefined`, the min value is
     * automatically calculated.
     *
     * If a datetime string is passed, it is parsed into epoch time
     * according to the time zone given in [time.timezone](#time.timezone).
     *
     * If the [startOnTick](#yAxis.startOnTick) option is true (default),
     * the `min` value might be rounded down.
     *
     * The automatically calculated minimum value is also affected by
     * [floor](#yAxis.floor), [softMin](#yAxis.softMin),
     * [minPadding](#yAxis.minPadding), [minRange](#yAxis.minRange)
     * as well as [series.threshold](#plotOptions.series.threshold)
     * and [series.softThreshold](#plotOptions.series.softThreshold).
     *
     * @sample {highcharts} highcharts/yaxis/min-startontick-false/
     *         -50 with startOnTick to false
     * @sample {highcharts} highcharts/yaxis/min-startontick-true/
     *         -50 with startOnTick true by default
     * @sample {highstock} stock/xaxis/min-max/
     *         Set min and max on X axis
     *
     * @type      {number|string|null}
     * @apioption xAxis.min
     */
    /**
     * The dash or dot style of the minor grid lines. For possible values,
     * see [this demonstration](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-dashstyle-all/).
     *
     * @sample {highcharts} highcharts/yaxis/minorgridlinedashstyle/
     *         Long dashes on minor grid lines
     * @sample {highstock} stock/xaxis/minorgridlinedashstyle/
     *         Long dashes on minor grid lines
     *
     * @type      {Highcharts.DashStyleValue}
     * @since     1.2
     */
    minorGridLineDashStyle: "Solid",
    /**
     * Specific tick interval in axis units for the minor ticks. On a linear
     * axis, if `"auto"`, the minor tick interval is calculated as a fifth
     * of the tickInterval. If `undefined`, minor ticks are not shown.
     *
     * On logarithmic axes, the unit is the power of the value. For example,
     * setting the minorTickInterval to 1 puts one tick on each of 0.1, 1,
     * 10, 100 etc. Setting the minorTickInterval to 0.1 produces 9 ticks
     * between 1 and 10, 10 and 100 etc.
     *
     * If user settings dictate minor ticks to become too dense, they don't
     * make sense, and will be ignored to prevent performance problems.
     *
     * @sample {highcharts} highcharts/yaxis/minortickinterval-null/
     *         Undefined by default
     * @sample {highcharts} highcharts/yaxis/minortickinterval-5/ 5 units
     * @sample {highcharts} highcharts/yaxis/minortickinterval-log-auto/
     *         "auto"
     * @sample {highcharts} highcharts/yaxis/minortickinterval-log/ 0.1
     * @sample {highstock} stock/demo/basic-line/ Null by default
     * @sample {highstock} stock/xaxis/minortickinterval-auto/ "auto"
     *
     * @type      {number|'auto'}
     * @apioption xAxis.minorTickInterval
     */
    /**
     * The pixel length of the minor tick marks.
     *
     * @sample {highcharts} highcharts/yaxis/minorticklength/
     *         10px on Y axis
     * @sample {highstock} stock/xaxis/minorticks/
     *         10px on Y axis
     */
    minorTickLength: 2,
    /**
     * The position of the minor tick marks relative to the axis line.
     *  Can be one of `inside` and `outside`.
     *
     * @sample {highcharts} highcharts/yaxis/minortickposition-outside/
     *         Outside by default
     * @sample {highcharts} highcharts/yaxis/minortickposition-inside/
     *         Inside
     * @sample {highstock} stock/xaxis/minorticks/
     *         Inside
     *
     * @validvalue ["inside", "outside"]
     */
    minorTickPosition: "outside",
    /**
     * Enable or disable minor ticks. The interval between the minor ticks
     * can be controlled either by the
     * [minorTicksPerMajor](#xAxis.minorTicksPerMajor) setting, or as an
     * absolute [minorTickInterval](#xAxis.minorTickInterval) value.
     *
     * On a logarithmic axis, minor ticks are laid out based on a best
     * guess, attempting to enter an approximate number of minor ticks
     * between each major tick based on
     * [minorTicksPerMajor](#xAxis.minorTicksPerMajor).
     *
     * Prior to v6.0.0, ticks were enabled in auto layout by setting
     * `minorTickInterval` to `"auto"`.
     *
     * @productdesc {highcharts} On axes using
     * [categories](#xAxis.categories), minor ticks are not supported.
     *
     * @sample {highcharts} highcharts/yaxis/minorticks-true/ Enabled on
     *         linear Y axis
     *
     * @type      {boolean}
     * @default   false
     * @since     6.0.0
     * @apioption xAxis.minorTicks
     */
    /**
     * The number of minor ticks per major tick. Works for `linear`,
     * `logarithmic` and `datetime` axes.
     *
     * @sample {highcharts} highcharts/yaxis/minortickspermajor/
     *         2 minor ticks per major tick on Y axis
     *
     * @since  11.0.0
     *
     * @type {number}
     */
    minorTicksPerMajor: 5,
    /**
     * The pixel width of the minor tick mark.
     *
     * @sample {highcharts} highcharts/yaxis/minortickwidth/
     *         3px width
     * @sample {highstock} stock/xaxis/minorticks/
     *         1px width
     *
     * @type      {number}
     * @default   0
     * @apioption xAxis.minorTickWidth
     */
    /**
     * Padding of the min value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the lowest data value to appear on the edge
     * of the plot area. When the axis' `min` option is set or a min extreme
     * is set using `axis.setExtremes()`, the minPadding will be ignored.
     *
     * @productdesc {highstock}
     * For an [ordinal](#xAxis.ordinal) axis, `minPadding` and `maxPadding`
     * are ignored. Use [overscroll](#xAxis.overscroll) instead.
     *
     * @sample {highcharts} highcharts/yaxis/minpadding/
     *         Min padding of 0.2
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
     *         Add some padding
     *
     * @default    {highcharts} 0.01
     * @default    {highstock|highmaps} 0
     * @since      1.2.0
     * @product    highcharts highstock gantt
     */
    minPadding: 0.01,
    /**
     * The minimum range to display on this axis. The entire axis will not
     * be allowed to span over a smaller interval than this. For example,
     * for a datetime axis the main unit is milliseconds. If minRange is
     * set to 3600000, you can't zoom in more than to one hour.
     *
     * The default minRange for the x axis is five times the smallest
     * interval between any of the data points.
     *
     * On a logarithmic axis, the unit for the minimum range is the power.
     * So a minRange of 1 means that the axis can be zoomed to 10-100,
     * 100-1000, 1000-10000 etc.
     *
     * **Note**: The `minPadding`, `maxPadding`, `startOnTick` and
     * `endOnTick` settings also affect how the extremes of the axis
     * are computed.
     *
     * @sample {highcharts} highcharts/xaxis/minrange/
     *         Minimum range of 5
     * @sample {highstock} stock/xaxis/minrange/
     *         Max zoom of 6 months overrides user selections
     *
     * @type      {number}
     * @apioption xAxis.minRange
     */
    /**
     * The minimum tick interval allowed in axis values. For example on
     * zooming in on an axis with daily data, this can be used to prevent
     * the axis from showing hours. Defaults to the closest distance between
     * two points on the axis.
     *
     * @type      {number}
     * @since     2.3.0
     * @apioption xAxis.minTickInterval
     */
    /**
     * The distance in pixels from the plot area to the axis line.
     * A positive offset moves the axis with it's line, labels and ticks
     * away from the plot area. This is typically used when two or more
     * axes are displayed on the same side of the plot. With multiple
     * axes the offset is dynamically adjusted to avoid collision, this
     * can be overridden by setting offset explicitly.
     *
     * @sample {highcharts} highcharts/yaxis/offset/
     *         Y axis offset of 70
     * @sample {highcharts} highcharts/yaxis/offset-centered/
     *         Axes positioned in the center of the plot
     * @sample {highstock} stock/xaxis/offset/
     *         Y axis offset by 70 px
     *
     * @type {number}
     */
    offset: void 0,
    /**
     * Whether to display the axis on the opposite side of the normal. The
     * normal is on the left side for vertical axes and bottom for
     * horizontal, so the opposite sides will be right and top respectively.
     * This is typically used with dual or multiple axes.
     *
     * @sample {highcharts} highcharts/yaxis/opposite/
     *         Secondary Y axis opposite
     * @sample {highstock} stock/xaxis/opposite/
     *         Y axis on left side
     *
     * @default   {highcharts|highstock|highmaps} false
     * @default   {gantt} true
     * @type      Boolean
     * @apioption xAxis.opposite
     */
    /**
     * In an ordinal axis, the points are equally spaced in the chart
     * regardless of the actual time or x distance between them. This means
     * that missing data periods (e.g. nights or weekends for a stock chart)
     * will not take up space in the chart.
     * Having `ordinal: false` will show any gaps created by the `gapSize`
     * setting proportionate to their duration.
     *
     * In stock charts the X axis is ordinal by default, unless
     * the boost module is used and at least one of the series' data length
     * exceeds the [boostThreshold](#series.line.boostThreshold).
     *
     * For an ordinal axis, `minPadding` and `maxPadding` are ignored. Use
     * [overscroll](#xAxis.overscroll) instead.
     *
     * @sample {highstock} stock/xaxis/ordinal-true/
     *         True by default
     * @sample {highstock} stock/xaxis/ordinal-false/
     *         False
     *
     * @see [overscroll](#xAxis.overscroll)
     *
     * @type      {boolean}
     * @default   true
     * @since     1.1
     * @product   highstock
     * @apioption xAxis.ordinal
     */
    /**
     * Additional range on the right side of the xAxis. Works similar to
     * `xAxis.maxPadding`, but the value is set in terms of axis values,
     * percentage or pixels.
     *
     * If it's a number, it is interpreted as axis values, which in a
     * datetime axis equals milliseconds.
     *
     * If it's a percentage string, is interpreted as percentages of axis
     * length. An overscroll of 50% will make a 100px axis 50px longer.
     *
     * If it's a pixel string, it is interpreted as a fixed pixel value, but
     * limited to 90% of the axis length.
     *
     * @sample {highstock} stock/xaxis/overscroll/ One minute overscroll
     *         with live data
     * @sample {highstock} stock/xaxis/overscroll-percent/ Overscroll set in
     *         percentage
     * @sample {highstock} stock/xaxis/overscroll-pixel/ Overscroll set in
     *         pixels
     *
     * @type      {number | string}
     * @default   0
     * @since     6.0.0
     * @product   highstock
     * @apioption xAxis.overscroll
     */
    /**
     * Refers to the index in the [panes](#panes) array. Used for circular
     * gauges and polar charts. When the option is not set then first pane
     * will be used.
     *
     * @sample highcharts/demo/gauge-vu-meter
     *         Two gauges with different center
     *
     * @type      {number}
     * @product   highcharts
     * @apioption xAxis.pane
     */
    /**
     * The zoomed range to display when only defining one or none of `min`
     * or `max`. For example, to show the latest month, a range of one month
     * can be set.
     *
     * @sample {highstock} stock/xaxis/range/
     *         Setting a zoomed range when the rangeSelector is disabled
     *
     * @type      {number}
     * @product   highstock
     * @apioption xAxis.range
     */
    /**
     * Whether to reverse the axis so that the highest number is closest
     * to the origin. If the chart is inverted, the x axis is reversed by
     * default.
     *
     * @sample {highcharts} highcharts/yaxis/reversed/
     *         Reversed Y axis
     * @sample {highstock} stock/xaxis/reversed/
     *         Reversed Y axis
     *
     * @type      {boolean}
     * @default   undefined
     * @apioption xAxis.reversed
     */
    reversed: void 0,
    /**
     * This option determines how stacks should be ordered within a group.
     * For example reversed xAxis also reverses stacks, so first series
     * comes last in a group. To keep order like for non-reversed xAxis
     * enable this option.
     *
     * @sample {highcharts} highcharts/xaxis/reversedstacks/
     *         Reversed stacks comparison
     * @sample {highstock} highcharts/xaxis/reversedstacks/
     *         Reversed stacks comparison
     *
     * @since     6.1.1
     * @product   highcharts highstock
     */
    reversedStacks: false,
    /**
     * An optional scrollbar to display on the X axis in response to
     * limiting the minimum and maximum of the axis values.
     *
     * In styled mode, all the presentational options for the scrollbar are
     * replaced by the classes `.highcharts-scrollbar-thumb`,
     * `.highcharts-scrollbar-arrow`, `.highcharts-scrollbar-button`,
     * `.highcharts-scrollbar-rifles` and `.highcharts-scrollbar-track`.
     *
     * @sample {highstock} stock/yaxis/heatmap-scrollbars/
     *         Heatmap with both scrollbars
     *
     * @extends   scrollbar
     * @since     4.2.6
     * @product   highstock
     * @apioption xAxis.scrollbar
     */
    /**
     * Whether to show the axis line and title when the axis has no data.
     *
     * @sample {highcharts} highcharts/yaxis/showempty/
     *         When clicking the legend to hide series, one axis preserves
     *         line and title, the other doesn't
     * @sample {highstock} highcharts/yaxis/showempty/
     *         When clicking the legend to hide series, one axis preserves
     *         line and title, the other doesn't
     *
     * @since     1.1
     */
    showEmpty: true,
    /**
     * Whether to show the first tick label.
     *
     * @sample {highcharts} highcharts/xaxis/showfirstlabel-false/
     *         Set to false on X axis
     * @sample {highstock} stock/xaxis/showfirstlabel/
     *         Labels below plot lines on Y axis
     */
    showFirstLabel: true,
    /**
     * Whether to show the last tick label. Defaults to `true` on cartesian
     * charts, and `false` on polar charts.
     *
     * @sample {highcharts} highcharts/xaxis/showlastlabel-true/
     *         Set to true on X axis
     * @sample {highstock} stock/xaxis/showfirstlabel/
     *         Labels below plot lines on Y axis
     *
     * @type    {boolean}
     * @default undefined
     * @product highcharts highstock gantt
     */
    showLastLabel: true,
    /**
     * A soft maximum for the axis. If the series data maximum is less than
     * this, the axis will stay at this maximum, but if the series data
     * maximum is higher, the axis will flex to show all data.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption xAxis.softMax
     */
    /**
     * A soft minimum for the axis. If the series data minimum is greater
     * than this, the axis will stay at this minimum, but if the series
     * data minimum is lower, the axis will flex to show all data.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption xAxis.softMin
     */
    /**
     * For datetime axes, this decides where to put the tick between weeks.
     *  0 = Sunday, 1 = Monday.
     *
     * @sample {highcharts} highcharts/xaxis/startofweek-monday/
     *         Monday by default
     * @sample {highcharts} highcharts/xaxis/startofweek-sunday/
     *         Sunday
     * @sample {highstock} stock/xaxis/startofweek-1
     *         Monday by default
     * @sample {highstock} stock/xaxis/startofweek-0
     *         Sunday
     *
     * @product highcharts highstock gantt
     */
    startOfWeek: 1,
    /**
     * Whether to force the axis to start on a tick. Use this option with
     * the `minPadding` option to control the axis start.
     *
     * @productdesc {highstock}
     * In Highcharts Stock, `startOnTick` is always `false` when
     * the navigator is enabled, to prevent jumpy scrolling.
     *
     * @sample {highcharts} highcharts/xaxis/startontick-false/
     *         False by default
     * @sample {highcharts} highcharts/xaxis/startontick-true/
     *         True
     *
     * @since 1.2.0
     */
    startOnTick: false,
    /**
     * The amount of ticks to draw on the axis. This opens up for aligning
     * the ticks of multiple charts or panes within a chart. This option
     * overrides the `tickPixelInterval` option.
     *
     * This option only has an effect on linear axes. Datetime, logarithmic
     * or category axes are not affected.
     *
     * @sample {highcharts} highcharts/yaxis/tickamount/
     *         8 ticks on Y axis
     * @sample {highstock} highcharts/yaxis/tickamount/
     *         8 ticks on Y axis
     *
     * @type      {number}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.tickAmount
     */
    /**
     * The interval of the tick marks in axis units. When `undefined`, the
     * tick interval is computed to approximately follow the
     * [tickPixelInterval](#xAxis.tickPixelInterval) on linear and datetime
     * axes. On categorized axes, a `undefined` tickInterval will default to
     * 1, one category. Note that datetime axes are based on milliseconds,
     * so for example an interval of one day is expressed as
     * `24 * 3600 * 1000`.
     *
     * On logarithmic axes, the tickInterval is based on powers, so a
     * tickInterval of 1 means one tick on each of 0.1, 1, 10, 100 etc. A
     * tickInterval of 2 means a tick of 0.1, 10, 1000 etc. A tickInterval
     * of 0.2 puts a tick on 0.1, 0.2, 0.4, 0.6, 0.8, 1, 2, 4, 6, 8, 10, 20,
     * 40 etc.
     *
     *
     * If the tickInterval is too dense for labels to be drawn, Highcharts
     * may remove ticks.
     *
     * If the chart has multiple axes, the [alignTicks](#chart.alignTicks)
     * option may interfere with the `tickInterval` setting.
     *
     * @see [tickPixelInterval](#xAxis.tickPixelInterval)
     * @see [tickPositions](#xAxis.tickPositions)
     * @see [tickPositioner](#xAxis.tickPositioner)
     *
     * @sample {highcharts} highcharts/xaxis/tickinterval-5/
     *         Tick interval of 5 on a linear axis
     * @sample {highstock} stock/xaxis/tickinterval/
     *         Tick interval of 0.01 on Y axis
     *
     * @type      {number}
     * @apioption xAxis.tickInterval
     */
    /**
     * The pixel length of the main tick marks.
     *
     * @sample {highcharts} highcharts/xaxis/ticklength/
     *         20 px tick length on the X axis
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     */
    tickLength: 10,
    /**
     * If tickInterval is `null` this option sets the approximate pixel
     * interval of the tick marks. Not applicable to categorized axis.
     *
     * The tick interval is also influenced by the [minTickInterval](
     * #xAxis.minTickInterval) option, that, by default prevents ticks from
     * being denser than the data points.
     *
     * @see [tickInterval](#xAxis.tickInterval)
     * @see [tickPositioner](#xAxis.tickPositioner)
     * @see [tickPositions](#xAxis.tickPositions)
     *
     * @sample {highcharts} highcharts/xaxis/tickpixelinterval-50/
     *         50 px on X axis
     * @sample {highstock} stock/xaxis/tickpixelinterval/
     *         200 px on X axis
     */
    tickPixelInterval: 100,
    /**
     * For categorized axes only. If `on` the tick mark is placed in the
     * center of the category, if `between` the tick mark is placed between
     * categories. The default is `between` if the `tickInterval` is 1, else
     * `on`. In order to render tick marks on a category axis it is necessary
     * to provide a [tickWidth](#xAxis.tickWidth).
     *
     * @sample {highcharts} highcharts/xaxis/tickmarkplacement-between/
     *         "between" by default
     * @sample {highcharts} highcharts/xaxis/tickmarkplacement-on/
     *         "on"
     *
     * @product    highcharts gantt
     * @validvalue ["on", "between"]
     */
    tickmarkPlacement: "between",
    /**
     * The position of the major tick marks relative to the axis line.
     * Can be one of `inside` and `outside`.
     *
     * @sample {highcharts} highcharts/xaxis/tickposition-outside/
     *         "outside" by default
     * @sample {highcharts} highcharts/xaxis/tickposition-inside/
     *         "inside"
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     *
     * @validvalue ["inside", "outside"]
     */
    tickPosition: "outside",
    /**
     * A callback function returning array defining where the ticks are
     * laid out on the axis. This overrides the default behaviour of
     * [tickPixelInterval](#xAxis.tickPixelInterval) and [tickInterval](
     * #xAxis.tickInterval). The automatic tick positions are accessible
     * through `this.tickPositions` and can be modified by the callback.
     *
     * @see [tickPositions](#xAxis.tickPositions)
     *
     * @sample {highcharts} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     * @sample {highstock} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     *
     * @type      {Highcharts.AxisTickPositionerCallbackFunction}
     * @apioption xAxis.tickPositioner
     */
    /**
     * An array defining where the ticks are laid out on the axis. This
     * overrides the default behaviour of [tickPixelInterval](
     * #xAxis.tickPixelInterval) and [tickInterval](#xAxis.tickInterval).
     *
     * @see [tickPositioner](#xAxis.tickPositioner)
     *
     * @sample {highcharts} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     * @sample {highstock} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     *
     * @type      {Array<number>}
     * @apioption xAxis.tickPositions
     */
    /**
     * The pixel width of the major tick marks. Defaults to 0 on category
     * axes, otherwise 1.
     *
     * In styled mode, the stroke width is given in the `.highcharts-tick`
     * class, but in order for the element to be generated on category axes,
     * the option must be explicitly set to 1.
     *
     * @sample {highcharts} highcharts/xaxis/tickwidth/
     *         10 px width
     * @sample {highcharts} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     * @sample {highstock} highcharts/css/axis-grid/
     *         Styled mode
     *
     * @type      {undefined|number}
     * @default   {highstock} 1
     * @default   {highmaps} 0
     * @apioption xAxis.tickWidth
     */
    /**
     * The axis title, showing next to the axis line.
     *
     * @productdesc {highmaps}
     * In Highmaps, the axis is hidden by default, but adding an axis title
     * is still possible. X axis and Y axis titles will appear at the bottom
     * and left by default.
     */
    title: {
      /**
       * Alignment of the title relative to the axis values. Possible
       * values are "low", "middle" or "high".
       *
       * @sample {highcharts} highcharts/xaxis/title-align-low/
       *         "low"
       * @sample {highcharts} highcharts/xaxis/title-align-center/
       *         "middle" by default
       * @sample {highcharts} highcharts/xaxis/title-align-high/
       *         "high"
       * @sample {highcharts} highcharts/yaxis/title-offset/
       *         Place the Y axis title on top of the axis
       * @sample {highstock} stock/xaxis/title-align/
       *         Aligned to "high" value
       *
       * @type {Highcharts.AxisTitleAlignValue}
       */
      align: "middle",
      /**
       * Deprecated. Set the `text` to `undefined` to disable the title.
       *
       * @deprecated
       * @type      {boolean}
       * @product   highcharts
       * @apioption xAxis.title.enabled
       */
      /**
       * The pixel distance between the axis labels or line and the title.
       * Defaults to 0 for horizontal axes, 10 for vertical
       *
       * @sample {highcharts} highcharts/xaxis/title-margin/
       *         Y axis title margin of 60
       *
       * @type      {number}
       * @apioption xAxis.title.margin
       */
      /**
       * The distance of the axis title from the axis line. By default,
       * this distance is computed from the offset width of the labels,
       * the labels' distance from the axis and the title's margin.
       * However when the offset option is set, it overrides all this.
       *
       * @sample {highcharts} highcharts/yaxis/title-offset/
       *         Place the axis title on top of the axis
       * @sample {highstock} highcharts/yaxis/title-offset/
       *         Place the axis title on top of the Y axis
       *
       * @type      {number}
       * @since     2.2.0
       * @apioption xAxis.title.offset
       */
      /**
       * Whether to reserve space for the title when laying out the axis.
       *
       * @type      {boolean}
       * @default   true
       * @since     5.0.11
       * @product   highcharts highstock gantt
       * @apioption xAxis.title.reserveSpace
       */
      /**
       * The rotation of the text in degrees. 0 is horizontal, 270 is
       * vertical reading from bottom to top. Defaults to 0 for horizontal
       * axes, 270 for left-side axes and 90 for right-side axes.
       *
       * @sample    {highcharts} highcharts/yaxis/title-offset/
       *            Horizontal
       *
       * @type      {number}
       * @default   undefined
       * @apioption xAxis.title.rotation
       */
      /**
       * The actual text of the axis title. It can contain basic HTML tags
       * like `b`, `i` and `span` with style.
       *
       * @sample {highcharts} highcharts/xaxis/title-text/
       *         Custom HTML
       * @sample {highstock} stock/xaxis/title-text/
       *         Titles for both axes
       *
       * @type      {string|null}
       * @apioption xAxis.title.text
       */
      /**
       * Alignment of the text, can be `"left"`, `"right"` or `"center"`.
       * Default alignment depends on the
       * [title.align](xAxis.title.align):
       *
       * Horizontal axes:
       * - for `align` = `"low"`, `textAlign` is set to `left`
       * - for `align` = `"middle"`, `textAlign` is set to `center`
       * - for `align` = `"high"`, `textAlign` is set to `right`
       *
       * Vertical axes:
       * - for `align` = `"low"` and `opposite` = `true`, `textAlign` is
       *   set to `right`
       * - for `align` = `"low"` and `opposite` = `false`, `textAlign` is
       *   set to `left`
       * - for `align` = `"middle"`, `textAlign` is set to `center`
       * - for `align` = `"high"` and `opposite` = `true` `textAlign` is
       *   set to `left`
       * - for `align` = `"high"` and `opposite` = `false` `textAlign` is
       *   set to `right`
       *
       * @type      {Highcharts.AlignValue}
       * @apioption xAxis.title.textAlign
       */
      /**
       * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
       * to render the axis title.
       *
       * @product   highcharts highstock gantt
       */
      useHTML: false,
      /**
       * Horizontal pixel offset of the title position.
       *
       * @since     4.1.6
       * @product   highcharts highstock gantt
       */
      x: 0,
      /**
       * Vertical pixel offset of the title position.
       *
       * @product   highcharts highstock gantt
       */
      y: 0,
      /**
       * CSS styles for the title. If the title text is longer than the
       * axis length, it will wrap to multiple lines by default. This can
       * be customized by setting the `lineClamp` property, by setting a
       * specific `width` or by setting `whiteSpace: 'nowrap'`.
       *
       * In styled mode, the stroke width is given in the
       * `.highcharts-axis-title` class.
       *
       * @sample {highcharts} highcharts/xaxis/title-style/
       *         Red
       * @sample {highcharts} highcharts/css/axis/
       *         Styled mode
       *
       * @type    {Highcharts.CSSObject}
       */
      style: {
        /** @internal */
        color: "#666666",
        /**
         * @type {number|string}
         */
        fontSize: "0.8em"
      }
    },
    /**
     * The type of axis. Can be one of `linear`, `logarithmic`, `datetime`
     * or `category`. In a datetime axis, the numbers are given in
     * milliseconds, and tick marks are placed on appropriate values like
     * full hours or days. In a category axis, the
     * [point names](#series.line.data.name) of the chart's series are used
     * for categories, if not a [categories](#xAxis.categories) array is
     * defined.
     *
     * @sample {highcharts} highcharts/xaxis/type-linear/
     *         Linear
     * @sample {highcharts} highcharts/yaxis/type-log/
     *         Logarithmic
     * @sample {highcharts} highcharts/yaxis/type-log-minorgrid/
     *         Logarithmic with minor grid lines
     * @sample {highcharts} highcharts/xaxis/type-log-both/
     *         Logarithmic on two axes
     * @sample {highcharts} highcharts/yaxis/type-log-negative/
     *         Logarithmic with extension to emulate negative values
     *
     * @type    {Highcharts.AxisTypeValue}
     * @default linear
     * @product highcharts gantt
     * @apioption xAxis.type
     */
    /**
     * If there are multiple axes on the same side of the chart, the pixel
     * margin between the axes. Defaults to 0 on vertical axes, 15 on
     * horizontal axes.
     *
     * @type      {number}
     * @since     7.0.3
     * @apioption xAxis.margin
     */
    /**
     * Applies only when the axis `type` is `category`. When `uniqueNames`
     * is true, points are placed on the X axis according to their names.
     * If the same point name is repeated in the same or another series,
     * the point is placed on the same X position as other points of the
     * same name. When `uniqueNames` is false, the points are laid out in
     * increasing X positions regardless of their names, and the X axis
     * category will take the name of the last point in each position.
     *
     * @sample {highcharts} highcharts/xaxis/uniquenames-true/
     *         True by default
     * @sample {highcharts} highcharts/xaxis/uniquenames-false/
     *         False
     *
     * @since     4.2.7
     * @product   highcharts gantt
     * @type      {boolean}
     * @default   true
     * @apioption xAxis.uniqueNames
     */
    /**
     * Datetime axis only. An array determining what time intervals the
     * ticks are allowed to fall on. Each array item is an array where the
     * first value is the time unit and the second value another array of
     * allowed multiples.
     *
     * Defaults to:
     * ```js
     * units: [[
     *     'millisecond', // unit name
     *     [1, 2, 5, 10, 20, 25, 50, 100, 200, 500] // allowed multiples
     * ], [
     *     'second',
     *     [1, 2, 5, 10, 15, 30]
     * ], [
     *     'minute',
     *     [1, 2, 5, 10, 15, 30]
     * ], [
     *     'hour',
     *     [1, 2, 3, 4, 6, 8, 12]
     * ], [
     *     'day',
     *     [1, 2]
     * ], [
     *     'week',
     *     [1, 2]
     * ], [
     *     'month',
     *     [1, 2, 3, 4, 6]
     * ], [
     *     'year',
     *     null
     * ]]
     * ```
     *
     * @sample {highcharts} highcharts/xaxis/units/
     *         Axis units demonstrated
     *
     * @type      {Array<Array<string,(Array<number>|null)>>}
     * @product   highcharts highstock gantt
     * @apioption xAxis.units
     */
    /**
     * Whether axis, including axis title, line, ticks and labels, should
     * be visible.
     *
     * @since     4.1.9
     * @product   highcharts highstock gantt
     */
    visible: true,
    /**
     * Color of the minor, secondary grid lines.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-minor-grid-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/minorgridlinecolor/
     *         Bright grey lines from Y axis
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/minorgridlinecolor/
     *         Bright grey lines from Y axis
     *
     * @type    {Highcharts.ColorType}
     * @default #f2f2f2
     */
    minorGridLineColor: "#f2f2f2",
    /**
     * Width of the minor, secondary grid lines.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-grid-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/minorgridlinewidth/
     *         2px lines from Y axis
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/minorgridlinewidth/
     *         2px lines from Y axis
     */
    minorGridLineWidth: 1,
    /**
     * Color for the minor tick marks.
     *
     * @sample {highcharts} highcharts/yaxis/minortickcolor/
     *         Black tick marks on Y axis
     * @sample {highstock} stock/xaxis/minorticks/
     *         Black tick marks on Y axis
     *
     * @type    {Highcharts.ColorType}
     * @default #999999
     */
    minorTickColor: "#999999",
    /**
     * The color of the line marking the axis itself.
     *
     * In styled mode, the line stroke is given in the
     * `.highcharts-axis-line` or `.highcharts-xaxis-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/linecolor/
     *         A red line on Y axis
     * @sample {highcharts|highstock} highcharts/css/axis/
     *         Axes in styled mode
     * @sample {highstock} stock/xaxis/linecolor/
     *         A red line on X axis
     *
     * @type    {Highcharts.ColorType}
     */
    lineColor: "#333333",
    /**
     * The width of the line marking the axis itself.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-axis-line` or `.highcharts-xaxis-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/linecolor/
     *         A 1px line on Y axis
     * @sample {highcharts|highstock} highcharts/css/axis/
     *         Axes in styled mode
     * @sample {highstock} stock/xaxis/linewidth/
     *         A 2px line on X axis
     *
     * @default {highcharts|highstock} 1
     * @default {highmaps} 0
     */
    lineWidth: 1,
    /**
     * Color of the grid lines extending the ticks across the plot area.
     *
     * In styled mode, the stroke is given in the `.highcharts-grid-line`
     * class.
     *
     * @productdesc {highmaps}
     * In Highmaps, the grid lines are hidden by default.
     *
     * @sample {highcharts} highcharts/yaxis/gridlinecolor/
     *         Green lines
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/gridlinecolor/
     *         Green lines
     *
     * @type    {Highcharts.ColorType}
     * @default #e6e6e6
     */
    gridLineColor: "#e6e6e6",
    /**
     * The width of the grid lines extending the ticks across the plot area.
     * Defaults to 1 on the Y axis and 0 on the X axis, except for 3d
     * charts.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-grid-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/gridlinewidth/
     *         2px lines
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/gridlinewidth/
     *         2px lines
     *
     * @type      {number}
     * @apioption xAxis.gridLineWidth
     */
    gridLineWidth: void 0,
    /**
     * The height as the vertical axis. If it's a number, it is
     * interpreted as pixels.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted
     * as percentages of the total plot height.
     *
     * @sample {highcharts} highcharts/xaxis/axis-position-properties
     *         Different axis position properties
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.height
     */
    /**
     * The width as the horizontal axis. If it's a number, it is interpreted
     * as pixels.
     *
     * Since Highcharts v5.0.13: If it's a percentage string, it is
     * interpreted as percentages of the total plot width.
     *
     * @sample {highcharts} highcharts/xaxis/axis-position-properties
     *         Different axis position properties
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.width
     */
    /**
     * Color for the main tick marks.
     *
     * In styled mode, the stroke is given in the `.highcharts-tick`
     * class.
     *
     * @sample {highcharts} highcharts/xaxis/tickcolor/
     *         Red ticks on X axis
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     *
     * @type    {Highcharts.ColorType}
     */
    tickColor: "#333333"
    /* Palette.neutralColor80 */
    // `tickWidth: 1`
  };
  AxisDefaults2.yAxis = {
    /**
     * The type of axis. Can be one of `linear`, `logarithmic`, `datetime`,
     * `category` or `treegrid`. Defaults to `treegrid` for Gantt charts,
     * `linear` for other chart types.
     *
     * In a datetime axis, the numbers are given in milliseconds, and tick
     * marks are placed on appropriate values, like full hours or days. In a
     * category or treegrid axis, the [point names](#series.line.data.name)
     * of the chart's series are used for categories, if a
     * [categories](#xAxis.categories) array is not defined.
     *
     * @sample {highcharts} highcharts/yaxis/type-log-minorgrid/
     *         Logarithmic with minor grid lines
     * @sample {highcharts} highcharts/yaxis/type-log-negative/
     *         Logarithmic with extension to emulate negative values
     * @sample {gantt} gantt/treegrid-axis/demo
     *         Treegrid axis
     *
     * @type      {Highcharts.AxisTypeValue}
     * @default   {highcharts} linear
     * @default   {gantt} treegrid
     * @product   highcharts gantt
     * @apioption yAxis.type
     */
    /**
     * The height of the Y axis. If it's a number, it is interpreted as
     * pixels.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted as
     * percentages of the total plot height.
     *
     * @see [yAxis.top](#yAxis.top)
     *
     * @sample {highstock} stock/demo/candlestick-and-volume/
     *         Percentage height panes
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption yAxis.height
     */
    /**
     * Solid gauge only. Unless [stops](#yAxis.stops) are set, the color
     * to represent the maximum value of the Y axis.
     *
     * @sample {highcharts} highcharts/yaxis/mincolor-maxcolor/
     *         Min and max colors
     *
     * @type      {Highcharts.ColorType}
     * @default   #003399
     * @since     4.0
     * @product   highcharts
     * @apioption yAxis.maxColor
     */
    /**
     * Solid gauge only. Unless [stops](#yAxis.stops) are set, the color
     * to represent the minimum value of the Y axis.
     *
     * @sample {highcharts} highcharts/yaxis/mincolor-maxcolor/
     *         Min and max color
     *
     * @type      {Highcharts.ColorType}
     * @default   #e6ebf5
     * @since     4.0
     * @product   highcharts
     * @apioption yAxis.minColor
     */
    /**
     * Whether to reverse the axis so that the highest number is closest
     * to the origin.
     *
     * @sample {highcharts} highcharts/yaxis/reversed/
     *         Reversed Y axis
     * @sample {highstock} stock/xaxis/reversed/
     *         Reversed Y axis
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock} false
     * @default   {highmaps} true
     * @default   {gantt} true
     * @apioption yAxis.reversed
     */
    /**
     * If `true`, the first series in a stack will be drawn on top in a
     * positive, non-reversed Y axis. If `false`, the first series is in
     * the base of the stack.
     *
     * @sample {highcharts} highcharts/yaxis/reversedstacks-false/
     *         Non-reversed stacks
     * @sample {highstock} highcharts/yaxis/reversedstacks-false/
     *         Non-reversed stacks
     *
     * @type      {boolean}
     * @default   true
     * @since     3.0.10
     * @product   highcharts highstock
     * @apioption yAxis.reversedStacks
     */
    reversedStacks: true,
    /**
     * Solid gauge series only. Color stops for the solid gauge. Use this
     * in cases where a linear gradient between a `minColor` and `maxColor`
     * is not sufficient. The stops is an array of tuples, where the first
     * item is a float between 0 and 1 assigning the relative position in
     * the gradient, and the second item is the color.
     *
     * For solid gauges, the Y axis also inherits the concept of
     * [data classes](https://api.highcharts.com/highmaps#colorAxis.dataClasses)
     * from the Highmaps color axis.
     *
     * @sample {highcharts} highcharts/demo/gauge-solid/
     *         Gauge with stops
     *
     * @see [minColor](#yAxis.minColor)
     * @see [maxColor](#yAxis.maxColor)
     *
     * @type      {Array<Array<number,Highcharts.ColorType>>}
     * @since     4.0
     * @product   highcharts
     * @apioption yAxis.stops
     */
    /**
     * The pixel width of the major tick marks.
     *
     * @sample {highcharts} highcharts/xaxis/tickwidth/ 10 px width
     * @sample {highstock} stock/xaxis/ticks/ Formatted ticks on X axis
     *
     * @type      {number}
     * @default   0
     * @product   highcharts highstock gantt
     * @apioption yAxis.tickWidth
     */
    /**
     * Whether to force the axis to end on a tick. Use this option with
     * the `maxPadding` option to control the axis end.
     *
     * This option is always disabled, when panning type is
     * either `y` or `xy`.
     *
     * @see [type](#chart.panning.type)
     *
     *
     * @sample {highcharts} highcharts/yaxis/endontick/
     *         True by default
     * @sample {highcharts} highcharts/yaxis/endontick-false/
     *         False
     * @sample {highstock} stock/demo/basic-line/
     *         True by default
     * @sample {highstock} stock/xaxis/endontick/
     *         False for Y axis
     *
     * @since 1.2.0
     */
    endOnTick: true,
    /**
     * Padding of the max value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the highest data value to appear on the edge
     * of the plot area. When the axis' `max` option is set or a max extreme
     * is set using `axis.setExtremes()`, the maxPadding will be ignored.
     *
     * Also the `softThreshold` option takes precedence over `maxPadding`,
     * so if the data is tangent to the threshold, `maxPadding` may not
     * apply unless `softThreshold` is set to false.
     *
     * @sample {highcharts} highcharts/yaxis/maxpadding-02/
     *         Max padding of 0.2
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     *
     * @since   1.2.0
     * @product highcharts highstock gantt
     */
    maxPadding: 0.05,
    /**
     * Padding of the min value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the lowest data value to appear on the edge
     * of the plot area. When the axis' `min` option is set or a max extreme
     * is set using `axis.setExtremes()`, the maxPadding will be ignored.
     *
     * Also the `softThreshold` option takes precedence over `minPadding`,
     * so if the data is tangent to the threshold, `minPadding` may not
     * apply unless `softThreshold` is set to false.
     *
     * @sample {highcharts} highcharts/yaxis/minpadding/
     *         Min padding of 0.2
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     *
     * @since   1.2.0
     * @product highcharts highstock gantt
     */
    minPadding: 0.05,
    /**
     * @productdesc {highstock}
     * In Highcharts Stock 1.x, the Y axis was placed
     * on the left side by default.
     *
     * @sample {highcharts} highcharts/yaxis/opposite/
     *         Secondary Y axis opposite
     * @sample {highstock} stock/xaxis/opposite/
     *         Y axis on left side
     *
     * @type      {boolean}
     * @default   {highstock} true
     * @default   {highcharts} false
     * @product   highstock highcharts gantt
     * @apioption yAxis.opposite
     */
    /**
     * @see [tickInterval](#xAxis.tickInterval)
     * @see [tickPositioner](#xAxis.tickPositioner)
     * @see [tickPositions](#xAxis.tickPositions)
     */
    tickPixelInterval: 72,
    /**
     * Whether to show the last tick label.
     *
     * @productdesc {highcharts|gantt}
     * Defaults to `true` on cartesian charts, and `false` on polar charts.
     *
     * @productdesc {highstock}
     * Defaults to `true` for categorized yAxis and `false` for other types
     * of yAxis.
     *
     * @default undefined
     */
    showLastLabel: true,
    /**
     * @extends xAxis.labels
     */
    labels: {
      /**
       * The label's pixel distance from the perimeter of the plot area.
       * On cartesian charts, this is overridden if the `labels.y` setting
       * is set.
       *
       * On polar charts, if it's a percentage string, it is interpreted
       * the same as [series.radius](#plotOptions.gauge.radius), so the
       * label can be aligned under the gauge's shape.
       *
       * @sample {highcharts} highcharts/yaxis/labels-distance/
       *         Polar chart, labels centered under the arc
       *
       * @type      {number|string}
       * @product   highcharts
       * @apioption yAxis.labels.distance
       */
      /**
       * The y position offset of all labels relative to the tick
       * positions on the axis. For polar and radial axis consider the use
       * of the [distance](#yAxis.labels.distance) option.
       *
       * @sample {highcharts} highcharts/xaxis/labels-x/
       *         Y axis labels placed on grid lines
       *
       * @type      {number}
       * @default   {highcharts} 3
       * @default   {highstock} -2
       * @default   {highmaps} 3
       * @apioption yAxis.labels.y
       */
      /**
       * What part of the string the given position is anchored to. Can
       * be one of `"left"`, `"center"` or `"right"`. The exact position
       * also depends on the `labels.x` setting.
       *
       * Angular gauges and solid gauges defaults to `"center"`.
       * Solid gauges with two labels have additional option `"auto"`
       * for automatic horizontal and vertical alignment.
       *
       * @sample {highcharts} highcharts/yaxis/labels-align-left/
       *         Left
       * @sample {highcharts} highcharts/series-solidgauge/labels-auto-aligned/
       *         Solid gauge labels auto aligned
       *
       * @type       {Highcharts.AlignValue}
       * @default    {highstock} right
       * @apioption  yAxis.labels.align
       */
      /**
       * The x position offset of all labels relative to the tick
       * positions on the axis. Defaults to -15 for left axis, 15 for
       * right axis.
       *
       * @sample {highcharts} highcharts/xaxis/labels-x/
       *         Y axis labels placed on grid lines
       *
       * @type {number}
       */
      x: void 0
    },
    /**
     * @sample {highcharts} highcharts/yaxis/max-200/
     *         Y axis max of 200
     * @sample {highcharts} highcharts/yaxis/max-logarithmic/
     *         Y axis max on logarithmic axis
     * @sample {highstock} stock/yaxis/min-max/
     *         Fixed min and max on Y axis
     *
     * @apioption yAxis.max
     */
    /**
     * @sample {highcharts} highcharts/yaxis/min-startontick-false/
     *         -50 with startOnTick to false
     * @sample {highcharts} highcharts/yaxis/min-startontick-true/
     *         -50 with startOnTick true by default
     * @sample {highstock} stock/yaxis/min-max/
     *         Fixed min and max on Y axis
     *
     * @apioption yAxis.min
     */
    /**
     * An optional scrollbar to display on the Y axis in response to
     * limiting the minimum an maximum of the axis values.
     *
     * In styled mode, all the presentational options for the scrollbar
     * are replaced by the classes `.highcharts-scrollbar-thumb`,
     * `.highcharts-scrollbar-arrow`, `.highcharts-scrollbar-button`,
     * `.highcharts-scrollbar-rifles` and `.highcharts-scrollbar-track`.
     *
     * @sample {highstock} stock/yaxis/scrollbar/
     *         Scrollbar on the Y axis
     *
     * @extends   scrollbar
     * @since     4.2.6
     * @product   highstock
     * @excluding height
     * @apioption yAxis.scrollbar
     */
    /**
     * Enable the scrollbar on the Y axis.
     *
     * @sample {highstock} stock/yaxis/scrollbar/
     *         Enabled on Y axis
     *
     * @type      {boolean}
     * @default   false
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.enabled
     */
    /**
     * Pixel margin between the scrollbar and the axis elements.
     *
     * @type      {number}
     * @default   10
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.margin
     */
    /* eslint-disable @highcharts/highcharts/doclet-apioption-last */
    /**
     * Defines the position of the scrollbar. By default, it is positioned
     * on the opposite of the main axis (right side of the chart).
     * However, in the case of RTL languages could be set to `false`
     * which positions the scrollbar on the left.
     *
     * Works only for vertical axes.
     * This means yAxis in a non-inverted chart and xAxis in the inverted.
     *
     * @sample stock/yaxis/scrollbar-opposite/
     *         A scrollbar not on the opposite side
     *
     * @type      {boolean}
     * @default   true
     * @since 9.3.0
     *
     * @apioption yAxis.scrollbar.opposite
     * @apioption xAxis.scrollbar.opposite
     *
     */
    /* eslint-enable @highcharts/highcharts/doclet-apioption-last */
    /**
     * Whether to show the scrollbar when it is fully zoomed out at max
     * range. Setting it to `false` on the Y axis makes the scrollbar stay
     * hidden until the user zooms in, like common in browsers.
     *
     * @type      {boolean}
     * @default   true
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.showFull
     */
    /**
     * The width of a vertical scrollbar or height of a horizontal
     * scrollbar. Defaults to 20 on touch devices.
     *
     * @type      {number}
     * @default   14
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.size
     */
    /**
     * Z index of the scrollbar elements.
     *
     * @type      {number}
     * @default   3
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.zIndex
     */
    /**
     * A soft maximum for the axis. If the series data maximum is less
     * than this, the axis will stay at this maximum, but if the series
     * data maximum is higher, the axis will flex to show all data.
     *
     * **Note**: The [series.softThreshold](
     * #plotOptions.series.softThreshold) option takes precedence over this
     * option.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption yAxis.softMax
     */
    /**
     * A soft minimum for the axis. If the series data minimum is greater
     * than this, the axis will stay at this minimum, but if the series
     * data minimum is lower, the axis will flex to show all data.
     *
     * **Note**: The [series.softThreshold](
     * #plotOptions.series.softThreshold) option takes precedence over this
     * option.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption yAxis.softMin
     */
    /**
     * Defines the horizontal alignment of the stack total label. Can be one
     * of `"left"`, `"center"` or `"right"`. The default value is calculated
     * at runtime and depends on orientation and whether the stack is
     * positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-align-left/
     *         Aligned to the left
     * @sample {highcharts} highcharts/yaxis/stacklabels-align-center/
     *         Aligned in center
     * @sample {highcharts} highcharts/yaxis/stacklabels-align-right/
     *         Aligned to the right
     *
     * @type      {Highcharts.AlignValue}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.align
     */
    /**
     * A format string for the data label. Available variables are the same
     * as for `formatter`.
     *
     * @type      {string}
     * @default   {total}
     * @since     3.0.2
     * @product   highcharts highstock
     * @apioption yAxis.stackLabels.format
     */
    /**
     * Rotation of the labels in degrees.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-rotation/
     *         Labels rotated 45°
     *
     * @type      {number}
     * @default   0
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.rotation
     */
    /**
     * The text alignment for the label. While `align` determines where the
     * texts anchor point is placed with regards to the stack, `textAlign`
     * determines how the text is aligned against its anchor point. Possible
     * values are `"left"`, `"center"` and `"right"`. The default value is
     * calculated at runtime and depends on orientation and whether the
     * stack is positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-textalign-left/
     *         Label in center position but text-aligned left
     *
     * @type      {Highcharts.AlignValue}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.textAlign
     */
    /**
     * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the labels.
     *
     * @type      {boolean}
     * @default   false
     * @since     3.0
     * @product   highcharts highstock
     * @apioption yAxis.stackLabels.useHTML
     */
    /**
     * Defines the vertical alignment of the stack total label. Can be one
     * of `"top"`, `"middle"` or `"bottom"`. The default value is calculated
     * at runtime and depends on orientation and whether the stack is
     * positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-top/
     *         Vertically aligned top
     * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-middle/
     *         Vertically aligned middle
     * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-bottom/
     *         Vertically aligned bottom
     *
     * @type      {Highcharts.VerticalAlignValue}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.verticalAlign
     */
    /**
     * The x position offset of the label relative to the left of the
     * stacked bar. The default value is calculated at runtime and depends
     * on orientation and whether the stack is positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-x/
     *         Stack total labels with x offset
     *
     * @type      {number}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.x
     */
    /**
     * The y position offset of the label relative to the tick position
     * on the axis. The default value is calculated at runtime and depends
     * on orientation and whether the stack is positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-y/
     *         Stack total labels with y offset
     *
     * @type      {number}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.y
     */
    /**
     * Whether to force the axis to start on a tick. Use this option with
     * the `maxPadding` option to control the axis start.
     *
     * This option is always disabled, when panning type is
     * either `y` or `xy`.
     *
     * @see [type](#chart.panning.type)
     *
     * @sample {highcharts} highcharts/xaxis/startontick-false/
     *         False by default
     * @sample {highcharts} highcharts/xaxis/startontick-true/
     *         True
     * @sample {highstock} stock/xaxis/endontick/
     *         False for Y axis
     *
     * @since   1.2.0
     * @product highcharts highstock gantt
     */
    startOnTick: true,
    title: {
      /**
       * The pixel distance between the axis labels and the title.
       * Positive values are outside the axis line, negative are inside.
       *
       * @sample {highcharts} highcharts/xaxis/title-margin/
       *         Y axis title margin of 60
       *
       * @type      {number}
       * @default   40
       * @apioption yAxis.title.margin
       */
      /**
       * The actual text of the axis title. Horizontal texts can contain
       * HTML, but rotated texts are painted using vector techniques and
       * must be clean text. The Y axis title is disabled by setting the
       * `text` option to `undefined`. The default value is overriden by
       * the `lang.yAxisTitle` language option.
       *
       * @sample {highcharts} highcharts/xaxis/title-text/
       *         Custom HTML
       *
       * @type    {string|undefined}
       * @default {highcharts} Values
       * @default {highstock} undefined
       * @product highcharts highstock gantt
       */
    },
    /**
     * The top position of the Y axis. If it's a number, it is interpreted
     * as pixel position relative to the chart.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted as
     * percentages of the plot height, offset from plot area top.
     *
     * @see [yAxis.height](#yAxis.height)
     *
     * @sample {highstock} stock/demo/candlestick-and-volume/
     *         Percentage height panes
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption yAxis.top
     */
    /**
     * The stack labels show the total value for each bar in a stacked
     * column or bar chart. The label will be placed on top of positive
     * columns and below negative columns. In case of an inverted column
     * chart or a bar chart the label is placed to the right of positive
     * bars and to the left of negative bars.
     *
     * @product highcharts
     */
    stackLabels: {
      /**
       * Enable or disable the initial animation when a series is
       * displayed for the `stackLabels`. The animation can also be set as
       * a configuration object. Please note that this option only
       * applies to the initial animation.
       * For other animations, see [chart.animation](#chart.animation)
       * and the animation parameter under the API methods.
       * The following properties are supported:
       *
       * - `defer`: The animation delay time in milliseconds.
       *
       * @sample {highcharts} highcharts/plotoptions/animation-defer/
       *          Animation defer settings
       * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
       * @since 8.2.0
       * @apioption yAxis.stackLabels.animation
       */
      animation: {},
      /**
       * The animation delay time in milliseconds.
       * Set to `0` renders stackLabel immediately.
       * As `undefined` inherits defer time from the [series.animation.defer](#plotOptions.series.animation.defer).
       *
       * @type      {number}
       * @since 8.2.0
       * @apioption yAxis.stackLabels.animation.defer
       */
      /**
       * Allow the stack labels to overlap.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-allowoverlap-false/
       *         Default false
       *
       * @since   5.0.13
       * @product highcharts
       */
      allowOverlap: false,
      /**
       * The background color or gradient for the stack label.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {Highcharts.ColorType}
       * @since 8.1.0
       * @apioption yAxis.stackLabels.backgroundColor
       */
      /**
       * The border color for the stack label. Defaults to `undefined`.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {Highcharts.ColorType}
       * @since 8.1.0
       * @apioption yAxis.stackLabels.borderColor
       */
      /**
       * The border radius in pixels for the stack label.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {number}
       * @default   0
       * @since 8.1.0
       * @apioption yAxis.stackLabels.borderRadius
       */
      /**
       * The border width in pixels for the stack label.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {number}
       * @default   0
       * @since 8.1.0
       * @apioption yAxis.stackLabels.borderWidth
       */
      /**
       * Enable or disable the stack total labels.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-enabled/
       *         Enabled stack total labels
       * @sample {highcharts} highcharts/yaxis/stacklabels-enabled-waterfall/
       *         Enabled stack labels in waterfall chart
       *
       * @since   2.1.5
       * @product highcharts
       */
      enabled: false,
      /**
       * Whether to hide stack labels that are outside the plot area.
       * By default, the stack label is moved
       * inside the plot area according to the
       * [overflow](/highcharts/#yAxis/stackLabels/overflow)
       * option.
       *
       * @type  {boolean}
       * @since 7.1.3
       */
      crop: true,
      /**
       * How to handle stack total labels that flow outside the plot area.
       * The default is set to `"justify"`,
       * which aligns them inside the plot area.
       * For columns and bars, this means it will be moved inside the bar.
       * To display stack labels outside the plot area,
       * set `crop` to `false` and `overflow` to `"allow"`.
       *
       * @sample highcharts/yaxis/stacklabels-overflow/
       *         Stack labels flows outside the plot area.
       *
       * @type  {Highcharts.DataLabelsOverflowValue}
       * @since 7.1.3
       */
      overflow: "justify",
      /* eslint-disable valid-jsdoc */
      /**
       * Callback JavaScript function to format the label. The value is
       * given by `this.total`.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-formatter/
       *         Added units to stack total value
       *
       * @type    {Highcharts.FormatterCallbackFunction<Highcharts.StackItemObject>}
       * @since   2.1.5
       * @product highcharts
       */
      formatter: function() {
        const { numberFormatter } = this.axis.chart;
        return numberFormatter(this.total || 0, -1);
      },
      /**
       * CSS styles for the label.
       *
       * In styled mode, the styles are set in the
       * `.highcharts-stack-label` class.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-style/
       *         Red stack total labels
       *
       * @type    {Highcharts.CSSObject}
       * @since   2.1.5
       * @product highcharts
       */
      style: {
        /** @internal */
        color: "#000000",
        /**
         * @type {number|string}
         */
        fontSize: "0.7em",
        /** @internal */
        fontWeight: "bold",
        /** @internal */
        textOutline: "1px contrast"
      }
    },
    gridLineWidth: 1,
    lineWidth: 0
  };
})(AxisDefaults || (AxisDefaults = {}));
const AxisDefaults$1 = AxisDefaults;
const { addEvent: addEvent$1t, isFunction: isFunction$3, objectEach: objectEach$s, removeEvent: removeEvent$b } = Utilities;
var Foundation;
(function(Foundation2) {
  function registerEventOptions2(component, options2) {
    component.eventOptions = component.eventOptions || {};
    objectEach$s(options2.events, function(event, eventType) {
      if (component.eventOptions[eventType] !== event) {
        if (component.eventOptions[eventType]) {
          removeEvent$b(component, eventType, component.eventOptions[eventType]);
          delete component.eventOptions[eventType];
        }
        if (isFunction$3(event)) {
          component.eventOptions[eventType] = event;
          addEvent$1t(component, eventType, event, {
            order: 0
            // #14080 fire those events as firsts
          });
        }
      }
    });
  }
  Foundation2.registerEventOptions = registerEventOptions2;
})(Foundation || (Foundation = {}));
const Foundation$1 = Foundation;
const { deg2rad: deg2rad$8 } = Highcharts;
const { clamp: clamp$m, correctFloat: correctFloat$f, defined: defined$17, destroyObjectProperties: destroyObjectProperties$9, extend: extend$1l, fireEvent: fireEvent$J, getAlignFactor: getAlignFactor$7, isNumber: isNumber$12, merge: merge$1C, objectEach: objectEach$r, pick: pick$1J } = Utilities;
class Tick {
  /* *
   *
   *  Constructors
   *
   * */
  constructor(axis, pos, type, noLabel, parameters) {
    this.isNew = true;
    this.isNewLabel = true;
    this.axis = axis;
    this.pos = pos;
    this.type = type || "";
    this.parameters = parameters || {};
    this.tickmarkOffset = this.parameters.tickmarkOffset;
    this.options = this.parameters.options;
    fireEvent$J(this, "init");
    if (!type && !noLabel) {
      this.addLabel();
    }
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Write the tick label.
   *
   * @private
   * @function Highcharts.Tick#addLabel
   */
  addLabel() {
    const tick = this, axis = tick.axis, options2 = axis.options, chart = axis.chart, categories = axis.categories, log = axis.logarithmic, names2 = axis.names, pos = tick.pos, labelOptions = pick$1J(tick.options?.labels, options2.labels), tickPositions = axis.tickPositions, isFirst = pos === tickPositions[0], isLast = pos === tickPositions[tickPositions.length - 1], animateLabels = (!labelOptions.step || labelOptions.step === 1) && axis.tickInterval === 1, tickPositionInfo = tickPositions.info;
    let label = tick.label, dateTimeLabelFormat, dateTimeLabelFormats, i2;
    let value = this.parameters.category || (categories ? pick$1J(categories[pos], names2[pos], pos) : pos);
    if (log && isNumber$12(value)) {
      value = correctFloat$f(log.lin2log(value));
    }
    if (axis.dateTime) {
      if (tickPositionInfo) {
        dateTimeLabelFormats = chart.time.resolveDTLFormat(options2.dateTimeLabelFormats[!options2.grid && tickPositionInfo.higherRanks[pos] || tickPositionInfo.unitName]);
        dateTimeLabelFormat = dateTimeLabelFormats.main;
      } else if (isNumber$12(value)) {
        dateTimeLabelFormat = axis.dateTime.getXDateFormat(value, options2.dateTimeLabelFormats || {});
      }
    }
    tick.isFirst = isFirst;
    tick.isLast = isLast;
    const ctx = {
      axis,
      chart,
      dateTimeLabelFormat,
      isFirst,
      isLast,
      pos,
      tick,
      tickPositionInfo,
      value
    };
    fireEvent$J(this, "labelFormat", ctx);
    const labelFormatter = (ctx2) => {
      if (labelOptions.formatter) {
        return labelOptions.formatter.call(ctx2, ctx2);
      }
      if (labelOptions.format) {
        ctx2.text = axis.defaultLabelFormatter.call(ctx2);
        return Templating.format(labelOptions.format, ctx2, chart);
      }
      return axis.defaultLabelFormatter.call(ctx2);
    };
    const str = labelFormatter.call(ctx, ctx);
    const list = dateTimeLabelFormats?.list;
    if (list) {
      tick.shortenLabel = function() {
        for (i2 = 0; i2 < list.length; i2++) {
          extend$1l(ctx, { dateTimeLabelFormat: list[i2] });
          label.attr({
            text: labelFormatter.call(ctx, ctx)
          });
          if (label.getBBox().width < axis.getSlotWidth(tick) - 2 * (labelOptions.padding || 0)) {
            return;
          }
        }
        label.attr({
          text: ""
        });
      };
    } else {
      tick.shortenLabel = void 0;
    }
    if (animateLabels && axis._addedPlotLB) {
      tick.moveLabel(str, labelOptions);
    }
    if (!defined$17(label) && !tick.movedLabel) {
      tick.label = label = tick.createLabel(str, labelOptions);
      tick.rotation = 0;
    } else if (label && label.textStr !== str && !animateLabels) {
      if (label.textWidth && !labelOptions.style.width && !label.styles.width) {
        label.css({ width: null });
      }
      label.attr({ text: str });
      label.textPxLength = label.getBBox().width;
    }
  }
  /**
   * Render and return the label of the tick.
   *
   * @private
   * @function Highcharts.Tick#createLabel
   */
  createLabel(str, labelOptions, xy) {
    const axis = this.axis, { renderer, styledMode } = axis.chart, whiteSpace = labelOptions.style.whiteSpace, label = defined$17(str) && labelOptions.enabled ? renderer.text(str, xy?.x, xy?.y, labelOptions.useHTML).add(axis.labelGroup) : void 0;
    if (label) {
      if (!styledMode) {
        label.css(merge$1C(labelOptions.style));
      }
      label.textPxLength = label.getBBox().width;
      if (!styledMode && whiteSpace) {
        label.css({ whiteSpace });
      }
    }
    return label;
  }
  /**
   * Destructor for the tick prototype
   *
   * @private
   * @function Highcharts.Tick#destroy
   */
  destroy() {
    destroyObjectProperties$9(this, this.axis);
  }
  /**
   * Gets the x and y positions for ticks in terms of pixels.
   *
   * @private
   * @function Highcharts.Tick#getPosition
   *
   * @param {boolean} horiz
   * Whether the tick is on an horizontal axis or not.
   *
   * @param {number} tickPos
   * Position of the tick.
   *
   * @param {number} tickmarkOffset
   * Tickmark offset for all ticks.
   *
   * @param {boolean} [old]
   * Whether the axis has changed or not.
   *
   * @return {Highcharts.PositionObject}
   * The tick position.
   *
   * @emits Highcharts.Tick#event:afterGetPosition
   */
  getPosition(horiz, tickPos, tickmarkOffset, old) {
    const axis = this.axis, chart = axis.chart, cHeight = old && chart.oldChartHeight || chart.chartHeight, pos = {
      x: horiz ? correctFloat$f(axis.translate(tickPos + tickmarkOffset, void 0, void 0, old) + axis.transB) : axis.left + axis.offset + (axis.opposite ? (old && chart.oldChartWidth || chart.chartWidth) - axis.right - axis.left : 0),
      y: horiz ? cHeight - axis.bottom + axis.offset - (axis.opposite ? axis.height : 0) : correctFloat$f(cHeight - axis.translate(tickPos + tickmarkOffset, void 0, void 0, old) - axis.transB)
    };
    pos.y = clamp$m(pos.y, -1e9, 1e9);
    fireEvent$J(this, "afterGetPosition", { pos });
    return pos;
  }
  /**
   * Get the x, y position of the tick label
   * @private
   */
  getLabelPosition(x, y, label, horiz, labelOptions, tickmarkOffset, index, step) {
    const axis = this.axis, transA = axis.transA, reversed = (
      // #7911
      axis.isLinked && axis.linkedParent ? axis.linkedParent.reversed : axis.reversed
    ), staggerLines = axis.staggerLines, rotCorr = axis.tickRotCorr || { x: 0, y: 0 }, labelOffsetCorrection = !horiz && !axis.reserveSpaceDefault ? -axis.labelOffset * (axis.labelAlign === "center" ? 0.5 : 1) : 0, distance = labelOptions.distance, pos = {};
    let yOffset, line2;
    if (axis.side === 0) {
      yOffset = label.rotation ? -distance : -label.getBBox().height;
    } else if (axis.side === 2) {
      yOffset = rotCorr.y + distance;
    } else {
      yOffset = Math.cos(label.rotation * deg2rad$8) * (rotCorr.y - label.getBBox(false, 0).height / 2);
    }
    if (defined$17(labelOptions.y)) {
      yOffset = axis.side === 0 && axis.horiz ? labelOptions.y + yOffset : labelOptions.y;
    }
    x = x + pick$1J(labelOptions.x, [0, 1, 0, -1][axis.side] * distance) + labelOffsetCorrection + rotCorr.x - (tickmarkOffset && horiz ? tickmarkOffset * transA * (reversed ? -1 : 1) : 0);
    y = y + yOffset - (tickmarkOffset && !horiz ? tickmarkOffset * transA * (reversed ? 1 : -1) : 0);
    if (staggerLines) {
      line2 = index / (step || 1) % staggerLines;
      if (axis.opposite) {
        line2 = staggerLines - line2 - 1;
      }
      y += line2 * (axis.labelOffset / staggerLines);
    }
    pos.x = x;
    pos.y = Math.round(y);
    fireEvent$J(this, "afterGetLabelPosition", { pos, tickmarkOffset, index });
    return pos;
  }
  /**
   * Get the offset height or width of the label
   *
   * @private
   * @function Highcharts.Tick#getLabelSize
   */
  getLabelSize() {
    return this.label ? this.label.getBBox()[this.axis.horiz ? "height" : "width"] : 0;
  }
  /**
   * Extendible method to return the path of the marker
   * @private
   */
  getMarkPath(x, y, tickLength, tickWidth, horiz = false, renderer) {
    return renderer.crispLine([[
      "M",
      x,
      y
    ], [
      "L",
      x + (horiz ? 0 : -tickLength),
      y + (horiz ? tickLength : 0)
    ]], tickWidth);
  }
  /**
   * Handle the label overflow by adjusting the labels to the left and right
   * edge, or hide them if they collide into the neighbour label.
   *
   * @private
   * @function Highcharts.Tick#handleOverflow
   */
  handleOverflow(xy) {
    const tick = this, axis = this.axis, labelOptions = axis.options.labels, pxPos = xy.x, chartWidth = axis.chart.chartWidth, spacing = axis.chart.spacing, leftBound = pick$1J(axis.labelLeft, Math.min(axis.pos, spacing[3])), rightBound = pick$1J(axis.labelRight, Math.max(!axis.isRadial ? axis.pos + axis.len : 0, chartWidth - spacing[1])), label = this.label, rotation = this.rotation, factor = getAlignFactor$7(axis.labelAlign || label.attr("align")), labelWidth = label.getBBox().width, slotWidth = axis.getSlotWidth(tick), xCorrection = factor, css2 = {};
    let modifiedSlotWidth = slotWidth, goRight = 1, leftPos, rightPos, textWidth;
    if (!rotation && labelOptions.overflow === "justify") {
      leftPos = pxPos - factor * labelWidth;
      rightPos = pxPos + (1 - factor) * labelWidth;
      if (leftPos < leftBound) {
        modifiedSlotWidth = xy.x + modifiedSlotWidth * (1 - factor) - leftBound;
      } else if (rightPos > rightBound) {
        modifiedSlotWidth = rightBound - xy.x + modifiedSlotWidth * factor;
        goRight = -1;
      }
      modifiedSlotWidth = Math.min(slotWidth, modifiedSlotWidth);
      if (modifiedSlotWidth < slotWidth && axis.labelAlign === "center") {
        xy.x += goRight * (slotWidth - modifiedSlotWidth - xCorrection * (slotWidth - Math.min(labelWidth, modifiedSlotWidth)));
      }
      if (labelWidth > modifiedSlotWidth || axis.autoRotation && label?.styles?.width) {
        textWidth = modifiedSlotWidth;
      }
    } else if (rotation < 0 && pxPos - factor * labelWidth < leftBound) {
      textWidth = Math.round(pxPos / Math.cos(rotation * deg2rad$8) - leftBound);
    } else if (rotation > 0 && pxPos + factor * labelWidth > rightBound) {
      textWidth = Math.round((chartWidth - pxPos) / Math.cos(rotation * deg2rad$8));
    }
    if (textWidth && label) {
      if (tick.shortenLabel) {
        tick.shortenLabel();
      } else {
        label.css(extend$1l(css2, {
          width: Math.floor(textWidth) + "px",
          lineClamp: axis.isRadial ? 0 : 1
        }));
      }
    }
  }
  /**
   * Try to replace the label if the same one already exists.
   *
   * @private
   * @function Highcharts.Tick#moveLabel
   */
  moveLabel(str, labelOptions) {
    const tick = this, label = tick.label, axis = tick.axis;
    let moved = false, labelPos;
    if (label && label.textStr === str) {
      tick.movedLabel = label;
      moved = true;
      delete tick.label;
    } else {
      objectEach$r(axis.ticks, function(currentTick) {
        if (!moved && !currentTick.isNew && currentTick !== tick && currentTick.label && currentTick.label.textStr === str) {
          tick.movedLabel = currentTick.label;
          moved = true;
          currentTick.labelPos = tick.movedLabel.xy;
          delete currentTick.label;
        }
      });
    }
    if (!moved && (tick.labelPos || label)) {
      labelPos = tick.labelPos || label.xy;
      tick.movedLabel = tick.createLabel(str, labelOptions, labelPos);
      if (tick.movedLabel) {
        tick.movedLabel.attr({ opacity: 0 });
      }
    }
  }
  /**
   * Put everything in place
   *
   * @private
   * @param {number} index
   *
   * @param {boolean} [old]
   * Use old coordinates to prepare an animation into new position
   *
   * @param {number} [opacity]
   */
  render(index, old, opacity) {
    const tick = this, axis = tick.axis, horiz = axis.horiz, pos = tick.pos, tickmarkOffset = pick$1J(tick.tickmarkOffset, axis.tickmarkOffset), xy = tick.getPosition(horiz, pos, tickmarkOffset, old), x = xy.x, y = xy.y, axisStart = axis.pos, axisEnd = axisStart + axis.len, pxPos = horiz ? x : y;
    const labelOpacity = pick$1J(
      opacity,
      tick.label?.newOpacity,
      // #15528
      1
    );
    if (!axis.chart.polar && (correctFloat$f(pxPos) < axisStart || pxPos > axisEnd)) {
      opacity = 0;
    }
    opacity ?? (opacity = 1);
    this.isActive = true;
    this.renderGridLine(old, opacity);
    this.renderMark(xy, opacity);
    this.renderLabel(xy, old, labelOpacity, index);
    tick.isNew = false;
    fireEvent$J(this, "afterRender");
  }
  /**
   * Renders the gridLine.
   *
   * @private
   * @function Highcharts.Tick#renderGridLine
   * @param {boolean} old  Whether or not the tick is old
   * @param {number} opacity  The opacity of the grid line
   */
  renderGridLine(old, opacity) {
    const tick = this, axis = tick.axis, options2 = axis.options, attribs = {}, pos = tick.pos, type = tick.type, tickmarkOffset = pick$1J(tick.tickmarkOffset, axis.tickmarkOffset), renderer = axis.chart.renderer;
    let gridLine = tick.gridLine, gridLinePath, gridLineWidth = options2.gridLineWidth, gridLineColor = options2.gridLineColor, dashStyle = options2.gridLineDashStyle;
    if (tick.type === "minor") {
      gridLineWidth = options2.minorGridLineWidth;
      gridLineColor = options2.minorGridLineColor;
      dashStyle = options2.minorGridLineDashStyle;
    }
    if (!gridLine) {
      if (!axis.chart.styledMode) {
        attribs.stroke = gridLineColor;
        attribs["stroke-width"] = gridLineWidth || 0;
        attribs.dashstyle = dashStyle;
      }
      if (!type) {
        attribs.zIndex = 1;
      }
      if (old) {
        opacity = 0;
      }
      tick.gridLine = gridLine = renderer.path().attr(attribs).addClass("highcharts-" + (type ? type + "-" : "") + "grid-line").add(axis.gridGroup);
    }
    if (gridLine) {
      gridLinePath = axis.getPlotLinePath({
        value: pos + tickmarkOffset,
        lineWidth: gridLine.strokeWidth(),
        force: "pass",
        old,
        acrossPanes: false
        // #18025
      });
      if (gridLinePath) {
        gridLine[old || tick.isNew ? "attr" : "animate"]({
          d: gridLinePath,
          opacity
        });
      }
    }
  }
  /**
   * Renders the tick mark.
   *
   * @private
   * @function Highcharts.Tick#renderMark
   * @param {Highcharts.PositionObject} xy  The position vector of the mark
   * @param {number} opacity  The opacity of the mark
   */
  renderMark(xy, opacity) {
    const tick = this, axis = tick.axis, options2 = axis.options, renderer = axis.chart.renderer, type = tick.type, tickSize = axis.tickSize(type ? type + "Tick" : "tick"), x = xy.x, y = xy.y, tickWidth = pick$1J(options2[type !== "minor" ? "tickWidth" : "minorTickWidth"], !type && axis.isXAxis ? 1 : 0), tickColor = options2[type !== "minor" ? "tickColor" : "minorTickColor"];
    let mark = tick.mark;
    const isNewMark = !mark;
    if (tickSize) {
      if (axis.opposite) {
        tickSize[0] = -tickSize[0];
      }
      if (!mark) {
        tick.mark = mark = renderer.path().addClass("highcharts-" + (type ? type + "-" : "") + "tick").add(axis.axisGroup);
        if (!axis.chart.styledMode) {
          mark.attr({
            stroke: tickColor,
            "stroke-width": tickWidth
          });
        }
      }
      mark[isNewMark ? "attr" : "animate"]({
        d: tick.getMarkPath(x, y, tickSize[0], mark.strokeWidth(), axis.horiz, renderer),
        opacity
      });
    }
  }
  /**
   * Renders the tick label.
   * Note: The label should already be created in init(), so it should only
   * have to be moved into place.
   *
   * @private
   * @function Highcharts.Tick#renderLabel
   * @param {Highcharts.PositionObject} xy  The position vector of the label
   * @param {boolean} old  Whether or not the tick is old
   * @param {number} opacity  The opacity of the label
   * @param {number} index  The index of the tick
   */
  renderLabel(xy, old, opacity, index) {
    const tick = this, axis = tick.axis, horiz = axis.horiz, options2 = axis.options, label = tick.label, labelOptions = options2.labels, step = labelOptions.step, tickmarkOffset = pick$1J(tick.tickmarkOffset, axis.tickmarkOffset), x = xy.x, y = xy.y;
    let show = true;
    if (label && isNumber$12(x)) {
      label.xy = xy = tick.getLabelPosition(x, y, label, horiz, labelOptions, tickmarkOffset, index, step);
      if (tick.isFirst && !tick.isLast && !options2.showFirstLabel || tick.isLast && !tick.isFirst && !options2.showLastLabel) {
        show = false;
      } else if (horiz && !labelOptions.step && !labelOptions.rotation && !old && opacity !== 0) {
        tick.handleOverflow(xy);
      }
      if (step && index % step) {
        show = false;
      }
      if (show && isNumber$12(xy.y)) {
        xy.opacity = opacity;
        label[tick.isNewLabel ? "attr" : "animate"](xy).show(true);
        tick.isNewLabel = false;
      } else {
        label.hide();
        tick.isNewLabel = true;
      }
    }
  }
  /**
   * Replace labels with the moved ones to perform animation. Additionally
   * destroy unused labels.
   *
   * @private
   * @function Highcharts.Tick#replaceMovedLabel
   */
  replaceMovedLabel() {
    const tick = this, label = tick.label, axis = tick.axis;
    if (label && !tick.isNew) {
      label.animate({ opacity: 0 }, void 0, label.destroy);
      delete tick.label;
    }
    axis.isDirty = true;
    tick.label = tick.movedLabel;
    delete tick.movedLabel;
  }
}
const { animObject: animObject$e } = animationExports;
const { xAxis, yAxis } = AxisDefaults$1;
const { defaultOptions: defaultOptions$k } = DefaultOptions;
const { registerEventOptions: registerEventOptions$3 } = Foundation$1;
const { deg2rad: deg2rad$7 } = Highcharts;
const { arrayMax: arrayMax$a, arrayMin: arrayMin$8, clamp: clamp$l, correctFloat: correctFloat$e, defined: defined$16, destroyObjectProperties: destroyObjectProperties$8, erase: erase$a, error: error$8, extend: extend$1k, fireEvent: fireEvent$I, getClosestDistance: getClosestDistance$1, insertItem: insertItem$1, isArray: isArray$n, isNumber: isNumber$11, isString: isString$d, merge: merge$1B, normalizeTickInterval: normalizeTickInterval$2, objectEach: objectEach$q, pick: pick$1I, relativeLength: relativeLength$h, removeEvent: removeEvent$a, splat: splat$k, syncTimeout: syncTimeout$a } = Utilities;
const getNormalizedTickInterval = (axis, tickInterval) => normalizeTickInterval$2(tickInterval, void 0, void 0, pick$1I(
  axis.options.allowDecimals,
  // If the tick interval is greater than 0.5, avoid decimals, as
  // linear axes are often used to render discrete values (#3363). If
  // a tick amount is set, allow decimals by default, as it increases
  // the chances for a good fit.
  tickInterval < 0.5 || axis.tickAmount !== void 0
), !!axis.tickAmount);
extend$1k(defaultOptions$k, { xAxis, yAxis: merge$1B(xAxis, yAxis) });
class Axis {
  /* *
   *
   *  Constructors
   *
   * */
  constructor(chart, userOptions, coll) {
    this.init(chart, userOptions, coll);
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Overrideable function to initialize the axis.
   *
   * @see {@link Axis}
   *
   * @function Highcharts.Axis#init
   *
   * @param {Highcharts.Chart} chart
   * The Chart instance to apply the axis on.
   *
   * @param {AxisOptions} userOptions
   * Axis options.
   *
   * @emits Highcharts.Axis#event:afterInit
   * @emits Highcharts.Axis#event:init
   */
  init(chart, userOptions, coll = this.coll) {
    const isXAxis = coll === "xAxis", axis = this, horiz = axis.isZAxis || (chart.inverted ? !isXAxis : isXAxis);
    axis.chart = chart;
    axis.horiz = horiz;
    axis.isXAxis = isXAxis;
    axis.coll = coll;
    fireEvent$I(this, "init", { userOptions });
    axis.opposite = pick$1I(userOptions.opposite, axis.opposite);
    axis.side = pick$1I(
      userOptions.side,
      axis.side,
      horiz ? axis.opposite ? 0 : 2 : (
        // Top : bottom
        axis.opposite ? 1 : 3
      )
      // Right : left
    );
    axis.setOptions(userOptions);
    const options2 = axis.options, labelsOptions = options2.labels;
    axis.type ?? (axis.type = options2.type || "linear");
    axis.uniqueNames ?? (axis.uniqueNames = options2.uniqueNames ?? true);
    fireEvent$I(axis, "afterSetType");
    axis.userOptions = userOptions;
    axis.minPixelPadding = 0;
    axis.reversed = pick$1I(options2.reversed, axis.reversed);
    axis.visible = options2.visible;
    axis.zoomEnabled = options2.zoomEnabled;
    axis.hasNames = this.type === "category" || options2.categories === true;
    axis.categories = isArray$n(options2.categories) && options2.categories || (axis.hasNames ? [] : void 0);
    if (!axis.names) {
      axis.names = [];
      axis.names.keys = {};
    }
    axis.plotLinesAndBandsGroups = {};
    axis.positiveValuesOnly = !!axis.logarithmic;
    axis.isLinked = defined$16(options2.linkedTo);
    axis.ticks = {};
    axis.labelEdge = [];
    axis.minorTicks = {};
    axis.plotLinesAndBands = [];
    axis.alternateBands = {};
    axis.len ?? (axis.len = 0);
    axis.minRange = axis.userMinRange = options2.minRange || options2.maxZoom;
    axis.range = options2.range;
    axis.offset = options2.offset || 0;
    axis.max = void 0;
    axis.min = void 0;
    const crosshair = pick$1I(options2.crosshair, splat$k(chart.options.tooltip.crosshairs)[isXAxis ? 0 : 1]);
    axis.crosshair = crosshair === true ? {} : crosshair;
    if (chart.axes.indexOf(axis) === -1) {
      if (isXAxis) {
        chart.axes.splice(chart.xAxis.length, 0, axis);
      } else {
        chart.axes.push(axis);
      }
      insertItem$1(this, chart[this.coll]);
    }
    chart.orderItems(axis.coll);
    axis.series = axis.series || [];
    if (chart.inverted && !axis.isZAxis && isXAxis && !defined$16(axis.reversed)) {
      axis.reversed = true;
    }
    axis.labelRotation = isNumber$11(labelsOptions.rotation) ? labelsOptions.rotation : void 0;
    registerEventOptions$3(axis, options2);
    fireEvent$I(this, "afterInit");
  }
  /**
   * Merge and set options.
   *
   * @private
   * @function Highcharts.Axis#setOptions
   *
   * @param {Highcharts.AxisOptions} userOptions
   * Axis options.
   *
   * @emits Highcharts.Axis#event:afterSetOptions
   */
  setOptions(userOptions) {
    const sideSpecific = this.horiz ? (
      // Top and bottom axis defaults
      {
        labels: {
          autoRotation: [-45],
          padding: 3
        },
        margin: 15
      }
    ) : (
      // Left and right axis, title rotated 90 or 270 degrees
      // respectively
      {
        labels: {
          padding: 1
        },
        title: {
          rotation: 90 * this.side
        }
      }
    );
    this.options = merge$1B(
      sideSpecific,
      // Merge in the default title for y-axis, which changes with
      // language settings
      this.coll === "yAxis" ? {
        title: {
          text: this.chart.options.lang.yAxisTitle
        }
      } : {},
      defaultOptions$k[this.coll],
      userOptions
    );
    fireEvent$I(this, "afterSetOptions", { userOptions });
  }
  /**
   * The default label formatter. The context is a special config object for
   * the label. In apps, use the
   * [labels.formatter](https://api.highcharts.com/highcharts/xAxis.labels.formatter)
   * instead, except when a modification is needed.
   *
   * @function Highcharts.Axis#defaultLabelFormatter
   *
   * @param {Highcharts.AxisLabelsFormatterContextObject} this
   * Formatter context of axis label.
   *
   * @param {Highcharts.AxisLabelsFormatterContextObject} [ctx]
   * Formatter context of axis label.
   *
   * @return {string}
   * The formatted label content.
   */
  defaultLabelFormatter() {
    const axis = this.axis, chart = this.chart, { numberFormatter } = chart, value = isNumber$11(this.value) ? this.value : NaN, time = axis.chart.time, categories = axis.categories, dateTimeLabelFormat = this.dateTimeLabelFormat, lang2 = defaultOptions$k.lang, numericSymbols = lang2.numericSymbols, numSymMagnitude = lang2.numericSymbolMagnitude || 1e3, numericSymbolDetector = axis.logarithmic ? Math.abs(value) : axis.tickInterval;
    let i2 = numericSymbols?.length, multi, ret;
    if (categories) {
      ret = `${this.value}`;
    } else if (dateTimeLabelFormat) {
      ret = time.dateFormat(dateTimeLabelFormat, value, true);
    } else if (i2 && numericSymbols && numericSymbolDetector >= 1e3) {
      while (i2-- && typeof ret === "undefined") {
        multi = Math.pow(numSymMagnitude, i2 + 1);
        if (
          // Only accept a numeric symbol when the distance is more
          // than a full unit. So for example if the symbol is k, we
          // don't accept numbers like 0.5k.
          numericSymbolDetector >= multi && // Accept one decimal before the symbol. Accepts 0.5k but
          // not 0.25k. How does this work with the previous?
          value * 10 % multi === 0 && numericSymbols[i2] !== null && value !== 0
        ) {
          ret = numberFormatter(value / multi, -1) + numericSymbols[i2];
        }
      }
    }
    if (typeof ret === "undefined") {
      if (Math.abs(value) >= 1e4) {
        ret = numberFormatter(value, -1);
      } else {
        ret = numberFormatter(value, -1, void 0, "");
      }
    }
    return ret;
  }
  /**
   * Get the minimum and maximum for the series of each axis. The function
   * analyzes the axis series and updates `this.dataMin` and `this.dataMax`.
   *
   * @private
   * @function Highcharts.Axis#getSeriesExtremes
   *
   * @emits Highcharts.Axis#event:afterGetSeriesExtremes
   * @emits Highcharts.Axis#event:getSeriesExtremes
   */
  getSeriesExtremes() {
    const axis = this;
    let xExtremes;
    fireEvent$I(this, "getSeriesExtremes", null, function() {
      axis.hasVisibleSeries = false;
      axis.dataMin = axis.dataMax = axis.threshold = void 0;
      axis.softThreshold = !axis.isXAxis;
      axis.series.forEach((series) => {
        if (series.reserveSpace()) {
          const seriesOptions = series.options;
          let xData, threshold = seriesOptions.threshold, seriesDataMin, seriesDataMax;
          axis.hasVisibleSeries = true;
          if (axis.positiveValuesOnly && (threshold || 0) <= 0) {
            threshold = void 0;
          }
          if (axis.isXAxis) {
            xData = series.getColumn("x");
            if (xData.length) {
              xData = axis.logarithmic ? xData.filter((x) => x > 0) : xData;
              xExtremes = series.getXExtremes(xData);
              seriesDataMin = xExtremes.min;
              seriesDataMax = xExtremes.max;
              if (!isNumber$11(seriesDataMin) && // #5010:
              !(seriesDataMin instanceof Date)) {
                xData = xData.filter(isNumber$11);
                xExtremes = series.getXExtremes(xData);
                seriesDataMin = xExtremes.min;
                seriesDataMax = xExtremes.max;
              }
              if (xData.length) {
                axis.dataMin = Math.min(pick$1I(axis.dataMin, seriesDataMin), seriesDataMin);
                axis.dataMax = Math.max(pick$1I(axis.dataMax, seriesDataMax), seriesDataMax);
              }
            }
          } else {
            const dataExtremes = series.applyExtremes();
            if (isNumber$11(dataExtremes.dataMin)) {
              seriesDataMin = dataExtremes.dataMin;
              axis.dataMin = Math.min(pick$1I(axis.dataMin, seriesDataMin), seriesDataMin);
            }
            if (isNumber$11(dataExtremes.dataMax)) {
              seriesDataMax = dataExtremes.dataMax;
              axis.dataMax = Math.max(pick$1I(axis.dataMax, seriesDataMax), seriesDataMax);
            }
            if (defined$16(threshold)) {
              axis.threshold = threshold;
            }
            if (!seriesOptions.softThreshold || axis.positiveValuesOnly) {
              axis.softThreshold = false;
            }
          }
        }
      });
    });
    fireEvent$I(this, "afterGetSeriesExtremes");
  }
  /**
   * Translate from axis value to pixel position on the chart, or back. Use
   * the `toPixels` and `toValue` functions in applications.
   *
   * @private
   * @function Highcharts.Axis#translate
   */
  translate(val, backwards, cvsCoord, old, handleLog, pointPlacement) {
    const axis = this.linkedParent || this, localMin = old && axis.old ? axis.old.min : axis.min;
    if (!isNumber$11(localMin)) {
      return NaN;
    }
    const minPixelPadding = axis.minPixelPadding, doPostTranslate = (axis.isOrdinal || axis.brokenAxis?.hasBreaks || axis.logarithmic && handleLog) && axis.lin2val;
    let sign2 = 1, cvsOffset = 0, localA = old && axis.old ? axis.old.transA : axis.transA, returnValue = 0;
    if (!localA) {
      localA = axis.transA;
    }
    if (cvsCoord) {
      sign2 *= -1;
      cvsOffset = axis.len;
    }
    if (axis.reversed) {
      sign2 *= -1;
      cvsOffset -= sign2 * (axis.sector || axis.len);
    }
    if (backwards) {
      val = val * sign2 + cvsOffset;
      val -= minPixelPadding;
      returnValue = val / localA + localMin;
      if (doPostTranslate) {
        returnValue = axis.lin2val(returnValue);
      }
    } else {
      if (doPostTranslate) {
        val = axis.val2lin(val);
      }
      const value = sign2 * (val - localMin) * localA;
      returnValue = value + cvsOffset + sign2 * minPixelPadding + (isNumber$11(pointPlacement) ? localA * pointPlacement : 0);
      if (!axis.isRadial) {
        returnValue = correctFloat$e(returnValue);
      }
    }
    return returnValue;
  }
  /**
   * Translate a value in terms of axis units into pixels within the chart.
   *
   * @function Highcharts.Axis#toPixels
   *
   * @param {number|string} value
   * A value in terms of axis units. For datetime axes, a timestamp or
   * date/time string is accepted.
   *
   * @param {boolean} [paneCoordinates=false]
   * Whether to return the pixel coordinate relative to the chart or just the
   * axis/pane itself.
   *
   * @return {number}
   * Pixel position of the value on the chart or axis.
   */
  toPixels(value, paneCoordinates) {
    return this.translate(this.chart?.time.parse(value) ?? NaN, false, !this.horiz, void 0, true) + (paneCoordinates ? 0 : this.pos);
  }
  /**
   * Translate a pixel position along the axis to a value in terms of axis
   * units.
   *
   * @function Highcharts.Axis#toValue
   *
   * @param {number} pixel
   * The pixel value coordinate.
   *
   * @param {boolean} [paneCoordinates=false]
   * Whether the input pixel is relative to the chart or just the axis/pane
   * itself.
   *
   * @return {number}
   * The axis value.
   */
  toValue(pixel, paneCoordinates) {
    return this.translate(pixel - (paneCoordinates ? 0 : this.pos), true, !this.horiz, void 0, true);
  }
  /**
   * Create the path for a plot line that goes from the given value on
   * this axis, across the plot to the opposite side. Also used internally for
   * grid lines and crosshairs.
   *
   * @function Highcharts.Axis#getPlotLinePath
   *
   * @param {Highcharts.AxisPlotLinePathOptionsObject} options
   * Options for the path.
   *
   * @return {Highcharts.SVGPathArray|null}
   * The SVG path definition for the plot line.
   */
  getPlotLinePath(options2) {
    const axis = this, chart = axis.chart, axisLeft = axis.left, axisTop = axis.top, old = options2.old, value = options2.value, lineWidth = options2.lineWidth, cHeight = old && chart.oldChartHeight || chart.chartHeight, cWidth = old && chart.oldChartWidth || chart.chartWidth, transB = axis.transB;
    let translatedValue = options2.translatedValue, force = options2.force, x1, y1, x2, y2, skip;
    function between(x, a, b) {
      if (force !== "pass" && (x < a || x > b)) {
        if (force) {
          x = clamp$l(x, a, b);
        } else {
          skip = true;
        }
      }
      return x;
    }
    const evt = {
      value,
      lineWidth,
      old,
      force,
      acrossPanes: options2.acrossPanes,
      translatedValue
    };
    fireEvent$I(this, "getPlotLinePath", evt, function(e) {
      translatedValue = pick$1I(translatedValue, axis.translate(value, void 0, void 0, old));
      translatedValue = clamp$l(translatedValue, -1e9, 1e9);
      x1 = x2 = translatedValue + transB;
      y1 = y2 = cHeight - translatedValue - transB;
      if (!isNumber$11(translatedValue)) {
        skip = true;
        force = false;
      } else if (axis.horiz) {
        y1 = axisTop;
        y2 = cHeight - axis.bottom + (axis.options.isInternal ? 0 : chart.scrollablePixelsY || 0);
        x1 = x2 = between(x1, axisLeft, axisLeft + axis.width);
      } else {
        x1 = axisLeft;
        x2 = cWidth - axis.right + (chart.scrollablePixelsX || 0);
        y1 = y2 = between(y1, axisTop, axisTop + axis.height);
      }
      e.path = skip && !force ? void 0 : chart.renderer.crispLine([["M", x1, y1], ["L", x2, y2]], lineWidth || 1);
    });
    return evt.path;
  }
  /**
   * Internal function to get the tick positions of a linear axis to round
   * values like whole tens or every five.
   *
   * @function Highcharts.Axis#getLinearTickPositions
   *
   * @param {number} tickInterval
   * The normalized tick interval.
   *
   * @param {number} min
   * Axis minimum.
   *
   * @param {number} max
   * Axis maximum.
   *
   * @return {Array<number>}
   * An array of axis values where ticks should be placed.
   */
  getLinearTickPositions(tickInterval, min2, max2) {
    const roundedMin = correctFloat$e(Math.floor(min2 / tickInterval) * tickInterval), roundedMax = correctFloat$e(Math.ceil(max2 / tickInterval) * tickInterval), tickPositions = [];
    let pos, lastPos, precision;
    if (correctFloat$e(roundedMin + tickInterval) === roundedMin) {
      precision = 20;
    }
    if (this.single) {
      return [min2];
    }
    pos = roundedMin;
    while (pos <= roundedMax) {
      tickPositions.push(pos);
      pos = correctFloat$e(pos + tickInterval, precision);
      if (pos === lastPos) {
        break;
      }
      lastPos = pos;
    }
    return tickPositions;
  }
  /**
   * Resolve the new minorTicks/minorTickInterval options into the legacy
   * loosely typed minorTickInterval option.
   *
   * @function Highcharts.Axis#getMinorTickInterval
   *
   * @return {number|"auto"|null}
   * Legacy option
   */
  getMinorTickInterval() {
    const { minorTicks, minorTickInterval } = this.options;
    if (minorTicks === true) {
      return pick$1I(minorTickInterval, "auto");
    }
    if (minorTicks === false) {
      return;
    }
    return minorTickInterval;
  }
  /**
   * Internal function to return the minor tick positions. For logarithmic
   * axes, the same logic as for major ticks is reused.
   *
   * @function Highcharts.Axis#getMinorTickPositions
   *
   * @return {Array<number>}
   * An array of axis values where ticks should be placed.
   */
  getMinorTickPositions() {
    const axis = this, options2 = axis.options, tickPositions = axis.tickPositions, minorTickInterval = axis.minorTickInterval, pointRangePadding = axis.pointRangePadding || 0, min2 = (axis.min || 0) - pointRangePadding, max2 = (axis.max || 0) + pointRangePadding, range2 = axis.brokenAxis?.hasBreaks ? axis.brokenAxis.unitLength : max2 - min2;
    let minorTickPositions = [], pos;
    if (range2 && range2 / minorTickInterval < axis.len / 3) {
      const logarithmic = axis.logarithmic;
      if (logarithmic) {
        this.paddedTicks.forEach(function(_pos, i2, paddedTicks) {
          if (i2) {
            minorTickPositions.push.apply(minorTickPositions, logarithmic.getLogTickPositions(minorTickInterval, paddedTicks[i2 - 1], paddedTicks[i2], true));
          }
        });
      } else if (axis.dateTime && this.getMinorTickInterval() === "auto") {
        minorTickPositions = minorTickPositions.concat(axis.getTimeTicks(axis.dateTime.normalizeTimeTickInterval(minorTickInterval), min2, max2, options2.startOfWeek));
      } else {
        for (pos = min2 + (tickPositions[0] - min2) % minorTickInterval; pos <= max2; pos += minorTickInterval) {
          if (pos === minorTickPositions[0]) {
            break;
          }
          minorTickPositions.push(pos);
        }
      }
    }
    if (minorTickPositions.length !== 0) {
      axis.trimTicks(minorTickPositions);
    }
    return minorTickPositions;
  }
  /**
   * Adjust the min and max for the minimum range. Keep in mind that the
   * series data is not yet processed, so we don't have information on data
   * cropping and grouping, or updated `axis.pointRange` or
   * `series.pointRange`. The data can't be processed until we have finally
   * established min and max.
   *
   * @private
   * @function Highcharts.Axis#adjustForMinRange
   */
  adjustForMinRange() {
    const axis = this, options2 = axis.options, logarithmic = axis.logarithmic, time = axis.chart.time;
    let { max: max2, min: min2, minRange } = axis, zoomOffset, spaceAvailable, closestDataRange, minArgs, maxArgs;
    if (axis.isXAxis && typeof minRange === "undefined" && !logarithmic) {
      if (defined$16(options2.min) || defined$16(options2.max) || defined$16(options2.floor) || defined$16(options2.ceiling)) {
        minRange = null;
      } else {
        closestDataRange = getClosestDistance$1(axis.series.map((s) => {
          const xData = s.getColumn("x");
          return s.xIncrement ? xData.slice(0, 2) : xData;
        })) || 0;
        minRange = Math.min(closestDataRange * 5, axis.dataMax - axis.dataMin);
      }
    }
    if (isNumber$11(max2) && isNumber$11(min2) && isNumber$11(minRange) && max2 - min2 < minRange) {
      spaceAvailable = axis.dataMax - axis.dataMin >= minRange;
      zoomOffset = (minRange - max2 + min2) / 2;
      minArgs = [
        min2 - zoomOffset,
        time.parse(options2.min) ?? min2 - zoomOffset
      ];
      if (spaceAvailable) {
        minArgs[2] = logarithmic ? logarithmic.log2lin(axis.dataMin) : axis.dataMin;
      }
      min2 = arrayMax$a(minArgs);
      maxArgs = [
        min2 + minRange,
        time.parse(options2.max) ?? min2 + minRange
      ];
      if (spaceAvailable) {
        maxArgs[2] = logarithmic ? logarithmic.log2lin(axis.dataMax) : axis.dataMax;
      }
      max2 = arrayMin$8(maxArgs);
      if (max2 - min2 < minRange) {
        minArgs[0] = max2 - minRange;
        minArgs[1] = time.parse(options2.min) ?? max2 - minRange;
        min2 = arrayMax$a(minArgs);
      }
    }
    axis.minRange = minRange;
    axis.min = min2;
    axis.max = max2;
  }
  /**
   * Find the closestPointRange across all series, including the single data
   * series.
   *
   * @private
   * @function Highcharts.Axis#getClosest
   */
  getClosest() {
    let closestSingleDistance, closestDistance;
    if (this.categories) {
      closestDistance = 1;
    } else {
      const singleXs = [];
      this.series.forEach(function(series) {
        const seriesClosest = series.closestPointRange, xData = series.getColumn("x");
        if (xData.length === 1) {
          singleXs.push(xData[0]);
        } else if (series.sorted && defined$16(seriesClosest) && series.reserveSpace()) {
          closestDistance = defined$16(closestDistance) ? Math.min(closestDistance, seriesClosest) : seriesClosest;
        }
      });
      if (singleXs.length) {
        singleXs.sort((a, b) => a - b);
        closestSingleDistance = getClosestDistance$1([singleXs]);
      }
    }
    if (closestSingleDistance && closestDistance) {
      return Math.min(closestSingleDistance, closestDistance);
    }
    return closestSingleDistance || closestDistance;
  }
  /**
   * When a point name is given and no x, search for the name in the existing
   * categories, or if categories aren't provided, search names or create a
   * new category (#2522).
   *
   * @private
   * @function Highcharts.Axis#nameToX
   *
   * @param {Highcharts.Point} point
   * The point to inspect.
   *
   * @return {number}
   * The X value that the point is given.
   */
  nameToX(point) {
    const explicitCategories = isArray$n(this.options.categories), names2 = explicitCategories ? this.categories : this.names;
    let nameX = point.options.x, x;
    point.series.requireSorting = false;
    if (!defined$16(nameX)) {
      nameX = this.uniqueNames && names2 ? explicitCategories ? names2.indexOf(point.name) : pick$1I(names2.keys[point.name], -1) : point.series.autoIncrement();
    }
    if (nameX === -1) {
      if (!explicitCategories && names2) {
        x = names2.length;
      }
    } else if (isNumber$11(nameX)) {
      x = nameX;
    }
    if (typeof x !== "undefined") {
      this.names[x] = point.name;
      this.names.keys[point.name] = x;
    } else if (point.x) {
      x = point.x;
    }
    return x;
  }
  /**
   * When changes have been done to series data, update the axis.names.
   *
   * @private
   * @function Highcharts.Axis#updateNames
   */
  updateNames() {
    const axis = this, names2 = this.names, i2 = names2.length;
    if (i2 > 0) {
      Object.keys(names2.keys).forEach(function(key2) {
        delete names2.keys[key2];
      });
      names2.length = 0;
      this.minRange = this.userMinRange;
      (this.series || []).forEach((series) => {
        series.xIncrement = null;
        if (!series.points || series.isDirtyData) {
          axis.max = Math.max(axis.max || 0, series.dataTable.rowCount - 1);
          series.processData();
          series.generatePoints();
        }
        const xData = series.getColumn("x").slice();
        series.data.forEach((point, i3) => {
          let x = xData[i3];
          if (point?.options && typeof point.name !== "undefined") {
            x = axis.nameToX(point);
            if (typeof x !== "undefined" && x !== point.x) {
              xData[i3] = point.x = x;
            }
          }
        });
        series.dataTable.setColumn("x", xData);
      });
    }
  }
  /**
   * Update translation information.
   *
   * @private
   * @function Highcharts.Axis#setAxisTranslation
   *
   * @emits Highcharts.Axis#event:afterSetAxisTranslation
   */
  setAxisTranslation() {
    const axis = this, range2 = axis.max - axis.min, linkedParent = axis.linkedParent, hasCategories = !!axis.categories, isXAxis = axis.isXAxis;
    let pointRange = axis.axisPointRange || 0, closestPointRange, minPointOffset = 0, pointRangePadding = 0, ordinalCorrection, transA = axis.transA;
    if (isXAxis || hasCategories || pointRange) {
      closestPointRange = axis.getClosest();
      if (linkedParent) {
        minPointOffset = linkedParent.minPointOffset;
        pointRangePadding = linkedParent.pointRangePadding;
      } else {
        axis.series.forEach(function(series) {
          const seriesPointRange = hasCategories ? 1 : isXAxis ? pick$1I(series.options.pointRange, closestPointRange, 0) : axis.axisPointRange || 0, pointPlacement = series.options.pointPlacement;
          pointRange = Math.max(pointRange, seriesPointRange);
          if (!axis.single || hasCategories) {
            const isPointPlacementAxis = series.is("xrange") ? !isXAxis : isXAxis;
            minPointOffset = Math.max(minPointOffset, isPointPlacementAxis && isString$d(pointPlacement) ? 0 : seriesPointRange / 2);
            pointRangePadding = Math.max(pointRangePadding, isPointPlacementAxis && pointPlacement === "on" ? 0 : seriesPointRange);
          }
        });
      }
      ordinalCorrection = axis.ordinal?.slope && closestPointRange ? axis.ordinal.slope / closestPointRange : 1;
      axis.minPointOffset = minPointOffset = minPointOffset * ordinalCorrection;
      axis.pointRangePadding = pointRangePadding = pointRangePadding * ordinalCorrection;
      axis.pointRange = Math.min(pointRange, axis.single && hasCategories ? 1 : range2);
      if (isXAxis) {
        axis.closestPointRange = closestPointRange;
      }
    }
    axis.translationSlope = axis.transA = transA = axis.staticScale || axis.len / (range2 + pointRangePadding || 1);
    axis.transB = axis.horiz ? axis.left : axis.bottom;
    axis.minPixelPadding = transA * minPointOffset;
    fireEvent$I(this, "afterSetAxisTranslation");
  }
  /**
   * @private
   * @function Highcharts.Axis#minFromRange
   */
  minFromRange() {
    const { max: max2, min: min2 } = this;
    return isNumber$11(max2) && isNumber$11(min2) && max2 - min2 || void 0;
  }
  /**
   * Set the tick positions to round values and optionally extend the extremes
   * to the nearest tick.
   *
   * @private
   * @function Highcharts.Axis#setTickInterval
   *
   * @param {boolean} secondPass
   * TO-DO: parameter description
   *
   * @emits Highcharts.Axis#event:foundExtremes
   */
  setTickInterval(secondPass) {
    const axis = this, { categories, chart, dataMax, dataMin, dateTime, isXAxis, logarithmic, options: options2, softThreshold } = axis, time = chart.time, threshold = isNumber$11(axis.threshold) ? axis.threshold : void 0, minRange = axis.minRange || 0, { ceiling, floor: floor2, linkedTo, softMax, softMin } = options2, linkedParent = isNumber$11(linkedTo) && chart[axis.coll]?.[linkedTo], tickPixelIntervalOption = options2.tickPixelInterval;
    let maxPadding = options2.maxPadding, minPadding = options2.minPadding, range2 = 0, linkedParentExtremes, tickIntervalOption = isNumber$11(options2.tickInterval) && options2.tickInterval >= 0 ? options2.tickInterval : void 0, thresholdMin, thresholdMax, hardMin, hardMax;
    if (!dateTime && !categories && !linkedParent) {
      this.getTickAmount();
    }
    hardMin = pick$1I(axis.userMin, time.parse(options2.min));
    hardMax = pick$1I(axis.userMax, time.parse(options2.max));
    if (linkedParent) {
      axis.linkedParent = linkedParent;
      linkedParentExtremes = linkedParent.getExtremes();
      axis.min = pick$1I(linkedParentExtremes.min, linkedParentExtremes.dataMin);
      axis.max = pick$1I(linkedParentExtremes.max, linkedParentExtremes.dataMax);
      if (this.type !== linkedParent.type) {
        error$8(11, true, chart);
      }
    } else {
      if (softThreshold && defined$16(threshold) && isNumber$11(dataMax) && isNumber$11(dataMin)) {
        if (dataMin >= threshold) {
          thresholdMin = threshold;
          minPadding = 0;
        } else if (dataMax <= threshold) {
          thresholdMax = threshold;
          maxPadding = 0;
        }
      }
      axis.min = pick$1I(hardMin, thresholdMin, dataMin);
      axis.max = pick$1I(hardMax, thresholdMax, dataMax);
    }
    if (isNumber$11(axis.max) && isNumber$11(axis.min)) {
      if (logarithmic) {
        if (axis.positiveValuesOnly && !secondPass && Math.min(axis.min, pick$1I(dataMin, axis.min)) <= 0) {
          error$8(10, true, chart);
        }
        axis.min = correctFloat$e(logarithmic.log2lin(axis.min), 16);
        axis.max = correctFloat$e(logarithmic.log2lin(axis.max), 16);
      }
      if (axis.range && isNumber$11(dataMin)) {
        axis.userMin = axis.min = hardMin = Math.max(dataMin, axis.minFromRange() || 0);
        axis.userMax = hardMax = axis.max;
        axis.range = void 0;
      }
    }
    fireEvent$I(axis, "foundExtremes");
    axis.adjustForMinRange();
    if (isNumber$11(axis.min) && isNumber$11(axis.max)) {
      if (!isNumber$11(axis.userMin) && isNumber$11(softMin) && softMin < axis.min) {
        axis.min = hardMin = softMin;
      }
      if (!isNumber$11(axis.userMax) && isNumber$11(softMax) && softMax > axis.max) {
        axis.max = hardMax = softMax;
      }
      if (!categories && !axis.axisPointRange && !axis.stacking?.usePercentage && !linkedParent) {
        range2 = axis.max - axis.min;
        if (range2) {
          if (!defined$16(hardMin) && minPadding) {
            axis.min -= range2 * minPadding;
          }
          if (!defined$16(hardMax) && maxPadding) {
            axis.max += range2 * maxPadding;
          }
        }
      }
      if (!isNumber$11(axis.userMin) && isNumber$11(floor2)) {
        axis.min = Math.max(axis.min, floor2);
      }
      if (!isNumber$11(axis.userMax) && isNumber$11(ceiling)) {
        axis.max = Math.min(axis.max, ceiling);
      }
      if (softThreshold && isNumber$11(dataMin) && isNumber$11(dataMax)) {
        const numThreshold = threshold || 0;
        if (!defined$16(hardMin) && axis.min < numThreshold && dataMin >= numThreshold) {
          axis.min = options2.minRange ? Math.min(numThreshold, axis.max - minRange) : numThreshold;
        } else if (!defined$16(hardMax) && axis.max > numThreshold && dataMax <= numThreshold) {
          axis.max = options2.minRange ? Math.max(numThreshold, axis.min + minRange) : numThreshold;
        }
      }
      if (!chart.polar && axis.min > axis.max) {
        if (defined$16(options2.min)) {
          axis.max = axis.min;
        } else if (defined$16(options2.max)) {
          axis.min = axis.max;
        }
      }
      range2 = axis.max - axis.min;
    }
    if (axis.min === axis.max || !isNumber$11(axis.min) || !isNumber$11(axis.max)) {
      axis.tickInterval = 1;
    } else if (linkedParent && !tickIntervalOption && tickPixelIntervalOption === linkedParent.options.tickPixelInterval) {
      axis.tickInterval = tickIntervalOption = linkedParent.tickInterval;
    } else {
      axis.tickInterval = pick$1I(
        tickIntervalOption,
        this.tickAmount ? range2 / Math.max(this.tickAmount - 1, 1) : void 0,
        // For categorized axis, 1 is default, for linear axis use
        // tickPix
        categories ? 1 : (
          // Don't let it be more than the data range
          range2 * tickPixelIntervalOption / Math.max(axis.len, tickPixelIntervalOption)
        )
      );
    }
    if (isXAxis && !secondPass) {
      const hasExtremesChanged = axis.min !== axis.old?.min || axis.max !== axis.old?.max;
      axis.series.forEach(function(series) {
        series.forceCrop = series.forceCropping?.();
        series.processData(hasExtremesChanged);
      });
      fireEvent$I(this, "postProcessData", { hasExtremesChanged });
    }
    axis.setAxisTranslation();
    fireEvent$I(this, "initialAxisTranslation");
    if (axis.pointRange && !tickIntervalOption) {
      axis.tickInterval = Math.max(axis.pointRange, axis.tickInterval);
    }
    const minTickInterval = pick$1I(
      options2.minTickInterval,
      // In datetime axes, don't go below the data interval, except when
      // there are scatter-like series involved (#13369).
      dateTime && !axis.series.some((s) => !s.sorted) ? axis.closestPointRange : 0
    );
    if (!tickIntervalOption && minTickInterval && axis.tickInterval < minTickInterval) {
      axis.tickInterval = minTickInterval;
    }
    if (!dateTime && !logarithmic && !tickIntervalOption) {
      axis.tickInterval = getNormalizedTickInterval(axis, axis.tickInterval);
    }
    if (!this.tickAmount) {
      axis.tickInterval = axis.unsquish();
    }
    this.setTickPositions();
  }
  /**
   * Now we have computed the normalized tickInterval, get the tick positions.
   *
   * @private
   * @function Highcharts.Axis#setTickPositions
   *
   * @emits Highcharts.Axis#event:afterSetTickPositions
   */
  setTickPositions() {
    const axis = this, options2 = this.options, tickPositionsOption = options2.tickPositions, tickPositioner = options2.tickPositioner, minorTickIntervalOption = this.getMinorTickInterval(), allowEndOnTick = !this.isPanning, startOnTick = allowEndOnTick && options2.startOnTick, endOnTick = allowEndOnTick && options2.endOnTick;
    let tickPositions = [], tickPositionerResult;
    this.tickmarkOffset = this.categories && options2.tickmarkPlacement === "between" && this.tickInterval === 1 ? 0.5 : 0;
    this.single = this.min === this.max && defined$16(this.min) && !this.tickAmount && // Data is on integer (#6563)
    (this.min % 1 === 0 || // Between integers and decimals are not allowed (#6274)
    options2.allowDecimals !== false);
    if (tickPositionsOption) {
      tickPositions = tickPositionsOption.slice();
    } else if (isNumber$11(this.min) && isNumber$11(this.max)) {
      if (!axis.ordinal?.positions && (this.max - this.min) / this.tickInterval > Math.max(2 * this.len, 200)) {
        tickPositions = [this.min, this.max];
        error$8(19, false, this.chart);
      } else if (axis.dateTime) {
        tickPositions = axis.getTimeTicks(axis.dateTime.normalizeTimeTickInterval(this.tickInterval, options2.units), this.min, this.max, options2.startOfWeek, axis.ordinal?.positions, this.closestPointRange, true);
      } else if (axis.logarithmic) {
        tickPositions = axis.logarithmic.getLogTickPositions(this.tickInterval, this.min, this.max);
      } else {
        const startingTickInterval = this.tickInterval;
        let adjustedTickInterval = startingTickInterval;
        while (adjustedTickInterval <= startingTickInterval * 2) {
          tickPositions = this.getLinearTickPositions(this.tickInterval, this.min, this.max);
          if (this.tickAmount && tickPositions.length > this.tickAmount) {
            this.tickInterval = getNormalizedTickInterval(this, adjustedTickInterval *= 1.1);
          } else {
            break;
          }
        }
      }
      if (tickPositions.length > this.len) {
        tickPositions = [
          tickPositions[0],
          tickPositions[tickPositions.length - 1]
        ];
        if (tickPositions[0] === tickPositions[1]) {
          tickPositions.length = 1;
        }
      }
      if (tickPositioner) {
        this.tickPositions = tickPositions;
        tickPositionerResult = tickPositioner.apply(axis, [this.min, this.max]);
        if (tickPositionerResult) {
          tickPositions = tickPositionerResult;
        }
      }
    }
    this.tickPositions = tickPositions;
    this.minorTickInterval = minorTickIntervalOption === "auto" && this.tickInterval ? this.tickInterval / options2.minorTicksPerMajor : minorTickIntervalOption;
    this.paddedTicks = tickPositions.slice(0);
    this.trimTicks(tickPositions, startOnTick, endOnTick);
    if (!this.isLinked && isNumber$11(this.min) && isNumber$11(this.max)) {
      if (this.single && tickPositions.length < 2 && !this.categories && !this.series.some((s) => s.is("heatmap") && s.options.pointPlacement === "between")) {
        this.min -= 0.5;
        this.max += 0.5;
      }
      if (!tickPositionsOption && !tickPositionerResult) {
        this.adjustTickAmount();
      }
    }
    fireEvent$I(this, "afterSetTickPositions");
  }
  /**
   * Handle startOnTick and endOnTick by either adapting to padding min/max or
   * rounded min/max. Also handle single data points.
   *
   * @private
   * @function Highcharts.Axis#trimTicks
   *
   * @param {Array<number>} tickPositions
   * TO-DO: parameter description
   *
   * @param {boolean} [startOnTick]
   * TO-DO: parameter description
   *
   * @param {boolean} [endOnTick]
   * TO-DO: parameter description
   */
  trimTicks(tickPositions, startOnTick, endOnTick) {
    const roundedMin = tickPositions[0], roundedMax = tickPositions[tickPositions.length - 1], minPointOffset = !this.isOrdinal && this.minPointOffset || 0;
    fireEvent$I(this, "trimTicks");
    if (!this.isLinked || // Linked non-grid axes should trim ticks, #21743.
    // Grid axis has custom handling of ticks.
    !this.grid) {
      if (startOnTick && roundedMin !== -Infinity) {
        this.min = roundedMin;
      } else {
        while (this.min - minPointOffset > tickPositions[0]) {
          tickPositions.shift();
        }
      }
      if (endOnTick) {
        this.max = roundedMax;
      } else {
        while (this.max + minPointOffset < tickPositions[tickPositions.length - 1]) {
          tickPositions.pop();
        }
      }
      if (tickPositions.length === 0 && defined$16(roundedMin) && !this.options.tickPositions) {
        tickPositions.push((roundedMax + roundedMin) / 2);
      }
    }
  }
  /**
   * Check if there are multiple axes in the same pane.
   *
   * @private
   * @function Highcharts.Axis#alignToOthers
   *
   * @return {boolean|undefined}
   * True if there are other axes.
   */
  alignToOthers() {
    const axis = this, chart = axis.chart, alignedAxes = [this], options2 = axis.options, chartOptions = chart.options.chart, alignThresholds = this.coll === "yAxis" && chartOptions.alignThresholds, thresholdAlignments = [];
    let hasOther;
    axis.thresholdAlignment = void 0;
    if (
      // Only if alignTicks or alignThresholds is true
      (chartOptions.alignTicks !== false && options2.alignTicks || alignThresholds) && // Disabled when startOnTick or endOnTick are false (#7604)
      options2.startOnTick !== false && options2.endOnTick !== false && // Don't try to align ticks on a log axis, they are not evenly
      // spaced (#6021)
      !axis.logarithmic
    ) {
      const getKey = (axis2) => {
        const { horiz, options: options3 } = axis2;
        return [
          horiz ? options3.left : options3.top,
          options3.width,
          options3.height,
          options3.pane
        ].join(",");
      };
      const thisKey = getKey(this);
      chart[this.coll].forEach(function(otherAxis) {
        const { series } = otherAxis;
        if (
          // #4442
          series.length && series.some((s) => s.visible) && otherAxis !== axis && getKey(otherAxis) === thisKey
        ) {
          hasOther = true;
          alignedAxes.push(otherAxis);
        }
      });
    }
    if (hasOther && alignThresholds) {
      alignedAxes.forEach((otherAxis) => {
        const threshAlign = otherAxis.getThresholdAlignment(axis);
        if (isNumber$11(threshAlign)) {
          thresholdAlignments.push(threshAlign);
        }
      });
      const thresholdAlignment = thresholdAlignments.length > 1 ? thresholdAlignments.reduce((sum2, n2) => sum2 += n2, 0) / thresholdAlignments.length : void 0;
      alignedAxes.forEach((axis2) => {
        axis2.thresholdAlignment = thresholdAlignment;
      });
    }
    return hasOther;
  }
  /**
   * Where the axis wants its threshold, from 0 which is on `axis.min`, to 1 which
   * is on `axis.max`.
   *
   * @private
   * @function Highcharts.Axis#getThresholdAlignment
   */
  getThresholdAlignment(callerAxis) {
    if (!isNumber$11(this.dataMin) || this !== callerAxis && this.series.some((s) => s.isDirty || s.isDirtyData)) {
      this.getSeriesExtremes();
    }
    if (isNumber$11(this.threshold)) {
      let thresholdAlignment = clamp$l((this.threshold - (this.dataMin || 0)) / ((this.dataMax || 0) - (this.dataMin || 0)), 0, 1);
      if (this.options.reversed) {
        thresholdAlignment = 1 - thresholdAlignment;
      }
      return thresholdAlignment;
    }
  }
  /**
   * Find the max ticks of either the x and y axis collection, and record it
   * in `this.tickAmount`.
   *
   * @private
   * @function Highcharts.Axis#getTickAmount
   */
  getTickAmount() {
    const axis = this, options2 = this.options, tickPixelInterval = options2.tickPixelInterval;
    let tickAmount = options2.tickAmount;
    if (!defined$16(options2.tickInterval) && !tickAmount && this.len < tickPixelInterval && !this.isRadial && !axis.logarithmic && options2.startOnTick && options2.endOnTick) {
      tickAmount = 2;
    }
    if (!tickAmount && this.alignToOthers()) {
      tickAmount = Math.ceil(this.len / tickPixelInterval) + 1;
    }
    if (tickAmount < 4) {
      this.finalTickAmt = tickAmount;
      tickAmount = 5;
    }
    this.tickAmount = tickAmount;
  }
  /**
   * When using multiple axes, adjust the number of ticks to match the highest
   * number of ticks in that group.
   *
   * @private
   * @function Highcharts.Axis#adjustTickAmount
   */
  adjustTickAmount() {
    const axis = this, { finalTickAmt, max: max2, min: min2, options: options2, tickPositions, tickAmount, thresholdAlignment } = axis, currentTickAmount = tickPositions?.length, threshold = pick$1I(axis.threshold, axis.softThreshold ? 0 : null);
    let len, i2, tickInterval = axis.tickInterval, thresholdTickIndex;
    const append = () => tickPositions.push(correctFloat$e(tickPositions[tickPositions.length - 1] + tickInterval)), prepend = () => tickPositions.unshift(correctFloat$e(tickPositions[0] - tickInterval));
    if (isNumber$11(thresholdAlignment)) {
      thresholdTickIndex = thresholdAlignment < 0.5 ? Math.ceil(thresholdAlignment * (tickAmount - 1)) : Math.floor(thresholdAlignment * (tickAmount - 1));
      if (options2.reversed) {
        thresholdTickIndex = tickAmount - 1 - thresholdTickIndex;
      }
    }
    if (axis.hasData() && isNumber$11(min2) && isNumber$11(max2)) {
      const adjustExtremes2 = () => {
        axis.transA *= (currentTickAmount - 1) / (tickAmount - 1);
        axis.min = options2.startOnTick ? tickPositions[0] : Math.min(min2, tickPositions[0]);
        axis.max = options2.endOnTick ? tickPositions[tickPositions.length - 1] : Math.max(max2, tickPositions[tickPositions.length - 1]);
      };
      if (isNumber$11(thresholdTickIndex) && isNumber$11(axis.threshold)) {
        while (tickPositions[thresholdTickIndex] !== threshold || tickPositions.length !== tickAmount || tickPositions[0] > min2 || tickPositions[tickPositions.length - 1] < max2) {
          tickPositions.length = 0;
          tickPositions.push(axis.threshold);
          while (tickPositions.length < tickAmount) {
            if (
              // Start by prepending positions until the threshold
              // is at the required index...
              tickPositions[thresholdTickIndex] === void 0 || tickPositions[thresholdTickIndex] > axis.threshold
            ) {
              prepend();
            } else {
              append();
            }
          }
          if (tickInterval > axis.tickInterval * 8) {
            break;
          }
          tickInterval *= 2;
        }
        adjustExtremes2();
      } else if (currentTickAmount < tickAmount) {
        while (tickPositions.length < tickAmount) {
          if (tickPositions.length % 2 || min2 === threshold) {
            append();
          } else {
            prepend();
          }
        }
        adjustExtremes2();
      }
      if (defined$16(finalTickAmt)) {
        i2 = len = tickPositions.length;
        while (i2--) {
          if (
            // Remove every other tick
            finalTickAmt === 3 && i2 % 2 === 1 || // Remove all but first and last
            finalTickAmt <= 2 && i2 > 0 && i2 < len - 1
          ) {
            tickPositions.splice(i2, 1);
          }
        }
        axis.finalTickAmt = void 0;
      }
    }
  }
  /**
   * Set the scale based on data min and max, user set min and max or options.
   *
   * @private
   * @function Highcharts.Axis#setScale
   *
   * @emits Highcharts.Axis#event:afterSetScale
   */
  setScale() {
    const axis = this, { coll, stacking } = axis;
    let isDirtyData = false, isXAxisDirty = false;
    axis.series.forEach((series) => {
      isDirtyData = isDirtyData || series.isDirtyData || series.isDirty;
      isXAxisDirty = isXAxisDirty || series.xAxis?.isDirty || false;
    });
    axis.setAxisSize();
    const isDirtyAxisLength = axis.len !== axis.old?.len;
    if (isDirtyAxisLength || isDirtyData || isXAxisDirty || axis.isLinked || axis.forceRedraw || axis.userMin !== axis.old?.userMin || axis.userMax !== axis.old?.userMax || axis.alignToOthers()) {
      if (stacking && coll === "yAxis") {
        stacking.buildStacks();
      }
      axis.forceRedraw = false;
      if (!axis.userMinRange) {
        axis.minRange = void 0;
      }
      axis.getSeriesExtremes();
      axis.setTickInterval();
      if (stacking && coll === "xAxis") {
        stacking.buildStacks();
      }
      if (!axis.isDirty) {
        axis.isDirty = isDirtyAxisLength || axis.min !== axis.old?.min || axis.max !== axis.old?.max;
      }
    } else if (stacking) {
      stacking.cleanStacks();
    }
    if (isDirtyData) {
      delete axis.allExtremes;
    }
    fireEvent$I(this, "afterSetScale");
  }
  /**
   * Set the minimum and maximum of the axes after render time. If the
   * `startOnTick` and `endOnTick` options are true, the minimum and maximum
   * values are rounded off to the nearest tick. To prevent this, these
   * options can be set to false before calling setExtremes. Also, setExtremes
   * will not allow a range lower than the `minRange` option, which by default
   * is the range of five points.
   *
   * @sample highcharts/members/axis-setextremes/
   *         Set extremes from a button
   * @sample highcharts/members/axis-setextremes-datetime/
   *         Set extremes on a datetime axis
   * @sample highcharts/members/axis-setextremes-off-ticks/
   *         Set extremes off ticks
   * @sample stock/members/axis-setextremes/
   *         Set extremes in Highcharts Stock
   *
   * @function Highcharts.Axis#setExtremes
   *
   * @param {number|string} [newMin]
   * The new minimum value. For datetime axes, date strings are accepted.
   *
   * @param {number|string} [newMax]
   * The new maximum value. For datetime axes, date strings are accepted.
   *
   * @param {boolean} [redraw=true]
   * Whether to redraw the chart or wait for an explicit call to
   * {@link Highcharts.Chart#redraw}
   *
   * @param {boolean|Partial<Highcharts.AnimationOptionsObject>} [animation=true]
   * Enable or modify animations.
   *
   * @param {*} [eventArguments]
   * Arguments to be accessed in event handler.
   *
   * @emits Highcharts.Axis#event:setExtremes
   */
  setExtremes(min2, max2, redraw = true, animation, eventArguments) {
    const chart = this.chart;
    this.series.forEach((serie) => {
      delete serie.kdTree;
    });
    min2 = chart.time.parse(min2);
    max2 = chart.time.parse(max2);
    eventArguments = extend$1k(eventArguments, { min: min2, max: max2 });
    fireEvent$I(this, "setExtremes", eventArguments, (e) => {
      this.userMin = e.min;
      this.userMax = e.max;
      this.eventArgs = e;
      if (redraw) {
        chart.redraw(animation);
      }
    });
  }
  /**
   * Update the axis metrics.
   *
   * @private
   * @function Highcharts.Axis#setAxisSize
   */
  setAxisSize() {
    const chart = this.chart, options2 = this.options, offsets = options2.offsets || [0, 0, 0, 0], horiz = this.horiz, width = this.width = Math.round(relativeLength$h(pick$1I(options2.width, chart.plotWidth - offsets[3] + offsets[1]), chart.plotWidth)), height = this.height = Math.round(relativeLength$h(pick$1I(options2.height, chart.plotHeight - offsets[0] + offsets[2]), chart.plotHeight)), top = this.top = Math.round(relativeLength$h(pick$1I(options2.top, chart.plotTop + offsets[0]), chart.plotHeight, chart.plotTop)), left = this.left = Math.round(relativeLength$h(pick$1I(options2.left, chart.plotLeft + offsets[3]), chart.plotWidth, chart.plotLeft));
    this.bottom = chart.chartHeight - height - top;
    this.right = chart.chartWidth - width - left;
    this.len = Math.max(horiz ? width : height, 0);
    this.pos = horiz ? left : top;
  }
  /**
   * Get the current extremes for the axis.
   *
   * @sample highcharts/members/axis-getextremes/
   *         Report extremes by click on a button
   *
   * @function Highcharts.Axis#getExtremes
   *
   * @return {Highcharts.ExtremesObject}
   * An object containing extremes information.
   */
  getExtremes() {
    const axis = this, log = axis.logarithmic;
    return {
      min: log ? correctFloat$e(log.lin2log(axis.min)) : axis.min,
      max: log ? correctFloat$e(log.lin2log(axis.max)) : axis.max,
      dataMin: axis.dataMin,
      dataMax: axis.dataMax,
      userMin: axis.userMin,
      userMax: axis.userMax
    };
  }
  /**
   * Get the zero plane either based on zero or on the min or max value.
   * Used in bar and area plots.
   *
   * @function Highcharts.Axis#getThreshold
   *
   * @param {number} threshold
   * The threshold in axis values.
   *
   * @return {number}
   * The translated threshold position in terms of pixels, and corrected to
   * stay within the axis bounds.
   */
  getThreshold(threshold) {
    const axis = this, log = axis.logarithmic, realMin = log ? log.lin2log(axis.min) : axis.min, realMax = log ? log.lin2log(axis.max) : axis.max;
    if (threshold === null || threshold === -Infinity) {
      threshold = realMin;
    } else if (threshold === Infinity) {
      threshold = realMax;
    } else if (realMin > threshold) {
      threshold = realMin;
    } else if (realMax < threshold) {
      threshold = realMax;
    }
    return axis.translate(threshold, 0, 1, 0, 1);
  }
  /**
   * Compute auto alignment for the axis label based on which side the axis is
   * on and the given rotation for the label.
   *
   * @private
   * @function Highcharts.Axis#autoLabelAlign
   *
   * @param {number} rotation
   * The rotation in degrees as set by either the `rotation` or `autoRotation`
   * options.
   *
   * @return {Highcharts.AlignValue}
   * Can be `"center"`, `"left"` or `"right"`.
   */
  autoLabelAlign(rotation) {
    const angle = (pick$1I(rotation, 0) - this.side * 90 + 720) % 360, evt = { align: "center" };
    fireEvent$I(this, "autoLabelAlign", evt, function(e) {
      if (angle > 15 && angle < 165) {
        e.align = "right";
      } else if (angle > 195 && angle < 345) {
        e.align = "left";
      }
    });
    return evt.align;
  }
  /**
   * Get the tick length and width for the axis based on axis options.
   *
   * @private
   * @function Highcharts.Axis#tickSize
   *
   * @param {string} [prefix]
   * 'tick' or 'minorTick'
   *
   * @return {Array<number,number>|undefined}
   * An array of tickLength and tickWidth
   */
  tickSize(prefix) {
    const options2 = this.options, tickWidth = pick$1I(
      options2[prefix === "tick" ? "tickWidth" : "minorTickWidth"],
      // Default to 1 on linear and datetime X axes
      prefix === "tick" && this.isXAxis && !this.categories ? 1 : 0
    );
    let tickLength = options2[prefix === "tick" ? "tickLength" : "minorTickLength"], tickSize;
    if (tickWidth && tickLength) {
      if (options2[prefix + "Position"] === "inside") {
        tickLength = -tickLength;
      }
      tickSize = [tickLength, tickWidth];
    }
    const e = { tickSize };
    fireEvent$I(this, "afterTickSize", e);
    return e.tickSize;
  }
  /**
   * Return the size of the labels.
   *
   * @private
   * @function Highcharts.Axis#labelMetrics
   */
  labelMetrics() {
    const renderer = this.chart.renderer, ticks = this.ticks, tick = ticks[Object.keys(ticks)[0]] || {};
    return this.chart.renderer.fontMetrics(tick.label || tick.movedLabel || renderer.box);
  }
  /**
   * Prevent the ticks from getting so close we can't draw the labels. On a
   * horizontal axis, this is handled by rotating the labels, removing ticks
   * and adding ellipsis. On a vertical axis remove ticks and add ellipsis.
   *
   * @private
   * @function Highcharts.Axis#unsquish
   */
  unsquish() {
    const labelOptions = this.options.labels, padding = labelOptions.padding || 0, horiz = this.horiz, tickInterval = this.tickInterval, slotSize = this.len / (((this.categories ? 1 : 0) + this.max - this.min) / tickInterval), rotationOption = labelOptions.rotation, lineHeight = correctFloat$e(this.labelMetrics().h * 0.8), range2 = Math.max(this.max - this.min, 0), getStep = function(spaceNeeded) {
      let step = (spaceNeeded + 2 * padding) / (slotSize || 1);
      step = step > 1 ? Math.ceil(step) : 1;
      if (step * tickInterval > range2 && spaceNeeded !== Infinity && slotSize !== Infinity && range2) {
        step = Math.ceil(range2 / tickInterval);
      }
      return correctFloat$e(step * tickInterval);
    };
    let newTickInterval = tickInterval, rotation, bestScore = Number.MAX_VALUE, autoRotation;
    if (horiz) {
      if (!labelOptions.staggerLines) {
        if (isNumber$11(rotationOption)) {
          autoRotation = [rotationOption];
        } else if (slotSize < labelOptions.autoRotationLimit) {
          autoRotation = labelOptions.autoRotation;
        }
      }
      if (autoRotation) {
        let step, score;
        for (const rot of autoRotation) {
          if (rot === rotationOption || rot && rot >= -90 && rot <= 90) {
            step = getStep(Math.abs(lineHeight / Math.sin(deg2rad$7 * rot)));
            score = step + Math.abs(rot / 360);
            if (score < bestScore) {
              bestScore = score;
              rotation = rot;
              newTickInterval = step;
            }
          }
        }
      }
    } else {
      newTickInterval = getStep(lineHeight * 0.75);
    }
    this.autoRotation = autoRotation;
    this.labelRotation = pick$1I(rotation, isNumber$11(rotationOption) ? rotationOption : 0);
    return labelOptions.step ? tickInterval : newTickInterval;
  }
  /**
   * Get the general slot width for labels/categories on this axis. This may
   * change between the pre-render (from Axis.getOffset) and the final tick
   * rendering and placement.
   *
   * @private
   * @function Highcharts.Axis#getSlotWidth
   *
   * @param {Highcharts.Tick} [tick] Optionally, calculate the slot width
   * basing on tick label. It is used in highcharts-3d module, where the slots
   * has different widths depending on perspective angles.
   *
   * @return {number}
   * The pixel width allocated to each axis label.
   */
  getSlotWidth(tick) {
    const chart = this.chart, horiz = this.horiz, labelOptions = this.options.labels, slotCount = Math.max(this.tickPositions.length - (this.categories ? 0 : 1), 1), marginLeft = chart.margin[3];
    if (tick && isNumber$11(tick.slotWidth)) {
      return tick.slotWidth;
    }
    if (horiz && labelOptions.step < 2 && !this.isRadial) {
      if (labelOptions.rotation) {
        return 0;
      }
      return (this.staggerLines || 1) * this.len / slotCount;
    }
    if (!horiz) {
      const cssWidth = labelOptions.style.width;
      if (cssWidth !== void 0) {
        return parseInt(String(cssWidth), 10);
      }
      if (marginLeft) {
        return marginLeft - chart.spacing[3];
      }
    }
    return chart.chartWidth * 0.33;
  }
  /**
   * Render the axis labels and determine whether ellipsis or rotation need to
   * be applied.
   *
   * @private
   * @function Highcharts.Axis#renderUnsquish
   */
  renderUnsquish() {
    const chart = this.chart, renderer = chart.renderer, tickPositions = this.tickPositions, ticks = this.ticks, labelOptions = this.options.labels, labelStyleOptions = labelOptions.style, horiz = this.horiz, slotWidth = this.getSlotWidth(), innerWidth = Math.max(1, Math.round(slotWidth - (horiz ? 2 * (labelOptions.padding || 0) : labelOptions.distance || 0))), attr2 = {}, labelMetrics = this.labelMetrics(), lineClampOption = labelStyleOptions.lineClamp;
    let commonWidth, lineClamp = lineClampOption ?? (Math.floor(this.len / (tickPositions.length * labelMetrics.h)) || 1), maxLabelLength = 0;
    if (!isString$d(labelOptions.rotation)) {
      attr2.rotation = labelOptions.rotation || 0;
    }
    tickPositions.forEach(function(tickPosition) {
      const tick = ticks[tickPosition];
      if (tick.movedLabel) {
        tick.replaceMovedLabel();
      }
      const textPxLength = tick.label?.textPxLength || 0;
      if (textPxLength > maxLabelLength) {
        maxLabelLength = textPxLength;
      }
    });
    this.maxLabelLength = maxLabelLength;
    if (this.autoRotation) {
      if (maxLabelLength > innerWidth && maxLabelLength > labelMetrics.h) {
        attr2.rotation = this.labelRotation;
      } else {
        this.labelRotation = 0;
      }
    } else if (slotWidth) {
      commonWidth = innerWidth;
    }
    if (attr2.rotation) {
      commonWidth = maxLabelLength > chart.chartHeight * 0.5 ? chart.chartHeight * 0.33 : maxLabelLength;
      if (!lineClampOption) {
        lineClamp = 1;
      }
    }
    this.labelAlign = labelOptions.align || this.autoLabelAlign(this.labelRotation);
    if (this.labelAlign) {
      attr2.align = this.labelAlign;
    }
    tickPositions.forEach(function(pos) {
      const tick = ticks[pos], label = tick?.label, widthOption = labelStyleOptions.width, css2 = {};
      if (label) {
        label.attr(attr2);
        if (tick.shortenLabel) {
          tick.shortenLabel();
        } else if (commonWidth && !widthOption && // Setting width in this case messes with the bounding box
        // (#7975)
        labelStyleOptions.whiteSpace !== "nowrap" && // Speed optimizing, #7656
        (commonWidth < (label.textPxLength || 0) || // Resetting CSS, #4928
        label.element.tagName === "SPAN")) {
          label.css(extend$1k(css2, {
            width: `${commonWidth}px`,
            lineClamp
          }));
        } else if (label.styles.width && !css2.width && !widthOption) {
          label.css({ width: "auto" });
        }
        tick.rotation = attr2.rotation;
      }
    }, this);
    this.tickRotCorr = renderer.rotCorr(labelMetrics.b, this.labelRotation || 0, this.side !== 0);
  }
  /**
   * Return true if the axis has associated data.
   *
   * @function Highcharts.Axis#hasData
   *
   * @return {boolean}
   * True if the axis has associated visible series and those series have
   * either valid data points or explicit `min` and `max` settings.
   */
  hasData() {
    return this.series.some(function(s) {
      return s.hasData();
    }) || this.options.showEmpty && defined$16(this.min) && defined$16(this.max);
  }
  /**
   * Adds the title defined in axis.options.title.
   *
   * @function Highcharts.Axis#addTitle
   *
   * @param {boolean} [display]
   * Whether or not to display the title.
   */
  addTitle(display) {
    const axis = this, renderer = axis.chart.renderer, horiz = axis.horiz, opposite = axis.opposite, options2 = axis.options, axisTitleOptions = options2.title, styledMode = axis.chart.styledMode;
    let textAlign;
    if (!axis.axisTitle) {
      textAlign = axisTitleOptions.textAlign;
      if (!textAlign) {
        textAlign = (horiz ? {
          low: "left",
          middle: "center",
          high: "right"
        } : {
          low: opposite ? "right" : "left",
          middle: "center",
          high: opposite ? "left" : "right"
        })[axisTitleOptions.align];
      }
      axis.axisTitle = renderer.text(axisTitleOptions.text || "", 0, 0, axisTitleOptions.useHTML).attr({
        zIndex: 7,
        rotation: axisTitleOptions.rotation || 0,
        align: textAlign
      }).addClass("highcharts-axis-title");
      if (!styledMode) {
        axis.axisTitle.css(merge$1B(axisTitleOptions.style));
      }
      axis.axisTitle.add(axis.axisGroup);
      axis.axisTitle.isNew = true;
    }
    if (!styledMode && !axisTitleOptions.style.width && !axis.isRadial) {
      axis.axisTitle.css({
        width: axis.len + "px"
      });
    }
    axis.axisTitle[display ? "show" : "hide"](display);
  }
  /**
   * Generates a tick for initial positioning.
   *
   * @private
   * @function Highcharts.Axis#generateTick
   *
   * @param {number} pos
   * The tick position in axis values.
   *
   * @param {number} [i]
   * The index of the tick in {@link Axis.tickPositions}.
   */
  generateTick(pos) {
    const axis = this, ticks = axis.ticks;
    if (!ticks[pos]) {
      ticks[pos] = new Tick(axis, pos);
    } else {
      ticks[pos].addLabel();
    }
  }
  /**
   * Create the axisGroup and gridGroup elements on first iteration.
   *
   * @private
   * @function Highcharts.Axis#getOffset
   *
   * @emits Highcharts.Axis#event:afterGetOffset
   */
  createGroups() {
    const {
      axisParent,
      // Used in color axis
      chart,
      coll,
      options: options2
    } = this, renderer = chart.renderer;
    const createGroup = (name, suffix, zIndex) => renderer.g(name).attr({ zIndex }).addClass(`highcharts-${coll.toLowerCase()}${suffix} ` + (this.isRadial ? `highcharts-radial-axis${suffix} ` : "") + (options2.className || "")).add(axisParent);
    if (!this.axisGroup) {
      this.gridGroup = createGroup("grid", "-grid", options2.gridZIndex);
      this.axisGroup = createGroup("axis", "", options2.zIndex);
      this.labelGroup = createGroup("axis-labels", "-labels", options2.labels.zIndex);
    }
  }
  /**
   * Render the tick labels to a preliminary position to get their sizes
   *
   * @private
   * @function Highcharts.Axis#getOffset
   *
   * @emits Highcharts.Axis#event:afterGetOffset
   */
  getOffset() {
    const axis = this, { chart, horiz, options: options2, side, ticks, tickPositions, coll } = axis, invertedSide = chart.inverted && !axis.isZAxis ? [1, 0, 3, 2][side] : side, hasData = axis.hasData(), axisTitleOptions = options2.title, labelOptions = options2.labels, hasCrossing = isNumber$11(options2.crossing), axisOffset = chart.axisOffset, clipOffset = chart.clipOffset, directionFactor = [-1, 1, 1, -1][side];
    let showAxis, titleOffset = 0, titleOffsetOption, titleMargin = 0, labelOffset = 0, labelOffsetPadded, lineHeightCorrection;
    axis.showAxis = showAxis = hasData || options2.showEmpty;
    axis.staggerLines = axis.horiz && labelOptions.staggerLines || void 0;
    axis.createGroups();
    if (hasData || axis.isLinked) {
      tickPositions.forEach(function(pos) {
        axis.generateTick(pos);
      });
      axis.renderUnsquish();
      axis.reserveSpaceDefault = side === 0 || side === 2 || { 1: "left", 3: "right" }[side] === axis.labelAlign;
      if (pick$1I(labelOptions.reserveSpace, hasCrossing ? false : null, axis.labelAlign === "center" ? true : null, axis.reserveSpaceDefault)) {
        tickPositions.forEach(function(pos) {
          labelOffset = Math.max(ticks[pos].getLabelSize(), labelOffset);
        });
      }
      if (axis.staggerLines) {
        labelOffset *= axis.staggerLines;
      }
      axis.labelOffset = labelOffset * (axis.opposite ? -1 : 1);
    } else {
      objectEach$q(ticks, function(tick, n2) {
        tick.destroy();
        delete ticks[n2];
      });
    }
    if (axisTitleOptions?.text && axisTitleOptions.enabled !== false) {
      axis.addTitle(showAxis);
      if (showAxis && !hasCrossing && axisTitleOptions.reserveSpace !== false) {
        axis.titleOffset = titleOffset = axis.axisTitle.getBBox()[horiz ? "height" : "width"];
        titleOffsetOption = axisTitleOptions.offset;
        titleMargin = defined$16(titleOffsetOption) ? 0 : pick$1I(axisTitleOptions.margin, horiz ? 5 : 10);
      }
    }
    axis.renderLine();
    axis.offset = directionFactor * pick$1I(options2.offset, axisOffset[side] ? axisOffset[side] + (options2.margin || 0) : 0);
    axis.tickRotCorr = axis.tickRotCorr || { x: 0, y: 0 };
    if (side === 0) {
      lineHeightCorrection = -axis.labelMetrics().h;
    } else if (side === 2) {
      lineHeightCorrection = axis.tickRotCorr.y;
    } else {
      lineHeightCorrection = 0;
    }
    labelOffsetPadded = Math.abs(labelOffset) + titleMargin;
    if (labelOffset) {
      labelOffsetPadded -= lineHeightCorrection;
      labelOffsetPadded += directionFactor * (horiz ? pick$1I(labelOptions.y, axis.tickRotCorr.y + directionFactor * labelOptions.distance) : pick$1I(labelOptions.x, directionFactor * labelOptions.distance));
    }
    axis.axisTitleMargin = pick$1I(titleOffsetOption, labelOffsetPadded);
    if (axis.getMaxLabelDimensions) {
      axis.maxLabelDimensions = axis.getMaxLabelDimensions(ticks, tickPositions);
    }
    if (coll !== "colorAxis" && clipOffset) {
      const tickSize = this.tickSize("tick");
      axisOffset[side] = Math.max(
        axisOffset[side],
        (axis.axisTitleMargin || 0) + titleOffset + directionFactor * axis.offset,
        labelOffsetPadded,
        // #3027
        tickPositions?.length && tickSize ? tickSize[0] + directionFactor * axis.offset : 0
        // #4866
      );
      const clip = !axis.axisLine || options2.offset ? 0 : (
        // #4308, #4371
        axis.axisLine.strokeWidth() / 2
      );
      clipOffset[invertedSide] = Math.max(clipOffset[invertedSide], clip);
    }
    fireEvent$I(this, "afterGetOffset");
  }
  /**
   * Internal function to get the path for the axis line. Extended for polar
   * charts.
   *
   * @function Highcharts.Axis#getLinePath
   *
   * @param {number} lineWidth
   * The line width in pixels.
   *
   * @return {Highcharts.SVGPathArray}
   * The SVG path definition in array form.
   */
  getLinePath(lineWidth) {
    const chart = this.chart, opposite = this.opposite, offset2 = this.offset, horiz = this.horiz, lineLeft = this.left + (opposite ? this.width : 0) + offset2, lineTop = chart.chartHeight - this.bottom - (opposite ? this.height : 0) + offset2;
    if (opposite) {
      lineWidth *= -1;
    }
    return chart.renderer.crispLine([
      [
        "M",
        horiz ? this.left : lineLeft,
        horiz ? lineTop : this.top
      ],
      [
        "L",
        horiz ? chart.chartWidth - this.right : lineLeft,
        horiz ? lineTop : chart.chartHeight - this.bottom
      ]
    ], lineWidth);
  }
  /**
   * Render the axis line. Called internally when rendering and redrawing the
   * axis.
   *
   * @function Highcharts.Axis#renderLine
   */
  renderLine() {
    if (!this.axisLine) {
      this.axisLine = this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup);
      if (!this.chart.styledMode) {
        this.axisLine.attr({
          stroke: this.options.lineColor,
          "stroke-width": this.options.lineWidth,
          zIndex: 7
        });
      }
    }
  }
  /**
   * Position the axis title.
   *
   * @private
   * @function Highcharts.Axis#getTitlePosition
   *
   * @return {Highcharts.PositionObject}
   * X and Y positions for the title.
   */
  getTitlePosition(axisTitle) {
    const horiz = this.horiz, axisLeft = this.left, axisTop = this.top, axisLength = this.len, axisTitleOptions = this.options.title, margin = horiz ? axisLeft : axisTop, opposite = this.opposite, offset2 = this.offset, xOption = axisTitleOptions.x, yOption = axisTitleOptions.y, fontMetrics = this.chart.renderer.fontMetrics(axisTitle), textHeightOvershoot = axisTitle ? Math.max(axisTitle.getBBox(false, 0).height - fontMetrics.h - 1, 0) : 0, alongAxis = {
      low: margin + (horiz ? 0 : axisLength),
      middle: margin + axisLength / 2,
      high: margin + (horiz ? axisLength : 0)
    }[axisTitleOptions.align], offAxis = (horiz ? axisTop + this.height : axisLeft) + (horiz ? 1 : -1) * // Horizontal axis reverses the margin
    (opposite ? -1 : 1) * // So does opposite axes
    (this.axisTitleMargin || 0) + [
      -textHeightOvershoot,
      // Top
      textHeightOvershoot,
      // Right
      fontMetrics.f,
      // Bottom
      -textHeightOvershoot
      // Left
    ][this.side], titlePosition = {
      x: horiz ? alongAxis + xOption : offAxis + (opposite ? this.width : 0) + offset2 + xOption,
      y: horiz ? offAxis + yOption - (opposite ? this.height : 0) + offset2 : alongAxis + yOption
    };
    fireEvent$I(this, "afterGetTitlePosition", { titlePosition });
    return titlePosition;
  }
  /**
   * Render a minor tick into the given position. If a minor tick already
   * exists in this position, move it.
   *
   * @function Highcharts.Axis#renderMinorTick
   *
   * @param {number} pos
   * The position in axis values.
   *
   * @param {boolean} slideIn
   * Whether the tick should animate in from last computed position
   */
  renderMinorTick(pos, slideIn) {
    const axis = this;
    const minorTicks = axis.minorTicks;
    if (!minorTicks[pos]) {
      minorTicks[pos] = new Tick(axis, pos, "minor");
    }
    if (slideIn && minorTicks[pos].isNew) {
      minorTicks[pos].render(null, true);
    }
    minorTicks[pos].render(null, false, 1);
  }
  /**
   * Render a major tick into the given position. If a tick already exists
   * in this position, move it.
   *
   * @function Highcharts.Axis#renderTick
   *
   * @param {number} pos
   * The position in axis values.
   *
   * @param {number} i
   * The tick index.
   *
   * @param {boolean} slideIn
   * Whether the tick should animate in from last computed position
   */
  renderTick(pos, i2, slideIn) {
    const axis = this, isLinked = axis.isLinked, ticks = axis.ticks;
    if (!isLinked || pos >= axis.min && pos <= axis.max || axis.grid?.isColumn) {
      if (!ticks[pos]) {
        ticks[pos] = new Tick(axis, pos);
      }
      if (slideIn && ticks[pos].isNew) {
        ticks[pos].render(i2, true, -1);
      }
      ticks[pos].render(i2);
    }
  }
  /**
   * Render the axis.
   *
   * @private
   * @function Highcharts.Axis#render
   *
   * @emits Highcharts.Axis#event:afterRender
   */
  render() {
    const axis = this, chart = axis.chart, log = axis.logarithmic, renderer = chart.renderer, options2 = axis.options, isLinked = axis.isLinked, tickPositions = axis.tickPositions, axisTitle = axis.axisTitle, ticks = axis.ticks, minorTicks = axis.minorTicks, alternateBands = axis.alternateBands, stackLabelOptions = options2.stackLabels, alternateGridColor = options2.alternateGridColor, crossing = options2.crossing, tickmarkOffset = axis.tickmarkOffset, axisLine = axis.axisLine, showAxis = axis.showAxis, animation = animObject$e(renderer.globalAnimation);
    let from, to;
    axis.labelEdge.length = 0;
    axis.overlap = false;
    [ticks, minorTicks, alternateBands].forEach(function(coll) {
      objectEach$q(coll, function(tick) {
        tick.isActive = false;
      });
    });
    if (isNumber$11(crossing)) {
      const otherAxis = this.isXAxis ? chart.yAxis[0] : chart.xAxis[0], directionFactor = [1, -1, -1, 1][this.side];
      if (otherAxis) {
        let px = otherAxis.toPixels(crossing, true);
        if (axis.horiz) {
          px = otherAxis.len - px;
        }
        axis.offset = directionFactor * px;
      }
    }
    if (axis.hasData() || isLinked) {
      const slideInTicks = axis.chart.hasRendered && axis.old && isNumber$11(axis.old.min);
      if (axis.minorTickInterval && !axis.categories) {
        axis.getMinorTickPositions().forEach(function(pos) {
          axis.renderMinorTick(pos, slideInTicks);
        });
      }
      if (tickPositions.length) {
        tickPositions.forEach(function(pos, i2) {
          axis.renderTick(pos, i2, slideInTicks);
        });
        if (tickmarkOffset && (axis.min === 0 || axis.single)) {
          if (!ticks[-1]) {
            ticks[-1] = new Tick(axis, -1, null, true);
          }
          ticks[-1].render(-1);
        }
      }
      if (alternateGridColor) {
        tickPositions.forEach(function(pos, i2) {
          to = typeof tickPositions[i2 + 1] !== "undefined" ? tickPositions[i2 + 1] + tickmarkOffset : axis.max - tickmarkOffset;
          if (i2 % 2 === 0 && pos < axis.max && to <= axis.max + (chart.polar ? -tickmarkOffset : tickmarkOffset)) {
            if (!alternateBands[pos]) {
              alternateBands[pos] = new Highcharts.PlotLineOrBand(axis, {});
            }
            from = pos + tickmarkOffset;
            alternateBands[pos].options = {
              from: log ? log.lin2log(from) : from,
              to: log ? log.lin2log(to) : to,
              color: alternateGridColor,
              className: "highcharts-alternate-grid"
            };
            alternateBands[pos].render();
            alternateBands[pos].isActive = true;
          }
        });
      }
      if (!axis._addedPlotLB) {
        axis._addedPlotLB = true;
        (options2.plotLines || []).concat(options2.plotBands || []).forEach(function(plotLineOptions) {
          axis.addPlotBandOrLine(plotLineOptions);
        });
      }
    }
    [ticks, minorTicks, alternateBands].forEach(function(coll) {
      const forDestruction = [], delay = animation.duration, destroyInactiveItems = function() {
        let i2 = forDestruction.length;
        while (i2--) {
          if (coll[forDestruction[i2]] && !coll[forDestruction[i2]].isActive) {
            coll[forDestruction[i2]].destroy();
            delete coll[forDestruction[i2]];
          }
        }
      };
      objectEach$q(coll, function(tick, pos) {
        if (!tick.isActive) {
          tick.render(pos, false, 0);
          tick.isActive = false;
          forDestruction.push(pos);
        }
      });
      syncTimeout$a(destroyInactiveItems, coll === alternateBands || !chart.hasRendered || !delay ? 0 : delay);
    });
    if (axisLine) {
      axisLine[axisLine.isPlaced ? "animate" : "attr"]({
        d: this.getLinePath(axisLine.strokeWidth())
      });
      axisLine.isPlaced = true;
      axisLine[showAxis ? "show" : "hide"](showAxis);
    }
    if (axisTitle && showAxis) {
      axisTitle[axisTitle.isNew ? "attr" : "animate"](axis.getTitlePosition(axisTitle));
      axisTitle.isNew = false;
    }
    if (stackLabelOptions?.enabled && axis.stacking) {
      axis.stacking.renderStackTotals();
    }
    axis.old = {
      len: axis.len,
      max: axis.max,
      min: axis.min,
      transA: axis.transA,
      userMax: axis.userMax,
      userMin: axis.userMin
    };
    axis.isDirty = false;
    fireEvent$I(this, "afterRender");
  }
  /**
   * Redraw the axis to reflect changes in the data or axis extremes. Called
   * internally from Highcharts.Chart#redraw.
   *
   * @private
   * @function Highcharts.Axis#redraw
   */
  redraw() {
    if (this.visible) {
      this.render();
      this.plotLinesAndBands.forEach(function(plotLine) {
        plotLine.render();
      });
    }
    this.series.forEach(function(series) {
      series.isDirty = true;
    });
  }
  /**
   * Returns an array of axis properties, that should be untouched during
   * reinitialization.
   *
   * @private
   * @function Highcharts.Axis#getKeepProps
   */
  getKeepProps() {
    return this.keepProps || Axis.keepProps;
  }
  /**
   * Destroys an Axis instance. See {@link Axis#remove} for the API endpoint
   * to fully remove the axis.
   *
   * @private
   * @function Highcharts.Axis#destroy
   *
   * @param {boolean} [keepEvents]
   * Whether to preserve events, used internally in Axis.update.
   */
  destroy(keepEvents) {
    const axis = this, plotLinesAndBands = axis.plotLinesAndBands, eventOptions = this.eventOptions;
    fireEvent$I(this, "destroy", { keepEvents });
    if (!keepEvents) {
      removeEvent$a(axis);
    }
    [axis.ticks, axis.minorTicks, axis.alternateBands].forEach(function(coll) {
      destroyObjectProperties$8(coll);
    });
    if (plotLinesAndBands) {
      let i2 = plotLinesAndBands.length;
      while (i2--) {
        plotLinesAndBands[i2].destroy();
      }
    }
    [
      "axisLine",
      "axisTitle",
      "axisGroup",
      "gridGroup",
      "labelGroup",
      "cross",
      "scrollbar"
    ].forEach(function(prop) {
      if (axis[prop]) {
        axis[prop] = axis[prop].destroy();
      }
    });
    for (const plotGroup in axis.plotLinesAndBandsGroups) {
      axis.plotLinesAndBandsGroups[plotGroup] = axis.plotLinesAndBandsGroups[plotGroup].destroy();
    }
    objectEach$q(axis, function(val, key2) {
      if (axis.getKeepProps().indexOf(key2) === -1) {
        delete axis[key2];
      }
    });
    this.eventOptions = eventOptions;
  }
  /**
   * Internal function to draw a crosshair.
   *
   * @function Highcharts.Axis#drawCrosshair
   *
   * @param {Highcharts.PointerEventObject} [e]
   * The event arguments from the modified pointer event, extended with
   * `chartX` and `chartY`
   *
   * @param {Highcharts.Point} [point]
   * The Point object if the crosshair snaps to points.
   *
   * @emits Highcharts.Axis#event:afterDrawCrosshair
   * @emits Highcharts.Axis#event:drawCrosshair
   */
  drawCrosshair(e, point) {
    const options2 = this.crosshair, snap2 = options2?.snap ?? true, chart = this.chart;
    let path, pos, categorized, graphic = this.cross, crossOptions;
    fireEvent$I(this, "drawCrosshair", { e, point });
    if (!e) {
      e = this.cross?.e;
    }
    if (
      // Disabled in options
      !options2 || // Snap
      (defined$16(point) || !snap2) === false
    ) {
      this.hideCrosshair();
    } else {
      if (!snap2) {
        pos = e && (this.horiz ? e.chartX - this.pos : this.len - e.chartY + this.pos);
      } else if (defined$16(point)) {
        pos = pick$1I(this.coll !== "colorAxis" ? point.crosshairPos : (
          // 3D axis extension
          null
        ), this.isXAxis ? point.plotX : this.len - point.plotY);
      }
      if (defined$16(pos)) {
        crossOptions = {
          // Value, only used on radial
          value: point && (this.isXAxis ? point.x : pick$1I(point.stackY, point.y)),
          translatedValue: pos
        };
        if (chart.polar) {
          extend$1k(crossOptions, {
            isCrosshair: true,
            chartX: e?.chartX,
            chartY: e?.chartY,
            point
          });
        }
        path = this.getPlotLinePath(crossOptions) || null;
      }
      if (!defined$16(path)) {
        this.hideCrosshair();
        return;
      }
      categorized = this.categories && !this.isRadial;
      if (!graphic) {
        this.cross = graphic = chart.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-" + (categorized ? "category " : "thin ") + (options2.className || "")).attr({
          zIndex: pick$1I(options2.zIndex, 2)
        }).add();
        if (!chart.styledMode) {
          graphic.attr({
            stroke: options2.color || (categorized ? Color.parse(
              "#ccd3ff"
              /* Palette.highlightColor20 */
            ).setOpacity(0.25).get() : "#cccccc"),
            "stroke-width": pick$1I(options2.width, 1)
          }).css({
            "pointer-events": "none"
          });
          if (options2.dashStyle) {
            graphic.attr({
              dashstyle: options2.dashStyle
            });
          }
        }
      }
      graphic.show().attr({
        d: path
      });
      if (categorized && !options2.width) {
        graphic.attr({
          "stroke-width": this.transA
        });
      }
      this.cross.e = e;
    }
    fireEvent$I(this, "afterDrawCrosshair", { e, point });
  }
  /**
   * Hide the crosshair if visible.
   *
   * @function Highcharts.Axis#hideCrosshair
   */
  hideCrosshair() {
    if (this.cross) {
      this.cross.hide();
    }
    fireEvent$I(this, "afterHideCrosshair");
  }
  /**
   * Update an axis object with a new set of options. The options are merged
   * with the existing options, so only new or altered options need to be
   * specified.
   *
   * @sample highcharts/members/axis-update/
   *         Axis update demo
   *
   * @function Highcharts.Axis#update
   *
   * @param {Highcharts.AxisOptions} options
   * The new options that will be merged in with existing options on the axis.
   *
   * @param {boolean} [redraw=true]
   * Whether to redraw the chart after the axis is altered. If doing more
   * operations on the chart, it is a good idea to set redraw to false and
   * call {@link Chart#redraw} after.
   */
  update(options2, redraw) {
    const chart = this.chart;
    options2 = merge$1B(this.userOptions, options2);
    this.destroy(true);
    this.init(chart, options2);
    chart.isDirtyBox = true;
    if (pick$1I(redraw, true)) {
      chart.redraw();
    }
  }
  /**
   * Remove the axis from the chart.
   *
   * @sample highcharts/members/chart-addaxis/
   *         Add and remove axes
   *
   * @function Highcharts.Axis#remove
   *
   * @param {boolean} [redraw=true]
   * Whether to redraw the chart following the remove.
   */
  remove(redraw) {
    const chart = this.chart, coll = this.coll, axisSeries = this.series;
    let i2 = axisSeries.length;
    while (i2--) {
      if (axisSeries[i2]) {
        axisSeries[i2].remove(false);
      }
    }
    erase$a(chart.axes, this);
    erase$a(chart[coll] || [], this);
    chart.orderItems(coll);
    this.destroy();
    chart.isDirtyBox = true;
    if (pick$1I(redraw, true)) {
      chart.redraw();
    }
  }
  /**
   * Update the axis title by options after render time.
   *
   * @sample highcharts/members/axis-settitle/
   *         Set a new Y axis title
   *
   * @function Highcharts.Axis#setTitle
   *
   * @param {Highcharts.AxisTitleOptions} titleOptions
   * The additional title options.
   *
   * @param {boolean} [redraw=true]
   * Whether to redraw the chart after setting the title.
   */
  setTitle(titleOptions, redraw) {
    this.update({ title: titleOptions }, redraw);
  }
  /**
   * Set new axis categories and optionally redraw.
   *
   * @sample highcharts/members/axis-setcategories/
   *         Set categories by click on a button
   *
   * @function Highcharts.Axis#setCategories
   *
   * @param {Array<string>} categories
   * The new categories.
   *
   * @param {boolean} [redraw=true]
   * Whether to redraw the chart.
   */
  setCategories(categories, redraw) {
    this.update({ categories }, redraw);
  }
}
Axis.keepProps = [
  "coll",
  "extKey",
  "hcEvents",
  "len",
  "names",
  "series",
  "userMax",
  "userMin"
];
const { addEvent: addEvent$1s, getMagnitude, normalizeTickInterval: normalizeTickInterval$1, timeUnits: timeUnits$2 } = Utilities;
var DateTimeAxis;
(function(DateTimeAxis2) {
  function compose2(AxisClass) {
    if (!AxisClass.keepProps.includes("dateTime")) {
      AxisClass.keepProps.push("dateTime");
      const axisProto = AxisClass.prototype;
      axisProto.getTimeTicks = getTimeTicks;
      addEvent$1s(AxisClass, "afterSetType", onAfterSetType);
    }
    return AxisClass;
  }
  DateTimeAxis2.compose = compose2;
  function getTimeTicks() {
    return this.chart.time.getTimeTicks.apply(this.chart.time, arguments);
  }
  function onAfterSetType() {
    if (this.type !== "datetime") {
      this.dateTime = void 0;
      return;
    }
    if (!this.dateTime) {
      this.dateTime = new Additions(this);
    }
  }
  class Additions {
    /* *
     *
     *  Constructors
     *
     * */
    constructor(axis) {
      this.axis = axis;
    }
    /* *
     *
     *  Functions
     *
     * */
    /**
     * Get a normalized tick interval for dates. Returns a configuration
     * object with unit range (interval), count and name. Used to prepare
     * data for `getTimeTicks`. Previously this logic was part of
     * getTimeTicks, but as `getTimeTicks` now runs of segments in stock
     * charts, the normalizing logic was extracted in order to prevent it
     * for running over again for each segment having the same interval.
     * #662, #697.
     * @private
     */
    normalizeTimeTickInterval(tickInterval, unitsOption) {
      const units2 = unitsOption || [[
        // Unit name
        "millisecond",
        // Allowed multiples
        [1, 2, 5, 10, 20, 25, 50, 100, 200, 500]
      ], [
        "second",
        [1, 2, 5, 10, 15, 30]
      ], [
        "minute",
        [1, 2, 5, 10, 15, 30]
      ], [
        "hour",
        [1, 2, 3, 4, 6, 8, 12]
      ], [
        "day",
        [1, 2]
      ], [
        "week",
        [1, 2]
      ], [
        "month",
        [1, 2, 3, 4, 6]
      ], [
        "year",
        null
      ]];
      let unit = units2[units2.length - 1], interval = timeUnits$2[unit[0]], multiples = unit[1], i2;
      for (i2 = 0; i2 < units2.length; i2++) {
        unit = units2[i2];
        interval = timeUnits$2[unit[0]];
        multiples = unit[1];
        if (units2[i2 + 1]) {
          const lessThan = (interval * multiples[multiples.length - 1] + timeUnits$2[units2[i2 + 1][0]]) / 2;
          if (tickInterval <= lessThan) {
            break;
          }
        }
      }
      if (interval === timeUnits$2.year && tickInterval < 5 * interval) {
        multiples = [1, 2, 5];
      }
      const count = normalizeTickInterval$1(tickInterval / interval, multiples, unit[0] === "year" ? (
        // #1913, #2360
        Math.max(getMagnitude(tickInterval / interval), 1)
      ) : 1);
      return {
        unitRange: interval,
        count,
        unitName: unit[0]
      };
    }
    /**
     * Get the best date format for a specific X value based on the closest
     * point range on the axis.
     *
     * @private
     */
    getXDateFormat(x, dateTimeLabelFormats) {
      const { axis } = this, time = axis.chart.time;
      return axis.closestPointRange ? time.getDateFormat(axis.closestPointRange, x, axis.options.startOfWeek, dateTimeLabelFormats) || // #2546, 2581
      time.resolveDTLFormat(dateTimeLabelFormats.year).main : time.resolveDTLFormat(dateTimeLabelFormats.day).main;
    }
  }
  DateTimeAxis2.Additions = Additions;
})(DateTimeAxis || (DateTimeAxis = {}));
const DateTimeAxis$1 = DateTimeAxis;
const { addEvent: addEvent$1r, normalizeTickInterval, pick: pick$1H } = Utilities;
var LogarithmicAxis;
(function(LogarithmicAxis2) {
  function compose2(AxisClass) {
    if (!AxisClass.keepProps.includes("logarithmic")) {
      AxisClass.keepProps.push("logarithmic");
      addEvent$1r(AxisClass, "afterSetType", onAfterSetType);
      addEvent$1r(AxisClass, "afterInit", onAfterInit2);
    }
    return AxisClass;
  }
  LogarithmicAxis2.compose = compose2;
  function onAfterSetType() {
    if (this.type !== "logarithmic") {
      this.logarithmic = void 0;
    } else {
      this.logarithmic ?? (this.logarithmic = new Additions(this));
    }
  }
  function onAfterInit2() {
    const axis = this;
    const log = axis.logarithmic;
    if (log) {
      axis.lin2val = function(num) {
        return log.lin2log(num);
      };
      axis.val2lin = function(num) {
        return log.log2lin(num);
      };
    }
  }
  class Additions {
    /* *
    *
    *  Constructors
    *
    * */
    constructor(axis) {
      this.axis = axis;
    }
    /* *
    *
    *  Functions
    *
    * */
    /**
     * Set the tick positions of a logarithmic axis.
     */
    getLogTickPositions(interval, min2, max2, minor) {
      const log = this;
      const axis = log.axis;
      const axisLength = axis.len;
      const options2 = axis.options;
      let positions = [];
      if (!minor) {
        log.minorAutoInterval = void 0;
      }
      if (interval >= 0.5) {
        interval = Math.round(interval);
        positions = axis.getLinearTickPositions(interval, min2, max2);
      } else if (interval >= 0.08) {
        const roundedMin = Math.floor(min2);
        let intermediate, i2, j, len, pos, lastPos, break2;
        if (interval > 0.3) {
          intermediate = [1, 2, 4];
        } else if (interval > 0.15) {
          intermediate = [1, 2, 4, 6, 8];
        } else {
          intermediate = [1, 2, 3, 4, 5, 6, 7, 8, 9];
        }
        for (i2 = roundedMin; i2 < max2 + 1 && !break2; i2++) {
          len = intermediate.length;
          for (j = 0; j < len && !break2; j++) {
            pos = log.log2lin(log.lin2log(i2) * intermediate[j]);
            if (pos > min2 && (!minor || lastPos <= max2) && typeof lastPos !== "undefined") {
              positions.push(lastPos);
            }
            if (lastPos > max2) {
              break2 = true;
            }
            lastPos = pos;
          }
        }
      } else {
        const realMin = log.lin2log(min2), realMax = log.lin2log(max2), tickIntervalOption = minor ? axis.getMinorTickInterval() : options2.tickInterval, filteredTickIntervalOption = tickIntervalOption === "auto" ? null : tickIntervalOption, tickPixelIntervalOption = options2.tickPixelInterval / (minor ? 5 : 1), totalPixelLength = minor ? axisLength / axis.tickPositions.length : axisLength;
        interval = pick$1H(filteredTickIntervalOption, log.minorAutoInterval, (realMax - realMin) * tickPixelIntervalOption / (totalPixelLength || 1));
        interval = normalizeTickInterval(interval);
        positions = axis.getLinearTickPositions(interval, realMin, realMax).map(log.log2lin);
        if (!minor) {
          log.minorAutoInterval = interval / 5;
        }
      }
      if (!minor) {
        axis.tickInterval = interval;
      }
      return positions;
    }
    lin2log(num) {
      return Math.pow(10, num);
    }
    log2lin(num) {
      return Math.log(num) / Math.LN10;
    }
  }
  LogarithmicAxis2.Additions = Additions;
})(LogarithmicAxis || (LogarithmicAxis = {}));
const LogarithmicAxis$1 = LogarithmicAxis;
const { erase: erase$9, extend: extend$1j, isNumber: isNumber$10 } = Utilities;
var PlotLineOrBandAxis;
(function(PlotLineOrBandAxis2) {
  let PlotLineOrBandClass;
  function addPlotBand(options2) {
    return this.addPlotBandOrLine(options2, "plotBands");
  }
  function addPlotBandOrLine(options2, coll) {
    const userOptions = this.userOptions;
    let obj = new PlotLineOrBandClass(this, options2);
    if (this.visible) {
      obj = obj.render();
    }
    if (obj) {
      if (!this._addedPlotLB) {
        this._addedPlotLB = true;
        (userOptions.plotLines || []).concat(userOptions.plotBands || []).forEach((plotLineOptions) => {
          this.addPlotBandOrLine(plotLineOptions);
        });
      }
      if (coll) {
        const updatedOptions = userOptions[coll] || [];
        updatedOptions.push(options2);
        userOptions[coll] = updatedOptions;
      }
      this.plotLinesAndBands.push(obj);
    }
    return obj;
  }
  function addPlotLine(options2) {
    return this.addPlotBandOrLine(options2, "plotLines");
  }
  function compose2(PlotLineOrBandType, AxisClass) {
    const axisProto = AxisClass.prototype;
    if (!axisProto.addPlotBand) {
      PlotLineOrBandClass = PlotLineOrBandType;
      extend$1j(axisProto, {
        addPlotBand,
        addPlotLine,
        addPlotBandOrLine,
        getPlotBandPath,
        removePlotBand,
        removePlotLine,
        removePlotBandOrLine
      });
    }
    return AxisClass;
  }
  PlotLineOrBandAxis2.compose = compose2;
  function getPlotBandPath(from, to, options2) {
    options2 = options2 || this.options;
    const toPath = this.getPlotLinePath({
      value: to,
      force: true,
      acrossPanes: options2.acrossPanes
    }), result = [], horiz = this.horiz, outside = !isNumber$10(this.min) || !isNumber$10(this.max) || from < this.min && to < this.min || from > this.max && to > this.max, path = this.getPlotLinePath({
      value: from,
      force: true,
      acrossPanes: options2.acrossPanes
    });
    let i2, plus = 1, isFlat;
    if (path && toPath) {
      if (outside) {
        isFlat = path.toString() === toPath.toString();
        plus = 0;
      }
      for (i2 = 0; i2 < path.length; i2 += 2) {
        const pathStart = path[i2], pathEnd = path[i2 + 1], toPathStart = toPath[i2], toPathEnd = toPath[i2 + 1];
        if ((pathStart[0] === "M" || pathStart[0] === "L") && (pathEnd[0] === "M" || pathEnd[0] === "L") && (toPathStart[0] === "M" || toPathStart[0] === "L") && (toPathEnd[0] === "M" || toPathEnd[0] === "L")) {
          if (horiz && toPathStart[1] === pathStart[1]) {
            toPathStart[1] += plus;
            toPathEnd[1] += plus;
          } else if (!horiz && toPathStart[2] === pathStart[2]) {
            toPathStart[2] += plus;
            toPathEnd[2] += plus;
          }
          result.push(["M", pathStart[1], pathStart[2]], ["L", pathEnd[1], pathEnd[2]], ["L", toPathEnd[1], toPathEnd[2]], ["L", toPathStart[1], toPathStart[2]], ["Z"]);
        }
        result.isFlat = isFlat;
      }
    }
    return result;
  }
  function removePlotBand(id) {
    this.removePlotBandOrLine(id);
  }
  function removePlotBandOrLine(id) {
    const plotLinesAndBands = this.plotLinesAndBands, options2 = this.options, userOptions = this.userOptions;
    if (plotLinesAndBands) {
      let i2 = plotLinesAndBands.length;
      while (i2--) {
        if (plotLinesAndBands[i2].id === id) {
          plotLinesAndBands[i2].destroy();
        }
      }
      [
        options2.plotLines || [],
        userOptions.plotLines || [],
        options2.plotBands || [],
        userOptions.plotBands || []
      ].forEach(function(arr) {
        i2 = arr.length;
        while (i2--) {
          if (arr[i2]?.id === id) {
            erase$9(arr, arr[i2]);
          }
        }
      });
    }
  }
  function removePlotLine(id) {
    this.removePlotBandOrLine(id);
  }
})(PlotLineOrBandAxis || (PlotLineOrBandAxis = {}));
const PlotLineOrBandAxis$1 = PlotLineOrBandAxis;
const { addEvent: addEvent$1q, arrayMax: arrayMax$9, arrayMin: arrayMin$7, defined: defined$15, destroyObjectProperties: destroyObjectProperties$7, erase: erase$8, fireEvent: fireEvent$H, merge: merge$1A, objectEach: objectEach$p, pick: pick$1G } = Utilities;
class PlotLineOrBand {
  /* *
   *
   *  Static Functions
   *
   * */
  static compose(ChartClass, AxisClass) {
    addEvent$1q(ChartClass, "afterInit", function() {
      this.labelCollectors.push(() => {
        const labels = [];
        for (const axis of this.axes) {
          for (const { label, options: options2 } of axis.plotLinesAndBands) {
            if (label && !options2?.label?.allowOverlap) {
              labels.push(label);
            }
          }
        }
        return labels;
      });
    });
    return PlotLineOrBandAxis$1.compose(PlotLineOrBand, AxisClass);
  }
  /* *
   *
   *  Constructor
   *
   * */
  constructor(axis, options2) {
    this.axis = axis;
    this.options = options2;
    this.id = options2.id;
  }
  /* *
   *
   *  Functions
   *
   * */
  /* eslint-disable no-invalid-this, valid-jsdoc */
  /**
   * Render the plot line or plot band. If it is already existing,
   * move it.
   * @private
   * @function Highcharts.PlotLineOrBand#render
   */
  render() {
    fireEvent$H(this, "render");
    const { axis, options: options2 } = this, { horiz, logarithmic } = axis, { color: color2, events, zIndex = 0 } = options2, { renderer, time } = axis.chart, groupAttribs = {}, to = time.parse(options2.to), from = time.parse(options2.from), value = time.parse(options2.value), borderWidth = options2.borderWidth;
    let optionsLabel = options2.label, { label, svgElem } = this, path = [], group2;
    const isBand = defined$15(from) && defined$15(to), isLine = defined$15(value), isNew = !svgElem, attribs = {
      "class": "highcharts-plot-" + (isBand ? "band " : "line ") + (options2.className || "")
    };
    let groupName = isBand ? "bands" : "lines";
    if (!axis.chart.styledMode) {
      if (isLine) {
        attribs.stroke = color2 || "#999999";
        attribs["stroke-width"] = pick$1G(options2.width, 1);
        if (options2.dashStyle) {
          attribs.dashstyle = options2.dashStyle;
        }
      } else if (isBand) {
        attribs.fill = color2 || "#e6e9ff";
        if (borderWidth) {
          attribs.stroke = options2.borderColor;
          attribs["stroke-width"] = borderWidth;
        }
      }
    }
    groupAttribs.zIndex = zIndex;
    groupName += "-" + zIndex;
    group2 = axis.plotLinesAndBandsGroups[groupName];
    if (!group2) {
      axis.plotLinesAndBandsGroups[groupName] = group2 = renderer.g("plot-" + groupName).attr(groupAttribs).add();
    }
    if (!svgElem) {
      this.svgElem = svgElem = renderer.path().attr(attribs).add(group2);
    }
    if (defined$15(value)) {
      path = axis.getPlotLinePath({
        value: logarithmic?.log2lin(value) ?? value,
        lineWidth: svgElem.strokeWidth(),
        acrossPanes: options2.acrossPanes
      });
    } else if (defined$15(from) && defined$15(to)) {
      path = axis.getPlotBandPath(logarithmic?.log2lin(from) ?? from, logarithmic?.log2lin(to) ?? to, options2);
    } else {
      return;
    }
    if (!this.eventsAdded && events) {
      objectEach$p(events, (event, eventType) => {
        svgElem?.on(eventType, (e) => {
          events[eventType].apply(this, [e]);
        });
      });
      this.eventsAdded = true;
    }
    if ((isNew || !svgElem.d) && path?.length) {
      svgElem.attr({ d: path });
    } else if (svgElem) {
      if (path) {
        svgElem.show();
        svgElem.animate({ d: path });
      } else if (svgElem.d) {
        svgElem.hide();
        if (label) {
          this.label = label = label.destroy();
        }
      }
    }
    if (optionsLabel && (defined$15(optionsLabel.text) || defined$15(optionsLabel.formatter)) && path?.length && axis.width > 0 && axis.height > 0 && !path.isFlat) {
      optionsLabel = merge$1A({
        align: horiz && isBand ? "center" : void 0,
        x: horiz ? !isBand && 4 : 10,
        verticalAlign: !horiz && isBand ? "middle" : void 0,
        y: horiz ? isBand ? 16 : 10 : isBand ? 6 : -4,
        rotation: horiz && !isBand ? 90 : 0,
        ...isBand ? { inside: true } : {}
      }, optionsLabel);
      this.renderLabel(optionsLabel, path, isBand, zIndex);
    } else if (label) {
      label.hide();
    }
    return this;
  }
  /**
   * Render and align label for plot line or band.
   * @private
   * @function Highcharts.PlotLineOrBand#renderLabel
   */
  renderLabel(optionsLabel, path, isBand, zIndex) {
    const plotLine = this, axis = plotLine.axis, renderer = axis.chart.renderer, inside = optionsLabel.inside;
    let label = plotLine.label;
    if (!label) {
      plotLine.label = label = renderer.text(this.getLabelText(optionsLabel), 0, 0, optionsLabel.useHTML).attr({
        align: optionsLabel.textAlign || optionsLabel.align,
        rotation: optionsLabel.rotation,
        "class": "highcharts-plot-" + (isBand ? "band" : "line") + "-label " + (optionsLabel.className || ""),
        zIndex
      });
      if (!axis.chart.styledMode) {
        label.css(merge$1A({
          fontSize: "0.8em",
          textOverflow: isBand && !inside ? "" : "ellipsis"
        }, optionsLabel.style));
      }
      label.add();
    }
    const xBounds = path.xBounds || [path[0][1], path[1][1], isBand ? path[2][1] : path[0][1]], yBounds = path.yBounds || [path[0][2], path[1][2], isBand ? path[2][2] : path[0][2]], x = arrayMin$7(xBounds), y = arrayMin$7(yBounds), bBoxWidth = arrayMax$9(xBounds) - x;
    label.align(optionsLabel, false, {
      x,
      y,
      width: bBoxWidth,
      height: arrayMax$9(yBounds) - y
    });
    label.alignAttr.y -= renderer.fontMetrics(label).b;
    if (!label.alignValue || label.alignValue === "left" || defined$15(inside)) {
      label.css({
        width: (optionsLabel.style?.width || (!isBand || !inside ? label.rotation === 90 ? axis.height - (label.alignAttr.y - axis.top) : (optionsLabel.clip ? axis.width : axis.chart.chartWidth) - (label.alignAttr.x - axis.left) : bBoxWidth)) + "px"
      });
    }
    label.show(true);
  }
  /**
   * Get label's text content.
   * @private
   * @function Highcharts.PlotLineOrBand#getLabelText
   */
  getLabelText(optionsLabel) {
    return defined$15(optionsLabel.formatter) ? optionsLabel.formatter.call(this) : optionsLabel.text;
  }
  /**
   * Remove the plot line or band.
   *
   * @function Highcharts.PlotLineOrBand#destroy
   */
  destroy() {
    erase$8(this.axis.plotLinesAndBands, this);
    delete this.axis;
    destroyObjectProperties$7(this);
  }
}
const { animObject: animObject$d } = animationExports;
const { format: format$g } = Templating;
const { composed: composed$x, dateFormats: dateFormats$2, doc: doc$o, isSafari } = Highcharts;
const { distribute: distribute$3 } = R$1;
const { addEvent: addEvent$1p, clamp: clamp$k, css: css$b, discardElement: discardElement$5, extend: extend$1i, fireEvent: fireEvent$G, getAlignFactor: getAlignFactor$6, isArray: isArray$m, isNumber: isNumber$$, isObject: isObject$j, isString: isString$c, merge: merge$1z, pick: pick$1F, pushUnique: pushUnique$x, splat: splat$j, syncTimeout: syncTimeout$9 } = Utilities;
class Tooltip {
  /* *
   *
   *  Constructors
   *
   * */
  constructor(chart, options2, pointer) {
    this.allowShared = true;
    this.crosshairs = [];
    this.distance = 0;
    this.isHidden = true;
    this.isSticky = false;
    this.options = {};
    this.outside = false;
    this.chart = chart;
    this.init(chart, options2);
    this.pointer = pointer;
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Build the body (lines) of the tooltip by iterating over the items and
   * returning one entry for each item, abstracting this functionality allows
   * to easily overwrite and extend it.
   *
   * @private
   * @function Highcharts.Tooltip#bodyFormatter
   */
  bodyFormatter(points) {
    return points.map((point) => {
      const tooltipOptions = point.series.tooltipOptions, formatPrefix = point.formatPrefix || "point";
      return (tooltipOptions[formatPrefix + "Formatter"] || point.tooltipFormatter).call(point, tooltipOptions[formatPrefix + "Format"] || "");
    });
  }
  /**
   * Destroy the single tooltips in a split tooltip.
   * If the tooltip is active then it is not destroyed, unless forced to.
   *
   * @private
   * @function Highcharts.Tooltip#cleanSplit
   *
   * @param {boolean} [force]
   * Force destroy all tooltips.
   */
  cleanSplit(force) {
    this.chart.series.forEach(function(series) {
      const tt = series?.tt;
      if (tt) {
        if (!tt.isActive || force) {
          series.tt = tt.destroy();
        } else {
          tt.isActive = false;
        }
      }
    });
  }
  /**
   * In case no user defined formatter is given, this will be used. Note that
   * the context here is an object holding point, series, x, y etc.
   *
   * @function Highcharts.Tooltip#defaultFormatter
   *
   * @param {Highcharts.Tooltip} tooltip
   *
   * @return {string|Array<string>}
   * Returns a string (single tooltip and shared)
   * or an array of strings (split tooltip)
   */
  defaultFormatter(tooltip) {
    const hoverPoints = this.points || splat$j(this);
    let s;
    s = [tooltip.headerFooterFormatter(hoverPoints[0])];
    s = s.concat(tooltip.bodyFormatter(hoverPoints));
    s.push(tooltip.headerFooterFormatter(hoverPoints[0], true));
    return s;
  }
  /**
   * Removes and destroys the tooltip and its elements.
   *
   * @function Highcharts.Tooltip#destroy
   */
  destroy() {
    if (this.label) {
      this.label = this.label.destroy();
    }
    if (this.split) {
      this.cleanSplit(true);
      if (this.tt) {
        this.tt = this.tt.destroy();
      }
    }
    if (this.renderer) {
      this.renderer = this.renderer.destroy();
      discardElement$5(this.container);
    }
    Utilities.clearTimeout(this.hideTimer);
  }
  /**
   * Extendable method to get the anchor position of the tooltip
   * from a point or set of points
   *
   * @private
   * @function Highcharts.Tooltip#getAnchor
   */
  getAnchor(points, mouseEvent) {
    const { chart, pointer } = this, inverted = chart.inverted, plotTop = chart.plotTop, plotLeft = chart.plotLeft;
    let ret;
    points = splat$j(points);
    if (points[0].series?.yAxis && !points[0].series.yAxis.options.reversedStacks) {
      points = points.slice().reverse();
    }
    if (this.followPointer && mouseEvent) {
      if (typeof mouseEvent.chartX === "undefined") {
        mouseEvent = pointer.normalize(mouseEvent);
      }
      ret = [
        mouseEvent.chartX - plotLeft,
        mouseEvent.chartY - plotTop
      ];
    } else if (points[0].tooltipPos) {
      ret = points[0].tooltipPos;
    } else {
      let chartX = 0, chartY = 0;
      points.forEach(function(point) {
        const pos = point.pos(true);
        if (pos) {
          chartX += pos[0];
          chartY += pos[1];
        }
      });
      chartX /= points.length;
      chartY /= points.length;
      if (this.shared && points.length > 1 && mouseEvent) {
        if (inverted) {
          chartX = mouseEvent.chartX;
        } else {
          chartY = mouseEvent.chartY;
        }
      }
      ret = [chartX - plotLeft, chartY - plotTop];
    }
    return ret.map(Math.round);
  }
  /**
   * Get the CSS class names for the tooltip's label. Styles the label
   * by `colorIndex` or user-defined CSS.
   *
   * @function Highcharts.Tooltip#getClassName
   *
   * @return {string}
   *         The class names.
   */
  getClassName(point, isSplit, isHeader) {
    const options2 = this.options, series = point.series, seriesOptions = series.options;
    return [
      options2.className,
      "highcharts-label",
      isHeader && "highcharts-tooltip-header",
      isSplit ? "highcharts-tooltip-box" : "highcharts-tooltip",
      !isHeader && "highcharts-color-" + pick$1F(point.colorIndex, series.colorIndex),
      seriesOptions?.className
    ].filter(isString$c).join(" ");
  }
  /**
   * Creates the Tooltip label element if it does not exist, then returns it.
   *
   * @function Highcharts.Tooltip#getLabel
   *
   * @return {Highcharts.SVGElement}
   * Tooltip label
   */
  getLabel({ anchorX, anchorY } = { anchorX: 0, anchorY: 0 }) {
    const tooltip = this, styledMode = this.chart.styledMode, options2 = this.options, doSplit = this.split && this.allowShared;
    let container = this.container, renderer = this.chart.renderer;
    if (this.label) {
      const wasSplit = !this.label.hasClass("highcharts-label");
      if (!doSplit && wasSplit || doSplit && !wasSplit) {
        this.destroy();
      }
    }
    if (!this.label) {
      if (this.outside) {
        const chart = this.chart, chartStyle = chart.options.chart.style, Renderer = RendererRegistry$1.getRendererType();
        this.container = container = Highcharts.doc.createElement("div");
        container.className = "highcharts-tooltip-container " + (chart.renderTo.className.match(/(highcharts[a-zA-Z0-9-]+)\s?/gm) || [].join(" "));
        css$b(container, {
          position: "absolute",
          top: "1px",
          pointerEvents: "none",
          zIndex: Math.max(this.options.style.zIndex || 0, (chartStyle?.zIndex || 0) + 3)
        });
        this.renderer = renderer = new Renderer(container, 0, 0, chartStyle, void 0, void 0, renderer.styledMode);
      }
      if (doSplit) {
        this.label = renderer.g("tooltip");
      } else {
        this.label = renderer.label("", anchorX, anchorY, options2.shape || "callout", void 0, void 0, options2.useHTML, void 0, "tooltip").attr({
          padding: options2.padding,
          r: options2.borderRadius
        });
        if (!styledMode) {
          this.label.attr({
            fill: options2.backgroundColor,
            "stroke-width": options2.borderWidth || 0
          }).css(options2.style).css({
            pointerEvents: options2.style.pointerEvents || (this.shouldStickOnContact() ? "auto" : "none")
          });
        }
      }
      if (tooltip.outside) {
        const label = this.label;
        [label.xSetter, label.ySetter].forEach((setter, i2) => {
          label[i2 ? "ySetter" : "xSetter"] = (value) => {
            setter.call(label, tooltip.distance);
            label[i2 ? "y" : "x"] = value;
            if (container) {
              container.style[i2 ? "top" : "left"] = `${value}px`;
            }
          };
        });
      }
      this.label.attr({ zIndex: 8 }).shadow(options2.shadow ?? !options2.fixed).add();
    }
    if (container && !container.parentElement) {
      Highcharts.doc.body.appendChild(container);
    }
    return this.label;
  }
  /**
   * Get the total area available area to place the tooltip
   *
   * @private
   */
  getPlayingField() {
    const { body, documentElement } = doc$o, { chart, distance, outside } = this;
    return {
      width: outside ? (
        // Subtract distance to prevent scrollbars
        Math.max(body.scrollWidth, documentElement.scrollWidth, body.offsetWidth, documentElement.offsetWidth, documentElement.clientWidth) - 2 * distance - 2
      ) : chart.chartWidth,
      height: outside ? Math.max(body.scrollHeight, documentElement.scrollHeight, body.offsetHeight, documentElement.offsetHeight, documentElement.clientHeight) : chart.chartHeight
    };
  }
  /**
   * Place the tooltip in a chart without spilling over and not covering the
   * point itself.
   *
   * @function Highcharts.Tooltip#getPosition
   *
   * @param {number} boxWidth
   *        Width of the tooltip box.
   *
   * @param {number} boxHeight
   *        Height of the tooltip box.
   *
   * @param {Highcharts.Point} point
   *        Tooltip related point.
   *
   * @return {Highcharts.PositionObject}
   *         Recommended position of the tooltip.
   */
  getPosition(boxWidth, boxHeight, point) {
    const { distance, chart, outside, pointer } = this, { inverted, plotLeft, plotTop, polar } = chart, { plotX = 0, plotY = 0 } = point, ret = {}, h = inverted && point.h || 0, { height: outerHeight, width: outerWidth } = this.getPlayingField(), chartPosition = pointer.getChartPosition(), scaleX = (val) => val * chartPosition.scaleX, scaleY = (val) => val * chartPosition.scaleY, buildDimensionArray = (dim) => {
      const isX = dim === "x";
      return [
        dim,
        // Dimension - x or y
        isX ? outerWidth : outerHeight,
        isX ? boxWidth : boxHeight
      ].concat(outside ? [
        // If we are using tooltip.outside, we need to scale the
        // position to match scaling of the container in case there
        // is a transform/zoom on the container. #11329
        isX ? scaleX(boxWidth) : scaleY(boxHeight),
        isX ? chartPosition.left - distance + scaleX(plotX + plotLeft) : chartPosition.top - distance + scaleY(plotY + plotTop),
        0,
        isX ? outerWidth : outerHeight
      ] : [
        // Not outside, no scaling is needed
        isX ? boxWidth : boxHeight,
        isX ? plotX + plotLeft : plotY + plotTop,
        isX ? plotLeft : plotTop,
        isX ? plotLeft + chart.plotWidth : plotTop + chart.plotHeight
      ]);
    };
    let first = buildDimensionArray("y"), second = buildDimensionArray("x"), swapped;
    let flipped = !!point.negative;
    if (!polar && chart.hoverSeries?.yAxis?.reversed) {
      flipped = !flipped;
    }
    const preferFarSide = !this.followPointer && pick$1F(point.ttBelow, polar ? false : !inverted === flipped), firstDimension = function(dim, outerSize, innerSize, scaledInnerSize, point2, min2, max2) {
      const scaledDist = outside ? dim === "y" ? scaleY(distance) : scaleX(distance) : distance, scaleDiff = (innerSize - scaledInnerSize) / 2, roomLeft = scaledInnerSize < point2 - distance, roomRight = point2 + distance + scaledInnerSize < outerSize, alignedLeft = point2 - scaledDist - innerSize + scaleDiff, alignedRight = point2 + scaledDist - scaleDiff;
      if (preferFarSide && roomRight) {
        ret[dim] = alignedRight;
      } else if (!preferFarSide && roomLeft) {
        ret[dim] = alignedLeft;
      } else if (roomLeft) {
        ret[dim] = Math.min(max2 - scaledInnerSize, alignedLeft - h < 0 ? alignedLeft : alignedLeft - h);
      } else if (roomRight) {
        ret[dim] = Math.max(min2, alignedRight + h + innerSize > outerSize ? alignedRight : alignedRight + h);
      } else {
        ret[dim] = 0;
        return false;
      }
    }, secondDimension = function(dim, outerSize, innerSize, scaledInnerSize, point2) {
      if (point2 < distance || point2 > outerSize - distance) {
        return false;
      }
      if (point2 < innerSize / 2) {
        ret[dim] = 1;
      } else if (point2 > outerSize - scaledInnerSize / 2) {
        ret[dim] = outerSize - scaledInnerSize - 2;
      } else {
        ret[dim] = point2 - innerSize / 2;
      }
    }, swap2 = function(count) {
      [first, second] = [second, first];
      swapped = count;
    }, run = () => {
      if (firstDimension.apply(0, first) !== false) {
        if (secondDimension.apply(0, second) === false && !swapped) {
          swap2(true);
          run();
        }
      } else if (!swapped) {
        swap2(true);
        run();
      } else {
        ret.x = ret.y = 0;
      }
    };
    if (inverted && !polar || this.len > 1) {
      swap2();
    }
    run();
    return ret;
  }
  /**
   * Place the tooltip when `position.fixed` is true. This is called both for
   * single tooltips, and for partial tooltips when `split`.
   *
   * @private
   */
  getFixedPosition(boxWidth, boxHeight, point) {
    const series = point.series, { chart, options: options2, split } = this, position = options2.position, relativeToOption = position.relativeTo, noPane = options2.shared || series?.yAxis?.isRadial && (relativeToOption === "pane" || !relativeToOption), relativeTo = noPane ? "plotBox" : relativeToOption, bounds = relativeTo === "chart" ? chart.renderer : chart[relativeTo] || chart.getClipBox(series, true);
    return {
      x: bounds.x + (bounds.width - boxWidth) * getAlignFactor$6(position.align) + position.x,
      y: bounds.y + (bounds.height - boxHeight) * getAlignFactor$6(position.verticalAlign) + (!split && position.y || 0)
    };
  }
  /**
   * Hides the tooltip with a fade out animation.
   *
   * @function Highcharts.Tooltip#hide
   *
   * @param {number} [delay]
   *        The fade out in milliseconds. If no value is provided the value
   *        of the tooltip.hideDelay option is used. A value of 0 disables
   *        the fade out animation.
   */
  hide(delay) {
    const tooltip = this;
    Utilities.clearTimeout(this.hideTimer);
    delay = pick$1F(delay, this.options.hideDelay);
    if (!this.isHidden) {
      this.hideTimer = syncTimeout$9(function() {
        const label = tooltip.getLabel();
        tooltip.getLabel().animate({
          opacity: 0
        }, {
          duration: delay ? 150 : delay,
          complete: () => {
            label.hide();
            if (tooltip.container) {
              tooltip.container.remove();
            }
          }
        });
        tooltip.isHidden = true;
      }, delay);
    }
  }
  /**
   * Initialize tooltip.
   *
   * @private
   * @function Highcharts.Tooltip#init
   *
   * @param {Highcharts.Chart} chart
   *        The chart instance.
   *
   * @param {Highcharts.TooltipOptions} options
   *        Tooltip options.
   */
  init(chart, options2) {
    this.chart = chart;
    this.options = options2;
    this.crosshairs = [];
    this.isHidden = true;
    this.split = options2.split && !chart.inverted && !chart.polar;
    this.shared = options2.shared || this.split;
    this.outside = pick$1F(options2.outside, Boolean(chart.scrollablePixelsX || chart.scrollablePixelsY));
  }
  shouldStickOnContact(pointerEvent) {
    return !!(!this.followPointer && this.options.stickOnContact && (!pointerEvent || this.pointer.inClass(pointerEvent.target, "highcharts-tooltip")));
  }
  /**
   * Moves the tooltip with a soft animation to a new position.
   *
   * @private
   * @function Highcharts.Tooltip#move
   *
   * @param {number} x
   *
   * @param {number} y
   *
   * @param {number} anchorX
   *
   * @param {number} anchorY
   */
  move(x, y, anchorX, anchorY) {
    const { followPointer, options: options2 } = this, animation = animObject$d(!followPointer && !this.isHidden && !options2.fixed && options2.animation), skipAnchor = followPointer || (this.len || 0) > 1, attr2 = { x, y };
    if (!skipAnchor) {
      attr2.anchorX = anchorX;
      attr2.anchorY = anchorY;
    } else {
      attr2.anchorX = attr2.anchorY = NaN;
    }
    animation.step = () => this.drawTracker();
    this.getLabel().animate(attr2, animation);
  }
  /**
   * Refresh the tooltip's text and position.
   *
   * @function Highcharts.Tooltip#refresh
   *
   * @param {Highcharts.Point|Array<Highcharts.Point>} pointOrPoints
   *        Either a point or an array of points.
   *
   * @param {Highcharts.PointerEventObject} [mouseEvent]
   *        Mouse event, that is responsible for the refresh and should be
   *        used for the tooltip update.
   */
  refresh(pointOrPoints, mouseEvent) {
    const tooltip = this, { chart, options: options2, pointer, shared: shared2 } = this, points = splat$j(pointOrPoints), point = points[0], formatString = options2.format, formatter = options2.formatter || tooltip.defaultFormatter, styledMode = chart.styledMode;
    let wasShared = tooltip.allowShared;
    if (!options2.enabled || !point.series) {
      return;
    }
    Utilities.clearTimeout(this.hideTimer);
    tooltip.allowShared = !(!isArray$m(pointOrPoints) && pointOrPoints.series && pointOrPoints.series.noSharedTooltip);
    wasShared = wasShared && !tooltip.allowShared;
    tooltip.followPointer = !tooltip.split && point.series.tooltipOptions.followPointer;
    const anchor = tooltip.getAnchor(pointOrPoints, mouseEvent), x = anchor[0], y = anchor[1];
    if (shared2 && tooltip.allowShared) {
      pointer.applyInactiveState(points);
      points.forEach((item) => item.setState("hover"));
      point.points = points;
    }
    this.len = points.length;
    const text = isString$c(formatString) ? format$g(formatString, point, chart) : formatter.call(point, tooltip);
    point.points = void 0;
    const currentSeries = point.series;
    this.distance = pick$1F(currentSeries.tooltipOptions.distance, 16);
    if (text === false) {
      this.hide();
    } else {
      if (tooltip.split && tooltip.allowShared) {
        this.renderSplit(text, points);
      } else {
        let checkX = x;
        let checkY = y;
        if (mouseEvent && pointer.isDirectTouch) {
          checkX = mouseEvent.chartX - chart.plotLeft;
          checkY = mouseEvent.chartY - chart.plotTop;
        }
        if (chart.polar || currentSeries.options.clip === false || points.some((p) => (
          // #16004
          pointer.isDirectTouch || // ##17929
          p.series.shouldShowTooltip(checkX, checkY)
        ))) {
          const label = tooltip.getLabel(wasShared && tooltip.tt || {});
          if (!options2.style.width || styledMode) {
            label.css({
              width: (this.outside ? this.getPlayingField() : chart.spacingBox).width + "px"
            });
          }
          label.attr({
            // Add class before the label BBox calculation (#21035)
            "class": tooltip.getClassName(point),
            text: text && text.join ? text.join("") : text
          });
          if (this.outside) {
            label.attr({
              x: clamp$k(label.x || 0, 0, this.getPlayingField().width - (label.width || 0) - 1)
            });
          }
          if (!styledMode) {
            label.attr({
              stroke: options2.borderColor || point.color || currentSeries.color || "#666666"
            });
          }
          tooltip.updatePosition({
            plotX: x,
            plotY: y,
            negative: point.negative,
            ttBelow: point.ttBelow,
            series: currentSeries,
            h: anchor[2] || 0
          });
        } else {
          tooltip.hide();
          return;
        }
      }
      if (tooltip.isHidden && tooltip.label) {
        tooltip.label.attr({
          opacity: 1
        }).show();
      }
      tooltip.isHidden = false;
    }
    fireEvent$G(this, "refresh");
  }
  /**
   * Render the split tooltip. Loops over each point's text and adds
   * a label next to the point, then uses the distribute function to
   * find best non-overlapping positions.
   *
   * @private
   * @function Highcharts.Tooltip#renderSplit
   *
   * @param {string|Array<(boolean|string)>} labels
   *
   * @param {Array<Highcharts.Point>} points
   */
  renderSplit(labels, points) {
    const tooltip = this;
    const { chart, chart: { chartWidth, chartHeight, plotHeight, plotLeft, plotTop, scrollablePixelsY = 0, scrollablePixelsX, styledMode }, distance, options: options2, options: { fixed, position, positioner }, pointer } = tooltip;
    const { scrollLeft = 0, scrollTop = 0 } = chart.scrollablePlotArea?.scrollingContainer || {};
    const bounds = tooltip.outside && typeof scrollablePixelsX !== "number" ? doc$o.documentElement.getBoundingClientRect() : {
      left: scrollLeft,
      right: scrollLeft + chartWidth
    };
    const tooltipLabel = tooltip.getLabel();
    const ren = this.renderer || chart.renderer;
    const headerTop = Boolean(chart.xAxis[0]?.opposite);
    const { left: chartLeft, top: chartTop } = pointer.getChartPosition();
    const hasFixedPosition = positioner || fixed;
    let distributionBoxTop = plotTop + scrollTop;
    let headerHeight = 0;
    let adjustedPlotHeight = plotHeight - scrollablePixelsY;
    function getAnchor(point) {
      const { isHeader, plotX = 0, plotY = 0, series } = point;
      let anchorX;
      let anchorY;
      if (isHeader) {
        anchorX = Math.max(plotLeft + plotX, plotLeft);
        anchorY = plotTop + plotHeight / 2;
      } else {
        const { xAxis: xAxis2, yAxis: yAxis2 } = series;
        anchorX = xAxis2.pos + clamp$k(plotX, -distance, xAxis2.len + distance);
        if (series.shouldShowTooltip(0, yAxis2.pos - plotTop + plotY, {
          ignoreX: true
        })) {
          anchorY = yAxis2.pos + plotY;
        }
      }
      anchorX = clamp$k(anchorX, bounds.left - distance, bounds.right + distance);
      return { anchorX, anchorY };
    }
    const defaultPositioner = function(boxWidth, boxHeight, point, anchor = [0, 0], alignedLeft = true) {
      let x, y;
      if (point.isHeader) {
        y = headerTop ? 0 : adjustedPlotHeight;
        x = clamp$k(anchor[0] - boxWidth / 2, bounds.left, bounds.right - boxWidth - (tooltip.outside ? chartLeft : 0));
      } else if (fixed && point) {
        const pos = tooltip.getFixedPosition(boxWidth, boxHeight, point);
        x = pos.x;
        y = pos.y - distributionBoxTop;
      } else {
        y = anchor[1] - distributionBoxTop;
        x = alignedLeft ? anchor[0] - boxWidth - distance : anchor[0] + distance;
        x = clamp$k(x, alignedLeft ? x : bounds.left, bounds.right);
      }
      return { x, y };
    };
    function updatePartialTooltip(partialTooltip, point, str) {
      let tt = partialTooltip;
      const { isHeader, series } = point, ttOptions = series.tooltipOptions || options2;
      if (!tt) {
        const attribs = {
          padding: ttOptions.padding,
          r: ttOptions.borderRadius
        };
        if (!styledMode) {
          attribs.fill = ttOptions.backgroundColor;
          attribs["stroke-width"] = ttOptions.borderWidth ?? (fixed && !isHeader ? 0 : 1);
        }
        tt = ren.label("", 0, 0, ttOptions[isHeader ? "headerShape" : "shape"] || (fixed && !isHeader ? "rect" : "callout"), void 0, void 0, ttOptions.useHTML).addClass(tooltip.getClassName(point, true, isHeader)).attr(attribs).add(tooltipLabel);
      }
      tt.isActive = true;
      tt.attr({
        text: str
      });
      if (!styledMode) {
        tt.css(ttOptions.style).attr({
          stroke: ttOptions.borderColor || point.color || series.color || "#333333"
        });
      }
      return tt;
    }
    if (isString$c(labels)) {
      labels = [false, labels];
    }
    let boxes = labels.slice(0, points.length + 1).reduce(function(boxes2, str, i2) {
      if (str !== false && str !== "") {
        const point = points[i2 - 1] || {
          // Item 0 is the header. Instead of this, we could also
          // use the crosshair label
          isHeader: true,
          plotX: points[0].plotX,
          plotY: plotHeight,
          series: {}
        };
        const isHeader = point.isHeader;
        const owner = isHeader ? tooltip : point.series;
        const tt = owner.tt = updatePartialTooltip(owner.tt, point, str.toString());
        const bBox = tt.getBBox();
        const boxWidth = bBox.width + tt.strokeWidth();
        if (isHeader) {
          headerHeight = bBox.height;
          adjustedPlotHeight += headerHeight;
          if (headerTop) {
            distributionBoxTop -= headerHeight;
          }
        }
        const { anchorX, anchorY } = getAnchor(point);
        if (typeof anchorY === "number") {
          const size = bBox.height + 1, boxPosition = (positioner || defaultPositioner).call(tooltip, boxWidth, size, point, [anchorX, anchorY]);
          boxes2.push({
            // 0-align to the top, 1-align to the bottom
            align: hasFixedPosition ? 0 : void 0,
            anchorX,
            anchorY,
            boxWidth,
            point,
            rank: pick$1F(boxPosition.rank, isHeader ? 1 : 0),
            size,
            target: boxPosition.y,
            tt,
            x: boxPosition.x
          });
        } else {
          tt.isActive = false;
        }
      }
      return boxes2;
    }, []);
    if (!hasFixedPosition && boxes.some((box) => {
      const { outside: outside2 } = tooltip;
      const boxStart = (outside2 ? chartLeft : 0) + box.anchorX;
      if (boxStart < bounds.left && boxStart + box.boxWidth < bounds.right) {
        return true;
      }
      return boxStart < chartLeft - bounds.left + box.boxWidth && bounds.right - boxStart > boxStart;
    })) {
      boxes = boxes.map((box) => {
        const { x, y } = defaultPositioner.call(this, box.boxWidth, box.size, box.point, [box.anchorX, box.anchorY], false);
        return extend$1i(box, {
          target: y,
          x
        });
      });
    }
    tooltip.cleanSplit();
    distribute$3(boxes, adjustedPlotHeight);
    const boxExtremes = {
      left: chartLeft,
      right: chartLeft
    };
    boxes.forEach(function(box) {
      const { x, boxWidth, isHeader } = box;
      if (!isHeader) {
        if (tooltip.outside && chartLeft + x < boxExtremes.left) {
          boxExtremes.left = chartLeft + x;
        }
        if (!isHeader && tooltip.outside && boxExtremes.left + boxWidth > boxExtremes.right) {
          boxExtremes.right = chartLeft + x;
        }
      }
    });
    boxes.forEach(function(box) {
      const { x, anchorX, anchorY, pos, point: { isHeader } } = box;
      const attributes = {
        visibility: typeof pos === "undefined" ? "hidden" : "inherit",
        x,
        /* NOTE: y should equal pos to be consistent with !split
         * tooltip, but is currently relative to plotTop. Is left as is
         * to avoid breaking change. Remove distributionBoxTop to make
         * it consistent.
         */
        y: (pos || 0) + distributionBoxTop + (fixed && position.y || 0),
        anchorX,
        anchorY
      };
      if (tooltip.outside && x < anchorX) {
        const offset2 = chartLeft - boxExtremes.left;
        if (offset2 > 0) {
          if (!isHeader) {
            attributes.x = x + offset2;
            attributes.anchorX = anchorX + offset2;
          }
          if (isHeader) {
            attributes.x = (boxExtremes.right - boxExtremes.left) / 2;
            attributes.anchorX = anchorX + offset2;
          }
        }
      }
      box.tt.attr(attributes);
    });
    const { container, outside, renderer } = tooltip;
    if (outside && container && renderer) {
      const { width, height, x, y } = tooltipLabel.getBBox();
      renderer.setSize(width + x, height + y, false);
      container.style.left = boxExtremes.left + "px";
      container.style.top = chartTop + "px";
    }
    if (isSafari) {
      tooltipLabel.attr({
        // Force a redraw of the whole group by chaining the opacity
        // slightly
        opacity: tooltipLabel.opacity === 1 ? 0.999 : 1
      });
    }
  }
  /**
   * If the `stickOnContact` option is active, this will add a tracker shape.
   *
   * @private
   * @function Highcharts.Tooltip#drawTracker
   */
  drawTracker() {
    const tooltip = this;
    if (!this.shouldStickOnContact()) {
      if (tooltip.tracker) {
        tooltip.tracker = tooltip.tracker.destroy();
      }
      return;
    }
    const chart = tooltip.chart;
    const label = tooltip.label;
    const points = tooltip.shared ? chart.hoverPoints : chart.hoverPoint;
    if (!label || !points) {
      return;
    }
    const box = {
      x: 0,
      y: 0,
      width: 0,
      height: 0
    };
    const anchorPos = this.getAnchor(points);
    const labelBBox = label.getBBox();
    anchorPos[0] += chart.plotLeft - (label.translateX || 0);
    anchorPos[1] += chart.plotTop - (label.translateY || 0);
    box.x = Math.min(0, anchorPos[0]);
    box.y = Math.min(0, anchorPos[1]);
    box.width = anchorPos[0] < 0 ? Math.max(Math.abs(anchorPos[0]), labelBBox.width - anchorPos[0]) : Math.max(Math.abs(anchorPos[0]), labelBBox.width);
    box.height = anchorPos[1] < 0 ? Math.max(Math.abs(anchorPos[1]), labelBBox.height - Math.abs(anchorPos[1])) : Math.max(Math.abs(anchorPos[1]), labelBBox.height);
    if (tooltip.tracker) {
      tooltip.tracker.attr(box);
    } else {
      tooltip.tracker = label.renderer.rect(box).addClass("highcharts-tracker").add(label);
      if (!chart.styledMode) {
        tooltip.tracker.attr({
          fill: "rgba(0,0,0,0)"
        });
      }
    }
  }
  /**
   * @private
   */
  styledModeFormat(formatString) {
    return formatString.replace('style="font-size: 0.8em"', 'class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g, 'class="highcharts-color-{$1.colorIndex} {series.options.className} {point.options.className}"');
  }
  /**
   * Format the footer/header of the tooltip
   * #3397: abstraction to enable formatting of footer and header
   *
   * @private
   * @function Highcharts.Tooltip#headerFooterFormatter
   */
  headerFooterFormatter(point, isFooter) {
    const series = point.series, tooltipOptions = series.tooltipOptions, xAxis2 = series.xAxis, dateTime = xAxis2?.dateTime, e = {
      isFooter,
      point
    };
    let xDateFormat = tooltipOptions.xDateFormat || "", formatString = tooltipOptions[isFooter ? "footerFormat" : "headerFormat"];
    fireEvent$G(this, "headerFormatter", e, function(e2) {
      if (dateTime && !xDateFormat && isNumber$$(point.key)) {
        xDateFormat = dateTime.getXDateFormat(point.key, tooltipOptions.dateTimeLabelFormats);
      }
      if (dateTime && xDateFormat) {
        if (isObject$j(xDateFormat)) {
          const format2 = xDateFormat;
          dateFormats$2[0] = (timestamp) => series.chart.time.dateFormat(format2, timestamp);
          xDateFormat = "%0";
        }
        (point.tooltipDateKeys || ["key"]).forEach((key2) => {
          formatString = formatString.replace(new RegExp("point\\." + key2 + "([ \\)}])"), `(point.${key2}:${xDateFormat})$1`);
        });
      }
      if (series.chart.styledMode) {
        formatString = this.styledModeFormat(formatString);
      }
      e2.text = format$g(formatString, point, this.chart);
    });
    return e.text || "";
  }
  /**
   * Updates the tooltip with the provided tooltip options.
   *
   * @function Highcharts.Tooltip#update
   *
   * @param {Highcharts.TooltipOptions} options
   *        The tooltip options to update.
   */
  update(options2) {
    this.destroy();
    this.init(this.chart, merge$1z(true, this.options, options2));
  }
  /**
   * Find the new position and perform the move
   *
   * @private
   * @function Highcharts.Tooltip#updatePosition
   *
   * @param {Highcharts.Point} point
   */
  updatePosition(point) {
    const { chart, container, distance, options: options2, pointer, renderer } = this, label = this.getLabel(), { height = 0, width = 0 } = label, { fixed, positioner } = options2, { left, top, scaleX, scaleY } = pointer.getChartPosition(), pos = (positioner || fixed && this.getFixedPosition || this.getPosition).call(this, width, height, point), doc2 = Highcharts.doc;
    let anchorX = (point.plotX || 0) + chart.plotLeft, anchorY = (point.plotY || 0) + chart.plotTop, pad2;
    if (renderer && container) {
      if (positioner || fixed) {
        const { scrollLeft = 0, scrollTop = 0 } = chart.scrollablePlotArea?.scrollingContainer || {};
        pos.x += scrollLeft + left - distance;
        pos.y += scrollTop + top - distance;
      }
      pad2 = (options2.borderWidth || 0) + 2 * distance + 2;
      renderer.setSize(
        // Clamp width to keep tooltip in viewport (#21698)
        // and subtract one since tooltip container has 'left: 1px;'
        clamp$k(width + pad2, 0, doc2.documentElement.clientWidth) - 1,
        height + pad2,
        false
      );
      if (scaleX !== 1 || scaleY !== 1) {
        css$b(container, {
          transform: `scale(${scaleX}, ${scaleY})`
        });
        anchorX *= scaleX;
        anchorY *= scaleY;
      }
      anchorX += left - pos.x;
      anchorY += top - pos.y;
    }
    this.move(
      Math.round(pos.x),
      Math.round(pos.y || 0),
      // Can be undefined (#3977)
      anchorX,
      anchorY
    );
  }
}
(function(Tooltip2) {
  function compose2(PointerClass) {
    if (pushUnique$x(composed$x, "Core.Tooltip")) {
      addEvent$1p(PointerClass, "afterInit", function() {
        const chart = this.chart;
        if (chart.options.tooltip) {
          chart.tooltip = new Tooltip2(chart, chart.options.tooltip, this);
        }
      });
    }
  }
  Tooltip2.compose = compose2;
})(Tooltip || (Tooltip = {}));
const Tooltip$1 = Tooltip;
const { animObject: animObject$c } = animationExports;
const { defaultOptions: defaultOptions$j } = DefaultOptions;
const { format: format$f } = Templating;
const { addEvent: addEvent$1o, crisp: crisp$d, erase: erase$7, extend: extend$1h, fireEvent: fireEvent$F, getNestedProperty: getNestedProperty$2, isArray: isArray$l, isFunction: isFunction$2, isNumber: isNumber$_, isObject: isObject$i, merge: merge$1y, pick: pick$1E, syncTimeout: syncTimeout$8, removeEvent: removeEvent$9, uniqueKey: uniqueKey$7 } = Utilities;
let Point$3 = class Point2 {
  /**
   * For categorized axes this property holds the category name for the
   * point. For other axes it holds the X value.
   *
   * @name Highcharts.Point#category
   * @type {number|string}
   */
  /**
   * The name of the point. The name can be given as the first position of the
   * point configuration array, or as a `name` property in the configuration:
   *
   * @example
   * // Array config
   * data: [
   *     ['John', 1],
   *     ['Jane', 2]
   * ]
   *
   * // Object config
   * data: [{
   *        name: 'John',
   *        y: 1
   * }, {
   *     name: 'Jane',
   *     y: 2
   * }]
   *
   * @name Highcharts.Point#name
   * @type {string}
   */
  /**
   * The point's name if it is defined, or its category in case of a category,
   * otherwise the x value. Convenient for tooltip and data label formatting.
   *
   * @name Highcharts.Point#key
   * @type {number|string}
   */
  /**
   * The point's options as applied in the initial configuration, or
   * extended through `Point.update`.
   *
   * In TypeScript you have to extend `PointOptionsObject` via an
   * additional interface to allow custom data options:
   *
   * ```
   * declare interface PointOptionsObject {
   *     customProperty: string;
   * }
   * ```
   *
   * @name Highcharts.Point#options
   * @type {Highcharts.PointOptionsObject}
   */
  /**
   * The percentage for points in a stacked series, pies or gauges.
   *
   * @name Highcharts.Point#percentage
   * @type {number|undefined}
   */
  /**
   * Array of all hovered points when using shared tooltips.
   *
   * @name Highcharts.Point#points
   * @type {Array<Highcharts.Point>|undefined}
   */
  /**
   * The series object associated with the point.
   *
   * @name Highcharts.Point#series
   * @type {Highcharts.Series}
   */
  /**
   * The attributes of the rendered SVG shape like in `column` or `pie`
   * series.
   *
   * @readonly
   * @name Highcharts.Point#shapeArgs
   * @type {Readonly<Highcharts.SVGAttributes>|undefined}
   */
  /**
   * The total of values in either a stack for stacked series, or a pie in a
   * pie series.
   *
   * @name Highcharts.Point#total
   * @type {number|undefined}
   */
  /**
   * For certain series types, like pie charts, where individual points can
   * be shown or hidden.
   *
   * @name Highcharts.Point#visible
   * @type {boolean}
   * @default true
   */
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Animate SVG elements associated with the point.
   *
   * @private
   * @function Highcharts.Point#animateBeforeDestroy
   */
  animateBeforeDestroy() {
    const point = this, animateParams = { x: point.startXPos, opacity: 0 }, graphicalProps = point.getGraphicalProps();
    graphicalProps.singular.forEach(function(prop) {
      const isDataLabel = prop === "dataLabel";
      point[prop] = point[prop].animate(isDataLabel ? {
        x: point[prop].startXPos,
        y: point[prop].startYPos,
        opacity: 0
      } : animateParams);
    });
    graphicalProps.plural.forEach(function(plural) {
      point[plural].forEach(function(item) {
        if (item.element) {
          item.animate(extend$1h({ x: point.startXPos }, item.startYPos ? {
            x: item.startXPos,
            y: item.startYPos
          } : {}));
        }
      });
    });
  }
  /**
   * Apply the options containing the x and y data and possible some extra
   * properties. Called on point init or from point.update.
   *
   * @private
   * @function Highcharts.Point#applyOptions
   *
   * @param {Highcharts.PointOptionsType} options
   *        The point options as defined in series.data.
   *
   * @param {number} [x]
   *        Optionally, the x value.
   *
   * @return {Highcharts.Point}
   *         The Point instance.
   */
  applyOptions(options2, x) {
    const point = this, series = point.series, pointValKey = series.options.pointValKey || series.pointValKey;
    options2 = Point2.prototype.optionsToObject.call(this, options2);
    extend$1h(point, options2);
    point.options = point.options ? extend$1h(point.options, options2) : options2;
    if (options2.group) {
      delete point.group;
    }
    if (options2.dataLabels) {
      delete point.dataLabels;
    }
    if (pointValKey) {
      point.y = Point2.prototype.getNestedProperty.call(point, pointValKey);
    }
    if (point.selected) {
      point.state = "select";
    }
    if ("name" in point && typeof x === "undefined" && series.xAxis && series.xAxis.hasNames) {
      point.x = series.xAxis.nameToX(point);
    }
    if (typeof point.x === "undefined" && series) {
      point.x = x ?? series.autoIncrement();
    } else if (isNumber$_(options2.x) && series.options.relativeXValue) {
      point.x = series.autoIncrement(options2.x);
    } else if (typeof point.x === "string") {
      x ?? (x = series.chart.time.parse(point.x));
      if (isNumber$_(x)) {
        point.x = x;
      }
    }
    point.isNull = this.isValid && !this.isValid();
    point.formatPrefix = point.isNull ? "null" : "point";
    return point;
  }
  /**
   * Destroy a point to clear memory. Its reference still stays in
   * `series.data`.
   *
   * @private
   * @function Highcharts.Point#destroy
   */
  destroy() {
    if (!this.destroyed) {
      const point = this, series = point.series, chart = series.chart, dataSorting = series.options.dataSorting, hoverPoints = chart.hoverPoints, globalAnimation = point.series.chart.renderer.globalAnimation, animation = animObject$c(globalAnimation);
      const destroyPoint = () => {
        if (point.graphic || point.graphics || point.dataLabel || point.dataLabels) {
          removeEvent$9(point);
          point.destroyElements();
        }
        for (const prop in point) {
          delete point[prop];
        }
      };
      if (point.legendItem) {
        chart.legend.destroyItem(point);
      }
      if (hoverPoints) {
        point.setState();
        erase$7(hoverPoints, point);
        if (!hoverPoints.length) {
          chart.hoverPoints = null;
        }
      }
      if (point === chart.hoverPoint) {
        point.onMouseOut();
      }
      if (!dataSorting?.enabled) {
        destroyPoint();
      } else {
        this.animateBeforeDestroy();
        syncTimeout$8(destroyPoint, animation.duration);
      }
      chart.pointCount--;
    }
    this.destroyed = true;
  }
  /**
   * Destroy SVG elements associated with the point.
   *
   * @private
   * @function Highcharts.Point#destroyElements
   * @param {Highcharts.Dictionary<number>} [kinds]
   */
  destroyElements(kinds) {
    const point = this, props = point.getGraphicalProps(kinds);
    props.singular.forEach(function(prop) {
      point[prop] = point[prop].destroy();
    });
    props.plural.forEach(function(plural) {
      point[plural].forEach(function(item) {
        if (item?.element) {
          item.destroy();
        }
      });
      delete point[plural];
    });
  }
  /**
   * Fire an event on the Point object.
   *
   * @private
   * @function Highcharts.Point#firePointEvent
   *
   * @param {string} eventType
   *        Type of the event.
   *
   * @param {Highcharts.Dictionary<any>|Event} [eventArgs]
   *        Additional event arguments.
   *
   * @param {Highcharts.EventCallbackFunction<Highcharts.Point>|Function} [defaultFunction]
   *        Default event handler.
   *
   * @emits Highcharts.Point#event:*
   */
  firePointEvent(eventType, eventArgs, defaultFunction) {
    const point = this, series = this.series, seriesOptions = series.options;
    point.manageEvent(eventType);
    if (eventType === "click" && seriesOptions.allowPointSelect) {
      defaultFunction = function(event) {
        if (!point.destroyed && point.select) {
          point.select(null, event.ctrlKey || event.metaKey || event.shiftKey);
        }
      };
    }
    fireEvent$F(point, eventType, eventArgs, defaultFunction);
  }
  /**
   * Get the CSS class names for individual points. Used internally where the
   * returned value is set on every point.
   *
   * @function Highcharts.Point#getClassName
   *
   * @return {string}
   *         The class names.
   */
  getClassName() {
    const point = this;
    return "highcharts-point" + (point.selected ? " highcharts-point-select" : "") + (point.negative ? " highcharts-negative" : "") + (point.isNull ? " highcharts-null-point" : "") + (typeof point.colorIndex !== "undefined" ? " highcharts-color-" + point.colorIndex : "") + (point.options.className ? " " + point.options.className : "") + (point.zone?.className ? " " + point.zone.className.replace("highcharts-negative", "") : "");
  }
  /**
   * Get props of all existing graphical point elements.
   *
   * @private
   * @function Highcharts.Point#getGraphicalProps
   */
  getGraphicalProps(kinds) {
    const point = this, props = [], graphicalProps = { singular: [], plural: [] };
    let prop, i2;
    kinds = kinds || { graphic: 1, dataLabel: 1 };
    if (kinds.graphic) {
      props.push(
        "graphic",
        "connector"
        // Used by dumbbell
      );
    }
    if (kinds.dataLabel) {
      props.push("dataLabel", "dataLabelPath", "dataLabelUpper");
    }
    i2 = props.length;
    while (i2--) {
      prop = props[i2];
      if (point[prop]) {
        graphicalProps.singular.push(prop);
      }
    }
    [
      "graphic",
      "dataLabel"
    ].forEach(function(prop2) {
      const plural = prop2 + "s";
      if (kinds[prop2] && point[plural]) {
        graphicalProps.plural.push(plural);
      }
    });
    return graphicalProps;
  }
  /**
   * Returns the value of the point property for a given value.
   * @private
   */
  getNestedProperty(key2) {
    if (!key2) {
      return;
    }
    if (key2.indexOf("custom.") === 0) {
      return getNestedProperty$2(key2, this.options);
    }
    return this[key2];
  }
  /**
   * In a series with `zones`, return the zone that the point belongs to.
   *
   * @function Highcharts.Point#getZone
   *
   * @return {Highcharts.SeriesZonesOptionsObject}
   *         The zone item.
   */
  getZone() {
    const series = this.series, zones = series.zones, zoneAxis = series.zoneAxis || "y";
    let zone, i2 = 0;
    zone = zones[i2];
    while (this[zoneAxis] >= zone.value) {
      zone = zones[++i2];
    }
    if (!this.nonZonedColor) {
      this.nonZonedColor = this.color;
    }
    if (zone?.color && !this.options.color) {
      this.color = zone.color;
    } else {
      this.color = this.nonZonedColor;
    }
    return zone;
  }
  /**
   * Utility to check if point has new shape type. Used in column series and
   * all others that are based on column series.
   * @private
   */
  hasNewShapeType() {
    const point = this;
    const oldShapeType = point.graphic && (point.graphic.symbolName || point.graphic.element.nodeName);
    return oldShapeType !== this.shapeType;
  }
  /**
   * Initialize the point. Called internally based on the `series.data`
   * option.
   *
   * @function Highcharts.Point#init
   *
   * @param {Highcharts.Series} series
   *        The series object containing this point.
   *
   * @param {Highcharts.PointOptionsType} options
   *        The data in either number, array or object format.
   *
   * @param {number} [x]
   *        Optionally, the X value of the point.
   *
   * @return {Highcharts.Point}
   *         The Point instance.
   *
   * @emits Highcharts.Point#event:afterInit
   */
  constructor(series, options2, x) {
    this.formatPrefix = "point";
    this.visible = true;
    this.point = this;
    this.series = series;
    this.applyOptions(options2, x);
    this.id ?? (this.id = uniqueKey$7());
    this.resolveColor();
    this.dataLabelOnNull ?? (this.dataLabelOnNull = series.options.nullInteraction);
    series.chart.pointCount++;
    fireEvent$F(this, "afterInit");
  }
  /**
   * Determine if point is valid.
   * @private
   * @function Highcharts.Point#isValid
   */
  isValid() {
    return (isNumber$_(this.x) || this.x instanceof Date) && isNumber$_(this.y);
  }
  /**
   * Transform number or array configs into objects. Also called for object
   * configs. Used internally to unify the different configuration formats for
   * points. For example, a simple number `10` in a line series will be
   * transformed to `{ y: 10 }`, and an array config like `[1, 10]` in a
   * scatter series will be transformed to `{ x: 1, y: 10 }`.
   *
   * @function Highcharts.Point#optionsToObject
   *
   * @param {Highcharts.PointOptionsType} options
   * Series data options.
   *
   * @return {Highcharts.Dictionary<*>}
   * Transformed point options.
   */
  optionsToObject(options2) {
    const series = this.series, keys = series.options.keys, pointArrayMap = keys || series.pointArrayMap || ["y"], valueCount = pointArrayMap.length;
    let ret = {}, firstItemType, i2 = 0, j = 0;
    if (isNumber$_(options2) || options2 === null) {
      ret[pointArrayMap[0]] = options2;
    } else if (isArray$l(options2)) {
      if (!keys && options2.length > valueCount) {
        firstItemType = typeof options2[0];
        if (firstItemType === "string") {
          if (series.xAxis?.dateTime) {
            ret.x = series.chart.time.parse(options2[0]);
          } else {
            ret.name = options2[0];
          }
        } else if (firstItemType === "number") {
          ret.x = options2[0];
        }
        i2++;
      }
      while (j < valueCount) {
        if (!keys || typeof options2[i2] !== "undefined") {
          if (pointArrayMap[j].indexOf(".") > 0) {
            Point2.prototype.setNestedProperty(ret, options2[i2], pointArrayMap[j]);
          } else {
            ret[pointArrayMap[j]] = options2[i2];
          }
        }
        i2++;
        j++;
      }
    } else if (typeof options2 === "object") {
      ret = options2;
      if (options2.dataLabels) {
        series.hasDataLabels = () => true;
      }
      if (options2.marker) {
        series._hasPointMarkers = true;
      }
    }
    return ret;
  }
  /**
   * Get the pixel position of the point relative to the plot area.
   * @function Highcharts.Point#pos
   *
   * @sample highcharts/point/position
   *         Get point's position in pixels.
   *
   * @param {boolean} chartCoordinates
   * If true, the returned position is relative to the full chart area.
   * If false, it is relative to the plot area determined by the axes.
   *
   * @param {number|undefined} plotY
   * A custom plot y position to be computed. Used internally for some
   * series types that have multiple `y` positions, like area range (low
   * and high values).
   *
   * @return {Array<number>|undefined}
   * Coordinates of the point if the point exists.
   */
  pos(chartCoordinates, plotY = this.plotY) {
    if (!this.destroyed) {
      const { plotX, series } = this, { chart, xAxis: xAxis2, yAxis: yAxis2 } = series;
      let posX = 0, posY = 0;
      if (isNumber$_(plotX) && isNumber$_(plotY)) {
        if (chartCoordinates) {
          posX = xAxis2 ? xAxis2.pos : chart.plotLeft;
          posY = yAxis2 ? yAxis2.pos : chart.plotTop;
        }
        return chart.inverted && xAxis2 && yAxis2 ? [yAxis2.len - plotY + posY, xAxis2.len - plotX + posX] : [plotX + posX, plotY + posY];
      }
    }
  }
  /**
   * @private
   * @function Highcharts.Point#resolveColor
   */
  resolveColor() {
    const series = this.series, optionsChart = series.chart.options.chart, styledMode = series.chart.styledMode;
    let color2, colors, colorCount = optionsChart.colorCount, colorIndex;
    delete this.nonZonedColor;
    if (series.options.colorByPoint) {
      if (!styledMode) {
        colors = series.options.colors || series.chart.options.colors;
        color2 = colors[series.colorCounter];
        colorCount = colors.length;
      }
      colorIndex = series.colorCounter;
      series.colorCounter++;
      if (series.colorCounter === colorCount) {
        series.colorCounter = 0;
      }
    } else {
      if (!styledMode) {
        color2 = series.color;
      }
      colorIndex = series.colorIndex;
    }
    this.colorIndex = pick$1E(this.options.colorIndex, colorIndex);
    this.color = pick$1E(this.options.color, color2);
  }
  /**
   * Set a value in an object, on the property defined by key. The key
   * supports nested properties using dot notation. The function modifies the
   * input object and does not make a copy.
   *
   * @function Highcharts.Point#setNestedProperty<T>
   *
   * @param {T} object
   *        The object to set the value on.
   *
   * @param {*} value
   *        The value to set.
   *
   * @param {string} key
   *        Key to the property to set.
   *
   * @return {T}
   *         The modified object.
   */
  setNestedProperty(object, value, key2) {
    const nestedKeys = key2.split(".");
    nestedKeys.reduce(function(result, key3, i2, arr) {
      const isLastKey = arr.length - 1 === i2;
      result[key3] = isLastKey ? value : isObject$i(result[key3], true) ? result[key3] : {};
      return result[key3];
    }, object);
    return object;
  }
  shouldDraw() {
    return !this.isNull;
  }
  /**
   * Extendable method for formatting each point's tooltip line.
   *
   * @function Highcharts.Point#tooltipFormatter
   *
   * @param {string} pointFormat
   *        The point format.
   *
   * @return {string}
   *         A string to be concatenated in to the common tooltip text.
   */
  tooltipFormatter(pointFormat) {
    const { chart, pointArrayMap = ["y"], tooltipOptions } = this.series, { valueDecimals = "", valuePrefix = "", valueSuffix = "" } = tooltipOptions;
    if (chart.styledMode) {
      pointFormat = chart.tooltip?.styledModeFormat(pointFormat) || pointFormat;
    }
    pointArrayMap.forEach((key2) => {
      key2 = "{point." + key2;
      if (valuePrefix || valueSuffix) {
        pointFormat = pointFormat.replace(RegExp(key2 + "}", "g"), valuePrefix + key2 + "}" + valueSuffix);
      }
      pointFormat = pointFormat.replace(RegExp(key2 + "}", "g"), key2 + ":,." + valueDecimals + "f}");
    });
    return format$f(pointFormat, this, chart);
  }
  /**
   * Update point with new options (typically x/y data) and optionally redraw
   * the series.
   *
   * @sample highcharts/members/point-update-column/
   *         Update column value
   * @sample highcharts/members/point-update-pie/
   *         Update pie slice
   * @sample maps/members/point-update/
   *         Update map area value in Highmaps
   *
   * @function Highcharts.Point#update
   *
   * @param {Highcharts.PointOptionsType} options
   *        The point options. Point options are handled as described under
   *        the `series.type.data` item for each series type. For example
   *        for a line series, if options is a single number, the point will
   *        be given that number as the marin y value. If it is an array, it
   *        will be interpreted as x and y values respectively. If it is an
   *        object, advanced options are applied.
   *
   * @param {boolean} [redraw=true]
   *        Whether to redraw the chart after the point is updated. If doing
   *        more operations on the chart, it is best practice to set
   *        `redraw` to false and call `chart.redraw()` after.
   *
   * @param {boolean|Partial<Highcharts.AnimationOptionsObject>} [animation=true]
   *        Whether to apply animation, and optionally animation
   *        configuration.
   *
   * @emits Highcharts.Point#event:update
   */
  update(options2, redraw, animation, runEvent) {
    const point = this, series = point.series, graphic = point.graphic, chart = series.chart, seriesOptions = series.options;
    let i2;
    redraw = pick$1E(redraw, true);
    function update() {
      point.applyOptions(options2);
      const hasMockGraphic = graphic && point.hasMockGraphic;
      const shouldDestroyGraphic = point.y === null ? !hasMockGraphic : hasMockGraphic;
      if (graphic && shouldDestroyGraphic) {
        point.graphic = graphic.destroy();
        delete point.hasMockGraphic;
      }
      if (isObject$i(options2, true)) {
        if (graphic?.element) {
          if (options2 && options2.marker && typeof options2.marker.symbol !== "undefined") {
            point.graphic = graphic.destroy();
          }
        }
        if (options2?.dataLabels && point.dataLabel) {
          point.dataLabel = point.dataLabel.destroy();
        }
      }
      i2 = point.index;
      const row = {};
      for (const key2 of series.dataColumnKeys()) {
        row[key2] = point[key2];
      }
      series.dataTable.setRow(row, i2);
      seriesOptions.data[i2] = isObject$i(seriesOptions.data[i2], true) || isObject$i(options2, true) ? point.options : pick$1E(options2, seriesOptions.data[i2]);
      series.isDirty = series.isDirtyData = true;
      if (!series.fixedBox && series.hasCartesianSeries) {
        chart.isDirtyBox = true;
      }
      if (seriesOptions.legendType === "point") {
        chart.isDirtyLegend = true;
      }
      if (redraw) {
        chart.redraw(animation);
      }
    }
    if (runEvent === false) {
      update();
    } else {
      point.firePointEvent("update", { options: options2 }, update);
    }
  }
  /**
   * Remove a point and optionally redraw the series and if necessary the axes
   *
   * @sample highcharts/plotoptions/series-point-events-remove/
   *         Remove point and confirm
   * @sample highcharts/members/point-remove/
   *         Remove pie slice
   * @sample maps/members/point-remove/
   *         Remove selected points in Highmaps
   *
   * @function Highcharts.Point#remove
   *
   * @param {boolean} [redraw=true]
   *        Whether to redraw the chart or wait for an explicit call. When
   *        doing more operations on the chart, for example running
   *        `point.remove()` in a loop, it is best practice to set `redraw`
   *        to false and call `chart.redraw()` after.
   *
   * @param {boolean|Partial<Highcharts.AnimationOptionsObject>} [animation=false]
   *        Whether to apply animation, and optionally animation
   *        configuration.
   */
  remove(redraw, animation) {
    this.series.removePoint(this.series.data.indexOf(this), redraw, animation);
  }
  /**
   * Toggle the selection status of a point.
   *
   * @see Highcharts.Chart#getSelectedPoints
   *
   * @sample highcharts/members/point-select/
   *         Select a point from a button
   * @sample highcharts/members/point-select-lasso/
   *         Lasso selection
   * @sample highcharts/chart/events-selection-points/
   *         Rectangle selection
   * @sample maps/series/data-id/
   *         Select a point in Highmaps
   *
   * @function Highcharts.Point#select
   *
   * @param {boolean} [selected]
   * When `true`, the point is selected. When `false`, the point is
   * unselected. When `null` or `undefined`, the selection state is toggled.
   *
   * @param {boolean} [accumulate=false]
   * When `true`, the selection is added to other selected points.
   * When `false`, other selected points are deselected. Internally in
   * Highcharts, when
   * [allowPointSelect](https://api.highcharts.com/highcharts/plotOptions.series.allowPointSelect)
   * is `true`, selected points are accumulated on Control, Shift or Cmd
   * clicking the point.
   *
   * @emits Highcharts.Point#event:select
   * @emits Highcharts.Point#event:unselect
   */
  select(selected, accumulate) {
    const point = this, series = point.series, chart = series.chart;
    selected = pick$1E(selected, !point.selected);
    this.selectedStaging = selected;
    point.firePointEvent(selected ? "select" : "unselect", { accumulate }, function() {
      point.selected = point.options.selected = selected;
      series.options.data[series.data.indexOf(point)] = point.options;
      point.setState(selected && "select");
      if (!accumulate) {
        chart.getSelectedPoints().forEach(function(loopPoint) {
          const loopSeries = loopPoint.series;
          if (loopPoint.selected && loopPoint !== point) {
            loopPoint.selected = loopPoint.options.selected = false;
            loopSeries.options.data[loopSeries.data.indexOf(loopPoint)] = loopPoint.options;
            loopPoint.setState(chart.hoverPoints && loopSeries.options.inactiveOtherPoints ? "inactive" : "");
            loopPoint.firePointEvent("unselect");
          }
        });
      }
    });
    delete this.selectedStaging;
  }
  /**
   * Runs on mouse over the point. Called internally from mouse and touch
   * events.
   *
   * @function Highcharts.Point#onMouseOver
   *
   * @param {Highcharts.PointerEventObject} [e]
   *        The event arguments.
   */
  onMouseOver(e) {
    const point = this, series = point.series, { inverted, pointer } = series.chart;
    if (pointer) {
      e = e ? pointer.normalize(e) : (
        // In cases where onMouseOver is called directly without an
        // event
        pointer.getChartCoordinatesFromPoint(point, inverted)
      );
      pointer.runPointActions(e, point);
    }
  }
  /**
   * Runs on mouse out from the point. Called internally from mouse and touch
   * events.
   *
   * @function Highcharts.Point#onMouseOut
   * @emits Highcharts.Point#event:mouseOut
   */
  onMouseOut() {
    const point = this, chart = point.series.chart;
    point.firePointEvent("mouseOut");
    if (!point.series.options.inactiveOtherPoints) {
      (chart.hoverPoints || []).forEach(function(p) {
        p.setState();
      });
    }
    chart.hoverPoints = chart.hoverPoint = null;
  }
  /**
   * Manage specific event from the series' and point's options. Only do it on
   * demand, to save processing time on hovering.
   *
   * @private
   * @function Highcharts.Point#importEvents
   */
  manageEvent(eventType) {
    const point = this, options2 = merge$1y(point.series.options.point, point.options), userEvent = options2.events?.[eventType];
    if (isFunction$2(userEvent) && (!point.hcEvents?.[eventType] || // Some HC modules, like marker-clusters, draggable-poins etc.
    // use events in their logic, so we need to be sure, that
    // callback function is different
    point.hcEvents?.[eventType]?.map((el) => el.fn).indexOf(userEvent) === -1)) {
      point.importedUserEvent?.();
      point.importedUserEvent = addEvent$1o(point, eventType, userEvent);
      if (point.hcEvents) {
        point.hcEvents[eventType].userEvent = true;
      }
    } else if (point.importedUserEvent && !userEvent && point.hcEvents?.[eventType] && point.hcEvents?.[eventType].userEvent) {
      removeEvent$9(point, eventType);
      delete point.hcEvents[eventType];
      if (!Object.keys(point.hcEvents)) {
        delete point.importedUserEvent;
      }
    }
  }
  /**
   * Set the point's state.
   *
   * @function Highcharts.Point#setState
   *
   * @param {Highcharts.PointStateValue|""} [state]
   *        The new state, can be one of `'hover'`, `'select'`, `'inactive'`,
   *        or `''` (an empty string), `'normal'` or `undefined` to set to
   *        normal state.
   * @param {boolean} [move]
   *        State for animation.
   *
   * @emits Highcharts.Point#event:afterSetState
   */
  setState(state, move) {
    const point = this, series = point.series, previousState = point.state, stateOptions = series.options.states[state || "normal"] || {}, markerOptions = defaultOptions$j.plotOptions[series.type].marker && series.options.marker, normalDisabled = markerOptions && markerOptions.enabled === false, markerStateOptions = markerOptions?.states?.[state || "normal"] || {}, stateDisabled = markerStateOptions.enabled === false, pointMarker = point.marker || {}, chart = series.chart, hasMarkers = markerOptions && series.markerAttribs;
    let halo = series.halo, markerAttribs, pointAttribs, pointAttribsAnimation, stateMarkerGraphic = series.stateMarkerGraphic, newSymbol;
    state = state || "";
    if (
      // Already has this state
      state === point.state && !move || // Selected points don't respond to hover
      point.selected && state !== "select" || // Series' state options is disabled
      stateOptions.enabled === false || // General point marker's state options is disabled
      state && (stateDisabled || normalDisabled && markerStateOptions.enabled === false) || // Individual point marker's state options is disabled
      state && pointMarker.states && pointMarker.states[state] && pointMarker.states[state].enabled === false
    ) {
      return;
    }
    point.state = state;
    if (hasMarkers) {
      markerAttribs = series.markerAttribs(point, state);
    }
    if (point.graphic && !point.hasMockGraphic) {
      if (previousState) {
        point.graphic.removeClass("highcharts-point-" + previousState);
      }
      if (state) {
        point.graphic.addClass("highcharts-point-" + state);
      }
      if (!chart.styledMode) {
        pointAttribs = series.pointAttribs(point, state);
        pointAttribsAnimation = pick$1E(chart.options.chart.animation, stateOptions.animation);
        const opacity = pointAttribs.opacity;
        if (series.options.inactiveOtherPoints && isNumber$_(opacity)) {
          (point.dataLabels || []).forEach(function(label) {
            if (label && !label.hasClass("highcharts-data-label-hidden")) {
              label.animate({ opacity }, pointAttribsAnimation);
              if (label.connector) {
                label.connector.animate({ opacity }, pointAttribsAnimation);
              }
            }
          });
        }
        point.graphic.animate(pointAttribs, pointAttribsAnimation);
      }
      if (markerAttribs) {
        point.graphic.animate(markerAttribs, pick$1E(
          // Turn off globally:
          chart.options.chart.animation,
          markerStateOptions.animation,
          markerOptions.animation
        ));
      }
      if (stateMarkerGraphic) {
        stateMarkerGraphic.hide();
      }
    } else {
      if (state && markerStateOptions) {
        newSymbol = pointMarker.symbol || series.symbol;
        if (stateMarkerGraphic && stateMarkerGraphic.currentSymbol !== newSymbol) {
          stateMarkerGraphic = stateMarkerGraphic.destroy();
        }
        if (markerAttribs) {
          if (!stateMarkerGraphic) {
            if (newSymbol) {
              series.stateMarkerGraphic = stateMarkerGraphic = chart.renderer.symbol(newSymbol, markerAttribs.x, markerAttribs.y, markerAttribs.width, markerAttribs.height, merge$1y(markerOptions, markerStateOptions)).add(series.markerGroup);
              stateMarkerGraphic.currentSymbol = newSymbol;
            }
          } else {
            stateMarkerGraphic[move ? "animate" : "attr"]({
              x: markerAttribs.x,
              y: markerAttribs.y
            });
          }
        }
        if (!chart.styledMode && stateMarkerGraphic && point.state !== "inactive") {
          stateMarkerGraphic.attr(series.pointAttribs(point, state));
        }
      }
      if (stateMarkerGraphic) {
        stateMarkerGraphic[state && point.isInside ? "show" : "hide"]();
        stateMarkerGraphic.element.point = point;
        stateMarkerGraphic.addClass(point.getClassName(), true);
      }
    }
    const haloOptions = stateOptions.halo;
    const markerGraphic = point.graphic || stateMarkerGraphic;
    const markerVisibility = markerGraphic?.visibility || "inherit";
    if (haloOptions?.size && markerGraphic && markerVisibility !== "hidden" && !point.isCluster) {
      if (!halo) {
        series.halo = halo = chart.renderer.path().add(markerGraphic.parentGroup);
      }
      halo.show()[move ? "animate" : "attr"]({
        d: point.haloPath(haloOptions.size)
      });
      halo.attr({
        "class": "highcharts-halo highcharts-color-" + pick$1E(point.colorIndex, series.colorIndex) + (point.className ? " " + point.className : ""),
        "visibility": markerVisibility,
        "zIndex": -1
        // #4929, #8276
      });
      halo.point = point;
      if (!chart.styledMode) {
        halo.attr(extend$1h({
          "fill": point.color || series.color,
          "fill-opacity": haloOptions.opacity
        }, AST.filterUserAttributes(haloOptions.attributes || {})));
      }
    } else if (halo?.point?.haloPath && !halo.point.destroyed) {
      halo.animate(
        { d: halo.point.haloPath(0) },
        null,
        // Hide after unhovering. The `complete` callback runs in the
        // halo's context (#7681).
        halo.hide
      );
    }
    fireEvent$F(point, "afterSetState", { state });
  }
  /**
   * Get the path definition for the halo, which is usually a shadow-like
   * circle around the currently hovered point.
   *
   * @function Highcharts.Point#haloPath
   *
   * @param {number} size
   *        The radius of the circular halo.
   *
   * @return {Highcharts.SVGPathArray}
   *         The path definition.
   */
  haloPath(size) {
    const pos = this.pos();
    return pos ? this.series.chart.renderer.symbols.circle(crisp$d(pos[0], 1) - size, pos[1] - size, size * 2, size * 2) : [];
  }
};
const { parse: color$b } = Color;
const { charts: charts$2, composed: composed$w, isTouchDevice: isTouchDevice$5 } = Highcharts;
const { addEvent: addEvent$1n, attr: attr$9, css: css$a, extend: extend$1g, find: find$i, fireEvent: fireEvent$E, isNumber: isNumber$Z, isObject: isObject$h, objectEach: objectEach$o, offset, pick: pick$1D, pushUnique: pushUnique$w, splat: splat$i } = Utilities;
class Pointer {
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Set inactive state to all series that are not currently hovered,
   * or, if `inactiveOtherPoints` is set to true, set inactive state to
   * all points within that series.
   *
   * @private
   * @function Highcharts.Pointer#applyInactiveState
   *
   * @param {Array<Highcharts.Point>} points
   * Currently hovered points
   */
  applyInactiveState(points = []) {
    const activeSeries = [];
    points.forEach((item) => {
      const series = item.series;
      activeSeries.push(series);
      if (series.linkedParent) {
        activeSeries.push(series.linkedParent);
      }
      if (series.linkedSeries) {
        activeSeries.push.apply(activeSeries, series.linkedSeries);
      }
      if (series.navigatorSeries) {
        activeSeries.push(series.navigatorSeries);
      }
      if (series.boosted && series.markerGroup) {
        activeSeries.push.apply(activeSeries, this.chart.series.filter((otherSeries) => otherSeries.markerGroup === series.markerGroup));
      }
    });
    this.chart.series.forEach((series) => {
      if (activeSeries.indexOf(series) === -1) {
        series.setState("inactive", true);
      } else if (series.options.inactiveOtherPoints) {
        series.setAllPointsToState("inactive");
      }
    });
  }
  /**
   * Destroys the Pointer object and disconnects DOM events.
   *
   * @function Highcharts.Pointer#destroy
   */
  destroy() {
    const pointer = this;
    this.eventsToUnbind.forEach((unbind) => unbind());
    this.eventsToUnbind = [];
    if (!Highcharts.chartCount) {
      Pointer.unbindDocumentMouseUp.forEach((el) => el.unbind());
      Pointer.unbindDocumentMouseUp.length = 0;
      if (Pointer.unbindDocumentTouchEnd) {
        Pointer.unbindDocumentTouchEnd = Pointer.unbindDocumentTouchEnd();
      }
    }
    clearInterval(pointer.tooltipTimeout);
    objectEach$o(pointer, function(_val, prop) {
      pointer[prop] = void 0;
    });
  }
  /**
   * Calculate attrs for selection marker.
   * @private
   * @function Highcharts.Pointer#getSelectionMarkerAttrs
   * @emits getSelectionMarkerAttrs
   */
  getSelectionMarkerAttrs(chartX, chartY) {
    const e = {
      args: { chartX, chartY },
      attrs: {},
      shapeType: "rect"
    };
    fireEvent$E(this, "getSelectionMarkerAttrs", e, (e2) => {
      const { chart, zoomHor, zoomVert } = this, { mouseDownX = 0, mouseDownY = 0 } = chart, attrs = e2.attrs;
      let size;
      attrs.x = chart.plotLeft;
      attrs.y = chart.plotTop;
      attrs.width = zoomHor ? 1 : chart.plotWidth;
      attrs.height = zoomVert ? 1 : chart.plotHeight;
      if (zoomHor) {
        size = chartX - mouseDownX;
        attrs.width = Math.max(1, Math.abs(size));
        attrs.x = (size > 0 ? 0 : size) + mouseDownX;
      }
      if (zoomVert) {
        size = chartY - mouseDownY;
        attrs.height = Math.max(1, Math.abs(size));
        attrs.y = (size > 0 ? 0 : size) + mouseDownY;
      }
    });
    return e;
  }
  /**
   * Perform a drag operation in response to a mousemove event while the mouse
   * is down.
   * @private
   * @function Highcharts.Pointer#drag
   */
  drag(e) {
    const { chart } = this, { mouseDownX = 0, mouseDownY = 0 } = chart, { panning, panKey, selectionMarkerFill } = chart.options.chart, plotLeft = chart.plotLeft, plotTop = chart.plotTop, plotWidth = chart.plotWidth, plotHeight = chart.plotHeight, panningEnabled = isObject$h(panning) ? panning.enabled : panning, panKeyPressed = panKey && e[`${panKey}Key`];
    let chartX = e.chartX, chartY = e.chartY, clickedInside, selectionMarker = this.selectionMarker;
    if (selectionMarker && selectionMarker.touch) {
      return;
    }
    if (chartX < plotLeft) {
      chartX = plotLeft;
    } else if (chartX > plotLeft + plotWidth) {
      chartX = plotLeft + plotWidth;
    }
    if (chartY < plotTop) {
      chartY = plotTop;
    } else if (chartY > plotTop + plotHeight) {
      chartY = plotTop + plotHeight;
    }
    this.hasDragged = Math.sqrt(Math.pow(mouseDownX - chartX, 2) + Math.pow(mouseDownY - chartY, 2));
    if (this.hasDragged > 10) {
      clickedInside = chart.isInsidePlot(mouseDownX - plotLeft, mouseDownY - plotTop, {
        visiblePlotOnly: true
      });
      const { shapeType, attrs } = this.getSelectionMarkerAttrs(chartX, chartY);
      if ((chart.hasCartesianSeries || chart.mapView) && this.hasZoom && clickedInside && !panKeyPressed) {
        if (!selectionMarker) {
          this.selectionMarker = selectionMarker = chart.renderer[shapeType]();
          selectionMarker.attr({
            "class": "highcharts-selection-marker",
            zIndex: 7
          }).add();
          if (!chart.styledMode) {
            selectionMarker.attr({
              fill: selectionMarkerFill || color$b(
                "#334eff"
                /* Palette.highlightColor80 */
              ).setOpacity(0.25).get()
            });
          }
        }
      }
      if (selectionMarker) {
        selectionMarker.attr(attrs);
      }
      if (clickedInside && !selectionMarker && panningEnabled) {
        chart.pan(e, panning);
      }
    }
  }
  /**
   * Start a drag operation.
   * @private
   * @function Highcharts.Pointer#dragStart
   */
  dragStart(e) {
    const chart = this.chart;
    chart.mouseIsDown = e.type;
    chart.cancelClick = false;
    chart.mouseDownX = e.chartX;
    chart.mouseDownY = e.chartY;
  }
  /**
   * Get selection box to calculate extremes
   * @private
   * @function Highcharts.Pointer#getSelectionBox
   * @emits getSelectionBox
   */
  getSelectionBox(marker) {
    const e = {
      args: { marker },
      result: marker.getBBox()
    };
    fireEvent$E(this, "getSelectionBox", e);
    return e.result;
  }
  /**
   * On mouse up or touch end across the entire document, drop the selection.
   * @private
   * @function Highcharts.Pointer#drop
   */
  drop(e) {
    const { chart, selectionMarker } = this;
    let redraw;
    for (const axis of chart.axes) {
      if (axis.isPanning) {
        axis.isPanning = false;
        if (axis.options.startOnTick || axis.options.endOnTick || axis.series.some((s) => s.boosted)) {
          axis.forceRedraw = true;
          axis.setExtremes(axis.userMin, axis.userMax, false);
          redraw = true;
        }
      }
    }
    if (redraw) {
      chart.redraw();
    }
    if (selectionMarker && e) {
      if (this.hasDragged) {
        const from = this.getSelectionBox(selectionMarker);
        chart.transform({
          axes: chart.axes.filter((a) => a.zoomEnabled && (a.coll === "xAxis" && this.zoomX || a.coll === "yAxis" && this.zoomY)),
          selection: {
            originalEvent: e,
            // #4890
            xAxis: [],
            yAxis: [],
            ...from
          },
          from
        });
      }
      if (isNumber$Z(chart.index)) {
        this.selectionMarker = selectionMarker.destroy();
      }
    }
    if (chart && isNumber$Z(chart.index)) {
      css$a(chart.container, { cursor: chart._cursor });
      chart.cancelClick = this.hasDragged > 10;
      chart.mouseIsDown = false;
      this.hasDragged = 0;
      this.pinchDown = [];
    }
  }
  /**
   * Finds the closest point to a set of coordinates, using the k-d-tree
   * algorithm.
   *
   * @function Highcharts.Pointer#findNearestKDPoint
   *
   * @param {Array<Highcharts.Series>} series
   * All the series to search in.
   *
   * @param {boolean|undefined} shared
   * Whether it is a shared tooltip or not.
   *
   * @param {Highcharts.PointerEventObject} e
   * The pointer event object, containing chart coordinates of the pointer.
   *
   * @return {Highcharts.Point|undefined}
   * The point closest to given coordinates.
   */
  findNearestKDPoint(series, shared2, e) {
    let closest;
    function sort(p12, p22) {
      const isCloserX = p12.distX - p22.distX, isCloser = p12.dist - p22.dist, isAbove = p22.series.group?.zIndex - p12.series.group?.zIndex;
      let result;
      if (isCloserX !== 0 && shared2) {
        result = isCloserX;
      } else if (isCloser !== 0) {
        result = isCloser;
      } else if (isAbove !== 0) {
        result = isAbove;
      } else {
        result = p12.series.index > p22.series.index ? -1 : 1;
      }
      return result;
    }
    series.forEach(function(s) {
      const noSharedTooltip = s.noSharedTooltip && shared2, compareX = !noSharedTooltip && s.options.findNearestPointBy.indexOf("y") < 0, point = s.searchPoint(e, compareX);
      if (
        // Check that we actually found a point on the series.
        isObject$h(point, true) && point.series && // Use the new point if it is closer.
        (!isObject$h(closest, true) || sort(closest, point) > 0)
      ) {
        closest = point;
      }
    });
    return closest;
  }
  /**
   * @private
   * @function Highcharts.Pointer#getChartCoordinatesFromPoint
   */
  getChartCoordinatesFromPoint(point, inverted) {
    const { xAxis: xAxis2, yAxis: yAxis2 } = point.series, shapeArgs = point.shapeArgs;
    if (xAxis2 && yAxis2) {
      let x = point.clientX ?? point.plotX ?? 0, y = point.plotY || 0;
      if (point.isNode && shapeArgs && isNumber$Z(shapeArgs.x) && isNumber$Z(shapeArgs.y)) {
        x = shapeArgs.x;
        y = shapeArgs.y;
      }
      return inverted ? {
        chartX: yAxis2.len + yAxis2.pos - y,
        chartY: xAxis2.len + xAxis2.pos - x
      } : {
        chartX: x + xAxis2.pos,
        chartY: y + yAxis2.pos
      };
    }
    if (shapeArgs?.x && shapeArgs.y) {
      return {
        chartX: shapeArgs.x,
        chartY: shapeArgs.y
      };
    }
  }
  /**
   * Return the cached chartPosition if it is available on the Pointer,
   * otherwise find it. Running offset is quite expensive, so it should be
   * avoided when we know the chart hasn't moved.
   *
   * @function Highcharts.Pointer#getChartPosition
   *
   * @return {Highcharts.ChartPositionObject}
   * The offset of the chart container within the page
   */
  getChartPosition() {
    if (this.chartPosition) {
      return this.chartPosition;
    }
    const { container } = this.chart;
    const pos = offset(container);
    this.chartPosition = {
      left: pos.left,
      top: pos.top,
      scaleX: 1,
      scaleY: 1
    };
    const { offsetHeight, offsetWidth } = container;
    if (offsetWidth > 2 && // #13342
    offsetHeight > 2) {
      this.chartPosition.scaleX = pos.width / offsetWidth;
      this.chartPosition.scaleY = pos.height / offsetHeight;
    }
    return this.chartPosition;
  }
  /**
   * Get the click position in terms of axis values.
   *
   * @function Highcharts.Pointer#getCoordinates
   *
   * @param {Highcharts.PointerEventObject} e
   * Pointer event, extended with `chartX` and `chartY` properties.
   *
   * @return {Highcharts.PointerAxisCoordinatesObject}
   * Axis coordinates.
   */
  getCoordinates(e) {
    const coordinates2 = {
      xAxis: [],
      yAxis: []
    };
    for (const axis of this.chart.axes) {
      coordinates2[axis.isXAxis ? "xAxis" : "yAxis"].push({
        axis,
        value: axis.toValue(e[axis.horiz ? "chartX" : "chartY"])
      });
    }
    return coordinates2;
  }
  /**
   * Calculates what is the current hovered point/points and series.
   *
   * @private
   * @function Highcharts.Pointer#getHoverData
   *
   * @param {Highcharts.Point|undefined} existingHoverPoint
   * The point currently being hovered.
   *
   * @param {Highcharts.Series|undefined} existingHoverSeries
   * The series currently being hovered.
   *
   * @param {Array<Highcharts.Series>} series
   * All the series in the chart.
   *
   * @param {boolean} isDirectTouch
   * Is the pointer directly hovering the point.
   *
   * @param {boolean|undefined} shared
   * Whether it is a shared tooltip or not.
   *
   * @param {Highcharts.PointerEventObject} [e]
   * The triggering event, containing chart coordinates of the pointer.
   *
   * @return {Object}
   * Object containing resulting hover data: hoverPoint, hoverSeries, and
   * hoverPoints.
   */
  getHoverData(existingHoverPoint, existingHoverSeries, series, isDirectTouch, shared2, e) {
    const hoverPoints = [], useExisting = !!(isDirectTouch && existingHoverPoint), filter = function(s) {
      return s.visible && !(!shared2 && s.directTouch) && // #3821
      pick$1D(s.options.enableMouseTracking, true);
    };
    let hoverSeries = existingHoverSeries, searchSeries, eventArgs = {
      chartX: e ? e.chartX : void 0,
      chartY: e ? e.chartY : void 0,
      shared: shared2
    };
    fireEvent$E(this, "beforeGetHoverData", eventArgs);
    const notSticky = hoverSeries && !hoverSeries.stickyTracking;
    searchSeries = notSticky ? (
      // Only search on hovered series if it has stickyTracking false
      [hoverSeries]
    ) : (
      // Filter what series to look in.
      series.filter((s) => s.stickyTracking && (eventArgs.filter || filter)(s))
    );
    const hoverPoint = useExisting || !e ? existingHoverPoint : this.findNearestKDPoint(searchSeries, shared2, e);
    hoverSeries = hoverPoint?.series;
    if (hoverPoint) {
      if (shared2 && !hoverSeries.noSharedTooltip) {
        searchSeries = series.filter(function(s) {
          return eventArgs.filter ? eventArgs.filter(s) : filter(s) && !s.noSharedTooltip;
        });
        searchSeries.forEach(function(s) {
          const nullInteraction = s.options?.nullInteraction;
          let point = find$i(s.points, function(p) {
            return p.x === hoverPoint.x && (!p.isNull || !!nullInteraction);
          });
          if (isObject$h(point)) {
            if (s.boosted && s.boost) {
              point = s.boost.getPoint(point);
            }
            hoverPoints.push(point);
          }
        });
      } else {
        hoverPoints.push(hoverPoint);
      }
    }
    eventArgs = { hoverPoint };
    fireEvent$E(this, "afterGetHoverData", eventArgs);
    return {
      hoverPoint: eventArgs.hoverPoint,
      hoverSeries,
      hoverPoints
    };
  }
  /**
   * @private
   * @function Highcharts.Pointer#getPointFromEvent
   */
  getPointFromEvent(e) {
    let target = e.target, point;
    while (target && !point) {
      point = target.point;
      target = target.parentNode;
    }
    return point;
  }
  /**
   * @private
   * @function Highcharts.Pointer#onTrackerMouseOut
   */
  onTrackerMouseOut(e) {
    const chart = this.chart;
    const relatedTarget = e.relatedTarget;
    const series = chart.hoverSeries;
    this.isDirectTouch = false;
    if (series && relatedTarget && !series.stickyTracking && !this.inClass(relatedTarget, "highcharts-tooltip") && (!this.inClass(relatedTarget, "highcharts-series-" + series.index) || // #2499, #4465, #5553
    !this.inClass(relatedTarget, "highcharts-tracker"))) {
      series.onMouseOut();
    }
  }
  /**
   * Utility to detect whether an element has, or has a parent with, a
   * specific class name. Used on detection of tracker objects and on deciding
   * whether hovering the tooltip should cause the active series to mouse out.
   *
   * @function Highcharts.Pointer#inClass
   *
   * @param {Highcharts.SVGDOMElement|Highcharts.HTMLDOMElement} element
   * The element to investigate.
   *
   * @param {string} className
   * The class name to look for.
   *
   * @return {boolean|undefined}
   * True if either the element or one of its parents has the given class
   * name.
   */
  inClass(element, className) {
    let elem = element, elemClassName;
    while (elem) {
      elemClassName = attr$9(elem, "class");
      if (elemClassName) {
        if (elemClassName.indexOf(className) !== -1) {
          return true;
        }
        if (elemClassName.indexOf("highcharts-container") !== -1) {
          return false;
        }
      }
      elem = elem.parentElement;
    }
  }
  /**
   * Initialize the Pointer.
   *
   * @private
   * @function Highcharts.Pointer#init
   *
   * @param {Highcharts.Chart} chart
   * The Chart instance.
   *
   * @param {Highcharts.Options} options
   * The root options object. The pointer uses options from the chart and
   * tooltip structures.
   */
  constructor(chart, options2) {
    this.hasDragged = 0;
    this.pointerCaptureEventsToUnbind = [];
    this.eventsToUnbind = [];
    this.options = options2;
    this.chart = chart;
    this.runChartClick = Boolean(options2.chart.events?.click);
    this.pinchDown = [];
    this.setDOMEvents();
    fireEvent$E(this, "afterInit");
  }
  /**
   * Takes a browser event object and extends it with custom Highcharts
   * properties `chartX` and `chartY` in order to work on the internal
   * coordinate system.
   *
   * On map charts, the properties `lon` and `lat` are added to the event
   * object given that the chart has projection information.
   *
   * @function Highcharts.Pointer#normalize
   *
   * @param {global.MouseEvent|global.PointerEvent|global.TouchEvent} e
   * Event object in standard browsers.
   *
   * @param {Highcharts.OffsetObject} [chartPosition]
   * Additional chart offset.
   *
   * @return {Highcharts.PointerEventObject}
   * A browser event with extended properties `chartX` and `chartY`.
   */
  normalize(e, chartPosition) {
    const touches = e.touches;
    const ePos = touches ? touches.length ? touches.item(0) : pick$1D(
      // #13534
      touches.changedTouches,
      e.changedTouches
    )[0] : e;
    if (!chartPosition) {
      chartPosition = this.getChartPosition();
    }
    let chartX = ePos.pageX - chartPosition.left, chartY = ePos.pageY - chartPosition.top;
    chartX /= chartPosition.scaleX;
    chartY /= chartPosition.scaleY;
    return extend$1g(e, {
      chartX: Math.round(chartX),
      chartY: Math.round(chartY)
    });
  }
  /**
   * @private
   * @function Highcharts.Pointer#onContainerClick
   */
  onContainerClick(e) {
    const chart = this.chart;
    const hoverPoint = chart.hoverPoint;
    const pEvt = this.normalize(e);
    const plotLeft = chart.plotLeft;
    const plotTop = chart.plotTop;
    if (!chart.cancelClick) {
      if (hoverPoint && this.inClass(pEvt.target, "highcharts-tracker")) {
        fireEvent$E(hoverPoint.series, "click", extend$1g(pEvt, {
          point: hoverPoint
        }));
        if (chart.hoverPoint) {
          hoverPoint.firePointEvent("click", pEvt);
        }
      } else {
        extend$1g(pEvt, this.getCoordinates(pEvt));
        if (chart.isInsidePlot(pEvt.chartX - plotLeft, pEvt.chartY - plotTop, {
          visiblePlotOnly: true
        })) {
          fireEvent$E(chart, "click", pEvt);
        }
      }
    }
  }
  /**
   * @private
   * @function Highcharts.Pointer#onContainerMouseDown
   */
  onContainerMouseDown(e) {
    const isPrimaryButton = ((e.buttons || e.button) & 1) === 1;
    e = this.normalize(e);
    if (Highcharts.isFirefox && e.button !== 0) {
      this.onContainerMouseMove(e);
    }
    if (typeof e.button === "undefined" || isPrimaryButton) {
      this.zoomOption(e);
      if (isPrimaryButton) {
        e.preventDefault?.();
      }
      this.dragStart(e);
    }
  }
  /**
   * When mouse leaves the container, hide the tooltip.
   * @private
   * @function Highcharts.Pointer#onContainerMouseLeave
   */
  onContainerMouseLeave(e) {
    const { pointer } = charts$2[pick$1D(Pointer.hoverChartIndex, -1)] || {};
    e = this.normalize(e);
    this.onContainerMouseMove(e);
    if (pointer && !this.inClass(e.relatedTarget, "highcharts-tooltip")) {
      pointer.reset();
      pointer.chartPosition = void 0;
    }
  }
  /**
   * When mouse enters the container, delete pointer's chartPosition.
   * @private
   * @function Highcharts.Pointer#onContainerMouseEnter
   */
  onContainerMouseEnter() {
    delete this.chartPosition;
  }
  /**
   * The mousemove, touchmove and touchstart event handler
   * @private
   * @function Highcharts.Pointer#onContainerMouseMove
   */
  onContainerMouseMove(e) {
    const chart = this.chart, tooltip = chart.tooltip, pEvt = this.normalize(e);
    this.setHoverChartIndex(e);
    if (chart.mouseIsDown === "mousedown" || this.touchSelect(pEvt)) {
      this.drag(pEvt);
    }
    if (!chart.openMenu && (this.inClass(pEvt.target, "highcharts-tracker") || chart.isInsidePlot(pEvt.chartX - chart.plotLeft, pEvt.chartY - chart.plotTop, {
      visiblePlotOnly: true
    })) && // If the tooltip has stickOnContact enabled, do nothing. This
    // applies regardless of any combinations of the `split` and
    // `useHTML` options.
    !tooltip?.shouldStickOnContact(pEvt)) {
      if (this.inClass(pEvt.target, "highcharts-no-tooltip")) {
        this.reset(false, 0);
      } else {
        this.runPointActions(pEvt);
      }
    }
  }
  /**
   * @private
   * @function Highcharts.Pointer#onDocumentTouchEnd
   */
  onDocumentTouchEnd(e) {
    this.onDocumentMouseUp(e);
  }
  /**
   * @private
   * @function Highcharts.Pointer#onContainerTouchMove
   */
  onContainerTouchMove(e) {
    if (this.touchSelect(e)) {
      this.onContainerMouseMove(e);
    } else {
      this.touch(e);
    }
  }
  /**
   * @private
   * @function Highcharts.Pointer#onContainerTouchStart
   */
  onContainerTouchStart(e) {
    if (this.touchSelect(e)) {
      this.onContainerMouseDown(e);
    } else {
      this.zoomOption(e);
      this.touch(e, true);
    }
  }
  /**
   * Special handler for mouse move that will hide the tooltip when the mouse
   * leaves the plotarea. Issue #149 workaround. The mouseleave event does not
   * always fire.
   * @private
   * @function Highcharts.Pointer#onDocumentMouseMove
   */
  onDocumentMouseMove(e) {
    const chart = this.chart;
    const tooltip = chart.tooltip;
    const chartPosition = this.chartPosition;
    const pEvt = this.normalize(e, chartPosition);
    if (chartPosition && !chart.isInsidePlot(pEvt.chartX - chart.plotLeft, pEvt.chartY - chart.plotTop, {
      visiblePlotOnly: true
    }) && !tooltip?.shouldStickOnContact(pEvt) && (pEvt.target === chart.container.ownerDocument || !this.inClass(pEvt.target, "highcharts-tracker"))) {
      this.reset();
    }
  }
  /**
   * @private
   * @function Highcharts.Pointer#onDocumentMouseUp
   */
  onDocumentMouseUp(e) {
    charts$2[pick$1D(Pointer.hoverChartIndex, -1)]?.pointer?.drop(e);
  }
  /**
   * Handle touch events with two touches
   * @private
   * @function Highcharts.Pointer#pinch
   */
  pinch(e) {
    const pointer = this, { chart, hasZoom, lastTouches } = pointer, touches = [].map.call(
      e.touches || [],
      // Normalize each touch
      (touch) => pointer.normalize(touch)
    ), touchesLength = touches.length, fireClickEvent = touchesLength === 1 && (pointer.inClass(e.target, "highcharts-tracker") && chart.runTrackerClick || pointer.runChartClick), tooltip = chart.tooltip, followTouchMove = touchesLength === 1 && pick$1D(tooltip?.options.followTouchMove, true);
    if (touchesLength > 1) {
      pointer.initiated = true;
    } else if (followTouchMove) {
      pointer.initiated = false;
    }
    if (hasZoom && pointer.initiated && !fireClickEvent && e.cancelable !== false) {
      e.preventDefault();
    }
    if (e.type === "touchstart") {
      pointer.pinchDown = touches;
      pointer.res = true;
      chart.mouseDownX = e.chartX;
    } else if (followTouchMove) {
      this.runPointActions(pointer.normalize(e));
    } else if (lastTouches) {
      fireEvent$E(chart, "touchpan", {
        originalEvent: e,
        touches
      }, () => {
        const boxFromTouches = (touches2) => {
          const finger0 = touches2[0], finger1 = touches2[1] || finger0;
          return {
            x: finger0.chartX,
            y: finger0.chartY,
            width: finger1.chartX - finger0.chartX,
            height: finger1.chartY - finger0.chartY
          };
        };
        chart.transform({
          axes: chart.axes.filter((axis) => axis.zoomEnabled && (this.zoomHor && axis.horiz || this.zoomVert && !axis.horiz)),
          to: boxFromTouches(touches),
          from: boxFromTouches(lastTouches),
          trigger: e.type
        });
      });
      if (pointer.res) {
        pointer.res = false;
        this.reset(false, 0);
      }
    }
    pointer.lastTouches = touches;
  }
  /**
   * Run translation operations
   * @private
   * @function Highcharts.Pointer#pinchTranslate
   * /
  public pinchTranslate(
      pinchDown: Array<any>,
      touches: Array<PointerEvent>,
      transform: any,
      selectionMarker: any,
      clip: any,
      lastValidTouch: any
  ): void {
      if (this.zoomHor) {
          this.pinchTranslateDirection(
              true,
              pinchDown,
              touches,
              transform,
              selectionMarker,
              clip,
              lastValidTouch
          );
      }
      if (this.zoomVert) {
          this.pinchTranslateDirection(
              false,
              pinchDown,
              touches,
              transform,
              selectionMarker,
              clip,
              lastValidTouch
          );
      }
  }
  */
  /**
       * Run translation operations for each direction (horizontal and vertical)
       * independently.
       * @private
       * @function Highcharts.Pointer#pinchTranslateDirection
       * /
      public pinchTranslateDirection(
          horiz: boolean,
          pinchDown: Array<any>,
          touches: Array<PointerEvent>,
          transform: any,
          selectionMarker: any,
          clip: any,
          lastValidTouch: any,
          forcedScale?: number
      ): void {
          const chart = this.chart,
              xy: ('x'|'y') = horiz ? 'x' : 'y',
              XY: ('X'|'Y') = horiz ? 'X' : 'Y',
              sChartXY: ('chartX'|'chartY') = ('chart' + XY) as any,
              wh = horiz ? 'width' : 'height',
              plotLeftTop = (chart as any)['plot' + (horiz ? 'Left' : 'Top')],
              inverted = chart.inverted,
              bounds = chart.bounds[horiz ? 'h' : 'v'],
              singleTouch = pinchDown.length === 1,
              touch0Start = pinchDown[0][sChartXY],
              touch1Start = !singleTouch && pinchDown[1][sChartXY],
              setScale = function (): void {
                  // Don't zoom if fingers are too close on this axis
                  if (
                      typeof touch1Now === 'number' &&
                      Math.abs(touch0Start - touch1Start) > 20
                  ) {
                      scale = forcedScale ||
                          Math.abs(touch0Now - touch1Now) /
                          Math.abs(touch0Start - touch1Start);
                  }
  
                  clipXY = ((plotLeftTop - touch0Now) / scale) + touch0Start;
                  selectionWH = (chart as any)[
                      'plot' + (horiz ? 'Width' : 'Height')
                  ] / scale;
              };
  
          let selectionWH: any,
              selectionXY,
              clipXY: any,
              scale = forcedScale || 1,
              touch0Now = touches[0][sChartXY],
              touch1Now = !singleTouch && touches[1][sChartXY],
              outOfBounds;
  
          // Set the scale, first pass
          setScale();
  
          // The clip position (x or y) is altered if out of bounds, the selection
          // position is not
          selectionXY = clipXY;
  
          // Out of bounds
          if (selectionXY < bounds.min) {
              selectionXY = bounds.min;
              outOfBounds = true;
          } else if (selectionXY + selectionWH > bounds.max) {
              selectionXY = bounds.max - selectionWH;
              outOfBounds = true;
          }
  
          // Is the chart dragged off its bounds, determined by dataMin and
          // dataMax?
          if (outOfBounds) {
  
              // Modify the touchNow position in order to create an elastic drag
              // movement. This indicates to the user that the chart is responsive
              // but can't be dragged further.
              touch0Now -= 0.8 * (touch0Now - lastValidTouch[xy][0]);
              if (typeof touch1Now === 'number') {
                  touch1Now -= 0.8 * (touch1Now - lastValidTouch[xy][1]);
              }
  
              // Set the scale, second pass to adapt to the modified touchNow
              // positions
              setScale();
  
          } else {
              lastValidTouch[xy] = [touch0Now, touch1Now];
          }
  
          // Set geometry for clipping, selection and transformation
          if (!inverted) {
              clip[xy] = clipXY - plotLeftTop;
              clip[wh] = selectionWH;
          }
          const scaleKey = inverted ?
              (horiz ? 'scaleY' : 'scaleX') : 'scale' + XY;
          const transformScale = inverted ? 1 / scale : scale;
  
          selectionMarker[wh] = selectionWH;
          selectionMarker[xy] = selectionXY;
          // Invert scale if needed (#19217)
          transform[scaleKey] = scale * (inverted && !horiz ? -1 : 1);
          transform['translate' + XY] = (transformScale * plotLeftTop) +
              (touch0Now - (transformScale * touch0Start));
      }
      */
  /**
   * Reset the tracking by hiding the tooltip, the hover series state and the
   * hover point.
   *
   * @function Highcharts.Pointer#reset
   *
   * @param {boolean} [allowMove]
   * Instead of destroying the tooltip altogether, allow moving it if
   * possible.
   *
   * @param {number} [delay]
   * The tooltip hide delay in ms.
   */
  reset(allowMove, delay) {
    const pointer = this, chart = pointer.chart, hoverSeries = chart.hoverSeries, hoverPoint = chart.hoverPoint, hoverPoints = chart.hoverPoints, tooltip = chart.tooltip, tooltipPoints = tooltip?.shared ? hoverPoints : hoverPoint;
    if (allowMove && tooltipPoints) {
      splat$i(tooltipPoints).forEach(function(point) {
        if (point.series.isCartesian && typeof point.plotX === "undefined") {
          allowMove = false;
        }
      });
    }
    if (allowMove) {
      if (tooltip && tooltipPoints && splat$i(tooltipPoints).length) {
        tooltip.refresh(tooltipPoints);
        if (tooltip.shared && hoverPoints) {
          hoverPoints.forEach(function(point) {
            point.setState(point.state, true);
            if (point.series.isCartesian) {
              if (point.series.xAxis.crosshair) {
                point.series.xAxis.drawCrosshair(null, point);
              }
              if (point.series.yAxis.crosshair) {
                point.series.yAxis.drawCrosshair(null, point);
              }
            }
          });
        } else if (hoverPoint) {
          hoverPoint.setState(hoverPoint.state, true);
          chart.axes.forEach(function(axis) {
            if (axis.crosshair && hoverPoint.series[axis.coll] === axis) {
              axis.drawCrosshair(null, hoverPoint);
            }
          });
        }
      }
    } else {
      if (hoverPoint) {
        hoverPoint.onMouseOut();
      }
      if (hoverPoints) {
        hoverPoints.forEach(function(point) {
          point.setState();
        });
      }
      if (hoverSeries) {
        hoverSeries.onMouseOut();
      }
      if (tooltip) {
        tooltip.hide(delay);
      }
      if (pointer.unDocMouseMove) {
        pointer.unDocMouseMove = pointer.unDocMouseMove();
      }
      chart.axes.forEach(function(axis) {
        axis.hideCrosshair();
      });
      chart.hoverPoints = chart.hoverPoint = void 0;
    }
  }
  /**
   * With line type charts with a single tracker, get the point closest to the
   * mouse. Run Point.onMouseOver and display tooltip for the point or points.
   *
   * @private
   * @function Highcharts.Pointer#runPointActions
   *
   * @emits Highcharts.Point#event:mouseOut
   * @emits Highcharts.Point#event:mouseOver
   */
  runPointActions(e, p, force) {
    const pointer = this, chart = pointer.chart, series = chart.series, tooltip = chart.tooltip?.options.enabled ? chart.tooltip : void 0, shared2 = tooltip ? tooltip.shared : false;
    let hoverPoint = p || chart.hoverPoint, hoverSeries = hoverPoint?.series || chart.hoverSeries;
    const isDirectTouch = (!e || e.type !== "touchmove") && (!!p || hoverSeries?.directTouch && pointer.isDirectTouch), hoverData = this.getHoverData(hoverPoint, hoverSeries, series, isDirectTouch, shared2, e);
    hoverPoint = hoverData.hoverPoint;
    hoverSeries = hoverData.hoverSeries;
    const points = hoverData.hoverPoints, followPointer = hoverSeries?.tooltipOptions.followPointer && !hoverSeries.tooltipOptions.split, useSharedTooltip = shared2 && hoverSeries && !hoverSeries.noSharedTooltip;
    if (hoverPoint && (force || hoverPoint !== chart.hoverPoint || tooltip?.isHidden)) {
      (chart.hoverPoints || []).forEach(function(p5) {
        if (points.indexOf(p5) === -1) {
          p5.setState();
        }
      });
      if (chart.hoverSeries !== hoverSeries) {
        hoverSeries.onMouseOver();
      }
      pointer.applyInactiveState(points);
      (points || []).forEach(function(p5) {
        p5.setState("hover");
      });
      if (chart.hoverPoint) {
        chart.hoverPoint.firePointEvent("mouseOut");
      }
      if (!hoverPoint.series) {
        return;
      }
      chart.hoverPoints = points;
      chart.hoverPoint = hoverPoint;
      hoverPoint.firePointEvent("mouseOver", void 0, () => {
        if (tooltip && hoverPoint) {
          tooltip.refresh(useSharedTooltip ? points : hoverPoint, e);
        }
      });
    } else if (followPointer && tooltip && !tooltip.isHidden) {
      const anchor = tooltip.getAnchor([{}], e);
      if (chart.isInsidePlot(anchor[0], anchor[1], {
        visiblePlotOnly: true
      })) {
        tooltip.updatePosition({ plotX: anchor[0], plotY: anchor[1] });
      }
    }
    if (!pointer.unDocMouseMove) {
      pointer.unDocMouseMove = addEvent$1n(chart.container.ownerDocument, "mousemove", (e2) => charts$2[Pointer.hoverChartIndex ?? -1]?.pointer?.onDocumentMouseMove(e2));
      pointer.eventsToUnbind.push(pointer.unDocMouseMove);
    }
    chart.axes.forEach(function drawAxisCrosshair(axis) {
      const snap2 = axis.crosshair?.snap ?? true;
      let point;
      if (snap2) {
        point = chart.hoverPoint;
        if (!point || point.series[axis.coll] !== axis) {
          point = find$i(points, (p5) => p5.series?.[axis.coll] === axis);
        }
      }
      if (point || !snap2) {
        axis.drawCrosshair(e, point);
      } else {
        axis.hideCrosshair();
      }
    });
  }
  /**
   * Set the JS DOM events on the container and document. This method should
   * contain a one-to-one assignment between methods and their handlers. Any
   * advanced logic should be moved to the handler reflecting the event's
   * name.
   * @private
   * @function Highcharts.Pointer#setDOMEvents
   */
  setDOMEvents() {
    const container = this.chart.container, ownerDoc = container.ownerDocument;
    container.onmousedown = this.onContainerMouseDown.bind(this);
    container.onmousemove = this.onContainerMouseMove.bind(this);
    container.onclick = this.onContainerClick.bind(this);
    this.eventsToUnbind.push(addEvent$1n(container, "mouseenter", this.onContainerMouseEnter.bind(this)), addEvent$1n(container, "mouseleave", this.onContainerMouseLeave.bind(this)));
    if (!Pointer.unbindDocumentMouseUp.some((el) => el.doc === ownerDoc)) {
      Pointer.unbindDocumentMouseUp.push({
        doc: ownerDoc,
        unbind: addEvent$1n(ownerDoc, "mouseup", this.onDocumentMouseUp.bind(this))
      });
    }
    let parent = this.chart.renderTo.parentElement;
    while (parent && parent.tagName !== "BODY") {
      this.eventsToUnbind.push(addEvent$1n(parent, "scroll", () => {
        delete this.chartPosition;
      }));
      parent = parent.parentElement;
    }
    this.eventsToUnbind.push(addEvent$1n(container, "touchstart", this.onContainerTouchStart.bind(this), { passive: false }), addEvent$1n(container, "touchmove", this.onContainerTouchMove.bind(this), { passive: false }));
    if (!Pointer.unbindDocumentTouchEnd) {
      Pointer.unbindDocumentTouchEnd = addEvent$1n(ownerDoc, "touchend", this.onDocumentTouchEnd.bind(this), { passive: false });
    }
    this.setPointerCapture();
    addEvent$1n(this.chart, "redraw", this.setPointerCapture.bind(this));
  }
  /**
   * Sets, or removes on update, pointer events using pointer capture for
   * tooltip.followTouchMove if any series has findNearestPointBy that
   * includes the y dimension.
   * @private
   * @function Highcharts.Pointer#setPointerCapture
  */
  setPointerCapture() {
    if (!isTouchDevice$5) {
      return;
    }
    const pointer = this, events = pointer.pointerCaptureEventsToUnbind, chart = pointer.chart, container = chart.container, followTouchMove = pick$1D(chart.options.tooltip?.followTouchMove, true), shouldHave = followTouchMove && chart.series.some((series) => series.options.findNearestPointBy.indexOf("y") > -1);
    if (!pointer.hasPointerCapture && shouldHave) {
      events.push(addEvent$1n(container, "pointerdown", (e) => {
        if (e.target?.hasPointerCapture(e.pointerId)) {
          e.target?.releasePointerCapture(e.pointerId);
        }
      }), addEvent$1n(container, "pointermove", (e) => {
        chart.pointer?.getPointFromEvent(e)?.onMouseOver(e);
      }));
      if (!chart.styledMode) {
        css$a(container, { "touch-action": "none" });
      }
      container.className += " highcharts-no-touch-action";
      pointer.hasPointerCapture = true;
    } else if (pointer.hasPointerCapture && !shouldHave) {
      events.forEach((e) => e());
      events.length = 0;
      if (!chart.styledMode) {
        css$a(container, {
          "touch-action": pick$1D(chart.options.chart.style?.["touch-action"], "manipulation")
        });
      }
      container.className = container.className.replace(" highcharts-no-touch-action", "");
      pointer.hasPointerCapture = false;
    }
  }
  /**
   * Sets the index of the hovered chart and leaves the previous hovered
   * chart, to reset states like tooltip.
   * @private
   * @function Highcharts.Pointer#setHoverChartIndex
   */
  setHoverChartIndex(e) {
    const chart = this.chart;
    const hoverChart = Highcharts.charts[pick$1D(Pointer.hoverChartIndex, -1)];
    if (hoverChart && hoverChart !== chart) {
      const relatedTargetObj = { relatedTarget: chart.container };
      if (e && !e?.relatedTarget) {
        Object.assign({}, e, relatedTargetObj);
      }
      hoverChart.pointer?.onContainerMouseLeave(e || relatedTargetObj);
    }
    if (!hoverChart?.mouseIsDown) {
      Pointer.hoverChartIndex = chart.index;
    }
  }
  /**
   * General touch handler shared by touchstart and touchmove.
   * @private
   * @function Highcharts.Pointer#touch
   */
  touch(e, start2) {
    const { chart, pinchDown = [] } = this;
    let hasMoved, isInside;
    this.setHoverChartIndex();
    e = this.normalize(e);
    if (e.touches.length === 1) {
      isInside = chart.isInsidePlot(e.chartX - chart.plotLeft, e.chartY - chart.plotTop, {
        visiblePlotOnly: true
      });
      if (isInside && !chart.openMenu) {
        if (start2) {
          this.runPointActions(e);
        }
        if (e.type === "touchmove") {
          hasMoved = pinchDown[0] ? (
            // #5266
            Math.pow(pinchDown[0].chartX - e.chartX, 2) + Math.pow(pinchDown[0].chartY - e.chartY, 2) >= 16
          ) : false;
        }
        if (pick$1D(hasMoved, true)) {
          this.pinch(e);
        }
      } else if (start2) {
        this.reset();
      }
    } else if (e.touches.length === 2) {
      this.pinch(e);
    }
  }
  /**
   * Returns true if the chart is set up for zooming by single touch and the
   * event is capable
   * @private
   * @function Highcharts.Pointer#touchSelect
   */
  touchSelect(e) {
    return Boolean(this.chart.zooming.singleTouch && e.touches && e.touches.length === 1);
  }
  /**
   * Resolve the zoomType option, this is reset on all touch start and mouse
   * down events.
   * @private
   * @function Highcharts.Pointer#zoomOption
   */
  zoomOption(e) {
    const chart = this.chart, inverted = chart.inverted;
    let zoomType = chart.zooming.type || "", zoomX, zoomY;
    if (/touch/.test(e.type)) {
      zoomType = pick$1D(chart.zooming.pinchType, zoomType);
    }
    this.zoomX = zoomX = /x/.test(zoomType);
    this.zoomY = zoomY = /y/.test(zoomType);
    this.zoomHor = zoomX && !inverted || zoomY && inverted;
    this.zoomVert = zoomY && !inverted || zoomX && inverted;
    this.hasZoom = zoomX || zoomY;
  }
}
Pointer.unbindDocumentMouseUp = [];
(function(Pointer2) {
  function compose2(ChartClass) {
    if (pushUnique$w(composed$w, "Core.Pointer")) {
      addEvent$1n(ChartClass, "beforeRender", function() {
        this.pointer = new Pointer2(this, this.options);
      });
    }
  }
  Pointer2.compose = compose2;
})(Pointer || (Pointer = {}));
const Pointer$1 = Pointer;
var ColumnUtils;
(function(ColumnUtils2) {
  function setLength2(column2, length, asSubarray) {
    if (Array.isArray(column2)) {
      column2.length = length;
      return column2;
    }
    return column2[asSubarray ? "subarray" : "slice"](0, length);
  }
  ColumnUtils2.setLength = setLength2;
  function splice2(column2, start2, deleteCount, removedAsSubarray, items = []) {
    if (Array.isArray(column2)) {
      if (!Array.isArray(items)) {
        items = Array.from(items);
      }
      return {
        removed: column2.splice(start2, deleteCount, ...items),
        array: column2
      };
    }
    const Constructor = Object.getPrototypeOf(column2).constructor;
    const removed = column2[removedAsSubarray ? "subarray" : "slice"](start2, start2 + deleteCount);
    const newLength = column2.length - deleteCount + items.length;
    const result = new Constructor(newLength);
    result.set(column2.subarray(0, start2), 0);
    result.set(items, start2);
    result.set(column2.subarray(start2 + deleteCount), start2 + items.length);
    return {
      removed,
      array: result
    };
  }
  ColumnUtils2.splice = splice2;
})(ColumnUtils || (ColumnUtils = {}));
const ColumnUtils$1 = ColumnUtils;
const { setLength, splice } = ColumnUtils$1;
const { fireEvent: fireEvent$D, objectEach: objectEach$n, uniqueKey: uniqueKey$6 } = Utilities;
class DataTableCore {
  /**
       * Constructs an instance of the DataTable class.
       *
       * @example
       * const dataTable = new Highcharts.DataTableCore({
       *   columns: {
       *     year: [2020, 2021, 2022, 2023],
       *     cost: [11, 13, 12, 14],
       *     revenue: [12, 15, 14, 18]
       *   }
       * });
  
       *
       * @param {Highcharts.DataTableOptions} [options]
       * Options to initialize the new DataTable instance.
       */
  constructor(options2 = {}) {
    this.autoId = !options2.id;
    this.columns = {};
    this.id = options2.id || uniqueKey$6();
    this.modified = this;
    this.rowCount = 0;
    this.versionTag = uniqueKey$6();
    let rowCount = 0;
    objectEach$n(options2.columns || {}, (column2, columnName) => {
      this.columns[columnName] = column2.slice();
      rowCount = Math.max(rowCount, column2.length);
    });
    this.applyRowCount(rowCount);
  }
  /* *
   *
   *  Functions
   *
   * */
  /**
   * Applies a row count to the table by setting the `rowCount` property and
   * adjusting the length of all columns.
   *
   * @private
   * @param {number} rowCount The new row count.
   */
  applyRowCount(rowCount) {
    this.rowCount = rowCount;
    objectEach$n(this.columns, (column2, columnName) => {
      if (column2.length !== rowCount) {
        this.columns[columnName] = setLength(column2, rowCount);
      }
    });
  }
  /**
   * Delete rows. Simplified version of the full
   * `DataTable.deleteRows` method.
   *
   * @param {number} rowIndex
   * The start row index
   *
   * @param {number} [rowCount=1]
   * The number of rows to delete
   *
   * @return {void}
   *
   * @emits #afterDeleteRows
   */
  deleteRows(rowIndex, rowCount = 1) {
    if (rowCount > 0 && rowIndex < this.rowCount) {
      let length = 0;
      objectEach$n(this.columns, (column2, columnName) => {
        this.columns[columnName] = splice(column2, rowIndex, rowCount).array;
        length = column2.length;
      });
      this.rowCount = length;
    }
    fireEvent$D(this, "afterDeleteRows", { rowIndex, rowCount });
    this.versionTag = uniqueKey$6();
  }
  /**
   * Fetches the given column by the canonical column name. Simplified version
   * of the full `DataTable.getRow` method, always returning by reference.
   *
   * @param {string} columnName
   * Name of the column to get.
   *
   * @return {Highcharts.DataTableColumn|undefined}
   * A copy of the column, or `undefined` if not found.
   */
  getColumn(columnName, asReference) {
    return this.columns[columnName];
  }
  /**
   * Retrieves all or the given columns. Simplified version of the full
   * `DataTable.getColumns` method, always returning by reference.
   *
   * @param {Array<string>} [columnNames]
   * Column names to retrieve.
   *
   * @return {Highcharts.DataTableColumnCollection}
   * Collection of columns. If a requested column was not found, it is
   * `undefined`.
   */
  getColumns(columnNames, asReference) {
    return (columnNames || Object.keys(this.columns)).reduce((columns, columnName) => {
      columns[columnName] = this.columns[columnName];
      return columns;
    }, {});
  }
  /**
   * Retrieves the row at a given index.
   *
   * @param {number} rowIndex
   * Row index to retrieve. First row has index 0.
   *
   * @param {Array<string>} [columnNames]
   * Column names to retrieve.
   *
   * @return {Record<string, number|string|undefined>|undefined}
   * Returns the row values, or `undefined` if not found.
   */
  getRow(rowIndex, columnNames) {
    return (columnNames || Object.keys(this.columns)).map((key2) => this.columns[key2]?.[rowIndex]);
  }
  /**
   * Sets cell values for a column. Will insert a new column, if not found.
   *
   * @param {string} columnName
   * Column name to set.
   *
   * @param {Highcharts.DataTableColumn} [column]
   * Values to set in the column.
   *
   * @param {number} [rowIndex]
   * Index of the first row to change. (Default: 0)
   *
   * @param {Record<string, (boolean|number|string|null|undefined)>} [eventDetail]
   * Custom information for pending events.
   *
   * @emits #setColumns
   * @emits #afterSetColumns
   */
  setColumn(columnName, column2 = [], rowIndex = 0, eventDetail) {
    this.setColumns({ [columnName]: column2 }, rowIndex, eventDetail);
  }
  /**
   * Sets cell values for multiple columns. Will insert new columns, if not
   * found. Simplified version of the full `DataTableCore.setColumns`, limited
   * to full replacement of the columns (undefined `rowIndex`).
   *
   * @param {Highcharts.DataTableColumnCollection} columns
   * Columns as a collection, where the keys are the column names.
   *
   * @param {number} [rowIndex]
   * Index of the first row to change. Ignored in the `DataTableCore`, as it
   * always replaces the full column.
   *
   * @param {Record<string, (boolean|number|string|null|undefined)>} [eventDetail]
   * Custom information for pending events.
   *
   * @emits #setColumns
   * @emits #afterSetColumns
   */
  setColumns(columns, rowIndex, eventDetail) {
    let rowCount = this.rowCount;
    objectEach$n(columns, (column2, columnName) => {
      this.columns[columnName] = column2.slice();
      rowCount = column2.length;
    });
    this.applyRowCount(rowCount);
    if (!eventDetail?.silent) {
      fireEvent$D(this, "afterSetColumns");
      this.versionTag = uniqueKey$6();
    }
  }
  /**
   * Sets cell values of a row. Will insert a new row if no index was
   * provided, or if the index is higher than the total number of table rows.
   * A simplified version of the full `DateTable.setRow`, limited to objects.
   *
   * @param {Record<string, number|string|undefined>} row
   * Cell values to set.
   *
   * @param {number} [rowIndex]
   * Index of the row to set. Leave `undefined` to add as a new row.
   *
   * @param {boolean} [insert]
   * Whether to insert the row at the given index, or to overwrite the row.
   *
   * @param {Record<string, (boolean|number|string|null|undefined)>} [eventDetail]
   * Custom information for pending events.
   *
   * @emits #afterSetRows
   */
  setRow(row, rowIndex = this.rowCount, insert, eventDetail) {
    const { columns } = this, indexRowCount = insert ? this.rowCount + 1 : rowIndex + 1;
    objectEach$n(row, (cellValue, columnName) => {
      let column2 = columns[columnName] || eventDetail?.addColumns !== false && new Array(indexRowCount);
      if (column2) {
        if (insert) {
          column2 = splice(column2, rowIndex, 0, true, [cellValue]).array;
        } else {
          column2[rowIndex] = cellValue;
        }
        columns[columnName] = column2;
      }
    });
    if (indexRowCount > this.rowCount) {
      this.applyRowCount(indexRowCount);
    }
    if (!eventDetail?.silent) {
      fireEvent$D(this, "afterSetRows");
      this.versionTag = uniqueKey$6();
    }
  }
}
const { extend: extend$1f, merge: merge$1x, pick: pick$1C } = Utilities;
var LegendSymbol;
(function(LegendSymbol2) {
  function areaMarker(legend, item) {
    lineMarker.call(this, legend, item, true);
  }
  LegendSymbol2.areaMarker = areaMarker;
  function lineMarker(legend, item, hasArea2) {
    const legendItem = this.legendItem = this.legendItem || {}, { chart, options: options2 } = this, { baseline = 0, symbolWidth, symbolHeight } = legend, symbol = this.symbol || "circle", generalRadius = symbolHeight / 2, renderer = chart.renderer, legendItemGroup = legendItem.group, verticalCenter = baseline - Math.round((legend.fontMetrics?.b || symbolHeight) * // Render line and marker slightly higher to make room for the
    // area
    (hasArea2 ? 0.4 : 0.3)), attr2 = {};
    let legendSymbol, markerOptions = options2.marker, lineSizer = 0;
    if (!chart.styledMode) {
      attr2["stroke-width"] = Math.min(options2.lineWidth || 0, 24);
      if (options2.dashStyle) {
        attr2.dashstyle = options2.dashStyle;
      } else if (options2.linecap !== "square") {
        attr2["stroke-linecap"] = "round";
      }
    }
    legendItem.line = renderer.path().addClass("highcharts-graph").attr(attr2).add(legendItemGroup);
    if (hasArea2) {
      legendItem.area = renderer.path().addClass("highcharts-area").add(legendItemGroup);
    }
    if (attr2["stroke-linecap"]) {
      lineSizer = Math.min(legendItem.line.strokeWidth(), symbolWidth) / 2;
    }
    if (symbolWidth) {
      const d = [
        ["M", lineSizer, verticalCenter],
        ["L", symbolWidth - lineSizer, verticalCenter]
      ];
      legendItem.line.attr({ d });
      legendItem.area?.attr({
        d: [
          ...d,
          ["L", symbolWidth - lineSizer, baseline],
          ["L", lineSizer, baseline]
        ]
      });
    }
    if (markerOptions && markerOptions.enabled !== false && symbolWidth) {
      let radius = Math.min(pick$1C(markerOptions.radius, generalRadius), generalRadius);
      if (symbol.indexOf("url") === 0) {
        markerOptions = merge$1x(markerOptions, {
          width: symbolHeight,
          height: symbolHeight
        });
        radius = 0;
      }
      legendItem.symbol = legendSymbol = renderer.symbol(symbol, symbolWidth / 2 - radius, verticalCenter - radius, 2 * radius, 2 * radius, extend$1f({ context: "legend" }, markerOptions)).addClass("highcharts-point").add(legendItemGroup);
      legendSymbol.isMarker = true;
    }
  }
  LegendSymbol2.lineMarker = lineMarker;
  function rectangle(legend, item) {
    const legendItem = item.legendItem || {}, options2 = legend.options, symbolHeight = legend.symbolHeight, square = options2.squareSymbol, symbolWidth = square ? symbolHeight : legend.symbolWidth;
    legendItem.symbol = this.chart.renderer.rect(
      square ? (legend.symbolWidth - symbolHeight) / 2 : 0,
      legend.baseline - symbolHeight + 1,
      // #3988
      symbolWidth,
      symbolHeight,
      pick$1C(legend.options.symbolRadius, symbolHeight / 2)
    ).addClass("highcharts-point").attr({
      zIndex: 3
    }).add(legendItem.group);
  }
  LegendSymbol2.rectangle = rectangle;
})(LegendSymbol || (LegendSymbol = {}));
const LegendSymbol$1 = LegendSymbol;
const seriesDefaults = {
  // Base series options
  /**
   * The SVG value used for the `stroke-linecap` and `stroke-linejoin`
   * of a line graph. Round means that lines are rounded in the ends and
   * bends.
   *
   * @type       {Highcharts.SeriesLinecapValue}
   * @default    round
   * @since      3.0.7
   * @apioption  plotOptions.line.linecap
   */
  /**
   * Pixel width of the graph line.
   *
   * @see In styled mode, the line stroke-width can be set with the
   *      `.highcharts-graph` class name.
   *
   * @sample {highcharts} highcharts/plotoptions/series-linewidth-general/
   *         On all series
   * @sample {highcharts} highcharts/plotoptions/series-linewidth-specific/
   *         On one single series
   *
   * @product highcharts highstock
   */
  lineWidth: 2,
  /**
   * For some series, there is a limit that shuts down animation
   * by default when the total number of points in the chart is too high.
   * For example, for a column chart and its derivatives, animation does
   * not run if there is more than 250 points totally. To disable this
   * cap, set `animationLimit` to `Infinity`. This option works if animation
   * is fired on individual points, not on a group of points like e.g. during
   * the initial animation.
   *
   * @sample {highcharts} highcharts/plotoptions/series-animationlimit/
   *         Animation limit on updating individual points
   *
   * @type      {number}
   * @apioption plotOptions.series.animationLimit
   */
  /**
   * Allow this series' points to be selected by clicking on the graphic
   * (columns, point markers, pie slices, map areas etc).
   *
   * The selected points can be handled by point select and unselect
   * events, or collectively by the [getSelectedPoints
   * ](/class-reference/Highcharts.Chart#getSelectedPoints) function.
   *
   * And alternative way of selecting points is through dragging.
   *
   * @sample {highcharts} highcharts/plotoptions/series-allowpointselect-line/
   *         Line
   * @sample {highcharts} highcharts/plotoptions/series-allowpointselect-column/
   *         Column
   * @sample {highcharts} highcharts/plotoptions/series-allowpointselect-pie/
   *         Pie
   * @sample {highcharts} highcharts/chart/events-selection-points/
   *         Select a range of points through a drag selection
   * @sample {highmaps} maps/plotoptions/series-allowpointselect/
   *         Map area
   * @sample {highmaps} maps/plotoptions/mapbubble-allowpointselect/
   *         Map bubble
   *
   * @since 1.2.0
   *
   * @private
   */
  allowPointSelect: false,
  /**
   * When true, each point or column edge is rounded to its nearest pixel
   * in order to render sharp on screen. In some cases, when there are a
   * lot of densely packed columns, this leads to visible difference
   * in column widths or distance between columns. In these cases,
   * setting `crisp` to `false` may look better, even though each column
   * is rendered blurry.
   *
   * @sample {highcharts} highcharts/plotoptions/column-crisp-false/
   *         Crisp is false
   *
   * @since   5.0.10
   * @product highcharts highstock gantt
   *
   * @private
   */
  crisp: true,
  /**
   * If true, a checkbox is displayed next to the legend item to allow
   * selecting the series. The state of the checkbox is determined by
   * the `selected` option.
   *
   * @productdesc {highmaps}
   * Note that if a `colorAxis` is defined, the color axis is represented
   * in the legend, not the series.
   *
   * @sample {highcharts} highcharts/plotoptions/series-showcheckbox-true/
   *         Show select box
   *
   * @since 1.2.0
   *
   * @private
   */
  showCheckbox: false,
  /**
   * Enable or disable the initial animation when a series is displayed.
   * The animation can also be set as a configuration object. Please
   * note that this option only applies to the initial animation of the
   * series itself. For other animations, see [chart.animation](
   * #chart.animation) and the animation parameter under the API methods.
   * The following properties are supported:
   *
   * - `defer`: The animation delay time in milliseconds.
   *
   * - `duration`: The duration of the animation in milliseconds. (Defaults to
   *   `1000`)
   *
   * - `easing`: Can be a string reference to an easing function set on
   *   the `Math` object or a function. See the _Custom easing function_
   *   demo below. (Defaults to `easeInOutSine`)
   *
   * Due to poor performance, animation is disabled in old IE browsers
   * for several chart types.
   *
   * @sample {highcharts} highcharts/plotoptions/series-animation-disabled/
   *         Animation disabled
   * @sample {highcharts} highcharts/plotoptions/series-animation-slower/
   *         Slower animation
   * @sample {highcharts} highcharts/plotoptions/series-animation-easing/
   *         Custom easing function
   * @sample {highstock} stock/plotoptions/animation-slower/
   *         Slower animation
   * @sample {highstock} stock/plotoptions/animation-easing/
   *         Custom easing function
   * @sample {highmaps} maps/plotoptions/series-animation-true/
   *         Animation enabled on map series
   * @sample {highmaps} maps/plotoptions/mapbubble-animation-false/
   *         Disabled on mapbubble series
   *
   * @type    {boolean|Highcharts.AnimationOptionsObject}
   * @default {highcharts} true
   * @default {highstock} true
   * @default {highmaps} false
   *
   * @private
   */
  animation: {
    /** @ignore-option */
    duration: 1e3
  },
  /**
   * An additional class name to apply to the series' graphical elements.
   * This option does not replace default class names of the graphical
   * element. Changes to the series' color will also be reflected in a
   * chart's legend and tooltip.
   *
   * @sample {highcharts} highcharts/css/point-series-classname
   *         Series and point class name
   *
   * @type      {string}
   * @since     5.0.0
   * @apioption plotOptions.series.className
   */
  /**
   * Disable this option to allow series rendering in the whole plotting
   * area.
   *
   * **Note:** Clipping should be always enabled when
   * [chart.zoomType](#chart.zoomType) is set
   *
   * @sample {highcharts} highcharts/plotoptions/series-clip/
   *         Disabled clipping
   *
   * @default   true
   * @type      {boolean}
   * @since     3.0.0
   * @apioption plotOptions.series.clip
   */
  /**
   * The main color of the series. In line type series it applies to the
   * line and the point markers unless otherwise specified. In bar type
   * series it applies to the bars unless a color is specified per point.
   * The default value is pulled from the `options.colors` array.
   *
   * In styled mode, the color can be defined by the
   * [colorIndex](#plotOptions.series.colorIndex) option. Also, the series
   * color can be set with the `.highcharts-series`,
   * `.highcharts-color-{n}`, `.highcharts-{type}-series` or
   * `.highcharts-series-{n}` class, or individual classes given by the
   * `className` option.
   *
   * @productdesc {highmaps}
   * In maps, the series color is rarely used, as most choropleth maps use
   * the color to denote the value of each point. The series color can
   * however be used in a map with multiple series holding categorized
   * data.
   *
   * @sample {highcharts} highcharts/plotoptions/series-color-general/
   *         General plot option
   * @sample {highcharts} highcharts/plotoptions/series-color-specific/
   *         One specific series
   * @sample {highcharts} highcharts/plotoptions/series-color-area/
   *         Area color
   * @sample {highcharts} highcharts/series/infographic/
   *         Pattern fill
   * @sample {highmaps} maps/demo/category-map/
   *         Category map by multiple series
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @apioption plotOptions.series.color
   */
  /**
   * Styled mode only. A specific color index to use for the series, so its
   * graphic representations are given the class name `highcharts-color-{n}`.
   *
   * Since v11, CSS variables on the form `--highcharts-color-{n}` make
   * changing the color scheme very convenient.
   *
   * @sample    {highcharts} highcharts/css/colorindex/ Series and point color
   *            index
   *
   * @type      {number}
   * @since     5.0.0
   * @apioption plotOptions.series.colorIndex
   */
  /**
   * Whether to connect a graph line across null points, or render a gap
   * between the two points on either side of the null.
   *
   * In stacked area chart, if `connectNulls` is set to true,
   * null points are interpreted as 0.
   *
   * @sample {highcharts} highcharts/plotoptions/series-connectnulls-false/
   *         False by default
   * @sample {highcharts} highcharts/plotoptions/series-connectnulls-true/
   *         True
   *
   * @type      {boolean}
   * @default   false
   * @product   highcharts highstock
   * @apioption plotOptions.series.connectNulls
   */
  /**
   * You can set the cursor to "pointer" if you have click events attached
   * to the series, to signal to the user that the points and lines can
   * be clicked.
   *
   * In styled mode, the series cursor can be set with the same classes
   * as listed under [series.color](#plotOptions.series.color).
   *
   * @sample {highcharts} highcharts/plotoptions/series-cursor-line/
   *         On line graph
   * @sample {highcharts} highcharts/plotoptions/series-cursor-column/
   *         On columns
   * @sample {highcharts} highcharts/plotoptions/series-cursor-scatter/
   *         On scatter markers
   * @sample {highstock} stock/plotoptions/cursor/
   *         Pointer on a line graph
   * @sample {highmaps} maps/plotoptions/series-allowpointselect/
   *         Map area
   * @sample {highmaps} maps/plotoptions/mapbubble-allowpointselect/
   *         Map bubble
   *
   * @type      {string|Highcharts.CursorValue}
   * @apioption plotOptions.series.cursor
   */
  /**
   * A reserved subspace to store options and values for customized
   * functionality. Here you can add additional data for your own event
   * callbacks and formatter callbacks.
   *
   * @sample {highcharts} highcharts/point/custom/
   *         Point and series with custom data
   *
   * @type      {Highcharts.Dictionary<*>}
   * @apioption plotOptions.series.custom
   */
  /**
   * Name of the dash style to use for the graph, or for some series types
   * the outline of each shape.
   *
   * In styled mode, the
   * [stroke dash-array](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/css/series-dashstyle/)
   * can be set with the same classes as listed under
   * [series.color](#plotOptions.series.color).
   *
   * @sample {highcharts} highcharts/plotoptions/series-dashstyle-all/
   *         Possible values demonstrated
   * @sample {highcharts} highcharts/plotoptions/series-dashstyle/
   *         Chart suitable for printing in black and white
   * @sample {highstock} highcharts/plotoptions/series-dashstyle-all/
   *         Possible values demonstrated
   * @sample {highmaps} highcharts/plotoptions/series-dashstyle-all/
   *         Possible values demonstrated
   * @sample {highmaps} maps/plotoptions/series-dashstyle/
   *         Dotted borders on a map
   *
   * @type      {Highcharts.DashStyleValue}
   * @default   Solid
   * @since     2.1
   * @apioption plotOptions.series.dashStyle
   */
  /**
   * A description of the series to add to the screen reader information
   * about the series.
   *
   * @type      {string}
   * @since     5.0.0
   * @requires  modules/accessibility
   * @apioption plotOptions.series.description
   */
  /**
   * Options for the series data sorting.
   *
   * @type      {Highcharts.DataSortingOptionsObject}
   * @since     8.0.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.dataSorting
   */
  /**
   * Enable or disable data sorting for the series. Use [xAxis.reversed](
   * #xAxis.reversed) to change the sorting order.
   *
   * @sample {highcharts} highcharts/datasorting/animation/
   *         Data sorting in scatter-3d
   * @sample {highcharts} highcharts/datasorting/labels-animation/
   *         Axis labels animation
   * @sample {highcharts} highcharts/datasorting/dependent-sorting/
   *         Dependent series sorting
   * @sample {highcharts} highcharts/datasorting/independent-sorting/
   *         Independent series sorting
   *
   * @type      {boolean}
   * @since     8.0.0
   * @apioption plotOptions.series.dataSorting.enabled
   */
  /**
   * Whether to allow matching points by name in an update. If this option
   * is disabled, points will be matched by order.
   *
   * @sample {highcharts} highcharts/datasorting/match-by-name/
   *         Enabled match by name
   *
   * @type      {boolean}
   * @since     8.0.0
   * @apioption plotOptions.series.dataSorting.matchByName
   */
  /**
   * Determines what data value should be used to sort by.
   *
   * @sample {highcharts} highcharts/datasorting/sort-key/
   *         Sort key as `z` value
   *
   * @type      {string}
   * @since     8.0.0
   * @default   y
   * @apioption plotOptions.series.dataSorting.sortKey
   */
  /**
   * Enable or disable the mouse tracking for a specific series. This
   * includes point tooltips and click events on graphs and points. For
   * large datasets it improves performance.
   *
   * @sample {highcharts} highcharts/plotoptions/series-enablemousetracking-false/
   *         No mouse tracking
   * @sample {highmaps} maps/plotoptions/series-enablemousetracking-false/
   *         No mouse tracking
   *
   * @type      {boolean}
   * @default   true
   * @apioption plotOptions.series.enableMouseTracking
   */
  enableMouseTracking: true,
  /**
   * Whether to use the Y extremes of the total chart width or only the
   * zoomed area when zooming in on parts of the X axis. By default, the
   * Y axis adjusts to the min and max of the visible data. Cartesian
   * series only.
   *
   * @type      {boolean}
   * @default   false
   * @since     4.1.6
   * @product   highcharts highstock gantt
   * @apioption plotOptions.series.getExtremesFromAll
   */
  /**
   * Highlight only the hovered point and fade the remaining points.
   *
   * Scatter-type series require enabling the 'inactive' marker state and
   * adjusting opacity. Note that this approach could affect performance
   * with large datasets.
   *
   * @sample {highcharts} highcharts/plotoptions/series-inactiveotherpoints-enabled/
   *         Chart with inactiveOtherPoints option enabled.
   *
   * @type      {boolean}
   * @default   false
   * @apioption plotOptions.series.inactiveOtherPoints
   */
  /**
   * An array specifying which option maps to which key in the data point
   * array. This makes it convenient to work with unstructured data arrays
   * from different sources.
   *
   * @see [series.data](#series.line.data)
   *
   * @sample {highcharts|highstock} highcharts/series/data-keys/
   *         An extended data array with keys
   * @sample {highcharts|highstock} highcharts/series/data-nested-keys/
   *         Nested keys used to access object properties
   *
   * @type      {Array<string>}
   * @since     4.1.6
   * @apioption plotOptions.series.keys
   */
  /**
   * The line cap used for line ends and line joins on the graph.
   *
   * @sample highcharts/series-line/linecap/
   *         Line cap comparison
   *
   * @type       {Highcharts.SeriesLinecapValue}
   * @default    round
   * @product    highcharts highstock
   * @apioption  plotOptions.series.linecap
   */
  /**
   * The [id](#series.id) of another series to link to. Additionally,
   * the value can be ":previous" to link to the previous series. When
   * two series are linked, only the first one appears in the legend.
   * Toggling the visibility of this also toggles the linked series.
   *
   * If master series uses data sorting and linked series does not have
   * its own sorting definition, the linked series will be sorted in the
   * same order as the master one.
   *
   * @sample {highcharts|highstock} highcharts/demo/arearange-line/
   *         Linked series
   *
   * @type      {string}
   * @since     3.0
   * @product   highcharts highstock gantt
   * @apioption plotOptions.series.linkedTo
   */
  /**
   * Options for the corresponding navigator series if `showInNavigator`
   * is `true` for this series. Available options are the same as any
   * series, documented at [plotOptions](#plotOptions.series) and
   * [series](#series).
   *
   * These options are merged with options in [navigator.series](
   * #navigator.series), and will take precedence if the same option is
   * defined both places.
   *
   * @see [navigator.series](#navigator.series)
   *
   * @type      {Highcharts.PlotSeriesOptions}
   * @since     5.0.0
   * @product   highstock
   * @apioption plotOptions.series.navigatorOptions
   */
  /**
   * The color for the parts of the graph or points that are below the
   * [threshold](#plotOptions.series.threshold). Note that `zones` takes
   * precedence over the negative color. Using `negativeColor` is
   * equivalent to applying a zone with value of 0.
   *
   * @see In styled mode, a negative color is applied by setting this option
   *      to `true` combined with the `.highcharts-negative` class name.
   *
   * @sample {highcharts} highcharts/plotoptions/series-negative-color/
   *         Spline, area and column
   * @sample {highcharts} highcharts/plotoptions/arearange-negativecolor/
   *         Arearange
   * @sample {highcharts} highcharts/css/series-negative-color/
   *         Styled mode
   * @sample {highstock} highcharts/plotoptions/series-negative-color/
   *         Spline, area and column
   * @sample {highstock} highcharts/plotoptions/arearange-negativecolor/
   *         Arearange
   * @sample {highmaps} highcharts/plotoptions/series-negative-color/
   *         Spline, area and column
   * @sample {highmaps} highcharts/plotoptions/arearange-negativecolor/
   *         Arearange
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @since     3.0
   * @apioption plotOptions.series.negativeColor
   */
  /**
   * Whether or not data-points with the value of `null` should be interactive.
   * When this is set to `true`, tooltips may highlight these points, and this
   * option also enables keyboard navigation for such points. Format options
   * for such points include [`nullFormat`](#tooltip.nullFormat) and [`nullFormater`](#tooltip.nullFormatter).
   * Works for these series: `line`, `spline`, `area`, `area-spline`,
   * `column`, `bar`, and* `timeline`.
   *
   * @sample {highcharts} highcharts/series/null-interaction/
   *         Chart with interactive `null` points
   *
   * @sample {highcharts} highcharts/series-timeline/null-interaction/
   *         Timeline series with `null` points
   *
   * @type      {boolean|undefined}
   * @product   highcharts highstock
   * @apioption plotOptions.series.nullInteraction
   */
  /**
   * Same as
   * [accessibility.point.descriptionFormat](#accessibility.point.descriptionFormat),
   * but for an individual series. Overrides the chart wide configuration.
   *
   * @type      {Function}
   * @since 11.1.0
   * @apioption plotOptions.series.pointDescriptionFormat
   */
  /**
   * Same as
   * [accessibility.series.descriptionFormatter](#accessibility.series.descriptionFormatter),
   * but for an individual series. Overrides the chart wide configuration.
   *
   * @type      {Function}
   * @since     5.0.12
   * @apioption plotOptions.series.pointDescriptionFormatter
   */
  /**
   * If no x values are given for the points in a series, `pointInterval`
   * defines the interval of the x values. For example, if a series
   * contains one value every decade starting from year 0, set
   * `pointInterval` to `10`. In true `datetime` axes, the `pointInterval`
   * is set in milliseconds.
   *
   * It can be also be combined with `pointIntervalUnit` to draw irregular
   * time intervals.
   *
   * If combined with `relativeXValue`, an x value can be set on each
   * point, and the `pointInterval` is added x times to the `pointStart`
   * setting.
   *
   * Please note that this options applies to the _series data_, not the
   * interval of the axis ticks, which is independent.
   *
   * @sample {highcharts} highcharts/plotoptions/series-pointstart-datetime/
   *         Datetime X axis
   * @sample {highcharts} highcharts/plotoptions/series-relativexvalue/
   *         Relative x value
   * @sample {highstock} stock/plotoptions/pointinterval-pointstart/
   *         Using pointStart and pointInterval
   * @sample {highstock} stock/plotoptions/relativexvalue/
   *         Relative x value
   *
   * @type      {number}
   * @default   1
   * @product   highcharts highstock gantt
   * @apioption plotOptions.series.pointInterval
   */
  /**
   * On datetime series, this allows for setting the
   * [pointInterval](#plotOptions.series.pointInterval) to irregular time
   * units, `day`, `month` and `year`. A day is usually the same as 24
   * hours, but `pointIntervalUnit` also takes the DST crossover into
   * consideration when dealing with local time. Combine this option with
   * `pointInterval` to draw weeks, quarters, 6 months, 10 years etc.
   *
   * Please note that this options applies to the _series data_, not the
   * interval of the axis ticks, which is independent.
   *
   * @sample {highcharts} highcharts/plotoptions/series-pointintervalunit/
   *         One point a month
   * @sample {highstock} highcharts/plotoptions/series-pointintervalunit/
   *         One point a month
   *
   * @type       {string}
   * @since      4.1.0
   * @product    highcharts highstock gantt
   * @validvalue ["day", "month", "year"]
   * @apioption  plotOptions.series.pointIntervalUnit
   */
  /**
   * Possible values: `"on"`, `"between"`, `number`.
   *
   * In a column chart, when pointPlacement is `"on"`, the point will not
   * create any padding of the X axis. In a polar column chart this means
   * that the first column points directly north. If the pointPlacement is
   * `"between"`, the columns will be laid out between ticks. This is
   * useful for example for visualising an amount between two points in
   * time or in a certain sector of a polar chart.
   *
   * Since Highcharts 3.0.2, the point placement can also be numeric,
   * where 0 is on the axis value, -0.5 is between this value and the
   * previous, and 0.5 is between this value and the next. Unlike the
   * textual options, numeric point placement options won't affect axis
   * padding.
   *
   * Note that pointPlacement needs a [pointRange](
   * #plotOptions.series.pointRange) to work. For column series this is
   * computed, but for line-type series it needs to be set.
   *
   * For the `xrange` series type and gantt charts, if the Y axis is a
   * category axis, the `pointPlacement` applies to the Y axis rather than
   * the (typically datetime) X axis.
   *
   * Defaults to `undefined` in cartesian charts, `"between"` in polar
   * charts.
   *
   * @see [xAxis.tickmarkPlacement](#xAxis.tickmarkPlacement)
   *
   * @sample {highcharts|highstock} highcharts/plotoptions/series-pointplacement-between/
   *         Between in a column chart
   * @sample {highcharts|highstock} highcharts/plotoptions/series-pointplacement-numeric/
   *         Numeric placement for custom layout
   * @sample {highcharts|highstock} maps/plotoptions/heatmap-pointplacement/
   *         Placement in heatmap
   *
   * @type      {string|number}
   * @since     2.3.0
   * @product   highcharts highstock gantt
   * @apioption plotOptions.series.pointPlacement
   */
  /**
   * If no x values are given for the points in a series, `pointStart`
   * defines on what value to start. For example, if a series contains one
   * yearly value starting from 1945, set `pointStart` to 1945.
   *
   * The `pointStart` setting can be a number, or a datetime string that is
   * parsed according to the `time.timezone` setting.
   *
   * If combined with `relativeXValue`, an x value can be set on each
   * point. The x value from the point options is multiplied by
   * `pointInterval` and added to `pointStart` to produce a modified x
   * value.
   *
   * @sample {highcharts} highcharts/plotoptions/series-pointstart-linear/
   *         Linear
   * @sample {highcharts} highcharts/plotoptions/series-pointstart-datetime/
   *         Datetime
   * @sample {highcharts} highcharts/plotoptions/series-relativexvalue/
   *         Relative x value
   * @sample {highstock} stock/plotoptions/pointinterval-pointstart/
   *         Using pointStart and pointInterval
   * @sample {highstock} stock/plotoptions/relativexvalue/
   *         Relative x value
   *
   * @type      {number|string}
   * @default   0
   * @product   highcharts highstock gantt
   * @apioption plotOptions.series.pointStart
   */
  /**
   * When true, X values in the data set are relative to the current
   * `pointStart`, `pointInterval` and `pointIntervalUnit` settings. This
   * allows compression of the data for datasets with irregular X values.
   *
   * The real X values are computed on the formula `f(x) = ax + b`, where
   * `a` is the `pointInterval` (optionally with a time unit given by
   * `pointIntervalUnit`), and `b` is the `pointStart`.
   *
   * @sample {highcharts} highcharts/plotoptions/series-relativexvalue/
   *         Relative X value
   * @sample {highstock} stock/plotoptions/relativexvalue/
   *         Relative X value
   *
   * @type      {boolean}
   * @default   false
   * @product   highcharts highstock
   * @apioption plotOptions.series.relativeXValue
   */
  /**
   * Whether to select the series initially. If `showCheckbox` is true,
   * the checkbox next to the series name in the legend will be checked
   * for a selected series.
   *
   * @sample {highcharts} highcharts/plotoptions/series-selected/
   *         One out of two series selected
   *
   * @type      {boolean}
   * @default   false
   * @since     1.2.0
   * @apioption plotOptions.series.selected
   */
  /**
   * Whether to apply a drop shadow to the graph line. Since 2.3 the
   * shadow can be an object configuration containing `color`, `offsetX`,
   * `offsetY`, `opacity` and `width`.
   *
   * Note that in some cases, like stacked columns or other dense layouts, the
   * series may cast shadows on each other. In that case, the
   * `chart.seriesGroupShadow` allows applying a common drop shadow to the
   * whole series group.
   *
   * @sample {highcharts} highcharts/plotoptions/series-shadow/
   *         Shadow enabled
   *
   * @type      {boolean|Highcharts.ShadowOptionsObject}
   * @default   false
   * @apioption plotOptions.series.shadow
   */
  /**
   * Whether to display this particular series or series type in the
   * legend. Standalone series are shown in legend by default, and linked
   * series are not. Since v7.2.0 it is possible to show series that use
   * colorAxis by setting this option to `true`.
   *
   * @sample {highcharts} highcharts/plotoptions/series-showinlegend/
   *         One series in the legend, one hidden
   *
   * @type      {boolean}
   * @apioption plotOptions.series.showInLegend
   */
  /**
   * Whether or not to show the series in the navigator. Takes precedence
   * over [navigator.baseSeries](#navigator.baseSeries) if defined.
   *
   * @type      {boolean}
   * @since     5.0.0
   * @product   highstock
   * @apioption plotOptions.series.showInNavigator
   */
  /**
   * If set to `true`, the accessibility module will skip past the points
   * in this series for keyboard navigation.
   *
   * @type      {boolean}
   * @since     5.0.12
   * @apioption plotOptions.series.skipKeyboardNavigation
   */
  /**
   * Whether to stack the values of each series on top of each other.
   * Possible values are `undefined` to disable, `"normal"` to stack by
   * value or `"percent"`.
   *
   * When stacking is enabled, data must be sorted
   * in ascending X order.
   *
   * Some stacking options are related to specific series types. In the
   * streamgraph series type, the stacking option is set to `"stream"`.
   * The second one is `"overlap"`, which only applies to waterfall
   * series.
   *
   * @see [yAxis.reversedStacks](#yAxis.reversedStacks)
   *
   * @sample {highcharts} highcharts/plotoptions/series-stacking-line/
   *         Line
   * @sample {highcharts} highcharts/plotoptions/series-stacking-column/
   *         Column
   * @sample {highcharts} highcharts/plotoptions/series-stacking-bar/
   *         Bar
   * @sample {highcharts} highcharts/plotoptions/series-stacking-area/
   *         Area
   * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-line/
   *         Line
   * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-column/
   *         Column
   * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-bar/
   *         Bar
   * @sample {highcharts} highcharts/plotoptions/series-stacking-percent-area/
   *         Area
   * @sample {highcharts} highcharts/plotoptions/series-waterfall-with-normal-stacking
   *         Waterfall with normal stacking
   * @sample {highcharts} highcharts/plotoptions/series-waterfall-with-overlap-stacking
   *         Waterfall with overlap stacking
   * @sample {highstock} stock/plotoptions/stacking/
   *         Area
   *
   * @type       {string}
   * @product    highcharts highstock
   * @validvalue ["normal", "overlap", "percent", "stream"]
   * @apioption  plotOptions.series.stacking
   */
  /**
   * Whether to apply steps to the line. Possible values are `left`,
   * `center` and `right`.
   *
   * @sample {highcharts} highcharts/plotoptions/line-step/
   *         Different step line options
   * @sample {highcharts} highcharts/plotoptions/area-step/
   *         Stepped, stacked area
   * @sample {highstock} stock/plotoptions/line-step/
   *         Step line
   *
   * @type       {string}
   * @since      1.2.5
   * @product    highcharts highstock
   * @validvalue ["left", "center", "right"]
   * @apioption  plotOptions.series.step
   */
  /**
   * The threshold, also called zero level or base level. For line type
   * series this is only used in conjunction with
   * [negativeColor](#plotOptions.series.negativeColor).
   *
   * @see [softThreshold](#plotOptions.series.softThreshold).
   *
   * @type      {number|null}
   * @default   0
   * @since     3.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.threshold
   */
  /**
   * Set the initial visibility of the series.
   *
   * @sample {highcharts} highcharts/plotoptions/series-visible/
   *         Two series, one hidden and one visible
   * @sample {highstock} stock/plotoptions/series-visibility/
   *         Hidden series
   *
   * @type      {boolean}
   * @default   true
   * @apioption plotOptions.series.visible
   */
  /**
   * Defines the Axis on which the zones are applied.
   *
   * @see [zones](#plotOptions.series.zones)
   *
   * @sample {highcharts} highcharts/series/color-zones-zoneaxis-x/
   *         Zones on the X-Axis
   * @sample {highstock} highcharts/series/color-zones-zoneaxis-x/
   *         Zones on the X-Axis
   *
   * @type      {string}
   * @default   y
   * @since     4.1.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.zoneAxis
   */
  /**
   * General event handlers for the series items. These event hooks can
   * also be attached to the series at run time using the
   * `Highcharts.addEvent` function.
   *
   * @declare Highcharts.SeriesEventsOptionsObject
   *
   * @private
   */
  events: {},
  /**
   * Fires after the series has finished its initial animation, or in case
   * animation is disabled, immediately as the series is displayed.
   *
   * @sample {highcharts} highcharts/plotoptions/series-events-afteranimate/
   *         Show label after animate
   * @sample {highstock} highcharts/plotoptions/series-events-afteranimate/
   *         Show label after animate
   *
   * @type      {Highcharts.SeriesAfterAnimateCallbackFunction}
   * @since     4.0
   * @product   highcharts highstock gantt
   * @context   Highcharts.Series
   * @apioption plotOptions.series.events.afterAnimate
   */
  /**
   * Fires when the checkbox next to the series' name in the legend is
   * clicked. One parameter, `event`, is passed to the function. The state
   * of the checkbox is found by `event.checked`. The checked item is
   * found by `event.item`. Return `false` to prevent the default action
   * which is to toggle the select state of the series.
   *
   * @sample {highcharts} highcharts/plotoptions/series-events-checkboxclick/
   *         Alert checkbox status
   *
   * @type      {Highcharts.SeriesCheckboxClickCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Series
   * @apioption plotOptions.series.events.checkboxClick
   */
  /**
   * Fires when the series is clicked. One parameter, `event`, is passed
   * to the function, containing common event information. Additionally,
   * `event.point` holds a pointer to the nearest point on the graph.
   *
   * @sample {highcharts} highcharts/plotoptions/series-events-click/
   *         Alert click info
   * @sample {highstock} stock/plotoptions/series-events-click/
   *         Alert click info
   * @sample {highmaps} maps/plotoptions/series-events-click/
   *         Display click info in subtitle
   *
   * @type      {Highcharts.SeriesClickCallbackFunction}
   * @context   Highcharts.Series
   * @apioption plotOptions.series.events.click
   */
  /**
   * Fires when the series is hidden after chart generation time, either
   * by clicking the legend item or by calling `.hide()`.
   *
   * @sample {highcharts} highcharts/plotoptions/series-events-hide/
   *         Alert when the series is hidden by clicking the legend item
   *
   * @type      {Highcharts.SeriesHideCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Series
   * @apioption plotOptions.series.events.hide
   */
  /**
   * Fires when the legend item belonging to the series is clicked. One
   * parameter, `event`, is passed to the function. The default action
   * is to toggle the visibility of the series. This can be prevented
   * by returning `false` or calling `event.preventDefault()`.
   *
   * **Note:** This option is deprecated in favor of
   * [legend.events.itemClick](#legend.events.itemClick).
   *
   * @type       {Highcharts.SeriesLegendItemClickCallbackFunction}
   * @deprecated 11.4.4
   * @context    Highcharts.Series
   * @apioption  plotOptions.series.events.legendItemClick
   */
  /**
   * Fires when the mouse leaves the graph. One parameter, `event`, is
   * passed to the function, containing common event information. If the
   * [stickyTracking](#plotOptions.series) option is true, `mouseOut`
   * doesn't happen before the mouse enters another graph or leaves the
   * plot area.
   *
   * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-sticky/
   *         With sticky tracking by default
   * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-no-sticky/
   *         Without sticky tracking
   *
   * @type      {Highcharts.SeriesMouseOutCallbackFunction}
   * @context   Highcharts.Series
   * @apioption plotOptions.series.events.mouseOut
   */
  /**
   * Fires when the mouse enters the graph. One parameter, `event`, is
   * passed to the function, containing common event information.
   *
   * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-sticky/
   *         With sticky tracking by default
   * @sample {highcharts} highcharts/plotoptions/series-events-mouseover-no-sticky/
   *         Without sticky tracking
   *
   * @type      {Highcharts.SeriesMouseOverCallbackFunction}
   * @context   Highcharts.Series
   * @apioption plotOptions.series.events.mouseOver
   */
  /**
   * Fires when the series is shown after chart generation time, either
   * by clicking the legend item or by calling `.show()`.
   *
   * @sample {highcharts} highcharts/plotoptions/series-events-show/
   *         Alert when the series is shown by clicking the legend item.
   *
   * @type      {Highcharts.SeriesShowCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Series
   * @apioption plotOptions.series.events.show
   */
  /**
   * Options for the point markers of line and scatter-like series. Properties
   * like `fillColor`, `lineColor` and `lineWidth` define the visual
   * appearance of the markers. The `symbol` option defines the shape. Other
   * series types, like column series, don't have markers, but have visual
   * options on the series level instead.
   *
   * In styled mode, the markers can be styled with the `.highcharts-point`,
   * `.highcharts-point-hover` and `.highcharts-point-select` class names.
   *
   * @declare Highcharts.PointMarkerOptionsObject
   *
   * @sample {highmaps} maps/demo/mappoint-mapmarker
   *         Using the mapmarker symbol for points
   *
   * @private
   */
  marker: {
    /**
     * Enable or disable the point marker. If `undefined`, the markers
     * are hidden when the data is dense, and shown for more widespread
     * data points.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-enabled/
     *         Disabled markers
     * @sample {highcharts} highcharts/plotoptions/series-marker-enabled-false/
     *         Disabled in normal state but enabled on hover
     * @sample {highstock} stock/plotoptions/series-marker/
     *         Enabled markers
     *
     * @type      {boolean}
     * @default   {highcharts} undefined
     * @default   {highstock} false
     * @apioption plotOptions.series.marker.enabled
     */
    /**
     * The threshold for how dense the point markers should be before
     * they are hidden, given that `enabled` is not defined. The number
     * indicates the horizontal distance between the two closest points
     * in the series, as multiples of the `marker.radius`. In other
     * words, the default value of 2 means points are hidden if
     * overlapping horizontally.
     *
     * @sample highcharts/plotoptions/series-marker-enabledthreshold
     *         A higher threshold
     *
     * @since 6.0.5
     */
    enabledThreshold: 2,
    /**
     * The fill color of the point marker. When `undefined`, the series'
     * or point's color is used.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-fillcolor/
     *         White fill
     *
     * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     * @apioption plotOptions.series.marker.fillColor
     */
    /**
     * Image markers only. Set the image width explicitly. When using
     * this option, a `width` must also be set.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-width-height/
     *         Fixed width and height
     * @sample {highstock} highcharts/plotoptions/series-marker-width-height/
     *         Fixed width and height
     *
     * @type      {number}
     * @since     4.0.4
     * @apioption plotOptions.series.marker.height
     */
    /**
     * The color of the point marker's outline. When `undefined`, the
     * series' or point's color is used.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-fillcolor/
     *         Inherit from series color (undefined)
     *
     * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     */
    lineColor: "#ffffff",
    /**
     * The width of the point marker's outline.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-fillcolor/
     *         2px blue marker
     */
    lineWidth: 0,
    /**
     * The radius of the point marker.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-radius/
     *         Bigger markers
     *
     * @default {highstock} 2
     * @default {highcharts} 4
     *
     */
    radius: 4,
    /**
     * A predefined shape or symbol for the marker. When undefined, the
     * symbol is pulled from options.symbols. Other possible values are
     * `'circle'`, `'square'`,`'diamond'`, `'triangle'` and
     * `'triangle-down'`.
     *
     * Additionally, the URL to a graphic can be given on this form:
     * `'url(graphic.png)'`. Note that for the image to be applied to
     * exported charts, its URL needs to be accessible by the export
     * server.
     *
     * Custom callbacks for symbol path generation can also be added to
     * `Highcharts.SVGRenderer.prototype.symbols`. The callback is then
     * used by its method name, as shown in the demo.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-symbol/
     *         Predefined, graphic and custom markers
     * @sample {highstock} highcharts/plotoptions/series-marker-symbol/
     *         Predefined, graphic and custom markers
     * @sample {highmaps} maps/demo/mappoint-mapmarker
     *         Using the mapmarker symbol for points
     *
     * @type      {string}
     * @apioption plotOptions.series.marker.symbol
     */
    /**
     * Image markers only. Set the image width explicitly. When using
     * this option, a `height` must also be set.
     *
     * @sample {highcharts} highcharts/plotoptions/series-marker-width-height/
     *         Fixed width and height
     * @sample {highstock} highcharts/plotoptions/series-marker-width-height/
     *         Fixed width and height
     *
     * @type      {number}
     * @since     4.0.4
     * @apioption plotOptions.series.marker.width
     */
    /**
     * States for a single point marker.
     *
     * @declare Highcharts.PointStatesOptionsObject
     */
    states: {
      /**
       * The normal state of a single point marker. Currently only
       * used for setting animation when returning to normal state
       * from hover.
       *
       * @declare Highcharts.PointStatesNormalOptionsObject
       */
      normal: {
        /**
         * Animation when returning to normal state after hovering.
         *
         * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
         */
        animation: true
      },
      /**
       * The hover state for a single point marker.
       *
       * @declare Highcharts.PointStatesHoverOptionsObject
       */
      hover: {
        /**
         * Animation when hovering over the marker.
         *
         * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
         */
        animation: {
          /** @internal */
          duration: 150
        },
        /**
         * Enable or disable the point marker.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-enabled/
         *         Disabled hover state
         */
        enabled: true,
        /**
         * The fill color of the marker in hover state. When
         * `undefined`, the series' or point's fillColor for normal
         * state is used.
         *
         * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         * @apioption plotOptions.series.marker.states.hover.fillColor
         */
        /**
         * The color of the point marker's outline. When
         * `undefined`, the series' or point's lineColor for normal
         * state is used.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-linecolor/
         *         White fill color, black line color
         *
         * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         * @apioption plotOptions.series.marker.states.hover.lineColor
         */
        /**
         * The width of the point marker's outline. When
         * `undefined`, the series' or point's lineWidth for normal
         * state is used.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-linewidth/
         *         3px line width
         *
         * @type      {number}
         * @apioption plotOptions.series.marker.states.hover.lineWidth
         */
        /**
         * The radius of the point marker. In hover state, it
         * defaults to the normal state's radius + 2 as per the
         * [radiusPlus](#plotOptions.series.marker.states.hover.radiusPlus)
         * option.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-hover-radius/
         *         10px radius
         *
         * @type      {number}
         * @apioption plotOptions.series.marker.states.hover.radius
         */
        /**
         * The number of pixels to increase the radius of the
         * hovered point.
         *
         * @sample {highcharts} highcharts/plotoptions/series-states-hover-linewidthplus/
         *         5 pixels greater radius on hover
         * @sample {highstock} highcharts/plotoptions/series-states-hover-linewidthplus/
         *         5 pixels greater radius on hover
         *
         * @since 4.0.3
         */
        radiusPlus: 2,
        /**
         * The additional line width for a hovered point.
         *
         * @sample {highcharts} highcharts/plotoptions/series-states-hover-linewidthplus/
         *         2 pixels wider on hover
         * @sample {highstock} highcharts/plotoptions/series-states-hover-linewidthplus/
         *         2 pixels wider on hover
         *
         * @since 4.0.3
         */
        lineWidthPlus: 1
      },
      /**
       * The appearance of the point marker when selected. In order to
       * allow a point to be selected, set the
       * `series.allowPointSelect` option to true.
       *
       * @declare Highcharts.PointStatesSelectOptionsObject
       */
      select: {
        /**
         * Enable or disable visible feedback for selection.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-enabled/
         *         Disabled select state
         *
         * @type      {boolean}
         * @default   true
         * @apioption plotOptions.series.marker.states.select.enabled
         */
        /**
         * The radius of the point marker. In hover state, it
         * defaults to the normal state's radius + 2.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-radius/
         *         10px radius for selected points
         *
         * @type      {number}
         * @apioption plotOptions.series.marker.states.select.radius
         */
        /**
         * The fill color of the point marker.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-fillcolor/
         *         Solid red discs for selected points
         *
         * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         */
        fillColor: "#cccccc",
        /**
         * The color of the point marker's outline. When
         * `undefined`, the series' or point's color is used.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-linecolor/
         *         Red line color for selected points
         *
         * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
         */
        lineColor: "#000000",
        /**
         * The width of the point marker's outline.
         *
         * @sample {highcharts} highcharts/plotoptions/series-marker-states-select-linewidth/
         *         3px line width for selected points
         */
        lineWidth: 2
      }
    }
  },
  /**
   * Properties for each single point.
   *
   * @declare Highcharts.PlotSeriesPointOptions
   *
   * @private
   */
  point: {
    /**
     * Fires when a point is clicked. One parameter, `event`, is passed
     * to the function, containing common event information.
     *
     * If the `series.allowPointSelect` option is true, the default
     * action for the point's click event is to toggle the point's
     * select state. Returning `false` cancels this action.
     *
     * @sample {highcharts} highcharts/plotoptions/series-point-events-click/
     *         Click marker to alert values
     * @sample {highcharts} highcharts/plotoptions/series-point-events-click-column/
     *         Click column
     * @sample {highcharts} highcharts/plotoptions/series-point-events-click-url/
     *         Go to URL
     * @sample {highmaps} maps/plotoptions/series-point-events-click/
     *         Click marker to display values
     * @sample {highmaps} maps/plotoptions/series-point-events-click-url/
     *         Go to URL
     *
     * @type      {Highcharts.PointClickCallbackFunction}
     * @context   Highcharts.Point
     * @apioption plotOptions.series.point.events.click
     */
    /**
     * Fires when the mouse leaves the area close to the point. One
     * parameter, `event`, is passed to the function, containing common
     * event information.
     *
     * @sample {highcharts} highcharts/plotoptions/series-point-events-mouseover/
     *         Show values in the chart's corner on mouse over
     *
     * @type      {Highcharts.PointMouseOutCallbackFunction}
     * @context   Highcharts.Point
     * @apioption plotOptions.series.point.events.mouseOut
     */
    /**
     * Fires when the mouse enters the area close to the point. One
     * parameter, `event`, is passed to the function, containing common
     * event information.
     *
     * Returning `false` cancels the default behavior, which is to show a
     * tooltip for the point.
     *
     * @sample {highcharts} highcharts/plotoptions/series-point-events-mouseover/
     *         Show values in the chart's corner on mouse over
     *
     * @type      {Highcharts.PointMouseOverCallbackFunction}
     * @context   Highcharts.Point
     * @apioption plotOptions.series.point.events.mouseOver
     */
    /**
     * Fires when the point is removed using the `.remove()` method. One
     * parameter, `event`, is passed to the function. Returning `false`
     * cancels the operation.
     *
     * @sample {highcharts} highcharts/plotoptions/series-point-events-remove/
     *         Remove point and confirm
     *
     * @type      {Highcharts.PointRemoveCallbackFunction}
     * @since     1.2.0
     * @context   Highcharts.Point
     * @apioption plotOptions.series.point.events.remove
     */
    /**
     * Fires when the point is selected either programmatically or
     * following a click on the point. One parameter, `event`, is passed
     * to the function. Returning `false` cancels the operation.
     *
     * @sample {highcharts} highcharts/plotoptions/series-point-events-select/
     *         Report the last selected point
     * @sample {highmaps} maps/plotoptions/series-allowpointselect/
     *         Report select and unselect
     *
     * @type      {Highcharts.PointSelectCallbackFunction}
     * @since     1.2.0
     * @context   Highcharts.Point
     * @apioption plotOptions.series.point.events.select
     */
    /**
     * Fires when the point is unselected either programmatically or
     * following a click on the point. One parameter, `event`, is passed
     * to the function.
     *  Returning `false` cancels the operation.
     *
     * @sample {highcharts} highcharts/plotoptions/series-point-events-unselect/
     *         Report the last unselected point
     * @sample {highmaps} maps/plotoptions/series-allowpointselect/
     *         Report select and unselect
     *
     * @type      {Highcharts.PointUnselectCallbackFunction}
     * @since     1.2.0
     * @context   Highcharts.Point
     * @apioption plotOptions.series.point.events.unselect
     */
    /**
     * Fires when the point is updated programmatically through the
     * `.update()` method. One parameter, `event`, is passed to the
     * function. The new point options can be accessed through
     * `event.options`. Returning `false` cancels the operation.
     *
     * @sample {highcharts} highcharts/plotoptions/series-point-events-update/
     *         Confirm point updating
     *
     * @type      {Highcharts.PointUpdateCallbackFunction}
     * @since     1.2.0
     * @context   Highcharts.Point
     * @apioption plotOptions.series.point.events.update
     */
    /**
     * Events for each single point.
     *
     * @declare Highcharts.PointEventsOptionsObject
     */
    events: {}
  },
  /**
   * Options for the series data labels, appearing next to each data
   * point.
   *
   * Since v6.2.0, multiple data labels can be applied to each single
   * point by defining them as an array of configs.
   *
   * In styled mode, the data labels can be styled with the
   * `.highcharts-data-label-box` and `.highcharts-data-label` class names
   * ([see example](https://www.highcharts.com/samples/highcharts/css/series-datalabels)).
   *
   * @sample {highcharts} highcharts/plotoptions/series-datalabels-enabled
   *         Data labels enabled
   * @sample {highcharts} highcharts/plotoptions/series-datalabels-multiple
   *         Multiple data labels on a bar series
   * @sample {highcharts} highcharts/css/series-datalabels
   *         Styled mode example
   * @sample {highmaps} maps/demo/color-axis
   *         Choropleth map with data labels
   * @sample {highmaps} maps/demo/mappoint-datalabels-mapmarker
   *         Using data labels as map markers
   *
   * @type    {*|Array<*>}
   * @product highcharts highstock highmaps gantt
   *
   * @private
   */
  dataLabels: {
    /**
     * Enable or disable the initial animation when a series is displayed
     * for the `dataLabels`. The animation can also be set as a
     * configuration object. Please note that this option only applies to
     * the initial animation.
     *
     * For other animations, see [chart.animation](#chart.animation) and the
     * animation parameter under the API methods. The following properties
     * are supported:
     *
     * - `defer`: The animation delay time in milliseconds.
     *
     * @sample {highcharts} highcharts/plotoptions/animation-defer/
     *          Animation defer settings
     *
     * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
     * @since     8.2.0
     * @apioption plotOptions.series.dataLabels.animation
     */
    animation: {},
    /**
     * The animation delay time in milliseconds. Set to `0` to render the
     * data labels immediately. As `undefined` inherits defer time from the
     * [series.animation.defer](#plotOptions.series.animation.defer).
     *
     * @type      {number}
     * @since     8.2.0
     * @apioption plotOptions.series.dataLabels.animation.defer
     */
    /**
     * The alignment of the data label compared to the point. If `right`,
     * the right side of the label should be touching the point. For points
     * with an extent, like columns, the alignments also dictates how to
     * align it inside the box, as given with the
     * [inside](#plotOptions.column.dataLabels.inside) option. Can be one of
     * `left`, `center` or `right`.
     *
     * @sample {highcharts}
     *         highcharts/plotoptions/series-datalabels-align-left/ Left
     *         aligned
     * @sample {highcharts}
     *         highcharts/plotoptions/bar-datalabels-align-inside-bar/ Data
     *         labels inside the bar
     *
     * @type {Highcharts.AlignValue|null}
     */
    align: "center",
    /**
     * Alignment method for data labels. If set to `plotEdges`, the labels
     * are aligned within the plot area in the direction of the y-axis. So
     * in a regular column chart, the labels are aligned vertically
     * according to the `verticalAlign` setting. In a bar chart, which is
     * inverted, the labels are aligned horizontally according to the
     * `align` setting. Applies to cartesian series only.
     *
     * @sample {highcharts} highcharts/series-bar/datalabels-alignto/
     *         Align to plot edges
     *
     * @type      {string}
     * @since 11.4.2
     * @apioption plotOptions.series.dataLabels.alignTo
     */
    /**
     * Whether to allow data labels to overlap. To make the labels less
     * sensitive for overlapping, the
     * [dataLabels.padding](#plotOptions.series.dataLabels.padding)
     * can be set to 0.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-allowoverlap-false/
     *         Don't allow overlap
     *
     * @type      {boolean}
     * @default   false
     * @since     4.1.0
     * @apioption plotOptions.series.dataLabels.allowOverlap
     */
    /**
     * The background color or gradient for the data label. Setting it to
     * `auto` will use the point's color.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
     *         Data labels box options
     * @sample {highmaps} maps/plotoptions/series-datalabels-box/
     *         Data labels box options
     * @sample {highmaps} maps/demo/mappoint-datalabels-mapmarker
     *         Data labels as map markers
     *
     * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     * @since     2.2.1
     * @apioption plotOptions.series.dataLabels.backgroundColor
     */
    /**
     * The border color for the data label. Setting it to `auto` will use
     * the point's color. Defaults to `undefined`.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
     *         Data labels box options
     *
     * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     * @since     2.2.1
     * @apioption plotOptions.series.dataLabels.borderColor
     */
    /**
     * The border radius in pixels for the data label.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
     *         Data labels box options
     * @sample {highmaps} maps/plotoptions/series-datalabels-box/
     *         Data labels box options
     *
     * @type      {number}
     * @default   0
     * @since     2.2.1
     * @apioption plotOptions.series.dataLabels.borderRadius
     */
    /**
     * The border width in pixels for the data label.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
     *         Data labels box options
     *
     * @type      {number}
     * @default   0
     * @since     2.2.1
     * @apioption plotOptions.series.dataLabels.borderWidth
     */
    borderWidth: 0,
    /**
     * A class name for the data label. Particularly in styled mode,
     * this can be used to give each series' or point's data label
     * unique styling. In addition to this option, a default color class
     * name is added so that we can give the labels a contrast text
     * shadow.
     *
     * @sample {highcharts} highcharts/css/data-label-contrast/
     *         Contrast text shadow
     * @sample {highcharts} highcharts/css/series-datalabels/
     *         Styling by CSS
     *
     * @type      {string}
     * @since     5.0.0
     * @apioption plotOptions.series.dataLabels.className
     */
    /**
     * This options is deprecated.
     * Use [style.color](#plotOptions.series.dataLabels.style) instead.
     *
     * The text color for the data labels. Defaults to `undefined`. For
     * certain series types, like column or map, the data labels can be
     * drawn inside the points. In this case the data label will be
     * drawn with maximum contrast by default. Additionally, it will be
     * given a `text-outline` style with the opposite color, to further
     * increase the contrast. This can be overridden by setting the
     * `text-outline` style to `none` in the `dataLabels.style` option.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-color/
     *         Red data labels
     * @sample {highmaps} maps/demo/color-axis/
     *         White data labels
     *
     * @see [style.color](#plotOptions.series.dataLabels.style)
     *
     * @type       {Highcharts.ColorType}
     * @deprecated 10.3
     * @apioption  plotOptions.series.dataLabels.color
     */
    /**
     * Whether to hide data labels that are outside the plot area. By
     * default, the data label is moved inside the plot area according
     * to the
     * [overflow](#plotOptions.series.dataLabels.overflow)
     * option.
     *
     * @type      {boolean}
     * @default   true
     * @since     2.3.3
     * @apioption plotOptions.series.dataLabels.crop
     */
    /**
     * Whether to defer displaying the data labels until the initial
     * series animation has finished. Setting to `false` renders the
     * data label immediately. If set to `true` inherits the defer
     * time set in [plotOptions.series.animation](#plotOptions.series.animation).
     *
     * @since     4.0.0
     * @type      {boolean}
     * @product   highcharts highstock gantt
     */
    defer: true,
    /**
     * Enable or disable the data labels.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-enabled/
     *         Data labels enabled
     * @sample {highmaps} maps/demo/color-axis/
     *         Data labels enabled
     *
     * @type      {boolean}
     * @default   false
     * @apioption plotOptions.series.dataLabels.enabled
     */
    /**
     * A declarative filter to control of which data labels to display.
     * The declarative filter is designed for use when callback
     * functions are not available, like when the chart options require
     * a pure JSON structure or for use with graphical editors. For
     * programmatic control, use the `formatter` instead, and return
     * `undefined` to disable a single data label.
     *
     * @example
     * filter: {
     *     property: 'percentage',
     *     operator: '>',
     *     value: 4
     * }
     *
     * @sample {highcharts} highcharts/demo/pie-monochrome
     *         Data labels filtered by percentage
     *
     * @declare   Highcharts.DataLabelsFilterOptionsObject
     * @since     6.0.3
     * @apioption plotOptions.series.dataLabels.filter
     */
    /**
     * The operator to compare by. Can be one of `>`, `<`, `>=`, `<=`,
     * `==`, `===`, `!=` and `!==`.
     *
     * @type       {string}
     * @validvalue [">", "<", ">=", "<=", "==", "===", "!=", "!=="]
     * @apioption  plotOptions.series.dataLabels.filter.operator
     */
    /**
     * The point property to filter by. Point options are passed
     * directly to properties, additionally there are `y` value,
     * `percentage` and others listed under {@link Highcharts.Point}
     * members.
     *
     * @type      {string}
     * @apioption plotOptions.series.dataLabels.filter.property
     */
    /**
     * The value to compare against.
     *
     * @type      {number}
     * @apioption plotOptions.series.dataLabels.filter.value
     */
    /**
     * A
     * [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
     * for the data label. Available variables are the same as for
     * `formatter`.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-format/
     *         Add a unit
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-format-subexpression/
     *         Complex logic in the format string
     * @sample {highmaps} maps/plotoptions/series-datalabels-format/
     *         Formatted value in the data label
     *
     * @type      {string}
     * @default   y
     * @default   point.value
     * @since     3.0
     * @apioption plotOptions.series.dataLabels.format
     */
    // eslint-disable-next-line valid-jsdoc
    /**
     * Callback JavaScript function to format the data label. Note that if a
     * `format` is defined, the format takes precedence and the formatter is
     * ignored.
     *
     * @sample {highmaps} maps/plotoptions/series-datalabels-format/
     *         Formatted value
     *
     * @type {Highcharts.DataLabelsFormatterCallbackFunction}
     */
    formatter: function() {
      const { numberFormatter } = this.series.chart;
      return typeof this.y !== "number" ? "" : numberFormatter(this.y, -1);
    },
    /**
     * For points with an extent, like columns or map areas, whether to
     * align the data label inside the box or to the actual value point.
     * Defaults to `false` in most cases, `true` in stacked columns.
     *
     * @type      {boolean}
     * @since     3.0
     * @apioption plotOptions.series.dataLabels.inside
     */
    /**
     * Format for points with the value of null. Works analogously to
     * [format](#plotOptions.series.dataLabels.format). `nullFormat` can
     * be applied only to series which support displaying null points.
     * `heatmap` and `tilemap` supports `nullFormat` by default while the
     * following series requires [#series.nullInteraction] set to `true`:
     * `line`, `spline`, `area`, `area-spline`, `column`, `bar`, and
     * `timeline`. Does not work with series that don't display null
     * points, like `pie`.
     *
     * @sample {highcharts} highcharts/series/null-interaction/
     *         Line chart with null interaction
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-nullformat/
     *         Heatmap with null interaction
     *
     * @type      {boolean|string}
     * @since     7.1.0
     * @apioption plotOptions.series.dataLabels.nullFormat
     */
    /**
             * Callback JavaScript function that defines formatting for points
             * with the value of null. Works analogously to [formatter](#plotOptions.series.dataLabels.formatter).
             * `nullFormatter` can be applied only to series which support
             * displaying null points. `heatmap` and `tilemap` supports
             * `nullFormatter` by default while the following series requires [#series.nullInteraction]
             * set to `true`: `line`, `spline`, `area`, `area-spline`, `column`,
             * `bar`, and `timeline`. Does not work with series that don't display
             * null points, like `pie`.
    
             * @sample {highcharts} highcharts/plotoptions/series-datalabels-nullformat/
             *         Format data label for null points in heat map
             *
             * @type      {Highcharts.DataLabelsFormatterCallbackFunction}
             * @since     7.1.0
             * @apioption plotOptions.series.dataLabels.nullFormatter
             */
    /**
     * How to handle data labels that flow outside the plot area. The
     * default is `"justify"`, which aligns them inside the plot area.
     * For columns and bars, this means it will be moved inside the bar.
     * To display data labels outside the plot area, set `crop` to
     * `false` and `overflow` to `"allow"`.
     *
     * @type       {Highcharts.DataLabelsOverflowValue}
     * @default    justify
     * @since      3.0.6
     * @apioption  plotOptions.series.dataLabels.overflow
     */
    /**
     * When either the `borderWidth` or the `backgroundColor` is set,
     * this is the padding within the box.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
     *         Data labels box options
     * @sample {highmaps} maps/plotoptions/series-datalabels-box/
     *         Data labels box options
     *
     * @since 2.2.1
     */
    padding: 5,
    /**
     * Aligns data labels relative to points. If `center` alignment is
     * not possible, it defaults to `right`.
     *
     * @type      {Highcharts.AlignValue}
     * @default   center
     * @apioption plotOptions.series.dataLabels.position
     */
    /**
     * Text rotation in degrees. Note that due to a more complex
     * structure, backgrounds, borders and padding will be lost on a
     * rotated data label.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-rotation/
     *         Vertical labels
     *
     * @type      {number}
     * @default   0
     * @apioption plotOptions.series.dataLabels.rotation
     */
    /**
     * The shadow of the box. Works best with `borderWidth` or
     * `backgroundColor`. Since 2.3 the shadow can be an object
     * configuration containing `color`, `offsetX`, `offsetY`, `opacity`
     * and `width`.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-box/
     *         Data labels box options
     *
     * @type      {boolean|Highcharts.ShadowOptionsObject}
     * @default   false
     * @since     2.2.1
     * @apioption plotOptions.series.dataLabels.shadow
     */
    /**
     * The name of a symbol to use for the border around the label.
     * Symbols are predefined functions on the Renderer object.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-shape/
     *         A callout for annotations
     *
     * @type      {string}
     * @default   square
     * @since     4.1.2
     * @apioption plotOptions.series.dataLabels.shape
     */
    /**
     * Styles for the label. The default `color` setting is
     * `"contrast"`, which is a pseudo color that Highcharts picks up
     * and applies the maximum contrast to the underlying point item,
     * for example the bar in a bar chart.
     *
     * The `textOutline` is a pseudo property that applies an outline of
     * the given width with the given color, which by default is the
     * maximum contrast to the text. So a bright text color will result
     * in a black text outline for maximum readability on a mixed
     * background. In some cases, especially with grayscale text, the
     * text outline doesn't work well, in which cases it can be disabled
     * by setting it to `"none"`. When `useHTML` is true, the
     * `textOutline` will not be picked up. In this, case, the same
     * effect can be acheived through the `text-shadow` CSS property.
     *
     * For some series types, where each point has an extent, like for
     * example tree maps, the data label may overflow the point. There
     * are two strategies for handling overflow. By default, the text
     * will wrap to multiple lines. The other strategy is to set
     * `style.textOverflow` to `ellipsis`, which will keep the text on
     * one line plus it will break inside long words.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-style/
     *         Bold labels
     * @sample {highcharts} highcharts/plotoptions/pie-datalabels-overflow/
     *         Long labels truncated with an ellipsis in a pie
     * @sample {highcharts} highcharts/plotoptions/pie-datalabels-overflow-wrap/
     *         Long labels are wrapped in a pie
     * @sample {highmaps} maps/demo/color-axis/
     *         Bold labels
     *
     * @type      {Highcharts.CSSObject}
     * @since     4.1.0
     * @apioption plotOptions.series.dataLabels.style
     */
    style: {
      /** @internal */
      fontSize: "0.7em",
      /** @internal */
      fontWeight: "bold",
      /** @internal */
      color: "contrast",
      /** @internal */
      textOutline: "1px contrast"
    },
    /**
     * Options for a label text which should follow marker's shape.
     * Border and background are disabled for a label that follows a
     * path.
     *
     * **Note:** Only SVG-based renderer supports this option. Setting
     * `useHTML` to true will disable this option.
     *
     * @declare   Highcharts.DataLabelsTextPathOptionsObject
     * @since     7.1.0
     * @apioption plotOptions.series.dataLabels.textPath
     */
    /**
     * Presentation attributes for the text path.
     *
     * @type      {Highcharts.SVGAttributes}
     * @since     7.1.0
     * @apioption plotOptions.series.dataLabels.textPath.attributes
     */
    /**
     * Enable or disable `textPath` option for link's or marker's data
     * labels.
     *
     * @type      {boolean}
     * @since     7.1.0
     * @apioption plotOptions.series.dataLabels.textPath.enabled
     */
    /**
     * Whether to
     * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the labels.
     *
     * @type      {boolean}
     * @default   false
     * @apioption plotOptions.series.dataLabels.useHTML
     */
    /**
     * The vertical alignment of a data label. Can be one of `top`,
     * `middle` or `bottom`. The default value depends on the data, for
     * instance in a column chart, the label is above positive values
     * and below negative values.
     *
     * @type  {Highcharts.VerticalAlignValue|null}
     * @since 2.3.3
     */
    verticalAlign: "bottom",
    /**
     * The x position offset of the label relative to the point in
     * pixels.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-rotation/
     *         Vertical and positioned
     * @sample {highcharts} highcharts/plotoptions/bar-datalabels-align-inside-bar/
     *         Data labels inside the bar
     */
    x: 0,
    /**
     * The z index of the data labels. Use a `zIndex` of 6 to display it above
     * the series, or use a `zIndex` of 2 to display it behind the series.
     *
     * @type      {number}
     * @default   6
     * @since     2.3.5
     * @apioption plotOptions.series.dataLabels.zIndex
     */
    /**
     * The y position offset of the label relative to the point in
     * pixels.
     *
     * @sample {highcharts} highcharts/plotoptions/series-datalabels-rotation/
     *         Vertical and positioned
     */
    y: 0
  },
  /**
   * When the series contains less points than the crop threshold, all
   * points are drawn, even if the points fall outside the visible plot
   * area at the current zoom. The advantage of drawing all points
   * (including markers and columns), is that animation is performed on
   * updates. On the other hand, when the series contains more points than
   * the crop threshold, the series data is cropped to only contain points
   * that fall within the plot area. The advantage of cropping away
   * invisible points is to increase performance on large series.
   *
   * @since   2.2
   * @product highcharts highstock
   *
   * @private
   */
  cropThreshold: 300,
  /**
   * Opacity of a series parts: line, fill (e.g. area) and dataLabels.
   *
   * @see [states.inactive.opacity](#plotOptions.series.states.inactive.opacity)
   *
   * @since 7.1.0
   *
   * @private
   */
  opacity: 1,
  /**
   * The width of each point on the x axis. For example in a column chart
   * with one value each day, the pointRange would be 1 day (= 24 * 3600
   * * 1000 milliseconds). This is normally computed automatically, but
   * this option can be used to override the automatic value.
   *
   * @product highstock
   *
   * @private
   */
  pointRange: 0,
  /**
   * When this is true, the series will not cause the Y axis to cross
   * the zero plane (or [threshold](#plotOptions.series.threshold) option)
   * unless the data actually crosses the plane.
   *
   * For example, if `softThreshold` is `false`, a series of 0, 1, 2,
   * 3 will make the Y axis show negative values according to the
   * `minPadding` option. If `softThreshold` is `true`, the Y axis starts
   * at 0.
   *
   * @since   4.1.9
   * @product highcharts highstock
   *
   * @private
   */
  softThreshold: true,
  /**
   * @declare Highcharts.SeriesStatesOptionsObject
   *
   * @private
   */
  states: {
    /**
     * The normal state of a series, or for point items in column, pie
     * and similar series. Currently only used for setting animation
     * when returning to normal state from hover.
     *
     * @declare Highcharts.SeriesStatesNormalOptionsObject
     */
    normal: {
      /**
       * Animation when returning to normal state after hovering.
       *
           * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
       */
      animation: true
    },
    /**
     * Options for the hovered series. These settings override the
     * normal state options when a series is moused over or touched.
     *
     * @declare Highcharts.SeriesStatesHoverOptionsObject
     */
    hover: {
      /**
       * Enable separate styles for the hovered series to visualize
       * that the user hovers either the series itself or the legend.
       *
       * @sample {highcharts} highcharts/plotoptions/series-states-hover-enabled/
       *         Line
       * @sample {highcharts} highcharts/plotoptions/series-states-hover-enabled-column/
       *         Column
       * @sample {highcharts} highcharts/plotoptions/series-states-hover-enabled-pie/
       *         Pie
       *
       * @type      {boolean}
       * @default   true
       * @since     1.2
       * @apioption plotOptions.series.states.hover.enabled
       */
      /**
       * Animation setting for hovering the graph in line-type series.
       *
       * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
       * @since   5.0.8
       * @product highcharts highstock
       */
      animation: {
        /**
         * The duration of the hover animation in milliseconds. By
         * default the hover state animates quickly in, and slowly
         * back to normal.
         *
         * @internal
         */
        duration: 150
      },
      /**
       * Pixel width of the graph line. By default this property is
       * undefined, and the `lineWidthPlus` property dictates how much
       * to increase the linewidth from normal state.
       *
       * @sample {highcharts} highcharts/plotoptions/series-states-hover-linewidth/
       *         5px line on hover
       *
       * @type      {number}
       * @product   highcharts highstock
       * @apioption plotOptions.series.states.hover.lineWidth
       */
      /**
       * The additional line width for the graph of a hovered series.
       *
       * @sample {highcharts} highcharts/plotoptions/series-states-hover-linewidthplus/
       *         5 pixels wider
       * @sample {highstock} highcharts/plotoptions/series-states-hover-linewidthplus/
       *         5 pixels wider
       *
       * @since   4.0.3
       * @product highcharts highstock
       */
      lineWidthPlus: 1,
      /**
       * In Highcharts 1.0, the appearance of all markers belonging
       * to the hovered series. For settings on the hover state of the
       * individual point, see
       * [marker.states.hover](#plotOptions.series.marker.states.hover).
       *
       * @deprecated
       *
       * @extends   plotOptions.series.marker
       * @excluding states, symbol
       * @product   highcharts highstock
       */
      marker: {
        // `lineWidth: base + 1`,
        // `radius: base + 1`
      },
      /**
       * Options for the halo appearing around the hovered point in
       * line-type series as well as outside the hovered slice in pie
       * charts. By default the halo is filled by the current point or
       * series color with an opacity of 0.25\. The halo can be
       * disabled by setting the `halo` option to `null`.
       *
       * In styled mode, the halo is styled with the
       * `.highcharts-halo` class, with colors inherited from
       * `.highcharts-color-{n}`.
       *
       * @sample {highcharts} highcharts/plotoptions/halo/
       *         Halo options
       * @sample {highstock} highcharts/plotoptions/halo/
       *         Halo options
       *
       * @declare Highcharts.SeriesStatesHoverHaloOptionsObject
       * @type    {null|*}
       * @since   4.0
       * @product highcharts highstock
       */
      halo: {
        /**
         * A collection of SVG attributes to override the appearance
         * of the halo, for example `fill`, `stroke` and
         * `stroke-width`.
         *
         * @type      {Highcharts.SVGAttributes}
         * @since     4.0
         * @product   highcharts highstock
         * @apioption plotOptions.series.states.hover.halo.attributes
         */
        /**
         * The pixel size of the halo. For point markers this is the
         * radius of the halo. For pie slices it is the width of the
         * halo outside the slice. For bubbles it defaults to 5 and
         * is the width of the halo outside the bubble.
         *
         * @since   4.0
         * @product highcharts highstock
         */
        size: 10,
        /**
         * Opacity for the halo unless a specific fill is overridden
         * using the `attributes` setting. Note that Highcharts is
         * only able to apply opacity to colors of hex or rgb(a)
         * formats.
         *
         * @since   4.0
         * @product highcharts highstock
         */
        opacity: 0.25
      }
    },
    /**
     * Specific options for point in selected states, after being
     * selected by
     * [allowPointSelect](#plotOptions.series.allowPointSelect)
     * or programmatically.
     *
     * @sample maps/plotoptions/series-allowpointselect/
     *         Allow point select demo
     *
     * @declare   Highcharts.SeriesStatesSelectOptionsObject
     * @extends   plotOptions.series.states.hover
     * @excluding brightness
     */
    select: {
      animation: {
        /** @internal */
        duration: 0
      }
    },
    /**
     * The opposite state of a hover for series.
     *
     * @sample highcharts/plotoptions/series-states-inactive-disabled
     *         Disabled inactive state
     *
     * @declare Highcharts.SeriesStatesInactiveOptionsObject
     */
    inactive: {
      /**
       * Enable or disable the inactive state for a series
       *
       * @sample highcharts/plotoptions/series-states-inactive-disabled
       *         Disabled inactive state
       *
       * @type {boolean}
       * @default true
       * @apioption plotOptions.series.states.inactive.enabled
       */
      /**
       * The animation for entering the inactive state.
       *
       * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
       */
      animation: {
        /** @internal */
        duration: 150
      },
      /**
       * Opacity of series elements (dataLabels, line, area).
       *
       * @type {number}
       */
      opacity: 0.2
    }
  },
  /**
   * Sticky tracking of mouse events. When true, the `mouseOut` event on a
   * series isn't triggered until the mouse moves over another series, or
   * out of the plot area. When false, the `mouseOut` event on a series is
   * triggered when the mouse leaves the area around the series' graph or
   * markers. This also implies the tooltip when not shared. When
   * `stickyTracking` is false and `tooltip.shared` is false, the tooltip
   * will be hidden when moving the mouse between series. Defaults to true
   * for line and area type series, but to false for columns, pies etc.
   *
   * **Note:** The boost module will force this option because of
   * technical limitations.
   *
   * @sample {highcharts} highcharts/plotoptions/series-stickytracking-true/
   *         True by default
   * @sample {highcharts} highcharts/plotoptions/series-stickytracking-false/
   *         False
   *
   * @default {highcharts} true
   * @default {highstock} true
   * @default {highmaps} false
   * @since   2.0
   *
   * @private
   */
  stickyTracking: true,
  /**
   * A configuration object for the tooltip rendering of each single
   * series. Properties are inherited from [tooltip](#tooltip), but only
   * the following properties can be defined on a series level.
   *
   * @declare   Highcharts.SeriesTooltipOptionsObject
   * @since     2.3
   * @extends   tooltip
   * @excluding animation, backgroundColor, borderColor, borderRadius,
   *            borderWidth, className, crosshairs, enabled, fixed, formatter,
   *            headerShape, hideDelay, outside, padding, positioner,
   *            shadow, shape, shared, snap, split, stickOnContact,
   *            style, useHTML
   * @apioption plotOptions.series.tooltip
   */
  /**
   * When a series contains a `data` array that is longer than this, the
   * Series class looks for data configurations of plain numbers or arrays of
   * numbers. The first and last valid points are checked. If found, the rest
   * of the data is assumed to be the same. This saves expensive data checking
   * and indexing in long series, and makes data-heavy charts render faster.
   *
   * Set it to `0` disable.
   *
   * Note:
   * - In boost mode turbo threshold is forced. Only array of numbers or two
   *   dimensional arrays are allowed.
   * - In version 11.4.3 and earlier, if object configurations were passed
   *   beyond the turbo threshold, a warning was logged in the console and the
   *   data series didn't render.
   *
   * @since   2.2
   * @product highcharts highstock gantt
   *
   * @private
   */
  turboThreshold: 1e3,
  /**
   * An array defining zones within a series. Zones can be applied to the
   * X axis, Y axis or Z axis for bubbles, according to the `zoneAxis`
   * option. The zone definitions have to be in ascending order regarding
   * to the value.
   *
   * In styled mode, the color zones are styled with the
   * `.highcharts-zone-{n}` class, or custom classed from the `className`
   * option
   * ([view live demo](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/css/color-zones/)).
   *
   * @see [zoneAxis](#plotOptions.series.zoneAxis)
   *
   * @sample {highcharts} highcharts/series/color-zones-simple/
   *         Color zones
   * @sample {highstock} highcharts/series/color-zones-simple/
   *         Color zones
   *
   * @declare   Highcharts.SeriesZonesOptionsObject
   * @type      {Array<*>}
   * @since     4.1.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.zones
   */
  /**
   * Styled mode only. A custom class name for the zone.
   *
   * @sample highcharts/css/color-zones/
   *         Zones styled by class name
   *
   * @type      {string}
   * @since     5.0.0
   * @apioption plotOptions.series.zones.className
   */
  /**
   * Defines the color of the series.
   *
   * @see [series color](#plotOptions.series.color)
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @since     4.1.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.zones.color
   */
  /**
   * A name for the dash style to use for the graph.
   *
   * @see [plotOptions.series.dashStyle](#plotOptions.series.dashStyle)
   *
   * @sample {highcharts|highstock} highcharts/series/color-zones-dashstyle-dot/
   *         Dashed line indicates prognosis
   *
   * @type      {Highcharts.DashStyleValue}
   * @since     4.1.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.zones.dashStyle
   */
  /**
   * Defines the fill color for the series (in area type series)
   *
   * @see [fillColor](#plotOptions.area.fillColor)
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @since     4.1.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.zones.fillColor
   */
  /**
   * The value up to where the zone extends, if undefined the zones
   * stretches to the last value in the series.
   *
   * @type      {number}
   * @since     4.1.0
   * @product   highcharts highstock
   * @apioption plotOptions.series.zones.value
   */
  /**
   * When using dual or multiple color axes, this number defines which
   * colorAxis the particular series is connected to. It refers to
   * either the
   * {@link #colorAxis.id|axis id}
   * or the index of the axis in the colorAxis array, with 0 being the
   * first. Set this option to false to prevent a series from connecting
   * to the default color axis.
   *
   * Since v7.2.0 the option can also be an axis id or an axis index
   * instead of a boolean flag.
   *
   * @sample highcharts/coloraxis/coloraxis-with-pie/
   *         Color axis with pie series
   * @sample highcharts/coloraxis/multiple-coloraxis/
   *         Multiple color axis
   *
   * @type      {number|string|boolean}
   * @default   0
   * @product   highcharts highstock highmaps
   * @apioption plotOptions.series.colorAxis
   */
  /**
   * Determines what data value should be used to calculate point color
   * if `colorAxis` is used. Requires to set `min` and `max` if some
   * custom point property is used or if approximation for data grouping
   * is set to `'sum'`.
   *
   * @sample highcharts/coloraxis/custom-color-key/
   *         Custom color key
   * @sample highcharts/coloraxis/color-key-with-stops/
   *         Custom colorKey with color axis stops
   * @sample highcharts/coloraxis/changed-default-color-key/
   *         Changed default color key
   *
   * @type      {string}
   * @default   y
   * @since     7.2.0
   * @product   highcharts highstock highmaps
   * @apioption plotOptions.series.colorKey
   */
  /**
   * What type of legend symbol to render for this series. Can be one of
   * `areaMarker`, `lineMarker` or `rectangle`.
   *
   * @validvalue ["areaMarker", "lineMarker", "rectangle"]
   *
   * @sample {highcharts} highcharts/series/legend-symbol/
   *         Change the legend symbol
   *
   * @type      {string}
   * @default   rectangle
   * @since     11.0.1
   * @apioption plotOptions.series.legendSymbol
   */
  /**
   * Defines the color of the legend symbol for this series. Defaults to
   * undefined, in which case the series color is used. Does not work with
   * styled mode.
   *
   * @sample {highcharts|highstock} highcharts/series/legend-symbol-color/
   *         Change the legend symbol color
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @default   undefined
   * @since 12.0.0
   * @product   highcharts highstock highmaps
   * @apioption plotOptions.series.legendSymbolColor
   */
  /**
   * Determines whether the series should look for the nearest point
   * in both dimensions or just the x-dimension when hovering the series.
   * Defaults to `'xy'` for scatter series and `'x'` for most other
   * series. If the data has duplicate x-values, it is recommended to
   * set this to `'xy'` to allow hovering over all points.
   *
   * Applies only to series types using nearest neighbor search (not
   * direct hover) for tooltip.
   *
   * @sample {highcharts} highcharts/series/findnearestpointby/
   *         Different hover behaviors
   * @sample {highstock} highcharts/series/findnearestpointby/
   *         Different hover behaviors
   * @sample {highmaps} highcharts/series/findnearestpointby/
   *         Different hover behaviors
   *
   * @since      5.0.10
   * @validvalue ["x", "xy"]
   *
   * @private
   */
  findNearestPointBy: "x"
};
const { defaultOptions: defaultOptions$i } = DefaultOptions;
const { extend: extend$1e, extendClass, merge: merge$1w } = Utilities;
var SeriesRegistry;
(function(SeriesRegistry2) {
  SeriesRegistry2.seriesTypes = Highcharts.seriesTypes;
  function registerSeriesType(seriesType2, SeriesClass) {
    const defaultPlotOptions = defaultOptions$i.plotOptions || {}, seriesOptions = SeriesClass.defaultOptions, seriesProto2 = SeriesClass.prototype;
    seriesProto2.type = seriesType2;
    if (!seriesProto2.pointClass) {
      seriesProto2.pointClass = Point$3;
    }
    if (SeriesRegistry2.seriesTypes[seriesType2]) {
      return false;
    }
    if (seriesOptions) {
      defaultPlotOptions[seriesType2] = seriesOptions;
    }
    SeriesRegistry2.seriesTypes[seriesType2] = SeriesClass;
    return true;
  }
  SeriesRegistry2.registerSeriesType = registerSeriesType;
  function seriesType(type, parent, options2, seriesProto2, pointProto2) {
    const defaultPlotOptions = defaultOptions$i.plotOptions || {};
    parent = parent || "";
    defaultPlotOptions[type] = merge$1w(defaultPlotOptions[parent], options2);
    delete SeriesRegistry2.seriesTypes[type];
    registerSeriesType(type, extendClass(SeriesRegistry2.seriesTypes[parent] || function() {
    }, seriesProto2));
    SeriesRegistry2.seriesTypes[type].prototype.type = type;
    if (pointProto2) {
      class PointClass extends Point$3 {
      }
      extend$1e(PointClass.prototype, pointProto2);
      SeriesRegistry2.seriesTypes[type].prototype.pointClass = PointClass;
    }
    return SeriesRegistry2.seriesTypes[type];
  }
  SeriesRegistry2.seriesType = seriesType;
})(SeriesRegistry || (SeriesRegistry = {}));
const SeriesRegistry$1 = SeriesRegistry;
const { animObject: animObject$b, setAnimation: setAnimation$4 } = animationExports;
const { defaultOptions: defaultOptions$h } = DefaultOptions;
const { registerEventOptions: registerEventOptions$2 } = Foundation$1;
const { svg: svg$1, win: win$9 } = Highcharts;
const { seriesTypes: seriesTypes$5 } = SeriesRegistry$1;
const { format: format$e } = Templating;
const { arrayMax: arrayMax$8, arrayMin: arrayMin$6, clamp: clamp$j, correctFloat: correctFloat$d, crisp: crisp$c, defined: defined$14, destroyObjectProperties: destroyObjectProperties$6, diffObjects: diffObjects$4, erase: erase$6, error: error$7, extend: extend$1d, find: find$h, fireEvent: fireEvent$C, getClosestDistance, getNestedProperty: getNestedProperty$1, insertItem, isArray: isArray$k, isNumber: isNumber$Y, isString: isString$b, merge: merge$1v, objectEach: objectEach$m, pick: pick$1B, removeEvent: removeEvent$8, syncTimeout: syncTimeout$7 } = Utilities;
let Series$9 = class Series2 {
  constructor() {
    this.zoneAxis = "y";
  }
  /* *
   *
   *  Functions
   *
   * */
  /* eslint-disable valid-jsdoc */
  init(chart, userOptions) {
    fireEvent$C(this, "init", { options: userOptions });
    this.dataTable ?? (this.dataTable = new DataTableCore());
    const series = this, chartSeries = chart.series;
    this.eventsToUnbind = [];
    series.chart = chart;
    series.options = series.setOptions(userOptions);
    const options2 = series.options, visible = options2.visible !== false;
    series.linkedSeries = [];
    series.bindAxes();
    extend$1d(series, {
      /**
       * The series name as given in the options. Defaults to
       * "Series {n}".
       *
       * @name Highcharts.Series#name
       * @type {string}
       */
      name: options2.name,
      state: "",
      /**
       * Read only. The series' visibility state as set by {@link
       * Series#show}, {@link Series#hide}, or in the initial
       * configuration.
       *
       * @name Highcharts.Series#visible
       * @type {boolean}
       */
      visible,
      // True by default
      /**
       * Read only. The series' selected state as set by {@link
       * Highcharts.Series#select}.
       *
       * @name Highcharts.Series#selected
       * @type {boolean}
       */
      selected: options2.selected === true
      // False by default
    });
    registerEventOptions$2(this, options2);
    const events = options2.events;
    if (events?.click || options2.point?.events?.click || options2.allowPointSelect) {
      chart.runTrackerClick = true;
    }
    series.getColor();
    series.getSymbol();
    if (series.isCartesian) {
      chart.hasCartesianSeries = true;
    }
    let lastSeries;
    if (chartSeries.length) {
      lastSeries = chartSeries[chartSeries.length - 1];
    }
    series._i = pick$1B(lastSeries?._i, -1) + 1;
    series.opacity = series.options.opacity;
    chart.orderItems("series", insertItem(this, chartSeries));
    if (options2.dataSorting?.enabled) {
      series.setDataSortingOptions();
    } else if (!series.points && !series.data) {
      series.setData(options2.data, false);
    }
    fireEvent$C(this, "afterInit");
  }
  /**
   * Check whether the series item is itself or inherits from a certain
   * series type.
   *
   * @function Highcharts.Series#is
   * @param {string} type The type of series to check for, can be either
   *        featured or custom series types. For example `column`, `pie`,
   *        `ohlc` etc.
   *
   * @return {boolean}
   *        True if this item is or inherits from the given type.
   */
  is(type) {
    return seriesTypes$5[type] && this instanceof seriesTypes$5[type];
  }
  /**
   * Set the xAxis and yAxis properties of cartesian series, and register
   * the series in the `axis.series` array.
   *
   * @private
   * @function Highcharts.Series#bindAxes
   */
  bindAxes() {
    const series = this, seriesOptions = series.options, chart = series.chart;
    let axisOptions;
    fireEvent$C(this, "bindAxes", null, function() {
      (series.axisTypes || []).forEach(function(coll) {
        (chart[coll] || []).forEach(function(axis) {
          axisOptions = axis.options;
          if (pick$1B(seriesOptions[coll], 0) === axis.index || typeof seriesOptions[coll] !== "undefined" && seriesOptions[coll] === axisOptions.id) {
            insertItem(series, axis.series);
            series[coll] = axis;
            axis.isDirty = true;
          }
        });
        if (!series[coll] && series.optionalAxis !== coll) {
          error$7(18, true, chart);
        }
      });
    });
    fireEvent$C(this, "afterBindAxes");
  }
  /**
   * Define hasData functions for series. These return true if there
   * are data points on this series within the plot area.
   *
   * @private
   * @function Highcharts.Series#hasData
   */
  hasData() {
    return this.visible && typeof this.dataMax !== "undefined" && typeof this.dataMin !== "undefined" || // #3703
    this.visible && this.dataTable.rowCount > 0;
  }
  /**
   * Determine whether the marker in a series has changed.
   *
   * @private
   * @function Highcharts.Series#hasMarkerChanged
   */
  hasMarkerChanged(options2, oldOptions) {
    const marker = options2.marker, oldMarker = oldOptions.marker || {};
    return marker && (oldMarker.enabled && !marker.enabled || oldMarker.symbol !== marker.symbol || // #10870, #15946
    oldMarker.height !== marker.height || // #16274
    oldMarker.width !== marker.width);
  }
  /**
   * Return an auto incremented x value based on the pointStart and
   * pointInterval options. This is only used if an x value is not given
   * for the point that calls autoIncrement.
   *
   * @private
   * @function Highcharts.Series#autoIncrement
   */
  autoIncrement(x) {
    const options2 = this.options, { pointIntervalUnit, relativeXValue } = this.options, time = this.chart.time, xIncrement = this.xIncrement ?? time.parse(options2.pointStart) ?? 0;
    let pointInterval;
    this.pointInterval = pointInterval = pick$1B(this.pointInterval, options2.pointInterval, 1);
    if (relativeXValue && isNumber$Y(x)) {
      pointInterval *= x;
    }
    if (pointIntervalUnit) {
      const d = time.toParts(xIncrement);
      if (pointIntervalUnit === "day") {
        d[2] += pointInterval;
      } else if (pointIntervalUnit === "month") {
        d[1] += pointInterval;
      } else if (pointIntervalUnit === "year") {
        d[0] += pointInterval;
      }
      pointInterval = time.makeTime.apply(time, d) - xIncrement;
    }
    if (relativeXValue && isNumber$Y(x)) {
      return xIncrement + pointInterval;
    }
    this.xIncrement = xIncrement + pointInterval;
    return xIncrement;
  }
  /**
   * Internal function to set properties for series if data sorting is
   * enabled.
   *
   * @private
   * @function Highcharts.Series#setDataSortingOptions
   */
  setDataSortingOptions() {
    const options2 = this.options;
    extend$1d(this, {
      requireSorting: false,
      sorted: false,
      enabledDataSorting: true,
      allowDG: false
    });
    if (!defined$14(options2.pointRange)) {
      options2.pointRange = 1;
    }
  }
  /**
   * Set the series options by merging from the options tree. Called
   * internally on initializing and updating series. This function will
   * not redraw the series. For API usage, use {@link Series#update}.
   * @private
   * @function Highcharts.Series#setOptions
   * @param {Highcharts.SeriesOptionsType} itemOptions
   * The series options.
   * @emits Highcharts.Series#event:afterSetOptions
   */
  setOptions(itemOptions) {
    const chart = this.chart, chartOptions = chart.options, plotOptions = chartOptions.plotOptions, userOptions = chart.userOptions || {}, seriesUserOptions = merge$1v(itemOptions), styledMode = chart.styledMode, e = {
      plotOptions,
      userOptions: seriesUserOptions
    };
    let zone;
    fireEvent$C(this, "setOptions", e);
    const typeOptions = e.plotOptions[this.type], userPlotOptions = userOptions.plotOptions || {}, userPlotOptionsSeries = userPlotOptions.series || {}, defaultPlotOptionsType = defaultOptions$h.plotOptions[this.type] || {}, userPlotOptionsType = userPlotOptions[this.type] || {};
    typeOptions.dataLabels = this.mergeArrays(defaultPlotOptionsType.dataLabels, typeOptions.dataLabels);
    this.userOptions = e.userOptions;
    const options2 = merge$1v(
      typeOptions,
      plotOptions.series,
      // #3881, chart instance plotOptions[type] should trump
      // plotOptions.series
      userPlotOptionsType,
      seriesUserOptions
    );
    this.tooltipOptions = merge$1v(
      defaultOptions$h.tooltip,
      // 1
      defaultOptions$h.plotOptions.series?.tooltip,
      // 2
      defaultPlotOptionsType?.tooltip,
      // 3
      chart.userOptions.tooltip,
      // 4
      userPlotOptions.series?.tooltip,
      // 5
      userPlotOptionsType.tooltip,
      // 6
      seriesUserOptions.tooltip
      // 7
    );
    this.stickyTracking = pick$1B(seriesUserOptions.stickyTracking, userPlotOptionsType.stickyTracking, userPlotOptionsSeries.stickyTracking, this.tooltipOptions.shared && !this.noSharedTooltip ? true : options2.stickyTracking);
    if (typeOptions.marker === null) {
      delete options2.marker;
    }
    this.zoneAxis = options2.zoneAxis || "y";
    const zones = this.zones = // #20440, create deep copy of zones options
    (options2.zones || []).map((z) => ({ ...z }));
    if ((options2.negativeColor || options2.negativeFillColor) && !options2.zones) {
      zone = {
        value: options2[this.zoneAxis + "Threshold"] || options2.threshold || 0,
        className: "highcharts-negative"
      };
      if (!styledMode) {
        zone.color = options2.negativeColor;
        zone.fillColor = options2.negativeFillColor;
      }
      zones.push(zone);
    }
    if (zones.length && defined$14(zones[zones.length - 1].value)) {
      zones.push(styledMode ? {} : {
        color: this.color,
        fillColor: this.fillColor
      });
    }
    fireEvent$C(this, "afterSetOptions", { options: options2 });
    return options2;
  }
  /**
   * Return series name in "Series {Number}" format or the one defined by
   * a user. This method can be simply overridden as series name format
   * can vary (e.g. technical indicators).
   *
   * @function Highcharts.Series#getName
   *
   * @return {string}
   * The series name.
   */
  getName() {
    return this.options.name ?? format$e(this.chart.options.lang.seriesName, this, this.chart);
  }
  /**
   * @private
   * @function Highcharts.Series#getCyclic
   */
  getCyclic(prop, value, defaults2) {
    const chart = this.chart, indexName = `${prop}Index`, counterName = `${prop}Counter`, len = (
      // Symbol count
      defaults2?.length || // Color count
      chart.options.chart.colorCount
    );
    let i2, setting;
    if (!value) {
      setting = pick$1B(prop === "color" ? this.options.colorIndex : void 0, this[indexName]);
      if (defined$14(setting)) {
        i2 = setting;
      } else {
        if (!chart.series.length) {
          chart[counterName] = 0;
        }
        i2 = chart[counterName] % len;
        chart[counterName] += 1;
      }
      if (defaults2) {
        value = defaults2[i2];
      }
    }
    if (typeof i2 !== "undefined") {
      this[indexName] = i2;
    }
    this[prop] = value;
  }
  /**
   * Get the series' color based on either the options or pulled from
   * global options.
   *
   * @private
   * @function Highcharts.Series#getColor
   */
  getColor() {
    if (this.chart.styledMode) {
      this.getCyclic("color");
    } else if (this.options.colorByPoint) {
      this.color = "#cccccc";
    } else {
      this.getCyclic("color", this.options.color || defaultOptions$h.plotOptions[this.type].color, this.chart.options.colors);
    }
  }
  /**
   * Get all points' instances created for this series.
   *
   * @private
   * @function Highcharts.Series#getPointsCollection
   */
  getPointsCollection() {
    return (this.hasGroupedData ? this.points : this.data) || [];
  }
  /**
   * Get the series' symbol based on either the options or pulled from
   * global options.
   *
   * @private
   * @function Highcharts.Series#getSymbol
   */
  getSymbol() {
    const seriesMarkerOption = this.options.marker;
    this.getCyclic("symbol", seriesMarkerOption.symbol, this.chart.options.symbols);
  }
  /**
   * Shorthand to get one of the series' data columns from `Series.dataTable`.
   *
   * @private
   * @function Highcharts.Series#getColumn
   */
  getColumn(columnName, modified) {
    return (modified ? this.dataTable.modified : this.dataTable).getColumn(columnName, true) || [];
  }
  /**
   * Finds the index of an existing point that matches the given point
   * options.
   *
   * @private
   * @function Highcharts.Series#findPointIndex
   * @param {Highcharts.PointOptionsObject} optionsObject
   * The options of the point.
   * @param {number} fromIndex
   * The index to start searching from, used for optimizing series with
   * required sorting.
   * @return {number|undefined}
   * Returns the index of a matching point, or undefined if no match is found.
   */
  findPointIndex(optionsObject, fromIndex) {
    const { id, x } = optionsObject, oldData = this.points, dataSorting = this.options.dataSorting, cropStart = this.cropStart || 0;
    let matchingPoint, matchedById, pointIndex;
    if (id) {
      const item = this.chart.get(id);
      if (item instanceof Point$3) {
        matchingPoint = item;
      }
    } else if (this.linkedParent || this.enabledDataSorting || this.options.relativeXValue) {
      let matcher = (oldPoint) => !oldPoint.touched && oldPoint.index === optionsObject.index;
      if (dataSorting?.matchByName) {
        matcher = (oldPoint) => !oldPoint.touched && oldPoint.name === optionsObject.name;
      } else if (this.options.relativeXValue) {
        matcher = (oldPoint) => !oldPoint.touched && oldPoint.options.x === optionsObject.x;
      }
      matchingPoint = find$h(oldData, matcher);
      if (!matchingPoint) {
        return void 0;
      }
    }
    if (matchingPoint) {
      pointIndex = matchingPoint?.index;
      if (typeof pointIndex !== "undefined") {
        matchedById = true;
      }
    }
    if (typeof pointIndex === "undefined" && isNumber$Y(x)) {
      pointIndex = this.getColumn("x").indexOf(x, fromIndex);
    }
    if (pointIndex !== -1 && typeof pointIndex !== "undefined" && this.cropped) {
      pointIndex = pointIndex >= cropStart ? pointIndex - cropStart : pointIndex;
    }
    if (!matchedById && isNumber$Y(pointIndex) && oldData[pointIndex]?.touched) {
      pointIndex = void 0;
    }
    return pointIndex;
  }
  /**
   * Internal function called from setData. If the point count is the same
   * as it was, or if there are overlapping X values, just run
   * Point.update which is cheaper, allows animation, and keeps references
   * to points. This also allows adding or removing points if the X-es
   * don't match.
   *
   * @private
   * @function Highcharts.Series#updateData
   */
  updateData(data, animation) {
    const { options: options2, requireSorting } = this, dataSorting = options2.dataSorting, oldData = this.points, pointsToAdd = [], equalLength = data.length === oldData.length;
    let hasUpdatedByKey, i2, point, lastIndex, succeeded = true;
    this.xIncrement = null;
    data.forEach((pointOptions, i3) => {
      const optionsObject = defined$14(pointOptions) && this.pointClass.prototype.optionsToObject.call({ series: this }, pointOptions) || {}, { id, x } = optionsObject;
      let pointIndex;
      if (id || isNumber$Y(x)) {
        pointIndex = this.findPointIndex(optionsObject, lastIndex);
        if (pointIndex === -1 || typeof pointIndex === "undefined") {
          pointsToAdd.push(pointOptions);
        } else if (oldData[pointIndex] && pointOptions !== options2.data?.[pointIndex]) {
          oldData[pointIndex].update(pointOptions, false, void 0, false);
          oldData[pointIndex].touched = true;
          if (requireSorting) {
            lastIndex = pointIndex + 1;
          }
        } else if (oldData[pointIndex]) {
          oldData[pointIndex].touched = true;
        }
        if (!equalLength || i3 !== pointIndex || dataSorting?.enabled || this.hasDerivedData) {
          hasUpdatedByKey = true;
        }
      } else {
        pointsToAdd.push(pointOptions);
      }
    }, this);
    if (hasUpdatedByKey) {
      i2 = oldData.length;
      while (i2--) {
        point = oldData[i2];
        if (point && !point.touched) {
          point.remove?.(false, animation);
        }
      }
    } else if (equalLength && !dataSorting?.enabled) {
      data.forEach((point2, i3) => {
        if (point2 !== oldData[i3].y && !oldData[i3].destroyed) {
          oldData[i3].update(point2, false, void 0, false);
        }
      });
      pointsToAdd.length = 0;
    } else {
      succeeded = false;
    }
    oldData.forEach((point2) => {
      if (point2) {
        point2.touched = false;
      }
    });
    if (!succeeded) {
      return false;
    }
    pointsToAdd.forEach((point2) => {
      this.addPoint(point2, false, void 0, void 0, false);
    }, this);
    const xData = this.getColumn("x");
    if (this.xIncrement === null && xData.length) {
      this.xIncrement = arrayMax$8(xData);
      this.autoIncrement();
    }
    return true;
  }
  dataColumnKeys() {
    return ["x", ...this.pointArrayMap || ["y"]];
  }
  /**
   * Apply a new set of data to the series and optionally redraw it. The
   * new data array is passed by reference (except in case of
   * `updatePoints`), and may later be mutated when updating the chart
   * data.
   *
   * Note the difference in behaviour when setting the same amount of
   * points, or a different amount of points, as handled by the
   * `updatePoints` parameter.
   *
   * @sample highcharts/members/series-setdata/
   *         Set new data from a button
   * @sample highcharts/members/series-setdata-pie/
   *         Set data in a pie
   * @sample stock/members/series-setdata/
   *         Set new data in Highcharts Stock
   * @sample maps/members/series-setdata/
   *         Set new data in Highmaps
   *
   * @function Highcharts.Series#setData
   *
   * @param {Array<Highcharts.PointOptionsType>} data
   *        Takes an array of data in the same format as described under
   *        `series.{type}.data` for the given series type, for example a
   *        line series would take data in the form described under
   *        [series.line.data](https://api.highcharts.com/highcharts/series.line.data).
   *
   * @param {boolean} [redraw=true]
   *        Whether to redraw the chart after the series is altered. If
   *        doing more operations on the chart, it is a good idea to set
   *        redraw to false and call {@link Chart#redraw} after.
   *
   * @param {boolean|Partial<Highcharts.AnimationOptionsObject>} [animation]
   *        When the updated data is the same length as the existing data,
   *        points will be updated by default, and animation visualizes
   *        how the points are changed. Set false to disable animation, or
   *        a configuration object to set duration or easing.
   *
   * @param {boolean} [updatePoints=true]
   *        When this is true, points will be updated instead of replaced
   *        whenever possible. This occurs a) when the updated data is the
   *        same length as the existing data, b) when points are matched
   *        by their id's, or c) when points can be matched by X values.
   *        This allows updating with animation and performs better. In
   *        this case, the original array is not passed by reference. Set
   *        `false` to prevent.
   */
  setData(data, redraw = true, animation, updatePoints2) {
    const series = this, oldData = series.points, oldDataLength = oldData?.length || 0, options2 = series.options, chart = series.chart, dataSorting = options2.dataSorting, xAxis2 = series.xAxis, turboThreshold = options2.turboThreshold, table = this.dataTable, dataColumnKeys = this.dataColumnKeys(), pointValKey = series.pointValKey || "y", pointArrayMap = series.pointArrayMap || [], valueCount = pointArrayMap.length, keys = options2.keys;
    let i2, updatedData, indexOfX = 0, indexOfY = 1, copiedData;
    if (!chart.options.chart.allowMutatingData) {
      if (options2.data) {
        delete series.options.data;
      }
      if (series.userOptions.data) {
        delete series.userOptions.data;
      }
      copiedData = merge$1v(true, data);
    }
    data = copiedData || data || [];
    const dataLength = data.length;
    if (dataSorting?.enabled) {
      data = this.sortData(data);
    }
    if (chart.options.chart.allowMutatingData && updatePoints2 !== false && dataLength && oldDataLength && !series.cropped && !series.hasGroupedData && series.visible && // Soft updating has no benefit in boost, and causes JS error
    // (#8355)
    !series.boosted) {
      updatedData = this.updateData(data, animation);
    }
    if (!updatedData) {
      series.xIncrement = null;
      series.colorCounter = 0;
      let runTurbo = turboThreshold && dataLength > turboThreshold;
      if (runTurbo) {
        const firstPoint = series.getFirstValidPoint(data), lastPoint = series.getFirstValidPoint(data, dataLength - 1, -1), isShortArray = (a) => Boolean(isArray$k(a) && (keys || isNumber$Y(a[0])));
        if (isNumber$Y(firstPoint) && isNumber$Y(lastPoint)) {
          const x = [], valueData = [];
          for (const value of data) {
            x.push(this.autoIncrement());
            valueData.push(value);
          }
          table.setColumns({
            x,
            [pointValKey]: valueData
          });
        } else if (isShortArray(firstPoint) && isShortArray(lastPoint)) {
          if (valueCount) {
            const autoX = firstPoint.length === valueCount ? 1 : 0, colArray = new Array(dataColumnKeys.length).fill(0).map(() => []);
            for (const pt of data) {
              if (autoX) {
                colArray[0].push(this.autoIncrement());
              }
              for (let j = autoX; j <= valueCount; j++) {
                colArray[j]?.push(pt[j - autoX]);
              }
            }
            table.setColumns(dataColumnKeys.reduce((columns, columnName, i3) => {
              columns[columnName] = colArray[i3];
              return columns;
            }, {}));
          } else {
            if (keys) {
              indexOfX = keys.indexOf("x");
              indexOfY = keys.indexOf("y");
              indexOfX = indexOfX >= 0 ? indexOfX : 0;
              indexOfY = indexOfY >= 0 ? indexOfY : 1;
            }
            if (firstPoint.length === 1) {
              indexOfY = 0;
            }
            const xData = [], valueData = [];
            if (indexOfX === indexOfY) {
              for (const pt of data) {
                xData.push(this.autoIncrement());
                valueData.push(pt[indexOfY]);
              }
            } else {
              for (const pt of data) {
                xData.push(pt[indexOfX]);
                valueData.push(pt[indexOfY]);
              }
            }
            table.setColumns({
              x: xData,
              [pointValKey]: valueData
            });
          }
        } else {
          runTurbo = false;
        }
      }
      if (!runTurbo) {
        const columns = dataColumnKeys.reduce((columns2, columnName) => {
          columns2[columnName] = [];
          return columns2;
        }, {});
        for (i2 = 0; i2 < dataLength; i2++) {
          const pt = series.pointClass.prototype.applyOptions.apply({ series }, [data[i2]]);
          for (const key2 of dataColumnKeys) {
            columns[key2][i2] = pt[key2];
          }
        }
        table.setColumns(columns);
      }
      if (isString$b(this.getColumn("y")[0])) {
        error$7(14, true, chart);
      }
      series.data = [];
      series.options.data = series.userOptions.data = data;
      i2 = oldDataLength;
      while (i2--) {
        oldData[i2]?.destroy();
      }
      if (xAxis2) {
        xAxis2.minRange = xAxis2.userMinRange;
      }
      series.isDirty = chart.isDirtyBox = true;
      series.isDirtyData = !!oldData;
      animation = false;
    }
    if (options2.legendType === "point") {
      this.processData();
      this.generatePoints();
    }
    if (redraw) {
      chart.redraw(animation);
    }
  }
  /**
   * Internal function to sort series data
   *
   * @private
   * @function Highcharts.Series#sortData
   * @param {Array<Highcharts.PointOptionsType>} data
   * Force data grouping.
   */
  sortData(data) {
    const series = this, options2 = series.options, dataSorting = options2.dataSorting, sortKey = dataSorting.sortKey || "y", getPointOptionsObject = function(series2, pointOptions) {
      return defined$14(pointOptions) && series2.pointClass.prototype.optionsToObject.call({
        series: series2
      }, pointOptions) || {};
    };
    data.forEach(function(pointOptions, i2) {
      data[i2] = getPointOptionsObject(series, pointOptions);
      data[i2].index = i2;
    }, this);
    const sortedData = data.concat().sort((a, b) => {
      const aValue = getNestedProperty$1(sortKey, a);
      const bValue = getNestedProperty$1(sortKey, b);
      return bValue < aValue ? -1 : bValue > aValue ? 1 : 0;
    });
    sortedData.forEach(function(point, i2) {
      point.x = i2;
    }, this);
    if (series.linkedSeries) {
      series.linkedSeries.forEach(function(linkedSeries) {
        const options3 = linkedSeries.options, seriesData = options3.data;
        if (!options3.dataSorting?.enabled && seriesData) {
          seriesData.forEach(function(pointOptions, i2) {
            seriesData[i2] = getPointOptionsObject(linkedSeries, pointOptions);
            if (data[i2]) {
              seriesData[i2].x = data[i2].x;
              seriesData[i2].index = i2;
            }
          });
          linkedSeries.setData(seriesData, false);
        }
      });
    }
    return data;
  }
  /**
   * Internal function to process the data by cropping away unused data
   * points if the series is longer than the crop threshold. This saves
   * computing time for large series.
   *
   * @private
   * @function Highcharts.Series#getProcessedData
   * @param {boolean} [forceExtremesFromAll]
   * Force getting extremes of a total series data range.
   */
  getProcessedData(forceExtremesFromAll) {
    const series = this, { dataTable: table, isCartesian, options: options2, xAxis: xAxis2 } = series, cropThreshold = options2.cropThreshold, getExtremesFromAll = forceExtremesFromAll || // X-range series etc, #21003
    series.getExtremesFromAll, logarithmic = xAxis2?.logarithmic, dataLength = table.rowCount;
    let croppedData, cropped, cropStart = 0, xExtremes, min2, max2, xData = series.getColumn("x"), modified = table, updatingNames = false;
    if (xAxis2) {
      xExtremes = xAxis2.getExtremes();
      min2 = xExtremes.min;
      max2 = xExtremes.max;
      updatingNames = !!(xAxis2.categories && !xAxis2.names.length);
      if (isCartesian && series.sorted && !getExtremesFromAll && (!cropThreshold || dataLength > cropThreshold || series.forceCrop)) {
        if (xData[dataLength - 1] < min2 || xData[0] > max2) {
          modified = new DataTableCore();
        } else if (
          // Don't understand why this condition is needed
          series.getColumn(series.pointValKey || "y").length && (xData[0] < min2 || xData[dataLength - 1] > max2)
        ) {
          croppedData = this.cropData(table, min2, max2);
          modified = croppedData.modified;
          cropStart = croppedData.start;
          cropped = true;
        }
      }
    }
    xData = modified.getColumn("x") || [];
    const closestPointRange = getClosestDistance(
      [
        logarithmic ? xData.map(logarithmic.log2lin) : xData
      ],
      // Unsorted data is not supported by the line tooltip, as well as
      // data grouping and navigation in Stock charts (#725) and width
      // calculation of columns (#1900). Avoid warning during the
      // premature processing pass in updateNames (#16104).
      () => series.requireSorting && !updatingNames && error$7(15, false, series.chart)
    );
    return {
      modified,
      cropped,
      cropStart,
      closestPointRange
    };
  }
  /**
   * Internal function to apply processed data.
   * In Highcharts Stock, this function is extended to provide data grouping.
   *
   * @private
   * @function Highcharts.Series#processData
   * @param {boolean} [force]
   * Force data grouping.
   */
  processData(force) {
    const series = this, xAxis2 = series.xAxis, table = series.dataTable;
    if (series.isCartesian && !series.isDirty && !xAxis2.isDirty && !series.yAxis.isDirty && !force) {
      return false;
    }
    const processedData = series.getProcessedData();
    table.modified = processedData.modified;
    series.cropped = processedData.cropped;
    series.cropStart = processedData.cropStart;
    series.closestPointRange = series.basePointRange = processedData.closestPointRange;
    fireEvent$C(series, "afterProcessData");
  }
  /**
   * Iterate over xData and crop values between min and max. Returns
   * object containing crop start/end cropped xData with corresponding
   * part of yData, dataMin and dataMax within the cropped range.
   *
   * @private
   * @function Highcharts.Series#cropData
   */
  cropData(table, min2, max2) {
    const xData = table.getColumn("x", true) || [], dataLength = xData.length, columns = {};
    let i2, j, start2 = 0, end = dataLength;
    for (i2 = 0; i2 < dataLength; i2++) {
      if (xData[i2] >= min2) {
        start2 = Math.max(0, i2 - 1);
        break;
      }
    }
    for (j = i2; j < dataLength; j++) {
      if (xData[j] > max2) {
        end = j + 1;
        break;
      }
    }
    for (const key2 of this.dataColumnKeys()) {
      const column2 = table.getColumn(key2, true);
      if (column2) {
        columns[key2] = column2.slice(start2, end);
      }
    }
    return {
      modified: new DataTableCore({ columns }),
      start: start2,
      end
    };
  }
  /**
   * Generate the data point after the data has been processed by cropping
   * away unused points and optionally grouped in Highcharts Stock.
   *
   * @private
   * @function Highcharts.Series#generatePoints
   */
  generatePoints() {
    const series = this, options2 = series.options, dataOptions = series.processedData || options2.data, table = series.dataTable.modified, xData = series.getColumn("x", true), PointClass = series.pointClass, processedDataLength = table.rowCount, cropStart = series.cropStart || 0, hasGroupedData = series.hasGroupedData, keys = options2.keys, points = [], groupCropStartIndex = options2.dataGrouping?.groupAll ? cropStart : 0, categories = series.xAxis?.categories, pointArrayMap = series.pointArrayMap || ["y"], dataColumnKeys = this.dataColumnKeys();
    let dataLength, cursor, point, i2, data = series.data, pOptions;
    if (!data && !hasGroupedData) {
      const arr = [];
      arr.length = dataOptions?.length || 0;
      data = series.data = arr;
    }
    if (keys && hasGroupedData) {
      series.options.keys = false;
    }
    for (i2 = 0; i2 < processedDataLength; i2++) {
      cursor = cropStart + i2;
      if (!hasGroupedData) {
        point = data[cursor];
        pOptions = dataOptions ? dataOptions[cursor] : table.getRow(i2, pointArrayMap);
        if (!point && pOptions !== void 0) {
          data[cursor] = point = new PointClass(series, pOptions, xData[i2]);
        }
      } else {
        point