import { av as css$e, aw as addGlobalThemeStyles, ax as ThemableMixin, ay as DirMixin, az as PolylitMixin, aA as LumoInjectionMixin, aB as LitElement, aC as html$3, aD as defineCustomElement, aE as overlayStyles$1, aF as PositionMixin, aG as OverlayMixin, aH as Debouncer, aI as timeOut, aJ as isKeyboardActive, aK as announce, aL as detailsSummary, aM as ActiveMixin, aN as CollapsibleMixin, aO as DelegateFocusMixin, aP as DelegateStateMixin, aQ as SummaryController, aR as TooltipController, aS as KeyboardDirectionMixin, aT as isElementFocused, aU as SlotObserver, aV as ElementMixin, aW as isIOS, aX as I18nMixin, aY as FocusTrapController, aZ as animationFrame, a_ as ButtonMixin, a$ as buttonStyles, b0 as isEmptyTextNode, b1 as PopoverOverlayMixin, b2 as PopoverPositionMixin, b3 as PopoverTargetMixin, b4 as generateUniqueId, b5 as SlotController, b6 as removeValueFromAttribute, b7 as addValueToAttribute, b8 as ThemePropertyMixin, b9 as ifDefined, ba as FocusMixin, bb as ListMixin, bc as itemStyles, bd as ItemMixin, be as ResizeMixin, bf as render$1, bg as isElementHidden, bh as unsafeCSS, bi as get$5, bj as field, bk as group, bl as FieldMixin, bm as DisabledMixin, bn as Directive, bo as isSingleExpression, bp as PartType, bq as directive, br as noChange, bs as ComboBoxPlaceholder, bt as dialogOverlayBase, bu as DialogSizeMixin, bv as setAriaIDReference, bw as gestures, bx as removeListener, by as addListener, bz as dialogOverlayStyles, bA as DialogBaseMixin, bB as ColumnBaseMixin, bC as updateColumnOrders, bD as ColumnObserver, bE as Button, bF as set, bG as GridColumn, bH as gridStyles, bI as Grid, bJ as SlotStylesMixin, bK as FocusRestorationController, bL as MediaQueryController, bM as nothing, bN as isFocusable, bO as container, bP as KeyboardMixin, bQ as getFlattenedElements, bR as setTouchAction, bS as isElementFocusable, bT as InputConstraintsMixin, bU as VirtualKeyboardController, bV as InputControlMixin, bW as inputFieldShared, bX as InputController, bY as LabelledInputController, bZ as ComboBoxItemMixin, b_ as ComboBoxOverlayMixin, b$ as ComboBoxScrollerMixin, c0 as comboBoxScrollerStyles, c1 as PatternMixin, c2 as ComboBoxBaseMixin, c3 as iterateRowCells, c4 as updatePart, c5 as Checkbox, c6 as Select, c7 as TextField, c8 as getDeepActiveElement, c9 as InputMixin, ca as SlotChildObserveController, cb as getFocusableElements, cc as __vitePreload, cd as isTemplateResult, ce as Popover, cf as reactExports, cg as clientExports, ch as jsxDEV, ci as Outlet, cj as InputFieldMixin, ck as setCommittedValue, cl as isTouch, cm as Virtualizer, cn as OverflowController, co as isChrome, cp as isSafari, cq as Iconset, cr as injectGlobalCss } from "./indexhtml-BJ8ZM_Ro.js";
const $cssFromFile_0 = css$e`/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/* Reset properties that are set by the base theme */
:where(:root, :host) {
  --vaadin-focus-ring-color: inherit;
  --vaadin-focus-ring-width: inherit;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@font-face {
  font-family: 'lumo-icons';
  src: url(data:application/font-woff;charset=utf-8;base64,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)
    format('woff');
  font-weight: normal;
  font-style: normal;
}
:where(:root, :host) {
  --lumo-icons-align-center: '\\ea01';
  --lumo-icons-align-left: '\\ea02';
  --lumo-icons-align-right: '\\ea03';
  --lumo-icons-angle-down: '\\ea04';
  --lumo-icons-angle-left: '\\ea05';
  --lumo-icons-angle-right: '\\ea06';
  --lumo-icons-angle-up: '\\ea07';
  --lumo-icons-arrow-down: '\\ea08';
  --lumo-icons-arrow-left: '\\ea09';
  --lumo-icons-arrow-right: '\\ea0a';
  --lumo-icons-arrow-up: '\\ea0b';
  --lumo-icons-bar-chart: '\\ea0c';
  --lumo-icons-bell: '\\ea0d';
  --lumo-icons-calendar: '\\ea0e';
  --lumo-icons-checkmark: '\\ea0f';
  --lumo-icons-chevron-down: '\\ea10';
  --lumo-icons-chevron-left: '\\ea11';
  --lumo-icons-chevron-right: '\\ea12';
  --lumo-icons-chevron-up: '\\ea13';
  --lumo-icons-clean: '\\ea14';
  --lumo-icons-clock: '\\ea15';
  --lumo-icons-cog: '\\ea16';
  --lumo-icons-cross: '\\ea17';
  --lumo-icons-download: '\\ea18';
  --lumo-icons-drag-handle: '\\ea19';
  --lumo-icons-dropdown: '\\ea1a';
  --lumo-icons-edit: '\\ea1b';
  --lumo-icons-error: '\\ea1c';
  --lumo-icons-eye: '\\ea1d';
  --lumo-icons-eye-disabled: '\\ea1e';
  --lumo-icons-indent: '\\ea1f';
  --lumo-icons-link: '\\ea20';
  --lumo-icons-menu: '\\ea21';
  --lumo-icons-minus: '\\ea22';
  --lumo-icons-ordered-list: '\\ea23';
  --lumo-icons-outdent: '\\ea24';
  --lumo-icons-phone: '\\ea25';
  --lumo-icons-photo: '\\ea26';
  --lumo-icons-play: '\\ea27';
  --lumo-icons-plus: '\\ea28';
  --lumo-icons-redo: '\\ea29';
  --lumo-icons-reload: '\\ea2a';
  --lumo-icons-resize-handle: '\\ea2b';
  --lumo-icons-search: '\\ea2c';
  --lumo-icons-undo: '\\ea2d';
  --lumo-icons-unordered-list: '\\ea2e';
  --lumo-icons-upload: '\\ea2f';
  --lumo-icons-user: '\\ea30';
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(:root, :host) {
  /* Border radius */
  --lumo-border-radius-s: 0.25em; /* Checkbox, badge, date-picker year indicator, etc */
  --lumo-border-radius-m: var(--lumo-border-radius, 0.25em); /* Button, text field, menu overlay, etc */
  --lumo-border-radius-l: 0.5em; /* Dialog, notification, etc */

  /* Shadow */
  --lumo-box-shadow-xs: 0 1px 4px -1px var(--lumo-shade-50pct);
  --lumo-box-shadow-s: 0 2px 4px -1px var(--lumo-shade-20pct), 0 3px 12px -1px var(--lumo-shade-30pct);
  --lumo-box-shadow-m: 0 2px 6px -1px var(--lumo-shade-20pct), 0 8px 24px -4px var(--lumo-shade-40pct);
  --lumo-box-shadow-l: 0 3px 18px -2px var(--lumo-shade-20pct), 0 12px 48px -6px var(--lumo-shade-40pct);
  --lumo-box-shadow-xl: 0 4px 24px -3px var(--lumo-shade-20pct), 0 18px 64px -8px var(--lumo-shade-40pct);

  /* Clickable element cursor */
  --lumo-clickable-cursor: default;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(:root, :host) {
  /* Base (background) */
  --lumo-base-color: #fff;

  /* Tint */
  --lumo-tint-5pct: hsla(0, 0%, 100%, 0.3);
  --lumo-tint-10pct: hsla(0, 0%, 100%, 0.37);
  --lumo-tint-20pct: hsla(0, 0%, 100%, 0.44);
  --lumo-tint-30pct: hsla(0, 0%, 100%, 0.5);
  --lumo-tint-40pct: hsla(0, 0%, 100%, 0.57);
  --lumo-tint-50pct: hsla(0, 0%, 100%, 0.64);
  --lumo-tint-60pct: hsla(0, 0%, 100%, 0.7);
  --lumo-tint-70pct: hsla(0, 0%, 100%, 0.77);
  --lumo-tint-80pct: hsla(0, 0%, 100%, 0.84);
  --lumo-tint-90pct: hsla(0, 0%, 100%, 0.9);
  --lumo-tint: #fff;

  /* Shade */
  --lumo-shade-5pct: hsla(214, 61%, 25%, 0.05);
  --lumo-shade-10pct: hsla(214, 57%, 24%, 0.1);
  --lumo-shade-20pct: hsla(214, 53%, 23%, 0.16);
  --lumo-shade-30pct: hsla(214, 50%, 22%, 0.26);
  --lumo-shade-40pct: hsla(214, 47%, 21%, 0.38);
  --lumo-shade-50pct: hsla(214, 45%, 20%, 0.52);
  --lumo-shade-60pct: hsla(214, 43%, 19%, 0.6);
  --lumo-shade-70pct: hsla(214, 42%, 18%, 0.69);
  --lumo-shade-80pct: hsla(214, 41%, 17%, 0.83);
  --lumo-shade-90pct: hsla(214, 40%, 16%, 0.94);
  --lumo-shade: hsl(214, 35%, 15%);

  /* Contrast */
  --lumo-contrast-5pct: var(--lumo-shade-5pct);
  --lumo-contrast-10pct: var(--lumo-shade-10pct);
  --lumo-contrast-20pct: var(--lumo-shade-20pct);
  --lumo-contrast-30pct: var(--lumo-shade-30pct);
  --lumo-contrast-40pct: var(--lumo-shade-40pct);
  --lumo-contrast-50pct: var(--lumo-shade-50pct);
  --lumo-contrast-60pct: var(--lumo-shade-60pct);
  --lumo-contrast-70pct: var(--lumo-shade-70pct);
  --lumo-contrast-80pct: var(--lumo-shade-80pct);
  --lumo-contrast-90pct: var(--lumo-shade-90pct);
  --lumo-contrast: var(--lumo-shade);

  /* Text */
  --lumo-header-text-color: var(--lumo-contrast);
  --lumo-body-text-color: var(--lumo-contrast-90pct);
  --lumo-secondary-text-color: var(--lumo-contrast-70pct);
  --lumo-tertiary-text-color: var(--lumo-contrast-50pct);
  --lumo-disabled-text-color: var(--lumo-contrast-30pct);

  /* Primary */
  --lumo-primary-color: hsl(214, 100%, 48%);
  --lumo-primary-color-50pct: hsla(214, 100%, 49%, 0.76);
  --lumo-primary-color-10pct: hsla(214, 100%, 60%, 0.13);
  --lumo-primary-text-color: hsl(214, 100%, 43%);
  --lumo-primary-contrast-color: #fff;

  /* Error */
  --lumo-error-color: hsl(3, 85%, 48%);
  --lumo-error-color-50pct: hsla(3, 85%, 49%, 0.5);
  --lumo-error-color-10pct: hsla(3, 85%, 49%, 0.1);
  --lumo-error-text-color: hsl(3, 89%, 42%);
  --lumo-error-contrast-color: #fff;

  /* Success */
  --lumo-success-color: hsl(145, 72%, 30%);
  --lumo-success-color-50pct: hsla(145, 72%, 31%, 0.5);
  --lumo-success-color-10pct: hsla(145, 72%, 31%, 0.1);
  --lumo-success-text-color: hsl(145, 85%, 25%);
  --lumo-success-contrast-color: #fff;

  /* Warning */
  --lumo-warning-color: hsl(48, 100%, 50%);
  --lumo-warning-color-10pct: hsla(48, 100%, 50%, 0.25);
  --lumo-warning-text-color: hsl(32, 100%, 30%);
  --lumo-warning-contrast-color: var(--lumo-shade-90pct);

  /* User colors */
  --vaadin-user-color-0: #df0b92;
  --vaadin-user-color-1: #650acc;
  --vaadin-user-color-2: #097faa;
  --vaadin-user-color-3: #ad6200;
  --vaadin-user-color-4: #bf16f3;
  --vaadin-user-color-5: #084391;
  --vaadin-user-color-6: #078836;
}
/* forced-colors mode adjustments */
@media (forced-colors: active) {
  :where(:root, :host) {
    --lumo-disabled-text-color: GrayText;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(:root, :host) {
  --lumo-size-xs: 1.625rem;
  --lumo-size-s: 1.875rem;
  --lumo-size-m: 2.25rem;
  --lumo-size-l: 2.75rem;
  --lumo-size-xl: 3.5rem;

  /* Icons */
  --lumo-icon-size-s: 1.25em;
  --lumo-icon-size-m: 1.5em;
  --lumo-icon-size-l: 2.25em;
  /* For backwards compatibility */
  --lumo-icon-size: var(--lumo-icon-size-m);
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(:root, :host) {
  /* Square */
  --lumo-space-xs: 0.25rem;
  --lumo-space-s: 0.5rem;
  --lumo-space-m: 1rem;
  --lumo-space-l: 1.5rem;
  --lumo-space-xl: 2.5rem;

  /* Wide */
  --lumo-space-wide-xs: calc(var(--lumo-space-xs) / 2) var(--lumo-space-xs);
  --lumo-space-wide-s: calc(var(--lumo-space-s) / 2) var(--lumo-space-s);
  --lumo-space-wide-m: calc(var(--lumo-space-m) / 2) var(--lumo-space-m);
  --lumo-space-wide-l: calc(var(--lumo-space-l) / 2) var(--lumo-space-l);
  --lumo-space-wide-xl: calc(var(--lumo-space-xl) / 2) var(--lumo-space-xl);

  /* Tall */
  --lumo-space-tall-xs: var(--lumo-space-xs) calc(var(--lumo-space-xs) / 2);
  --lumo-space-tall-s: var(--lumo-space-s) calc(var(--lumo-space-s) / 2);
  --lumo-space-tall-m: var(--lumo-space-m) calc(var(--lumo-space-m) / 2);
  --lumo-space-tall-l: var(--lumo-space-l) calc(var(--lumo-space-l) / 2);
  --lumo-space-tall-xl: var(--lumo-space-xl) calc(var(--lumo-space-xl) / 2);
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(:root, :host) {
  /* prettier-ignore */
  --lumo-font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';

  /* Font sizes */
  --lumo-font-size-xxs: 0.75rem;
  --lumo-font-size-xs: 0.8125rem;
  --lumo-font-size-s: 0.875rem;
  --lumo-font-size-m: 1rem;
  --lumo-font-size-l: 1.125rem;
  --lumo-font-size-xl: 1.375rem;
  --lumo-font-size-xxl: 1.75rem;
  --lumo-font-size-xxxl: 2.5rem;

  /* Line heights */
  --lumo-line-height-xs: 1.25;
  --lumo-line-height-s: 1.375;
  --lumo-line-height-m: 1.625;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
[theme~='badge'] {
  display: inline-flex;
  align-items: center;
  justify-content: center;
  box-sizing: border-box;
  padding: 0.4em calc(0.5em + var(--lumo-border-radius-s) / 4);
  color: var(--lumo-primary-text-color);
  background-color: var(--lumo-primary-color-10pct);
  border-radius: var(--lumo-border-radius-s);
  font-family: var(--lumo-font-family);
  font-size: var(--lumo-font-size-s);
  line-height: 1;
  font-weight: 500;
  text-transform: initial;
  letter-spacing: initial;
  min-width: calc(var(--lumo-line-height-xs) * 1em + 0.45em);
  flex-shrink: 0;
}
/* Ensure proper vertical alignment */
[theme~='badge']::before {
  display: inline-block;
  content: '\\2003';
  width: 0;
}
[theme~='badge'][theme~='small'] {
  font-size: var(--lumo-font-size-xxs);
  line-height: 1;
}
/* Colors */
[theme~='badge'][theme~='success'] {
  color: var(--lumo-success-text-color);
  background-color: var(--lumo-success-color-10pct);
}
[theme~='badge'][theme~='error'] {
  color: var(--lumo-error-text-color);
  background-color: var(--lumo-error-color-10pct);
}
[theme~='badge'][theme~='warning'] {
  color: var(--lumo-warning-text-color);
  background-color: var(--lumo-warning-color-10pct);
}
[theme~='badge'][theme~='contrast'] {
  color: var(--lumo-contrast-80pct);
  background-color: var(--lumo-contrast-5pct);
}
/* Primary */
[theme~='badge'][theme~='primary'] {
  color: var(--lumo-primary-contrast-color);
  background-color: var(--lumo-primary-color);
}
[theme~='badge'][theme~='success'][theme~='primary'] {
  color: var(--lumo-success-contrast-color);
  background-color: var(--lumo-success-color);
}
[theme~='badge'][theme~='error'][theme~='primary'] {
  color: var(--lumo-error-contrast-color);
  background-color: var(--lumo-error-color);
}
[theme~='badge'][theme~='warning'][theme~='primary'] {
  color: var(--lumo-warning-contrast-color);
  background-color: var(--lumo-warning-color);
}
[theme~='badge'][theme~='contrast'][theme~='primary'] {
  color: var(--lumo-base-color);
  background-color: var(--lumo-contrast);
}
/* Links */
[theme~='badge'][href]:hover {
  text-decoration: none;
}
/* Icon */
[theme~='badge'] > vaadin-icon {
  margin: -0.25em 0;
}
[theme~='badge'] > vaadin-icon:first-child {
  margin-left: -0.375em;
}
[theme~='badge'] > vaadin-icon:last-child {
  margin-right: -0.375em;
}
vaadin-icon[theme~='badge'][icon] {
  min-width: 0;
  padding: 0;
  font-size: 1rem;
  width: var(--lumo-icon-size-m);
  height: var(--lumo-icon-size-m);
}
vaadin-icon[theme~='badge'][icon][theme~='small'] {
  width: var(--lumo-icon-size-s);
  height: var(--lumo-icon-size-s);
}
/* Empty */
[theme~='badge']:not([icon]):empty {
  min-width: 0;
  width: 1em;
  height: 1em;
  padding: 0;
  border-radius: 50%;
  background-color: var(--lumo-primary-color);
}
[theme~='badge'][theme~='small']:not([icon]):empty {
  width: 0.75em;
  height: 0.75em;
}
[theme~='badge'][theme~='contrast']:not([icon]):empty {
  background-color: var(--lumo-contrast);
}
[theme~='badge'][theme~='success']:not([icon]):empty {
  background-color: var(--lumo-success-color);
}
[theme~='badge'][theme~='error']:not([icon]):empty {
  background-color: var(--lumo-error-color);
}
[theme~='badge'][theme~='warning']:not([icon]):empty {
  background-color: var(--lumo-warning-color);
}
/* Pill */
[theme~='badge'][theme~='pill'] {
  --lumo-border-radius-s: 1em;
}
/* RTL specific styles */
[dir='rtl'][theme~='badge'] vaadin-icon:first-child {
  margin-right: -0.375em;
  margin-left: 0;
}
[dir='rtl'][theme~='badge'] vaadin-icon:last-child {
  margin-left: -0.375em;
  margin-right: 0;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(:root, :host) {
  color: var(--lumo-body-text-color);
  background-color: var(--lumo-base-color);
  color-scheme: light;
}
[theme~='dark'] {
  /* Base (background) */
  --lumo-base-color: hsl(214, 35%, 21%);

  /* Tint */
  --lumo-tint-5pct: hsla(214, 65%, 85%, 0.06);
  --lumo-tint-10pct: hsla(214, 60%, 80%, 0.14);
  --lumo-tint-20pct: hsla(214, 64%, 82%, 0.23);
  --lumo-tint-30pct: hsla(214, 69%, 84%, 0.32);
  --lumo-tint-40pct: hsla(214, 73%, 86%, 0.41);
  --lumo-tint-50pct: hsla(214, 78%, 88%, 0.5);
  --lumo-tint-60pct: hsla(214, 82%, 90%, 0.58);
  --lumo-tint-70pct: hsla(214, 87%, 92%, 0.69);
  --lumo-tint-80pct: hsla(214, 91%, 94%, 0.8);
  --lumo-tint-90pct: hsla(214, 96%, 96%, 0.9);
  --lumo-tint: hsl(214, 100%, 98%);

  /* Shade */
  --lumo-shade-5pct: hsla(214, 0%, 0%, 0.07);
  --lumo-shade-10pct: hsla(214, 4%, 2%, 0.15);
  --lumo-shade-20pct: hsla(214, 8%, 4%, 0.23);
  --lumo-shade-30pct: hsla(214, 12%, 6%, 0.32);
  --lumo-shade-40pct: hsla(214, 16%, 8%, 0.41);
  --lumo-shade-50pct: hsla(214, 20%, 10%, 0.5);
  --lumo-shade-60pct: hsla(214, 24%, 12%, 0.6);
  --lumo-shade-70pct: hsla(214, 28%, 13%, 0.7);
  --lumo-shade-80pct: hsla(214, 32%, 13%, 0.8);
  --lumo-shade-90pct: hsla(214, 33%, 13%, 0.9);
  --lumo-shade: hsl(214, 33%, 13%);

  /* Contrast */
  --lumo-contrast-5pct: var(--lumo-tint-5pct);
  --lumo-contrast-10pct: var(--lumo-tint-10pct);
  --lumo-contrast-20pct: var(--lumo-tint-20pct);
  --lumo-contrast-30pct: var(--lumo-tint-30pct);
  --lumo-contrast-40pct: var(--lumo-tint-40pct);
  --lumo-contrast-50pct: var(--lumo-tint-50pct);
  --lumo-contrast-60pct: var(--lumo-tint-60pct);
  --lumo-contrast-70pct: var(--lumo-tint-70pct);
  --lumo-contrast-80pct: var(--lumo-tint-80pct);
  --lumo-contrast-90pct: var(--lumo-tint-90pct);
  --lumo-contrast: var(--lumo-tint);

  /* Text */
  --lumo-header-text-color: var(--lumo-contrast);
  --lumo-body-text-color: var(--lumo-contrast-90pct);
  --lumo-secondary-text-color: var(--lumo-contrast-70pct);
  --lumo-tertiary-text-color: var(--lumo-contrast-50pct);
  --lumo-disabled-text-color: var(--lumo-contrast-30pct);

  /* Primary */
  --lumo-primary-color: hsl(214, 90%, 48%);
  --lumo-primary-color-50pct: hsla(214, 90%, 70%, 0.69);
  --lumo-primary-color-10pct: hsla(214, 90%, 55%, 0.13);
  --lumo-primary-text-color: hsl(214, 90%, 77%);
  --lumo-primary-contrast-color: #fff;

  /* Error */
  --lumo-error-color: hsl(3, 79%, 49%);
  --lumo-error-color-50pct: hsla(3, 75%, 62%, 0.5);
  --lumo-error-color-10pct: hsla(3, 75%, 62%, 0.14);
  --lumo-error-text-color: hsl(3, 100%, 80%);

  /* Success */
  --lumo-success-color: hsl(145, 72%, 30%);
  --lumo-success-color-50pct: hsla(145, 92%, 51%, 0.5);
  --lumo-success-color-10pct: hsla(145, 92%, 51%, 0.1);
  --lumo-success-text-color: hsl(145, 85%, 46%);

  /* Warning */
  --lumo-warning-color: hsl(43, 100%, 48%);
  --lumo-warning-color-10pct: hsla(40, 100%, 50%, 0.2);
  --lumo-warning-text-color: hsl(45, 100%, 60%);
  --lumo-warning-contrast-color: var(--lumo-shade-90pct);

  /* User colors */
  --vaadin-user-color-0: #ff66c7;
  --vaadin-user-color-1: #9d8aff;
  --vaadin-user-color-2: #8aff66;
  --vaadin-user-color-3: #ffbd66;
  --vaadin-user-color-4: #dc6bff;
  --vaadin-user-color-5: #66fffa;
  --vaadin-user-color-6: #e6ff66;

  color: var(--lumo-body-text-color);
  background-color: var(--lumo-base-color);
  color-scheme: dark;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(body, :host) {
  font-family: var(--lumo-font-family);
  font-size: var(--lumo-font-size-m);
  line-height: var(--lumo-line-height-m);
  -webkit-text-size-adjust: 100%;
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
}
small,
[theme~='font-size-s'] {
  font-size: var(--lumo-font-size-s);
  line-height: var(--lumo-line-height-s);
}
[theme~='font-size-xs'] {
  font-size: var(--lumo-font-size-xs);
  line-height: var(--lumo-line-height-xs);
}
:where(h1, h2, h3, h4, h5, h6) {
  font-weight: 600;
  line-height: var(--lumo-line-height-xs);
  color: var(--lumo-header-text-color);
  margin-block: 0;
}
:where(h1) {
  font-size: var(--lumo-font-size-xxxl);
}
:where(h2) {
  font-size: var(--lumo-font-size-xxl);
}
:where(h3) {
  font-size: var(--lumo-font-size-xl);
}
:where(h4) {
  font-size: var(--lumo-font-size-l);
}
:where(h5) {
  font-size: var(--lumo-font-size-m);
}
:where(h6) {
  font-size: var(--lumo-font-size-xs);
  text-transform: uppercase;
  letter-spacing: 0.03em;
}
p,
blockquote {
  margin-top: 0.5em;
  margin-bottom: 0.75em;
}
a {
  text-decoration: none;
}
a:where(:any-link) {
  color: var(--lumo-primary-text-color);
}
a:where(:any-link):hover {
  text-decoration: underline;
}
a:not(:any-link) {
  color: var(--lumo-disabled-text-color);
}
hr {
  display: block;
  align-self: stretch;
  height: 1px;
  border: 0;
  padding: 0;
  margin: var(--lumo-space-s) calc(var(--lumo-border-radius-m) / 2);
  background-color: var(--lumo-contrast-10pct);
}
b,
strong {
  font-weight: 600;
}
code,
pre {
  border-radius: var(--lumo-border-radius-m);
}
pre code {
  background: transparent;
}
blockquote {
  border-left: 2px solid var(--lumo-contrast-30pct);
  color: var(--lumo-secondary-text-color);
}
blockquote[dir='rtl'] {
  border-left: none;
  border-right: 2px solid var(--lumo-contrast-30pct);
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_accordion-heading {
  :host {
    display: block;
    outline: none;
    -webkit-user-select: none;
    user-select: none;
    padding: 0;
  }

  :host([hidden]) {
    display: none !important;
  }

  button {
    display: flex;
    align-items: center;
    justify-content: inherit;
    width: 100%;
    margin: 0;
    padding: 0;
    background-color: initial;
    color: inherit;
    border: initial;
    outline: none;
    font: inherit;
    text-align: inherit;
  }

  [part='content'] {
    padding: var(--lumo-space-s) 0;
  }

  :host([theme~='filled']) {
    padding-top: 0;
    padding-bottom: 0;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_details-summary {
  :host {
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
    display: flex;
    align-items: center;
    width: 100%;
    outline: none;
    padding: var(--lumo-space-s) 0;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 500;
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
    background-color: inherit;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: none;
  }

  :host([disabled]),
  :host([disabled]) [part='toggle'] {
    color: var(--lumo-disabled-text-color);
    cursor: default;
  }

  @media (hover: hover) {
    :host(:hover:not([disabled])),
    :host(:hover:not([disabled])) [part='toggle'] {
      color: var(--lumo-contrast-80pct);
    }
  }

  [part='toggle'] {
    display: block;
    width: 1em;
    height: 1em;
    margin-left: calc(var(--lumo-space-xs) * -1);
    margin-right: var(--lumo-space-xs);
    font-size: var(--lumo-icon-size-s);
    line-height: 1;
    color: var(--lumo-contrast-60pct);
    font-family: 'lumo-icons';
    cursor: var(--lumo-clickable-cursor);
  }

  [part='toggle']::before {
    content: var(--lumo-icons-angle-right);
  }

  :host([opened]) [part='toggle'] {
    transform: rotate(90deg);
  }

  [part='content'] {
    flex-grow: 1;
  }

  /* RTL styles */
  :host([dir='rtl']) [part='toggle'] {
    margin-left: var(--lumo-space-xs);
    margin-right: calc(var(--lumo-space-xs) * -1);
  }

  :host([dir='rtl']) [part='toggle']::before {
    content: var(--lumo-icons-angle-left);
  }

  :host([opened][dir='rtl']) [part='toggle'] {
    transform: rotate(-90deg);
  }

  /* Small */
  :host([theme~='small']) {
    padding-top: var(--lumo-space-xs);
    padding-bottom: var(--lumo-space-xs);
  }

  :host([theme~='small']) [part='toggle'] {
    margin-right: calc(var(--lumo-space-xs) / 2);
  }

  :host([theme~='small'][dir='rtl']) [part='toggle'] {
    margin-left: calc(var(--lumo-space-xs) / 2);
  }

  /* Filled */
  :host([theme~='filled']) {
    padding: var(--lumo-space-s) calc(var(--lumo-space-s) + var(--lumo-space-xs) / 2);
  }

  /* Reverse */
  :host([theme~='reverse']) {
    justify-content: space-between;
  }

  :host([theme~='reverse']) [part='toggle'] {
    order: 1;
    margin-right: 0;
  }

  :host([theme~='reverse'][dir='rtl']) [part='toggle'] {
    margin-left: 0;
  }

  /* Filled reverse */
  :host([theme~='reverse'][theme~='filled']) {
    padding-left: var(--lumo-space-m);
  }

  :host([theme~='reverse'][theme~='filled'][dir='rtl']) {
    padding-right: var(--lumo-space-m);
  }
}
:is(:root, :host)::before {
  --vaadin-accordion-heading-lumo-inject: 1;
  --vaadin-accordion-heading-lumo-inject-modules:
    lumo_components_details-summary,
    lumo_components_accordion-heading;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_accordion-panel {
  :host {
    display: block;
    margin: 0;
    border-bottom: solid 1px var(--lumo-contrast-10pct);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    display: none;
    overflow: hidden;
  }

  :host([opened]) [part='content'] {
    display: block;
    overflow: visible;
  }

  :host(:last-child) {
    border-bottom: none;
  }

  :host([theme~='filled']) {
    border-bottom: none;
  }

  :host([theme~='filled']:not(:last-child)) {
    margin-bottom: 2px;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_details {
  :host {
    margin: var(--lumo-space-xs) 0;
    outline: none;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([focus-ring]) ::slotted([slot='summary']) {
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) 0 var(--lumo-space-s);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
  }

  :host([theme~='filled']) {
    background-color: var(--lumo-contrast-5pct);
    border-radius: var(--lumo-border-radius-m);
  }

  :host([theme~='filled']) [part='content'] {
    padding-left: var(--lumo-space-m);
    padding-right: var(--lumo-space-m);
  }

  :host([theme~='small']) [part$='content'] {
    font-size: var(--lumo-font-size-s);
  }
}
:is(:root, :host)::before {
  --vaadin-accordion-panel-lumo-inject: 1;
  --vaadin-accordion-panel-lumo-inject-modules:
    lumo_components_details,
    lumo_components_accordion-panel;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_app-layout {
  :host {
    display: block;
    box-sizing: border-box;
    height: 100%;
    --vaadin-app-layout-transition-duration: 200ms;
    transition: padding var(--vaadin-app-layout-transition-duration);
    --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 16em);
    --vaadin-app-layout-touch-optimized: false;
    --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
    --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
    padding-block: var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);
    padding-inline-start: var(--vaadin-app-layout-navbar-offset-left);
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([no-anim]) {
    --vaadin-app-layout-transition-duration: 0s !important;
  }

  :host([drawer-opened]) {
    --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
  }

  :host([overlay]) {
    --vaadin-app-layout-drawer-offset-left: 0;
    --vaadin-app-layout-navbar-offset-left: 0;
  }

  :host(:not([no-scroll])) [content] {
    overflow: auto;
  }

  [content] {
    height: 100%;
  }

  @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
    :host {
      --vaadin-app-layout-touch-optimized: true;
    }
  }

  [part='navbar'] {
    position: fixed;
    display: flex;
    align-items: center;
    top: 0;
    inset-inline: 0;
    transition: inset-inline-start var(--vaadin-app-layout-transition-duration);
    padding-top: var(--safe-area-inset-top);
    padding-left: var(--safe-area-inset-left);
    padding-right: var(--safe-area-inset-right);
    z-index: 1;
    min-height: var(--lumo-size-xl);
    border-bottom: 1px solid var(--lumo-contrast-10pct);
  }

  :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
    inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
  }

  :host([primary-section='drawer']) [part='drawer'] {
    top: 0;
  }

  [part='navbar'][bottom] {
    top: auto;
    bottom: 0;
    padding-bottom: var(--safe-area-inset-bottom);
    border-bottom: none;
    border-top: 1px solid var(--lumo-contrast-10pct);
  }

  [part='drawer'] {
    overflow: auto;
    position: fixed;
    top: var(--vaadin-app-layout-navbar-offset-top, 0);
    bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
    inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
    transition:
      transform var(--vaadin-app-layout-transition-duration),
      visibility var(--vaadin-app-layout-transition-duration);
    transform: translateX(-100%);
    max-width: 90%;
    width: var(--_vaadin-app-layout-drawer-width);
    box-sizing: border-box;
    padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
    outline: none;
    /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
    visibility: hidden;
    display: flex;
    flex-direction: column;
    border-inline-end: 1px solid var(--lumo-contrast-10pct);
  }

  :host([drawer-opened]) [part='drawer'] {
    /* The drawer should be accessible by the tabbing navigation when it is opened. */
    visibility: visible;
    transform: translateX(0%);
    touch-action: manipulation;
  }

  [part='backdrop'] {
    background-color: var(--lumo-shade-20pct);
    opacity: 1;
  }

  :host(:not([drawer-opened])) [part='backdrop'] {
    opacity: 0;
  }

  :host([overlay]) [part='backdrop'] {
    position: fixed;
    inset: 0;
    pointer-events: none;
    transition: opacity var(--vaadin-app-layout-transition-duration);
    -webkit-tap-highlight-color: transparent;
  }

  :host([overlay]) [part='drawer'] {
    top: 0;
    bottom: 0;
    border-inline-end: none;
    box-shadow: var(--lumo-box-shadow-s);
  }

  :host([overlay]) [part='drawer'],
  :host([overlay]) [part='backdrop'] {
    z-index: 2;
  }

  :host([drawer-opened][overlay]) [part='backdrop'] {
    pointer-events: auto;
    touch-action: manipulation;
  }

  :host([dir='rtl']) [part='drawer'] {
    transform: translateX(100%);
  }

  :host([dir='rtl'][drawer-opened]) [part='drawer'] {
    transform: translateX(0%);
  }

  :host([drawer-opened]:not([overlay])) {
    padding-inline-start: var(--vaadin-app-layout-drawer-offset-left);
  }

  @media (max-width: 800px), (max-height: 600px) {
    :host {
      --vaadin-app-layout-drawer-overlay: true;
      --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 20em);
    }
  }

  /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
  [part='drawer'] ::slotted(vaadin-scroller) {
    flex: 1;
    overscroll-behavior: contain;
  }

  [part='navbar'],
  [part='drawer'] {
    background-color: var(--lumo-base-color);
    background-clip: padding-box;
  }

  :host([primary-section='navbar']) [part='navbar'] {
    border: none;
    background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
  }

  :host([primary-section='drawer']:not([overlay])) [part='drawer'] {
    background-image: linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
  }

  [part] ::slotted(h2),
  [part] ::slotted(h3),
  [part] ::slotted(h4) {
    margin-top: var(--lumo-space-xs) !important;
    margin-bottom: var(--lumo-space-xs) !important;
  }
}
:is(:root, :host)::before {
  --vaadin-app-layout-lumo-inject: 1;
  --vaadin-app-layout-lumo-inject-modules: lumo_components_app-layout;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_menu-overlay-core {
  :host([opening]),
  :host([closing]) {
    animation: 0.14s lumo-overlay-dummy-animation;
  }

  [part='overlay'] {
    will-change: opacity, transform;
  }

  :host([opening]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-enter ease-out both;
  }

  @keyframes lumo-menu-overlay-enter {
    0% {
      opacity: 0;
      transform: translateY(-4px);
    }
  }

  :host([closing]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-exit both;
  }

  @keyframes lumo-menu-overlay-exit {
    100% {
      opacity: 0;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_overlay {
  :host {
    z-index: 200;
    position: fixed;

    /* Despite of what the names say, <vaadin-overlay> is just a container
        for position/sizing/alignment. The actual overlay is the overlay part. */

    /* Use flexbox alignment for the overlay part. */
    display: flex;
    flex-direction: column; /* makes dropdowns sizing easier */
    /* Align to center by default. */
    align-items: center;
    justify-content: center;

    /* Override native [popover] user agent styles */
    width: auto;
    height: auto;
    border: none;
    padding: 0;
    background-color: transparent;
    overflow: visible;

    /* Allow centering when max-width/max-height applies. */
    margin: auto;

    /* The host is not clickable, only the overlay part is. */
    pointer-events: none;

    /* Remove tap highlight on touch devices. */
    -webkit-tap-highlight-color: transparent;

    /* CSS API for host */
    --vaadin-overlay-viewport-bottom: 0;

    inset: var(--lumo-space-m) var(--lumo-space-m) var(--lumo-space-m) var(--lumo-space-m);
    /* Workaround for Edge issue (only on Surface), where an overflowing vaadin-list-box inside vaadin-select-overlay makes the overlay transparent */
    /* stylelint-disable-next-line */
    outline: 0px solid transparent;
  }

  :host([hidden]),
  :host(:not([opened]):not([closing])),
  :host(:not([opened]):not([closing])) [part='overlay'] {
    display: none !important;
  }

  [part='overlay'] {
    overflow: auto;
    pointer-events: auto;

    /* Prevent overflowing the host */
    max-width: 100%;
    box-sizing: border-box;

    -webkit-tap-highlight-color: initial; /* reenable tap highlight inside */
    background-color: var(--lumo-base-color);
    background-image: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
    border-radius: var(--lumo-border-radius-m);
    box-shadow:
      0 0 0 1px var(--lumo-shade-5pct),
      var(--lumo-box-shadow-m);
    color: var(--lumo-body-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 400;
    line-height: var(--lumo-line-height-m);
    letter-spacing: 0;
    text-transform: none;
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  [part='backdrop'] {
    z-index: -1;
    content: '';
    background: rgba(0, 0, 0, 0.5);
    position: fixed;
    inset: 0;
    pointer-events: auto;
    background-color: var(--lumo-shade-20pct);
    animation: 0.2s lumo-overlay-backdrop-enter both;
    will-change: opacity;
  }

  [part='content'] {
    padding: var(--lumo-space-xs);
  }

  @keyframes lumo-overlay-backdrop-enter {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) [part='backdrop'] {
    animation: 0.2s lumo-overlay-backdrop-exit both;
  }

  @keyframes lumo-overlay-backdrop-exit {
    100% {
      opacity: 0;
    }
  }

  @keyframes lumo-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_avatar-group-menu-item {
  :host {
    padding: var(--lumo-space-xs);
    padding-inline-end: var(--lumo-space-m);
  }

  [part='content'] {
    display: flex;
    align-items: center;
  }

  [part='content'] ::slotted(vaadin-avatar) {
    width: var(--lumo-size-xs);
    height: var(--lumo-size-xs);
    margin-inline-end: var(--lumo-space-s);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_avatar-group-overlay {
  :host {
    --_lumo-list-box-item-selected-icon-display: none;
    --_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_avatar-group {
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    --vaadin-avatar-size: var(--lumo-size-m);
    --vaadin-avatar-group-overlap: 8px;
    /* Deprecated property name (overlap-border), for backwards compatibility */
    --vaadin-avatar-group-overlap-border: var(--vaadin-avatar-group-gap, 2px);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    display: flex;
    position: relative;
    width: 100%;
    flex-wrap: nowrap;
  }

  ::slotted(vaadin-avatar:not(:first-of-type)) {
    mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
    mask-size: calc(300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6);
  }

  ::slotted(vaadin-avatar:not([dir='rtl']):not(:first-of-type)) {
    margin-left: calc(var(--vaadin-avatar-group-overlap) * -1 - var(--vaadin-avatar-outline-width));
    mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
  }

  ::slotted(vaadin-avatar[dir='rtl']:not(:first-of-type)) {
    margin-right: calc(var(--vaadin-avatar-group-overlap) * -1);
    mask-position: calc(
      50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
    );
  }

  :host([theme~='xlarge']) {
    --vaadin-avatar-group-overlap: 12px;
    --vaadin-avatar-group-overlap-border: 3px;
    --vaadin-avatar-size: var(--lumo-size-xl);
  }

  :host([theme~='large']) {
    --vaadin-avatar-group-overlap: 10px;
    --vaadin-avatar-group-overlap-border: 3px;
    --vaadin-avatar-size: var(--lumo-size-l);
  }

  :host([theme~='small']) {
    --vaadin-avatar-group-overlap: 6px;
    --vaadin-avatar-group-overlap-border: 2px;
    --vaadin-avatar-size: var(--lumo-size-s);
  }

  :host([theme~='xsmall']) {
    --vaadin-avatar-group-overlap: 4px;
    --vaadin-avatar-group-overlap-border: 2px;
    --vaadin-avatar-size: var(--lumo-size-xs);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_item {
  :host {
    display: flex;
    align-items: center;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    padding: 0.5em calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4) 0.5em
      var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
    min-height: var(--lumo-size-m);
    outline: none;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: var(--lumo-primary-color-10pct);
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
  }

  :host([hidden]) {
    display: none !important;
  }

  /* Checkmark */
  [part='checkmark']::before {
    display: var(--_lumo-item-selected-icon-display, none);
    content: var(--lumo-icons-checkmark);
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    font-weight: normal;
    width: 1em;
    height: 1em;
    margin: calc((1 - var(--lumo-line-height-xs)) * var(--lumo-font-size-m) / 2) 0;
    color: var(--_selection-color-text);
    flex: none;
    opacity: 0;
    transition:
      transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2),
      opacity 0.1s;
  }

  :host([selected]) [part='checkmark']::before {
    opacity: 1;
  }

  :host([active]:not([selected])) [part='checkmark']::before {
    transform: scale(0.8);
    opacity: 0;
    transition-duration: 0s;
  }

  [part='content'] {
    flex: auto;
  }

  /* Disabled */
  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
    cursor: default;
    pointer-events: none;
  }

  /* TODO a workaround until we have "focus-follows-mouse". After that, use the hover style for focus-ring as well */
  @media (any-hover: hover) {
    :host(:hover:not([disabled])) {
      background-color: var(--lumo-primary-color-10pct);
    }
  }

  :host([focus-ring]:not([disabled])) {
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  /* RTL specific styles */
  :host([dir='rtl']) {
    padding-left: calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);
    padding-right: var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
  }

  /* Slotted icons */
  :host ::slotted(vaadin-icon) {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_list-box {
  :host {
    display: flex;
    -webkit-tap-highlight-color: transparent;
    --_lumo-item-selected-icon-display: var(--_lumo-list-box-item-selected-icon-display, block);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='items'] {
    height: 100%;
    width: 100%;
    overflow-y: auto;
  }

  /* Dividers */
  [part='items'] ::slotted(hr) {
    height: 1px;
    border: 0;
    padding: 0;
    margin: var(--lumo-space-s) var(--lumo-border-radius-m);
    background-color: var(--lumo-contrast-10pct);
  }
}
:is(:root, :host)::before {
  --vaadin-avatar-group-lumo-inject: 1;
  --vaadin-avatar-group-lumo-inject-modules: lumo_components_avatar-group;

  --vaadin-avatar-group-overlay-lumo-inject: 1;
  --vaadin-avatar-group-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_components_avatar-group-overlay;

  --vaadin-avatar-group-menu-lumo-inject: 1;
  --vaadin-avatar-group-menu-lumo-inject-modules: lumo_components_list-box;

  --vaadin-avatar-group-menu-item-lumo-inject: 1;
  --vaadin-avatar-group-menu-item-lumo-inject-modules:
    lumo_components_item,
    lumo_components_avatar-group-menu-item;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_avatar {
  :host {
    --vaadin-avatar-outline-width: var(--vaadin-focus-ring-width, 2px);
    border: var(--vaadin-avatar-outline-width) solid transparent;
    margin: calc(var(--vaadin-avatar-outline-width) * -1);
    color: var(--lumo-secondary-text-color);
    background-color: var(--lumo-contrast-10pct);
    outline: none;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    vertical-align: baseline;
  }

  [part='icon'] {
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: var(--vaadin-avatar-size, 64px);
    line-height: 1;
    mask: none;
    background: none;
  }

  [part='icon']::before {
    content: var(--lumo-icons-user);
    font-family: lumo-icons;
    font-size: 0.9em;
  }

  [part='abbr'] {
    font-family: var(--lumo-font-family);
    font-size: 2.4375em;
    font-weight: 500;
  }

  :host([has-color-index]) {
    color: var(--lumo-base-color);
  }

  :host([has-color-index])::before {
    border: none;
    box-shadow: inset 0 0 0 2px var(--vaadin-avatar-user-color);
  }

  :host([focus-ring]) {
    outline: none;
    border-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
  }

  :host([theme~='xlarge']) [part='abbr'] {
    font-size: 2.5em;
  }

  :host([theme~='large']) [part='abbr'] {
    font-size: 2.375em;
  }

  :host([theme~='small']) [part='abbr'] {
    font-size: 2.75em;
  }

  :host([theme~='xsmall']) [part='abbr'] {
    font-size: 3em;
  }

  :host([theme~='xlarge']) {
    --vaadin-avatar-size: var(--lumo-size-xl);
  }

  :host([theme~='large']) {
    --vaadin-avatar-size: var(--lumo-size-l);
  }

  :host([theme~='small']) {
    --vaadin-avatar-size: var(--lumo-size-s);
  }

  :host([theme~='xsmall']) {
    --vaadin-avatar-size: var(--lumo-size-xs);
  }
}
:is(:root, :host)::before {
  --vaadin-avatar-lumo-inject: 1;
  --vaadin-avatar-lumo-inject-modules: lumo_components_avatar;
}
:where(:root, :host) {
  --vaadin-avatar-size: var(
    --lumo-size-m
  );
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_button {
  :host {
    display: inline-block;
    position: relative;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
    /* Sizing */
    --lumo-button-size: var(--lumo-size-m);
    min-width: var(--vaadin-button-min-width, calc(var(--_button-size) * 2));
    height: var(--_button-size);
    padding: var(--vaadin-button-padding, 0 calc(var(--_button-size) / 3 + var(--lumo-border-radius-m) / 2));
    margin: var(--vaadin-button-margin, var(--lumo-space-xs) 0);
    box-sizing: border-box;
    /* Style */
    font-family: var(--lumo-font-family);
    font-size: var(--vaadin-button-font-size, var(--lumo-font-size-m));
    font-weight: var(--vaadin-button-font-weight, 500);
    color: var(--_lumo-button-text-color);
    background: var(--_lumo-button-background);
    border: var(--vaadin-button-border, none);
    border-radius: var(--vaadin-button-border-radius, var(--lumo-border-radius-m));
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    flex-shrink: 0;
    --_button-size: var(--vaadin-button-height, var(--lumo-button-size));
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    /* Used by notification */
    --_lumo-button-background: var(--vaadin-button-background, var(--lumo-contrast-5pct));
    --_lumo-button-text-color: var(--vaadin-button-text-color, var(--lumo-primary-text-color));
    --_lumo-button-primary-background: var(--vaadin-button-primary-background, var(--lumo-primary-color));
    --_lumo-button-primary-text-color: var(--vaadin-button-primary-text-color, var(--lumo-primary-contrast-color));
  }

  :host([hidden]) {
    display: none !important;
  }

  .vaadin-button-container {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    width: 100%;
    height: 100%;
    min-height: inherit;
    text-shadow: inherit;
  }

  /* Aligns the button with form fields when placed on the same line.
Note, to make it work, the form fields should have the same "::before" pseudo-element. */
  .vaadin-button-container::before {
    content: '\\2003';
    display: inline-block;
    width: 0;
    max-height: 100%;
  }

  [part='prefix'],
  [part='suffix'] {
    flex: none;
  }

  /* Set only for the internal parts so we don't affect the host vertical alignment */
  [part='label'],
  [part='prefix'],
  [part='suffix'] {
    line-height: var(--lumo-line-height-xs);
  }

  [part='label'] {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    padding: calc(var(--lumo-button-size) / 6) 0;
  }

  :host([theme~='small']) {
    font-size: var(--lumo-font-size-s);
    --lumo-button-size: var(--lumo-size-s);
  }

  :host([theme~='large']) {
    font-size: var(--lumo-font-size-l);
    --lumo-button-size: var(--lumo-size-l);
  }

  /* For interaction states */
  :host::before,
  :host::after {
    content: '';
    /* We rely on the host always being relative */
    position: absolute;
    z-index: 1;
    inset: 0;
    background-color: currentColor;
    border-radius: inherit;
    opacity: 0;
    pointer-events: none;
  }

  /* Hover */

  @media (any-hover: hover) {
    :host(:not([disabled]):hover)::before {
      opacity: 0.02;
    }
  }

  /* Active */

  :host::after {
    transition:
      opacity 1.4s,
      transform 0.1s;
    filter: blur(8px);
  }

  :host([active])::before {
    opacity: 0.05;
    transition-duration: 0s;
  }

  :host([active])::after {
    opacity: 0.1;
    transition-duration: 0s, 0s;
    transform: scale(0);
  }

  /* Keyboard focus */

  :host([focus-ring]) {
    box-shadow:
      0 0 0 calc(1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-gap-color, var(--lumo-base-color)),
      0 0 0 calc(var(--_focus-ring-width) + 1px * var(--_focus-ring-gap-on, 0)) var(--_focus-ring-color);
  }

  :host([theme~='primary'][focus-ring]) {
    --_focus-ring-gap-on: 1;
  }

  /* Types (primary, tertiary, tertiary-inline */

  :host([theme~='tertiary']),
  :host([theme~='tertiary-inline']) {
    --_background: transparent !important;
    background: var(--vaadin-button-tertiary-background, var(--_background));
    min-width: 0;
  }

  :host([theme~='tertiary']) {
    border: var(--vaadin-button-tertiary-border, none);
    color: var(--vaadin-button-tertiary-text-color, var(--lumo-primary-text-color));
    font-weight: var(--vaadin-button-tertiary-font-weight, 500);
    padding: var(--vaadin-button-tertiary-padding, 0 calc(var(--_button-size) / 6));
  }

  :host([theme~='tertiary-inline'])::before {
    display: none;
  }

  :host([theme~='tertiary-inline']) {
    margin: 0;
    height: auto;
    padding: 0;
    line-height: inherit;
    font-size: inherit;
  }

  :host([theme~='tertiary-inline']) [part='label'] {
    padding: 0;
    overflow: visible;
    line-height: inherit;
  }

  :host([theme~='primary']) {
    background: var(--_lumo-button-primary-background);
    border: var(--vaadin-button-primary-border, none);
    color: var(--_lumo-button-primary-text-color);
    font-weight: var(--vaadin-button-primary-font-weight, 600);
    min-width: calc(var(--lumo-button-size) * 2.5);
  }

  :host([theme~='primary'])::before {
    background-color: black;
  }

  @media (any-hover: hover) {
    :host([theme~='primary']:not([disabled]):hover)::before {
      opacity: 0.05;
    }
  }

  :host([theme~='primary'][active])::before {
    opacity: 0.1;
  }

  :host([theme~='primary'][active])::after {
    opacity: 0.2;
  }

  /* Colors (success, warning, error, contrast) */

  :host([theme~='success']) {
    color: var(--lumo-success-text-color);
  }

  :host([theme~='success'][theme~='primary']) {
    background-color: var(--lumo-success-color);
    color: var(--lumo-success-contrast-color);
  }

  :host([theme~='warning']) {
    color: var(--lumo-warning-text-color);
  }

  :host([theme~='warning'][theme~='primary']) {
    background-color: var(--lumo-warning-color);
    color: var(--lumo-warning-contrast-color);
  }

  :host([theme~='error']) {
    color: var(--lumo-error-text-color);
  }

  :host([theme~='error'][theme~='primary']) {
    background-color: var(--lumo-error-color);
    color: var(--lumo-error-contrast-color);
  }

  :host([theme~='contrast']) {
    color: var(--lumo-contrast);
  }

  :host([theme~='contrast'][theme~='primary']) {
    background-color: var(--lumo-contrast);
    color: var(--lumo-base-color);
  }

  /* Disabled state. Keep selectors after other color variants. */

  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
    pointer-events: var(--_vaadin-button-disabled-pointer-events, none);
    cursor: not-allowed;
  }

  :host([theme~='primary'][disabled]) {
    background-color: var(--lumo-contrast-30pct);
    color: var(--lumo-base-color);
  }

  :host([theme~='primary'][disabled]) [part] {
    opacity: 0.7;
  }

  /* Icons */

  [part] ::slotted(vaadin-icon) {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }

  [part] ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: 0.25em;
    box-sizing: border-box !important;
  }

  [part='prefix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  [part='suffix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  /* Icon-only */

  :host([theme~='icon']:not([theme~='tertiary-inline'])) {
    min-width: var(--lumo-button-size);
    padding-left: calc(var(--lumo-button-size) / 4);
    padding-right: calc(var(--lumo-button-size) / 4);
  }

  :host([theme~='icon']) [part='prefix'],
  :host([theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='prefix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  :host([dir='rtl']) [part='suffix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  :host([dir='rtl'][theme~='icon']) [part='prefix'],
  :host([dir='rtl'][theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }

  @media (forced-colors: active) {
    :host {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([focused]) {
      outline-width: 2px;
    }

    :host([disabled]) {
      outline-color: GrayText;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-button-lumo-inject: 1;
  --vaadin-button-lumo-inject-modules: lumo_components_button;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_card {
  :host::before {
    inset: var(--_card-border-inset, 0);
    border-radius: var(--_card-border-pseudo-radius, inherit);
  }

  :host([theme~='outlined']) {
    --vaadin-card-border-width: 1px;
    --vaadin-card-background: var(--lumo-base-color);
  }

  :host([theme~='elevated']) {
    --vaadin-card-background: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct)) var(--lumo-base-color);
    --vaadin-card-shadow: var(--lumo-box-shadow-xs);
    --vaadin-card-border-width: 1px;
    --_card-border-inset: calc(-1 * var(--vaadin-card-border-width));
    --_card-border-pseudo-radius: calc(var(--vaadin-card-border-radius) + var(--vaadin-card-border-width));
  }

  :host([theme~='elevated']:not([theme~='outlined'])) {
    --vaadin-card-border-color: var(--lumo-contrast-10pct);
  }

  :host(:where([theme~='stretch-media'])) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: var(--lumo-border-radius-m);
  }

  :host([theme~='elevated'][theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    margin-top: calc((var(--_padding) + var(--vaadin-card-border-width)) * -1);
    margin-inline: calc((var(--_padding) + var(--vaadin-card-border-width)) * -1);
    width: calc(100% + (var(--_padding) + var(--vaadin-card-border-width)) * 2);
  }
}
:is(:root, :host)::before {
  --vaadin-card-lumo-inject: 1;
  --vaadin-card-lumo-inject-modules: lumo_components_card;
}
:where(:root, :host) {
  --vaadin-card-background: var(
    --lumo-contrast-5pct
  );
  --vaadin-card-border-radius: var(
    --lumo-border-radius-l
  );
  --vaadin-card-border-width: 0;
  --vaadin-card-border-color: var(
    --lumo-contrast-20pct
  );
  --vaadin-card-padding: var(
    --lumo-space-m
  );
  --vaadin-card-gap: var(
    --lumo-space-m
  );
  --vaadin-card-shadow: none;
  --vaadin-card-title-font-color: var(
    --lumo-header-text-color
  );
  --vaadin-card-title-font-size: var(
    --lumo-font-size-l
  );
  --vaadin-card-title-font-weight: 600;
  --vaadin-card-title-line-height: var(
    --lumo-line-height-xs
  );
  --vaadin-card-subtitle-font-color: var(
    --lumo-secondary-text-color
  );
  --vaadin-card-subtitle-font-size: var(
    --lumo-font-size-m
  );
  --vaadin-card-subtitle-line-height: var(
    --lumo-line-height-xs
  );
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_chart {
  :host,
  :root {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-button-border-radius: 2px;
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
    font-family: var(--lumo-font-family);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
}
:is(:root, :host)::before {
  --vaadin-chart-lumo-inject: 1;
  --vaadin-chart-lumo-inject-modules: lumo_components_chart;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_field-error-message {
  [part='error-message'] {
    margin-left: calc(var(--lumo-border-radius-m) / 4);
    font-size: var(--vaadin-input-field-error-font-size, var(--lumo-font-size-xs));
    line-height: var(--lumo-line-height-xs);
    font-weight: var(--vaadin-input-field-error-font-weight, 400);
    color: var(--vaadin-input-field-error-color, var(--lumo-error-text-color));
    will-change: max-height;
    transition: 0.4s max-height;
    max-height: 5em;
  }

  :host([has-error-message]) [part='error-message']::before,
  :host([has-error-message]) [part='error-message']::after {
    content: '';
    display: block;
    height: 0.4em;
  }

  :host(:not([invalid])) [part='error-message'] {
    max-height: 0;
    overflow: hidden;
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='error-message'] {
    margin-left: 0;
    margin-right: calc(var(--lumo-border-radius-m) / 4);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_field-helper {
  :host {
    --_helper-spacing: var(--vaadin-input-field-helper-spacing, 0.4em);
  }

  :host([has-helper]) [part='helper-text']::before {
    content: '';
    display: block;
    height: var(--_helper-spacing);
  }

  [part='helper-text'] {
    display: block;
    color: var(--vaadin-input-field-helper-color, var(--lumo-secondary-text-color));
    font-size: var(--vaadin-input-field-helper-font-size, var(--lumo-font-size-xs));
    line-height: var(--lumo-line-height-xs);
    font-weight: var(--vaadin-input-field-helper-font-weight, 400);
    margin-left: calc(var(--lumo-border-radius-m) / 4);
    transition: color 0.2s;
  }

  :host(:hover:not([readonly])) [part='helper-text'] {
    color: var(--lumo-body-text-color);
  }

  :host([disabled]) [part='helper-text'] {
    color: var(--lumo-disabled-text-color);
    -webkit-text-fill-color: var(--lumo-disabled-text-color);
  }

  :host([has-helper][theme~='helper-above-field']) [part='helper-text']::before {
    display: none;
  }

  :host([has-helper][theme~='helper-above-field']) [part='helper-text']::after {
    content: '';
    display: block;
    height: var(--_helper-spacing);
  }

  :host([has-helper][theme~='helper-above-field']) [part='label'] {
    order: 0;
    padding-bottom: var(--_helper-spacing);
  }

  :host([has-helper][theme~='helper-above-field']) [part='helper-text'] {
    order: 1;
  }

  :host([has-helper][theme~='helper-above-field']) [part='label'] + * {
    order: 2;
  }

  :host([has-helper][theme~='helper-above-field']) [part='error-message'] {
    order: 3;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_field-label {
  [part='label'] {
    align-self: flex-start;
    color: var(--vaadin-input-field-label-color, var(--lumo-secondary-text-color));
    font-weight: var(--vaadin-input-field-label-font-weight, 500);
    font-size: var(--vaadin-input-field-label-font-size, var(--lumo-font-size-s));
    transition: color 0.2s;
    line-height: 1;
    padding-inline: calc(var(--lumo-border-radius-m) / 4) 1em;
    padding-bottom: 0.5em;
    /* As a workaround for diacritics being cut off, add a top padding and a
  negative margin to compensate */
    padding-top: 0.25em;
    margin-top: -0.25em;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    position: relative;
    max-width: 100%;
    box-sizing: border-box;
  }

  :host([focused]:not([readonly])) [part='label'] {
    color: var(--vaadin-input-field-focused-label-color, var(--lumo-primary-text-color));
  }

  :host(:hover:not([readonly]):not([focused])) [part='label'] {
    color: var(--vaadin-input-field-hovered-label-color, var(--lumo-body-text-color));
  }

  /* Touch device adjustment */
  @media (pointer: coarse) {
    :host(:hover:not([readonly]):not([focused])) [part='label'] {
      color: var(--vaadin-input-field-label-color, var(--lumo-secondary-text-color));
    }
  }

  :host(:not([has-label])) [part='label'] {
    display: none;
  }

  :host([has-label])::before {
    margin-top: calc(var(--lumo-font-size-s) * 1.5);
  }

  :host([has-label][theme~='small'])::before {
    margin-top: calc(var(--lumo-font-size-xs) * 1.5);
  }

  :host([has-label]) {
    padding-top: var(--lumo-space-m);
  }

  :host([has-label]) ::slotted([slot='tooltip']) {
    --vaadin-tooltip-offset-bottom: calc((var(--lumo-space-m) - var(--lumo-space-xs)) * -1);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_field-required {
  :host([required]) [part='required-indicator']::after {
    content: var(--lumo-required-field-indicator, '\\2022');
    color: var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));
    position: absolute;
    right: 0;
    width: 1em;
    text-align: center;
  }

  :host([invalid]) [part='required-indicator']::after {
    color: var(--lumo-required-field-indicator-color, var(--lumo-error-text-color));
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='required-indicator']::after {
    right: auto;
    left: 0;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_group-field {
  :host {
    display: inline-flex;
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-m);
    font-family: var(--lumo-font-family);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: transparent;
    padding: var(--lumo-space-xs) 0;
  }

  :host::before {
    content: '\\2003';
    width: 0;
    height: var(--lumo-size-s);
    box-sizing: border-box;
    display: inline-flex;
    align-items: center;
  }

  :host([hidden]) {
    display: none !important;
  }

  .vaadin-group-field-container {
    display: flex;
    flex-direction: column;
    width: 100%;
  }

  [part='group-field'] {
    display: flex;
    flex-wrap: wrap;
  }

  :host(:not([has-label])) [part='label'] {
    display: none;
  }

  :host([theme~='vertical']) [part='group-field'] {
    flex-direction: column;
  }

  :host([disabled]) [part='label'] {
    color: var(--lumo-disabled-text-color);
    -webkit-text-fill-color: var(--lumo-disabled-text-color);
  }

  :host([focused]:not([readonly])) [part='label'] {
    color: var(--lumo-primary-text-color);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_checkbox-group {
  :host(:hover:not([readonly]):not([disabled]):not([focused])) [part='label'],
  :host(:hover:not([readonly]):not([disabled]):not([focused])) [part='helper-text'] {
    color: var(--lumo-body-text-color);
  }

  /* Touch device adjustment */
  @media (pointer: coarse) {
    :host(:hover:not([readonly]):not([disabled]):not([focused])) [part='label'] {
      color: var(--lumo-secondary-text-color);
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_checkable-field {
  :host {
    display: inline-block;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    -webkit-tap-highlight-color: transparent;
  }

  .vaadin-checkbox-container,
  .vaadin-radio-button-container {
    display: grid;
    grid-template-columns: auto 1fr;
    align-items: baseline;
  }

  [part='checkbox'],
  [part='radio'],
  [part='label'],
  ::slotted(input),
  ::slotted(label) {
    grid-row: 1;
  }

  [part='checkbox'],
  [part='radio'],
  ::slotted(input) {
    grid-column: 1;
  }

  /* Control container (checkbox, radio button) */
  [part='checkbox'],
  [part='radio'] {
    width: var(--_input-size, 1em);
    height: var(--_input-size, 1em);
    --_input-border-width: var(--vaadin-input-field-border-width, 0);
    --_input-border-color: var(--vaadin-input-field-border-color, transparent);
    box-shadow: inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color);
  }

  [part='checkbox']::before,
  [part='radio']::before {
    display: block;
    content: '\\202F';
    line-height: var(--_input-size, 1em);
    contain: paint;
  }

  /* visually hidden */
  ::slotted(input) {
    cursor: inherit;
    margin: 0;
    align-self: stretch;
    appearance: none;
    width: initial;
    height: initial;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_checkbox {
  :host {
    color: var(--vaadin-checkbox-label-color, var(--lumo-body-text-color));
    font-size: var(--vaadin-checkbox-label-font-size, var(--lumo-font-size-m));
    font-family: var(--lumo-font-family);
    line-height: var(--lumo-line-height-s);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: transparent;
    -webkit-user-select: none;
    user-select: none;
    cursor: default;
    outline: none;
    --_checkbox-size: var(--vaadin-checkbox-size, calc(var(--lumo-size-m) / 2));
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color));
    --_invalid-background: var(--vaadin-input-field-invalid-background, var(--lumo-error-color-10pct));
    --_disabled-checkmark-color: var(--vaadin-checkbox-disabled-checkmark-color, var(--lumo-contrast-30pct));
  }

  [part='label'] {
    display: flex;
    position: relative;
    max-width: max-content;
  }

  :host([has-label]) ::slotted(label) {
    padding: var(
      --vaadin-checkbox-label-padding,
      var(--lumo-space-xs) var(--lumo-space-s) var(--lumo-space-xs) var(--lumo-space-xs)
    );
  }

  :host([dir='rtl'][has-label]) ::slotted(label) {
    padding: var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-s);
  }

  :host([has-label][required]) ::slotted(label) {
    padding-inline-end: var(--lumo-space-m);
  }

  [part='checkbox'] {
    --_input-size: var(--_checkbox-size);
    margin: var(--lumo-space-xs);
    position: relative;
    border-radius: var(--vaadin-checkbox-border-radius, var(--lumo-border-radius-s));
    background: var(--vaadin-checkbox-background, var(--lumo-contrast-20pct));
    transition:
      transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2),
      background-color 0.15s;
    cursor: var(--lumo-clickable-cursor);
    /* Default field border color */
    --_input-border-color: var(--vaadin-input-field-border-color, var(--lumo-contrast-50pct));
  }

  :host([indeterminate]),
  :host([checked]) {
    --vaadin-input-field-border-color: transparent;
  }

  :host([indeterminate]) [part='checkbox'],
  :host([checked]) [part='checkbox'] {
    background-color: var(--_selection-color);
  }

  /* Used for activation "halo" */
  [part='checkbox']::before {
    pointer-events: none;
    color: transparent;
    width: 100%;
    height: 100%;
    border-radius: inherit;
    background-color: inherit;
    transform: scale(1.4);
    opacity: 0;
    transition:
      transform 0.1s,
      opacity 0.8s;
  }

  /* Checkmark */
  [part='checkbox']::after {
    pointer-events: none;
    font-family: 'lumo-icons';
    content: var(--vaadin-checkbox-checkmark-char, var(--lumo-icons-checkmark));
    color: var(--vaadin-checkbox-checkmark-color, var(--lumo-primary-contrast-color));
    font-size: var(--vaadin-checkbox-checkmark-size, calc(var(--_checkbox-size) + 2px));
    line-height: 1;
    position: absolute;
    top: -1px;
    left: -1px;
    contain: content;
    opacity: 0;
  }

  :host([checked]) [part='checkbox']::after {
    opacity: 1;
  }

  :host([readonly]:not([checked]):not([indeterminate])) {
    color: var(--lumo-secondary-text-color);
  }

  :host([readonly]:not([checked]):not([indeterminate])) [part='checkbox'] {
    background: transparent;
    box-shadow: none;
  }

  :host([readonly]:not([checked]):not([indeterminate])) [part='checkbox']::after {
    content: '';
    box-sizing: border-box;
    width: 100%;
    height: 100%;
    border-radius: inherit;
    top: 0;
    left: 0;
    opacity: 1;
    border: var(--vaadin-input-field-readonly-border, 1px dashed var(--lumo-contrast-50pct));
  }

  /* Indeterminate checkmark */
  :host([indeterminate]) [part='checkbox']::after {
    content: var(--vaadin-checkbox-checkmark-char-indeterminate, '');
    opacity: 1;
    top: 45%;
    height: 10%;
    left: 22%;
    right: 22%;
    width: auto;
    border: 0;
    background-color: var(--lumo-primary-contrast-color);
  }

  /* Focus ring */
  :host([focus-ring]) [part='checkbox'] {
    box-shadow:
      0 0 0 1px var(--lumo-base-color),
      0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color),
      inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color);
  }

  :host([focus-ring][readonly]:not([checked]):not([indeterminate])) [part='checkbox'] {
    box-shadow:
      0 0 0 1px var(--lumo-base-color),
      0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color);
  }

  /* Disabled */
  :host([disabled]) {
    pointer-events: none;
    --vaadin-input-field-border-color: var(--lumo-contrast-20pct);
  }

  :host([disabled]) ::slotted(label) {
    color: inherit;
  }

  :host([disabled]) [part='checkbox'] {
    background-color: var(--vaadin-checkbox-disabled-background, var(--lumo-contrast-10pct));
  }

  :host([disabled]) [part='checkbox']::after {
    color: var(--_disabled-checkmark-color);
  }

  :host([disabled]) [part='label'],
  :host([disabled]) [part='helper-text'] {
    color: var(--lumo-disabled-text-color);
    -webkit-text-fill-color: var(--lumo-disabled-text-color);
  }

  :host([indeterminate][disabled]) [part='checkbox']::after {
    background-color: var(--_disabled-checkmark-color);
  }

  :host([readonly][checked]:not([disabled])) [part='checkbox'],
  :host([readonly][indeterminate]:not([disabled])) [part='checkbox'] {
    background-color: var(--vaadin-checkbox-readonly-checked-background, var(--lumo-contrast-70pct));
  }

  /* Hover */
  :host(:not([checked]):not([indeterminate]):not([disabled]):not([readonly]):not([invalid]):hover) [part='checkbox'] {
    background: var(--vaadin-checkbox-background-hover, var(--lumo-contrast-30pct));
  }

  /* Disable hover for touch devices */
  @media (pointer: coarse) {
    :host(:not([checked]):not([indeterminate]):not([disabled]):not([readonly]):not([invalid]):hover) [part='checkbox'] {
      background: var(--vaadin-checkbox-background, var(--lumo-contrast-20pct));
    }
  }

  /* Active */
  :host([active]) [part='checkbox'] {
    transform: scale(0.9);
    transition-duration: 0.05s;
  }

  :host([active][checked]) [part='checkbox'] {
    transform: scale(1.1);
  }

  :host([active]:not([checked])) [part='checkbox']::before {
    transition-duration: 0.01s, 0.01s;
    transform: scale(0);
    opacity: 0.4;
  }

  /* Required */
  :host([required]) [part='required-indicator'] {
    position: absolute;
    top: var(--lumo-space-xs);
    right: var(--lumo-space-xs);
  }

  :host([required][dir='rtl']) [part='required-indicator'] {
    right: auto;
    left: var(--lumo-space-xs);
  }

  :host([required]) [part='required-indicator']::after {
    content: var(--lumo-required-field-indicator, '\\2022');
    transition: opacity 0.2s;
    color: var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));
    width: 1em;
    text-align: center;
  }

  :host(:not([has-label])) [part='required-indicator'] {
    display: none;
  }

  /* Invalid */
  :host([invalid]) {
    --vaadin-input-field-border-color: var(--lumo-error-color);
  }

  :host([invalid]) [part='checkbox'] {
    background-color: var(--_invalid-background);
    background-image: linear-gradient(var(--_invalid-background) 0%, var(--_invalid-background) 100%);
  }

  :host([invalid]:hover) [part='checkbox'] {
    background-image:
      linear-gradient(var(--_invalid-background) 0%, var(--_invalid-background) 100%),
      linear-gradient(var(--_invalid-background) 0%, var(--_invalid-background) 100%);
  }

  :host([invalid][focus-ring]) {
    --_focus-ring-color: var(--lumo-error-color-50pct);
  }

  :host([invalid]) [part='required-indicator']::after {
    color: var(--lumo-required-field-indicator-color, var(--lumo-error-text-color));
  }

  /* Error message */
  [part='error-message'] {
    font-size: var(--vaadin-input-field-error-font-size, var(--lumo-font-size-xs));
    line-height: var(--lumo-line-height-xs);
    font-weight: var(--vaadin-input-field-error-font-weight, 400);
    color: var(--vaadin-input-field-error-color, var(--lumo-error-text-color));
    will-change: max-height;
    transition: 0.4s max-height;
    max-height: 5em;
    padding-inline-start: var(--lumo-space-xs);
  }

  [part='helper-text'],
  [part='error-message'] {
    grid-column: 2;
  }

  :host(:not([has-helper])) [part='helper-text'],
  :host(:not([has-error-message])) [part='error-message'] {
    display: none;
  }

  :host([has-error-message]) [part='error-message']::after,
  :host([has-helper]) [part='helper-text']::after {
    content: '';
    display: block;
    height: 0.4em;
  }

  :host(:not([invalid])) [part='error-message'] {
    max-height: 0;
    overflow: hidden;
  }

  /* Helper */
  [part='helper-text'] {
    display: block;
    color: var(--vaadin-input-field-helper-color, var(--lumo-secondary-text-color));
    font-size: var(--vaadin-input-field-helper-font-size, var(--lumo-font-size-xs));
    line-height: var(--lumo-line-height-xs);
    font-weight: var(--vaadin-input-field-helper-font-weight, 400);
    margin-left: calc(var(--lumo-border-radius-m) / 4);
    transition: color 0.2s;
    padding-inline-start: var(--lumo-space-xs);
  }

  :host(:hover:not([readonly])) [part='helper-text'] {
    color: var(--lumo-body-text-color);
  }

  :host([has-error-message]) ::slotted(label),
  :host([has-helper]) ::slotted(label) {
    padding-bottom: 0;
  }

  @media (forced-colors: active) {
    [part='checkbox'] {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([disabled]) [part='checkbox'],
    :host([disabled]) [part='checkbox']::after {
      outline-color: GrayText;
    }

    :host(:is([checked], [indeterminate])) [part='checkbox']::after {
      outline: 1px solid;
      outline-offset: -1px;
      border-radius: inherit;
    }

    :host([focused]) [part='checkbox'],
    :host([focused]) [part='checkbox']::after {
      outline-width: 2px;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-checkbox-lumo-inject: 1;
  --vaadin-checkbox-lumo-inject-modules:
    lumo_mixins_checkable-field,
    lumo_components_checkbox;
}
:is(:root, :host)::before {
  --vaadin-checkbox-group-lumo-inject: 1;
  --vaadin-checkbox-group-lumo-inject-modules:
    lumo_mixins_group-field,
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-helper,
    lumo_components_checkbox-group;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_combo-box-loader {
  [part='loader'] {
    position: absolute;
    z-index: 1;
    inset-inline: var(--lumo-space-s);
    top: var(--lumo-space-s);
    margin-inline: auto 0;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_combo-box-overlay {
  [part='content'] {
    display: flex;
    flex-direction: column;
    height: 100%;
    padding: 0;
  }

  /* When items are empty, the spinner needs some room */
  :host(:not([closing])) [part='content'] {
    min-height: calc(2 * var(--lumo-space-s) + var(--lumo-icon-size-s));
  }

  [part='overlay'] {
    position: relative;
  }

  :host([top-aligned]) [part='overlay'] {
    margin-top: var(--lumo-space-xs);
  }

  :host([bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--lumo-space-xs);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_field-base {
  :host {
    display: inline-flex;
    outline: none;
    --lumo-text-field-size: var(--lumo-size-m);
    color: var(--vaadin-input-field-value-color, var(--lumo-body-text-color));
    font-size: var(--vaadin-input-field-value-font-size, var(--lumo-font-size-m));
    font-family: var(--lumo-font-family);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: transparent;
    padding: var(--lumo-space-xs) 0;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_input-height: var(--vaadin-input-field-height, var(--lumo-text-field-size));
    --_disabled-value-color: var(--vaadin-input-field-disabled-value-color, var(--lumo-disabled-text-color));
  }

  :host::before {
    content: '\\2003';
    width: 0;
    /* Size and position this element on the same vertical position as the input-field element
          to make vertical align for the host element work as expected */
    height: var(--_input-height);
    box-sizing: border-box;
    display: inline-flex;
    align-items: center;
  }

  [class$='container'] {
    display: flex;
    flex-direction: column;
    min-width: 100%;
    max-width: 100%;
    width: var(--vaadin-field-default-width, 12em);
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([focused]) [part='input-field'] ::slotted(:is(input, textarea)) {
    mask-image: none;
  }

  ::slotted(:is(input, textarea):placeholder-shown) {
    color: var(--vaadin-input-field-placeholder-color, var(--lumo-secondary-text-color));
  }

  /* Hover */
  :host(:hover:not([readonly]):not([focused]):not([disabled])) [part='input-field']::after {
    opacity: var(--vaadin-input-field-hover-highlight-opacity, 0.1);
  }

  /* Touch device adjustment */
  @media (pointer: coarse) {
    :host(:hover:not([readonly]):not([focused]):not([disabled])) [part='input-field']::after {
      opacity: 0;
    }

    :host(:active:not([readonly]):not([focused]):not([disabled])) [part='input-field']::after {
      opacity: 0.2;
    }
  }

  /* Trigger when not focusing using the keyboard */
  :host([focused]:not([focus-ring]):not([readonly])) [part='input-field']::after {
    transform: scaleX(0);
    transition-duration: 0.15s, 1s;
  }

  /* Opt-in focus-ring when using pointer devices */
  /* This applies a focus-ring as box-shadow when the element is focused, but
   the ring is only visible / has a width when the respective CSS property is
   "enabled" using a value of 1 */
  :host([focused]) [part='input-field'] {
    /* Borders are implemented using box-shadows as well. To avoid overriding
     the border on focus, even if the pointer focus-ring is disabled, we need to:
     - Duplicate the border box shadow for this rule
     - Remove the border (by using width of 0) when the focus-ring is visible,
       which is the same behavior as for the keyboard focus-ring below
     - Apply the border when the focus ring is not visible
  */
    --_pointer-focus-visible: clamp(0, var(--lumo-input-field-pointer-focus-visible, 0), 1);
    --_conditional-border-width: calc(calc(1 - var(--_pointer-focus-visible)) * var(--_input-border-width));
    --_conditional-focus-ring-width: calc(var(--_pointer-focus-visible) * var(--_focus-ring-width));
    box-shadow:
      inset 0 0 0 var(--_conditional-border-width) var(--_input-border-color),
      0 0 0 var(--_conditional-focus-ring-width) var(--_focus-ring-color);
  }

  /* Focus-ring when using keyboard navigation */
  :host([focus-ring]) [part='input-field'] {
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  /* Read-only and disabled */
  :host(:is([readonly], [disabled])) ::slotted(:is(input, textarea):placeholder-shown) {
    opacity: 0;
  }

  /* Read-only style */
  :host([readonly]) {
    --vaadin-input-field-border-color: transparent;
  }

  /* Disabled style */
  :host([disabled]) {
    pointer-events: none;
    --vaadin-input-field-border-color: var(--lumo-contrast-20pct);
  }

  :host([disabled]) [part='label'],
  :host([disabled]) [part='input-field'] ::slotted([slot$='fix']) {
    color: var(--lumo-disabled-text-color);
    -webkit-text-fill-color: var(--lumo-disabled-text-color);
  }

  :host([disabled]) [part='input-field'] ::slotted(:not([slot$='fix'])) {
    color: var(--_disabled-value-color);
    -webkit-text-fill-color: var(--_disabled-value-color);
  }

  /* Invalid style */
  :host([invalid]) {
    --vaadin-input-field-border-color: var(--lumo-error-color);
    --_focus-ring-color: var(--lumo-error-color-50pct);
  }

  :host([input-prevented]) [part='input-field'] {
    animation: shake 0.15s infinite;
  }

  @keyframes shake {
    25% {
      transform: translateX(4px);
    }

    75% {
      transform: translateX(-4px);
    }
  }

  /* Small theme */
  :host([theme~='small']) {
    font-size: var(--lumo-font-size-s);
    --lumo-text-field-size: var(--lumo-size-s);
  }

  :host([theme~='small']) [part='label'] {
    font-size: var(--lumo-font-size-xs);
  }

  :host([theme~='small']) [part='error-message'] {
    font-size: var(--lumo-font-size-xxs);
  }

  /* Slotted content */
  [part='input-field'] ::slotted(:not(vaadin-icon):not(input):not(textarea)) {
    color: var(--lumo-secondary-text-color);
    font-weight: 400;
  }

  [part='clear-button']::before {
    content: var(--lumo-icons-cross);
  }

  @media (forced-colors: active) {
    :host(:not([readonly])) [part='input-field'] {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([focused]) [part='input-field'] {
      outline-width: 2px;
    }

    :host([disabled]) [part='input-field'] {
      outline-color: GrayText;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_field-button {
  [part$='button'] {
    flex: none;
    width: 1em;
    height: 1em;
    line-height: 1;
    font-size: var(--lumo-icon-size-m);
    text-align: center;
    color: var(--lumo-contrast-60pct);
    transition: 0.2s color;
    cursor: var(--lumo-clickable-cursor);
  }

  [part$='button']:hover {
    color: var(--lumo-contrast-90pct);
  }

  :host([disabled]) [part$='button'],
  :host([readonly]) [part$='button'] {
    color: var(--lumo-contrast-20pct);
    cursor: default;
  }

  [part$='button']::before {
    font-family: 'lumo-icons';
    display: block;
  }

  [part='clear-button'] {
    display: none;
    cursor: default;
  }

  [part='clear-button']::before {
    content: '\\2715';
  }

  :host([clear-button-visible][has-value]:not([disabled]):not([readonly])) [part='clear-button'] {
    display: block;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_loader {
  [part='loader'] {
    box-sizing: border-box;
    width: var(--lumo-icon-size-s);
    height: var(--lumo-icon-size-s);
    border: 2px solid transparent;
    border-color: var(--lumo-primary-color-10pct) var(--lumo-primary-color-10pct) var(--lumo-primary-color)
      var(--lumo-primary-color);
    border-radius: calc(0.5 * var(--lumo-icon-size-s));
    opacity: 0;
    pointer-events: none;
  }

  :host(:not([loading])) [part='loader'] {
    display: none;
  }

  :host([loading]) [part='loader'] {
    animation:
      1s linear infinite lumo-loader-rotate,
      0.3s 0.1s lumo-loader-fade-in both;
  }

  @keyframes lumo-loader-fade-in {
    0% {
      opacity: 0;
    }

    100% {
      opacity: 1;
    }
  }

  @keyframes lumo-loader-rotate {
    0% {
      transform: rotate(0deg);
    }

    100% {
      transform: rotate(360deg);
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_combo-box-item {
  :host {
    transition: background-color 100ms;
    overflow: hidden;
    --_lumo-item-selected-icon-display: block;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([focused]:not([disabled])) {
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_combo-box-overlay {
  :host {
    --_vaadin-combo-box-items-container-border-width: var(--lumo-space-xs);
    --_vaadin-combo-box-items-container-border-style: solid;
  }

  #overlay {
    width: var(--vaadin-combo-box-overlay-width, var(--_vaadin-combo-box-overlay-default-width, auto));
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_combo-box {
  :host([opened]) {
    pointer-events: auto;
  }

  [part='toggle-button']::before {
    content: var(--lumo-icons-dropdown);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_input-container {
  :host {
    display: flex;
    align-items: center;
    flex: 0 1 auto;
    --_border-radius: var(--vaadin-input-field-border-radius, 0);
    --_input-border-width: var(--vaadin-input-field-border-width, 0px);
    box-shadow: inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color);
    background: var(--_background);
    padding: 0 calc(0.375em + var(--_input-container-radius) / 4 - 1px);
    font-weight: var(--vaadin-input-field-value-font-weight, 500);
    line-height: 1;
    position: relative;
    cursor: text;
    box-sizing: border-box;
    border-radius:
    /* See https://developer.mozilla.org/en-US/docs/Web/CSS/border-radius#syntax */
      var(--vaadin-input-field-top-start-radius, var(--_input-container-radius))
      var(--vaadin-input-field-top-end-radius, var(--_input-container-radius))
      var(--vaadin-input-field-bottom-end-radius, var(--_input-container-radius))
      var(--vaadin-input-field-bottom-start-radius, var(--_input-container-radius));
    /* Fallback */
    --_input-container-radius: var(--vaadin-input-field-border-radius, var(--lumo-border-radius-m));
    --_input-height: var(--lumo-text-field-size, var(--lumo-size-m));
    /* Default values */
    --_background: var(--vaadin-input-field-background, var(--lumo-contrast-10pct));
    --_hover-highlight: var(--vaadin-input-field-hover-highlight, var(--lumo-contrast-50pct));
    --_input-border-color: var(--vaadin-input-field-border-color, var(--lumo-contrast-50pct));
    --_icon-color: var(--vaadin-input-field-icon-color, var(--lumo-contrast-60pct));
    --_icon-size: var(--vaadin-input-field-icon-size, var(--lumo-icon-size-m));
    --_invalid-background: var(--vaadin-input-field-invalid-background, var(--lumo-error-color-10pct));
    --_invalid-hover-highlight: var(--vaadin-input-field-invalid-hover-highlight, var(--lumo-error-color-50pct));
    --_disabled-background: var(--vaadin-input-field-disabled-background, var(--lumo-contrast-5pct));
    --_disabled-value-color: var(--vaadin-input-field-disabled-value-color, var(--lumo-disabled-text-color));
  }

  :host([dir='rtl']) {
    border-radius:
    /* Don't use logical props, see https://github.com/vaadin/vaadin-time-picker/issues/145 */
      var(--vaadin-input-field-top-end-radius, var(--_input-container-radius))
      var(--vaadin-input-field-top-start-radius, var(--_input-container-radius))
      var(--vaadin-input-field-bottom-start-radius, var(--_input-container-radius))
      var(--vaadin-input-field-bottom-end-radius, var(--_input-container-radius));
  }

  /* Used for hover and activation effects */
  :host::after {
    content: '';
    position: absolute;
    inset: 0;
    border-radius: inherit;
    pointer-events: none;
    background: var(--_hover-highlight);
    opacity: 0;
    transition:
      transform 0.15s,
      opacity 0.2s;
    transform-origin: 100% 0;
  }

  :host([hidden]) {
    display: none !important;
  }

  /* Reset the native input styles */
  ::slotted(input) {
    appearance: none;
    flex: auto;
    white-space: nowrap;
    overflow: hidden;
    width: 100%;
    height: 100%;
    outline: none;
    margin: 0;
    padding: 0;
    border: 0;
    border-radius: 0;
    min-width: 0;
    font: inherit;
    line-height: normal;
    color: inherit;
    background-color: transparent;
    /* Disable default invalid style in Firefox */
    box-shadow: none;
  }

  ::slotted(*) {
    flex: none;
  }

  ::slotted(:is(input, textarea))::placeholder {
    /* Use ::slotted(input:placeholder-shown) in themes to style the placeholder. */
    /* because ::slotted(...)::placeholder does not work in Safari. */
    font: inherit;
    color: inherit;
    /* Override default opacity in Firefox */
    opacity: 1;
  }

  ::slotted(:not([slot$='fix'])) {
    cursor: inherit;
    min-height: var(--vaadin-input-field-height, var(--_input-height));
    padding: 0 0.25em;
    --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);
    mask-image: var(--_lumo-text-field-overflow-mask-image);
  }

  /* Read-only */
  :host([readonly]) {
    color: var(--lumo-secondary-text-color);
    background-color: transparent;
    cursor: default;
  }

  :host([readonly])::after {
    background-color: transparent;
    opacity: 1;
    border: var(--vaadin-input-field-readonly-border, 1px dashed var(--lumo-contrast-30pct));
  }

  /* Disabled */
  :host([disabled]) {
    background: var(--_disabled-background);
  }

  :host([disabled]) ::slotted(:not([slot$='fix'])) {
    -webkit-text-fill-color: var(--_disabled-value-color);
    color: var(--_disabled-value-color);
  }

  /* Invalid */
  :host([invalid]) {
    background: var(--_invalid-background);
  }

  :host([invalid]:not([readonly]))::after {
    background: var(--_invalid-hover-highlight);
  }

  /* Slotted icons */
  ::slotted(vaadin-icon) {
    color: var(--_icon-color);
    width: var(--_icon-size);
    height: var(--_icon-size);
  }

  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */
  ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: 0.25em;
    box-sizing: border-box !important;
  }

  /* Text align */
  :host([dir='rtl']) ::slotted(:not([slot$='fix'])) {
    --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent, #000 1.25em);
  }

  @-moz-document url-prefix() {
    :host([dir='rtl']) ::slotted(:not([slot$='fix'])) {
      mask-image: var(--_lumo-text-field-overflow-mask-image);
    }
  }

  :host([theme~='align-left']) ::slotted(:not([slot$='fix'])) {
    text-align: start;
    --_lumo-text-field-overflow-mask-image: none;
  }

  :host([theme~='align-center']) ::slotted(:not([slot$='fix'])) {
    text-align: center;
    --_lumo-text-field-overflow-mask-image: none;
  }

  :host([theme~='align-right']) ::slotted(:not([slot$='fix'])) {
    text-align: end;
    --_lumo-text-field-overflow-mask-image: none;
  }

  @-moz-document url-prefix() {
    /* Firefox is smart enough to align overflowing text to right */
    :host([theme~='align-right']) ::slotted(:not([slot$='fix'])) {
      --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent 0.25em, #000 1.5em);
    }
  }

  @-moz-document url-prefix() {
    /* Firefox is smart enough to align overflowing text to right */
    :host([theme~='align-left']) ::slotted(:not([slot$='fix'])) {
      --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent 0.25em, #000 1.5em);
    }
  }

  /* RTL specific styles */
  :host([dir='rtl'])::after {
    transform-origin: 0% 0;
  }

  :host([theme~='align-left'][dir='rtl']) ::slotted(:not([slot$='fix'])) {
    --_lumo-text-field-overflow-mask-image: none;
  }

  :host([theme~='align-center'][dir='rtl']) ::slotted(:not([slot$='fix'])) {
    --_lumo-text-field-overflow-mask-image: none;
  }

  :host([theme~='align-right'][dir='rtl']) ::slotted(:not([slot$='fix'])) {
    --_lumo-text-field-overflow-mask-image: none;
  }

  @-moz-document url-prefix() {
    /* Firefox is smart enough to align overflowing text to right */
    :host([theme~='align-right'][dir='rtl']) ::slotted(:not([slot$='fix'])) {
      --_lumo-text-field-overflow-mask-image: linear-gradient(to right, transparent 0.25em, #000 1.5em);
    }
  }

  @-moz-document url-prefix() {
    /* Firefox is smart enough to align overflowing text to right */
    :host([theme~='align-left'][dir='rtl']) ::slotted(:not([slot$='fix'])) {
      --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent 0.25em, #000 1.5em);
    }
  }
}
:is(:root, :host)::before {
  --vaadin-input-container-lumo-inject: 1;
  --vaadin-input-container-lumo-inject-modules: lumo_components_input-container;
}
:is(:root, :host)::before {
  --vaadin-combo-box-lumo-inject: 1;
  --vaadin-combo-box-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_combo-box;

  --vaadin-combo-box-item-lumo-inject: 1;
  --vaadin-combo-box-item-lumo-inject-modules:
    lumo_components_item,
    lumo_components_combo-box-item;

  --vaadin-combo-box-overlay-lumo-inject: 1;
  --vaadin-combo-box-overlay-lumo-inject-modules:
    lumo_mixins_loader,
    lumo_mixins_combo-box-loader,
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_mixins_combo-box-overlay,
    lumo_components_combo-box-overlay;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_confirm-dialog-overlay {
  [part='header'] {
    pointer-events: auto;
    margin-inline-start: calc(var(--lumo-space-l) - var(--lumo-space-m));
    font-weight: 600;
    line-height: var(--lumo-line-height-xs);
    font-size: var(--lumo-font-size-xl);
    color: var(--lumo-header-text-color);
  }

  ::slotted([slot='header']) {
    display: contents !important;
    font: inherit !important;
    color: inherit !important;
  }

  /* Make buttons clickable */
  [part='footer'] > * {
    pointer-events: all;
  }

  [part='message'] {
    width: 25em;
    min-width: 100%;
    max-width: 100%;
  }

  ::slotted([slot$='button'][theme~='tertiary']) {
    padding-left: var(--lumo-space-s);
    padding-right: var(--lumo-space-s);
  }

  [part='cancel-button'] {
    flex-grow: 1;
  }

  @media (max-width: 360px) {
    [part='footer'] {
      flex-direction: column-reverse;
      align-items: stretch;
      padding: var(--lumo-space-s) var(--lumo-space-l);
      gap: var(--lumo-space-s);
    }

    ::slotted([slot$='button']) {
      width: 100%;
      margin: 0;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_dialog-overlay {
  [part='header'],
  [part='header-content'],
  [part='footer'] {
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    flex: none;
    pointer-events: none;
    z-index: 1;
    gap: var(--lumo-space-xs) var(--lumo-space-s);
    line-height: var(--lumo-line-height-s);
  }

  [part='header'] {
    flex-wrap: nowrap;
    padding: var(--lumo-space-m);
    background-color: var(--lumo-base-color);
    border-radius: var(--lumo-border-radius-l) var(--lumo-border-radius-l) 0 0; /* Needed for Safari */
  }

  [part='footer'] {
    padding: var(--lumo-space-s) var(--lumo-space-m);
    background-color: var(--lumo-contrast-5pct);
    border-radius: 0 0 var(--lumo-border-radius-l) var(--lumo-border-radius-l); /* Needed for Safari */
  }

  [part='title'] {
    font-size: var(--lumo-font-size-xl);
    font-weight: 600;
    color: var(--lumo-header-text-color);
    margin-inline-start: calc(var(--lumo-space-l) - var(--lumo-space-m));
  }

  ::slotted([slot='header-content']),
  ::slotted([slot='title']),
  ::slotted([slot='footer']) {
    display: contents;
    pointer-events: auto;
  }

  ::slotted([slot='title']) {
    font: inherit !important;
    overflow-wrap: anywhere;
  }

  [part='header-content'] {
    flex: 1;
  }

  :host([has-title]) [part='header-content'],
  [part='footer'] {
    justify-content: flex-end;
  }

  :host(:not([has-title]):not([has-header])) [part='header'],
  :host(:not([has-header])) [part='header-content'],
  :host(:not([has-title])) [part='title'],
  :host(:not([has-footer])) [part='footer'] {
    display: none !important;
  }

  :host(:is([has-title], [has-header], [has-footer])) [part='content'] {
    height: auto;
  }

  /*
  NOTE(platosha): Make some min-width to prevent collapsing of the content
  taking the parent width, e. g., <vaadin-grid> and such.
*/
  [part='content'] {
    min-width: 12em; /* matches the default <vaadin-text-field> width */
    padding: var(--lumo-space-l);
    flex: 1;
    min-height: 0;
  }

  :host([overflow]) [part='content'] {
    overflow: auto;
  }

  :host([overflow~='top']) [part='header'] {
    box-shadow: 0 1px 0 0 var(--lumo-contrast-10pct);
  }

  :host([has-bounds-set]) [part='overlay'] {
    max-width: none;
  }

  /* Optical centering */
  :host::before,
  :host::after {
    content: '';
    flex-basis: 0;
    flex-grow: 1;
  }

  :host::after {
    flex-grow: 1.1;
  }

  [part='overlay'] {
    border-radius: var(--lumo-border-radius-l);
    box-shadow:
      0 0 0 1px var(--lumo-shade-5pct),
      var(--lumo-box-shadow-xl);
    background-image: none;
    outline: none;
    -webkit-tap-highlight-color: transparent;
  }

  :host(:is([has-header], [has-title])) [part='header'] + [part='content'] {
    padding-top: 0;
  }

  /* No padding */
  :host([theme~='no-padding']) [part='content'] {
    padding: 0 !important;
  }

  /* Animations */

  :host([opening]),
  :host([closing]) {
    animation: 0.25s lumo-overlay-dummy-animation;
  }

  :host([opening]) [part='overlay'] {
    animation: 0.12s 0.05s vaadin-dialog-enter cubic-bezier(0.215, 0.61, 0.355, 1) both;
  }

  @keyframes vaadin-dialog-enter {
    0% {
      opacity: 0;
      transform: scale(0.95);
    }
  }

  :host([closing]) [part='overlay'] {
    animation: 0.1s 0.03s vaadin-dialog-exit cubic-bezier(0.55, 0.055, 0.675, 0.19) both;
  }

  :host([closing]) [part='backdrop'] {
    animation-delay: 0.05s;
  }

  @keyframes vaadin-dialog-exit {
    100% {
      opacity: 0;
      transform: scale(1.02);
    }
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 3px solid !important;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-confirm-dialog-overlay-lumo-inject: 1;
  --vaadin-confirm-dialog-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_components_dialog-overlay,
    lumo_components_confirm-dialog-overlay;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_menu-overlay-ext {
  /* Small viewport (bottom sheet) styles */
  /* Use direct media queries instead of the state attributes ([phone] and [fullscreen]) provided by the elements */
  @media (max-width: 450px), (max-height: 450px) {
    :host {
      inset: 0 0 var(--vaadin-overlay-viewport-bottom, 0) 0 !important;
      align-items: stretch !important;
      justify-content: flex-end !important;
    }

    [part='overlay'] {
      max-height: 50vh;
      width: 100vw;
      border-radius: 0;
      box-shadow: var(--lumo-box-shadow-xl);
    }

    /* The content part scrolls instead of the overlay part, because of the gradient fade-out */
    [part='content'] {
      padding: 30px var(--lumo-space-m);
      max-height: inherit;
      box-sizing: border-box;
      overflow: auto;
      mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
    }

    [part='backdrop'] {
      display: block;
    }

    /* Animations */

    :host([opening]) [part='overlay'] {
      animation: 0.2s lumo-mobile-menu-overlay-enter cubic-bezier(0.215, 0.61, 0.355, 1) both;
    }

    :host([closing]),
    :host([closing]) [part='backdrop'] {
      animation-delay: 0.14s;
    }

    :host([closing]) [part='overlay'] {
      animation: 0.14s 0.14s lumo-mobile-menu-overlay-exit cubic-bezier(0.55, 0.055, 0.675, 0.19) both;
    }
  }

  @keyframes lumo-mobile-menu-overlay-enter {
    0% {
      transform: translateY(150%);
    }
  }

  @keyframes lumo-mobile-menu-overlay-exit {
    100% {
      transform: translateY(150%);
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_context-menu-item {
  /* :hover needed to workaround https://github.com/vaadin/web-components/issues/3133 */
  :host(:hover) {
    user-select: none;
    -webkit-user-select: none;
  }

  :host([role='menuitem'][menu-item-checked]) [part='checkmark']::before {
    opacity: 1;
  }

  :host([aria-haspopup='true'])::after {
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-xs);
    content: var(--lumo-icons-angle-right);
    color: var(--lumo-tertiary-text-color);
  }

  :host(:not([dir='rtl'])[aria-haspopup='true'])::after {
    margin-right: calc(var(--lumo-space-m) * -1);
    padding-left: var(--lumo-space-m);
  }

  :host([expanded]) {
    background-color: var(--lumo-primary-color-10pct);
  }

  /* RTL styles */
  :host([dir='rtl'][aria-haspopup='true'])::after {
    content: var(--lumo-icons-angle-left);
    margin-left: calc(var(--lumo-space-m) * -1);
    padding-right: var(--lumo-space-m);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_context-menu-list-box {
  :host {
    --_lumo-list-box-item-selected-icon-display: block;
  }

  /* Normal item */
  [part='items'] ::slotted([role='menuitem']) {
    -webkit-tap-highlight-color: var(--lumo-primary-color-10pct);
    cursor: default;
    outline: none;
    border-radius: var(--lumo-border-radius-m);
    padding-left: calc(var(--lumo-border-radius-m) / 4);
    padding-right: calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);
  }

  /* Hovered item */
  /* TODO a workaround until we have "focus-follows-mouse". After that, use the hover style for focus-ring as well */
  [part='items'] ::slotted([role='menuitem']:hover:not([disabled])),
  [part='items'] ::slotted([role='menuitem'][expanded]:not([disabled])) {
    background-color: var(--lumo-primary-color-10pct);
  }

  /* RTL styles */
  :host([dir='rtl']) [part='items'] ::slotted([role='menuitem']) {
    padding-left: calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);
    padding-right: calc(var(--lumo-border-radius-m) / 4);
  }

  /* Focused item */
  @media (pointer: coarse) {
    [part='items'] ::slotted([role='menuitem']:hover:not([expanded]):not([disabled])) {
      background-color: transparent;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_context-menu-overlay {
  :host {
    align-items: flex-start;
    justify-content: flex-start;
    /* TODO These style overrides should not be needed.
     We should instead offer a way to have non-selectable items inside the context menu. */
    --_lumo-list-box-item-selected-icon-display: none;
    --_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4);
  }

  :host([right-aligned]),
  :host([end-aligned]) {
    align-items: flex-end;
  }

  :host([bottom-aligned]) {
    justify-content: flex-end;
  }

  [part='overlay'] {
    background-color: #fff;
    outline: none;
  }

  :host([phone]) {
    inset: 0 0 var(--vaadin-overlay-viewport-bottom, 0) 0 !important;
    align-items: stretch;
    justify-content: flex-end;
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 3px solid !important;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-context-menu-overlay-lumo-inject: 1;
  --vaadin-context-menu-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_mixins_menu-overlay-ext,
    lumo_components_context-menu-overlay;

  --vaadin-context-menu-list-box-lumo-inject: 1;
  --vaadin-context-menu-list-box-lumo-inject-modules:
    lumo_components_list-box,
    lumo_components_context-menu-list-box;

  --vaadin-context-menu-item-lumo-inject: 1;
  --vaadin-context-menu-item-lumo-inject-modules:
    lumo_components_item,
    lumo_components_context-menu-item;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_crud-dialog-overlay {
  [part='overlay'] {
    max-width: 54em;
    min-width: 20em;
    display: flex;
  }

  .resizer-container {
    display: flex;
    flex-direction: column;
    flex-grow: 1;
  }

  [part='footer'] {
    justify-content: flex-start;
    flex-direction: row-reverse;
  }

  /* Make buttons clickable */
  [part='footer'] ::slotted(:not([disabled])) {
    pointer-events: all;
  }

  :host([fullscreen]) {
    inset: 0;
    padding: 0;
  }

  :host([fullscreen]) [part='overlay'] {
    height: 100vh;
    width: 100vw;
    border-radius: 0 !important;
  }

  :host([fullscreen]) [part='content'] {
    flex: 1;
  }

  [part='header'] ::slotted(h3) {
    margin-top: 0 !important;
    margin-bottom: 0 !important;
    margin-inline-start: var(--lumo-space-s);
  }

  :host(:not([dir='rtl'])) ::slotted([slot='delete-button']) {
    margin-right: auto;
  }

  :host([dir='rtl']) ::slotted([slot='delete-button']) {
    margin-left: auto;
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_crud-edit {
  :host {
    display: block;
    min-width: auto;
    margin: 0;
    font-family: 'lumo-icons', var(--lumo-font-family);
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    position: relative;
    width: var(--lumo-size-s);
    height: var(--lumo-size-s);
    outline: none;
  }

  [part='icon']::before {
    content: var(--lumo-icons-edit);
    width: var(--lumo-size-m);
    height: var(--lumo-size-m);
    line-height: var(--lumo-size-m);
    text-align: center;
    position: absolute;
    top: calc((var(--lumo-size-m) - var(--lumo-size-s)) / -2);
    left: calc((var(--lumo-size-m) - var(--lumo-size-s)) / -2);
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_crud {
  :host {
    --vaadin-crud-editor-max-height: 40%;
    --vaadin-crud-editor-max-width: 40%;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    width: 100%;
    height: 400px;
    font-family: var(--lumo-font-family);
  }

  :host,
  #main {
    display: flex;
    flex-direction: column;
    align-self: stretch;
    position: relative;
    overflow: hidden;
  }

  #main {
    flex: 1 1 100%;
    height: 100%;
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  [part='toolbar'] {
    display: flex;
    flex-shrink: 0;
    align-items: baseline;
    justify-content: flex-end;
    padding: var(--lumo-space-s) var(--lumo-space-m);
    background-color: var(--lumo-contrast-5pct);
    border-right: 1px solid var(--lumo-contrast-10pct);
    border-left: 1px solid var(--lumo-contrast-10pct);
    border-bottom: 1px solid var(--lumo-contrast-10pct);
  }

  :host([no-toolbar]) [part='toolbar'] {
    display: none;
  }

  #container {
    display: flex;
    height: 100%;
  }

  :host([editor-position='bottom']) #container {
    flex-direction: column;
  }

  [part='editor'] {
    z-index: 1;
    display: flex;
    flex-direction: column;
    height: 100%;
    outline: none;
    background: var(--lumo-base-color);
    box-sizing: border-box;
    position: relative;
  }

  :host(:not([editor-position=''])[editor-opened]:not([fullscreen])) [part='editor'] {
    flex: 1 0 100%;
  }

  :host([editor-position='bottom'][editor-opened]:not([fullscreen])) [part='editor'] {
    max-height: var(--vaadin-crud-editor-max-height);
  }

  :host([editor-position='aside'][editor-opened]:not([fullscreen])) [part='editor'] {
    min-width: 300px;
    max-width: var(--vaadin-crud-editor-max-width);
  }

  [part='scroller'] {
    display: flex;
    flex-direction: column;
    overflow: auto;
    flex: auto;
    padding: var(--lumo-space-l);
  }

  [part='footer'] {
    display: flex;
    flex: none;
    flex-direction: row-reverse;
    background-color: var(--lumo-contrast-5pct);
    padding: var(--lumo-space-s);
  }

  [part='header'] ::slotted(h3) {
    margin-top: 0 !important;
  }

  :host(:not([dir='rtl'])) ::slotted([slot='delete-button']) {
    margin-right: auto;
  }

  :host([dir='rtl']) ::slotted([slot='delete-button']) {
    margin-left: auto;
  }

  :host(:not([dir='rtl'])) [part='toolbar'] ::slotted(*:not(:first-child)) {
    margin-left: var(--lumo-space-s);
  }

  :host([dir='rtl']) [part='toolbar'] ::slotted(*:not(:first-child)) {
    margin-right: var(--lumo-space-s);
  }

  :host([theme~='no-border']) [part='toolbar'] {
    border: 0;
  }

  [part='footer'] ::slotted(*) {
    margin-left: var(--lumo-space-s);
    margin-right: var(--lumo-space-s);
  }

  [part='editor']:focus::before {
    position: absolute;
    inset: 0;
    content: '';
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
    pointer-events: none;
  }

  :host(:not([editor-position=''])) [part='editor']:not([hidden]) {
    box-shadow: var(--lumo-box-shadow-m);
  }

  :host(:not([theme~='no-border']):not([editor-position=''])) [part='editor']:not([hidden]) {
    border: 1px solid var(--lumo-contrast-20pct);
  }

  :host(:not([theme~='no-border'])[editor-position='bottom']) [part='editor']:not([hidden]) {
    border-top: 0;
  }

  :host(:not([dir='rtl'])[editor-position='aside']) [part='editor']:not([hidden]) {
    border-left: 0;
  }

  :host([dir='rtl']:not([theme~='no-border'])[editor-position='aside']) [part='editor']:not([hidden]) {
    border-right: 0;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_form-layout {
  :host {
    --vaadin-form-layout-column-spacing: var(--lumo-space-l);
    --vaadin-form-layout-row-spacing: 0;
    --vaadin-form-layout-label-spacing: 1em;
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_grid {
  @keyframes vaadin-grid-appear {
    to {
      opacity: 1;
    }
  }

  :host {
    display: flex;
    flex-direction: column;
    animation: 1ms vaadin-grid-appear;
    height: 400px;
    min-height: var(--_grid-min-height, 0);
    flex: 1 1 auto;
    align-self: stretch;
    position: relative;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-s);
    color: var(--lumo-body-text-color);
    background-color: var(--lumo-base-color);
    box-sizing: border-box;
    -webkit-text-size-adjust: 100%;
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    /* For internal use only */
    --_lumo-grid-border-color: var(--lumo-contrast-20pct);
    --_lumo-grid-secondary-border-color: var(--lumo-contrast-10pct);
    --_lumo-grid-border-width: 1px;
    --_lumo-grid-selected-row-color: var(--lumo-primary-color-10pct);
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: none;
    opacity: 0.7;
  }

  #scroller {
    display: flex;
    flex-direction: column;
    min-height: 100%;
    transform: translateY(0);
    width: auto;
    height: auto;
    position: absolute;
    inset: 0;
  }

  :host([all-rows-visible]) {
    height: auto;
    align-self: flex-start;
    min-height: auto;
    flex-grow: 0;
    width: 100%;
  }

  :host([all-rows-visible]) #scroller {
    width: 100%;
    height: 100%;
    position: relative;
  }

  :host([all-rows-visible]) #items {
    min-height: 1px;
  }

  #table {
    display: flex;
    flex-direction: column;
    width: 100%;
    height: 100%;
    overflow: auto;
    position: relative;
    outline: none;
    /* Workaround for a Desktop Safari bug: new stacking context here prevents the scrollbar from getting hidden */
    z-index: 0;
  }

  #header,
  #footer {
    display: block;
    position: sticky;
    left: 0;
    overflow: visible;
    width: 100%;
    z-index: 1;
  }

  #header {
    top: 0;
  }

  th {
    text-align: inherit;
  }

  /* Safari doesn't work with "inherit" */
  [safari] th {
    text-align: initial;
  }

  #footer {
    bottom: 0;
  }

  #items {
    flex-grow: 1;
    flex-shrink: 0;
    display: block;
    position: sticky;
    width: 100%;
    left: 0;
    overflow: visible;
  }

  [part~='row'] {
    display: flex;
    width: 100%;
    box-sizing: border-box;
    margin: 0;
    position: relative;
  }

  [part~='row'][loading] [part~='body-cell'] ::slotted(vaadin-grid-cell-content) {
    visibility: hidden;
  }

  [column-rendering='lazy'] [part~='body-cell']:not([frozen]):not([frozen-to-end]) {
    transform: translateX(var(--_grid-lazy-columns-start));
  }

  #items [part~='row'] {
    position: absolute;
  }

  #items [part~='row']:empty {
    height: 100%;
  }

  [part~='cell']:not([part~='details-cell']) {
    flex-shrink: 0;
    flex-grow: 1;
    box-sizing: border-box;
    display: flex;
    width: 100%;
    position: relative;
    align-items: center;
    padding: 0;
    white-space: nowrap;
  }

  [part~='cell'] {
    outline: none;
    min-height: var(--lumo-size-m);
    background-color: var(--vaadin-grid-cell-background, var(--lumo-base-color));
    cursor: default;
    --_cell-padding: var(--vaadin-grid-cell-padding, var(--_cell-default-padding));
    --_cell-default-padding: var(--lumo-space-xs) var(--lumo-space-m);
  }

  [part~='cell'] > [tabindex] {
    display: flex;
    align-items: inherit;
    outline: none;
    position: absolute;
    inset: 0;
  }

  /* Switch the focusButtonMode wrapping element to "position: static" temporarily
     when measuring real width of the cells in the auto-width columns. */
  [measuring-auto-width] [part~='cell'] > [tabindex] {
    position: static;
  }

  [part~='details-cell'] {
    position: absolute;
    bottom: 0;
    width: 100%;
    box-sizing: border-box;
    padding: 0;
  }

  [part~='cell'] ::slotted(vaadin-grid-cell-content) {
    display: block;
    width: 100%;
    box-sizing: border-box;
    overflow: hidden;
    text-overflow: ellipsis;
    cursor: inherit;
    padding: var(--_cell-padding);
  }

  [hidden] {
    display: none !important;
  }

  [frozen],
  [frozen-to-end] {
    z-index: 2;
    will-change: transform;
  }

  [no-scrollbars][safari] #table,
  [no-scrollbars][firefox] #table {
    overflow: hidden;
  }

  /* Empty state */

  #scroller:not([empty-state]) #emptystatebody,
  #scroller[empty-state] #items {
    display: none;
  }

  #emptystatebody {
    display: flex;
    position: sticky;
    inset: 0;
    flex: 1;
    overflow: hidden;
  }

  #emptystaterow {
    display: flex;
    flex: 1;
  }

  #emptystatecell {
    display: block;
    flex: 1;
    overflow: auto;
  }

  /* Reordering styles */
  :host([reordering]) [part~='cell'] ::slotted(vaadin-grid-cell-content),
  :host([reordering]) [part~='resize-handle'],
  #scroller[no-content-pointer-events] [part~='cell'] ::slotted(vaadin-grid-cell-content) {
    pointer-events: none;
  }

  [part~='reorder-ghost'] {
    visibility: hidden;
    position: fixed;
    pointer-events: none;

    /* Prevent overflowing the grid in Firefox */
    top: 0;
    left: 0;
    opacity: 0.85;
    box-shadow: var(--lumo-box-shadow-s);
    /* TODO Use the same styles as for the cell element (reorder-ghost copies styles from the cell element) */
    padding: var(--lumo-space-s) var(--lumo-space-m) !important;
  }

  :host([reordering]) {
    -webkit-user-select: none;
    user-select: none;
  }

  /* Resizing styles */
  [part~='resize-handle'] {
    position: absolute;
    top: 0;
    right: 0;
    height: 100%;
    cursor: col-resize;
    z-index: 1;
  }

  [part~='resize-handle']::before {
    position: absolute;
    content: '';
    height: 100%;
    width: 35px;
    transform: translateX(-50%);
  }

  [last-column] [part~='resize-handle']::before,
  [last-frozen] [part~='resize-handle']::before {
    width: 18px;
    transform: none;
    right: 0;
  }

  [frozen-to-end] [part~='resize-handle'] {
    left: 0;
    right: auto;
  }

  [frozen-to-end] [part~='resize-handle']::before {
    left: 0;
    right: auto;
  }

  [first-frozen-to-end] [part~='resize-handle']::before {
    width: 18px;
    transform: none;
  }

  [first-frozen-to-end] {
    margin-inline-start: auto;
    border-left: var(--_lumo-grid-border-width) solid transparent;
  }

  /* Hide resize handle if scrolled to end */
  :host(:not([overflow~='end'])) [first-frozen-to-end] [part~='resize-handle'] {
    display: none;
  }

  #scroller[column-resizing],
  #scroller[range-selecting] {
    -webkit-user-select: none;
    user-select: none;
  }

  /* Sizer styles */
  #sizer {
    display: flex;
    position: absolute;
    visibility: hidden;
  }

  #sizer [part~='details-cell'] {
    display: none !important;
  }

  #sizer [part~='cell'][hidden] {
    display: none !important;
  }

  #sizer [part~='cell'] {
    display: block;
    flex-shrink: 0;
    line-height: 0;
    height: 0 !important;
    min-height: 0 !important;
    max-height: 0 !important;
    padding: 0 !important;
    border: none !important;
  }

  #sizer [part~='cell']::before {
    content: '-';
  }

  #sizer [part~='cell'] ::slotted(vaadin-grid-cell-content) {
    display: none !important;
  }

  /* RTL specific styles */

  :host([dir='rtl']) #items,
  :host([dir='rtl']) #header,
  :host([dir='rtl']) #footer {
    left: auto;
  }

  :host([dir='rtl']) [part~='reorder-ghost'] {
    left: auto;
    right: 0;
  }

  :host([dir='rtl']) [part~='resize-handle'] {
    left: 0;
    right: auto;
  }

  :host([dir='rtl']) [part~='resize-handle']::before {
    transform: translateX(50%);
  }

  :host([dir='rtl']) [last-column] [part~='resize-handle']::before,
  :host([dir='rtl']) [last-frozen] [part~='resize-handle']::before {
    left: 0;
    right: auto;
  }

  :host([dir='rtl']) [frozen-to-end] [part~='resize-handle'] {
    right: 0;
    left: auto;
  }

  :host([dir='rtl']) [frozen-to-end] [part~='resize-handle']::before {
    right: 0;
    left: auto;
  }

  /* No (outer) border */

  :host(:not([theme~='no-border'])) {
    border: var(--_lumo-grid-border-width) solid var(--_lumo-grid-border-color);
  }

  /* Cell styles */

  /* Apply row borders by default and introduce the "no-row-borders" variant */
  :host(:not([theme~='no-row-borders'])) [part~='cell']:not([part~='details-cell']) {
    border-top: var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color);
  }

  /* Hide first body row top border */
  :host(:not([theme~='no-row-borders'])) [part~='first-row'] [part~='cell']:not([part~='details-cell']) {
    border-top: 0;
    min-height: calc(var(--lumo-size-m) - var(--_lumo-grid-border-width));
  }

  /* Focus-ring */

  [part~='row']:focus,
  [part~='focused-cell']:focus {
    outline: none;
  }

  :host([navigating]) [part~='row']:focus::before,
  :host([navigating]) [part~='focused-cell']:focus::before {
    content: '';
    position: absolute;
    inset: 0;
    pointer-events: none;
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  :host([navigating]) [part~='row']:focus::before {
    transform: translateX(var(--_grid-horizontal-scroll-position));
    z-index: 3;
  }

  /* Empty state */
  [part~='empty-state'] {
    padding: var(--lumo-space-m);
    color: var(--lumo-secondary-text-color);
  }

  /* Drag and Drop styles */
  :host([dragover])::after {
    content: '';
    position: absolute;
    z-index: 100;
    inset: 0;
    pointer-events: none;
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part~='row'][dragover] {
    z-index: 100 !important;
  }

  [part~='row'][dragover] [part~='cell'] {
    overflow: visible;
  }

  [part~='row'][dragover] [part~='cell']::after {
    content: '';
    position: absolute;
    inset: 0;
    height: calc(var(--_lumo-grid-border-width) + 2px);
    pointer-events: none;
    background: var(--lumo-primary-color-50pct);
  }

  [part~='row'][dragover] [part~='cell'][last-frozen]::after {
    right: -1px;
  }

  :host([theme~='no-row-borders']) [dragover] [part~='cell']::after {
    height: 2px;
  }

  [part~='row'][dragover='below'] [part~='cell']::after {
    top: 100%;
    bottom: auto;
    margin-top: -1px;
  }

  :host([all-rows-visible]) [part~='last-row'][dragover='below'] [part~='cell']::after {
    height: 1px;
  }

  [part~='row'][dragover='above'] [part~='cell']::after {
    top: auto;
    bottom: 100%;
    margin-bottom: -1px;
  }

  [part~='row'][details-opened][dragover='below'] [part~='cell']:not([part~='details-cell'])::after,
  [part~='row'][details-opened][dragover='above'] [part~='details-cell']::after {
    display: none;
  }

  [part~='row'][dragover][dragover='on-top'] [part~='cell']::after {
    height: 100%;
    opacity: 0.5;
  }

  [part~='row'][dragstart] [part~='cell'] {
    border: none !important;
    box-shadow: none !important;
  }

  [part~='row'][dragstart] [part~='cell'][last-column] {
    border-radius: 0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0;
  }

  [part~='row'][dragstart] [part~='cell'][first-column] {
    border-radius: var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s);
  }

  #scroller [part~='row'][dragstart]:not([dragstart=''])::after {
    display: block;
    position: absolute;
    left: var(--_grid-drag-start-x);
    top: var(--_grid-drag-start-y);
    z-index: 100;
    content: attr(dragstart);
    align-items: center;
    justify-content: center;
    box-sizing: border-box;
    padding: calc(var(--lumo-space-xs) * 0.8);
    color: var(--lumo-error-contrast-color);
    background-color: var(--lumo-error-color);
    border-radius: var(--lumo-border-radius-m);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-xxs);
    line-height: 1;
    font-weight: 500;
    text-transform: initial;
    letter-spacing: initial;
    min-width: calc(var(--lumo-size-s) * 0.7);
    text-align: center;
  }

  /* Headers and footers */

  [part~='header-cell'],
  [part~='footer-cell'],
  [part~='reorder-ghost'] {
    font-size: var(--lumo-font-size-s);
    font-weight: 500;
  }

  [part~='footer-cell'] {
    font-weight: 400;
  }

  [part~='row']:only-child [part~='header-cell'] {
    min-height: var(--lumo-size-xl);
  }

  /* Header borders */

  /* Hide first header row top border */
  :host(:not([theme~='no-row-borders'])) [part~='row']:first-child [part~='header-cell'] {
    border-top: 0;
  }

  /* Hide header row top border if previous row is hidden */
  [part~='row'][hidden] + [part~='row'] [part~='header-cell'] {
    border-top: 0;
  }

  [part~='row']:last-child [part~='header-cell'] {
    border-bottom: var(--_lumo-grid-border-width) solid transparent;
  }

  :host(:not([theme~='no-row-borders'])) [part~='row']:last-child [part~='header-cell'] {
    border-bottom-color: var(--_lumo-grid-secondary-border-color);
  }

  /* Overflow uses a stronger border color */
  :host([overflow~='top']) [part~='row']:last-child [part~='header-cell'] {
    border-bottom-color: var(--_lumo-grid-border-color);
  }

  /* Footer borders */

  [part~='row']:first-child [part~='footer-cell'] {
    border-top: var(--_lumo-grid-border-width) solid transparent;
  }

  :host(:not([theme~='no-row-borders'])) [part~='row']:first-child [part~='footer-cell'] {
    border-top-color: var(--_lumo-grid-secondary-border-color);
  }

  /* Overflow uses a stronger border color */
  :host([overflow~='bottom']) [part~='row']:first-child [part~='footer-cell'] {
    border-top-color: var(--_lumo-grid-border-color);
  }

  /* Column reordering */

  :host([reordering]) [part~='cell'] {
    background: linear-gradient(var(--lumo-shade-20pct), var(--lumo-shade-20pct)) var(--lumo-base-color);
  }

  :host([reordering]) [part~='cell'][reorder-status='allowed'] {
    background: var(--lumo-base-color);
  }

  :host([reordering]) [part~='cell'][reorder-status='dragging'] {
    background: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct)) var(--lumo-base-color);
  }

  /* Column resizing */

  [part='resize-handle'] {
    --_resize-handle-width: 3px;
    width: var(--_resize-handle-width);
    background-color: var(--lumo-primary-color-50pct);
    opacity: 0;
    transition: opacity 0.2s;
  }

  [part='resize-handle']::before {
    transform: translateX(calc(-50% + var(--_resize-handle-width) / 2));
    width: var(--lumo-size-s);
  }

  :host(:not([reordering])) *:not([column-resizing]) [part~='cell']:hover [part='resize-handle'],
  [part='resize-handle']:active {
    opacity: 1;
    transition-delay: 0.15s;
  }

  /* Column borders */

  :host([theme~='column-borders']) [part~='cell']:not([last-column]):not([part~='details-cell']) {
    border-right: var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color);
  }

  /* Frozen columns */

  [last-frozen] {
    border-right: var(--_lumo-grid-border-width) solid transparent;
    overflow: hidden;
  }

  :host([overflow~='start']) [part~='cell'][last-frozen]:not([part~='details-cell']) {
    border-right-color: var(--_lumo-grid-border-color);
  }

  :host([overflow~='end']) [part~='cell'][first-frozen-to-end]:not([part~='details-cell']) {
    border-left-color: var(--_lumo-grid-border-color);
  }

  /* Row stripes */

  :host([theme~='row-stripes']) [part~='even-row'] [part~='body-cell'],
  :host([theme~='row-stripes']) [part~='even-row'] [part~='details-cell'] {
    background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    background-repeat: repeat-x;
  }

  /* Selected row */

  /* Raise the selected rows above unselected rows (so that box-shadow can cover unselected rows) */
  :host(:not([reordering])) [part~='row'][selected] {
    z-index: 1;
  }

  :host(:not([reordering])) [part~='row'][selected] [part~='body-cell']:not([part~='details-cell']) {
    background-image: linear-gradient(var(--_lumo-grid-selected-row-color), var(--_lumo-grid-selected-row-color));
    background-repeat: repeat;
  }

  /* Cover the border of an unselected row */
  :host(:not([theme~='no-row-borders'])) [part~='row'][selected] [part~='cell']:not([part~='details-cell']) {
    box-shadow: 0 var(--_lumo-grid-border-width) 0 0 var(--_lumo-grid-selected-row-color);
  }

  /* Compact */

  :host([theme~='compact']) [part~='row']:only-child [part~='header-cell'] {
    min-height: var(--lumo-size-m);
  }

  :host([theme~='compact']) [part~='cell'] {
    min-height: var(--lumo-size-s);
    --_cell-default-padding: var(--lumo-space-xs) var(--lumo-space-s);
  }

  :host([theme~='compact']) [part~='first-row'] [part~='cell']:not([part~='details-cell']) {
    min-height: calc(var(--lumo-size-s) - var(--_lumo-grid-border-width));
  }

  :host([theme~='compact']) [part~='empty-state'] {
    padding: var(--lumo-space-s);
  }

  /* Wrap cell contents */

  :host([theme~='wrap-cell-content']) [part~='cell'] ::slotted(vaadin-grid-cell-content) {
    white-space: normal;
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part~='row'][dragstart] [part~='cell'][last-column] {
    border-radius: var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s);
  }

  :host([dir='rtl']) [part~='row'][dragstart] [part~='cell'][first-column] {
    border-radius: 0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0;
  }

  :host([dir='rtl'][theme~='column-borders']) [part~='cell']:not([last-column]):not([part~='details-cell']) {
    border-right: none;
    border-left: var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color);
  }

  :host([dir='rtl']) [last-frozen] {
    border-right: none;
    border-left: var(--_lumo-grid-border-width) solid transparent;
  }

  :host([dir='rtl']) [first-frozen-to-end] {
    border-left: none;
    border-right: var(--_lumo-grid-border-width) solid transparent;
  }

  :host([dir='rtl'][overflow~='start']) [part~='cell'][last-frozen]:not([part~='details-cell']) {
    border-left-color: var(--_lumo-grid-border-color);
  }

  :host([dir='rtl'][overflow~='end']) [part~='cell'][first-frozen-to-end]:not([part~='details-cell']) {
    border-right-color: var(--_lumo-grid-border-color);
  }

  @media (forced-colors: active) {
    [part~='selected-row'] [part~='first-column-cell']::after {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      bottom: 0;
      border: 2px solid;
    }

    [part~='focused-cell']::before {
      outline: 2px solid !important;
      outline-offset: -1px;
    }
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_grid-filter {
  :host {
    display: inline-flex;
    max-width: 100%;
  }

  ::slotted(*) {
    width: 100%;
    box-sizing: border-box;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-text-field-lumo-inject: 1;
  --vaadin-text-field-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base;
}
:is(:root, :host)::before {
  --vaadin-grid-filter-lumo-inject: 1;
  --vaadin-grid-filter-lumo-inject-modules: lumo_components_grid-filter;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_grid-sorter {
  :host {
    display: inline-flex;
    max-width: 100%;
    justify-content: flex-start;
    align-items: baseline;
    -webkit-user-select: none;
    user-select: none;
    cursor: var(--lumo-clickable-cursor);
  }

  [part='content'] {
    flex: 1 1 auto;
    display: inline-block;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  [part='indicators'] {
    position: relative;
    align-self: center;
    flex: none;
    margin-left: var(--lumo-space-s);
  }

  [part='order'] {
    display: inline;
    vertical-align: super;
    font-size: var(--lumo-font-size-xxs);
    line-height: 1;
  }

  [part='indicators']::before {
    font-family: 'vaadin-grid-sorter-icons';
    display: inline-block;
    transform: scale(0.8);
  }

  :host(:not([direction])) [part='indicators']::before {
    content: '\\e901';
  }

  :host([direction='asc']) [part='indicators']::before {
    content: '\\e900';
  }

  :host([direction='desc']) [part='indicators']::before {
    content: '\\e902';
  }

  :host(:not([direction]):not(:hover)) [part='indicators'] {
    color: var(--lumo-tertiary-text-color);
  }

  :host([direction]) {
    color: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='indicators'] {
    margin-right: var(--lumo-space-s);
    margin-left: 0;
  }
}
@font-face {
  font-family: 'vaadin-grid-sorter-icons';
  src: url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAQwAA0AAAAABuwAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABGRlRNAAAEFAAAABkAAAAcfep+mUdERUYAAAP4AAAAHAAAAB4AJwAOT1MvMgAAAZgAAAA/AAAAYA8TBPpjbWFwAAAB7AAAAFUAAAFeF1fZ4mdhc3AAAAPwAAAACAAAAAgAAAAQZ2x5ZgAAAlgAAABcAAAAnMvguMloZWFkAAABMAAAAC8AAAA2C5Ap72hoZWEAAAFgAAAAHQAAACQGbQPHaG10eAAAAdgAAAAUAAAAHAoAAABsb2NhAAACRAAAABIAAAASAIwAYG1heHAAAAGAAAAAFgAAACAACwAKbmFtZQAAArQAAAECAAACZxWCgKhwb3N0AAADuAAAADUAAABZCrApUXicY2BkYGAA4rDECVrx/DZfGbhZGEDgyqNPOxH0/wNMq5kPALkcDEwgUQBWRA0dAHicY2BkYGA+8P8AAwMLAwgwrWZgZEAFbABY4QM8AAAAeJxjYGRgYOAAQiYGEICQSAAAAi8AFgAAeJxjYGY6yziBgZWBgWkm0xkGBoZ+CM34msGYkZMBFTAKoAkwODAwvmRiPvD/AIMDMxCD1CDJKjAwAgBktQsXAHicY2GAAMZQCM0EwqshbAALxAEKeJxjYGBgZoBgGQZGBhCIAPIYwXwWBhsgzcXAwcAEhIwMCi+Z/v/9/x+sSuElA4T9/4k4K1gHFwMMMILMY2QDYmaoABOQYGJABUA7WBiGNwAAJd4NIQAAAAAAAAAACAAIABAAGAAmAEAATgAAeJyNjLENgDAMBP9tIURJwQCMQccSZgk2i5fIYBDAidJjycXr7x5EPwE2wY8si7jmyBNXGo/bNBerxJNrpxhbO3/fEFpx8ZICpV+ghxJ74fAMe+h7Ox14AbrsHB14nK2QQWrDMBRER4mTkhQK3ZRQKOgCNk7oGQqhhEIX2WSlWEI1BAlkJ5CDdNsj5Ey9Rncdi38ES+jzNJo/HwTgATcoDEthhY3wBHc4CE+pfwsX5F/hGe7Vo/AcK/UhvMSz+mGXKhZU6pww8ISz3oWn1BvhgnwTnuEJf8Jz1OpFeIlX9YULDLdFi4ASHolkSR0iuYdjLak1vAequBhj21D61Nqyi6l3qWybGPjySbPHGScGJl6dP58MYcQRI0bts7mjebBqrFENH7t3qWtj0OuqHnXcW7b0HOTZFnKryRGW2hFX1m0O2vEM3opNMfTau+CS6Z3Vx6veNnEXY6jwDxhsc2gAAHicY2BiwA84GBgYmRiYGJkZmBlZGFkZ2djScyoLMgzZS/MyDQwMwLSrpYEBlIbxjQDrzgsuAAAAAAEAAf//AA94nGNgZGBg4AFiMSBmYmAEQnYgZgHzGAAD6wA2eJxjYGBgZACCKyoz1cD0o087YTQATOcIewAAAA==)
    format('woff');
  font-weight: normal;
  font-style: normal;
}
:is(:root, :host)::before {
  --vaadin-grid-sorter-lumo-inject: 1;
  --vaadin-grid-sorter-lumo-inject-modules: lumo_components_grid-sorter;
}
:is(:root, :host)::before {
  --vaadin-crud-lumo-inject: 1;
  --vaadin-crud-lumo-inject-modules: lumo_components_crud;

  --vaadin-crud-edit-lumo-inject: 1;
  --vaadin-crud-edit-lumo-inject-modules:
    lumo_components_button,
    lumo_components_crud-edit;

  --vaadin-crud-grid-lumo-inject: 1;
  --vaadin-crud-grid-lumo-inject-modules: lumo_components_grid;

  --vaadin-crud-form-lumo-inject: 1;
  --vaadin-crud-form-lumo-inject-modules: lumo_components_form-layout;

  --vaadin-crud-dialog-overlay-lumo-inject: 1;
  --vaadin-crud-dialog-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_components_dialog-overlay,
    lumo_components_crud-dialog-overlay;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_custom-field {
  :host {
    display: inline-flex;
    --lumo-text-field-size: var(--lumo-size-m);
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-m);
    /* align with text-field height + vertical paddings */
    line-height: calc(var(--lumo-text-field-size) + 2 * var(--lumo-space-xs));
    font-family: var(--lumo-font-family);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: transparent;
    padding: 0;
  }

  :host::before {
    content: '\\2003';
    width: 0;
    /* Size and position this element on the same vertical position as the input-field element
           to make vertical align for the host element work as expected */
    margin-top: var(--lumo-space-xs);
    height: var(--lumo-text-field-size);
    box-sizing: border-box;
    display: inline-flex;
    align-items: center;
  }

  :host([hidden]) {
    display: none !important;
  }

  .vaadin-custom-field-container {
    width: 100%;
    display: flex;
    flex-direction: column;
  }

  .inputs-wrapper {
    flex: none;
  }

  /* align with text-field label */
  :host([has-label]) [part='label'] {
    padding-bottom: calc(0.5em - var(--lumo-space-xs));
  }

  :host(:not([has-label])) [part='label'],
  :host(:not([has-label]))::before {
    display: none;
  }

  /* align with text-field error message */
  :host([has-error-message]) [part='error-message']::before {
    height: calc(0.4em - var(--lumo-space-xs));
  }

  :host([focused]:not([readonly]):not([disabled])) [part='label'] {
    color: var(--lumo-primary-text-color);
  }

  :host(:hover:not([readonly]):not([disabled]):not([focused])) [part='label'],
  :host(:hover:not([readonly]):not([disabled]):not([focused])) [part='helper-text'] {
    color: var(--lumo-body-text-color);
  }

  /* Touch device adjustment */
  @media (pointer: coarse) {
    :host(:hover:not([readonly]):not([disabled]):not([focused])) [part='label'] {
      color: var(--lumo-secondary-text-color);
    }
  }

  /* Disabled */
  :host([disabled]) [part='label'] {
    color: var(--lumo-disabled-text-color);
    -webkit-text-fill-color: var(--lumo-disabled-text-color);
  }

  /* Small theme */
  :host([theme~='small']) {
    font-size: var(--lumo-font-size-s);
    --lumo-text-field-size: var(--lumo-size-s);
  }

  :host([theme~='small'][has-label]) [part='label'] {
    font-size: var(--lumo-font-size-xs);
  }

  :host([theme~='small'][has-label]) [part='error-message'] {
    font-size: var(--lumo-font-size-xxs);
  }

  /* When custom-field is used with components without outer margin */
  :host([theme~='whitespace'][has-label]) [part='label'] {
    padding-bottom: 0.5em;
  }
}
:is(:root, :host)::before {
  --vaadin-custom-field-lumo-inject: 1;
  --vaadin-custom-field-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-helper,
    lumo_components_custom-field;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_dashboard-item {
  :host {
    box-sizing: border-box;
    --_widget-background: var(--vaadin-dashboard-widget-background, var(--lumo-base-color));
    --_widget-border-radius: var(--vaadin-dashboard-widget-border-radius, var(--lumo-border-radius-l));
    --_widget-border-width: var(--vaadin-dashboard-widget-border-width, 1px);
    --_widget-border-color: var(--vaadin-dashboard-widget-border-color, var(--lumo-contrast-20pct));
    --_widget-shadow: var(--vaadin-dashboard-widget-shadow, 0 0 0 0 transparent);
    --_widget-editable-shadow: var(--lumo-box-shadow-s);
    --_widget-selected-shadow:
      0 2px 4px -1px var(--lumo-primary-color-10pct), 0 3px 12px -1px var(--lumo-primary-color-50pct);
    --_drop-target-background-color: var(
      --vaadin-dashboard-drop-target-background-color,
      var(--lumo-primary-color-10pct)
    );
    --_drop-target-border: var(--vaadin-dashboard-drop-target-border, 1px dashed var(--lumo-primary-color-50pct));

    color: var(--lumo-body-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_icon-color: var(--lumo-contrast-60pct);
    opacity: var(--_widget-opacity);
    filter: var(--_widget-filter);
  }

  :host([dragging]) * {
    visibility: hidden;
  }

  :host(:not([editable])) [part~='move-button'],
  :host(:not([editable])) [part~='remove-button'],
  :host(:not([editable])) #focus-button,
  :host(:not([editable])) #focus-button-wrapper,
  :host(:not([editable])) .mode-controls {
    display: none;
  }

  #focustrap {
    display: contents;
  }

  #focus-button-wrapper,
  #focus-button {
    position: absolute;
    inset: 0;
    opacity: 0;
  }

  #focus-button {
    pointer-events: none;
    padding: 0;
    border: none;
  }

  .mode-controls {
    position: absolute;
    inset: 0;
    z-index: 2;
  }

  .mode-controls[hidden] {
    display: none;
  }

  /* Move-mode buttons */
  [part~='move-backward-button'],
  [part~='move-forward-button'],
  [part~='move-apply-button'] {
    position: absolute;
    top: 50%;
  }

  [part~='move-backward-button'] {
    inset-inline-start: 0;
    transform: translateY(-50%);
  }

  [part~='move-forward-button'] {
    inset-inline-end: 0;
    transform: translateY(-50%);
  }

  [part~='move-apply-button'] {
    left: 50%;
    transform: translate(-50%, -50%);
    --icon: var(--lumo-icons-checkmark);
    font-size: var(--lumo-icon-size-m);
  }

  :host([first-child]) [part~='move-backward-button'],
  :host([last-child]) [part~='move-forward-button'] {
    display: none;
  }

  /* Resize-mode buttons */
  [part~='resize-shrink-width-button'],
  [part~='resize-shrink-height-button'],
  [part~='resize-grow-width-button'],
  [part~='resize-grow-height-button'],
  [part~='resize-apply-button'] {
    position: absolute;
  }

  [part~='resize-shrink-width-button'] {
    inset-inline-end: 0;
    top: 50%;
  }

  :host(:not([dir='rtl'])) [part~='resize-shrink-width-button'] {
    transform: translateY(-50%) translateX(-100%);
  }

  :host([dir='rtl']) [part~='resize-shrink-width-button'] {
    transform: translateY(-50%) translateX(100%);
  }

  .mode-controls:has([part~='resize-grow-width-button'][hidden]) [part~='resize-shrink-width-button'] {
    transform: translateY(-50%);
  }

  [part~='resize-grow-width-button'] {
    inset-inline-start: 100%;
    top: 50%;
  }

  :host(:not([dir='rtl'])) [part~='resize-grow-width-button'] {
    transform: translateY(-50%) translateX(-100%);
  }

  :host([dir='rtl']) [part~='resize-grow-width-button'] {
    transform: translateY(-50%) translateX(100%);
  }

  [part~='resize-shrink-height-button'] {
    bottom: 0;
    left: 50%;
    transform: translateX(-50%) translateY(-100%);
  }

  [part~='resize-grow-height-button'] {
    top: 100%;
    left: 50%;
    transform: translateX(-50%) translateY(-100%);
  }

  [part~='resize-apply-button'] {
    left: 50%;
    top: 50%;

    transform: translate(-50%, -50%);
  }

  :host([focused]) {
    z-index: 1;
  }

  header {
    overflow: hidden;
    display: flex;
    align-items: start;
    box-sizing: border-box;
    justify-content: space-between;
  }

  [part='title'] {
    flex: 1;
    color: var(--lumo-header-text-color);
    white-space: var(--vaadin-dashboard-widget-title-wrap, wrap);
    text-overflow: ellipsis;
    overflow: hidden;
    line-height: var(--lumo-line-height-s);
    margin: 0 0 1px;
    align-self: safe center;
  }

  vaadin-dashboard-button {
    font-family: 'lumo-icons';
    font-size: var(--lumo-icon-size-m);
    margin: 0;
    z-index: 1;
  }

  vaadin-dashboard-button .icon::before {
    display: block;
    content: var(--icon);
  }

  /* Common styles for non-mode edit buttons */
  [part='move-button'],
  [part='resize-button'],
  [part='remove-button'] {
    color: var(--_icon-color);
    padding-inline: 0;
  }

  :where([part='move-button'], [part='resize-button'], [part='remove-button']):hover {
    --_icon-color: var(--lumo-primary-text-color);
  }

  :host([selected]) {
    opacity: 1;
    z-index: 1;
    --_icon-color: var(--lumo-primary-text-color);
  }

  :host(:is([move-mode], [resize-mode])) {
    --_icon-color: var(--lumo-disabled-text-color);
  }

  /* Drag handle */
  [part~='move-button'] {
    cursor: move;
    --icon: var(--lumo-icons-drag-handle);
  }

  /* Remove button */
  [part~='remove-button'] {
    cursor: pointer;
    --icon: var(--lumo-icons-cross);
    margin-inline-start: var(--lumo-space-xs);
  }

  /* Mode controls */
  .mode-controls vaadin-dashboard-button[focused] {
    z-index: 3;
  }

  /* Move mode */

  :host(:not([dir='rtl'])) [part~='move-backward-button'],
  :host([dir='rtl']) [part~='move-forward-button'] {
    border-top-left-radius: 0;
    border-bottom-left-radius: 0;
    --icon: var(--lumo-icons-angle-left);
  }

  :host(:not([dir='rtl'])) [part~='move-forward-button'],
  :host([dir='rtl']) [part~='move-backward-button'] {
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    --icon: var(--lumo-icons-angle-right);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_dashboard-layout {
  :host {
    display: block;
    overflow: auto;
    box-sizing: border-box;
    width: 100%;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([dense-layout]) #grid {
    grid-auto-flow: dense;
  }

  #grid {
    box-sizing: border-box;

    /* Padding around dashboard edges */
    --_default-padding: var(--lumo-space-m);
    --_padding: max(0px, var(--vaadin-dashboard-padding, var(--_default-padding)));
    padding: var(--_padding);

    /* Gap between widgets */
    --_default-gap: var(--lumo-space-m);
    --_gap: max(0px, var(--vaadin-dashboard-gap, var(--_default-gap)));
    gap: var(--_gap);

    /* Default min and max column widths */
    --_default-col-min-width: 25rem;
    --_default-col-max-width: 1fr;

    /* Effective min and max column widths */
    --_col-min-width: var(--vaadin-dashboard-col-min-width, var(--_default-col-min-width));
    --_col-max-width: var(--vaadin-dashboard-col-max-width, var(--_default-col-max-width));

    /* Effective max column count */
    --_col-max-count: var(--vaadin-dashboard-col-max-count, var(--_col-count));

    /* Effective column count */
    --_effective-col-count: min(var(--_col-count), var(--_col-max-count));

    /* Default row min height */
    --_default-row-min-height: 12rem;
    /* Effective row min height */
    --_row-min-height: var(--vaadin-dashboard-row-min-height, var(--_default-row-min-height));
    /* Effective row height */
    --_row-height: minmax(var(--_row-min-height, auto), auto);

    display: grid;
    overflow: hidden;
    min-width: calc(var(--_col-min-width) + var(--_padding) * 2);

    grid-template-columns: repeat(
      var(--_effective-col-count, auto-fill),
      minmax(var(--_col-min-width), var(--_col-max-width))
    );

    grid-auto-rows: var(--_row-height);
  }

  ::slotted(*) {
    /* The grid-column value applied to children */
    --_item-column: span min(var(--vaadin-dashboard-widget-colspan, 1), var(--_effective-col-count, var(--_col-count)));

    grid-column: var(--_item-column);

    /* The grid-row value applied to children */
    --_item-row: span var(--vaadin-dashboard-widget-rowspan, 1);
    grid-row: var(--_item-row);
  }

  :host([theme~='shaded-background']) {
    background: var(--lumo-shade-5pct);
  }

  :host([theme~='elevated-widgets']) {
    --vaadin-dashboard-widget-shadow: var(--lumo-box-shadow-xs);
    --vaadin-dashboard-widget-border-color: var(--lumo-contrast-10pct);
    --vaadin-dashboard-widget-background: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct))
      var(--lumo-base-color);
  }

  :host([theme~='flat-widgets']) {
    --vaadin-dashboard-widget-background: var(--lumo-contrast-5pct);
    --vaadin-dashboard-widget-border-color: transparent;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_dashboard-section {
  :host {
    display: grid;
    position: relative;
    grid-template-columns: subgrid;
    --_section-column: 1 / calc(var(--_effective-col-count) + 1);
    grid-column: var(--_section-column) !important;
    gap: var(--_gap, 1rem);
    /* Dashboard section header height */
    --_section-header-height: minmax(0, auto);
    grid-template-rows: var(--_section-header-height) repeat(auto-fill, var(--_row-height));
    grid-auto-rows: var(--_row-height);
    --_section-outline-offset: calc(min(var(--_gap), var(--_padding)) / 3);
    --_focus-ring-offset: calc((var(--_section-outline-offset) - var(--_focus-ring-width)));
    border-radius: var(--lumo-border-radius-l);
  }

  :host([hidden]) {
    display: none !important;
  }

  ::slotted(*) {
    --_item-column: span min(var(--vaadin-dashboard-widget-colspan, 1), var(--_effective-col-count, var(--_col-count)));

    grid-column: var(--_item-column);
    --_item-row: span var(--vaadin-dashboard-widget-rowspan, 1);
    grid-row: var(--_item-row);
  }

  header {
    grid-column: var(--_section-column);
    margin-bottom: calc(-1 * var(--_section-outline-offset));
    line-height: var(--lumo-line-height-s);
    padding-inline: var(--lumo-space-s);
    min-height: var(--lumo-size-l);
    align-items: center;
  }

  :host::before {
    z-index: 2 !important;
  }

  ::slotted(vaadin-dashboard-widget-wrapper) {
    display: contents;
  }

  [part='title'] {
    font-size: var(--lumo-font-size-xl);
    font-weight: 600;
    white-space: nowrap;
    line-height: var(--lumo-line-height-m);
  }

  /* Section states */

  :host([editable]) {
    outline: 1px solid var(--lumo-contrast-10pct);
    outline-offset: calc(var(--_section-outline-offset) - 1px);
    background: var(--lumo-contrast-5pct);
    box-shadow: 0 0 0 var(--_section-outline-offset) var(--lumo-contrast-5pct);
  }

  :host([editable]) header {
    padding-inline: var(--lumo-space-xs);
  }

  :host([focused])::after {
    content: '';
    display: block;
    position: absolute;
    inset: 0;
    border-radius: var(--lumo-border-radius-l);
    z-index: 9;
    outline: var(--_focus-ring-width) solid var(--_focus-ring-color);
    outline-offset: var(--_focus-ring-offset);
  }

  :host([selected]) {
    background: var(--lumo-primary-color-10pct);
    box-shadow: 0 0 0 var(--_section-outline-offset) var(--lumo-primary-color-10pct);
  }

  :host([selected]:not([focused])) {
    outline-color: var(--lumo-primary-color-50pct);
  }

  :host([move-mode]) ::slotted(*) {
    --_widget-opacity: 0.3;
    --_widget-filter: blur(10px);
  }

  :host([dragging]) {
    background: var(--_drop-target-background-color);
    outline: var(--_drop-target-border);
    box-shadow: 0 0 0 var(--_section-outline-offset) var(--_drop-target-background-color);
  }

  /* Accessible move mode controls */

  [part~='move-backward-button'] {
    inset-inline-start: calc(-1 * var(--_section-outline-offset));
  }

  [part~='move-forward-button'] {
    inset-inline-end: calc(-1 * var(--_section-outline-offset));
    transform: translateY(-50%);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_dashboard-widget {
  :host {
    display: flex;
    flex-direction: column;
    grid-column: var(--_item-column);
    grid-row: var(--_item-row);
    background: var(--_widget-background);
    border-radius: var(--_widget-border-radius);
    box-shadow: var(--_widget-shadow);
    position: relative;
  }

  :host::before {
    content: '';
    position: absolute;
    inset: calc(-1 * var(--_widget-border-width));
    border: var(--_widget-border-width) solid var(--_widget-border-color);
    border-radius: calc(var(--_widget-border-radius) + var(--_widget-border-width));
    pointer-events: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host(:not([editable])) [part~='resize-button'] {
    display: none;
  }

  [part~='content'] {
    flex: 1;
    overflow: hidden;
  }

  /* Widget states */

  :host([editable]) {
    --vaadin-dashboard-widget-shadow: var(--_widget-editable-shadow);
    --_widget-border-color: var(--lumo-contrast-20pct);
    --_widget-border-width: 1px;
  }

  :host([focused])::before {
    border-width: var(--_focus-ring-width);
    border-color: var(--_focus-ring-color);
  }

  :host([selected]) {
    --vaadin-dashboard-widget-shadow: var(--_widget-selected-shadow);
    background: var(--lumo-primary-color-10pct);
  }

  :host([dragging]) {
    box-shadow: none;
    background: var(--_drop-target-background-color);
    border: var(--_drop-target-border);
  }

  :host([resizing])::after {
    content: '';
    z-index: 2;
    position: absolute;
    top: -1px;
    width: var(--_widget-resizer-width, 0);
    height: var(--_widget-resizer-height, 0);
    border-radius: inherit;
    background: var(--_drop-target-background-color);
    border: var(--_drop-target-border);
  }

  /* Widget parts */

  header {
    min-height: var(--lumo-size-l);
    padding: var(--lumo-space-xs) var(--lumo-space-m);
  }

  :host([editable]) header {
    padding-inline: var(--lumo-space-xs);
  }

  [part='title'] {
    font-size: var(--lumo-font-size-l);
    font-weight: 600;
  }

  #content {
    min-height: var(--lumo-size-m);
    padding-inline: var(--vaadin-dashboard-widget-padding, 0);
    padding-bottom: var(--vaadin-dashboard-widget-padding, 0);
    padding-top: 0;
    border-radius: inherit;
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    overflow: hidden;
  }

  ::slotted([slot='header-content']) {
    align-self: center;
  }

  :host([resize-mode]) #content,
  :host([move-mode]) #content {
    opacity: 0.75;
    filter: blur(10px);
  }

  /* Resize handle */

  [part~='resize-button'] {
    z-index: 1;
    overflow: hidden;
    --_resize-button-offset: min(var(--_gap), var(--_padding), var(--lumo-space-xs));
    position: absolute;
    bottom: calc(-1 * var(--_resize-button-offset));
    inset-inline-end: calc(-1 * var(--_resize-button-offset));
    cursor: nwse-resize;
    touch-action: none;
    --icon: var(--lumo-icons-resize-handle);
  }

  :host([dir='rtl']) [part~='resize-button'] {
    cursor: sw-resize;
  }

  :host([dir='rtl']) [part~='resize-button'] .icon::before {
    transform: scaleX(-1);
  }

  /* Accessible resize mode controls */

  [part~='resize-apply-button'] {
    --icon: var(--lumo-icons-checkmark);
    font-size: var(--lumo-icon-size-m);
  }

  [part~='resize-grow-width-button'],
  [part~='resize-shrink-width-button'] {
    padding-right: 0;
    padding-left: 0;
    min-width: var(--lumo-size-s);
  }

  [part~='resize-shrink-width-button'] + [part~='resize-grow-width-button'] {
    margin-left: 1px;
  }

  [part~='resize-grow-height-button'],
  [part~='resize-shrink-height-button'] {
    height: var(--lumo-size-s);
    padding-right: 0;
    padding-left: 0;
    border-bottom-left-radius: 0;
    border-bottom-right-radius: 0;
  }

  [part~='resize-shrink-height-button']:not([hidden]) + [part~='resize-grow-height-button'] {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
  }

  [part~='resize-shrink-height-button'] + [part~='resize-grow-height-button'] {
    margin-top: 1px;
  }

  :host(:not([dir='rtl'])) [part~='resize-grow-width-button'],
  :host(:not([dir='rtl'])) [part~='resize-shrink-width-button'] {
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
  }

  :host([dir='rtl']) [part~='resize-grow-width-button'],
  :host([dir='rtl']) [part~='resize-shrink-width-button'] {
    border-top-left-radius: 0;
    border-bottom-left-radius: 0;
  }

  :host(:not([dir='rtl'])) [part~='resize-shrink-width-button']:not([hidden]) + [part~='resize-grow-width-button'] {
    border-top-left-radius: 0;
    border-bottom-left-radius: 0;
  }

  :host([dir='rtl']) [part~='resize-shrink-width-button']:not([hidden]) + [part~='resize-grow-width-button'] {
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
  }

  [part~='resize-grow-height-button'],
  [part~='resize-grow-width-button'] {
    --icon: var(--lumo-icons-plus);
  }

  [part~='resize-shrink-height-button'],
  [part~='resize-shrink-width-button'] {
    --icon: var(--lumo-icons-minus);
  }

  /* Windows High Contrast Mode */
  @media (forced-colors: active) {
    :host {
      border: 1px solid;
    }

    :host([focused]) {
      outline: 2px solid;
      outline-offset: 1px;
    }

    :host([selected]) {
      outline-width: 1px;
      outline-offset: 0;
      outline-color: Highlight;
    }

    :host([selected][focused]) {
      outline-width: 3px;
      outline-offset: 0;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_dashboard {
  #grid[item-resizing] {
    -webkit-user-select: none;
    user-select: none;
  }

  ::slotted(vaadin-dashboard-widget-wrapper) {
    display: contents;
  }

  :host {
    --_widget-opacity: 1;
  }

  :host([item-selected]) {
    --_widget-opacity: 0.7;
  }
}
:is(:root, :host)::before {
  --vaadin-dashboard-lumo-inject: 1;
  --vaadin-dashboard-lumo-inject-modules:
    lumo_components_dashboard-layout,
    lumo_components_dashboard;

  --vaadin-dashboard-widget-lumo-inject: 1;
  --vaadin-dashboard-widget-lumo-inject-modules:
    lumo_mixins_dashboard-item,
    lumo_components_dashboard-widget;

  --vaadin-dashboard-section-lumo-inject: 1;
  --vaadin-dashboard-section-lumo-inject-modules:
    lumo_mixins_dashboard-item,
    lumo_components_dashboard-section;

  --vaadin-dashboard-layout-lumo-inject: 1;
  --vaadin-dashboard-layout-lumo-inject-modules: lumo_components_dashboard-layout;

  --vaadin-dashboard-button-lumo-inject: 1;
  --vaadin-dashboard-button-lumo-inject-modules: lumo_components_button;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_date-picker-month-calendar {
  :host {
    display: block;
    -webkit-user-select: none;
    -webkit-tap-highlight-color: transparent;
    user-select: none;
    font-size: var(--lumo-font-size-m);
    color: var(--lumo-body-text-color);
    text-align: center;
    padding: 0 var(--lumo-space-xs);
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color));
    --_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
  }

  #monthGrid {
    width: 100%;
    border-collapse: collapse;
  }

  #days-container tr,
  #weekdays-container tr {
    display: flex;
  }

  [part~='disabled'] {
    pointer-events: none;
  }

  /* Month header */

  [part='month-header'] {
    color: var(--lumo-header-text-color);
    font-size: var(--lumo-font-size-l);
    line-height: 1;
    font-weight: 500;
    margin-bottom: var(--lumo-space-m);
  }

  /* Week days and numbers */

  [part='weekdays'],
  [part='weekday'],
  [part='week-number'] {
    font-size: var(--lumo-font-size-xxs);
    line-height: 1;
    color: var(--lumo-secondary-text-color);
  }

  [part='weekdays'] {
    margin-bottom: var(--lumo-space-s);
  }

  [part='weekday']:empty,
  [part='week-number'] {
    flex-shrink: 0;
    padding: 0;
    width: var(--lumo-size-xs);
  }

  [part='week-number'][hidden],
  [part='weekday'][hidden] {
    display: none;
  }

  /* Date and week number cells */

  [part~='date'],
  [part='week-number'] {
    box-sizing: border-box;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    height: var(--lumo-size-m);
    position: relative;
  }

  [part~='date'] {
    outline: none;
    transition: color 0.1s;
  }

  [part~='date']:not(:empty) {
    cursor: var(--lumo-clickable-cursor);
  }

  [part='weekday'],
  [part~='date'] {
    width: calc(100% / 7);
    padding: 0;
    font-weight: normal;
  }

  :host([week-numbers]) [part='weekday']:not(:empty),
  :host([week-numbers]) [part~='date'] {
    width: calc((100% - var(--lumo-size-xs)) / 7);
  }

  /* Today date */

  [part~='date'][part~='today'] {
    color: var(--_selection-color-text);
  }

  /* Focused date */

  [part~='date']::before {
    content: '';
    position: absolute;
    z-index: -1;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    min-width: 2em;
    min-height: 2em;
    width: 80%;
    height: 80%;
    max-height: 100%;
    max-width: 100%;
    border-radius: var(--lumo-border-radius-m);
  }

  [part~='date'][part~='focused']::before {
    box-shadow:
      0 0 0 1px var(--lumo-base-color),
      0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color);
  }

  :host(:not([focused])) [part~='date'][part~='focused']::before {
    animation: vaadin-date-picker-month-calendar-focus-date 1.4s infinite;
  }

  @keyframes vaadin-date-picker-month-calendar-focus-date {
    50% {
      box-shadow:
        0 0 0 1px var(--lumo-base-color),
        0 0 0 calc(var(--_focus-ring-width) + 1px) transparent;
    }
  }

  [part~='date']:not(:empty):not([part~='disabled']):not([part~='selected']):hover::before {
    background-color: var(--lumo-primary-color-10pct);
  }

  [part~='date'][part~='selected'] {
    color: var(--lumo-primary-contrast-color);
  }

  [part~='date'][part~='selected']::before {
    background-color: var(--_selection-color);
  }

  [part~='date'][part~='disabled'] {
    color: var(--lumo-disabled-text-color);
  }

  @media (pointer: coarse) {
    [part~='date']:hover:not([part~='selected'])::before,
    :host(:not([focus-ring])) [part~='focused']:not([part~='selected'])::before {
      display: none;
    }

    [part~='date']:not(:empty):not([part~='disabled']):active::before {
      display: block;
    }

    :host(:not([focus-ring])) [part~='date'][part~='selected']::before {
      box-shadow: none;
    }
  }
  /* Disabled */

  :host([disabled]) * {
    color: var(--lumo-disabled-text-color) !important;
  }

  @media (forced-colors: active) {
    [part~='date'][part~='focused'] {
      outline: 1px solid;
    }

    [part~='date'][part~='selected'] {
      outline: 3px solid;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_date-picker-overlay-content {
  :host {
    display: grid;
    grid-template-areas:
      'header header'
      'months years'
      'toolbar years';
    grid-template-columns: minmax(0, 1fr) 0;
    height: 100%;
    outline: none;
    position: relative;
    /* Background for the year scroller, placed here as we are using a mask image on the actual years part */
    background-image: linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
    background-size: 57px 100%;
    background-position: top right;
    background-repeat: no-repeat;
    cursor: default;
  }

  :host([dir='rtl']) {
    background-position: top left;
  }

  :host([desktop]) {
    grid-template-columns: minmax(0, 1fr) auto;
  }

  :host([fullscreen][years-visible]) {
    grid-template-columns: minmax(0, 1fr) auto;
  }

  [hidden] {
    display: none !important;
  }

  ::slotted([slot='months']) {
    /* Month calendar height:
          header height + margin-bottom
        + weekdays height + margin-bottom
        + date cell heights
        + small margin between month calendars
    */
    /* prettier-ignore */
    --vaadin-infinite-scroller-item-height:
      calc(
          var(--lumo-font-size-l) + var(--lumo-space-m)
        + var(--lumo-font-size-xs) + var(--lumo-space-s)
        + var(--lumo-size-m) * 6
        + var(--lumo-space-s)
      );
    --vaadin-infinite-scroller-buffer-offset: 10%;
    mask-image: linear-gradient(transparent, #000 10%, #000 85%, transparent);
    position: relative;
  }

  ::slotted([slot='years']) {
    /* TODO get rid of fixed magic number */
    --vaadin-infinite-scroller-buffer-width: 57px;
    width: 57px;
    height: auto;
    top: 0;
    bottom: 0;
    font-size: var(--lumo-font-size-s);
    box-shadow: inset 2px 0 4px 0 var(--lumo-shade-5pct);
    mask-image: linear-gradient(transparent, #000 35%, #000 65%, transparent);
    cursor: var(--lumo-clickable-cursor);
  }

  :host([dir='rtl']) ::slotted([slot='years']) {
    box-shadow: inset -2px 0 4px 0 var(--lumo-shade-5pct);
  }

  ::slotted([slot='years']:hover) {
    --_lumo-date-picker-year-opacity: 1;
  }

  :host([desktop]) ::slotted([slot='years']),
  :host([years-visible]) ::slotted([slot='years']) {
    visibility: visible;
  }

  /* Year scroller position indicator */
  ::slotted([slot='years'])::before {
    border: none;
    width: 1em;
    height: 1em;
    background-color: var(--lumo-base-color);
    background-image: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
    transform: translate(-75%, -50%) rotate(45deg);
    border-top-right-radius: var(--lumo-border-radius-s);
    box-shadow: 2px -2px 6px 0 var(--lumo-shade-5pct);
    z-index: 1;
  }

  :host([dir='rtl']) ::slotted([slot='years'])::before {
    right: 0;
    transform: translate(75%, -50%) rotate(45deg);
  }

  [part='toolbar'] {
    display: flex;
    grid-area: toolbar;
    justify-content: space-between;
    padding: var(--lumo-space-s);
    border-bottom-left-radius: var(--lumo-border-radius-l);
  }

  /* Narrow viewport mode (fullscreen) */

  :host([fullscreen]) [part='toolbar'] {
    grid-area: header;
    margin-inline-end: 57px;
    background-color: var(--lumo-base-color);
  }

  [part='toolbar'] ::slotted(vaadin-button) {
    margin: 0;
  }

  /* Very narrow screen (year scroller initially hidden) */

  [part='years-toggle-button'] {
    display: flex;
    align-items: center;
    height: var(--lumo-size-m);
    padding: 0 0.5em;
    border-radius: var(--lumo-border-radius-m);
    color: var(--lumo-primary-text-color);
    font-weight: 500;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  :host([years-visible]) [part='years-toggle-button'] {
    background-color: var(--lumo-primary-color);
    color: var(--lumo-primary-contrast-color);
  }

  /* TODO magic number (same as used for media-query in vaadin-date-picker-overlay-content) */
  @media screen and (max-width: 374px) {
    :host {
      background-image: none;
    }

    :host([fullscreen]) [part='toolbar'] {
      margin-inline-end: 0;
    }

    /* TODO make date-picker adapt to the width of the years part */
    ::slotted([slot='years']) {
      --vaadin-infinite-scroller-buffer-width: 50px;
      width: 50px;
      background-color: var(--lumo-shade-5pct);
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_date-picker-overlay {
  [part='overlay'] {
    display: flex;
    flex: auto;
    /* Width: date cell widths + month calendar side padding + year scroller width */
    width: calc(var(--lumo-size-m) * 7 + var(--lumo-space-xs) * 2 + 57px);
    height: 100%;
    max-height: calc(var(--lumo-size-m) * 14);
    overflow: hidden;
    -webkit-tap-highlight-color: transparent;
    flex-direction: column;
  }

  [part='content'] {
    flex: auto;
    padding: 0;
    height: 100%;
    overflow: hidden;
    mask-image: none;
  }

  :host([top-aligned]) [part='overlay'] {
    margin-top: var(--lumo-space-xs);
  }

  :host([bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--lumo-space-xs);
  }

  @media (max-width: 450px), (max-height: 450px) {
    [part='overlay'] {
      width: 100vw;
      height: 70vh;
      max-height: 70vh;
    }
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 3px solid;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_date-picker-year {
  :host {
    display: block;
    height: 100%;
  }

  :host([current]) [part='year-number'] {
    color: var(--lumo-primary-text-color);
  }

  :host(:not([current])) [part='year-number'],
  [part='year-separator'] {
    opacity: var(--_lumo-date-picker-year-opacity, 0.7);
    transition: 0.2s opacity;
  }

  [part='year-number'],
  [part='year-separator'] {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 50%;
    transform: translateY(-50%);
  }

  [part='year-separator']::after {
    color: var(--lumo-disabled-text-color);
    content: '\\2022';
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_date-picker {
  :host([opened]) {
    pointer-events: auto;
  }

  :host([dir='rtl']) [part='input-field'] {
    direction: ltr;
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input)::placeholder {
    direction: rtl;
    text-align: left;
  }

  [part='toggle-button']::before {
    content: var(--lumo-icons-calendar);
  }

  [part='clear-button']::before {
    content: var(--lumo-icons-cross);
  }

  @media (max-width: 450px), (max-height: 450px) {
    [part='overlay-content'] {
      height: 70vh;
    }
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input) {
    --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input:placeholder-shown) {
    --_lumo-text-field-overflow-mask-image: none;
  }
}
:is(:root, :host)::before {
  --vaadin-date-picker-lumo-inject: 1;
  --vaadin-date-picker-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_date-picker;

  --vaadin-date-picker-year-lumo-inject: 1;
  --vaadin-date-picker-year-lumo-inject-modules: lumo_components_date-picker-year;

  --vaadin-date-picker-overlay-lumo-inject: 1;
  --vaadin-date-picker-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_mixins_menu-overlay-ext,
    lumo_components_date-picker-overlay;

  --vaadin-date-picker-overlay-content-lumo-inject: 1;
  --vaadin-date-picker-overlay-content-lumo-inject-modules: lumo_components_date-picker-overlay-content;

  --vaadin-month-calendar-lumo-inject: 1;
  --vaadin-month-calendar-lumo-inject-modules: lumo_components_date-picker-month-calendar;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_date-time-picker {
  .vaadin-date-time-picker-container {
    --vaadin-field-default-width: auto;
  }

  .slots {
    display: flex;
    --vaadin-field-default-width: 12em;
  }

  .slots ::slotted([slot='date-picker']) {
    min-width: 0;
    flex: 1 1 auto;
  }

  .slots ::slotted([slot='time-picker']) {
    min-width: 0;
    flex: 1 1.65 auto;
  }

  ::slotted([slot='date-picker']) {
    margin-inline-end: 2px;
    --vaadin-input-field-top-end-radius: 0;
    --vaadin-input-field-bottom-end-radius: 0;
  }

  ::slotted([slot='time-picker']) {
    --vaadin-input-field-top-start-radius: 0;
    --vaadin-input-field-bottom-start-radius: 0;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_time-picker-overlay {
  :host {
    --_vaadin-time-picker-items-container-border-width: var(--lumo-space-xs);
    --_vaadin-time-picker-items-container-border-style: solid;
  }

  #overlay {
    width: var(--vaadin-time-picker-overlay-width, var(--_vaadin-time-picker-overlay-default-width, auto));
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_time-picker {
  :host([opened]) {
    pointer-events: auto;
  }

  [part~='toggle-button'] {
    cursor: pointer;
  }

  [part='toggle-button']::before {
    content: var(--lumo-icons-clock);
  }

  /* See https://github.com/vaadin/vaadin-time-picker/issues/145 */
  :host([dir='rtl']) [part='input-field'] {
    direction: ltr;
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input) {
    --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input:placeholder-shown) {
    --_lumo-text-field-overflow-mask-image: none;
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input)::placeholder {
    direction: rtl;
    text-align: left;
  }
}
:is(:root, :host)::before {
  --vaadin-time-picker-lumo-inject: 1;
  --vaadin-time-picker-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_time-picker;

  --vaadin-time-picker-item-lumo-inject: 1;
  --vaadin-time-picker-item-lumo-inject-modules:
    lumo_components_item,
    lumo_components_combo-box-item;

  --vaadin-time-picker-overlay-lumo-inject: 1;
  --vaadin-time-picker-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_mixins_combo-box-overlay,
    lumo_components_time-picker-overlay;
}
:is(:root, :host)::before {
  --vaadin-date-time-picker-lumo-inject: 1;
  --vaadin-date-time-picker-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_custom-field,
    lumo_components_date-time-picker;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-details-summary-lumo-inject: 1;
  --vaadin-details-summary-lumo-inject-modules: lumo_components_details-summary;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-details-lumo-inject: 1;
  --vaadin-details-lumo-inject-modules: lumo_components_details;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_resizable-overlay {
  [part='overlay'] {
    position: relative;
    overflow: visible;
    max-height: 100%;
    display: flex;
  }

  [part='content'] {
    box-sizing: border-box;
    height: 100%;
  }

  .resizer-container {
    display: flex;
    flex-direction: column;
    flex-grow: 1;
    border-radius: inherit; /* prevent child elements being drawn outside part=overlay */
  }

  [part='overlay'][style] .resizer-container {
    min-height: 100%;
    width: 100%;
  }

  :host(:not([resizable])) .resizer {
    display: none;
  }

  :host([resizable]) [part='title'] {
    cursor: move;
    -webkit-user-select: none;
    user-select: none;
  }

  .resizer {
    position: absolute;
    height: 16px;
    width: 16px;
  }

  .resizer.edge {
    height: 8px;
    width: 8px;
    inset: -4px;
  }

  .resizer.edge.n {
    width: auto;
    bottom: auto;
    cursor: ns-resize;
  }

  .resizer.ne {
    top: -4px;
    right: -4px;
    cursor: nesw-resize;
  }

  .resizer.edge.e {
    height: auto;
    left: auto;
    cursor: ew-resize;
  }

  .resizer.se {
    bottom: -4px;
    right: -4px;
    cursor: nwse-resize;
  }

  .resizer.edge.s {
    width: auto;
    top: auto;
    cursor: ns-resize;
  }

  .resizer.sw {
    bottom: -4px;
    left: -4px;
    cursor: nesw-resize;
  }

  .resizer.edge.w {
    height: auto;
    right: auto;
    cursor: ew-resize;
  }

  .resizer.nw {
    top: -4px;
    left: -4px;
    cursor: nwse-resize;
  }
}
:is(:root, :host)::before {
  --vaadin-dialog-overlay-lumo-inject: 1;
  --vaadin-dialog-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_mixins_resizable-overlay,
    lumo_components_dialog-overlay;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_drawer-toggle {
  :host {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: default;
    position: relative;
    outline: none;
    width: var(--lumo-size-l);
    height: var(--lumo-size-l);
    min-width: auto;
    margin: 0 var(--lumo-space-s);
    padding: 0;
    background: transparent;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: inherit;
    height: auto;
    width: auto;
    background: transparent;
    top: auto;
  }

  [part='icon']::after,
  [part='icon']::before {
    content: '';
  }

  [part='icon']::after {
    top: 6px;
  }

  [part='icon']::before {
    top: 12px;
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    content: var(--lumo-icons-menu);
  }

  :host([slot~='navbar']) {
    color: var(--lumo-secondary-text-color);
  }
}
:is(:root, :host)::before {
  --vaadin-drawer-toggle-lumo-inject: 1;
  --vaadin-drawer-toggle-lumo-inject-modules:
    lumo_components_button,
    lumo_components_drawer-toggle;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_email-field {
  /* See https://github.com/vaadin/vaadin-text-field/issues/466 */

  :host([dir='rtl']) [part='input-field'] {
    direction: ltr;
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input) {
    --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input)::placeholder {
    direction: rtl;
    text-align: left;
  }

  :host([dir='rtl']) [part='input-field'] ::slotted(input:placeholder-shown) {
    --_lumo-text-field-overflow-mask-image: none;
  }
}
:is(:root, :host)::before {
  --vaadin-email-field-lumo-inject: 1;
  --vaadin-email-field-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_email-field;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_field-outline {
  :host {
    display: block;
    box-sizing: border-box;
    position: absolute;
    inset: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    user-select: none;
    opacity: 0;
    --_active-user-color: transparent;
    transition: opacity 0.3s;
    mask-image: none !important;
  }

  :host([has-active-user]) {
    opacity: 1;
  }

  :host::before {
    content: '';
    position: absolute;
    inset: 0;
    box-shadow: 0 0 0 2px var(--_active-user-color);
    border-radius: var(--lumo-border-radius-s);
    transition: box-shadow 0.3s;
  }

  :host([context$='checkbox'])::before {
    box-shadow:
      0 0 0 2px var(--lumo-base-color),
      0 0 0 4px var(--_active-user-color);
  }

  :host([context$='radio-button'])::before {
    border-radius: 50%;
    box-shadow:
      0 0 0 3px var(--lumo-base-color),
      0 0 0 5px var(--_active-user-color);
  }

  :host([context$='item'])::before {
    box-shadow: inset 0 0 0 2px var(--_active-user-color);
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_user-tag {
  :host {
    display: block;
    box-sizing: border-box;
    margin: 0 0 var(--vaadin-user-tag-offset);
    opacity: 0;
    height: 1.3rem;
    transition: opacity 0.2s ease-in-out;
    background-color: var(--vaadin-user-tag-color);
    color: #fff;
    cursor: default;
    -webkit-user-select: none;
    user-select: none;
    --vaadin-user-tag-offset: 4px;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-xxs);
    border-radius: var(--lumo-border-radius-s);
    box-shadow: var(--lumo-box-shadow-xs);
    --vaadin-user-tag-offset: var(--lumo-space-xs);
  }

  :host(.show) {
    opacity: 1;
  }

  :host(:last-of-type) {
    margin-bottom: 0;
  }

  [part='name'] {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
    box-sizing: border-box;
    height: 1.3rem;
    font-size: 13px;
    color: var(--lumo-primary-contrast-color);
    padding: 0.3em calc(0.3em + var(--lumo-border-radius-s) / 4);
    line-height: 1;
    font-weight: 500;
    min-width: calc(var(--lumo-line-height-xs) * 1em + 0.45em);
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_user-tags-overlay {
  [part='overlay'] {
    box-shadow: none;
    background: transparent;
    position: relative;
    left: -4px;
    padding: 4px;
    outline: none;
    overflow: visible;
    will-change: opacity, transform;
  }

  [part='content'] {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    padding: 0;
  }

  :host([dir='rtl']) [part='overlay'] {
    left: auto;
    right: -4px;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }

  :host([opening]) [part='overlay'] {
    animation: 0.1s lumo-user-tags-enter ease-out both;
  }

  @keyframes lumo-user-tags-enter {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) [part='overlay'] {
    animation: 0.1s lumo-user-tags-exit both;
  }

  @keyframes lumo-user-tags-exit {
    100% {
      opacity: 0;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-user-tags-overlay-lumo-inject: 1;
  --vaadin-user-tags-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_components_user-tags-overlay;

  --vaadin-user-tag-lumo-inject: 1;
  --vaadin-user-tag-lumo-inject-modules: lumo_components_user-tag;

  --vaadin-field-outline-lumo-inject: 1;
  --vaadin-field-outline-lumo-inject-modules: lumo_components_field-outline;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_form-item {
  [part='label'] {
    /* font-weight, margin-bottom, transition and line-height same as for part label in text-field */
    color: var(--lumo-secondary-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-s);
    font-weight: 500;
    margin-top: var(--lumo-space-m);
    margin-left: calc(var(--lumo-border-radius-m) / 4);
    margin-bottom: var(--lumo-space-xs);
    line-height: 1.333;
  }

  [part='required-indicator']::after {
    content: var(--lumo-required-field-indicator, '\\2022');
    transition: opacity 0.2s;
    opacity: 0;
    color: var(--lumo-required-field-indicator-color, var(--lumo-primary-text-color));
    position: relative;
    width: 1em;
    text-align: center;
  }

  :host([required]) [part='required-indicator']::after {
    opacity: 1;
  }

  :host([invalid]) [part='required-indicator']::after {
    color: var(--lumo-required-field-indicator-color, var(--lumo-error-text-color));
  }
}
:is(:root, :host)::before {
  --vaadin-form-item-lumo-inject: 1;
  --vaadin-form-item-lumo-inject-modules: lumo_components_form-item;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-form-layout-lumo-inject: 1;
  --vaadin-form-layout-lumo-inject-modules: lumo_components_form-layout;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_mixins_grid-pro-editor {
  :host([theme~='grid-pro-editor']) {
    position: absolute;
    inset: 0;
    padding: 0;
    will-change: transform;
    font-size: inherit;
    --lumo-text-field-size: 27px;
    /* outline similar to what grid uses */
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  :host([theme~='grid-pro-editor']) [part='input-field'] {
    padding: 0;
    border-radius: 0;
    flex-grow: 1;
    font-weight: 400;
    --vaadin-input-field-border-color: transparent;
  }

  /* reset outline inherited from text-field */
  :host([theme~='grid-pro-editor'][focus-ring]) [part='input-field'] {
    box-shadow: none;
  }

  :host([theme~='grid-pro-editor']) ::slotted(input) {
    padding: 0 var(--lumo-space-m);
    font-size: inherit;
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_grid-pro-edit-select {
  :host([theme~='grid-pro-editor']) [part='toggle-button'] {
    margin-right: var(--lumo-space-xs);
  }

  :host([theme~='grid-pro-editor']) [part='input-field'] ::slotted([slot='value']) {
    box-sizing: border-box;
    padding: 0 var(--lumo-space-m);
    font-size: var(--lumo-font-size-m);
    /* prevent selection on editor focus */
    -webkit-user-select: none;
    user-select: none;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_select {
  :host {
    position: relative;
    /* Disable pointer focus-ring for select, not supported yet */
    --lumo-input-field-pointer-focus-visible: 0;
  }

  ::slotted(div[slot='overlay']) {
    display: contents;
  }

  :host(:not([theme*='align'])) ::slotted([slot='value']) {
    text-align: start;
  }

  [part='input-field'] {
    cursor: var(--lumo-clickable-cursor);
  }

  [part='input-field'] ::slotted([slot='value']) {
    flex-grow: 1;
    font-weight: var(--vaadin-input-field-value-font-weight, 500);
  }

  [part='input-field'] ::slotted([slot='value']:not([placeholder])) {
    color: var(--vaadin-input-field-value-color, var(--lumo-body-text-color));
  }

  :host([readonly]) [part='input-field'] ::slotted([slot='value']:not([placeholder])) {
    color: var(--lumo-secondary-text-color);
  }

  /* placeholder styles */
  [part='input-field'] ::slotted([slot='value'][placeholder]) {
    color: var(--vaadin-input-field-placeholder-color, var(--lumo-secondary-text-color));
  }

  :host(:is([readonly], [disabled])) ::slotted([slot='value'][placeholder]) {
    opacity: 0;
  }

  [part='toggle-button']::before {
    content: var(--lumo-icons-dropdown);
  }

  /* Highlight the toggle button when hovering over the entire component */
  :host(:hover:not([readonly]):not([disabled])) [part='toggle-button'] {
    color: var(--lumo-contrast-80pct);
  }

  :host([theme~='small']) [part='input-field'] ::slotted([slot='value']) {
    --_lumo-selected-item-height: var(--lumo-size-s);
    --_lumo-selected-item-padding: 0;
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_select-overlay {
  :host {
    align-items: flex-start;
    justify-content: flex-start;
    --_lumo-item-selected-icon-display: block;
  }

  /* Small viewport adjustment */
  :host([phone]) {
    /* stylelint-disable declaration-block-no-redundant-longhand-properties */
    top: 0 !important;
    right: 0 !important;
    bottom: var(--vaadin-overlay-viewport-bottom, 0) !important;
    left: 0 !important;
    /* stylelint-enable declaration-block-no-redundant-longhand-properties */
    align-items: stretch;
    justify-content: flex-end;
  }

  :host(:not([phone])) [part='overlay'] {
    min-width: var(--vaadin-select-overlay-width, var(--_vaadin-select-overlay-default-width));
  }

  :host([no-vertical-overlap][top-aligned]) [part='overlay'] {
    margin-block-start: var(--lumo-space-xs);
  }

  :host([no-vertical-overlap][bottom-aligned]) [part='overlay'] {
    margin-block-end: var(--lumo-space-xs);
  }

  :host([theme~='align-left']) {
    text-align: left;
  }

  :host([theme~='align-right']) {
    text-align: right;
  }

  :host([theme~='align-center']) {
    text-align: center;
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 3px solid;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_select-value-button {
  :host {
    display: inline-block;
    position: relative;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    user-select: none;
    min-width: 0;
    width: 0;
    font-family: var(--lumo-font-family);
    font-size: var(--vaadin-input-field-value-font-size, var(--lumo-font-size-m));
    padding: 0 0.25em;
    --_lumo-selected-item-height: var(--lumo-size-m);
    --_lumo-selected-item-padding: 0.5em;
  }

  ::slotted(*) {
    padding: var(--_lumo-selected-item-padding) 0 var(--_lumo-selected-item-padding) 0;
    flex: auto;
    min-height: var(--_lumo-selected-item-height);
    font-size: inherit;
  }

  ::slotted(*:hover) {
    background-color: transparent;
  }

  /* placeholder styles */
  ::slotted(*:not([selected])) {
    line-height: 1;
  }

  .vaadin-button-container {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: inherit;
    width: 100%;
    height: 100%;
    min-height: inherit;
    text-shadow: inherit;
  }

  [part='label'] {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    width: 100%;
    line-height: inherit;
  }
}
:is(:root, :host)::before {
  --vaadin-select-lumo-inject: 1;
  --vaadin-select-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_select;

  --vaadin-select-item-lumo-inject: 1;
  --vaadin-select-item-lumo-inject-modules: lumo_components_item;

  --vaadin-select-overlay-lumo-inject: 1;
  --vaadin-select-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_mixins_menu-overlay-ext,
    lumo_components_select-overlay;

  --vaadin-select-list-box-lumo-inject: 1;
  --vaadin-select-list-box-lumo-inject-modules: lumo_components_list-box;

  --vaadin-select-value-button-lumo-inject: 1;
  --vaadin-select-value-button-lumo-inject-modules: lumo_components_select-value-button;
}
:is(:root, :host)::before {
  --vaadin-grid-pro-edit-text-field-lumo-inject: 1;
  --vaadin-grid-pro-edit-text-field-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_mixins_grid-pro-editor;

  --vaadin-grid-pro-edit-select-lumo-inject: 1;
  --vaadin-grid-pro-edit-select-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_mixins_grid-pro-editor,
    lumo_components_select,
    lumo_components_grid-pro-edit-select;

  --vaadin-grid-pro-edit-checkbox-lumo-inject: 1;
  --vaadin-grid-pro-edit-checkbox-lumo-inject-modules:
    lumo_mixins_checkable-field,
    lumo_components_checkbox;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_grid-pro {
  :host([navigating]) [part~='cell']:active::before {
    content: '';
    position: absolute;
    inset: 0;
    pointer-events: none;
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part~='editable-cell'],
  [part~='editable-cell'] ::slotted(vaadin-grid-cell-content) {
    cursor: var(--lumo-clickable-cursor);
  }

  [part~='editable-cell']:hover,
  [part~='editable-cell']:focus {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
  }

  /* Indicate editable cells */

  :host([theme~='highlight-editable-cells']) [part~='editable-cell'] {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
  }

  :host([theme~='highlight-editable-cells']) [part~='editable-cell']:hover,
  :host([theme~='highlight-editable-cells']) [part~='editable-cell']:focus {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-10pct), var(--lumo-contrast-10pct));
  }

  /* Indicate read-only cells */

  /* prettier-ignore */
  :host([theme~='highlight-read-only-cells']) [tabindex]:not([part~='editable-cell']):not([part~='header-cell']):not([part~='footer-cell']) {
    background-image: repeating-linear-gradient(
      135deg,
      transparent,
      transparent 6px,
      var(--lumo-contrast-5pct) 6px,
      var(--lumo-contrast-5pct) 14px
    );
  }

  /* Loading editor cell styles are used by Flow GridPro */
  :host([loading-editor]) [part~='focused-cell']::before {
    content: '';
    position: absolute;
    inset: 0;
    pointer-events: none;
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
    animation: vaadin-grid-pro-loading-editor 1.4s infinite;
    opacity: 0;
  }

  @keyframes vaadin-grid-pro-loading-editor {
    50% {
      opacity: 1;
    }
  }

  [part~='updating-cell']::after {
    content: '';
    position: absolute;
    inset: var(--_cell-padding);
    margin: var(--_focus-ring-width);
    border-radius: 4px;
    background-size: max(4em, 50%);
    background-repeat: no-repeat;
    background-position: min(-200%, -4em) 0;
    background-image: linear-gradient(90deg, transparent, var(--lumo-contrast-10pct), transparent);
    animation: vaadin-grid-pro-updating-cell 1.3s ease-out infinite;
  }

  @keyframes vaadin-grid-pro-updating-cell {
    100% {
      background-position: max(300%, 8em) 0;
    }
  }

  :host([loading-editor]) [part~='focused-cell'] ::slotted(vaadin-grid-cell-content),
  [part~='updating-cell'] ::slotted(vaadin-grid-cell-content) {
    opacity: 0;
    pointer-events: none;
  }
}
:is(:root, :host)::before {
  --vaadin-grid-pro-lumo-inject: 1;
  --vaadin-grid-pro-lumo-inject-modules:
    lumo_components_grid,
    lumo_components_grid-pro;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_grid-tree-toggle {
  :host {
    --vaadin-grid-tree-toggle-level-offset: 2em;
    display: inline-flex;
    max-width: 100%;
    align-items: center;
    vertical-align: middle;
    transform: translateX(calc(var(--lumo-space-s) * -1));
    -webkit-tap-highlight-color: transparent;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host(:not([leaf])) {
    cursor: default;
  }

  #level-spacer,
  [part='toggle'] {
    flex: none;
  }

  #level-spacer {
    display: inline-block;
    width: calc(var(--_level, '0') * var(--vaadin-grid-tree-toggle-level-offset));
  }

  [part='toggle']::before {
    line-height: 1em; /* make icon font metrics not affect baseline */
    font-family: 'lumo-icons';
    display: inline-block;
    height: 100%;
  }

  :host(:not([expanded])) [part='toggle']::before {
    content: var(--lumo-icons-angle-right);
  }

  :host([expanded]) [part='toggle']::before {
    content: var(--lumo-icons-angle-right);
    transform: rotate(90deg);
  }

  :host([leaf]) [part='toggle'] {
    visibility: hidden;
  }

  slot {
    display: block;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  [part='toggle'] {
    display: inline-block;
    font-size: 1.5em;
    line-height: 1;
    width: 1em;
    height: 1em;
    text-align: center;
    color: var(--lumo-contrast-50pct);
    cursor: var(--lumo-clickable-cursor);
    /* Increase touch target area */
    padding: calc(1em / 3);
    margin: calc(1em / -3);
  }

  :host(:not([dir='rtl'])) [part='toggle'] {
    margin-right: 0;
  }

  @media (hover: hover) {
    :host(:hover) [part='toggle'] {
      color: var(--lumo-contrast-80pct);
    }
  }

  /* RTL specific styles */

  :host([dir='rtl']) {
    margin-left: 0;
    margin-right: calc(var(--lumo-space-s) * -1);
  }

  :host([dir='rtl']) [part='toggle'] {
    margin-left: 0;
  }

  :host([dir='rtl'][expanded]) [part='toggle']::before {
    transform: rotate(-90deg);
  }

  :host([dir='rtl']:not([expanded])) [part='toggle']::before,
  :host([dir='rtl'][expanded]) [part='toggle']::before {
    content: var(--lumo-icons-angle-left);
  }
}
:is(:root, :host)::before {
  --vaadin-grid-tree-toggle-lumo-inject: 1;
  --vaadin-grid-tree-toggle-lumo-inject-modules: lumo_components_grid-tree-toggle;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-grid-lumo-inject: 1;
  --vaadin-grid-lumo-inject-modules: lumo_components_grid;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_horizontal-layout {
  :host([theme~='margin']) {
    margin: var(--lumo-space-m);
  }

  :host([theme~='padding']) {
    padding: var(--lumo-space-m);
  }

  :host([theme~='spacing-xs']) {
    gap: var(--lumo-space-xs);
  }

  :host([theme~='spacing-s']) {
    gap: var(--lumo-space-s);
  }

  :host([theme~='spacing']) {
    gap: var(--lumo-space-m);
  }

  :host([theme~='spacing-l']) {
    gap: var(--lumo-space-l);
  }

  :host([theme~='spacing-xl']) {
    gap: var(--lumo-space-xl);
  }
}
:is(:root, :host)::before {
  --vaadin-horizontal-layout-lumo-inject: 1;
  --vaadin-horizontal-layout-lumo-inject-modules: lumo_components_horizontal-layout;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_icon {
  :host {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }
}
:is(:root, :host)::before {
  --vaadin-icon-lumo-inject: 1;
  --vaadin-icon-lumo-inject-modules: lumo_components_icon;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_number-field {
  :host([readonly]) [part$='button'] {
    pointer-events: none;
  }

  :host([step-buttons-visible]:not([theme~='align-right'])) ::slotted(input) {
    text-align: center;
  }

  :host(:not([disabled])) [part$='button'][disabled] {
    opacity: 0.2;
  }

  :host([step-buttons-visible]) [part='input-field'] {
    padding: 0;
  }

  [part='decrease-button'],
  [part='increase-button'] {
    cursor: pointer;
    width: 1.5em;
    height: 1.5em;
    -webkit-user-select: none;
    user-select: none;
  }

  [part='decrease-button']::before,
  [part='increase-button']::before {
    margin-top: 0.25em;
  }

  [part='decrease-button']::before {
    content: var(--lumo-icons-minus);
  }

  [part='increase-button']::before {
    content: var(--lumo-icons-plus);
  }

  /* RTL specific styles */
  :host([dir='rtl']) [part='input-field'] {
    direction: ltr;
  }

  :host([dir='rtl']:not([theme~='align-right'])) ::slotted(input) {
    --_lumo-text-field-overflow-mask-image: linear-gradient(to left, transparent, #000 1.25em);
  }
}
:is(:root, :host)::before {
  --vaadin-integer-field-lumo-inject: 1;
  --vaadin-integer-field-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_number-field;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-item-lumo-inject: 1;
  --vaadin-item-lumo-inject-modules: lumo_components_item;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-list-box-lumo-inject: 1;
  --vaadin-list-box-lumo-inject-modules: lumo_components_list-box;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_login-overlay-wrapper {
  :host {
    inset: 0;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  [part='overlay'] {
    outline: none;
    background: none;
    border-radius: 0;
    box-shadow: none;
    width: 100%;
    height: 100%;
  }

  [part='card'] {
    max-width: 100%;
    box-sizing: border-box;
    overflow: hidden;
    display: flex;
    flex-direction: column;
    width: calc(var(--lumo-size-m) * 10);
    background: var(--lumo-base-color) linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
    border-radius: var(--lumo-border-radius-l);
    box-shadow: var(--lumo-box-shadow-s);
    margin: var(--lumo-space-s);
    height: auto;
  }

  [part='brand'] {
    box-sizing: border-box;
    overflow: hidden;
    flex-grow: 1;
    flex-shrink: 0;
    display: flex;
    flex-direction: column;
    justify-content: flex-end;
    padding: var(--lumo-space-l) var(--lumo-space-xl) var(--lumo-space-l) var(--lumo-space-l);
    background-color: var(--lumo-primary-color);
    color: var(--lumo-primary-contrast-color);
    min-height: calc(var(--lumo-size-m) * 5);
  }

  ::slotted([slot='title']) {
    color: inherit;
    margin: 0;
    font-size: var(--lumo-font-size-xxxl);
    font-weight: 600;
    line-height: var(--lumo-line-height-xs);
  }

  [part='backdrop'] {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
  }

  [part='description'] {
    line-height: var(--lumo-line-height-s);
    color: var(--lumo-tint-70pct);
    margin: 0.5em 0 0;
  }

  [part='content'] {
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
  }

  ::slotted(vaadin-login-form-wrapper) {
    min-height: 100%;
    max-width: 100%;
  }

  /* Small screen */
  @media only screen and (max-width: 500px) {
    [part='overlay'],
    [part='content'] {
      height: 100%;
    }

    [part='content'] {
      min-height: 100%;
      background: var(--lumo-base-color);
      align-items: flex-start;
    }

    [part='card'],
    [part='overlay'] {
      width: 100%;
      border-radius: 0;
      box-shadow: none;
      margin: 0;
    }

    /* RTL styles */
    :host([dir='rtl']) [part='brand'] {
      padding: var(--lumo-space-l) var(--lumo-space-l) var(--lumo-space-l) var(--lumo-space-xl);
    }
  }

  /* Landscape small screen */
  @media only screen and (max-height: 600px) and (min-width: 600px) and (orientation: landscape) {
    [part='card'] {
      flex-direction: row;
      align-items: stretch;
      max-width: calc(var(--lumo-size-m) * 16);
      width: 100%;
    }

    [part='brand'],
    [part='form-wrapper'] {
      flex: auto;
      flex-basis: 0;
      box-sizing: border-box;
    }

    [part='brand'] {
      justify-content: flex-start;
    }

    [part='form-wrapper'] {
      padding: var(--lumo-space-l);
      overflow: auto;
    }

    ::slotted(vaadin-login-form-wrapper) {
      flex: 1;
      padding: 2px;
    }
  }

  /* Landscape really small screen */
  @media only screen and (max-height: 500px) and (min-width: 600px) and (orientation: landscape),
    only screen and (max-width: 600px) and (min-width: 600px) and (orientation: landscape) {
    [part='content'] {
      height: 100vh;
    }

    [part='card'] {
      margin: 0;
      width: 100%;
      max-width: none;
      height: 100%;
      flex: auto;
      border-radius: 0;
      box-shadow: none;
    }

    [part='form-wrapper'] {
      height: 100%;
      overflow: auto;
    }
  }

  /* Handle iPhone X notch */
  @media only screen and (device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) {
    [part='card'] {
      padding-right: env(safe-area-inset-right);
      padding-left: env(safe-area-inset-left);
    }

    [part='brand'] {
      margin-left: calc(env(safe-area-inset-left) * -1);
      padding-left: calc(var(--lumo-space-l) + env(safe-area-inset-left));
    }

    /* RTL styles */
    :host([dir='rtl']) [part='card'] {
      padding-left: env(safe-area-inset-right);
      padding-right: env(safe-area-inset-left);
    }

    :host([dir='rtl']) [part='brand'] {
      margin-right: calc(env(safe-area-inset-left) * -1);
      padding-right: calc(var(--lumo-space-l) + env(safe-area-inset-left));
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_login-form-wrapper {
  :host {
    display: flex;
    flex-direction: column;
    box-sizing: border-box;
    padding: var(--lumo-space-l);
    overflow: hidden;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    width: calc(var(--lumo-size-m) * 10);
    max-width: 100%;
    background: var(--lumo-base-color) linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
  }

  :host([hidden]) {
    display: none !important;
  }

  ::slotted(form) {
    display: flex;
    flex-direction: column;
  }

  ::slotted([slot='form-title']) {
    margin: 0;
    margin-top: calc(var(--lumo-font-size-xxxl) - var(--lumo-font-size-xxl));
    color: var(--lumo-header-text-color);
    font-size: var(--lumo-font-size-xxl);
    font-weight: 600;
    line-height: var(--lumo-line-height-xs);
  }

  [part='error-message'] {
    position: relative;
    background-color: var(--lumo-error-color-10pct);
    padding: var(--lumo-space-m);
    border-radius: var(--lumo-border-radius-m);
    margin-top: var(--lumo-space-m);
    margin-bottom: var(--lumo-space-s);
    color: var(--lumo-error-text-color);
  }

  strong {
    font-weight: 600;
  }

  ::slotted([slot='submit']) {
    margin-top: var(--lumo-space-l);
    margin-bottom: var(--lumo-space-s);
  }

  ::slotted([slot='forgot-password']) {
    margin: var(--lumo-space-s) auto;
  }

  :host(:not([dir='rtl'])) [part='error-message'] {
    padding-left: var(--lumo-size-m);
  }

  :host([dir='rtl']) [part='error-message'] {
    padding-right: var(--lumo-size-m);
  }

  [part='error-message']::before {
    content: var(--lumo-icons-error);
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    position: absolute;
    width: var(--lumo-size-m);
    height: 1em;
    line-height: 1;
    text-align: center;
  }

  :host(:not([dir='rtl'])) [part='error-message']::before {
    /* Visual centering */
    margin-left: calc(var(--lumo-size-m) * -0.95);
  }

  :host([dir='rtl']) [part='error-message']::before {
    /* Visual centering */
    margin-right: calc(var(--lumo-size-m) * -0.95);
  }

  [part='error-message-title'] {
    display: block;
    margin: 0 0 0.25em;
    color: inherit;
    line-height: var(--lumo-line-height-xs);
  }

  [part='error-message-description'] {
    font-size: var(--lumo-font-size-s);
    line-height: var(--lumo-line-height-s);
    margin: 0;
    opacity: 0.9;
  }

  [part='footer'] {
    font-size: var(--lumo-font-size-xs);
    line-height: var(--lumo-line-height-s);
    color: var(--lumo-secondary-text-color);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_password-field-button {
  :host {
    position: absolute;
    right: 0;
    top: 0;
    margin: 0;
    padding: 0;
    width: 100%;
    height: 100%;
    min-width: auto;
    background: transparent;
    outline: none;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_password-field {
  [part='reveal-button']::before {
    content: var(--lumo-icons-eye);
  }

  :host([password-visible]) [part='reveal-button']::before {
    content: var(--lumo-icons-eye-disabled);
  }

  /* Make it easy to hide the button across the whole app */
  [part='reveal-button'] {
    position: relative;
    display: var(--lumo-password-field-reveal-button-display, block);
  }

  [part='reveal-button'][hidden] {
    display: none !important;
  }
}
:is(:root, :host)::before {
  --vaadin-password-field-lumo-inject: 1;
  --vaadin-password-field-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_password-field;

  --vaadin-password-field-button-lumo-inject: 1;
  --vaadin-password-field-button-lumo-inject-modules:
    lumo_components_button,
    lumo_components_password-field-button;
}
:is(:root, :host)::before {
  --vaadin-login-form-wrapper-lumo-inject: 1;
  --vaadin-login-form-wrapper-lumo-inject-modules: lumo_components_login-form-wrapper;
}
:is(:root, :host)::before {
  --vaadin-login-overlay-wrapper-lumo-inject: 1;
  --vaadin-login-overlay-wrapper-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_components_login-overlay-wrapper;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_map {
  :host {
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    --vaadin-map-controls-inset: var(--lumo-space-xs);
    --vaadin-map-icon-zoom-in: var(--lumo-icons-plus);
    --vaadin-map-icon-zoom-out: var(--lumo-icons-minus);
    --vaadin-map-icon-compass: var(--lumo-icons-arrow-up);
    --vaadin-map-icon-overview-map-collapse: var(--lumo-icons-angle-down);
    --vaadin-map-icon-overview-map-expand: var(--lumo-icons-angle-up);
    --vaadin-map-icon-close: var(--lumo-icons-cross);
    --vaadin-map-icon-attribution-collapse: var(--lumo-icons-angle-right);
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host(:not([theme~='no-border'])) {
    border-radius: var(--lumo-border-radius-l);
  }

  :host(:not([theme~='no-border']))::before {
    border: 1px solid var(--lumo-contrast-10pct);
  }

  :host([focus-ring]) {
    outline: none;
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  .ol-overviewmap button span:empty::before,
  .ol-zoom-in:empty::before,
  .ol-zoom-out:empty::before,
  .ol-compass:empty::before,
  .ol-full-screen button:empty::before,
  .ol-full-screen-true:empty::before {
    background: transparent;
    mask-image: none;
    display: inline;
    width: auto;
    height: auto;
  }

  .ol-control:not(.ol-uncollapsible):hover {
    box-shadow: var(--lumo-box-shadow-s);
    background-color: var(--lumo-shade-20pct);
  }

  .ol-scale-bar-inner {
    border-radius: var(--lumo-border-radius-s);
  }

  .ol-compass:empty::before {
    content: var(--vaadin-map-icon-compass);
  }

  .ol-full-screen {
    height: var(--lumo-size-s);
  }

  .ol-full-screen button:empty::before {
    content: var(--vaadin-map-icon-fullscreen, '\\2922');
  }

  .ol-full-screen .ol-full-screen-true:empty::before {
    content: var(--vaadin-map-icon-close, '\\00D7');
  }

  .ol-overviewmap button span:empty::before {
    content: var(--vaadin-map-icon-overview-map-collapse);
  }

  .ol-overviewmap.ol-collapsed button span:empty::before {
    content: var(--vaadin-map-icon-overview-map-expand);
  }

  .ol-overviewmap-map {
    margin: var(--lumo-space-xs);
    border-radius: var(--lumo-border-radius-s);
  }

  .ol-overviewmap:not(.ol-collapsed),
  .ol-overviewmap:not(.ol-collapsed):hover {
    background-color: var(--lumo-base-color);
    box-shadow: var(--lumo-box-shadow-s);
    transition: 0.15s box-shadow;
  }

  .ol-overviewmap.ol-collapsed button {
    rotate: none;
  }

  .ol-zoomslider button {
    height: var(--lumo-space-m);
  }

  .ol-zoomslider:hover button {
    box-shadow: var(--lumo-box-shadow-s);
  }

  .ol-control,
  .ol-scale-bar,
  .ol-scale-line {
    margin: var(--lumo-space-xs);
  }

  .ol-control {
    border-radius: var(--lumo-border-radius-m);
    transition:
      0.15s box-shadow,
      0.15s background-color;
    -webkit-backdrop-filter: blur(8px);
  }

  .ol-control:hover {
    background-color: var(--lumo-base-color);
  }

  .ol-control button {
    width: var(--lumo-size-s);
    height: var(--lumo-size-s);
    border-radius: inherit;
    font-family: 'lumo-icons';
    font-size: var(--lumo-icon-size-s);
    font-weight: 400;
  }

  .ol-control button,
  .ol-attribution:not(.ol-uncollapsible) ul {
    display: block;
    background-color: var(--lumo-base-color);
    color: var(--lumo-body-text-color);
  }

  .ol-control button:hover {
    color: var(--lumo-primary-text-color);
  }

  .ol-control button:active {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
  }

  .ol-control button:focus-visible {
    outline: none;
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  .ol-zoom-in:empty::before {
    content: var(--vaadin-map-icon-zoom-in);
  }

  .ol-zoom-out:empty::before {
    content: var(--vaadin-map-icon-zoom-out);
  }

  .ol-attribution.ol-uncollapsible {
    border-radius: var(--lumo-border-radius-m) 0 0 0;
  }

  .ol-attribution button span:empty::before {
    content: var(--vaadin-map-icon-attribution-collapse, '\\\\25B8');
  }

  .ol-attribution.ol-collapsed button span:empty::before {
    content: var(--vaadin-map-icon-attribution-expand, '\\\\2139');
  }

  .ol-attribution ul {
    font-size: var(--lumo-font-size-xxs);
    color: var(--lumo-secondary-text-color);
    padding: var(--lumo-space-xs) var(--lumo-space-s);
    cursor: default;
  }

  .ol-attribution:not(.ol-uncollapsible) ul {
    background-color: var(--lumo-base-color);
  }
}
:is(:root, :host)::before {
  --vaadin-map-lumo-inject: 1;
  --vaadin-map-lumo-inject-modules: lumo_components_map;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(:root, :host) {
  --vaadin-master-detail-layout-backdrop: var(
    --lumo-shade-20pct
  );
  --vaadin-master-detail-layout-detail-background: var(
    --lumo-base-color
  );
  --vaadin-master-detail-layout-detail-shadow:
    0 0 0 1px var(--lumo-shade-5pct),
    var(--lumo-box-shadow-m);
  --vaadin-master-detail-layout-border-color: var(
    --lumo-contrast-10pct
  );
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_menu-bar-button {
  :host {
    margin-block: calc(var(--lumo-space-xs) / 2);
    margin-right: calc(var(--lumo-space-xs) / 2);
    margin-left: 0;
    border-radius: 0;
  }

  [part='label'] {
    width: 100%;
  }

  /* NOTE(web-padawan): avoid using shorthand padding property for IE11 */
  [part='label'] ::slotted(vaadin-menu-bar-item) {
    justify-content: center;
    background-color: transparent;
    height: var(--lumo-button-size);
    margin: 0 calc((var(--lumo-size-m) / 3 + var(--lumo-border-radius-m) / 2) * -1);
    padding-left: calc(var(--lumo-size-m) / 3 + var(--lumo-border-radius-m) / 2);
    padding-right: calc(var(--lumo-size-m) / 3 + var(--lumo-border-radius-m) / 2);
  }

  :host([theme~='small']) [part='label'] ::slotted(vaadin-menu-bar-item) {
    min-height: var(--lumo-size-s);
    margin: 0 calc((var(--lumo-size-s) / 3 + var(--lumo-border-radius-m) / 2) * -1);
    padding-left: calc(var(--lumo-size-s) / 3 + var(--lumo-border-radius-m) / 2);
    padding-right: calc(var(--lumo-size-s) / 3 + var(--lumo-border-radius-m) / 2);
  }

  :host([theme~='tertiary']) [part='label'] ::slotted(vaadin-menu-bar-item) {
    margin: 0 calc((var(--lumo-button-size) / 6) * -1);
    padding-left: calc(var(--lumo-button-size) / 6);
    padding-right: calc(var(--lumo-button-size) / 6);
  }

  :host([theme~='tertiary-inline']) {
    margin-top: calc(var(--lumo-space-xs) / 2);
    margin-bottom: calc(var(--lumo-space-xs) / 2);
    margin-right: calc(var(--lumo-space-xs) / 2);
  }

  :host([theme~='tertiary-inline']) [part='label'] ::slotted(vaadin-menu-bar-item) {
    margin: 0;
    padding: 0;
  }

  :host([first-visible]) {
    border-radius: var(--lumo-border-radius-m) 0 0 var(--lumo-border-radius-m);

    /* Needed to retain the focus-ring with border-radius */
    margin-left: calc(var(--lumo-space-xs) / 2);
  }

  :host([last-visible]),
  :host([slot='overflow']) {
    border-radius: 0 var(--lumo-border-radius-m) var(--lumo-border-radius-m) 0;
  }

  :host([theme~='tertiary']),
  :host([theme~='tertiary-inline']) {
    border-radius: var(--lumo-border-radius-m);
  }

  :host([slot='overflow']) {
    min-width: var(--lumo-button-size);
    margin-inline-end: 0;
    padding-left: calc(var(--lumo-button-size) / 4);
    padding-right: calc(var(--lumo-button-size) / 4);
  }

  :host([slot='overflow']) ::slotted(*) {
    font-size: var(--lumo-font-size-xl);
  }

  :host([slot='overflow']) [part='prefix'],
  :host([slot='overflow']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }

  :host([theme~='dropdown-indicators']:not([slot='overflow']):not([theme~='icon'])[aria-haspopup]) [part='suffix'] {
    margin-inline-start: 0;
    width: 1em;
    height: 1em;
    line-height: 1;
    font-size: var(--lumo-icon-size-s);
    position: relative;
    inset-inline-start: 0.15em;
  }

  /* prettier-ignore */
  :host([theme~='dropdown-indicators']:not([slot='overflow']):not([theme~='icon'])[aria-haspopup]) [part='suffix']::after {
    font-family: lumo-icons;
    content: var(--lumo-icons-dropdown);
  }

  /* prettier-ignore */
  :host([theme~='dropdown-indicators']:not([slot='overflow']):not([theme~='icon'])[theme~='tertiary'][aria-haspopup]) [part='suffix'] {
    inset-inline-start: 0.05em;
  }

  /* prettier-ignore */
  :host([theme~='dropdown-indicators']:not([slot='overflow']):not([theme~='icon'])[theme~='tertiary-inline'][aria-haspopup]) [part='suffix'] {
    inset-inline-start: 0;
  }

  /* RTL styles */
  :host([dir='rtl']) {
    margin-left: calc(var(--lumo-space-xs) / 2);
    margin-right: 0;
    border-radius: 0;
  }

  :host([dir='rtl'][first-visible]) {
    border-radius: 0 var(--lumo-border-radius-m) var(--lumo-border-radius-m) 0;
    margin-right: calc(var(--lumo-space-xs) / 2);
  }

  :host([dir='rtl'][last-visible]),
  :host([dir='rtl'][slot='overflow']) {
    border-radius: var(--lumo-border-radius-m) 0 0 var(--lumo-border-radius-m);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_menu-bar-item {
  [part='content'] {
    display: flex;
    /* tweak to inherit centering from menu bar button */
    align-items: inherit;
    justify-content: inherit;
  }

  [part='content'] ::slotted(vaadin-icon) {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }

  [part='content'] ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: var(--lumo-space-xs);
    box-sizing: border-box !important;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_menu-bar-overlay {
  :host(:first-of-type) {
    padding-top: var(--lumo-space-xs);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_menu-bar {
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    position: relative;
    display: flex;
    width: 100%;
    flex-wrap: nowrap;
    overflow: hidden;
  }

  :host([has-single-button]) ::slotted(vaadin-menu-bar-button) {
    border-radius: var(--lumo-border-radius-m);
  }

  :host([theme~='end-aligned']) ::slotted(vaadin-menu-bar-button[first-visible]),
  :host([theme~='end-aligned'][has-single-button]) ::slotted(vaadin-menu-bar-button) {
    margin-inline-start: auto;
  }
}
:is(:root, :host)::before {
  --vaadin-menu-bar-lumo-inject: 1;
  --vaadin-menu-bar-lumo-inject-modules: lumo_components_menu-bar;

  --vaadin-menu-bar-overlay-lumo-inject: 1;
  --vaadin-menu-bar-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_mixins_menu-overlay-ext,
    lumo_components_context-menu-overlay,
    lumo_components_menu-bar-overlay;

  --vaadin-menu-bar-list-box-lumo-inject: 1;
  --vaadin-menu-bar-list-box-lumo-inject-modules:
    lumo_components_list-box,
    lumo_components_context-menu-list-box;

  --vaadin-menu-bar-item-lumo-inject: 1;
  --vaadin-menu-bar-item-lumo-inject-modules:
    lumo_components_item,
    lumo_components_context-menu-item,
    lumo_components_menu-bar-item;

  --vaadin-menu-bar-button-lumo-inject: 1;
  --vaadin-menu-bar-button-lumo-inject-modules:
    lumo_components_button,
    lumo_components_menu-bar-button;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_message-input {
  :host {
    align-items: flex-start;
    box-sizing: border-box;
    display: flex;
    max-height: 50vh;
    overflow: hidden;
    flex-shrink: 0;
    padding: var(--lumo-space-s) var(--lumo-space-m);
  }

  :host([hidden]) {
    display: none !important;
  }

  ::slotted([slot='button']) {
    flex-shrink: 0;
  }

  ::slotted([slot='textarea']) {
    align-self: stretch;
    flex-grow: 1;
    margin-inline-end: var(--lumo-space-s);
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_text-area {
  .vaadin-text-area-container {
    flex: auto;
  }

  /* The label, helper text and the error message should neither grow nor shrink. */
  [part='label'],
  [part='helper-text'],
  [part='error-message'] {
    flex: none;
  }

  ::slotted(textarea) {
    appearance: none;
    flex: auto;
    overflow: hidden;
    width: 100%;
    height: 100%;
    outline: none;
    resize: none;
    margin: 0;
    padding: 0 0.25em;
    border: 0;
    border-radius: 0;
    min-width: 0;
    font: inherit;
    font-size: 1em;
    line-height: normal;
    color: inherit;
    background-color: transparent;
    /* Disable default invalid style in Firefox */
    box-shadow: none;
  }

  /* Override styles from <vaadin-input-container> */
  [part='input-field'] ::slotted(textarea) {
    align-self: stretch;
    white-space: pre-wrap;
    line-height: inherit;
    --_lumo-text-field-overflow-mask-image: none;
  }

  [part='input-field'] ::slotted(:not(textarea)) {
    align-self: flex-start;
  }

  /* Workaround https://bugzilla.mozilla.org/show_bug.cgi?id=1739079 */
  :host([disabled]) ::slotted(textarea) {
    user-select: none;
  }

  [part='input-field'],
  [part='input-field'] ::slotted(textarea) {
    height: auto;
    box-sizing: border-box;
    min-height: 0;
  }

  [part='input-field'] {
    flex: auto;
    overflow: auto;
    /* Equal to the implicit padding in vaadin-text-field */
    padding-top: calc((var(--lumo-text-field-size) - 1em * var(--lumo-line-height-s)) / 2);
    padding-bottom: calc((var(--lumo-text-field-size) - 1em * var(--lumo-line-height-s)) / 2);
    transition: background-color 0.1s;
    line-height: var(--lumo-line-height-s);
  }

  :host(:not([readonly])) [part='input-field']::after {
    display: none;
  }

  :host([readonly]) [part='input-field'] {
    border: var(--vaadin-input-field-readonly-border, 1px dashed var(--lumo-contrast-30pct));
  }

  :host([readonly]) [part='input-field']::after {
    border: none;
  }

  :host(:hover:not([readonly]):not([focused]):not([invalid])) [part='input-field'] {
    background-color: var(--lumo-contrast-20pct);
  }

  @media (pointer: coarse) {
    :host(:hover:not([readonly]):not([focused]):not([invalid])) [part='input-field'] {
      background-color: var(--lumo-contrast-10pct);
    }

    :host(:active:not([readonly]):not([focused])) [part='input-field'] {
      background-color: var(--lumo-contrast-20pct);
    }
  }

  /* Use sticky positioning to keep prefix/suffix/clear button visible when scrolling textarea container */
  [part='input-field'] ::slotted([slot$='fix']),
  [part='clear-button'] {
    position: sticky;
    top: 0;
    align-self: flex-start;
  }

  [part='input-field'] ::slotted(vaadin-icon[slot$='fix']),
  [part='clear-button'] {
    /* Vertically align icon prefix/suffix/clear button with the first line of text */
    top: calc((var(--lumo-icon-size-m) - 1em * var(--lumo-line-height-s)) / -2);
    margin-top: calc((var(--lumo-icon-size-m) - 1em * var(--lumo-line-height-s)) / -2);
    /* Reduce effective height to match line height of native textarea, so icons don't increase component size when using single row */
    margin-bottom: calc((var(--lumo-icon-size-m) - 1em * var(--lumo-line-height-s)) / -2);
  }
}
:is(:root, :host)::before {
  --vaadin-text-area-lumo-inject: 1;
  --vaadin-text-area-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_text-area;
}
:is(:root, :host)::before {
  --vaadin-message-input-lumo-inject: 1;
  --vaadin-message-input-lumo-inject-modules: lumo_components_message-input;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_message {
  :host {
    display: flex;
    flex-direction: row;
    outline: none;
    color: var(--lumo-body-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
    padding: var(--lumo-space-s) var(--lumo-space-m);
    -moz-osx-font-smoothing: grayscale;
    -webkit-font-smoothing: antialiased;
    -webkit-text-size-adjust: 100%;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    display: flex;
    flex-direction: column;
    flex-grow: 1;
  }

  [part='header'] {
    align-items: baseline;
    display: flex;
    flex-flow: row wrap;
    min-height: calc(var(--lumo-font-size-m) * var(--lumo-line-height-m));
  }

  [part='name'] {
    font-weight: 500;
    margin-right: var(--lumo-space-s);
  }

  [part='name']:empty {
    margin-right: 0;
  }

  [part='message'] {
    white-space: pre-wrap;
  }

  [part='time'] {
    color: var(--lumo-secondary-text-color);
    font-size: var(--lumo-font-size-s);
  }

  ::slotted([slot='avatar']) {
    --vaadin-avatar-outline-width: 0;
    --vaadin-avatar-size: var(--lumo-size-m);
    flex-shrink: 0;
    margin-top: calc(var(--lumo-space-s));
    margin-inline-end: calc(var(--lumo-space-m));
  }

  ::slotted(vaadin-markdown) {
    white-space: normal;
  }

  :host([focus-ring]) {
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  :host([dir='rtl']) [part='name'] {
    margin-left: var(--lumo-space-s);
    margin-right: 0;
  }

  :host([dir='rtl']) [part='name']:empty {
    margin-left: 0;
  }
}
:is(:root, :host)::before {
  --vaadin-message-lumo-inject: 1;
  --vaadin-message-lumo-inject-modules: lumo_components_message;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_multi-select-combo-box-chip {
  :host {
    display: inline-flex;
    align-items: center;
    align-self: center;
    white-space: nowrap;
    box-sizing: border-box;
    font-size: var(--lumo-font-size-xxs);
    line-height: 1;
    color: var(--lumo-body-text-color);
    border-radius: var(--lumo-border-radius-s);
    background-color: var(--lumo-contrast-20pct);
    cursor: var(--lumo-clickable-cursor);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  :host([hidden]),
  :host(:is([readonly], [disabled], [slot='overflow'])) [part='remove-button'] {
    display: none !important;
  }

  :host([disabled]) {
    background-color: var(--lumo-contrast-10pct);
  }

  :host([focused]) [part='remove-button'] {
    color: inherit;
  }

  :host([slot='overflow']) {
    position: relative;
    min-width: var(--lumo-size-xxs);
    margin-inline-start: var(--lumo-space-s);
  }

  :host([slot='overflow'])::before,
  :host([slot='overflow'])::after {
    position: absolute;
    content: '';
    width: 100%;
    height: 100%;
    border-left: calc(var(--lumo-space-s) / 4) solid var(--lumo-contrast-30pct);
    border-radius: var(--lumo-border-radius-s);
  }

  :host([slot='overflow'])::before {
    left: calc(-1 * var(--lumo-space-s) / 2);
  }

  :host([slot='overflow'])::after {
    left: calc(-1 * var(--lumo-space-s));
  }

  :host([count='2']) {
    margin-inline-start: calc(var(--lumo-space-s) / 2);
  }

  :host([count='2'])::after {
    display: none;
  }

  :host([count='1']) {
    margin-inline-start: 0;
  }

  :host([count='1'])::before,
  :host([count='1'])::after {
    display: none;
  }

  [part='label'] {
    font-weight: 500;
    line-height: 1.25;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  [part='remove-button'] {
    display: flex;
    align-items: center;
    justify-content: center;
    margin-top: -0.3125em;
    margin-bottom: -0.3125em;
    margin-inline-start: auto;
    width: 1.25em;
    height: 1.25em;
    font-size: 1.5em;
    transition: none;
  }

  [part='remove-button']::before {
    content: var(--lumo-icons-cross);
  }

  :host([disabled]) [part='label'] {
    color: var(--lumo-disabled-text-color);
    -webkit-text-fill-color: var(--lumo-disabled-text-color);
    pointer-events: none;
  }

  @media (forced-colors: active) {
    :host {
      outline: 1px solid;
      outline-offset: -1px;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_multi-select-combo-box-container {
  #wrapper {
    display: flex;
    width: 100%;
    min-width: 0;
  }

  :host([auto-expand-vertically]) {
    padding-block: var(--lumo-space-xs);
  }

  :host([auto-expand-vertically]) #wrapper {
    flex-wrap: wrap;
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_multi-select-combo-box-item {
  @media (any-hover: hover) {
    :host(:hover[readonly]) {
      background-color: transparent;
      cursor: default;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_multi-select-combo-box-overlay {
  :host {
    --_vaadin-multi-select-combo-box-items-container-border-width: var(--lumo-space-xs);
    --_vaadin-multi-select-combo-box-items-container-border-style: solid;
  }

  #overlay {
    width: var(
      --vaadin-multi-select-combo-box-overlay-width,
      var(--_vaadin-multi-select-combo-box-overlay-default-width, auto)
    );
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_multi-select-combo-box {
  :host {
    max-width: 100%;
    --input-min-width: var(--vaadin-multi-select-combo-box-input-min-width, 4em);
    --_chip-min-width: var(--vaadin-multi-select-combo-box-chip-min-width, 50px);
    --_wrapper-gap: 0;
  }

  :host([opened]) {
    pointer-events: auto;
  }

  #chips {
    display: flex;
    align-items: center;
  }

  ::slotted(input) {
    box-sizing: border-box;
    flex: 1 0 var(--input-min-width);
  }

  ::slotted([slot='chip']),
  ::slotted([slot='overflow']) {
    flex: 0 1 auto;
  }

  ::slotted([slot='chip']) {
    overflow: hidden;
  }

  :host(:is([readonly], [disabled])) ::slotted(input) {
    flex-grow: 0;
    flex-basis: 0;
    padding: 0;
  }

  :host([auto-expand-vertically]) #chips {
    display: contents;
  }

  :host([auto-expand-horizontally]) [class$='container'] {
    width: auto;
  }

  :host([has-value]) {
    padding-inline-start: 0;
  }

  :host([has-value]) ::slotted(input:placeholder-shown) {
    caret-color: var(--lumo-body-text-color) !important;
  }

  [part='label'] {
    flex-shrink: 0;
  }

  /* Override input-container styles */
  [part='input-field'] ::slotted([slot='chip']),
  [part='input-field'] ::slotted([slot='overflow']) {
    min-height: auto;
    padding: 0.3125em calc(0.5em + var(--lumo-border-radius-s) / 4);
    color: var(--lumo-body-text-color);
    mask-image: none;
  }

  :host([auto-expand-vertically]) ::slotted([slot='chip']) {
    margin-block: calc(var(--lumo-space-xs) / 2);
  }

  ::slotted([slot='chip']:not([readonly]):not([disabled])) {
    padding-inline-end: 0;
  }

  :host([auto-expand-vertically]) ::slotted([slot='input']) {
    min-height: calc(var(--lumo-text-field-size, var(--lumo-size-m)) - 2 * var(--lumo-space-xs));
  }

  ::slotted([slot='chip']:not(:last-of-type)),
  ::slotted([slot='overflow']:not(:last-of-type)) {
    margin-inline-end: var(--lumo-space-xs);
  }

  ::slotted([slot='chip'][focused]) {
    background-color: var(--vaadin-selection-color, var(--lumo-primary-color));
    color: var(--lumo-primary-contrast-color);
  }

  [part='toggle-button']::before {
    content: var(--lumo-icons-dropdown);
  }

  :host([readonly][has-value]) [part='toggle-button'] {
    color: var(--lumo-contrast-60pct);
    cursor: var(--lumo-clickable-cursor);
  }
}
:is(:root, :host)::before {
  --vaadin-multi-select-combo-box-container-lumo-inject: 1;
  --vaadin-multi-select-combo-box-container-lumo-inject-modules:
    lumo_components_input-container,
    lumo_components_multi-select-combo-box-container;

  --vaadin-multi-select-combo-box-overlay-lumo-inject: 1;
  --vaadin-multi-select-combo-box-overlay-lumo-inject-modules:
    lumo_mixins_loader,
    lumo_mixins_combo-box-loader,
    lumo_mixins_overlay,
    lumo_mixins_menu-overlay-core,
    lumo_mixins_combo-box-overlay,
    lumo_components_multi-select-combo-box-overlay;

  --vaadin-multi-select-combo-box-chip-lumo-inject: 1;
  --vaadin-multi-select-combo-box-chip-lumo-inject-modules:
    lumo_mixins_field-button,
    lumo_components_multi-select-combo-box-chip;

  --vaadin-multi-select-combo-box-item-lumo-inject: 1;
  --vaadin-multi-select-combo-box-item-lumo-inject-modules:
    lumo_components_item,
    lumo_components_combo-box-item,
    lumo_components_multi-select-combo-box-item;

  --vaadin-multi-select-combo-box-lumo-inject: 1;
  --vaadin-multi-select-combo-box-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_multi-select-combo-box;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_notification-card {
  :host {
    display: block;
    position: relative;
    margin: var(--lumo-space-s);
  }

  [part='overlay'] {
    pointer-events: auto;
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    border-radius: var(--lumo-border-radius-l);
    box-shadow:
      0 0 0 1px var(--lumo-contrast-10pct),
      var(--lumo-box-shadow-l);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 400;
    line-height: var(--lumo-line-height-s);
    letter-spacing: 0;
    text-transform: none;
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  [part='content'] {
    padding: var(--lumo-space-wide-l);
    display: flex;
    align-items: center;
    justify-content: space-between;
  }

  [part='content'] ::slotted(vaadin-button) {
    flex: none;
    margin: 0 calc(var(--lumo-space-s) * -1) 0 var(--lumo-space-m);
  }

  :host([slot^='middle']) {
    max-width: 80vw;
    margin: var(--lumo-space-s) auto;
  }

  :host([slot$='stretch']) {
    margin: 0;
  }

  :host([slot$='stretch']) [part='overlay'] {
    border-radius: 0;
  }

  @media (min-width: 421px) {
    :host(:not([slot$='stretch'])) {
      display: flex;
    }

    :host([slot$='end']) {
      justify-content: flex-end;
    }

    :host([slot^='middle']),
    :host([slot$='center']) {
      display: flex;
      justify-content: center;
    }
  }

  @keyframes lumo-notification-exit-fade-out {
    100% {
      opacity: 0;
    }
  }

  @keyframes lumo-notification-enter-fade-in {
    0% {
      opacity: 0;
    }
  }

  @keyframes lumo-notification-enter-slide-down {
    0% {
      transform: translateY(-200%);
      opacity: 0;
    }
  }

  @keyframes lumo-notification-exit-slide-up {
    100% {
      transform: translateY(-200%);
      opacity: 0;
    }
  }

  @keyframes lumo-notification-enter-slide-up {
    0% {
      transform: translateY(200%);
      opacity: 0;
    }
  }

  @keyframes lumo-notification-exit-slide-down {
    100% {
      transform: translateY(200%);
      opacity: 0;
    }
  }

  :host([slot='middle'][opening]) {
    animation: lumo-notification-enter-fade-in 300ms;
  }

  :host([slot='middle'][closing]) {
    animation: lumo-notification-exit-fade-out 300ms;
  }

  :host([slot^='top'][opening]) {
    animation: lumo-notification-enter-slide-down 300ms;
  }

  :host([slot^='top'][closing]) {
    animation: lumo-notification-exit-slide-up 300ms;
  }

  :host([slot^='bottom'][opening]) {
    animation: lumo-notification-enter-slide-up 300ms;
  }

  :host([slot^='bottom'][closing]) {
    animation: lumo-notification-exit-slide-down 300ms;
  }

  :host([theme='success']) {
    --_focus-ring-gap-color: var(--lumo-success-color);
    --vaadin-focus-ring-color: var(--lumo-success-contrast-color);
  }

  :host([theme='warning']) {
    --_focus-ring-gap-color: var(--lumo-warning-color);
    --vaadin-focus-ring-color: var(--lumo-warning-contrast-color);
  }

  :host([theme='error']) {
    --_focus-ring-gap-color: var(--lumo-error-color);
    --vaadin-focus-ring-color: var(--lumo-error-contrast-color);
  }

  :host([theme='primary']) {
    --_focus-ring-gap-color: var(--lumo-primary-color);
    --vaadin-focus-ring-color: var(--lumo-primary-contrast-color);
  }

  :host([theme~='primary']) [part='overlay'] {
    background: var(--lumo-primary-color);
    color: var(--lumo-primary-contrast-color);
    box-shadow: var(--lumo-box-shadow-l);
  }

  :host([theme~='primary']) {
    --vaadin-button-background: var(--lumo-shade-20pct);
    --vaadin-button-text-color: var(--lumo-primary-contrast-color);
    --vaadin-button-primary-background: var(--lumo-primary-contrast-color);
    --vaadin-button-primary-text-color: var(--lumo-primary-text-color);
  }

  :host([theme~='contrast']) [part='overlay'] {
    background: var(--lumo-contrast);
    color: var(--lumo-base-color);
    box-shadow: var(--lumo-box-shadow-l);
  }

  :host([theme~='contrast']) {
    --vaadin-button-background: var(--lumo-contrast-20pct);
    --vaadin-button-text-color: var(--lumo-base-color);
    --vaadin-button-primary-background: var(--lumo-base-color);
    --vaadin-button-primary-text-color: var(--lumo-contrast);
  }

  :host([theme~='success']) [part='overlay'] {
    background: var(--lumo-success-color);
    color: var(--lumo-success-contrast-color);
    box-shadow: var(--lumo-box-shadow-l);
  }

  :host([theme~='success']) {
    --vaadin-button-background: var(--lumo-shade-20pct);
    --vaadin-button-text-color: var(--lumo-success-contrast-color);
    --vaadin-button-primary-background: var(--lumo-success-contrast-color);
    --vaadin-button-primary-text-color: var(--lumo-success-text-color);
  }

  :host([theme~='error']) [part='overlay'] {
    background: var(--lumo-error-color);
    color: var(--lumo-error-contrast-color);
    box-shadow: var(--lumo-box-shadow-l);
  }

  :host([theme~='error']) {
    --vaadin-button-background: var(--lumo-shade-20pct);
    --vaadin-button-text-color: var(--lumo-error-contrast-color);
    --vaadin-button-primary-background: var(--lumo-error-contrast-color);
    --vaadin-button-primary-text-color: var(--lumo-error-text-color);
  }

  :host([theme~='warning']) [part='overlay'] {
    background: var(--lumo-warning-color);
    color: var(--lumo-warning-contrast-color);
    box-shadow:
      inset 0 0 0 1px var(--lumo-contrast-20pct),
      var(--lumo-box-shadow-l);
  }

  :host([theme~='warning']) {
    --vaadin-button-background: var(--lumo-shade-20pct);
    --vaadin-button-text-color: var(--lumo-warning-contrast-color);
    --vaadin-button-primary-background: var(--lumo-shade-50pct);
    --vaadin-button-primary-text-color: var(--lumo-primary-contrast-color);
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 3px solid;
    }
  }
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_notification-container {
  :host {
    position: fixed;
    inset: 0;
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    align-items: stretch;
    pointer-events: none;

    /* Override native [popover] user agent styles */
    width: auto;
    height: auto;
    border: none;
    padding: 0;
    background-color: transparent;
    overflow: visible;
  }

  [region-group] {
    flex: 1 1 0%;
    display: flex;
  }

  [region-group='top'] {
    align-items: flex-start;
  }

  [region-group='bottom'] {
    align-items: flex-end;
  }

  [region-group] > [region] {
    flex: 1 1 0%;
  }

  @media (max-width: 420px) {
    [region-group] {
      flex-direction: column;
      align-items: stretch;
    }

    [region-group='top'] {
      justify-content: flex-start;
    }

    [region-group='bottom'] {
      justify-content: flex-end;
    }

    [region-group] > [region] {
      flex: initial;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-notification-container-lumo-inject: 1;
  --vaadin-notification-container-lumo-inject-modules: lumo_components_notification-container;

  --vaadin-notification-card-lumo-inject: 1;
  --vaadin-notification-card-lumo-inject-modules: lumo_components_notification-card;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-number-field-lumo-inject: 1;
  --vaadin-number-field-lumo-inject-modules:
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-button,
    lumo_mixins_field-helper,
    lumo_mixins_field-base,
    lumo_components_number-field;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:is(:root, :host)::before {
  --vaadin-overlay-lumo-inject: 1;
  --vaadin-overlay-lumo-inject-modules: lumo_mixins_overlay;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_popover-overlay {
  :host {
    --vaadin-popover-arrow-size: 0.5rem;
    --_default-offset: var(--lumo-space-xs);
  }

  [part='overlay'] {
    position: relative;
    overflow: visible;
    max-height: 100%;
    outline: none;
  }

  [part='content'] {
    overflow: auto;
    box-sizing: border-box;
    max-height: 100%;
    padding: var(--lumo-space-xs) var(--lumo-space-s);
  }

  /* Increase the area of the popover so the pointer can go from the target directly to it. */
  [part='overlay']::before {
    position: absolute;
    content: '';
    inset-block: calc(var(--vaadin-popover-offset-top, var(--_default-offset)) * -1)
      calc(var(--vaadin-popover-offset-bottom, var(--_default-offset)) * -1);
    inset-inline: calc(var(--vaadin-popover-offset-start, var(--_default-offset)) * -1)
      calc(var(--vaadin-popover-offset-end, var(--_default-offset)) * -1);
    z-index: -1;
    pointer-events: auto;
  }

  :host([theme~='no-padding']) [part='content'] {
    padding: 0 !important;
  }

  [part='arrow'] {
    display: none;
    position: absolute;
    height: 0;
    width: 0;
  }

  :host([theme~='arrow']) {
    --_default-offset: calc(var(--lumo-space-s) + var(--vaadin-popover-arrow-size) / 2);
  }

  :host([theme~='arrow']) [part='arrow'] {
    display: block;
  }

  :host([modeless][with-backdrop]) [part='backdrop'] {
    pointer-events: none;
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-popover-offset-top, var(--_default-offset));
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-popover-offset-bottom, var(--_default-offset));
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-popover-offset-start, var(--_default-offset));
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-popover-offset-end, var(--_default-offset));
  }

  /* top / bottom position */
  :host([theme~='arrow'][position^='top']) [part='arrow'],
  :host([theme~='arrow'][position^='bottom']) [part='arrow'] {
    border-left: var(--vaadin-popover-arrow-size) solid transparent;
    border-right: var(--vaadin-popover-arrow-size) solid transparent;
  }

  :host([theme~='arrow'][position^='bottom'][bottom-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='top'][bottom-aligned]) [part='arrow'] {
    bottom: calc(var(--vaadin-popover-arrow-size) * -1);
    border-top: var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);
    filter: drop-shadow(0 2px 1px var(--lumo-shade-10pct));
  }

  :host([theme~='arrow'][position^='bottom'][top-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='top'][top-aligned]) [part='arrow'] {
    top: calc(var(--vaadin-popover-arrow-size) * -1);
    border-bottom: var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);
    filter: drop-shadow(0 -2px 1px var(--lumo-shade-10pct));
  }

  :host([theme~='arrow'][position^='bottom'][start-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='top'][start-aligned]) [part='arrow'] {
    transform: translateX(-50%);
    inset-inline-start: 1.5rem;
  }

  :host([theme~='arrow'][position^='bottom'][end-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='top'][end-aligned]) [part='arrow'] {
    transform: translateX(50%);
    inset-inline-end: 1.5rem;
  }

  :host([theme~='arrow'][position^='bottom'][arrow-centered]) [part='arrow'],
  :host([theme~='arrow'][position^='top'][arrow-centered]) [part='arrow'] {
    transform: translateX(-50%);
    inset-inline-start: 50%;
  }

  /* start / end position */
  :host([theme~='arrow'][position^='start']) [part='arrow'],
  :host([theme~='arrow'][position^='end']) [part='arrow'] {
    border-top: var(--vaadin-popover-arrow-size) solid transparent;
    border-bottom: var(--vaadin-popover-arrow-size) solid transparent;
  }

  :host([theme~='arrow'][position^='start'][start-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='end'][start-aligned]) [part='arrow'] {
    inset-inline-start: calc(var(--vaadin-popover-arrow-size) * -1);
    border-right: var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);
    filter: drop-shadow(-2px 0 1px var(--lumo-shade-10pct));
  }

  :host([theme~='arrow'][position^='start'][end-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='end'][end-aligned]) [part='arrow'] {
    inset-inline-end: calc(var(--vaadin-popover-arrow-size) * -1);
    border-left: var(--vaadin-popover-arrow-size) solid var(--lumo-base-color);
    filter: drop-shadow(2px 0 1px var(--lumo-shade-10pct));
  }

  :host([theme~='arrow'][position^='start'][top-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='end'][top-aligned]) [part='arrow'] {
    top: 0.5rem;
  }

  :host([theme~='arrow'][position='start'][top-aligned]) [part='arrow'],
  :host([theme~='arrow'][position='end'][top-aligned]) [part='arrow'] {
    top: 50%;
    transform: translateY(-50%);
  }

  :host([theme~='arrow'][position^='start'][bottom-aligned]) [part='arrow'],
  :host([theme~='arrow'][position^='end'][bottom-aligned]) [part='arrow'] {
    bottom: 0.5rem;
  }
}
:is(:root, :host)::before {
  --vaadin-popover-overlay-lumo-inject: 1;
  --vaadin-popover-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_components_popover-overlay;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_progress-bar {
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    height: calc(var(--lumo-size-l) / 10);
    margin: var(--lumo-space-s) 0;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='bar'] {
    height: 100%;
    border-radius: var(--lumo-border-radius-m);
    background-color: var(--lumo-contrast-10pct);
  }

  [part='value'] {
    height: 100%;
    transform-origin: 0 50%;
    border-radius: var(--lumo-border-radius-m);
    background-color: var(--lumo-primary-color);
    /* Use width instead of transform to preserve border radius */
    transform: none;
    width: calc(var(--vaadin-progress-value) * 100%);
    will-change: width;
    transition: 0.1s width linear;
  }

  :host([dir='rtl']) [part='value'] {
    transform-origin: 100% 50%;
  }

  @media (forced-colors: active) {
    [part='bar'] {
      outline: 1px solid;
    }

    [part='value'] {
      background-color: AccentColor !important;
      forced-color-adjust: none;
    }
  }

  /* Indeterminate mode */
  :host([indeterminate]) [part='value'] {
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to right,
      var(--lumo-primary-color-10pct) 10%,
      var(--lumo-primary-color)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to left,
      var(--lumo-primary-color-10pct) 10%,
      var(--lumo-primary-color)
    );
    width: 100%;
    background-color: transparent !important;
    background-image: var(--lumo-progress-indeterminate-progress-bar-background);
    opacity: 0.75;
    will-change: transform;
    animation: vaadin-progress-indeterminate 1.6s infinite cubic-bezier(0.645, 0.045, 0.355, 1);
  }

  @keyframes vaadin-progress-indeterminate {
    0% {
      transform: scaleX(0.015);
      transform-origin: 0% 0%;
    }

    25% {
      transform: scaleX(0.4);
    }

    50% {
      transform: scaleX(0.015);
      transform-origin: 100% 0%;
      background-image: var(--lumo-progress-indeterminate-progress-bar-background);
    }

    50.1% {
      transform: scaleX(0.015);
      transform-origin: 100% 0%;
      background-image: var(--lumo-progress-indeterminate-progress-bar-background-reverse);
    }

    75% {
      transform: scaleX(0.4);
    }

    100% {
      transform: scaleX(0.015);
      transform-origin: 0% 0%;
      background-image: var(--lumo-progress-indeterminate-progress-bar-background-reverse);
    }
  }

  :host(:not([aria-valuenow])) [part='value']::before,
  :host([indeterminate]) [part='value']::before {
    content: '';
    display: block;
    width: 100%;
    height: 100%;
    border-radius: inherit;
    background-color: var(--lumo-primary-color);
    will-change: opacity;
    animation: vaadin-progress-pulse3 1.6s infinite cubic-bezier(0.645, 0.045, 0.355, 1);
  }

  @keyframes vaadin-progress-pulse3 {
    0% {
      opacity: 1;
    }

    10% {
      opacity: 0;
    }

    40% {
      opacity: 0;
    }

    50% {
      opacity: 1;
    }

    50.1% {
      opacity: 1;
    }

    60% {
      opacity: 0;
    }

    90% {
      opacity: 0;
    }

    100% {
      opacity: 1;
    }
  }

  /* Contrast color */
  :host([theme~='contrast']) [part='value'],
  :host([theme~='contrast']) [part='value']::before {
    background-color: var(--lumo-contrast-80pct);
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to right,
      var(--lumo-contrast-5pct) 10%,
      var(--lumo-contrast-80pct)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to left,
      var(--lumo-contrast-5pct) 10%,
      var(--lumo-contrast-60pct)
    );
  }

  /* Error color */
  :host([theme~='error']) [part='value'],
  :host([theme~='error']) [part='value']::before {
    background-color: var(--lumo-error-color);
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to right,
      var(--lumo-error-color-10pct) 10%,
      var(--lumo-error-color)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to left,
      var(--lumo-error-color-10pct) 10%,
      var(--lumo-error-color)
    );
  }

  /* Primary color */
  :host([theme~='success']) [part='value'],
  :host([theme~='success']) [part='value']::before {
    background-color: var(--lumo-success-color);
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to right,
      var(--lumo-success-color-10pct) 10%,
      var(--lumo-success-color)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to left,
      var(--lumo-success-color-10pct) 10%,
      var(--lumo-success-color)
    );
  }

  /* RTL specific styles */
  :host([indeterminate][dir='rtl']) [part='value'] {
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to left,
      var(--lumo-primary-color-10pct) 10%,
      var(--lumo-primary-color)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to right,
      var(--lumo-primary-color-10pct) 10%,
      var(--lumo-primary-color)
    );
    animation: vaadin-progress-indeterminate-rtl 1.6s infinite cubic-bezier(0.355, 0.045, 0.645, 1);
  }

  :host(:not([aria-valuenow])[dir='rtl']) [part='value']::before,
  :host([indeterminate][dir='rtl']) [part='value']::before {
    animation: vaadin-progress-pulse3 1.6s infinite cubic-bezier(0.355, 0.045, 0.645, 1);
  }

  @keyframes vaadin-progress-indeterminate-rtl {
    0% {
      transform: scaleX(0.015);
      transform-origin: 100% 0%;
    }

    25% {
      transform: scaleX(0.4);
    }

    50% {
      transform: scaleX(0.015);
      transform-origin: 0% 0%;
      background-image: var(--lumo-progress-indeterminate-progress-bar-background);
    }

    50.1% {
      transform: scaleX(0.015);
      transform-origin: 0% 0%;
      background-image: var(--lumo-progress-indeterminate-progress-bar-background-reverse);
    }

    75% {
      transform: scaleX(0.4);
    }

    100% {
      transform: scaleX(0.015);
      transform-origin: 100% 0%;
      background-image: var(--lumo-progress-indeterminate-progress-bar-background-reverse);
    }
  }

  /* Contrast color */
  :host([theme~='contrast'][dir='rtl']) [part='value'],
  :host([theme~='contrast'][dir='rtl']) [part='value']::before {
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to left,
      var(--lumo-contrast-5pct) 10%,
      var(--lumo-contrast-80pct)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to right,
      var(--lumo-contrast-5pct) 10%,
      var(--lumo-contrast-60pct)
    );
  }

  /* Error color */
  :host([theme~='error'][dir='rtl']) [part='value'],
  :host([theme~='error'][dir='rtl']) [part='value']::before {
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to left,
      var(--lumo-error-color-10pct) 10%,
      var(--lumo-error-color)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to right,
      var(--lumo-error-color-10pct) 10%,
      var(--lumo-error-color)
    );
  }

  /* Primary color */
  :host([theme~='success'][dir='rtl']) [part='value'],
  :host([theme~='success'][dir='rtl']) [part='value']::before {
    --lumo-progress-indeterminate-progress-bar-background: linear-gradient(
      to left,
      var(--lumo-success-color-10pct) 10%,
      var(--lumo-success-color)
    );
    --lumo-progress-indeterminate-progress-bar-background-reverse: linear-gradient(
      to right,
      var(--lumo-success-color-10pct) 10%,
      var(--lumo-success-color)
    );
  }
}
:is(:root, :host)::before {
  --vaadin-progress-bar-lumo-inject: 1;
  --vaadin-progress-bar-lumo-inject-modules: lumo_components_progress-bar;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_radio-button {
  :host {
    color: var(--vaadin-radio-button-label-color, var(--lumo-body-text-color));
    font-size: var(--vaadin-radio-button-label-font-size, var(--lumo-font-size-m));
    font-family: var(--lumo-font-family);
    line-height: var(--lumo-line-height-s);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: transparent;
    -webkit-user-select: none;
    user-select: none;
    cursor: default;
    outline: none;
    --_radio-button-size: var(--vaadin-radio-button-size, calc(var(--lumo-size-m) / 2));
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color));
  }

  :host([has-label]) ::slotted(label) {
    padding: var(
      --vaadin-radio-button-label-padding,
      var(--lumo-space-xs) var(--lumo-space-s) var(--lumo-space-xs) var(--lumo-space-xs)
    );
  }

  [part='radio'] {
    --_input-size: var(--_radio-button-size);
    margin: var(--lumo-space-xs);
    position: relative;
    border-radius: 50%;
    background: var(--vaadin-radio-button-background, var(--lumo-contrast-20pct));
    transition:
      transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2),
      background-color 0.15s;
    will-change: transform;
    cursor: var(--lumo-clickable-cursor);
    /* Default field border color */
    --_input-border-color: var(--vaadin-input-field-border-color, var(--lumo-contrast-50pct));
  }

  /* Used for activation "halo" */
  [part='radio']::before {
    pointer-events: none;
    color: transparent;
    width: 100%;
    height: 100%;
    border-radius: inherit;
    background-color: inherit;
    transform: scale(1.4);
    opacity: 0;
    transition:
      transform 0.1s,
      opacity 0.8s;
    will-change: transform, opacity;
  }

  /* Used for the dot */
  [part='radio']::after {
    content: '';
    pointer-events: none;
    width: 0;
    height: 0;
    border: var(--vaadin-radio-button-dot-size, 3px) solid
      var(--vaadin-radio-button-dot-color, var(--lumo-primary-contrast-color));
    border-radius: 50%;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%) scale(0);
    transition: 0.25s transform;
    will-change: transform;
    background-clip: content-box;
  }

  :host([checked]) {
    --vaadin-input-field-border-color: transparent;
  }

  :host([checked]) [part='radio'] {
    background-color: var(--_selection-color);
  }

  :host([checked]) [part='radio']::after {
    transform: translate(-50%, -50%) scale(1);
  }

  :host(:not([checked]):not([disabled]):hover) [part='radio'] {
    background: var(--vaadin-radio-button-background-hover, var(--lumo-contrast-30pct));
  }

  :host([active]) [part='radio'] {
    transform: scale(0.9);
    transition-duration: 0.05s;
  }

  :host([active][checked]) [part='radio'] {
    transform: scale(1.1);
  }

  :host([active]:not([checked])) [part='radio']::before {
    transition-duration: 0.01s, 0.01s;
    transform: scale(0);
    opacity: 0.4;
  }

  :host([focus-ring]) [part='radio'] {
    box-shadow:
      0 0 0 1px var(--lumo-base-color),
      0 0 0 calc(var(--_focus-ring-width) + 1px) var(--_focus-ring-color),
      inset 0 0 0 var(--_input-border-width, 0) var(--_input-border-color);
  }

  :host([disabled]) {
    pointer-events: none;
    color: var(--lumo-disabled-text-color);
    --vaadin-input-field-border-color: var(--lumo-contrast-20pct);
  }

  :host([disabled]) ::slotted(label) {
    color: inherit;
  }

  :host([disabled]) [part='radio'] {
    background-color: var(--vaadin-radio-button-disabled-background, var(--lumo-contrast-10pct));
  }

  :host([disabled]) [part='radio']::after {
    border-color: var(--vaadin-radio-button-disabled-dot-color, var(--lumo-contrast-30pct));
  }

  /* RTL specific styles */
  :host([dir='rtl'][has-label]) ::slotted(label) {
    padding: var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-s);
  }

  @media (forced-colors: active) {
    [part='radio'] {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([focused]) [part='radio'] {
      outline-width: 2px;
    }

    :host([disabled]) [part='radio'] {
      outline-color: GrayText;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-radio-button-lumo-inject: 1;
  --vaadin-radio-button-lumo-inject-modules:
    lumo_mixins_checkable-field,
    lumo_components_radio-button;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_radio-group {
  :host(:hover:not([readonly]):not([focused])) [part='label'],
  :host(:hover:not([readonly])) [part='helper-text'] {
    color: var(--lumo-body-text-color);
  }

  /* Touch device adjustment */
  @media (pointer: coarse) {
    :host(:hover:not([readonly]):not([focused])) [part='label'] {
      color: var(--lumo-secondary-text-color);
    }
  }
}
:is(:root, :host)::before {
  --vaadin-radio-group-lumo-inject: 1;
  --vaadin-radio-group-lumo-inject-modules:
    lumo_mixins_group-field,
    lumo_mixins_field-label,
    lumo_mixins_field-required,
    lumo_mixins_field-error-message,
    lumo_mixins_field-helper,
    lumo_components_radio-group;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_rich-text-editor-popup-overlay {
  [part='overlay'] {
    margin: var(--lumo-space-xs) 0;
  }

  [part='content'] {
    padding: var(--lumo-space-xs);
    max-width: calc(7 * (var(--_button-size) + var(--_button-margin) * 2));
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    --_button-size: 1.25rem;
    --_button-margin: 3px;
  }

  [part='content'] ::slotted(button) {
    border: none;
    width: var(--_button-size);
    height: var(--_button-size);
    margin: var(--_button-margin);
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_rich-text-editor {
  :host {
    display: flex;
    flex-direction: column;
    box-sizing: border-box;
    min-height: calc(var(--lumo-size-m) * 8);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_item-indent: var(--lumo-space-m);
    --_marker-indent: var(--lumo-space-xs);
    --_list-indent: calc(var(--_item-indent) + var(--_marker-indent));
  }

  :host([hidden]) {
    display: none !important;
  }

  .announcer {
    position: fixed;
    clip: rect(0, 0, 0, 0);
  }

  input[type='file'] {
    display: none;
  }

  .vaadin-rich-text-editor-container {
    display: flex;
    flex-direction: column;
    min-height: inherit;
    max-height: inherit;
    flex: auto;
  }

  [part='content'] {
    box-sizing: border-box;
    position: relative;
    flex: auto;
    display: flex;
    flex-direction: column;
    overflow: hidden;
    background-color: var(--lumo-base-color);
  }

  [part='toolbar'] {
    display: flex;
    flex-wrap: wrap;
    flex-shrink: 0;
    background-color: var(--lumo-contrast-5pct);
    padding: calc(var(--lumo-space-s) - 1px) var(--lumo-space-xs);
  }

  [part~='toolbar-button'] {
    padding: 0;
    font: inherit;
    line-height: 1;
    text-transform: none;
    background: transparent;
    border: none;
    position: relative;
    width: var(--lumo-size-m);
    height: var(--lumo-size-m);
    border-radius: var(--lumo-border-radius-m);
    color: var(--lumo-contrast-60pct);
    margin: 2px 1px;
    cursor: var(--lumo-clickable-cursor);
    transition:
      background-color 100ms,
      color 100ms;
  }

  [part~='toolbar-button']:not([part~='toolbar-button-pressed']):hover {
    outline: none;
    background-color: var(--lumo-contrast-5pct);
    color: var(--lumo-contrast-80pct);
  }

  @media (forced-colors: active) {
    [part~='toolbar-button']:focus,
    [part~='toolbar-button']:hover {
      outline: 1px solid !important;
    }

    [part~='toolbar-button-pressed'] {
      outline: 2px solid;
      outline-offset: -1px;
    }
  }

  [part~='toolbar-button']::before {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-family: 'lumo-icons', var(--lumo-font-family);
    font-size: var(--lumo-icon-size-m);
  }

  [part~='toolbar-group'] {
    display: flex;
    margin: 0 0.5em;
    margin: 0 calc(var(--lumo-space-l) / 2 - 1px);
  }

  [part~='toolbar-button-bold']::before {
    content: 'B';
    font-weight: 700;
  }

  [part~='toolbar-button-italic']::before {
    content: 'I';
    font-style: italic;
  }

  [part~='toolbar-button-underline']::before {
    content: 'U';
    text-decoration: underline;
  }

  [part~='toolbar-button-strike']::before {
    content: 'T';
    text-decoration: line-through;
  }

  [part~='toolbar-button-h1']::before {
    content: 'H1';
    font-size: 1.25em;
    font-size: var(--lumo-font-size-m);
  }

  [part~='toolbar-button-h2']::before {
    content: 'H2';
    font-size: 1em;
    font-size: var(--lumo-font-size-s);
  }

  [part~='toolbar-button-h3']::before {
    content: 'H3';
    font-size: 0.875em;
    font-size: var(--lumo-font-size-xs);
  }

  [part~='toolbar-button-h1']::before,
  [part~='toolbar-button-h2']::before,
  [part~='toolbar-button-h3']::before {
    letter-spacing: -0.05em;
    font-weight: 600;
  }

  [part~='toolbar-button-subscript']::before,
  [part~='toolbar-button-superscript']::before {
    content: 'X';
    font-weight: 600;
    font-size: var(--lumo-font-size-s);
  }

  [part~='toolbar-button-subscript']::after,
  [part~='toolbar-button-superscript']::after {
    content: '2';
    position: absolute;
    top: 50%;
    left: 70%;
    font-size: 0.625em;
    font-weight: 700;
  }

  [part~='toolbar-button-superscript']::after {
    top: 20%;
  }

  [part~='toolbar-button-blockquote']::before {
    content: '”';
    height: 0.6em;
    font-size: var(--lumo-font-size-xxl);
  }

  [part~='toolbar-button-code-block']::before {
    content: var(--lumo-icons-angle-left) var(--lumo-icons-angle-right);
    font-size: var(--lumo-font-size-l);
    letter-spacing: -0.5em;
    margin-left: -0.25em;
    font-weight: 600;
  }

  [part~='toolbar-button-background']::before,
  [part~='toolbar-button-color']::before {
    content: 'A';
    font-size: 1em;
  }

  [part~='toolbar-button-color']::after {
    content: '';
    position: absolute;
    bottom: 4px;
    left: 25%;
    right: 25%;
    width: 50%;
    height: 4px;
    background-color: var(--_color-value, currentColor);
  }

  [part~='toolbar-button-background']::before {
    z-index: 1;
    background-color: var(--lumo-base-color);
    background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
  }

  [part~='toolbar-button-background']::after {
    content: '';
    position: absolute;
    inset: 20%;
    background: repeating-linear-gradient(
      135deg,
      var(--_background-value, currentColor),
      var(--_background-value, currentColor) 1px,
      transparent 1px,
      transparent 2px
    );
  }

  :host([readonly]) [part='toolbar'] {
    display: none;
  }

  :host([disabled]) {
    pointer-events: none;
    opacity: 0.5;
    -webkit-user-select: none;
    user-select: none;
  }

  :host([disabled]) [part~='toolbar-button'] {
    background-color: transparent;
  }

  [part~='toolbar-button']:focus,
  [part~='toolbar-button'][aria-expanded='true'] {
    outline: none;
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  @media (hover: none) {
    [part~='toolbar-button']:hover {
      background-color: transparent;
    }
  }

  [part~='toolbar-button-pressed'] {
    background-color: var(--vaadin-selection-color, var(--lumo-primary-color));
    color: var(--lumo-primary-contrast-color);
  }

  [part~='toolbar-button']:not([part~='toolbar-button-pressed']):active {
    background-color: var(--lumo-contrast-10pct);
    color: var(--lumo-contrast-90pct);
  }

  [part~='toolbar-button-undo']::before {
    content: var(--lumo-icons-undo);
  }

  [part~='toolbar-button-redo']::before {
    content: var(--lumo-icons-redo);
  }

  [part~='toolbar-button-bold']::before,
  [part~='toolbar-button-background']::before,
  [part~='toolbar-button-color']::before,
  [part~='toolbar-button-italic']::before,
  [part~='toolbar-button-underline']::before,
  [part~='toolbar-button-strike']::before {
    font-size: var(--lumo-font-size-m);
    font-weight: 600;
  }

  [part~='toolbar-button-background']:hover::before {
    background-image:
      linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct)),
      linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
  }

  [part~='toolbar-button-background']:active::before {
    background-image:
      linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct)),
      linear-gradient(var(--lumo-contrast-10pct), var(--lumo-contrast-10pct));
  }

  [part~='toolbar-button-list-ordered']::before {
    content: var(--lumo-icons-ordered-list);
  }

  [part~='toolbar-button-list-bullet']::before {
    content: var(--lumo-icons-unordered-list);
  }

  [part~='toolbar-button-outdent']::before {
    content: var(--lumo-icons-outdent);
  }

  [part~='toolbar-button-indent']::before {
    content: var(--lumo-icons-indent);
  }

  [part~='toolbar-button-align-left']::before {
    content: var(--lumo-icons-align-left);
  }

  [part~='toolbar-button-align-center']::before {
    content: var(--lumo-icons-align-center);
  }

  [part~='toolbar-button-align-right']::before {
    content: var(--lumo-icons-align-right);
  }

  [part~='toolbar-button-image']::before {
    content: var(--lumo-icons-photo);
  }

  [part~='toolbar-button-link']::before {
    content: var(--lumo-icons-link);
  }

  [part~='toolbar-button-clean']::before {
    content: var(--lumo-icons-clean);
    font-size: var(--lumo-font-size-l);
  }

  /* TODO unsupported selector */
  [part='content'] > .ql-editor {
    padding: 0 var(--lumo-space-m);
    line-height: inherit;
  }

  /* Theme variants */

  /* No border */
  :host(:not([theme~='no-border'])) {
    border: 1px solid var(--lumo-contrast-20pct);
  }

  :host(:not([theme~='no-border']):not([readonly])) [part='content'] {
    border-top: 1px solid var(--lumo-contrast-20pct);
  }

  :host([theme~='no-border']) [part='toolbar'] {
    padding-top: var(--lumo-space-s);
    padding-bottom: var(--lumo-space-s);
  }

  /* Compact */
  :host([theme~='compact']) {
    min-height: calc(var(--lumo-size-m) * 6);
  }

  :host([theme~='compact']) [part='toolbar'] {
    padding: var(--lumo-space-xs) 0;
  }

  :host([theme~='compact'][theme~='no-border']) [part='toolbar'] {
    padding: calc(var(--lumo-space-xs) + 1px) 0;
  }

  :host([theme~='compact']) [part~='toolbar-button'] {
    width: var(--lumo-size-s);
    height: var(--lumo-size-s);
  }

  :host([theme~='compact']) [part~='toolbar-group'] {
    margin: 0 calc(var(--lumo-space-m) / 2 - 1px);
  }

  /*
    Quill core styles.
    CSS selectors removed: margin & padding reset, check list, indentation, video, colors, ordered & unordered list, h1-6, anchor
  */
  .ql-clipboard {
    left: -100000px;
    height: 1px;
    overflow-y: hidden;
    position: absolute;
    top: 50%;
  }

  .ql-clipboard p {
    margin: 0;
    padding: 0;
  }

  .ql-editor {
    box-sizing: border-box;
    line-height: 1.42;
    height: 100%;
    outline: none;
    overflow-y: auto;
    padding: 0.75em 1em;
    tab-size: calc(var(--_item-indent) * 2);
    text-align: left;
    white-space: pre-wrap;
    word-wrap: break-word;
    flex: 1;
  }

  .ql-editor > * {
    cursor: text;
  }

  .ql-align-left {
    text-align: left;
  }

  .ql-direction-rtl {
    direction: rtl;
    text-align: inherit;
  }

  .ql-align-center {
    text-align: center;
  }

  .ql-align-justify {
    text-align: justify;
  }

  .ql-align-right {
    text-align: right;
  }

  .ql-code-block-container {
    font-family: monospace;
    background-color: var(--lumo-contrast-10pct);
    border-radius: var(--lumo-border-radius-m);
    white-space: pre-wrap;
    margin-bottom: 0.3125em;
    margin-top: 0.3125em;
    padding: 0.3125em 0.625em;
  }

  /* lists */
  .ql-editor ol {
    padding-inline-start: var(--_list-indent);
  }

  .ql-editor li {
    list-style-type: none;
    position: relative;
    padding-inline-start: var(--_item-indent);
  }

  .ql-editor li > .ql-ui::before {
    display: inline-block;
    width: var(--vaadin-padding-l);
    margin-inline: calc(var(--_item-indent) * -1) var(--_marker-indent);
    text-align: end;
    white-space: nowrap;
  }

  .ql-editor li[data-list='bullet'] > .ql-ui::before {
    content: '\\2022';
    font-size: 1.5rem;
    line-height: 1rem;
    align-self: baseline;
    vertical-align: text-top;
  }

  .ql-editor p,
  .ql-editor h1,
  .ql-editor h2,
  .ql-editor h3,
  .ql-editor h4,
  .ql-editor h5,
  .ql-editor h6 {
    counter-set: list-0 list-1 list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;
  }

  /* 0 */
  .ql-editor li[data-list='ordered'] {
    counter-increment: list-0;
  }

  .ql-editor li[data-list='ordered'] > .ql-ui::before {
    content: counter(list-0, decimal) '. ';
  }

  /* 1 */
  .ql-editor li[data-list='ordered'].ql-indent-1 {
    counter-increment: list-1;
  }

  .ql-editor li[data-list='ordered'].ql-indent-1 > .ql-ui::before {
    content: counter(list-1, lower-alpha) '. ';
  }

  .ql-editor li[data-list].ql-indent-1 {
    counter-set: list-2 list-3 list-4 list-5 list-6 list-7 list-8 list-9;
  }

  /* 2 */
  .ql-editor li[data-list='ordered'].ql-indent-2 {
    counter-increment: list-2;
  }

  .ql-editor li[data-list='ordered'].ql-indent-2 > .ql-ui::before {
    content: counter(list-2, lower-roman) '. ';
  }

  .ql-editor li[data-list].ql-indent-2 {
    counter-set: list-3 list-4 list-5 list-6 list-7 list-8 list-9;
  }

  /* 3 */
  .ql-editor li[data-list='ordered'].ql-indent-3 {
    counter-increment: list-3;
  }

  .ql-editor li[data-list='ordered'].ql-indent-3 > .ql-ui::before {
    content: counter(list-3, decimal) '. ';
  }

  .ql-editor li[data-list].ql-indent-3 {
    counter-set: list-4 list-5 list-6 list-7 list-8 list-9;
  }

  /* 4 */
  .ql-editor li[data-list='ordered'].ql-indent-4 {
    counter-increment: list-4;
  }

  .ql-editor li[data-list='ordered'].ql-indent-4 > .ql-ui::before {
    content: counter(list-4, lower-alpha) '. ';
  }

  .ql-editor li[data-list].ql-indent-4 {
    counter-set: list-5 list-6 list-7 list-8 list-9;
  }

  /* 5 */
  .ql-editor li[data-list='ordered'].ql-indent-5 {
    counter-increment: list-5;
  }

  .ql-editor li[data-list='ordered'].ql-indent-5 > .ql-ui::before {
    content: counter(list-5, lower-roman) '. ';
  }

  .ql-editor li[data-list].ql-indent-5 {
    counter-set: list-6 list-7 list-8 list-9;
  }

  /* 6 */
  .ql-editor li[data-list='ordered'].ql-indent-6 {
    counter-increment: list-6;
  }

  .ql-editor li[data-list='ordered'].ql-indent-6 > .ql-ui::before {
    content: counter(list-6, decimal) '. ';
  }

  .ql-editor li[data-list].ql-indent-6 {
    counter-set: list-7 list-8 list-9;
  }

  /* 7 */
  .ql-editor li[data-list='ordered'].ql-indent-7 {
    counter-increment: list-7;
  }

  .ql-editor li[data-list='ordered'].ql-indent-7 > .ql-ui::before {
    content: counter(list-7, lower-alpha) '. ';
  }

  .ql-editor li[data-list].ql-indent-7 {
    counter-set: list-8 list-9;
  }

  /* 8 */
  .ql-editor li[data-list='ordered'].ql-indent-8 {
    counter-increment: list-8;
  }

  .ql-editor li[data-list='ordered'].ql-indent-8 > .ql-ui::before {
    content: counter(list-8, lower-roman) '. ';
  }

  .ql-editor li[data-list].ql-indent-8 {
    counter-set: list-9;
  }

  /* indent 1 */
  .ql-editor .ql-indent-1 {
    padding-inline-start: calc(var(--_item-indent) * 2);
  }

  .ql-editor li.ql-indent-1 {
    padding-inline-start: calc(var(--_list-indent) + var(--_item-indent) * 2);
  }

  /* indent 2 */
  .ql-editor .ql-indent-2 {
    padding-inline-start: calc(var(--_item-indent) * 4);
  }

  .ql-editor li.ql-indent-2 {
    padding-inline-start: calc(var(--_list-indent) * 2 + var(--_item-indent) * 3);
  }

  /* indent 3 */
  .ql-editor .ql-indent-3 {
    padding-inline-start: calc(var(--_item-indent) * 6);
  }

  .ql-editor li.ql-indent-3 {
    padding-inline-start: calc(var(--_list-indent) * 3 + var(--_item-indent) * 4);
  }

  /* indent 4 */
  .ql-editor .ql-indent-4 {
    padding-inline-start: calc(var(--_item-indent) * 8);
  }

  .ql-editor li.ql-indent-4 {
    padding-inline-start: calc(var(--_list-indent) * 4 + var(--_item-indent) * 5);
  }

  /* indent 5 */
  .ql-editor .ql-indent-5 {
    padding-inline-start: calc(var(--_item-indent) * 10);
  }

  .ql-editor li.ql-indent-5 {
    padding-inline-start: calc(var(--_list-indent) * 5 + var(--_item-indent) * 6);
  }

  /* indent 6 */
  .ql-editor .ql-indent-6 {
    padding-inline-start: calc(var(--_item-indent) * 12);
  }

  .ql-editor li.ql-indent-6 {
    padding-inline-start: calc(var(--_list-indent) * 6 + var(--_item-indent) * 7);
  }

  /* indent 7 */
  .ql-editor .ql-indent-7 {
    padding-inline-start: calc(var(--_item-indent) * 14);
  }

  .ql-editor li.ql-indent-7 {
    padding-inline-start: calc(var(--_list-indent) * 7 + var(--_item-indent) * 8);
  }

  /* indent 8 */
  .ql-editor .ql-indent-8 {
    padding-inline-start: calc(var(--_item-indent) * 16);
  }

  .ql-editor li.ql-indent-8 {
    padding-inline-start: calc(var(--_list-indent) * 8 + var(--_item-indent) * 9);
  }
  /* quill core end */

  blockquote {
    padding-left: 1em;
  }

  code {
    background-color: var(--lumo-contrast-10pct);
    font-size: 85%;
    padding: 0.125em 0.25em;
  }

  img {
    max-width: 100%;
  }

  :where(h1, h2, h3, h4, h5, h6) {
    margin-top: 1.25em;
  }

  :where(h1) {
    margin-bottom: 0.75em;
  }

  :where(h2, h3, h4) {
    margin-bottom: 0.5em;
  }

  :where(h5) {
    margin-bottom: 0.25em;
  }

  /* RTL specific styles */
  :host([dir='rtl']) .ql-editor {
    direction: rtl;
    text-align: right;
  }

  :host([dir='rtl']) [part~='toolbar-button-redo']::before {
    content: var(--lumo-icons-undo);
  }

  :host([dir='rtl']) [part~='toolbar-button-undo']::before {
    content: var(--lumo-icons-redo);
  }
}
@media lumo_global_typography {
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
:where(body, :host) {
  font-family: var(--lumo-font-family);
  font-size: var(--lumo-font-size-m);
  line-height: var(--lumo-line-height-m);
  -webkit-text-size-adjust: 100%;
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
}

small,
[theme~='font-size-s'] {
  font-size: var(--lumo-font-size-s);
  line-height: var(--lumo-line-height-s);
}

[theme~='font-size-xs'] {
  font-size: var(--lumo-font-size-xs);
  line-height: var(--lumo-line-height-xs);
}

:where(h1, h2, h3, h4, h5, h6) {
  font-weight: 600;
  line-height: var(--lumo-line-height-xs);
  color: var(--lumo-header-text-color);
  margin-block: 0;
}

:where(h1) {
  font-size: var(--lumo-font-size-xxxl);
}

:where(h2) {
  font-size: var(--lumo-font-size-xxl);
}

:where(h3) {
  font-size: var(--lumo-font-size-xl);
}

:where(h4) {
  font-size: var(--lumo-font-size-l);
}

:where(h5) {
  font-size: var(--lumo-font-size-m);
}

:where(h6) {
  font-size: var(--lumo-font-size-xs);
  text-transform: uppercase;
  letter-spacing: 0.03em;
}

p,
blockquote {
  margin-top: 0.5em;
  margin-bottom: 0.75em;
}

a {
  text-decoration: none;
}

a:where(:any-link) {
  color: var(--lumo-primary-text-color);
}

a:where(:any-link):hover {
  text-decoration: underline;
}

a:not(:any-link) {
  color: var(--lumo-disabled-text-color);
}

hr {
  display: block;
  align-self: stretch;
  height: 1px;
  border: 0;
  padding: 0;
  margin: var(--lumo-space-s) calc(var(--lumo-border-radius-m) / 2);
  background-color: var(--lumo-contrast-10pct);
}

b,
strong {
  font-weight: 600;
}

code,
pre {
  border-radius: var(--lumo-border-radius-m);
}

pre code {
  background: transparent;
}

blockquote {
  border-left: 2px solid var(--lumo-contrast-30pct);
  color: var(--lumo-secondary-text-color);
}

blockquote[dir='rtl'] {
  border-left: none;
  border-right: 2px solid var(--lumo-contrast-30pct);
}
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_tooltip-overlay {
  :host {
    --_vaadin-tooltip-default-offset: var(--lumo-space-xs);
  }

  [part='overlay'] {
    max-width: 40ch;
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-xs);
    line-height: var(--lumo-line-height-s);
  }

  [part='content'] {
    white-space: pre-wrap;
    padding: var(--lumo-space-xs) var(--lumo-space-s);
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-tooltip-offset-top, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-tooltip-offset-bottom, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-tooltip-offset-start, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-tooltip-offset-end, var(--_vaadin-tooltip-default-offset));
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      outline: 1px dashed;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-tooltip-overlay-lumo-inject: 1;
  --vaadin-tooltip-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_components_tooltip-overlay;
}
:is(:root, :host)::before {
  --vaadin-rich-text-editor-lumo-inject: 1;
  --vaadin-rich-text-editor-lumo-inject-modules:
    lumo_global_typography,
    lumo_components_rich-text-editor;

  --vaadin-rich-text-editor-popup-overlay-lumo-inject: 1;
  --vaadin-rich-text-editor-popup-overlay-lumo-inject-modules:
    lumo_mixins_overlay,
    lumo_components_rich-text-editor-popup-overlay;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_scroller {
  :host {
    outline: none;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([focus-ring]) {
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  /* Show dividers when content overflows */

  :host([theme~='overflow-indicators'])::before,
  :host([theme~='overflow-indicators'])::after {
    content: '';
    display: none;
    position: sticky;
    inset: 0;
    z-index: 9999;
    height: 1px;
    margin-bottom: -1px;
    background: var(--lumo-contrast-10pct);
  }

  :host([theme~='overflow-indicators'])::after {
    margin-bottom: 0;
    margin-top: -1px;
  }

  :host([theme~='overflow-indicators'][overflow~='top'])::before,
  :host([theme~='overflow-indicators'][overflow~='bottom'])::after {
    display: block;
  }
}
:is(:root, :host)::before {
  --vaadin-scroller-lumo-inject: 1;
  --vaadin-scroller-lumo-inject-modules: lumo_components_scroller;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_side-nav {
  :host {
    display: block;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 500;
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-body-text-color);
    -webkit-tap-highlight-color: transparent;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([hidden]) {
    display: none !important;
  }

  button {
    display: flex;
    align-items: center;
    justify-content: inherit;
    width: 100%;
    margin: 0;
    padding: 0;
    background-color: initial;
    color: inherit;
    border: initial;
    outline: none;
    font: inherit;
    text-align: inherit;
  }

  [part='children'] {
    padding: 0;
    margin: 0;
    list-style-type: none;
  }

  [part='label'] {
    display: flex;
    align-items: center;
    width: 100%;
    outline: none;
    box-sizing: border-box;
    border-radius: var(--lumo-border-radius-m);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-s);
    font-weight: 500;
    line-height: var(--lumo-line-height-xs);
  }

  [part='label'] ::slotted([slot='label']) {
    color: var(--lumo-secondary-text-color);
    margin: var(--lumo-space-s);
  }

  :host([focus-ring]) [part='label'] {
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part='toggle-button'] {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: var(--lumo-size-s);
    height: var(--lumo-size-s);
    margin-inline: auto var(--lumo-space-xs);
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    color: var(--lumo-contrast-60pct);
    font-family: 'lumo-icons';
    cursor: var(--lumo-clickable-cursor);
  }

  [part='toggle-button']::before {
    content: var(--lumo-icons-angle-right);
    transition: transform 140ms;
  }

  :host(:not([collapsible])) [part='toggle-button'] {
    display: none !important;
  }

  :host(:not([collapsed])) [part='toggle-button']::before {
    transform: rotate(90deg);
  }

  :host([collapsed][dir='rtl']) [part='toggle-button']::before {
    transform: rotate(180deg);
  }

  @media (any-hover: hover) {
    [part='label']:hover [part='toggle-button'] {
      color: var(--lumo-body-text-color);
    }
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_side-nav-item {
  :host {
    display: block;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([disabled]) {
    pointer-events: none;
  }

  [part='content'] {
    display: flex;
    align-items: center;
  }

  [part='link'] {
    flex: auto;
    min-width: 0;
    display: flex;
    align-items: center;
    text-decoration: none;
    color: inherit;
    font: inherit;
    width: 100%;
    gap: var(--lumo-space-xs);
    padding: var(--lumo-space-s);
    padding-inline-start: calc(var(--lumo-space-s) + var(--_child-indent, 0px));
    border-radius: var(--lumo-border-radius-m);
    transition:
      background-color 140ms,
      color 140ms;
    cursor: var(--lumo-clickable-cursor, default);
    min-height: var(--lumo-icon-size-m);
  }

  button {
    appearance: none;
    flex: none;
    position: relative;
    margin: 0;
    padding: 0;
    border: 0;
    background: transparent;
  }

  [part='children'] {
    padding: 0;
    margin: 0;
    list-style-type: none;
  }

  :host(:not([has-children])) button {
    display: none !important;
  }

  slot[name='prefix'],
  slot[name='suffix'] {
    flex: none;
  }

  slot:not([name]) {
    display: block;
    flex: auto;
    min-width: 0;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
    margin: 0 var(--lumo-space-s);
  }

  [part='link'][href] {
    cursor: pointer;
  }

  :host([disabled]) [part='link'] {
    color: var(--lumo-disabled-text-color);
  }

  [part='toggle-button'] {
    margin-inline-end: calc(var(--lumo-space-xs) * -1);
    width: var(--lumo-size-s);
    height: var(--lumo-size-s);
  }

  :host([has-children]) [part='content'] {
    padding-inline-end: var(--lumo-space-s);
  }

  @media (any-hover: hover) {
    [part='link']:hover {
      color: var(--lumo-header-text-color);
    }

    [part='toggle-button']:hover {
      color: var(--lumo-body-text-color);
    }
  }

  [part='link']:active:focus {
    background-color: var(--lumo-contrast-5pct);
  }

  [part='toggle-button']::before {
    content: var(--lumo-icons-dropdown);
    transform: rotate(-90deg);
    transition: transform 140ms;
  }

  :host([dir='rtl']) [part='toggle-button']::before {
    transform: rotate(90deg);
  }

  :host([expanded]) [part='toggle-button']::before {
    transform: none;
  }

  [part='link'],
  [part='toggle-button'] {
    outline: none;
  }

  [part='link']:focus-visible,
  [part='toggle-button']:focus-visible {
    border-radius: var(--lumo-border-radius-m);
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part='link']:active {
    color: var(--lumo-header-text-color);
  }

  slot[name='prefix']::slotted(:is(vaadin-icon, [class*='icon'])) {
    padding: 0.1em;
    flex-shrink: 0;
    color: var(--lumo-contrast-60pct);
  }

  :host([disabled]) slot[name='prefix']::slotted(:is(vaadin-icon, [class*='icon'])) {
    color: var(--lumo-disabled-text-color);
  }

  :host([current]) slot[name='prefix']::slotted(:is(vaadin-icon, [class*='icon'])) {
    color: inherit;
  }

  slot[name='children'] {
    --_child-indent: calc(var(--_child-indent-2, 0px) + var(--vaadin-side-nav-child-indent, var(--lumo-space-l)));
  }

  slot[name='children']::slotted(*) {
    --_child-indent-2: var(--_child-indent);
  }

  :host([current]) [part='content'] {
    background-color: var(--lumo-primary-color-10pct);
    color: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
    border-radius: var(--lumo-border-radius-m);
  }
}
:is(:root, :host)::before {
  --vaadin-side-nav-item-lumo-inject: 1;
  --vaadin-side-nav-item-lumo-inject-modules:
    lumo_mixins_field-button,
    lumo_components_side-nav-item;
}
:is(:root, :host)::before {
  --vaadin-side-nav-lumo-inject: 1;
  --vaadin-side-nav-lumo-inject-modules: lumo_components_side-nav;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_split-layout {
  :host {
    display: flex;
    overflow: hidden !important;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([orientation='vertical']) {
    flex-direction: column;
  }

  :host ::slotted(*) {
    flex: 1 1 auto;
    overflow: auto;
  }

  [part='splitter'] {
    flex: none;
    position: relative;
    z-index: 1;
    overflow: visible;
    min-width: var(--lumo-space-s);
    min-height: var(--lumo-space-s);
    background-color: var(--lumo-contrast-5pct);
    transition: 0.1s background-color;
  }

  :host(:not([orientation='vertical'])) > [part='splitter'] {
    cursor: ew-resize;
  }

  :host([orientation='vertical']) > [part='splitter'] {
    cursor: ns-resize;
  }

  [part='handle'] {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate3d(-50%, -50%, 0);
    display: flex;
    align-items: center;
    justify-content: center;
    width: var(--lumo-size-m);
    height: var(--lumo-size-m);
  }

  [part='handle']::after {
    content: '';
    display: block;
    --_handle-size: 4px;
    width: var(--_handle-size);
    height: 100%;
    max-width: 100%;
    max-height: 100%;
    border-radius: var(--lumo-border-radius-s);
    background-color: var(--lumo-contrast-30pct);
    transition:
      0.1s opacity,
      0.1s background-color;
  }

  :host([orientation='vertical']) [part='handle']::after {
    width: 100%;
    height: var(--_handle-size);
  }

  /* Active style */
  [part='splitter']:active [part='handle']::after {
    background-color: var(--lumo-contrast-50pct);
  }

  /* Small/minimal */
  :host([theme~='small']) > [part='splitter'] {
    border-left: 1px solid var(--lumo-contrast-10pct);
    border-top: 1px solid var(--lumo-contrast-10pct);
  }

  :host(:is([theme~='small'], [theme~='minimal'])) > [part='splitter'] {
    min-width: 0;
    min-height: 0;
    background-color: transparent;
  }

  :host(:is([theme~='small'], [theme~='minimal'])) > [part='splitter']::after {
    content: '';
    position: absolute;
    inset: -4px;
  }

  :host(:is([theme~='small'], [theme~='minimal'])) > [part='splitter'] > [part='handle'] {
    left: calc(50% - 0.5px);
    top: calc(50% - 0.5px);
  }

  :host(:is([theme~='small'], [theme~='minimal'])) > [part='splitter'] > [part='handle']::after {
    opacity: 0;
    --_handle-size: 5px;
  }

  :host(:is([theme~='small'], [theme~='minimal'])) > [part='splitter']:hover > [part='handle']::after,
  :host(:is([theme~='small'], [theme~='minimal'])) > [part='splitter']:active > [part='handle']::after {
    opacity: 1;
  }

  /* Hover style */
  @media (any-hover: hover) {
    [part='splitter']:hover [part='handle']::after {
      background-color: var(--lumo-contrast-40pct);
    }
  }

  @media (forced-colors: active) {
    [part~='splitter'] {
      outline: 1px solid;
    }

    [part~='handle']::after {
      background-color: AccentColor !important;
      forced-color-adjust: none;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-split-layout-lumo-inject: 1;
  --vaadin-split-layout-lumo-inject-modules: lumo_components_split-layout;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_tabs {
  :host {
    display: flex;
    align-items: center;
    -webkit-tap-highlight-color: transparent;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([orientation='vertical']) {
    display: block;
    box-shadow: -1px 0 0 0 var(--lumo-contrast-10pct);
  }

  :host([orientation='vertical']) [part='tabs'] {
    height: 100%;
    overflow-y: auto;
    width: 100%;
    margin: 0.5rem 0;
  }

  :host(:not([orientation='vertical'])) {
    box-shadow: inset 0 -1px 0 0 var(--lumo-contrast-10pct);
    position: relative;
    min-height: var(--lumo-size-l);
  }

  :host([orientation='horizontal']) [part='tabs'] {
    flex-grow: 1;
    display: flex;
    align-self: stretch;
    overflow-x: auto;
    margin: 0 0.75rem;
  }

  :host([orientation='horizontal']) [part='tabs'] ::slotted(vaadin-tab:not([theme~='icon-on-top'])) {
    justify-content: center;
  }

  /*
  This seems more future-proof than \`overflow: -moz-scrollbars-none\` which is marked obsolete
  and is no longer guaranteed to work:
  https://developer.mozilla.org/en-US/docs/Web/CSS/overflow#Mozilla_Extensions
*/
  @-moz-document url-prefix() {
    :host([orientation='horizontal']) [part='tabs'] {
      overflow: hidden;
    }
  }

  :host([orientation='horizontal']) [part='tabs']::-webkit-scrollbar {
    display: none;
  }

  [part='back-button'],
  [part='forward-button'] {
    pointer-events: none;
    opacity: 0;
    cursor: default;
    position: absolute;
    z-index: 1;
    font-family: lumo-icons;
    color: var(--lumo-tertiary-text-color);
    font-size: var(--lumo-icon-size-m);
    display: flex;
    align-items: center;
    justify-content: center;
    width: 1.5em;
    height: 100%;
    transition: 0.2s opacity;
    top: 0;
  }

  [part='forward-button']:hover,
  [part='back-button']:hover {
    color: inherit;
  }

  :host([overflow~='start']) [part='back-button'],
  :host([overflow~='end']) [part='forward-button'] {
    pointer-events: auto;
    opacity: 1;
  }

  [part='back-button']::after {
    content: var(--lumo-icons-angle-left);
  }

  [part='forward-button']::after {
    content: var(--lumo-icons-angle-right);
  }

  :host([orientation='vertical']) [part='back-button'],
  :host([orientation='vertical']) [part='forward-button'] {
    display: none;
  }

  /* Tabs overflow */

  [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: none;
    mask-image: var(--_lumo-tabs-overflow-mask-image);
  }

  /* Horizontal tabs overflow */

  /* Both ends overflowing */
  :host([overflow~='start'][overflow~='end']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(
      90deg,
      transparent 2em,
      #000 4em,
      #000 calc(100% - 4em),
      transparent calc(100% - 2em)
    );
  }

  /* End overflowing */
  :host([overflow~='end']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(90deg, #000 calc(100% - 4em), transparent calc(100% - 2em));
  }

  /* Start overflowing */
  :host([overflow~='start']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(90deg, transparent 2em, #000 4em);
  }

  /* Vertical tabs overflow */

  /* Both ends overflowing */
  :host([overflow~='start'][overflow~='end'][orientation='vertical']) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(transparent, #000 2em, #000 calc(100% - 2em), transparent);
  }

  /* End overflowing */
  :host([overflow~='end'][orientation='vertical']) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(#000 calc(100% - 2em), transparent);
  }

  /* Start overflowing */
  :host([overflow~='start'][orientation='vertical']) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(transparent, #000 2em);
  }

  :host [part='tabs'] ::slotted(:not(vaadin-tab)) {
    margin-left: var(--lumo-space-m);
  }

  /* Centered */

  :host([theme~='centered'][orientation='horizontal']) ::slotted(vaadin-tab:first-of-type) {
    margin-inline-start: auto;
  }

  :host([theme~='centered'][orientation='horizontal']) ::slotted(vaadin-tab:last-of-type) {
    margin-inline-end: auto;
  }

  /* Small */

  :host([theme~='small']),
  :host([theme~='small']) [part='tabs'] {
    min-height: var(--lumo-size-m);
  }

  :host([theme~='small']) [part='tabs'] ::slotted(vaadin-tab) {
    font-size: var(--lumo-font-size-s);
  }

  /* Minimal */

  :host([theme~='minimal']) {
    box-shadow: none;
    --_lumo-tab-marker-display: none;
  }

  /* Hide-scroll-buttons */

  :host([theme~='hide-scroll-buttons']) [part='back-button'],
  :host([theme~='hide-scroll-buttons']) [part='forward-button'] {
    display: none;
  }

  :host([theme~='hide-scroll-buttons'][overflow~='start'][overflow~='end']:not([orientation='vertical']))
    [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(
      90deg,
      transparent,
      #000 2em,
      #000 calc(100% - 2em),
      transparent 100%
    );
  }

  :host([theme~='hide-scroll-buttons'][overflow~='end']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(90deg, #000 calc(100% - 2em), transparent 100%);
  }

  :host([theme~='hide-scroll-buttons'][overflow~='start']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(90deg, transparent, #000 2em);
  }

  /* Equal-width tabs */
  :host([theme~='equal-width-tabs']) {
    flex: auto;
  }

  :host([theme~='equal-width-tabs']) [part='tabs'] ::slotted(vaadin-tab) {
    flex: 1 0 0%;
  }

  /* RTL specific styles */

  :host(:not([dir='rtl'])) [part='forward-button'] {
    right: 0;
  }

  :host([dir='rtl']) [part='back-button']::after {
    content: var(--lumo-icons-angle-right);
  }

  :host([dir='rtl']) [part='forward-button']::after {
    content: var(--lumo-icons-angle-left);
  }

  :host([dir='rtl'][orientation='vertical']) {
    box-shadow: 1px 0 0 0 var(--lumo-contrast-10pct);
  }

  :host([dir='rtl']) [part='forward-button'] {
    left: 0;
  }

  :host([dir='rtl']) [part='tabs'] ::slotted(:not(vaadin-tab)) {
    margin-left: 0;
    margin-right: var(--lumo-space-m);
  }

  /* Both ends overflowing */
  :host([dir='rtl'][overflow~='start'][overflow~='end']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(
      -90deg,
      transparent 2em,
      #000 4em,
      #000 calc(100% - 4em),
      transparent calc(100% - 2em)
    );
  }

  /* End overflowing */
  :host([dir='rtl'][overflow~='end']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, #000 calc(100% - 4em), transparent calc(100% - 2em));
  }

  /* Start overflowing */
  :host([dir='rtl'][overflow~='start']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, transparent 2em, #000 4em);
  }

  :host([dir='rtl'][theme~='hide-scroll-buttons'][overflow~='start'][overflow~='end']:not([orientation='vertical']))
    [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(
      -90deg,
      transparent,
      #000 2em,
      #000 calc(100% - 2em),
      transparent 100%
    );
  }

  :host([dir='rtl'][theme~='hide-scroll-buttons'][overflow~='end']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, #000 calc(100% - 2em), transparent 100%);
  }

  :host([dir='rtl'][theme~='hide-scroll-buttons'][overflow~='start']:not([orientation='vertical'])) [part='tabs'] {
    --_lumo-tabs-overflow-mask-image: linear-gradient(-90deg, transparent, #000 2em);
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_tab {
  :host {
    box-sizing: border-box;
    padding: 0.5rem 0.75rem;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    font-weight: 500;
    opacity: 1;
    color: var(--lumo-secondary-text-color);
    transition:
      0.15s color,
      0.2s transform;
    flex-shrink: 0;
    display: flex;
    align-items: center;
    position: relative;
    cursor: var(--lumo-clickable-cursor);
    transform-origin: 50% 100%;
    outline: none;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    overflow: hidden;
    min-width: var(--lumo-size-m);
    -webkit-user-select: none;
    user-select: none;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
    --_selection-color: var(--vaadin-selection-color, var(--lumo-primary-color));
    --_selection-color-text: var(--vaadin-selection-color-text, var(--lumo-primary-text-color));
  }

  :host([hidden]) {
    display: none !important;
  }

  :host(:not([orientation='vertical'])) {
    text-align: center;
  }

  :host([orientation='vertical']) {
    transform-origin: 0% 50%;
    padding: 0.25rem 1rem;
    min-height: var(--lumo-size-m);
    min-width: 0;
  }

  :host(:hover),
  :host([focus-ring]) {
    color: var(--lumo-body-text-color);
  }

  :host([selected]) {
    color: var(--_selection-color-text);
    transition: 0.6s color;
  }

  :host([active]:not([selected])) {
    color: var(--_selection-color-text);
    transition-duration: 0.1s;
  }

  :host::before,
  :host::after {
    content: '';
    position: absolute;
    display: var(--_lumo-tab-marker-display, block);
    bottom: 0;
    left: 50%;
    width: var(--lumo-size-s);
    height: 2px;
    background-color: var(--lumo-contrast-60pct);
    border-radius: var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0 0;
    transform: translateX(-50%) scale(0);
    transform-origin: 50% 100%;
    transition: 0.14s transform cubic-bezier(0.12, 0.32, 0.54, 1);
    will-change: transform;
  }

  :host([orientation='vertical'])::before,
  :host([orientation='vertical'])::after {
    left: 0;
    bottom: 50%;
    transform: translateY(50%) scale(0);
    width: 2px;
    height: var(--lumo-size-xs);
    border-radius: 0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0;
    transform-origin: 100% 50%;
  }

  :host::after {
    box-shadow: 0 0 0 4px var(--_selection-color);
    opacity: 0.15;
    transition:
      0.15s 0.02s transform,
      0.8s 0.17s opacity;
  }

  :host([selected])::before,
  :host([selected])::after {
    background-color: var(--_selection-color);
    transform: translateX(-50%) scale(1);
    transition-timing-function: cubic-bezier(0.12, 0.32, 0.54, 1.5);
  }

  :host([orientation='vertical'][selected])::before,
  :host([orientation='vertical'][selected])::after {
    transform: translateY(50%) scale(1);
  }

  :host([selected]:not([active]))::after {
    opacity: 0;
  }

  :host(:not([orientation='vertical'])) ::slotted(a[href]) {
    justify-content: center;
  }

  :host ::slotted(a) {
    display: flex;
    width: 100%;
    align-items: center;
    height: 100%;
    margin: -0.5rem -0.75rem;
    padding: 0.5rem 0.75rem;
    outline: none;

    /*
    Override the CSS inherited from \`lumo-color\` and \`lumo-typography\`.
    Note: \`!important\` is needed because of the \`:slotted\` specificity.
  */
    text-decoration: none !important;
    color: inherit !important;
  }

  :host ::slotted(vaadin-icon) {
    margin: 0 4px;
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }

  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */
  :host ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: 0.25rem;
    box-sizing: border-box !important;
  }

  :host(:not([dir='rtl'])) ::slotted(vaadin-icon:first-child) {
    margin-left: 0;
  }

  :host(:not([dir='rtl'])) ::slotted(vaadin-icon:last-child) {
    margin-right: 0;
  }

  :host([theme~='icon-on-top']) {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: space-around;
    text-align: center;
    padding-bottom: 0.5rem;
    padding-top: 0.25rem;
  }

  :host([theme~='icon-on-top']) ::slotted(a) {
    flex-direction: column;
    align-items: center;
    margin-top: -0.25rem;
    padding-top: 0.25rem;
  }

  :host([theme~='icon-on-top']) ::slotted(vaadin-icon) {
    margin: 0;
  }

  /* Disabled */

  :host([disabled]) {
    pointer-events: none;
    opacity: 1;
    color: var(--lumo-disabled-text-color);
  }

  /* Focus-ring */

  :host([focus-ring]) {
    box-shadow: inset 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
    border-radius: var(--lumo-border-radius-m);
  }

  /* RTL specific styles */

  :host([dir='rtl'])::before,
  :host([dir='rtl'])::after {
    left: auto;
    right: 50%;
    transform: translateX(50%) scale(0);
  }

  :host([dir='rtl'][selected]:not([orientation='vertical']))::before,
  :host([dir='rtl'][selected]:not([orientation='vertical']))::after {
    transform: translateX(50%) scale(1);
  }

  :host([dir='rtl']) ::slotted(vaadin-icon:first-child) {
    margin-right: 0;
  }

  :host([dir='rtl']) ::slotted(vaadin-icon:last-child) {
    margin-left: 0;
  }

  :host([orientation='vertical'][dir='rtl']) {
    transform-origin: 100% 50%;
  }

  :host([dir='rtl'][orientation='vertical'])::before,
  :host([dir='rtl'][orientation='vertical'])::after {
    left: auto;
    right: 0;
    border-radius: var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s);
    transform-origin: 0% 50%;
  }

  @media (forced-colors: active) {
    :host([focused]) {
      outline: 1px solid;
      outline-offset: -1px;
    }

    :host([selected]) {
      border-bottom: 2px solid;
    }

    :host([orientation='vertical'][selected]) {
      border-bottom: none;
      border-left: 2px solid;
    }
  }
}
:is(:root, :host)::before {
  --vaadin-tab-lumo-inject: 1;
  --vaadin-tab-lumo-inject-modules: lumo_components_tab;
}
:is(:root, :host)::before {
  --vaadin-tabs-lumo-inject: 1;
  --vaadin-tabs-lumo-inject-modules: lumo_components_tabs;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_tabsheet {
  :host {
    display: flex;
    flex-direction: column;
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
    font-family: var(--lumo-font-family);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='tabs-container'] {
    position: relative;
    display: flex;
    align-items: center;
    box-shadow: inset 0 -1px 0 0 var(--lumo-contrast-10pct);
    padding: var(--lumo-space-xs) var(--lumo-space-s);
    gap: var(--lumo-space-s);
  }

  ::slotted([slot='tabs']) {
    flex: 1;
    align-self: stretch;
    min-width: 8em;
    box-shadow: initial;
    margin: calc(var(--lumo-space-xs) * -1) calc(var(--lumo-space-s) * -1);
  }

  ::slotted([hidden]) {
    display: none !important;
  }

  [part='content'] {
    position: relative;
    flex: 1;
    box-sizing: border-box;
    padding: var(--lumo-space-s) var(--lumo-space-m);
    border-bottom-left-radius: inherit;
    border-bottom-right-radius: inherit;
  }

  :host([theme~='bordered']) {
    border: 1px solid var(--lumo-contrast-20pct);
    border-radius: var(--lumo-border-radius-l);
  }

  :host([loading]) [part='content'] {
    display: flex;
    align-items: center;
    justify-content: center;
  }

  :host([theme~='no-padding']) [part='content'] {
    padding: 0 !important;
  }
}
:is(:root, :host)::before {
  --vaadin-tabsheet-lumo-inject: 1;
  --vaadin-tabsheet-lumo-inject-modules:
    lumo_mixins_loader,
    lumo_components_tabsheet;

  --vaadin-tabsheet-scroller-lumo-inject: 1;
  --vaadin-tabsheet-scroller-lumo-inject-modules: lumo_components_scroller;
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_upload-file-list {
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='list'] {
    padding: 0;
    margin: 0;
    list-style-type: none;
  }

  ::slotted(li:not(:first-of-type)) {
    border-top: 1px solid var(--lumo-contrast-10pct);
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_upload-file {
  :host {
    display: block;
    padding: var(--lumo-space-s) 0;
    outline: none;
    --_focus-ring-color: var(--vaadin-focus-ring-color, var(--lumo-primary-color-50pct));
    --_focus-ring-width: var(--vaadin-focus-ring-width, 2px);
  }

  [hidden] {
    display: none;
  }

  [part='row'] {
    list-style-type: none;
    display: flex;
    align-items: baseline;
    justify-content: space-between;
  }

  button {
    background: transparent;
    padding: 0;
    border: none;
    box-shadow: none;
  }

  :host([complete]) ::slotted([slot='progress']),
  :host([error]) ::slotted([slot='progress']) {
    display: none !important;
  }

  :host([focus-ring]) [part='row'] {
    border-radius: var(--lumo-border-radius-s);
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part='status'],
  [part='error'] {
    color: var(--lumo-secondary-text-color);
    font-size: var(--lumo-font-size-s);
  }

  [part='info'] {
    display: flex;
    align-items: baseline;
    flex: auto;
  }

  [part='meta'] {
    width: 0.001px;
    flex: 1 1 auto;
  }

  [part='name'] {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }

  [part='commands'] {
    display: flex;
    align-items: baseline;
    flex: none;
  }

  [part$='icon'] {
    margin-right: var(--lumo-space-xs);
    font-size: var(--lumo-icon-size-m);
    font-family: 'lumo-icons';
    line-height: 1;
  }

  /* When both icons are hidden, let us keep space for one */
  [part='done-icon'][hidden] + [part='warning-icon'][hidden] {
    display: block !important;
    visibility: hidden;
  }

  [part$='button'] {
    flex: none;
    margin-left: var(--lumo-space-xs);
    cursor: var(--lumo-clickable-cursor);
  }

  [part$='button']:focus {
    outline: none;
    border-radius: var(--lumo-border-radius-s);
    box-shadow: 0 0 0 var(--_focus-ring-width) var(--_focus-ring-color);
  }

  [part$='icon']::before,
  [part$='button']::before {
    vertical-align: -0.25em;
  }

  [part='done-icon']::before {
    content: var(--lumo-icons-checkmark);
    color: var(--lumo-primary-text-color);
  }

  [part='warning-icon']::before {
    content: var(--lumo-icons-error);
    color: var(--lumo-error-text-color);
  }

  [part='start-button']::before {
    content: var(--lumo-icons-play);
  }

  [part='retry-button']::before {
    content: var(--lumo-icons-reload);
  }

  [part='remove-button']::before {
    content: var(--lumo-icons-cross);
  }

  [part='error'] {
    color: var(--lumo-error-text-color);
  }

  ::slotted([slot='progress']) {
    width: auto;
    margin-left: calc(var(--lumo-icon-size-m) + var(--lumo-space-xs));
    margin-right: calc(var(--lumo-icon-size-m) + var(--lumo-space-xs));
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_upload-icon {
  :host {
    display: inline-block;
  }

  :host::before {
    content: var(--lumo-icons-upload);
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    vertical-align: -0.25em;
    background-color: transparent;
    mask-image: none;
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_upload {
  :host {
    display: block;
    position: relative;
    box-sizing: border-box;
    line-height: var(--lumo-line-height-m);
  }

  :host([hidden]) {
    display: none !important;
  }

  [hidden] {
    display: none !important;
  }

  :host(:not([nodrop])) {
    overflow: hidden;
    border: 1px dashed var(--lumo-contrast-20pct);
    border-radius: var(--lumo-border-radius-l);
    padding: var(--lumo-space-m);
    transition:
      background-color 0.6s,
      border-color 0.6s;
  }

  [part='drop-label'] {
    display: inline-block;
    white-space: normal;
    padding: 0 var(--lumo-space-s);
    color: var(--lumo-secondary-text-color);
    font-family: var(--lumo-font-family);
  }

  :host([dragover-valid]) {
    border-color: var(--lumo-primary-color-50pct);
    background: var(--lumo-primary-color-10pct);
    transition:
      background-color 0.1s,
      border-color 0.1s;
  }

  :host([dragover-valid]) [part='drop-label'] {
    color: var(--lumo-primary-text-color);
  }

  :host([disabled]) [part='drop-label'],
  :host([max-files-reached]) [part='drop-label'] {
    color: var(--lumo-disabled-text-color);
  }
}
:is(:root, :host)::before {
  --vaadin-upload-lumo-inject: 1;
  --vaadin-upload-lumo-inject-modules: lumo_components_upload;

  --vaadin-upload-icon-lumo-inject: 1;
  --vaadin-upload-icon-lumo-inject-modules: lumo_components_upload-icon;

  --vaadin-upload-file-lumo-inject: 1;
  --vaadin-upload-file-lumo-inject-modules:
    lumo_mixins_field-button,
    lumo_components_upload-file;

  --vaadin-upload-file-list-lumo-inject: 1;
  --vaadin-upload-file-list-lumo-inject-modules: lumo_components_upload-file-list;
}
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
@media lumo_components_vertical-layout {
  :host([theme~='margin']) {
    margin: var(--lumo-space-m);
  }

  :host([theme~='padding']) {
    padding: var(--lumo-space-m);
  }

  :host([theme~='spacing-xs']) {
    gap: var(--lumo-space-xs);
  }

  :host([theme~='spacing-s']) {
    gap: var(--lumo-space-s);
  }

  :host([theme~='spacing']) {
    gap: var(--lumo-space-m);
  }

  :host([theme~='spacing-l']) {
    gap: var(--lumo-space-l);
  }

  :host([theme~='spacing-xl']) {
    gap: var(--lumo-space-xl);
  }
}
:is(:root, :host)::before {
  --vaadin-vertical-layout-lumo-inject: 1;
  --vaadin-vertical-layout-lumo-inject-modules: lumo_components_vertical-layout;
}
`;
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
addGlobalThemeStyles(
  "vaadin-base-user-colors",
  css$e`
    @layer vaadin.base {
      :where(html) {
        --_color-count: 10;
        --_hue-step: calc(360 / var(--_color-count) - 1);
        --vaadin-user-color-0: var(--vaadin-user-color, #4172d5);
        --vaadin-user-color-1: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 1)
        );
        --vaadin-user-color-2: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 2)
        );
        --vaadin-user-color-3: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 3)
        );
        --vaadin-user-color-4: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 4)
        );
        --vaadin-user-color-5: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 5)
        );
        --vaadin-user-color-6: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 6)
        );
        --vaadin-user-color-7: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 7)
        );
        --vaadin-user-color-8: oklch(
          from var(--vaadin-user-color-0) min(l + 0.1, 0.8) c calc(h - var(--_hue-step) * 8)
        );
        --vaadin-user-color-9: oklch(
          from var(--vaadin-user-color-0) max(0.2, l - 0.1) c calc(h - var(--_hue-step) * 9)
        );
      }
    }
  `
);
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const fieldOutlineStyles = css$e`
  :host {
    display: block;
    position: absolute;
    inset: 0;
    pointer-events: none;
    opacity: 0;
    --_active-user-color: transparent;
    outline: 3px solid var(--_active-user-color);
    outline-offset: -1px;
    /* TODO doesn't inherit correctly from vaadin-input-container for some reason, so we use the internal _radius property */
    border-radius: var(--_radius, inherit);
  }

  :host([has-active-user]) {
    opacity: 1;
  }

  :host([context$='item']) {
    inset: 2px;
  }
`;
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class FieldOutline extends ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-field-outline";
  }
  static get styles() {
    return fieldOutlineStyles;
  }
  static get properties() {
    return {
      /**
       * A user who last interacted with the field.
       */
      user: {
        type: Object,
        value: null,
        observer: "_userChanged",
        sync: true
      }
    };
  }
  /** @protected */
  render() {
    return html$3``;
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("part", "outline");
    this._field = this.getRootNode().host;
  }
  /** @private */
  _userChanged(user) {
    this.toggleAttribute("has-active-user", Boolean(user));
    const value = user ? `var(--vaadin-user-color-${user.colorIndex})` : "transparent";
    const prop = "--_active-user-color";
    this.style.setProperty(prop, value);
    if (this._field) {
      this._field.style.setProperty(prop, value);
    }
  }
}
defineCustomElement(FieldOutline);
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const userTagStyles = css$e`
  :host {
    display: inline-block;
    box-sizing: border-box;
    opacity: 0;
    padding: var(--vaadin-user-tag-padding, 0.3em);
    background-color: var(--vaadin-user-tag-color);
    color: oklch(from var(--vaadin-user-tag-color) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    font-size: var(--vaadin-user-tag-font-size, 0.75em);
    font-weight: var(--vaadin-user-tag-font-weight, 500);
    line-height: var(--vaadin-user-tag-line-height, 1);
    border: var(--vaadin-user-tag-border-width, 0) solid
      var(--vaadin-user-tag-border-color, var(--vaadin-border-color-subtle));
    border-radius: var(--vaadin-user-tag-border-radius, var(--vaadin-radius-m));
    cursor: default;
  }

  :host(.show) {
    opacity: 1;
  }

  [part='name'] {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
  }
`;
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class UserTag extends ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-user-tag";
  }
  static get styles() {
    return userTagStyles;
  }
  /** @protected */
  render() {
    return html$3`<div part="name">${this.name}</div>`;
  }
  static get properties() {
    return {
      /**
       * Name of the user.
       */
      name: {
        type: String
      },
      /**
       * Id of the user.
       */
      uid: {
        type: String
      },
      /**
       * Color index of the user.
       */
      colorIndex: {
        type: Number,
        observer: "_colorIndexChanged"
      }
    };
  }
  /** @protected */
  ready() {
    super.ready();
    this.addEventListener("mousedown", this._onClick.bind(this), true);
  }
  /** @private */
  _colorIndexChanged(index) {
    if (index != null) {
      this.style.setProperty("--vaadin-user-tag-color", `var(--vaadin-user-color-${index})`);
    }
  }
  /**
   * @param {Event} e
   * @private
   */
  _onClick(e) {
    e.preventDefault();
    this.dispatchEvent(
      new CustomEvent("user-tag-click", {
        bubbles: true,
        composed: true,
        detail: {
          name: this.name
        }
      })
    );
  }
}
defineCustomElement(UserTag);
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const userTagsOverlay = css$e`
  [part='overlay'] {
    all: initial;
    display: block;
    font: inherit;
    color: inherit;
  }

  [part='content'] {
    display: flex;
    flex-wrap: wrap;
    gap: var(--vaadin-user-tag-overlay-gap, 0.2em);
    padding: 0.5em 0;
  }

  :host([opening]),
  :host([closing]) {
    animation: 0.14s user-tags-overlay-dummy-animation;
  }

  @keyframes user-tags-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;
const userTagsOverlayStyles = [overlayStyles$1, userTagsOverlay];
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class UserTagsOverlay extends PositionMixin(
  OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))))
) {
  static get is() {
    return "vaadin-user-tags-overlay";
  }
  static get styles() {
    return userTagsOverlayStyles;
  }
  /** @protected */
  render() {
    return html$3`
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `;
  }
}
defineCustomElement(UserTagsOverlay);
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const listenOnce$1 = (elem, type) => {
  return new Promise((resolve) => {
    const listener = () => {
      elem.removeEventListener(type, listener);
      resolve();
    };
    elem.addEventListener(type, listener);
  });
};
class UserTags extends PolylitMixin(LitElement) {
  static get is() {
    return "vaadin-user-tags";
  }
  static get styles() {
    return css$e`
      :host {
        position: absolute;
      }
    `;
  }
  /** @protected */
  render() {
    return html$3`
      <vaadin-user-tags-overlay
        id="overlay"
        exportparts="overlay:user-tags-overlay, content:user-tags-content"
        modeless
        .opened="${this.opened}"
        no-vertical-overlap
        @vaadin-overlay-open="${this._onOverlayOpen}"
      >
        <slot></slot>
      </vaadin-user-tags-overlay>
    `;
  }
  static get properties() {
    return {
      /**
       * True when the field has focus. In this case, the overlay
       * with a list of the user tags needs to be always visible.
       */
      hasFocus: {
        type: Boolean,
        value: false,
        observer: "_hasFocusChanged"
      },
      /**
       * True when the overlay is opened.
       */
      opened: {
        type: Boolean,
        value: false,
        sync: true
      },
      /**
       * True when the overlay is flashing: quickly shown and then hidden
       * once a different user starts to interact with the field.
       */
      flashing: {
        type: Boolean,
        value: false
      },
      /**
       * A target element that the overlay is positioned to.
       */
      target: {
        type: Object,
        observer: "__targetChanged"
      },
      /**
       * A list of users who focused the field.
       */
      users: {
        type: Array,
        value: () => []
      },
      duration: {
        type: Number,
        value: 200
      },
      delay: {
        type: Number,
        value: 2e3
      },
      /** @private */
      __flashQueue: {
        type: Array,
        value: () => []
      },
      /** @private */
      __isTargetVisible: {
        type: Boolean,
        value: false
      }
    };
  }
  constructor() {
    super();
    this.__targetVisibilityObserver = new IntersectionObserver(
      ([entry]) => {
        this.__onTargetVisibilityChange(entry.isIntersecting);
      },
      { threshold: 1 }
    );
  }
  /** @protected */
  get wrapper() {
    return this;
  }
  /** @protected */
  connectedCallback() {
    super.connectedCallback();
    if (this.target) {
      this.__targetVisibilityObserver.observe(this.target);
    }
  }
  /** @protected */
  disconnectedCallback() {
    super.disconnectedCallback();
    this.opened = false;
    if (this.target) {
      this.__targetVisibilityObserver.unobserve(this.target);
    }
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("exportparts", "user-tags-overlay, user-tags-content");
  }
  /** @private */
  __onTargetVisibilityChange(isVisible) {
    this.__isTargetVisible = isVisible;
    if (isVisible && this.__flashQueue.length > 0 && !this.flashing) {
      this.flashTags(this.__flashQueue.shift());
      return;
    }
    if (isVisible && this.hasFocus) {
      this.opened = true;
      return;
    }
    if (!isVisible && this.opened) {
      this.opened = false;
    }
  }
  /** @private */
  __targetChanged(newTarget, oldTarget) {
    this.$.overlay.positionTarget = newTarget;
    if (oldTarget) {
      this.__targetVisibilityObserver.unobserve(oldTarget);
    }
    if (newTarget) {
      this.__targetVisibilityObserver.observe(newTarget);
    }
  }
  /** @private */
  _hasFocusChanged(hasFocus) {
    if (hasFocus && this.flashing) {
      this.stopFlash();
    }
  }
  createUserTag(user) {
    const tag2 = document.createElement("vaadin-user-tag");
    tag2.setAttribute("part", "user-tag");
    tag2.name = user.name;
    tag2.uid = user.id;
    tag2.colorIndex = user.colorIndex;
    return tag2;
  }
  getTagForUser(user) {
    return Array.from(this.children).find((tag2) => tag2.uid === user.id);
  }
  getChangedTags(addedUsers, removedUsers) {
    const removed = removedUsers.map((user) => this.getTagForUser(user));
    const added = addedUsers.map((user) => this.getTagForUser(user) || this.createUserTag(user));
    return { added, removed };
  }
  applyTagsStart({ added, removed }) {
    removed.forEach((tag2) => {
      if (tag2) {
        tag2.classList.add("removing");
        tag2.classList.remove("show");
      }
    });
    added.forEach((tag2) => this.insertBefore(tag2, this.firstChild));
  }
  applyTagsEnd({ added, removed }) {
    removed.forEach((tag2) => {
      if (tag2 && tag2.parentNode === this) {
        this.removeChild(tag2);
      }
    });
    added.forEach((tag2) => tag2 && tag2.classList.add("show"));
  }
  setUsers(users) {
    this.requestContentUpdate();
    let addedUsers = [];
    let removedUsers = [];
    const hasNewUsers = Array.isArray(users);
    const hasOldUsers = Array.isArray(this.users);
    if (hasOldUsers) {
      const newUserIds = (users || []).map((user) => user.id);
      removedUsers = this.users.filter((item) => !newUserIds.includes(item.id));
    }
    if (hasNewUsers) {
      const oldUserIds = (this.users || []).map((user) => user.id);
      addedUsers = users.filter((item) => !oldUserIds.includes(item.id)).reverse();
    }
    if (addedUsers.length === 0 && removedUsers.length === 0) {
      return;
    }
    const changedTags = this.getChangedTags(addedUsers, removedUsers);
    if (this.__flashQueue.length > 0) {
      removedUsers.forEach((user, i2) => {
        if (changedTags.removed[i2] === null) {
          return;
        }
        this.__flashQueue.forEach((tags) => {
          if (tags.some((tag2) => tag2.uid === user.id)) {
            this.__flashQueue = this.__flashQueue.filter((_2, index) => index !== i2);
          }
        });
      });
    }
    if (this.opened && this.hasFocus) {
      this.updateTags(users, changedTags);
    } else if (addedUsers.length > 0 && document.visibilityState !== "hidden") {
      const addedTags = changedTags.added;
      const removedTags = changedTags.removed;
      this.updateTagsSync(users, {
        added: [],
        removed: removedTags
      });
      if (this.flashing || !this.__isTargetVisible) {
        this.__flashQueue = [...this.__flashQueue, addedTags];
      } else {
        this.flashTags(addedTags);
      }
    } else {
      this.updateTagsSync(users, changedTags);
    }
  }
  /** @private */
  _onOverlayOpen() {
    Array.from(this.children).forEach((tag2) => {
      if (!tag2.classList.contains("removing")) {
        tag2.classList.add("show");
      }
    });
  }
  flashTags(added) {
    this.flashing = true;
    const hidden = Array.from(this.children);
    hidden.forEach((tag2) => {
      tag2.style.display = "none";
    });
    added.forEach((tag2) => {
      this.insertBefore(tag2, this.firstChild);
    });
    this.flashPromise = new Promise((resolve) => {
      listenOnce$1(this.$.overlay, "vaadin-overlay-open").then(() => {
        this._debounceFlashStart = Debouncer.debounce(
          this._debounceFlashStart,
          timeOut.after(this.duration + this.delay),
          () => {
            if (!this.hasFocus) {
              added.forEach((tag2) => tag2.classList.remove("show"));
            }
            this._debounceFlashEnd = Debouncer.debounce(this._debounceFlashEnd, timeOut.after(this.duration), () => {
              const finishFlash = () => {
                hidden.forEach((tag2) => {
                  tag2.style.display = "block";
                });
                this.flashing = false;
                resolve();
              };
              if (this.hasFocus) {
                finishFlash();
              } else {
                listenOnce$1(this.$.overlay, "animationend").then(() => {
                  finishFlash();
                });
                this.opened = false;
              }
            });
          }
        );
      });
    }).then(() => {
      if (this.__flashQueue.length > 0) {
        const tags = this.__flashQueue[0];
        this.__flashQueue = [...this.__flashQueue].slice(1);
        this.flashTags(tags);
      }
    });
    this.opened = true;
  }
  stopFlash() {
    if (this._debounceFlashStart) {
      this._debounceFlashStart.flush();
    }
    if (this._debounceFlashEnd) {
      this._debounceFlashEnd.flush();
    }
    this.$.overlay._flushAnimation("closing");
  }
  updateTags(users, changed) {
    this.applyTagsStart(changed);
    this._debounceRender = Debouncer.debounce(this._debounceRender, timeOut.after(this.duration), () => {
      this.users = users;
      this.applyTagsEnd(changed);
      if (users.length === 0 && this.opened) {
        this.opened = false;
      }
    });
  }
  updateTagsSync(users, changed) {
    this.applyTagsStart(changed);
    this.users = users;
    this.applyTagsEnd(changed);
  }
  show() {
    this.hasFocus = true;
    if (this.__isTargetVisible) {
      this.opened = true;
    }
  }
  hide() {
    this.hasFocus = false;
    this.opened = false;
  }
  requestContentUpdate() {
    if (this._debounceRender && this._debounceRender.isActive()) {
      this._debounceRender.flush();
    }
  }
}
defineCustomElement(UserTags);
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const getOutlineTarget = (element, tagName) => {
  switch (tagName) {
    /* c8 ignore next */
    case "vaadin-big-decimal-field":
    case "vaadin-combo-box":
    case "vaadin-date-picker":
    case "vaadin-email-field":
    case "vaadin-integer-field":
    case "vaadin-number-field":
    case "vaadin-password-field":
    case "vaadin-select":
    case "vaadin-text-area":
    case "vaadin-text-field":
    case "vaadin-time-picker":
      return element.shadowRoot.querySelector('[part="input-field"]');
    /* c8 ignore next */
    case "vaadin-checkbox":
      return element.shadowRoot.querySelector('[part="checkbox"]');
    /* c8 ignore next */
    case "vaadin-radio-button":
      return element.shadowRoot.querySelector('[part="radio"]');
    /* c8 ignore next */
    default:
      return element;
  }
};
const fields = /* @__PURE__ */ new WeakMap();
const initOutline = (field2) => {
  if (!fields.has(field2)) {
    const tagName = field2.tagName.toLowerCase();
    const target = getOutlineTarget(field2, tagName);
    target.style.position = "relative";
    if (tagName.endsWith("text-area")) {
      target.style.overflow = "visible";
    }
    const style = document.createElement("style");
    style.textContent = `
      :host(:is([active], [focused])) [part="outline"] {
        display: none;
      }
    `;
    field2.shadowRoot.appendChild(style);
    const outline = document.createElement("vaadin-field-outline");
    (target === field2 ? field2.shadowRoot : target).appendChild(outline);
    outline.setAttribute("context", tagName);
    fields.set(field2, { root: field2, target, outline });
  }
  return fields.get(field2);
};
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class ComponentObserver {
  constructor(component) {
    this.component = component;
    this.initTags(component);
  }
  getFields() {
    return [this.component];
  }
  getFieldIndex(field2) {
    return this.getFields().indexOf(field2);
  }
  getFocusTarget(_event) {
    return this.component;
  }
  initTags(component) {
    const tags = document.createElement("vaadin-user-tags");
    component.shadowRoot.appendChild(tags);
    tags.target = component;
    this._tags = tags;
    component.addEventListener("mouseenter", (event) => {
      if (event.relatedTarget === this._tags.$.overlay) {
        return;
      }
      this._mouse = true;
      this._mouseDebouncer = Debouncer.debounce(this._mouseDebouncer, timeOut.after(200), () => {
        if (this._mouse) {
          this._tags.show();
        }
      });
    });
    component.addEventListener("mouseleave", (event) => {
      if (event.relatedTarget === this._tags.$.overlay) {
        return;
      }
      this._mouse = false;
      if (!this._hasFocus) {
        this._tags.hide();
      }
    });
    component.addEventListener("vaadin-highlight-show", (_event) => {
      this._hasFocus = true;
      if (this._debouncer && this._debouncer.isActive()) {
        this._debouncer.cancel();
      } else {
        this._tags.show();
      }
    });
    component.addEventListener("vaadin-highlight-hide", (_event) => {
      this._hasFocus = false;
      if (!this._mouse) {
        this._debouncer = Debouncer.debounce(this._debouncer, timeOut.after(1), () => {
          this._tags.hide();
        });
      }
    });
    this._tags.$.overlay.addEventListener("mouseleave", (event) => {
      if (event.relatedTarget === component) {
        return;
      }
      this._mouse = false;
      if (!component.hasAttribute("focused")) {
        this._tags.hide();
      }
    });
  }
  setOutlines(users) {
    const fields2 = this.getFields();
    fields2.forEach((field2, idx2) => {
      const { outline } = initOutline(field2);
      const index = fields2.length === 1 ? 0 : users.map((user) => user.fieldIndex).indexOf(idx2);
      outline.user = users[index];
    });
  }
  showOutline(field2) {
    this.fire("show", field2);
  }
  hideOutline(field2) {
    this.fire("hide", field2);
  }
  fire(action, field2) {
    this.component.dispatchEvent(
      new CustomEvent(`vaadin-highlight-${action}`, {
        bubbles: true,
        composed: true,
        detail: { fieldIndex: this.getFieldIndex(field2) }
      })
    );
  }
  redraw(users) {
    this._tags.setUsers(users);
    this.setOutlines(users);
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class FieldObserver extends ComponentObserver {
  constructor(field2) {
    super(field2);
    this.addListeners(field2);
  }
  addListeners(field2) {
    field2.addEventListener("focusin", (event) => this.onFocusIn(event));
    field2.addEventListener("focusout", (event) => this.onFocusOut(event));
  }
  onFocusIn(event) {
    const target = this.getFocusTarget(event);
    this.showOutline(target);
  }
  onFocusOut(event) {
    const target = this.getFocusTarget(event);
    this.hideOutline(target);
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class CheckboxGroupObserver extends FieldObserver {
  getFields() {
    return this.component.__checkboxes;
  }
  getFocusTarget(event) {
    const fields2 = this.getFields();
    return Array.from(event.composedPath()).find((node) => fields2.includes(node));
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class DatePickerObserver extends ComponentObserver {
  constructor(datePicker) {
    super(datePicker);
    this.datePicker = datePicker;
    this.blurWhileOpened = false;
    this.addListeners(datePicker);
  }
  addListeners(datePicker) {
    this.overlay = datePicker.$.overlay;
    datePicker.addEventListener("opened-changed", (event) => this.onOpenedChanged(event));
    this.overlay.addEventListener("focusout", (event) => this.onOverlayFocusOut(event));
    datePicker.addEventListener("focusin", (event) => this.onFocusIn(event));
    datePicker.addEventListener("focusout", (event) => this.onFocusOut(event));
  }
  isEventInOverlay(node) {
    return this.datePicker._overlayContent && this.datePicker._overlayContent.contains(node);
  }
  isFullscreen() {
    const datePicker = this.datePicker;
    return datePicker._noInput && !isKeyboardActive();
  }
  onFocusIn(event) {
    if (this.isEventInOverlay(event.target)) {
      return;
    }
    if (this.isEventInOverlay(event.relatedTarget)) {
      return;
    }
    if (this.blurWhileOpened) {
      this.blurWhileOpened = false;
      return;
    }
    this.showOutline(this.datePicker);
  }
  onFocusOut(event) {
    if (this.isEventInOverlay(event.target) && this.component.contains(event.relatedTarget)) {
      return;
    }
    if (this.isEventInOverlay(event.relatedTarget)) {
      return;
    }
    if (!this.datePicker.opened) {
      this.hideOutline(this.datePicker);
    } else {
      this.blurWhileOpened = true;
    }
  }
  onOverlayFocusOut(event) {
    if (!this.datePicker.contains(event.relatedTarget)) {
      this.blurWhileOpened = true;
    }
  }
  onOpenedChanged(event) {
    if (event.detail.value === true && this.isFullscreen()) {
      this.showOutline(this.datePicker);
    }
    if (event.detail.value === false && this.blurWhileOpened) {
      this.blurWhileOpened = false;
      this.hideOutline(this.datePicker);
    }
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class DateObserver extends DatePickerObserver {
  constructor(datePicker, host) {
    super(datePicker);
    this.component = host;
  }
  getFieldIndex() {
    return 0;
  }
}
class TimeObserver extends FieldObserver {
  constructor(timePicker, host) {
    super(timePicker);
    this.component = host;
    this.timePicker = timePicker;
  }
  getFocusTarget(_event) {
    return this.timePicker;
  }
  getFieldIndex() {
    return 1;
  }
}
class DateTimePickerObserver extends ComponentObserver {
  constructor(picker) {
    super(picker);
    const [datePicker, timePicker] = this.getFields();
    this.dateObserver = new DateObserver(datePicker, picker);
    this.timeObserver = new TimeObserver(timePicker, picker);
  }
  getFields() {
    return [this.component.querySelector("[slot=date-picker]"), this.component.querySelector("[slot=time-picker]")];
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class ListBoxObserver extends FieldObserver {
  getFields() {
    return this.component.items || [];
  }
  getFocusTarget(event) {
    const fields2 = this.getFields();
    return Array.from(event.composedPath()).find((node) => fields2.includes(node));
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class RadioGroupObserver extends FieldObserver {
  getFields() {
    return this.component.__radioButtons;
  }
  getFocusTarget(event) {
    const fields2 = this.getFields();
    return Array.from(event.composedPath()).find((node) => fields2.includes(node));
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class SelectObserver extends FieldObserver {
  constructor(select) {
    super(select);
    this.overlay = select._overlayElement;
  }
  onFocusIn(event) {
    if (this.overlay._contentRoot.contains(event.target)) {
      return;
    }
    if (this.overlay._contentRoot.contains(event.relatedTarget)) {
      return;
    }
    super.onFocusIn(event);
  }
  onFocusOut(event) {
    if (this.overlay._contentRoot.contains(event.relatedTarget)) {
      return;
    }
    if (this.overlay._contentRoot.contains(event.target) && this.component.contains(event.relatedTarget)) {
      return;
    }
    super.onFocusOut(event);
  }
}
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const initFieldObserver = (field2) => {
  let result2;
  switch (field2.tagName.toLowerCase()) {
    /* c8 ignore next */
    case "vaadin-date-picker":
      result2 = new DatePickerObserver(field2);
      break;
    /* c8 ignore next */
    case "vaadin-date-time-picker":
      result2 = new DateTimePickerObserver(field2);
      break;
    /* c8 ignore next */
    case "vaadin-select":
      result2 = new SelectObserver(field2);
      break;
    /* c8 ignore next 2 */
    case "vaadin-checkbox-group":
      result2 = new CheckboxGroupObserver(field2);
      break;
    case "vaadin-radio-group":
      result2 = new RadioGroupObserver(field2);
      break;
    case "vaadin-list-box":
      result2 = new ListBoxObserver(field2);
      break;
    default:
      result2 = new FieldObserver(field2);
  }
  return result2;
};
class FieldHighlighterController {
  constructor(host) {
    this.host = host;
    this.user = null;
    this.users = [];
  }
  get user() {
    return this._user;
  }
  set user(user) {
    this._user = user;
    if (user) {
      const msg = `${user.name} started editing`;
      const { label } = this.host;
      announce(label ? `${msg} ${label}` : msg);
    }
  }
  hostConnected() {
    this.redraw();
  }
  addUser(user) {
    if (user) {
      this.users.push(user);
      this.redraw();
      this.user = user;
    }
  }
  setUsers(users) {
    if (Array.isArray(users)) {
      this.users = users;
      this.redraw();
      this.user = users[users.length - 1] || null;
    }
  }
  removeUser(user) {
    if (user && user.id !== void 0) {
      let index;
      for (let i2 = 0; i2 < this.users.length; i2++) {
        if (this.users[i2].id === user.id) {
          index = i2;
          break;
        }
      }
      if (index !== void 0) {
        this.users.splice(index, 1);
        this.redraw();
        if (this.users.length > 0) {
          this.user = this.users[this.users.length - 1];
        } else {
          this.user = null;
        }
      }
    }
  }
  redraw() {
    this.observer.redraw([...this.users].reverse());
  }
}
class FieldHighlighter extends HTMLElement {
  static get is() {
    return "vaadin-field-highlighter";
  }
  static init(field2) {
    if (!field2._highlighterController) {
      const instance = new FieldHighlighterController(field2);
      field2.setAttribute("has-highlighter", "");
      instance.observer = initFieldObserver(field2);
      field2.addController(instance);
      field2._highlighterController = instance;
    }
    return field2._highlighterController;
  }
  static addUser(field2, user) {
    this.init(field2).addUser(user);
  }
  static removeUser(field2, user) {
    this.init(field2).removeUser(user);
  }
  static setUsers(field2, users) {
    this.init(field2).setUsers(users);
  }
}
defineCustomElement(FieldHighlighter);
/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const accordionHeading = [
  detailsSummary("vaadin-accordion-heading"),
  css$e`
    button {
      align-items: center;
      appearance: none;
      background: transparent;
      border: 0;
      color: inherit;
      cursor: inherit;
      display: flex;
      font: inherit;
      gap: inherit;
      outline: none;
      padding: 0;
      touch-action: manipulation;
    }
  `
];
/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-accordion-heading";
  }
  static get shadowRootOptions() {
    return { ...LitElement.shadowRootOptions, delegatesFocus: true };
  }
  static get styles() {
    return accordionHeading;
  }
  static get properties() {
    return {
      /**
       * When true, the element is opened.
       */
      opened: {
        type: Boolean,
        reflectToAttribute: true,
        sync: true,
        value: false
      }
    };
  }
  /** @protected */
  render() {
    return html$3`
      <button id="button" part="content" ?disabled="${this.disabled}" aria-expanded="${this.opened ? "true" : "false"}">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    if (!this.hasAttribute("role")) {
      this.setAttribute("role", "heading");
    }
  }
}
defineCustomElement(AccordionHeading);
/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const accordionPanel = css$e`
  :host {
    display: block;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='content'] {
    box-sizing: border-box;
  }

  :host(:not([opened])) [part='content'] {
    display: none !important;
  }

  :host([focus-ring]) {
    --_focus-ring: 1;
  }
`;
/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const AccordionPanelMixin = (superClass) => class AccordionPanelMixinClass extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(superClass))) {
  static get properties() {
    return {
      /**
       * A text that is displayed in the heading, if no
       * element is assigned to the `summary` slot.
       */
      summary: {
        type: String,
        observer: "_summaryChanged"
      }
    };
  }
  static get observers() {
    return ["__updateAriaAttributes(focusElement, _contentElements)"];
  }
  static get delegateProps() {
    return ["disabled", "opened", "_theme"];
  }
  constructor() {
    super();
    this._summaryController = new SummaryController(this, "vaadin-accordion-heading");
    this._summaryController.addEventListener("slot-content-changed", (event) => {
      const { node } = event.target;
      this._setFocusElement(node);
      this.stateTarget = node;
      this._tooltipController.setTarget(node);
    });
    this._tooltipController = new TooltipController(this);
    this._tooltipController.setPosition("bottom-start");
  }
  /**
   * @protected
   * @override
   */
  __forwardTabIndex(tabindex) {
    super.__forwardTabIndex(tabindex);
    if (tabindex !== void 0 && this.focusElement) {
      this.focusElement.$.button.tabIndex = tabindex;
      this.focusElement.tabIndex = -1;
    }
  }
  /** @protected */
  ready() {
    super.ready();
    this.addController(this._summaryController);
    this.addController(this._tooltipController);
  }
  /**
   * Override method from `DelegateStateMixin` to set delegate `theme`
   * using attribute instead of property (needed for the Lit version).
   * @protected
   * @override
   */
  _delegateProperty(name, value) {
    if (!this.stateTarget) {
      return;
    }
    if (name === "_theme") {
      this._delegateAttribute("theme", value);
      return;
    }
    super._delegateProperty(name, value);
  }
  /**
   * Override method inherited from `DisabledMixin`
   * to not set `aria-disabled` on the host element.
   *
   * @protected
   * @override
   */
  _setAriaDisabled() {
  }
  /** @private */
  _summaryChanged(summary) {
    this._summaryController.setSummary(summary);
  }
  /** @private */
  __updateAriaAttributes(focusElement, contentElements) {
    if (focusElement && contentElements) {
      const node = contentElements[0];
      if (node) {
        node.setAttribute("role", "region");
        node.setAttribute("aria-labelledby", focusElement.id);
      }
      if (node && node.id) {
        focusElement.setAttribute("aria-controls", node.id);
      } else {
        focusElement.removeAttribute("aria-controls");
      }
    }
  }
};
/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AccordionPanel extends AccordionPanelMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-accordion-panel";
  }
  static get styles() {
    return accordionPanel;
  }
  /** @protected */
  render() {
    return html$3`
      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `;
  }
}
defineCustomElement(AccordionPanel);
/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const AccordionMixin = (superClass) => class AccordionMixinClass extends KeyboardDirectionMixin(superClass) {
  static get properties() {
    return {
      /**
       * The index of currently opened panel. First panel is opened by
       * default. Only one panel can be opened at the same time.
       * Setting null or undefined closes all the accordion panels.
       * @type {number}
       */
      opened: {
        type: Number,
        value: 0,
        notify: true,
        reflectToAttribute: true
      },
      /**
       * The list of `<vaadin-accordion-panel>` child elements.
       * It is populated from the elements passed to the light DOM,
       * and updated dynamically when adding or removing panels.
       * @type {!Array<!AccordionPanel>}
       */
      items: {
        type: Array,
        readOnly: true,
        notify: true
      }
    };
  }
  static get observers() {
    return ["_updateItems(items, opened)"];
  }
  constructor() {
    super();
    this._boundUpdateOpened = this._updateOpened.bind(this);
  }
  /**
   * Override getter from `KeyboardDirectionMixin`
   * to check if the heading element has focus.
   *
   * @return {Element | null}
   * @protected
   * @override
   */
  get focused() {
    return (this._getItems() || []).find((item) => isElementFocused(item.focusElement));
  }
  /**
   * @protected
   * @override
   */
  focus() {
    if (this._observer) {
      this._observer.flush();
    }
    super.focus();
  }
  /** @protected */
  ready() {
    super.ready();
    const slot = this.shadowRoot.querySelector("slot");
    this._observer = new SlotObserver(slot, (info) => {
      this._setItems(this._filterItems(Array.from(this.children)));
      this._filterItems(info.addedNodes).forEach((el) => {
        el.addEventListener("opened-changed", this._boundUpdateOpened);
      });
    });
  }
  /**
   * Override method inherited from `KeyboardDirectionMixin`
   * to use the stored list of accordion panels as items.
   *
   * @return {Element[]}
   * @protected
   * @override
   */
  _getItems() {
    return this.items;
  }
  /**
   * @param {!Array<!Element>} array
   * @return {!Array<!AccordionPanel>}
   * @protected
   */
  _filterItems(array) {
    return array.filter((el) => el instanceof customElements.get("vaadin-accordion-panel"));
  }
  /** @private */
  _updateItems(items, opened) {
    if (items) {
      this.__itemsSync = true;
      const itemToOpen = items[opened];
      items.forEach((item) => {
        item.opened = item === itemToOpen;
      });
      this.__itemsSync = false;
    }
  }
  /**
   * Override an event listener from `KeyboardMixin`
   * to only handle details toggle buttons events.
   *
   * @param {!KeyboardEvent} event
   * @protected
   * @override
   */
  _onKeyDown(event) {
    if (!this.items.some((item) => item.focusElement === event.target)) {
      return;
    }
    super._onKeyDown(event);
  }
  /** @private */
  _updateOpened(e) {
    if (this.__itemsSync) {
      return;
    }
    const target = this._filterItems(e.composedPath())[0];
    const idx2 = this.items.indexOf(target);
    if (e.detail.value) {
      if (target.disabled || idx2 === -1) {
        return;
      }
      this.opened = idx2;
    } else if (!this.items.some((item) => item.opened)) {
      this.opened = null;
    }
  }
};
/**
 * @license
 * Copyright (c) 2019 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class Accordion extends AccordionMixin(ThemableMixin(ElementMixin(PolylitMixin(LitElement)))) {
  static get is() {
    return "vaadin-accordion";
  }
  static get styles() {
    return css$e`
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }
    `;
  }
  /** @protected */
  render() {
    return html$3`<slot></slot>`;
  }
}
defineCustomElement(Accordion);
/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
function _detectIosNavbar() {
  if (isIOS) {
    const innerHeight = window.innerHeight;
    const innerWidth = window.innerWidth;
    const landscape = innerWidth > innerHeight;
    const clientHeight = document.documentElement.clientHeight;
    if (landscape && clientHeight > innerHeight) {
      document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom", `${clientHeight - innerHeight}px`);
    } else {
      document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom", "");
    }
  }
}
_detectIosNavbar();
window.addEventListener("resize", _detectIosNavbar);
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const template$3 = document.createElement("template");
template$3.innerHTML = `
  <style>
    /* Use units so that the values can be used in calc() */
    html {
      --safe-area-inset-top: env(safe-area-inset-top, 0px);
      --safe-area-inset-right: env(safe-area-inset-right, 0px);
      --safe-area-inset-bottom: env(safe-area-inset-bottom, 0px);
      --safe-area-inset-left: env(safe-area-inset-left, 0px);
    }
  </style>
`;
document.head.appendChild(template$3.content);
/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const appLayoutStyles = css$e`
  :host {
    display: block;
    box-sizing: border-box;
    height: 100%;
    --vaadin-app-layout-transition-duration: 0s;
    transition: padding var(--vaadin-app-layout-transition-duration);
    --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, auto);
    --vaadin-app-layout-touch-optimized: false;
    --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
    --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
    padding-block: var(--vaadin-app-layout-navbar-offset-top) var(--vaadin-app-layout-navbar-offset-bottom);
    padding-inline-start: var(--vaadin-app-layout-navbar-offset-left);
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  @media (prefers-reduced-motion: no-preference) {
    :host(:not([no-anim])) {
      --vaadin-app-layout-transition-duration: 200ms;
    }
  }

  :host([drawer-opened]) {
    --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
  }

  :host([overlay]) {
    --vaadin-app-layout-drawer-offset-left: 0;
    --vaadin-app-layout-navbar-offset-left: 0;
  }

  :host(:not([no-scroll])) [content] {
    overflow: auto;
  }

  [content] {
    height: 100%;
  }

  @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
    :host {
      --vaadin-app-layout-touch-optimized: true;
    }
  }

  [part='navbar'] {
    position: fixed;
    display: flex;
    align-items: center;
    top: 0;
    inset-inline: 0;
    transition: inset-inline-start var(--vaadin-app-layout-transition-duration);
    padding-top: max(var(--vaadin-app-layout-navbar-padding-top, var(--vaadin-padding-s)), var(--safe-area-inset-top));
    padding-bottom: var(--vaadin-app-layout-navbar-padding-bottom, var(--vaadin-padding-s));
    padding-inline-start: max(
      var(--vaadin-app-layout-navbar-padding-inline-start, var(--vaadin-padding-s)),
      var(--safe-area-inset-left)
    );
    /* stylelint-disable-next-line declaration-block-no-redundant-longhand-properties */
    padding-inline-end: max(
      var(--vaadin-app-layout-navbar-padding-inline-end, var(--vaadin-padding-s)),
      var(--safe-area-inset-right)
    );
    z-index: 1;
    gap: var(--vaadin-app-layout-navbar-gap, var(--vaadin-gap-s));
    background: var(--vaadin-app-layout-navbar-background, var(--vaadin-background-container));
  }

  :host([primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
    inset-inline-start: var(--vaadin-app-layout-drawer-offset-left, 0);
  }

  :host([primary-section='drawer']) [part='drawer'] {
    top: 0;
  }

  [part='navbar'][bottom] {
    top: auto;
    bottom: 0;
    padding-top: var(--vaadin-app-layout-navbar-padding-top, var(--vaadin-padding-s));
    padding-bottom: max(
      var(--vaadin-app-layout-navbar-padding-bottom, var(--vaadin-padding-s)),
      var(--safe-area-inset-bottom)
    );
  }

  [part='drawer'] {
    overflow: auto;
    overscroll-behavior: contain;
    position: fixed;
    top: var(--vaadin-app-layout-navbar-offset-top, 0);
    bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
    inset-inline: var(--vaadin-app-layout-navbar-offset-left, 0) auto;
    transition:
      transform var(--vaadin-app-layout-transition-duration),
      visibility var(--vaadin-app-layout-transition-duration);
    transform: translateX(-100%);
    max-width: 90%;
    width: var(--_vaadin-app-layout-drawer-width);
    box-sizing: border-box;
    padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
    outline: none;
    /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
    visibility: hidden;
    display: flex;
    flex-direction: column;
    background: var(--vaadin-app-layout-drawer-background, transparent);
  }

  :host([drawer-opened]) [part='drawer'] {
    /* The drawer should be accessible by the tabbing navigation when it is opened. */
    visibility: visible;
    transform: translateX(0%);
    touch-action: manipulation;
  }

  [part='backdrop'] {
    background: var(--vaadin-overlay-backdrop-background, rgba(0, 0, 0, 0.5));
  }

  :host(:not([drawer-opened])) [part='backdrop'] {
    opacity: 0 !important;
  }

  :host([overlay]) [part='backdrop'] {
    position: fixed;
    inset: 0;
    pointer-events: none;
    transition: opacity var(--vaadin-app-layout-transition-duration);
    -webkit-tap-highlight-color: transparent;
  }

  :host([overlay]) [part='drawer'] {
    top: 0;
    bottom: 0;
    box-shadow: var(--vaadin-overlay-box-shadow, 0 8px 24px -4px rgba(0, 0, 0, 0.3));
    background: var(--vaadin-app-layout-drawer-background, var(--vaadin-background-color));
  }

  :host([overlay]) [part='drawer'],
  :host([overlay]) [part='backdrop'] {
    z-index: 2;
  }

  :host([drawer-opened][overlay]) [part='backdrop'] {
    pointer-events: auto;
    touch-action: manipulation;
  }

  :host([dir='rtl']) [part='drawer'] {
    transform: translateX(100%);
  }

  :host([dir='rtl'][drawer-opened]) [part='drawer'] {
    transform: translateX(0%);
  }

  :host([drawer-opened]:not([overlay])) {
    padding-inline-start: var(--vaadin-app-layout-drawer-offset-left);
  }

  @media (max-width: 800px), (max-height: 600px) {
    :host {
      --vaadin-app-layout-drawer-overlay: true;
      --_vaadin-app-layout-drawer-width: var(--vaadin-app-layout-drawer-width, 320px);
    }
  }

  /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
  [part='drawer'] ::slotted(vaadin-scroller) {
    flex: 1;
    overscroll-behavior: contain;
  }

  @media (forced-colors: active) {
    :host([overlay]) [part='drawer'] {
      border: 3px solid;
    }
  }
`;
/**
 * @license
 * Copyright (c) 2017 Anton Korzunov
 * SPDX-License-Identifier: MIT
 */
let counterMap = /* @__PURE__ */ new WeakMap();
let uncontrolledNodes = /* @__PURE__ */ new WeakMap();
let markerMap = {};
let lockCount = 0;
const isElement = (node) => node && node.nodeType === Node.ELEMENT_NODE;
const logError = (...args) => {
  console.error(`Error: ${args.join(" ")}. Skip setting aria-hidden.`);
};
const correctTargets = (parent, targets) => {
  if (!isElement(parent)) {
    logError(parent, "is not a valid element");
    return [];
  }
  return targets.map((target) => {
    if (!isElement(target)) {
      logError(target, "is not a valid element");
      return null;
    }
    let node = target;
    while (node && node !== parent) {
      if (parent.contains(node)) {
        return target;
      }
      node = node.getRootNode().host;
    }
    logError(target, "is not contained inside", parent);
    return null;
  }).filter((x) => Boolean(x));
};
const applyAttributeToOthers = (originalTarget, parentNode, markerName, controlAttribute) => {
  const targets = correctTargets(parentNode, Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  if (!markerMap[markerName]) {
    markerMap[markerName] = /* @__PURE__ */ new WeakMap();
  }
  const markerCounter = markerMap[markerName];
  const hiddenNodes = [];
  const elementsToKeep = /* @__PURE__ */ new Set();
  const elementsToStop = new Set(targets);
  const keep = (el) => {
    if (!el || elementsToKeep.has(el)) {
      return;
    }
    elementsToKeep.add(el);
    const slot = el.assignedSlot;
    if (slot) {
      keep(slot);
    }
    keep(el.parentNode || el.host);
  };
  targets.forEach(keep);
  const deep = (parent) => {
    if (!parent || elementsToStop.has(parent)) {
      return;
    }
    const root = parent.shadowRoot;
    const children = root ? [...parent.children, ...root.children] : [...parent.children];
    children.forEach((node) => {
      if (["template", "script", "style"].includes(node.localName)) {
        return;
      }
      if (elementsToKeep.has(node)) {
        deep(node);
      } else {
        const attr2 = node.getAttribute(controlAttribute);
        const alreadyHidden = attr2 !== null && attr2 !== "false";
        const counterValue = (counterMap.get(node) || 0) + 1;
        const markerValue = (markerCounter.get(node) || 0) + 1;
        counterMap.set(node, counterValue);
        markerCounter.set(node, markerValue);
        hiddenNodes.push(node);
        if (counterValue === 1 && alreadyHidden) {
          uncontrolledNodes.set(node, true);
        }
        if (markerValue === 1) {
          node.setAttribute(markerName, "true");
        }
        if (!alreadyHidden) {
          node.setAttribute(controlAttribute, "true");
        }
      }
    });
  };
  deep(parentNode);
  elementsToKeep.clear();
  lockCount += 1;
  return () => {
    hiddenNodes.forEach((node) => {
      const counterValue = counterMap.get(node) - 1;
      const markerValue = markerCounter.get(node) - 1;
      counterMap.set(node, counterValue);
      markerCounter.set(node, markerValue);
      if (!counterValue) {
        if (uncontrolledNodes.has(node)) {
          uncontrolledNodes.delete(node);
        } else {
          node.removeAttribute(controlAttribute);
        }
      }
      if (!markerValue) {
        node.removeAttribute(markerName);
      }
    });
    lockCount -= 1;
    if (!lockCount) {
      counterMap = /* @__PURE__ */ new WeakMap();
      counterMap = /* @__PURE__ */ new WeakMap();
      uncontrolledNodes = /* @__PURE__ */ new WeakMap();
      markerMap = {};
    }
  };
};
const hideOthers = (originalTarget, parentNode = document.body, markerName = "data-aria-hidden") => {
  const targets = Array.from(Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  if (parentNode) {
    targets.push(...Array.from(parentNode.querySelectorAll("[aria-live]")));
  }
  return applyAttributeToOthers(targets, parentNode, markerName, "aria-hidden");
};
/**
 * @license
 * Copyright (c) 2021 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AriaModalController {
  /**
   * @param {HTMLElement} host
   */
  constructor(host, callback) {
    this.host = host;
    this.callback = typeof callback === "function" ? callback : () => host;
  }
  /**
   * Make the controller host modal by hiding other elements from screen readers
   * using `aria-hidden` attribute (can be replaced with `inert` in the future).
   *
   * The method name is chosen to align with the one provided by native `<dialog>`:
   * https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement/showModal
   */
  showModal() {
    const targets = this.callback();
    this.__showOthers = hideOthers(targets);
  }
  /**
   * Remove `aria-hidden` from other elements unless there are any other
   * controller hosts on the page activated by using `showModal()` call.
   */
  close() {
    if (this.__showOthers) {
      this.__showOthers();
      this.__showOthers = null;
    }
  }
}
/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const DEFAULT_I18N$9 = {
  drawer: "Drawer"
};
const AppLayoutMixin = (superclass) => class AppLayoutMixinClass extends I18nMixin(DEFAULT_I18N$9, superclass) {
  static get properties() {
    return {
      /**
       * Defines whether navbar or drawer will come first visually.
       * - By default (`primary-section="navbar"`), the navbar takes the full available width and moves the drawer down.
       * - If `primary-section="drawer"` is set, then the drawer will move the navbar, taking the full available height.
       * @attr {navbar|drawer} primary-section
       * @type {!PrimarySection}
       */
      primarySection: {
        type: String,
        value: "navbar",
        notify: true,
        reflectToAttribute: true,
        observer: "__primarySectionChanged",
        sync: true
      },
      /**
       * Controls whether the drawer is opened (visible) or not.
       * Its default value depends on the viewport:
       * - `true`, for desktop size views
       * - `false`, for mobile size views
       * @attr {boolean} drawer-opened
       * @type {boolean}
       */
      drawerOpened: {
        type: Boolean,
        notify: true,
        value: true,
        reflectToAttribute: true,
        observer: "__drawerOpenedChanged",
        sync: true
      },
      /**
       * Drawer is an overlay on top of the content
       * Controlled via CSS using `--vaadin-app-layout-drawer-overlay: true|false`;
       * @type {boolean}
       */
      overlay: {
        type: Boolean,
        notify: true,
        readOnly: true,
        value: false,
        reflectToAttribute: true,
        observer: "__overlayChanged",
        sync: true
      },
      /**
       * A global event that causes the drawer to close (be hidden) when it is in overlay mode.
       * - The default is `vaadin-router-location-changed` dispatched by Vaadin Router
       *
       * @attr {string} close-drawer-on
       * @type {string}
       */
      closeDrawerOn: {
        type: String,
        value: "vaadin-router-location-changed",
        observer: "_closeDrawerOnChanged"
      }
    };
  }
  static get observers() {
    return ["__i18nChanged(__effectiveI18n)"];
  }
  /**
   * Helper static method that dispatches a `close-overlay-drawer` event
   */
  static dispatchCloseOverlayDrawerEvent() {
    window.dispatchEvent(new CustomEvent("close-overlay-drawer"));
  }
  /**
   * The object used to localize this component. To change the default
   * localization, replace this with an object that provides all properties, or
   * just the individual properties you want to change.
   *
   * The object has the following structure and default values:
   * ```
   * {
   *   drawer: 'Drawer'
   * }
   * ```
   * @return {!AppLayoutI18n}
   */
  get i18n() {
    return super.i18n;
  }
  set i18n(value) {
    super.i18n = value;
  }
  constructor() {
    super();
    this.__boundResizeListener = this._resize.bind(this);
    this.__drawerToggleClickListener = this._drawerToggleClick.bind(this);
    this.__onDrawerKeyDown = this.__onDrawerKeyDown.bind(this);
    this.__closeOverlayDrawerListener = this.__closeOverlayDrawer.bind(this);
    this.__trapFocusInDrawer = this.__trapFocusInDrawer.bind(this);
    this.__releaseFocusFromDrawer = this.__releaseFocusFromDrawer.bind(this);
    this.__ariaModalController = new AriaModalController(this, () => [
      ...this.querySelectorAll('vaadin-drawer-toggle, [slot="drawer"]')
    ]);
    this.__focusTrapController = new FocusTrapController(this);
  }
  /** @protected */
  connectedCallback() {
    super.connectedCallback();
    this._blockAnimationUntilAfterNextRender();
    window.addEventListener("resize", this.__boundResizeListener);
    this.addEventListener("drawer-toggle-click", this.__drawerToggleClickListener);
    requestAnimationFrame(() => {
      this._updateOffsetSize();
    });
    this._updateTouchOptimizedMode();
    this._updateDrawerSize();
    this._updateOverlayMode();
    this._navbarSizeObserver = new ResizeObserver(() => {
      requestAnimationFrame(() => {
        if (this.__isDrawerAnimating) {
          this.__updateOffsetSizePending = true;
        } else {
          this._updateOffsetSize();
        }
      });
    });
    this._navbarSizeObserver.observe(this.$.navbarTop);
    this._navbarSizeObserver.observe(this.$.navbarBottom);
    this._navbarSizeObserver.observe(this.$.drawer);
    window.addEventListener("close-overlay-drawer", this.__closeOverlayDrawerListener);
    window.addEventListener("keydown", this.__onDrawerKeyDown);
  }
  /** @protected */
  ready() {
    super.ready();
    this.addController(this.__focusTrapController);
    this.__setAriaExpanded();
    this.$.drawer.addEventListener("transitionstart", () => {
      this.__isDrawerAnimating = true;
    });
    this.$.drawer.addEventListener("transitionend", () => {
      if (this.__updateOffsetSizePending) {
        this.__updateOffsetSizePending = false;
        this._updateOffsetSize();
      }
      requestAnimationFrame(() => {
        this.__isDrawerAnimating = false;
      });
    });
  }
  /** @protected */
  disconnectedCallback() {
    super.disconnectedCallback();
    window.removeEventListener("resize", this.__boundResizeListener);
    this.removeEventListener("drawer-toggle-click", this.__drawerToggleClickListener);
    window.removeEventListener("close-overlay-drawer", this.__drawerToggleClickListener);
    window.removeEventListener("keydown", this.__onDrawerKeyDown);
  }
  /**
   * A callback for the `primarySection` property observer.
   *
   * Ensures the property is set to its default value `navbar`
   * whenever the new value is not one of the valid values: `navbar`, `drawer`.
   *
   * @param {string} value
   * @private
   */
  __primarySectionChanged(value) {
    const isValid2 = ["navbar", "drawer"].includes(value);
    if (!isValid2) {
      this.primarySection = "navbar";
    }
  }
  /**
   * A callback for the `drawerOpened` property observer.
   *
   * When the drawer opens, the method ensures the drawer has a proper height and sets focus on it.
   * As long as the drawer is open, the focus is trapped within the drawer.
   *
   * When the drawer closes, the method releases focus from the drawer, setting focus on the drawer toggle.
   *
   * @param {boolean} drawerOpened
   * @param {boolean} oldDrawerOpened
   * @private
   */
  __drawerOpenedChanged(drawerOpened, oldDrawerOpened) {
    if (this.overlay) {
      if (drawerOpened) {
        this.__trapFocusInDrawer();
      } else if (oldDrawerOpened) {
        this.__releaseFocusFromDrawer();
      }
    }
    this.__setAriaExpanded();
  }
  /**
   * A callback for the `overlay` property observer.
   *
   * When layout resizes while in the overlay mode, drawer opened state
   * is not changed, but focus trap needs to be removed.
   *
   * @param {boolean} overlay
   * @param {boolean} oldOverlay
   * @private
   */
  __overlayChanged(_overlay, oldOverlay) {
    if (oldOverlay) {
      this.__restoreFocus();
    }
  }
  /**
   * A callback for the `i18n` property observer.
   *
   * The method ensures the drawer has ARIA attributes updated
   * once the `i18n` property changes.
   *
   * @private
   */
  __i18nChanged() {
    this.__updateDrawerAriaAttributes();
  }
  /** @private */
  _drawerToggleClick(e) {
    e.stopPropagation();
    this.drawerOpened = !this.drawerOpened;
  }
  /** @private */
  __closeOverlayDrawer() {
    if (this.overlay) {
      this.drawerOpened = false;
    }
  }
  /** @private */
  __setAriaExpanded() {
    const toggle = this.querySelector("vaadin-drawer-toggle");
    if (toggle) {
      toggle.setAttribute("aria-expanded", this.drawerOpened);
    }
  }
  /** @protected */
  _updateDrawerSize() {
    const childCount = this.querySelectorAll("[slot=drawer]").length;
    const drawer = this.$.drawer;
    if (childCount === 0) {
      drawer.setAttribute("hidden", "");
      this.style.setProperty("--_vaadin-app-layout-drawer-width", 0);
    } else {
      drawer.removeAttribute("hidden");
      this.style.removeProperty("--_vaadin-app-layout-drawer-width");
    }
    this._updateOffsetSize();
  }
  /** @private */
  _resize() {
    this._blockAnimationUntilAfterNextRender();
    this._updateTouchOptimizedMode();
    this._updateOverlayMode();
  }
  /** @protected */
  _updateOffsetSize() {
    const navbar = this.$.navbarTop;
    const navbarRect = navbar.getBoundingClientRect();
    const navbarBottom = this.$.navbarBottom;
    const navbarBottomRect = navbarBottom.getBoundingClientRect();
    const drawer = this.$.drawer;
    const drawerRect = drawer.getBoundingClientRect();
    this.style.setProperty("--_vaadin-app-layout-navbar-offset-size", `${navbarRect.height}px`);
    this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom", `${navbarBottomRect.height}px`);
    this.style.setProperty("--_vaadin-app-layout-drawer-offset-size", `${drawerRect.width}px`);
  }
  /** @protected */
  _updateOverlayMode() {
    const overlay = this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay") === "true";
    if (!this.overlay && overlay) {
      this._drawerStateSaved = this.drawerOpened;
      this.drawerOpened = false;
    }
    this._setOverlay(overlay);
    if (!this.overlay && this._drawerStateSaved) {
      this.drawerOpened = this._drawerStateSaved;
      this._drawerStateSaved = null;
    }
    this.__updateDrawerAriaAttributes();
  }
  /**
   * Updates ARIA attributes on the drawer depending on the drawer mode.
   *
   * - In the overlay mode, the method marks the drawer with ARIA attributes as a dialog
   * labelled with the `i18n.drawer` property.
   * - In the normal mode, the method removes the ARIA attributes that has been set for the overlay mode.
   *
   * @private
   */
  __updateDrawerAriaAttributes() {
    const drawer = this.$.drawer;
    if (this.overlay) {
      drawer.setAttribute("role", "dialog");
      drawer.setAttribute("aria-modal", "true");
      drawer.setAttribute("aria-label", this.__effectiveI18n.drawer);
    } else {
      drawer.removeAttribute("role");
      drawer.removeAttribute("aria-modal");
      drawer.removeAttribute("aria-label");
    }
  }
  /**
   * Returns a promise that resolves when the drawer opening/closing CSS transition ends.
   *
   * The method relies on the `--vaadin-app-layout-transition-duration` CSS variable to detect whether
   * the drawer has a CSS transition that needs to be awaited. If the CSS variable equals `0s`,
   * the promise resolves immediately.
   *
   * @return {Promise}
   * @private
   */
  __drawerTransitionComplete() {
    return new Promise((resolve) => {
      if (this._getCustomPropertyValue("--vaadin-app-layout-transition-duration") === "0s") {
        resolve();
        return;
      }
      this.$.drawer.addEventListener("transitionend", resolve, { once: true });
    });
  }
  /** @private */
  async __trapFocusInDrawer() {
    await this.__drawerTransitionComplete();
    if (!this.drawerOpened) {
      return;
    }
    this.$.drawer.setAttribute("tabindex", "0");
    this.__ariaModalController.showModal();
    this.__focusTrapController.trapFocus(this.$.drawer);
  }
  /** @private */
  async __releaseFocusFromDrawer() {
    await this.__drawerTransitionComplete();
    if (this.drawerOpened) {
      return;
    }
    this.__restoreFocus();
    const toggle = this.querySelector("vaadin-drawer-toggle");
    if (toggle) {
      toggle.focus();
      toggle.setAttribute("focus-ring", "focus");
    }
  }
  /** @private */
  __restoreFocus() {
    this.__ariaModalController.close();
    this.__focusTrapController.releaseFocus();
    this.$.drawer.removeAttribute("tabindex");
  }
  /**
   * Closes the drawer on Escape press if it has been opened in the overlay mode.
   *
   * @param {KeyboardEvent} event
   * @private
   */
  __onDrawerKeyDown(event) {
    if (event.key === "Escape" && this.overlay) {
      this.drawerOpened = false;
    }
  }
  /** @private */
  _closeDrawerOnChanged(closeDrawerOn, oldCloseDrawerOn) {
    if (oldCloseDrawerOn) {
      window.removeEventListener(oldCloseDrawerOn, this.__closeOverlayDrawerListener);
    }
    if (closeDrawerOn) {
      window.addEventListener(closeDrawerOn, this.__closeOverlayDrawerListener);
    }
  }
  /** @private */
  _onBackdropClick() {
    this._close();
  }
  /** @private */
  _onBackdropTouchend(event) {
    event.preventDefault();
    this._close();
  }
  /** @protected */
  _close() {
    this.drawerOpened = false;
  }
  /** @private */
  _getCustomPropertyValue(customProperty) {
    const customPropertyValue = getComputedStyle(this).getPropertyValue(customProperty);
    return (customPropertyValue || "").trim().toLowerCase();
  }
  /** @protected */
  _updateTouchOptimizedMode() {
    const touchOptimized = this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized") === "true";
    const navbarItems = this.querySelectorAll('[slot*="navbar"]');
    if (navbarItems.length > 0) {
      Array.from(navbarItems).forEach((navbar) => {
        if (navbar.getAttribute("slot").indexOf("touch-optimized") > -1) {
          navbar.__touchOptimized = true;
        }
        if (touchOptimized && navbar.__touchOptimized) {
          navbar.setAttribute("slot", "navbar-bottom");
        } else {
          navbar.setAttribute("slot", "navbar");
        }
      });
    }
    if (this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length === 0) {
      this.$.navbarTop.setAttribute("hidden", "");
    } else {
      this.$.navbarTop.removeAttribute("hidden");
    }
    if (this.$.navbarBottom.querySelector("[name=navbar-bottom]").assignedNodes().length === 0) {
      this.$.navbarBottom.setAttribute("hidden", "");
    } else {
      this.$.navbarBottom.removeAttribute("hidden");
    }
    this._updateOffsetSize();
  }
  /** @protected */
  _blockAnimationUntilAfterNextRender() {
    this.setAttribute("no-anim", "");
    this.__debounceAnimation = Debouncer.debounce(this.__debounceAnimation, animationFrame, () => {
      setTimeout(() => {
        this.removeAttribute("no-anim");
      });
    });
  }
  /**
   * App Layout listens to `close-overlay-drawer` on the window level.
   * A custom event can be dispatched and the App Layout will close the drawer in overlay.
   *
   * That can be used, for instance, when a navigation occurs when user clicks in a menu item inside the drawer.
   *
   * See `dispatchCloseOverlayDrawerEvent()` helper method.
   *
   * @event close-overlay-drawer
   */
};
/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AppLayout extends AppLayoutMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-app-layout";
  }
  static get styles() {
    return appLayoutStyles;
  }
  /** @protected */
  render() {
    return html$3`
      <div part="navbar" id="navbarTop">
        <slot name="navbar" @slotchange="${this._updateTouchOptimizedMode}"></slot>
      </div>
      <div part="backdrop" @click="${this._onBackdropClick}" @touchend="${this._onBackdropTouchend}"></div>
      <div part="drawer" id="drawer">
        <slot name="drawer" id="drawerSlot" @slotchange="${this._updateDrawerSize}"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar" id="navbarBottom" bottom hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden>
        <slot id="touchSlot" name="navbar touch-optimized" @slotchange="${this._updateTouchOptimizedMode}"></slot>
      </div>
    `;
  }
}
defineCustomElement(AppLayout);
/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const drawerToggle = css$e`
  [part='icon'] {
    background: currentColor;
    display: block;
    height: var(--vaadin-icon-size, 1lh);
    mask-image: var(--_vaadin-icon-menu);
    width: var(--vaadin-icon-size, 1lh);
  }

  [hidden] {
    display: none !important;
  }

  @media (forced-colors: active) {
    [part='icon'] {
      background: CanvasText;
    }
  }
`;
/**
 * @license
 * Copyright (c) 2018 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class DrawerToggle extends ButtonMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-drawer-toggle";
  }
  static get styles() {
    return [buttonStyles, drawerToggle];
  }
  static get properties() {
    return {
      ariaLabel: {
        type: String,
        value: "Toggle navigation panel",
        reflectToAttribute: true,
        sync: true
      },
      /** @private */
      _showFallbackIcon: {
        type: Boolean,
        value: false
      }
    };
  }
  constructor() {
    super();
    this.addEventListener("click", () => {
      this.dispatchEvent(new CustomEvent("drawer-toggle-click", { bubbles: true, composed: true }));
    });
  }
  /** @protected */
  render() {
    return html$3`
      <slot id="slot" @slotchange="${this._toggleFallbackIcon}">
        <div part="icon"></div>
      </slot>
      <div part="icon" ?hidden="${!this._showFallbackIcon}"></div>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this._toggleFallbackIcon();
  }
  /** @private */
  _toggleFallbackIcon() {
    const nodes = this.$.slot.assignedNodes();
    this._showFallbackIcon = nodes.length > 0 && nodes.every((node) => isEmptyTextNode(node));
  }
}
defineCustomElement(DrawerToggle);
/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const tooltipOverlayStyles = css$e`
  :host {
    --_vaadin-tooltip-default-offset: 4px;
    line-height: normal;
  }

  [part='overlay'] {
    max-width: var(--vaadin-tooltip-max-width, 40ch);
    padding: var(--vaadin-tooltip-padding, var(--vaadin-padding-container));
    border-radius: var(--vaadin-tooltip-border-radius, var(--vaadin-radius-m));
    background: var(--vaadin-tooltip-background, var(--vaadin-background-color));
    color: var(--vaadin-tooltip-color, inherit);
    font-size: var(--vaadin-tooltip-font-size, 0.9em);
    font-weight: var(--vaadin-tooltip-font-weight, inherit);
    line-height: var(--vaadin-tooltip-line-height, inherit);
    border: 0;
    box-shadow:
      0 0 0 var(--vaadin-tooltip-border-width, 1px)
        var(--vaadin-tooltip-border-color, var(--vaadin-border-color-subtle)),
      var(--vaadin-tooltip-box-shadow, 0 3px 8px -1px rgba(0, 0, 0, 0.2));
  }

  [part='content'] {
    white-space: pre-wrap;
  }

  :host([position^='top'][top-aligned]) [part='overlay'],
  :host([position^='bottom'][top-aligned]) [part='overlay'] {
    margin-top: var(--vaadin-tooltip-offset-top, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='top'][bottom-aligned]) [part='overlay'],
  :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
    margin-bottom: var(--vaadin-tooltip-offset-bottom, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='start'][start-aligned]) [part='overlay'],
  :host([position^='end'][start-aligned]) [part='overlay'] {
    margin-inline-start: var(--vaadin-tooltip-offset-start, var(--_vaadin-tooltip-default-offset));
  }

  :host([position^='start'][end-aligned]) [part='overlay'],
  :host([position^='end'][end-aligned]) [part='overlay'] {
    margin-inline-end: var(--vaadin-tooltip-offset-end, var(--_vaadin-tooltip-default-offset));
  }

  @media (forced-colors: active) {
    [part='overlay'] {
      border: 1px dashed !important;
    }
  }
`;
/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class TooltipOverlay extends PopoverOverlayMixin(
  DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))
) {
  static get is() {
    return "vaadin-tooltip-overlay";
  }
  static get styles() {
    return [overlayStyles$1, tooltipOverlayStyles];
  }
  /** @protected */
  render() {
    return html$3`
      <div part="overlay" id="overlay">
        <div part="content" id="content"><slot></slot></div>
      </div>
    `;
  }
}
defineCustomElement(TooltipOverlay);
/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const DEFAULT_DELAY = 500;
let defaultFocusDelay$2 = DEFAULT_DELAY;
let defaultHoverDelay$2 = DEFAULT_DELAY;
let defaultHideDelay$2 = DEFAULT_DELAY;
const closing = /* @__PURE__ */ new Set();
let warmedUp = false;
let warmUpTimeout = null;
let cooldownTimeout = null;
class TooltipStateController {
  constructor(host) {
    this.host = host;
  }
  /** @private */
  get focusDelay() {
    const tooltip = this.host;
    return tooltip.focusDelay != null && tooltip.focusDelay >= 0 ? tooltip.focusDelay : defaultFocusDelay$2;
  }
  /** @private */
  get hoverDelay() {
    const tooltip = this.host;
    return tooltip.hoverDelay != null && tooltip.hoverDelay >= 0 ? tooltip.hoverDelay : defaultHoverDelay$2;
  }
  /** @private */
  get hideDelay() {
    const tooltip = this.host;
    return tooltip.hideDelay != null && tooltip.hideDelay >= 0 ? tooltip.hideDelay : defaultHideDelay$2;
  }
  /**
   * Whether closing is currently in progress.
   * @return {boolean}
   */
  get isClosing() {
    return closing.has(this.host);
  }
  /**
   * Schedule opening the tooltip.
   * @param {Object} options
   */
  open(options = { immediate: false }) {
    const { immediate, hover, focus: focus2 } = options;
    const isHover = hover && this.hoverDelay > 0;
    const isFocus = focus2 && this.focusDelay > 0;
    if (!immediate && (isHover || isFocus) && !this.__closeTimeout) {
      this.__warmupTooltip(isFocus);
    } else {
      this.__showTooltip();
    }
  }
  /**
   * Schedule closing the tooltip.
   * @param {boolean} immediate
   */
  close(immediate) {
    if (!immediate && this.hideDelay > 0) {
      this.__scheduleClose();
    } else {
      this.__abortClose();
      this._setOpened(false);
    }
    this.__abortWarmUp();
    if (warmedUp) {
      this.__abortCooldown();
      this.__scheduleCooldown();
    }
  }
  /** @private */
  _isOpened() {
    return this.host.opened;
  }
  /** @private */
  _setOpened(opened) {
    this.host.opened = opened;
  }
  /** @private */
  __flushClosingTooltips() {
    closing.forEach((tooltip) => {
      tooltip._stateController.close(true);
      closing.delete(tooltip);
    });
  }
  /** @private */
  __showTooltip() {
    this.__abortClose();
    this.__flushClosingTooltips();
    this._setOpened(true);
    warmedUp = true;
    this.__abortWarmUp();
    this.__abortCooldown();
  }
  /** @private */
  __warmupTooltip(isFocus) {
    if (!this._isOpened()) {
      if (warmedUp) {
        this.__showTooltip();
      } else if (warmUpTimeout == null) {
        this.__scheduleWarmUp(isFocus);
      }
    }
  }
  /** @private */
  __abortClose() {
    if (this.__closeTimeout) {
      clearTimeout(this.__closeTimeout);
      this.__closeTimeout = null;
    }
    if (this.isClosing) {
      closing.delete(this.host);
    }
  }
  /** @private */
  __abortCooldown() {
    if (cooldownTimeout) {
      clearTimeout(cooldownTimeout);
      cooldownTimeout = null;
    }
  }
  /** @private */
  __abortWarmUp() {
    if (warmUpTimeout) {
      clearTimeout(warmUpTimeout);
      warmUpTimeout = null;
    }
  }
  /** @private */
  __scheduleClose() {
    if (this._isOpened() && !this.isClosing) {
      closing.add(this.host);
      this.__closeTimeout = setTimeout(() => {
        closing.delete(this.host);
        this.__closeTimeout = null;
        this._setOpened(false);
      }, this.hideDelay);
    }
  }
  /** @private */
  __scheduleCooldown() {
    cooldownTimeout = setTimeout(() => {
      cooldownTimeout = null;
      warmedUp = false;
    }, this.hideDelay);
  }
  /** @private */
  __scheduleWarmUp(isFocus) {
    const delay = isFocus ? this.focusDelay : this.hoverDelay;
    warmUpTimeout = setTimeout(() => {
      warmUpTimeout = null;
      warmedUp = true;
      this.__showTooltip();
    }, delay);
  }
}
const TooltipMixin = (superClass) => class TooltipMixinClass extends PopoverPositionMixin(PopoverTargetMixin(superClass)) {
  static get properties() {
    return {
      /**
       * Element used to link with the `aria-describedby`
       * attribute. Supports array of multiple elements.
       * When not set, defaults to `target`.
       */
      ariaTarget: {
        type: Object
      },
      /**
       * Object with properties passed to `generator` and
       * `shouldShow` functions for generating tooltip text
       * or detecting whether to show the tooltip or not.
       */
      context: {
        type: Object,
        value: () => {
          return {};
        }
      },
      /**
       * The delay in milliseconds before the tooltip
       * is opened on keyboard focus, when not in manual mode.
       * @attr {number} focus-delay
       */
      focusDelay: {
        type: Number
      },
      /**
       * Function used to generate the tooltip content.
       * When provided, it overrides the `text` property.
       * Use the `context` property to provide argument
       * that can be passed to the generator function.
       */
      generator: {
        type: Object
      },
      /**
       * The delay in milliseconds before the tooltip
       * is closed on losing hover, when not in manual mode.
       * On blur, the tooltip is closed immediately.
       * @attr {number} hide-delay
       */
      hideDelay: {
        type: Number
      },
      /**
       * The delay in milliseconds before the tooltip
       * is opened on hover, when not in manual mode.
       * @attr {number} hover-delay
       */
      hoverDelay: {
        type: Number
      },
      /**
       * When true, the tooltip is controlled programmatically
       * instead of reacting to focus and mouse events.
       */
      manual: {
        type: Boolean,
        value: false,
        sync: true
      },
      /**
       * When true, the tooltip is opened.
       * In manual mode, this can be set programmatically.
       * In automatic mode, this is set automatically by internal logic.
       */
      opened: {
        type: Boolean,
        value: false,
        reflectToAttribute: true,
        observer: "__openedChanged",
        sync: true
      },
      /**
       * Function used to detect whether to show the tooltip based on a condition,
       * called every time the tooltip is about to be shown on hover and focus.
       * The function takes two parameters: `target` and `context`, which contain
       * values of the corresponding tooltip properties at the time of calling.
       * The tooltip is only shown when the function invocation returns `true`.
       */
      shouldShow: {
        type: Object,
        value: () => {
          return (_target, _context) => true;
        }
      },
      /**
       * String used as a tooltip content.
       */
      text: {
        type: String
      },
      /**
       * Element used to link with the `aria-describedby`
       * attribute. When not set, defaults to `target`.
       * @protected
       */
      _effectiveAriaTarget: {
        type: Object,
        computed: "__computeAriaTarget(ariaTarget, target)",
        observer: "__effectiveAriaTargetChanged"
      },
      /** @private */
      __isTargetHidden: {
        type: Boolean,
        value: false
      },
      /** @private */
      _isConnected: {
        type: Boolean,
        sync: true
      }
    };
  }
  /**
   * Sets the default focus delay to be used by all tooltip instances,
   * except for those that have focus delay configured using property.
   *
   * @param {number} focusDelay
   */
  static setDefaultFocusDelay(focusDelay) {
    defaultFocusDelay$2 = focusDelay != null && focusDelay >= 0 ? focusDelay : DEFAULT_DELAY;
  }
  /**
   * Sets the default hide delay to be used by all tooltip instances,
   * except for those that have hide delay configured using property.
   *
   * @param {number} hideDelay
   */
  static setDefaultHideDelay(hideDelay) {
    defaultHideDelay$2 = hideDelay != null && hideDelay >= 0 ? hideDelay : DEFAULT_DELAY;
  }
  /**
   * Sets the default hover delay to be used by all tooltip instances,
   * except for those that have hover delay configured using property.
   *
   * @param {number} hoverDelay
   */
  static setDefaultHoverDelay(hoverDelay) {
    defaultHoverDelay$2 = hoverDelay != null && hoverDelay >= 0 ? hoverDelay : DEFAULT_DELAY;
  }
  constructor() {
    super();
    this._uniqueId = `vaadin-tooltip-${generateUniqueId()}`;
    this.__onFocusin = this.__onFocusin.bind(this);
    this.__onFocusout = this.__onFocusout.bind(this);
    this.__onMouseDown = this.__onMouseDown.bind(this);
    this.__onMouseEnter = this.__onMouseEnter.bind(this);
    this.__onMouseLeave = this.__onMouseLeave.bind(this);
    this.__onKeyDown = this.__onKeyDown.bind(this);
    this.__onOverlayOpen = this.__onOverlayOpen.bind(this);
    this.__targetVisibilityObserver = new IntersectionObserver(
      (entries2) => {
        entries2.forEach((entry) => this.__onTargetVisibilityChange(entry.isIntersecting));
      },
      { threshold: 0 }
    );
    this._stateController = new TooltipStateController(this);
  }
  /** @protected */
  connectedCallback() {
    super.connectedCallback();
    this._isConnected = true;
    document.body.addEventListener("vaadin-overlay-open", this.__onOverlayOpen);
  }
  /** @protected */
  disconnectedCallback() {
    super.disconnectedCallback();
    if (this.opened && !this.manual) {
      this._stateController.close(true);
    }
    this._isConnected = false;
    document.body.removeEventListener("vaadin-overlay-open", this.__onOverlayOpen);
  }
  /** @protected */
  ready() {
    super.ready();
    this._overlayElement = this.$.overlay;
    this.__contentController = new SlotController(this, "overlay", "div", {
      initializer: (element) => {
        element.id = this._uniqueId;
        element.setAttribute("role", "tooltip");
        this.__contentNode = element;
      }
    });
    this.addController(this.__contentController);
  }
  /** @protected */
  updated(props) {
    super.updated(props);
    if (props.has("text") || props.has("generator") || props.has("context")) {
      this.__updateContent();
      this.$.overlay.toggleAttribute("hidden", this.__contentNode.textContent.trim() === "");
    }
  }
  /** @private */
  __openedChanged(opened, oldOpened) {
    if (opened) {
      document.addEventListener("keydown", this.__onKeyDown, true);
    } else if (oldOpened) {
      document.removeEventListener("keydown", this.__onKeyDown, true);
    }
  }
  /**
   * @param {HTMLElement} target
   * @protected
   * @override
   */
  _addTargetListeners(target) {
    target.addEventListener("mouseenter", this.__onMouseEnter);
    target.addEventListener("mouseleave", this.__onMouseLeave);
    target.addEventListener("focusin", this.__onFocusin);
    target.addEventListener("focusout", this.__onFocusout);
    target.addEventListener("mousedown", this.__onMouseDown);
    requestAnimationFrame(() => {
      this.__targetVisibilityObserver.observe(target);
    });
  }
  /**
   * @param {HTMLElement} target
   * @protected
   * @override
   */
  _removeTargetListeners(target) {
    target.removeEventListener("mouseenter", this.__onMouseEnter);
    target.removeEventListener("mouseleave", this.__onMouseLeave);
    target.removeEventListener("focusin", this.__onFocusin);
    target.removeEventListener("focusout", this.__onFocusout);
    target.removeEventListener("mousedown", this.__onMouseDown);
    this.__targetVisibilityObserver.unobserve(target);
  }
  /** @private */
  __onFocusin(event) {
    if (this.manual) {
      return;
    }
    if (!isKeyboardActive()) {
      return;
    }
    if (this.target.contains(event.relatedTarget)) {
      return;
    }
    if (!this.__isShouldShow()) {
      return;
    }
    this.__focusInside = true;
    if (!this.__isTargetHidden && (!this.__hoverInside || !this.opened)) {
      this._stateController.open({ focus: true });
    }
  }
  /** @private */
  __onFocusout(event) {
    if (this.manual) {
      return;
    }
    if (this.target.contains(event.relatedTarget)) {
      return;
    }
    this.__focusInside = false;
    if (!this.__hoverInside) {
      this._stateController.close(true);
    }
  }
  /** @private */
  __onKeyDown(event) {
    if (this.manual) {
      return;
    }
    if (event.key === "Escape") {
      event.stopPropagation();
      this._stateController.close(true);
    }
  }
  /** @private */
  __onMouseDown() {
    if (this.manual) {
      return;
    }
    this._stateController.close(true);
  }
  /** @private */
  __onMouseEnter() {
    if (this.manual) {
      return;
    }
    if (!this.__isShouldShow()) {
      return;
    }
    if (this.__hoverInside) {
      return;
    }
    this.__hoverInside = true;
    if (!this.__isTargetHidden && (!this.__focusInside || !this.opened)) {
      this._stateController.open({ hover: true });
    }
  }
  /** @private */
  __onMouseLeave(event) {
    if (event.relatedTarget !== this._overlayElement) {
      this.__handleMouseLeave();
    }
  }
  /** @protected */
  __onOverlayMouseEnter() {
    if (this.manual) {
      return;
    }
    if (this._stateController.isClosing) {
      this._stateController.open({ immediate: true });
    }
  }
  /** @protected */
  __onOverlayMouseLeave(event) {
    if (event.relatedTarget !== this.target) {
      this.__handleMouseLeave();
    }
  }
  /** @private */
  __handleMouseLeave() {
    if (this.manual) {
      return;
    }
    this.__hoverInside = false;
    if (!this.__focusInside) {
      this._stateController.close();
    }
  }
  /** @private */
  __onOverlayOpen() {
    if (this.manual) {
      return;
    }
    if (this._overlayElement.opened && !this._overlayElement._last) {
      this._stateController.close(true);
    }
  }
  /** @private */
  __onTargetVisibilityChange(isVisible) {
    if (this.manual) {
      return;
    }
    const oldHidden = this.__isTargetHidden;
    this.__isTargetHidden = !isVisible;
    if (oldHidden && isVisible && (this.__focusInside || this.__hoverInside)) {
      this._stateController.open({ immediate: true });
      return;
    }
    if (!isVisible && this.opened) {
      this._stateController.close(true);
    }
  }
  /** @private */
  __isShouldShow() {
    if (typeof this.shouldShow === "function" && this.shouldShow(this.target, this.context) !== true) {
      return false;
    }
    return true;
  }
  /** @private */
  __updateContent() {
    this.__contentNode.textContent = typeof this.generator === "function" ? this.generator(this.context) : this.text;
  }
  /** @private */
  __computeAriaTarget(ariaTarget, target) {
    const isElementNode = (el) => el && el.nodeType === Node.ELEMENT_NODE;
    const isAriaTargetSet = Array.isArray(ariaTarget) ? ariaTarget.some(isElementNode) : ariaTarget;
    return ariaTarget === null || isAriaTargetSet ? ariaTarget : target;
  }
  /** @private */
  __effectiveAriaTargetChanged(ariaTarget, oldAriaTarget) {
    if (oldAriaTarget) {
      [oldAriaTarget].flat().forEach((target) => {
        removeValueFromAttribute(target, "aria-describedby", this._uniqueId);
      });
    }
    if (ariaTarget) {
      [ariaTarget].flat().forEach((target) => {
        addValueToAttribute(target, "aria-describedby", this._uniqueId);
      });
    }
  }
};
/**
 * @license
 * Copyright (c) 2022 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
let Tooltip$1 = class Tooltip2 extends TooltipMixin(ThemePropertyMixin(ElementMixin(PolylitMixin(LitElement)))) {
  static get is() {
    return "vaadin-tooltip";
  }
  static get styles() {
    return css$e`
      :host {
        display: contents;
      }
    `;
  }
  /** @protected */
  render() {
    const effectivePosition = this.__effectivePosition;
    return html$3`
      <vaadin-tooltip-overlay
        id="overlay"
        .owner="${this}"
        theme="${ifDefined(this._theme)}"
        .opened="${this._isConnected && this.opened}"
        .positionTarget="${this.target}"
        .position="${effectivePosition}"
        ?no-horizontal-overlap="${this.__computeNoHorizontalOverlap(effectivePosition)}"
        ?no-vertical-overlap="${this.__computeNoVerticalOverlap(effectivePosition)}"
        .horizontalAlign="${this.__computeHorizontalAlign(effectivePosition)}"
        .verticalAlign="${this.__computeVerticalAlign(effectivePosition)}"
        @mouseenter="${this.__onOverlayMouseEnter}"
        @mouseleave="${this.__onOverlayMouseLeave}"
        modeless
        exportparts="overlay, content"
        ><slot name="overlay"></slot
      ></vaadin-tooltip-overlay>
    `;
  }
};
defineCustomElement(Tooltip$1);
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const avatarStyles = css$e`
  :host {
    display: inline-block;
    flex: none;
    border-radius: 50%;
    cursor: default;
    color: var(--vaadin-avatar-color, var(--vaadin-color-subtle));
    line-height: 0;
    overflow: hidden;
    height: var(--vaadin-avatar-size, 32px);
    width: var(--vaadin-avatar-size, 32px);
    border: var(--vaadin-focus-ring-width) solid transparent;
    margin: calc(var(--vaadin-focus-ring-width) * -1);
    background: var(--vaadin-avatar-background, var(--vaadin-background-container-strong));
    background-clip: content-box;
    vertical-align: middle;
    -webkit-user-select: none;
    user-select: none;
    -webkit-tap-highlight-color: transparent;
    position: relative;
  }

  :host([role='button']) {
    cursor: var(--vaadin-clickable-cursor);
  }

  img {
    height: 100%;
    width: 100%;
    object-fit: cover;
  }

  [part='icon'] {
    height: 100%;
    mask: var(--_vaadin-icon-user) no-repeat center / 74%;
    background: currentColor;
  }

  [part='abbr'] {
    font-size: 2.75em;
    fill: currentColor;
  }

  :host([hidden]),
  [hidden] {
    display: none !important;
  }

  :host([has-color-index]) {
    background-color: var(--vaadin-avatar-user-color);
    color: oklch(from var(--vaadin-avatar-user-color) clamp(0, (0.62 - l) * 1000, 1) 0 0);
  }

  :host([has-color-index])::before {
    position: absolute;
    content: '';
    inset: 0;
    border-radius: inherit;
    border: 2px solid var(--vaadin-avatar-user-color);
  }

  :host([focus-ring]) {
    outline: var(--vaadin-focus-ring-width) solid var(--vaadin-focus-ring-color);
    outline-offset: calc((var(--vaadin-focus-ring-width)) * -1);
  }
`;
/**
 * @license
 * Copyright (c) 2017 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const DEFAULT_I18N$8 = {
  anonymous: "anonymous"
};
const AvatarMixin = (superClass) => class AvatarMixinClass extends I18nMixin(DEFAULT_I18N$8, FocusMixin(superClass)) {
  static get properties() {
    return {
      /**
       * The path to the image
       */
      img: {
        type: String,
        reflectToAttribute: true,
        observer: "__imgChanged"
      },
      /**
       * A shortened form of name that is displayed
       * in the avatar when `img` is not provided.
       */
      abbr: {
        type: String,
        reflectToAttribute: true
      },
      /**
       * Full name of the user
       * used for the tooltip of the avatar.
       */
      name: {
        type: String,
        reflectToAttribute: true
      },
      /**
       * Color index used for avatar background.
       * @attr {number} color-index
       */
      colorIndex: {
        type: Number,
        observer: "__colorIndexChanged"
      },
      /**
       * When true, the avatar has tooltip shown on hover and focus.
       * The tooltip text is based on the `name` and `abbr` properties.
       * When neither is provided, `i18n.anonymous` is used instead.
       * @attr {boolean} with-tooltip
       */
      withTooltip: {
        type: Boolean,
        value: false,
        observer: "__withTooltipChanged"
      },
      /** @protected */
      __imgVisible: Boolean,
      /** @protected */
      __iconVisible: Boolean,
      /** @protected */
      __abbrVisible: Boolean,
      /** @private */
      __tooltipNode: Object
    };
  }
  static get observers() {
    return [
      "__imgOrAbbrOrNameChanged(img, abbr, name)",
      "__i18nChanged(__effectiveI18n)",
      "__tooltipChanged(__tooltipNode, name, abbr)"
    ];
  }
  /**
   * The object used to localize this component. To change the default
   * localization, replace this with an object that provides all properties, or
   * just the individual properties you want to change.
   *
   * The object has the following JSON structure and default values:
   * ```
   * {
   *   // Translation of the anonymous user avatar tooltip.
   *   anonymous: 'anonymous'
   * }
   * ```
   * @return {!AvatarI18n}
   */
  get i18n() {
    return super.i18n;
  }
  set i18n(value) {
    super.i18n = value;
  }
  /** @protected */
  ready() {
    super.ready();
    this.__updateVisibility();
    if (!this.hasAttribute("role")) {
      this.setAttribute("role", "img");
    }
    if (!this.hasAttribute("tabindex")) {
      this.setAttribute("tabindex", "0");
    }
    if (!this.name && !this.abbr) {
      this.__setTooltip();
    }
  }
  /** @private */
  __colorIndexChanged(index) {
    if (index != null) {
      const prop = `--vaadin-user-color-${index}`;
      const isValid2 = Boolean(getComputedStyle(document.documentElement).getPropertyValue(prop));
      if (isValid2) {
        this.setAttribute("has-color-index", "");
        this.style.setProperty("--vaadin-avatar-user-color", `var(${prop})`);
      } else {
        this.removeAttribute("has-color-index");
        console.warn(`The CSS property --vaadin-user-color-${index} is not defined`);
      }
    } else {
      this.removeAttribute("has-color-index");
    }
  }
  /** @private */
  __imgChanged() {
    this.__imgFailedToLoad = false;
  }
  /** @private */
  __imgOrAbbrOrNameChanged(_img, abbr, name) {
    this.__updateVisibility();
    if (abbr && abbr !== this.__generatedAbbr) {
      return;
    }
    if (name) {
      this.abbr = this.__generatedAbbr = name.split(" ").map((word) => word.charAt(0)).join("");
    } else {
      this.abbr = void 0;
    }
  }
  /** @private */
  __tooltipChanged(tooltipNode, name, abbr) {
    if (tooltipNode) {
      if (abbr && abbr !== this.__generatedAbbr) {
        this.__setTooltip(name ? `${name} (${abbr})` : abbr);
      } else {
        this.__setTooltip(name);
      }
    }
    if (abbr) {
      this.setAttribute("aria-label", !tooltipNode && name ? `${name} (${abbr})` : abbr);
    } else {
      this.removeAttribute("aria-label");
    }
  }
  /** @private */
  __withTooltipChanged(withTooltip, oldWithTooltip) {
    if (withTooltip) {
      const tooltipNode = document.createElement("vaadin-tooltip");
      tooltipNode.setAttribute("slot", "tooltip");
      this.appendChild(tooltipNode);
      this.__tooltipNode = tooltipNode;
    } else if (oldWithTooltip) {
      this.__tooltipNode.target = null;
      this.__tooltipNode.remove();
      this.__tooltipNode = null;
    }
  }
  /** @private */
  __i18nChanged(effectiveI18n) {
    if (effectiveI18n && effectiveI18n.anonymous) {
      if (this.__oldAnonymous && this.__tooltipNode && this.__tooltipNode.text === this.__oldAnonymous) {
        this.__setTooltip();
      }
      this.__oldAnonymous = effectiveI18n.anonymous;
    }
  }
  /** @private */
  __updateVisibility() {
    this.__imgVisible = !!this.img && !this.__imgFailedToLoad;
    this.__abbrVisible = !this.__imgVisible && !!this.abbr;
    this.__iconVisible = !this.__imgVisible && !this.abbr;
  }
  /** @private */
  __setTooltip(tooltip) {
    const tooltipNode = this.__tooltipNode;
    if (tooltipNode) {
      tooltipNode.text = tooltip || this.__effectiveI18n.anonymous;
    }
  }
  /** @protected */
  __onImageLoadError() {
    if (this.img) {
      console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`);
      this.__imgFailedToLoad = true;
      this.__updateVisibility();
    }
  }
};
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class Avatar extends AvatarMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar";
  }
  static get styles() {
    return avatarStyles;
  }
  static get lumoInjector() {
    return {
      includeBaseStyles: true
    };
  }
  /** @protected */
  render() {
    return html$3`
      <img
        ?hidden="${!this.__imgVisible}"
        src="${ifDefined(this.img)}"
        aria-hidden="true"
        @error="${this.__onImageLoadError}"
        draggable="false"
      />
      <div part="icon" ?hidden="${!this.__iconVisible}" aria-hidden="true"></div>
      <svg
        part="abbr"
        ?hidden="${!this.__abbrVisible}"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">${this.abbr}</text>
      </svg>

      <slot name="tooltip"></slot>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this._tooltipController = new TooltipController(this);
    this.addController(this._tooltipController);
  }
}
defineCustomElement(Avatar);
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const avatarGroupMenuStyles = css$e`
  :host {
    display: block;
    padding: var(--vaadin-item-overlay-padding, 4px);
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='items'] {
    display: contents;
  }
`;
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar-group-menu";
  }
  static get styles() {
    return avatarGroupMenuStyles;
  }
  static get properties() {
    return {
      // We don't need to define this property since super default is vertical,
      // but we don't want it to be modified, or be shown in the API docs.
      /** @private */
      orientation: {
        readOnly: true
      }
    };
  }
  /**
   * @return {!HTMLElement}
   * @protected
   * @override
   */
  get _scrollerElement() {
    return this.shadowRoot.querySelector('[part="items"]');
  }
  /** @protected */
  render() {
    return html$3`
      <div part="items">
        <slot></slot>
      </div>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("role", "menu");
  }
}
defineCustomElement(AvatarGroupMenu);
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const menuItemStyles = css$e`
  [part='content'] {
    display: flex;
    align-items: center;
    gap: inherit;
  }
`;
const avatarGroupMenuItemStyles = [itemStyles, menuItemStyles];
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar-group-menu-item";
  }
  static get styles() {
    return avatarGroupMenuItemStyles;
  }
  /** @protected */
  render() {
    return html$3`
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `;
  }
  /** @protected */
  ready() {
    super.ready();
    this.setAttribute("role", "menuitem");
  }
}
defineCustomElement(AvatarGroupMenuItem);
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroupOverlay extends PositionMixin(
  OverlayMixin(DirMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))))
) {
  static get is() {
    return "vaadin-avatar-group-overlay";
  }
  static get styles() {
    return overlayStyles$1;
  }
  /** @protected */
  render() {
    return html$3`
      <div part="overlay" id="overlay">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `;
  }
}
defineCustomElement(AvatarGroupOverlay);
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const avatarGroupStyles = css$e`
  :host {
    display: block;
    width: 100%; /* prevent collapsing inside non-stretching column flex */
    /* 1: last on top */
    /* -1: first on top */
    --_dir: 1;
  }

  :host([theme~='reverse']) {
    --_dir: -1;
  }

  :host([hidden]) {
    display: none !important;
  }

  [part='container'] {
    display: flex;
    position: relative;
    width: 100%;
    flex-wrap: nowrap;
  }

  ::slotted(vaadin-avatar) {
    mask-image: url('data:image/svg+xml;utf8,<svg viewBox="0 0 300 300" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z" fill="black"/></svg>');
    mask-size: calc(300% + var(--vaadin-avatar-group-gap, 2px) * 6 - var(--vaadin-focus-ring-width) * 6);
    mask-position: calc(
      50% +
        (
          var(--vaadin-avatar-size, 32px) - var(--vaadin-avatar-group-overlap, 8px) +
            var(--vaadin-avatar-group-gap, 2px)
        ) *
        var(--_d)
    );
    --_d: var(--_dir);
  }

  :host(:dir(rtl)) ::slotted(vaadin-avatar) {
    --_d: calc(var(--_dir) * -1);
  }

  ::slotted(vaadin-avatar:not(:first-of-type)) {
    margin-inline-start: calc(
      var(--vaadin-avatar-group-overlap, 8px) * -1 - var(--vaadin-focus-ring-width) +
        var(--vaadin-avatar-group-gap, 2px)
    );
  }

  :host(:not([theme~='reverse'])) ::slotted(vaadin-avatar:last-child),
  :host(:not([theme~='reverse']):not([has-overflow])) ::slotted(vaadin-avatar:nth-last-child(2)),
  :host([theme~='reverse']) ::slotted(vaadin-avatar:first-of-type) {
    mask-image: none;
  }
`;
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const MINIMUM_DISPLAYED_AVATARS = 2;
const DEFAULT_I18N$7 = {
  anonymous: "anonymous",
  activeUsers: {
    one: "Currently one active user",
    many: "Currently {count} active users"
  },
  joined: "{user} joined",
  left: "{user} left"
};
const AvatarGroupMixin = (superClass) => class AvatarGroupMixinClass extends I18nMixin(DEFAULT_I18N$7, ResizeMixin(superClass)) {
  static get properties() {
    return {
      /**
       * An array containing the items which will be stamped as avatars.
       *
       * The items objects allow to configure [`name`](#/elements/vaadin-avatar#property-name),
       * [`abbr`](#/elements/vaadin-avatar#property-abbr), [`img`](#/elements/vaadin-avatar#property-img)
       * and [`colorIndex`](#/elements/vaadin-avatar#property-colorIndex) properties on the
       * stamped avatars, and set `className` to provide CSS class names.
       *
       * #### Example
       *
       * ```js
       * group.items = [
       *   {
       *     name: 'User name',
       *     img: 'url-to-image.png',
       *     className: 'even'
       *   },
       *   {
       *     abbr: 'JD',
       *     colorIndex: 1,
       *     className: 'odd'
       *   },
       * ];
       * ```
       *
       * @type {!Array<!AvatarGroupItem> | undefined}
       */
      items: {
        type: Array,
        sync: true
      },
      /**
       * The maximum number of avatars to display. By default, all the avatars are displayed.
       * When _maxItemsVisible_ is set, the overflowing avatars are grouped into one avatar with
       * a dropdown. Setting 0 or 1 has no effect so there are always at least two avatars visible.
       * @attr {number} max-items-visible
       */
      maxItemsVisible: {
        type: Number,
        sync: true
      },
      /** @private */
      __itemsInView: {
        type: Number,
        value: null,
        sync: true
      },
      /** @private */
      _overflowItems: {
        type: Array
      },
      /** @private */
      _overflowLimit: {
        type: Number
      },
      /** @private */
      _opened: {
        type: Boolean,
        sync: true
      }
    };
  }
  /**
   * The object used to localize this component. To change the default
   * localization, replace this with an object that provides all properties, or
   * just the individual properties you want to change.
   *
   * The object has the following JSON structure and default values:
   * ```
   * {
   *   // Translation of the anonymous user avatar tooltip.
   *   anonymous: 'anonymous',
   *   // Translation of the avatar group accessible label.
   *   // {count} is replaced with the actual count of users.
   *   activeUsers: {
   *     one: 'Currently one active user',
   *     many: 'Currently {count} active users'
   *   },
   *   // Screen reader announcement when user joins group.
   *   // {user} is replaced with the name or abbreviation.
   *   // When neither is set, "anonymous" is used instead.
   *   joined: '{user} joined',
   *   // Screen reader announcement when user leaves group.
   *   // {user} is replaced with the name or abbreviation.
   *   // When neither is set, "anonymous" is used instead.
   *   left: '{user} left'
   * }
   * ```
   * @return {!AvatarGroupI18n}
   */
  get i18n() {
    return super.i18n;
  }
  set i18n(value) {
    super.i18n = value;
  }
  /** @protected */
  get _avatars() {
    return [...this.children].filter((node) => node.localName === "vaadin-avatar");
  }
  /** @protected */
  ready() {
    super.ready();
    this._menuController = new SlotController(this, "overlay", "vaadin-avatar-group-menu", {
      initializer: (menu) => {
        menu.addEventListener("keydown", this._onListKeyDown.bind(this));
        this._menuElement = menu;
      }
    });
    this._overflowController = new SlotController(this, "overflow", "vaadin-avatar", {
      initializer: (overflow) => {
        overflow.setAttribute("role", "button");
        overflow.setAttribute("aria-haspopup", "menu");
        overflow.setAttribute("aria-expanded", "false");
        overflow.addEventListener("click", (e) => this._onOverflowClick(e));
        overflow.addEventListener("keydown", (e) => this._onOverflowKeyDown(e));
        const tooltip = document.createElement("vaadin-tooltip");
        tooltip.setAttribute("slot", "tooltip");
        overflow.appendChild(tooltip);
        this._overflow = overflow;
        this._overflowTooltip = tooltip;
      }
    });
    this.addController(this._menuController);
    this.addController(this._overflowController);
    this._overlayElement = this.$.overlay;
  }
  /** @protected */
  disconnectedCallback() {
    super.disconnectedCallback();
    this._opened = false;
  }
  /** @protected */
  willUpdate(props) {
    super.willUpdate(props);
    if (props.has("items") || props.has("__itemsInView") || props.has("maxItemsVisible")) {
      const count = Array.isArray(this.items) ? this.items.length : 0;
      const limit = this.__getLimit(count, this.__itemsInView, this.maxItemsVisible);
      this._overflowLimit = limit;
      this._overflowItems = limit ? this.items.slice(limit) : [];
    }
  }
  /** @protected */
  updated(props) {
    super.updated(props);
    if (props.has("items")) {
      this.__itemsChanged(this.items, props.get("items"));
    }
    if (props.has("items") || props.has("_overflowLimit") || props.has("__effectiveI18n") || props.has("_theme")) {
      const limit = this._overflowLimit;
      this.__renderAvatars(limit ? this.items.slice(0, limit) : this.items || []);
    }
    if (props.has("items") || props.has("_overflowLimit")) {
      this.__updateOverflowTooltip(this.items, this._overflowLimit);
      this.__updateOverflowAvatar(this.items, this._overflowLimit, this.__itemsInView);
    }
    if (props.has("__effectiveI18n") || props.has("items")) {
      this.__i18nItemsChanged(this.__effectiveI18n, this.items);
    }
    if (props.has("_opened")) {
      this.__openedChanged(this._opened, props.get("_opened"));
    }
    if (props.has("_theme")) {
      if (this._theme) {
        this._overflow.setAttribute("theme", this._theme);
      } else {
        this._overflow.removeAttribute("theme");
      }
    }
    if (props.has("_overflowItems") || props.has("__effectiveI18n") || props.has("_theme")) {
      this.__renderMenu();
    }
  }
  /** @private */
  __getMessage(user, action) {
    return action.replace("{user}", user.name || user.abbr || this.__effectiveI18n.anonymous);
  }
  /**
   * Renders items when they are provided by the `items` property and clears the content otherwise.
   * @private
   */
  __renderMenu() {
    render$1(
      html$3`
          ${(this._overflowItems || []).map(
        (item) => html$3`
              <vaadin-avatar-group-menu-item>
                <vaadin-avatar
                  .name="${item.name}"
                  .abbr="${item.abbr}"
                  .img="${item.img}"
                  .colorIndex="${item.colorIndex}"
                  .i18n="${this.__effectiveI18n}"
                  class="${ifDefined(item.className)}"
                  theme="${ifDefined(this._theme)}"
                  aria-hidden="true"
                  tabindex="-1"
                ></vaadin-avatar>
                ${item.name || ""}
              </vaadin-avatar-group-menu-item>
            `
      )}
        `,
      this._menuElement,
      { host: this }
    );
  }
  /** @private */
  _onOverflowClick(e) {
    e.stopPropagation();
    if (this._opened) {
      this.$.overlay.close();
    } else if (!e.defaultPrevented) {
      this._opened = true;
    }
  }
  /** @private */
  _onOverflowKeyDown(e) {
    if (!this._opened) {
      if (/^(Enter|SpaceBar|\s)$/u.test(e.key)) {
        e.preventDefault();
        this._opened = true;
      }
    }
  }
  /** @private */
  _onListKeyDown(event) {
    if (event.key === "Escape" || event.key === "Tab") {
      this._opened = false;
    }
  }
  /**
   * @protected
   * @override
   */
  _onResize() {
    this.__setItemsInView();
  }
  /** @private */
  _onVaadinOverlayClose(e) {
    if (e.detail.sourceEvent && e.detail.sourceEvent.composedPath().includes(this)) {
      e.preventDefault();
    }
  }
  /** @private */
  _onVaadinOverlayOpen() {
    if (this._menuElement) {
      this._menuElement.focus();
    }
  }
  /** @private */
  __renderAvatars(items) {
    render$1(
      html$3`
          ${items.map(
        (item) => html$3`
              <vaadin-avatar
                .name="${item.name}"
                .abbr="${item.abbr}"
                .img="${item.img}"
                .colorIndex="${item.colorIndex}"
                .i18n="${this.__effectiveI18n}"
                theme="${ifDefined(this._theme)}"
                class="${ifDefined(item.className)}"
                with-tooltip
              ></vaadin-avatar>
            `
      )}
        `,
      this,
      { renderBefore: this._overflow }
    );
  }
  /** @private */
  __updateOverflowAvatar(items, limit, itemsInView) {
    const overflow = this._overflow;
    if (overflow) {
      const count = Array.isArray(items) ? items.length : 0;
      const maxReached = this.maxItemsVisible != null && count > this.__getMax(this.maxItemsVisible);
      overflow.abbr = `+${count - limit}`;
      const hasOverflow = maxReached || itemsInView && itemsInView < count;
      overflow.toggleAttribute("hidden", !hasOverflow);
      this.toggleAttribute("has-overflow", hasOverflow);
    }
  }
  /** @private */
  __updateOverflowTooltip(items, limit) {
    if (!Array.isArray(items)) {
      return;
    }
    if (limit == null) {
      return;
    }
    const result2 = [];
    for (let i2 = limit; i2 < items.length; i2++) {
      const item = items[i2];
      if (item) {
        result2.push(item.name || item.abbr || "anonymous");
      }
    }
    this._overflowTooltip.text = result2.join("\n");
  }
  /** @private */
  __getLimit(items, itemsInView, maxItemsVisible) {
    let limit = null;
    const adjustedMax = this.__getMax(maxItemsVisible);
    if (maxItemsVisible != null && adjustedMax < items) {
      limit = adjustedMax - 1;
    } else if (itemsInView && itemsInView < items) {
      limit = itemsInView;
    }
    return Math.min(limit, this.__calculateAvatarsFitWidth());
  }
  /** @private */
  __getMax(maxItemsVisible) {
    return Math.max(maxItemsVisible, MINIMUM_DISPLAYED_AVATARS);
  }
  /** @private */
  __itemsChanged(items, oldItems) {
    this.__setItemsInView();
    let added = [];
    let removed = [];
    const hasNewItems = Array.isArray(items);
    const hasOldItems = Array.isArray(oldItems);
    if (hasOldItems) {
      removed = oldItems.filter((item) => hasNewItems && !items.includes(item));
    }
    if (hasNewItems) {
      added = items.filter((item) => hasOldItems && !oldItems.includes(item));
    }
    this.__announceItemsChange(added, removed);
  }
  /** @private */
  __announceItemsChange(added, removed) {
    let addedMsg = [];
    let removedMsg = [];
    if (added) {
      addedMsg = added.map((user) => this.__getMessage(user, this.__effectiveI18n.joined || "{user} joined"));
    }
    if (removed) {
      removedMsg = removed.map((user) => this.__getMessage(user, this.__effectiveI18n.left || "{user} left"));
    }
    const messages = removedMsg.concat(addedMsg);
    if (messages.length > 0) {
      announce(messages.join(", "));
    }
  }
  /** @private */
  __i18nItemsChanged(effectiveI18n, items) {
    if (effectiveI18n && effectiveI18n.activeUsers) {
      const count = Array.isArray(items) ? items.length : 0;
      const field2 = count === 1 ? "one" : "many";
      if (effectiveI18n.activeUsers[field2]) {
        this.setAttribute("aria-label", effectiveI18n.activeUsers[field2].replace("{count}", count || 0));
      }
    }
  }
  /** @private */
  __openedChanged(opened, oldOpened) {
    if (opened) {
      this._openedWithFocusRing = this._overflow.hasAttribute("focus-ring");
    } else if (oldOpened) {
      this._overflow.focus();
      if (this._openedWithFocusRing) {
        this._overflow.setAttribute("focus-ring", "");
      }
    }
    this._overflow.setAttribute("aria-expanded", opened === true);
  }
  /** @private */
  __setItemsInView() {
    const avatars = this._avatars;
    const items = this.items;
    if (!items || !avatars || avatars.length < 3) {
      return;
    }
    let result2 = this.__calculateAvatarsFitWidth();
    if (result2 === items.length - 1) {
      result2 = items.length;
    }
    if (result2 >= items.length && this._opened) {
      this.$.overlay.close();
      this.$.overlay._flushAnimation("closing");
    }
    this.__itemsInView = result2;
  }
  /** @private */
  __calculateAvatarsFitWidth() {
    if (!this.shadowRoot || this._avatars.length < MINIMUM_DISPLAYED_AVATARS) {
      return MINIMUM_DISPLAYED_AVATARS;
    }
    const avatars = this._avatars;
    const avatarWidth = avatars[0].clientWidth;
    const { marginLeft, marginRight } = getComputedStyle(avatars[1]);
    const offset2 = this.__isRTL ? parseInt(marginRight, 0) - parseInt(marginLeft, 0) : parseInt(marginLeft, 0) - parseInt(marginRight, 0);
    return Math.floor((this.$.container.offsetWidth - avatarWidth) / (avatarWidth + offset2));
  }
};
/**
 * @license
 * Copyright (c) 2020 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class AvatarGroup extends AvatarGroupMixin(ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement))))) {
  static get is() {
    return "vaadin-avatar-group";
  }
  static get styles() {
    return avatarGroupStyles;
  }
  /** @protected */
  render() {
    return html$3`
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        .owner="${this}"
        .opened="${this._opened}"
        .positionTarget="${this._overflow}"
        no-vertical-overlap
        exportparts="overlay, content"
        @vaadin-overlay-close="${this._onVaadinOverlayClose}"
        @vaadin-overlay-open="${this._onVaadinOverlayOpen}"
        @opened-changed="${this._onOpenedChanged}"
      >
        <slot name="overlay"></slot>
      </vaadin-avatar-group-overlay>
    `;
  }
  /** @private */
  _onOpenedChanged(event) {
    this._opened = event.detail.value;
  }
}
defineCustomElement(AvatarGroup);
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
const CLASSES = {
  SMALL: "small",
  MEDIUM: "medium",
  LARGE: "large"
};
const BoardRowMixin = (superClass) => class BoardRowMixinClass extends ResizeMixin(superClass) {
  constructor() {
    super();
    this._oldWidth = 0;
    this._oldBreakpoints = { smallSize: 600, mediumSize: 960 };
    this._oldFlexBasis = [];
  }
  /** @protected */
  ready() {
    super.ready();
    this.$.insertionPoint.addEventListener("slotchange", () => this.redraw());
  }
  /** @protected */
  connectedCallback() {
    super.connectedCallback();
    this._onResize();
  }
  /**
   * Adds styles for board row based on width.
   * @private
   */
  _addStyleNames(width, breakpoints) {
    if (width < breakpoints.smallSize) {
      this.classList.add(CLASSES.SMALL);
      this.classList.remove(CLASSES.MEDIUM);
      this.classList.remove(CLASSES.LARGE);
    } else if (width < breakpoints.mediumSize) {
      this.classList.remove(CLASSES.SMALL);
      this.classList.add(CLASSES.MEDIUM);
      this.classList.remove(CLASSES.LARGE);
    } else {
      this.classList.remove(CLASSES.SMALL);
      this.classList.remove(CLASSES.MEDIUM);
      this.classList.add(CLASSES.LARGE);
    }
  }
  /**
   * Calculates flex basis based on colSpan, width and breakpoints.
   * @param {number} colSpan colspan value of the row
   * @param {number} width width of the row in px
   * @param {number} colsInRow number of columns in the row
   * @param {object} breakpoints object with smallSize and mediumSize number properties, which tells
   * where the row should switch rendering size in pixels.
   * @private
   */
  _calculateFlexBasis(colSpan, width, colsInRow, breakpoints) {
    if (width < breakpoints.smallSize) {
      colsInRow = 1;
    } else if (width < breakpoints.mediumSize && colsInRow === 4) {
      colsInRow = 2;
    }
    let flexBasis = colSpan / colsInRow * 100;
    flexBasis = flexBasis > 100 ? 100 : flexBasis;
    return `${flexBasis}%`;
  }
  /** @private */
  _reportError() {
    const errorMessage = "The column configuration is not valid; column count should add up to 3 or 4.";
    console.warn(errorMessage, `check: \r
${this.outerHTML}`);
  }
  /**
   * Parses board-cols from DOM.
   * If there is not enough space in the row drop board cols.
   * @param {!Array<!Node>} nodes array of nodes
   * @return {!Array<number>} array of boardCols
   * @private
   */
  _parseBoardCols(nodes) {
    const boardCols = nodes.map((node) => {
      if (node.getAttribute("board-cols")) {
        return parseInt(node.getAttribute("board-cols"));
      }
      return 1;
    });
    let spaceLeft = 4;
    let returnBoardCols = [];
    nodes.forEach((_node, i2) => {
      spaceLeft -= boardCols[i2];
    });
    if (spaceLeft < 0) {
      this._reportError();
      boardCols.forEach((_node, i2) => {
        returnBoardCols[i2] = 1;
      });
    } else {
      returnBoardCols = boardCols.slice(0);
    }
    return returnBoardCols;
  }
  /**
   * If there is not enough space in the row.
   * Extra items are dropped from DOM.
   * @param {!Array<number>} boardCols array of board-cols for every node
   * @param {!Array<!Node>} nodes array of nodes
   * @return {!Array<!Node>} filtered array of nodes
   * @private
   */
  _removeExtraNodesFromDOM(boardCols, nodes) {
    let isErrorReported = false;
    let spaceLeft = 4;
    const returnNodes = [];
    nodes.forEach((node, i2) => {
      spaceLeft -= boardCols[i2];
      if (spaceLeft < 0) {
        if (!isErrorReported) {
          isErrorReported = true;
          this._reportError();
        }
        this.removeChild(node);
      } else {
        returnNodes[i2] = node;
      }
    });
    return returnNodes;
  }
  /**
   * Redraws the row, if necessary.
   *
   * In most cases, a board row will redraw itself if your reconfigure it.
   * If you dynamically change breakpoints
   * --vaadin-board-width-small or --vaadin-board-width-medium,
   * then you need to call this method.
   */
  redraw() {
    this._recalculateFlexBasis(true);
  }
  /**
   * @protected
   * @override
   */
  _onResize() {
    this._recalculateFlexBasis(false);
  }
  /** @private */
  _recalculateFlexBasis(forceResize) {
    const width = this.getBoundingClientRect().width;
    const breakpoints = this._measureBreakpointsInPx();
    if (forceResize || this._shouldRecalculate(width, breakpoints)) {
      const nodes = this.$.insertionPoint.assignedNodes({ flatten: true });
      const filteredNodes = nodes.filter((node) => node.nodeType === Node.ELEMENT_NODE);
      this._addStyleNames(width, breakpoints);
      const boardCols = this._parseBoardCols(filteredNodes);
      const colsInRow = boardCols.reduce((a, b) => a + b, 0);
      this._removeExtraNodesFromDOM(boardCols, filteredNodes).forEach((e, i2) => {
        const newFlexBasis = this._calculateFlexBasis(boardCols[i2], width, colsInRow, breakpoints);
        if (forceResize || !this._oldFlexBasis[i2] || this._oldFlexBasis[i2] !== newFlexBasis) {
          this._oldFlexBasis[i2] = newFlexBasis;
          e.style.flexBasis = newFlexBasis;
        }
      });
      this._oldWidth = width;
      this._oldBreakpoints = breakpoints;
    }
  }
  /** @private */
  _shouldRecalculate(width, breakpoints) {
    if (isElementHidden(this)) {
      return false;
    }
    return width !== this._oldWidth || breakpoints.smallSize !== this._oldBreakpoints.smallSize || breakpoints.mediumSize !== this._oldBreakpoints.mediumSize;
  }
  /**
   * Measure the breakpoints in pixels.
   *
   * The breakpoints for `small` and `medium` can be given in any unit: `px`, `em`, `in` etc.
   * We need to know them in `px` so that they are comparable with the actual size.
   *
   * @return {object} object with smallSize and mediumSize number properties, which tells
   * where the row should switch rendering size in pixels.
   * @private
   */
  _measureBreakpointsInPx() {
    const breakpoints = {};
    const tmpStyleProp = "background-position";
    const smallSize = getComputedStyle(this).getPropertyValue("--small-size");
    const mediumSize = getComputedStyle(this).getPropertyValue("--medium-size");
    this.style.setProperty(tmpStyleProp, smallSize);
    breakpoints.smallSize = parseFloat(getComputedStyle(this).getPropertyValue(tmpStyleProp));
    this.style.setProperty(tmpStyleProp, mediumSize);
    breakpoints.mediumSize = parseFloat(getComputedStyle(this).getPropertyValue(tmpStyleProp));
    this.style.removeProperty(tmpStyleProp);
    return breakpoints;
  }
};
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
class BoardRow extends BoardRowMixin(ElementMixin(PolylitMixin(LitElement))) {
  static get is() {
    return "vaadin-board-row";
  }
  static get styles() {
    return css$e`
      :host {
        display: flex;
        flex-flow: row wrap;
        align-items: stretch;
        --small-size: var(--vaadin-board-width-small, 600px);
        --medium-size: var(--vaadin-board-width-medium, 960px);
      }

      :host([hidden]) {
        display: none !important;
      }

      :host ::slotted(*) {
        box-sizing: border-box;
        flex-grow: 1;
        overflow: hidden;
      }
    `;
  }
  /** @protected */
  render() {
    return html$3`<slot id="insertionPoint"></slot>`;
  }
}
defineCustomElement(BoardRow);
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const issuedWarnings = /* @__PURE__ */ new Set();
function issueWarning(warning) {
  if (issuedWarnings.has(warning)) {
    return;
  }
  issuedWarnings.add(warning);
  console.warn(warning);
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
class Board extends ElementMixin(PolylitMixin(LitElement)) {
  static get is() {
    return "vaadin-board";
  }
  static get cvdlName() {
    return "vaadin-board";
  }
  static get styles() {
    return css$e`
      :host {
        display: block;
      }

      :host([hidden]) {
        display: none !important;
      }
    `;
  }
  /** @protected */
  firstUpdated() {
    super.firstUpdated();
    issueWarning(
      "`<vaadin-board>` is deprecated and will be removed in Vaadin 26. Consider using `<vaadin-dashboard>` or `<vaadin-dashboard-layout>` as an alternative."
    );
  }
  /** @protected */
  render() {
    return html$3`<slot></slot>`;
  }
  /**
   * Redraws the board and all rows inside it, if necessary.
   *
   * In most cases, board will redraw itself if your reconfigure it. If you dynamically change
   * breakpoints `--vaadin-board-width-small` or `--vaadin-board-width-medium`,
   * then you need to call this method.
   */
  redraw() {
    [...this.querySelectorAll("*")].filter((node) => node instanceof BoardRow).forEach((row) => row.redraw());
  }
}
defineCustomElement(Board);
/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
const cardStyles = css$e`
  :host {
    --_content: 0;
    --_footer: 0;
    --_gap: var(--vaadin-card-gap, var(--vaadin-gap-m));
    --_header: max(var(--_header-prefix), var(--_title), var(--_subtitle), var(--_header-suffix));
    --_header-prefix: 0;
    --_header-suffix: 0;
    --_media: 0;
    --_padding: var(--vaadin-card-padding, var(--vaadin-padding-m));
    --_subtitle: 0;
    --_title: 0;
    background: var(--vaadin-card-background, var(--vaadin-background-container));
    border-radius: var(--vaadin-card-border-radius, var(--vaadin-radius-m));
    box-shadow: var(--vaadin-card-shadow, none);
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    gap: var(--_gap);
    padding: var(--_padding);
    position: relative;
  }

  /* Could be an inset outline on the host as well, but let's reserve that for a potential focus outline */
  :host::before {
    border: var(--vaadin-card-border-width, 0) solid var(--vaadin-card-border-color, var(--vaadin-border-color-subtle));
    border-radius: inherit;
    content: '';
    inset: 0;
    pointer-events: none;
    position: absolute;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host(:not([theme~='horizontal'])) {
    justify-content: space-between;
  }

  :host([_m]) {
    --_media: 1;
  }

  :host([_t]) {
    --_title: 1;
  }

  :host([_st]) {
    --_subtitle: 1;
  }

  :host([_h]) {
    --_header: 1;
    --_title: 0;
    --_subtitle: 0;
  }

  :host([_hp]) {
    --_header-prefix: 1;
  }

  :host([_hs]) {
    --_header-suffix: 1;
  }

  :host([_c]) {
    --_content: 1;
  }

  :host([_f]) {
    --_footer: 1;
  }

  [part='media'],
  [part='header'],
  [part='content'],
  [part='footer'] {
    display: none;
  }

  :host([_m]) [part='media'] {
    display: block;
  }

  :host(:is([_h], [_t], [_st], [_hp], [_hs])) [part='header'] {
    align-items: center;
    display: grid;
    gap: var(--_gap);
    row-gap: 0;
  }

  :host([_hs]) [part='header'] {
    grid-template-columns: 1fr auto;
  }

  :host([_hp]) [part='header'] {
    grid-template-columns: repeat(var(--_header-prefix), auto) 1fr;
  }

  :host([_c]) [part='content'] {
    display: block;
  }

  :host([_f]) [part='footer'] {
    display: flex;
    flex-wrap: wrap;
    gap: var(--_gap);
  }

  slot {
    border-radius: inherit;
  }

  ::slotted([slot='header-prefix']) {
    grid-column: 1;
    grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
  }

  ::slotted([slot='header']),
  ::slotted([slot='title']) {
    grid-column: calc(1 + var(--_header-prefix));
    grid-row: 1;
  }

  ::slotted([slot='title']) {
    color: var(--vaadin-card-title-color, var(--vaadin-color)) !important;
    font-size: var(--vaadin-card-title-font-size, inherit) !important;
    font-weight: var(--vaadin-card-title-font-weight, 500) !important;
    line-height: var(--vaadin-card-title-line-height, inherit) !important;
    margin: 0 !important;
  }

  ::slotted([slot='subtitle']) {
    color: var(--vaadin-card-subtitle-color, var(--vaadin-color-subtle)) !important;
    font-size: var(--vaadin-card-subtitle-font-size, inherit) !important;
    font-weight: var(--vaadin-card-subtitle-font-weight, 400) !important;
    line-height: var(--vaadin-card-subtitle-line-height, inherit) !important;
    margin: 0 !important;
    grid-column: calc(1 + var(--_header-prefix));
    grid-row: calc(1 + var(--_title));
  }

  ::slotted([slot='header-suffix']) {
    grid-column: calc(2 + var(--_header-prefix));
    grid-row: 1 / span calc(var(--_title) + var(--_subtitle));
  }

  /* Horizontal */
  :host([theme~='horizontal']) {
    align-items: start;
    display: grid;
    grid-template-columns: repeat(var(--_media), minmax(auto, max-content)) 1fr;
  }

  :host([theme~='horizontal'][_f]) {
    grid-template-rows: 1fr auto;
  }

  :host([theme~='horizontal'][_c]) {
    grid-template-rows: repeat(var(--_header), auto) 1fr;
  }

  [part='media'] {
    align-self: stretch;
    border-radius: inherit;
    grid-column: 1;
    grid-row: 1 / span calc(var(--_header) + var(--_content) + var(--_footer));
  }

  [part='header'] {
    margin-bottom: auto;
    grid-column: calc(1 + var(--_media));
    grid-row: 1;
  }

  [part='content'] {
    grid-column: calc(1 + var(--_media));
    grid-row: calc(1 + var(--_header));
    flex: auto;
    min-height: 0;
  }

  [part='footer'] {
    border-radius: inherit;
    grid-column: calc(1 + var(--_media));
    grid-row: calc(1 + var(--_header) + var(--_content));
  }

  :host([theme~='horizontal']) [part='footer'] {
    align-self: end;
  }

  :host(:not([theme~='horizontal'])) ::slotted([slot='media']:is(img, video, svg)) {
    max-width: 100%;
  }

  ::slotted([slot='media']) {
    vertical-align: middle;
  }

  :host(:is([theme~='cover-media'], [theme~='stretch-media']))
    ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    aspect-ratio: var(--vaadin-card-media-aspect-ratio, 16/9);
    height: auto;
    object-fit: cover;
    /* Fixes an issue where an icon overflows the card boundaries on Firefox: https://github.com/vaadin/web-components/issues/8641 */
    overflow: hidden;
    width: 100%;
  }

  :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media'])) {
    grid-template-columns: repeat(var(--_media), minmax(auto, 0.5fr)) 1fr;
  }

  :host([theme~='horizontal']:is([theme~='cover-media'], [theme~='stretch-media']))
    ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    aspect-ratio: auto;
    height: 100%;
  }

  :host([theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: inherit;
    border-end-end-radius: 0;
    border-end-start-radius: 0;
    margin-inline: calc(var(--_padding) * -1);
    margin-top: calc(var(--_padding) * -1);
    max-width: none;
    width: calc(100% + var(--_padding) * 2);
  }

  :host([theme~='horizontal'][theme~='cover-media']) ::slotted([slot='media']:is(img, video, svg, vaadin-icon)) {
    border-radius: inherit;
    border-end-end-radius: 0;
    border-start-end-radius: 0;
    height: calc(100% + var(--_padding) * 2);
    margin-inline-end: 0;
    width: calc(100% + var(--_padding));
  }

  /* Scroller in content */
  [part='content'] ::slotted(vaadin-scroller) {
    margin-inline: calc(var(--_padding) * -1);
    padding-inline: var(--_padding);
  }

  [part='content'] ::slotted(vaadin-scroller)::before,
  [part='content'] ::slotted(vaadin-scroller)::after {
    margin-inline: calc(var(--_padding) * -1);
  }

  /* Outlined */
  :host([theme~='outlined']) {
    --vaadin-card-border-width: 1px;
  }

  /* Elevated */
  :host([theme~='elevated']) {
    --vaadin-card-background: var(--vaadin-background-color);
    box-shadow: var(--vaadin-card-shadow, 0 1px 4px -1px rgba(0, 0, 0, 0.3));
  }
`;
/**
 * @license
 * Copyright (c) 2024 - 2025 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */
class Card extends ElementMixin(ThemableMixin(PolylitMixin(LumoInjectionMixin(LitElement)))) {
  static get is() {
    return "vaadin-card";
  }
  static get styles() {
    return cardStyles;
  }
  static get lumoInjector() {
    return {
      includeBaseStyles: true
    };
  }
  static get properties() {
    return {
      /**
       * The title of the card. When set, any custom slotted title is removed and this string-based title is used instead. If this title is used, an `aria-labelledby` attribute that points to the generated title element is set.
       *
       * @attr {string} card-title
       */
      cardTitle: {
        type: String,
        observer: "__cardTitleChanged"
      },
      /**
       * Sets the heading level (`aria-level`) for the string-based title. If not set, the level defaults to 2. Setting values outside the range [1, 6] can cause accessibility issues.
       *
       * @attr {number} title-heading-level
       */
      titleHeadingLevel: {
        type: Number,
        reflectToAttribute: true,
        observer: "__titleHeadingLevelChanged"
      }
    };
  }
  /** @protected */
  ready() {
    super.ready();
    if (!this.hasAttribute("role")) {
      this.setAttribute("role", "region");
    }
  }
  /** @protected */
  render() {
    return html$3`
      <div part="media">
        <slot name="media"></slot>
      </div>
      <div part="header">
        <slot name="header-prefix"></slot>
        <slot name="header">
          <slot name="title"></slot>
          <slot name="subtitle"></slot>
        </slot>
        <slot name="header-suffix"></slot>
      </div>
      <div part="content">
        <slot></slot>
      </div>
      <div part="footer">
        <slot name="footer"></slot>
      </div>
    `;
  }
  /** @private */
  _onSlotChange() {
    this.toggleAttribute("_m", this.querySelector(':scope > [slot="media"]'));
    this.toggleAttribute("_h", this.querySelector(':scope > [slot="header"]'));
    this.toggleAttribute(
      "_t",
      this.querySelector(':scope > [slot="title"]') && !this.querySelector(':scope > [slot="header"]')
    );
    this.toggleAttribute(
      "_st",
      this.querySelector(':scope > [slot="subtitle"]') && !this.querySelector(':scope > [slot="header"]')
    );
    this.toggleAttribute("_hp", this.querySelector(':scope > [slot="header-prefix"]'));
    this.toggleAttribute("_hs", this.querySelector(':scope > [slot="header-suffix"]'));
    this.toggleAttribute("_c", this.querySelector(":scope > :not([slot])"));
    this.toggleAttribute("_f", this.querySelector(':scope > [slot="footer"]'));
    if (this.__getCustomTitleElement()) {
      this.__clearStringTitle();
    }
  }
  /** @private */
  __clearStringTitle() {
    const stringTitleElement = this.__getStringTitleElement();
    if (stringTitleElement) {
      this.removeChild(stringTitleElement);
    }
    const ariaLabelledby = this.getAttribute("aria-labelledby");
    if (ariaLabelledby && ariaLabelledby.startsWith("card-title-")) {
      this.removeAttribute("aria-labelledby");
    }
    if (this.cardTitle) {
      this.cardTitle = "";
    }
  }
  /** @private */
  __getCustomTitleElement() {
    return Array.from(this.querySelectorAll('[slot="title"]')).find((el) => {
      return !el.hasAttribute("card-string-title");
    });
  }
  /** @private */
  __cardTitleChanged(title) {
    if (!title) {
      this.__clearStringTitle();
      return;
    }
    const customTitleElement = this.__getCustomTitleElement();
    if (customTitleElement) {
      this.removeChild(customTitleElement);
    }
    let stringTitleElement = this.__getStringTitleElement();
    if (!stringTitleElement) {
      stringTitleElement = this.__createStringTitleElement();
      this.appendChild(stringTitleElement);
      this.setAttribute("aria-labelledby", stringTitleElement.id);
    }
    stringTitleElement.textContent = title;
  }
  /** @private */
  __createStringTitleElement() {
    const stringTitleElement = document.createElement("div");
    stringTitleElement.setAttribute("slot", "title");
    stringTitleElement.setAttribute("role", "heading");
    this.__setTitleHeadingLevel(stringTitleElement, this.titleHeadingLevel);
    stringTitleElement.setAttribute("card-string-title", "");
    stringTitleElement.id = `card-title-${generateUniqueId()}`;
    return stringTitleElement;
  }
  /** @private */
  __titleHeadingLevelChanged(titleHeadingLevel) {
    const stringTitleElement = this.__getStringTitleElement();
    if (stringTitleElement) {
      this.__setTitleHeadingLevel(stringTitleElement, titleHeadingLevel);
    }
  }
  /** @private */
  __setTitleHeadingLevel(stringTitleElement, titleHeadingLevel) {
    stringTitleElement.setAttribute("aria-level", titleHeadingLevel || 2);
  }
  /** @private */
  __getStringTitleElement() {
    return this.querySelector('[slot="title"][card-string-title]');
  }
  /**
   * @protected
   * @override
   */
  createRenderRoot() {
    const root = super.createRenderRoot();
    root.addEventListener("slotchange", () => this._onSlotChange());
    return root;
  }
}
defineCustomElement(Card);
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
function inflateFunctions(config) {
  if (Array.isArray(config)) {
    config.forEach(inflateFunctions);
    return;
  }
  if (
    // Check if param is a primitive/null/undefined value
    !(config instanceof Object) || // Check if param is a plain object (not a HC object)
    config.constructor !== Object
  ) {
    return;
  }
  Object.entries(config).forEach(([attr, targetProperty]) => {
    if (attr.startsWith("_fn_") && (typeof targetProperty === "string" || targetProperty instanceof String)) {
      try {
        config[attr.substr(4)] = eval(`(${targetProperty})`);
      } catch (_) {
        config[attr.substr(4)] = eval(`(function(){${targetProperty}})`);
      }
      delete config[attr];
    } else if (targetProperty instanceof Object) {
      inflateFunctions(targetProperty);
    }
  });
}
function deepMerge(target, source) {
  const isObject2 = (item) => item && typeof item === "object" && !Array.isArray(item);
  if (isObject2(source) && isObject2(target)) {
    Object.keys(source).forEach((key2) => {
      if (isObject2(source[key2])) {
        if (!target[key2]) {
          Object.assign(target, { [key2]: {} });
        }
        deepMerge(target[key2], source[key2]);
      } else {
        Object.assign(target, { [key2]: source[key2] });
      }
    });
  }
  return target;
}
function prepareExport(chart) {
  if (!chart.tempBodyStyle) {
    let effectiveCss = "";
    if (chart.shadowRoot.adoptedStyleSheets) {
      chart.shadowRoot.adoptedStyleSheets.forEach((sheet) => {
        effectiveCss += `${[...sheet.cssRules].map((rule) => rule.cssText).join("\n")}
`;
      });
    }
    effectiveCss = effectiveCss.replace(/:host\(.+?\)/gu, (match2) => {
      const selector = match2.substr(6, match2.length - 7);
      return chart.matches(selector) ? "" : match2;
    });
    effectiveCss = `${effectiveCss}body {    -moz-transform: scale(0.9, 0.9);    zoom: 0.9;    zoom: 90%;}`;
    chart.tempBodyStyle = document.createElement("style");
    chart.tempBodyStyle.textContent = effectiveCss;
    document.body.appendChild(chart.tempBodyStyle);
    if (chart.options.chart.styledMode) {
      document.body.setAttribute("styled-mode", "");
    }
  }
}
function cleanupExport(chart) {
  if (chart.tempBodyStyle) {
    document.body.removeChild(chart.tempBodyStyle);
    delete chart.tempBodyStyle;
    if (chart.options.chart.styledMode) {
      document.body.removeAttribute("styled-mode");
    }
  }
}
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
const ChartSeriesMixin = (superClass) => class extends superClass {
  static get properties() {
    return {
      /**
       * An array of data used by the series.
       * Format depends on the chart type and can be:
       *   - An array of numerical values `[y0, y1, y2, y3,...]`
       *   - An array of arrays with 2 values (`x`, `y`) `[ [x0, y0], [x1, y1], [x2, y2], ... ]`
       *   - An array of objects, each one describing one point `[ {x: x0, y: y0, name: 'Point0', color: '#FF0000'}, {...}, ...]`
       *
       *  See more in [API Site](https://api.highcharts.com/highcharts/series)
       *
       * @type {ChartSeriesValues}
       */
      values: {
        type: Array,
        value: () => [],
        sync: true
      },
      /**
       * Value-axis minimum-value.
       * Sets the value to a series bound by 'unit' property.
       * Otherwise sets the value to the first series.
       * Undefined by default (determined from data).
       * @attr {number} value-min
       */
      valueMin: {
        type: Number,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Value-axis maximum-value.
       * See the 'valueMin'
       * @attr {number} value-max
       */
      valueMax: {
        type: Number,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * A string with the type of the series.
       * Defaults to `'line'` in case no type is set for the chart.
       * Note that `'bar'`, `'gauge'` and `'solidgauge'` should be set as default series type on `<vaadin-chart>`.
       */
      type: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * The name of the series as shown in the legend, tooltip etc.
       * @type {string}
       */
      title: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Shows/hides data-point markers for line-like series.
       * Acceptable input are:
       *  - `shown`: markers are always visible
       *  - `hidden`: markers are always hidden
       *  - `auto`: markers are visible for widespread data and hidden, when data is dense *(default)*
       * @type {ChartSeriesMarkers | undefined}
       */
      markers: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Used to connect the series to an axis; if multiple series have the same `unit`, they will share axis.
       * Displayed as a title for the axis.
       * If no unit is defined, then series will be connected to the first axis.
       */
      unit: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Used to group series in a different stacks.
       * "stacking" property should be specified either for each series or in plotOptions.
       * It is recommended to place series in a single stack, when they belong to the same yAxis.
       * @type {number | string}
       */
      stack: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * The height of the neck, the lower part of the funnel.
       * A number defines pixel width, a percentage string defines a percentage of the plot area height. Defaults to 30%.
       * Note that this property only applies for "funnel" charts.
       * @attr {number | string} neck-position
       * @type {number | string}
       */
      neckPosition: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * The width of the neck, the lower part of the funnel.
       * A number defines pixel width, a percentage string defines a percentage of the plot area width. Defaults to 30%.
       * Note that this property only applies for "funnel" charts.
       * @attr {number | string} neck-width
       * @type {number | string}
       */
      neckWidth: {
        type: String,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * Object with the configured options defined and used to create a series.
       * @type {!ChartSeriesOptions}
       * @readonly
       */
      options: {
        type: Object,
        sync: true
      },
      /**
       * Represents additional JSON configuration.
       * @type {SeriesOptionsType | undefined}
       */
      additionalOptions: {
        type: Object,
        reflectToAttribute: true,
        sync: true
      },
      /**
       * @type {!Series | undefined}
       * @protected
       */
      _series: {
        type: Object,
        sync: true
      }
    };
  }
  static get observers() {
    return [
      "__additionalOptionsObserver(additionalOptions, _series)",
      "__markersObserver(markers, _series)",
      "__neckPositionObserver(neckPosition, _series)",
      "__neckWidthObserver(neckWidth, _series)",
      "__stackObserver(stack, _series)",
      "__titleObserver(title, _series)",
      "__typeObserver(type, _series)",
      "__unitObserver(unit, valueMin, valueMax, _series)",
      "__valueMinObserver(valueMin, _series)",
      "__valueMaxObserver(valueMax, _series)",
      "__valuesObserver(values, _series)"
    ];
  }
  get options() {
    const options = deepMerge({}, this.additionalOptions);
    if (this.type) {
      options.type = this.type;
    }
    if (this.title) {
      options.name = this.title;
    }
    if (this.values) {
      options.data = this.values;
    }
    if (this.markers) {
      if (!this.__isMarkersValid()) {
        this.markers = "auto";
      }
      options.marker = this.__markersConfiguration;
    }
    if (this.unit) {
      options.yAxis = this.unit;
    }
    if (this.stack) {
      options.stack = this.stack;
    }
    if (isFinite(this.valueMin)) {
      options.yAxisValueMin = this.valueMin;
    }
    if (isFinite(this.valueMax)) {
      options.yAxisValueMax = this.valueMax;
    }
    if (this.neckWidth) {
      options.neckWidth = this.neckWidth;
    }
    if (this.neckPosition) {
      options.neckHeight = this.neckPosition;
    }
    return options;
  }
  /** @private */
  get __markersConfiguration() {
    const config2 = {};
    switch (this.markers) {
      case "shown":
        config2.enabled = true;
        break;
      case "hidden":
        config2.enabled = false;
        break;
      case "auto":
      default:
        config2.enabled = null;
        break;
    }
    return config2;
  }
  /**
   * Method to attach a series object of type `Highcharts.Series`.
   * @param {!Series} series Object of type `Highcharts.Series`
   */
  setSeries(series) {
    this._series = series;
  }
  /** @private */
  __valuesObserver(values2, series) {
    if (series) {
      series.setData(values2);
    }
  }
  /** @private */
  __additionalOptionsObserver(additionalOptions, series) {
    if (series && additionalOptions) {
      series.update(additionalOptions);
    }
  }
  /** @private */
  __updateAxis(series, value, key2) {
    if (!isFinite(value)) {
      this.__showWarn(`value-${key2}`, "Numbers or null");
      return;
    }
    if (series && series.yAxis) {
      series.yAxis.update({ [key2]: value });
    }
  }
  /** @private */
  __valueMinObserver(valueMin, series) {
    if (valueMin === void 0 || series == null) {
      return;
    }
    this.__updateAxis(series, valueMin, "min");
  }
  /** @private */
  __valueMaxObserver(valueMax, series) {
    if (valueMax === void 0 || series == null) {
      return;
    }
    this.__updateAxis(series, valueMax, "max");
  }
  /** @private */
  __typeObserver(type, series) {
    if (type && series) {
      series.update({ type });
    }
  }
  /** @private */
  __titleObserver(title, series) {
    if (title === void 0 || series == null) {
      return;
    }
    series.update({ name: title });
  }
  /** @private */
  __stackObserver(stack, series) {
    if (stack === void 0 || series == null) {
      return;
    }
    series.update({ stack });
  }
  /** @private */
  __neckPositionObserver(neckPosition, series) {
    if (neckPosition === void 0 || series == null) {
      return;
    }
    series.update({ neckHeight: neckPosition });
  }
  /** @private */
  __neckWidthObserver(neckWidth, series) {
    if (neckWidth === void 0 || series == null) {
      return;
    }
    series.update({ neckWidth });
  }
  /** @private */
  __unitObserver(unit, valueMin, valueMax, series) {
    if (series && unit !== this.__oldUnit) {
      const Chart2 = customElements.get("vaadin-chart");
      this.__oldUnit = unit;
      const parent = this.parentNode instanceof Chart2 && this.parentNode;
      if (parent && parent instanceof Chart2) {
        if (unit && !parent.__getAxis(unit)) {
          const title = { title: { text: unit } };
          parent.__addAxis({ id: unit, axisGenerated: true, ...title });
        }
        series.update({ yAxis: unit || 0 });
        if (valueMin !== void 0) {
          this.__updateAxis(series, valueMin, "min");
        }
        if (valueMax !== void 0) {
          this.__updateAxis(series, valueMax, "max");
        }
        parent.__removeAxisIfEmpty();
      }
    }
  }
  /** @private */
  __isMarkersValid() {
    if (["shown", "hidden", "auto"].indexOf(this.markers) === -1) {
      this.__showWarn("markers", '"shown", "hidden" or "auto"');
      return false;
    }
    return true;
  }
  /** @private */
  __markersObserver(markers, series) {
    if (markers === void 0 || series == null) {
      return;
    }
    if (!this.__isMarkersValid()) {
      this.markers = "auto";
      return;
    }
    series.update({
      marker: this.__markersConfiguration
    });
  }
  /** @private */
  __showWarn(propertyName, acceptedValues) {
    console.warn(`<vaadin-chart-series> Acceptable values for "${propertyName}" are ${acceptedValues}`);
  }
};
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
class ChartSeries extends ChartSeriesMixin(PolylitMixin(LitElement)) {
  static get is() {
    return "vaadin-chart-series";
  }
}
defineCustomElement(ChartSeries);
/**
 * @license
 * Copyright (c) 2000 - 2025 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */
const tooltipStyles = (scope) => css$e`
  ${unsafeCSS(scope)} .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
    filter: drop-shadow(var(--vaadin-charts-tooltip-shadow, 0 4px 8px rgba(0, 0, 0, 0.2))) !important;
  }

  ${unsafeCSS(scope)} .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, var(--vaadin-color));
  }

  ${unsafeCSS(scope)} .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-color-subtle);
  }

  ${unsafeCSS(scope)} .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, var(--vaadin-border-color-subtle));
    fill: var(--vaadin-charts-tooltip-background, var(--vaadin-background-color));
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  ${unsafeCSS(scope)} .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, var(--vaadin-background-color));
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
    stroke: var(--vaadin-charts-tooltip-border, var(--vaadin-border-color-subtle));
  }

  ${unsafeCSS(scope)} .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 20%, transparent);
  }

  ${unsafeCSS(scope)} div.highcharts-tooltip {
    filter: none;
  }
`;
addGlobalThemeStyles(
  "vaadin-charts-tooltip",
  css$e`
    .highcharts-tooltip-container .highcharts-root {
      overflow: visible;
      font-size: var(--vaadin-charts-font-size, 0.75rem);
      line-height: normal;
    }
  `,
  tooltipStyles(".highcharts-tooltip-container")
);
const chartStyles = css$e`
  :host {
    display: block;
    width: 100%;
    overflow: hidden;
  }

  :host,
  :root {
    font-size: var(--vaadin-charts-font-size, 0.75rem);
    line-height: normal;

    /* Needs to be a color, not a background image */
    --_bg: var(--vaadin-charts-background, var(--vaadin-background-color));

    --_color-0: var(--vaadin-charts-color-0, var(--vaadin-user-color-0));
    --_color-1: var(--vaadin-charts-color-1, var(--vaadin-user-color-1));
    --_color-2: var(--vaadin-charts-color-2, var(--vaadin-user-color-2));
    --_color-3: var(--vaadin-charts-color-3, var(--vaadin-user-color-3));
    --_color-4: var(--vaadin-charts-color-4, var(--vaadin-user-color-4));
    --_color-5: var(--vaadin-charts-color-5, var(--vaadin-user-color-5));
    --_color-6: var(--vaadin-charts-color-6, var(--vaadin-user-color-6));
    --_color-7: var(--vaadin-charts-color-7, var(--vaadin-user-color-7));
    --_color-8: var(--vaadin-charts-color-8, var(--vaadin-user-color-8));
    --_color-9: var(--vaadin-charts-color-9, var(--vaadin-user-color-9));

    --_color-0-label: oklch(from var(--_color-0) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-1-label: oklch(from var(--_color-1) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-2-label: oklch(from var(--_color-2) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-3-label: oklch(from var(--_color-3) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-4-label: oklch(from var(--_color-4) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-5-label: oklch(from var(--_color-5) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-6-label: oklch(from var(--_color-6) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-7-label: oklch(from var(--_color-7) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-8-label: oklch(from var(--_color-8) clamp(0, (0.62 - l) * 1000, 1) 0 0);
    --_color-9-label: oklch(from var(--_color-9) clamp(0, (0.62 - l) * 1000, 1) 0 0);

    --_color-positive: light-dark(#19b156, #1ccc62);
    --_color-negative: light-dark(#dc0611, #f7353f);

    --_label: var(--vaadin-charts-label, var(--vaadin-color));
    --_secondary-label: var(--vaadin-charts-secondary-label, var(--vaadin-color-subtle));
    --_disabled-label: var(--vaadin-charts-disabled-label, var(--vaadin-color-disabled));
    --_point-border: var(--vaadin-charts-point-border, var(--_bg));
    --_axis-line: var(--vaadin-charts-axis-line, var(--vaadin-border-color-subtle));
    --_axis-title: var(--vaadin-charts-axis-title, var(--_secondary-label));
    --_axis-label: var(--vaadin-charts-axis-label, var(--_secondary-label));
    --_grid-line: var(--vaadin-charts-grid-line, var(--vaadin-border-color-subtle));
    --_minor-grid-line: var(
      --vaadin-charts-minor-grid-line,
      color-mix(in srgb, var(--vaadin-border-color-subtle) 60%, transparent)
    );
    --_data-label: var(--vaadin-charts-data-label, var(--_label));
  }

  /* Safari 17 doesn't support relative colors from light-dark() */
  @supports not (color: oklch(from light-dark(red, red) l c h)) {
    :host {
      /* Safari 17 wants degrees instead of raw numbers */
      --_hue-scale: 180deg;
    }
  }

  :host([hidden]) {
    display: none !important;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
    rx: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    ry: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, var(--_label));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--_secondary-label);
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--_axis-line);
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--_axis-title);
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--_axis-label);
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--_minor-grid-line);
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--_color-0);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--_disabled-label);
    font-size: 0.7em;
    transition:
      fill 250ms,
      font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  ${unsafeCSS(tooltipStyles(":where([styled-mode])"))};

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--_color-0);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: var(--vaadin-chart-graph-stroke-width, 2);
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: calc(var(--vaadin-chart-graph-stroke-width, 2) + 1);
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--_color-0);
    stroke: var(--_color-0);
    color: var(--_color-0-label);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--_color-1);
    stroke: var(--_color-1);
    color: var(--_color-1-label);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--_color-2);
    stroke: var(--_color-2);
    color: var(--_color-2-label);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--_color-3);
    stroke: var(--_color-3);
    color: var(--_color-2-label);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--_color-4);
    stroke: var(--_color-4);
    color: var(--_color-4-label);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--_color-5);
    stroke: var(--_color-5);
    color: var(--_color-5-label);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--_color-6);
    stroke: var(--_color-6);
    color: var(--_color-6-label);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--_color-7);
    stroke: var(--_color-7);
    color: var(--_color-7-label);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--_color-8);
    stroke: var(--_color-8);
    color: var(--_color-8-label);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--_color-9);
    stroke: var(--_color-9);
    color: var(--_color-9-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-0 {
    color: var(--_color-0-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-1 {
    color: var(--_color-1-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-2 {
    color: var(--_color-2-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-3 {
    color: var(--_color-3-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-4 {
    color: var(--_color-4-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-5 {
    color: var(--_color-5-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-6 {
    color: var(--_color-6-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-7 {
    color: var(--_color-7-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-8 {
    color: var(--_color-8-label);
  }

  :where([styled-mode]) .highcharts-data-label-color-9 {
    color: var(--_color-9-label);
  }

  :where([styled-mode]) [class*='highcharts-data-label-color-'] {
    fill: currentColor;
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--_bg);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--_data-label);
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    /* TODO where are these used? */
    fill: var(--_grid-line);
    stroke: var(--vaadin-charts-contrast, var(--_label));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--_point-border);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--_point-border);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--_point-border);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--_point-border);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--_point-border);
    transition:
      stroke 250ms,
      fill 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0;
    stroke: var(--_point-border);
    fill-opacity: 0.75;
    transition:
      stroke 25ms,
      fill 25ms,
      fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-treemap-series [class*='highcharts-data-label-color-'] text {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    /* TODO where is this used? */
    stroke: var(--vaadin-charts-contrast, var(--_label));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--_data-label);
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, var(--_label));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--_disabled-label) !important;
    stroke: var(--_disabled-label) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, var(--_label));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--_disabled-label);
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--_data-label);
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--_bg);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition:
      opacity 250ms,
      height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, var(--_label));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    /* TODO where is this used? */
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--_data-label);
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, var(--_label));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--_grid-line);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, var(--_label));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition:
      fill 250ms,
      fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition:
      fill 50ms,
      fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--_point-border);
    transition:
      stroke 250ms,
      fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--_point-border);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--_color-0);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--_grid-line);
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--_grid-line);
    fill: var(--_bg);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--_color-1);
    stroke: var(--_color-1);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--_grid-line);
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--_secondary-label);
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 20%, transparent);
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--_data-label);
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--_data-label);
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 5%, transparent);
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, var(--vaadin-background-container));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, var(--_label));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, var(--vaadin-background-container));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, var(--_label));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, var(--_label));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, var(--_bg));
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-disabled-label, var(--vaadin-color-disabled));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > :is(text, .highcharts-label) {
    fill: var(--_secondary-label);
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--_secondary-label);
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-range-input-background, var(--vaadin-background-container));
    rx: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    ry: var(--vaadin-charts-button-border-radius, var(--vaadin-radius-m));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-range-input-background-hover, var(--vaadin-background-container));
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--_data-label);
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--_bg);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-candlestick-line, var(--vaadin-border-color));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--_color-positive);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--_color-negative);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--_grid-line);
    fill: var(--_bg);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
    fill: var(--_bg);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--_data-label);
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, var(--_label));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition:
      fill 500ms,
      fill-opacity 500ms,
      stroke-width 250ms;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 20%, transparent);
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition:
      fill 0ms,
      fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--_bg);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--_axis-label);
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: transparent;
    stroke: var(--vaadin-border-color-subtle);
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--_secondary-label);
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, var(--_label));
    cursor: pointer;
    transition:
      background 250ms,
      color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, var(--_label));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--_secondary-label);
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: color-mix(in srgb, var(--vaadin-charts-contrast, var(--_label)) 60%, transparent);
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, var(--_label));
    fill: var(--vaadin-charts-contrast, var(--_label));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--_disabled-label);
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-organization-series .highcharts-link {
    stroke: var(--vaadin-charts-org-line, color-mix(in srgb, var(--_label) 50%, var(--_bg)));
    stroke-width: var(--vaadin-charts-org-line-width, 1);
  }

  /* Workaround for https://github.com/highcharts/highcharts/issues/22490 */
  :where([styled-mode]) .highcharts-gantt-series .highcharts-partfill-overlay {
    fill: hsla(0, 0%, 0%, 0.3);
    stroke: hsla(0, 0%, 0%, 0.3);
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0;
  }
`;
var w = typeof win !== "undefined" ? win : typeof window !== "undefined" ? window : {};
var Globals;
(function(Globals2) {
  Globals2.SVG_NS = "http://www.w3.org/2000/svg", Globals2.product = "Highcharts", Globals2.version = "9.2.2", Globals2.win = w, Globals2.doc = Globals2.win.document, Globals2.svg = Globals2.doc && Globals2.doc.createElementNS && !!Globals2.doc.createElementNS(Globals2.SVG_NS, "svg").createSVGRect, Globals2.userAgent = Globals2.win.navigator && Globals2.win.navigator.userAgent || "", Globals2.isChrome = Globals2.userAgent.indexOf("Chrome") !== -1, Globals2.isFirefox = Globals2.userAgent.indexOf("Firefox") !== -1, Globals2.isMS = /(edge|msie|trident)/i.test(Globals2.userAgent) && !Globals2.win.opera, Globals2.isSafari = !Globals2.isChrome && Globals2.userAgent.indexOf("Safari") !== -1, Globals2.isTouchDevice = /(Mobile|Android|Windows Phone)/.test(Globals2.userAgent), Globals2.isWebKit = Globals2.userAgent.indexOf("AppleWebKit") !== -1, Globals2.deg2rad = Math.PI * 2 / 360, Globals2.hasBidiBug = Globals2.isFirefox && parseInt(Globals2.userAgent.split("Firefox/")[1], 10) < 4, Globals2.hasTouch = !!Globals2.win.TouchEvent, Globals2.marginNames = [
    "plotTop",
    "marginRight",
    "marginBottom",
    "plotLeft"
  ], Globals2.noop = function() {
  }, Globals2.supportsPassiveEvents = (function() {
    var supportsPassive = false;
    if (!Globals2.isMS) {
      var opts = Object.defineProperty({}, "passive", {
        get: function() {
          supportsPassive = true;
        }
      });
      if (Globals2.win.addEventListener && Globals2.win.removeEventListener) {
        Globals2.win.addEventListener("testPassive", Globals2.noop, opts);
        Globals2.win.removeEventListener("testPassive", Globals2.noop, opts);
      }
    }
    return supportsPassive;
  })();
  Globals2.charts = [];
  Globals2.dateFormats = {};
  Globals2.seriesTypes = {};
  Globals2.symbolSizes = {};
  Globals2.chartCount = 0;
})(Globals || (Globals = {}));
const H = Globals;
var charts$5 = H.charts, doc$m = H.doc, win$g = H.win;
function error$c(code, stop2, chart, params2) {
  var severity = stop2 ? "Highcharts error" : "Highcharts warning";
  if (code === 32) {
    code = severity + ": Deprecated member";
  }
  var isCode = isNumber$X(code);
  var message2 = isCode ? severity + " #" + code + ": www.highcharts.com/errors/" + code + "/" : code.toString();
  var defaultHandler = function() {
    if (stop2) {
      throw new Error(message2);
    }
    if (win$g.console && error$c.messages.indexOf(message2) === -1) {
      console.warn(message2);
    }
  };
  if (typeof params2 !== "undefined") {
    var additionalMessages_1 = "";
    if (isCode) {
      message2 += "?";
    }
    objectEach$D(params2, function(value, key2) {
      additionalMessages_1 += "\n - " + key2 + ": " + value;
      if (isCode) {
        message2 += encodeURI(key2) + "=" + encodeURI(value);
      }
    });
    message2 += additionalMessages_1;
  }
  fireEvent$C(H, "displayError", { chart, code, message: message2, params: params2 }, defaultHandler);
  error$c.messages.push(message2);
}
(function(error2) {
  error2.messages = [];
})(error$c || (error$c = {}));
function merge$1x() {
  var i2, args = arguments, ret = {};
  var doCopy = function(copy, original) {
    if (typeof copy !== "object") {
      copy = {};
    }
    objectEach$D(original, function(value, key2) {
      if (key2 === "__proto__" || key2 === "constructor") {
        return;
      }
      if (isObject$i(value, true) && !isClass(value) && !isDOMElement(value)) {
        copy[key2] = doCopy(copy[key2] || {}, value);
      } else {
        copy[key2] = original[key2];
      }
    });
    return copy;
  };
  if (args[0] === true) {
    ret = args[1];
    args = Array.prototype.slice.call(args, 2);
  }
  var len = args.length;
  for (i2 = 0; i2 < len; i2++) {
    ret = doCopy(ret, args[i2]);
  }
  return ret;
}
function clamp$l(value, min2, max2) {
  return value > min2 ? value < max2 ? value : max2 : min2;
}
function cleanRecursively$2(newer, older) {
  var result2 = {};
  objectEach$D(newer, function(_val, key2) {
    var ob;
    if (isObject$i(newer[key2], true) && !newer.nodeType && // #10044
    older[key2]) {
      ob = cleanRecursively$2(newer[key2], older[key2]);
      if (Object.keys(ob).length) {
        result2[key2] = ob;
      }
    } else if (isObject$i(newer[key2]) || newer[key2] !== older[key2]) {
      result2[key2] = newer[key2];
    }
  });
  return result2;
}
function pInt$a(s, mag) {
  return parseInt(s, mag || 10);
}
function isString$d(s) {
  return typeof s === "string";
}
function isArray$q(obj) {
  var str = Object.prototype.toString.call(obj);
  return str === "[object Array]" || str === "[object Array Iterator]";
}
function isObject$i(obj, strict) {
  return !!obj && typeof obj === "object" && (!strict || !isArray$q(obj));
}
function isDOMElement(obj) {
  return isObject$i(obj) && typeof obj.nodeType === "number";
}
function isClass(obj) {
  var c = obj && obj.constructor;
  return !!(isObject$i(obj, true) && !isDOMElement(obj) && (c && c.name && c.name !== "Object"));
}
function isNumber$X(n2) {
  return typeof n2 === "number" && !isNaN(n2) && n2 < Infinity && n2 > -Infinity;
}
function erase$a(arr, item) {
  var i2 = arr.length;
  while (i2--) {
    if (arr[i2] === item) {
      arr.splice(i2, 1);
      break;
    }
  }
}
function defined$_(obj) {
  return typeof obj !== "undefined" && obj !== null;
}
function attr$8(elem, prop, value) {
  var ret;
  if (isString$d(prop)) {
    if (defined$_(value)) {
      elem.setAttribute(prop, value);
    } else if (elem && elem.getAttribute) {
      ret = elem.getAttribute(prop);
      if (!ret && prop === "class") {
        ret = elem.getAttribute(prop + "Name");
      }
    }
  } else {
    objectEach$D(prop, function(val, key2) {
      elem.setAttribute(key2, val);
    });
  }
  return ret;
}
function splat$l(obj) {
  return isArray$q(obj) ? obj : [obj];
}
function syncTimeout$9(fn, delay, context) {
  if (delay > 0) {
    return setTimeout(fn, delay, context);
  }
  fn.call(0, context);
  return -1;
}
function internalClearTimeout(id) {
  if (defined$_(id)) {
    clearTimeout(id);
  }
}
function extend$1y(a, b) {
  var n2;
  if (!a) {
    a = {};
  }
  for (n2 in b) {
    a[n2] = b[n2];
  }
  return a;
}
function pick$1K() {
  var args = arguments;
  var length = args.length;
  for (var i2 = 0; i2 < length; i2++) {
    var arg = args[i2];
    if (typeof arg !== "undefined" && arg !== null) {
      return arg;
    }
  }
}
function css$d(el, styles) {
  if (H.isMS && !H.svg) {
    if (styles && typeof styles.opacity !== "undefined") {
      styles.filter = "alpha(opacity=" + styles.opacity * 100 + ")";
    }
  }
  extend$1y(el.style, styles);
}
function createElement$b(tag2, attribs, styles, parent, nopad) {
  var el = doc$m.createElement(tag2);
  if (attribs) {
    extend$1y(el, attribs);
  }
  if (nopad) {
    css$d(el, { padding: "0", border: "none", margin: "0" });
  }
  if (styles) {
    css$d(el, styles);
  }
  if (parent) {
    parent.appendChild(el);
  }
  return el;
}
function extendClass$2(parent, members) {
  var obj = (function() {
  });
  obj.prototype = new parent();
  extend$1y(obj.prototype, members);
  return obj;
}
function pad$2(number, length, padder) {
  return new Array((length || 2) + 1 - String(number).replace("-", "").length).join(padder || "0") + number;
}
function relativeLength$a(value, base2, offset2) {
  return /%$/.test(value) ? base2 * parseFloat(value) / 100 + (offset2 || 0) : parseFloat(value);
}
function wrap$i(obj, method, func) {
  var proceed = obj[method];
  obj[method] = function() {
    var args = Array.prototype.slice.call(arguments), outerArgs = arguments, ctx = this;
    ctx.proceed = function() {
      proceed.apply(ctx, arguments.length ? arguments : outerArgs);
    };
    args.unshift(proceed);
    var ret = func.apply(this, args);
    ctx.proceed = null;
    return ret;
  };
}
function getMagnitude$3(num) {
  return Math.pow(10, Math.floor(Math.log(num) / Math.LN10));
}
function normalizeTickInterval$3(interval, multiples, magnitude, allowDecimals, hasTickAmount) {
  var i2, retInterval = interval;
  magnitude = pick$1K(magnitude, 1);
  var normalized = interval / magnitude;
  if (!multiples) {
    multiples = hasTickAmount ? (
      // Finer grained ticks when the tick amount is hard set, including
      // when alignTicks is true on multiple axes (#4580).
      [1, 1.2, 1.5, 2, 2.5, 3, 4, 5, 6, 8, 10]
    ) : (
      // Else, let ticks fall on rounder numbers
      [1, 2, 2.5, 5, 10]
    );
    if (allowDecimals === false) {
      if (magnitude === 1) {
        multiples = multiples.filter(function(num) {
          return num % 1 === 0;
        });
      } else if (magnitude <= 0.1) {
        multiples = [1 / magnitude];
      }
    }
  }
  for (i2 = 0; i2 < multiples.length; i2++) {
    retInterval = multiples[i2];
    if (hasTickAmount && retInterval * magnitude >= interval || !hasTickAmount && normalized <= (multiples[i2] + (multiples[i2 + 1] || multiples[i2])) / 2) {
      break;
    }
  }
  retInterval = correctFloat$d(retInterval * magnitude, -Math.round(Math.log(1e-3) / Math.LN10));
  return retInterval;
}
function stableSort$7(arr, sortFunction) {
  var length = arr.length;
  var sortValue, i2;
  for (i2 = 0; i2 < length; i2++) {
    arr[i2].safeI = i2;
  }
  arr.sort(function(a, b) {
    sortValue = sortFunction(a, b);
    return sortValue === 0 ? a.safeI - b.safeI : sortValue;
  });
  for (i2 = 0; i2 < length; i2++) {
    delete arr[i2].safeI;
  }
}
function arrayMin$9(data) {
  var i2 = data.length, min2 = data[0];
  while (i2--) {
    if (data[i2] < min2) {
      min2 = data[i2];
    }
  }
  return min2;
}
function arrayMax$a(data) {
  var i2 = data.length, max2 = data[0];
  while (i2--) {
    if (data[i2] > max2) {
      max2 = data[i2];
    }
  }
  return max2;
}
function destroyObjectProperties$a(obj, except) {
  objectEach$D(obj, function(val, n2) {
    if (val && val !== except && val.destroy) {
      val.destroy();
    }
    delete obj[n2];
  });
}
function discardElement$7(element) {
  if (!garbageBin) {
    garbageBin = createElement$b("div");
  }
  if (element) {
    garbageBin.appendChild(element);
  }
  garbageBin.innerHTML = "";
}
var garbageBin;
function correctFloat$d(num, prec) {
  return parseFloat(num.toPrecision(prec || 14));
}
var timeUnits$4 = {
  millisecond: 1,
  second: 1e3,
  minute: 6e4,
  hour: 36e5,
  day: 24 * 36e5,
  week: 7 * 24 * 36e5,
  month: 28 * 24 * 36e5,
  year: 364 * 24 * 36e5
};
Math.easeInOutSine = function(pos) {
  return -0.5 * (Math.cos(Math.PI * pos) - 1);
};
function getNestedProperty$3(path, parent) {
  var pathElements = path.split(".");
  while (pathElements.length && defined$_(parent)) {
    var pathElement = pathElements.shift();
    if (typeof pathElement === "undefined" || pathElement === "__proto__") {
      return;
    }
    var child = parent[pathElement];
    if (!defined$_(child) || typeof child === "function" || typeof child.nodeType === "number" || child === win$g) {
      return;
    }
    parent = child;
  }
  return parent;
}
function getStyle$2(el, prop, toInt) {
  var customGetStyle = H.getStyle || // oldie getStyle
  getStyle$2;
  var style;
  if (prop === "width") {
    var offsetWidth = Math.min(el.offsetWidth, el.scrollWidth);
    var boundingClientRectWidth = el.getBoundingClientRect && el.getBoundingClientRect().width;
    if (boundingClientRectWidth < offsetWidth && boundingClientRectWidth >= offsetWidth - 1) {
      offsetWidth = Math.floor(boundingClientRectWidth);
    }
    return Math.max(
      0,
      // #8377
      offsetWidth - (customGetStyle(el, "padding-left", true) || 0) - (customGetStyle(el, "padding-right", true) || 0)
    );
  }
  if (prop === "height") {
    return Math.max(
      0,
      // #8377
      Math.min(el.offsetHeight, el.scrollHeight) - (customGetStyle(el, "padding-top", true) || 0) - (customGetStyle(el, "padding-bottom", true) || 0)
    );
  }
  if (!win$g.getComputedStyle) {
    error$c(27, true);
  }
  var css2 = win$g.getComputedStyle(el, void 0);
  if (css2) {
    style = css2.getPropertyValue(prop);
    if (pick$1K(toInt, prop !== "opacity")) {
      style = pInt$a(style);
    }
  }
  return style;
}
function inArray(item, arr, fromIndex) {
  error$c(32, false, void 0, { "Highcharts.inArray": "use Array.indexOf" });
  return arr.indexOf(item, fromIndex);
}
var find$l = Array.prototype.find ? function(arr, callback) {
  return arr.find(callback);
} : (
  // Legacy implementation. PhantomJS, IE <= 11 etc. #7223.
  (function(arr, callback) {
    var i2;
    var length = arr.length;
    for (i2 = 0; i2 < length; i2++) {
      if (callback(arr[i2], i2)) {
        return arr[i2];
      }
    }
  })
);
function keys(obj) {
  error$c(32, false, void 0, { "Highcharts.keys": "use Object.keys" });
  return Object.keys(obj);
}
function offset$1(el) {
  var docElem = doc$m.documentElement, box = el.parentElement || el.parentNode ? el.getBoundingClientRect() : { top: 0, left: 0, width: 0, height: 0 };
  return {
    top: box.top + (win$g.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
    left: box.left + (win$g.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0),
    width: box.width,
    height: box.height
  };
}
function objectEach$D(obj, fn, ctx) {
  for (var key2 in obj) {
    if (Object.hasOwnProperty.call(obj, key2)) {
      fn.call(ctx || obj[key2], obj[key2], key2, obj);
    }
  }
}
objectEach$D({
  map: "map",
  each: "forEach",
  grep: "filter",
  reduce: "reduce",
  some: "some"
}, function(val, key2) {
  H[key2] = function(arr) {
    var _a2;
    error$c(32, false, void 0, (_a2 = {}, _a2["Highcharts." + key2] = "use Array." + val, _a2));
    return Array.prototype[val].apply(arr, [].slice.call(arguments, 1));
  };
});
function addEvent$19(el, type, fn, options) {
  if (options === void 0) {
    options = {};
  }
  var owner = typeof el === "function" && el.prototype || el;
  if (!Object.hasOwnProperty.call(owner, "hcEvents")) {
    owner.hcEvents = {};
  }
  var events = owner.hcEvents;
  if (H.Point && // without H a dependency loop occurs
  el instanceof H.Point && el.series && el.series.chart) {
    el.series.chart.runTrackerClick = true;
  }
  var addEventListener = el.addEventListener || H.addEventListenerPolyfill;
  if (addEventListener) {
    addEventListener.call(el, type, fn, H.supportsPassiveEvents ? {
      passive: options.passive === void 0 ? type.indexOf("touch") !== -1 : options.passive,
      capture: false
    } : false);
  }
  if (!events[type]) {
    events[type] = [];
  }
  var eventObject = {
    fn,
    order: typeof options.order === "number" ? options.order : Infinity
  };
  events[type].push(eventObject);
  events[type].sort(function(a, b) {
    return a.order - b.order;
  });
  return function() {
    removeEvent$c(el, type, fn);
  };
}
function removeEvent$c(el, type, fn) {
  function removeOneEvent(type2, fn2) {
    var removeEventListener = el.removeEventListener || H.removeEventListenerPolyfill;
    if (removeEventListener) {
      removeEventListener.call(el, type2, fn2, false);
    }
  }
  function removeAllEvents(eventCollection) {
    var types, len;
    if (!el.nodeName) {
      return;
    }
    if (type) {
      types = {};
      types[type] = true;
    } else {
      types = eventCollection;
    }
    objectEach$D(types, function(_val, n2) {
      if (eventCollection[n2]) {
        len = eventCollection[n2].length;
        while (len--) {
          removeOneEvent(n2, eventCollection[n2][len].fn);
        }
      }
    });
  }
  var owner = typeof el === "function" && el.prototype || el;
  if (Object.hasOwnProperty.call(owner, "hcEvents")) {
    var events = owner.hcEvents;
    if (type) {
      var typeEvents = events[type] || [];
      if (fn) {
        events[type] = typeEvents.filter(function(obj) {
          return fn !== obj.fn;
        });
        removeOneEvent(type, fn);
      } else {
        removeAllEvents(events);
        events[type] = [];
      }
    } else {
      removeAllEvents(events);
      delete owner.hcEvents;
    }
  }
}
function fireEvent$C(el, type, eventArguments, defaultFunction) {
  var e;
  eventArguments = eventArguments || {};
  if (doc$m.createEvent && (el.dispatchEvent || el.fireEvent && // Enable firing events on Highcharts instance.
  el !== H)) {
    e = doc$m.createEvent("Events");
    e.initEvent(type, true, true);
    eventArguments = extend$1y(e, eventArguments);
    if (el.dispatchEvent) {
      el.dispatchEvent(eventArguments);
    } else {
      el.fireEvent(type, eventArguments);
    }
  } else if (el.hcEvents) {
    if (!eventArguments.target) {
      extend$1y(eventArguments, {
        // Attach a simple preventDefault function to skip
        // default handler if called. The built-in
        // defaultPrevented property is not overwritable (#5112)
        preventDefault: function() {
          eventArguments.defaultPrevented = true;
        },
        // Setting target to native events fails with clicking
        // the zoom-out button in Chrome.
        target: el,
        // If the type is not set, we're running a custom event
        // (#2297). If it is set, we're running a browser event,
        // and setting it will cause en error in IE8 (#2465).
        type
      });
    }
    var events = [];
    var object = el;
    var multilevel = false;
    while (object.hcEvents) {
      if (Object.hasOwnProperty.call(object, "hcEvents") && object.hcEvents[type]) {
        if (events.length) {
          multilevel = true;
        }
        events.unshift.apply(events, object.hcEvents[type]);
      }
      object = Object.getPrototypeOf(object);
    }
    if (multilevel) {
      events.sort(function(a, b) {
        return a.order - b.order;
      });
    }
    events.forEach(function(obj) {
      if (obj.fn.call(el, eventArguments) === false) {
        eventArguments.preventDefault();
      }
    });
  }
  if (defaultFunction && !eventArguments.defaultPrevented) {
    defaultFunction.call(el, eventArguments);
  }
}
var serialMode;
var uniqueKey$8 = (function() {
  var hash2 = Math.random().toString(36).substring(2, 9) + "-";
  var id = 0;
  return function() {
    return "highcharts-" + (serialMode ? "" : hash2) + id++;
  };
})();
function useSerialIds(mode2) {
  return serialMode = pick$1K(mode2, serialMode);
}
function isFunction$5(obj) {
  return typeof obj === "function";
}
if (win$g.jQuery) {
  win$g.jQuery.fn.highcharts = function() {
    var args = [].slice.call(arguments);
    if (this[0]) {
      if (args[0]) {
        new H[
          // eslint-disable-line computed-property-spacing, no-new
          // Constructor defaults to Chart
          isString$d(args[0]) ? args.shift() : "Chart"
        ](this[0], args[0], args[1]);
        return this;
      }
      return charts$5[attr$8(this[0], "data-highcharts-chart")];
    }
  };
}
var Utilities = {
  addEvent: addEvent$19,
  arrayMax: arrayMax$a,
  arrayMin: arrayMin$9,
  attr: attr$8,
  clamp: clamp$l,
  cleanRecursively: cleanRecursively$2,
  clearTimeout: internalClearTimeout,
  correctFloat: correctFloat$d,
  createElement: createElement$b,
  css: css$d,
  defined: defined$_,
  destroyObjectProperties: destroyObjectProperties$a,
  discardElement: discardElement$7,
  erase: erase$a,
  error: error$c,
  extend: extend$1y,
  extendClass: extendClass$2,
  find: find$l,
  fireEvent: fireEvent$C,
  getMagnitude: getMagnitude$3,
  getNestedProperty: getNestedProperty$3,
  getStyle: getStyle$2,
  inArray,
  isArray: isArray$q,
  isClass,
  isDOMElement,
  isFunction: isFunction$5,
  isNumber: isNumber$X,
  isObject: isObject$i,
  isString: isString$d,
  keys,
  merge: merge$1x,
  normalizeTickInterval: normalizeTickInterval$3,
  objectEach: objectEach$D,
  offset: offset$1,
  pad: pad$2,
  pick: pick$1K,
  pInt: pInt$a,
  relativeLength: relativeLength$a,
  removeEvent: removeEvent$c,
  splat: splat$l,
  stableSort: stableSort$7,
  syncTimeout: syncTimeout$9,
  timeUnits: timeUnits$4,
  uniqueKey: uniqueKey$8,
  useSerialIds,
  wrap: wrap$i
};
var palette = {
  /**
   * Colors for data series and points.
   */
  colors: [
    "#7cb5ec",
    "#434348",
    "#90ed7d",
    "#f7a35c",
    "#8085e9",
    "#f15c80",
    "#e4d354",
    "#2b908f",
    "#f45b5b",
    "#91e8e1"
  ],
  /**
   * Chart background, point stroke for markers and columns etc
   */
  backgroundColor: "#ffffff",
  /**
   * Strong text.
   */
  neutralColor100: "#000000",
  /**
   * Main text and some strokes.
   */
  neutralColor80: "#333333",
  /**
   * Axis labels, axis title, connector fallback.
   */
  neutralColor60: "#666666",
  /**
   * Credits text, export menu stroke.
   */
  neutralColor40: "#999999",
  /**
   * Disabled texts, button strokes, crosshair etc.
   */
  neutralColor20: "#cccccc",
  /**
   * Grid lines etc.
   */
  neutralColor10: "#e6e6e6",
  /**
   * Minor grid lines etc.
   */
  neutralColor5: "#f2f2f2",
  /**
   * Tooltip backgroud, button fills, map null points.
   */
  neutralColor3: "#f7f7f7",
  /**
   * Drilldown clickable labels, color axis max color.
   */
  highlightColor100: "#003399",
  /**
   * Selection marker, menu hover, button hover, chart border, navigator series.
   */
  highlightColor80: "#335cad",
  /**
   * Navigator mask fill.
   */
  highlightColor60: "#6685c2",
  /**
   * Ticks and axis line.
   */
  highlightColor20: "#ccd6eb",
  /**
   * Pressed button, color axis min color.
   */
  highlightColor10: "#e6ebf5"
};
var ChartDefaults = {
  /**
   * Default `mapData` for all series. If set to a string, it functions
   * as an index into the `Highcharts.maps` array. Otherwise it is
   * interpreted as map data.
   *
   * @see [mapData](#series.map.mapData)
   *
   * @sample    maps/demo/geojson
   *            Loading geoJSON data
   * @sample    maps/chart/topojson
   *            Loading topoJSON converted to geoJSON
   *
   * @type      {string|Array<*>|Highcharts.GeoJSON}
   * @since     5.0.0
   * @product   highmaps
   * @apioption chart.map
   */
  /**
   * Set lat/lon transformation definitions for the chart. If not defined,
   * these are extracted from the map data.
   *
   * @type      {*}
   * @since     5.0.0
   * @product   highmaps
   * @apioption chart.mapTransforms
   */
  /**
   * When using multiple axis, the ticks of two or more opposite axes
   * will automatically be aligned by adding ticks to the axis or axes
   * with the least ticks, as if `tickAmount` were specified.
   *
   * This can be prevented by setting `alignTicks` to false. If the grid
   * lines look messy, it's a good idea to hide them for the secondary
   * axis by setting `gridLineWidth` to 0.
   *
   * If `startOnTick` or `endOnTick` in an Axis options are set to false,
   * then the `alignTicks ` will be disabled for the Axis.
   *
   * Disabled for logarithmic axes.
   *
   * @sample {highcharts} highcharts/chart/alignticks-true/
   *         True by default
   * @sample {highcharts} highcharts/chart/alignticks-false/
   *         False
   * @sample {highstock} stock/chart/alignticks-true/
   *         True by default
   * @sample {highstock} stock/chart/alignticks-false/
   *         False
   *
   * @type      {boolean}
   * @default   true
   * @product   highcharts highstock gantt
   * @apioption chart.alignTicks
   */
  /**
   * Set the overall animation for all chart updating. Animation can be
   * disabled throughout the chart by setting it to false here. It can
   * be overridden for each individual API method as a function parameter.
   * The only animation not affected by this option is the initial series
   * animation, see [plotOptions.series.animation](
   * #plotOptions.series.animation).
   *
   * The animation can either be set as a boolean or a configuration
   * object. If `true`, it will use the 'swing' jQuery easing and a
   * duration of 500 ms. If used as a configuration object, the following
   * properties are supported:
   *
   * - `defer`: The animation delay time in milliseconds.
   *
   * - `duration`: The duration of the animation in milliseconds.
   *
   * - `easing`: A string reference to an easing function set on the
   *   `Math` object. See
   *   [the easing demo](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-animation-easing/).
   *
   * When zooming on a series with less than 100 points, the chart redraw
   * will be done with animation, but in case of more data points, it is
   * necessary to set this option to ensure animation on zoom.
   *
   * @sample {highcharts} highcharts/chart/animation-none/
   *         Updating with no animation
   * @sample {highcharts} highcharts/chart/animation-duration/
   *         With a longer duration
   * @sample {highcharts} highcharts/chart/animation-easing/
   *         With a jQuery UI easing
   * @sample {highmaps} maps/chart/animation-none/
   *         Updating with no animation
   * @sample {highmaps} maps/chart/animation-duration/
   *         With a longer duration
   *
   * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
   * @default   undefined
   * @apioption chart.animation
   */
  /**
   * A CSS class name to apply to the charts container `div`, allowing
   * unique CSS styling for each chart.
   *
   * @type      {string}
   * @apioption chart.className
   */
  /**
   * Event listeners for the chart.
   *
   * @apioption chart.events
   */
  /**
   * Fires when a series is added to the chart after load time, using the
   * `addSeries` method. One parameter, `event`, is passed to the
   * function, containing common event information. Through
   * `event.options` you can access the series options that were passed to
   * the `addSeries` method. Returning false prevents the series from
   * being added.
   *
   * @sample {highcharts} highcharts/chart/events-addseries/
   *         Alert on add series
   * @sample {highstock} stock/chart/events-addseries/
   *         Alert on add series
   *
   * @type      {Highcharts.ChartAddSeriesCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Chart
   * @apioption chart.events.addSeries
   */
  /**
   * Fires when clicking on the plot background. One parameter, `event`,
   * is passed to the function, containing common event information.
   *
   * Information on the clicked spot can be found through `event.xAxis`
   * and `event.yAxis`, which are arrays containing the axes of each
   * dimension and each axis' value at the clicked spot. The primary axes
   * are `event.xAxis[0]` and `event.yAxis[0]`. Remember the unit of a
   * datetime axis is milliseconds since 1970-01-01 00:00:00.
   *
   * ```js
   * click: function(e) {
   *     console.log(
   *         Highcharts.dateFormat('%Y-%m-%d %H:%M:%S', e.xAxis[0].value),
   *         e.yAxis[0].value
   *     )
   * }
   * ```
   *
   * @sample {highcharts} highcharts/chart/events-click/
   *         Alert coordinates on click
   * @sample {highcharts} highcharts/chart/events-container/
   *         Alternatively, attach event to container
   * @sample {highstock} stock/chart/events-click/
   *         Alert coordinates on click
   * @sample {highstock} highcharts/chart/events-container/
   *         Alternatively, attach event to container
   * @sample {highmaps} maps/chart/events-click/
   *         Record coordinates on click
   * @sample {highmaps} highcharts/chart/events-container/
   *         Alternatively, attach event to container
   *
   * @type      {Highcharts.ChartClickCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Chart
   * @apioption chart.events.click
   */
  /**
   * Fires when the chart is finished loading. Since v4.2.2, it also waits
   * for images to be loaded, for example from point markers. One
   * parameter, `event`, is passed to the function, containing common
   * event information.
   *
   * There is also a second parameter to the chart constructor where a
   * callback function can be passed to be executed on chart.load.
   *
   * @sample {highcharts} highcharts/chart/events-load/
   *         Alert on chart load
   * @sample {highstock} stock/chart/events-load/
   *         Alert on chart load
   * @sample {highmaps} maps/chart/events-load/
   *         Add series on chart load
   *
   * @type      {Highcharts.ChartLoadCallbackFunction}
   * @context   Highcharts.Chart
   * @apioption chart.events.load
   */
  /**
   * Fires when the chart is redrawn, either after a call to
   * `chart.redraw()` or after an axis, series or point is modified with
   * the `redraw` option set to `true`. One parameter, `event`, is passed
   * to the function, containing common event information.
   *
   * @sample {highcharts} highcharts/chart/events-redraw/
   *         Alert on chart redraw
   * @sample {highstock} stock/chart/events-redraw/
   *         Alert on chart redraw when adding a series or moving the
   *         zoomed range
   * @sample {highmaps} maps/chart/events-redraw/
   *         Set subtitle on chart redraw
   *
   * @type      {Highcharts.ChartRedrawCallbackFunction}
   * @since     1.2.0
   * @context   Highcharts.Chart
   * @apioption chart.events.redraw
   */
  /**
   * Fires after initial load of the chart (directly after the `load`
   * event), and after each redraw (directly after the `redraw` event).
   *
   * @type      {Highcharts.ChartRenderCallbackFunction}
   * @since     5.0.7
   * @context   Highcharts.Chart
   * @apioption chart.events.render
   */
  /**
   * Fires when an area of the chart has been selected. Selection is
   * enabled by setting the chart's zoomType. One parameter, `event`, is
   * passed to the function, containing common event information. The
   * default action for the selection event is to zoom the chart to the
   * selected area. It can be prevented by calling
   * `event.preventDefault()` or return false.
   *
   * Information on the selected area can be found through `event.xAxis`
   * and `event.yAxis`, which are arrays containing the axes of each
   * dimension and each axis' min and max values. The primary axes are
   * `event.xAxis[0]` and `event.yAxis[0]`. Remember the unit of a
   * datetime axis is milliseconds since 1970-01-01 00:00:00.
   *
   * ```js
   * selection: function(event) {
   *     // log the min and max of the primary, datetime x-axis
   *     console.log(
   *         Highcharts.dateFormat(
   *             '%Y-%m-%d %H:%M:%S',
   *             event.xAxis[0].min
   *         ),
   *         Highcharts.dateFormat(
   *             '%Y-%m-%d %H:%M:%S',
   *             event.xAxis[0].max
   *         )
   *     );
   *     // log the min and max of the y axis
   *     console.log(event.yAxis[0].min, event.yAxis[0].max);
   * }
   * ```
   *
   * @sample {highcharts} highcharts/chart/events-selection/
   *         Report on selection and reset
   * @sample {highcharts} highcharts/chart/events-selection-points/
   *         Select a range of points through a drag selection
   * @sample {highstock} stock/chart/events-selection/
   *         Report on selection and reset
   * @sample {highstock} highcharts/chart/events-selection-points/
   *         Select a range of points through a drag selection
   *         (Highcharts)
   *
   * @type      {Highcharts.ChartSelectionCallbackFunction}
   * @apioption chart.events.selection
   */
  /**
   * The margin between the outer edge of the chart and the plot area.
   * The numbers in the array designate top, right, bottom and left
   * respectively. Use the options `marginTop`, `marginRight`,
   * `marginBottom` and `marginLeft` for shorthand setting of one option.
   *
   * By default there is no margin. The actual space is dynamically
   * calculated from the offset of axis labels, axis title, title,
   * subtitle and legend in addition to the `spacingTop`, `spacingRight`,
   * `spacingBottom` and `spacingLeft` options.
   *
   * @sample {highcharts} highcharts/chart/margins-zero/
   *         Zero margins
   * @sample {highstock} stock/chart/margin-zero/
   *         Zero margins
   *
   * @type      {number|Array<number>}
   * @apioption chart.margin
   */
  /**
   * The margin between the bottom outer edge of the chart and the plot
   * area. Use this to set a fixed pixel value for the margin as opposed
   * to the default dynamic margin. See also `spacingBottom`.
   *
   * @sample {highcharts} highcharts/chart/marginbottom/
   *         100px bottom margin
   * @sample {highstock} stock/chart/marginbottom/
   *         100px bottom margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginBottom
   */
  /**
   * The margin between the left outer edge of the chart and the plot
   * area. Use this to set a fixed pixel value for the margin as opposed
   * to the default dynamic margin. See also `spacingLeft`.
   *
   * @sample {highcharts} highcharts/chart/marginleft/
   *         150px left margin
   * @sample {highstock} stock/chart/marginleft/
   *         150px left margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginLeft
   */
  /**
   * The margin between the right outer edge of the chart and the plot
   * area. Use this to set a fixed pixel value for the margin as opposed
   * to the default dynamic margin. See also `spacingRight`.
   *
   * @sample {highcharts} highcharts/chart/marginright/
   *         100px right margin
   * @sample {highstock} stock/chart/marginright/
   *         100px right margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginRight
   */
  /**
   * The margin between the top outer edge of the chart and the plot area.
   * Use this to set a fixed pixel value for the margin as opposed to
   * the default dynamic margin. See also `spacingTop`.
   *
   * @sample {highcharts} highcharts/chart/margintop/ 100px top margin
   * @sample {highstock} stock/chart/margintop/
   *         100px top margin
   * @sample {highmaps} maps/chart/margin/
   *         100px margins
   *
   * @type      {number}
   * @since     2.0
   * @apioption chart.marginTop
   */
  /**
   * Callback function to override the default function that formats all
   * the numbers in the chart. Returns a string with the formatted number.
   *
   * @sample highcharts/members/highcharts-numberformat
   *      Arabic digits in Highcharts
   * @type {Highcharts.NumberFormatterCallbackFunction}
   * @since 8.0.0
   * @apioption chart.numberFormatter
   */
  /**
   * Allows setting a key to switch between zooming and panning. Can be
   * one of `alt`, `ctrl`, `meta` (the command key on Mac and Windows
   * key on Windows) or `shift`. The keys are mapped directly to the key
   * properties of the click event argument (`event.altKey`,
   * `event.ctrlKey`, `event.metaKey` and `event.shiftKey`).
   *
   * @type       {string}
   * @since      4.0.3
   * @product    highcharts gantt
   * @validvalue ["alt", "ctrl", "meta", "shift"]
   * @apioption  chart.panKey
   */
  /**
   * Allow panning in a chart. Best used with [panKey](#chart.panKey)
   * to combine zooming and panning.
   *
   * On touch devices, when the [tooltip.followTouchMove](
   * #tooltip.followTouchMove) option is `true` (default), panning
   * requires two fingers. To allow panning with one finger, set
   * `followTouchMove` to `false`.
   *
   * @sample  {highcharts} highcharts/chart/pankey/ Zooming and panning
   * @sample  {highstock} stock/chart/panning/ Zooming and xy panning
   */
  panning: {
    /**
     * Enable or disable chart panning.
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock|highmaps} true
     */
    enabled: false,
    /**
     * Decides in what dimensions the user can pan the chart. Can be
     * one of `x`, `y`, or `xy`.
     *
     * @sample {highcharts} highcharts/chart/panning-type
     *         Zooming and xy panning
     *
     * @type       {string}
     * @validvalue ["x", "y", "xy"]
     * @default    {highcharts|highstock} x
     * @default    {highmaps} xy
     */
    type: "x"
  },
  /**
   * Equivalent to [zoomType](#chart.zoomType), but for multitouch
   * gestures only. By default, the `pinchType` is the same as the
   * `zoomType` setting. However, pinching can be enabled separately in
   * some cases, for example in stock charts where a mouse drag pans the
   * chart, while pinching is enabled. When [tooltip.followTouchMove](
   * #tooltip.followTouchMove) is true, pinchType only applies to
   * two-finger touches.
   *
   * @type       {string}
   * @default    {highcharts} undefined
   * @default    {highstock} x
   * @since      3.0
   * @product    highcharts highstock gantt
   * @validvalue ["x", "y", "xy"]
   * @apioption  chart.pinchType
   */
  /**
   * Whether to apply styled mode. When in styled mode, no presentational
   * attributes or CSS are applied to the chart SVG. Instead, CSS rules
   * are required to style the chart. The default style sheet is
   * available from `https://code.highcharts.com/css/highcharts.css`.
   *
   * @type       {boolean}
   * @default    false
   * @since      7.0
   * @apioption  chart.styledMode
   */
  styledMode: false,
  /**
   * The corner radius of the outer chart border.
   *
   * @sample {highcharts} highcharts/chart/borderradius/
   *         20px radius
   * @sample {highstock} stock/chart/border/
   *         10px radius
   * @sample {highmaps} maps/chart/border/
   *         Border options
   *
   */
  borderRadius: 0,
  /**
   * In styled mode, this sets how many colors the class names
   * should rotate between. With ten colors, series (or points) are
   * given class names like `highcharts-color-0`, `highcharts-color-0`
   * [...] `highcharts-color-9`. The equivalent in non-styled mode
   * is to set colors using the [colors](#colors) setting.
   *
   * @since      5.0.0
   */
  colorCount: 10,
  /**
   * Alias of `type`.
   *
   * @sample {highcharts} highcharts/chart/defaultseriestype/
   *         Bar
   *
   * @deprecated
   *
   * @product highcharts
   */
  defaultSeriesType: "line",
  /**
   * If true, the axes will scale to the remaining visible series once
   * one series is hidden. If false, hiding and showing a series will
   * not affect the axes or the other series. For stacks, once one series
   * within the stack is hidden, the rest of the stack will close in
   * around it even if the axis is not affected.
   *
   * @sample {highcharts} highcharts/chart/ignorehiddenseries-true/
   *         True by default
   * @sample {highcharts} highcharts/chart/ignorehiddenseries-false/
   *         False
   * @sample {highcharts} highcharts/chart/ignorehiddenseries-true-stacked/
   *         True with stack
   * @sample {highstock} stock/chart/ignorehiddenseries-true/
   *         True by default
   * @sample {highstock} stock/chart/ignorehiddenseries-false/
   *         False
   *
   * @since   1.2.0
   * @product highcharts highstock gantt
   */
  ignoreHiddenSeries: true,
  /**
   * Whether to invert the axes so that the x axis is vertical and y axis
   * is horizontal. When `true`, the x axis is [reversed](#xAxis.reversed)
   * by default.
   *
   * @productdesc {highcharts}
   * If a bar series is present in the chart, it will be inverted
   * automatically. Inverting the chart doesn't have an effect if there
   * are no cartesian series in the chart, or if the chart is
   * [polar](#chart.polar).
   *
   * @sample {highcharts} highcharts/chart/inverted/
   *         Inverted line
   * @sample {highstock} stock/navigator/inverted/
   *         Inverted stock chart
   *
   * @type      {boolean}
   * @default   false
   * @product   highcharts highstock gantt
   * @apioption chart.inverted
   */
  /**
   * The distance between the outer edge of the chart and the content,
   * like title or legend, or axis title and labels if present. The
   * numbers in the array designate top, right, bottom and left
   * respectively. Use the options spacingTop, spacingRight, spacingBottom
   * and spacingLeft options for shorthand setting of one option.
   *
   * @type    {Array<number>}
   * @see     [chart.margin](#chart.margin)
   * @default [10, 10, 15, 10]
   * @since   3.0.6
   */
  spacing: [10, 10, 15, 10],
  /**
   * The button that appears after a selection zoom, allowing the user
   * to reset zoom.
   */
  resetZoomButton: {
    /**
     * What frame the button placement should be related to. Can be
     * either `plotBox` or `spacingBox`.
     *
     * @sample {highcharts} highcharts/chart/resetzoombutton-relativeto/
     *         Relative to the chart
     * @sample {highstock} highcharts/chart/resetzoombutton-relativeto/
     *         Relative to the chart
     *
     * @type       {Highcharts.ButtonRelativeToValue}
     * @default    plot
     * @since      2.2
     * @apioption  chart.resetZoomButton.relativeTo
     */
    /**
     * A collection of attributes for the button. The object takes SVG
     * attributes like `fill`, `stroke`, `stroke-width` or `r`, the
     * border radius. The theme also supports `style`, a collection of
     * CSS properties for the text. Equivalent attributes for the hover
     * state are given in `theme.states.hover`.
     *
     * @sample {highcharts} highcharts/chart/resetzoombutton-theme/
     *         Theming the button
     * @sample {highstock} highcharts/chart/resetzoombutton-theme/
     *         Theming the button
     *
     * @type {Highcharts.SVGAttributes}
     * @since 2.2
     */
    theme: {
      /** @internal */
      zIndex: 6
    },
    /**
     * The position of the button.
     *
     * @sample {highcharts} highcharts/chart/resetzoombutton-position/
     *         Above the plot area
     * @sample {highstock} highcharts/chart/resetzoombutton-position/
     *         Above the plot area
     * @sample {highmaps} highcharts/chart/resetzoombutton-position/
     *         Above the plot area
     *
     * @type  {Highcharts.AlignObject}
     * @since 2.2
     */
    position: {
      /**
       * The horizontal alignment of the button.
       */
      align: "right",
      /**
       * The horizontal offset of the button.
       */
      x: -10,
      /**
       * The vertical alignment of the button.
       *
       * @type       {Highcharts.VerticalAlignValue}
       * @default    top
       * @apioption  chart.resetZoomButton.position.verticalAlign
       */
      /**
       * The vertical offset of the button.
       */
      y: 10
    }
  },
  /**
   * The pixel width of the plot area border.
   *
   * @sample {highcharts} highcharts/chart/plotborderwidth/
   *         1px border
   * @sample {highstock} stock/chart/plotborder/
   *         2px border
   * @sample {highmaps} maps/chart/plotborder/
   *         Plot border options
   *
   * @type      {number}
   * @default   0
   * @apioption chart.plotBorderWidth
   */
  /**
   * Whether to apply a drop shadow to the plot area. Requires that
   * plotBackgroundColor be set. The shadow can be an object configuration
   * containing `color`, `offsetX`, `offsetY`, `opacity` and `width`.
   *
   * @sample {highcharts} highcharts/chart/plotshadow/
   *         Plot shadow
   * @sample {highstock} stock/chart/plotshadow/
   *         Plot shadow
   * @sample {highmaps} maps/chart/plotborder/
   *         Plot border options
   *
   * @type      {boolean|Highcharts.CSSObject}
   * @default   false
   * @apioption chart.plotShadow
   */
  /**
   * When true, cartesian charts like line, spline, area and column are
   * transformed into the polar coordinate system. This produces _polar
   * charts_, also known as _radar charts_.
   *
   * @sample {highcharts} highcharts/demo/polar/
   *         Polar chart
   * @sample {highcharts} highcharts/demo/polar-wind-rose/
   *         Wind rose, stacked polar column chart
   * @sample {highcharts} highcharts/demo/polar-spider/
   *         Spider web chart
   * @sample {highcharts} highcharts/parallel-coordinates/polar/
   *         Star plot, multivariate data in a polar chart
   *
   * @type      {boolean}
   * @default   false
   * @since     2.3.0
   * @product   highcharts
   * @requires  highcharts-more
   * @apioption chart.polar
   */
  /**
   * Whether to reflow the chart to fit the width of the container div
   * on resizing the window.
   *
   * @sample {highcharts} highcharts/chart/reflow-true/
   *         True by default
   * @sample {highcharts} highcharts/chart/reflow-false/
   *         False
   * @sample {highstock} stock/chart/reflow-true/
   *         True by default
   * @sample {highstock} stock/chart/reflow-false/
   *         False
   * @sample {highmaps} maps/chart/reflow-true/
   *         True by default
   * @sample {highmaps} maps/chart/reflow-false/
   *         False
   *
   * @type      {boolean}
   * @default   true
   * @since     2.1
   * @apioption chart.reflow
   */
  /**
   * The HTML element where the chart will be rendered. If it is a string,
   * the element by that id is used. The HTML element can also be passed
   * by direct reference, or as the first argument of the chart
   * constructor, in which case the option is not needed.
   *
   * @sample {highcharts} highcharts/chart/reflow-true/
   *         String
   * @sample {highcharts} highcharts/chart/renderto-object/
   *         Object reference
   * @sample {highstock} stock/chart/renderto-string/
   *         String
   * @sample {highstock} stock/chart/renderto-object/
   *         Object reference
   *
   * @type      {string|Highcharts.HTMLDOMElement}
   * @apioption chart.renderTo
   */
  /**
   * The background color of the marker square when selecting (zooming
   * in on) an area of the chart.
   *
   * @see In styled mode, the selection marker fill is set with the
   *      `.highcharts-selection-marker` class.
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @default   rgba(51,92,173,0.25)
   * @since     2.1.7
   * @apioption chart.selectionMarkerFill
   */
  /**
   * Whether to apply a drop shadow to the outer chart area. Requires
   * that backgroundColor be set. The shadow can be an object
   * configuration containing `color`, `offsetX`, `offsetY`, `opacity` and
   * `width`.
   *
   * @sample {highcharts} highcharts/chart/shadow/
   *         Shadow
   * @sample {highstock} stock/chart/shadow/
   *         Shadow
   * @sample {highmaps} maps/chart/border/
   *         Chart border and shadow
   *
   * @type      {boolean|Highcharts.CSSObject}
   * @default   false
   * @apioption chart.shadow
   */
  /**
   * Whether to show the axes initially. This only applies to empty charts
   * where series are added dynamically, as axes are automatically added
   * to cartesian series.
   *
   * @sample {highcharts} highcharts/chart/showaxes-false/
   *         False by default
   * @sample {highcharts} highcharts/chart/showaxes-true/
   *         True
   *
   * @type      {boolean}
   * @since     1.2.5
   * @product   highcharts gantt
   * @apioption chart.showAxes
   */
  /**
   * The space between the bottom edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingbottom/
   *         Spacing bottom set to 100
   * @sample {highstock} stock/chart/spacingbottom/
   *         Spacing bottom set to 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   15
   * @since     2.1
   * @apioption chart.spacingBottom
   */
  /**
   * The space between the left edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingleft/
   *         Spacing left set to 100
   * @sample {highstock} stock/chart/spacingleft/
   *         Spacing left set to 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   10
   * @since     2.1
   * @apioption chart.spacingLeft
   */
  /**
   * The space between the right edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingright-100/
   *         Spacing set to 100
   * @sample {highcharts} highcharts/chart/spacingright-legend/
   *         Legend in right position with default spacing
   * @sample {highstock} stock/chart/spacingright/
   *         Spacing set to 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   10
   * @since     2.1
   * @apioption chart.spacingRight
   */
  /**
   * The space between the top edge of the chart and the content (plot
   * area, axis title and labels, title, subtitle or legend in top
   * position).
   *
   * @sample {highcharts} highcharts/chart/spacingtop-100/
   *         A top spacing of 100
   * @sample {highcharts} highcharts/chart/spacingtop-10/
   *         Floating chart title makes the plot area align to the default
   *         spacingTop of 10.
   * @sample {highstock} stock/chart/spacingtop/
   *         A top spacing of 100
   * @sample {highmaps} maps/chart/spacing/
   *         Spacing 100 all around
   *
   * @type      {number}
   * @default   10
   * @since     2.1
   * @apioption chart.spacingTop
   */
  /**
   * Additional CSS styles to apply inline to the container `div`. Note
   * that since the default font styles are applied in the renderer, it
   * is ignorant of the individual chart options and must be set globally.
   *
   * @see    In styled mode, general chart styles can be set with the
   *         `.highcharts-root` class.
   * @sample {highcharts} highcharts/chart/style-serif-font/
   *         Using a serif type font
   * @sample {highcharts} highcharts/css/em/
   *         Styled mode with relative font sizes
   * @sample {highstock} stock/chart/style/
   *         Using a serif type font
   * @sample {highmaps} maps/chart/style-serif-font/
   *         Using a serif type font
   *
   * @type      {Highcharts.CSSObject}
   * @default   {"fontFamily": "\"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, Arial, Helvetica, sans-serif","fontSize":"12px"}
   * @apioption chart.style
   */
  /**
   * The default series type for the chart. Can be any of the chart types
   * listed under [plotOptions](#plotOptions) and [series](#series) or can
   * be a series provided by an additional module.
   *
   * In TypeScript this option has no effect in sense of typing and
   * instead the `type` option must always be set in the series.
   *
   * @sample {highcharts} highcharts/chart/type-bar/
   *         Bar
   * @sample {highstock} stock/chart/type/
   *         Areaspline
   * @sample {highmaps} maps/chart/type-mapline/
   *         Mapline
   *
   * @type       {string}
   * @default    {highcharts} line
   * @default    {highstock} line
   * @default    {highmaps} map
   * @since      2.1.0
   * @apioption  chart.type
   */
  /**
   * Decides in what dimensions the user can zoom by dragging the mouse.
   * Can be one of `x`, `y` or `xy`.
   *
   * @see [panKey](#chart.panKey)
   *
   * @sample {highcharts} highcharts/chart/zoomtype-none/
   *         None by default
   * @sample {highcharts} highcharts/chart/zoomtype-x/
   *         X
   * @sample {highcharts} highcharts/chart/zoomtype-y/
   *         Y
   * @sample {highcharts} highcharts/chart/zoomtype-xy/
   *         Xy
   * @sample {highstock} stock/demo/basic-line/
   *         None by default
   * @sample {highstock} stock/chart/zoomtype-x/
   *         X
   * @sample {highstock} stock/chart/zoomtype-y/
   *         Y
   * @sample {highstock} stock/chart/zoomtype-xy/
   *         Xy
   *
   * @type       {string}
   * @product    highcharts highstock gantt
   * @validvalue ["x", "y", "xy"]
   * @apioption  chart.zoomType
   */
  /**
   * Enables zooming by a single touch, in combination with
   * [chart.zoomType](#chart.zoomType). When enabled, two-finger pinch
   * will still work as set up by [chart.pinchType](#chart.pinchType).
   * However, `zoomBySingleTouch` will interfere with touch-dragging the
   * chart to read the tooltip. And especially when vertical zooming is
   * enabled, it will make it hard to scroll vertically on the page.
   * @since 9.0.0
   * @sample     highcharts/chart/zoombysingletouch
   *             Zoom by single touch enabled, with buttons to toggle
   * @product    highcharts highstock gantt
   */
  zoomBySingleTouch: false,
  /**
   * An explicit width for the chart. By default (when `null`) the width
   * is calculated from the offset width of the containing element.
   *
   * @sample {highcharts} highcharts/chart/width/
   *         800px wide
   * @sample {highstock} stock/chart/width/
   *         800px wide
   * @sample {highmaps} maps/chart/size/
   *         Chart with explicit size
   *
   * @type {null|number|string}
   */
  width: null,
  /**
   * An explicit height for the chart. If a _number_, the height is
   * given in pixels. If given a _percentage string_ (for example
   * `'56%'`), the height is given as the percentage of the actual chart
   * width. This allows for preserving the aspect ratio across responsive
   * sizes.
   *
   * By default (when `null`) the height is calculated from the offset
   * height of the containing element, or 400 pixels if the containing
   * element's height is 0.
   *
   * @sample {highcharts} highcharts/chart/height/
   *         500px height
   * @sample {highstock} stock/chart/height/
   *         300px height
   * @sample {highmaps} maps/chart/size/
   *         Chart with explicit size
   * @sample highcharts/chart/height-percent/
   *         Highcharts with percentage height
   *
   * @type {null|number|string}
   */
  height: null,
  /**
   * The color of the outer chart border.
   *
   * @see In styled mode, the stroke is set with the
   *      `.highcharts-background` class.
   *
   * @sample {highcharts} highcharts/chart/bordercolor/
   *         Brown border
   * @sample {highstock} stock/chart/border/
   *         Brown border
   * @sample {highmaps} maps/chart/border/
   *         Border options
   *
   * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   */
  borderColor: palette.highlightColor80,
  /**
   * The pixel width of the outer chart border.
   *
   * @see In styled mode, the stroke is set with the
   *      `.highcharts-background` class.
   *
   * @sample {highcharts} highcharts/chart/borderwidth/
   *         5px border
   * @sample {highstock} stock/chart/border/
   *         2px border
   * @sample {highmaps} maps/chart/border/
   *         Border options
   *
   * @type      {number}
   * @default   0
   * @apioption chart.borderWidth
   */
  /**
   * The background color or gradient for the outer chart area.
   *
   * @see In styled mode, the background is set with the
   *      `.highcharts-background` class.
   *
   * @sample {highcharts} highcharts/chart/backgroundcolor-color/
   *         Color
   * @sample {highcharts} highcharts/chart/backgroundcolor-gradient/
   *         Gradient
   * @sample {highstock} stock/chart/backgroundcolor-color/
   *         Color
   * @sample {highstock} stock/chart/backgroundcolor-gradient/
   *         Gradient
   * @sample {highmaps} maps/chart/backgroundcolor-color/
   *         Color
   * @sample {highmaps} maps/chart/backgroundcolor-gradient/
   *         Gradient
   *
   * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   */
  backgroundColor: palette.backgroundColor,
  /**
   * The background color or gradient for the plot area.
   *
   * @see In styled mode, the plot background is set with the
   *      `.highcharts-plot-background` class.
   *
   * @sample {highcharts} highcharts/chart/plotbackgroundcolor-color/
   *         Color
   * @sample {highcharts} highcharts/chart/plotbackgroundcolor-gradient/
   *         Gradient
   * @sample {highstock} stock/chart/plotbackgroundcolor-color/
   *         Color
   * @sample {highstock} stock/chart/plotbackgroundcolor-gradient/
   *         Gradient
   * @sample {highmaps} maps/chart/plotbackgroundcolor-color/
   *         Color
   * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
   *         Gradient
   *
   * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   * @apioption chart.plotBackgroundColor
   */
  /**
   * The URL for an image to use as the plot background. To set an image
   * as the background for the entire chart, set a CSS background image
   * to the container element. Note that for the image to be applied to
   * exported charts, its URL needs to be accessible by the export server.
   *
   * @see In styled mode, a plot background image can be set with the
   *      `.highcharts-plot-background` class and a [custom pattern](
   *      https://www.highcharts.com/docs/chart-design-and-style/
   *      gradients-shadows-and-patterns).
   *
   * @sample {highcharts} highcharts/chart/plotbackgroundimage/
   *         Skies
   * @sample {highstock} stock/chart/plotbackgroundimage/
   *         Skies
   *
   * @type      {string}
   * @apioption chart.plotBackgroundImage
   */
  /**
   * The color of the inner chart or plot area border.
   *
   * @see In styled mode, a plot border stroke can be set with the
   *      `.highcharts-plot-border` class.
   *
   * @sample {highcharts} highcharts/chart/plotbordercolor/
   *         Blue border
   * @sample {highstock} stock/chart/plotborder/
   *         Blue border
   * @sample {highmaps} maps/chart/plotborder/
   *         Plot border options
   *
   * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
   */
  plotBorderColor: palette.neutralColor20
};
var isNumber$W = Utilities.isNumber, merge$1w = Utilities.merge, pInt$9 = Utilities.pInt;
var Color = (
  /** @class */
  (function() {
    function Color2(input) {
      this.rgba = [NaN, NaN, NaN, NaN];
      this.input = input;
      var GlobalColor = H.Color;
      if (GlobalColor && GlobalColor !== Color2) {
        return new GlobalColor(input);
      }
      if (!(this instanceof Color2)) {
        return new Color2(input);
      }
      this.init(input);
    }
    Color2.parse = function(input) {
      return input ? new Color2(input) : Color2.None;
    };
    Color2.prototype.init = function(input) {
      var result2, rgba, i2, parser;
      if (typeof input === "object" && typeof input.stops !== "undefined") {
        this.stops = input.stops.map(function(stop2) {
          return new Color2(stop2[1]);
        });
      } else if (typeof input === "string") {
        this.input = input = Color2.names[input.toLowerCase()] || input;
        if (input.charAt(0) === "#") {
          var len = input.length, col = parseInt(input.substr(1), 16);
          if (len === 7) {
            rgba = [
              (col & 16711680) >> 16,
              (col & 65280) >> 8,
              col & 255,
              1
            ];
          } else if (len === 4) {
            rgba = [
              (col & 3840) >> 4 | (col & 3840) >> 8,
              (col & 240) >> 4 | col & 240,
              (col & 15) << 4 | col & 15,
              1
            ];
          }
        }
        if (!rgba) {
          i2 = Color2.parsers.length;
          while (i2-- && !rgba) {
            parser = Color2.parsers[i2];
            result2 = parser.regex.exec(input);
            if (result2) {
              rgba = parser.parse(result2);
            }
          }
        }
      }
      if (rgba) {
        this.rgba = rgba;
      }
    };
    Color2.prototype.get = function(format2) {
      var input = this.input, rgba = this.rgba;
      if (typeof input === "object" && typeof this.stops !== "undefined") {
        var ret_1 = merge$1w(input);
        ret_1.stops = [].slice.call(ret_1.stops);
        this.stops.forEach(function(stop2, i2) {
          ret_1.stops[i2] = [
            ret_1.stops[i2][0],
            stop2.get(format2)
          ];
        });
        return ret_1;
      }
      if (rgba && isNumber$W(rgba[0])) {
        if (format2 === "rgb" || !format2 && rgba[3] === 1) {
          return "rgb(" + rgba[0] + "," + rgba[1] + "," + rgba[2] + ")";
        }
        if (format2 === "a") {
          return "" + rgba[3];
        }
        return "rgba(" + rgba.join(",") + ")";
      }
      return input;
    };
    Color2.prototype.brighten = function(alpha) {
      var rgba = this.rgba;
      if (this.stops) {
        this.stops.forEach(function(stop2) {
          stop2.brighten(alpha);
        });
      } else if (isNumber$W(alpha) && alpha !== 0) {
        for (var i2 = 0; i2 < 3; i2++) {
          rgba[i2] += pInt$9(alpha * 255);
          if (rgba[i2] < 0) {
            rgba[i2] = 0;
          }
          if (rgba[i2] > 255) {
            rgba[i2] = 255;
          }
        }
      }
      return this;
    };
    Color2.prototype.setOpacity = function(alpha) {
      this.rgba[3] = alpha;
      return this;
    };
    Color2.prototype.tweenTo = function(to, pos) {
      var fromRgba = this.rgba, toRgba = to.rgba;
      if (!isNumber$W(fromRgba[0]) || !isNumber$W(toRgba[0])) {
        return to.input || "none";
      }
      var hasAlpha = toRgba[3] !== 1 || fromRgba[3] !== 1;
      return (hasAlpha ? "rgba(" : "rgb(") + Math.round(toRgba[0] + (fromRgba[0] - toRgba[0]) * (1 - pos)) + "," + Math.round(toRgba[1] + (fromRgba[1] - toRgba[1]) * (1 - pos)) + "," + Math.round(toRgba[2] + (fromRgba[2] - toRgba[2]) * (1 - pos)) + (hasAlpha ? "," + (toRgba[3] + (fromRgba[3] - toRgba[3]) * (1 - pos)) : "") + ")";
    };
    Color2.names = {
      white: "#ffffff",
      black: "#000000"
    };
    Color2.parsers = [{
      // RGBA color
      // eslint-disable-next-line max-len
      regex: /rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,
      parse: function(result2) {
        return [
          pInt$9(result2[1]),
          pInt$9(result2[2]),
          pInt$9(result2[3]),
          parseFloat(result2[4], 10)
        ];
      }
    }, {
      // RGB color
      regex: /rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,
      parse: function(result2) {
        return [pInt$9(result2[1]), pInt$9(result2[2]), pInt$9(result2[3]), 1];
      }
    }];
    Color2.None = new Color2("");
    return Color2;
  })()
);
var win$f = H.win;
var defined$Z = Utilities.defined, error$b = Utilities.error, extend$1x = Utilities.extend, isObject$h = Utilities.isObject, merge$1v = Utilities.merge, objectEach$C = Utilities.objectEach, pad$1 = Utilities.pad, pick$1J = Utilities.pick, splat$k = Utilities.splat, timeUnits$3 = Utilities.timeUnits;
var hasNewSafariBug = H.isSafari && win$f.Intl && win$f.Intl.DateTimeFormat.prototype.formatRange;
var hasOldSafariBug = H.isSafari && win$f.Intl && !win$f.Intl.DateTimeFormat.prototype.formatRange;
var Time = (
  /** @class */
  (function() {
    function Time2(options) {
      this.options = {};
      this.useUTC = false;
      this.variableTimezone = false;
      this.Date = win$f.Date;
      this.getTimezoneOffset = this.timezoneOffsetFunction();
      this.update(options);
    }
    Time2.prototype.get = function(unit, date) {
      if (this.variableTimezone || this.timezoneOffset) {
        var realMs = date.getTime();
        var ms = realMs - this.getTimezoneOffset(date);
        date.setTime(ms);
        var ret = date["getUTC" + unit]();
        date.setTime(realMs);
        return ret;
      }
      if (this.useUTC) {
        return date["getUTC" + unit]();
      }
      return date["get" + unit]();
    };
    Time2.prototype.set = function(unit, date, value) {
      if (this.variableTimezone || this.timezoneOffset) {
        if (unit === "Milliseconds" || unit === "Seconds" || unit === "Minutes" && this.getTimezoneOffset(date) % 36e5 === 0) {
          return date["setUTC" + unit](value);
        }
        var offset2 = this.getTimezoneOffset(date);
        var ms = date.getTime() - offset2;
        date.setTime(ms);
        date["setUTC" + unit](value);
        var newOffset = this.getTimezoneOffset(date);
        ms = date.getTime() + newOffset;
        return date.setTime(ms);
      }
      if (this.useUTC || hasNewSafariBug && unit === "FullYear") {
        return date["setUTC" + unit](value);
      }
      return date["set" + unit](value);
    };
    Time2.prototype.update = function(options) {
      var useUTC = pick$1J(options && options.useUTC, true);
      this.options = options = merge$1v(true, this.options || {}, options);
      this.Date = options.Date || win$f.Date || Date;
      this.useUTC = useUTC;
      this.timezoneOffset = useUTC && options.timezoneOffset;
      this.getTimezoneOffset = this.timezoneOffsetFunction();
      this.variableTimezone = useUTC && !!(options.getTimezoneOffset || options.timezone);
    };
    Time2.prototype.makeTime = function(year, month, date, hours, minutes, seconds) {
      var d, offset2, newOffset;
      if (this.useUTC) {
        d = this.Date.UTC.apply(0, arguments);
        offset2 = this.getTimezoneOffset(d);
        d += offset2;
        newOffset = this.getTimezoneOffset(d);
        if (offset2 !== newOffset) {
          d += newOffset - offset2;
        } else if (offset2 - 36e5 === this.getTimezoneOffset(d - 36e5) && !hasOldSafariBug) {
          d -= 36e5;
        }
      } else {
        d = new this.Date(year, month, pick$1J(date, 1), pick$1J(hours, 0), pick$1J(minutes, 0), pick$1J(seconds, 0)).getTime();
      }
      return d;
    };
    Time2.prototype.timezoneOffsetFunction = function() {
      var time = this, options = this.options, moment = options.moment || win$f.moment;
      if (!this.useUTC) {
        return function(timestamp) {
          return new Date(timestamp.toString()).getTimezoneOffset() * 6e4;
        };
      }
      if (options.timezone) {
        if (!moment) {
          error$b(25);
        } else {
          return function(timestamp) {
            return -moment.tz(timestamp, options.timezone).utcOffset() * 6e4;
          };
        }
      }
      if (this.useUTC && options.getTimezoneOffset) {
        return function(timestamp) {
          return options.getTimezoneOffset(timestamp.valueOf()) * 6e4;
        };
      }
      return function() {
        return (time.timezoneOffset || 0) * 6e4;
      };
    };
    Time2.prototype.dateFormat = function(format2, timestamp, capitalize2) {
      if (!defined$Z(timestamp) || isNaN(timestamp)) {
        return H.defaultOptions.lang && H.defaultOptions.lang.invalidDate || "";
      }
      format2 = pick$1J(format2, "%Y-%m-%d %H:%M:%S");
      var time = this, date = new this.Date(timestamp), hours = this.get("Hours", date), day = this.get("Day", date), dayOfMonth = this.get("Date", date), month = this.get("Month", date), fullYear = this.get("FullYear", date), lang2 = H.defaultOptions.lang, langWeekdays = lang2 && lang2.weekdays, shortWeekdays = lang2 && lang2.shortWeekdays, replacements = extend$1x({
        // Day
        // Short weekday, like 'Mon'
        a: shortWeekdays ? shortWeekdays[day] : langWeekdays[day].substr(0, 3),
        // Long weekday, like 'Monday'
        A: langWeekdays[day],
        // Two digit day of the month, 01 to 31
        d: pad$1(dayOfMonth),
        // Day of the month, 1 through 31
        e: pad$1(dayOfMonth, 2, " "),
        // Day of the week, 0 through 6
        w: day,
        // Week (none implemented)
        // 'W': weekNumber(),
        // Month
        // Short month, like 'Jan'
        b: lang2.shortMonths[month],
        // Long month, like 'January'
        B: lang2.months[month],
        // Two digit month number, 01 through 12
        m: pad$1(month + 1),
        // Month number, 1 through 12 (#8150)
        o: month + 1,
        // Year
        // Two digits year, like 09 for 2009
        y: fullYear.toString().substr(2, 2),
        // Four digits year, like 2009
        Y: fullYear,
        // Time
        // Two digits hours in 24h format, 00 through 23
        H: pad$1(hours),
        // Hours in 24h format, 0 through 23
        k: hours,
        // Two digits hours in 12h format, 00 through 11
        I: pad$1(hours % 12 || 12),
        // Hours in 12h format, 1 through 12
        l: hours % 12 || 12,
        // Two digits minutes, 00 through 59
        M: pad$1(this.get("Minutes", date)),
        // Upper case AM or PM
        p: hours < 12 ? "AM" : "PM",
        // Lower case AM or PM
        P: hours < 12 ? "am" : "pm",
        // Two digits seconds, 00 through  59
        S: pad$1(date.getSeconds()),
        // Milliseconds (naming from Ruby)
        L: pad$1(Math.floor(timestamp % 1e3), 3)
      }, H.dateFormats);
      objectEach$C(replacements, function(val, key2) {
        while (format2.indexOf("%" + key2) !== -1) {
          format2 = format2.replace("%" + key2, typeof val === "function" ? val.call(time, timestamp) : val);
        }
      });
      return capitalize2 ? format2.substr(0, 1).toUpperCase() + format2.substr(1) : format2;
    };
    Time2.prototype.resolveDTLFormat = function(f) {
      if (!isObject$h(f, true)) {
        f = splat$k(f);
        return {
          main: f[0],
          from: f[1],
          to: f[2]
        };
      }
      return f;
    };
    Time2.prototype.getTimeTicks = function(normalizedInterval, min2, max2, startOfWeek2) {
      var time = this, Date2 = time.Date, tickPositions = [], higherRanks = {}, minDate = new Date2(min2), interval = normalizedInterval.unitRange, count = normalizedInterval.count || 1;
      var i2, minYear, variableDayLength, minDay;
      startOfWeek2 = pick$1J(startOfWeek2, 1);
      if (defined$Z(min2)) {
        time.set("Milliseconds", minDate, interval >= timeUnits$3.second ? 0 : (
          // #3935
          count * Math.floor(time.get("Milliseconds", minDate) / count)
        ));
        if (interval >= timeUnits$3.second) {
          time.set("Seconds", minDate, interval >= timeUnits$3.minute ? 0 : (
            // #3935
            count * Math.floor(time.get("Seconds", minDate) / count)
          ));
        }
        if (interval >= timeUnits$3.minute) {
          time.set("Minutes", minDate, interval >= timeUnits$3.hour ? 0 : count * Math.floor(time.get("Minutes", minDate) / count));
        }
        if (interval >= timeUnits$3.hour) {
          time.set("Hours", minDate, interval >= timeUnits$3.day ? 0 : count * Math.floor(time.get("Hours", minDate) / count));
        }
        if (interval >= timeUnits$3.day) {
          time.set("Date", minDate, interval >= timeUnits$3.month ? 1 : Math.max(1, count * Math.floor(time.get("Date", minDate) / count)));
        }
        if (interval >= timeUnits$3.month) {
          time.set("Month", minDate, interval >= timeUnits$3.year ? 0 : count * Math.floor(time.get("Month", minDate) / count));
          minYear = time.get("FullYear", minDate);
        }
        if (interval >= timeUnits$3.year) {
          minYear -= minYear % count;
          time.set("FullYear", minDate, minYear);
        }
        if (interval === timeUnits$3.week) {
          minDay = time.get("Day", minDate);
          time.set("Date", minDate, time.get("Date", minDate) - minDay + startOfWeek2 + // We don't want to skip days that are before
          // startOfWeek (#7051)
          (minDay < startOfWeek2 ? -7 : 0));
        }
        minYear = time.get("FullYear", minDate);
        var minMonth = time.get("Month", minDate), minDateDate = time.get("Date", minDate), minHours = time.get("Hours", minDate);
        min2 = minDate.getTime();
        if ((time.variableTimezone || !time.useUTC) && defined$Z(max2)) {
          variableDayLength = // Long range, assume we're crossing over.
          max2 - min2 > 4 * timeUnits$3.month || // Short range, check if min and max are in different time
          // zones.
          time.getTimezoneOffset(min2) !== time.getTimezoneOffset(max2);
        }
        var t = minDate.getTime();
        i2 = 1;
        while (t < max2) {
          tickPositions.push(t);
          if (interval === timeUnits$3.year) {
            t = time.makeTime(minYear + i2 * count, 0);
          } else if (interval === timeUnits$3.month) {
            t = time.makeTime(minYear, minMonth + i2 * count);
          } else if (variableDayLength && (interval === timeUnits$3.day || interval === timeUnits$3.week)) {
            t = time.makeTime(minYear, minMonth, minDateDate + i2 * count * (interval === timeUnits$3.day ? 1 : 7));
          } else if (variableDayLength && interval === timeUnits$3.hour && count > 1) {
            t = time.makeTime(minYear, minMonth, minDateDate, minHours + i2 * count);
          } else {
            t += interval * count;
          }
          i2++;
        }
        tickPositions.push(t);
        if (interval <= timeUnits$3.hour && tickPositions.length < 1e4) {
          tickPositions.forEach(function(t2) {
            if (
              // Speed optimization, no need to run dateFormat unless
              // we're on a full or half hour
              t2 % 18e5 === 0 && // Check for local or global midnight
              time.dateFormat("%H%M%S%L", t2) === "000000000"
            ) {
              higherRanks[t2] = "day";
            }
          });
        }
      }
      tickPositions.info = extend$1x(normalizedInterval, {
        higherRanks,
        totalRange: interval * count
      });
      return tickPositions;
    };
    Time2.prototype.getDateFormat = function(range, timestamp, startOfWeek2, dateTimeLabelFormats) {
      var dateStr = this.dateFormat("%m-%d %H:%M:%S.%L", timestamp), blank = "01-01 00:00:00.000", strpos = {
        millisecond: 15,
        second: 12,
        minute: 9,
        hour: 6,
        day: 3
      };
      var format2, n2, lastN = "millisecond";
      for (n2 in timeUnits$3) {
        if (range === timeUnits$3.week && +this.dateFormat("%w", timestamp) === startOfWeek2 && dateStr.substr(6) === blank.substr(6)) {
          n2 = "week";
          break;
        }
        if (timeUnits$3[n2] > range) {
          n2 = lastN;
          break;
        }
        if (strpos[n2] && dateStr.substr(strpos[n2]) !== blank.substr(strpos[n2])) {
          break;
        }
        if (n2 !== "week") {
          lastN = n2;
        }
      }
      if (n2) {
        format2 = this.resolveDTLFormat(dateTimeLabelFormats[n2]).main;
      }
      return format2;
    };
    return Time2;
  })()
);
var color$g = Color.parse;
var isTouchDevice$4 = H.isTouchDevice, svg$7 = H.svg;
var merge$1u = Utilities.merge;
var defaultOptions$j = {
  /**
   * An array containing the default colors for the chart's series. When
   * all colors are used, new colors are pulled from the start again.
   *
   * Default colors can also be set on a series or series.type basis,
   * see [column.colors](#plotOptions.column.colors),
   * [pie.colors](#plotOptions.pie.colors).
   *
   * In styled mode, the colors option doesn't exist. Instead, colors
   * are defined in CSS and applied either through series or point class
   * names, or through the [chart.colorCount](#chart.colorCount) option.
   *
   *
   * ### Legacy
   *
   * In Highcharts 3.x, the default colors were:
   * ```js
   * colors: ['#2f7ed8', '#0d233a', '#8bbc21', '#910000', '#1aadce',
   *         '#492970', '#f28f43', '#77a1e5', '#c42525', '#a6c96a']
   * ```
   *
   * In Highcharts 2.x, the default colors were:
   * ```js
   * colors: ['#4572A7', '#AA4643', '#89A54E', '#80699B', '#3D96AE',
   *         '#DB843D', '#92A8CD', '#A47D7C', '#B5CA92']
   * ```
   *
   * @sample {highcharts} highcharts/chart/colors/
   *         Assign a global color theme
   *
   * @type    {Array<Highcharts.ColorString>}
   * @default ["#7cb5ec", "#434348", "#90ed7d", "#f7a35c", "#8085e9",
   *          "#f15c80", "#e4d354", "#2b908f", "#f45b5b", "#91e8e1"]
   */
  colors: palette.colors,
  /**
   * Styled mode only. Configuration object for adding SVG definitions for
   * reusable elements. See [gradients, shadows and
   * patterns](https://www.highcharts.com/docs/chart-design-and-style/gradients-shadows-and-patterns)
   * for more information and code examples.
   *
   * @type      {*}
   * @since     5.0.0
   * @apioption defs
   */
  /**
   * @ignore-option
   */
  symbols: ["circle", "diamond", "square", "triangle", "triangle-down"],
  /**
   * The language object is global and it can't be set on each chart
   * initialization. Instead, use `Highcharts.setOptions` to set it before any
   * chart is initialized.
   *
   * ```js
   * Highcharts.setOptions({
   *     lang: {
   *         months: [
   *             'Janvier', 'Février', 'Mars', 'Avril',
   *             'Mai', 'Juin', 'Juillet', 'Août',
   *             'Septembre', 'Octobre', 'Novembre', 'Décembre'
   *         ],
   *         weekdays: [
   *             'Dimanche', 'Lundi', 'Mardi', 'Mercredi',
   *             'Jeudi', 'Vendredi', 'Samedi'
   *         ]
   *     }
   * });
   * ```
   */
  lang: {
    /**
     * The loading text that appears when the chart is set into the loading
     * state following a call to `chart.showLoading`.
     */
    loading: "Loading...",
    /**
     * An array containing the months names. Corresponds to the `%B` format
     * in `Highcharts.dateFormat()`.
     *
     * @type    {Array<string>}
     * @default ["January", "February", "March", "April", "May", "June",
     *          "July", "August", "September", "October", "November",
     *          "December"]
     */
    months: [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December"
    ],
    /**
     * An array containing the months names in abbreviated form. Corresponds
     * to the `%b` format in `Highcharts.dateFormat()`.
     *
     * @type    {Array<string>}
     * @default ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
     *          "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
     */
    shortMonths: [
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec"
    ],
    /**
     * An array containing the weekday names.
     *
     * @type    {Array<string>}
     * @default ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
     *          "Friday", "Saturday"]
     */
    weekdays: [
      "Sunday",
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday"
    ],
    /**
     * Short week days, starting Sunday. If not specified, Highcharts uses
     * the first three letters of the `lang.weekdays` option.
     *
     * @sample highcharts/lang/shortweekdays/
     *         Finnish two-letter abbreviations
     *
     * @type      {Array<string>}
     * @since     4.2.4
     * @apioption lang.shortWeekdays
     */
    /**
     * What to show in a date field for invalid dates. Defaults to an empty
     * string.
     *
     * @type      {string}
     * @since     4.1.8
     * @product   highcharts highstock
     * @apioption lang.invalidDate
     */
    /**
     * The title appearing on hovering the zoom in button. The text itself
     * defaults to "+" and can be changed in the button options.
     *
     * @type      {string}
     * @default   Zoom in
     * @product   highmaps
     * @apioption lang.zoomIn
     */
    /**
     * The title appearing on hovering the zoom out button. The text itself
     * defaults to "-" and can be changed in the button options.
     *
     * @type      {string}
     * @default   Zoom out
     * @product   highmaps
     * @apioption lang.zoomOut
     */
    /**
     * The default decimal point used in the `Highcharts.numberFormat`
     * method unless otherwise specified in the function arguments.
     *
     * @since 1.2.2
     */
    decimalPoint: ".",
    /**
     * [Metric prefixes](https://en.wikipedia.org/wiki/Metric_prefix) used
     * to shorten high numbers in axis labels. Replacing any of the
     * positions with `null` causes the full number to be written. Setting
     * `numericSymbols` to `null` disables shortening altogether.
     *
     * @sample {highcharts} highcharts/lang/numericsymbols/
     *         Replacing the symbols with text
     * @sample {highstock} highcharts/lang/numericsymbols/
     *         Replacing the symbols with text
     *
     * @type    {Array<string>}
     * @default ["k", "M", "G", "T", "P", "E"]
     * @since   2.3.0
     */
    numericSymbols: ["k", "M", "G", "T", "P", "E"],
    /**
     * The magnitude of [numericSymbols](#lang.numericSymbol) replacements.
     * Use 10000 for Japanese, Korean and various Chinese locales, which
     * use symbols for 10^4, 10^8 and 10^12.
     *
     * @sample highcharts/lang/numericsymbolmagnitude/
     *         10000 magnitude for Japanese
     *
     * @type      {number}
     * @default   1000
     * @since     5.0.3
     * @apioption lang.numericSymbolMagnitude
     */
    /**
     * The text for the label appearing when a chart is zoomed.
     *
     * @since 1.2.4
     */
    resetZoom: "Reset zoom",
    /**
     * The tooltip title for the label appearing when a chart is zoomed.
     *
     * @since 1.2.4
     */
    resetZoomTitle: "Reset zoom level 1:1",
    /**
     * The default thousands separator used in the `Highcharts.numberFormat`
     * method unless otherwise specified in the function arguments. Defaults
     * to a single space character, which is recommended in
     * [ISO 31-0](https://en.wikipedia.org/wiki/ISO_31-0#Numbers) and works
     * across Anglo-American and continental European languages.
     *
     * @default \u0020
     * @since   1.2.2
     */
    thousandsSep: " "
  },
  /**
   * Global options that don't apply to each chart. These options, like
   * the `lang` options, must be set using the `Highcharts.setOptions`
   * method.
   *
   * ```js
   * Highcharts.setOptions({
   *     global: {
   *         useUTC: false
   *     }
   * });
   * ```
   */
  /**
   * _Canvg rendering for Android 2.x is removed as of Highcharts 5.0\.
   * Use the [libURL](#exporting.libURL) option to configure exporting._
   *
   * The URL to the additional file to lazy load for Android 2.x devices.
   * These devices don't support SVG, so we download a helper file that
   * contains [canvg](https://github.com/canvg/canvg), its dependency
   * rbcolor, and our own CanVG Renderer class. To avoid hotlinking to
   * our site, you can install canvas-tools.js on your own server and
   * change this option accordingly.
   *
   * @deprecated
   *
   * @type      {string}
   * @default   https://code.highcharts.com/{version}/modules/canvas-tools.js
   * @product   highcharts highmaps
   * @apioption global.canvasToolsURL
   */
  /**
   * This option is deprecated since v6.0.5. Instead, use
   * [time.useUTC](#time.useUTC) that supports individual time settings
   * per chart.
   *
   * @deprecated
   *
   * @type      {boolean}
   * @apioption global.useUTC
   */
  /**
   * This option is deprecated since v6.0.5. Instead, use
   * [time.Date](#time.Date) that supports individual time settings
   * per chart.
   *
   * @deprecated
   *
   * @type      {Function}
   * @product   highcharts highstock
   * @apioption global.Date
   */
  /**
   * This option is deprecated since v6.0.5. Instead, use
   * [time.getTimezoneOffset](#time.getTimezoneOffset) that supports
   * individual time settings per chart.
   *
   * @deprecated
   *
   * @type      {Function}
   * @product   highcharts highstock
   * @apioption global.getTimezoneOffset
   */
  /**
   * This option is deprecated since v6.0.5. Instead, use
   * [time.timezone](#time.timezone) that supports individual time
   * settings per chart.
   *
   * @deprecated
   *
   * @type      {string}
   * @product   highcharts highstock
   * @apioption global.timezone
   */
  /**
   * This option is deprecated since v6.0.5. Instead, use
   * [time.timezoneOffset](#time.timezoneOffset) that supports individual
   * time settings per chart.
   *
   * @deprecated
   *
   * @type      {number}
   * @product   highcharts highstock
   * @apioption global.timezoneOffset
   */
  global: {},
  /**
   * Time options that can apply globally or to individual charts. These
   * settings affect how `datetime` axes are laid out, how tooltips are
   * formatted, how series
   * [pointIntervalUnit](#plotOptions.series.pointIntervalUnit) works and how
   * the Highcharts Stock range selector handles time.
   *
   * The common use case is that all charts in the same Highcharts object
   * share the same time settings, in which case the global settings are set
   * using `setOptions`.
   *
   * ```js
   * // Apply time settings globally
   * Highcharts.setOptions({
   *     time: {
   *         timezone: 'Europe/London'
   *     }
   * });
   * // Apply time settings by instance
   * let chart = Highcharts.chart('container', {
   *     time: {
   *         timezone: 'America/New_York'
   *     },
   *     series: [{
   *         data: [1, 4, 3, 5]
   *     }]
   * });
   *
   * // Use the Time object
   * console.log(
   *        'Current time in New York',
   *        chart.time.dateFormat('%Y-%m-%d %H:%M:%S', Date.now())
   * );
   * ```
   *
   * Since v6.0.5, the time options were moved from the `global` obect to the
   * `time` object, and time options can be set on each individual chart.
   *
   * @sample {highcharts|highstock}
   *         highcharts/time/timezone/
   *         Set the timezone globally
   * @sample {highcharts}
   *         highcharts/time/individual/
   *         Set the timezone per chart instance
   * @sample {highstock}
   *         stock/time/individual/
   *         Set the timezone per chart instance
   *
   * @since     6.0.5
   * @optionparent time
   */
  time: {
    /**
     * A custom `Date` class for advanced date handling. For example,
     * [JDate](https://github.com/tahajahangir/jdate) can be hooked in to
     * handle Jalali dates.
     *
     * @type      {*}
     * @since     4.0.4
     * @product   highcharts highstock gantt
     */
    Date: void 0,
    /**
     * A callback to return the time zone offset for a given datetime. It
     * takes the timestamp in terms of milliseconds since January 1 1970,
     * and returns the timezone offset in minutes. This provides a hook
     * for drawing time based charts in specific time zones using their
     * local DST crossover dates, with the help of external libraries.
     *
     * @see [global.timezoneOffset](#global.timezoneOffset)
     *
     * @sample {highcharts|highstock} highcharts/time/gettimezoneoffset/
     *         Use moment.js to draw Oslo time regardless of browser locale
     *
     * @type      {Highcharts.TimezoneOffsetCallbackFunction}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     */
    getTimezoneOffset: void 0,
    /**
     * Requires [moment.js](https://momentjs.com/). If the timezone option
     * is specified, it creates a default
     * [getTimezoneOffset](#time.getTimezoneOffset) function that looks
     * up the specified timezone in moment.js. If moment.js is not included,
     * this throws a Highcharts error in the console, but does not crash the
     * chart.
     *
     * @see [getTimezoneOffset](#time.getTimezoneOffset)
     *
     * @sample {highcharts|highstock} highcharts/time/timezone/
     *         Europe/Oslo
     *
     * @type      {string}
     * @since     5.0.7
     * @product   highcharts highstock gantt
     */
    timezone: void 0,
    /**
     * The timezone offset in minutes. Positive values are west, negative
     * values are east of UTC, as in the ECMAScript
     * [getTimezoneOffset](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTimezoneOffset)
     * method. Use this to display UTC based data in a predefined time zone.
     *
     * @see [time.getTimezoneOffset](#time.getTimezoneOffset)
     *
     * @sample {highcharts|highstock} highcharts/time/timezoneoffset/
     *         Timezone offset
     *
     * @since     3.0.8
     * @product   highcharts highstock gantt
     */
    timezoneOffset: 0,
    /**
     * Whether to use UTC time for axis scaling, tickmark placement and
     * time display in `Highcharts.dateFormat`. Advantages of using UTC
     * is that the time displays equally regardless of the user agent's
     * time zone settings. Local time can be used when the data is loaded
     * in real time or when correct Daylight Saving Time transitions are
     * required.
     *
     * @sample {highcharts} highcharts/time/useutc-true/
     *         True by default
     * @sample {highcharts} highcharts/time/useutc-false/
     *         False
     */
    useUTC: true
  },
  chart: ChartDefaults,
  /**
   * The chart's main title.
   *
   * @sample {highmaps} maps/title/title/
   *         Title options demonstrated
   */
  title: {
    /**
     * When the title is floating, the plot area will not move to make space
     * for it.
     *
     * @sample {highcharts} highcharts/chart/zoomtype-none/
     *         False by default
     * @sample {highcharts} highcharts/title/floating/
     *         True - title on top of the plot area
     * @sample {highstock} stock/chart/title-floating/
     *         True - title on top of the plot area
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @apioption title.floating
     */
    /**
     * CSS styles for the title. Use this for font styling, but use `align`,
     * `x` and `y` for text alignment.
     *
     * In styled mode, the title style is given in the `.highcharts-title`
     * class.
     *
     * @sample {highcharts} highcharts/title/style/
     *         Custom color and weight
     * @sample {highstock} stock/chart/title-style/
     *         Custom color and weight
     * @sample highcharts/css/titles/
     *         Styled mode
     *
     * @type      {Highcharts.CSSObject}
     * @default   {highcharts|highmaps} { "color": "#333333", "fontSize": "18px" }
     * @default   {highstock} { "color": "#333333", "fontSize": "16px" }
     * @apioption title.style
     */
    /**
     * Whether to
     * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the text.
     *
     * @type      {boolean}
     * @default   false
     * @apioption title.useHTML
     */
    /**
     * The vertical alignment of the title. Can be one of `"top"`,
     * `"middle"` and `"bottom"`. When a value is given, the title behaves
     * as if [floating](#title.floating) were `true`.
     *
     * @sample {highcharts} highcharts/title/verticalalign/
     *         Chart title in bottom right corner
     * @sample {highstock} stock/chart/title-verticalalign/
     *         Chart title in bottom right corner
     *
     * @type      {Highcharts.VerticalAlignValue}
     * @since     2.1
     * @apioption title.verticalAlign
     */
    /**
     * The x position of the title relative to the alignment within
     * `chart.spacingLeft` and `chart.spacingRight`.
     *
     * @sample {highcharts} highcharts/title/align/
     *         Aligned to the plot area (x = 70px = margin left - spacing
     *         left)
     * @sample {highstock} stock/chart/title-align/
     *         Aligned to the plot area (x = 50px = margin left - spacing
     *         left)
     *
     * @type      {number}
     * @default   0
     * @since     2.0
     * @apioption title.x
     */
    /**
     * The y position of the title relative to the alignment within
     * [chart.spacingTop](#chart.spacingTop) and [chart.spacingBottom](
     * #chart.spacingBottom). By default it depends on the font size.
     *
     * @sample {highcharts} highcharts/title/y/
     *         Title inside the plot area
     * @sample {highstock} stock/chart/title-verticalalign/
     *         Chart title in bottom right corner
     *
     * @type      {number}
     * @since     2.0
     * @apioption title.y
     */
    /**
     * The title of the chart. To disable the title, set the `text` to
     * `undefined`.
     *
     * @sample {highcharts} highcharts/title/text/
     *         Custom title
     * @sample {highstock} stock/chart/title-text/
     *         Custom title
     *
     * @default {highcharts|highmaps} Chart title
     * @default {highstock} undefined
     */
    text: "Chart title",
    /**
     * The horizontal alignment of the title. Can be one of "left", "center"
     * and "right".
     *
     * @sample {highcharts} highcharts/title/align/
     *         Aligned to the plot area (x = 70px = margin left - spacing
     *         left)
     * @sample {highstock} stock/chart/title-align/
     *         Aligned to the plot area (x = 50px = margin left - spacing
     *         left)
     *
     * @type  {Highcharts.AlignValue}
     * @since 2.0
     */
    align: "center",
    /**
     * The margin between the title and the plot area, or if a subtitle
     * is present, the margin between the subtitle and the plot area.
     *
     * @sample {highcharts} highcharts/title/margin-50/
     *         A chart title margin of 50
     * @sample {highcharts} highcharts/title/margin-subtitle/
     *         The same margin applied with a subtitle
     * @sample {highstock} stock/chart/title-margin/
     *         A chart title margin of 50
     *
     * @since 2.1
     */
    margin: 15,
    /**
     * Adjustment made to the title width, normally to reserve space for
     * the exporting burger menu.
     *
     * @sample highcharts/title/widthadjust/
     *         Wider menu, greater padding
     *
     * @since 4.2.5
     */
    widthAdjust: -44
  },
  /**
   * The chart's subtitle. This can be used both to display a subtitle below
   * the main title, and to display random text anywhere in the chart. The
   * subtitle can be updated after chart initialization through the
   * `Chart.setTitle` method.
   *
   * @sample {highmaps} maps/title/subtitle/
   *         Subtitle options demonstrated
   */
  subtitle: {
    /**
     * When the subtitle is floating, the plot area will not move to make
     * space for it.
     *
     * @sample {highcharts} highcharts/subtitle/floating/
     *         Floating title and subtitle
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote floating at bottom right of plot area
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @apioption subtitle.floating
     */
    /**
     * CSS styles for the title.
     *
     * In styled mode, the subtitle style is given in the
     * `.highcharts-subtitle` class.
     *
     * @sample {highcharts} highcharts/subtitle/style/
     *         Custom color and weight
     * @sample {highcharts} highcharts/css/titles/
     *         Styled mode
     * @sample {highstock} stock/chart/subtitle-style
     *         Custom color and weight
     * @sample {highstock} highcharts/css/titles/
     *         Styled mode
     * @sample {highmaps} highcharts/css/titles/
     *         Styled mode
     *
     * @type      {Highcharts.CSSObject}
     * @default   {"color": "#666666"}
     * @apioption subtitle.style
     */
    /**
     * Whether to
     * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the text.
     *
     * @type      {boolean}
     * @default   false
     * @apioption subtitle.useHTML
     */
    /**
     * The vertical alignment of the title. Can be one of `"top"`,
     * `"middle"` and `"bottom"`. When middle, the subtitle behaves as
     * floating.
     *
     * @sample {highcharts} highcharts/subtitle/verticalalign/
     *         Footnote at the bottom right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at the bottom right of plot area
     *
     * @type      {Highcharts.VerticalAlignValue}
     * @since     2.1
     * @apioption subtitle.verticalAlign
     */
    /**
     * The x position of the subtitle relative to the alignment within
     * `chart.spacingLeft` and `chart.spacingRight`.
     *
     * @sample {highcharts} highcharts/subtitle/align/
     *         Footnote at right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at the bottom right of plot area
     *
     * @type      {number}
     * @default   0
     * @since     2.0
     * @apioption subtitle.x
     */
    /**
     * The y position of the subtitle relative to the alignment within
     * `chart.spacingTop` and `chart.spacingBottom`. By default the subtitle
     * is laid out below the title unless the title is floating.
     *
     * @sample {highcharts} highcharts/subtitle/verticalalign/
     *         Footnote at the bottom right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at the bottom right of plot area
     *
     * @type      {number}
     * @since     2.0
     * @apioption subtitle.y
     */
    /**
     * The subtitle of the chart.
     *
     * @sample {highcharts|highstock} highcharts/subtitle/text/
     *         Custom subtitle
     * @sample {highcharts|highstock} highcharts/subtitle/text-formatted/
     *         Formatted and linked text.
     */
    text: "",
    /**
     * The horizontal alignment of the subtitle. Can be one of "left",
     *  "center" and "right".
     *
     * @sample {highcharts} highcharts/subtitle/align/
     *         Footnote at right of plot area
     * @sample {highstock} stock/chart/subtitle-footnote
     *         Footnote at bottom right of plot area
     *
     * @type  {Highcharts.AlignValue}
     * @since 2.0
     */
    align: "center",
    /**
     * Adjustment made to the subtitle width, normally to reserve space
     * for the exporting burger menu.
     *
     * @see [title.widthAdjust](#title.widthAdjust)
     *
     * @sample highcharts/title/widthadjust/
     *         Wider menu, greater padding
     *
     * @since 4.2.5
     */
    widthAdjust: -44
  },
  /**
   * The chart's caption, which will render below the chart and will be part
   * of exported charts. The caption can be updated after chart initialization
   * through the `Chart.update` or `Chart.caption.update` methods.
   *
   * @sample highcharts/caption/text/
   *         A chart with a caption
   * @since  7.2.0
   */
  caption: {
    /**
     * When the caption is floating, the plot area will not move to make
     * space for it.
     *
     * @type      {boolean}
     * @default   false
     * @apioption caption.floating
     */
    /**
     * The margin between the caption and the plot area.
     */
    margin: 15,
    /**
     * CSS styles for the caption.
     *
     * In styled mode, the caption style is given in the
     * `.highcharts-caption` class.
     *
     * @sample {highcharts} highcharts/css/titles/
     *         Styled mode
     *
     * @type      {Highcharts.CSSObject}
     * @default   {"color": "#666666"}
     * @apioption caption.style
     */
    /**
     * Whether to
     * [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the text.
     *
     * @type      {boolean}
     * @default   false
     * @apioption caption.useHTML
     */
    /**
     * The x position of the caption relative to the alignment within
     * `chart.spacingLeft` and `chart.spacingRight`.
     *
     * @type      {number}
     * @default   0
     * @apioption caption.x
     */
    /**
     * The y position of the caption relative to the alignment within
     * `chart.spacingTop` and `chart.spacingBottom`.
     *
     * @type      {number}
     * @apioption caption.y
     */
    /**
     * The caption text of the chart.
     *
     * @sample {highcharts} highcharts/caption/text/
     *         Custom caption
     */
    text: "",
    /**
     * The horizontal alignment of the caption. Can be one of "left",
     *  "center" and "right".
     *
     * @type  {Highcharts.AlignValue}
     */
    align: "left",
    /**
     * The vertical alignment of the caption. Can be one of `"top"`,
     * `"middle"` and `"bottom"`. When middle, the caption behaves as
     * floating.
     *
     * @type      {Highcharts.VerticalAlignValue}
     */
    verticalAlign: "bottom"
  },
  /**
   * The plotOptions is a wrapper object for config objects for each series
   * type. The config objects for each series can also be overridden for
   * each series item as given in the series array.
   *
   * Configuration options for the series are given in three levels. Options
   * for all series in a chart are given in the [plotOptions.series](
   * #plotOptions.series) object. Then options for all series of a specific
   * type are given in the plotOptions of that type, for example
   * `plotOptions.line`. Next, options for one single series are given in
   * [the series array](#series).
   */
  plotOptions: {},
  /**
   * HTML labels that can be positioned anywhere in the chart area.
   *
   * This option is deprecated since v7.1.2. Instead, use
   * [annotations](#annotations) that support labels.
   *
   * @deprecated
   * @product   highcharts highstock
   */
  labels: {
    /**
     * An HTML label that can be positioned anywhere in the chart area.
     *
     * @deprecated
     * @type      {Array<*>}
     * @apioption labels.items
     */
    /**
     * Inner HTML or text for the label.
     *
     * @deprecated
     * @type      {string}
     * @apioption labels.items.html
     */
    /**
     * CSS styles for each label. To position the label, use left and top
     * like this:
     * ```js
     * style: {
     *     left: '100px',
     *     top: '100px'
     * }
     * ```
     *
     * @deprecated
     * @type      {Highcharts.CSSObject}
     * @apioption labels.items.style
     */
    /**
     * Shared CSS styles for all labels.
     *
     * @deprecated
     * @type    {Highcharts.CSSObject}
     * @default {"color": "#333333", "position": "absolute"}
     */
    style: {
      /**
       * @ignore-option
       */
      position: "absolute",
      /**
       * @ignore-option
       */
      color: palette.neutralColor80
    }
  },
  /**
   * The legend is a box containing a symbol and name for each series
   * item or point item in the chart. Each series (or points in case
   * of pie charts) is represented by a symbol and its name in the legend.
   *
   * It is possible to override the symbol creator function and create
   * [custom legend symbols](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/studies/legend-custom-symbol/).
   *
   * @productdesc {highmaps}
   * A Highmaps legend by default contains one legend item per series, but if
   * a `colorAxis` is defined, the axis will be displayed in the legend.
   * Either as a gradient, or as multiple legend items for `dataClasses`.
   */
  legend: {
    /**
     * The background color of the legend.
     *
     * @see In styled mode, the legend background fill can be applied with
     *      the `.highcharts-legend-box` class.
     *
     * @sample {highcharts} highcharts/legend/backgroundcolor/
     *         Yellowish background
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     * @apioption legend.backgroundColor
     */
    /**
     * The width of the drawn border around the legend.
     *
     * @see In styled mode, the legend border stroke width can be applied
     *      with the `.highcharts-legend-box` class.
     *
     * @sample {highcharts} highcharts/legend/borderwidth/
     *         2px border width
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type      {number}
     * @default   0
     * @apioption legend.borderWidth
     */
    /**
     * Enable or disable the legend. There is also a series-specific option,
     * [showInLegend](#plotOptions.series.showInLegend), that can hide the
     * series from the legend. In some series types this is `false` by
     * default, so it must set to `true` in order to show the legend for the
     * series.
     *
     * @sample {highcharts} highcharts/legend/enabled-false/ Legend disabled
     * @sample {highstock} stock/legend/align/ Various legend options
     * @sample {highmaps} maps/legend/enabled-false/ Legend disabled
     *
     * @default {highstock} false
     * @default {highmaps} true
     * @default {gantt} false
     */
    enabled: true,
    /**
     * The horizontal alignment of the legend box within the chart area.
     * Valid values are `left`, `center` and `right`.
     *
     * In the case that the legend is aligned in a corner position, the
     * `layout` option will determine whether to place it above/below
     * or on the side of the plot area.
     *
     * @sample {highcharts} highcharts/legend/align/
     *         Legend at the right of the chart
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/alignment/
     *         Legend alignment
     *
     * @type  {Highcharts.AlignValue}
     * @since 2.0
     */
    align: "center",
    /**
     * If the [layout](legend.layout) is `horizontal` and the legend items
     * span over two lines or more, whether to align the items into vertical
     * columns. Setting this to `false` makes room for more items, but will
     * look more messy.
     *
     * @since 6.1.0
     */
    alignColumns: true,
    /**
     * A CSS class name to apply to the legend group.
     */
    className: "highcharts-no-tooltip",
    /**
     * When the legend is floating, the plot area ignores it and is allowed
     * to be placed below it.
     *
     * @sample {highcharts} highcharts/legend/floating-false/
     *         False by default
     * @sample {highcharts} highcharts/legend/floating-true/
     *         True
     * @sample {highmaps} maps/legend/alignment/
     *         Floating legend
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @apioption legend.floating
     */
    /**
     * The layout of the legend items. Can be one of `horizontal` or
     * `vertical` or `proximate`. When `proximate`, the legend items will be
     * placed as close as possible to the graphs they're representing,
     * except in inverted charts or when the legend position doesn't allow
     * it.
     *
     * @sample {highcharts} highcharts/legend/layout-horizontal/
     *         Horizontal by default
     * @sample {highcharts} highcharts/legend/layout-vertical/
     *         Vertical
     * @sample highcharts/legend/layout-proximate
     *         Labels proximate to the data
     * @sample {highstock} stock/legend/layout-horizontal/
     *         Horizontal by default
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Vertical with data classes
     * @sample {highmaps} maps/legend/layout-vertical/
     *         Vertical with color axis gradient
     *
     * @validvalue ["horizontal", "vertical", "proximate"]
     */
    layout: "horizontal",
    /**
     * In a legend with horizontal layout, the itemDistance defines the
     * pixel distance between each item.
     *
     * @sample {highcharts} highcharts/legend/layout-horizontal/
     *         50px item distance
     * @sample {highstock} highcharts/legend/layout-horizontal/
     *         50px item distance
     *
     * @type      {number}
     * @default   {highcharts} 20
     * @default   {highstock} 20
     * @default   {highmaps} 8
     * @since     3.0.3
     * @apioption legend.itemDistance
     */
    /**
     * The pixel bottom margin for each legend item.
     *
     * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     *
     * @type      {number}
     * @default   0
     * @since     2.2.0
     * @apioption legend.itemMarginBottom
     */
    /**
     * The pixel top margin for each legend item.
     *
     * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     *
     * @type      {number}
     * @default   0
     * @since     2.2.0
     * @apioption legend.itemMarginTop
     */
    /**
     * The width for each legend item. By default the items are laid out
     * successively. In a [horizontal layout](legend.layout), if the items
     * are laid out across two rows or more, they will be vertically aligned
     * depending on the [legend.alignColumns](legend.alignColumns) option.
     *
     * @sample {highcharts} highcharts/legend/itemwidth-default/
     *         Undefined by default
     * @sample {highcharts} highcharts/legend/itemwidth-80/
     *         80 for aligned legend items
     *
     * @type      {number}
     * @since     2.0
     * @apioption legend.itemWidth
     */
    /**
     * A [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
     * for each legend label. Available variables relates to properties on
     * the series, or the point in case of pies.
     *
     * @type      {string}
     * @default   {name}
     * @since     1.3
     * @apioption legend.labelFormat
     */
    /* eslint-disable valid-jsdoc */
    /**
     * Callback function to format each of the series' labels. The `this`
     * keyword refers to the series object, or the point object in case of
     * pie charts. By default the series or point name is printed.
     *
     * @productdesc {highmaps}
     * In Highmaps the context can also be a data class in case of a
     * `colorAxis`.
     *
     * @sample {highcharts} highcharts/legend/labelformatter/
     *         Add text
     * @sample {highmaps} maps/legend/labelformatter/
     *         Data classes with label formatter
     *
     * @type {Highcharts.FormatterCallbackFunction<Point|Series>}
     */
    labelFormatter: function() {
      return this.name;
    },
    /**
     * Line height for the legend items. Deprecated as of 2.1\. Instead,
     * the line height for each item can be set using
     * `itemStyle.lineHeight`, and the padding between items using
     * `itemMarginTop` and `itemMarginBottom`.
     *
     * @sample {highcharts} highcharts/legend/lineheight/
     *         Setting padding
     *
     * @deprecated
     *
     * @type      {number}
     * @default   16
     * @since     2.0
     * @product   highcharts gantt
     * @apioption legend.lineHeight
     */
    /**
     * If the plot area sized is calculated automatically and the legend is
     * not floating, the legend margin is the space between the legend and
     * the axis labels or plot area.
     *
     * @sample {highcharts} highcharts/legend/margin-default/
     *         12 pixels by default
     * @sample {highcharts} highcharts/legend/margin-30/
     *         30 pixels
     *
     * @type      {number}
     * @default   12
     * @since     2.1
     * @apioption legend.margin
     */
    /**
     * Maximum pixel height for the legend. When the maximum height is
     * extended, navigation will show.
     *
     * @type      {number}
     * @since     2.3.0
     * @apioption legend.maxHeight
     */
    /**
     * The color of the drawn border around the legend.
     *
     * @see In styled mode, the legend border stroke can be applied with the
     *      `.highcharts-legend-box` class.
     *
     * @sample {highcharts} highcharts/legend/bordercolor/
     *         Brown border
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     */
    borderColor: palette.neutralColor40,
    /**
     * The border corner radius of the legend.
     *
     * @sample {highcharts} highcharts/legend/borderradius-default/
     *         Square by default
     * @sample {highcharts} highcharts/legend/borderradius-round/
     *         5px rounded
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     */
    borderRadius: 0,
    /**
     * Options for the paging or navigation appearing when the legend is
     * overflown. Navigation works well on screen, but not in static
     * exported images. One way of working around that is to
     * [increase the chart height in
     * export](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/legend/navigation-enabled-false/).
     */
    navigation: {
      /**
       * How to animate the pages when navigating up or down. A value of
       * `true` applies the default navigation given in the
       * `chart.animation` option. Additional options can be given as an
       * object containing values for easing and duration.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type      {boolean|Partial<Highcharts.AnimationOptionsObject>}
       * @default   true
       * @since     2.2.4
       * @apioption legend.navigation.animation
       */
      /**
       * The pixel size of the up and down arrows in the legend paging
       * navigation.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type      {number}
       * @default   12
       * @since     2.2.4
       * @apioption legend.navigation.arrowSize
       */
      /**
       * Whether to enable the legend navigation. In most cases, disabling
       * the navigation results in an unwanted overflow.
       *
       * See also the [adapt chart to legend](
       * https://www.highcharts.com/products/plugin-registry/single/8/Adapt-Chart-To-Legend)
       * plugin for a solution to extend the chart height to make room for
       * the legend, optionally in exported charts only.
       *
       * @type      {boolean}
       * @default   true
       * @since     4.2.4
       * @apioption legend.navigation.enabled
       */
      /**
       * Text styles for the legend page navigation.
       *
       * @see In styled mode, the navigation items are styled with the
       *      `.highcharts-legend-navigation` class.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type      {Highcharts.CSSObject}
       * @since     2.2.4
       * @apioption legend.navigation.style
       */
      /**
       * The color for the active up or down arrow in the legend page
       * navigation.
       *
       * @see In styled mode, the active arrow be styled with the
       *      `.highcharts-legend-nav-active` class.
       *
       * @sample  {highcharts} highcharts/legend/navigation/
       *          Legend page navigation demonstrated
       * @sample  {highstock} highcharts/legend/navigation/
       *          Legend page navigation demonstrated
       *
       * @type  {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @since 2.2.4
       */
      activeColor: palette.highlightColor100,
      /**
       * The color of the inactive up or down arrow in the legend page
       * navigation. .
       *
       * @see In styled mode, the inactive arrow be styled with the
       *      `.highcharts-legend-nav-inactive` class.
       *
       * @sample {highcharts} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       * @sample {highstock} highcharts/legend/navigation/
       *         Legend page navigation demonstrated
       *
       * @type  {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
       * @since 2.2.4
       */
      inactiveColor: palette.neutralColor20
    },
    /**
     * The inner padding of the legend box.
     *
     * @sample {highcharts|highstock} highcharts/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     *
     * @type      {number}
     * @default   8
     * @since     2.2.0
     * @apioption legend.padding
     */
    /**
     * Whether to reverse the order of the legend items compared to the
     * order of the series or points as defined in the configuration object.
     *
     * @see [yAxis.reversedStacks](#yAxis.reversedStacks),
     *      [series.legendIndex](#series.legendIndex)
     *
     * @sample {highcharts} highcharts/legend/reversed/
     *         Stacked bar with reversed legend
     *
     * @type      {boolean}
     * @default   false
     * @since     1.2.5
     * @apioption legend.reversed
     */
    /**
     * Whether to show the symbol on the right side of the text rather than
     * the left side. This is common in Arabic and Hebrew.
     *
     * @sample {highcharts} highcharts/legend/rtl/
     *         Symbol to the right
     *
     * @type      {boolean}
     * @default   false
     * @since     2.2
     * @apioption legend.rtl
     */
    /**
     * CSS styles for the legend area. In the 1.x versions the position
     * of the legend area was determined by CSS. In 2.x, the position is
     * determined by properties like `align`, `verticalAlign`, `x` and `y`,
     * but the styles are still parsed for backwards compatibility.
     *
     * @deprecated
     *
     * @type      {Highcharts.CSSObject}
     * @product   highcharts highstock
     * @apioption legend.style
     */
    /**
     * CSS styles for each legend item. Only a subset of CSS is supported,
     * notably those options related to text. The default `textOverflow`
     * property makes long texts truncate. Set it to `undefined` to wrap
     * text instead. A `width` property can be added to control the text
     * width.
     *
     * @see In styled mode, the legend items can be styled with the
     *      `.highcharts-legend-item` class.
     *
     * @sample {highcharts} highcharts/legend/itemstyle/
     *         Bold black text
     * @sample {highmaps} maps/legend/itemstyle/
     *         Item text styles
     *
     * @type    {Highcharts.CSSObject}
     * @default {"color": "#333333", "cursor": "pointer", "fontSize": "12px", "fontWeight": "bold", "textOverflow": "ellipsis"}
     */
    itemStyle: {
      /**
       * @ignore
       */
      color: palette.neutralColor80,
      /**
       * @ignore
       */
      cursor: "pointer",
      /**
       * @ignore
       */
      fontSize: "12px",
      /**
       * @ignore
       */
      fontWeight: "bold",
      /**
       * @ignore
       */
      textOverflow: "ellipsis"
    },
    /**
     * CSS styles for each legend item in hover mode. Only a subset of
     * CSS is supported, notably those options related to text. Properties
     * are inherited from `style` unless overridden here.
     *
     * @see In styled mode, the hovered legend items can be styled with
     *      the `.highcharts-legend-item:hover` pesudo-class.
     *
     * @sample {highcharts} highcharts/legend/itemhoverstyle/
     *         Red on hover
     * @sample {highmaps} maps/legend/itemstyle/
     *         Item text styles
     *
     * @type    {Highcharts.CSSObject}
     * @default {"color": "#000000"}
     */
    itemHoverStyle: {
      /**
       * @ignore
       */
      color: palette.neutralColor100
    },
    /**
     * CSS styles for each legend item when the corresponding series or
     * point is hidden. Only a subset of CSS is supported, notably those
     * options related to text. Properties are inherited from `style`
     * unless overridden here.
     *
     * @see In styled mode, the hidden legend items can be styled with
     *      the `.highcharts-legend-item-hidden` class.
     *
     * @sample {highcharts} highcharts/legend/itemhiddenstyle/
     *         Darker gray color
     *
     * @type    {Highcharts.CSSObject}
     * @default {"color": "#cccccc"}
     */
    itemHiddenStyle: {
      /**
       * @ignore
       */
      color: palette.neutralColor20
    },
    /**
     * Whether to apply a drop shadow to the legend. A `backgroundColor`
     * also needs to be applied for this to take effect. The shadow can be
     * an object configuration containing `color`, `offsetX`, `offsetY`,
     * `opacity` and `width`.
     *
     * @sample {highcharts} highcharts/legend/shadow/
     *         White background and drop shadow
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/border-background/
     *         Border and background options
     *
     * @type {boolean|Highcharts.CSSObject}
     */
    shadow: false,
    /**
     * Default styling for the checkbox next to a legend item when
     * `showCheckbox` is true.
     *
     * @type {Highcharts.CSSObject}
     * @default {"width": "13px", "height": "13px", "position":"absolute"}
     */
    itemCheckboxStyle: {
      /**
       * @ignore
       */
      position: "absolute",
      /**
       * @ignore
       */
      width: "13px",
      /**
       * @ignore
       */
      height: "13px"
    },
    // itemWidth: undefined,
    /**
     * When this is true, the legend symbol width will be the same as
     * the symbol height, which in turn defaults to the font size of the
     * legend items.
     *
     * @since 5.0.0
     */
    squareSymbol: true,
    /**
     * The pixel height of the symbol for series types that use a rectangle
     * in the legend. Defaults to the font size of legend items.
     *
     * @productdesc {highmaps}
     * In Highmaps, when the symbol is the gradient of a vertical color
     * axis, the height defaults to 200.
     *
     * @sample {highmaps} maps/legend/layout-vertical-sized/
     *         Sized vertical gradient
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         No distance between data classes
     *
     * @type      {number}
     * @since     3.0.8
     * @apioption legend.symbolHeight
     */
    /**
     * The border radius of the symbol for series types that use a rectangle
     * in the legend. Defaults to half the `symbolHeight`.
     *
     * @sample {highcharts} highcharts/legend/symbolradius/
     *         Round symbols
     * @sample {highstock} highcharts/legend/symbolradius/
     *         Round symbols
     * @sample {highmaps} highcharts/legend/symbolradius/
     *         Round symbols
     *
     * @type      {number}
     * @since     3.0.8
     * @apioption legend.symbolRadius
     */
    /**
     * The pixel width of the legend item symbol. When the `squareSymbol`
     * option is set, this defaults to the `symbolHeight`, otherwise 16.
     *
     * @productdesc {highmaps}
     * In Highmaps, when the symbol is the gradient of a horizontal color
     * axis, the width defaults to 200.
     *
     * @sample {highcharts} highcharts/legend/symbolwidth/
     *         Greater symbol width and padding
     * @sample {highmaps} maps/legend/padding-itemmargin/
     *         Padding and item margins demonstrated
     * @sample {highmaps} maps/legend/layout-vertical-sized/
     *         Sized vertical gradient
     *
     * @type      {number}
     * @apioption legend.symbolWidth
     */
    /**
     * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the legend item texts.
     *
     * Prior to 4.1.7, when using HTML, [legend.navigation](
     * #legend.navigation) was disabled.
     *
     * @type      {boolean}
     * @default   false
     * @apioption legend.useHTML
     */
    /**
     * The width of the legend box. If a number is set, it translates to
     * pixels. Since v7.0.2 it allows setting a percent string of the full
     * chart width, for example `40%`.
     *
     * Defaults to the full chart width for legends below or above the
     * chart, half the chart width for legends to the left and right.
     *
     * @sample {highcharts} highcharts/legend/width/
     *         Aligned to the plot area
     * @sample {highcharts} highcharts/legend/width-percent/
     *         A percent of the chart width
     *
     * @type      {number|string}
     * @since     2.0
     * @apioption legend.width
     */
    /**
     * The pixel padding between the legend item symbol and the legend
     * item text.
     *
     * @sample {highcharts} highcharts/legend/symbolpadding/
     *         Greater symbol width and padding
     */
    symbolPadding: 5,
    /**
     * The vertical alignment of the legend box. Can be one of `top`,
     * `middle` or `bottom`. Vertical position can be further determined
     * by the `y` option.
     *
     * In the case that the legend is aligned in a corner position, the
     * `layout` option will determine whether to place it above/below
     * or on the side of the plot area.
     *
     * When the [layout](#legend.layout) option is `proximate`, the
     * `verticalAlign` option doesn't apply.
     *
     * @sample {highcharts} highcharts/legend/verticalalign/
     *         Legend 100px from the top of the chart
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/alignment/
     *         Legend alignment
     *
     * @type  {Highcharts.VerticalAlignValue}
     * @since 2.0
     */
    verticalAlign: "bottom",
    // width: undefined,
    /**
     * The x offset of the legend relative to its horizontal alignment
     * `align` within chart.spacingLeft and chart.spacingRight. Negative
     * x moves it to the left, positive x moves it to the right.
     *
     * @sample {highcharts} highcharts/legend/width/
     *         Aligned to the plot area
     *
     * @since 2.0
     */
    x: 0,
    /**
     * The vertical offset of the legend relative to it's vertical alignment
     * `verticalAlign` within chart.spacingTop and chart.spacingBottom.
     *  Negative y moves it up, positive y moves it down.
     *
     * @sample {highcharts} highcharts/legend/verticalalign/
     *         Legend 100px from the top of the chart
     * @sample {highstock} stock/legend/align/
     *         Various legend options
     * @sample {highmaps} maps/legend/alignment/
     *         Legend alignment
     *
     * @since 2.0
     */
    y: 0,
    /**
     * A title to be added on top of the legend.
     *
     * @sample {highcharts} highcharts/legend/title/
     *         Legend title
     * @sample {highmaps} maps/legend/alignment/
     *         Legend with title
     *
     * @since 3.0
     */
    title: {
      /**
       * A text or HTML string for the title.
       *
       * @type      {string}
       * @since     3.0
       * @apioption legend.title.text
       */
      /**
       * Generic CSS styles for the legend title.
       *
       * @see In styled mode, the legend title is styled with the
       *      `.highcharts-legend-title` class.
       *
       * @type    {Highcharts.CSSObject}
       * @default {"fontWeight": "bold"}
       * @since   3.0
       */
      style: {
        /**
         * @ignore
         */
        fontWeight: "bold"
      }
    }
  },
  /**
   * The loading options control the appearance of the loading screen
   * that covers the plot area on chart operations. This screen only
   * appears after an explicit call to `chart.showLoading()`. It is a
   * utility for developers to communicate to the end user that something
   * is going on, for example while retrieving new data via an XHR connection.
   * The "Loading..." text itself is not part of this configuration
   * object, but part of the `lang` object.
   */
  loading: {
    /**
     * The duration in milliseconds of the fade out effect.
     *
     * @sample highcharts/loading/hideduration/
     *         Fade in and out over a second
     *
     * @type      {number}
     * @default   100
     * @since     1.2.0
     * @apioption loading.hideDuration
     */
    /**
     * The duration in milliseconds of the fade in effect.
     *
     * @sample highcharts/loading/hideduration/
     *         Fade in and out over a second
     *
     * @type      {number}
     * @default   100
     * @since     1.2.0
     * @apioption loading.showDuration
     */
    /**
     * CSS styles for the loading label `span`.
     *
     * @see In styled mode, the loading label is styled with the
     *      `.highcharts-loading-inner` class.
     *
     * @sample {highcharts|highmaps} highcharts/loading/labelstyle/
     *         Vertically centered
     * @sample {highstock} stock/loading/general/
     *         Label styles
     *
     * @type    {Highcharts.CSSObject}
     * @default {"fontWeight": "bold", "position": "relative", "top": "45%"}
     * @since   1.2.0
     */
    labelStyle: {
      /**
       * @ignore
       */
      fontWeight: "bold",
      /**
       * @ignore
       */
      position: "relative",
      /**
       * @ignore
       */
      top: "45%"
    },
    /**
     * CSS styles for the loading screen that covers the plot area.
     *
     * In styled mode, the loading label is styled with the
     * `.highcharts-loading` class.
     *
     * @sample  {highcharts|highmaps} highcharts/loading/style/
     *          Gray plot area, white text
     * @sample  {highstock} stock/loading/general/
     *          Gray plot area, white text
     *
     * @type    {Highcharts.CSSObject}
     * @default {"position": "absolute", "backgroundColor": "#ffffff", "opacity": 0.5, "textAlign": "center"}
     * @since   1.2.0
     */
    style: {
      /**
       * @ignore
       */
      position: "absolute",
      /**
       * @ignore
       */
      backgroundColor: palette.backgroundColor,
      /**
       * @ignore
       */
      opacity: 0.5,
      /**
       * @ignore
       */
      textAlign: "center"
    }
  },
  /**
   * Options for the tooltip that appears when the user hovers over a
   * series or point.
   *
   * @declare Highcharts.TooltipOptions
   */
  tooltip: {
    /**
     * The color of the tooltip border. When `undefined`, the border takes
     * the color of the corresponding series or point.
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         Follow series by default
     * @sample {highcharts} highcharts/tooltip/bordercolor-black/
     *         Black border
     * @sample {highstock} stock/tooltip/general/
     *         Styled tooltip
     * @sample {highmaps} maps/tooltip/background-border/
     *         Background and border demo
     *
     * @type      {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     * @apioption tooltip.borderColor
     */
    /**
     * A CSS class name to apply to the tooltip's container div,
     * allowing unique CSS styling for each chart.
     *
     * @type      {string}
     * @apioption tooltip.className
     */
    /**
     * Since 4.1, the crosshair definitions are moved to the Axis object
     * in order for a better separation from the tooltip. See
     * [xAxis.crosshair](#xAxis.crosshair).
     *
     * @sample {highcharts} highcharts/tooltip/crosshairs-x/
     *         Enable a crosshair for the x value
     *
     * @deprecated
     *
     * @type      {*}
     * @default   true
     * @apioption tooltip.crosshairs
     */
    /**
     * Distance from point to tooltip in pixels.
     *
     * @type      {number}
     * @default   16
     * @apioption tooltip.distance
     */
    /**
     * Whether the tooltip should follow the mouse as it moves across
     * columns, pie slices and other point types with an extent.
     * By default it behaves this way for pie, polygon, map, sankey
     * and wordcloud series by override in the `plotOptions`
     * for those series types.
     *
     * Does not apply if [split](#tooltip.split) is `true`.
     *
     * For touch moves to behave the same way, [followTouchMove](
     * #tooltip.followTouchMove) must be `true` also.
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock} false
     * @default   {highmaps} true
     * @since     3.0
     * @apioption tooltip.followPointer
     */
    /**
     * Whether the tooltip should update as the finger moves on a touch
     * device. If this is `true` and [chart.panning](#chart.panning) is
     * set,`followTouchMove` will take over one-finger touches, so the user
     * needs to use two fingers for zooming and panning.
     *
     * Note the difference to [followPointer](#tooltip.followPointer) that
     * only defines the _position_ of the tooltip. If `followPointer` is
     * false in for example a column series, the tooltip will show above or
     * below the column, but as `followTouchMove` is true, the tooltip will
     * jump from column to column as the user swipes across the plot area.
     *
     * @type      {boolean}
     * @default   {highcharts} true
     * @default   {highstock} true
     * @default   {highmaps} false
     * @since     3.0.1
     * @apioption tooltip.followTouchMove
     */
    /**
     * Callback function to format the text of the tooltip from scratch. In
     * case of single or [shared](#tooltip.shared) tooltips, a string should
     * be returned. In case of [split](#tooltip.split) tooltips, it should
     * return an array where the first item is the header, and subsequent
     * items are mapped to the points. Return `false` to disable tooltip for
     * a specific point on series.
     *
     * A subset of HTML is supported. Unless `useHTML` is true, the HTML of
     * the tooltip is parsed and converted to SVG, therefore this isn't a
     * complete HTML renderer. The following HTML tags are supported: `b`,
     * `br`, `em`, `i`, `span`, `strong`. Spans can be styled with a `style`
     * attribute, but only text-related CSS, that is shared with SVG, is
     * handled.
     *
     * The available data in the formatter differ a bit depending on whether
     * the tooltip is shared or split, or belongs to a single point. In a
     * shared/split tooltip, all properties except `x`, which is common for
     * all points, are kept in an array, `this.points`.
     *
     * Available data are:
     *
     * - **this.percentage (not shared) /**
     *   **this.points[i].percentage (shared)**:
     *   Stacked series and pies only. The point's percentage of the total.
     *
     * - **this.point (not shared) / this.points[i].point (shared)**:
     *   The point object. The point name, if defined, is available through
     *   `this.point.name`.
     *
     * - **this.points**:
     *   In a shared tooltip, this is an array containing all other
     *   properties for each point.
     *
     * - **this.series (not shared) / this.points[i].series (shared)**:
     *   The series object. The series name is available through
     *   `this.series.name`.
     *
     * - **this.total (not shared) / this.points[i].total (shared)**:
     *   Stacked series only. The total value at this point's x value.
     *
     * - **this.x**:
     *   The x value. This property is the same regardless of the tooltip
     *   being shared or not.
     *
     * - **this.y (not shared) / this.points[i].y (shared)**:
     *   The y value.
     *
     * @sample {highcharts} highcharts/tooltip/formatter-simple/
     *         Simple string formatting
     * @sample {highcharts} highcharts/tooltip/formatter-shared/
     *         Formatting with shared tooltip
     * @sample {highcharts|highstock} highcharts/tooltip/formatter-split/
     *         Formatting with split tooltip
     * @sample highcharts/tooltip/formatter-conditional-default/
     *         Extending default formatter
     * @sample {highstock} stock/tooltip/formatter/
     *         Formatting with shared tooltip
     * @sample {highmaps} maps/tooltip/formatter/
     *         String formatting
     *
     * @type      {Highcharts.TooltipFormatterCallbackFunction}
     * @apioption tooltip.formatter
     */
    /**
     * Callback function to format the text of the tooltip for
     * visible null points.
     * Works analogously to [formatter](#tooltip.formatter).
     *
     * @sample highcharts/plotoptions/series-nullformat
     *         Format data label and tooltip for null point.
     *
     * @type      {Highcharts.TooltipFormatterCallbackFunction}
     * @apioption tooltip.nullFormatter
     */
    /**
     * Whether to allow the tooltip to render outside the chart's SVG
     * element box. By default (`false`), the tooltip is rendered within the
     * chart's SVG element, which results in the tooltip being aligned
     * inside the chart area. For small charts, this may result in clipping
     * or overlapping. When `true`, a separate SVG element is created and
     * overlaid on the page, allowing the tooltip to be aligned inside the
     * page itself.
     *
     * Defaults to `true` if `chart.scrollablePlotArea` is activated,
     * otherwise `false`.
     *
     * @sample highcharts/tooltip/outside
     *         Small charts with tooltips outside
     *
     * @type      {boolean|undefined}
     * @default   undefined
     * @since     6.1.1
     * @apioption tooltip.outside
     */
    /**
     * A callback function for formatting the HTML output for a single point
     * in the tooltip. Like the `pointFormat` string, but with more
     * flexibility.
     *
     * @type      {Highcharts.FormatterCallbackFunction<Highcharts.Point>}
     * @since     4.1.0
     * @context   Highcharts.Point
     * @apioption tooltip.pointFormatter
     */
    /**
     * A callback function to place the tooltip in a default position. The
     * callback receives three parameters: `labelWidth`, `labelHeight` and
     * `point`, where point contains values for `plotX` and `plotY` telling
     * where the reference point is in the plot area. Add `chart.plotLeft`
     * and `chart.plotTop` to get the full coordinates.
     *
     * Since v7, when [tooltip.split](#tooltip.split) option is enabled,
     * positioner is called for each of the boxes separately, including
     * xAxis header. xAxis header is not a point, instead `point` argument
     * contains info:
     * `{ plotX: Number, plotY: Number, isHeader: Boolean }`
     *
     *
     * The return should be an object containing x and y values, for example
     * `{ x: 100, y: 100 }`.
     *
     * @sample {highcharts} highcharts/tooltip/positioner/
     *         A fixed tooltip position
     * @sample {highstock} stock/tooltip/positioner/
     *         A fixed tooltip position on top of the chart
     * @sample {highmaps} maps/tooltip/positioner/
     *         A fixed tooltip position
     * @sample {highstock} stock/tooltip/split-positioner/
     *         Split tooltip with fixed positions
     * @sample {highstock} stock/tooltip/positioner-scrollable-plotarea/
     *         Scrollable plot area combined with tooltip positioner
     *
     * @type      {Highcharts.TooltipPositionerCallbackFunction}
     * @since     2.2.4
     * @apioption tooltip.positioner
     */
    /**
     * Split the tooltip into one label per series, with the header close
     * to the axis. This is recommended over [shared](#tooltip.shared)
     * tooltips for charts with multiple line series, generally making them
     * easier to read. This option takes precedence over `tooltip.shared`.
     *
     * @productdesc {highstock} In Highcharts Stock, tooltips are split
     * by default since v6.0.0. Stock charts typically contain
     * multi-dimension points and multiple panes, making split tooltips
     * the preferred layout over
     * the previous `shared` tooltip.
     *
     * @sample highcharts/tooltip/split/
     *         Split tooltip
     * @sample {highcharts|highstock} highcharts/tooltip/formatter-split/
     *         Split tooltip and custom formatter callback
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock} true
     * @since     5.0.0
     * @product   highcharts highstock
     * @apioption tooltip.split
     */
    /**
     * Prevents the tooltip from switching or closing, when touched or
     * pointed.
     *
     * @sample highcharts/tooltip/stickoncontact/
     *         Tooltip sticks on pointer contact
     *
     * @type      {boolean}
     * @since     8.0.1
     * @apioption tooltip.stickOnContact
     */
    /**
     * Use HTML to render the contents of the tooltip instead of SVG. Using
     * HTML allows advanced formatting like tables and images in the
     * tooltip. It is also recommended for rtl languages as it works around
     * rtl bugs in early Firefox.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/footerformat/
     *         A table for value alignment
     * @sample {highcharts|highstock} highcharts/tooltip/fullhtml/
     *         Full HTML tooltip
     * @sample {highmaps} maps/tooltip/usehtml/
     *         Pure HTML tooltip
     *
     * @type      {boolean}
     * @default   false
     * @since     2.2
     * @apioption tooltip.useHTML
     */
    /**
     * How many decimals to show in each series' y value. This is
     * overridable in each series' tooltip options object. The default is to
     * preserve all decimals.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     * @sample {highmaps} maps/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     *
     * @type      {number|undefined}
     * @since     2.2
     * @apioption tooltip.valueDecimals
     */
    /**
     * A string to prepend to each series' y value. Overridable in each
     * series' tooltip options object.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     * @sample {highmaps} maps/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     *
     * @type      {string}
     * @since     2.2
     * @apioption tooltip.valuePrefix
     */
    /**
     * A string to append to each series' y value. Overridable in each
     * series' tooltip options object.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     * @sample {highmaps} maps/tooltip/valuedecimals/
     *         Set decimals, prefix and suffix for the value
     *
     * @type      {string}
     * @since     2.2
     * @apioption tooltip.valueSuffix
     */
    /**
     * The format for the date in the tooltip header if the X axis is a
     * datetime axis. The default is a best guess based on the smallest
     * distance between points in the chart.
     *
     * @sample {highcharts} highcharts/tooltip/xdateformat/
     *         A different format
     *
     * @type      {string}
     * @product   highcharts highstock gantt
     * @apioption tooltip.xDateFormat
     */
    /**
     * How many decimals to show for the `point.change` value when the
     * `series.compare` option is set. This is overridable in each series'
     * tooltip options object. The default is to preserve all decimals.
     *
     * @type      {number}
     * @since     1.0.1
     * @product   highstock
     * @apioption tooltip.changeDecimals
     */
    /**
     * Enable or disable the tooltip.
     *
     * @sample {highcharts} highcharts/tooltip/enabled/
     *         Disabled
     * @sample {highcharts} highcharts/plotoptions/series-point-events-mouseover/
     *         Disable tooltip and show values on chart instead
     */
    enabled: true,
    /**
     * Enable or disable animation of the tooltip.
     *
     * @type       {boolean}
     * @default    true
     * @since      2.3.0
     */
    animation: svg$7,
    /**
     * The radius of the rounded border corners.
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         5px by default
     * @sample {highcharts} highcharts/tooltip/borderradius-0/
     *         Square borders
     * @sample {highmaps} maps/tooltip/background-border/
     *         Background and border demo
     */
    borderRadius: 3,
    /**
     * For series on datetime axes, the date format in the tooltip's
     * header will by default be guessed based on the closest data points.
     * This member gives the default string representations used for
     * each unit. For an overview of the replacement codes, see
     * [dateFormat](/class-reference/Highcharts#.dateFormat).
     *
     * @see [xAxis.dateTimeLabelFormats](#xAxis.dateTimeLabelFormats)
     *
     * @type    {Highcharts.Dictionary<string>}
     * @product highcharts highstock gantt
     */
    dateTimeLabelFormats: {
      /** @internal */
      millisecond: "%A, %b %e, %H:%M:%S.%L",
      /** @internal */
      second: "%A, %b %e, %H:%M:%S",
      /** @internal */
      minute: "%A, %b %e, %H:%M",
      /** @internal */
      hour: "%A, %b %e, %H:%M",
      /** @internal */
      day: "%A, %b %e, %Y",
      /** @internal */
      week: "Week from %A, %b %e, %Y",
      /** @internal */
      month: "%B %Y",
      /** @internal */
      year: "%Y"
    },
    /**
     * A string to append to the tooltip format.
     *
     * @sample {highcharts} highcharts/tooltip/footerformat/
     *         A table for value alignment
     * @sample {highmaps} maps/tooltip/format/
     *         Format demo
     *
     * @since 2.2
     */
    footerFormat: "",
    /**
     * The name of a symbol to use for the border around the tooltip
     * header. Applies only when [tooltip.split](#tooltip.split) is
     * enabled.
     *
     * Custom callbacks for symbol path generation can also be added to
     * `Highcharts.SVGRenderer.prototype.symbols` the same way as for
     * [series.marker.symbol](plotOptions.line.marker.symbol).
     *
     * @see [tooltip.shape](#tooltip.shape)
     *
     * @sample {highstock} stock/tooltip/split-positioner/
     *         Different shapes for header and split boxes
     *
     * @type       {Highcharts.TooltipShapeValue}
     * @validvalue ["callout", "square"]
     * @since      7.0
     */
    headerShape: "callout",
    /**
     * The number of milliseconds to wait until the tooltip is hidden when
     * mouse out from a point or chart.
     *
     * @since     3.0
     */
    hideDelay: 500,
    /**
     * Padding inside the tooltip, in pixels.
     *
     * @since      5.0.0
     */
    padding: 8,
    /**
     * The name of a symbol to use for the border around the tooltip. Can
     * be one of: `"callout"`, `"circle"` or `"rect"`. When
     * [tooltip.split](#tooltip.split)
     * option is enabled, shape is applied to all boxes except header, which
     * is controlled by
     * [tooltip.headerShape](#tooltip.headerShape).
     *
     * Custom callbacks for symbol path generation can also be added to
     * `Highcharts.SVGRenderer.prototype.symbols` the same way as for
     * [series.marker.symbol](plotOptions.line.marker.symbol).
     *
     * @type      {Highcharts.TooltipShapeValue}
     * @since     4.0
     */
    shape: "callout",
    /**
     * When the tooltip is shared, the entire plot area will capture mouse
     * movement or touch events. Tooltip texts for series types with ordered
     * data (not pie, scatter, flags etc) will be shown in a single bubble.
     * This is recommended for single series charts and for tablet/mobile
     * optimized charts.
     *
     * See also [tooltip.split](#tooltip.split), that is better suited for
     * charts with many series, especially line-type series. The
     * `tooltip.split` option takes precedence over `tooltip.shared`.
     *
     * @sample {highcharts} highcharts/tooltip/shared-false/
     *         False by default
     * @sample {highcharts} highcharts/tooltip/shared-true/
     *         True
     * @sample {highcharts} highcharts/tooltip/shared-x-crosshair/
     *         True with x axis crosshair
     * @sample {highcharts} highcharts/tooltip/shared-true-mixed-types/
     *         True with mixed series types
     *
     * @since     2.1
     * @product   highcharts highstock
     */
    shared: false,
    /**
     * Proximity snap for graphs or single points. It defaults to 10 for
     * mouse-powered devices and 25 for touch devices.
     *
     * Note that in most cases the whole plot area captures the mouse
     * movement, and in these cases `tooltip.snap` doesn't make sense. This
     * applies when [stickyTracking](#plotOptions.series.stickyTracking)
     * is `true` (default) and when the tooltip is [shared](#tooltip.shared)
     * or [split](#tooltip.split).
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         10 px by default
     * @sample {highcharts} highcharts/tooltip/snap-50/
     *         50 px on graph
     *
     * @type    {number}
     * @default 10/25
     * @since   1.2.0
     * @product highcharts highstock
     */
    snap: isTouchDevice$4 ? 25 : 10,
    /**
     * The HTML of the tooltip header line. Variables are enclosed by
     * curly brackets. Available variables are `point.key`, `series.name`,
     * `series.color` and other members from the `point` and `series`
     * objects. The `point.key` variable contains the category name, x
     * value or datetime string depending on the type of axis. For datetime
     * axes, the `point.key` date format can be set using
     * `tooltip.xDateFormat`.
     *
     * @sample {highcharts} highcharts/tooltip/footerformat/
     *         An HTML table in the tooltip
     * @sample {highstock} highcharts/tooltip/footerformat/
     *         An HTML table in the tooltip
     * @sample {highmaps} maps/tooltip/format/
     *         Format demo
     *
     * @type       {string}
     * @apioption  tooltip.headerFormat
     */
    headerFormat: '<span style="font-size: 10px">{point.key}</span><br/>',
    /**
     * The HTML of the null point's line in the tooltip. Works analogously
     * to [pointFormat](#tooltip.pointFormat).
     *
     * @sample {highcharts} highcharts/plotoptions/series-nullformat
     *         Format data label and tooltip for null point.
     *
     * @type      {string}
     * @apioption tooltip.nullFormat
     */
    /**
     * The HTML of the point's line in the tooltip. Variables are enclosed
     * by curly brackets. Available variables are `point.x`, `point.y`,
     * `series.name` and `series.color` and other properties on the same
     * form. Furthermore, `point.y` can be extended by the
     * `tooltip.valuePrefix` and `tooltip.valueSuffix` variables. This can
     * also be overridden for each series, which makes it a good hook for
     * displaying units.
     *
     * In styled mode, the dot is colored by a class name rather
     * than the point color.
     *
     * @sample {highcharts} highcharts/tooltip/pointformat/
     *         A different point format with value suffix
     * @sample {highmaps} maps/tooltip/format/
     *         Format demo
     *
     * @type       {string}
     * @since      2.2
     * @apioption  tooltip.pointFormat
     */
    pointFormat: '<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',
    /**
     * The background color or gradient for the tooltip.
     *
     * In styled mode, the stroke width is set in the
     * `.highcharts-tooltip-box` class.
     *
     * @sample {highcharts} highcharts/tooltip/backgroundcolor-solid/
     *         Yellowish background
     * @sample {highcharts} highcharts/tooltip/backgroundcolor-gradient/
     *         Gradient
     * @sample {highcharts} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highstock} stock/tooltip/general/
     *         Custom tooltip
     * @sample {highstock} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highmaps} maps/tooltip/background-border/
     *         Background and border demo
     * @sample {highmaps} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     *
     * @type {Highcharts.ColorString|Highcharts.GradientColorObject|Highcharts.PatternObject}
     */
    backgroundColor: color$g(palette.neutralColor3).setOpacity(0.85).get(),
    /**
     * The pixel width of the tooltip border.
     *
     * In styled mode, the stroke width is set in the
     * `.highcharts-tooltip-box` class.
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         2px by default
     * @sample {highcharts} highcharts/tooltip/borderwidth/
     *         No border (shadow only)
     * @sample {highcharts} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highstock} stock/tooltip/general/
     *         Custom tooltip
     * @sample {highstock} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     * @sample {highmaps} maps/tooltip/background-border/
     *         Background and border demo
     * @sample {highmaps} highcharts/css/tooltip-border-background/
     *         Tooltip in styled mode
     */
    borderWidth: 1,
    /**
     * Whether to apply a drop shadow to the tooltip.
     *
     * @sample {highcharts} highcharts/tooltip/bordercolor-default/
     *         True by default
     * @sample {highcharts} highcharts/tooltip/shadow/
     *         False
     * @sample {highmaps} maps/tooltip/positioner/
     *         Fixed tooltip position, border and shadow disabled
     *
     * @type {boolean|Highcharts.ShadowOptionsObject}
     */
    shadow: true,
    /**
     * Prevents the tooltip from switching or closing when touched or
     * pointed.
     *
     * @sample highcharts/tooltip/stickoncontact/
     *         Tooltip sticks on pointer contact
     *
     * @since     8.0.1
     */
    stickOnContact: false,
    /**
     * CSS styles for the tooltip. The tooltip can also be styled through
     * the CSS class `.highcharts-tooltip`.
     *
     * Note that the default `pointerEvents` style makes the tooltip ignore
     * mouse events, so in order to use clickable tooltips, this value must
     * be set to `auto`.
     *
     * @sample {highcharts} highcharts/tooltip/style/
     *         Greater padding, bold text
     *
     * @type {Highcharts.CSSObject}
     */
    style: {
      /** @internal */
      color: palette.neutralColor80,
      /** @internal */
      cursor: "default",
      /** @internal */
      fontSize: "12px",
      /** @internal */
      whiteSpace: "nowrap"
    },
    /**
     * Use HTML to render the contents of the tooltip instead of SVG. Using
     * HTML allows advanced formatting like tables and images in the
     * tooltip. It is also recommended for rtl languages as it works around
     * rtl bugs in early Firefox.
     *
     * @sample {highcharts|highstock} highcharts/tooltip/footerformat/
     *         A table for value alignment
     * @sample {highcharts|highstock} highcharts/tooltip/fullhtml/
     *         Full HTML tooltip
     * @sample {highmaps} maps/tooltip/usehtml/
     *         Pure HTML tooltip
     *
     * @since     2.2
     */
    useHTML: false
  },
  /**
   * Highchart by default puts a credits label in the lower right corner
   * of the chart. This can be changed using these options.
   */
  credits: {
    /**
     * Credits for map source to be concatenated with conventional credit
     * text. By default this is a format string that collects copyright
     * information from the map if available.
     *
     * @see [mapTextFull](#credits.mapTextFull)
     * @see [text](#credits.text)
     *
     * @type      {string}
     * @default   \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>
     * @since     4.2.2
     * @product   highmaps
     * @apioption credits.mapText
     */
    /**
     * Detailed credits for map source to be displayed on hover of credits
     * text. By default this is a format string that collects copyright
     * information from the map if available.
     *
     * @see [mapText](#credits.mapText)
     * @see [text](#credits.text)
     *
     * @type      {string}
     * @default   {geojson.copyright}
     * @since     4.2.2
     * @product   highmaps
     * @apioption credits.mapTextFull
     */
    /**
     * Whether to show the credits text.
     *
     * @sample {highcharts} highcharts/credits/enabled-false/
     *         Credits disabled
     * @sample {highstock} stock/credits/enabled/
     *         Credits disabled
     * @sample {highmaps} maps/credits/enabled-false/
     *         Credits disabled
     */
    enabled: true,
    /**
     * The URL for the credits label.
     *
     * @sample {highcharts} highcharts/credits/href/
     *         Custom URL and text
     * @sample {highmaps} maps/credits/customized/
     *         Custom URL and text
     */
    href: "https://www.highcharts.com?credits",
    /**
     * Position configuration for the credits label.
     *
     * @sample {highcharts} highcharts/credits/position-left/
     *         Left aligned
     * @sample {highcharts} highcharts/credits/position-left/
     *         Left aligned
     * @sample {highmaps} maps/credits/customized/
     *         Left aligned
     * @sample {highmaps} maps/credits/customized/
     *         Left aligned
     *
     * @type    {Highcharts.AlignObject}
     * @since   2.1
     */
    position: {
      /** @internal */
      align: "right",
      /** @internal */
      x: -10,
      /** @internal */
      verticalAlign: "bottom",
      /** @internal */
      y: -5
    },
    /**
     * CSS styles for the credits label.
     *
     * @see In styled mode, credits styles can be set with the
     *      `.highcharts-credits` class.
     *
     * @type {Highcharts.CSSObject}
     */
    style: {
      /** @internal */
      cursor: "pointer",
      /** @internal */
      color: palette.neutralColor40,
      /** @internal */
      fontSize: "9px"
    },
    /**
     * The text for the credits label.
     *
     * @productdesc {highmaps}
     * If a map is loaded as GeoJSON, the text defaults to
     * `Highcharts @ {map-credits}`. Otherwise, it defaults to
     * `Highcharts.com`.
     *
     * @sample {highcharts} highcharts/credits/href/
     *         Custom URL and text
     * @sample {highmaps} maps/credits/customized/
     *         Custom URL and text
     */
    text: "Highcharts.com"
  }
};
defaultOptions$j.chart.styledMode = false;
var defaultTime$2 = new Time(merge$1u(defaultOptions$j.global, defaultOptions$j.time));
function getOptions$4() {
  return defaultOptions$j;
}
function setOptions$2(options) {
  merge$1u(true, defaultOptions$j, options);
  if (options.time || options.global) {
    if (H.time) {
      H.time.update(merge$1u(defaultOptions$j.global, defaultOptions$j.time, options.global, options.time));
    } else {
      H.time = defaultTime$2;
    }
  }
  return defaultOptions$j;
}
var DefaultOptions = {
  defaultOptions: defaultOptions$j,
  defaultTime: defaultTime$2,
  getOptions: getOptions$4,
  setOptions: setOptions$2
};
var color$f = Color.parse;
var win$e = H.win;
var isNumber$V = Utilities.isNumber, objectEach$B = Utilities.objectEach;
var Fx = (
  /** @class */
  (function() {
    function Fx2(elem, options, prop) {
      this.pos = NaN;
      this.options = options;
      this.elem = elem;
      this.prop = prop;
    }
    Fx2.prototype.dSetter = function() {
      var paths = this.paths, start2 = paths && paths[0], end = paths && paths[1], now = this.now || 0;
      var path = [];
      if (now === 1 || !start2 || !end) {
        path = this.toD || [];
      } else if (start2.length === end.length && now < 1) {
        for (var i2 = 0; i2 < end.length; i2++) {
          var startSeg = start2[i2];
          var endSeg = end[i2];
          var tweenSeg = [];
          for (var j = 0; j < endSeg.length; j++) {
            var startItem = startSeg[j];
            var endItem = endSeg[j];
            if (isNumber$V(startItem) && isNumber$V(endItem) && // Arc boolean flags
            !(endSeg[0] === "A" && (j === 4 || j === 5))) {
              tweenSeg[j] = startItem + now * (endItem - startItem);
            } else {
              tweenSeg[j] = endItem;
            }
          }
          path.push(tweenSeg);
        }
      } else {
        path = end;
      }
      this.elem.attr("d", path, void 0, true);
    };
    Fx2.prototype.update = function() {
      var elem = this.elem, prop = this.prop, now = this.now, step = this.options.step;
      if (this[prop + "Setter"]) {
        this[prop + "Setter"]();
      } else if (elem.attr) {
        if (elem.element) {
          elem.attr(prop, now, null, true);
        }
      } else {
        elem.style[prop] = now + this.unit;
      }
      if (step) {
        step.call(elem, now, this);
      }
    };
    Fx2.prototype.run = function(from, to, unit) {
      var self2 = this, options = self2.options, timer = function(gotoEnd) {
        return timer.stopped ? false : self2.step(gotoEnd);
      }, requestAnimationFrame2 = win$e.requestAnimationFrame || function(step2) {
        setTimeout(step2, 13);
      }, step = function() {
        for (var i2 = 0; i2 < Fx2.timers.length; i2++) {
          if (!Fx2.timers[i2]()) {
            Fx2.timers.splice(i2--, 1);
          }
        }
        if (Fx2.timers.length) {
          requestAnimationFrame2(step);
        }
      };
      if (from === to && !this.elem["forceAnimate:" + this.prop]) {
        delete options.curAnim[this.prop];
        if (options.complete && Object.keys(options.curAnim).length === 0) {
          options.complete.call(this.elem);
        }
      } else {
        this.startTime = +/* @__PURE__ */ new Date();
        this.start = from;
        this.end = to;
        this.unit = unit;
        this.now = this.start;
        this.pos = 0;
        timer.elem = this.elem;
        timer.prop = this.prop;
        if (timer() && Fx2.timers.push(timer) === 1) {
          requestAnimationFrame2(step);
        }
      }
    };
    Fx2.prototype.step = function(gotoEnd) {
      var t = +/* @__PURE__ */ new Date(), options = this.options, elem = this.elem, complete = options.complete, duration = options.duration, curAnim = options.curAnim;
      var ret, done;
      if (elem.attr && !elem.element) {
        ret = false;
      } else if (gotoEnd || t >= duration + this.startTime) {
        this.now = this.end;
        this.pos = 1;
        this.update();
        curAnim[this.prop] = true;
        done = true;
        objectEach$B(curAnim, function(val) {
          if (val !== true) {
            done = false;
          }
        });
        if (done && complete) {
          complete.call(elem);
        }
        ret = false;
      } else {
        this.pos = options.easing((t - this.startTime) / duration);
        this.now = this.start + (this.end - this.start) * this.pos;
        this.update();
        ret = true;
      }
      return ret;
    };
    Fx2.prototype.initPath = function(elem, fromD, toD) {
      var startX = elem.startX, endX = elem.endX, end = toD.slice(), isArea = elem.isArea, positionFactor = isArea ? 2 : 1;
      var shift, fullLength, i2, reverse, start2 = fromD && fromD.slice();
      if (!start2) {
        return [end, end];
      }
      function prepend(arr, other2) {
        while (arr.length < fullLength) {
          var moveSegment = arr[0], otherSegment = other2[fullLength - arr.length];
          if (otherSegment && moveSegment[0] === "M") {
            if (otherSegment[0] === "C") {
              arr[0] = [
                "C",
                moveSegment[1],
                moveSegment[2],
                moveSegment[1],
                moveSegment[2],
                moveSegment[1],
                moveSegment[2]
              ];
            } else {
              arr[0] = ["L", moveSegment[1], moveSegment[2]];
            }
          }
          arr.unshift(moveSegment);
          if (isArea) {
            var z = arr.pop();
            arr.push(arr[arr.length - 1], z);
          }
        }
      }
      function append(arr, other2) {
        while (arr.length < fullLength) {
          var segmentToAdd = arr[Math.floor(arr.length / positionFactor) - 1].slice();
          if (segmentToAdd[0] === "C") {
            segmentToAdd[1] = segmentToAdd[5];
            segmentToAdd[2] = segmentToAdd[6];
          }
          if (!isArea) {
            arr.push(segmentToAdd);
          } else {
            var lowerSegmentToAdd = arr[Math.floor(arr.length / positionFactor)].slice();
            arr.splice(arr.length / 2, 0, segmentToAdd, lowerSegmentToAdd);
          }
        }
      }
      if (startX && endX && endX.length) {
        for (i2 = 0; i2 < startX.length; i2++) {
          if (startX[i2] === endX[0]) {
            shift = i2;
            break;
          } else if (startX[0] === endX[endX.length - startX.length + i2]) {
            shift = i2;
            reverse = true;
            break;
          } else if (startX[startX.length - 1] === endX[endX.length - startX.length + i2]) {
            shift = startX.length - i2;
            break;
          }
        }
        if (typeof shift === "undefined") {
          start2 = [];
        }
      }
      if (start2.length && isNumber$V(shift)) {
        fullLength = end.length + shift * positionFactor;
        if (!reverse) {
          prepend(end, start2);
          append(start2);
        } else {
          prepend(start2, end);
          append(end);
        }
      }
      return [start2, end];
    };
    Fx2.prototype.fillSetter = function() {
      Fx2.prototype.strokeSetter.apply(this, arguments);
    };
    Fx2.prototype.strokeSetter = function() {
      this.elem.attr(this.prop, color$f(this.start).tweenTo(color$f(this.end), this.pos), null, true);
    };
    Fx2.timers = [];
    return Fx2;
  })()
);
var defined$Y = Utilities.defined, getStyle$1 = Utilities.getStyle, isArray$p = Utilities.isArray, isNumber$U = Utilities.isNumber, isObject$g = Utilities.isObject, merge$1t = Utilities.merge, objectEach$A = Utilities.objectEach, pick$1I = Utilities.pick;
function setAnimation$5(animation, chart) {
  chart.renderer.globalAnimation = pick$1I(animation, chart.options.chart.animation, true);
}
function animObject$d(animation) {
  return isObject$g(animation) ? merge$1t({ duration: 500, defer: 0 }, animation) : { duration: animation ? 500 : 0, defer: 0 };
}
function getDeferredAnimation$3(chart, animation, series) {
  var labelAnimation = animObject$d(animation), s = series ? [series] : chart.series;
  var defer = 0, duration = 0;
  s.forEach(function(series2) {
    var seriesAnim = animObject$d(series2.options.animation);
    defer = animation && defined$Y(animation.defer) ? labelAnimation.defer : Math.max(defer, seriesAnim.duration + seriesAnim.defer);
    duration = Math.min(labelAnimation.duration, seriesAnim.duration);
  });
  if (chart.renderer.forExport) {
    defer = 0;
  }
  var anim = {
    defer: Math.max(0, defer - duration),
    duration: Math.min(defer, duration)
  };
  return anim;
}
function animate$2(el, params2, opt) {
  var start2, unit = "", end, fx, args;
  if (!isObject$g(opt)) {
    args = arguments;
    opt = {
      duration: args[2],
      easing: args[3],
      complete: args[4]
    };
  }
  if (!isNumber$U(opt.duration)) {
    opt.duration = 400;
  }
  opt.easing = typeof opt.easing === "function" ? opt.easing : Math[opt.easing] || Math.easeInOutSine;
  opt.curAnim = merge$1t(params2);
  objectEach$A(params2, function(val, prop) {
    stop$2(el, prop);
    fx = new Fx(el, opt, prop);
    end = void 0;
    if (prop === "d" && isArray$p(params2.d)) {
      fx.paths = fx.initPath(el, el.pathArray, params2.d);
      fx.toD = params2.d;
      start2 = 0;
      end = 1;
    } else if (el.attr) {
      start2 = el.attr(prop);
    } else {
      start2 = parseFloat(getStyle$1(el, prop)) || 0;
      if (prop !== "opacity") {
        unit = "px";
      }
    }
    if (!end) {
      end = val;
    }
    if (typeof end === "string" && end.match("px")) {
      end = end.replace(/px/g, "");
    }
    fx.run(start2, end, unit);
  });
}
function stop$2(el, prop) {
  var i2 = Fx.timers.length;
  while (i2--) {
    if (Fx.timers[i2].elem === el && (!prop || prop === Fx.timers[i2].prop)) {
      Fx.timers[i2].stopped = true;
    }
  }
}
var animationExports = {
  animate: animate$2,
  animObject: animObject$d,
  getDeferredAnimation: getDeferredAnimation$3,
  setAnimation: setAnimation$5,
  stop: stop$2
};
var SVG_NS$3 = H.SVG_NS;
var attr$7 = Utilities.attr, createElement$a = Utilities.createElement, discardElement$6 = Utilities.discardElement, error$a = Utilities.error, isString$c = Utilities.isString, objectEach$z = Utilities.objectEach, splat$j = Utilities.splat;
var hasValidDOMParser = (function() {
  try {
    return Boolean(new DOMParser().parseFromString("", "text/html"));
  } catch (e) {
    return false;
  }
})();
var AST = (
  /** @class */
  (function() {
    function AST2(source) {
      this.nodes = typeof source === "string" ? this.parseMarkup(source) : source;
    }
    AST2.filterUserAttributes = function(attributes) {
      objectEach$z(attributes, function(val, key2) {
        var valid = true;
        if (AST2.allowedAttributes.indexOf(key2) === -1) {
          valid = false;
        }
        if (["background", "dynsrc", "href", "lowsrc", "src"].indexOf(key2) !== -1) {
          valid = isString$c(val) && AST2.allowedReferences.some(function(ref) {
            return val.indexOf(ref) === 0;
          });
        }
        if (!valid) {
          error$a("Highcharts warning: Invalid attribute '" + key2 + "' in config");
          delete attributes[key2];
        }
      });
      return attributes;
    };
    AST2.setElementHTML = function(el, html2) {
      el.innerHTML = "";
      if (html2) {
        var ast = new AST2(html2);
        ast.addToDOM(el);
      }
    };
    AST2.prototype.addToDOM = function(parent) {
      function recurse(subtree, subParent) {
        var ret;
        splat$j(subtree).forEach(function(item) {
          var tagName = item.tagName;
          var textNode = item.textContent ? H.doc.createTextNode(item.textContent) : void 0;
          var node;
          if (tagName) {
            if (tagName === "#text") {
              node = textNode;
            } else if (AST2.allowedTags.indexOf(tagName) !== -1) {
              var NS = tagName === "svg" ? SVG_NS$3 : subParent.namespaceURI || SVG_NS$3;
              var element = H.doc.createElementNS(NS, tagName);
              var attributes_1 = item.attributes || {};
              objectEach$z(item, function(val, key2) {
                if (key2 !== "tagName" && key2 !== "attributes" && key2 !== "children" && key2 !== "textContent") {
                  attributes_1[key2] = val;
                }
              });
              attr$7(element, AST2.filterUserAttributes(attributes_1));
              if (textNode) {
                element.appendChild(textNode);
              }
              recurse(item.children || [], element);
              node = element;
            } else {
              error$a("Highcharts warning: Invalid tagName '" + tagName + "' in config");
            }
          }
          if (node) {
            subParent.appendChild(node);
          }
          ret = node;
        });
        return ret;
      }
      return recurse(this.nodes, parent);
    };
    AST2.prototype.parseMarkup = function(markup) {
      var nodes = [];
      markup = markup.trim();
      var doc2;
      var body;
      if (hasValidDOMParser) {
        doc2 = new DOMParser().parseFromString(markup, "text/html");
      } else {
        body = createElement$a("div");
        body.innerHTML = markup;
        doc2 = { body };
      }
      var appendChildNodes = function(node, addTo) {
        var tagName = node.nodeName.toLowerCase();
        var astNode = {
          tagName
        };
        if (tagName === "#text") {
          astNode.textContent = node.textContent || "";
        }
        var parsedAttributes = node.attributes;
        if (parsedAttributes) {
          var attributes_2 = {};
          [].forEach.call(parsedAttributes, function(attrib) {
            attributes_2[attrib.name] = attrib.value;
          });
          astNode.attributes = attributes_2;
        }
        if (node.childNodes.length) {
          var children_1 = [];
          [].forEach.call(node.childNodes, function(childNode) {
            appendChildNodes(childNode, children_1);
          });
          if (children_1.length) {
            astNode.children = children_1;
          }
        }
        addTo.push(astNode);
      };
      [].forEach.call(doc2.body.childNodes, function(childNode) {
        return appendChildNodes(childNode, nodes);
      });
      if (body) {
        discardElement$6(body);
      }
      return nodes;
    };
    AST2.allowedAttributes = [
      "aria-controls",
      "aria-describedby",
      "aria-expanded",
      "aria-haspopup",
      "aria-hidden",
      "aria-label",
      "aria-labelledby",
      "aria-live",
      "aria-pressed",
      "aria-readonly",
      "aria-roledescription",
      "aria-selected",
      "class",
      "clip-path",
      "color",
      "colspan",
      "cx",
      "cy",
      "d",
      "dx",
      "dy",
      "disabled",
      "fill",
      "height",
      "href",
      "id",
      "in",
      "markerHeight",
      "markerWidth",
      "offset",
      "opacity",
      "orient",
      "padding",
      "paddingLeft",
      "paddingRight",
      "patternUnits",
      "r",
      "refX",
      "refY",
      "role",
      "scope",
      "slope",
      "src",
      "startOffset",
      "stdDeviation",
      "stroke",
      "stroke-linecap",
      "stroke-width",
      "style",
      "tableValues",
      "result",
      "rowspan",
      "summary",
      "target",
      "tabindex",
      "text-align",
      "textAnchor",
      "textLength",
      "type",
      "valign",
      "width",
      "x",
      "x1",
      "x2",
      "y",
      "y1",
      "y2",
      "zIndex"
    ];
    AST2.allowedReferences = [
      "https://",
      "http://",
      "mailto:",
      "/",
      "../",
      "./",
      "#"
    ];
    AST2.allowedTags = [
      "a",
      "b",
      "br",
      "button",
      "caption",
      "circle",
      "clipPath",
      "code",
      "dd",
      "defs",
      "div",
      "dl",
      "dt",
      "em",
      "feComponentTransfer",
      "feFuncA",
      "feFuncB",
      "feFuncG",
      "feFuncR",
      "feGaussianBlur",
      "feOffset",
      "feMerge",
      "feMergeNode",
      "filter",
      "h1",
      "h2",
      "h3",
      "h4",
      "h5",
      "h6",
      "hr",
      "i",
      "img",
      "li",
      "linearGradient",
      "marker",
      "ol",
      "p",
      "path",
      "pattern",
      "pre",
      "rect",
      "small",
      "span",
      "stop",
      "strong",
      "style",
      "sub",
      "sup",
      "svg",
      "table",
      "text",
      "thead",
      "tbody",
      "tspan",
      "td",
      "th",
      "tr",
      "u",
      "ul",
      "#text"
    ];
    return AST2;
  })()
);
var defaultOptions$i = DefaultOptions.defaultOptions, defaultTime$1 = DefaultOptions.defaultTime;
var getNestedProperty$2 = Utilities.getNestedProperty, isNumber$T = Utilities.isNumber, pick$1H = Utilities.pick, pInt$8 = Utilities.pInt;
function dateFormat(format2, timestamp, capitalize2) {
  return defaultTime$1.dateFormat(format2, timestamp, capitalize2);
}
function format$e(str, ctx, chart) {
  var splitter = "{", isInside = false, segment, valueAndFormat, val, index;
  var floatRegex = /f$/;
  var decRegex = /\.([0-9])/;
  var lang2 = defaultOptions$i.lang;
  var time = chart && chart.time || defaultTime$1;
  var numberFormatter = chart && chart.numberFormatter || numberFormat$2;
  var ret = [];
  while (str) {
    index = str.indexOf(splitter);
    if (index === -1) {
      break;
    }
    segment = str.slice(0, index);
    if (isInside) {
      valueAndFormat = segment.split(":");
      val = getNestedProperty$2(valueAndFormat.shift() || "", ctx);
      if (valueAndFormat.length && typeof val === "number") {
        segment = valueAndFormat.join(":");
        if (floatRegex.test(segment)) {
          var decimals = parseInt((segment.match(decRegex) || ["", "-1"])[1], 10);
          if (val !== null) {
            val = numberFormatter(val, decimals, lang2.decimalPoint, segment.indexOf(",") > -1 ? lang2.thousandsSep : "");
          }
        } else {
          val = time.dateFormat(segment, val);
        }
      }
      ret.push(val);
    } else {
      ret.push(segment);
    }
    str = str.slice(index + 1);
    isInside = !isInside;
    splitter = isInside ? "}" : "{";
  }
  ret.push(str);
  return ret.join("");
}
function numberFormat$2(number, decimals, decimalPoint, thousandsSep) {
  number = +number || 0;
  decimals = +decimals;
  var ret, fractionDigits;
  var lang2 = defaultOptions$i.lang, origDec = (number.toString().split(".")[1] || "").split("e")[0].length, exponent = number.toString().split("e"), firstDecimals = decimals;
  if (decimals === -1) {
    decimals = Math.min(origDec, 20);
  } else if (!isNumber$T(decimals)) {
    decimals = 2;
  } else if (decimals && exponent[1] && exponent[1] < 0) {
    fractionDigits = decimals + +exponent[1];
    if (fractionDigits >= 0) {
      exponent[0] = (+exponent[0]).toExponential(fractionDigits).split("e")[0];
      decimals = fractionDigits;
    } else {
      exponent[0] = exponent[0].split(".")[0] || 0;
      if (decimals < 20) {
        number = (exponent[0] * Math.pow(10, exponent[1])).toFixed(decimals);
      } else {
        number = 0;
      }
      exponent[1] = 0;
    }
  }
  var roundedNumber = (Math.abs(exponent[1] ? exponent[0] : number) + Math.pow(10, -Math.max(decimals, origDec) - 1)).toFixed(decimals);
  var strinteger = String(pInt$8(roundedNumber));
  var thousands = strinteger.length > 3 ? strinteger.length % 3 : 0;
  decimalPoint = pick$1H(decimalPoint, lang2.decimalPoint);
  thousandsSep = pick$1H(thousandsSep, lang2.thousandsSep);
  ret = number < 0 ? "-" : "";
  ret += thousands ? strinteger.substr(0, thousands) + thousandsSep : "";
  if (+exponent[1] < 0 && !firstDecimals) {
    ret = "0";
  } else {
    ret += strinteger.substr(thousands).replace(/(\d{3})(?=\d)/g, "$1" + thousandsSep);
  }
  if (decimals) {
    ret += decimalPoint + roundedNumber.slice(-decimals);
  }
  if (exponent[1] && +ret !== 0) {
    ret += "e" + exponent[1];
  }
  return ret;
}
var FormatUtilities = {
  dateFormat,
  format: format$e,
  numberFormat: numberFormat$2
};
var clamp$k = Utilities.clamp, pick$1G = Utilities.pick, stableSort$6 = Utilities.stableSort;
var RendererUtilities;
(function(RendererUtilities2) {
  function distribute2(boxes, len, maxDistance) {
    var origBoxes = boxes, reducedLen = origBoxes.reducedLen || len, sortByRank = function(a, b) {
      return (b.rank || 0) - (a.rank || 0);
    }, sortByTarget = function(a, b) {
      return a.target - b.target;
    };
    var i2, overlapping = true, restBoxes = [], box, target, total = 0;
    i2 = boxes.length;
    while (i2--) {
      total += boxes[i2].size;
    }
    if (total > reducedLen) {
      stableSort$6(boxes, sortByRank);
      i2 = 0;
      total = 0;
      while (total <= reducedLen) {
        total += boxes[i2].size;
        i2++;
      }
      restBoxes = boxes.splice(i2 - 1, boxes.length);
    }
    stableSort$6(boxes, sortByTarget);
    boxes = boxes.map(function(box2) {
      return {
        size: box2.size,
        targets: [box2.target],
        align: pick$1G(box2.align, 0.5)
      };
    });
    while (overlapping) {
      i2 = boxes.length;
      while (i2--) {
        box = boxes[i2];
        target = (Math.min.apply(0, box.targets) + Math.max.apply(0, box.targets)) / 2;
        box.pos = clamp$k(target - box.size * box.align, 0, len - box.size);
      }
      i2 = boxes.length;
      overlapping = false;
      while (i2--) {
        if (i2 > 0 && boxes[i2 - 1].pos + boxes[i2 - 1].size > boxes[i2].pos) {
          boxes[i2 - 1].size += boxes[i2].size;
          boxes[i2 - 1].targets = boxes[i2 - 1].targets.concat(boxes[i2].targets);
          boxes[i2 - 1].align = 0.5;
          if (boxes[i2 - 1].pos + boxes[i2 - 1].size > len) {
            boxes[i2 - 1].pos = len - boxes[i2 - 1].size;
          }
          boxes.splice(i2, 1);
          overlapping = true;
        }
      }
    }
    origBoxes.push.apply(origBoxes, restBoxes);
    i2 = 0;
    boxes.some(function(box2) {
      var posInCompositeBox = 0;
      return (box2.targets || []).some(function() {
        origBoxes[i2].pos = box2.pos + posInCompositeBox;
        if (typeof maxDistance !== "undefined" && Math.abs(origBoxes[i2].pos - origBoxes[i2].target) > maxDistance) {
          origBoxes.slice(0, i2 + 1).forEach(function(box3) {
            return delete box3.pos;
          });
          origBoxes.reducedLen = (origBoxes.reducedLen || len) - len * 0.1;
          if (origBoxes.reducedLen > len * 0.1) {
            distribute2(origBoxes, len, maxDistance);
          }
          return true;
        }
        posInCompositeBox += origBoxes[i2].size;
        i2++;
        return false;
      });
    });
    stableSort$6(origBoxes, sortByTarget);
    return origBoxes;
  }
  RendererUtilities2.distribute = distribute2;
})(RendererUtilities || (RendererUtilities = {}));
const R$1 = RendererUtilities;
var animate$1 = animationExports.animate, animObject$c = animationExports.animObject, stop$1 = animationExports.stop;
var deg2rad$9 = H.deg2rad, doc$l = H.doc, noop$k = H.noop, svg$6 = H.svg, SVG_NS$2 = H.SVG_NS, win$d = H.win;
var addEvent$18 = Utilities.addEvent, attr$6 = Utilities.attr, createElement$9 = Utilities.createElement, css$c = Utilities.css, defined$X = Utilities.defined, erase$9 = Utilities.erase, extend$1w = Utilities.extend, fireEvent$B = Utilities.fireEvent, isArray$o = Utilities.isArray, isFunction$4 = Utilities.isFunction, isNumber$S = Utilities.isNumber, isString$b = Utilities.isString, merge$1s = Utilities.merge, objectEach$y = Utilities.objectEach, pick$1F = Utilities.pick, pInt$7 = Utilities.pInt, syncTimeout$8 = Utilities.syncTimeout, uniqueKey$7 = Utilities.uniqueKey;
var SVGElement = (
  /** @class */
  (function() {
    function SVGElement2() {
      this.element = void 0;
      this.onEvents = {};
      this.opacity = 1;
      this.renderer = void 0;
      this.SVG_NS = SVG_NS$2;
      this.symbolCustomAttribs = [
        "x",
        "y",
        "width",
        "height",
        "r",
        "start",
        "end",
        "innerR",
        "anchorX",
        "anchorY",
        "rounded"
      ];
    }
    SVGElement2.prototype._defaultGetter = function(key2) {
      var ret = pick$1F(
        this[key2 + "Value"],
        // align getter
        this[key2],
        this.element ? this.element.getAttribute(key2) : null,
        0
      );
      if (/^[\-0-9\.]+$/.test(ret)) {
        ret = parseFloat(ret);
      }
      return ret;
    };
    SVGElement2.prototype._defaultSetter = function(value, key2, element) {
      element.setAttribute(key2, value);
    };
    SVGElement2.prototype.add = function(parent) {
      var renderer = this.renderer, element = this.element;
      var inserted;
      if (parent) {
        this.parentGroup = parent;
      }
      this.parentInverted = parent && parent.inverted;
      if (typeof this.textStr !== "undefined" && this.element.nodeName === "text") {
        renderer.buildText(this);
      }
      this.added = true;
      if (!parent || parent.handleZ || this.zIndex) {
        inserted = this.zIndexSetter();
      }
      if (!inserted) {
        (parent ? parent.element : renderer.box).appendChild(element);
      }
      if (this.onAdd) {
        this.onAdd();
      }
      return this;
    };
    SVGElement2.prototype.addClass = function(className, replace) {
      var currentClassName = replace ? "" : this.attr("class") || "";
      className = (className || "").split(/ /g).reduce(function(newClassName, name) {
        if (currentClassName.indexOf(name) === -1) {
          newClassName.push(name);
        }
        return newClassName;
      }, currentClassName ? [currentClassName] : []).join(" ");
      if (className !== currentClassName) {
        this.attr("class", className);
      }
      return this;
    };
    SVGElement2.prototype.afterSetters = function() {
      if (this.doTransform) {
        this.updateTransform();
        this.doTransform = false;
      }
    };
    SVGElement2.prototype.align = function(alignOptions, alignByTranslate, box) {
      var attribs = {}, renderer = this.renderer, alignedObjects = renderer.alignedObjects;
      var x, y, alignTo, alignFactor, vAlignFactor;
      if (alignOptions) {
        this.alignOptions = alignOptions;
        this.alignByTranslate = alignByTranslate;
        if (!box || isString$b(box)) {
          this.alignTo = alignTo = box || "renderer";
          erase$9(alignedObjects, this);
          alignedObjects.push(this);
          box = void 0;
        }
      } else {
        alignOptions = this.alignOptions;
        alignByTranslate = this.alignByTranslate;
        alignTo = this.alignTo;
      }
      box = pick$1F(box, renderer[alignTo], alignTo === "scrollablePlotBox" ? renderer.plotBox : void 0, renderer);
      var align = alignOptions.align, vAlign = alignOptions.verticalAlign;
      x = (box.x || 0) + (alignOptions.x || 0);
      y = (box.y || 0) + (alignOptions.y || 0);
      if (align === "right") {
        alignFactor = 1;
      } else if (align === "center") {
        alignFactor = 2;
      }
      if (alignFactor) {
        x += (box.width - (alignOptions.width || 0)) / alignFactor;
      }
      attribs[alignByTranslate ? "translateX" : "x"] = Math.round(x);
      if (vAlign === "bottom") {
        vAlignFactor = 1;
      } else if (vAlign === "middle") {
        vAlignFactor = 2;
      }
      if (vAlignFactor) {
        y += (box.height - (alignOptions.height || 0)) / vAlignFactor;
      }
      attribs[alignByTranslate ? "translateY" : "y"] = Math.round(y);
      this[this.placed ? "animate" : "attr"](attribs);
      this.placed = true;
      this.alignAttr = attribs;
      return this;
    };
    SVGElement2.prototype.alignSetter = function(value) {
      var convert = {
        left: "start",
        center: "middle",
        right: "end"
      };
      if (convert[value]) {
        this.alignValue = value;
        this.element.setAttribute("text-anchor", convert[value]);
      }
    };
    SVGElement2.prototype.animate = function(params2, options, complete) {
      var _this = this;
      var animOptions = animObject$c(pick$1F(options, this.renderer.globalAnimation, true)), deferTime = animOptions.defer;
      if (pick$1F(doc$l.hidden, doc$l.msHidden, doc$l.webkitHidden, false)) {
        animOptions.duration = 0;
      }
      if (animOptions.duration !== 0) {
        if (complete) {
          animOptions.complete = complete;
        }
        syncTimeout$8(function() {
          if (_this.element) {
            animate$1(_this, params2, animOptions);
          }
        }, deferTime);
      } else {
        this.attr(params2, void 0, complete);
        objectEach$y(params2, function(val, prop) {
          if (animOptions.step) {
            animOptions.step.call(this, val, { prop, pos: 1, elem: this });
          }
        }, this);
      }
      return this;
    };
    SVGElement2.prototype.applyTextOutline = function(textOutline) {
      var elem = this.element, hasContrast = textOutline.indexOf("contrast") !== -1;
      if (hasContrast) {
        textOutline = textOutline.replace(/contrast/g, this.renderer.getContrast(elem.style.fill));
      }
      var parts = textOutline.split(" ");
      var color2 = parts[parts.length - 1];
      var strokeWidth = parts[0];
      if (strokeWidth && strokeWidth !== "none" && H.svg) {
        this.fakeTS = true;
        this.ySetter = this.xSetter;
        strokeWidth = strokeWidth.replace(/(^[\d\.]+)(.*?)$/g, function(match2, digit, unit) {
          return 2 * Number(digit) + unit;
        });
        this.removeTextOutline();
        var outline_1 = doc$l.createElementNS(SVG_NS$2, "tspan");
        attr$6(outline_1, {
          "class": "highcharts-text-outline",
          fill: color2,
          stroke: color2,
          "stroke-width": strokeWidth,
          "stroke-linejoin": "round"
        });
        [].forEach.call(elem.childNodes, function(childNode) {
          var clone2 = childNode.cloneNode(true);
          if (clone2.removeAttribute) {
            ["fill", "stroke", "stroke-width", "stroke"].forEach(function(prop) {
              return clone2.removeAttribute(prop);
            });
          }
          outline_1.appendChild(clone2);
        });
        var br_1 = doc$l.createElementNS(SVG_NS$2, "tspan");
        br_1.textContent = "​";
        ["x", "y"].forEach(function(key2) {
          var value = elem.getAttribute(key2);
          if (value) {
            br_1.setAttribute(key2, value);
          }
        });
        outline_1.appendChild(br_1);
        elem.insertBefore(outline_1, elem.firstChild);
      }
    };
    SVGElement2.prototype.attr = function(hash2, val, complete, continueAnimation) {
      var element = this.element, symbolCustomAttribs = this.symbolCustomAttribs;
      var key2, hasSetSymbolSize, ret = this, skipAttr, setter;
      if (typeof hash2 === "string" && typeof val !== "undefined") {
        key2 = hash2;
        hash2 = {};
        hash2[key2] = val;
      }
      if (typeof hash2 === "string") {
        ret = (this[hash2 + "Getter"] || this._defaultGetter).call(this, hash2, element);
      } else {
        objectEach$y(hash2, function eachAttribute(val2, key3) {
          skipAttr = false;
          if (!continueAnimation) {
            stop$1(this, key3);
          }
          if (this.symbolName && symbolCustomAttribs.indexOf(key3) !== -1) {
            if (!hasSetSymbolSize) {
              this.symbolAttr(hash2);
              hasSetSymbolSize = true;
            }
            skipAttr = true;
          }
          if (this.rotation && (key3 === "x" || key3 === "y")) {
            this.doTransform = true;
          }
          if (!skipAttr) {
            setter = this[key3 + "Setter"] || this._defaultSetter;
            setter.call(this, val2, key3, element);
            if (!this.styledMode && this.shadows && /^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(key3)) {
              this.updateShadows(key3, val2, setter);
            }
          }
        }, this);
        this.afterSetters();
      }
      if (complete) {
        complete.call(this);
      }
      return ret;
    };
    SVGElement2.prototype.clip = function(clipRect) {
      return this.attr("clip-path", clipRect ? "url(" + this.renderer.url + "#" + clipRect.id + ")" : "none");
    };
    SVGElement2.prototype.crisp = function(rect2, strokeWidth) {
      var wrapper = this;
      strokeWidth = strokeWidth || rect2.strokeWidth || 0;
      var normalizer = Math.round(strokeWidth) % 2 / 2;
      rect2.x = Math.floor(rect2.x || wrapper.x || 0) + normalizer;
      rect2.y = Math.floor(rect2.y || wrapper.y || 0) + normalizer;
      rect2.width = Math.floor((rect2.width || wrapper.width || 0) - 2 * normalizer);
      rect2.height = Math.floor((rect2.height || wrapper.height || 0) - 2 * normalizer);
      if (defined$X(rect2.strokeWidth)) {
        rect2.strokeWidth = strokeWidth;
      }
      return rect2;
    };
    SVGElement2.prototype.complexColor = function(colorOptions, prop, elem) {
      var renderer = this.renderer;
      var colorObject, gradName, gradAttr, radAttr, gradients, stops, stopColor, stopOpacity, radialReference, id, key2 = [], value;
      fireEvent$B(this.renderer, "complexColor", {
        args: arguments
      }, function() {
        if (colorOptions.radialGradient) {
          gradName = "radialGradient";
        } else if (colorOptions.linearGradient) {
          gradName = "linearGradient";
        }
        if (gradName) {
          gradAttr = colorOptions[gradName];
          gradients = renderer.gradients;
          stops = colorOptions.stops;
          radialReference = elem.radialReference;
          if (isArray$o(gradAttr)) {
            colorOptions[gradName] = gradAttr = {
              x1: gradAttr[0],
              y1: gradAttr[1],
              x2: gradAttr[2],
              y2: gradAttr[3],
              gradientUnits: "userSpaceOnUse"
            };
          }
          if (gradName === "radialGradient" && radialReference && !defined$X(gradAttr.gradientUnits)) {
            radAttr = gradAttr;
            gradAttr = merge$1s(gradAttr, renderer.getRadialAttr(radialReference, radAttr), { gradientUnits: "userSpaceOnUse" });
          }
          objectEach$y(gradAttr, function(value2, n2) {
            if (n2 !== "id") {
              key2.push(n2, value2);
            }
          });
          objectEach$y(stops, function(val) {
            key2.push(val);
          });
          key2 = key2.join(",");
          if (gradients[key2]) {
            id = gradients[key2].attr("id");
          } else {
            gradAttr.id = id = uniqueKey$7();
            var gradientObject_1 = gradients[key2] = renderer.createElement(gradName).attr(gradAttr).add(renderer.defs);
            gradientObject_1.radAttr = radAttr;
            gradientObject_1.stops = [];
            stops.forEach(function(stop2) {
              if (stop2[1].indexOf("rgba") === 0) {
                colorObject = Color.parse(stop2[1]);
                stopColor = colorObject.get("rgb");
                stopOpacity = colorObject.get("a");
              } else {
                stopColor = stop2[1];
                stopOpacity = 1;
              }
              var stopObject = renderer.createElement("stop").attr({
                offset: stop2[0],
                "stop-color": stopColor,
                "stop-opacity": stopOpacity
              }).add(gradientObject_1);
              gradientObject_1.stops.push(stopObject);
            });
          }
          value = "url(" + renderer.url + "#" + id + ")";
          elem.setAttribute(prop, value);
          elem.gradient = key2;
          colorOptions.toString = function() {
            return value;
          };
        }
      });
    };
    SVGElement2.prototype.css = function(styles) {
      var oldStyles = this.styles, newStyles = {}, elem = this.element, svgPseudoProps = ["textOutline", "textOverflow", "width"];
      var textWidth, serializedCss = "", hyphenate, hasNew = !oldStyles;
      if (styles && styles.color) {
        styles.fill = styles.color;
      }
      if (oldStyles) {
        objectEach$y(styles, function(style, n2) {
          if (oldStyles && oldStyles[n2] !== style) {
            newStyles[n2] = style;
            hasNew = true;
          }
        });
      }
      if (hasNew) {
        if (oldStyles) {
          styles = extend$1w(oldStyles, newStyles);
        }
        if (styles) {
          if (styles.width === null || styles.width === "auto") {
            delete this.textWidth;
          } else if (elem.nodeName.toLowerCase() === "text" && styles.width) {
            textWidth = this.textWidth = pInt$7(styles.width);
          }
        }
        this.styles = styles;
        if (textWidth && (!svg$6 && this.renderer.forExport)) {
          delete styles.width;
        }
        if (elem.namespaceURI === this.SVG_NS) {
          hyphenate = function(a, b) {
            return "-" + b.toLowerCase();
          };
          objectEach$y(styles, function(style, n2) {
            if (svgPseudoProps.indexOf(n2) === -1) {
              serializedCss += n2.replace(/([A-Z])/g, hyphenate) + ":" + style + ";";
            }
          });
          if (serializedCss) {
            attr$6(elem, "style", serializedCss);
          }
        } else {
          css$c(elem, styles);
        }
        if (this.added) {
          if (this.element.nodeName === "text") {
            this.renderer.buildText(this);
          }
          if (styles && styles.textOutline) {
            this.applyTextOutline(styles.textOutline);
          }
        }
      }
      return this;
    };
    SVGElement2.prototype.dashstyleSetter = function(value) {
      var i2, strokeWidth = this["stroke-width"];
      if (strokeWidth === "inherit") {
        strokeWidth = 1;
      }
      value = value && value.toLowerCase();
      if (value) {
        var v = value.replace("shortdashdotdot", "3,1,1,1,1,1,").replace("shortdashdot", "3,1,1,1").replace("shortdot", "1,1,").replace("shortdash", "3,1,").replace("longdash", "8,3,").replace(/dot/g, "1,3,").replace("dash", "4,3,").replace(/,$/, "").split(",");
        i2 = v.length;
        while (i2--) {
          v[i2] = "" + pInt$7(v[i2]) * pick$1F(strokeWidth, NaN);
        }
        value = v.join(",").replace(/NaN/g, "none");
        this.element.setAttribute("stroke-dasharray", value);
      }
    };
    SVGElement2.prototype.destroy = function() {
      var wrapper = this, element = wrapper.element || {}, renderer = wrapper.renderer, ownerSVGElement = element.ownerSVGElement;
      var parentToClean = renderer.isSVG && element.nodeName === "SPAN" && wrapper.parentGroup || void 0, grandParent, i2;
      element.onclick = element.onmouseout = element.onmouseover = element.onmousemove = element.point = null;
      stop$1(wrapper);
      if (wrapper.clipPath && ownerSVGElement) {
        var clipPath_1 = wrapper.clipPath;
        [].forEach.call(ownerSVGElement.querySelectorAll("[clip-path],[CLIP-PATH]"), function(el) {
          if (el.getAttribute("clip-path").indexOf(clipPath_1.element.id) > -1) {
            el.removeAttribute("clip-path");
          }
        });
        wrapper.clipPath = clipPath_1.destroy();
      }
      if (wrapper.stops) {
        for (i2 = 0; i2 < wrapper.stops.length; i2++) {
          wrapper.stops[i2].destroy();
        }
        wrapper.stops.length = 0;
        wrapper.stops = void 0;
      }
      wrapper.safeRemoveChild(element);
      if (!renderer.styledMode) {
        wrapper.destroyShadows();
      }
      while (parentToClean && parentToClean.div && parentToClean.div.childNodes.length === 0) {
        grandParent = parentToClean.parentGroup;
        wrapper.safeRemoveChild(parentToClean.div);
        delete parentToClean.div;
        parentToClean = grandParent;
      }
      if (wrapper.alignTo) {
        erase$9(renderer.alignedObjects, wrapper);
      }
      objectEach$y(wrapper, function(val, key2) {
        if (wrapper[key2] && wrapper[key2].parentGroup === wrapper && wrapper[key2].destroy) {
          wrapper[key2].destroy();
        }
        delete wrapper[key2];
      });
      return;
    };
    SVGElement2.prototype.destroyShadows = function() {
      (this.shadows || []).forEach(function(shadow) {
        this.safeRemoveChild(shadow);
      }, this);
      this.shadows = void 0;
    };
    SVGElement2.prototype.destroyTextPath = function(elem, path) {
      var textElement = elem.getElementsByTagName("text")[0];
      var childNodes;
      if (textElement) {
        textElement.removeAttribute("dx");
        textElement.removeAttribute("dy");
        path.element.setAttribute("id", "");
        if (this.textPathWrapper && textElement.getElementsByTagName("textPath").length) {
          childNodes = this.textPathWrapper.element.childNodes;
          while (childNodes.length) {
            textElement.appendChild(childNodes[0]);
          }
          textElement.removeChild(this.textPathWrapper.element);
        }
      } else if (elem.getAttribute("dx") || elem.getAttribute("dy")) {
        elem.removeAttribute("dx");
        elem.removeAttribute("dy");
      }
      if (this.textPathWrapper) {
        this.textPathWrapper = this.textPathWrapper.destroy();
      }
    };
    SVGElement2.prototype.dSetter = function(value, key2, element) {
      if (isArray$o(value)) {
        if (typeof value[0] === "string") {
          value = this.renderer.pathToSegments(value);
        }
        this.pathArray = value;
        value = value.reduce(function(acc, seg, i2) {
          if (!seg || !seg.join) {
            return (seg || "").toString();
          }
          return (i2 ? acc + " " : "") + seg.join(" ");
        }, "");
      }
      if (/(NaN| {2}|^$)/.test(value)) {
        value = "M 0 0";
      }
      if (this[key2] !== value) {
        element.setAttribute(key2, value);
        this[key2] = value;
      }
    };
    SVGElement2.prototype.fadeOut = function(duration) {
      var elemWrapper = this;
      elemWrapper.animate({
        opacity: 0
      }, {
        duration: pick$1F(duration, 150),
        complete: function() {
          elemWrapper.attr({ y: -9999 }).hide();
        }
      });
    };
    SVGElement2.prototype.fillSetter = function(value, key2, element) {
      if (typeof value === "string") {
        element.setAttribute(key2, value);
      } else if (value) {
        this.complexColor(value, key2, element);
      }
    };
    SVGElement2.prototype.getBBox = function(reload, rot) {
      var wrapper = this, renderer = wrapper.renderer, element = wrapper.element, styles = wrapper.styles, textStr = wrapper.textStr, cache2 = renderer.cache, cacheKeys = renderer.cacheKeys, isSVG = element.namespaceURI === wrapper.SVG_NS, rotation = pick$1F(rot, wrapper.rotation, 0), fontSize = renderer.styledMode ? element && SVGElement2.prototype.getStyle.call(element, "font-size") : styles && styles.fontSize;
      var bBox, width, height, toggleTextShadowShim, cacheKey;
      if (defined$X(textStr)) {
        cacheKey = textStr.toString();
        if (cacheKey.indexOf("<") === -1) {
          cacheKey = cacheKey.replace(/[0-9]/g, "0");
        }
        cacheKey += [
          "",
          rotation,
          fontSize,
          wrapper.textWidth,
          styles && styles.textOverflow,
          styles && styles.fontWeight
          // #12163
        ].join(",");
      }
      if (cacheKey && !reload) {
        bBox = cache2[cacheKey];
      }
      if (!bBox) {
        if (isSVG || renderer.forExport) {
          try {
            toggleTextShadowShim = this.fakeTS && function(display) {
              var outline = element.querySelector(".highcharts-text-outline");
              if (outline) {
                css$c(outline, { display });
              }
            };
            if (isFunction$4(toggleTextShadowShim)) {
              toggleTextShadowShim("none");
            }
            bBox = element.getBBox ? (
              // SVG: use extend because IE9 is not allowed to change
              // width and height in case of rotation (below)
              extend$1w({}, element.getBBox())
            ) : {
              // Legacy IE in export mode
              width: element.offsetWidth,
              height: element.offsetHeight
            };
            if (isFunction$4(toggleTextShadowShim)) {
              toggleTextShadowShim("");
            }
          } catch (e) {
          }
          if (!bBox || bBox.width < 0) {
            bBox = { width: 0, height: 0 };
          }
        } else {
          bBox = wrapper.htmlGetBBox();
        }
        if (renderer.isSVG) {
          width = bBox.width;
          height = bBox.height;
          if (isSVG) {
            bBox.height = height = {
              "11px,17": 14,
              "13px,20": 16
            }[styles && styles.fontSize + "," + Math.round(height)] || height;
          }
          if (rotation) {
            var rad = rotation * deg2rad$9;
            bBox.width = Math.abs(height * Math.sin(rad)) + Math.abs(width * Math.cos(rad));
            bBox.height = Math.abs(height * Math.cos(rad)) + Math.abs(width * Math.sin(rad));
          }
        }
        if (cacheKey && (textStr === "" || bBox.height > 0)) {
          while (cacheKeys.length > 250) {
            delete cache2[cacheKeys.shift()];
          }
          if (!cache2[cacheKey]) {
            cacheKeys.push(cacheKey);
          }
          cache2[cacheKey] = bBox;
        }
      }
      return bBox;
    };
    SVGElement2.prototype.getStyle = function(prop) {
      return win$d.getComputedStyle(this.element || this, "").getPropertyValue(prop);
    };
    SVGElement2.prototype.hasClass = function(className) {
      return ("" + this.attr("class")).split(" ").indexOf(className) !== -1;
    };
    SVGElement2.prototype.hide = function(hideByTranslation) {
      if (hideByTranslation) {
        this.attr({ y: -9999 });
      } else {
        this.attr({ visibility: "hidden" });
      }
      return this;
    };
    SVGElement2.prototype.htmlGetBBox = function() {
      return { height: 0, width: 0, x: 0, y: 0 };
    };
    SVGElement2.prototype.init = function(renderer, nodeName) {
      this.element = nodeName === "span" ? createElement$9(nodeName) : doc$l.createElementNS(this.SVG_NS, nodeName);
      this.renderer = renderer;
      fireEvent$B(this, "afterInit");
    };
    SVGElement2.prototype.invert = function(inverted) {
      this.inverted = inverted;
      this.updateTransform();
      return this;
    };
    SVGElement2.prototype.on = function(eventType, handler) {
      var onEvents = this.onEvents;
      if (onEvents[eventType]) {
        onEvents[eventType]();
      }
      onEvents[eventType] = addEvent$18(this.element, eventType, handler);
      return this;
    };
    SVGElement2.prototype.opacitySetter = function(value, key2, element) {
      var opacity = Number(Number(value).toFixed(3));
      this.opacity = opacity;
      element.setAttribute(key2, opacity);
    };
    SVGElement2.prototype.removeClass = function(className) {
      return this.attr("class", ("" + this.attr("class")).replace(isString$b(className) ? new RegExp("(^| )" + className + "( |$)") : (
        // #12064, #13590
        className
      ), " ").replace(/ +/g, " ").trim());
    };
    SVGElement2.prototype.removeTextOutline = function() {
      var outline = this.element.querySelector("tspan.highcharts-text-outline");
      if (outline) {
        this.safeRemoveChild(outline);
      }
    };
    SVGElement2.prototype.safeRemoveChild = function(element) {
      var parentNode = element.parentNode;
      if (parentNode) {
        parentNode.removeChild(element);
      }
    };
    SVGElement2.prototype.setRadialReference = function(coordinates2) {
      var existingGradient = this.element.gradient && this.renderer.gradients[this.element.gradient];
      this.element.radialReference = coordinates2;
      if (existingGradient && existingGradient.radAttr) {
        existingGradient.animate(this.renderer.getRadialAttr(coordinates2, existingGradient.radAttr));
      }
      return this;
    };
    SVGElement2.prototype.setTextPath = function(path, textPathOptions) {
      var elem = this.element, textNode = this.text ? this.text.element : elem, attribsMap = {
        textAnchor: "text-anchor"
      };
      var adder = false, textPathElement, textPathId, textPathWrapper = this.textPathWrapper, firstTime = !textPathWrapper;
      textPathOptions = merge$1s(true, {
        enabled: true,
        attributes: {
          dy: -5,
          startOffset: "50%",
          textAnchor: "middle"
        }
      }, textPathOptions);
      var attrs = AST.filterUserAttributes(textPathOptions.attributes);
      if (path && textPathOptions && textPathOptions.enabled) {
        if (textPathWrapper && textPathWrapper.element.parentNode === null) {
          firstTime = true;
          textPathWrapper = textPathWrapper.destroy();
        } else if (textPathWrapper) {
          this.removeTextOutline.call(textPathWrapper.parentGroup);
        }
        if (this.options && this.options.padding) {
          attrs.dx = -this.options.padding;
        }
        if (!textPathWrapper) {
          this.textPathWrapper = textPathWrapper = this.renderer.createElement("textPath");
          adder = true;
        }
        textPathElement = textPathWrapper.element;
        textPathId = path.element.getAttribute("id");
        if (!textPathId) {
          path.element.setAttribute("id", textPathId = uniqueKey$7());
        }
        if (firstTime) {
          textNode.setAttribute("y", 0);
          if (isNumber$S(attrs.dx)) {
            textNode.setAttribute("x", -attrs.dx);
          }
          var childNodes = [].slice.call(textNode.childNodes);
          for (var i2 = 0; i2 < childNodes.length; i2++) {
            var childNode = childNodes[i2];
            if (childNode.nodeType === Node.TEXT_NODE || childNode.nodeName === "tspan") {
              textPathElement.appendChild(childNode);
            }
          }
        }
        if (adder && textPathWrapper) {
          textPathWrapper.add({ element: textNode });
        }
        textPathElement.setAttributeNS("http://www.w3.org/1999/xlink", "href", this.renderer.url + "#" + textPathId);
        if (defined$X(attrs.dy)) {
          textPathElement.parentNode.setAttribute("dy", attrs.dy);
          delete attrs.dy;
        }
        if (defined$X(attrs.dx)) {
          textPathElement.parentNode.setAttribute("dx", attrs.dx);
          delete attrs.dx;
        }
        objectEach$y(attrs, function(val, key2) {
          textPathElement.setAttribute(attribsMap[key2] || key2, val);
        });
        elem.removeAttribute("transform");
        this.removeTextOutline.call(textPathWrapper);
        if (this.text && !this.renderer.styledMode) {
          this.attr({
            fill: "none",
            "stroke-width": 0
          });
        }
        this.updateTransform = noop$k;
        this.applyTextOutline = noop$k;
      } else if (textPathWrapper) {
        delete this.updateTransform;
        delete this.applyTextOutline;
        this.destroyTextPath(elem, path);
        this.updateTransform();
        if (this.options && this.options.rotation) {
          this.applyTextOutline(this.options.style.textOutline);
        }
      }
      return this;
    };
    SVGElement2.prototype.shadow = function(shadowOptions, group2, cutOff) {
      var shadows = [], element = this.element, oldShadowOptions = this.oldShadowOptions, defaultShadowOptions = {
        color: palette.neutralColor100,
        offsetX: this.parentInverted ? -1 : 1,
        offsetY: this.parentInverted ? -1 : 1,
        opacity: 0.15,
        width: 3
      };
      var i2, shadow, strokeWidth, shadowElementOpacity, update = false, transform2, options;
      if (shadowOptions === true) {
        options = defaultShadowOptions;
      } else if (typeof shadowOptions === "object") {
        options = extend$1w(defaultShadowOptions, shadowOptions);
      }
      if (options) {
        if (options && oldShadowOptions) {
          objectEach$y(options, function(value, key2) {
            if (value !== oldShadowOptions[key2]) {
              update = true;
            }
          });
        }
        if (update) {
          this.destroyShadows();
        }
        this.oldShadowOptions = options;
      }
      if (!options) {
        this.destroyShadows();
      } else if (!this.shadows) {
        shadowElementOpacity = options.opacity / options.width;
        transform2 = this.parentInverted ? "translate(" + options.offsetY + ", " + options.offsetX + ")" : "translate(" + options.offsetX + ", " + options.offsetY + ")";
        for (i2 = 1; i2 <= options.width; i2++) {
          shadow = element.cloneNode(false);
          strokeWidth = options.width * 2 + 1 - 2 * i2;
          attr$6(shadow, {
            stroke: shadowOptions.color || palette.neutralColor100,
            "stroke-opacity": shadowElementOpacity * i2,
            "stroke-width": strokeWidth,
            transform: transform2,
            fill: "none"
          });
          shadow.setAttribute("class", (shadow.getAttribute("class") || "") + " highcharts-shadow");
          if (cutOff) {
            attr$6(shadow, "height", Math.max(attr$6(shadow, "height") - strokeWidth, 0));
            shadow.cutHeight = strokeWidth;
          }
          if (group2) {
            group2.element.appendChild(shadow);
          } else if (element.parentNode) {
            element.parentNode.insertBefore(shadow, element);
          }
          shadows.push(shadow);
        }
        this.shadows = shadows;
      }
      return this;
    };
    SVGElement2.prototype.show = function(inherit) {
      return this.attr({ visibility: inherit ? "inherit" : "visible" });
    };
    SVGElement2.prototype.strokeSetter = function(value, key2, element) {
      this[key2] = value;
      if (this.stroke && this["stroke-width"]) {
        SVGElement2.prototype.fillSetter.call(this, this.stroke, "stroke", element);
        element.setAttribute("stroke-width", this["stroke-width"]);
        this.hasStroke = true;
      } else if (key2 === "stroke-width" && value === 0 && this.hasStroke) {
        element.removeAttribute("stroke");
        this.hasStroke = false;
      } else if (this.renderer.styledMode && this["stroke-width"]) {
        element.setAttribute("stroke-width", this["stroke-width"]);
        this.hasStroke = true;
      }
    };
    SVGElement2.prototype.strokeWidth = function() {
      if (!this.renderer.styledMode) {
        return this["stroke-width"] || 0;
      }
      var val = this.getStyle("stroke-width");
      var ret = 0, dummy;
      if (val.indexOf("px") === val.length - 2) {
        ret = pInt$7(val);
      } else if (val !== "") {
        dummy = doc$l.createElementNS(SVG_NS$2, "rect");
        attr$6(dummy, {
          width: val,
          "stroke-width": 0
        });
        this.element.parentNode.appendChild(dummy);
        ret = dummy.getBBox().width;
        dummy.parentNode.removeChild(dummy);
      }
      return ret;
    };
    SVGElement2.prototype.symbolAttr = function(hash2) {
      var wrapper = this;
      [
        "x",
        "y",
        "r",
        "start",
        "end",
        "width",
        "height",
        "innerR",
        "anchorX",
        "anchorY",
        "clockwise"
      ].forEach(function(key2) {
        wrapper[key2] = pick$1F(hash2[key2], wrapper[key2]);
      });
      wrapper.attr({
        d: wrapper.renderer.symbols[wrapper.symbolName](wrapper.x, wrapper.y, wrapper.width, wrapper.height, wrapper)
      });
    };
    SVGElement2.prototype.textSetter = function(value) {
      if (value !== this.textStr) {
        delete this.textPxLength;
        this.textStr = value;
        if (this.added) {
          this.renderer.buildText(this);
        }
      }
    };
    SVGElement2.prototype.titleSetter = function(value) {
      var el = this.element;
      var titleNode = el.getElementsByTagName("title")[0] || doc$l.createElementNS(this.SVG_NS, "title");
      if (el.insertBefore) {
        el.insertBefore(titleNode, el.firstChild);
      } else {
        el.appendChild(titleNode);
      }
      titleNode.textContent = // #3276, #3895
      String(pick$1F(value, "")).replace(/<[^>]*>/g, "").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
    };
    SVGElement2.prototype.toFront = function() {
      var element = this.element;
      element.parentNode.appendChild(element);
      return this;
    };
    SVGElement2.prototype.translate = function(x, y) {
      return this.attr({
        translateX: x,
        translateY: y
      });
    };
    SVGElement2.prototype.updateShadows = function(key2, value, setter) {
      var shadows = this.shadows;
      if (shadows) {
        var i2 = shadows.length;
        while (i2--) {
          setter.call(shadows[i2], key2 === "height" ? Math.max(value - (shadows[i2].cutHeight || 0), 0) : key2 === "d" ? this.d : value, key2, shadows[i2]);
        }
      }
    };
    SVGElement2.prototype.updateTransform = function() {
      var wrapper = this, scaleX = wrapper.scaleX, scaleY = wrapper.scaleY, inverted = wrapper.inverted, rotation = wrapper.rotation, matrix = wrapper.matrix, element = wrapper.element;
      var translateX = wrapper.translateX || 0, translateY = wrapper.translateY || 0;
      if (inverted) {
        translateX += wrapper.width;
        translateY += wrapper.height;
      }
      var transform2 = ["translate(" + translateX + "," + translateY + ")"];
      if (defined$X(matrix)) {
        transform2.push("matrix(" + matrix.join(",") + ")");
      }
      if (inverted) {
        transform2.push("rotate(90) scale(-1,1)");
      } else if (rotation) {
        transform2.push("rotate(" + rotation + " " + pick$1F(this.rotationOriginX, element.getAttribute("x"), 0) + " " + pick$1F(this.rotationOriginY, element.getAttribute("y") || 0) + ")");
      }
      if (defined$X(scaleX) || defined$X(scaleY)) {
        transform2.push("scale(" + pick$1F(scaleX, 1) + " " + pick$1F(scaleY, 1) + ")");
      }
      if (transform2.length) {
        element.setAttribute("transform", transform2.join(" "));
      }
    };
    SVGElement2.prototype.visibilitySetter = function(value, key2, element) {
      if (value === "inherit") {
        element.removeAttribute(key2);
      } else if (this[key2] !== value) {
        element.setAttribute(key2, value);
      }
      this[key2] = value;
    };
    SVGElement2.prototype.xGetter = function(key2) {
      if (this.element.nodeName === "circle") {
        if (key2 === "x") {
          key2 = "cx";
        } else if (key2 === "y") {
          key2 = "cy";
        }
      }
      return this._defaultGetter(key2);
    };
    SVGElement2.prototype.zIndexSetter = function(value, key2) {
      var renderer = this.renderer, parentGroup = this.parentGroup, parentWrapper = parentGroup || renderer, parentNode = parentWrapper.element || renderer.box, element = this.element, svgParent = parentNode === renderer.box;
      var childNodes, otherElement, otherZIndex, inserted = false, undefinedOtherZIndex, run = this.added, i2;
      if (defined$X(value)) {
        element.setAttribute("data-z-index", value);
        value = +value;
        if (this[key2] === value) {
          run = false;
        }
      } else if (defined$X(this[key2])) {
        element.removeAttribute("data-z-index");
      }
      this[key2] = value;
      if (run) {
        value = this.zIndex;
        if (value && parentGroup) {
          parentGroup.handleZ = true;
        }
        childNodes = parentNode.childNodes;
        for (i2 = childNodes.length - 1; i2 >= 0 && !inserted; i2--) {
          otherElement = childNodes[i2];
          otherZIndex = otherElement.getAttribute("data-z-index");
          undefinedOtherZIndex = !defined$X(otherZIndex);
          if (otherElement !== element) {
            if (
              // Negative zIndex versus no zIndex:
              // On all levels except the highest. If the parent is
              // <svg>, then we don't want to put items before <desc>
              // or <defs>
              value < 0 && undefinedOtherZIndex && !svgParent && !i2
            ) {
              parentNode.insertBefore(element, childNodes[i2]);
              inserted = true;
            } else if (
              // Insert after the first element with a lower zIndex
              pInt$7(otherZIndex) <= value || // If negative zIndex, add this before first undefined
              // zIndex element
              undefinedOtherZIndex && (!defined$X(value) || value >= 0)
            ) {
              parentNode.insertBefore(
                element,
                childNodes[i2 + 1] || null
                // null for oldIE export
              );
              inserted = true;
            }
          }
        }
        if (!inserted) {
          parentNode.insertBefore(
            element,
            childNodes[svgParent ? 3 : 0] || null
            // null for oldIE
          );
          inserted = true;
        }
      }
      return inserted;
    };
    return SVGElement2;
  })()
);
SVGElement.prototype["stroke-widthSetter"] = SVGElement.prototype.strokeSetter;
SVGElement.prototype.yGetter = SVGElement.prototype.xGetter;
SVGElement.prototype.matrixSetter = SVGElement.prototype.rotationOriginXSetter = SVGElement.prototype.rotationOriginYSetter = SVGElement.prototype.rotationSetter = SVGElement.prototype.scaleXSetter = SVGElement.prototype.scaleYSetter = SVGElement.prototype.translateXSetter = SVGElement.prototype.translateYSetter = SVGElement.prototype.verticalAlignSetter = function(value, key2) {
  this[key2] = value;
  this.doTransform = true;
};
var RendererRegistry;
(function(RendererRegistry2) {
  RendererRegistry2.rendererTypes = {};
  var defaultRenderer;
  function getRendererType(rendererType) {
    if (rendererType === void 0) {
      rendererType = defaultRenderer;
    }
    return RendererRegistry2.rendererTypes[rendererType] || RendererRegistry2.rendererTypes[defaultRenderer];
  }
  RendererRegistry2.getRendererType = getRendererType;
  function registerRendererType(rendererType, rendererClass, setAsDefault) {
    RendererRegistry2.rendererTypes[rendererType] = rendererClass;
    if (!defaultRenderer || setAsDefault) {
      defaultRenderer = rendererType;
      H.Renderer = rendererClass;
    }
  }
  RendererRegistry2.registerRendererType = registerRendererType;
})(RendererRegistry || (RendererRegistry = {}));
const RendererRegistry$1 = RendererRegistry;
var __extends$$ = /* @__PURE__ */ (function() {
  var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b3) {
      d2.__proto__ = b3;
    } || function(d2, b3) {
      for (var p in b3) if (b3.hasOwnProperty(p)) d2[p] = b3[p];
    };
    return extendStatics(d, b);
  };
  return function(d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
})();
var defined$W = Utilities.defined, extend$1v = Utilities.extend, isNumber$R = Utilities.isNumber, merge$1r = Utilities.merge, pick$1E = Utilities.pick, removeEvent$b = Utilities.removeEvent;
var SVGLabel = (
  /** @class */
  (function(_super) {
    __extends$$(SVGLabel2, _super);
    function SVGLabel2(renderer, str, x, y, shape, anchorX, anchorY, useHTML, baseline, className) {
      var _this = _super.call(this) || this;
      _this.paddingLeftSetter = _this.paddingSetter;
      _this.paddingRightSetter = _this.paddingSetter;
      _this.init(renderer, "g");
      _this.textStr = str;
      _this.x = x;
      _this.y = y;
      _this.anchorX = anchorX;
      _this.anchorY = anchorY;
      _this.baseline = baseline;
      _this.className = className;
      _this.addClass(className === "button" ? "highcharts-no-tooltip" : "highcharts-label");
      if (className) {
        _this.addClass("highcharts-" + className);
      }
      _this.text = renderer.text(void 0, 0, 0, useHTML).attr({ zIndex: 1 });
      var hasBGImage;
      if (typeof shape === "string") {
        hasBGImage = /^url\((.*?)\)$/.test(shape);
        if (hasBGImage || _this.renderer.symbols[shape]) {
          _this.symbolKey = shape;
        }
      }
      _this.bBox = SVGLabel2.emptyBBox;
      _this.padding = 3;
      _this.baselineOffset = 0;
      _this.needsBox = renderer.styledMode || hasBGImage;
      _this.deferredAttr = {};
      _this.alignFactor = 0;
      return _this;
    }
    SVGLabel2.prototype.alignSetter = function(value) {
      var alignFactor = {
        left: 0,
        center: 0.5,
        right: 1
      }[value];
      if (alignFactor !== this.alignFactor) {
        this.alignFactor = alignFactor;
        if (this.bBox && isNumber$R(this.xSetting)) {
          this.attr({ x: this.xSetting });
        }
      }
    };
    SVGLabel2.prototype.anchorXSetter = function(value, key2) {
      this.anchorX = value;
      this.boxAttr(key2, Math.round(value) - this.getCrispAdjust() - this.xSetting);
    };
    SVGLabel2.prototype.anchorYSetter = function(value, key2) {
      this.anchorY = value;
      this.boxAttr(key2, value - this.ySetting);
    };
    SVGLabel2.prototype.boxAttr = function(key2, value) {
      if (this.box) {
        this.box.attr(key2, value);
      } else {
        this.deferredAttr[key2] = value;
      }
    };
    SVGLabel2.prototype.css = function(styles) {
      if (styles) {
        var textStyles_1 = {};
        styles = merge$1r(styles);
        SVGLabel2.textProps.forEach(function(prop) {
          if (typeof styles[prop] !== "undefined") {
            textStyles_1[prop] = styles[prop];
            delete styles[prop];
          }
        });
        this.text.css(textStyles_1);
        var isWidth = "width" in textStyles_1, isFontStyle = "fontSize" in textStyles_1 || "fontWeight" in textStyles_1;
        if (isFontStyle) {
          this.updateTextPadding();
        } else if (isWidth) {
          this.updateBoxSize();
        }
      }
      return SVGElement.prototype.css.call(this, styles);
    };
    SVGLabel2.prototype.destroy = function() {
      removeEvent$b(this.element, "mouseenter");
      removeEvent$b(this.element, "mouseleave");
      if (this.text) {
        this.text.destroy();
      }
      if (this.box) {
        this.box = this.box.destroy();
      }
      SVGElement.prototype.destroy.call(this);
      return void 0;
    };
    SVGLabel2.prototype.fillSetter = function(value, key2) {
      if (value) {
        this.needsBox = true;
      }
      this.fill = value;
      this.boxAttr(key2, value);
    };
    SVGLabel2.prototype.getBBox = function() {
      if (this.textStr && this.bBox.width === 0 && this.bBox.height === 0) {
        this.updateBoxSize();
      }
      var padding = this.padding;
      var paddingLeft = pick$1E(this.paddingLeft, padding);
      return {
        width: this.width,
        height: this.height,
        x: this.bBox.x - paddingLeft,
        y: this.bBox.y - padding
      };
    };
    SVGLabel2.prototype.getCrispAdjust = function() {
      return this.renderer.styledMode && this.box ? this.box.strokeWidth() % 2 / 2 : (this["stroke-width"] ? parseInt(this["stroke-width"], 10) : 0) % 2 / 2;
    };
    SVGLabel2.prototype.heightSetter = function(value) {
      this.heightSetting = value;
    };
    SVGLabel2.prototype.onAdd = function() {
      var str = this.textStr;
      this.text.add(this);
      this.attr({
        // Alignment is available now  (#3295, 0 not rendered if given
        // as a value)
        text: defined$W(str) ? str : "",
        x: this.x,
        y: this.y
      });
      if (this.box && defined$W(this.anchorX)) {
        this.attr({
          anchorX: this.anchorX,
          anchorY: this.anchorY
        });
      }
    };
    SVGLabel2.prototype.paddingSetter = function(value, key2) {
      if (!isNumber$R(value)) {
        this[key2] = void 0;
      } else if (value !== this[key2]) {
        this[key2] = value;
        this.updateTextPadding();
      }
    };
    SVGLabel2.prototype.rSetter = function(value, key2) {
      this.boxAttr(key2, value);
    };
    SVGLabel2.prototype.shadow = function(b) {
      if (b && !this.renderer.styledMode) {
        this.updateBoxSize();
        if (this.box) {
          this.box.shadow(b);
        }
      }
      return this;
    };
    SVGLabel2.prototype.strokeSetter = function(value, key2) {
      this.stroke = value;
      this.boxAttr(key2, value);
    };
    SVGLabel2.prototype["stroke-widthSetter"] = function(value, key2) {
      if (value) {
        this.needsBox = true;
      }
      this["stroke-width"] = value;
      this.boxAttr(key2, value);
    };
    SVGLabel2.prototype["text-alignSetter"] = function(value) {
      this.textAlign = value;
    };
    SVGLabel2.prototype.textSetter = function(text2) {
      if (typeof text2 !== "undefined") {
        this.text.attr({ text: text2 });
      }
      this.updateTextPadding();
    };
    SVGLabel2.prototype.updateBoxSize = function() {
      var style = this.text.element.style, attribs = {}, padding = this.padding, bBox = this.bBox = (!isNumber$R(this.widthSetting) || !isNumber$R(this.heightSetting) || this.textAlign) && defined$W(this.text.textStr) ? this.text.getBBox() : SVGLabel2.emptyBBox;
      var crispAdjust;
      this.width = this.getPaddedWidth();
      this.height = (this.heightSetting || bBox.height || 0) + 2 * padding;
      var metrics = this.renderer.fontMetrics(style && style.fontSize, this.text);
      this.baselineOffset = padding + Math.min(
        // When applicable, use the font size of the first line (#15707)
        (this.text.firstLineMetrics || metrics).b,
        // When the height is 0, there is no bBox, so go with the font
        // metrics. Highmaps CSS demos.
        bBox.height || Infinity
      );
      if (this.heightSetting) {
        this.baselineOffset += (this.heightSetting - metrics.h) / 2;
      }
      if (this.needsBox) {
        if (!this.box) {
          var box = this.box = this.symbolKey ? this.renderer.symbol(this.symbolKey) : this.renderer.rect();
          box.addClass(
            // Don't use label className for buttons
            (this.className === "button" ? "" : "highcharts-label-box") + (this.className ? " highcharts-" + this.className + "-box" : "")
          );
          box.add(this);
        }
        crispAdjust = this.getCrispAdjust();
        attribs.x = crispAdjust;
        attribs.y = (this.baseline ? -this.baselineOffset : 0) + crispAdjust;
        attribs.width = Math.round(this.width);
        attribs.height = Math.round(this.height);
        this.box.attr(extend$1v(attribs, this.deferredAttr));
        this.deferredAttr = {};
      }
    };
    SVGLabel2.prototype.updateTextPadding = function() {
      var text2 = this.text;
      this.updateBoxSize();
      var textY = this.baseline ? 0 : this.baselineOffset;
      var textX = pick$1E(this.paddingLeft, this.padding);
      if (defined$W(this.widthSetting) && this.bBox && (this.textAlign === "center" || this.textAlign === "right")) {
        textX += { center: 0.5, right: 1 }[this.textAlign] * (this.widthSetting - this.bBox.width);
      }
      if (textX !== text2.x || textY !== text2.y) {
        text2.attr("x", textX);
        if (text2.hasBoxWidthChanged) {
          this.bBox = text2.getBBox(true);
        }
        if (typeof textY !== "undefined") {
          text2.attr("y", textY);
        }
      }
      text2.x = textX;
      text2.y = textY;
    };
    SVGLabel2.prototype.widthSetter = function(value) {
      this.widthSetting = isNumber$R(value) ? value : void 0;
    };
    SVGLabel2.prototype.getPaddedWidth = function() {
      var padding = this.padding;
      var paddingLeft = pick$1E(this.paddingLeft, padding);
      var paddingRight = pick$1E(this.paddingRight, padding);
      return (this.widthSetting || this.bBox.width || 0) + paddingLeft + paddingRight;
    };
    SVGLabel2.prototype.xSetter = function(value) {
      this.x = value;
      if (this.alignFactor) {
        value -= this.alignFactor * this.getPaddedWidth();
        this["forceAnimate:x"] = true;
      }
      this.xSetting = Math.round(value);
      this.attr("translateX", this.xSetting);
    };
    SVGLabel2.prototype.ySetter = function(value) {
      this.ySetting = this.y = Math.round(value);
      this.attr("translateY", this.ySetting);
    };
    SVGLabel2.emptyBBox = { width: 0, height: 0, x: 0, y: 0 };
    SVGLabel2.textProps = [
      "color",
      "direction",
      "fontFamily",
      "fontSize",
      "fontStyle",
      "fontWeight",
      "lineHeight",
      "textAlign",
      "textDecoration",
      "textOutline",
      "textOverflow",
      "width"
    ];
    return SVGLabel2;
  })(SVGElement)
);
var defined$V = Utilities.defined, isNumber$Q = Utilities.isNumber, pick$1D = Utilities.pick;
function arc$1(x, y, w2, h, options) {
  var arc2 = [];
  if (options) {
    var start2 = options.start || 0, rx = pick$1D(options.r, w2), ry = pick$1D(options.r, h || w2), proximity = 1e-3, fullCircle = Math.abs((options.end || 0) - start2 - 2 * Math.PI) < proximity, end = (options.end || 0) - proximity, innerRadius = options.innerR, open_1 = pick$1D(options.open, fullCircle), cosStart = Math.cos(start2), sinStart = Math.sin(start2), cosEnd = Math.cos(end), sinEnd = Math.sin(end), longArc = pick$1D(options.longArc, end - start2 - Math.PI < proximity ? 0 : 1);
    arc2.push([
      "M",
      x + rx * cosStart,
      y + ry * sinStart
    ], [
      "A",
      rx,
      ry,
      0,
      longArc,
      pick$1D(options.clockwise, 1),
      x + rx * cosEnd,
      y + ry * sinEnd
    ]);
    if (defined$V(innerRadius)) {
      arc2.push(open_1 ? [
        "M",
        x + innerRadius * cosEnd,
        y + innerRadius * sinEnd
      ] : [
        "L",
        x + innerRadius * cosEnd,
        y + innerRadius * sinEnd
      ], [
        "A",
        innerRadius,
        innerRadius,
        0,
        longArc,
        // Clockwise - opposite to the outer arc clockwise
        defined$V(options.clockwise) ? 1 - options.clockwise : 0,
        x + innerRadius * cosStart,
        y + innerRadius * sinStart
      ]);
    }
    if (!open_1) {
      arc2.push(["Z"]);
    }
  }
  return arc2;
}
function callout(x, y, w2, h, options) {
  var arrowLength = 6, halfDistance = 6, r = Math.min(options && options.r || 0, w2, h), safeDistance = r + halfDistance, anchorX = options && options.anchorX, anchorY = options && options.anchorY || 0;
  var path = roundedRect(x, y, w2, h, { r });
  if (!isNumber$Q(anchorX)) {
    return path;
  }
  if (x + anchorX >= w2) {
    if (anchorY > y + safeDistance && anchorY < y + h - safeDistance) {
      path.splice(3, 1, ["L", x + w2, anchorY - halfDistance], ["L", x + w2 + arrowLength, anchorY], ["L", x + w2, anchorY + halfDistance], ["L", x + w2, y + h - r]);
    } else {
      path.splice(3, 1, ["L", x + w2, h / 2], ["L", anchorX, anchorY], ["L", x + w2, h / 2], ["L", x + w2, y + h - r]);
    }
  } else if (x + anchorX <= 0) {
    if (anchorY > y + safeDistance && anchorY < y + h - safeDistance) {
      path.splice(7, 1, ["L", x, anchorY + halfDistance], ["L", x - arrowLength, anchorY], ["L", x, anchorY - halfDistance], ["L", x, y + r]);
    } else {
      path.splice(7, 1, ["L", x, h / 2], ["L", anchorX, anchorY], ["L", x, h / 2], ["L", x, y + r]);
    }
  } else if (
    // replace bottom
    anchorY && anchorY > h && anchorX > x + safeDistance && anchorX < x + w2 - safeDistance
  ) {
    path.splice(5, 1, ["L", anchorX + halfDistance, y + h], ["L", anchorX, y + h + arrowLength], ["L", anchorX - halfDistance, y + h], ["L", x + r, y + h]);
  } else if (
    // replace top
    anchorY && anchorY < 0 && anchorX > x + safeDistance && anchorX < x + w2 - safeDistance
  ) {
    path.splice(1, 1, ["L", anchorX - halfDistance, y], ["L", anchorX, y - arrowLength], ["L", anchorX + halfDistance, y], ["L", w2 - r, y]);
  }
  return path;
}
function circle(x, y, w2, h) {
  return arc$1(x + w2 / 2, y + h / 2, w2 / 2, h / 2, {
    start: Math.PI * 0.5,
    end: Math.PI * 2.5,
    open: false
  });
}
function diamond(x, y, w2, h) {
  return [
    ["M", x + w2 / 2, y],
    ["L", x + w2, y + h / 2],
    ["L", x + w2 / 2, y + h],
    ["L", x, y + h / 2],
    ["Z"]
  ];
}
function rect(x, y, w2, h, options) {
  if (options && options.r) {
    return roundedRect(x, y, w2, h, options);
  }
  return [
    ["M", x, y],
    ["L", x + w2, y],
    ["L", x + w2, y + h],
    ["L", x, y + h],
    ["Z"]
  ];
}
function roundedRect(x, y, w2, h, options) {
  var r = options && options.r || 0;
  return [
    ["M", x + r, y],
    ["L", x + w2 - r, y],
    ["C", x + w2, y, x + w2, y, x + w2, y + r],
    ["L", x + w2, y + h - r],
    ["C", x + w2, y + h, x + w2, y + h, x + w2 - r, y + h],
    ["L", x + r, y + h],
    ["C", x, y + h, x, y + h, x, y + h - r],
    ["L", x, y + r],
    ["C", x, y, x, y, x + r, y]
    // top-left corner
  ];
}
function triangle(x, y, w2, h) {
  return [
    ["M", x + w2 / 2, y],
    ["L", x + w2, y + h],
    ["L", x, y + h],
    ["Z"]
  ];
}
function triangleDown(x, y, w2, h) {
  return [
    ["M", x, y],
    ["L", x + w2, y],
    ["L", x + w2 / 2, y + h],
    ["Z"]
  ];
}
var Symbols = {
  arc: arc$1,
  callout,
  circle,
  diamond,
  rect,
  roundedRect,
  square: rect,
  triangle,
  "triangle-down": triangleDown
};
var doc$k = H.doc, SVG_NS$1 = H.SVG_NS;
var attr$5 = Utilities.attr, isString$a = Utilities.isString, objectEach$x = Utilities.objectEach, pick$1C = Utilities.pick;
var TextBuilder = (
  /** @class */
  (function() {
    function TextBuilder2(svgElement) {
      var textStyles = svgElement.styles;
      this.renderer = svgElement.renderer;
      this.svgElement = svgElement;
      this.width = svgElement.textWidth;
      this.textLineHeight = textStyles && textStyles.lineHeight;
      this.textOutline = textStyles && textStyles.textOutline;
      this.ellipsis = Boolean(textStyles && textStyles.textOverflow === "ellipsis");
      this.noWrap = Boolean(textStyles && textStyles.whiteSpace === "nowrap");
      this.fontSize = textStyles && textStyles.fontSize;
    }
    TextBuilder2.prototype.buildSVG = function() {
      var wrapper = this.svgElement, textNode = wrapper.element, renderer = wrapper.renderer, textStr = pick$1C(wrapper.textStr, "").toString(), hasMarkup = textStr.indexOf("<") !== -1, childNodes = textNode.childNodes, tempParent = this.width && !wrapper.added && renderer.box, regexMatchBreaks = /<br.*?>/g, textCache = [
        textStr,
        this.ellipsis,
        this.noWrap,
        this.textLineHeight,
        this.textOutline,
        this.fontSize,
        this.width
      ].join(",");
      if (textCache === wrapper.textCache) {
        return;
      }
      wrapper.textCache = textCache;
      delete wrapper.actualWidth;
      for (var i2 = childNodes.length; i2--; ) {
        textNode.removeChild(childNodes[i2]);
      }
      if (!hasMarkup && !this.ellipsis && !this.width && (textStr.indexOf(" ") === -1 || this.noWrap && !regexMatchBreaks.test(textStr))) {
        textNode.appendChild(doc$k.createTextNode(this.unescapeEntities(textStr)));
      } else if (textStr !== "") {
        if (tempParent) {
          tempParent.appendChild(textNode);
        }
        var ast = new AST(textStr);
        this.modifyTree(ast.nodes);
        ast.addToDOM(wrapper.element);
        this.modifyDOM();
        if (this.ellipsis && (textNode.textContent || "").indexOf("…") !== -1) {
          wrapper.attr(
            "title",
            this.unescapeEntities(wrapper.textStr || "", ["&lt;", "&gt;"])
            // #7179
          );
        }
        if (tempParent) {
          tempParent.removeChild(textNode);
        }
      }
      if (isString$a(this.textOutline) && wrapper.applyTextOutline) {
        wrapper.applyTextOutline(this.textOutline);
      }
    };
    TextBuilder2.prototype.modifyDOM = function() {
      var _this = this;
      var wrapper = this.svgElement;
      var x = attr$5(wrapper.element, "x");
      wrapper.firstLineMetrics = void 0;
      var firstChild;
      while (firstChild = wrapper.element.firstChild) {
        if (/^[\s\u200B]*$/.test(firstChild.textContent || " ")) {
          wrapper.element.removeChild(firstChild);
        } else {
          break;
        }
      }
      [].forEach.call(wrapper.element.querySelectorAll("tspan.highcharts-br"), function(br2, i2) {
        if (br2.nextSibling && br2.previousSibling) {
          if (i2 === 0 && br2.previousSibling.nodeType === 1) {
            wrapper.firstLineMetrics = wrapper.renderer.fontMetrics(void 0, br2.previousSibling);
          }
          attr$5(br2, {
            // Since the break is inserted in front of the next
            // line, we need to use the next sibling for the line
            // height
            dy: _this.getLineHeight(br2.nextSibling),
            x
          });
        }
      });
      var width = this.width || 0;
      if (!width) {
        return;
      }
      var modifyTextNode = function(textNode, parentElement) {
        var text2 = textNode.textContent || "";
        var words = text2.replace(/([^\^])-/g, "$1- ").split(" ");
        var hasWhiteSpace = !_this.noWrap && (words.length > 1 || wrapper.element.childNodes.length > 1);
        var dy = _this.getLineHeight(parentElement);
        var lineNo = 0;
        var startAt = wrapper.actualWidth;
        if (_this.ellipsis) {
          if (text2) {
            _this.truncate(
              textNode,
              text2,
              void 0,
              0,
              // Target width
              Math.max(
                0,
                // Substract the font face to make room for the
                // ellipsis itself
                width - parseInt(_this.fontSize || 12, 10)
              ),
              // Build the text to test for
              function(text3, currentIndex) {
                return text3.substring(0, currentIndex) + "…";
              }
            );
          }
        } else if (hasWhiteSpace) {
          var lines = [];
          var precedingSiblings = [];
          while (parentElement.firstChild && parentElement.firstChild !== textNode) {
            precedingSiblings.push(parentElement.firstChild);
            parentElement.removeChild(parentElement.firstChild);
          }
          while (words.length) {
            if (words.length && !_this.noWrap && lineNo > 0) {
              lines.push(textNode.textContent || "");
              textNode.textContent = words.join(" ").replace(/- /g, "-");
            }
            _this.truncate(
              textNode,
              void 0,
              words,
              lineNo === 0 ? startAt || 0 : 0,
              width,
              // Build the text to test for
              function(t, currentIndex) {
                return words.slice(0, currentIndex).join(" ").replace(/- /g, "-");
              }
            );
            startAt = wrapper.actualWidth;
            lineNo++;
          }
          precedingSiblings.forEach(function(childNode) {
            parentElement.insertBefore(childNode, textNode);
          });
          lines.forEach(function(line) {
            parentElement.insertBefore(doc$k.createTextNode(line), textNode);
            var br2 = doc$k.createElementNS(SVG_NS$1, "tspan");
            br2.textContent = "​";
            attr$5(br2, { dy, x });
            parentElement.insertBefore(br2, textNode);
          });
        }
      };
      var modifyChildren = (function(node) {
        var childNodes = [].slice.call(node.childNodes);
        childNodes.forEach(function(childNode) {
          if (childNode.nodeType === Node.TEXT_NODE) {
            modifyTextNode(childNode, node);
          } else {
            if (childNode.className.baseVal.indexOf("highcharts-br") !== -1) {
              wrapper.actualWidth = 0;
            }
            modifyChildren(childNode);
          }
        });
      });
      modifyChildren(wrapper.element);
    };
    TextBuilder2.prototype.getLineHeight = function(node) {
      var fontSizeStyle;
      var element = node.nodeType === Node.TEXT_NODE ? node.parentElement : node;
      if (!this.renderer.styledMode) {
        fontSizeStyle = element && /(px|em)$/.test(element.style.fontSize) ? element.style.fontSize : this.fontSize || this.renderer.style.fontSize || 12;
      }
      return this.textLineHeight ? parseInt(this.textLineHeight.toString(), 10) : this.renderer.fontMetrics(fontSizeStyle, element || this.svgElement.element).h;
    };
    TextBuilder2.prototype.modifyTree = function(nodes) {
      var _this = this;
      var modifyChild = function(node, i2) {
        var tagName = node.tagName;
        var styledMode = _this.renderer.styledMode;
        var attributes = node.attributes || {};
        if (tagName === "b" || tagName === "strong") {
          if (styledMode) {
            attributes["class"] = "highcharts-strong";
          } else {
            attributes.style = "font-weight:bold;" + (attributes.style || "");
          }
        } else if (tagName === "i" || tagName === "em") {
          if (styledMode) {
            attributes["class"] = "highcharts-emphasized";
          } else {
            attributes.style = "font-style:italic;" + (attributes.style || "");
          }
        }
        if (isString$a(attributes.style)) {
          attributes.style = attributes.style.replace(/(;| |^)color([ :])/, "$1fill$2");
        }
        if (tagName === "br") {
          attributes["class"] = "highcharts-br";
          node.textContent = "​";
          var nextNode = nodes[i2 + 1];
          if (nextNode && nextNode.textContent) {
            nextNode.textContent = nextNode.textContent.replace(/^ +/gm, "");
          }
        }
        if (tagName !== "#text" && tagName !== "a") {
          node.tagName = "tspan";
        }
        node.attributes = attributes;
        if (node.children) {
          node.children.filter(function(c) {
            return c.tagName !== "#text";
          }).forEach(modifyChild);
        }
      };
      nodes.forEach(modifyChild);
    };
    TextBuilder2.prototype.truncate = function(textNode, text2, words, startAt, width, getString) {
      var svgElement = this.svgElement;
      var renderer = svgElement.renderer, rotation = svgElement.rotation;
      var lengths = [];
      var minIndex = words ? 1 : 0;
      var maxIndex = (text2 || words || "").length;
      var currentIndex = maxIndex;
      var str;
      var actualWidth;
      var getSubStringLength = function(charEnd, concatenatedEnd) {
        var end = concatenatedEnd || charEnd;
        var parentNode = textNode.parentNode;
        if (parentNode && typeof lengths[end] === "undefined") {
          if (parentNode.getSubStringLength) {
            try {
              lengths[end] = startAt + parentNode.getSubStringLength(0, words ? end + 1 : end);
            } catch (e) {
            }
          } else if (renderer.getSpanWidth) {
            textNode.textContent = getString(text2 || words, charEnd);
            lengths[end] = startAt + renderer.getSpanWidth(svgElement, textNode);
          }
        }
        return lengths[end];
      };
      svgElement.rotation = 0;
      actualWidth = getSubStringLength(textNode.textContent.length);
      if (startAt + actualWidth > width) {
        while (minIndex <= maxIndex) {
          currentIndex = Math.ceil((minIndex + maxIndex) / 2);
          if (words) {
            str = getString(words, currentIndex);
          }
          actualWidth = getSubStringLength(currentIndex, str && str.length - 1);
          if (minIndex === maxIndex) {
            minIndex = maxIndex + 1;
          } else if (actualWidth > width) {
            maxIndex = currentIndex - 1;
          } else {
            minIndex = currentIndex;
          }
        }
        if (maxIndex === 0) {
          textNode.textContent = "";
        } else if (!(text2 && maxIndex === text2.length - 1)) {
          textNode.textContent = str || getString(text2 || words, currentIndex);
        }
      }
      if (words) {
        words.splice(0, currentIndex);
      }
      svgElement.actualWidth = actualWidth;
      svgElement.rotation = rotation;
    };
    TextBuilder2.prototype.unescapeEntities = function(inputStr, except) {
      objectEach$x(this.renderer.escapes, function(value, key2) {
        if (!except || except.indexOf(value) === -1) {
          inputStr = inputStr.toString().replace(new RegExp(value, "g"), key2);
        }
      });
      return inputStr;
    };
    return TextBuilder2;
  })()
);
var charts$4 = H.charts, deg2rad$8 = H.deg2rad, doc$j = H.doc, isFirefox$3 = H.isFirefox, isMS$2 = H.isMS, isWebKit$1 = H.isWebKit, noop$j = H.noop, SVG_NS = H.SVG_NS, symbolSizes = H.symbolSizes, win$c = H.win;
var addEvent$17 = Utilities.addEvent, attr$4 = Utilities.attr, createElement$8 = Utilities.createElement, css$b = Utilities.css, defined$U = Utilities.defined, destroyObjectProperties$9 = Utilities.destroyObjectProperties, extend$1u = Utilities.extend, isArray$n = Utilities.isArray, isNumber$P = Utilities.isNumber, isObject$f = Utilities.isObject, isString$9 = Utilities.isString, merge$1q = Utilities.merge, pick$1B = Utilities.pick, pInt$6 = Utilities.pInt, uniqueKey$6 = Utilities.uniqueKey;
var hasInternalReferenceBug;
var SVGRenderer = (
  /** @class */
  (function() {
    function SVGRenderer2(container2, width, height, style, forExport, allowHTML, styledMode) {
      this.alignedObjects = void 0;
      this.box = void 0;
      this.boxWrapper = void 0;
      this.cache = void 0;
      this.cacheKeys = void 0;
      this.chartIndex = void 0;
      this.defs = void 0;
      this.globalAnimation = void 0;
      this.gradients = void 0;
      this.height = void 0;
      this.imgCount = void 0;
      this.isSVG = void 0;
      this.style = void 0;
      this.url = void 0;
      this.width = void 0;
      this.init(container2, width, height, style, forExport, allowHTML, styledMode);
    }
    SVGRenderer2.prototype.init = function(container2, width, height, style, forExport, allowHTML, styledMode) {
      var renderer = this, boxWrapper = renderer.createElement("svg").attr({
        version: "1.1",
        "class": "highcharts-root"
      }), element = boxWrapper.element;
      if (!styledMode) {
        boxWrapper.css(this.getStyle(style));
      }
      container2.appendChild(element);
      attr$4(container2, "dir", "ltr");
      if (container2.innerHTML.indexOf("xmlns") === -1) {
        attr$4(element, "xmlns", this.SVG_NS);
      }
      renderer.isSVG = true;
      this.box = element;
      this.boxWrapper = boxWrapper;
      renderer.alignedObjects = [];
      this.url = this.getReferenceURL();
      var desc = this.createElement("desc").add();
      desc.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2"));
      renderer.defs = this.createElement("defs").add();
      renderer.allowHTML = allowHTML;
      renderer.forExport = forExport;
      renderer.styledMode = styledMode;
      renderer.gradients = {};
      renderer.cache = {};
      renderer.cacheKeys = [];
      renderer.imgCount = 0;
      renderer.setSize(width, height, false);
      var subPixelFix, rect2;
      if (isFirefox$3 && container2.getBoundingClientRect) {
        subPixelFix = function() {
          css$b(container2, { left: 0, top: 0 });
          rect2 = container2.getBoundingClientRect();
          css$b(container2, {
            left: Math.ceil(rect2.left) - rect2.left + "px",
            top: Math.ceil(rect2.top) - rect2.top + "px"
          });
        };
        subPixelFix();
        renderer.unSubPixelFix = addEvent$17(win$c, "resize", subPixelFix);
      }
    };
    SVGRenderer2.prototype.definition = function(def2) {
      var ast = new AST([def2]);
      return ast.addToDOM(this.defs.element);
    };
    SVGRenderer2.prototype.getReferenceURL = function() {
      if ((isFirefox$3 || isWebKit$1) && doc$j.getElementsByTagName("base").length) {
        if (!defined$U(hasInternalReferenceBug)) {
          var id = uniqueKey$6();
          var ast = new AST([{
            tagName: "svg",
            attributes: {
              width: 8,
              height: 8
            },
            children: [{
              tagName: "defs",
              children: [{
                tagName: "clipPath",
                attributes: {
                  id
                },
                children: [{
                  tagName: "rect",
                  attributes: {
                    width: 4,
                    height: 4
                  }
                }]
              }]
            }, {
              tagName: "rect",
              attributes: {
                id: "hitme",
                width: 8,
                height: 8,
                "clip-path": "url(#" + id + ")",
                fill: "rgba(0,0,0,0.001)"
              }
            }]
          }]);
          var svg2 = ast.addToDOM(doc$j.body);
          css$b(svg2, {
            position: "fixed",
            top: 0,
            left: 0,
            zIndex: 9e5
          });
          var hitElement = doc$j.elementFromPoint(6, 6);
          hasInternalReferenceBug = (hitElement && hitElement.id) === "hitme";
          doc$j.body.removeChild(svg2);
        }
        if (hasInternalReferenceBug) {
          return win$c.location.href.split("#")[0].replace(/<[^>]*>/g, "").replace(/([\('\)])/g, "\\$1").replace(/ /g, "%20");
        }
      }
      return "";
    };
    SVGRenderer2.prototype.getStyle = function(style) {
      this.style = extend$1u({
        fontFamily: '"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
        fontSize: "12px"
      }, style);
      return this.style;
    };
    SVGRenderer2.prototype.setStyle = function(style) {
      this.boxWrapper.css(this.getStyle(style));
    };
    SVGRenderer2.prototype.isHidden = function() {
      return !this.boxWrapper.getBBox().width;
    };
    SVGRenderer2.prototype.destroy = function() {
      var renderer = this, rendererDefs = renderer.defs;
      renderer.box = null;
      renderer.boxWrapper = renderer.boxWrapper.destroy();
      destroyObjectProperties$9(renderer.gradients || {});
      renderer.gradients = null;
      if (rendererDefs) {
        renderer.defs = rendererDefs.destroy();
      }
      if (renderer.unSubPixelFix) {
        renderer.unSubPixelFix();
      }
      renderer.alignedObjects = null;
      return null;
    };
    SVGRenderer2.prototype.createElement = function(nodeName) {
      var wrapper = new this.Element();
      wrapper.init(this, nodeName);
      return wrapper;
    };
    SVGRenderer2.prototype.getRadialAttr = function(radialReference, gradAttr) {
      return {
        cx: radialReference[0] - radialReference[2] / 2 + (gradAttr.cx || 0) * radialReference[2],
        cy: radialReference[1] - radialReference[2] / 2 + (gradAttr.cy || 0) * radialReference[2],
        r: (gradAttr.r || 0) * radialReference[2]
      };
    };
    SVGRenderer2.prototype.buildText = function(wrapper) {
      new TextBuilder(wrapper).buildSVG();
    };
    SVGRenderer2.prototype.getContrast = function(rgba) {
      rgba = Color.parse(rgba).rgba;
      rgba[0] *= 1;
      rgba[1] *= 1.2;
      rgba[2] *= 0.5;
      return rgba[0] + rgba[1] + rgba[2] > 1.8 * 255 ? "#000000" : "#FFFFFF";
    };
    SVGRenderer2.prototype.button = function(text2, x, y, callback, theme2, hoverState, pressedState, disabledState, shape, useHTML) {
      var label = this.label(text2, x, y, shape, void 0, void 0, useHTML, void 0, "button"), styledMode = this.styledMode;
      var curState = 0, normalState = theme2 ? merge$1q(theme2) : {};
      var userNormalStyle = normalState && normalState.style || {};
      normalState = AST.filterUserAttributes(normalState);
      label.attr(merge$1q({ padding: 8, r: 2 }, normalState));
      var normalStyle, hoverStyle, pressedStyle, disabledStyle;
      if (!styledMode) {
        normalState = merge$1q({
          fill: palette.neutralColor3,
          stroke: palette.neutralColor20,
          "stroke-width": 1,
          style: {
            color: palette.neutralColor80,
            cursor: "pointer",
            fontWeight: "normal"
          }
        }, {
          style: userNormalStyle
        }, normalState);
        normalStyle = normalState.style;
        delete normalState.style;
        hoverState = merge$1q(normalState, {
          fill: palette.neutralColor10
        }, AST.filterUserAttributes(hoverState || {}));
        hoverStyle = hoverState.style;
        delete hoverState.style;
        pressedState = merge$1q(normalState, {
          fill: palette.highlightColor10,
          style: {
            color: palette.neutralColor100,
            fontWeight: "bold"
          }
        }, AST.filterUserAttributes(pressedState || {}));
        pressedStyle = pressedState.style;
        delete pressedState.style;
        disabledState = merge$1q(normalState, {
          style: {
            color: palette.neutralColor20
          }
        }, AST.filterUserAttributes(disabledState || {}));
        disabledStyle = disabledState.style;
        delete disabledState.style;
      }
      addEvent$17(label.element, isMS$2 ? "mouseover" : "mouseenter", function() {
        if (curState !== 3) {
          label.setState(1);
        }
      });
      addEvent$17(label.element, isMS$2 ? "mouseout" : "mouseleave", function() {
        if (curState !== 3) {
          label.setState(curState);
        }
      });
      label.setState = function(state) {
        if (state !== 1) {
          label.state = curState = state;
        }
        label.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-" + ["normal", "hover", "pressed", "disabled"][state || 0]);
        if (!styledMode) {
          label.attr([
            normalState,
            hoverState,
            pressedState,
            disabledState
          ][state || 0]).css([
            normalStyle,
            hoverStyle,
            pressedStyle,
            disabledStyle
          ][state || 0]);
        }
      };
      if (!styledMode) {
        label.attr(normalState).css(extend$1u({ cursor: "default" }, normalStyle));
      }
      return label.on("touchstart", function(e) {
        return e.stopPropagation();
      }).on("click", function(e) {
        if (curState !== 3) {
          callback.call(label, e);
        }
      });
    };
    SVGRenderer2.prototype.crispLine = function(points, width, roundingFunction) {
      if (roundingFunction === void 0) {
        roundingFunction = "round";
      }
      var start2 = points[0];
      var end = points[1];
      if (defined$U(start2[1]) && start2[1] === end[1]) {
        start2[1] = end[1] = Math[roundingFunction](start2[1]) - width % 2 / 2;
      }
      if (defined$U(start2[2]) && start2[2] === end[2]) {
        start2[2] = end[2] = Math[roundingFunction](start2[2]) + width % 2 / 2;
      }
      return points;
    };
    SVGRenderer2.prototype.path = function(path) {
      var attribs = this.styledMode ? {} : {
        fill: "none"
      };
      if (isArray$n(path)) {
        attribs.d = path;
      } else if (isObject$f(path)) {
        extend$1u(attribs, path);
      }
      return this.createElement("path").attr(attribs);
    };
    SVGRenderer2.prototype.circle = function(x, y, r) {
      var attribs = isObject$f(x) ? x : typeof x === "undefined" ? {} : { x, y, r }, wrapper = this.createElement("circle");
      wrapper.xSetter = wrapper.ySetter = function(value, key2, element) {
        element.setAttribute("c" + key2, value);
      };
      return wrapper.attr(attribs);
    };
    SVGRenderer2.prototype.arc = function(x, y, r, innerR, start2, end) {
      var options;
      if (isObject$f(x)) {
        options = x;
        y = options.y;
        r = options.r;
        innerR = options.innerR;
        start2 = options.start;
        end = options.end;
        x = options.x;
      } else {
        options = { innerR, start: start2, end };
      }
      var arc2 = this.symbol("arc", x, y, r, r, options);
      arc2.r = r;
      return arc2;
    };
    SVGRenderer2.prototype.rect = function(x, y, width, height, r, strokeWidth) {
      r = isObject$f(x) ? x.r : r;
      var wrapper = this.createElement("rect");
      var attribs = isObject$f(x) ? x : typeof x === "undefined" ? {} : {
        x,
        y,
        width: Math.max(width, 0),
        height: Math.max(height, 0)
      };
      if (!this.styledMode) {
        if (typeof strokeWidth !== "undefined") {
          attribs["stroke-width"] = strokeWidth;
          attribs = wrapper.crisp(attribs);
        }
        attribs.fill = "none";
      }
      if (r) {
        attribs.r = r;
      }
      wrapper.rSetter = function(value, _key, element) {
        wrapper.r = value;
        attr$4(element, {
          rx: value,
          ry: value
        });
      };
      wrapper.rGetter = function() {
        return wrapper.r || 0;
      };
      return wrapper.attr(attribs);
    };
    SVGRenderer2.prototype.setSize = function(width, height, animate2) {
      var renderer = this;
      renderer.width = width;
      renderer.height = height;
      renderer.boxWrapper.animate({
        width,
        height
      }, {
        step: function() {
          this.attr({
            viewBox: "0 0 " + this.attr("width") + " " + this.attr("height")
          });
        },
        duration: pick$1B(animate2, true) ? void 0 : 0
      });
      renderer.alignElements();
    };
    SVGRenderer2.prototype.g = function(name) {
      var elem = this.createElement("g");
      return name ? elem.attr({ "class": "highcharts-" + name }) : elem;
    };
    SVGRenderer2.prototype.image = function(src, x, y, width, height, onload) {
      var attribs = { preserveAspectRatio: "none" }, setSVGImageSource = function(el, src2) {
        if (el.setAttributeNS) {
          el.setAttributeNS("http://www.w3.org/1999/xlink", "href", src2);
        } else {
          el.setAttribute("hc-svg-href", src2);
        }
      };
      if (arguments.length > 1) {
        extend$1u(attribs, {
          x,
          y,
          width,
          height
        });
      }
      var elemWrapper = this.createElement("image").attr(attribs), onDummyLoad = function(e) {
        setSVGImageSource(elemWrapper.element, src);
        onload.call(elemWrapper, e);
      };
      if (onload) {
        setSVGImageSource(
          elemWrapper.element,
          "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="
          /* eslint-disable-line */
        );
        var dummy = new win$c.Image();
        addEvent$17(dummy, "load", onDummyLoad);
        dummy.src = src;
        if (dummy.complete) {
          onDummyLoad({});
        }
      } else {
        setSVGImageSource(elemWrapper.element, src);
      }
      return elemWrapper;
    };
    SVGRenderer2.prototype.symbol = function(symbol, x, y, width, height, options) {
      var ren = this, imageRegex = /^url\((.*?)\)$/, isImage = imageRegex.test(symbol), sym = !isImage && (this.symbols[symbol] ? symbol : "circle"), symbolFn = sym && this.symbols[sym];
      var obj, path, imageSrc, centerImage;
      if (symbolFn) {
        if (typeof x === "number") {
          path = symbolFn.call(this.symbols, Math.round(x || 0), Math.round(y || 0), width || 0, height || 0, options);
        }
        obj = this.path(path);
        if (!ren.styledMode) {
          obj.attr("fill", "none");
        }
        extend$1u(obj, {
          symbolName: sym || void 0,
          x,
          y,
          width,
          height
        });
        if (options) {
          extend$1u(obj, options);
        }
      } else if (isImage) {
        imageSrc = symbol.match(imageRegex)[1];
        var img_1 = obj = this.image(imageSrc);
        img_1.imgwidth = pick$1B(symbolSizes[imageSrc] && symbolSizes[imageSrc].width, options && options.width);
        img_1.imgheight = pick$1B(symbolSizes[imageSrc] && symbolSizes[imageSrc].height, options && options.height);
        centerImage = function(obj2) {
          return obj2.attr({
            width: obj2.width,
            height: obj2.height
          });
        };
        ["width", "height"].forEach(function(key2) {
          img_1[key2 + "Setter"] = function(value, key3) {
            var imgSize = this["img" + key3];
            this[key3] = value;
            if (defined$U(imgSize)) {
              if (options && options.backgroundSize === "within" && this.width && this.height) {
                imgSize = Math.round(imgSize * Math.min(this.width / this.imgwidth, this.height / this.imgheight));
              }
              if (this.element) {
                this.element.setAttribute(key3, imgSize);
              }
              if (!this.alignByTranslate) {
                var translate2 = ((this[key3] || 0) - imgSize) / 2;
                var attribs = key3 === "width" ? { translateX: translate2 } : { translateY: translate2 };
                this.attr(attribs);
              }
            }
          };
        });
        if (defined$U(x)) {
          img_1.attr({
            x,
            y
          });
        }
        img_1.isImg = true;
        if (defined$U(img_1.imgwidth) && defined$U(img_1.imgheight)) {
          centerImage(img_1);
        } else {
          img_1.attr({ width: 0, height: 0 });
          createElement$8("img", {
            onload: function() {
              var chart = charts$4[ren.chartIndex];
              if (this.width === 0) {
                css$b(this, {
                  position: "absolute",
                  top: "-999em"
                });
                doc$j.body.appendChild(this);
              }
              symbolSizes[imageSrc] = {
                width: this.width,
                height: this.height
              };
              img_1.imgwidth = this.width;
              img_1.imgheight = this.height;
              if (img_1.element) {
                centerImage(img_1);
              }
              if (this.parentNode) {
                this.parentNode.removeChild(this);
              }
              ren.imgCount--;
              if (!ren.imgCount && chart && !chart.hasLoaded) {
                chart.onload();
              }
            },
            src: imageSrc
          });
          this.imgCount++;
        }
      }
      return obj;
    };
    SVGRenderer2.prototype.clipRect = function(x, y, width, height) {
      var id = uniqueKey$6() + "-", clipPath = this.createElement("clipPath").attr({
        id
      }).add(this.defs), wrapper = this.rect(x, y, width, height, 0).add(clipPath);
      wrapper.id = id;
      wrapper.clipPath = clipPath;
      wrapper.count = 0;
      return wrapper;
    };
    SVGRenderer2.prototype.text = function(str, x, y, useHTML) {
      var renderer = this, attribs = {};
      if (useHTML && (renderer.allowHTML || !renderer.forExport)) {
        return renderer.html(str, x, y);
      }
      attribs.x = Math.round(x || 0);
      if (y) {
        attribs.y = Math.round(y);
      }
      if (defined$U(str)) {
        attribs.text = str;
      }
      var wrapper = renderer.createElement("text").attr(attribs);
      if (!useHTML || renderer.forExport && !renderer.allowHTML) {
        wrapper.xSetter = function(value, key2, element) {
          var tspans = element.getElementsByTagName("tspan"), parentVal = element.getAttribute(key2);
          for (var i2 = 0, tspan = void 0; i2 < tspans.length; i2++) {
            tspan = tspans[i2];
            if (tspan.getAttribute(key2) === parentVal) {
              tspan.setAttribute(key2, value);
            }
          }
          element.setAttribute(key2, value);
        };
      }
      return wrapper;
    };
    SVGRenderer2.prototype.fontMetrics = function(fontSize, elem) {
      if ((this.styledMode || !/px/.test(fontSize)) && win$c.getComputedStyle) {
        fontSize = elem && SVGElement.prototype.getStyle.call(elem, "font-size");
      } else {
        fontSize = fontSize || // When the elem is a DOM element (#5932)
        elem && elem.style && elem.style.fontSize || // Fall back on the renderer style default
        this.style && this.style.fontSize;
      }
      if (/px/.test(fontSize)) {
        fontSize = pInt$6(fontSize);
      } else {
        fontSize = 12;
      }
      var lineHeight = fontSize < 24 ? fontSize + 3 : Math.round(fontSize * 1.2), baseline = Math.round(lineHeight * 0.8);
      return {
        h: lineHeight,
        b: baseline,
        f: fontSize
      };
    };
    SVGRenderer2.prototype.rotCorr = function(baseline, rotation, alterY) {
      var y = baseline;
      if (rotation && alterY) {
        y = Math.max(y * Math.cos(rotation * deg2rad$8), 4);
      }
      return {
        x: -baseline / 3 * Math.sin(rotation * deg2rad$8),
        y
      };
    };
    SVGRenderer2.prototype.pathToSegments = function(path) {
      var ret = [];
      var segment = [];
      var commandLength = {
        A: 8,
        C: 7,
        H: 2,
        L: 3,
        M: 3,
        Q: 5,
        S: 5,
        T: 3,
        V: 2
      };
      for (var i2 = 0; i2 < path.length; i2++) {
        if (isString$9(segment[0]) && isNumber$P(path[i2]) && segment.length === commandLength[segment[0].toUpperCase()]) {
          path.splice(i2, 0, segment[0].replace("M", "L").replace("m", "l"));
        }
        if (typeof path[i2] === "string") {
          if (segment.length) {
            ret.push(segment.slice(0));
          }
          segment.length = 0;
        }
        segment.push(path[i2]);
      }
      ret.push(segment.slice(0));
      return ret;
    };
    SVGRenderer2.prototype.label = function(str, x, y, shape, anchorX, anchorY, useHTML, baseline, className) {
      return new SVGLabel(this, str, x, y, shape, anchorX, anchorY, useHTML, baseline, className);
    };
    SVGRenderer2.prototype.alignElements = function() {
      this.alignedObjects.forEach(function(el) {
        return el.align();
      });
    };
    return SVGRenderer2;
  })()
);
extend$1u(SVGRenderer.prototype, {
  /**
   * A pointer to the renderer's associated Element class. The VMLRenderer
   * will have a pointer to VMLElement here.
   *
   * @name Highcharts.SVGRenderer#Element
   * @type {Highcharts.SVGElement}
   */
  Element: SVGElement,
  SVG_NS,
  /**
   * A collection of characters mapped to HTML entities. When `useHTML` on an
   * element is true, these entities will be rendered correctly by HTML. In
   * the SVG pseudo-HTML, they need to be unescaped back to simple characters,
   * so for example `&lt;` will render as `<`.
   *
   * @example
   * // Add support for unescaping quotes
   * Highcharts.SVGRenderer.prototype.escapes['"'] = '&quot;';
   *
   * @name Highcharts.SVGRenderer#escapes
   * @type {Highcharts.Dictionary<string>}
   */
  escapes: {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    "'": "&#39;",
    '"': "&quot;"
  },
  /**
   * An extendable collection of functions for defining symbol paths.
   *
   * @name Highcharts.SVGRenderer#symbols
   * @type {Highcharts.SymbolDictionary}
   */
  symbols: Symbols,
  /**
   * Dummy function for plugins, called every time the renderer is updated.
   * Prior to Highcharts 5, this was used for the canvg renderer.
   *
   * @deprecated
   * @function Highcharts.SVGRenderer#draw
   */
  draw: noop$j
});
RendererRegistry$1.registerRendererType("svg", SVGRenderer, true);
var __extends$_ = /* @__PURE__ */ (function() {
  var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b3) {
      d2.__proto__ = b3;
    } || function(d2, b3) {
      for (var p in b3) if (b3.hasOwnProperty(p)) d2[p] = b3[p];
    };
    return extendStatics(d, b);
  };
  return function(d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
})();
var isFirefox$2 = H.isFirefox, isMS$1 = H.isMS, isWebKit = H.isWebKit, win$b = H.win;
var css$a = Utilities.css, defined$T = Utilities.defined, extend$1t = Utilities.extend, pick$1A = Utilities.pick, pInt$5 = Utilities.pInt;
var HTMLElement$1 = (
  /** @class */
  (function(_super) {
    __extends$_(HTMLElement2, _super);
    function HTMLElement2() {
      return _super !== null && _super.apply(this, arguments) || this;
    }
    HTMLElement2.compose = function(SVGElementClass) {
      if (HTMLElement2.composedClasses.indexOf(SVGElementClass) === -1) {
        HTMLElement2.composedClasses.push(SVGElementClass);
        var htmlElementProto = HTMLElement2.prototype, svgElementProto = SVGElementClass.prototype;
        svgElementProto.getSpanCorrection = htmlElementProto.getSpanCorrection;
        svgElementProto.htmlCss = htmlElementProto.htmlCss;
        svgElementProto.htmlGetBBox = htmlElementProto.htmlGetBBox;
        svgElementProto.htmlUpdateTransform = htmlElementProto.htmlUpdateTransform;
        svgElementProto.setSpanRotation = htmlElementProto.setSpanRotation;
      }
      return SVGElementClass;
    };
    HTMLElement2.prototype.getSpanCorrection = function(width, baseline, alignCorrection) {
      this.xCorr = -width * alignCorrection;
      this.yCorr = -baseline;
    };
    HTMLElement2.prototype.htmlCss = function(styles) {
      var wrapper = this, element = wrapper.element, isSettingWidth = element.tagName === "SPAN" && styles && "width" in styles, textWidth = pick$1A(isSettingWidth && styles.width, void 0);
      var doTransform;
      if (isSettingWidth) {
        delete styles.width;
        wrapper.textWidth = textWidth;
        doTransform = true;
      }
      if (styles && styles.textOverflow === "ellipsis") {
        styles.whiteSpace = "nowrap";
        styles.overflow = "hidden";
      }
      wrapper.styles = extend$1t(wrapper.styles, styles);
      css$a(wrapper.element, styles);
      if (doTransform) {
        wrapper.htmlUpdateTransform();
      }
      return wrapper;
    };
    HTMLElement2.prototype.htmlGetBBox = function() {
      var wrapper = this, element = wrapper.element;
      return {
        x: element.offsetLeft,
        y: element.offsetTop,
        width: element.offsetWidth,
        height: element.offsetHeight
      };
    };
    HTMLElement2.prototype.htmlUpdateTransform = function() {
      if (!this.added) {
        this.alignOnAdd = true;
        return;
      }
      var wrapper = this, renderer = wrapper.renderer, elem = wrapper.element, translateX = wrapper.translateX || 0, translateY = wrapper.translateY || 0, x = wrapper.x || 0, y = wrapper.y || 0, align = wrapper.textAlign || "left", alignCorrection = {
        left: 0,
        center: 0.5,
        right: 1
      }[align], styles = wrapper.styles, whiteSpace = styles && styles.whiteSpace;
      function getTextPxLength() {
        css$a(elem, {
          width: "",
          whiteSpace: whiteSpace || "nowrap"
        });
        return elem.offsetWidth;
      }
      css$a(elem, {
        marginLeft: translateX,
        marginTop: translateY
      });
      if (!renderer.styledMode && wrapper.shadows) {
        wrapper.shadows.forEach(function(shadow) {
          css$a(shadow, {
            marginLeft: translateX + 1,
            marginTop: translateY + 1
          });
        });
      }
      if (wrapper.inverted) {
        [].forEach.call(elem.childNodes, function(child) {
          renderer.invertChild(child, elem);
        });
      }
      if (elem.tagName === "SPAN") {
        var rotation = wrapper.rotation, textWidth = wrapper.textWidth && pInt$5(wrapper.textWidth), currentTextTransform = [
          rotation,
          align,
          elem.innerHTML,
          wrapper.textWidth,
          wrapper.textAlign
        ].join(",");
        var baseline = void 0;
        if (textWidth !== wrapper.oldTextWidth && (textWidth > wrapper.oldTextWidth || (wrapper.textPxLength || getTextPxLength()) > textWidth) && // Only set the width if the text is able to word-wrap, or
        // text-overflow is ellipsis (#9537)
        (/[ \-]/.test(elem.textContent || elem.innerText) || elem.style.textOverflow === "ellipsis")) {
          css$a(elem, {
            width: textWidth + "px",
            display: "block",
            whiteSpace: whiteSpace || "normal"
            // #3331
          });
          wrapper.oldTextWidth = textWidth;
          wrapper.hasBoxWidthChanged = true;
        } else {
          wrapper.hasBoxWidthChanged = false;
        }
        if (currentTextTransform !== wrapper.cTT) {
          baseline = renderer.fontMetrics(elem.style.fontSize, elem).b;
          if (defined$T(rotation) && (rotation !== (wrapper.oldRotation || 0) || align !== wrapper.oldAlign)) {
            wrapper.setSpanRotation(rotation, alignCorrection, baseline);
          }
          wrapper.getSpanCorrection(
            // Avoid elem.offsetWidth if we can, it affects rendering
            // time heavily (#7656)
            !defined$T(rotation) && wrapper.textPxLength || // #7920
            elem.offsetWidth,
            baseline,
            alignCorrection,
            rotation,
            align
          );
        }
        css$a(elem, {
          left: x + (wrapper.xCorr || 0) + "px",
          top: y + (wrapper.yCorr || 0) + "px"
        });
        wrapper.cTT = currentTextTransform;
        wrapper.oldRotation = rotation;
        wrapper.oldAlign = align;
      }
    };
    HTMLElement2.prototype.setSpanRotation = function(rotation, alignCorrection, baseline) {
      var getTransformKey = function() {
        return isMS$1 && !/Edge/.test(win$b.navigator.userAgent) ? "-ms-transform" : isWebKit ? "-webkit-transform" : isFirefox$2 ? "MozTransform" : win$b.opera ? "-o-transform" : void 0;
      };
      var rotationStyle = {}, cssTransformKey = getTransformKey();
      if (cssTransformKey) {
        rotationStyle[cssTransformKey] = rotationStyle.transform = "rotate(" + rotation + "deg)";
        rotationStyle[cssTransformKey + (isFirefox$2 ? "Origin" : "-origin")] = rotationStyle.transformOrigin = alignCorrection * 100 + "% " + baseline + "px";
        css$a(this.element, rotationStyle);
      }
    };
    HTMLElement2.composedClasses = [];
    return HTMLElement2;
  })(SVGElement)
);
var __extends$Z = /* @__PURE__ */ (function() {
  var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b3) {
      d2.__proto__ = b3;
    } || function(d2, b3) {
      for (var p in b3) if (b3.hasOwnProperty(p)) d2[p] = b3[p];
    };
    return extendStatics(d, b);
  };
  return function(d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
})();
var attr$3 = Utilities.attr, createElement$7 = Utilities.createElement, extend$1s = Utilities.extend, pick$1z = Utilities.pick;
var HTMLRenderer = (
  /** @class */
  (function(_super) {
    __extends$Z(HTMLRenderer2, _super);
    function HTMLRenderer2() {
      return _super !== null && _super.apply(this, arguments) || this;
    }
    HTMLRenderer2.compose = function(SVGRendererClass) {
      if (HTMLRenderer2.composedClasses.indexOf(SVGRendererClass) === -1) {
        HTMLRenderer2.composedClasses.push(SVGRendererClass);
        var htmlRendererProto = HTMLRenderer2.prototype, svgRendererProto = SVGRendererClass.prototype;
        svgRendererProto.html = htmlRendererProto.html;
      }
      return SVGRendererClass;
    };
    HTMLRenderer2.prototype.html = function(str, x, y) {
      var wrapper = this.createElement("span"), element = wrapper.element, renderer = wrapper.renderer, isSVG = renderer.isSVG, addSetters = function(gWrapper, style) {
        ["opacity", "visibility"].forEach(function(prop) {
          gWrapper[prop + "Setter"] = function(value, key2, elem) {
            var styleObject = gWrapper.div ? gWrapper.div.style : style;
            SVGElement.prototype[prop + "Setter"].call(this, value, key2, elem);
            if (styleObject) {
              styleObject[key2] = value;
            }
          };
        });
        gWrapper.addedSetters = true;
      };
      wrapper.textSetter = function(value) {
        if (value !== this.textStr) {
          delete this.bBox;
          delete this.oldTextWidth;
          AST.setElementHTML(this.element, pick$1z(value, ""));
          this.textStr = value;
          wrapper.doTransform = true;
        }
      };
      if (isSVG) {
        addSetters(wrapper, wrapper.element.style);
      }
      wrapper.xSetter = wrapper.ySetter = wrapper.alignSetter = wrapper.rotationSetter = function(value, key2) {
        if (key2 === "align") {
          wrapper.alignValue = wrapper.textAlign = value;
        } else {
          wrapper[key2] = value;
        }
        wrapper.doTransform = true;
      };
      wrapper.afterSetters = function() {
        if (this.doTransform) {
          this.htmlUpdateTransform();
          this.doTransform = false;
        }
      };
      wrapper.attr({
        text: str,
        x: Math.round(x),
        y: Math.round(y)
      }).css({
        position: "absolute"
      });
      if (!renderer.styledMode) {
        wrapper.css({
          fontFamily: this.style.fontFamily,
          fontSize: this.style.fontSize
        });
      }
      element.style.whiteSpace = "nowrap";
      wrapper.css = wrapper.htmlCss;
      if (isSVG) {
        wrapper.add = function(svgGroupWrapper) {
          var container2 = renderer.box.parentNode, parents = [];
          var htmlGroup, parentGroup;
          this.parentGroup = svgGroupWrapper;
          if (svgGroupWrapper) {
            htmlGroup = svgGroupWrapper.div;
            if (!htmlGroup) {
              parentGroup = svgGroupWrapper;
              while (parentGroup) {
                parents.push(parentGroup);
                parentGroup = parentGroup.parentGroup;
              }
              parents.reverse().forEach(function(parentGroup2) {
                var cls = attr$3(parentGroup2.element, "class");
                function translateSetter(value, key2) {
                  parentGroup2[key2] = value;
                  if (key2 === "translateX") {
                    htmlGroupStyle.left = value + "px";
                  } else {
                    htmlGroupStyle.top = value + "px";
                  }
                  parentGroup2.doTransform = true;
                }
                var parentGroupStyles = parentGroup2.styles || {};
                htmlGroup = parentGroup2.div = parentGroup2.div || createElement$7("div", cls ? { className: cls } : void 0, {
                  position: "absolute",
                  left: (parentGroup2.translateX || 0) + "px",
                  top: (parentGroup2.translateY || 0) + "px",
                  display: parentGroup2.display,
                  opacity: parentGroup2.opacity,
                  cursor: parentGroupStyles.cursor,
                  pointerEvents: parentGroupStyles.pointerEvents,
                  visibility: parentGroup2.visibility
                  // the top group is appended to container
                }, htmlGroup || container2);
                var htmlGroupStyle = htmlGroup.style;
                extend$1s(parentGroup2, {
                  // (#7287) Pass htmlGroup to use
                  // the related group
                  classSetter: /* @__PURE__ */ (function(htmlGroup2) {
                    return function(value) {
                      this.element.setAttribute("class", value);
                      htmlGroup2.className = value;
                    };
                  })(htmlGroup),
                  on: function() {
                    if (parents[0].div) {
                      wrapper.on.apply({
                        element: parents[0].div,
                        onEvents: parentGroup2.onEvents
                      }, arguments);
                    }
                    return parentGroup2;
                  },
                  translateXSetter: translateSetter,
                  translateYSetter: translateSetter
                });
                if (!parentGroup2.addedSetters) {
                  addSetters(parentGroup2);
                }
              });
            }
          } else {
            htmlGroup = container2;
          }
          htmlGroup.appendChild(element);
          wrapper.added = true;
          if (wrapper.alignOnAdd) {
            wrapper.htmlUpdateTransform();
          }
          return wrapper;
        };
      }
      return wrapper;
    };
    HTMLRenderer2.composedClasses = [];
    return HTMLRenderer2;
  })(SVGRenderer)
);
var AxisDefaults;
(function(AxisDefaults2) {
  AxisDefaults2.defaultXAxisOptions = {
    /**
     * When using multiple axis, the ticks of two or more opposite axes
     * will automatically be aligned by adding ticks to the axis or axes
     * with the least ticks, as if `tickAmount` were specified.
     *
     * This can be prevented by setting `alignTicks` to false. If the grid
     * lines look messy, it's a good idea to hide them for the secondary
     * axis by setting `gridLineWidth` to 0.
     *
     * If `startOnTick` or `endOnTick` in an Axis options are set to false,
     * then the `alignTicks ` will be disabled for the Axis.
     *
     * Disabled for logarithmic axes.
     *
     * @product   highcharts highstock gantt
     */
    alignTicks: true,
    /**
     * Whether to allow decimals in this axis' ticks. When counting
     * integers, like persons or hits on a web page, decimals should
     * be avoided in the labels. By default, decimals are allowed on small
     * scale axes.
     *
     * @see [minTickInterval](#xAxis.minTickInterval)
     *
     * @sample {highcharts|highstock} highcharts/yaxis/allowdecimals-true/
     *         True by default
     * @sample {highcharts|highstock} highcharts/yaxis/allowdecimals-false/
     *         False
     *
     * @type      {boolean|undefined}
     * @default   undefined
     * @since     2.0
     */
    allowDecimals: void 0,
    /**
     * When using an alternate grid color, a band is painted across the
     * plot area between every other grid line.
     *
     * @sample {highcharts} highcharts/yaxis/alternategridcolor/
     *         Alternate grid color on the Y axis
     * @sample {highstock} stock/xaxis/alternategridcolor/
     *         Alternate grid color on the Y axis
     *
     * @type      {Highcharts.ColorType}
     * @apioption xAxis.alternateGridColor
     */
    /**
     * An array defining breaks in the axis, the sections defined will be
     * left out and all the points shifted closer to each other.
     *
     * @productdesc {highcharts}
     * Requires that the broken-axis.js module is loaded.
     *
     * @sample {highcharts} highcharts/axisbreak/break-simple/
     *         Simple break
     * @sample {highcharts|highstock} highcharts/axisbreak/break-visualized/
     *         Advanced with callback
     * @sample {highstock} stock/demo/intraday-breaks/
     *         Break on nights and weekends
     *
     * @type      {Array<*>}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks
     */
    /**
     * A number indicating how much space should be left between the start
     * and the end of the break. The break size is given in axis units,
     * so for instance on a `datetime` axis, a break size of 3600000 would
     * indicate the equivalent of an hour.
     *
     * @type      {number}
     * @default   0
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.breakSize
     */
    /**
     * The point where the break starts.
     *
     * @type      {number}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.from
     */
    /**
     * Defines an interval after which the break appears again. By default
     * the breaks do not repeat.
     *
     * @type      {number}
     * @default   0
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.repeat
     */
    /**
     * The point where the break ends.
     *
     * @type      {number}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.breaks.to
     */
    /**
     * If categories are present for the xAxis, names are used instead of
     * numbers for that axis.
     *
     * Since Highcharts 3.0, categories can also
     * be extracted by giving each point a [name](#series.data) and setting
     * axis [type](#xAxis.type) to `category`. However, if you have multiple
     * series, best practice remains defining the `categories` array.
     *
     * Example: `categories: ['Apples', 'Bananas', 'Oranges']`
     *
     * @sample {highcharts} highcharts/demo/line-labels/
     *         With
     * @sample {highcharts} highcharts/xaxis/categories/
     *         Without
     *
     * @type      {Array<string>}
     * @product   highcharts gantt
     * @apioption xAxis.categories
     */
    /**
     * The highest allowed value for automatically computed axis extremes.
     *
     * @see [floor](#xAxis.floor)
     *
     * @sample {highcharts|highstock} highcharts/yaxis/floor-ceiling/
     *         Floor and ceiling
     *
     * @type       {number}
     * @since      4.0
     * @product    highcharts highstock gantt
     * @apioption  xAxis.ceiling
     */
    /**
     * A class name that opens for styling the axis by CSS, especially in
     * Highcharts styled mode. The class name is applied to group elements
     * for the grid, axis elements and labels.
     *
     * @sample {highcharts|highstock|highmaps} highcharts/css/axis/
     *         Multiple axes with separate styling
     *
     * @type      {string}
     * @since     5.0.0
     * @apioption xAxis.className
     */
    /**
     * Configure a crosshair that follows either the mouse pointer or the
     * hovered point.
     *
     * In styled mode, the crosshairs are styled in the
     * `.highcharts-crosshair`, `.highcharts-crosshair-thin` or
     * `.highcharts-xaxis-category` classes.
     *
     * @productdesc {highstock}
     * In Highcharts stock, by default, the crosshair is enabled on the
     * X axis and disabled on the Y axis.
     *
     * @sample {highcharts} highcharts/xaxis/crosshair-both/
     *         Crosshair on both axes
     * @sample {highstock} stock/xaxis/crosshairs-xy/
     *         Crosshair on both axes
     * @sample {highmaps} highcharts/xaxis/crosshair-both/
     *         Crosshair on both axes
     *
     * @declare   Highcharts.AxisCrosshairOptions
     * @type      {boolean|*}
     * @default   false
     * @since     4.1
     * @apioption xAxis.crosshair
     */
    /**
     * A class name for the crosshair, especially as a hook for styling.
     *
     * @type      {string}
     * @since     5.0.0
     * @apioption xAxis.crosshair.className
     */
    /**
     * The color of the crosshair. Defaults to `#cccccc` for numeric and
     * datetime axes, and `rgba(204,214,235,0.25)` for category axes, where
     * the crosshair by default highlights the whole category.
     *
     * @sample {highcharts|highstock|highmaps} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     *
     * @type      {Highcharts.ColorType}
     * @default   #cccccc
     * @since     4.1
     * @apioption xAxis.crosshair.color
     */
    /**
     * The dash style for the crosshair. See
     * [plotOptions.series.dashStyle](#plotOptions.series.dashStyle)
     * for possible values.
     *
     * @sample {highcharts|highmaps} highcharts/xaxis/crosshair-dotted/
     *         Dotted crosshair
     * @sample {highstock} stock/xaxis/crosshair-dashed/
     *         Dashed X axis crosshair
     *
     * @type      {Highcharts.DashStyleValue}
     * @default   Solid
     * @since     4.1
     * @apioption xAxis.crosshair.dashStyle
     */
    /**
     * A label on the axis next to the crosshair.
     *
     * In styled mode, the label is styled with the
     * `.highcharts-crosshair-label` class.
     *
     * @sample {highstock} stock/xaxis/crosshair-label/
     *         Crosshair labels
     * @sample {highstock} highcharts/css/crosshair-label/
     *         Style mode
     *
     * @declare   Highcharts.AxisCrosshairLabelOptions
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label
     */
    /**
     * Alignment of the label compared to the axis. Defaults to `"left"` for
     * right-side axes, `"right"` for left-side axes and `"center"` for
     * horizontal axes.
     *
     * @type      {Highcharts.AlignValue}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.align
     */
    /**
     * The background color for the label. Defaults to the related series
     * color, or `#666666` if that is not available.
     *
     * @type      {Highcharts.ColorType}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.backgroundColor
     */
    /**
     * The border color for the crosshair label
     *
     * @type      {Highcharts.ColorType}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.borderColor
     */
    /**
     * The border corner radius of the crosshair label.
     *
     * @type      {number}
     * @default   3
     * @since     2.1.10
     * @product   highstock
     * @apioption xAxis.crosshair.label.borderRadius
     */
    /**
     * The border width for the crosshair label.
     *
     * @type      {number}
     * @default   0
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.borderWidth
     */
    /**
     * Flag to enable crosshair's label.
     *
     * @sample {highstock} stock/xaxis/crosshairs-xy/
     *         Enabled label for yAxis' crosshair
     *
     * @type      {boolean}
     * @default   false
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.enabled
     */
    /**
     * A format string for the crosshair label. Defaults to `{value}` for
     * numeric axes and `{value:%b %d, %Y}` for datetime axes.
     *
     * @type      {string}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.format
     */
    /**
     * Formatter function for the label text.
     *
     * @type      {Highcharts.XAxisCrosshairLabelFormatterCallbackFunction}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.formatter
     */
    /**
     * Padding inside the crosshair label.
     *
     * @type      {number}
     * @default   8
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.padding
     */
    /**
     * The shape to use for the label box.
     *
     * @type      {string}
     * @default   callout
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.shape
     */
    /**
     * Text styles for the crosshair label.
     *
     * @type      {Highcharts.CSSObject}
     * @default   {"color": "white", "fontWeight": "normal", "fontSize": "11px", "textAlign": "center"}
     * @since     2.1
     * @product   highstock
     * @apioption xAxis.crosshair.label.style
     */
    /**
     * Whether the crosshair should snap to the point or follow the pointer
     * independent of points.
     *
     * @sample {highcharts|highstock} highcharts/xaxis/crosshair-snap-false/
     *         True by default
     * @sample {highmaps} maps/demo/latlon-advanced/
     *         Snap is false
     *
     * @type      {boolean}
     * @default   true
     * @since     4.1
     * @apioption xAxis.crosshair.snap
     */
    /**
     * The pixel width of the crosshair. Defaults to 1 for numeric or
     * datetime axes, and for one category width for category axes.
     *
     * @sample {highcharts} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     * @sample {highstock} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     * @sample {highmaps} highcharts/xaxis/crosshair-customized/
     *         Customized crosshairs
     *
     * @type      {number}
     * @default   1
     * @since     4.1
     * @apioption xAxis.crosshair.width
     */
    /**
     * The Z index of the crosshair. Higher Z indices allow drawing the
     * crosshair on top of the series or behind the grid lines.
     *
     * @type      {number}
     * @default   2
     * @since     4.1
     * @apioption xAxis.crosshair.zIndex
     */
    /**
     * Whether to pan axis. If `chart.panning` is enabled, the option
     * allows to disable panning on an individual axis.
     */
    panningEnabled: true,
    /**
     * The Z index for the axis group.
     */
    zIndex: 2,
    /**
     * Whether to zoom axis. If `chart.zoomType` is set, the option allows
     * to disable zooming on an individual axis.
     *
     * @sample {highcharts} highcharts/xaxis/zoomenabled/
     *         Zoom enabled is false
     */
    zoomEnabled: true,
    /**
     * For a datetime axis, the scale will automatically adjust to the
     * appropriate unit. This member gives the default string
     * representations used for each unit. For intermediate values,
     * different units may be used, for example the `day` unit can be used
     * on midnight and `hour` unit be used for intermediate values on the
     * same axis.
     *
     * For an overview of the replacement codes, see
     * [dateFormat](/class-reference/Highcharts#.dateFormat).
     *
     * Defaults to:
     * ```js
     * {
     *     millisecond: '%H:%M:%S.%L',
     *     second: '%H:%M:%S',
     *     minute: '%H:%M',
     *     hour: '%H:%M',
     *     day: '%e. %b',
     *     week: '%e. %b',
     *     month: '%b \'%y',
     *     year: '%Y'
     * }
     * ```
     *
     * @sample {highcharts} highcharts/xaxis/datetimelabelformats/
     *         Different day format on X axis
     * @sample {highstock} stock/xaxis/datetimelabelformats/
     *         More information in x axis labels
     *
     * @declare Highcharts.AxisDateTimeLabelFormatsOptions
     * @product highcharts highstock gantt
     */
    dateTimeLabelFormats: {
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      millisecond: {
        main: "%H:%M:%S.%L",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      second: {
        main: "%H:%M:%S",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      minute: {
        main: "%H:%M",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      hour: {
        main: "%H:%M",
        range: false
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      day: {
        main: "%e. %b"
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      week: {
        main: "%e. %b"
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      month: {
        main: "%b '%y"
      },
      /**
       * @declare Highcharts.AxisDateTimeLabelFormatsOptionsObject
       * @type {string|*}
       */
      year: {
        main: "%Y"
      }
    },
    /**
     * Whether to force the axis to end on a tick. Use this option with
     * the `maxPadding` option to control the axis end.
     *
     * @productdesc {highstock}
     * In Highcharts Stock, `endOnTick` is always `false` when the navigator
     * is enabled, to prevent jumpy scrolling.
     *
     * @sample {highcharts} highcharts/chart/reflow-true/
     *         True by default
     * @sample {highcharts} highcharts/yaxis/endontick/
     *         False
     * @sample {highstock} stock/demo/basic-line/
     *         True by default
     * @sample {highstock} stock/xaxis/endontick/
     *         False
     *
     * @since 1.2.0
     */
    endOnTick: false,
    /**
     * Event handlers for the axis.
     *
     * @type      {*}
     * @apioption xAxis.events
     */
    /**
     * An event fired after the breaks have rendered.
     *
     * @see [breaks](#xAxis.breaks)
     *
     * @sample {highcharts} highcharts/axisbreak/break-event/
     *         AfterBreak Event
     *
     * @type      {Highcharts.AxisEventCallbackFunction}
     * @since     4.1.0
     * @product   highcharts gantt
     * @apioption xAxis.events.afterBreaks
     */
    /**
     * As opposed to the `setExtremes` event, this event fires after the
     * final min and max values are computed and corrected for `minRange`.
     *
     * Fires when the minimum and maximum is set for the axis, either by
     * calling the `.setExtremes()` method or by selecting an area in the
     * chart. One parameter, `event`, is passed to the function, containing
     * common event information.
     *
     * The new user set minimum and maximum values can be found by
     * `event.min` and `event.max`. These reflect the axis minimum and
     * maximum in axis values. The actual data extremes are found in
     * `event.dataMin` and `event.dataMax`.
     *
     * @type      {Highcharts.AxisSetExtremesEventCallbackFunction}
     * @since     2.3
     * @context   Highcharts.Axis
     * @apioption xAxis.events.afterSetExtremes
     */
    /**
     * An event fired when a break from this axis occurs on a point.
     *
     * @see [breaks](#xAxis.breaks)
     *
     * @sample {highcharts} highcharts/axisbreak/break-visualized/
     *         Visualization of a Break
     *
     * @type      {Highcharts.AxisPointBreakEventCallbackFunction}
     * @since     4.1.0
     * @product   highcharts gantt
     * @context   Highcharts.Axis
     * @apioption xAxis.events.pointBreak
     */
    /**
     * An event fired when a point falls inside a break from this axis.
     *
     * @type      {Highcharts.AxisPointBreakEventCallbackFunction}
     * @product   highcharts highstock gantt
     * @context   Highcharts.Axis
     * @apioption xAxis.events.pointInBreak
     */
    /**
     * Fires when the minimum and maximum is set for the axis, either by
     * calling the `.setExtremes()` method or by selecting an area in the
     * chart. One parameter, `event`, is passed to the function,
     * containing common event information.
     *
     * The new user set minimum and maximum values can be found by
     * `event.min` and `event.max`. These reflect the axis minimum and
     * maximum in data values. When an axis is zoomed all the way out from
     * the "Reset zoom" button, `event.min` and `event.max` are null, and
     * the new extremes are set based on `this.dataMin` and `this.dataMax`.
     *
     * @sample {highstock} stock/xaxis/events-setextremes/
     *         Log new extremes on x axis
     *
     * @type      {Highcharts.AxisSetExtremesEventCallbackFunction}
     * @since     1.2.0
     * @context   Highcharts.Axis
     * @apioption xAxis.events.setExtremes
     */
    /**
     * The lowest allowed value for automatically computed axis extremes.
     *
     * @see [ceiling](#yAxis.ceiling)
     *
     * @sample {highcharts} highcharts/yaxis/floor-ceiling/
     *         Floor and ceiling
     * @sample {highstock} stock/demo/lazy-loading/
     *         Prevent negative stock price on Y axis
     *
     * @type      {number}
     * @since     4.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.floor
     */
    /**
     * The dash or dot style of the grid lines. For possible values, see
     * [this demonstration](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-dashstyle-all/).
     *
     * @sample {highcharts} highcharts/yaxis/gridlinedashstyle/
     *         Long dashes
     * @sample {highstock} stock/xaxis/gridlinedashstyle/
     *         Long dashes
     *
     * @type      {Highcharts.DashStyleValue}
     * @since     1.2
     */
    gridLineDashStyle: "Solid",
    /**
     * The Z index of the grid lines.
     *
     * @sample {highcharts|highstock} highcharts/xaxis/gridzindex/
     *         A Z index of 4 renders the grid above the graph
     *
     * @product   highcharts highstock gantt
     */
    gridZIndex: 1,
    /**
     * An id for the axis. This can be used after render time to get
     * a pointer to the axis object through `chart.get()`.
     *
     * @sample {highcharts} highcharts/xaxis/id/
     *         Get the object
     * @sample {highstock} stock/xaxis/id/
     *         Get the object
     *
     * @type      {string}
     * @since     1.2.0
     * @apioption xAxis.id
     */
    /**
     * The axis labels show the number or category for each tick.
     *
     * Since v8.0.0: Labels are animated in categorized x-axis with
     * updating data if `tickInterval` and `step` is set to 1.
     *
     * @productdesc {highmaps}
     * X and Y axis labels are by default disabled in Highmaps, but the
     * functionality is inherited from Highcharts and used on `colorAxis`,
     * and can be enabled on X and Y axes too.
     */
    labels: {
      /**
       * What part of the string the given position is anchored to.
       * If `left`, the left side of the string is at the axis position.
       * Can be one of `"left"`, `"center"` or `"right"`. Defaults to
       * an intelligent guess based on which side of the chart the axis
       * is on and the rotation of the label.
       *
       * @see [reserveSpace](#xAxis.labels.reserveSpace)
       *
       * @sample {highcharts} highcharts/xaxis/labels-align-left/
       *         Left
       * @sample {highcharts} highcharts/xaxis/labels-align-right/
       *         Right
       * @sample {highcharts} highcharts/xaxis/labels-reservespace-true/
       *         Left-aligned labels on a vertical category axis
       *
       * @type       {Highcharts.AlignValue}
       * @apioption  xAxis.labels.align
       */
      /**
       * Whether to allow the axis labels to overlap.
       * When false, overlapping labels are hidden.
       *
       * @sample {highcharts} highcharts/xaxis/labels-allowoverlap-true/
       *         X axis labels overlap enabled
       *
       * @type {boolean}
       * @default false
       * @apioption xAxis.labels.allowOverlap
       *
       */
      /**
       * For horizontal axes, the allowed degrees of label rotation
       * to prevent overlapping labels. If there is enough space,
       * labels are not rotated. As the chart gets narrower, it
       * will start rotating the labels -45 degrees, then remove
       * every second label and try again with rotations 0 and -45 etc.
       * Set it to `undefined` to disable rotation, which will
       * cause the labels to word-wrap if possible. Defaults to `[-45]``
       * on bottom and top axes, `undefined` on left and right axes.
       *
       * @sample {highcharts|highstock} highcharts/xaxis/labels-autorotation-default/
       *         Default auto rotation of 0 or -45
       * @sample {highcharts|highstock} highcharts/xaxis/labels-autorotation-0-90/
       *         Custom graded auto rotation
       *
       * @type      {Array<number>}
       * @default   undefined
       * @since     4.1.0
       * @product   highcharts highstock gantt
       * @apioption xAxis.labels.autoRotation
       */
      autoRotation: void 0,
      /**
       * When each category width is more than this many pixels, we don't
       * apply auto rotation. Instead, we lay out the axis label with word
       * wrap. A lower limit makes sense when the label contains multiple
       * short words that don't extend the available horizontal space for
       * each label.
       *
       * @sample {highcharts} highcharts/xaxis/labels-autorotationlimit/
       *         Lower limit
       *
       * @since     4.1.5
       * @product   highcharts gantt
       */
      autoRotationLimit: 80,
      /**
       * Polar charts only. The label's pixel distance from the perimeter
       * of the plot area.
       *
       * @type      {number}
       * @default   undefined
       * @product   highcharts gantt
       */
      distance: void 0,
      /**
       * Enable or disable the axis labels.
       *
       * @sample {highcharts} highcharts/xaxis/labels-enabled/
       *         X axis labels disabled
       * @sample {highstock} stock/xaxis/labels-enabled/
       *         X axis labels disabled
       *
       * @default {highcharts|highstock|gantt} true
       * @default {highmaps} false
       */
      enabled: true,
      /**
       * A format string for the axis label. The context is available as
       * format string variables. For example, you can use `{text}` to
       * insert the default formatted text. The recommended way of adding
       * units for the label is using `text`, for example `{text} km`.
       *
       * To add custom numeric or datetime formatting, use `{value}` with
       * formatting, for example `{value:.1f}` or `{value:%Y-%m-%d}`.
       *
       * See
       * [format string](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting)
       * for more examples of formatting.
       *
       * The default value is not specified due to the dynamic
       * nature of the default implementation.
       *
       * @sample {highcharts|highstock} highcharts/yaxis/labels-format/
       *         Add units to Y axis label
       * @sample {highcharts} highcharts/xaxis/labels-format-linked/
       *         Linked category names
       * @sample {highcharts} highcharts/xaxis/labels-format-custom/
       *         Custom number format
       *
       * @type      {string}
       * @since     3.0
       * @apioption xAxis.labels.format
       */
      /**
       * Callback JavaScript function to format the label. The value
       * is given by `this.value`. Additional properties for `this` are
       * `axis`, `chart`, `isFirst`, `isLast` and `text` which holds the
       * value of the default formatter.
       *
       * Defaults to a built in function returning a formatted string
       * depending on whether the axis is `category`, `datetime`,
       * `numeric` or other.
       *
       * @sample {highcharts} highcharts/xaxis/labels-formatter-linked/
       *         Linked category names
       * @sample {highcharts} highcharts/xaxis/labels-formatter-extended/
       *         Modified numeric labels
       * @sample {highstock} stock/xaxis/labels-formatter/
       *         Added units on Y axis
       *
       * @type      {Highcharts.AxisLabelsFormatterCallbackFunction}
       * @apioption xAxis.labels.formatter
       */
      /**
       * The number of pixels to indent the labels per level in a treegrid
       * axis.
       *
       * @sample gantt/treegrid-axis/demo
       *         Indentation 10px by default.
       * @sample gantt/treegrid-axis/indentation-0px
       *         Indentation set to 0px.
       *
       * @product gantt
       */
      indentation: 10,
      /**
       * Horizontal axis only. When `staggerLines` is not set,
       * `maxStaggerLines` defines how many lines the axis is allowed to
       * add to automatically avoid overlapping X labels. Set to `1` to
       * disable overlap detection.
       *
       * @deprecated
       * @type      {number}
       * @default   5
       * @since     1.3.3
       * @apioption xAxis.labels.maxStaggerLines
       */
      /**
       * How to handle overflowing labels on horizontal axis. If set to
       * `"allow"`, it will not be aligned at all. By default it
       * `"justify"` labels inside the chart area. If there is room to
       * move it, it will be aligned to the edge, else it will be removed.
       *
       * @since      2.2.5
       * @validvalue ["allow", "justify"]
       */
      overflow: "justify",
      /**
       * The pixel padding for axis labels, to ensure white space between
       * them.
       *
       * @product   highcharts gantt
       */
      padding: 5,
      /**
       * Whether to reserve space for the labels. By default, space is
       * reserved for the labels in these cases:
       *
       * * On all horizontal axes.
       * * On vertical axes if `label.align` is `right` on a left-side
       * axis or `left` on a right-side axis.
       * * On vertical axes if `label.align` is `center`.
       *
       * This can be turned off when for example the labels are rendered
       * inside the plot area instead of outside.
       *
       * @see [labels.align](#xAxis.labels.align)
       *
       * @sample {highcharts} highcharts/xaxis/labels-reservespace/
       *         No reserved space, labels inside plot
       * @sample {highcharts} highcharts/xaxis/labels-reservespace-true/
       *         Left-aligned labels on a vertical category axis
       *
       * @type      {boolean}
       * @since     4.1.10
       * @product   highcharts gantt
       * @apioption xAxis.labels.reserveSpace
       */
      reserveSpace: void 0,
      /**
       * Rotation of the labels in degrees. When `undefined`, the
       * `autoRotation` option takes precedence.
       *
       * @sample {highcharts} highcharts/xaxis/labels-rotation/
       *         X axis labels rotated 90°
       *
       * @type      {number}
       * @default   0
       * @apioption xAxis.labels.rotation
       */
      rotation: void 0,
      /**
       * Horizontal axes only. The number of lines to spread the labels
       * over to make room or tighter labels. 0 disables staggering.
       *
       * @sample {highcharts} highcharts/xaxis/labels-staggerlines/
       *         Show labels over two lines
       * @sample {highstock} stock/xaxis/labels-staggerlines/
       *         Show labels over two lines
       *
       * @since     2.1
       */
      staggerLines: 0,
      /**
       * To show only every _n_'th label on the axis, set the step to _n_.
       * Setting the step to 2 shows every other label.
       *
       * By default, when 0, the step is calculated automatically to avoid
       * overlap. To prevent this, set it to 1\. This usually only
       * happens on a category axis, and is often a sign that you have
       * chosen the wrong axis type.
       *
       * Read more at
       * [Axis docs](https://www.highcharts.com/docs/chart-concepts/axes)
       * => What axis should I use?
       *
       * @sample {highcharts} highcharts/xaxis/labels-step/
       *         Showing only every other axis label on a categorized
       *         x-axis
       * @sample {highcharts} highcharts/xaxis/labels-step-auto/
       *         Auto steps on a category axis
       *
       * @since     2.1
       */
      step: 0,
      /**
       * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
       * to render the labels.
       */
      useHTML: false,
      /**
       * The x position offset of all labels relative to the tick
       * positions on the axis.
       *
       * @sample {highcharts} highcharts/xaxis/labels-x/
       *         Y axis labels placed on grid lines
       */
      x: 0,
      /**
       * The y position offset of all labels relative to the tick
       * positions on the axis. The default makes it adapt to the font
       * size of the bottom axis.
       *
       * @sample {highcharts} highcharts/xaxis/labels-x/
       *         Y axis labels placed on grid lines
       *
       * @type      {number}
       * @apioption xAxis.labels.y
       */
      /**
       * The Z index for the axis labels.
       */
      zIndex: 7,
      /**
       * CSS styles for the label. Use `whiteSpace: 'nowrap'` to prevent
       * wrapping of category labels. Use `textOverflow: 'none'` to
       * prevent ellipsis (dots).
       *
       * In styled mode, the labels are styled with the
       * `.highcharts-axis-labels` class.
       *
       * @sample {highcharts} highcharts/xaxis/labels-style/
       *         Red X axis labels
       *
       * @type      {Highcharts.CSSObject}
       */
      style: {
        /** @internal */
        color: palette.neutralColor60,
        /** @internal */
        cursor: "default",
        /** @internal */
        fontSize: "11px"
      }
    },
    /**
     * The left position as the horizontal axis. If it's a number, it is
     * interpreted as pixel position relative to the chart.
     *
     * Since Highcharts v5.0.13: If it's a percentage string, it is
     * interpreted as percentages of the plot width, offset from plot area
     * left.
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.left
     */
    /**
     * The top position as the vertical axis. If it's a number, it is
     * interpreted as pixel position relative to the chart.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted
     * as percentages of the plot height, offset from plot area top.
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.top
     */
    /**
     * Index of another axis that this axis is linked to. When an axis is
     * linked to a master axis, it will take the same extremes as
     * the master, but as assigned by min or max or by setExtremes.
     * It can be used to show additional info, or to ease reading the
     * chart by duplicating the scales.
     *
     * @sample {highcharts} highcharts/xaxis/linkedto/
     *         Different string formats of the same date
     * @sample {highcharts} highcharts/yaxis/linkedto/
     *         Y values on both sides
     *
     * @type      {number}
     * @since     2.0.2
     * @product   highcharts highstock gantt
     * @apioption xAxis.linkedTo
     */
    /**
     * The maximum value of the axis. If `null`, the max value is
     * automatically calculated.
     *
     * If the [endOnTick](#yAxis.endOnTick) option is true, the `max` value
     * might be rounded up.
     *
     * If a [tickAmount](#yAxis.tickAmount) is set, the axis may be extended
     * beyond the set max in order to reach the given number of ticks. The
     * same may happen in a chart with multiple axes, determined by [chart.
     * alignTicks](#chart), where a `tickAmount` is applied internally.
     *
     * @sample {highcharts} highcharts/yaxis/max-200/
     *         Y axis max of 200
     * @sample {highcharts} highcharts/yaxis/max-logarithmic/
     *         Y axis max on logarithmic axis
     * @sample {highstock} stock/xaxis/min-max/
     *         Fixed min and max on X axis
     * @sample {highmaps} maps/axis/min-max/
     *         Pre-zoomed to a specific area
     *
     * @type      {number|null}
     * @apioption xAxis.max
     */
    /**
     * Padding of the max value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the highest data value to appear on the edge
     * of the plot area. When the axis' `max` option is set or a max extreme
     * is set using `axis.setExtremes()`, the maxPadding will be ignored.
     *
     * @productdesc {highstock}
     * For an [ordinal](#xAxis.ordinal) axis, `minPadding` and `maxPadding`
     * are ignored. Use [overscroll](#xAxis.overscroll) instead.
     *
     * @sample {highcharts} highcharts/yaxis/maxpadding/
     *         Max padding of 0.25 on y axis
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
     *         Add some padding
     *
     * @default   {highcharts} 0.01
     * @default   {highstock|highmaps} 0
     * @since     1.2.0
     */
    maxPadding: 0.01,
    /**
     * Deprecated. Use `minRange` instead.
     *
     * @deprecated
     * @type      {number}
     * @product   highcharts highstock
     * @apioption xAxis.maxZoom
     */
    /**
     * The minimum value of the axis. If `null` the min value is
     * automatically calculated.
     *
     * If the [startOnTick](#yAxis.startOnTick) option is true (default),
     * the `min` value might be rounded down.
     *
     * The automatically calculated minimum value is also affected by
     * [floor](#yAxis.floor), [softMin](#yAxis.softMin),
     * [minPadding](#yAxis.minPadding), [minRange](#yAxis.minRange)
     * as well as [series.threshold](#plotOptions.series.threshold)
     * and [series.softThreshold](#plotOptions.series.softThreshold).
     *
     * @sample {highcharts} highcharts/yaxis/min-startontick-false/
     *         -50 with startOnTick to false
     * @sample {highcharts} highcharts/yaxis/min-startontick-true/
     *         -50 with startOnTick true by default
     * @sample {highstock} stock/xaxis/min-max/
     *         Set min and max on X axis
     * @sample {highmaps} maps/axis/min-max/
     *         Pre-zoomed to a specific area
     *
     * @type      {number|null}
     * @apioption xAxis.min
     */
    /**
     * The dash or dot style of the minor grid lines. For possible values,
     * see [this demonstration](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/plotoptions/series-dashstyle-all/).
     *
     * @sample {highcharts} highcharts/yaxis/minorgridlinedashstyle/
     *         Long dashes on minor grid lines
     * @sample {highstock} stock/xaxis/minorgridlinedashstyle/
     *         Long dashes on minor grid lines
     *
     * @type      {Highcharts.DashStyleValue}
     * @since     1.2
     */
    minorGridLineDashStyle: "Solid",
    /**
     * Specific tick interval in axis units for the minor ticks. On a linear
     * axis, if `"auto"`, the minor tick interval is calculated as a fifth
     * of the tickInterval. If `null` or `undefined`, minor ticks are not
     * shown.
     *
     * On logarithmic axes, the unit is the power of the value. For example,
     * setting the minorTickInterval to 1 puts one tick on each of 0.1, 1,
     * 10, 100 etc. Setting the minorTickInterval to 0.1 produces 9 ticks
     * between 1 and 10, 10 and 100 etc.
     *
     * If user settings dictate minor ticks to become too dense, they don't
     * make sense, and will be ignored to prevent performance problems.
     *
     * @sample {highcharts} highcharts/yaxis/minortickinterval-null/
     *         Null by default
     * @sample {highcharts} highcharts/yaxis/minortickinterval-5/
     *         5 units
     * @sample {highcharts} highcharts/yaxis/minortickinterval-log-auto/
     *         "auto"
     * @sample {highcharts} highcharts/yaxis/minortickinterval-log/
     *         0.1
     * @sample {highstock} stock/demo/basic-line/
     *         Null by default
     * @sample {highstock} stock/xaxis/minortickinterval-auto/
     *         "auto"
     *
     * @type      {number|string|null}
     * @apioption xAxis.minorTickInterval
     */
    /**
     * The pixel length of the minor tick marks.
     *
     * @sample {highcharts} highcharts/yaxis/minorticklength/
     *         10px on Y axis
     * @sample {highstock} stock/xaxis/minorticks/
     *         10px on Y axis
     */
    minorTickLength: 2,
    /**
     * The position of the minor tick marks relative to the axis line.
     *  Can be one of `inside` and `outside`.
     *
     * @sample {highcharts} highcharts/yaxis/minortickposition-outside/
     *         Outside by default
     * @sample {highcharts} highcharts/yaxis/minortickposition-inside/
     *         Inside
     * @sample {highstock} stock/xaxis/minorticks/
     *         Inside
     *
     * @validvalue ["inside", "outside"]
     */
    minorTickPosition: "outside",
    /**
     * Enable or disable minor ticks. Unless
     * [minorTickInterval](#xAxis.minorTickInterval) is set, the tick
     * interval is calculated as a fifth of the `tickInterval`.
     *
     * On a logarithmic axis, minor ticks are laid out based on a best
     * guess, attempting to enter approximately 5 minor ticks between
     * each major tick.
     *
     * Prior to v6.0.0, ticks were unabled in auto layout by setting
     * `minorTickInterval` to `"auto"`.
     *
     * @productdesc {highcharts}
     * On axes using [categories](#xAxis.categories), minor ticks are not
     * supported.
     *
     * @sample {highcharts} highcharts/yaxis/minorticks-true/
     *         Enabled on linear Y axis
     *
     * @type      {boolean}
     * @default   false
     * @since     6.0.0
     * @apioption xAxis.minorTicks
     */
    /**
     * The pixel width of the minor tick mark.
     *
     * @sample {highcharts} highcharts/yaxis/minortickwidth/
     *         3px width
     * @sample {highstock} stock/xaxis/minorticks/
     *         1px width
     *
     * @type      {number}
     * @default   0
     * @apioption xAxis.minorTickWidth
     */
    /**
     * Padding of the min value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the lowest data value to appear on the edge
     * of the plot area. When the axis' `min` option is set or a min extreme
     * is set using `axis.setExtremes()`, the minPadding will be ignored.
     *
     * @productdesc {highstock}
     * For an [ordinal](#xAxis.ordinal) axis, `minPadding` and `maxPadding`
     * are ignored. Use [overscroll](#xAxis.overscroll) instead.
     *
     * @sample {highcharts} highcharts/yaxis/minpadding/
     *         Min padding of 0.2
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     * @sample {highmaps} maps/chart/plotbackgroundcolor-gradient/
     *         Add some padding
     *
     * @default    {highcharts} 0.01
     * @default    {highstock|highmaps} 0
     * @since      1.2.0
     * @product    highcharts highstock gantt
     */
    minPadding: 0.01,
    /**
     * The minimum range to display on this axis. The entire axis will not
     * be allowed to span over a smaller interval than this. For example,
     * for a datetime axis the main unit is milliseconds. If minRange is
     * set to 3600000, you can't zoom in more than to one hour.
     *
     * The default minRange for the x axis is five times the smallest
     * interval between any of the data points.
     *
     * On a logarithmic axis, the unit for the minimum range is the power.
     * So a minRange of 1 means that the axis can be zoomed to 10-100,
     * 100-1000, 1000-10000 etc.
     *
     * **Note**: The `minPadding`, `maxPadding`, `startOnTick` and
     * `endOnTick` settings also affect how the extremes of the axis
     * are computed.
     *
     * @sample {highcharts} highcharts/xaxis/minrange/
     *         Minimum range of 5
     * @sample {highstock} stock/xaxis/minrange/
     *         Max zoom of 6 months overrides user selections
     * @sample {highmaps} maps/axis/minrange/
     *         Minimum range of 1000
     *
     * @type      {number}
     * @apioption xAxis.minRange
     */
    /**
     * The minimum tick interval allowed in axis values. For example on
     * zooming in on an axis with daily data, this can be used to prevent
     * the axis from showing hours. Defaults to the closest distance between
     * two points on the axis.
     *
     * @type      {number}
     * @since     2.3.0
     * @apioption xAxis.minTickInterval
     */
    /**
     * The distance in pixels from the plot area to the axis line.
     * A positive offset moves the axis with it's line, labels and ticks
     * away from the plot area. This is typically used when two or more
     * axes are displayed on the same side of the plot. With multiple
     * axes the offset is dynamically adjusted to avoid collision, this
     * can be overridden by setting offset explicitly.
     *
     * @sample {highcharts} highcharts/yaxis/offset/
     *         Y axis offset of 70
     * @sample {highcharts} highcharts/yaxis/offset-centered/
     *         Axes positioned in the center of the plot
     * @sample {highstock} stock/xaxis/offset/
     *         Y axis offset by 70 px
     *
     * @type {number}
     */
    offset: void 0,
    /**
     * Whether to display the axis on the opposite side of the normal. The
     * normal is on the left side for vertical axes and bottom for
     * horizontal, so the opposite sides will be right and top respectively.
     * This is typically used with dual or multiple axes.
     *
     * @sample {highcharts} highcharts/yaxis/opposite/
     *         Secondary Y axis opposite
     * @sample {highstock} stock/xaxis/opposite/
     *         Y axis on left side
     *
     * @default   {highcharts|highstock|highmaps} false
     * @default   {gantt} true
     */
    opposite: false,
    /**
     * In an ordinal axis, the points are equally spaced in the chart
     * regardless of the actual time or x distance between them. This means
     * that missing data periods (e.g. nights or weekends for a stock chart)
     * will not take up space in the chart.
     * Having `ordinal: false` will show any gaps created by the `gapSize`
     * setting proportionate to their duration.
     *
     * In stock charts the X axis is ordinal by default, unless
     * the boost module is used and at least one of the series' data length
     * exceeds the [boostThreshold](#series.line.boostThreshold).
     *
     * For an ordinal axis, `minPadding` and `maxPadding` are ignored. Use
     * [overscroll](#xAxis.overscroll) instead.
     *
     * @sample {highstock} stock/xaxis/ordinal-true/
     *         True by default
     * @sample {highstock} stock/xaxis/ordinal-false/
     *         False
     *
     * @see [overscroll](#xAxis.overscroll)
     *
     * @type      {boolean}
     * @default   true
     * @since     1.1
     * @product   highstock
     * @apioption xAxis.ordinal
     */
    /**
     * Additional range on the right side of the xAxis. Works similar to
     * `xAxis.maxPadding`, but value is set in milliseconds. Can be set for
     * both main `xAxis` and the navigator's `xAxis`.
     *
     * @sample {highstock} stock/xaxis/overscroll/
     *         One minute overscroll with live data
     *
     * @type      {number}
     * @default   0
     * @since     6.0.0
     * @product   highstock
     * @apioption xAxis.overscroll
     */
    /**
     * Refers to the index in the [panes](#panes) array. Used for circular
     * gauges and polar charts. When the option is not set then first pane
     * will be used.
     *
     * @sample highcharts/demo/gauge-vu-meter
     *         Two gauges with different center
     *
     * @type      {number}
     * @product   highcharts
     * @apioption xAxis.pane
     */
    /**
     * The zoomed range to display when only defining one or none of `min`
     * or `max`. For example, to show the latest month, a range of one month
     * can be set.
     *
     * @sample {highstock} stock/xaxis/range/
     *         Setting a zoomed range when the rangeSelector is disabled
     *
     * @type      {number}
     * @product   highstock
     * @apioption xAxis.range
     */
    /**
     * Whether to reverse the axis so that the highest number is closest
     * to the origin. If the chart is inverted, the x axis is reversed by
     * default.
     *
     * @sample {highcharts} highcharts/yaxis/reversed/
     *         Reversed Y axis
     * @sample {highstock} stock/xaxis/reversed/
     *         Reversed Y axis
     *
     * @type      {boolean}
     * @default   undefined
     * @apioption xAxis.reversed
     */
    reversed: void 0,
    /**
     * This option determines how stacks should be ordered within a group.
     * For example reversed xAxis also reverses stacks, so first series
     * comes last in a group. To keep order like for non-reversed xAxis
     * enable this option.
     *
     * @sample {highcharts} highcharts/xaxis/reversedstacks/
     *         Reversed stacks comparison
     * @sample {highstock} highcharts/xaxis/reversedstacks/
     *         Reversed stacks comparison
     *
     * @since     6.1.1
     * @product   highcharts highstock
     */
    reversedStacks: false,
    /**
     * An optional scrollbar to display on the X axis in response to
     * limiting the minimum and maximum of the axis values.
     *
     * In styled mode, all the presentational options for the scrollbar are
     * replaced by the classes `.highcharts-scrollbar-thumb`,
     * `.highcharts-scrollbar-arrow`, `.highcharts-scrollbar-button`,
     * `.highcharts-scrollbar-rifles` and `.highcharts-scrollbar-track`.
     *
     * @sample {highstock} stock/yaxis/heatmap-scrollbars/
     *         Heatmap with both scrollbars
     *
     * @extends   scrollbar
     * @since     4.2.6
     * @product   highstock
     * @apioption xAxis.scrollbar
     */
    /**
     * Whether to show the axis line and title when the axis has no data.
     *
     * @sample {highcharts} highcharts/yaxis/showempty/
     *         When clicking the legend to hide series, one axis preserves
     *         line and title, the other doesn't
     * @sample {highstock} highcharts/yaxis/showempty/
     *         When clicking the legend to hide series, one axis preserves
     *         line and title, the other doesn't
     *
     * @since     1.1
     */
    showEmpty: true,
    /**
     * Whether to show the first tick label.
     *
     * @sample {highcharts} highcharts/xaxis/showfirstlabel-false/
     *         Set to false on X axis
     * @sample {highstock} stock/xaxis/showfirstlabel/
     *         Labels below plot lines on Y axis
     */
    showFirstLabel: true,
    /**
     * Whether to show the last tick label. Defaults to `true` on cartesian
     * charts, and `false` on polar charts.
     *
     * @sample {highcharts} highcharts/xaxis/showlastlabel-true/
     *         Set to true on X axis
     * @sample {highstock} stock/xaxis/showfirstlabel/
     *         Labels below plot lines on Y axis
     *
     * @product   highcharts highstock gantt
     */
    showLastLabel: true,
    /**
     * A soft maximum for the axis. If the series data maximum is less than
     * this, the axis will stay at this maximum, but if the series data
     * maximum is higher, the axis will flex to show all data.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption xAxis.softMax
     */
    /**
     * A soft minimum for the axis. If the series data minimum is greater
     * than this, the axis will stay at this minimum, but if the series
     * data minimum is lower, the axis will flex to show all data.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption xAxis.softMin
     */
    /**
     * For datetime axes, this decides where to put the tick between weeks.
     *  0 = Sunday, 1 = Monday.
     *
     * @sample {highcharts} highcharts/xaxis/startofweek-monday/
     *         Monday by default
     * @sample {highcharts} highcharts/xaxis/startofweek-sunday/
     *         Sunday
     * @sample {highstock} stock/xaxis/startofweek-1
     *         Monday by default
     * @sample {highstock} stock/xaxis/startofweek-0
     *         Sunday
     *
     * @product highcharts highstock gantt
     */
    startOfWeek: 1,
    /**
     * Whether to force the axis to start on a tick. Use this option with
     * the `minPadding` option to control the axis start.
     *
     * @productdesc {highstock}
     * In Highcharts Stock, `startOnTick` is always `false` when
     * the navigator is enabled, to prevent jumpy scrolling.
     *
     * @sample {highcharts} highcharts/xaxis/startontick-false/
     *         False by default
     * @sample {highcharts} highcharts/xaxis/startontick-true/
     *         True
     *
     * @since 1.2.0
     */
    startOnTick: false,
    /**
     * The amount of ticks to draw on the axis. This opens up for aligning
     * the ticks of multiple charts or panes within a chart. This option
     * overrides the `tickPixelInterval` option.
     *
     * This option only has an effect on linear axes. Datetime, logarithmic
     * or category axes are not affected.
     *
     * @sample {highcharts} highcharts/yaxis/tickamount/
     *         8 ticks on Y axis
     * @sample {highstock} highcharts/yaxis/tickamount/
     *         8 ticks on Y axis
     *
     * @type      {number}
     * @since     4.1.0
     * @product   highcharts highstock gantt
     * @apioption xAxis.tickAmount
     */
    /**
     * The interval of the tick marks in axis units. When `undefined`, the
     * tick interval is computed to approximately follow the
     * [tickPixelInterval](#xAxis.tickPixelInterval) on linear and datetime
     * axes. On categorized axes, a `undefined` tickInterval will default to
     * 1, one category. Note that datetime axes are based on milliseconds,
     * so for example an interval of one day is expressed as
     * `24 * 3600 * 1000`.
     *
     * On logarithmic axes, the tickInterval is based on powers, so a
     * tickInterval of 1 means one tick on each of 0.1, 1, 10, 100 etc. A
     * tickInterval of 2 means a tick of 0.1, 10, 1000 etc. A tickInterval
     * of 0.2 puts a tick on 0.1, 0.2, 0.4, 0.6, 0.8, 1, 2, 4, 6, 8, 10, 20,
     * 40 etc.
     *
     *
     * If the tickInterval is too dense for labels to be drawn, Highcharts
     * may remove ticks.
     *
     * If the chart has multiple axes, the [alignTicks](#chart.alignTicks)
     * option may interfere with the `tickInterval` setting.
     *
     * @see [tickPixelInterval](#xAxis.tickPixelInterval)
     * @see [tickPositions](#xAxis.tickPositions)
     * @see [tickPositioner](#xAxis.tickPositioner)
     *
     * @sample {highcharts} highcharts/xaxis/tickinterval-5/
     *         Tick interval of 5 on a linear axis
     * @sample {highstock} stock/xaxis/tickinterval/
     *         Tick interval of 0.01 on Y axis
     *
     * @type      {number}
     * @apioption xAxis.tickInterval
     */
    /**
     * The pixel length of the main tick marks.
     *
     * @sample {highcharts} highcharts/xaxis/ticklength/
     *         20 px tick length on the X axis
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     */
    tickLength: 10,
    /**
     * If tickInterval is `null` this option sets the approximate pixel
     * interval of the tick marks. Not applicable to categorized axis.
     *
     * The tick interval is also influenced by the [minTickInterval](
     * #xAxis.minTickInterval) option, that, by default prevents ticks from
     * being denser than the data points.
     *
     * @see [tickInterval](#xAxis.tickInterval)
     * @see [tickPositioner](#xAxis.tickPositioner)
     * @see [tickPositions](#xAxis.tickPositions)
     *
     * @sample {highcharts} highcharts/xaxis/tickpixelinterval-50/
     *         50 px on X axis
     * @sample {highstock} stock/xaxis/tickpixelinterval/
     *         200 px on X axis
     */
    tickPixelInterval: 100,
    /**
     * For categorized axes only. If `on` the tick mark is placed in the
     * center of the category, if `between` the tick mark is placed between
     * categories. The default is `between` if the `tickInterval` is 1, else
     * `on`.
     *
     * @sample {highcharts} highcharts/xaxis/tickmarkplacement-between/
     *         "between" by default
     * @sample {highcharts} highcharts/xaxis/tickmarkplacement-on/
     *         "on"
     *
     * @product    highcharts gantt
     * @validvalue ["on", "between"]
     */
    tickmarkPlacement: "between",
    /**
     * The position of the major tick marks relative to the axis line.
     * Can be one of `inside` and `outside`.
     *
     * @sample {highcharts} highcharts/xaxis/tickposition-outside/
     *         "outside" by default
     * @sample {highcharts} highcharts/xaxis/tickposition-inside/
     *         "inside"
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     *
     * @validvalue ["inside", "outside"]
     */
    tickPosition: "outside",
    /**
     * A callback function returning array defining where the ticks are
     * laid out on the axis. This overrides the default behaviour of
     * [tickPixelInterval](#xAxis.tickPixelInterval) and [tickInterval](
     * #xAxis.tickInterval). The automatic tick positions are accessible
     * through `this.tickPositions` and can be modified by the callback.
     *
     * @see [tickPositions](#xAxis.tickPositions)
     *
     * @sample {highcharts} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     * @sample {highstock} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     *
     * @type      {Highcharts.AxisTickPositionerCallbackFunction}
     * @apioption xAxis.tickPositioner
     */
    /**
     * An array defining where the ticks are laid out on the axis. This
     * overrides the default behaviour of [tickPixelInterval](
     * #xAxis.tickPixelInterval) and [tickInterval](#xAxis.tickInterval).
     *
     * @see [tickPositioner](#xAxis.tickPositioner)
     *
     * @sample {highcharts} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     * @sample {highstock} highcharts/xaxis/tickpositions-tickpositioner/
     *         Demo of tickPositions and tickPositioner
     *
     * @type      {Array<number>}
     * @apioption xAxis.tickPositions
     */
    /**
     * The pixel width of the major tick marks. Defaults to 0 on category
     * axes, otherwise 1.
     *
     * In styled mode, the stroke width is given in the `.highcharts-tick`
     * class, but in order for the element to be generated on category axes,
     * the option must be explicitly set to 1.
     *
     * @sample {highcharts} highcharts/xaxis/tickwidth/
     *         10 px width
     * @sample {highcharts} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     * @sample {highstock} highcharts/css/axis-grid/
     *         Styled mode
     *
     * @type      {undefined|number}
     * @default   {highstock} 1
     * @default   {highmaps} 0
     * @apioption xAxis.tickWidth
     */
    /**
     * The axis title, showing next to the axis line.
     *
     * @productdesc {highmaps}
     * In Highmaps, the axis is hidden by default, but adding an axis title
     * is still possible. X axis and Y axis titles will appear at the bottom
     * and left by default.
     */
    title: {
      /**
       * Alignment of the title relative to the axis values. Possible
       * values are "low", "middle" or "high".
       *
       * @sample {highcharts} highcharts/xaxis/title-align-low/
       *         "low"
       * @sample {highcharts} highcharts/xaxis/title-align-center/
       *         "middle" by default
       * @sample {highcharts} highcharts/xaxis/title-align-high/
       *         "high"
       * @sample {highcharts} highcharts/yaxis/title-offset/
       *         Place the Y axis title on top of the axis
       * @sample {highstock} stock/xaxis/title-align/
       *         Aligned to "high" value
       *
       * @type {Highcharts.AxisTitleAlignValue}
       */
      align: "middle",
      /**
       * Deprecated. Set the `text` to `undefined` to disable the title.
       *
       * @deprecated
       * @type      {boolean}
       * @product   highcharts
       * @apioption xAxis.title.enabled
       */
      /**
       * The pixel distance between the axis labels or line and the title.
       * Defaults to 0 for horizontal axes, 10 for vertical
       *
       * @sample {highcharts} highcharts/xaxis/title-margin/
       *         Y axis title margin of 60
       *
       * @type      {number}
       * @apioption xAxis.title.margin
       */
      /**
       * The distance of the axis title from the axis line. By default,
       * this distance is computed from the offset width of the labels,
       * the labels' distance from the axis and the title's margin.
       * However when the offset option is set, it overrides all this.
       *
       * @sample {highcharts} highcharts/yaxis/title-offset/
       *         Place the axis title on top of the axis
       * @sample {highstock} highcharts/yaxis/title-offset/
       *         Place the axis title on top of the Y axis
       *
       * @type      {number}
       * @since     2.2.0
       * @apioption xAxis.title.offset
       */
      /**
       * Whether to reserve space for the title when laying out the axis.
       *
       * @type      {boolean}
       * @default   true
       * @since     5.0.11
       * @product   highcharts highstock gantt
       * @apioption xAxis.title.reserveSpace
       */
      /**
       * The rotation of the text in degrees. 0 is horizontal, 270 is
       * vertical reading from bottom to top.
       *
       * @sample {highcharts} highcharts/yaxis/title-offset/
       *         Horizontal
       */
      rotation: 0,
      /**
       * The actual text of the axis title. It can contain basic HTML tags
       * like `b`, `i` and `span` with style.
       *
       * @sample {highcharts} highcharts/xaxis/title-text/
       *         Custom HTML
       * @sample {highstock} stock/xaxis/title-text/
       *         Titles for both axes
       *
       * @type      {string|null}
       * @apioption xAxis.title.text
       */
      /**
       * Alignment of the text, can be `"left"`, `"right"` or `"center"`.
       * Default alignment depends on the
       * [title.align](xAxis.title.align):
       *
       * Horizontal axes:
       * - for `align` = `"low"`, `textAlign` is set to `left`
       * - for `align` = `"middle"`, `textAlign` is set to `center`
       * - for `align` = `"high"`, `textAlign` is set to `right`
       *
       * Vertical axes:
       * - for `align` = `"low"` and `opposite` = `true`, `textAlign` is
       *   set to `right`
       * - for `align` = `"low"` and `opposite` = `false`, `textAlign` is
       *   set to `left`
       * - for `align` = `"middle"`, `textAlign` is set to `center`
       * - for `align` = `"high"` and `opposite` = `true` `textAlign` is
       *   set to `left`
       * - for `align` = `"high"` and `opposite` = `false` `textAlign` is
       *   set to `right`
       *
       * @type      {Highcharts.AlignValue}
       * @apioption xAxis.title.textAlign
       */
      /**
       * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
       * to render the axis title.
       *
       * @product   highcharts highstock gantt
       */
      useHTML: false,
      /**
       * Horizontal pixel offset of the title position.
       *
       * @since     4.1.6
       * @product   highcharts highstock gantt
       */
      x: 0,
      /**
       * Vertical pixel offset of the title position.
       *
       * @product   highcharts highstock gantt
       */
      y: 0,
      /**
       * CSS styles for the title. If the title text is longer than the
       * axis length, it will wrap to multiple lines by default. This can
       * be customized by setting `textOverflow: 'ellipsis'`, by
       * setting a specific `width` or by setting `whiteSpace: 'nowrap'`.
       *
       * In styled mode, the stroke width is given in the
       * `.highcharts-axis-title` class.
       *
       * @sample {highcharts} highcharts/xaxis/title-style/
       *         Red
       * @sample {highcharts} highcharts/css/axis/
       *         Styled mode
       *
       * @type    {Highcharts.CSSObject}
       */
      style: {
        /** @internal */
        color: palette.neutralColor60
      }
    },
    /**
     * The type of axis. Can be one of `linear`, `logarithmic`, `datetime`
     * or `category`. In a datetime axis, the numbers are given in
     * milliseconds, and tick marks are placed on appropriate values like
     * full hours or days. In a category axis, the
     * [point names](#series.line.data.name) of the chart's series are used
     * for categories, if not a [categories](#xAxis.categories) array is
     * defined.
     *
     * @sample {highcharts} highcharts/xaxis/type-linear/
     *         Linear
     * @sample {highcharts} highcharts/yaxis/type-log/
     *         Logarithmic
     * @sample {highcharts} highcharts/yaxis/type-log-minorgrid/
     *         Logarithmic with minor grid lines
     * @sample {highcharts} highcharts/xaxis/type-log-both/
     *         Logarithmic on two axes
     * @sample {highcharts} highcharts/yaxis/type-log-negative/
     *         Logarithmic with extension to emulate negative values
     *
     * @type    {Highcharts.AxisTypeValue}
     * @product highcharts gantt
     */
    type: "linear",
    /**
     * If there are multiple axes on the same side of the chart, the pixel
     * margin between the axes. Defaults to 0 on vertical axes, 15 on
     * horizontal axes.
     *
     * @type      {number}
     * @since     7.0.3
     * @apioption xAxis.margin
     */
    /**
     * Applies only when the axis `type` is `category`. When `uniqueNames`
     * is true, points are placed on the X axis according to their names.
     * If the same point name is repeated in the same or another series,
     * the point is placed on the same X position as other points of the
     * same name. When `uniqueNames` is false, the points are laid out in
     * increasing X positions regardless of their names, and the X axis
     * category will take the name of the last point in each position.
     *
     * @sample {highcharts} highcharts/xaxis/uniquenames-true/
     *         True by default
     * @sample {highcharts} highcharts/xaxis/uniquenames-false/
     *         False
     *
     * @since     4.2.7
     * @product   highcharts gantt
     */
    uniqueNames: true,
    /**
     * Datetime axis only. An array determining what time intervals the
     * ticks are allowed to fall on. Each array item is an array where the
     * first value is the time unit and the second value another array of
     * allowed multiples.
     *
     * Defaults to:
     * ```js
     * units: [[
     *     'millisecond', // unit name
     *     [1, 2, 5, 10, 20, 25, 50, 100, 200, 500] // allowed multiples
     * ], [
     *     'second',
     *     [1, 2, 5, 10, 15, 30]
     * ], [
     *     'minute',
     *     [1, 2, 5, 10, 15, 30]
     * ], [
     *     'hour',
     *     [1, 2, 3, 4, 6, 8, 12]
     * ], [
     *     'day',
     *     [1, 2]
     * ], [
     *     'week',
     *     [1, 2]
     * ], [
     *     'month',
     *     [1, 2, 3, 4, 6]
     * ], [
     *     'year',
     *     null
     * ]]
     * ```
     *
     * @type      {Array<Array<string,(Array<number>|null)>>}
     * @product   highcharts highstock gantt
     * @apioption xAxis.units
     */
    /**
     * Whether axis, including axis title, line, ticks and labels, should
     * be visible.
     *
     * @since     4.1.9
     * @product   highcharts highstock gantt
     */
    visible: true,
    /**
     * Color of the minor, secondary grid lines.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-minor-grid-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/minorgridlinecolor/
     *         Bright grey lines from Y axis
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/minorgridlinecolor/
     *         Bright grey lines from Y axis
     *
     * @type    {Highcharts.ColorType}
     * @default #f2f2f2
     */
    minorGridLineColor: palette.neutralColor5,
    /**
     * Width of the minor, secondary grid lines.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-grid-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/minorgridlinewidth/
     *         2px lines from Y axis
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/minorgridlinewidth/
     *         2px lines from Y axis
     */
    minorGridLineWidth: 1,
    /**
     * Color for the minor tick marks.
     *
     * @sample {highcharts} highcharts/yaxis/minortickcolor/
     *         Black tick marks on Y axis
     * @sample {highstock} stock/xaxis/minorticks/
     *         Black tick marks on Y axis
     *
     * @type    {Highcharts.ColorType}
     * @default #999999
     */
    minorTickColor: palette.neutralColor40,
    /**
     * The color of the line marking the axis itself.
     *
     * In styled mode, the line stroke is given in the
     * `.highcharts-axis-line` or `.highcharts-xaxis-line` class.
     *
     * @productdesc {highmaps}
     * In Highmaps, the axis line is hidden by default, because the axis is
     * not visible by default.
     *
     * @sample {highcharts} highcharts/yaxis/linecolor/
     *         A red line on Y axis
     * @sample {highcharts|highstock} highcharts/css/axis/
     *         Axes in styled mode
     * @sample {highstock} stock/xaxis/linecolor/
     *         A red line on X axis
     *
     * @type    {Highcharts.ColorType}
     * @default #ccd6eb
     */
    lineColor: palette.highlightColor20,
    /**
     * The width of the line marking the axis itself.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-axis-line` or `.highcharts-xaxis-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/linecolor/
     *         A 1px line on Y axis
     * @sample {highcharts|highstock} highcharts/css/axis/
     *         Axes in styled mode
     * @sample {highstock} stock/xaxis/linewidth/
     *         A 2px line on X axis
     *
     * @default {highcharts|highstock} 1
     * @default {highmaps} 0
     */
    lineWidth: 1,
    /**
     * Color of the grid lines extending the ticks across the plot area.
     *
     * In styled mode, the stroke is given in the `.highcharts-grid-line`
     * class.
     *
     * @productdesc {highmaps}
     * In Highmaps, the grid lines are hidden by default.
     *
     * @sample {highcharts} highcharts/yaxis/gridlinecolor/
     *         Green lines
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/gridlinecolor/
     *         Green lines
     *
     * @type    {Highcharts.ColorType}
     * @default #e6e6e6
     */
    gridLineColor: palette.neutralColor10,
    /**
     * The width of the grid lines extending the ticks across the plot area.
     * Defaults to 1 on the Y axis and 0 on the X axis, except for 3d
     * charts.
     *
     * In styled mode, the stroke width is given in the
     * `.highcharts-grid-line` class.
     *
     * @sample {highcharts} highcharts/yaxis/gridlinewidth/
     *         2px lines
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/gridlinewidth/
     *         2px lines
     *
     * @type      {number}
     * @apioption xAxis.gridLineWidth
     */
    gridLineWidth: void 0,
    /**
     * The height as the vertical axis. If it's a number, it is
     * interpreted as pixels.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted
     * as percentages of the total plot height.
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.height
     */
    /**
     * The width as the horizontal axis. If it's a number, it is interpreted
     * as pixels.
     *
     * Since Highcharts v5.0.13: If it's a percentage string, it is
     * interpreted as percentages of the total plot width.
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption xAxis.width
     */
    /**
     * Color for the main tick marks.
     *
     * In styled mode, the stroke is given in the `.highcharts-tick`
     * class.
     *
     * @sample {highcharts} highcharts/xaxis/tickcolor/
     *         Red ticks on X axis
     * @sample {highcharts|highstock} highcharts/css/axis-grid/
     *         Styled mode
     * @sample {highstock} stock/xaxis/ticks/
     *         Formatted ticks on X axis
     *
     * @type    {Highcharts.ColorType}
     * @default #ccd6eb
     */
    tickColor: palette.highlightColor20
    // tickWidth: 1
  };
  AxisDefaults2.defaultYAxisOptions = {
    /**
     * The type of axis. Can be one of `linear`, `logarithmic`, `datetime`,
     * `category` or `treegrid`. Defaults to `treegrid` for Gantt charts,
     * `linear` for other chart types.
     *
     * In a datetime axis, the numbers are given in milliseconds, and tick
     * marks are placed on appropriate values, like full hours or days. In a
     * category or treegrid axis, the [point names](#series.line.data.name)
     * of the chart's series are used for categories, if a
     * [categories](#xAxis.categories) array is not defined.
     *
     * @sample {highcharts} highcharts/yaxis/type-log-minorgrid/
     *         Logarithmic with minor grid lines
     * @sample {highcharts} highcharts/yaxis/type-log-negative/
     *         Logarithmic with extension to emulate negative values
     * @sample {gantt} gantt/treegrid-axis/demo
     *         Treegrid axis
     *
     * @type      {Highcharts.AxisTypeValue}
     * @default   {highcharts} linear
     * @default   {gantt} treegrid
     * @product   highcharts gantt
     * @apioption yAxis.type
     */
    /**
     * The height of the Y axis. If it's a number, it is interpreted as
     * pixels.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted as
     * percentages of the total plot height.
     *
     * @see [yAxis.top](#yAxis.top)
     *
     * @sample {highstock} stock/demo/candlestick-and-volume/
     *         Percentage height panes
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption yAxis.height
     */
    /**
     * Solid gauge only. Unless [stops](#yAxis.stops) are set, the color
     * to represent the maximum value of the Y axis.
     *
     * @sample {highcharts} highcharts/yaxis/mincolor-maxcolor/
     *         Min and max colors
     *
     * @type      {Highcharts.ColorType}
     * @default   #003399
     * @since     4.0
     * @product   highcharts
     * @apioption yAxis.maxColor
     */
    /**
     * Solid gauge only. Unless [stops](#yAxis.stops) are set, the color
     * to represent the minimum value of the Y axis.
     *
     * @sample {highcharts} highcharts/yaxis/mincolor-maxcolor/
     *         Min and max color
     *
     * @type      {Highcharts.ColorType}
     * @default   #e6ebf5
     * @since     4.0
     * @product   highcharts
     * @apioption yAxis.minColor
     */
    /**
     * Whether to reverse the axis so that the highest number is closest
     * to the origin.
     *
     * @sample {highcharts} highcharts/yaxis/reversed/
     *         Reversed Y axis
     * @sample {highstock} stock/xaxis/reversed/
     *         Reversed Y axis
     *
     * @type      {boolean}
     * @default   {highcharts} false
     * @default   {highstock} false
     * @default   {highmaps} true
     * @default   {gantt} true
     * @apioption yAxis.reversed
     */
    /**
     * If `true`, the first series in a stack will be drawn on top in a
     * positive, non-reversed Y axis. If `false`, the first series is in
     * the base of the stack.
     *
     * @sample {highcharts} highcharts/yaxis/reversedstacks-false/
     *         Non-reversed stacks
     * @sample {highstock} highcharts/yaxis/reversedstacks-false/
     *         Non-reversed stacks
     *
     * @type      {boolean}
     * @default   true
     * @since     3.0.10
     * @product   highcharts highstock
     * @apioption yAxis.reversedStacks
     */
    reversedStacks: true,
    /**
     * Solid gauge series only. Color stops for the solid gauge. Use this
     * in cases where a linear gradient between a `minColor` and `maxColor`
     * is not sufficient. The stops is an array of tuples, where the first
     * item is a float between 0 and 1 assigning the relative position in
     * the gradient, and the second item is the color.
     *
     * For solid gauges, the Y axis also inherits the concept of
     * [data classes](https://api.highcharts.com/highmaps#colorAxis.dataClasses)
     * from the Highmaps color axis.
     *
     * @see [minColor](#yAxis.minColor)
     * @see [maxColor](#yAxis.maxColor)
     *
     * @sample {highcharts} highcharts/demo/gauge-solid/
     *         True by default
     *
     * @type      {Array<Array<number,Highcharts.ColorType>>}
     * @since     4.0
     * @product   highcharts
     * @apioption yAxis.stops
     */
    /**
     * The pixel width of the major tick marks.
     *
     * @sample {highcharts} highcharts/xaxis/tickwidth/ 10 px width
     * @sample {highstock} stock/xaxis/ticks/ Formatted ticks on X axis
     *
     * @type      {number}
     * @default   0
     * @product   highcharts highstock gantt
     * @apioption yAxis.tickWidth
     */
    /**
     * Whether to force the axis to end on a tick. Use this option with
     * the `maxPadding` option to control the axis end.
     *
     * This option is always disabled, when panning type is
     * either `y` or `xy`.
     *
     * @see [type](#chart.panning.type)
     *
     *
     * @sample {highcharts} highcharts/chart/reflow-true/
     *         True by default
     * @sample {highcharts} highcharts/yaxis/endontick/
     *         False
     * @sample {highstock} stock/demo/basic-line/
     *         True by default
     * @sample {highstock} stock/xaxis/endontick/
     *         False for Y axis
     *
     * @since 1.2.0
     */
    endOnTick: true,
    /**
     * Padding of the max value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the highest data value to appear on the edge
     * of the plot area. When the axis' `max` option is set or a max extreme
     * is set using `axis.setExtremes()`, the maxPadding will be ignored.
     *
     * Also the `softThreshold` option takes precedence over `maxPadding`,
     * so if the data is tangent to the threshold, `maxPadding` may not
     * apply unless `softThreshold` is set to false.
     *
     * @sample {highcharts} highcharts/yaxis/maxpadding-02/
     *         Max padding of 0.2
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     *
     * @since   1.2.0
     * @product highcharts highstock gantt
     */
    maxPadding: 0.05,
    /**
     * Padding of the min value relative to the length of the axis. A
     * padding of 0.05 will make a 100px axis 5px longer. This is useful
     * when you don't want the lowest data value to appear on the edge
     * of the plot area. When the axis' `min` option is set or a max extreme
     * is set using `axis.setExtremes()`, the maxPadding will be ignored.
     *
     * Also the `softThreshold` option takes precedence over `minPadding`,
     * so if the data is tangent to the threshold, `minPadding` may not
     * apply unless `softThreshold` is set to false.
     *
     * @sample {highcharts} highcharts/yaxis/minpadding/
     *         Min padding of 0.2
     * @sample {highstock} stock/xaxis/minpadding-maxpadding/
     *         Greater min- and maxPadding
     *
     * @since   1.2.0
     * @product highcharts highstock gantt
     */
    minPadding: 0.05,
    /**
     * @productdesc {highstock}
     * In Highcharts Stock 1.x, the Y axis was placed
     * on the left side by default.
     *
     * @sample {highcharts} highcharts/yaxis/opposite/
     *         Secondary Y axis opposite
     * @sample {highstock} stock/xaxis/opposite/
     *         Y axis on left side
     *
     * @type      {boolean}
     * @default   {highstock} true
     * @default   {highcharts} false
     * @product   highstock highcharts gantt
     * @apioption yAxis.opposite
     */
    /**
     * @see [tickInterval](#xAxis.tickInterval)
     * @see [tickPositioner](#xAxis.tickPositioner)
     * @see [tickPositions](#xAxis.tickPositions)
     */
    tickPixelInterval: 72,
    showLastLabel: true,
    /**
     * @extends xAxis.labels
     */
    labels: {
      /**
       * Angular gauges and solid gauges only.
       * The label's pixel distance from the perimeter of the plot area.
       *
       * Since v7.1.2: If it's a percentage string, it is interpreted the
       * same as [series.radius](#plotOptions.gauge.radius), so label can be
       * aligned under the gauge's shape.
       *
       * @sample {highcharts} highcharts/yaxis/labels-distance/
       *         Labels centered under the arc
       *
       * @type      {number|string}
       * @default   -25
       * @product   highcharts
       * @apioption yAxis.labels.distance
       */
      /**
       * The y position offset of all labels relative to the tick
       * positions on the axis. For polar and radial axis consider the use
       * of the [distance](#yAxis.labels.distance) option.
       *
       * @sample {highcharts} highcharts/xaxis/labels-x/
       *         Y axis labels placed on grid lines
       *
       * @type      {number}
       * @default   {highcharts} 3
       * @default   {highstock} -2
       * @default   {highmaps} 3
       * @apioption yAxis.labels.y
       */
      /**
       * What part of the string the given position is anchored to. Can
       * be one of `"left"`, `"center"` or `"right"`. The exact position
       * also depends on the `labels.x` setting.
       *
       * Angular gauges and solid gauges defaults to `"center"`.
       * Solid gauges with two labels have additional option `"auto"`
       * for automatic horizontal and vertical alignment.
       *
       * @see [yAxis.labels.distance](#yAxis.labels.distance)
       *
       * @sample {highcharts} highcharts/yaxis/labels-align-left/
       *         Left
       * @sample {highcharts} highcharts/series-solidgauge/labels-auto-aligned/
       *         Solid gauge labels auto aligned
       *
       * @type       {Highcharts.AlignValue}
       * @default    {highcharts|highmaps} right
       * @default    {highstock} left
       * @apioption  yAxis.labels.align
       */
      /**
       * The x position offset of all labels relative to the tick
       * positions on the axis. Defaults to -15 for left axis, 15 for
       * right axis.
       *
       * @sample {highcharts} highcharts/xaxis/labels-x/
       *         Y axis labels placed on grid lines
       */
      x: -8
    },
    /**
     * @productdesc {highmaps}
     * In Highmaps, the axis line is hidden by default, because the axis is
     * not visible by default.
     *
     * @type      {Highcharts.ColorType}
     * @apioption yAxis.lineColor
     */
    /**
     * @sample {highcharts} highcharts/yaxis/max-200/
     *         Y axis max of 200
     * @sample {highcharts} highcharts/yaxis/max-logarithmic/
     *         Y axis max on logarithmic axis
     * @sample {highstock} stock/yaxis/min-max/
     *         Fixed min and max on Y axis
     * @sample {highmaps} maps/axis/min-max/
     *         Pre-zoomed to a specific area
     *
     * @apioption yAxis.max
     */
    /**
     * @sample {highcharts} highcharts/yaxis/min-startontick-false/
     *         -50 with startOnTick to false
     * @sample {highcharts} highcharts/yaxis/min-startontick-true/
     *         -50 with startOnTick true by default
     * @sample {highstock} stock/yaxis/min-max/
     *         Fixed min and max on Y axis
     * @sample {highmaps} maps/axis/min-max/
     *         Pre-zoomed to a specific area
     *
     * @apioption yAxis.min
     */
    /**
     * An optional scrollbar to display on the Y axis in response to
     * limiting the minimum an maximum of the axis values.
     *
     * In styled mode, all the presentational options for the scrollbar
     * are replaced by the classes `.highcharts-scrollbar-thumb`,
     * `.highcharts-scrollbar-arrow`, `.highcharts-scrollbar-button`,
     * `.highcharts-scrollbar-rifles` and `.highcharts-scrollbar-track`.
     *
     * @sample {highstock} stock/yaxis/scrollbar/
     *         Scrollbar on the Y axis
     *
     * @extends   scrollbar
     * @since     4.2.6
     * @product   highstock
     * @excluding height
     * @apioption yAxis.scrollbar
     */
    /**
     * Enable the scrollbar on the Y axis.
     *
     * @sample {highstock} stock/yaxis/scrollbar/
     *         Enabled on Y axis
     *
     * @type      {boolean}
     * @default   false
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.enabled
     */
    /**
     * Pixel margin between the scrollbar and the axis elements.
     *
     * @type      {number}
     * @default   10
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.margin
     */
    /**
     * Whether to show the scrollbar when it is fully zoomed out at max
     * range. Setting it to `false` on the Y axis makes the scrollbar stay
     * hidden until the user zooms in, like common in browsers.
     *
     * @type      {boolean}
     * @default   true
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.showFull
     */
    /**
     * The width of a vertical scrollbar or height of a horizontal
     * scrollbar. Defaults to 20 on touch devices.
     *
     * @type      {number}
     * @default   14
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.size
     */
    /**
     * Z index of the scrollbar elements.
     *
     * @type      {number}
     * @default   3
     * @since     4.2.6
     * @product   highstock
     * @apioption yAxis.scrollbar.zIndex
     */
    /**
     * A soft maximum for the axis. If the series data maximum is less
     * than this, the axis will stay at this maximum, but if the series
     * data maximum is higher, the axis will flex to show all data.
     *
     * **Note**: The [series.softThreshold](
     * #plotOptions.series.softThreshold) option takes precedence over this
     * option.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption yAxis.softMax
     */
    /**
     * A soft minimum for the axis. If the series data minimum is greater
     * than this, the axis will stay at this minimum, but if the series
     * data minimum is lower, the axis will flex to show all data.
     *
     * **Note**: The [series.softThreshold](
     * #plotOptions.series.softThreshold) option takes precedence over this
     * option.
     *
     * @sample highcharts/yaxis/softmin-softmax/
     *         Soft min and max
     *
     * @type      {number}
     * @since     5.0.1
     * @product   highcharts highstock gantt
     * @apioption yAxis.softMin
     */
    /**
     * Defines the horizontal alignment of the stack total label. Can be one
     * of `"left"`, `"center"` or `"right"`. The default value is calculated
     * at runtime and depends on orientation and whether the stack is
     * positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-align-left/
     *         Aligned to the left
     * @sample {highcharts} highcharts/yaxis/stacklabels-align-center/
     *         Aligned in center
     * @sample {highcharts} highcharts/yaxis/stacklabels-align-right/
     *         Aligned to the right
     *
     * @type      {Highcharts.AlignValue}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.align
     */
    /**
     * A format string for the data label. Available variables are the same
     * as for `formatter`.
     *
     * @type      {string}
     * @default   {total}
     * @since     3.0.2
     * @product   highcharts highstock
     * @apioption yAxis.stackLabels.format
     */
    /**
     * Rotation of the labels in degrees.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-rotation/
     *         Labels rotated 45°
     *
     * @type      {number}
     * @default   0
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.rotation
     */
    /**
     * The text alignment for the label. While `align` determines where the
     * texts anchor point is placed with regards to the stack, `textAlign`
     * determines how the text is aligned against its anchor point. Possible
     * values are `"left"`, `"center"` and `"right"`. The default value is
     * calculated at runtime and depends on orientation and whether the
     * stack is positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-textalign-left/
     *         Label in center position but text-aligned left
     *
     * @type      {Highcharts.AlignValue}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.textAlign
     */
    /**
     * Whether to [use HTML](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#html)
     * to render the labels.
     *
     * @type      {boolean}
     * @default   false
     * @since     3.0
     * @product   highcharts highstock
     * @apioption yAxis.stackLabels.useHTML
     */
    /**
     * Defines the vertical alignment of the stack total label. Can be one
     * of `"top"`, `"middle"` or `"bottom"`. The default value is calculated
     * at runtime and depends on orientation and whether the stack is
     * positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-top/
     *         Vertically aligned top
     * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-middle/
     *         Vertically aligned middle
     * @sample {highcharts} highcharts/yaxis/stacklabels-verticalalign-bottom/
     *         Vertically aligned bottom
     *
     * @type      {Highcharts.VerticalAlignValue}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.verticalAlign
     */
    /**
     * The x position offset of the label relative to the left of the
     * stacked bar. The default value is calculated at runtime and depends
     * on orientation and whether the stack is positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-x/
     *         Stack total labels with x offset
     *
     * @type      {number}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.x
     */
    /**
     * The y position offset of the label relative to the tick position
     * on the axis. The default value is calculated at runtime and depends
     * on orientation and whether the stack is positive or negative.
     *
     * @sample {highcharts} highcharts/yaxis/stacklabels-y/
     *         Stack total labels with y offset
     *
     * @type      {number}
     * @since     2.1.5
     * @product   highcharts
     * @apioption yAxis.stackLabels.y
     */
    /**
     * Whether to force the axis to start on a tick. Use this option with
     * the `maxPadding` option to control the axis start.
     *
     * This option is always disabled, when panning type is
     * either `y` or `xy`.
     *
     * @see [type](#chart.panning.type)
     *
     * @sample {highcharts} highcharts/xaxis/startontick-false/
     *         False by default
     * @sample {highcharts} highcharts/xaxis/startontick-true/
     *         True
     * @sample {highstock} stock/xaxis/endontick/
     *         False for Y axis
     *
     * @since   1.2.0
     * @product highcharts highstock gantt
     */
    startOnTick: true,
    title: {
      /**
       * The pixel distance between the axis labels and the title.
       * Positive values are outside the axis line, negative are inside.
       *
       * @sample {highcharts} highcharts/xaxis/title-margin/
       *         Y axis title margin of 60
       *
       * @type      {number}
       * @default   40
       * @apioption yAxis.title.margin
       */
      /**
       * The rotation of the text in degrees. 0 is horizontal, 270 is
       * vertical reading from bottom to top.
       *
       * @sample {highcharts} highcharts/yaxis/title-offset/
       *         Horizontal
       */
      rotation: 270,
      /**
       * The actual text of the axis title. Horizontal texts can contain
       * HTML, but rotated texts are painted using vector techniques and
       * must be clean text. The Y axis title is disabled by setting the
       * `text` option to `undefined`.
       *
       * @sample {highcharts} highcharts/xaxis/title-text/
       *         Custom HTML
       *
       * @type    {string|null}
       * @default {highcharts} Values
       * @default {highstock} undefined
       * @product highcharts highstock gantt
       */
      text: "Values"
    },
    /**
     * The top position of the Y axis. If it's a number, it is interpreted
     * as pixel position relative to the chart.
     *
     * Since Highcharts 2: If it's a percentage string, it is interpreted as
     * percentages of the plot height, offset from plot area top.
     *
     * @see [yAxis.height](#yAxis.height)
     *
     * @sample {highstock} stock/demo/candlestick-and-volume/
     *         Percentage height panes
     *
     * @type      {number|string}
     * @product   highcharts highstock
     * @apioption yAxis.top
     */
    /**
     * The stack labels show the total value for each bar in a stacked
     * column or bar chart. The label will be placed on top of positive
     * columns and below negative columns. In case of an inverted column
     * chart or a bar chart the label is placed to the right of positive
     * bars and to the left of negative bars.
     *
     * @product highcharts
     */
    stackLabels: {
      /**
       * Enable or disable the initial animation when a series is
       * displayed for the `stackLabels`. The animation can also be set as
       * a configuration object. Please note that this option only
       * applies to the initial animation.
       * For other animations, see [chart.animation](#chart.animation)
       * and the animation parameter under the API methods.
       * The following properties are supported:
       *
       * - `defer`: The animation delay time in milliseconds.
       *
       * @sample {highcharts} highcharts/plotoptions/animation-defer/
       *          Animation defer settings
       * @type {boolean|Partial<Highcharts.AnimationOptionsObject>}
       * @since 8.2.0
       * @apioption yAxis.stackLabels.animation
       */
      animation: {},
      /**
       * The animation delay time in milliseconds.
       * Set to `0` renders stackLabel immediately.
       * As `undefined` inherits defer time from the [series.animation.defer](#plotOptions.series.animation.defer).
       *
       * @type      {number}
       * @since 8.2.0
       * @apioption yAxis.stackLabels.animation.defer
       */
      /**
       * Allow the stack labels to overlap.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-allowoverlap-false/
       *         Default false
       *
       * @since   5.0.13
       * @product highcharts
       */
      allowOverlap: false,
      /**
       * The background color or gradient for the stack label.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {Highcharts.ColorType}
       * @since 8.1.0
       * @apioption yAxis.stackLabels.backgroundColor
       */
      /**
       * The border color for the stack label. Defaults to `undefined`.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {Highcharts.ColorType}
       * @since 8.1.0
       * @apioption yAxis.stackLabels.borderColor
       */
      /**
       * The border radius in pixels for the stack label.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {number}
       * @default   0
       * @since 8.1.0
       * @apioption yAxis.stackLabels.borderRadius
       */
      /**
       * The border width in pixels for the stack label.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-box/
       *          Stack labels box options
       * @type      {number}
       * @default   0
       * @since 8.1.0
       * @apioption yAxis.stackLabels.borderWidth
       */
      /**
       * Enable or disable the stack total labels.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-enabled/
       *         Enabled stack total labels
       * @sample {highcharts} highcharts/yaxis/stacklabels-enabled-waterfall/
       *         Enabled stack labels in waterfall chart
       *
       * @since   2.1.5
       * @product highcharts
       */
      enabled: false,
      /**
       * Whether to hide stack labels that are outside the plot area.
       * By default, the stack label is moved
       * inside the plot area according to the
       * [overflow](/highcharts/#yAxis/stackLabels/overflow)
       * option.
       *
       * @type  {boolean}
       * @since 7.1.3
       */
      crop: true,
      /**
       * How to handle stack total labels that flow outside the plot area.
       * The default is set to `"justify"`,
       * which aligns them inside the plot area.
       * For columns and bars, this means it will be moved inside the bar.
       * To display stack labels outside the plot area,
       * set `crop` to `false` and `overflow` to `"allow"`.
       *
       * @sample highcharts/yaxis/stacklabels-overflow/
       *         Stack labels flows outside the plot area.
       *
       * @type  {Highcharts.DataLabelsOverflowValue}
       * @since 7.1.3
       */
      overflow: "justify",
      /* eslint-disable valid-jsdoc */
      /**
       * Callback JavaScript function to format the label. The value is
       * given by `this.total`.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-formatter/
       *         Added units to stack total value
       *
       * @type    {Highcharts.FormatterCallbackFunction<Highcharts.StackItemObject>}
       * @since   2.1.5
       * @product highcharts
       */
      formatter: function() {
        var numberFormatter = this.axis.chart.numberFormatter;
        return numberFormatter(this.total, -1);
      },
      /**
       * CSS styles for the label.
       *
       * In styled mode, the styles are set in the
       * `.highcharts-stack-label` class.
       *
       * @sample {highcharts} highcharts/yaxis/stacklabels-style/
       *         Red stack total labels
       *
       * @type    {Highcharts.CSSObject}
       * @since   2.1.5
       * @product highcharts
       */
      style: {
        /** @internal */
        color: palette.neutralColor100,
        /** @internal */
        fontSize: "11px",
        /** @internal */
        fontWeight: "bold",
        /** @internal */
        textOutline: "1px contrast"
      }
    },
    gridLineWidth: 1,
    lineWidth: 0
    // tickWidth: 0
  };
  AxisDefaults2.defaultLeftAxisOptions = {
    labels: {
      x: -15
    },
    title: {
      rotation: 270
    }
  };
  AxisDefaults2.defaultRightAxisOptions = {
    labels: {
      x: 15
    },
    title: {
      rotation: 90
    }
  };
  AxisDefaults2.defaultBottomAxisOptions = {
    labels: {
      autoRotation: [-45],
      x: 0
      // overflow: undefined,
      // staggerLines: null
    },
    margin: 15,
    title: {
      rotation: 0
    }
  };
  AxisDefaults2.defaultTopAxisOptions = {
    labels: {
      autoRotation: [-45],
      x: 0
      // overflow: undefined
      // staggerLines: null
    },
    margin: 15,
    title: {
      rotation: 0
    }
  };
})(AxisDefaults || (AxisDefaults = {}));
const AxisDefaults$1 = AxisDefaults;
var addEvent$16 = Utilities.addEvent, isFunction$3 = Utilities.isFunction, objectEach$w = Utilities.objectEach, removeEvent$a = Utilities.removeEvent;
var registerEventOptions$3 = function(component, options) {
  component.eventOptions = component.eventOptions || {};
  objectEach$w(options.events, function(event, eventType) {
    if (component.eventOptions[eventType] !== event) {
      if (component.eventOptions[eventType]) {
        removeEvent$a(component, eventType, component.eventOptions[eventType]);
        delete component.eventOptions[eventType];
      }
      if (isFunction$3(event)) {
        component.eventOptions[eventType] = event;
        addEvent$16(component, eventType, event);
      }
    }
  });
};
var exports$4 = {
  registerEventOptions: registerEventOptions$3
};
var deg2rad$7 = H.deg2rad;
var clamp$j = Utilities.clamp, correctFloat$c = Utilities.correctFloat, defined$S = Utilities.defined, destroyObjectProperties$8 = Utilities.destroyObjectProperties, extend$1r = Utilities.extend, fireEvent$A = Utilities.fireEvent, isNumber$O = Utilities.isNumber, merge$1p = Utilities.merge, objectEach$v = Utilities.objectEach, pick$1y = Utilities.pick;
var Tick = (
  /** @class */
  (function() {
    function Tick2(axis, pos, type, noLabel, parameters) {
      this.isNew = true;
      this.isNewLabel = true;
      this.axis = axis;
      this.pos = pos;
      this.type = type || "";
      this.parameters = parameters || {};
      this.tickmarkOffset = this.parameters.tickmarkOffset;
      this.options = this.parameters.options;
      fireEvent$A(this, "init");
      if (!type && !noLabel) {
        this.addLabel();
      }
    }
    Tick2.prototype.addLabel = function() {
      var tick = this, axis = tick.axis, options = axis.options, chart = axis.chart, categories = axis.categories, log = axis.logarithmic, names2 = axis.names, pos = tick.pos, labelOptions = pick$1y(tick.options && tick.options.labels, options.labels), tickPositions = axis.tickPositions, isFirst = pos === tickPositions[0], isLast = pos === tickPositions[tickPositions.length - 1], animateLabels = (!labelOptions.step || labelOptions.step === 1) && axis.tickInterval === 1, tickPositionInfo = tickPositions.info;
      var label = tick.label, dateTimeLabelFormat, dateTimeLabelFormats, i2;
      var value = this.parameters.category || (categories ? pick$1y(categories[pos], names2[pos], pos) : pos);
      if (log && isNumber$O(value)) {
        value = correctFloat$c(log.lin2log(value));
      }
      if (axis.dateTime) {
        if (tickPositionInfo) {
          dateTimeLabelFormats = chart.time.resolveDTLFormat(options.dateTimeLabelFormats[!options.grid && tickPositionInfo.higherRanks[pos] || tickPositionInfo.unitName]);
          dateTimeLabelFormat = dateTimeLabelFormats.main;
        } else if (isNumber$O(value)) {
          dateTimeLabelFormat = axis.dateTime.getXDateFormat(value, options.dateTimeLabelFormats || {});
        }
      }
      tick.isFirst = isFirst;
      tick.isLast = isLast;
      var ctx = {
        axis,
        chart,
        dateTimeLabelFormat,
        isFirst,
        isLast,
        pos,
        tick,
        tickPositionInfo,
        value
      };
      fireEvent$A(this, "labelFormat", ctx);
      var labelFormatter = function(ctx2) {
        if (labelOptions.formatter) {
          return labelOptions.formatter.call(ctx2, ctx2);
        }
        if (labelOptions.format) {
          ctx2.text = axis.defaultLabelFormatter.call(ctx2);
          return FormatUtilities.format(labelOptions.format, ctx2, chart);
        }
        return axis.defaultLabelFormatter.call(ctx2, ctx2);
      };
      var str = labelFormatter.call(ctx, ctx);
      var list2 = dateTimeLabelFormats && dateTimeLabelFormats.list;
      if (list2) {
        tick.shortenLabel = function() {
          for (i2 = 0; i2 < list2.length; i2++) {
            extend$1r(ctx, { dateTimeLabelFormat: list2[i2] });
            label.attr({
              text: labelFormatter.call(ctx, ctx)
            });
            if (label.getBBox().width < axis.getSlotWidth(tick) - 2 * labelOptions.padding) {
              return;
            }
          }
          label.attr({
            text: ""
          });
        };
      } else {
        tick.shortenLabel = void 0;
      }
      if (animateLabels && axis._addedPlotLB) {
        tick.moveLabel(str, labelOptions);
      }
      if (!defined$S(label) && !tick.movedLabel) {
        tick.label = label = tick.createLabel({ x: 0, y: 0 }, str, labelOptions);
        tick.rotation = 0;
      } else if (label && label.textStr !== str && !animateLabels) {
        if (label.textWidth && !labelOptions.style.width && !label.styles.width) {
          label.css({ width: null });
        }
        label.attr({ text: str });
        label.textPxLength = label.getBBox().width;
      }
    };
    Tick2.prototype.createLabel = function(xy, str, labelOptions) {
      var axis = this.axis, chart = axis.chart, label = defined$S(str) && labelOptions.enabled ? chart.renderer.text(str, xy.x, xy.y, labelOptions.useHTML).add(axis.labelGroup) : null;
      if (label) {
        if (!chart.styledMode) {
          label.css(merge$1p(labelOptions.style));
        }
        label.textPxLength = label.getBBox().width;
      }
      return label;
    };
    Tick2.prototype.destroy = function() {
      destroyObjectProperties$8(this, this.axis);
    };
    Tick2.prototype.getPosition = function(horiz, tickPos, tickmarkOffset, old) {
      var axis = this.axis, chart = axis.chart, cHeight = old && chart.oldChartHeight || chart.chartHeight, pos = {
        x: horiz ? correctFloat$c(axis.translate(tickPos + tickmarkOffset, null, null, old) + axis.transB) : axis.left + axis.offset + (axis.opposite ? (old && chart.oldChartWidth || chart.chartWidth) - axis.right - axis.left : 0),
        y: horiz ? cHeight - axis.bottom + axis.offset - (axis.opposite ? axis.height : 0) : correctFloat$c(cHeight - axis.translate(tickPos + tickmarkOffset, null, null, old) - axis.transB)
      };
      pos.y = clamp$j(pos.y, -1e5, 1e5);
      fireEvent$A(this, "afterGetPosition", { pos });
      return pos;
    };
    Tick2.prototype.getLabelPosition = function(x, y, label, horiz, labelOptions, tickmarkOffset, index, step) {
      var axis = this.axis, transA = axis.transA, reversed = (
        // #7911
        axis.isLinked && axis.linkedParent ? axis.linkedParent.reversed : axis.reversed
      ), staggerLines = axis.staggerLines, rotCorr = axis.tickRotCorr || { x: 0, y: 0 }, labelOffsetCorrection = !horiz && !axis.reserveSpaceDefault ? -axis.labelOffset * (axis.labelAlign === "center" ? 0.5 : 1) : 0, pos = {};
      var yOffset = labelOptions.y, line;
      if (!defined$S(yOffset)) {
        if (axis.side === 0) {
          yOffset = label.rotation ? -8 : -label.getBBox().height;
        } else if (axis.side === 2) {
          yOffset = rotCorr.y + 8;
        } else {
          yOffset = Math.cos(label.rotation * deg2rad$7) * (rotCorr.y - label.getBBox(false, 0).height / 2);
        }
      }
      x = x + labelOptions.x + labelOffsetCorrection + rotCorr.x - (tickmarkOffset && horiz ? tickmarkOffset * transA * (reversed ? -1 : 1) : 0);
      y = y + yOffset - (tickmarkOffset && !horiz ? tickmarkOffset * transA * (reversed ? 1 : -1) : 0);
      if (staggerLines) {
        line = index / (step || 1) % staggerLines;
        if (axis.opposite) {
          line = staggerLines - line - 1;
        }
        y += line * (axis.labelOffset / staggerLines);
      }
      pos.x = x;
      pos.y = Math.round(y);
      fireEvent$A(this, "afterGetLabelPosition", { pos, tickmarkOffset, index });
      return pos;
    };
    Tick2.prototype.getLabelSize = function() {
      return this.label ? this.label.getBBox()[this.axis.horiz ? "height" : "width"] : 0;
    };
    Tick2.prototype.getMarkPath = function(x, y, tickLength, tickWidth, horiz, renderer) {
      return renderer.crispLine([[
        "M",
        x,
        y
      ], [
        "L",
        x + (horiz ? 0 : -tickLength),
        y + (horiz ? tickLength : 0)
      ]], tickWidth);
    };
    Tick2.prototype.handleOverflow = function(xy) {
      var tick = this, axis = this.axis, labelOptions = axis.options.labels, pxPos = xy.x, chartWidth = axis.chart.chartWidth, spacing = axis.chart.spacing, leftBound = pick$1y(axis.labelLeft, Math.min(axis.pos, spacing[3])), rightBound = pick$1y(axis.labelRight, Math.max(!axis.isRadial ? axis.pos + axis.len : 0, chartWidth - spacing[1])), label = this.label, rotation = this.rotation, factor = {
        left: 0,
        center: 0.5,
        right: 1
      }[axis.labelAlign || label.attr("align")], labelWidth = label.getBBox().width, slotWidth = axis.getSlotWidth(tick), xCorrection = factor, css2 = {};
      var modifiedSlotWidth = slotWidth, goRight = 1, leftPos, rightPos, textWidth;
      if (!rotation && labelOptions.overflow === "justify") {
        leftPos = pxPos - factor * labelWidth;
        rightPos = pxPos + (1 - factor) * labelWidth;
        if (leftPos < leftBound) {
          modifiedSlotWidth = xy.x + modifiedSlotWidth * (1 - factor) - leftBound;
        } else if (rightPos > rightBound) {
          modifiedSlotWidth = rightBound - xy.x + modifiedSlotWidth * factor;
          goRight = -1;
        }
        modifiedSlotWidth = Math.min(slotWidth, modifiedSlotWidth);
        if (modifiedSlotWidth < slotWidth && axis.labelAlign === "center") {
          xy.x += goRight * (slotWidth - modifiedSlotWidth - xCorrection * (slotWidth - Math.min(labelWidth, modifiedSlotWidth)));
        }
        if (labelWidth > modifiedSlotWidth || axis.autoRotation && (label.styles || {}).width) {
          textWidth = modifiedSlotWidth;
        }
      } else if (rotation < 0 && pxPos - factor * labelWidth < leftBound) {
        textWidth = Math.round(pxPos / Math.cos(rotation * deg2rad$7) - leftBound);
      } else if (rotation > 0 && pxPos + factor * labelWidth > rightBound) {
        textWidth = Math.round((chartWidth - pxPos) / Math.cos(rotation * deg2rad$7));
      }
      if (textWidth) {
        if (tick.shortenLabel) {
          tick.shortenLabel();
        } else {
          css2.width = Math.floor(textWidth) + "px";
          if (!(labelOptions.style || {}).textOverflow) {
            css2.textOverflow = "ellipsis";
          }
          label.css(css2);
        }
      }
    };
    Tick2.prototype.moveLabel = function(str, labelOptions) {
      var tick = this, label = tick.label, axis = tick.axis, reversed = axis.reversed;
      var moved = false, labelPos, xPos, yPos;
      if (label && label.textStr === str) {
        tick.movedLabel = label;
        moved = true;
        delete tick.label;
      } else {
        objectEach$v(axis.ticks, function(currentTick) {
          if (!moved && !currentTick.isNew && currentTick !== tick && currentTick.label && currentTick.label.textStr === str) {
            tick.movedLabel = currentTick.label;
            moved = true;
            currentTick.labelPos = tick.movedLabel.xy;
            delete currentTick.label;
          }
        });
      }
      if (!moved && (tick.labelPos || label)) {
        labelPos = tick.labelPos || label.xy;
        xPos = axis.horiz ? reversed ? 0 : axis.width + axis.left : labelPos.x;
        yPos = axis.horiz ? labelPos.y : reversed ? axis.width + axis.left : 0;
        tick.movedLabel = tick.createLabel({ x: xPos, y: yPos }, str, labelOptions);
        if (tick.movedLabel) {
          tick.movedLabel.attr({ opacity: 0 });
        }
      }
    };
    Tick2.prototype.render = function(index, old, opacity) {
      var tick = this, axis = tick.axis, horiz = axis.horiz, pos = tick.pos, tickmarkOffset = pick$1y(tick.tickmarkOffset, axis.tickmarkOffset), xy = tick.getPosition(horiz, pos, tickmarkOffset, old), x = xy.x, y = xy.y, reverseCrisp = horiz && x === axis.pos + axis.len || !horiz && y === axis.pos ? -1 : 1;
      var labelOpacity = pick$1y(
        opacity,
        tick.label && tick.label.newOpacity,
        // #15528
        1
      );
      opacity = pick$1y(opacity, 1);
      this.isActive = true;
      this.renderGridLine(old, opacity, reverseCrisp);
      this.renderMark(xy, opacity, reverseCrisp);
      this.renderLabel(xy, old, labelOpacity, index);
      tick.isNew = false;
      fireEvent$A(this, "afterRender");
    };
    Tick2.prototype.renderGridLine = function(old, opacity, reverseCrisp) {
      var tick = this, axis = tick.axis, options = axis.options, attribs = {}, pos = tick.pos, type = tick.type, tickmarkOffset = pick$1y(tick.tickmarkOffset, axis.tickmarkOffset), renderer = axis.chart.renderer;
      var gridLine = tick.gridLine, gridLinePath, gridLineWidth = options.gridLineWidth, gridLineColor = options.gridLineColor, dashStyle = options.gridLineDashStyle;
      if (tick.type === "minor") {
        gridLineWidth = options.minorGridLineWidth;
        gridLineColor = options.minorGridLineColor;
        dashStyle = options.minorGridLineDashStyle;
      }
      if (!gridLine) {
        if (!axis.chart.styledMode) {
          attribs.stroke = gridLineColor;
          attribs["stroke-width"] = gridLineWidth || 0;
          attribs.dashstyle = dashStyle;
        }
        if (!type) {
          attribs.zIndex = 1;
        }
        if (old) {
          opacity = 0;
        }
        tick.gridLine = gridLine = renderer.path().attr(attribs).addClass("highcharts-" + (type ? type + "-" : "") + "grid-line").add(axis.gridGroup);
      }
      if (gridLine) {
        gridLinePath = axis.getPlotLinePath({
          value: pos + tickmarkOffset,
          lineWidth: gridLine.strokeWidth() * reverseCrisp,
          force: "pass",
          old
        });
        if (gridLinePath) {
          gridLine[old || tick.isNew ? "attr" : "animate"]({
            d: gridLinePath,
            opacity
          });
        }
      }
    };
    Tick2.prototype.renderMark = function(xy, opacity, reverseCrisp) {
      var tick = this, axis = tick.axis, options = axis.options, renderer = axis.chart.renderer, type = tick.type, tickSize = axis.tickSize(type ? type + "Tick" : "tick"), x = xy.x, y = xy.y, tickWidth = pick$1y(options[type !== "minor" ? "tickWidth" : "minorTickWidth"], !type && axis.isXAxis ? 1 : 0), tickColor = options[type !== "minor" ? "tickColor" : "minorTickColor"];
      var mark = tick.mark;
      var isNewMark = !mark;
      if (tickSize) {
        if (axis.opposite) {
          tickSize[0] = -tickSize[0];
        }
        if (!mark) {
          tick.mark = mark = renderer.path().addClass("highcharts-" + (type ? type + "-" : "") + "tick").add(axis.axisGroup);
          if (!axis.chart.styledMode) {
            mark.attr({
              stroke: tickColor,
              "stroke-width": tickWidth
            });
          }
        }
        mark[isNewMark ? "attr" : "animate"]({
          d: tick.getMarkPath(x, y, tickSize[0], mark.strokeWidth() * reverseCrisp, axis.horiz, renderer),
          opacity
        });
      }
    };
    Tick2.prototype.renderLabel = function(xy, old, opacity, index) {
      var tick = this, axis = tick.axis, horiz = axis.horiz, options = axis.options, label = tick.label, labelOptions = options.labels, step = labelOptions.step, tickmarkOffset = pick$1y(tick.tickmarkOffset, axis.tickmarkOffset), x = xy.x, y = xy.y;
      var show = true;
      if (label && isNumber$O(x)) {
        label.xy = xy = tick.getLabelPosition(x, y, label, horiz, labelOptions, tickmarkOffset, index, step);
        if (tick.isFirst && !tick.isLast && !options.showFirstLabel || tick.isLast && !tick.isFirst && !options.showLastLabel) {
          show = false;
        } else if (horiz && !labelOptions.step && !labelOptions.rotation && !old && opacity !== 0) {
          tick.handleOverflow(xy);
        }
        if (step && index % step) {
          show = false;
        }
        if (show && isNumber$O(xy.y)) {
          xy.opacity = opacity;
          label[tick.isNewLabel ? "attr" : "animate"](xy);
          tick.isNewLabel = false;
        } else {
          label.attr("y", -9999);
          tick.isNewLabel = true;
        }
      }
    };
    Tick2.prototype.replaceMovedLabel = function() {
      var tick = this, label = tick.label, axis = tick.axis, reversed = axis.reversed;
      var x, y;
      if (label && !tick.isNew) {
        x = axis.horiz ? reversed ? axis.left : axis.width + axis.left : label.xy.x;
        y = axis.horiz ? label.xy.y : reversed ? axis.width + axis.top : axis.top;
        label.animate({ x, y, opacity: 0 }, void 0, label.destroy);
        delete tick.label;
      }
      axis.isDirty = true;
      tick.label = tick.movedLabel;
      delete tick.movedLabel;
    };
    return Tick2;
  })()
);
var animObject$b = animationExports.animObject;
var defaultOptions$h = DefaultOptions.defaultOptions;
var registerEventOptions$2 = exports$4.registerEventOptions;
var deg2rad$6 = H.deg2rad;
var arrayMax$9 = Utilities.arrayMax, arrayMin$8 = Utilities.arrayMin, clamp$i = Utilities.clamp, correctFloat$b = Utilities.correctFloat, defined$R = Utilities.defined, destroyObjectProperties$7 = Utilities.destroyObjectProperties, erase$8 = Utilities.erase, error$9 = Utilities.error, extend$1q = Utilities.extend, fireEvent$z = Utilities.fireEvent, getMagnitude$2 = Utilities.getMagnitude, isArray$m = Utilities.isArray, isNumber$N = Utilities.isNumber, isString$8 = Utilities.isString, merge$1o = Utilities.merge, normalizeTickInterval$2 = Utilities.normalizeTickInterval, objectEach$u = Utilities.objectEach, pick$1x = Utilities.pick, relativeLength$9 = Utilities.relativeLength, removeEvent$9 = Utilities.removeEvent, splat$i = Utilities.splat, syncTimeout$7 = Utilities.syncTimeout;
var Axis = (
  /** @class */
  (function() {
    function Axis2(chart, userOptions) {
      this.alternateBands = void 0;
      this.bottom = void 0;
      this.categories = void 0;
      this.chart = void 0;
      this.closestPointRange = void 0;
      this.coll = void 0;
      this.eventOptions = void 0;
      this.hasNames = void 0;
      this.hasVisibleSeries = void 0;
      this.height = void 0;
      this.isLinked = void 0;
      this.labelEdge = void 0;
      this.labelFormatter = void 0;
      this.left = void 0;
      this.len = void 0;
      this.max = void 0;
      this.maxLabelLength = void 0;
      this.min = void 0;
      this.minorTickInterval = void 0;
      this.minorTicks = void 0;
      this.minPixelPadding = void 0;
      this.names = void 0;
      this.offset = void 0;
      this.options = void 0;
      this.overlap = void 0;
      this.paddedTicks = void 0;
      this.plotLinesAndBands = void 0;
      this.plotLinesAndBandsGroups = void 0;
      this.pointRange = void 0;
      this.pointRangePadding = void 0;
      this.pos = void 0;
      this.positiveValuesOnly = void 0;
      this.right = void 0;
      this.series = void 0;
      this.side = void 0;
      this.tickAmount = void 0;
      this.tickInterval = void 0;
      this.tickmarkOffset = void 0;
      this.tickPositions = void 0;
      this.tickRotCorr = void 0;
      this.ticks = void 0;
      this.top = void 0;
      this.transA = void 0;
      this.transB = void 0;
      this.translationSlope = void 0;
      this.userOptions = void 0;
      this.visible = void 0;
      this.width = void 0;
      this.zoomEnabled = void 0;
      this.init(chart, userOptions);
    }
    Axis2.prototype.init = function(chart, userOptions) {
      var isXAxis = userOptions.isX, axis = this;
      axis.chart = chart;
      axis.horiz = chart.inverted && !axis.isZAxis ? !isXAxis : isXAxis;
      axis.isXAxis = isXAxis;
      axis.coll = axis.coll || (isXAxis ? "xAxis" : "yAxis");
      fireEvent$z(this, "init", { userOptions });
      axis.opposite = pick$1x(userOptions.opposite, axis.opposite);
      axis.side = pick$1x(
        userOptions.side,
        axis.side,
        axis.horiz ? axis.opposite ? 0 : 2 : (
          // top : bottom
          axis.opposite ? 1 : 3
        )
        // right : left
      );
      axis.setOptions(userOptions);
      var options = this.options, labelsOptions = options.labels, type = options.type;
      axis.userOptions = userOptions;
      axis.minPixelPadding = 0;
      axis.reversed = pick$1x(options.reversed, axis.reversed);
      axis.visible = options.visible;
      axis.zoomEnabled = options.zoomEnabled;
      axis.hasNames = type === "category" || options.categories === true;
      axis.categories = options.categories || axis.hasNames;
      if (!axis.names) {
        axis.names = [];
        axis.names.keys = {};
      }
      axis.plotLinesAndBandsGroups = {};
      axis.positiveValuesOnly = !!axis.logarithmic;
      axis.isLinked = defined$R(options.linkedTo);
      axis.ticks = {};
      axis.labelEdge = [];
      axis.minorTicks = {};
      axis.plotLinesAndBands = [];
      axis.alternateBands = {};
      axis.len = 0;
      axis.minRange = axis.userMinRange = options.minRange || options.maxZoom;
      axis.range = options.range;
      axis.offset = options.offset || 0;
      axis.max = null;
      axis.min = null;
      var crosshair = pick$1x(options.crosshair, splat$i(chart.options.tooltip.crosshairs)[isXAxis ? 0 : 1]);
      axis.crosshair = crosshair === true ? {} : crosshair;
      if (chart.axes.indexOf(axis) === -1) {
        if (isXAxis) {
          chart.axes.splice(chart.xAxis.length, 0, axis);
        } else {
          chart.axes.push(axis);
        }
        chart[axis.coll].push(axis);
      }
      axis.series = axis.series || [];
      if (chart.inverted && !axis.isZAxis && isXAxis && typeof axis.reversed === "undefined") {
        axis.reversed = true;
      }
      axis.labelRotation = isNumber$N(labelsOptions.rotation) ? labelsOptions.rotation : void 0;
      registerEventOptions$2(axis, options);
      fireEvent$z(this, "afterInit");
    };
    Axis2.prototype.setOptions = function(userOptions) {
      this.options = merge$1o(AxisDefaults$1.defaultXAxisOptions, this.coll === "yAxis" && AxisDefaults$1.defaultYAxisOptions, [
        AxisDefaults$1.defaultTopAxisOptions,
        AxisDefaults$1.defaultRightAxisOptions,
        AxisDefaults$1.defaultBottomAxisOptions,
        AxisDefaults$1.defaultLeftAxisOptions
      ][this.side], merge$1o(
        // if set in setOptions (#1053):
        defaultOptions$h[this.coll],
        userOptions
      ));
      fireEvent$z(this, "afterSetOptions", { userOptions });
    };
    Axis2.prototype.defaultLabelFormatter = function(ctx) {
      var axis = this.axis, chart = this.chart, numberFormatter = chart.numberFormatter, value = isNumber$N(this.value) ? this.value : NaN, time = axis.chart.time, categories = axis.categories, dateTimeLabelFormat = this.dateTimeLabelFormat, lang2 = defaultOptions$h.lang, numericSymbols = lang2.numericSymbols, numSymMagnitude = lang2.numericSymbolMagnitude || 1e3, numericSymbolDetector = axis.logarithmic ? Math.abs(value) : axis.tickInterval;
      var i2 = numericSymbols && numericSymbols.length, multi, ret;
      if (categories) {
        ret = "" + this.value;
      } else if (dateTimeLabelFormat) {
        ret = time.dateFormat(dateTimeLabelFormat, value);
      } else if (i2 && numericSymbolDetector >= 1e3) {
        while (i2-- && typeof ret === "undefined") {
          multi = Math.pow(numSymMagnitude, i2 + 1);
          if (
            // Only accept a numeric symbol when the distance is more
            // than a full unit. So for example if the symbol is k, we
            // don't accept numbers like 0.5k.
            numericSymbolDetector >= multi && // Accept one decimal before the symbol. Accepts 0.5k but
            // not 0.25k. How does this work with the previous?
            value * 10 % multi === 0 && numericSymbols[i2] !== null && value !== 0
          ) {
            ret = numberFormatter(value / multi, -1) + numericSymbols[i2];
          }
        }
      }
      if (typeof ret === "undefined") {
        if (Math.abs(value) >= 1e4) {
          ret = numberFormatter(value, -1);
        } else {
          ret = numberFormatter(value, -1, void 0, "");
        }
      }
      return ret;
    };
    Axis2.prototype.getSeriesExtremes = function() {
      var axis = this, chart = axis.chart;
      var xExtremes;
      fireEvent$z(this, "getSeriesExtremes", null, function() {
        axis.hasVisibleSeries = false;
        axis.dataMin = axis.dataMax = axis.threshold = null;
        axis.softThreshold = !axis.isXAxis;
        if (axis.stacking) {
          axis.stacking.buildStacks();
        }
        axis.series.forEach(function(series) {
          if (series.visible || !chart.options.chart.ignoreHiddenSeries) {
            var seriesOptions = series.options;
            var xData = void 0, threshold = seriesOptions.threshold, seriesDataMin = void 0, seriesDataMax = void 0;
            axis.hasVisibleSeries = true;
            if (axis.positiveValuesOnly && threshold <= 0) {
              threshold = null;
            }
            if (axis.isXAxis) {
              xData = series.xData;
              if (xData.length) {
                xData = axis.logarithmic ? xData.filter(axis.validatePositiveValue) : xData;
                xExtremes = series.getXExtremes(xData);
                seriesDataMin = xExtremes.min;
                seriesDataMax = xExtremes.max;
                if (!isNumber$N(seriesDataMin) && // #5010:
                !(seriesDataMin instanceof Date)) {
                  xData = xData.filter(isNumber$N);
                  xExtremes = series.getXExtremes(xData);
                  seriesDataMin = xExtremes.min;
                  seriesDataMax = xExtremes.max;
                }
                if (xData.length) {
                  axis.dataMin = Math.min(pick$1x(axis.dataMin, seriesDataMin), seriesDataMin);
                  axis.dataMax = Math.max(pick$1x(axis.dataMax, seriesDataMax), seriesDataMax);
                }
              }
            } else {
              var dataExtremes = series.applyExtremes();
              if (isNumber$N(dataExtremes.dataMin)) {
                seriesDataMin = dataExtremes.dataMin;
                axis.dataMin = Math.min(pick$1x(axis.dataMin, seriesDataMin), seriesDataMin);
              }
              if (isNumber$N(dataExtremes.dataMax)) {
                seriesDataMax = dataExtremes.dataMax;
                axis.dataMax = Math.max(pick$1x(axis.dataMax, seriesDataMax), seriesDataMax);
              }
              if (defined$R(threshold)) {
                axis.threshold = threshold;
              }
              if (!seriesOptions.softThreshold || axis.positiveValuesOnly) {
                axis.softThreshold = false;
              }
            }
          }
        });
      });
      fireEvent$z(this, "afterGetSeriesExtremes");
    };
    Axis2.prototype.translate = function(val, backwards, cvsCoord, old, handleLog, pointPlacement) {
      var axis = this.linkedParent || this, localMin = old && axis.old ? axis.old.min : axis.min, minPixelPadding = axis.minPixelPadding, doPostTranslate = (axis.isOrdinal || axis.brokenAxis && axis.brokenAxis.hasBreaks || axis.logarithmic && handleLog) && axis.lin2val;
      var sign2 = 1, cvsOffset = 0, localA = old && axis.old ? axis.old.transA : axis.transA, returnValue = 0;
      if (!localA) {
        localA = axis.transA;
      }
      if (cvsCoord) {
        sign2 *= -1;
        cvsOffset = axis.len;
      }
      if (axis.reversed) {
        sign2 *= -1;
        cvsOffset -= sign2 * (axis.sector || axis.len);
      }
      if (backwards) {
        val = val * sign2 + cvsOffset;
        val -= minPixelPadding;
        returnValue = val / localA + localMin;
        if (doPostTranslate) {
          returnValue = axis.lin2val(returnValue);
        }
      } else {
        if (doPostTranslate) {
          val = axis.val2lin(val);
        }
        returnValue = isNumber$N(localMin) ? sign2 * (val - localMin) * localA + cvsOffset + sign2 * minPixelPadding + (isNumber$N(pointPlacement) ? localA * pointPlacement : 0) : void 0;
      }
      return returnValue;
    };
    Axis2.prototype.toPixels = function(value, paneCoordinates) {
      return this.translate(value, false, !this.horiz, null, true) + (paneCoordinates ? 0 : this.pos);
    };
    Axis2.prototype.toValue = function(pixel, paneCoordinates) {
      return this.translate(pixel - (paneCoordinates ? 0 : this.pos), true, !this.horiz, null, true);
    };
    Axis2.prototype.getPlotLinePath = function(options) {
      var axis = this, chart = axis.chart, axisLeft = axis.left, axisTop = axis.top, old = options.old, value = options.value, lineWidth = options.lineWidth, cHeight = old && chart.oldChartHeight || chart.chartHeight, cWidth = old && chart.oldChartWidth || chart.chartWidth, transB = axis.transB;
      var translatedValue = options.translatedValue, force = options.force, x1, y1, x2, y2, skip;
      function between(x, a, b) {
        if (force !== "pass" && x < a || x > b) {
          if (force) {
            x = clamp$i(x, a, b);
          } else {
            skip = true;
          }
        }
        return x;
      }
      var evt = {
        value,
        lineWidth,
        old,
        force,
        acrossPanes: options.acrossPanes,
        translatedValue
      };
      fireEvent$z(this, "getPlotLinePath", evt, function(e) {
        translatedValue = pick$1x(translatedValue, axis.translate(value, null, null, old));
        translatedValue = clamp$i(translatedValue, -1e5, 1e5);
        x1 = x2 = Math.round(translatedValue + transB);
        y1 = y2 = Math.round(cHeight - translatedValue - transB);
        if (!isNumber$N(translatedValue)) {
          skip = true;
          force = false;
        } else if (axis.horiz) {
          y1 = axisTop;
          y2 = cHeight - axis.bottom;
          x1 = x2 = between(x1, axisLeft, axisLeft + axis.width);
        } else {
          x1 = axisLeft;
          x2 = cWidth - axis.right;
          y1 = y2 = between(y1, axisTop, axisTop + axis.height);
        }
        e.path = skip && !force ? null : chart.renderer.crispLine([["M", x1, y1], ["L", x2, y2]], lineWidth || 1);
      });
      return evt.path;
    };
    Axis2.prototype.getLinearTickPositions = function(tickInterval, min2, max2) {
      var roundedMin = correctFloat$b(Math.floor(min2 / tickInterval) * tickInterval), roundedMax = correctFloat$b(Math.ceil(max2 / tickInterval) * tickInterval), tickPositions = [];
      var pos, lastPos, precision;
      if (correctFloat$b(roundedMin + tickInterval) === roundedMin) {
        precision = 20;
      }
      if (this.single) {
        return [min2];
      }
      pos = roundedMin;
      while (pos <= roundedMax) {
        tickPositions.push(pos);
        pos = correctFloat$b(pos + tickInterval, precision);
        if (pos === lastPos) {
          break;
        }
        lastPos = pos;
      }
      return tickPositions;
    };
    Axis2.prototype.getMinorTickInterval = function() {
      var options = this.options;
      if (options.minorTicks === true) {
        return pick$1x(options.minorTickInterval, "auto");
      }
      if (options.minorTicks === false) {
        return null;
      }
      return options.minorTickInterval;
    };
    Axis2.prototype.getMinorTickPositions = function() {
      var axis = this, options = axis.options, tickPositions = axis.tickPositions, minorTickInterval = axis.minorTickInterval, pointRangePadding = axis.pointRangePadding || 0, min2 = axis.min - pointRangePadding, max2 = axis.max + pointRangePadding, range = max2 - min2;
      var minorTickPositions = [], pos;
      if (range && range / minorTickInterval < axis.len / 3) {
        var logarithmic_1 = axis.logarithmic;
        if (logarithmic_1) {
          this.paddedTicks.forEach(function(_pos, i2, paddedTicks) {
            if (i2) {
              minorTickPositions.push.apply(minorTickPositions, logarithmic_1.getLogTickPositions(minorTickInterval, paddedTicks[i2 - 1], paddedTicks[i2], true));
            }
          });
        } else if (axis.dateTime && this.getMinorTickInterval() === "auto") {
          minorTickPositions = minorTickPositions.concat(axis.getTimeTicks(axis.dateTime.normalizeTimeTickInterval(minorTickInterval), min2, max2, options.startOfWeek));
        } else {
          for (pos = min2 + (tickPositions[0] - min2) % minorTickInterval; pos <= max2; pos += minorTickInterval) {
            if (pos === minorTickPositions[0]) {
              break;
            }
            minorTickPositions.push(pos);
          }
        }
      }
      if (minorTickPositions.length !== 0) {
        axis.trimTicks(minorTickPositions);
      }
      return minorTickPositions;
    };
    Axis2.prototype.adjustForMinRange = function() {
      var axis = this, options = axis.options, log = axis.logarithmic;
      var min2 = axis.min, max2 = axis.max, zoomOffset, spaceAvailable, closestDataRange = 0, i2, distance, xData, loopLength, minArgs, maxArgs, minRange;
      if (axis.isXAxis && typeof axis.minRange === "undefined" && !log) {
        if (defined$R(options.min) || defined$R(options.max)) {
          axis.minRange = null;
        } else {
          axis.series.forEach(function(series) {
            xData = series.xData;
            loopLength = series.xIncrement ? 1 : xData.length - 1;
            if (xData.length > 1) {
              for (i2 = loopLength; i2 > 0; i2--) {
                distance = xData[i2] - xData[i2 - 1];
                if (!closestDataRange || distance < closestDataRange) {
                  closestDataRange = distance;
                }
              }
            }
          });
          axis.minRange = Math.min(closestDataRange * 5, axis.dataMax - axis.dataMin);
        }
      }
      if (max2 - min2 < axis.minRange) {
        spaceAvailable = axis.dataMax - axis.dataMin >= axis.minRange;
        minRange = axis.minRange;
        zoomOffset = (minRange - max2 + min2) / 2;
        minArgs = [
          min2 - zoomOffset,
          pick$1x(options.min, min2 - zoomOffset)
        ];
        if (spaceAvailable) {
          minArgs[2] = axis.logarithmic ? axis.logarithmic.log2lin(axis.dataMin) : axis.dataMin;
        }
        min2 = arrayMax$9(minArgs);
        maxArgs = [
          min2 + minRange,
          pick$1x(options.max, min2 + minRange)
        ];
        if (spaceAvailable) {
          maxArgs[2] = log ? log.log2lin(axis.dataMax) : axis.dataMax;
        }
        max2 = arrayMin$8(maxArgs);
        if (max2 - min2 < minRange) {
          minArgs[0] = max2 - minRange;
          minArgs[1] = pick$1x(options.min, max2 - minRange);
          min2 = arrayMax$9(minArgs);
        }
      }
      axis.min = min2;
      axis.max = max2;
    };
    Axis2.prototype.getClosest = function() {
      var ret;
      if (this.categories) {
        ret = 1;
      } else {
        this.series.forEach(function(series) {
          var seriesClosest = series.closestPointRange, visible = series.visible || !series.chart.options.chart.ignoreHiddenSeries;
          if (!series.noSharedTooltip && defined$R(seriesClosest) && visible) {
            ret = defined$R(ret) ? Math.min(ret, seriesClosest) : seriesClosest;
          }
        });
      }
      return ret;
    };
    Axis2.prototype.nameToX = function(point) {
      var explicitCategories = isArray$m(this.categories), names2 = explicitCategories ? this.categories : this.names;
      var nameX = point.options.x, x;
      point.series.requireSorting = false;
      if (!defined$R(nameX)) {
        nameX = this.options.uniqueNames ? explicitCategories ? names2.indexOf(point.name) : pick$1x(names2.keys[point.name], -1) : point.series.autoIncrement();
      }
      if (nameX === -1) {
        if (!explicitCategories) {
          x = names2.length;
        }
      } else {
        x = nameX;
      }
      if (typeof x !== "undefined") {
        this.names[x] = point.name;
        this.names.keys[point.name] = x;
      }
      return x;
    };
    Axis2.prototype.updateNames = function() {
      var axis = this, names2 = this.names, i2 = names2.length;
      if (i2 > 0) {
        Object.keys(names2.keys).forEach(function(key2) {
          delete names2.keys[key2];
        });
        names2.length = 0;
        this.minRange = this.userMinRange;
        (this.series || []).forEach(function(series) {
          series.xIncrement = null;
          if (!series.points || series.isDirtyData) {
            axis.max = Math.max(axis.max, series.xData.length - 1);
            series.processData();
            series.generatePoints();
          }
          series.data.forEach(function(point, i3) {
            var x;
            if (point && point.options && typeof point.name !== "undefined") {
              x = axis.nameToX(point);
              if (typeof x !== "undefined" && x !== point.x) {
                point.x = x;
                series.xData[i3] = x;
              }
            }
          });
        });
      }
    };
    Axis2.prototype.setAxisTranslation = function() {
      var axis = this, range = axis.max - axis.min, linkedParent = axis.linkedParent, hasCategories = !!axis.categories, isXAxis = axis.isXAxis;
      var pointRange = axis.axisPointRange || 0, closestPointRange, minPointOffset = 0, pointRangePadding = 0, ordinalCorrection, transA = axis.transA;
      if (isXAxis || hasCategories || pointRange) {
        closestPointRange = axis.getClosest();
        if (linkedParent) {
          minPointOffset = linkedParent.minPointOffset;
          pointRangePadding = linkedParent.pointRangePadding;
        } else {
          axis.series.forEach(function(series) {
            var seriesPointRange = hasCategories ? 1 : isXAxis ? pick$1x(series.options.pointRange, closestPointRange, 0) : axis.axisPointRange || 0, pointPlacement = series.options.pointPlacement;
            pointRange = Math.max(pointRange, seriesPointRange);
            if (!axis.single || hasCategories) {
              var isPointPlacementAxis = series.is("xrange") ? !isXAxis : isXAxis;
              minPointOffset = Math.max(minPointOffset, isPointPlacementAxis && isString$8(pointPlacement) ? 0 : seriesPointRange / 2);
              pointRangePadding = Math.max(pointRangePadding, isPointPlacementAxis && pointPlacement === "on" ? 0 : seriesPointRange);
            }
          });
        }
        ordinalCorrection = axis.ordinal && axis.ordinal.slope && closestPointRange ? axis.ordinal.slope / closestPointRange : 1;
        axis.minPointOffset = minPointOffset = minPointOffset * ordinalCorrection;
        axis.pointRangePadding = pointRangePadding = pointRangePadding * ordinalCorrection;
        axis.pointRange = Math.min(pointRange, axis.single && hasCategories ? 1 : range);
        if (isXAxis) {
          axis.closestPointRange = closestPointRange;
        }
      }
      axis.translationSlope = axis.transA = transA = axis.staticScale || axis.len / (range + pointRangePadding || 1);
      axis.transB = axis.horiz ? axis.left : axis.bottom;
      axis.minPixelPadding = transA * minPointOffset;
      fireEvent$z(this, "afterSetAxisTranslation");
    };
    Axis2.prototype.minFromRange = function() {
      var axis = this;
      return axis.max - axis.range;
    };
    Axis2.prototype.setTickInterval = function(secondPass) {
      var axis = this, chart = axis.chart, log = axis.logarithmic, options = axis.options, isXAxis = axis.isXAxis, isLinked = axis.isLinked, tickPixelIntervalOption = options.tickPixelInterval, categories = axis.categories, softThreshold = axis.softThreshold;
      var maxPadding = options.maxPadding, minPadding = options.minPadding, length, linkedParentExtremes, tickIntervalOption = options.tickInterval, threshold = isNumber$N(axis.threshold) ? axis.threshold : null, thresholdMin, thresholdMax, hardMin, hardMax;
      if (!axis.dateTime && !categories && !isLinked) {
        this.getTickAmount();
      }
      hardMin = pick$1x(axis.userMin, options.min);
      hardMax = pick$1x(axis.userMax, options.max);
      if (isLinked) {
        axis.linkedParent = chart[axis.coll][options.linkedTo];
        linkedParentExtremes = axis.linkedParent.getExtremes();
        axis.min = pick$1x(linkedParentExtremes.min, linkedParentExtremes.dataMin);
        axis.max = pick$1x(linkedParentExtremes.max, linkedParentExtremes.dataMax);
        if (options.type !== axis.linkedParent.options.type) {
          error$9(11, 1, chart);
        }
      } else {
        if (softThreshold && defined$R(threshold)) {
          if (axis.dataMin >= threshold) {
            thresholdMin = threshold;
            minPadding = 0;
          } else if (axis.dataMax <= threshold) {
            thresholdMax = threshold;
            maxPadding = 0;
          }
        }
        axis.min = pick$1x(hardMin, thresholdMin, axis.dataMin);
        axis.max = pick$1x(hardMax, thresholdMax, axis.dataMax);
      }
      if (log) {
        if (axis.positiveValuesOnly && !secondPass && Math.min(axis.min, pick$1x(axis.dataMin, axis.min)) <= 0) {
          error$9(10, 1, chart);
        }
        axis.min = correctFloat$b(log.log2lin(axis.min), 16);
        axis.max = correctFloat$b(log.log2lin(axis.max), 16);
      }
      if (axis.range && defined$R(axis.max)) {
        axis.userMin = axis.min = hardMin = Math.max(axis.dataMin, axis.minFromRange());
        axis.userMax = hardMax = axis.max;
        axis.range = null;
      }
      fireEvent$z(axis, "foundExtremes");
      if (axis.beforePadding) {
        axis.beforePadding();
      }
      axis.adjustForMinRange();
      if (!categories && !axis.axisPointRange && !(axis.stacking && axis.stacking.usePercentage) && !isLinked && defined$R(axis.min) && defined$R(axis.max)) {
        length = axis.max - axis.min;
        if (length) {
          if (!defined$R(hardMin) && minPadding) {
            axis.min -= length * minPadding;
          }
          if (!defined$R(hardMax) && maxPadding) {
            axis.max += length * maxPadding;
          }
        }
      }
      if (!isNumber$N(axis.userMin)) {
        if (isNumber$N(options.softMin) && options.softMin < axis.min) {
          axis.min = hardMin = options.softMin;
        }
        if (isNumber$N(options.floor)) {
          axis.min = Math.max(axis.min, options.floor);
        }
      }
      if (!isNumber$N(axis.userMax)) {
        if (isNumber$N(options.softMax) && options.softMax > axis.max) {
          axis.max = hardMax = options.softMax;
        }
        if (isNumber$N(options.ceiling)) {
          axis.max = Math.min(axis.max, options.ceiling);
        }
      }
      if (softThreshold && defined$R(axis.dataMin)) {
        threshold = threshold || 0;
        if (!defined$R(hardMin) && axis.min < threshold && axis.dataMin >= threshold) {
          axis.min = axis.options.minRange ? Math.min(threshold, axis.max - axis.minRange) : threshold;
        } else if (!defined$R(hardMax) && axis.max > threshold && axis.dataMax <= threshold) {
          axis.max = axis.options.minRange ? Math.max(threshold, axis.min + axis.minRange) : threshold;
        }
      }
      if (isNumber$N(axis.min) && isNumber$N(axis.max) && !this.chart.polar && axis.min > axis.max) {
        if (defined$R(axis.options.min)) {
          axis.max = axis.min;
        } else if (defined$R(axis.options.max)) {
          axis.min = axis.max;
        }
      }
      if (axis.min === axis.max || typeof axis.min === "undefined" || typeof axis.max === "undefined") {
        axis.tickInterval = 1;
      } else if (isLinked && axis.linkedParent && !tickIntervalOption && tickPixelIntervalOption === axis.linkedParent.options.tickPixelInterval) {
        axis.tickInterval = tickIntervalOption = axis.linkedParent.tickInterval;
      } else {
        axis.tickInterval = pick$1x(
          tickIntervalOption,
          this.tickAmount ? (axis.max - axis.min) / Math.max(this.tickAmount - 1, 1) : void 0,
          // For categoried axis, 1 is default, for linear axis use
          // tickPix
          categories ? 1 : (
            // don't let it be more than the data range
            (axis.max - axis.min) * tickPixelIntervalOption / Math.max(axis.len, tickPixelIntervalOption)
          )
        );
      }
      if (isXAxis && !secondPass) {
        axis.series.forEach(function(series) {
          series.forceCrop = series.forceCropping && series.forceCropping();
          series.processData(axis.min !== (axis.old && axis.old.min) || axis.max !== (axis.old && axis.old.max));
        });
        fireEvent$z(this, "postProcessData");
      }
      axis.setAxisTranslation();
      fireEvent$z(this, "initialAxisTranslation");
      if (axis.pointRange && !tickIntervalOption) {
        axis.tickInterval = Math.max(axis.pointRange, axis.tickInterval);
      }
      var minTickInterval = pick$1x(
        options.minTickInterval,
        // In datetime axes, don't go below the data interval, except when
        // there are scatter-like series involved (#13369).
        axis.dateTime && !axis.series.some(function(s) {
          return s.noSharedTooltip;
        }) ? axis.closestPointRange : 0
      );
      if (!tickIntervalOption && axis.tickInterval < minTickInterval) {
        axis.tickInterval = minTickInterval;
      }
      if (!axis.dateTime && !axis.logarithmic && !tickIntervalOption) {
        axis.tickInterval = normalizeTickInterval$2(axis.tickInterval, void 0, getMagnitude$2(axis.tickInterval), pick$1x(
          options.allowDecimals,
          // If the tick interval is greather than 0.5, avoid
          // decimals, as linear axes are often used to render
          // discrete values. #3363. If a tick amount is set, allow
          // decimals by default, as it increases the chances for a
          // good fit.
          axis.tickInterval < 0.5 || this.tickAmount !== void 0
        ), !!this.tickAmount);
      }
      if (!this.tickAmount) {
        axis.tickInterval = axis.unsquish();
      }
      this.setTickPositions();
    };
    Axis2.prototype.setTickPositions = function() {
      var axis = this, options = this.options, tickPositionsOption = options.tickPositions, minorTickIntervalOption = this.getMinorTickInterval(), hasVerticalPanning = this.hasVerticalPanning(), isColorAxis = this.coll === "colorAxis", startOnTick = (isColorAxis || !hasVerticalPanning) && options.startOnTick, endOnTick = (isColorAxis || !hasVerticalPanning) && options.endOnTick;
      var tickPositions, tickPositioner = options.tickPositioner;
      this.tickmarkOffset = this.categories && options.tickmarkPlacement === "between" && this.tickInterval === 1 ? 0.5 : 0;
      this.minorTickInterval = minorTickIntervalOption === "auto" && this.tickInterval ? this.tickInterval / 5 : minorTickIntervalOption;
      this.single = this.min === this.max && defined$R(this.min) && !this.tickAmount && // Data is on integer (#6563)
      (parseInt(this.min, 10) === this.min || // Between integers and decimals are not allowed (#6274)
      options.allowDecimals !== false);
      this.tickPositions = // Find the tick positions. Work on a copy (#1565)
      tickPositions = tickPositionsOption && tickPositionsOption.slice();
      if (!tickPositions) {
        if ((!axis.ordinal || !axis.ordinal.positions) && (this.max - this.min) / this.tickInterval > Math.max(2 * this.len, 200)) {
          tickPositions = [this.min, this.max];
          error$9(19, false, this.chart);
        } else if (axis.dateTime) {
          tickPositions = axis.getTimeTicks(axis.dateTime.normalizeTimeTickInterval(this.tickInterval, options.units), this.min, this.max, options.startOfWeek, axis.ordinal && axis.ordinal.positions, this.closestPointRange, true);
        } else if (axis.logarithmic) {
          tickPositions = axis.logarithmic.getLogTickPositions(this.tickInterval, this.min, this.max);
        } else {
          tickPositions = this.getLinearTickPositions(this.tickInterval, this.min, this.max);
        }
        if (tickPositions.length > this.len) {
          tickPositions = [tickPositions[0], tickPositions.pop()];
          if (tickPositions[0] === tickPositions[1]) {
            tickPositions.length = 1;
          }
        }
        this.tickPositions = tickPositions;
        if (tickPositioner) {
          tickPositioner = tickPositioner.apply(axis, [this.min, this.max]);
          if (tickPositioner) {
            this.tickPositions = tickPositions = tickPositioner;
          }
        }
      }
      this.paddedTicks = tickPositions.slice(0);
      this.trimTicks(tickPositions, startOnTick, endOnTick);
      if (!this.isLinked) {
        if (this.single && tickPositions.length < 2 && !this.categories && !this.series.some(function(s) {
          return s.is("heatmap") && s.options.pointPlacement === "between";
        })) {
          this.min -= 0.5;
          this.max += 0.5;
        }
        if (!tickPositionsOption && !tickPositioner) {
          this.adjustTickAmount();
        }
      }
      fireEvent$z(this, "afterSetTickPositions");
    };
    Axis2.prototype.trimTicks = function(tickPositions, startOnTick, endOnTick) {
      var roundedMin = tickPositions[0], roundedMax = tickPositions[tickPositions.length - 1], minPointOffset = !this.isOrdinal && this.minPointOffset || 0;
      fireEvent$z(this, "trimTicks");
      if (!this.isLinked) {
        if (startOnTick && roundedMin !== -Infinity) {
          this.min = roundedMin;
        } else {
          while (this.min - minPointOffset > tickPositions[0]) {
            tickPositions.shift();
          }
        }
        if (endOnTick) {
          this.max = roundedMax;
        } else {
          while (this.max + minPointOffset < tickPositions[tickPositions.length - 1]) {
            tickPositions.pop();
          }
        }
        if (tickPositions.length === 0 && defined$R(roundedMin) && !this.options.tickPositions) {
          tickPositions.push((roundedMax + roundedMin) / 2);
        }
      }
    };
    Axis2.prototype.alignToOthers = function() {
      var axis = this, others = (
        // Whether there is another axis to pair with this one
        {}
      ), options = axis.options;
      var hasOther;
      if (
        // Only if alignTicks is true
        this.chart.options.chart.alignTicks !== false && options.alignTicks && // Disabled when startOnTick or endOnTick are false (#7604)
        options.startOnTick !== false && options.endOnTick !== false && // Don't try to align ticks on a log axis, they are not evenly
        // spaced (#6021)
        !axis.logarithmic
      ) {
        this.chart[this.coll].forEach(function(axis2) {
          var otherOptions = axis2.options, horiz = axis2.horiz, key2 = [
            horiz ? otherOptions.left : otherOptions.top,
            otherOptions.width,
            otherOptions.height,
            otherOptions.pane
          ].join(",");
          if (axis2.series.length) {
            if (others[key2]) {
              hasOther = true;
            } else {
              others[key2] = 1;
            }
          }
        });
      }
      return hasOther;
    };
    Axis2.prototype.getTickAmount = function() {
      var axis = this, options = this.options, tickPixelInterval = options.tickPixelInterval;
      var tickAmount = options.tickAmount;
      if (!defined$R(options.tickInterval) && !tickAmount && this.len < tickPixelInterval && !this.isRadial && !axis.logarithmic && options.startOnTick && options.endOnTick) {
        tickAmount = 2;
      }
      if (!tickAmount && this.alignToOthers()) {
        tickAmount = Math.ceil(this.len / tickPixelInterval) + 1;
      }
      if (tickAmount < 4) {
        this.finalTickAmt = tickAmount;
        tickAmount = 5;
      }
      this.tickAmount = tickAmount;
    };
    Axis2.prototype.adjustTickAmount = function() {
      var axis = this, axisOptions = axis.options, tickInterval = axis.tickInterval, tickPositions = axis.tickPositions, tickAmount = axis.tickAmount, finalTickAmt = axis.finalTickAmt, currentTickAmount = tickPositions && tickPositions.length, threshold = pick$1x(axis.threshold, axis.softThreshold ? 0 : null);
      var len, i2;
      if (axis.hasData() && isNumber$N(axis.min) && isNumber$N(axis.max)) {
        if (currentTickAmount < tickAmount) {
          while (tickPositions.length < tickAmount) {
            if (tickPositions.length % 2 || axis.min === threshold) {
              tickPositions.push(correctFloat$b(tickPositions[tickPositions.length - 1] + tickInterval));
            } else {
              tickPositions.unshift(correctFloat$b(tickPositions[0] - tickInterval));
            }
          }
          axis.transA *= (currentTickAmount - 1) / (tickAmount - 1);
          axis.min = axisOptions.startOnTick ? tickPositions[0] : Math.min(axis.min, tickPositions[0]);
          axis.max = axisOptions.endOnTick ? tickPositions[tickPositions.length - 1] : Math.max(axis.max, tickPositions[tickPositions.length - 1]);
        } else if (currentTickAmount > tickAmount) {
          axis.tickInterval *= 2;
          axis.setTickPositions();
        }
        if (defined$R(finalTickAmt)) {
          i2 = len = tickPositions.length;
          while (i2--) {
            if (
              // Remove every other tick
              finalTickAmt === 3 && i2 % 2 === 1 || // Remove all but first and last
              finalTickAmt <= 2 && i2 > 0 && i2 < len - 1
            ) {
              tickPositions.splice(i2, 1);
            }
          }
          axis.finalTickAmt = void 0;
        }
      }
    };
    Axis2.prototype.setScale = function() {
      var axis = this;
      var isDirtyData = false, isXAxisDirty = false;
      axis.series.forEach(function(series) {
        isDirtyData = isDirtyData || series.isDirtyData || series.isDirty;
        isXAxisDirty = isXAxisDirty || series.xAxis && series.xAxis.isDirty || false;
      });
      axis.setAxisSize();
      var isDirtyAxisLength = axis.len !== (axis.old && axis.old.len);
      if (isDirtyAxisLength || isDirtyData || isXAxisDirty || axis.isLinked || axis.forceRedraw || axis.userMin !== (axis.old && axis.old.userMin) || axis.userMax !== (axis.old && axis.old.userMax) || axis.alignToOthers()) {
        if (axis.stacking) {
          axis.stacking.resetStacks();
        }
        axis.forceRedraw = false;
        axis.getSeriesExtremes();
        axis.setTickInterval();
        if (!axis.isDirty) {
          axis.isDirty = isDirtyAxisLength || axis.min !== (axis.old && axis.old.min) || axis.max !== (axis.old && axis.old.max);
        }
      } else if (axis.stacking) {
        axis.stacking.cleanStacks();
      }
      if (isDirtyData && axis.panningState) {
        axis.panningState.isDirty = true;
      }
      fireEvent$z(this, "afterSetScale");
    };
    Axis2.prototype.setExtremes = function(newMin, newMax, redraw, animation, eventArguments) {
      var axis = this, chart = axis.chart;
      redraw = pick$1x(redraw, true);
      axis.series.forEach(function(serie) {
        delete serie.kdTree;
      });
      eventArguments = extend$1q(eventArguments, {
        min: newMin,
        max: newMax
      });
      fireEvent$z(axis, "setExtremes", eventArguments, function() {
        axis.userMin = newMin;
        axis.userMax = newMax;
        axis.eventArgs = eventArguments;
        if (redraw) {
          chart.redraw(animation);
        }
      });
    };
    Axis2.prototype.zoom = function(newMin, newMax) {
      var axis = this, dataMin = this.dataMin, dataMax = this.dataMax, options = this.options, min2 = Math.min(dataMin, pick$1x(options.min, dataMin)), max2 = Math.max(dataMax, pick$1x(options.max, dataMax)), evt = {
        newMin,
        newMax
      };
      fireEvent$z(this, "zoom", evt, function(e) {
        var newMin2 = e.newMin, newMax2 = e.newMax;
        if (newMin2 !== axis.min || newMax2 !== axis.max) {
          if (!axis.allowZoomOutside) {
            if (defined$R(dataMin)) {
              if (newMin2 < min2) {
                newMin2 = min2;
              }
              if (newMin2 > max2) {
                newMin2 = max2;
              }
            }
            if (defined$R(dataMax)) {
              if (newMax2 < min2) {
                newMax2 = min2;
              }
              if (newMax2 > max2) {
                newMax2 = max2;
              }
            }
          }
          axis.displayBtn = typeof newMin2 !== "undefined" || typeof newMax2 !== "undefined";
          axis.setExtremes(newMin2, newMax2, false, void 0, { trigger: "zoom" });
        }
        e.zoomed = true;
      });
      return evt.zoomed;
    };
    Axis2.prototype.setAxisSize = function() {
      var chart = this.chart, options = this.options, offsets = options.offsets || [0, 0, 0, 0], horiz = this.horiz, width = this.width = Math.round(relativeLength$9(pick$1x(options.width, chart.plotWidth - offsets[3] + offsets[1]), chart.plotWidth)), height = this.height = Math.round(relativeLength$9(pick$1x(options.height, chart.plotHeight - offsets[0] + offsets[2]), chart.plotHeight)), top = this.top = Math.round(relativeLength$9(pick$1x(options.top, chart.plotTop + offsets[0]), chart.plotHeight, chart.plotTop)), left = this.left = Math.round(relativeLength$9(pick$1x(options.left, chart.plotLeft + offsets[3]), chart.plotWidth, chart.plotLeft));
      this.bottom = chart.chartHeight - height - top;
      this.right = chart.chartWidth - width - left;
      this.len = Math.max(horiz ? width : height, 0);
      this.pos = horiz ? left : top;
    };
    Axis2.prototype.getExtremes = function() {
      var axis = this, log = axis.logarithmic;
      return {
        min: log ? correctFloat$b(log.lin2log(axis.min)) : axis.min,
        max: log ? correctFloat$b(log.lin2log(axis.max)) : axis.max,
        dataMin: axis.dataMin,
        dataMax: axis.dataMax,
        userMin: axis.userMin,
        userMax: axis.userMax
      };
    };
    Axis2.prototype.getThreshold = function(threshold) {
      var axis = this, log = axis.logarithmic, realMin = log ? log.lin2log(axis.min) : axis.min, realMax = log ? log.lin2log(axis.max) : axis.max;
      if (threshold === null || threshold === -Infinity) {
        threshold = realMin;
      } else if (threshold === Infinity) {
        threshold = realMax;
      } else if (realMin > threshold) {
        threshold = realMin;
      } else if (realMax < threshold) {
        threshold = realMax;
      }
      return axis.translate(threshold, 0, 1, 0, 1);
    };
    Axis2.prototype.autoLabelAlign = function(rotation) {
      var angle = (pick$1x(rotation, 0) - this.side * 90 + 720) % 360, evt = { align: "center" };
      fireEvent$z(this, "autoLabelAlign", evt, function(e) {
        if (angle > 15 && angle < 165) {
          e.align = "right";
        } else if (angle > 195 && angle < 345) {
          e.align = "left";
        }
      });
      return evt.align;
    };
    Axis2.prototype.tickSize = function(prefix) {
      var options = this.options, tickWidth = pick$1x(
        options[prefix === "tick" ? "tickWidth" : "minorTickWidth"],
        // Default to 1 on linear and datetime X axes
        prefix === "tick" && this.isXAxis && !this.categories ? 1 : 0
      );
      var tickLength = options[prefix === "tick" ? "tickLength" : "minorTickLength"], tickSize;
      if (tickWidth && tickLength) {
        if (options[prefix + "Position"] === "inside") {
          tickLength = -tickLength;
        }
        tickSize = [tickLength, tickWidth];
      }
      var e = { tickSize };
      fireEvent$z(this, "afterTickSize", e);
      return e.tickSize;
    };
    Axis2.prototype.labelMetrics = function() {
      var index = this.tickPositions && this.tickPositions[0] || 0;
      return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize, this.ticks[index] && this.ticks[index].label);
    };
    Axis2.prototype.unsquish = function() {
      var labelOptions = this.options.labels, horiz = this.horiz, tickInterval = this.tickInterval, slotSize = this.len / (((this.categories ? 1 : 0) + this.max - this.min) / tickInterval), rotationOption = labelOptions.rotation, labelMetrics = this.labelMetrics(), range = Math.max(this.max - this.min, 0), getStep = function(spaceNeeded) {
        var step2 = spaceNeeded / (slotSize || 1);
        step2 = step2 > 1 ? Math.ceil(step2) : 1;
        if (step2 * tickInterval > range && spaceNeeded !== Infinity && slotSize !== Infinity && range) {
          step2 = Math.ceil(range / tickInterval);
        }
        return correctFloat$b(step2 * tickInterval);
      };
      var newTickInterval = tickInterval, rotation, step, bestScore = Number.MAX_VALUE, autoRotation;
      if (horiz) {
        if (!labelOptions.staggerLines && !labelOptions.step) {
          if (isNumber$N(rotationOption)) {
            autoRotation = [rotationOption];
          } else if (slotSize < labelOptions.autoRotationLimit) {
            autoRotation = labelOptions.autoRotation;
          }
        }
        if (autoRotation) {
          autoRotation.forEach(function(rot) {
            var score;
            if (rot === rotationOption || rot && rot >= -90 && rot <= 90) {
              step = getStep(Math.abs(labelMetrics.h / Math.sin(deg2rad$6 * rot)));
              score = step + Math.abs(rot / 360);
              if (score < bestScore) {
                bestScore = score;
                rotation = rot;
                newTickInterval = step;
              }
            }
          });
        }
      } else if (!labelOptions.step) {
        newTickInterval = getStep(labelMetrics.h);
      }
      this.autoRotation = autoRotation;
      this.labelRotation = pick$1x(rotation, isNumber$N(rotationOption) ? rotationOption : 0);
      return newTickInterval;
    };
    Axis2.prototype.getSlotWidth = function(tick) {
      var chart = this.chart, horiz = this.horiz, labelOptions = this.options.labels, slotCount = Math.max(this.tickPositions.length - (this.categories ? 0 : 1), 1), marginLeft = chart.margin[3];
      if (tick && isNumber$N(tick.slotWidth)) {
        return tick.slotWidth;
      }
      if (horiz && labelOptions.step < 2) {
        if (labelOptions.rotation) {
          return 0;
        }
        return (this.staggerLines || 1) * this.len / slotCount;
      }
      if (!horiz) {
        var cssWidth = labelOptions.style.width;
        if (cssWidth !== void 0) {
          return parseInt(String(cssWidth), 10);
        }
        if (marginLeft) {
          return marginLeft - chart.spacing[3];
        }
      }
      return chart.chartWidth * 0.33;
    };
    Axis2.prototype.renderUnsquish = function() {
      var chart = this.chart, renderer = chart.renderer, tickPositions = this.tickPositions, ticks = this.ticks, labelOptions = this.options.labels, labelStyleOptions = labelOptions.style, horiz = this.horiz, slotWidth = this.getSlotWidth(), innerWidth = Math.max(1, Math.round(slotWidth - 2 * labelOptions.padding)), attr2 = {}, labelMetrics = this.labelMetrics(), textOverflowOption = labelStyleOptions.textOverflow;
      var commonWidth, commonTextOverflow, maxLabelLength = 0, label, i2, pos;
      if (!isString$8(labelOptions.rotation)) {
        attr2.rotation = labelOptions.rotation || 0;
      }
      tickPositions.forEach(function(tickPosition) {
        var tick = ticks[tickPosition];
        if (tick.movedLabel) {
          tick.replaceMovedLabel();
        }
        if (tick && tick.label && tick.label.textPxLength > maxLabelLength) {
          maxLabelLength = tick.label.textPxLength;
        }
      });
      this.maxLabelLength = maxLabelLength;
      if (this.autoRotation) {
        if (maxLabelLength > innerWidth && maxLabelLength > labelMetrics.h) {
          attr2.rotation = this.labelRotation;
        } else {
          this.labelRotation = 0;
        }
      } else if (slotWidth) {
        commonWidth = innerWidth;
        if (!textOverflowOption) {
          commonTextOverflow = "clip";
          i2 = tickPositions.length;
          while (!horiz && i2--) {
            pos = tickPositions[i2];
            label = ticks[pos].label;
            if (label) {
              if (label.styles && label.styles.textOverflow === "ellipsis") {
                label.css({ textOverflow: "clip" });
              } else if (label.textPxLength > slotWidth) {
                label.css({ width: slotWidth + "px" });
              }
              if (label.getBBox().height > this.len / tickPositions.length - (labelMetrics.h - labelMetrics.f)) {
                label.specificTextOverflow = "ellipsis";
              }
            }
          }
        }
      }
      if (attr2.rotation) {
        commonWidth = maxLabelLength > chart.chartHeight * 0.5 ? chart.chartHeight * 0.33 : maxLabelLength;
        if (!textOverflowOption) {
          commonTextOverflow = "ellipsis";
        }
      }
      this.labelAlign = labelOptions.align || this.autoLabelAlign(this.labelRotation);
      if (this.labelAlign) {
        attr2.align = this.labelAlign;
      }
      tickPositions.forEach(function(pos2) {
        var tick = ticks[pos2], label2 = tick && tick.label, widthOption = labelStyleOptions.width, css2 = {};
        if (label2) {
          label2.attr(attr2);
          if (tick.shortenLabel) {
            tick.shortenLabel();
          } else if (commonWidth && !widthOption && // Setting width in this case messes with the bounding box
          // (#7975)
          labelStyleOptions.whiteSpace !== "nowrap" && // Speed optimizing, #7656
          (commonWidth < label2.textPxLength || // Resetting CSS, #4928
          label2.element.tagName === "SPAN")) {
            css2.width = commonWidth + "px";
            if (!textOverflowOption) {
              css2.textOverflow = label2.specificTextOverflow || commonTextOverflow;
            }
            label2.css(css2);
          } else if (label2.styles && label2.styles.width && !css2.width && !widthOption) {
            label2.css({ width: null });
          }
          delete label2.specificTextOverflow;
          tick.rotation = attr2.rotation;
        }
      }, this);
      this.tickRotCorr = renderer.rotCorr(labelMetrics.b, this.labelRotation || 0, this.side !== 0);
    };
    Axis2.prototype.hasData = function() {
      return this.series.some(function(s) {
        return s.hasData();
      }) || this.options.showEmpty && defined$R(this.min) && defined$R(this.max);
    };
    Axis2.prototype.addTitle = function(display) {
      var axis = this, renderer = axis.chart.renderer, horiz = axis.horiz, opposite = axis.opposite, options = axis.options, axisTitleOptions = options.title, styledMode = axis.chart.styledMode;
      var textAlign;
      if (!axis.axisTitle) {
        textAlign = axisTitleOptions.textAlign;
        if (!textAlign) {
          textAlign = (horiz ? {
            low: "left",
            middle: "center",
            high: "right"
          } : {
            low: opposite ? "right" : "left",
            middle: "center",
            high: opposite ? "left" : "right"
          })[axisTitleOptions.align];
        }
        axis.axisTitle = renderer.text(axisTitleOptions.text || "", 0, 0, axisTitleOptions.useHTML).attr({
          zIndex: 7,
          rotation: axisTitleOptions.rotation,
          align: textAlign
        }).addClass("highcharts-axis-title");
        if (!styledMode) {
          axis.axisTitle.css(merge$1o(axisTitleOptions.style));
        }
        axis.axisTitle.add(axis.axisGroup);
        axis.axisTitle.isNew = true;
      }
      if (!styledMode && !axisTitleOptions.style.width && !axis.isRadial) {
        axis.axisTitle.css({
          width: axis.len + "px"
        });
      }
      axis.axisTitle[display ? "show" : "hide"](display);
    };
    Axis2.prototype.generateTick = function(pos) {
      var axis = this, ticks = axis.ticks;
      if (!ticks[pos]) {
        ticks[pos] = new Tick(axis, pos);
      } else {
        ticks[pos].addLabel();
      }
    };
    Axis2.prototype.getOffset = function() {
      var _this = this;
      var axis = this, chart = axis.chart, renderer = chart.renderer, options = axis.options, tickPositions = axis.tickPositions, ticks = axis.ticks, horiz = axis.horiz, side = axis.side, invertedSide = chart.inverted && !axis.isZAxis ? [1, 0, 3, 2][side] : side, hasData = axis.hasData(), axisTitleOptions = options.title, labelOptions = options.labels, axisOffset = chart.axisOffset, clipOffset = chart.clipOffset, directionFactor = [-1, 1, 1, -1][side], className = options.className, axisParent = axis.axisParent;
      var showAxis, titleOffset = 0, titleOffsetOption, titleMargin = 0, labelOffset = 0, labelOffsetPadded, lineHeightCorrection;
      axis.showAxis = showAxis = hasData || options.showEmpty;
      axis.staggerLines = axis.horiz && labelOptions.staggerLines || void 0;
      if (!axis.axisGroup) {
        var createGroup = function(name, suffix, zIndex) {
          return renderer.g(name).attr({ zIndex }).addClass("highcharts-" + _this.coll.toLowerCase() + suffix + " " + (_this.isRadial ? "highcharts-radial-axis" + suffix + " " : "") + (className || "")).add(axisParent);
        };
        axis.gridGroup = createGroup("grid", "-grid", options.gridZIndex);
        axis.axisGroup = createGroup("axis", "", options.zIndex);
        axis.labelGroup = createGroup("axis-labels", "-labels", labelOptions.zIndex);
      }
      if (hasData || axis.isLinked) {
        tickPositions.forEach(function(pos) {
          axis.generateTick(pos);
        });
        axis.renderUnsquish();
        axis.reserveSpaceDefault = side === 0 || side === 2 || { 1: "left", 3: "right" }[side] === axis.labelAlign;
        if (pick$1x(labelOptions.reserveSpace, axis.labelAlign === "center" ? true : null, axis.reserveSpaceDefault)) {
          tickPositions.forEach(function(pos) {
            labelOffset = Math.max(ticks[pos].getLabelSize(), labelOffset);
          });
        }
        if (axis.staggerLines) {
          labelOffset *= axis.staggerLines;
        }
        axis.labelOffset = labelOffset * (axis.opposite ? -1 : 1);
      } else {
        objectEach$u(ticks, function(tick, n2) {
          tick.destroy();
          delete ticks[n2];
        });
      }
      if (axisTitleOptions && axisTitleOptions.text && axisTitleOptions.enabled !== false) {
        axis.addTitle(showAxis);
        if (showAxis && axisTitleOptions.reserveSpace !== false) {
          axis.titleOffset = titleOffset = axis.axisTitle.getBBox()[horiz ? "height" : "width"];
          titleOffsetOption = axisTitleOptions.offset;
          titleMargin = defined$R(titleOffsetOption) ? 0 : pick$1x(axisTitleOptions.margin, horiz ? 5 : 10);
        }
      }
      axis.renderLine();
      axis.offset = directionFactor * pick$1x(options.offset, axisOffset[side] ? axisOffset[side] + (options.margin || 0) : 0);
      axis.tickRotCorr = axis.tickRotCorr || { x: 0, y: 0 };
      if (side === 0) {
        lineHeightCorrection = -axis.labelMetrics().h;
      } else if (side === 2) {
        lineHeightCorrection = axis.tickRotCorr.y;
      } else {
        lineHeightCorrection = 0;
      }
      labelOffsetPadded = Math.abs(labelOffset) + titleMargin;
      if (labelOffset) {
        labelOffsetPadded -= lineHeightCorrection;
        labelOffsetPadded += directionFactor * (horiz ? pick$1x(labelOptions.y, axis.tickRotCorr.y + directionFactor * 8) : labelOptions.x);
      }
      axis.axisTitleMargin = pick$1x(titleOffsetOption, labelOffsetPadded);
      if (axis.getMaxLabelDimensions) {
        axis.maxLabelDimensions = axis.getMaxLabelDimensions(ticks, tickPositions);
      }
      var tickSize = this.tickSize("tick");
      axisOffset[side] = Math.max(
        axisOffset[side],
        (axis.axisTitleMargin || 0) + titleOffset + directionFactor * axis.offset,
        labelOffsetPadded,
        // #3027
        tickPositions && tickPositions.length && tickSize ? tickSize[0] + directionFactor * axis.offset : 0
        // #4866
      );
      var clip = options.offset ? 0 : (
        // #4308, #4371:
        Math.floor(axis.axisLine.strokeWidth() / 2) * 2
      );
      clipOffset[invertedSide] = Math.max(clipOffset[invertedSide], clip);
      fireEvent$z(this, "afterGetOffset");
    };
    Axis2.prototype.getLinePath = function(lineWidth) {
      var chart = this.chart, opposite = this.opposite, offset2 = this.offset, horiz = this.horiz, lineLeft = this.left + (opposite ? this.width : 0) + offset2, lineTop = chart.chartHeight - this.bottom - (opposite ? this.height : 0) + offset2;
      if (opposite) {
        lineWidth *= -1;
      }
      return chart.renderer.crispLine([
        [
          "M",
          horiz ? this.left : lineLeft,
          horiz ? lineTop : this.top
        ],
        [
          "L",
          horiz ? chart.chartWidth - this.right : lineLeft,
          horiz ? lineTop : chart.chartHeight - this.bottom
        ]
      ], lineWidth);
    };
    Axis2.prototype.renderLine = function() {
      if (!this.axisLine) {
        this.axisLine = this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup);
        if (!this.chart.styledMode) {
          this.axisLine.attr({
            stroke: this.options.lineColor,
            "stroke-width": this.options.lineWidth,
            zIndex: 7
          });
        }
      }
    };
    Axis2.prototype.getTitlePosition = function() {
      var horiz = this.horiz, axisLeft = this.left, axisTop = this.top, axisLength = this.len, axisTitleOptions = this.options.title, margin = horiz ? axisLeft : axisTop, opposite = this.opposite, offset2 = this.offset, xOption = axisTitleOptions.x, yOption = axisTitleOptions.y, axisTitle = this.axisTitle, fontMetrics = this.chart.renderer.fontMetrics(axisTitleOptions.style.fontSize, axisTitle), textHeightOvershoot = Math.max(axisTitle.getBBox(null, 0).height - fontMetrics.h - 1, 0), alongAxis = {
        low: margin + (horiz ? 0 : axisLength),
        middle: margin + axisLength / 2,
        high: margin + (horiz ? axisLength : 0)
      }[axisTitleOptions.align], offAxis = (horiz ? axisTop + this.height : axisLeft) + (horiz ? 1 : -1) * // horizontal axis reverses the margin
      (opposite ? -1 : 1) * // so does opposite axes
      this.axisTitleMargin + [
        -textHeightOvershoot,
        textHeightOvershoot,
        fontMetrics.f,
        -textHeightOvershoot
        // left
      ][this.side], titlePosition = {
        x: horiz ? alongAxis + xOption : offAxis + (opposite ? this.width : 0) + offset2 + xOption,
        y: horiz ? offAxis + yOption - (opposite ? this.height : 0) + offset2 : alongAxis + yOption
      };
      fireEvent$z(this, "afterGetTitlePosition", { titlePosition });
      return titlePosition;
    };
    Axis2.prototype.renderMinorTick = function(pos, slideIn) {
      var axis = this;
      var minorTicks = axis.minorTicks;
      if (!minorTicks[pos]) {
        minorTicks[pos] = new Tick(axis, pos, "minor");
      }
      if (slideIn && minorTicks[pos].isNew) {
        minorTicks[pos].render(null, true);
      }
      minorTicks[pos].render(null, false, 1);
    };
    Axis2.prototype.renderTick = function(pos, i2, slideIn) {
      var axis = this, isLinked = axis.isLinked, ticks = axis.ticks;
      if (!isLinked || pos >= axis.min && pos <= axis.max || axis.grid && axis.grid.isColumn) {
        if (!ticks[pos]) {
          ticks[pos] = new Tick(axis, pos);
        }
        if (slideIn && ticks[pos].isNew) {
          ticks[pos].render(i2, true, -1);
        }
        ticks[pos].render(i2);
      }
    };
    Axis2.prototype.render = function() {
      var axis = this, chart = axis.chart, log = axis.logarithmic, renderer = chart.renderer, options = axis.options, isLinked = axis.isLinked, tickPositions = axis.tickPositions, axisTitle = axis.axisTitle, ticks = axis.ticks, minorTicks = axis.minorTicks, alternateBands = axis.alternateBands, stackLabelOptions = options.stackLabels, alternateGridColor = options.alternateGridColor, tickmarkOffset = axis.tickmarkOffset, axisLine = axis.axisLine, showAxis = axis.showAxis, animation = animObject$b(renderer.globalAnimation);
      var from, to;
      axis.labelEdge.length = 0;
      axis.overlap = false;
      [ticks, minorTicks, alternateBands].forEach(function(coll) {
        objectEach$u(coll, function(tick) {
          tick.isActive = false;
        });
      });
      if (axis.hasData() || isLinked) {
        var slideInTicks_1 = axis.chart.hasRendered && axis.old && isNumber$N(axis.old.min);
        if (axis.minorTickInterval && !axis.categories) {
          axis.getMinorTickPositions().forEach(function(pos) {
            axis.renderMinorTick(pos, slideInTicks_1);
          });
        }
        if (tickPositions.length) {
          tickPositions.forEach(function(pos, i2) {
            axis.renderTick(pos, i2, slideInTicks_1);
          });
          if (tickmarkOffset && (axis.min === 0 || axis.single)) {
            if (!ticks[-1]) {
              ticks[-1] = new Tick(axis, -1, null, true);
            }
            ticks[-1].render(-1);
          }
        }
        if (alternateGridColor) {
          tickPositions.forEach(function(pos, i2) {
            to = typeof tickPositions[i2 + 1] !== "undefined" ? tickPositions[i2 + 1] + tickmarkOffset : axis.max - tickmarkOffset;
            if (i2 % 2 === 0 && pos < axis.max && to <= axis.max + (chart.polar ? -tickmarkOffset : tickmarkOffset)) {
              if (!alternateBands[pos]) {
                alternateBands[pos] = new H.PlotLineOrBand(axis);
              }
              from = pos + tickmarkOffset;
              alternateBands[pos].options = {
                from: log ? log.lin2log(from) : from,
                to: log ? log.lin2log(to) : to,
                color: alternateGridColor,
                className: "highcharts-alternate-grid"
              };
              alternateBands[pos].render();
              alternateBands[pos].isActive = true;
            }
          });
        }
        if (!axis._addedPlotLB) {
          axis._addedPlotLB = true;
          (options.plotLines || []).concat(options.plotBands || []).forEach(function(plotLineOptions) {
            axis.addPlotBandOrLine(plotLineOptions);
          });
        }
      }
      [ticks, minorTicks, alternateBands].forEach(function(coll) {
        var forDestruction = [], delay = animation.duration, destroyInactiveItems = function() {
          var i2 = forDestruction.length;
          while (i2--) {
            if (coll[forDestruction[i2]] && !coll[forDestruction[i2]].isActive) {
              coll[forDestruction[i2]].destroy();
              delete coll[forDestruction[i2]];
            }
          }
        };
        objectEach$u(coll, function(tick, pos) {
          if (!tick.isActive) {
            tick.render(pos, false, 0);
            tick.isActive = false;
            forDestruction.push(pos);
          }
        });
        syncTimeout$7(destroyInactiveItems, coll === alternateBands || !chart.hasRendered || !delay ? 0 : delay);
      });
      if (axisLine) {
        axisLine[axisLine.isPlaced ? "animate" : "attr"]({
          d: this.getLinePath(axisLine.strokeWidth())
        });
        axisLine.isPlaced = true;
        axisLine[showAxis ? "show" : "hide"](showAxis);
      }
      if (axisTitle && showAxis) {
        var titleXy = axis.getTitlePosition();
        if (isNumber$N(titleXy.y)) {
          axisTitle[axisTitle.isNew ? "attr" : "animate"](titleXy);
          axisTitle.isNew = false;
        } else {
          axisTitle.attr("y", -9999);
          axisTitle.isNew = true;
        }
      }
      if (stackLabelOptions && stackLabelOptions.enabled && axis.stacking) {
        axis.stacking.renderStackTotals();
      }
      axis.old = {
        len: axis.len,
        max: axis.max,
        min: axis.min,
        transA: axis.transA,
        userMax: axis.userMax,
        userMin: axis.userMin
      };
      axis.isDirty = false;
      fireEvent$z(this, "afterRender");
    };
    Axis2.prototype.redraw = function() {
      if (this.visible) {
        this.render();
        this.plotLinesAndBands.forEach(function(plotLine) {
          plotLine.render();
        });
      }
      this.series.forEach(function(series) {
        series.isDirty = true;
      });
    };
    Axis2.prototype.getKeepProps = function() {
      return this.keepProps || Axis2.keepProps;
    };
    Axis2.prototype.destroy = function(keepEvents) {
      var axis = this, plotLinesAndBands = axis.plotLinesAndBands, eventOptions = this.eventOptions;
      fireEvent$z(this, "destroy", { keepEvents });
      if (!keepEvents) {
        removeEvent$9(axis);
      }
      [axis.ticks, axis.minorTicks, axis.alternateBands].forEach(function(coll) {
        destroyObjectProperties$7(coll);
      });
      if (plotLinesAndBands) {
        var i2 = plotLinesAndBands.length;
        while (i2--) {
          plotLinesAndBands[i2].destroy();
        }
      }
      [
        "axisLine",
        "axisTitle",
        "axisGroup",
        "gridGroup",
        "labelGroup",
        "cross",
        "scrollbar"
      ].forEach(function(prop) {
        if (axis[prop]) {
          axis[prop] = axis[prop].destroy();
        }
      });
      for (var plotGroup in axis.plotLinesAndBandsGroups) {
        axis.plotLinesAndBandsGroups[plotGroup] = axis.plotLinesAndBandsGroups[plotGroup].destroy();
      }
      objectEach$u(axis, function(val, key2) {
        if (axis.getKeepProps().indexOf(key2) === -1) {
          delete axis[key2];
        }
      });
      this.eventOptions = eventOptions;
    };
    Axis2.prototype.drawCrosshair = function(e, point) {
      var options = this.crosshair, snap2 = pick$1x(options && options.snap, true), chart = this.chart;
      var path, pos, categorized, graphic = this.cross, crossOptions;
      fireEvent$z(this, "drawCrosshair", { e, point });
      if (!e) {
        e = this.cross && this.cross.e;
      }
      if (
        // Disabled in options
        !options || // Snap
        (defined$R(point) || !snap2) === false
      ) {
        this.hideCrosshair();
      } else {
        if (!snap2) {
          pos = e && (this.horiz ? e.chartX - this.pos : this.len - e.chartY + this.pos);
        } else if (defined$R(point)) {
          pos = pick$1x(this.coll !== "colorAxis" ? point.crosshairPos : (
            // 3D axis extension
            null
          ), this.isXAxis ? point.plotX : this.len - point.plotY);
        }
        if (defined$R(pos)) {
          crossOptions = {
            // value, only used on radial
            value: point && (this.isXAxis ? point.x : pick$1x(point.stackY, point