/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.details;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.SignalPropertySupport;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.details.DetailsVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@Tag(value="vaadin-details")
@NpmPackage(value="@vaadin/details", version="25.1.0-beta1")
@JsModule(value="@vaadin/details/src/vaadin-details.js")
public class Details
extends Component
implements HasComponents,
HasSize,
HasThemeVariant<DetailsVariant>,
HasTooltip {
    private Component summary;
    private final Component summaryContainer;
    private final Div contentContainer;
    private final SignalPropertySupport<String> summaryTextSupport = SignalPropertySupport.create((Component)this, this::updateSummaryText);

    public Details() {
        this.contentContainer = new Div();
        this.getElement().appendChild(new Element[]{this.contentContainer.getElement()});
        this.summaryContainer = this.createSummaryContainer();
        SlotUtils.addToSlot((HasElement)this, (String)"summary", (Component[])new Component[]{this.summaryContainer});
        if (this.getElement().getPropertyRaw("opened") == null) {
            this.doSetOpened(false);
        }
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent(this, event.isUserOriginated())));
    }

    public Details(String summary) {
        this();
        this.updateSummaryText(summary);
    }

    public Details(Component summary) {
        this();
        this.updateSummary(summary);
    }

    public Details(Signal<String> summaryTextSignal) {
        this();
        this.summaryTextSupport.bind(summaryTextSignal);
    }

    public Details(String summary, Component content) {
        this();
        this.updateSummaryText(summary);
        this.contentContainer.add(new Component[]{content});
    }

    public Details(Component summary, Component content) {
        this();
        this.updateSummary(summary);
        this.contentContainer.add(new Component[]{content});
    }

    public Details(Signal<String> summaryTextSignal, Component content) {
        this();
        this.summaryTextSupport.bind(summaryTextSignal);
        this.contentContainer.add(new Component[]{content});
    }

    public Details(String summary, Component ... components) {
        this(summary);
        this.contentContainer.add(components);
    }

    public Details(Component summary, Component ... components) {
        this(summary);
        this.contentContainer.add(components);
    }

    public Details(Signal<String> summaryTextSignal, Component ... components) {
        this();
        this.summaryTextSupport.bind(summaryTextSignal);
        this.contentContainer.add(components);
    }

    protected Component createSummaryContainer() {
        return new DetailsSummary();
    }

    public void setSummary(Component summary) {
        this.updateSummary(summary);
    }

    public Component getSummary() {
        return this.summary;
    }

    public void setSummaryText(String summary) {
        this.summaryTextSupport.set((Object)summary);
    }

    public String getSummaryText() {
        return this.summary == null ? "" : this.summary.getElement().getText();
    }

    private void updateSummary(Component summary) {
        this.summaryContainer.getElement().removeAllChildren();
        if (summary == null) {
            return;
        }
        this.summary = summary;
        this.summaryContainer.getElement().appendChild(new Element[]{summary.getElement()});
    }

    private void updateSummaryText(String newText) {
        if (this.summary == null || !(this.summary instanceof Span)) {
            this.updateSummary((Component)new Span(newText));
        } else {
            this.summary.getElement().setText(newText);
        }
    }

    public void bindSummaryText(Signal<String> signal) {
        this.summaryTextSupport.bind(signal);
    }

    SignalPropertySupport<String> getSummaryTextSupport() {
        return this.summaryTextSupport;
    }

    public void add(Collection<Component> components) {
        this.contentContainer.add(components);
    }

    public void add(String text) {
        this.contentContainer.add(text);
    }

    public void remove(Collection<Component> components) {
        this.contentContainer.remove(components);
    }

    public void removeAll() {
        this.contentContainer.removeAll();
    }

    public void addComponentAtIndex(int index, Component component) {
        this.contentContainer.addComponentAtIndex(index, component);
    }

    public <T, S extends Signal<T>> void bindChildren(Signal<List<S>> list, SerializableFunction<S, Component> childFactory) {
        Objects.requireNonNull(list, "ListSignal cannot be null");
        Objects.requireNonNull(childFactory, "Child element factory cannot be null");
        this.contentContainer.bindChildren(list, childFactory);
    }

    public Stream<Component> getContent() {
        return this.contentContainer.getChildren();
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        this.doSetOpened(opened);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    private void doSetOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    @Tag(value="vaadin-details-summary")
    static class DetailsSummary
    extends Component {
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<Details> {
        private final boolean opened;

        public OpenedChangeEvent(Details source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

