/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datetimepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerDatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerTimePicker;
import com.vaadin.flow.component.datetimepicker.FieldValidationUtil;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.timepicker.StepsUtil;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;

@Tag(value="vaadin-date-time-picker")
@NpmPackage(value="@vaadin/vaadin-date-time-picker", version="2.1.0")
@JsModule(value="@vaadin/vaadin-date-time-picker/src/vaadin-date-time-picker.js")
public class DateTimePicker
extends AbstractSinglePropertyField<DateTimePicker, LocalDateTime>
implements HasStyle,
HasSize,
HasTheme,
HasValidation,
Focusable<DateTimePicker>,
HasHelper,
HasLabel,
HasValidator<LocalDateTime>,
HasClientValidation {
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private final DateTimePickerDatePicker datePicker = new DateTimePickerDatePicker();
    private final DateTimePickerTimePicker timePicker = new DateTimePickerTimePicker();
    private DatePicker.DatePickerI18n i18n;
    private Locale locale;
    private static final SerializableFunction<String, LocalDateTime> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDateTime.parse(s);
    private static final SerializableFunction<LocalDateTime, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.truncatedTo(ChronoUnit.MILLIS).toString();
    private LocalDateTime max;
    private LocalDateTime min;
    private boolean required;

    public DateTimePicker() {
        this((LocalDateTime)null);
    }

    public DateTimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime) {
        this(initialDateTime);
        this.setLabel(label);
    }

    public DateTimePicker(LocalDateTime initialDateTime) {
        super("value", null, String.class, PARSER, FORMATTER);
        if (initialDateTime != null) {
            initialDateTime = this.sanitizeValue(initialDateTime);
            this.setPresentationValue(initialDateTime);
            this.synchronizeChildComponentValues(initialDateTime);
        }
        this.addToSlot((Component)this.datePicker, "date-picker");
        this.addToSlot((Component)this.timePicker, "time-picker");
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        if (this.isEnforcedFieldValidationEnabled()) {
            this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
        }
    }

    public DateTimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, Locale locale) {
        this(initialDateTime);
        this.setLocale(locale);
    }

    public void setValue(LocalDateTime value) {
        boolean isValueRemainedEmpty;
        LocalDateTime oldValue = (LocalDateTime)this.getValue();
        value = this.sanitizeValue(value);
        super.setValue((Object)value);
        boolean isInputValuePresent = this.timePicker.isInputValuePresent() || this.datePicker.isInputValuePresent();
        boolean bl = isValueRemainedEmpty = Objects.equals(oldValue, this.getEmptyValue()) && Objects.equals(value, this.getEmptyValue());
        if (isValueRemainedEmpty && isInputValuePresent) {
            this.synchronizeChildComponentValues(value);
            this.fireEvent((ComponentEvent)new HasClientValidation.ClientValidatedEvent((Component)this, false));
        } else {
            this.synchronizeChildComponentValues(value);
        }
    }

    private LocalDateTime sanitizeValue(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return value.truncatedTo(ChronoUnit.MILLIS);
    }

    private void synchronizeChildComponentValues(LocalDateTime value) {
        if (value != null) {
            this.datePicker.passThroughPresentationValue(value.toLocalDate());
            this.timePicker.passThroughPresentationValue(value.toLocalTime());
        } else {
            this.datePicker.passThroughPresentationValue(null);
            this.timePicker.passThroughPresentationValue(null);
        }
    }

    private void addToSlot(Component component, String slot) {
        Objects.requireNonNull(component, "Component to add cannot be null");
        component.getElement().setAttribute("slot", slot);
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.datePicker.setReadOnly(readOnly);
        this.timePicker.setReadOnly(readOnly);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setDatePlaceholder(String placeholder) {
        this.datePicker.setPlaceholder(placeholder);
    }

    public String getDatePlaceholder() {
        return this.datePicker.getPlaceholder();
    }

    public void setTimePlaceholder(String placeholder) {
        this.timePicker.setPlaceholder(placeholder);
    }

    public String getTimePlaceholder() {
        return this.timePicker.getPlaceholder();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        this.getElement().setProperty("step", StepsUtil.convertDurationToStepsValue((Duration)step));
        this.timePicker.setStep(step);
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return StepsUtil.DEFAULT_WEB_COMPONENT_STEP;
        }
        double stepsValue = this.getElement().getProperty("step", 0.0);
        return StepsUtil.convertStepsValueToDuration((double)stepsValue);
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.datePicker.setWeekNumbersVisible(weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.datePicker.isWeekNumbersVisible();
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.datePicker.setLocale(locale);
        this.timePicker.setLocale(locale);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    private void synchronizeTheme() {
        String theme = this.getThemeName();
        theme = theme != null ? theme : "";
        this.datePicker.getElement().setAttribute("theme", theme);
        this.timePicker.getElement().setAttribute("theme", theme);
    }

    public void addThemeName(String themeName) {
        super.addThemeName(themeName);
        this.synchronizeTheme();
    }

    public boolean removeThemeName(String themeName) {
        boolean result = super.removeThemeName(themeName);
        this.synchronizeTheme();
        return result;
    }

    public void setThemeName(String themeName) {
        super.setThemeName(themeName);
        this.synchronizeTheme();
    }

    public void setThemeName(String themeName, boolean set) {
        super.setThemeName(themeName, set);
        this.synchronizeTheme();
    }

    public void addThemeNames(String ... themeNames) {
        super.addThemeNames(themeNames);
        this.synchronizeTheme();
    }

    public void removeThemeNames(String ... themeNames) {
        super.removeThemeNames(themeNames);
        this.synchronizeTheme();
    }

    public void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    public String getErrorMessage() {
        return this.getElement().getProperty("errorMessage");
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    public boolean isInvalid() {
        return this.getElement().getProperty("invalid", false);
    }

    public Validator<LocalDateTime> getDefaultValidator() {
        if (this.isEnforcedFieldValidationEnabled()) {
            return (Validator & Serializable)(value, context) -> this.checkValidity((LocalDateTime)value);
        }
        return Validator.alwaysPass();
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalDateTime> listener) {
        if (this.isEnforcedFieldValidationEnabled()) {
            return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, event.isValid().booleanValue())));
        }
        return null;
    }

    private ValidationResult checkValidity(LocalDateTime value) {
        ValidationResult greaterThanMax;
        if (this.isEnforcedFieldValidationEnabled()) {
            boolean hasNonParsableTimePickerValue;
            boolean hasNonParsableDatePickerValue = this.datePicker.getValue() == this.datePicker.getEmptyValue() && this.datePicker.isInputValuePresent();
            boolean bl = hasNonParsableTimePickerValue = this.timePicker.getValue() == this.timePicker.getEmptyValue() && this.timePicker.isInputValuePresent();
            if (hasNonParsableDatePickerValue || hasNonParsableTimePickerValue) {
                return ValidationResult.error((String)"");
            }
        }
        if ((greaterThanMax = DateTimePicker.checkGreaterThanMax(value, this.max)).isError()) {
            return greaterThanMax;
        }
        ValidationResult smallerThanMin = DateTimePicker.checkSmallerThanMin(value, this.min);
        if (smallerThanMin.isError()) {
            return smallerThanMin;
        }
        return ValidationResult.ok();
    }

    private static <V extends Comparable<V>> ValidationResult checkGreaterThanMax(V value, V maxValue) {
        boolean isGreaterThanMax;
        boolean bl = isGreaterThanMax = value != null && maxValue != null && value.compareTo(maxValue) > 0;
        if (isGreaterThanMax) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    private static <V extends Comparable<V>> ValidationResult checkSmallerThanMin(V value, V minValue) {
        boolean isSmallerThanMin;
        boolean bl = isSmallerThanMin = value != null && minValue != null && value.compareTo(minValue) < 0;
        if (isSmallerThanMin) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    private static <V> ValidationResult checkRequired(boolean required, V value, V emptyValue) {
        boolean isRequiredButEmpty;
        boolean bl = isRequiredButEmpty = required && Objects.equals(emptyValue, value);
        if (isRequiredButEmpty) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    private boolean isInvalid(LocalDateTime value) {
        ValidationResult requiredValidation = DateTimePicker.checkRequired(this.required, value, this.getEmptyValue());
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    protected void validate() {
        this.setInvalid(this.isInvalid((LocalDateTime)this.getValue()));
    }

    public void setMin(LocalDateTime min) {
        this.getElement().setProperty("min", (String)FORMATTER.apply((Object)min));
        this.min = min;
    }

    public LocalDateTime getMin() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("min"));
    }

    public void setMax(LocalDateTime max) {
        this.getElement().setProperty("max", (String)FORMATTER.apply((Object)max));
        this.max = max;
    }

    public LocalDateTime getMax() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("max"));
    }

    public DatePicker.DatePickerI18n getDatePickerI18n() {
        return this.i18n;
    }

    public void setDatePickerI18n(DatePicker.DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.i18n = i18n;
        this.datePicker.setI18n(i18n);
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.required = requiredIndicatorVisible;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
        this.datePicker.setAutoOpen(autoOpen);
        this.timePicker.setAutoOpen(autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.isEnforcedFieldValidationEnabled()) {
            ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
        } else {
            FieldValidationUtil.disableClientValidation(this);
        }
    }

    protected boolean isEnforcedFieldValidationEnabled() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return false;
        }
        DeploymentConfiguration configuration = session.getConfiguration();
        if (configuration == null) {
            return false;
        }
        return configuration.isEnforcedFieldValidationEnabled();
    }
}

