/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker.testbench;

import com.vaadin.flow.component.button.testbench.ButtonElement;
import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.Keys;

@Element(value="vaadin-date-picker")
public class DatePickerElement
extends TestBenchElement
implements HasLabel,
HasHelper {
    public void clear() {
        this.setDate(null);
    }

    public void setDate(LocalDate date) {
        if (date == null) {
            this.setValue("");
        } else {
            this.setValue(date.toString());
        }
    }

    public LocalDate getDate() {
        String value = this.getValue();
        if (value.isEmpty()) {
            return null;
        }
        return LocalDate.parse(value);
    }

    protected void setValue(String value) {
        this.setProperty("value", value);
    }

    protected String getValue() {
        return this.getPropertyString(new String[]{"value"});
    }

    public void setInputValue(String value) {
        this.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.SHIFT, Keys.HOME}), Keys.BACK_SPACE});
        this.sendKeys(new CharSequence[]{value, Keys.ENTER});
    }

    public String getInputValue() {
        return this.getPropertyString(new String[]{"_inputElementValue"});
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }

    public void open() {
        this.executeScript("arguments[0].open();", new Object[]{this});
    }

    public void close() {
        this.executeScript("arguments[0].close();", new Object[]{this});
    }

    public OverlayContentElement getOverlayContent() {
        return (OverlayContentElement)this.$("vaadin-date-picker-overlay").onPage().waitForFirst().$(TestBenchElement.class).id("content").$(OverlayContentElement.class).id("overlay-content");
    }

    public static class WeekdayElement
    extends TestBenchElement {
    }

    public static class MonthCalendarElement
    extends TestBenchElement {
        public String getHeaderText() {
            return this.$(TestBenchElement.class).attribute("part", "month-header").first().getText();
        }

        public List<WeekdayElement> getWeekdays() {
            return this.$(WeekdayElement.class).attribute("part", "weekday").all();
        }
    }

    public static class OverlayContentElement
    extends TestBenchElement {
        public List<MonthCalendarElement> getVisibleMonthCalendars() {
            return this.$("vaadin-month-calendar").all().stream().map(el -> (MonthCalendarElement)el.wrap(MonthCalendarElement.class)).collect(Collectors.toList());
        }

        public ButtonElement getTodayButton() {
            return (ButtonElement)this.$(ButtonElement.class).attribute("part", "today-button").first();
        }

        public ButtonElement getCancelButton() {
            return (ButtonElement)this.$(ButtonElement.class).attribute("part", "cancel-button").first();
        }
    }
}

