/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.DatePickerVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

@Tag(value="vaadin-date-picker")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/date-picker", version="25.0.0-alpha16"), @NpmPackage(value="date-fns", version="4.1.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/date-picker/src/vaadin-date-picker.js"), @JsModule(value="./datepickerConnector.js")})
public class DatePicker
extends AbstractSinglePropertyField<DatePicker, LocalDate>
implements Focusable<DatePicker>,
HasAllowedCharPattern,
HasAriaLabel,
HasAutoOpen,
HasClearButton,
InputField<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>, LocalDate>,
HasPrefix,
HasThemeVariant<DatePickerVariant>,
HasValidationProperties,
HasValidator<LocalDate>,
HasPlaceholder {
    private DatePickerI18n i18n;
    private static final SerializableFunction<String, LocalDate> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDate.parse(s);
    private static final SerializableFunction<LocalDate, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.toString();
    private Locale locale;
    private LocalDate max;
    private LocalDate min;
    private StateTree.ExecutionRegistration pendingI18nUpdate;
    private String unparsableValue;
    private SerializableFunction<String, Result<LocalDate>> fallbackParser;
    private String fallbackParserErrorMessage = null;
    private boolean isFallbackParserRunning = false;
    private final CopyOnWriteArrayList<ValidationStatusChangeListener<LocalDate>> validationStatusChangeListeners = new CopyOnWriteArrayList();
    private Validator<LocalDate> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean fromComponent;
        boolean bl = fromComponent = context == null;
        if (this.isInputUnparsable() && this.fallbackParserErrorMessage != null) {
            return ValidationResult.error((String)this.fallbackParserErrorMessage);
        }
        if (this.isInputUnparsable()) {
            return ValidationResult.error((String)this.getI18nErrorMessage(DatePickerI18n::getBadInputErrorMessage));
        }
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(DatePickerI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)((LocalDate)this.getEmptyValue()))).isError()) {
            return requiredResult;
        }
        ValidationResult maxResult = ValidationUtil.validateMaxConstraint((String)this.getI18nErrorMessage(DatePickerI18n::getMaxErrorMessage), (Comparable)value, (Comparable)this.max);
        if (maxResult.isError()) {
            return maxResult;
        }
        ValidationResult minResult = ValidationUtil.validateMinConstraint((String)this.getI18nErrorMessage(DatePickerI18n::getMinErrorMessage), (Comparable)value, (Comparable)this.min);
        if (minResult.isError()) {
            return minResult;
        }
        return ValidationResult.ok();
    };
    private ValidationController<DatePicker, LocalDate> validationController = new ValidationController((Component)this);

    public DatePicker() {
        this((LocalDate)null, true);
    }

    public DatePicker(LocalDate initialDate) {
        this(initialDate, false);
    }

    private DatePicker(LocalDate initialDate, boolean isInitialValueOptional) {
        super("value", null, String.class, PARSER, FORMATTER);
        this.getElement().setProperty("manualValidation", true);
        if (this.getElement().getProperty("value") == null || !isInitialValueOptional) {
            this.setPresentationValue(initialDate);
        }
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.getElement().addEventListener("unparsable-change", (DomEventListener & Serializable)event -> this.setModelValue((LocalDate)this.getEmptyValue(), true));
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent(this, event.isUserOriginated())));
        this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> this.fireEvent(new InvalidChangeEvent(this, event.isUserOriginated())));
    }

    public DatePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DatePicker(String label, LocalDate initialDate) {
        this(initialDate);
        this.setLabel(label);
    }

    public DatePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, Locale locale) {
        this(initialDate);
        this.setLocale(locale);
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    public void setMin(LocalDate min) {
        String minAsString = (String)FORMATTER.apply((Object)min);
        this.getElement().setProperty("min", minAsString == null ? "" : minAsString);
        this.min = min;
    }

    public LocalDate getMin() {
        return (LocalDate)PARSER.apply((Object)this.getElement().getProperty("min"));
    }

    public void setMax(LocalDate max) {
        String maxAsString = (String)FORMATTER.apply((Object)max);
        this.getElement().setProperty("max", maxAsString == null ? "" : maxAsString);
        this.max = max;
    }

    public LocalDate getMax() {
        return (LocalDate)PARSER.apply((Object)this.getElement().getProperty("max"));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.requestI18nUpdate();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.requestI18nUpdate();
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.datepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public DatePickerI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(DatePickerI18n i18n) {
        this.i18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.requestI18nUpdate();
    }

    private void requestI18nUpdate() {
        this.getUI().ifPresent(ui -> {
            if (this.pendingI18nUpdate != null) {
                this.pendingI18nUpdate.remove();
            }
            this.pendingI18nUpdate = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingI18nUpdate = null;
                this.executeI18nUpdate();
            });
        });
    }

    private void executeI18nUpdate() {
        JsonObject i18nObject = this.getI18nAsJsonObject();
        Locale appliedLocale = this.getLocale();
        Object languageTag = !appliedLocale.toLanguageTag().contains("lvariant") ? appliedLocale.toLanguageTag() : (appliedLocale.getCountry().isEmpty() ? appliedLocale.getLanguage() : appliedLocale.getLanguage() + "-" + appliedLocale.getCountry());
        this.getElement().callJsFunction("$connector.updateI18n", new Serializable[]{languageTag, i18nObject});
    }

    private JsonObject getI18nAsJsonObject() {
        if (this.i18n == null) {
            return null;
        }
        JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        if (this.i18n.getReferenceDate() != null) {
            i18nObject.put("referenceDate", this.i18n.getReferenceDate().format(DateTimeFormatter.ISO_DATE));
        }
        i18nObject.remove("badInputErrorMessage");
        i18nObject.remove("requiredErrorMessage");
        i18nObject.remove("minErrorMessage");
        i18nObject.remove("maxErrorMessage");
        this.removeNullValuesFromJsonObject(i18nObject);
        return i18nObject;
    }

    private void removeNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public Validator<LocalDate> getDefaultValidator() {
        return this.defaultValidator;
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalDate> listener) {
        return Registration.addAndRemove(this.validationStatusChangeListeners, listener);
    }

    private void fireValidationStatusChangeEvent() {
        ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid());
        this.validationStatusChangeListeners.forEach((Consumer<ValidationStatusChangeListener<LocalDate>>)((Consumer<ValidationStatusChangeListener>)listener -> listener.validationStatusChanged(event)));
    }

    @Deprecated(since="24.8")
    protected boolean isInputValuePresent() {
        return !this.getInputElementValue().isEmpty();
    }

    protected final boolean isInputUnparsable() {
        return this.unparsableValue != null;
    }

    @Synchronize(property="_inputElementValue", value={"change", "unparsable-change"})
    private String getInputElementValue() {
        return this.getElement().getProperty("_inputElementValue", "");
    }

    private void setInputElementValue(String value) {
        this.getElement().setProperty("_inputElementValue", value);
    }

    public void setFallbackParser(SerializableFunction<String, Result<LocalDate>> fallbackParser) {
        this.fallbackParser = fallbackParser;
        this.fallbackParserErrorMessage = null;
    }

    public SerializableFunction<String, Result<LocalDate>> getFallbackParser() {
        return this.fallbackParser;
    }

    private Result<LocalDate> runFallbackParser(String s) {
        Result result = null;
        try {
            result = (Result)this.fallbackParser.apply((Object)s);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DatePicker.class).error("Fallback parser threw an exception", (Throwable)e);
            result = Result.error((String)this.getI18nErrorMessage(DatePickerI18n::getBadInputErrorMessage));
        }
        return Objects.requireNonNull(result, "Result cannot be null");
    }

    public void setValue(LocalDate value) {
        LocalDate oldValue = (LocalDate)this.getValue();
        if (oldValue == null && value == null && this.isInputUnparsable()) {
            this.setModelValue((LocalDate)this.getEmptyValue(), false);
            return;
        }
        super.setValue((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setModelValue(LocalDate newModelValue, boolean fromClient) {
        boolean isModelValueRemainedEmpty;
        if (this.isFallbackParserRunning) {
            return;
        }
        LocalDate oldModelValue = (LocalDate)this.getValue();
        String oldUnparsableValue = this.unparsableValue;
        this.unparsableValue = fromClient && newModelValue == null && !this.getInputElementValue().isEmpty() ? this.getInputElementValue() : null;
        try {
            this.isFallbackParserRunning = true;
            if (this.fallbackParser != null && this.isInputUnparsable()) {
                Result<LocalDate> result = this.runFallbackParser(this.unparsableValue);
                if (result.isError()) {
                    this.fallbackParserErrorMessage = result.getMessage().orElse(null);
                } else {
                    this.unparsableValue = null;
                    this.fallbackParserErrorMessage = null;
                    newModelValue = (LocalDate)result.getOrThrow(IllegalStateException::new);
                    this.setPresentationValue(newModelValue);
                }
            }
        }
        finally {
            this.isFallbackParserRunning = false;
        }
        boolean bl = isModelValueRemainedEmpty = newModelValue == null && oldModelValue == null;
        if (fromClient && isModelValueRemainedEmpty) {
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        if (!fromClient && isModelValueRemainedEmpty && oldUnparsableValue != null) {
            this.setInputElementValue("");
            this.validate();
            this.fireValidationStatusChangeEvent();
            return;
        }
        super.setModelValue((Object)newModelValue, fromClient);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setInitialPosition(LocalDate initialPosition) {
        String initialPositionString = (String)FORMATTER.apply((Object)initialPosition);
        this.getElement().setProperty("initialPosition", initialPositionString == null ? "" : initialPositionString);
    }

    public LocalDate getInitialPosition() {
        return (LocalDate)PARSER.apply((Object)this.getElement().getProperty("initialPosition"));
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
    }

    public boolean isRequiredIndicatorVisible() {
        return super.isRequiredIndicatorVisible();
    }

    public void setRequired(boolean required) {
        this.setRequiredIndicatorVisible(required);
    }

    public boolean isRequired() {
        return this.isRequiredIndicatorVisible();
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.getElement().setProperty("showWeekNumbers", weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.getElement().getProperty("showWeekNumbers", false);
    }

    public void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    public void open() {
        this.setOpened(true);
    }

    protected void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setName(String name) {
        this.getElement().setProperty("name", name == null ? "" : name);
    }

    public String getName() {
        return this.getElement().getProperty("name");
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate((Object)((LocalDate)this.getValue()));
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    public Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent> listener) {
        return this.addListener(InvalidChangeEvent.class, listener);
    }

    private String getI18nErrorMessage(Function<DatePickerI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class DatePickerI18n
    implements Serializable {
        private List<String> monthNames;
        private List<String> weekdays;
        private List<String> weekdaysShort;
        private List<String> dateFormats;
        private int firstDayOfWeek;
        private String today;
        private String cancel;
        private LocalDate referenceDate;
        private String badInputErrorMessage;
        private String requiredErrorMessage;
        private String minErrorMessage;
        private String maxErrorMessage;

        public List<String> getMonthNames() {
            return this.monthNames;
        }

        public DatePickerI18n setMonthNames(List<String> monthNames) {
            this.monthNames = monthNames;
            return this;
        }

        public List<String> getWeekdays() {
            return this.weekdays;
        }

        public DatePickerI18n setWeekdays(List<String> weekdays) {
            if (weekdays != null && weekdays.size() != 7) {
                LoggerFactory.getLogger(this.getClass()).warn(String.format("setWeekdays parameter list should have exactly 7 elements. Instead got %d", weekdays.size()));
            }
            this.weekdays = weekdays;
            return this;
        }

        public List<String> getWeekdaysShort() {
            return this.weekdaysShort;
        }

        public DatePickerI18n setWeekdaysShort(List<String> weekdaysShort) {
            if (weekdaysShort != null && weekdaysShort.size() != 7) {
                LoggerFactory.getLogger(this.getClass()).warn(String.format("setWeekdaysShort parameter list should have exactly 7 elements. Instead got %d", weekdaysShort.size()));
            }
            this.weekdaysShort = weekdaysShort;
            return this;
        }

        public List<String> getDateFormats() {
            return this.dateFormats;
        }

        public DatePickerI18n setDateFormat(String dateFormat) {
            this.setDateFormats(dateFormat, new String[0]);
            return this;
        }

        public DatePickerI18n setDateFormats(String primaryFormat, String ... additionalParsingFormats) {
            Objects.requireNonNull(additionalParsingFormats, "Additional parsing formats must not be null");
            if (primaryFormat == null) {
                this.dateFormats = null;
            } else {
                this.dateFormats = new ArrayList<String>();
                this.dateFormats.add(primaryFormat);
                this.dateFormats.addAll(Stream.of(additionalParsingFormats).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            return this;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public DatePickerI18n setFirstDayOfWeek(int firstDayOfWeek) {
            if (firstDayOfWeek < 0 || firstDayOfWeek > 6) {
                throw new IllegalArgumentException("First day of the week needs to be in range of 0 to 6.");
            }
            this.firstDayOfWeek = firstDayOfWeek;
            return this;
        }

        public String getToday() {
            return this.today;
        }

        public DatePickerI18n setToday(String today) {
            this.today = today;
            return this;
        }

        public String getCancel() {
            return this.cancel;
        }

        public DatePickerI18n setCancel(String cancel) {
            this.cancel = cancel;
            return this;
        }

        public LocalDate getReferenceDate() {
            return this.referenceDate;
        }

        public DatePickerI18n setReferenceDate(LocalDate referenceDate) {
            this.referenceDate = referenceDate;
            return this;
        }

        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public DatePickerI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public DatePickerI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinErrorMessage() {
            return this.minErrorMessage;
        }

        public DatePickerI18n setMinErrorMessage(String errorMessage) {
            this.minErrorMessage = errorMessage;
            return this;
        }

        public String getMaxErrorMessage() {
            return this.maxErrorMessage;
        }

        public DatePickerI18n setMaxErrorMessage(String errorMessage) {
            this.maxErrorMessage = errorMessage;
            return this;
        }
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<DatePicker> {
        private final boolean opened;

        public OpenedChangeEvent(DatePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    public static class InvalidChangeEvent
    extends ComponentEvent<DatePicker> {
        private final boolean invalid;

        public InvalidChangeEvent(DatePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.invalid = source.isInvalid();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }
}

