/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.FieldValidationUtil;
import com.vaadin.flow.component.datepicker.GeneratedVaadinDatePicker;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsModule(value="./datepickerConnector.js")
@JavaScript(value="frontend://datepickerConnector.js")
@NpmPackage(value="date-fns", version="2.29.3")
public class DatePicker
extends GeneratedVaadinDatePicker<DatePicker, LocalDate>
implements HasSize,
HasValidation,
HasHelper,
HasLabel,
HasValidator<LocalDate>,
HasClientValidation {
    private static final String PROP_AUTO_OPEN_DISABLED = "autoOpenDisabled";
    private DatePickerI18n i18n;
    private static final SerializableFunction<String, LocalDate> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDate.parse(s);
    private static final SerializableFunction<LocalDate, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.toString();
    private Locale locale;
    private LocalDate max;
    private LocalDate min;
    private boolean required;
    private StateTree.ExecutionRegistration pendingI18nUpdate;

    public DatePicker() {
        this((LocalDate)null);
    }

    public DatePicker(LocalDate initialDate) {
        super(initialDate, null, String.class, PARSER, FORMATTER);
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        if (this.isEnforcedFieldValidationEnabled()) {
            this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
        }
    }

    public DatePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DatePicker(String label, LocalDate initialDate) {
        this(initialDate);
        this.setLabel(label);
    }

    public DatePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, Locale locale) {
        this(initialDate);
        this.setLocale(locale);
    }

    public void setMin(LocalDate min) {
        this.setMinAsString((String)FORMATTER.apply((Object)min));
        this.min = min;
    }

    public LocalDate getMin() {
        return (LocalDate)PARSER.apply((Object)this.getMinAsStringString());
    }

    public void setMax(LocalDate max) {
        this.setMaxAsString((String)FORMATTER.apply((Object)max));
        this.max = max;
    }

    public LocalDate getMax() {
        return (LocalDate)PARSER.apply((Object)this.getMaxAsStringString());
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.requestI18nUpdate();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.requestI18nUpdate();
        if (this.isEnforcedFieldValidationEnabled()) {
            ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
        } else {
            FieldValidationUtil.disableClientValidation(this);
        }
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("window.Vaadin.Flow.datepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public DatePickerI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.requestI18nUpdate();
    }

    private void requestI18nUpdate() {
        this.getUI().ifPresent(ui -> {
            if (this.pendingI18nUpdate != null) {
                this.pendingI18nUpdate.remove();
            }
            this.pendingI18nUpdate = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingI18nUpdate = null;
                this.executeI18nUpdate();
            });
        });
    }

    private void executeI18nUpdate() {
        JsonObject i18nObject = this.getI18nAsJsonObject();
        Locale appliedLocale = this.getLocale();
        String languageTag = !appliedLocale.toLanguageTag().contains("lvariant") ? appliedLocale.toLanguageTag() : (appliedLocale.getCountry().isEmpty() ? appliedLocale.getLanguage() : appliedLocale.getLanguage() + "-" + appliedLocale.getCountry());
        this.getElement().callJsFunction("$connector.updateI18n", new Serializable[]{languageTag, i18nObject});
    }

    private JsonObject getI18nAsJsonObject() {
        if (this.i18n == null) {
            return null;
        }
        JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        if (this.i18n.getReferenceDate() != null) {
            i18nObject.put("referenceDate", this.i18n.getReferenceDate().format(DateTimeFormatter.ISO_DATE));
        }
        this.removeNullValuesFromJsonObject(i18nObject);
        return i18nObject;
    }

    private void removeNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            super.setErrorMessage("");
        } else {
            super.setErrorMessage(errorMessage);
        }
    }

    public String getErrorMessage() {
        return this.getErrorMessageString();
    }

    public Validator<LocalDate> getDefaultValidator() {
        if (this.isEnforcedFieldValidationEnabled()) {
            return (Validator & Serializable)(value, context) -> this.checkValidity((LocalDate)value);
        }
        return Validator.alwaysPass();
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalDate> listener) {
        if (this.isEnforcedFieldValidationEnabled()) {
            return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
        }
        return null;
    }

    @Override
    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.isInvalidBoolean();
    }

    private ValidationResult checkValidity(LocalDate value) {
        ValidationResult greaterThanMax;
        if (this.isEnforcedFieldValidationEnabled()) {
            boolean hasNonParsableValue;
            boolean bl = hasNonParsableValue = value == this.getEmptyValue() && this.isInputValuePresent();
            if (hasNonParsableValue) {
                return ValidationResult.error((String)"");
            }
        }
        if ((greaterThanMax = DatePicker.checkGreaterThanMax(value, this.max)).isError()) {
            return greaterThanMax;
        }
        ValidationResult smallerThanMin = DatePicker.checkSmallerThanMin(value, this.min);
        if (smallerThanMin.isError()) {
            return smallerThanMin;
        }
        return ValidationResult.ok();
    }

    private static <V extends Comparable<V>> ValidationResult checkGreaterThanMax(V value, V maxValue) {
        boolean isGreaterThanMax;
        boolean bl = isGreaterThanMax = value != null && maxValue != null && value.compareTo(maxValue) > 0;
        if (isGreaterThanMax) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    private static <V extends Comparable<V>> ValidationResult checkSmallerThanMin(V value, V minValue) {
        boolean isSmallerThanMin;
        boolean bl = isSmallerThanMin = value != null && minValue != null && value.compareTo(minValue) < 0;
        if (isSmallerThanMin) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    private static <V> ValidationResult checkRequired(boolean required, V value, V emptyValue) {
        boolean isRequiredButEmpty;
        boolean bl = isRequiredButEmpty = required && Objects.equals(emptyValue, value);
        if (isRequiredButEmpty) {
            return ValidationResult.error((String)"");
        }
        return ValidationResult.ok();
    }

    private boolean isInvalid(LocalDate value) {
        ValidationResult requiredValidation = DatePicker.checkRequired(this.required, value, this.getEmptyValue());
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    private boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    public void setValue(LocalDate value) {
        LocalDate oldValue = (LocalDate)this.getValue();
        super.setValue((Object)value);
        if (Objects.equals(oldValue, this.getEmptyValue()) && Objects.equals(value, this.getEmptyValue()) && this.isInputValuePresent()) {
            this.getElement().executeJs("if (!this.value) this._inputElementValue = ''", new Serializable[0]);
            this.getElement().setProperty("_hasInputValue", false);
            this.fireEvent((ComponentEvent)new HasClientValidation.ClientValidatedEvent((Component)this, false));
        }
    }

    @Override
    public void setClearButtonVisible(boolean clearButtonVisible) {
        super.setClearButtonVisible(clearButtonVisible);
    }

    public boolean isClearButtonVisible() {
        return super.isClearButtonVisibleBoolean();
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
    }

    public String getLabel() {
        return this.getLabelString();
    }

    @Override
    public void setPlaceholder(String placeholder) {
        super.setPlaceholder(placeholder);
    }

    public String getPlaceholder() {
        return this.getPlaceholderString();
    }

    public void setInitialPosition(LocalDate initialPosition) {
        this.setInitialPosition((String)FORMATTER.apply((Object)initialPosition));
    }

    public LocalDate getInitialPosition() {
        return (LocalDate)PARSER.apply((Object)this.getInitialPositionString());
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
        this.required = required;
    }

    public boolean isRequired() {
        return this.isRequiredBoolean();
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        super.setShowWeekNumbers(weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.isShowWeekNumbersBoolean();
    }

    @Override
    public void setOpened(boolean opened) {
        super.setOpened(opened);
    }

    @Override
    public void open() {
        super.setOpened(true);
    }

    @Override
    protected void close() {
        super.setOpened(false);
    }

    public boolean isOpened() {
        return this.isOpenedBoolean();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public String getName() {
        return this.getNameString();
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty(PROP_AUTO_OPEN_DISABLED, !autoOpen);
    }

    public boolean isAutoOpen() {
        return !this.getElement().getProperty(PROP_AUTO_OPEN_DISABLED, false);
    }

    protected void validate() {
        this.setInvalid(this.isInvalid((LocalDate)this.getValue()));
    }

    @Override
    public Registration addOpenedChangeListener(ComponentEventListener<GeneratedVaadinDatePicker.OpenedChangeEvent<DatePicker>> listener) {
        return super.addOpenedChangeListener(listener);
    }

    @Override
    public Registration addInvalidChangeListener(ComponentEventListener<GeneratedVaadinDatePicker.InvalidChangeEvent<DatePicker>> listener) {
        return super.addInvalidChangeListener(listener);
    }

    protected boolean isEnforcedFieldValidationEnabled() {
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null) {
            return false;
        }
        DeploymentConfiguration configuration = session.getConfiguration();
        if (configuration == null) {
            return false;
        }
        return configuration.isEnforcedFieldValidationEnabled();
    }

    public static class DatePickerI18n
    implements Serializable {
        private List<String> monthNames;
        private List<String> weekdays;
        private List<String> weekdaysShort;
        private List<String> dateFormats;
        private int firstDayOfWeek;
        private String week;
        private String calendar;
        private String clear;
        private String today;
        private String cancel;
        private LocalDate referenceDate;

        public List<String> getMonthNames() {
            return this.monthNames;
        }

        public DatePickerI18n setMonthNames(List<String> monthNames) {
            this.monthNames = monthNames;
            return this;
        }

        public List<String> getWeekdays() {
            return this.weekdays;
        }

        public DatePickerI18n setWeekdays(List<String> weekdays) {
            this.weekdays = weekdays;
            return this;
        }

        public List<String> getWeekdaysShort() {
            return this.weekdaysShort;
        }

        public DatePickerI18n setWeekdaysShort(List<String> weekdaysShort) {
            this.weekdaysShort = weekdaysShort;
            return this;
        }

        public List<String> getDateFormats() {
            return this.dateFormats;
        }

        public DatePickerI18n setDateFormat(String dateFormat) {
            this.setDateFormats(dateFormat, new String[0]);
            return this;
        }

        public DatePickerI18n setDateFormats(String primaryFormat, String ... additionalParsingFormats) {
            Objects.requireNonNull(additionalParsingFormats, "Additional parsing formats must not be null");
            if (primaryFormat == null) {
                this.dateFormats = null;
            } else {
                this.dateFormats = new ArrayList<String>();
                this.dateFormats.add(primaryFormat);
                this.dateFormats.addAll(Stream.of(additionalParsingFormats).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            return this;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public DatePickerI18n setFirstDayOfWeek(int firstDayOfWeek) {
            if (firstDayOfWeek < 0 || firstDayOfWeek > 6) {
                throw new IllegalArgumentException("First day of the week needs to be in range of 0 to 6.");
            }
            this.firstDayOfWeek = firstDayOfWeek;
            return this;
        }

        public String getWeek() {
            return this.week;
        }

        public DatePickerI18n setWeek(String week) {
            this.week = week;
            return this;
        }

        public String getCalendar() {
            return this.calendar;
        }

        public DatePickerI18n setCalendar(String calendar) {
            this.calendar = calendar;
            return this;
        }

        public String getClear() {
            return this.clear;
        }

        public DatePickerI18n setClear(String clear) {
            this.clear = clear;
            return this;
        }

        public String getToday() {
            return this.today;
        }

        public DatePickerI18n setToday(String today) {
            this.today = today;
            return this;
        }

        public String getCancel() {
            return this.cancel;
        }

        public DatePickerI18n setCancel(String cancel) {
            this.cancel = cancel;
            return this;
        }

        public LocalDate getReferenceDate() {
            return this.referenceDate;
        }

        public DatePickerI18n setReferenceDate(LocalDate referenceDate) {
            this.referenceDate = referenceDate;
            return this;
        }
    }
}

